/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface InitializeRequest
 */
export interface InitializeRequest {
    /**
     * Specifies an array of PGP public keys used to encrypt the output unseal keys. Ordering is preserved. The keys must be base64-encoded from their original binary representation. The size of this array must be the same as `secret_shares`.
     * @type {Array<string>}
     * @memberof InitializeRequest
     */
    pgpKeys?: Array<string>;
    /**
     * Specifies an array of PGP public keys used to encrypt the output recovery keys. Ordering is preserved. The keys must be base64-encoded from their original binary representation. The size of this array must be the same as `recovery_shares`.
     * @type {Array<string>}
     * @memberof InitializeRequest
     */
    recoveryPgpKeys?: Array<string>;
    /**
     * Specifies the number of shares to split the recovery key into.
     * @type {number}
     * @memberof InitializeRequest
     */
    recoveryShares?: number;
    /**
     * Specifies the number of shares required to reconstruct the recovery key. This must be less than or equal to `recovery_shares`.
     * @type {number}
     * @memberof InitializeRequest
     */
    recoveryThreshold?: number;
    /**
     * Specifies a PGP public key used to encrypt the initial root token. The key must be base64-encoded from its original binary representation.
     * @type {string}
     * @memberof InitializeRequest
     */
    rootTokenPgpKey?: string;
    /**
     * Specifies the number of shares to split the unseal key into.
     * @type {number}
     * @memberof InitializeRequest
     */
    secretShares?: number;
    /**
     * Specifies the number of shares required to reconstruct the unseal key. This must be less than or equal secret_shares. If using Vault HSM with auto-unsealing, this value must be the same as `secret_shares`.
     * @type {number}
     * @memberof InitializeRequest
     */
    secretThreshold?: number;
    /**
     * Specifies the number of shares that should be encrypted by the HSM and stored for auto-unsealing. Currently must be the same as `secret_shares`.
     * @type {number}
     * @memberof InitializeRequest
     */
    storedShares?: number;
}
/**
 * Check if a given object implements the InitializeRequest interface.
 */
export declare function instanceOfInitializeRequest(value: object): value is InitializeRequest;
export declare function InitializeRequestFromJSON(json: any): InitializeRequest;
export declare function InitializeRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): InitializeRequest;
export declare function InitializeRequestToJSON(json: any): InitializeRequest;
export declare function InitializeRequestToJSONTyped(value?: InitializeRequest | null, ignoreDiscriminator?: boolean): any;
