/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface GoogleCloudConfigureRequest
 */
export interface GoogleCloudConfigureRequest {
    /**
     * GCP IAM service account credentials JSON with permissions to create new service accounts and set IAM policies
     * @type {string}
     * @memberof GoogleCloudConfigureRequest
     */
    credentials?: string;
    /**
     * If set to true, will deregister all registered rotation jobs from the RotationManager for the plugin.
     * @type {boolean}
     * @memberof GoogleCloudConfigureRequest
     */
    disableAutomatedRotation?: boolean;
    /**
     * Audience of plugin identity tokens
     * @type {string}
     * @memberof GoogleCloudConfigureRequest
     */
    identityTokenAudience?: string;
    /**
     * Time-to-live of plugin identity tokens
     * @type {string}
     * @memberof GoogleCloudConfigureRequest
     */
    identityTokenTtl?: string;
    /**
     * Maximum time a service account key is valid for. If <= 0, will use system default.
     * @type {string}
     * @memberof GoogleCloudConfigureRequest
     */
    maxTtl?: string;
    /**
     * TTL for automatic credential rotation of the given username. Mutually exclusive with rotation_schedule
     * @type {string}
     * @memberof GoogleCloudConfigureRequest
     */
    rotationPeriod?: string;
    /**
     * CRON-style string that will define the schedule on which rotations should occur. Mutually exclusive with rotation_period
     * @type {string}
     * @memberof GoogleCloudConfigureRequest
     */
    rotationSchedule?: string;
    /**
     * Specifies the amount of time in which the rotation is allowed to occur starting from a given rotation_schedule
     * @type {string}
     * @memberof GoogleCloudConfigureRequest
     */
    rotationWindow?: string;
    /**
     * Email ID for the Service Account to impersonate for Workload Identity Federation.
     * @type {string}
     * @memberof GoogleCloudConfigureRequest
     */
    serviceAccountEmail?: string;
    /**
     * Default lease for generated keys. If <= 0, will use system default.
     * @type {string}
     * @memberof GoogleCloudConfigureRequest
     */
    ttl?: string;
}
/**
 * Check if a given object implements the GoogleCloudConfigureRequest interface.
 */
export declare function instanceOfGoogleCloudConfigureRequest(value: object): value is GoogleCloudConfigureRequest;
export declare function GoogleCloudConfigureRequestFromJSON(json: any): GoogleCloudConfigureRequest;
export declare function GoogleCloudConfigureRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): GoogleCloudConfigureRequest;
export declare function GoogleCloudConfigureRequestToJSON(json: any): GoogleCloudConfigureRequest;
export declare function GoogleCloudConfigureRequestToJSONTyped(value?: GoogleCloudConfigureRequest | null, ignoreDiscriminator?: boolean): any;
