/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface GoogleCloudConfigureAuthRequest
 */
export interface GoogleCloudConfigureAuthRequest {
    /**
     * Google credentials JSON that Vault will use to verify users against GCP APIs. If not specified, will use application default credentials
     * @type {string}
     * @memberof GoogleCloudConfigureAuthRequest
     */
    credentials?: string;
    /**
     * Specifies overrides for various Google API Service Endpoints used in requests.
     * @type {object}
     * @memberof GoogleCloudConfigureAuthRequest
     */
    customEndpoint?: object;
    /**
     * If set to true, will deregister all registered rotation jobs from the RotationManager for the plugin.
     * @type {boolean}
     * @memberof GoogleCloudConfigureAuthRequest
     */
    disableAutomatedRotation?: boolean;
    /**
     * Indicates what value to use when generating an alias for GCE authentications.
     * @type {string}
     * @memberof GoogleCloudConfigureAuthRequest
     */
    gceAlias?: string;
    /**
     * The metadata to include on the aliases and audit logs generated by this plugin. When set to 'default', includes: instance_creation_timestamp, instance_id, instance_name, project_id, project_number, role, service_account_id, service_account_email, zone. Not editing this field means the 'default' fields are included. Explicitly setting this field to empty overrides the 'default' and means no metadata will be included. If not using 'default', explicit fields must be sent like: 'field1,field2'.
     * @type {Array<string>}
     * @memberof GoogleCloudConfigureAuthRequest
     */
    gceMetadata?: Array<string>;
    /**
     * Deprecated. This field does nothing and be removed in a future release
     * @type {string}
     * @memberof GoogleCloudConfigureAuthRequest
     * @deprecated
     */
    googleCertsEndpoint?: string;
    /**
     * Indicates what value to use when generating an alias for IAM authentications.
     * @type {string}
     * @memberof GoogleCloudConfigureAuthRequest
     */
    iamAlias?: string;
    /**
     * The metadata to include on the aliases and audit logs generated by this plugin. When set to 'default', includes: project_id, role, service_account_id, service_account_email. Not editing this field means the 'default' fields are included. Explicitly setting this field to empty overrides the 'default' and means no metadata will be included. If not using 'default', explicit fields must be sent like: 'field1,field2'.
     * @type {Array<string>}
     * @memberof GoogleCloudConfigureAuthRequest
     */
    iamMetadata?: Array<string>;
    /**
     * Audience of plugin identity tokens
     * @type {string}
     * @memberof GoogleCloudConfigureAuthRequest
     */
    identityTokenAudience?: string;
    /**
     * Time-to-live of plugin identity tokens
     * @type {string}
     * @memberof GoogleCloudConfigureAuthRequest
     */
    identityTokenTtl?: string;
    /**
     * TTL for automatic credential rotation of the given username. Mutually exclusive with rotation_schedule
     * @type {string}
     * @memberof GoogleCloudConfigureAuthRequest
     */
    rotationPeriod?: string;
    /**
     * CRON-style string that will define the schedule on which rotations should occur. Mutually exclusive with rotation_period
     * @type {string}
     * @memberof GoogleCloudConfigureAuthRequest
     */
    rotationSchedule?: string;
    /**
     * Specifies the amount of time in which the rotation is allowed to occur starting from a given rotation_schedule
     * @type {string}
     * @memberof GoogleCloudConfigureAuthRequest
     */
    rotationWindow?: string;
    /**
     * Email ID for the Service Account to impersonate for Workload Identity Federation.
     * @type {string}
     * @memberof GoogleCloudConfigureAuthRequest
     */
    serviceAccountEmail?: string;
}
/**
 * Check if a given object implements the GoogleCloudConfigureAuthRequest interface.
 */
export declare function instanceOfGoogleCloudConfigureAuthRequest(value: object): value is GoogleCloudConfigureAuthRequest;
export declare function GoogleCloudConfigureAuthRequestFromJSON(json: any): GoogleCloudConfigureAuthRequest;
export declare function GoogleCloudConfigureAuthRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): GoogleCloudConfigureAuthRequest;
export declare function GoogleCloudConfigureAuthRequestToJSON(json: any): GoogleCloudConfigureAuthRequest;
export declare function GoogleCloudConfigureAuthRequestToJSONTyped(value?: GoogleCloudConfigureAuthRequest | null, ignoreDiscriminator?: boolean): any;
