/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface AwsConfigureClientRequest
 */
export interface AwsConfigureClientRequest {
    /**
     * AWS Access Key ID for the account used to make AWS API requests.
     * @type {string}
     * @memberof AwsConfigureClientRequest
     */
    accessKey?: string;
    /**
     * List of additional headers that are allowed to be in AWS STS request headers
     * @type {Array<string>}
     * @memberof AwsConfigureClientRequest
     */
    allowedStsHeaderValues?: Array<string>;
    /**
     * If set to true, will deregister all registered rotation jobs from the RotationManager for the plugin.
     * @type {boolean}
     * @memberof AwsConfigureClientRequest
     */
    disableAutomatedRotation?: boolean;
    /**
     * URL to override the default generated endpoint for making AWS EC2 API calls.
     * @type {string}
     * @memberof AwsConfigureClientRequest
     */
    endpoint?: string;
    /**
     * URL to override the default generated endpoint for making AWS IAM API calls.
     * @type {string}
     * @memberof AwsConfigureClientRequest
     */
    iamEndpoint?: string;
    /**
     * Value to require in the X-Vault-AWS-IAM-Server-ID request header
     * @type {string}
     * @memberof AwsConfigureClientRequest
     */
    iamServerIdHeaderValue?: string;
    /**
     * Audience of plugin identity tokens
     * @type {string}
     * @memberof AwsConfigureClientRequest
     */
    identityTokenAudience?: string;
    /**
     * Time-to-live of plugin identity tokens
     * @type {string}
     * @memberof AwsConfigureClientRequest
     */
    identityTokenTtl?: string;
    /**
     * Maximum number of retries for recoverable exceptions of AWS APIs
     * @type {number}
     * @memberof AwsConfigureClientRequest
     */
    maxRetries?: number;
    /**
     * Role ARN to assume for plugin identity token federation
     * @type {string}
     * @memberof AwsConfigureClientRequest
     */
    roleArn?: string;
    /**
     * TTL for automatic credential rotation of the given username. Mutually exclusive with rotation_schedule
     * @type {string}
     * @memberof AwsConfigureClientRequest
     */
    rotationPeriod?: string;
    /**
     * CRON-style string that will define the schedule on which rotations should occur. Mutually exclusive with rotation_period
     * @type {string}
     * @memberof AwsConfigureClientRequest
     */
    rotationSchedule?: string;
    /**
     * Specifies the amount of time in which the rotation is allowed to occur starting from a given rotation_schedule
     * @type {string}
     * @memberof AwsConfigureClientRequest
     */
    rotationWindow?: string;
    /**
     * AWS Secret Access Key for the account used to make AWS API requests.
     * @type {string}
     * @memberof AwsConfigureClientRequest
     */
    secretKey?: string;
    /**
     * URL to override the default generated endpoint for making AWS STS API calls.
     * @type {string}
     * @memberof AwsConfigureClientRequest
     */
    stsEndpoint?: string;
    /**
     * The region ID for the sts_endpoint, if set.
     * @type {string}
     * @memberof AwsConfigureClientRequest
     */
    stsRegion?: string;
    /**
     * Uses the STS region from client requests for making AWS STS API calls.
     * @type {boolean}
     * @memberof AwsConfigureClientRequest
     */
    useStsRegionFromClient?: boolean;
}
/**
 * Check if a given object implements the AwsConfigureClientRequest interface.
 */
export declare function instanceOfAwsConfigureClientRequest(value: object): value is AwsConfigureClientRequest;
export declare function AwsConfigureClientRequestFromJSON(json: any): AwsConfigureClientRequest;
export declare function AwsConfigureClientRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): AwsConfigureClientRequest;
export declare function AwsConfigureClientRequestToJSON(json: any): AwsConfigureClientRequest;
export declare function AwsConfigureClientRequestToJSONTyped(value?: AwsConfigureClientRequest | null, ignoreDiscriminator?: boolean): any;
