/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import * as runtime from '../runtime';
import type { AuditingCalculateHashRequest, AuditingCalculateHashResponse, AuditingEnableDeviceRequest, AuditingEnableRequestHeaderRequest, AuditingListRequestHeadersResponse, AuthEnableMethodRequest, AuthReadConfigurationResponse, AuthReadTuningInformationResponse, AuthTuneConfigurationParametersRequest, CollectHostInformationResponse, CorsConfigureRequest, CorsReadConfigurationResponse, CreateCustomMessageRequest, DecodeTokenRequest, EncryptionKeyConfigureRotationRequest, EncryptionKeyReadRotationConfigurationResponse, GenerateHashRequest, GenerateHashResponse, GenerateHashWithAlgorithmRequest, GenerateHashWithAlgorithmResponse, GenerateRandomRequest, GenerateRandomResponse, GenerateRandomWithBytesRequest, GenerateRandomWithBytesResponse, GenerateRandomWithSourceAndBytesRequest, GenerateRandomWithSourceAndBytesResponse, GenerateRandomWithSourceRequest, GenerateRandomWithSourceResponse, GenerateUtilizationReportResponse, HaStatusResponse, InitializeRequest, InternalClientActivityConfigureRequest, InternalCountEntitiesResponse, InternalGenerateOpenApiDocumentWithParametersRequest, InternalUiListEnabledFeatureFlagsResponse, InternalUiListEnabledVisibleMountsResponse, InternalUiListNamespacesResponse, InternalUiReadAuthenticatedActiveCustomMessagesResponse, InternalUiReadMountInformationResponse, InternalUiReadResultantAclResponse, InternalUiReadUnauthenticatedActiveCustomMessagesResponse, LeaderStatusResponse, LeasesCountResponse, LeasesListResponse, LeasesLookUpResponse, LeasesReadLeaseRequest, LeasesReadLeaseResponse, LeasesRenewLease2Request, LeasesRenewLeaseRequest, LeasesRenewLeaseWithId2Request, LeasesRenewLeaseWithIdRequest, LeasesRevokeLease2Request, LeasesRevokeLeaseRequest, LeasesRevokeLeaseWithId2Request, LeasesRevokeLeaseWithIdRequest, LeasesRevokeLeaseWithPrefix2Request, LeasesRevokeLeaseWithPrefixRequest, LoggersUpdateVerbosityLevelForRequest, LoggersUpdateVerbosityLevelRequest, MfaValidateRequest, MountsEnableSecretsEngineRequest, MountsReadConfigurationResponse, MountsReadTuningInformationResponse, MountsTuneConfigurationParametersRequest, PluginsCatalogListPluginsResponse, PluginsCatalogListPluginsWithTypeResponse, PluginsCatalogPinsCreatePinnedVersionRequest, PluginsCatalogPinsListPinnedVersionsResponse, PluginsCatalogPinsReadPinnedVersionResponse, PluginsCatalogReadPluginConfigurationResponse, PluginsCatalogReadPluginConfigurationWithTypeResponse, PluginsCatalogRegisterPluginRequest, PluginsCatalogRegisterPluginWithTypeRequest, PluginsReloadBackendsRequest, PluginsReloadBackendsResponse, PluginsRuntimesCatalogListPluginsRuntimesResponse, PluginsRuntimesCatalogReadPluginRuntimeConfigurationResponse, PluginsRuntimesCatalogRegisterPluginRuntimeRequest, PoliciesGeneratePasswordFromPasswordPolicyResponse, PoliciesListAclPolicies2Response, PoliciesListAclPolicies3Response, PoliciesListAclPoliciesResponse, PoliciesReadAclPolicy2Response, PoliciesReadAclPolicyResponse, PoliciesReadPasswordPolicyResponse, PoliciesWriteAclPolicy2Request, PoliciesWriteAclPolicyRequest, PoliciesWritePasswordPolicyRequest, QueryTokenAccessorCapabilitiesRequest, QueryTokenCapabilitiesRequest, QueryTokenSelfCapabilitiesRequest, RateLimitQuotasConfigureRequest, RateLimitQuotasReadConfigurationResponse, RateLimitQuotasReadResponse, RateLimitQuotasWriteRequest, RawReadResponse, RawWriteRequest, ReadWrappingProperties2Response, ReadWrappingPropertiesRequest, ReadWrappingPropertiesResponse, RekeyAttemptInitializeRequest, RekeyAttemptInitializeResponse, RekeyAttemptReadProgressResponse, RekeyAttemptUpdateRequest, RekeyAttemptUpdateResponse, RekeyReadBackupKeyResponse, RekeyReadBackupRecoveryKeyResponse, RekeyVerificationCancelResponse, RekeyVerificationReadProgressResponse, RekeyVerificationUpdateRequest, RekeyVerificationUpdateResponse, ReloadPluginsRequest, ReloadPluginsResponse, RemountRequest, RemountResponse, RemountStatusResponse, RewrapRequest, RootTokenGenerationInitialize2Request, RootTokenGenerationInitialize2Response, RootTokenGenerationInitializeRequest, RootTokenGenerationInitializeResponse, RootTokenGenerationReadProgress2Response, RootTokenGenerationReadProgressResponse, RootTokenGenerationUpdateRequest, RootTokenGenerationUpdateResponse, SealStatusResponse, StandardListResponse, SubscriptionsCreateResponse, SubscriptionsListEventsSubscriptionsResponse, SubscriptionsReadEventsSubscriptionsResponse, SubscriptionsWriteEventsSubscriptionsRequest, SubscriptionsWriteEventsSubscriptionsResponse, SystemDeleteSyncConfigResponse, SystemDeleteSyncGithubAppsNameResponse, SystemListSyncAssociationsResponse, SystemListSyncDestinationsResponse, SystemListSyncDestinationsTypeResponse, SystemListSyncGithubAppsResponse, SystemPatchNamespacesPathRequest, SystemPatchSyncConfigRequest, SystemPatchSyncConfigResponse, SystemPatchSyncDestinationsAwsSmNameRequest, SystemPatchSyncDestinationsAwsSmNameResponse, SystemPatchSyncDestinationsAzureKvNameRequest, SystemPatchSyncDestinationsAzureKvNameResponse, SystemPatchSyncDestinationsGcpSmNameRequest, SystemPatchSyncDestinationsGcpSmNameResponse, SystemPatchSyncDestinationsGhNameRequest, SystemPatchSyncDestinationsGhNameResponse, SystemPatchSyncDestinationsInMemNameRequest, SystemPatchSyncDestinationsInMemNameResponse, SystemPatchSyncDestinationsVercelProjectNameRequest, SystemPatchSyncDestinationsVercelProjectNameResponse, SystemReadConfigGroupPolicyApplicationResponse, SystemReadSyncAssociationsDestinationsResponse, SystemReadSyncAssociationsMountSecretNameResponse, SystemReadSyncConfigResponse, SystemReadSyncDestinationsAwsSmNameResponse, SystemReadSyncDestinationsAzureKvNameResponse, SystemReadSyncDestinationsGcpSmNameResponse, SystemReadSyncDestinationsGhNameResponse, SystemReadSyncDestinationsInMemNameResponse, SystemReadSyncDestinationsTypeNameAssociationsResponse, SystemReadSyncDestinationsVercelProjectNameResponse, SystemReadSyncGithubAppsNameResponse, SystemWriteConfigControlGroupRequest, SystemWriteConfigGroupPolicyApplicationRequest, SystemWriteControlGroupAuthorizeRequest, SystemWriteControlGroupRequestRequest, SystemWriteInternalCountersActivityWriteRequest, SystemWriteManagedKeysTypeNameRequest, SystemWriteManagedKeysTypeNameTestSignRequest, SystemWriteMfaMethodDuoNameRequest, SystemWriteMfaMethodOktaNameRequest, SystemWriteMfaMethodPingidNameRequest, SystemWriteMfaMethodTotpNameAdminDestroyRequest, SystemWriteMfaMethodTotpNameAdminGenerateRequest, SystemWriteMfaMethodTotpNameRequest, SystemWriteNamespacesApiLockUnlockPathRequest, SystemWriteNamespacesApiLockUnlockRequest, SystemWriteNamespacesPathRequest, SystemWritePoliciesEgpNameRequest, SystemWritePoliciesRgpNameRequest, SystemWriteQuotasLeaseCountNameRequest, SystemWriteReplicationDrPrimaryEnableRequest, SystemWriteReplicationDrPrimaryRevokeSecondaryRequest, SystemWriteReplicationDrPrimarySecondaryTokenRequest, SystemWriteReplicationDrSecondaryDisableRequest, SystemWriteReplicationDrSecondaryEnableRequest, SystemWriteReplicationDrSecondaryMerkleCheckRequest, SystemWriteReplicationDrSecondaryOperationTokenDeleteRequest, SystemWriteReplicationDrSecondaryPromoteRequest, SystemWriteReplicationDrSecondaryRecoverRequest, SystemWriteReplicationDrSecondaryReindexRequest, SystemWriteReplicationDrSecondaryUpdatePrimaryRequest, SystemWriteReplicationForceCorruptionRequest, SystemWriteReplicationPerformancePrimaryEnableRequest, SystemWriteReplicationPerformancePrimaryPathsFilterIdRequest, SystemWriteReplicationPerformancePrimaryRevokeSecondaryRequest, SystemWriteReplicationPerformancePrimarySecondaryTokenRequest, SystemWriteReplicationPerformanceSecondaryEnableRequest, SystemWriteReplicationPerformanceSecondaryPromoteRequest, SystemWriteReplicationPerformanceSecondaryUpdatePrimaryRequest, SystemWriteReplicationPrimaryEnableRequest, SystemWriteReplicationPrimaryRevokeSecondaryRequest, SystemWriteReplicationPrimarySecondaryTokenRequest, SystemWriteReplicationReindexRequest, SystemWriteReplicationSecondaryEnableRequest, SystemWriteReplicationSecondaryPromoteRequest, SystemWriteReplicationSecondaryUpdatePrimaryRequest, SystemWriteStorageRaftSnapshotAutoConfigNameRequest, SystemWriteSyncDestinationsAwsSmNameRequest, SystemWriteSyncDestinationsAwsSmNameResponse, SystemWriteSyncDestinationsAzureKvNameRequest, SystemWriteSyncDestinationsAzureKvNameResponse, SystemWriteSyncDestinationsGcpSmNameRequest, SystemWriteSyncDestinationsGcpSmNameResponse, SystemWriteSyncDestinationsGhNameRequest, SystemWriteSyncDestinationsGhNameResponse, SystemWriteSyncDestinationsInMemNameRequest, SystemWriteSyncDestinationsInMemNameResponse, SystemWriteSyncDestinationsTypeNameAssociationsRemoveRequest, SystemWriteSyncDestinationsTypeNameAssociationsRemoveResponse, SystemWriteSyncDestinationsTypeNameAssociationsSetRequest, SystemWriteSyncDestinationsTypeNameAssociationsSetResponse, SystemWriteSyncDestinationsVercelProjectNameRequest, SystemWriteSyncDestinationsVercelProjectNameResponse, SystemWriteSyncGithubAppsNameRequest, SystemWriteSyncGithubAppsNameResponse, SystemWriteUtilizationRequest, SystemWriteUtilizationResponse, UiConfigListCustomMessagesResponse, UiConfigReadCustomMessageResponse, UiConfigUpdateCustomMessageRequest, UiConfigUpdateCustomMessageResponse, UiHeadersConfigureRequest, UiHeadersListResponse, UiHeadersReadConfigurationResponse, UiLoginDefaultAuthConfigureRequest, UiLoginDefaultAuthListResponse, UnsealRequest, UnsealResponse, UnwrapRequest, VersionHistoryResponse, WellKnownListLabels2Response, WellKnownListLabelsResponse, WellKnownReadLabelResponse } from '../models/index';
export interface SystemApiAuditingCalculateHashOperationRequest {
    path: string;
    auditingCalculateHashRequest: AuditingCalculateHashRequest;
}
export interface SystemApiAuditingDisableDeviceRequest {
    path: string;
}
export interface SystemApiAuditingDisableRequestHeaderRequest {
    header: string;
}
export interface SystemApiAuditingEnableDeviceOperationRequest {
    path: string;
    auditingEnableDeviceRequest: AuditingEnableDeviceRequest;
}
export interface SystemApiAuditingEnableRequestHeaderOperationRequest {
    header: string;
    auditingEnableRequestHeaderRequest: AuditingEnableRequestHeaderRequest;
}
export interface SystemApiAuditingReadRequestHeaderInformationRequest {
    header: string;
}
export interface SystemApiAuthDisableMethodRequest {
    path: string;
}
export interface SystemApiAuthEnableMethodOperationRequest {
    path: string;
    authEnableMethodRequest: AuthEnableMethodRequest;
}
export interface SystemApiAuthReadConfigurationRequest {
    path: string;
}
export interface SystemApiAuthReadTuningInformationRequest {
    path: string;
}
export interface SystemApiAuthTuneConfigurationParametersOperationRequest {
    path: string;
    authTuneConfigurationParametersRequest: AuthTuneConfigurationParametersRequest;
}
export interface SystemApiCorsConfigureOperationRequest {
    corsConfigureRequest: CorsConfigureRequest;
}
export interface SystemApiCreateCustomMessageOperationRequest {
    createCustomMessageRequest: CreateCustomMessageRequest;
}
export interface SystemApiDecodeTokenOperationRequest {
    decodeTokenRequest: DecodeTokenRequest;
}
export interface SystemApiEncryptionKeyConfigureRotationOperationRequest {
    encryptionKeyConfigureRotationRequest: EncryptionKeyConfigureRotationRequest;
}
export interface SystemApiGenerateHashOperationRequest {
    generateHashRequest: GenerateHashRequest;
}
export interface SystemApiGenerateHashWithAlgorithmOperationRequest {
    urlalgorithm: string;
    generateHashWithAlgorithmRequest: GenerateHashWithAlgorithmRequest;
}
export interface SystemApiGenerateRandomOperationRequest {
    generateRandomRequest: GenerateRandomRequest;
}
export interface SystemApiGenerateRandomWithBytesOperationRequest {
    urlbytes: string;
    generateRandomWithBytesRequest: GenerateRandomWithBytesRequest;
}
export interface SystemApiGenerateRandomWithSourceOperationRequest {
    source: string;
    generateRandomWithSourceRequest: GenerateRandomWithSourceRequest;
}
export interface SystemApiGenerateRandomWithSourceAndBytesOperationRequest {
    source: string;
    urlbytes: string;
    generateRandomWithSourceAndBytesRequest: GenerateRandomWithSourceAndBytesRequest;
}
export interface SystemApiInitializeOperationRequest {
    initializeRequest: InitializeRequest;
}
export interface SystemApiInternalClientActivityConfigureOperationRequest {
    internalClientActivityConfigureRequest: InternalClientActivityConfigureRequest;
}
export interface SystemApiInternalGenerateOpenApiDocumentRequest {
    context?: string;
    genericMountPaths?: boolean;
}
export interface SystemApiInternalGenerateOpenApiDocumentWithParametersOperationRequest {
    internalGenerateOpenApiDocumentWithParametersRequest: InternalGenerateOpenApiDocumentWithParametersRequest;
}
export interface SystemApiInternalInspectRouterRequest {
    tag: string;
}
export interface SystemApiInternalUiReadMountInformationRequest {
    path: string;
}
export interface SystemApiLeasesForceRevokeLeaseWithPrefixRequest {
    prefix: string;
}
export interface SystemApiLeasesForceRevokeLeaseWithPrefix2Request {
    prefix: string;
}
export interface SystemApiLeasesLookUpRequest {
    prefix: string;
    list: LeasesLookUpListEnum;
}
export interface SystemApiLeasesReadLeaseOperationRequest {
    leasesReadLeaseRequest: LeasesReadLeaseRequest;
}
export interface SystemApiLeasesRenewLeaseOperationRequest {
    leasesRenewLeaseRequest: LeasesRenewLeaseRequest;
}
export interface SystemApiLeasesRenewLease2OperationRequest {
    leasesRenewLease2Request: LeasesRenewLease2Request;
}
export interface SystemApiLeasesRenewLeaseWithIdOperationRequest {
    urlLeaseId: string;
    leasesRenewLeaseWithIdRequest: LeasesRenewLeaseWithIdRequest;
}
export interface SystemApiLeasesRenewLeaseWithId2OperationRequest {
    urlLeaseId: string;
    leasesRenewLeaseWithId2Request: LeasesRenewLeaseWithId2Request;
}
export interface SystemApiLeasesRevokeLeaseOperationRequest {
    leasesRevokeLeaseRequest: LeasesRevokeLeaseRequest;
}
export interface SystemApiLeasesRevokeLease2OperationRequest {
    leasesRevokeLease2Request: LeasesRevokeLease2Request;
}
export interface SystemApiLeasesRevokeLeaseWithIdOperationRequest {
    urlLeaseId: string;
    leasesRevokeLeaseWithIdRequest: LeasesRevokeLeaseWithIdRequest;
}
export interface SystemApiLeasesRevokeLeaseWithId2OperationRequest {
    urlLeaseId: string;
    leasesRevokeLeaseWithId2Request: LeasesRevokeLeaseWithId2Request;
}
export interface SystemApiLeasesRevokeLeaseWithPrefixOperationRequest {
    prefix: string;
    leasesRevokeLeaseWithPrefixRequest: LeasesRevokeLeaseWithPrefixRequest;
}
export interface SystemApiLeasesRevokeLeaseWithPrefix2OperationRequest {
    prefix: string;
    leasesRevokeLeaseWithPrefix2Request: LeasesRevokeLeaseWithPrefix2Request;
}
export interface SystemApiLockedUsersUnlockRequest {
    aliasIdentifier: string;
    mountAccessor: string;
}
export interface SystemApiLoggersReadVerbosityLevelForRequest {
    name: string;
}
export interface SystemApiLoggersRevertVerbosityLevelForRequest {
    name: string;
}
export interface SystemApiLoggersUpdateVerbosityLevelOperationRequest {
    loggersUpdateVerbosityLevelRequest: LoggersUpdateVerbosityLevelRequest;
}
export interface SystemApiLoggersUpdateVerbosityLevelForOperationRequest {
    name: string;
    loggersUpdateVerbosityLevelForRequest: LoggersUpdateVerbosityLevelForRequest;
}
export interface SystemApiMetricsRequest {
    format?: string;
}
export interface SystemApiMfaValidateOperationRequest {
    mfaValidateRequest: MfaValidateRequest;
}
export interface SystemApiMonitorRequest {
    logFormat?: string;
    logLevel?: string;
}
export interface SystemApiMountsDisableSecretsEngineRequest {
    path: string;
}
export interface SystemApiMountsEnableSecretsEngineOperationRequest {
    path: string;
    mountsEnableSecretsEngineRequest: MountsEnableSecretsEngineRequest;
}
export interface SystemApiMountsReadConfigurationRequest {
    path: string;
}
export interface SystemApiMountsReadTuningInformationRequest {
    path: string;
}
export interface SystemApiMountsTuneConfigurationParametersOperationRequest {
    path: string;
    mountsTuneConfigurationParametersRequest: MountsTuneConfigurationParametersRequest;
}
export interface SystemApiPluginsCatalogListPluginsWithTypeRequest {
    type: string;
    list: PluginsCatalogListPluginsWithTypeListEnum;
}
export interface SystemApiPluginsCatalogPinsCreatePinnedVersionOperationRequest {
    name: string;
    type: string;
    pluginsCatalogPinsCreatePinnedVersionRequest: PluginsCatalogPinsCreatePinnedVersionRequest;
}
export interface SystemApiPluginsCatalogPinsReadPinnedVersionRequest {
    name: string;
    type: string;
}
export interface SystemApiPluginsCatalogPinsRemovePinnedVersionRequest {
    name: string;
    type: string;
}
export interface SystemApiPluginsCatalogReadPluginConfigurationRequest {
    name: string;
}
export interface SystemApiPluginsCatalogReadPluginConfigurationWithTypeRequest {
    name: string;
    type: string;
}
export interface SystemApiPluginsCatalogRegisterPluginOperationRequest {
    name: string;
    pluginsCatalogRegisterPluginRequest: PluginsCatalogRegisterPluginRequest;
}
export interface SystemApiPluginsCatalogRegisterPluginWithTypeOperationRequest {
    name: string;
    type: string;
    pluginsCatalogRegisterPluginWithTypeRequest: PluginsCatalogRegisterPluginWithTypeRequest;
}
export interface SystemApiPluginsCatalogRemovePluginRequest {
    name: string;
}
export interface SystemApiPluginsCatalogRemovePluginWithTypeRequest {
    name: string;
    type: string;
}
export interface SystemApiPluginsReloadBackendsOperationRequest {
    pluginsReloadBackendsRequest: PluginsReloadBackendsRequest;
}
export interface SystemApiPluginsRuntimesCatalogListPluginsRuntimes0Request {
    list: PluginsRuntimesCatalogListPluginsRuntimes0ListEnum;
}
export interface SystemApiPluginsRuntimesCatalogReadPluginRuntimeConfigurationRequest {
    name: string;
    type: string;
}
export interface SystemApiPluginsRuntimesCatalogRegisterPluginRuntimeOperationRequest {
    name: string;
    type: string;
    pluginsRuntimesCatalogRegisterPluginRuntimeRequest: PluginsRuntimesCatalogRegisterPluginRuntimeRequest;
}
export interface SystemApiPluginsRuntimesCatalogRemovePluginRuntimeRequest {
    name: string;
    type: string;
}
export interface SystemApiPoliciesDeleteAclPolicyRequest {
    name: string;
}
export interface SystemApiPoliciesDeleteAclPolicy2Request {
    name: string;
}
export interface SystemApiPoliciesDeletePasswordPolicyRequest {
    name: string;
}
export interface SystemApiPoliciesGeneratePasswordFromPasswordPolicyRequest {
    name: string;
}
export interface SystemApiPoliciesListAclPoliciesRequest {
    list: PoliciesListAclPoliciesListEnum;
}
export interface SystemApiPoliciesListAclPolicies3Request {
    list: PoliciesListAclPolicies3ListEnum;
}
export interface SystemApiPoliciesListPasswordPoliciesRequest {
    list: PoliciesListPasswordPoliciesListEnum;
}
export interface SystemApiPoliciesReadAclPolicyRequest {
    name: string;
}
export interface SystemApiPoliciesReadAclPolicy2Request {
    name: string;
}
export interface SystemApiPoliciesReadPasswordPolicyRequest {
    name: string;
}
export interface SystemApiPoliciesWriteAclPolicyOperationRequest {
    name: string;
    policiesWriteAclPolicyRequest: PoliciesWriteAclPolicyRequest;
}
export interface SystemApiPoliciesWriteAclPolicy2OperationRequest {
    name: string;
    policiesWriteAclPolicy2Request: PoliciesWriteAclPolicy2Request;
}
export interface SystemApiPoliciesWritePasswordPolicyOperationRequest {
    name: string;
    policiesWritePasswordPolicyRequest: PoliciesWritePasswordPolicyRequest;
}
export interface SystemApiQueryTokenAccessorCapabilitiesOperationRequest {
    queryTokenAccessorCapabilitiesRequest: QueryTokenAccessorCapabilitiesRequest;
}
export interface SystemApiQueryTokenCapabilitiesOperationRequest {
    queryTokenCapabilitiesRequest: QueryTokenCapabilitiesRequest;
}
export interface SystemApiQueryTokenSelfCapabilitiesOperationRequest {
    queryTokenSelfCapabilitiesRequest: QueryTokenSelfCapabilitiesRequest;
}
export interface SystemApiRateLimitQuotasConfigureOperationRequest {
    rateLimitQuotasConfigureRequest: RateLimitQuotasConfigureRequest;
}
export interface SystemApiRateLimitQuotasDeleteRequest {
    name: string;
}
export interface SystemApiRateLimitQuotasListRequest {
    list: RateLimitQuotasListListEnum;
}
export interface SystemApiRateLimitQuotasReadRequest {
    name: string;
}
export interface SystemApiRateLimitQuotasWriteOperationRequest {
    name: string;
    rateLimitQuotasWriteRequest: RateLimitQuotasWriteRequest;
}
export interface SystemApiRawDeleteRequest {
    path: string;
}
export interface SystemApiRawListRequest {
    path: string;
    list: RawListListEnum;
}
export interface SystemApiRawReadRequest {
    path: string;
}
export interface SystemApiRawWriteOperationRequest {
    path: string;
    rawWriteRequest: RawWriteRequest;
}
export interface SystemApiReadWrappingPropertiesOperationRequest {
    readWrappingPropertiesRequest: ReadWrappingPropertiesRequest;
}
export interface SystemApiReadWrappingProperties2Request {
    token?: string;
}
export interface SystemApiRekeyAttemptInitializeOperationRequest {
    rekeyAttemptInitializeRequest: RekeyAttemptInitializeRequest;
}
export interface SystemApiRekeyAttemptUpdateOperationRequest {
    rekeyAttemptUpdateRequest: RekeyAttemptUpdateRequest;
}
export interface SystemApiRekeyVerificationUpdateOperationRequest {
    rekeyVerificationUpdateRequest: RekeyVerificationUpdateRequest;
}
export interface SystemApiReloadPluginsOperationRequest {
    name: string;
    type: string;
    reloadPluginsRequest: ReloadPluginsRequest;
}
export interface SystemApiReloadSubsystemRequest {
    subsystem: string;
}
export interface SystemApiRemountOperationRequest {
    remountRequest: RemountRequest;
}
export interface SystemApiRemountStatusRequest {
    migrationId: string;
}
export interface SystemApiRewrapOperationRequest {
    rewrapRequest: RewrapRequest;
}
export interface SystemApiRootTokenGenerationInitializeOperationRequest {
    rootTokenGenerationInitializeRequest: RootTokenGenerationInitializeRequest;
}
export interface SystemApiRootTokenGenerationInitialize2OperationRequest {
    rootTokenGenerationInitialize2Request: RootTokenGenerationInitialize2Request;
}
export interface SystemApiRootTokenGenerationUpdateOperationRequest {
    rootTokenGenerationUpdateRequest: RootTokenGenerationUpdateRequest;
}
export interface SystemApiSubscriptionsCreateRequest {
    id: string;
    plugin: string;
}
export interface SystemApiSubscriptionsCreate0Request {
    id: string;
    plugin: string;
}
export interface SystemApiSubscriptionsListEventsSubscriptionsRequest {
    list: SubscriptionsListEventsSubscriptionsListEnum;
}
export interface SystemApiSubscriptionsWriteEventsSubscriptionsOperationRequest {
    subscriptionsWriteEventsSubscriptionsRequest: SubscriptionsWriteEventsSubscriptionsRequest;
}
export interface SystemApiSystemDeleteManagedKeysTypeNameRequest {
    name: string;
    type: string;
}
export interface SystemApiSystemDeleteMfaMethodDuoNameRequest {
    name: string;
}
export interface SystemApiSystemDeleteMfaMethodOktaNameRequest {
    name: string;
}
export interface SystemApiSystemDeleteMfaMethodPingidNameRequest {
    name: string;
}
export interface SystemApiSystemDeleteMfaMethodTotpNameRequest {
    name: string;
}
export interface SystemApiSystemDeleteNamespacesPathRequest {
    path: string;
}
export interface SystemApiSystemDeletePoliciesEgpNameRequest {
    name: string;
}
export interface SystemApiSystemDeletePoliciesRgpNameRequest {
    name: string;
}
export interface SystemApiSystemDeleteQuotasLeaseCountNameRequest {
    name: string;
}
export interface SystemApiSystemDeleteReplicationPerformancePrimaryPathsFilterIdRequest {
    id: string;
}
export interface SystemApiSystemDeleteStorageRaftSnapshotAutoConfigNameRequest {
    name: string;
}
export interface SystemApiSystemDeleteSyncDestinationsAwsSmNameRequest {
    name: string;
}
export interface SystemApiSystemDeleteSyncDestinationsAzureKvNameRequest {
    name: string;
}
export interface SystemApiSystemDeleteSyncDestinationsGcpSmNameRequest {
    name: string;
}
export interface SystemApiSystemDeleteSyncDestinationsGhNameRequest {
    name: string;
}
export interface SystemApiSystemDeleteSyncDestinationsInMemNameRequest {
    name: string;
}
export interface SystemApiSystemDeleteSyncDestinationsVercelProjectNameRequest {
    name: string;
}
export interface SystemApiSystemDeleteSyncGithubAppsNameRequest {
    name: string;
}
export interface SystemApiSystemListManagedKeysTypeRequest {
    type: string;
    list: SystemListManagedKeysTypeListEnum;
}
export interface SystemApiSystemListMfaMethodRequest {
    list: SystemListMfaMethodListEnum;
}
export interface SystemApiSystemListNamespacesRequest {
    list: SystemListNamespacesListEnum;
}
export interface SystemApiSystemListPoliciesEgpRequest {
    list: SystemListPoliciesEgpListEnum;
}
export interface SystemApiSystemListPoliciesRgpRequest {
    list: SystemListPoliciesRgpListEnum;
}
export interface SystemApiSystemListQuotasLeaseCountRequest {
    list: SystemListQuotasLeaseCountListEnum;
}
export interface SystemApiSystemListStorageRaftSnapshotAutoConfigRequest {
    list: SystemListStorageRaftSnapshotAutoConfigListEnum;
}
export interface SystemApiSystemListSyncAssociationsRequest {
    list: SystemListSyncAssociationsListEnum;
}
export interface SystemApiSystemListSyncDestinationsRequest {
    list: SystemListSyncDestinationsListEnum;
}
export interface SystemApiSystemListSyncDestinationsTypeRequest {
    type: string;
    list: SystemListSyncDestinationsTypeListEnum;
}
export interface SystemApiSystemListSyncGithubAppsRequest {
    list: SystemListSyncGithubAppsListEnum;
}
export interface SystemApiSystemPatchNamespacesPathOperationRequest {
    path: string;
    systemPatchNamespacesPathRequest: SystemPatchNamespacesPathRequest;
}
export interface SystemApiSystemPatchSyncConfigOperationRequest {
    systemPatchSyncConfigRequest: SystemPatchSyncConfigRequest;
}
export interface SystemApiSystemPatchSyncDestinationsAwsSmNameOperationRequest {
    name: string;
    systemPatchSyncDestinationsAwsSmNameRequest: SystemPatchSyncDestinationsAwsSmNameRequest;
}
export interface SystemApiSystemPatchSyncDestinationsAzureKvNameOperationRequest {
    name: string;
    systemPatchSyncDestinationsAzureKvNameRequest: SystemPatchSyncDestinationsAzureKvNameRequest;
}
export interface SystemApiSystemPatchSyncDestinationsGcpSmNameOperationRequest {
    name: string;
    systemPatchSyncDestinationsGcpSmNameRequest: SystemPatchSyncDestinationsGcpSmNameRequest;
}
export interface SystemApiSystemPatchSyncDestinationsGhNameOperationRequest {
    name: string;
    systemPatchSyncDestinationsGhNameRequest: SystemPatchSyncDestinationsGhNameRequest;
}
export interface SystemApiSystemPatchSyncDestinationsInMemNameOperationRequest {
    name: string;
    systemPatchSyncDestinationsInMemNameRequest: SystemPatchSyncDestinationsInMemNameRequest;
}
export interface SystemApiSystemPatchSyncDestinationsVercelProjectNameOperationRequest {
    name: string;
    systemPatchSyncDestinationsVercelProjectNameRequest: SystemPatchSyncDestinationsVercelProjectNameRequest;
}
export interface SystemApiSystemReadManagedKeysTypeNameRequest {
    name: string;
    type: string;
}
export interface SystemApiSystemReadMfaMethodDuoNameRequest {
    name: string;
}
export interface SystemApiSystemReadMfaMethodOktaNameRequest {
    name: string;
}
export interface SystemApiSystemReadMfaMethodPingidNameRequest {
    name: string;
}
export interface SystemApiSystemReadMfaMethodTotpNameRequest {
    name: string;
}
export interface SystemApiSystemReadMfaMethodTotpNameGenerateRequest {
    name: string;
}
export interface SystemApiSystemReadNamespacesPathRequest {
    path: string;
}
export interface SystemApiSystemReadPoliciesEgpNameRequest {
    name: string;
}
export interface SystemApiSystemReadPoliciesRgpNameRequest {
    name: string;
}
export interface SystemApiSystemReadQuotasLeaseCountNameRequest {
    name: string;
}
export interface SystemApiSystemReadReplicationPerformancePrimaryDynamicFilterIdRequest {
    id: string;
}
export interface SystemApiSystemReadReplicationPerformancePrimaryPathsFilterIdRequest {
    id: string;
}
export interface SystemApiSystemReadReplicationPerformanceSecondaryDynamicFilterIdRequest {
    id: string;
}
export interface SystemApiSystemReadStorageRaftSnapshotAutoConfigNameRequest {
    name: string;
}
export interface SystemApiSystemReadStorageRaftSnapshotAutoStatusNameRequest {
    name: string;
}
export interface SystemApiSystemReadSyncAssociationsMountSecretNameRequest {
    mount: string;
    secretName: string;
}
export interface SystemApiSystemReadSyncDestinationsAwsSmNameRequest {
    name: string;
}
export interface SystemApiSystemReadSyncDestinationsAzureKvNameRequest {
    name: string;
}
export interface SystemApiSystemReadSyncDestinationsGcpSmNameRequest {
    name: string;
}
export interface SystemApiSystemReadSyncDestinationsGhNameRequest {
    name: string;
}
export interface SystemApiSystemReadSyncDestinationsInMemNameRequest {
    name: string;
}
export interface SystemApiSystemReadSyncDestinationsTypeNameAssociationsRequest {
    name: string;
    type: string;
}
export interface SystemApiSystemReadSyncDestinationsVercelProjectNameRequest {
    name: string;
}
export interface SystemApiSystemReadSyncGithubAppsNameRequest {
    name: string;
}
export interface SystemApiSystemWriteConfigControlGroupOperationRequest {
    systemWriteConfigControlGroupRequest: SystemWriteConfigControlGroupRequest;
}
export interface SystemApiSystemWriteConfigGroupPolicyApplicationOperationRequest {
    systemWriteConfigGroupPolicyApplicationRequest: SystemWriteConfigGroupPolicyApplicationRequest;
}
export interface SystemApiSystemWriteControlGroupAuthorizeOperationRequest {
    systemWriteControlGroupAuthorizeRequest: SystemWriteControlGroupAuthorizeRequest;
}
export interface SystemApiSystemWriteControlGroupRequestOperationRequest {
    systemWriteControlGroupRequestRequest: SystemWriteControlGroupRequestRequest;
}
export interface SystemApiSystemWriteInternalCountersActivityWriteOperationRequest {
    systemWriteInternalCountersActivityWriteRequest: SystemWriteInternalCountersActivityWriteRequest;
}
export interface SystemApiSystemWriteManagedKeysTypeNameOperationRequest {
    name: string;
    type: string;
    systemWriteManagedKeysTypeNameRequest: SystemWriteManagedKeysTypeNameRequest;
}
export interface SystemApiSystemWriteManagedKeysTypeNameTestSignOperationRequest {
    name: string;
    type: string;
    systemWriteManagedKeysTypeNameTestSignRequest: SystemWriteManagedKeysTypeNameTestSignRequest;
}
export interface SystemApiSystemWriteMfaMethodDuoNameOperationRequest {
    name: string;
    systemWriteMfaMethodDuoNameRequest: SystemWriteMfaMethodDuoNameRequest;
}
export interface SystemApiSystemWriteMfaMethodOktaNameOperationRequest {
    name: string;
    systemWriteMfaMethodOktaNameRequest: SystemWriteMfaMethodOktaNameRequest;
}
export interface SystemApiSystemWriteMfaMethodPingidNameOperationRequest {
    name: string;
    systemWriteMfaMethodPingidNameRequest: SystemWriteMfaMethodPingidNameRequest;
}
export interface SystemApiSystemWriteMfaMethodTotpNameOperationRequest {
    name: string;
    systemWriteMfaMethodTotpNameRequest: SystemWriteMfaMethodTotpNameRequest;
}
export interface SystemApiSystemWriteMfaMethodTotpNameAdminDestroyOperationRequest {
    name: string;
    systemWriteMfaMethodTotpNameAdminDestroyRequest: SystemWriteMfaMethodTotpNameAdminDestroyRequest;
}
export interface SystemApiSystemWriteMfaMethodTotpNameAdminGenerateOperationRequest {
    name: string;
    systemWriteMfaMethodTotpNameAdminGenerateRequest: SystemWriteMfaMethodTotpNameAdminGenerateRequest;
}
export interface SystemApiSystemWriteNamespacesApiLockLockPathRequest {
    path: string;
}
export interface SystemApiSystemWriteNamespacesApiLockUnlockOperationRequest {
    systemWriteNamespacesApiLockUnlockRequest: SystemWriteNamespacesApiLockUnlockRequest;
}
export interface SystemApiSystemWriteNamespacesApiLockUnlockPathOperationRequest {
    path: string;
    systemWriteNamespacesApiLockUnlockPathRequest: SystemWriteNamespacesApiLockUnlockPathRequest;
}
export interface SystemApiSystemWriteNamespacesPathOperationRequest {
    path: string;
    systemWriteNamespacesPathRequest: SystemWriteNamespacesPathRequest;
}
export interface SystemApiSystemWritePoliciesEgpNameOperationRequest {
    name: string;
    systemWritePoliciesEgpNameRequest: SystemWritePoliciesEgpNameRequest;
}
export interface SystemApiSystemWritePoliciesRgpNameOperationRequest {
    name: string;
    systemWritePoliciesRgpNameRequest: SystemWritePoliciesRgpNameRequest;
}
export interface SystemApiSystemWriteQuotasLeaseCountNameOperationRequest {
    name: string;
    systemWriteQuotasLeaseCountNameRequest: SystemWriteQuotasLeaseCountNameRequest;
}
export interface SystemApiSystemWriteReplicationDrPrimaryEnableOperationRequest {
    systemWriteReplicationDrPrimaryEnableRequest: SystemWriteReplicationDrPrimaryEnableRequest;
}
export interface SystemApiSystemWriteReplicationDrPrimaryRevokeSecondaryOperationRequest {
    systemWriteReplicationDrPrimaryRevokeSecondaryRequest: SystemWriteReplicationDrPrimaryRevokeSecondaryRequest;
}
export interface SystemApiSystemWriteReplicationDrPrimarySecondaryTokenOperationRequest {
    systemWriteReplicationDrPrimarySecondaryTokenRequest: SystemWriteReplicationDrPrimarySecondaryTokenRequest;
}
export interface SystemApiSystemWriteReplicationDrSecondaryConfigReloadSubsystemRequest {
    subsystem: string;
}
export interface SystemApiSystemWriteReplicationDrSecondaryDisableOperationRequest {
    systemWriteReplicationDrSecondaryDisableRequest: SystemWriteReplicationDrSecondaryDisableRequest;
}
export interface SystemApiSystemWriteReplicationDrSecondaryEnableOperationRequest {
    systemWriteReplicationDrSecondaryEnableRequest: SystemWriteReplicationDrSecondaryEnableRequest;
}
export interface SystemApiSystemWriteReplicationDrSecondaryMerkleCheckOperationRequest {
    systemWriteReplicationDrSecondaryMerkleCheckRequest: SystemWriteReplicationDrSecondaryMerkleCheckRequest;
}
export interface SystemApiSystemWriteReplicationDrSecondaryOperationTokenDeleteOperationRequest {
    systemWriteReplicationDrSecondaryOperationTokenDeleteRequest: SystemWriteReplicationDrSecondaryOperationTokenDeleteRequest;
}
export interface SystemApiSystemWriteReplicationDrSecondaryPromoteOperationRequest {
    systemWriteReplicationDrSecondaryPromoteRequest: SystemWriteReplicationDrSecondaryPromoteRequest;
}
export interface SystemApiSystemWriteReplicationDrSecondaryRecoverOperationRequest {
    systemWriteReplicationDrSecondaryRecoverRequest: SystemWriteReplicationDrSecondaryRecoverRequest;
}
export interface SystemApiSystemWriteReplicationDrSecondaryReindexOperationRequest {
    systemWriteReplicationDrSecondaryReindexRequest: SystemWriteReplicationDrSecondaryReindexRequest;
}
export interface SystemApiSystemWriteReplicationDrSecondaryUpdatePrimaryOperationRequest {
    systemWriteReplicationDrSecondaryUpdatePrimaryRequest: SystemWriteReplicationDrSecondaryUpdatePrimaryRequest;
}
export interface SystemApiSystemWriteReplicationForceCorruptionOperationRequest {
    systemWriteReplicationForceCorruptionRequest: SystemWriteReplicationForceCorruptionRequest;
}
export interface SystemApiSystemWriteReplicationPerformancePrimaryEnableOperationRequest {
    systemWriteReplicationPerformancePrimaryEnableRequest: SystemWriteReplicationPerformancePrimaryEnableRequest;
}
export interface SystemApiSystemWriteReplicationPerformancePrimaryPathsFilterIdOperationRequest {
    id: string;
    systemWriteReplicationPerformancePrimaryPathsFilterIdRequest: SystemWriteReplicationPerformancePrimaryPathsFilterIdRequest;
}
export interface SystemApiSystemWriteReplicationPerformancePrimaryRevokeSecondaryOperationRequest {
    systemWriteReplicationPerformancePrimaryRevokeSecondaryRequest: SystemWriteReplicationPerformancePrimaryRevokeSecondaryRequest;
}
export interface SystemApiSystemWriteReplicationPerformancePrimarySecondaryTokenOperationRequest {
    systemWriteReplicationPerformancePrimarySecondaryTokenRequest: SystemWriteReplicationPerformancePrimarySecondaryTokenRequest;
}
export interface SystemApiSystemWriteReplicationPerformanceSecondaryEnableOperationRequest {
    systemWriteReplicationPerformanceSecondaryEnableRequest: SystemWriteReplicationPerformanceSecondaryEnableRequest;
}
export interface SystemApiSystemWriteReplicationPerformanceSecondaryPromoteOperationRequest {
    systemWriteReplicationPerformanceSecondaryPromoteRequest: SystemWriteReplicationPerformanceSecondaryPromoteRequest;
}
export interface SystemApiSystemWriteReplicationPerformanceSecondaryUpdatePrimaryOperationRequest {
    systemWriteReplicationPerformanceSecondaryUpdatePrimaryRequest: SystemWriteReplicationPerformanceSecondaryUpdatePrimaryRequest;
}
export interface SystemApiSystemWriteReplicationPrimaryEnableOperationRequest {
    systemWriteReplicationPrimaryEnableRequest: SystemWriteReplicationPrimaryEnableRequest;
}
export interface SystemApiSystemWriteReplicationPrimaryRevokeSecondaryOperationRequest {
    systemWriteReplicationPrimaryRevokeSecondaryRequest: SystemWriteReplicationPrimaryRevokeSecondaryRequest;
}
export interface SystemApiSystemWriteReplicationPrimarySecondaryTokenOperationRequest {
    systemWriteReplicationPrimarySecondaryTokenRequest: SystemWriteReplicationPrimarySecondaryTokenRequest;
}
export interface SystemApiSystemWriteReplicationReindexOperationRequest {
    systemWriteReplicationReindexRequest: SystemWriteReplicationReindexRequest;
}
export interface SystemApiSystemWriteReplicationSecondaryEnableOperationRequest {
    systemWriteReplicationSecondaryEnableRequest: SystemWriteReplicationSecondaryEnableRequest;
}
export interface SystemApiSystemWriteReplicationSecondaryPromoteOperationRequest {
    systemWriteReplicationSecondaryPromoteRequest: SystemWriteReplicationSecondaryPromoteRequest;
}
export interface SystemApiSystemWriteReplicationSecondaryUpdatePrimaryOperationRequest {
    systemWriteReplicationSecondaryUpdatePrimaryRequest: SystemWriteReplicationSecondaryUpdatePrimaryRequest;
}
export interface SystemApiSystemWriteStorageRaftSnapshotAutoConfigNameOperationRequest {
    name: string;
    systemWriteStorageRaftSnapshotAutoConfigNameRequest: SystemWriteStorageRaftSnapshotAutoConfigNameRequest;
}
export interface SystemApiSystemWriteSyncDestinationsAwsSmNameOperationRequest {
    name: string;
    systemWriteSyncDestinationsAwsSmNameRequest: SystemWriteSyncDestinationsAwsSmNameRequest;
}
export interface SystemApiSystemWriteSyncDestinationsAzureKvNameOperationRequest {
    name: string;
    systemWriteSyncDestinationsAzureKvNameRequest: SystemWriteSyncDestinationsAzureKvNameRequest;
}
export interface SystemApiSystemWriteSyncDestinationsGcpSmNameOperationRequest {
    name: string;
    systemWriteSyncDestinationsGcpSmNameRequest: SystemWriteSyncDestinationsGcpSmNameRequest;
}
export interface SystemApiSystemWriteSyncDestinationsGhNameOperationRequest {
    name: string;
    systemWriteSyncDestinationsGhNameRequest: SystemWriteSyncDestinationsGhNameRequest;
}
export interface SystemApiSystemWriteSyncDestinationsInMemNameOperationRequest {
    name: string;
    systemWriteSyncDestinationsInMemNameRequest: SystemWriteSyncDestinationsInMemNameRequest;
}
export interface SystemApiSystemWriteSyncDestinationsTypeNameAssociationsRemoveOperationRequest {
    name: string;
    type: string;
    systemWriteSyncDestinationsTypeNameAssociationsRemoveRequest: SystemWriteSyncDestinationsTypeNameAssociationsRemoveRequest;
}
export interface SystemApiSystemWriteSyncDestinationsTypeNameAssociationsSetOperationRequest {
    name: string;
    type: string;
    systemWriteSyncDestinationsTypeNameAssociationsSetRequest: SystemWriteSyncDestinationsTypeNameAssociationsSetRequest;
}
export interface SystemApiSystemWriteSyncDestinationsVercelProjectNameOperationRequest {
    name: string;
    systemWriteSyncDestinationsVercelProjectNameRequest: SystemWriteSyncDestinationsVercelProjectNameRequest;
}
export interface SystemApiSystemWriteSyncGithubAppsNameOperationRequest {
    name: string;
    systemWriteSyncGithubAppsNameRequest: SystemWriteSyncGithubAppsNameRequest;
}
export interface SystemApiSystemWriteUtilizationOperationRequest {
    systemWriteUtilizationRequest: SystemWriteUtilizationRequest;
}
export interface SystemApiUiConfigDeleteCustomMessageRequest {
    id: string;
}
export interface SystemApiUiConfigListCustomMessagesRequest {
    list: UiConfigListCustomMessagesListEnum;
    active?: boolean;
    authenticated?: boolean;
    type?: string;
}
export interface SystemApiUiConfigReadCustomMessageRequest {
    id: string;
}
export interface SystemApiUiConfigUpdateCustomMessageOperationRequest {
    id: string;
    uiConfigUpdateCustomMessageRequest: UiConfigUpdateCustomMessageRequest;
}
export interface SystemApiUiHeadersConfigureOperationRequest {
    header: string;
    uiHeadersConfigureRequest: UiHeadersConfigureRequest;
}
export interface SystemApiUiHeadersDeleteConfigurationRequest {
    header: string;
}
export interface SystemApiUiHeadersListRequest {
    list: UiHeadersListListEnum;
}
export interface SystemApiUiHeadersReadConfigurationRequest {
    header: string;
}
export interface SystemApiUiLoginDefaultAuthConfigureOperationRequest {
    name: string;
    uiLoginDefaultAuthConfigureRequest: UiLoginDefaultAuthConfigureRequest;
}
export interface SystemApiUiLoginDefaultAuthDeleteConfigurationRequest {
    name: string;
}
export interface SystemApiUiLoginDefaultAuthListRequest {
    list: UiLoginDefaultAuthListListEnum;
}
export interface SystemApiUiLoginDefaultAuthReadConfigurationRequest {
    name: string;
}
export interface SystemApiUnsealOperationRequest {
    unsealRequest: UnsealRequest;
}
export interface SystemApiUnwrapOperationRequest {
    unwrapRequest: UnwrapRequest;
}
export interface SystemApiVersionHistoryRequest {
    list: VersionHistoryListEnum;
}
export interface SystemApiWellKnownListLabelsRequest {
    list: WellKnownListLabelsListEnum;
}
export interface SystemApiWellKnownReadLabelRequest {
    label: string;
}
export interface SystemApiWrapRequest {
    requestBody: {
        [key: string]: any;
    };
}
/**
 *
 */
export declare class SystemApi extends runtime.BaseAPI {
    /**
     * Activate a flagged feature.
     */
    activationFlagsActivateRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Activate a flagged feature.
     */
    activationFlagsActivate(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Activate a flagged feature.
     */
    activationFlagsActivate_1Raw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Activate a flagged feature.
     */
    activationFlagsActivate_1(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Activate a flagged feature.
     */
    activationFlagsActivate_2Raw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Activate a flagged feature.
     */
    activationFlagsActivate_2(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    auditingCalculateHashRaw(requestParameters: SystemApiAuditingCalculateHashOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AuditingCalculateHashResponse>>;
    /**
     */
    auditingCalculateHash(path: string, auditingCalculateHashRequest: AuditingCalculateHashRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AuditingCalculateHashResponse>;
    /**
     * Disable the audit device at the given path.
     */
    auditingDisableDeviceRaw(requestParameters: SystemApiAuditingDisableDeviceRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Disable the audit device at the given path.
     */
    auditingDisableDevice(path: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Disable auditing of the given request header.
     */
    auditingDisableRequestHeaderRaw(requestParameters: SystemApiAuditingDisableRequestHeaderRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Disable auditing of the given request header.
     */
    auditingDisableRequestHeader(header: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Enable a new audit device at the supplied path.
     */
    auditingEnableDeviceRaw(requestParameters: SystemApiAuditingEnableDeviceOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Enable a new audit device at the supplied path.
     */
    auditingEnableDevice(path: string, auditingEnableDeviceRequest: AuditingEnableDeviceRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Enable auditing of a header.
     */
    auditingEnableRequestHeaderRaw(requestParameters: SystemApiAuditingEnableRequestHeaderOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Enable auditing of a header.
     */
    auditingEnableRequestHeader(header: string, auditingEnableRequestHeaderRequest: AuditingEnableRequestHeaderRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * List the enabled audit devices.
     */
    auditingListEnabledDevicesRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * List the enabled audit devices.
     */
    auditingListEnabledDevices(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * List the request headers that are configured to be audited.
     */
    auditingListRequestHeadersRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AuditingListRequestHeadersResponse>>;
    /**
     * List the request headers that are configured to be audited.
     */
    auditingListRequestHeaders(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AuditingListRequestHeadersResponse>;
    /**
     * List the information for the given request header.
     */
    auditingReadRequestHeaderInformationRaw(requestParameters: SystemApiAuditingReadRequestHeaderInformationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * List the information for the given request header.
     */
    auditingReadRequestHeaderInformation(header: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Disable the auth method at the given auth path
     */
    authDisableMethodRaw(requestParameters: SystemApiAuthDisableMethodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Disable the auth method at the given auth path
     */
    authDisableMethod(path: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * After enabling, the auth method can be accessed and configured via the auth path specified as part of the URL. This auth path will be nested under the auth prefix.  For example, enable the \"foo\" auth method will make it accessible at /auth/foo.
     * Enables a new auth method.
     */
    authEnableMethodRaw(requestParameters: SystemApiAuthEnableMethodOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * After enabling, the auth method can be accessed and configured via the auth path specified as part of the URL. This auth path will be nested under the auth prefix.  For example, enable the \"foo\" auth method will make it accessible at /auth/foo.
     * Enables a new auth method.
     */
    authEnableMethod(path: string, authEnableMethodRequest: AuthEnableMethodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    authListEnabledMethodsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    authListEnabledMethods(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read the configuration of the auth engine at the given path.
     */
    authReadConfigurationRaw(requestParameters: SystemApiAuthReadConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AuthReadConfigurationResponse>>;
    /**
     * Read the configuration of the auth engine at the given path.
     */
    authReadConfiguration(path: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AuthReadConfigurationResponse>;
    /**
     * This endpoint requires sudo capability on the final path, but the same functionality can be achieved without sudo via `sys/mounts/auth/[auth-path]/tune`.
     * Reads the given auth path\'s configuration.
     */
    authReadTuningInformationRaw(requestParameters: SystemApiAuthReadTuningInformationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AuthReadTuningInformationResponse>>;
    /**
     * This endpoint requires sudo capability on the final path, but the same functionality can be achieved without sudo via `sys/mounts/auth/[auth-path]/tune`.
     * Reads the given auth path\'s configuration.
     */
    authReadTuningInformation(path: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AuthReadTuningInformationResponse>;
    /**
     * This endpoint requires sudo capability on the final path, but the same functionality can be achieved without sudo via `sys/mounts/auth/[auth-path]/tune`.
     * Tune configuration parameters for a given auth path.
     */
    authTuneConfigurationParametersRaw(requestParameters: SystemApiAuthTuneConfigurationParametersOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * This endpoint requires sudo capability on the final path, but the same functionality can be achieved without sudo via `sys/mounts/auth/[auth-path]/tune`.
     * Tune configuration parameters for a given auth path.
     */
    authTuneConfigurationParameters(path: string, authTuneConfigurationParametersRequest: AuthTuneConfigurationParametersRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Information about the host instance that this Vault server is running on.   The information that gets collected includes host hardware information, and CPU,   disk, and memory utilization
     * Information about the host instance that this Vault server is running on.
     */
    collectHostInformationRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<CollectHostInformationResponse>>;
    /**
     * Information about the host instance that this Vault server is running on.   The information that gets collected includes host hardware information, and CPU,   disk, and memory utilization
     * Information about the host instance that this Vault server is running on.
     */
    collectHostInformation(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<CollectHostInformationResponse>;
    /**
     * This path responds to the following HTTP methods.   GET /    Returns a map of in-flight requests.
     * reports in-flight requests
     */
    collectInFlightRequestInformationRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * This path responds to the following HTTP methods.   GET /    Returns a map of in-flight requests.
     * reports in-flight requests
     */
    collectInFlightRequestInformation(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Configure the CORS settings.
     */
    corsConfigureRaw(requestParameters: SystemApiCorsConfigureOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Configure the CORS settings.
     */
    corsConfigure(corsConfigureRequest: CorsConfigureRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Remove any CORS settings.
     */
    corsDeleteConfigurationRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Remove any CORS settings.
     */
    corsDeleteConfiguration(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Return the current CORS settings.
     */
    corsReadConfigurationRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<CorsReadConfigurationResponse>>;
    /**
     * Return the current CORS settings.
     */
    corsReadConfiguration(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<CorsReadConfigurationResponse>;
    /**
     * Create custom message
     */
    createCustomMessageRaw(requestParameters: SystemApiCreateCustomMessageOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Create custom message
     */
    createCustomMessage(createCustomMessageRequest: CreateCustomMessageRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Decodes the encoded token with the otp.
     */
    decodeTokenRaw(requestParameters: SystemApiDecodeTokenOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Decodes the encoded token with the otp.
     */
    decodeToken(decodeTokenRequest: DecodeTokenRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    encryptionKeyConfigureRotationRaw(requestParameters: SystemApiEncryptionKeyConfigureRotationOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    encryptionKeyConfigureRotation(encryptionKeyConfigureRotationRequest: EncryptionKeyConfigureRotationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    encryptionKeyReadRotationConfigurationRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<EncryptionKeyReadRotationConfigurationResponse>>;
    /**
     */
    encryptionKeyReadRotationConfiguration(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<EncryptionKeyReadRotationConfigurationResponse>;
    /**
     */
    encryptionKeyRotateRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    encryptionKeyRotate(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Provides information about the backend encryption key.
     */
    encryptionKeyStatusRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Provides information about the backend encryption key.
     */
    encryptionKeyStatus(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    generateHashRaw(requestParameters: SystemApiGenerateHashOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GenerateHashResponse>>;
    /**
     */
    generateHash(generateHashRequest: GenerateHashRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GenerateHashResponse>;
    /**
     */
    generateHashWithAlgorithmRaw(requestParameters: SystemApiGenerateHashWithAlgorithmOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GenerateHashWithAlgorithmResponse>>;
    /**
     */
    generateHashWithAlgorithm(urlalgorithm: string, generateHashWithAlgorithmRequest: GenerateHashWithAlgorithmRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GenerateHashWithAlgorithmResponse>;
    /**
     */
    generateRandomRaw(requestParameters: SystemApiGenerateRandomOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GenerateRandomResponse>>;
    /**
     */
    generateRandom(generateRandomRequest: GenerateRandomRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GenerateRandomResponse>;
    /**
     */
    generateRandomWithBytesRaw(requestParameters: SystemApiGenerateRandomWithBytesOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GenerateRandomWithBytesResponse>>;
    /**
     */
    generateRandomWithBytes(urlbytes: string, generateRandomWithBytesRequest: GenerateRandomWithBytesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GenerateRandomWithBytesResponse>;
    /**
     */
    generateRandomWithSourceRaw(requestParameters: SystemApiGenerateRandomWithSourceOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GenerateRandomWithSourceResponse>>;
    /**
     */
    generateRandomWithSource(source: string, generateRandomWithSourceRequest: GenerateRandomWithSourceRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GenerateRandomWithSourceResponse>;
    /**
     */
    generateRandomWithSourceAndBytesRaw(requestParameters: SystemApiGenerateRandomWithSourceAndBytesOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GenerateRandomWithSourceAndBytesResponse>>;
    /**
     */
    generateRandomWithSourceAndBytes(source: string, urlbytes: string, generateRandomWithSourceAndBytesRequest: GenerateRandomWithSourceAndBytesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GenerateRandomWithSourceAndBytesResponse>;
    /**
     */
    generateUtilizationReportRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<GenerateUtilizationReportResponse>>;
    /**
     */
    generateUtilizationReport(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<GenerateUtilizationReportResponse>;
    /**
     * Check the HA status of a Vault cluster
     */
    haStatusRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<HaStatusResponse>>;
    /**
     * Check the HA status of a Vault cluster
     */
    haStatus(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<HaStatusResponse>;
    /**
     * The Vault must not have been previously initialized. The recovery options, as well as the stored shares option, are only available when using Vault HSM.
     * Initialize a new Vault.
     */
    initializeRaw(requestParameters: SystemApiInitializeOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * The Vault must not have been previously initialized. The recovery options, as well as the stored shares option, are only available when using Vault HSM.
     * Initialize a new Vault.
     */
    initialize(initializeRequest: InitializeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Enable or disable collection of client count, set retention period, or set default reporting period.
     */
    internalClientActivityConfigureRaw(requestParameters: SystemApiInternalClientActivityConfigureOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Enable or disable collection of client count, set retention period, or set default reporting period.
     */
    internalClientActivityConfigure(internalClientActivityConfigureRequest: InternalClientActivityConfigureRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Report the client count metrics, for this namespace and all child namespaces.
     */
    internalClientActivityExportRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Report the client count metrics, for this namespace and all child namespaces.
     */
    internalClientActivityExport(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read the client count tracking configuration.
     */
    internalClientActivityReadConfigurationRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read the client count tracking configuration.
     */
    internalClientActivityReadConfiguration(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Report the client count metrics, for this namespace and all child namespaces.
     */
    internalClientActivityReportCountsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Report the client count metrics, for this namespace and all child namespaces.
     */
    internalClientActivityReportCounts(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Report the number of clients for this month, for this namespace and all child namespaces.
     */
    internalClientActivityReportCountsThisMonthRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Report the number of clients for this month, for this namespace and all child namespaces.
     */
    internalClientActivityReportCountsThisMonth(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Backwards compatibility is not guaranteed for this API
     */
    internalCountEntitiesRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<InternalCountEntitiesResponse>>;
    /**
     * Backwards compatibility is not guaranteed for this API
     */
    internalCountEntities(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<InternalCountEntitiesResponse>;
    /**
     * Backwards compatibility is not guaranteed for this API
     * @deprecated
     */
    internalCountRequestsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Backwards compatibility is not guaranteed for this API
     * @deprecated
     */
    internalCountRequests(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    internalGenerateOpenApiDocumentRaw(requestParameters: SystemApiInternalGenerateOpenApiDocumentRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    internalGenerateOpenApiDocument(context?: string, genericMountPaths?: boolean, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    internalGenerateOpenApiDocumentWithParametersRaw(requestParameters: SystemApiInternalGenerateOpenApiDocumentWithParametersOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    internalGenerateOpenApiDocumentWithParameters(internalGenerateOpenApiDocumentWithParametersRequest: InternalGenerateOpenApiDocumentWithParametersRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Expose the route entry and mount entry tables present in the router
     */
    internalInspectRouterRaw(requestParameters: SystemApiInternalInspectRouterRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Expose the route entry and mount entry tables present in the router
     */
    internalInspectRouter(tag: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Lists enabled feature flags.
     */
    internalUiListEnabledFeatureFlagsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<InternalUiListEnabledFeatureFlagsResponse>>;
    /**
     * Lists enabled feature flags.
     */
    internalUiListEnabledFeatureFlags(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<InternalUiListEnabledFeatureFlagsResponse>;
    /**
     * Lists all enabled and visible auth and secrets mounts.
     */
    internalUiListEnabledVisibleMountsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<InternalUiListEnabledVisibleMountsResponse>>;
    /**
     * Lists all enabled and visible auth and secrets mounts.
     */
    internalUiListEnabledVisibleMounts(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<InternalUiListEnabledVisibleMountsResponse>;
    /**
     * Backwards compatibility is not guaranteed for this API
     */
    internalUiListNamespacesRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<InternalUiListNamespacesResponse>>;
    /**
     * Backwards compatibility is not guaranteed for this API
     */
    internalUiListNamespaces(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<InternalUiListNamespacesResponse>;
    /**
     * Retrieves Active post-login Custom Messages
     */
    internalUiReadAuthenticatedActiveCustomMessagesRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<InternalUiReadAuthenticatedActiveCustomMessagesResponse>>;
    /**
     * Retrieves Active post-login Custom Messages
     */
    internalUiReadAuthenticatedActiveCustomMessages(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<InternalUiReadAuthenticatedActiveCustomMessagesResponse>;
    /**
     * Return information about the given mount.
     */
    internalUiReadMountInformationRaw(requestParameters: SystemApiInternalUiReadMountInformationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<InternalUiReadMountInformationResponse>>;
    /**
     * Return information about the given mount.
     */
    internalUiReadMountInformation(path: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<InternalUiReadMountInformationResponse>;
    /**
     * Backwards compatibility is not guaranteed for this API
     */
    internalUiReadResultantAclRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<InternalUiReadResultantAclResponse>>;
    /**
     * Backwards compatibility is not guaranteed for this API
     */
    internalUiReadResultantAcl(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<InternalUiReadResultantAclResponse | null | undefined>;
    /**
     * Retrieves Active pre-login Custom Messages
     */
    internalUiReadUnauthenticatedActiveCustomMessagesRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<InternalUiReadUnauthenticatedActiveCustomMessagesResponse>>;
    /**
     * Retrieves Active pre-login Custom Messages
     */
    internalUiReadUnauthenticatedActiveCustomMessages(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<InternalUiReadUnauthenticatedActiveCustomMessagesResponse>;
    /**
     * Returns the high availability status and current leader instance of Vault.
     */
    leaderStatusRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<LeaderStatusResponse>>;
    /**
     * Returns the high availability status and current leader instance of Vault.
     */
    leaderStatus(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<LeaderStatusResponse>;
    /**
     */
    leasesCountRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<LeasesCountResponse>>;
    /**
     */
    leasesCount(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<LeasesCountResponse>;
    /**
     * Unlike `/sys/leases/revoke-prefix`, this path ignores backend errors encountered during revocation. This is potentially very dangerous and should only be used in specific emergency situations where errors in the backend or the connected backend service prevent normal revocation.  By ignoring these errors, Vault abdicates responsibility for ensuring that the issued credentials or secrets are properly revoked and/or cleaned up. Access to this endpoint should be tightly controlled.
     * Revokes all secrets or tokens generated under a given prefix immediately
     */
    leasesForceRevokeLeaseWithPrefixRaw(requestParameters: SystemApiLeasesForceRevokeLeaseWithPrefixRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Unlike `/sys/leases/revoke-prefix`, this path ignores backend errors encountered during revocation. This is potentially very dangerous and should only be used in specific emergency situations where errors in the backend or the connected backend service prevent normal revocation.  By ignoring these errors, Vault abdicates responsibility for ensuring that the issued credentials or secrets are properly revoked and/or cleaned up. Access to this endpoint should be tightly controlled.
     * Revokes all secrets or tokens generated under a given prefix immediately
     */
    leasesForceRevokeLeaseWithPrefix(prefix: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Unlike `/sys/leases/revoke-prefix`, this path ignores backend errors encountered during revocation. This is potentially very dangerous and should only be used in specific emergency situations where errors in the backend or the connected backend service prevent normal revocation.  By ignoring these errors, Vault abdicates responsibility for ensuring that the issued credentials or secrets are properly revoked and/or cleaned up. Access to this endpoint should be tightly controlled.
     * Revokes all secrets or tokens generated under a given prefix immediately
     */
    leasesForceRevokeLeaseWithPrefix2Raw(requestParameters: SystemApiLeasesForceRevokeLeaseWithPrefix2Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Unlike `/sys/leases/revoke-prefix`, this path ignores backend errors encountered during revocation. This is potentially very dangerous and should only be used in specific emergency situations where errors in the backend or the connected backend service prevent normal revocation.  By ignoring these errors, Vault abdicates responsibility for ensuring that the issued credentials or secrets are properly revoked and/or cleaned up. Access to this endpoint should be tightly controlled.
     * Revokes all secrets or tokens generated under a given prefix immediately
     */
    leasesForceRevokeLeaseWithPrefix2(prefix: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    leasesListRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<LeasesListResponse>>;
    /**
     */
    leasesList(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<LeasesListResponse>;
    /**
     */
    leasesLookUpRaw(requestParameters: SystemApiLeasesLookUpRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<LeasesLookUpResponse>>;
    /**
     */
    leasesLookUp(prefix: string, list: LeasesLookUpListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<LeasesLookUpResponse>;
    /**
     */
    leasesReadLeaseRaw(requestParameters: SystemApiLeasesReadLeaseOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<LeasesReadLeaseResponse>>;
    /**
     */
    leasesReadLease(leasesReadLeaseRequest: LeasesReadLeaseRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<LeasesReadLeaseResponse>;
    /**
     * Renews a lease, requesting to extend the lease.
     */
    leasesRenewLeaseRaw(requestParameters: SystemApiLeasesRenewLeaseOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Renews a lease, requesting to extend the lease.
     */
    leasesRenewLease(leasesRenewLeaseRequest: LeasesRenewLeaseRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Renews a lease, requesting to extend the lease.
     */
    leasesRenewLease2Raw(requestParameters: SystemApiLeasesRenewLease2OperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Renews a lease, requesting to extend the lease.
     */
    leasesRenewLease2(leasesRenewLease2Request: LeasesRenewLease2Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Renews a lease, requesting to extend the lease.
     */
    leasesRenewLeaseWithIdRaw(requestParameters: SystemApiLeasesRenewLeaseWithIdOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Renews a lease, requesting to extend the lease.
     */
    leasesRenewLeaseWithId(urlLeaseId: string, leasesRenewLeaseWithIdRequest: LeasesRenewLeaseWithIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Renews a lease, requesting to extend the lease.
     */
    leasesRenewLeaseWithId2Raw(requestParameters: SystemApiLeasesRenewLeaseWithId2OperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Renews a lease, requesting to extend the lease.
     */
    leasesRenewLeaseWithId2(urlLeaseId: string, leasesRenewLeaseWithId2Request: LeasesRenewLeaseWithId2Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Revokes a lease immediately.
     */
    leasesRevokeLeaseRaw(requestParameters: SystemApiLeasesRevokeLeaseOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Revokes a lease immediately.
     */
    leasesRevokeLease(leasesRevokeLeaseRequest: LeasesRevokeLeaseRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Revokes a lease immediately.
     */
    leasesRevokeLease2Raw(requestParameters: SystemApiLeasesRevokeLease2OperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Revokes a lease immediately.
     */
    leasesRevokeLease2(leasesRevokeLease2Request: LeasesRevokeLease2Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Revokes a lease immediately.
     */
    leasesRevokeLeaseWithIdRaw(requestParameters: SystemApiLeasesRevokeLeaseWithIdOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Revokes a lease immediately.
     */
    leasesRevokeLeaseWithId(urlLeaseId: string, leasesRevokeLeaseWithIdRequest: LeasesRevokeLeaseWithIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Revokes a lease immediately.
     */
    leasesRevokeLeaseWithId2Raw(requestParameters: SystemApiLeasesRevokeLeaseWithId2OperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Revokes a lease immediately.
     */
    leasesRevokeLeaseWithId2(urlLeaseId: string, leasesRevokeLeaseWithId2Request: LeasesRevokeLeaseWithId2Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Revokes all secrets (via a lease ID prefix) or tokens (via the tokens\' path property) generated under a given prefix immediately.
     */
    leasesRevokeLeaseWithPrefixRaw(requestParameters: SystemApiLeasesRevokeLeaseWithPrefixOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Revokes all secrets (via a lease ID prefix) or tokens (via the tokens\' path property) generated under a given prefix immediately.
     */
    leasesRevokeLeaseWithPrefix(prefix: string, leasesRevokeLeaseWithPrefixRequest: LeasesRevokeLeaseWithPrefixRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Revokes all secrets (via a lease ID prefix) or tokens (via the tokens\' path property) generated under a given prefix immediately.
     */
    leasesRevokeLeaseWithPrefix2Raw(requestParameters: SystemApiLeasesRevokeLeaseWithPrefix2OperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Revokes all secrets (via a lease ID prefix) or tokens (via the tokens\' path property) generated under a given prefix immediately.
     */
    leasesRevokeLeaseWithPrefix2(prefix: string, leasesRevokeLeaseWithPrefix2Request: LeasesRevokeLeaseWithPrefix2Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    leasesTidyRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    leasesTidy(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Returns the available and enabled experiments
     */
    listExperimentalFeaturesRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Returns the available and enabled experiments
     */
    listExperimentalFeatures(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Report the locked user count metrics, for this namespace and all child namespaces.
     */
    lockedUsersListRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Report the locked user count metrics, for this namespace and all child namespaces.
     */
    lockedUsersList(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Unlocks the user with given mount_accessor and alias_identifier
     */
    lockedUsersUnlockRaw(requestParameters: SystemApiLockedUsersUnlockRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Unlocks the user with given mount_accessor and alias_identifier
     */
    lockedUsersUnlock(aliasIdentifier: string, mountAccessor: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read the log level for all existing loggers.
     */
    loggersReadVerbosityLevelRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read the log level for all existing loggers.
     */
    loggersReadVerbosityLevel(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read the log level for a single logger.
     */
    loggersReadVerbosityLevelForRaw(requestParameters: SystemApiLoggersReadVerbosityLevelForRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read the log level for a single logger.
     */
    loggersReadVerbosityLevelFor(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Revert the all loggers to use log level provided in config.
     */
    loggersRevertVerbosityLevelRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Revert the all loggers to use log level provided in config.
     */
    loggersRevertVerbosityLevel(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Revert a single logger to use log level provided in config.
     */
    loggersRevertVerbosityLevelForRaw(requestParameters: SystemApiLoggersRevertVerbosityLevelForRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Revert a single logger to use log level provided in config.
     */
    loggersRevertVerbosityLevelFor(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Modify the log level for all existing loggers.
     */
    loggersUpdateVerbosityLevelRaw(requestParameters: SystemApiLoggersUpdateVerbosityLevelOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Modify the log level for all existing loggers.
     */
    loggersUpdateVerbosityLevel(loggersUpdateVerbosityLevelRequest: LoggersUpdateVerbosityLevelRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Modify the log level of a single logger.
     */
    loggersUpdateVerbosityLevelForRaw(requestParameters: SystemApiLoggersUpdateVerbosityLevelForOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Modify the log level of a single logger.
     */
    loggersUpdateVerbosityLevelFor(name: string, loggersUpdateVerbosityLevelForRequest: LoggersUpdateVerbosityLevelForRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    metricsRaw(requestParameters: SystemApiMetricsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    metrics(format?: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Validates the login for the given MFA methods. Upon successful validation, it returns an auth response containing the client token
     */
    mfaValidateRaw(requestParameters: SystemApiMfaValidateOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Validates the login for the given MFA methods. Upon successful validation, it returns an auth response containing the client token
     */
    mfaValidate(mfaValidateRequest: MfaValidateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    monitorRaw(requestParameters: SystemApiMonitorRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    monitor(logFormat?: string, logLevel?: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Disable the mount point specified at the given path.
     */
    mountsDisableSecretsEngineRaw(requestParameters: SystemApiMountsDisableSecretsEngineRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Disable the mount point specified at the given path.
     */
    mountsDisableSecretsEngine(path: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Enable a new secrets engine at the given path.
     */
    mountsEnableSecretsEngineRaw(requestParameters: SystemApiMountsEnableSecretsEngineOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Enable a new secrets engine at the given path.
     */
    mountsEnableSecretsEngine(path: string, mountsEnableSecretsEngineRequest: MountsEnableSecretsEngineRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    mountsListSecretsEnginesRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    mountsListSecretsEngines(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read the configuration of the secret engine at the given path.
     */
    mountsReadConfigurationRaw(requestParameters: SystemApiMountsReadConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<MountsReadConfigurationResponse>>;
    /**
     * Read the configuration of the secret engine at the given path.
     */
    mountsReadConfiguration(path: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<MountsReadConfigurationResponse>;
    /**
     */
    mountsReadTuningInformationRaw(requestParameters: SystemApiMountsReadTuningInformationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<MountsReadTuningInformationResponse>>;
    /**
     */
    mountsReadTuningInformation(path: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<MountsReadTuningInformationResponse>;
    /**
     */
    mountsTuneConfigurationParametersRaw(requestParameters: SystemApiMountsTuneConfigurationParametersOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    mountsTuneConfigurationParameters(path: string, mountsTuneConfigurationParametersRequest: MountsTuneConfigurationParametersRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    pluginsCatalogListPluginsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PluginsCatalogListPluginsResponse>>;
    /**
     */
    pluginsCatalogListPlugins(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PluginsCatalogListPluginsResponse>;
    /**
     * List the plugins in the catalog.
     */
    pluginsCatalogListPluginsWithTypeRaw(requestParameters: SystemApiPluginsCatalogListPluginsWithTypeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PluginsCatalogListPluginsWithTypeResponse>>;
    /**
     * List the plugins in the catalog.
     */
    pluginsCatalogListPluginsWithType(type: string, list: PluginsCatalogListPluginsWithTypeListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PluginsCatalogListPluginsWithTypeResponse>;
    /**
     * Create or update the pinned version for a plugin with a given type and name.
     */
    pluginsCatalogPinsCreatePinnedVersionRaw(requestParameters: SystemApiPluginsCatalogPinsCreatePinnedVersionOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Create or update the pinned version for a plugin with a given type and name.
     */
    pluginsCatalogPinsCreatePinnedVersion(name: string, type: string, pluginsCatalogPinsCreatePinnedVersionRequest: PluginsCatalogPinsCreatePinnedVersionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    pluginsCatalogPinsListPinnedVersionsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PluginsCatalogPinsListPinnedVersionsResponse>>;
    /**
     */
    pluginsCatalogPinsListPinnedVersions(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PluginsCatalogPinsListPinnedVersionsResponse>;
    /**
     * Return the pinned version for the plugin with the given type and name.
     */
    pluginsCatalogPinsReadPinnedVersionRaw(requestParameters: SystemApiPluginsCatalogPinsReadPinnedVersionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PluginsCatalogPinsReadPinnedVersionResponse>>;
    /**
     * Return the pinned version for the plugin with the given type and name.
     */
    pluginsCatalogPinsReadPinnedVersion(name: string, type: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PluginsCatalogPinsReadPinnedVersionResponse>;
    /**
     * Remove any pinned version for the plugin with the given type and name.
     */
    pluginsCatalogPinsRemovePinnedVersionRaw(requestParameters: SystemApiPluginsCatalogPinsRemovePinnedVersionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Remove any pinned version for the plugin with the given type and name.
     */
    pluginsCatalogPinsRemovePinnedVersion(name: string, type: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Return the configuration data for the plugin with the given name.
     */
    pluginsCatalogReadPluginConfigurationRaw(requestParameters: SystemApiPluginsCatalogReadPluginConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PluginsCatalogReadPluginConfigurationResponse>>;
    /**
     * Return the configuration data for the plugin with the given name.
     */
    pluginsCatalogReadPluginConfiguration(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PluginsCatalogReadPluginConfigurationResponse>;
    /**
     * Return the configuration data for the plugin with the given name.
     */
    pluginsCatalogReadPluginConfigurationWithTypeRaw(requestParameters: SystemApiPluginsCatalogReadPluginConfigurationWithTypeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PluginsCatalogReadPluginConfigurationWithTypeResponse>>;
    /**
     * Return the configuration data for the plugin with the given name.
     */
    pluginsCatalogReadPluginConfigurationWithType(name: string, type: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PluginsCatalogReadPluginConfigurationWithTypeResponse>;
    /**
     * Register a new plugin, or updates an existing one with the supplied name.
     */
    pluginsCatalogRegisterPluginRaw(requestParameters: SystemApiPluginsCatalogRegisterPluginOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Register a new plugin, or updates an existing one with the supplied name.
     */
    pluginsCatalogRegisterPlugin(name: string, pluginsCatalogRegisterPluginRequest: PluginsCatalogRegisterPluginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Register a new plugin, or updates an existing one with the supplied name.
     */
    pluginsCatalogRegisterPluginWithTypeRaw(requestParameters: SystemApiPluginsCatalogRegisterPluginWithTypeOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Register a new plugin, or updates an existing one with the supplied name.
     */
    pluginsCatalogRegisterPluginWithType(name: string, type: string, pluginsCatalogRegisterPluginWithTypeRequest: PluginsCatalogRegisterPluginWithTypeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Remove the plugin with the given name.
     */
    pluginsCatalogRemovePluginRaw(requestParameters: SystemApiPluginsCatalogRemovePluginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Remove the plugin with the given name.
     */
    pluginsCatalogRemovePlugin(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Remove the plugin with the given name.
     */
    pluginsCatalogRemovePluginWithTypeRaw(requestParameters: SystemApiPluginsCatalogRemovePluginWithTypeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Remove the plugin with the given name.
     */
    pluginsCatalogRemovePluginWithType(name: string, type: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Either the plugin name (`plugin`) or the desired plugin backend mounts (`mounts`) must be provided, but not both. In the case that the plugin name is provided, all mounted paths that use that plugin backend will be reloaded.  If (`scope`) is provided and is (`global`), the plugin(s) are reloaded globally.
     * Reload mounted plugin backends.
     */
    pluginsReloadBackendsRaw(requestParameters: SystemApiPluginsReloadBackendsOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PluginsReloadBackendsResponse>>;
    /**
     * Either the plugin name (`plugin`) or the desired plugin backend mounts (`mounts`) must be provided, but not both. In the case that the plugin name is provided, all mounted paths that use that plugin backend will be reloaded.  If (`scope`) is provided and is (`global`), the plugin(s) are reloaded globally.
     * Reload mounted plugin backends.
     */
    pluginsReloadBackends(pluginsReloadBackendsRequest: PluginsReloadBackendsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PluginsReloadBackendsResponse>;
    /**
     */
    pluginsRuntimesCatalogListPluginsRuntimesRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PluginsRuntimesCatalogListPluginsRuntimesResponse>>;
    /**
     */
    pluginsRuntimesCatalogListPluginsRuntimes(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PluginsRuntimesCatalogListPluginsRuntimesResponse>;
    /**
     */
    pluginsRuntimesCatalogListPluginsRuntimes_3Raw(requestParameters: SystemApiPluginsRuntimesCatalogListPluginsRuntimes0Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PluginsRuntimesCatalogListPluginsRuntimesResponse>>;
    /**
     */
    pluginsRuntimesCatalogListPluginsRuntimes_3(list: PluginsRuntimesCatalogListPluginsRuntimes0ListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PluginsRuntimesCatalogListPluginsRuntimesResponse>;
    /**
     * Return the configuration data for the plugin runtime with the given name.
     */
    pluginsRuntimesCatalogReadPluginRuntimeConfigurationRaw(requestParameters: SystemApiPluginsRuntimesCatalogReadPluginRuntimeConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PluginsRuntimesCatalogReadPluginRuntimeConfigurationResponse>>;
    /**
     * Return the configuration data for the plugin runtime with the given name.
     */
    pluginsRuntimesCatalogReadPluginRuntimeConfiguration(name: string, type: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PluginsRuntimesCatalogReadPluginRuntimeConfigurationResponse>;
    /**
     * Register a new plugin runtime, or updates an existing one with the supplied name.
     */
    pluginsRuntimesCatalogRegisterPluginRuntimeRaw(requestParameters: SystemApiPluginsRuntimesCatalogRegisterPluginRuntimeOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Register a new plugin runtime, or updates an existing one with the supplied name.
     */
    pluginsRuntimesCatalogRegisterPluginRuntime(name: string, type: string, pluginsRuntimesCatalogRegisterPluginRuntimeRequest: PluginsRuntimesCatalogRegisterPluginRuntimeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Remove the plugin runtime with the given name.
     */
    pluginsRuntimesCatalogRemovePluginRuntimeRaw(requestParameters: SystemApiPluginsRuntimesCatalogRemovePluginRuntimeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Remove the plugin runtime with the given name.
     */
    pluginsRuntimesCatalogRemovePluginRuntime(name: string, type: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Delete the ACL policy with the given name.
     */
    policiesDeleteAclPolicyRaw(requestParameters: SystemApiPoliciesDeleteAclPolicyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Delete the ACL policy with the given name.
     */
    policiesDeleteAclPolicy(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Delete the policy with the given name.
     */
    policiesDeleteAclPolicy2Raw(requestParameters: SystemApiPoliciesDeleteAclPolicy2Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Delete the policy with the given name.
     */
    policiesDeleteAclPolicy2(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Delete a password policy.
     */
    policiesDeletePasswordPolicyRaw(requestParameters: SystemApiPoliciesDeletePasswordPolicyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Delete a password policy.
     */
    policiesDeletePasswordPolicy(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Generate a password from an existing password policy.
     */
    policiesGeneratePasswordFromPasswordPolicyRaw(requestParameters: SystemApiPoliciesGeneratePasswordFromPasswordPolicyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PoliciesGeneratePasswordFromPasswordPolicyResponse>>;
    /**
     * Generate a password from an existing password policy.
     */
    policiesGeneratePasswordFromPasswordPolicy(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PoliciesGeneratePasswordFromPasswordPolicyResponse>;
    /**
     */
    policiesListAclPoliciesRaw(requestParameters: SystemApiPoliciesListAclPoliciesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PoliciesListAclPoliciesResponse>>;
    /**
     */
    policiesListAclPolicies(list: PoliciesListAclPoliciesListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PoliciesListAclPoliciesResponse>;
    /**
     */
    policiesListAclPolicies2Raw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PoliciesListAclPolicies2Response>>;
    /**
     */
    policiesListAclPolicies2(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PoliciesListAclPolicies2Response>;
    /**
     */
    policiesListAclPolicies3Raw(requestParameters: SystemApiPoliciesListAclPolicies3Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PoliciesListAclPolicies3Response>>;
    /**
     */
    policiesListAclPolicies3(list: PoliciesListAclPolicies3ListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PoliciesListAclPolicies3Response>;
    /**
     * List the existing password policies.
     */
    policiesListPasswordPoliciesRaw(requestParameters: SystemApiPoliciesListPasswordPoliciesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * List the existing password policies.
     */
    policiesListPasswordPolicies(list: PoliciesListPasswordPoliciesListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * Retrieve information about the named ACL policy.
     */
    policiesReadAclPolicyRaw(requestParameters: SystemApiPoliciesReadAclPolicyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PoliciesReadAclPolicyResponse>>;
    /**
     * Retrieve information about the named ACL policy.
     */
    policiesReadAclPolicy(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PoliciesReadAclPolicyResponse>;
    /**
     * Retrieve the policy body for the named policy.
     */
    policiesReadAclPolicy2Raw(requestParameters: SystemApiPoliciesReadAclPolicy2Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PoliciesReadAclPolicy2Response>>;
    /**
     * Retrieve the policy body for the named policy.
     */
    policiesReadAclPolicy2(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PoliciesReadAclPolicy2Response>;
    /**
     * Retrieve an existing password policy.
     */
    policiesReadPasswordPolicyRaw(requestParameters: SystemApiPoliciesReadPasswordPolicyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<PoliciesReadPasswordPolicyResponse>>;
    /**
     * Retrieve an existing password policy.
     */
    policiesReadPasswordPolicy(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<PoliciesReadPasswordPolicyResponse>;
    /**
     * Add a new or update an existing ACL policy.
     */
    policiesWriteAclPolicyRaw(requestParameters: SystemApiPoliciesWriteAclPolicyOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Add a new or update an existing ACL policy.
     */
    policiesWriteAclPolicy(name: string, policiesWriteAclPolicyRequest: PoliciesWriteAclPolicyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Add a new or update an existing policy.
     */
    policiesWriteAclPolicy2Raw(requestParameters: SystemApiPoliciesWriteAclPolicy2OperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Add a new or update an existing policy.
     */
    policiesWriteAclPolicy2(name: string, policiesWriteAclPolicy2Request: PoliciesWriteAclPolicy2Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Add a new or update an existing password policy.
     */
    policiesWritePasswordPolicyRaw(requestParameters: SystemApiPoliciesWritePasswordPolicyOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Add a new or update an existing password policy.
     */
    policiesWritePasswordPolicy(name: string, policiesWritePasswordPolicyRequest: PoliciesWritePasswordPolicyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Returns stack traces that led to blocking on synchronization primitives
     * Returns stack traces that led to blocking on synchronization primitives
     */
    pprofBlockingRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Returns stack traces that led to blocking on synchronization primitives
     * Returns stack traces that led to blocking on synchronization primitives
     */
    pprofBlocking(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Returns the running program\'s command line, with arguments separated by NUL bytes.
     * Returns the running program\'s command line.
     */
    pprofCommandLineRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Returns the running program\'s command line, with arguments separated by NUL bytes.
     * Returns the running program\'s command line.
     */
    pprofCommandLine(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Returns a pprof-formatted cpu profile payload. Profiling lasts for duration specified in seconds GET parameter, or for 30 seconds if not specified.
     * Returns a pprof-formatted cpu profile payload.
     */
    pprofCpuProfileRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Returns a pprof-formatted cpu profile payload. Profiling lasts for duration specified in seconds GET parameter, or for 30 seconds if not specified.
     * Returns a pprof-formatted cpu profile payload.
     */
    pprofCpuProfile(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Returns  the execution trace in binary form. Tracing lasts for duration specified in seconds GET parameter, or for 1 second if not specified.
     * Returns the execution trace in binary form.
     */
    pprofExecutionTraceRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Returns  the execution trace in binary form. Tracing lasts for duration specified in seconds GET parameter, or for 1 second if not specified.
     * Returns the execution trace in binary form.
     */
    pprofExecutionTrace(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Returns stack traces of all current goroutines.
     * Returns stack traces of all current goroutines.
     */
    pprofGoroutinesRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Returns stack traces of all current goroutines.
     * Returns stack traces of all current goroutines.
     */
    pprofGoroutines(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Returns an HTML page listing the available  profiles. This should be mainly accessed via browsers or applications that can  render pages.
     * Returns an HTML page listing the available profiles.
     */
    pprofIndexRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Returns an HTML page listing the available  profiles. This should be mainly accessed via browsers or applications that can  render pages.
     * Returns an HTML page listing the available profiles.
     */
    pprofIndex(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Returns a sampling of all past memory allocations.
     * Returns a sampling of all past memory allocations.
     */
    pprofMemoryAllocationsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Returns a sampling of all past memory allocations.
     * Returns a sampling of all past memory allocations.
     */
    pprofMemoryAllocations(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Returns a sampling of memory allocations of live object.
     * Returns a sampling of memory allocations of live object.
     */
    pprofMemoryAllocationsLiveRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Returns a sampling of memory allocations of live object.
     * Returns a sampling of memory allocations of live object.
     */
    pprofMemoryAllocationsLive(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Returns stack traces of holders of contended mutexes
     * Returns stack traces of holders of contended mutexes
     */
    pprofMutexesRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Returns stack traces of holders of contended mutexes
     * Returns stack traces of holders of contended mutexes
     */
    pprofMutexes(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Returns the program counters listed in the request.
     * Returns the program counters listed in the request.
     */
    pprofSymbolsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Returns the program counters listed in the request.
     * Returns the program counters listed in the request.
     */
    pprofSymbols(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Returns stack traces that led to the creation of new OS threads
     * Returns stack traces that led to the creation of new OS threads
     */
    pprofThreadCreationsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Returns stack traces that led to the creation of new OS threads
     * Returns stack traces that led to the creation of new OS threads
     */
    pprofThreadCreations(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    queryTokenAccessorCapabilitiesRaw(requestParameters: SystemApiQueryTokenAccessorCapabilitiesOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    queryTokenAccessorCapabilities(queryTokenAccessorCapabilitiesRequest: QueryTokenAccessorCapabilitiesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    queryTokenCapabilitiesRaw(requestParameters: SystemApiQueryTokenCapabilitiesOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    queryTokenCapabilities(queryTokenCapabilitiesRequest: QueryTokenCapabilitiesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    queryTokenSelfCapabilitiesRaw(requestParameters: SystemApiQueryTokenSelfCapabilitiesOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    queryTokenSelfCapabilities(queryTokenSelfCapabilitiesRequest: QueryTokenSelfCapabilitiesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    rateLimitQuotasConfigureRaw(requestParameters: SystemApiRateLimitQuotasConfigureOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    rateLimitQuotasConfigure(rateLimitQuotasConfigureRequest: RateLimitQuotasConfigureRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    rateLimitQuotasDeleteRaw(requestParameters: SystemApiRateLimitQuotasDeleteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    rateLimitQuotasDelete(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    rateLimitQuotasListRaw(requestParameters: SystemApiRateLimitQuotasListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    rateLimitQuotasList(list: RateLimitQuotasListListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    rateLimitQuotasReadRaw(requestParameters: SystemApiRateLimitQuotasReadRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RateLimitQuotasReadResponse>>;
    /**
     */
    rateLimitQuotasRead(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RateLimitQuotasReadResponse>;
    /**
     */
    rateLimitQuotasReadConfigurationRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RateLimitQuotasReadConfigurationResponse>>;
    /**
     */
    rateLimitQuotasReadConfiguration(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RateLimitQuotasReadConfigurationResponse>;
    /**
     */
    rateLimitQuotasWriteRaw(requestParameters: SystemApiRateLimitQuotasWriteOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    rateLimitQuotasWrite(name: string, rateLimitQuotasWriteRequest: RateLimitQuotasWriteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Delete the key with given path.
     */
    rawDeleteRaw(requestParameters: SystemApiRawDeleteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Delete the key with given path.
     */
    rawDelete(path: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Return a list keys for a given path prefix.
     */
    rawListRaw(requestParameters: SystemApiRawListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * Return a list keys for a given path prefix.
     */
    rawList(path: string, list: RawListListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * Read the value of the key at the given path.
     */
    rawReadRaw(requestParameters: SystemApiRawReadRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RawReadResponse>>;
    /**
     * Read the value of the key at the given path.
     */
    rawRead(path: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RawReadResponse>;
    /**
     * Update the value of the key at the given path.
     */
    rawWriteRaw(requestParameters: SystemApiRawWriteOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Update the value of the key at the given path.
     */
    rawWrite(path: string, rawWriteRequest: RawWriteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Returns the available and activated activation-flagged features.
     */
    readActivationFlagsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Returns the available and activated activation-flagged features.
     */
    readActivationFlags(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Returns the health status of Vault.
     */
    readHealthStatusRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Returns the health status of Vault.
     */
    readHealthStatus(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Returns the initialization status of Vault.
     */
    readInitializationStatusRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Returns the initialization status of Vault.
     */
    readInitializationStatus(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * The sanitized output strips configuration values in the storage, HA storage, and seals stanzas, which may contain sensitive values such as API tokens. It also removes any token or secret fields in other stanzas, such as the circonus_api_token from telemetry.
     * Return a sanitized version of the Vault server configuration.
     */
    readSanitizedConfigurationStateRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * The sanitized output strips configuration values in the storage, HA storage, and seals stanzas, which may contain sensitive values such as API tokens. It also removes any token or secret fields in other stanzas, such as the circonus_api_token from telemetry.
     * Return a sanitized version of the Vault server configuration.
     */
    readSanitizedConfigurationState(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read the current Census agent\'s snapshot fields.
     */
    readVerbosityLevelForRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read the current Census agent\'s snapshot fields.
     */
    readVerbosityLevelFor(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read the current status of the request limiter.
     */
    readVerbosityLevelFor_4Raw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read the current status of the request limiter.
     */
    readVerbosityLevelFor_4(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Look up wrapping properties for the given token.
     */
    readWrappingPropertiesRaw(requestParameters: SystemApiReadWrappingPropertiesOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ReadWrappingPropertiesResponse>>;
    /**
     * Look up wrapping properties for the given token.
     */
    readWrappingProperties(readWrappingPropertiesRequest: ReadWrappingPropertiesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ReadWrappingPropertiesResponse>;
    /**
     * Look up wrapping properties for the requester\'s token.
     */
    readWrappingProperties2Raw(requestParameters: SystemApiReadWrappingProperties2Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ReadWrappingProperties2Response>>;
    /**
     * Look up wrapping properties for the requester\'s token.
     */
    readWrappingProperties2(token?: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ReadWrappingProperties2Response>;
    /**
     * This clears the rekey settings as well as any progress made. This must be called to change the parameters of the rekey. Note: verification is still a part of a rekey. If rekeying is canceled during the verification flow, the current unseal keys remain valid.
     * Cancels any in-progress rekey.
     */
    rekeyAttemptCancelRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * This clears the rekey settings as well as any progress made. This must be called to change the parameters of the rekey. Note: verification is still a part of a rekey. If rekeying is canceled during the verification flow, the current unseal keys remain valid.
     * Cancels any in-progress rekey.
     */
    rekeyAttemptCancel(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Only a single rekey attempt can take place at a time, and changing the parameters of a rekey requires canceling and starting a new rekey, which will also provide a new nonce.
     * Initializes a new rekey attempt.
     */
    rekeyAttemptInitializeRaw(requestParameters: SystemApiRekeyAttemptInitializeOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RekeyAttemptInitializeResponse>>;
    /**
     * Only a single rekey attempt can take place at a time, and changing the parameters of a rekey requires canceling and starting a new rekey, which will also provide a new nonce.
     * Initializes a new rekey attempt.
     */
    rekeyAttemptInitialize(rekeyAttemptInitializeRequest: RekeyAttemptInitializeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RekeyAttemptInitializeResponse>;
    /**
     * Reads the configuration and progress of the current rekey attempt.
     */
    rekeyAttemptReadProgressRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RekeyAttemptReadProgressResponse>>;
    /**
     * Reads the configuration and progress of the current rekey attempt.
     */
    rekeyAttemptReadProgress(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RekeyAttemptReadProgressResponse>;
    /**
     * Enter a single unseal key share to progress the rekey of the Vault.
     */
    rekeyAttemptUpdateRaw(requestParameters: SystemApiRekeyAttemptUpdateOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RekeyAttemptUpdateResponse>>;
    /**
     * Enter a single unseal key share to progress the rekey of the Vault.
     */
    rekeyAttemptUpdate(rekeyAttemptUpdateRequest: RekeyAttemptUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RekeyAttemptUpdateResponse>;
    /**
     * Delete the backup copy of PGP-encrypted unseal keys.
     */
    rekeyDeleteBackupKeyRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Delete the backup copy of PGP-encrypted unseal keys.
     */
    rekeyDeleteBackupKey(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    rekeyDeleteBackupRecoveryKeyRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    rekeyDeleteBackupRecoveryKey(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Return the backup copy of PGP-encrypted unseal keys.
     */
    rekeyReadBackupKeyRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RekeyReadBackupKeyResponse>>;
    /**
     * Return the backup copy of PGP-encrypted unseal keys.
     */
    rekeyReadBackupKey(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RekeyReadBackupKeyResponse>;
    /**
     */
    rekeyReadBackupRecoveryKeyRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RekeyReadBackupRecoveryKeyResponse>>;
    /**
     */
    rekeyReadBackupRecoveryKey(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RekeyReadBackupRecoveryKeyResponse>;
    /**
     * This clears any progress made and resets the nonce. Unlike a `DELETE` against `sys/rekey/init`, this only resets the current verification operation, not the entire rekey atttempt.
     * Cancel any in-progress rekey verification operation.
     */
    rekeyVerificationCancelRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RekeyVerificationCancelResponse>>;
    /**
     * This clears any progress made and resets the nonce. Unlike a `DELETE` against `sys/rekey/init`, this only resets the current verification operation, not the entire rekey atttempt.
     * Cancel any in-progress rekey verification operation.
     */
    rekeyVerificationCancel(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RekeyVerificationCancelResponse>;
    /**
     * Read the configuration and progress of the current rekey verification attempt.
     */
    rekeyVerificationReadProgressRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RekeyVerificationReadProgressResponse>>;
    /**
     * Read the configuration and progress of the current rekey verification attempt.
     */
    rekeyVerificationReadProgress(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RekeyVerificationReadProgressResponse>;
    /**
     * Enter a single new key share to progress the rekey verification operation.
     */
    rekeyVerificationUpdateRaw(requestParameters: SystemApiRekeyVerificationUpdateOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RekeyVerificationUpdateResponse>>;
    /**
     * Enter a single new key share to progress the rekey verification operation.
     */
    rekeyVerificationUpdate(rekeyVerificationUpdateRequest: RekeyVerificationUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RekeyVerificationUpdateResponse>;
    /**
     * Reload all plugins of a specific name and type across all namespaces. If \"scope\" is provided and is \"global\", the plugin is reloaded across all nodes and clusters. If a new plugin version has been pinned, this will ensure all instances start using the new version.
     * Reload all instances of a specific plugin.
     */
    reloadPluginsRaw(requestParameters: SystemApiReloadPluginsOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ReloadPluginsResponse>>;
    /**
     * Reload all plugins of a specific name and type across all namespaces. If \"scope\" is provided and is \"global\", the plugin is reloaded across all nodes and clusters. If a new plugin version has been pinned, this will ensure all instances start using the new version.
     * Reload all instances of a specific plugin.
     */
    reloadPlugins(name: string, type: string, reloadPluginsRequest: ReloadPluginsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ReloadPluginsResponse>;
    /**
     * Reload the given subsystem
     */
    reloadSubsystemRaw(requestParameters: SystemApiReloadSubsystemRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Reload the given subsystem
     */
    reloadSubsystem(subsystem: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Initiate a mount migration
     */
    remountRaw(requestParameters: SystemApiRemountOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RemountResponse>>;
    /**
     * Initiate a mount migration
     */
    remount(remountRequest: RemountRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RemountResponse>;
    /**
     * Check status of a mount migration
     */
    remountStatusRaw(requestParameters: SystemApiRemountStatusRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RemountStatusResponse>>;
    /**
     * Check status of a mount migration
     */
    remountStatus(migrationId: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RemountStatusResponse>;
    /**
     */
    rewrapRaw(requestParameters: SystemApiRewrapOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    rewrap(rewrapRequest: RewrapRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Cancels any in-progress root generation attempt.
     */
    rootTokenGenerationCancelRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Cancels any in-progress root generation attempt.
     */
    rootTokenGenerationCancel(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Cancels any in-progress root generation attempt.
     */
    rootTokenGenerationCancel2Raw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Cancels any in-progress root generation attempt.
     */
    rootTokenGenerationCancel2(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Only a single root generation attempt can take place at a time. One (and only one) of otp or pgp_key are required.
     * Initializes a new root generation attempt.
     */
    rootTokenGenerationInitializeRaw(requestParameters: SystemApiRootTokenGenerationInitializeOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RootTokenGenerationInitializeResponse>>;
    /**
     * Only a single root generation attempt can take place at a time. One (and only one) of otp or pgp_key are required.
     * Initializes a new root generation attempt.
     */
    rootTokenGenerationInitialize(rootTokenGenerationInitializeRequest: RootTokenGenerationInitializeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RootTokenGenerationInitializeResponse>;
    /**
     * Only a single root generation attempt can take place at a time. One (and only one) of otp or pgp_key are required.
     * Initializes a new root generation attempt.
     */
    rootTokenGenerationInitialize2Raw(requestParameters: SystemApiRootTokenGenerationInitialize2OperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RootTokenGenerationInitialize2Response>>;
    /**
     * Only a single root generation attempt can take place at a time. One (and only one) of otp or pgp_key are required.
     * Initializes a new root generation attempt.
     */
    rootTokenGenerationInitialize2(rootTokenGenerationInitialize2Request: RootTokenGenerationInitialize2Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RootTokenGenerationInitialize2Response>;
    /**
     * Read the configuration and progress of the current root generation attempt.
     */
    rootTokenGenerationReadProgressRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RootTokenGenerationReadProgressResponse>>;
    /**
     * Read the configuration and progress of the current root generation attempt.
     */
    rootTokenGenerationReadProgress(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RootTokenGenerationReadProgressResponse>;
    /**
     * Read the configuration and progress of the current root generation attempt.
     */
    rootTokenGenerationReadProgress2Raw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RootTokenGenerationReadProgress2Response>>;
    /**
     * Read the configuration and progress of the current root generation attempt.
     */
    rootTokenGenerationReadProgress2(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RootTokenGenerationReadProgress2Response>;
    /**
     * If the threshold number of unseal key shares is reached, Vault will complete the root generation and issue the new token. Otherwise, this API must be called multiple times until that threshold is met. The attempt nonce must be provided with each call.
     * Enter a single unseal key share to progress the root generation attempt.
     */
    rootTokenGenerationUpdateRaw(requestParameters: SystemApiRootTokenGenerationUpdateOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<RootTokenGenerationUpdateResponse>>;
    /**
     * If the threshold number of unseal key shares is reached, Vault will complete the root generation and issue the new token. Otherwise, this API must be called multiple times until that threshold is met. The attempt nonce must be provided with each call.
     * Enter a single unseal key share to progress the root generation attempt.
     */
    rootTokenGenerationUpdate(rootTokenGenerationUpdateRequest: RootTokenGenerationUpdateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<RootTokenGenerationUpdateResponse>;
    /**
     * Seal the Vault.
     */
    sealRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Seal the Vault.
     */
    seal(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Check the seal status of a Vault.
     */
    sealStatusRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SealStatusResponse>>;
    /**
     * Check the seal status of a Vault.
     */
    sealStatus(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SealStatusResponse>;
    /**
     * This endpoint forces the node to give up active status. If the node does not have active status, this endpoint does nothing. Note that the node will sleep for ten seconds before attempting to grab the active lock again, but if no standby nodes grab the active lock in the interim, the same node may become the active node again.
     * Cause the node to give up active status.
     */
    stepDownLeaderRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * This endpoint forces the node to give up active status. If the node does not have active status, this endpoint does nothing. Note that the node will sleep for ten seconds before attempting to grab the active lock again, but if no standby nodes grab the active lock in the interim, the same node may become the active node again.
     * Cause the node to give up active status.
     */
    stepDownLeader(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Returns the specified event notification subscription.
     */
    subscriptionsCreateRaw(requestParameters: SystemApiSubscriptionsCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SubscriptionsCreateResponse>>;
    /**
     * Returns the specified event notification subscription.
     */
    subscriptionsCreate(id: string, plugin: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SubscriptionsCreateResponse>;
    /**
     * Deletes the specified event notification subscription and stops sending event notifications to it.
     */
    subscriptionsCreate_5Raw(requestParameters: SystemApiSubscriptionsCreate0Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Deletes the specified event notification subscription and stops sending event notifications to it.
     */
    subscriptionsCreate_5(id: string, plugin: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Listing event notifications subscriptions
     */
    subscriptionsListEventsSubscriptionsRaw(requestParameters: SystemApiSubscriptionsListEventsSubscriptionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SubscriptionsListEventsSubscriptionsResponse>>;
    /**
     * Listing event notifications subscriptions
     */
    subscriptionsListEventsSubscriptions(list: SubscriptionsListEventsSubscriptionsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SubscriptionsListEventsSubscriptionsResponse>;
    /**
     * Listing event notifications subscriptions
     */
    subscriptionsReadEventsSubscriptionsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SubscriptionsReadEventsSubscriptionsResponse>>;
    /**
     * Listing event notifications subscriptions
     */
    subscriptionsReadEventsSubscriptions(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SubscriptionsReadEventsSubscriptionsResponse>;
    /**
     * Creates a new event notification subscription and starts to send events to it.
     */
    subscriptionsWriteEventsSubscriptionsRaw(requestParameters: SystemApiSubscriptionsWriteEventsSubscriptionsOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SubscriptionsWriteEventsSubscriptionsResponse>>;
    /**
     * Creates a new event notification subscription and starts to send events to it.
     */
    subscriptionsWriteEventsSubscriptions(subscriptionsWriteEventsSubscriptionsRequest: SubscriptionsWriteEventsSubscriptionsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SubscriptionsWriteEventsSubscriptionsResponse>;
    /**
     * Configure control group global settings.
     */
    systemDeleteConfigControlGroupRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Configure control group global settings.
     */
    systemDeleteConfigControlGroup(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemDeleteManagedKeysTypeNameRaw(requestParameters: SystemApiSystemDeleteManagedKeysTypeNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemDeleteManagedKeysTypeName(name: string, type: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Defines or updates a Duo MFA method.
     */
    systemDeleteMfaMethodDuoNameRaw(requestParameters: SystemApiSystemDeleteMfaMethodDuoNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Defines or updates a Duo MFA method.
     */
    systemDeleteMfaMethodDuoName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Defines or updates an Okta MFA method.
     */
    systemDeleteMfaMethodOktaNameRaw(requestParameters: SystemApiSystemDeleteMfaMethodOktaNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Defines or updates an Okta MFA method.
     */
    systemDeleteMfaMethodOktaName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Defines or updates a PingID MFA method.
     */
    systemDeleteMfaMethodPingidNameRaw(requestParameters: SystemApiSystemDeleteMfaMethodPingidNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Defines or updates a PingID MFA method.
     */
    systemDeleteMfaMethodPingidName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Defines or updates a TOTP MFA method.
     */
    systemDeleteMfaMethodTotpNameRaw(requestParameters: SystemApiSystemDeleteMfaMethodTotpNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Defines or updates a TOTP MFA method.
     */
    systemDeleteMfaMethodTotpName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemDeleteNamespacesPathRaw(requestParameters: SystemApiSystemDeleteNamespacesPathRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemDeleteNamespacesPath(path: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read, Modify, or Delete an access control policy.
     */
    systemDeletePoliciesEgpNameRaw(requestParameters: SystemApiSystemDeletePoliciesEgpNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read, Modify, or Delete an access control policy.
     */
    systemDeletePoliciesEgpName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read, Modify, or Delete an access control policy.
     */
    systemDeletePoliciesRgpNameRaw(requestParameters: SystemApiSystemDeletePoliciesRgpNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read, Modify, or Delete an access control policy.
     */
    systemDeletePoliciesRgpName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemDeleteQuotasLeaseCountNameRaw(requestParameters: SystemApiSystemDeleteQuotasLeaseCountNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemDeleteQuotasLeaseCountName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemDeleteReplicationPerformancePrimaryPathsFilterIdRaw(requestParameters: SystemApiSystemDeleteReplicationPerformancePrimaryPathsFilterIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemDeleteReplicationPerformancePrimaryPathsFilterId(id: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Delete automated raft snapshot configuration
     */
    systemDeleteStorageRaftSnapshotAutoConfigNameRaw(requestParameters: SystemApiSystemDeleteStorageRaftSnapshotAutoConfigNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Delete automated raft snapshot configuration
     */
    systemDeleteStorageRaftSnapshotAutoConfigName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemDeleteSyncConfigRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemDeleteSyncConfigResponse>>;
    /**
     */
    systemDeleteSyncConfig(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemDeleteSyncConfigResponse>;
    /**
     */
    systemDeleteSyncDestinationsAwsSmNameRaw(requestParameters: SystemApiSystemDeleteSyncDestinationsAwsSmNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemDeleteSyncDestinationsAwsSmName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemDeleteSyncDestinationsAzureKvNameRaw(requestParameters: SystemApiSystemDeleteSyncDestinationsAzureKvNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemDeleteSyncDestinationsAzureKvName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemDeleteSyncDestinationsGcpSmNameRaw(requestParameters: SystemApiSystemDeleteSyncDestinationsGcpSmNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemDeleteSyncDestinationsGcpSmName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemDeleteSyncDestinationsGhNameRaw(requestParameters: SystemApiSystemDeleteSyncDestinationsGhNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemDeleteSyncDestinationsGhName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemDeleteSyncDestinationsInMemNameRaw(requestParameters: SystemApiSystemDeleteSyncDestinationsInMemNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemDeleteSyncDestinationsInMemName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemDeleteSyncDestinationsVercelProjectNameRaw(requestParameters: SystemApiSystemDeleteSyncDestinationsVercelProjectNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemDeleteSyncDestinationsVercelProjectName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemDeleteSyncGithubAppsNameRaw(requestParameters: SystemApiSystemDeleteSyncGithubAppsNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemDeleteSyncGithubAppsNameResponse>>;
    /**
     */
    systemDeleteSyncGithubAppsName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemDeleteSyncGithubAppsNameResponse>;
    /**
     */
    systemListManagedKeysTypeRaw(requestParameters: SystemApiSystemListManagedKeysTypeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    systemListManagedKeysType(type: string, list: SystemListManagedKeysTypeListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * Lists all the available MFA methods by their name.
     */
    systemListMfaMethodRaw(requestParameters: SystemApiSystemListMfaMethodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * Lists all the available MFA methods by their name.
     */
    systemListMfaMethod(list: SystemListMfaMethodListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    systemListNamespacesRaw(requestParameters: SystemApiSystemListNamespacesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    systemListNamespaces(list: SystemListNamespacesListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * List the configured access control policies.
     */
    systemListPoliciesEgpRaw(requestParameters: SystemApiSystemListPoliciesEgpRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * List the configured access control policies.
     */
    systemListPoliciesEgp(list: SystemListPoliciesEgpListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * List the configured access control policies.
     */
    systemListPoliciesRgpRaw(requestParameters: SystemApiSystemListPoliciesRgpRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * List the configured access control policies.
     */
    systemListPoliciesRgp(list: SystemListPoliciesRgpListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    systemListQuotasLeaseCountRaw(requestParameters: SystemApiSystemListQuotasLeaseCountRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    systemListQuotasLeaseCount(list: SystemListQuotasLeaseCountListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * List automated raft snapshot configurations
     */
    systemListStorageRaftSnapshotAutoConfigRaw(requestParameters: SystemApiSystemListStorageRaftSnapshotAutoConfigRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * List automated raft snapshot configurations
     */
    systemListStorageRaftSnapshotAutoConfig(list: SystemListStorageRaftSnapshotAutoConfigListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    systemListSyncAssociationsRaw(requestParameters: SystemApiSystemListSyncAssociationsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemListSyncAssociationsResponse>>;
    /**
     */
    systemListSyncAssociations(list: SystemListSyncAssociationsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemListSyncAssociationsResponse>;
    /**
     */
    systemListSyncDestinationsRaw(requestParameters: SystemApiSystemListSyncDestinationsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemListSyncDestinationsResponse>>;
    /**
     */
    systemListSyncDestinations(list: SystemListSyncDestinationsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemListSyncDestinationsResponse>;
    /**
     */
    systemListSyncDestinationsTypeRaw(requestParameters: SystemApiSystemListSyncDestinationsTypeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemListSyncDestinationsTypeResponse>>;
    /**
     */
    systemListSyncDestinationsType(type: string, list: SystemListSyncDestinationsTypeListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemListSyncDestinationsTypeResponse>;
    /**
     */
    systemListSyncGithubAppsRaw(requestParameters: SystemApiSystemListSyncGithubAppsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemListSyncGithubAppsResponse>>;
    /**
     */
    systemListSyncGithubApps(list: SystemListSyncGithubAppsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemListSyncGithubAppsResponse>;
    /**
     */
    systemPatchNamespacesPathRaw(requestParameters: SystemApiSystemPatchNamespacesPathOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemPatchNamespacesPath(path: string, systemPatchNamespacesPathRequest: SystemPatchNamespacesPathRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemPatchSyncConfigRaw(requestParameters: SystemApiSystemPatchSyncConfigOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemPatchSyncConfigResponse>>;
    /**
     */
    systemPatchSyncConfig(systemPatchSyncConfigRequest: SystemPatchSyncConfigRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemPatchSyncConfigResponse>;
    /**
     */
    systemPatchSyncDestinationsAwsSmNameRaw(requestParameters: SystemApiSystemPatchSyncDestinationsAwsSmNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemPatchSyncDestinationsAwsSmNameResponse>>;
    /**
     */
    systemPatchSyncDestinationsAwsSmName(name: string, systemPatchSyncDestinationsAwsSmNameRequest: SystemPatchSyncDestinationsAwsSmNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemPatchSyncDestinationsAwsSmNameResponse>;
    /**
     */
    systemPatchSyncDestinationsAzureKvNameRaw(requestParameters: SystemApiSystemPatchSyncDestinationsAzureKvNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemPatchSyncDestinationsAzureKvNameResponse>>;
    /**
     */
    systemPatchSyncDestinationsAzureKvName(name: string, systemPatchSyncDestinationsAzureKvNameRequest: SystemPatchSyncDestinationsAzureKvNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemPatchSyncDestinationsAzureKvNameResponse>;
    /**
     */
    systemPatchSyncDestinationsGcpSmNameRaw(requestParameters: SystemApiSystemPatchSyncDestinationsGcpSmNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemPatchSyncDestinationsGcpSmNameResponse>>;
    /**
     */
    systemPatchSyncDestinationsGcpSmName(name: string, systemPatchSyncDestinationsGcpSmNameRequest: SystemPatchSyncDestinationsGcpSmNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemPatchSyncDestinationsGcpSmNameResponse>;
    /**
     */
    systemPatchSyncDestinationsGhNameRaw(requestParameters: SystemApiSystemPatchSyncDestinationsGhNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemPatchSyncDestinationsGhNameResponse>>;
    /**
     */
    systemPatchSyncDestinationsGhName(name: string, systemPatchSyncDestinationsGhNameRequest: SystemPatchSyncDestinationsGhNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemPatchSyncDestinationsGhNameResponse>;
    /**
     */
    systemPatchSyncDestinationsInMemNameRaw(requestParameters: SystemApiSystemPatchSyncDestinationsInMemNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemPatchSyncDestinationsInMemNameResponse>>;
    /**
     */
    systemPatchSyncDestinationsInMemName(name: string, systemPatchSyncDestinationsInMemNameRequest: SystemPatchSyncDestinationsInMemNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemPatchSyncDestinationsInMemNameResponse>;
    /**
     */
    systemPatchSyncDestinationsVercelProjectNameRaw(requestParameters: SystemApiSystemPatchSyncDestinationsVercelProjectNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemPatchSyncDestinationsVercelProjectNameResponse>>;
    /**
     */
    systemPatchSyncDestinationsVercelProjectName(name: string, systemPatchSyncDestinationsVercelProjectNameRequest: SystemPatchSyncDestinationsVercelProjectNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemPatchSyncDestinationsVercelProjectNameResponse>;
    /**
     * Configure control group global settings.
     */
    systemReadConfigControlGroupRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Configure control group global settings.
     */
    systemReadConfigControlGroup(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Gets the current status of the policy application mode for Vault.
     * Gets the current status of the policy application mode for Vault.
     */
    systemReadConfigGroupPolicyApplicationRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemReadConfigGroupPolicyApplicationResponse>>;
    /**
     * Gets the current status of the policy application mode for Vault.
     * Gets the current status of the policy application mode for Vault.
     */
    systemReadConfigGroupPolicyApplication(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemReadConfigGroupPolicyApplicationResponse>;
    /**
     * The path responds to the following HTTP methods.      GET /         Returns information on the installed license      POST         Sets the license for the server
     */
    systemReadLicenseStatusRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * The path responds to the following HTTP methods.      GET /         Returns information on the installed license      POST         Sets the license for the server
     */
    systemReadLicenseStatus(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemReadManagedKeysTypeNameRaw(requestParameters: SystemApiSystemReadManagedKeysTypeNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemReadManagedKeysTypeName(name: string, type: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Defines or updates a Duo MFA method.
     */
    systemReadMfaMethodDuoNameRaw(requestParameters: SystemApiSystemReadMfaMethodDuoNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Defines or updates a Duo MFA method.
     */
    systemReadMfaMethodDuoName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Defines or updates an Okta MFA method.
     */
    systemReadMfaMethodOktaNameRaw(requestParameters: SystemApiSystemReadMfaMethodOktaNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Defines or updates an Okta MFA method.
     */
    systemReadMfaMethodOktaName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Defines or updates a PingID MFA method.
     */
    systemReadMfaMethodPingidNameRaw(requestParameters: SystemApiSystemReadMfaMethodPingidNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Defines or updates a PingID MFA method.
     */
    systemReadMfaMethodPingidName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Defines or updates a TOTP MFA method.
     */
    systemReadMfaMethodTotpNameRaw(requestParameters: SystemApiSystemReadMfaMethodTotpNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Defines or updates a TOTP MFA method.
     */
    systemReadMfaMethodTotpName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Generates a TOTP secret for the given method name on the entity of the   calling token.
     */
    systemReadMfaMethodTotpNameGenerateRaw(requestParameters: SystemApiSystemReadMfaMethodTotpNameGenerateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Generates a TOTP secret for the given method name on the entity of the   calling token.
     */
    systemReadMfaMethodTotpNameGenerate(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemReadNamespacesPathRaw(requestParameters: SystemApiSystemReadNamespacesPathRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemReadNamespacesPath(path: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * The reload_id returned by a cluster scoped reload must be provided.
     * Get the status of a cluster-scoped reload.
     */
    systemReadPluginsReloadBackendStatusRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * The reload_id returned by a cluster scoped reload must be provided.
     * Get the status of a cluster-scoped reload.
     */
    systemReadPluginsReloadBackendStatus(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read, Modify, or Delete an access control policy.
     */
    systemReadPoliciesEgpNameRaw(requestParameters: SystemApiSystemReadPoliciesEgpNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read, Modify, or Delete an access control policy.
     */
    systemReadPoliciesEgpName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read, Modify, or Delete an access control policy.
     */
    systemReadPoliciesRgpNameRaw(requestParameters: SystemApiSystemReadPoliciesRgpNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read, Modify, or Delete an access control policy.
     */
    systemReadPoliciesRgpName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemReadQuotasLeaseCountNameRaw(requestParameters: SystemApiSystemReadQuotasLeaseCountNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemReadQuotasLeaseCountName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemReadReplicationDrSecondaryLicenseStatusRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemReadReplicationDrSecondaryLicenseStatus(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemReadReplicationDrStatusRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemReadReplicationDrStatus(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemReadReplicationPerformancePrimaryDynamicFilterIdRaw(requestParameters: SystemApiSystemReadReplicationPerformancePrimaryDynamicFilterIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemReadReplicationPerformancePrimaryDynamicFilterId(id: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemReadReplicationPerformancePrimaryPathsFilterIdRaw(requestParameters: SystemApiSystemReadReplicationPerformancePrimaryPathsFilterIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemReadReplicationPerformancePrimaryPathsFilterId(id: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemReadReplicationPerformanceSecondaryDynamicFilterIdRaw(requestParameters: SystemApiSystemReadReplicationPerformanceSecondaryDynamicFilterIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemReadReplicationPerformanceSecondaryDynamicFilterId(id: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemReadReplicationPerformanceStatusRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemReadReplicationPerformanceStatus(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemReadReplicationStatusRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemReadReplicationStatus(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Retrieve the state of any ongoing seal rewrap process
     */
    systemReadSealwrapRewrapRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Retrieve the state of any ongoing seal rewrap process
     */
    systemReadSealwrapRewrap(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read automated raft snapshot configuration
     */
    systemReadStorageRaftSnapshotAutoConfigNameRaw(requestParameters: SystemApiSystemReadStorageRaftSnapshotAutoConfigNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read automated raft snapshot configuration
     */
    systemReadStorageRaftSnapshotAutoConfigName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read status of automated raft snapshots
     */
    systemReadStorageRaftSnapshotAutoStatusNameRaw(requestParameters: SystemApiSystemReadStorageRaftSnapshotAutoStatusNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read status of automated raft snapshots
     */
    systemReadStorageRaftSnapshotAutoStatusName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemReadSyncAssociationsDestinationsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemReadSyncAssociationsDestinationsResponse>>;
    /**
     */
    systemReadSyncAssociationsDestinations(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemReadSyncAssociationsDestinationsResponse>;
    /**
     */
    systemReadSyncAssociationsMountSecretNameRaw(requestParameters: SystemApiSystemReadSyncAssociationsMountSecretNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemReadSyncAssociationsMountSecretNameResponse>>;
    /**
     */
    systemReadSyncAssociationsMountSecretName(mount: string, secretName: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemReadSyncAssociationsMountSecretNameResponse>;
    /**
     */
    systemReadSyncConfigRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemReadSyncConfigResponse>>;
    /**
     */
    systemReadSyncConfig(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemReadSyncConfigResponse>;
    /**
     */
    systemReadSyncDestinationsAwsSmNameRaw(requestParameters: SystemApiSystemReadSyncDestinationsAwsSmNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemReadSyncDestinationsAwsSmNameResponse>>;
    /**
     */
    systemReadSyncDestinationsAwsSmName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemReadSyncDestinationsAwsSmNameResponse>;
    /**
     */
    systemReadSyncDestinationsAzureKvNameRaw(requestParameters: SystemApiSystemReadSyncDestinationsAzureKvNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemReadSyncDestinationsAzureKvNameResponse>>;
    /**
     */
    systemReadSyncDestinationsAzureKvName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemReadSyncDestinationsAzureKvNameResponse>;
    /**
     */
    systemReadSyncDestinationsGcpSmNameRaw(requestParameters: SystemApiSystemReadSyncDestinationsGcpSmNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemReadSyncDestinationsGcpSmNameResponse>>;
    /**
     */
    systemReadSyncDestinationsGcpSmName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemReadSyncDestinationsGcpSmNameResponse>;
    /**
     */
    systemReadSyncDestinationsGhNameRaw(requestParameters: SystemApiSystemReadSyncDestinationsGhNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemReadSyncDestinationsGhNameResponse>>;
    /**
     */
    systemReadSyncDestinationsGhName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemReadSyncDestinationsGhNameResponse>;
    /**
     */
    systemReadSyncDestinationsInMemNameRaw(requestParameters: SystemApiSystemReadSyncDestinationsInMemNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemReadSyncDestinationsInMemNameResponse>>;
    /**
     */
    systemReadSyncDestinationsInMemName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemReadSyncDestinationsInMemNameResponse>;
    /**
     */
    systemReadSyncDestinationsTypeNameAssociationsRaw(requestParameters: SystemApiSystemReadSyncDestinationsTypeNameAssociationsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemReadSyncDestinationsTypeNameAssociationsResponse>>;
    /**
     */
    systemReadSyncDestinationsTypeNameAssociations(name: string, type: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemReadSyncDestinationsTypeNameAssociationsResponse>;
    /**
     */
    systemReadSyncDestinationsVercelProjectNameRaw(requestParameters: SystemApiSystemReadSyncDestinationsVercelProjectNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemReadSyncDestinationsVercelProjectNameResponse>>;
    /**
     */
    systemReadSyncDestinationsVercelProjectName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemReadSyncDestinationsVercelProjectNameResponse>;
    /**
     */
    systemReadSyncGithubAppsNameRaw(requestParameters: SystemApiSystemReadSyncGithubAppsNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemReadSyncGithubAppsNameResponse>>;
    /**
     */
    systemReadSyncGithubAppsName(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemReadSyncGithubAppsNameResponse>;
    /**
     * Configure control group global settings.
     */
    systemWriteConfigControlGroupRaw(requestParameters: SystemApiSystemWriteConfigControlGroupOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Configure control group global settings.
     */
    systemWriteConfigControlGroup(systemWriteConfigControlGroupRequest: SystemWriteConfigControlGroupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * The group_policy_application_mode must be provided, as within_namespace_hierarchy or any.
     * Updates the policy application mode for Vault.
     */
    systemWriteConfigGroupPolicyApplicationRaw(requestParameters: SystemApiSystemWriteConfigGroupPolicyApplicationOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * The group_policy_application_mode must be provided, as within_namespace_hierarchy or any.
     * Updates the policy application mode for Vault.
     */
    systemWriteConfigGroupPolicyApplication(systemWriteConfigGroupPolicyApplicationRequest: SystemWriteConfigGroupPolicyApplicationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Authorize a control group request
     */
    systemWriteControlGroupAuthorizeRaw(requestParameters: SystemApiSystemWriteControlGroupAuthorizeOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Authorize a control group request
     */
    systemWriteControlGroupAuthorize(systemWriteControlGroupAuthorizeRequest: SystemWriteControlGroupAuthorizeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Check the status of a control group request
     */
    systemWriteControlGroupRequestRaw(requestParameters: SystemApiSystemWriteControlGroupRequestOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Check the status of a control group request
     */
    systemWriteControlGroupRequest(systemWriteControlGroupRequestRequest: SystemWriteControlGroupRequestRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Write activity log data
     */
    systemWriteInternalCountersActivityWriteRaw(requestParameters: SystemApiSystemWriteInternalCountersActivityWriteOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Write activity log data
     */
    systemWriteInternalCountersActivityWrite(systemWriteInternalCountersActivityWriteRequest: SystemWriteInternalCountersActivityWriteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteManagedKeysTypeNameRaw(requestParameters: SystemApiSystemWriteManagedKeysTypeNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteManagedKeysTypeName(name: string, type: string, systemWriteManagedKeysTypeNameRequest: SystemWriteManagedKeysTypeNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteManagedKeysTypeNameTestSignRaw(requestParameters: SystemApiSystemWriteManagedKeysTypeNameTestSignOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteManagedKeysTypeNameTestSign(name: string, type: string, systemWriteManagedKeysTypeNameTestSignRequest: SystemWriteManagedKeysTypeNameTestSignRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Defines or updates a Duo MFA method.
     */
    systemWriteMfaMethodDuoNameRaw(requestParameters: SystemApiSystemWriteMfaMethodDuoNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Defines or updates a Duo MFA method.
     */
    systemWriteMfaMethodDuoName(name: string, systemWriteMfaMethodDuoNameRequest: SystemWriteMfaMethodDuoNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Defines or updates an Okta MFA method.
     */
    systemWriteMfaMethodOktaNameRaw(requestParameters: SystemApiSystemWriteMfaMethodOktaNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Defines or updates an Okta MFA method.
     */
    systemWriteMfaMethodOktaName(name: string, systemWriteMfaMethodOktaNameRequest: SystemWriteMfaMethodOktaNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Defines or updates a PingID MFA method.
     */
    systemWriteMfaMethodPingidNameRaw(requestParameters: SystemApiSystemWriteMfaMethodPingidNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Defines or updates a PingID MFA method.
     */
    systemWriteMfaMethodPingidName(name: string, systemWriteMfaMethodPingidNameRequest: SystemWriteMfaMethodPingidNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Defines or updates a TOTP MFA method.
     */
    systemWriteMfaMethodTotpNameRaw(requestParameters: SystemApiSystemWriteMfaMethodTotpNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Defines or updates a TOTP MFA method.
     */
    systemWriteMfaMethodTotpName(name: string, systemWriteMfaMethodTotpNameRequest: SystemWriteMfaMethodTotpNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Deletes the TOTP secret for the given method name on the given entity.
     */
    systemWriteMfaMethodTotpNameAdminDestroyRaw(requestParameters: SystemApiSystemWriteMfaMethodTotpNameAdminDestroyOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Deletes the TOTP secret for the given method name on the given entity.
     */
    systemWriteMfaMethodTotpNameAdminDestroy(name: string, systemWriteMfaMethodTotpNameAdminDestroyRequest: SystemWriteMfaMethodTotpNameAdminDestroyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Generates a TOTP secret for the given method name on the given entity.
     */
    systemWriteMfaMethodTotpNameAdminGenerateRaw(requestParameters: SystemApiSystemWriteMfaMethodTotpNameAdminGenerateOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Generates a TOTP secret for the given method name on the given entity.
     */
    systemWriteMfaMethodTotpNameAdminGenerate(name: string, systemWriteMfaMethodTotpNameAdminGenerateRequest: SystemWriteMfaMethodTotpNameAdminGenerateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Lock the API for a namespace and its descendants
     */
    systemWriteNamespacesApiLockLockRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Lock the API for a namespace and its descendants
     */
    systemWriteNamespacesApiLockLock(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Lock the API for a namespace and its descendants
     */
    systemWriteNamespacesApiLockLockPathRaw(requestParameters: SystemApiSystemWriteNamespacesApiLockLockPathRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Lock the API for a namespace and its descendants
     */
    systemWriteNamespacesApiLockLockPath(path: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Unlock the API for a namespace and its descendants
     */
    systemWriteNamespacesApiLockUnlockRaw(requestParameters: SystemApiSystemWriteNamespacesApiLockUnlockOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Unlock the API for a namespace and its descendants
     */
    systemWriteNamespacesApiLockUnlock(systemWriteNamespacesApiLockUnlockRequest: SystemWriteNamespacesApiLockUnlockRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Unlock the API for a namespace and its descendants
     */
    systemWriteNamespacesApiLockUnlockPathRaw(requestParameters: SystemApiSystemWriteNamespacesApiLockUnlockPathOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Unlock the API for a namespace and its descendants
     */
    systemWriteNamespacesApiLockUnlockPath(path: string, systemWriteNamespacesApiLockUnlockPathRequest: SystemWriteNamespacesApiLockUnlockPathRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteNamespacesPathRaw(requestParameters: SystemApiSystemWriteNamespacesPathOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteNamespacesPath(path: string, systemWriteNamespacesPathRequest: SystemWriteNamespacesPathRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read, Modify, or Delete an access control policy.
     */
    systemWritePoliciesEgpNameRaw(requestParameters: SystemApiSystemWritePoliciesEgpNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read, Modify, or Delete an access control policy.
     */
    systemWritePoliciesEgpName(name: string, systemWritePoliciesEgpNameRequest: SystemWritePoliciesEgpNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read, Modify, or Delete an access control policy.
     */
    systemWritePoliciesRgpNameRaw(requestParameters: SystemApiSystemWritePoliciesRgpNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read, Modify, or Delete an access control policy.
     */
    systemWritePoliciesRgpName(name: string, systemWritePoliciesRgpNameRequest: SystemWritePoliciesRgpNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteQuotasLeaseCountNameRaw(requestParameters: SystemApiSystemWriteQuotasLeaseCountNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteQuotasLeaseCountName(name: string, systemWriteQuotasLeaseCountNameRequest: SystemWriteQuotasLeaseCountNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationDrPrimaryDemoteRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationDrPrimaryDemote(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationDrPrimaryDisableRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationDrPrimaryDisable(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationDrPrimaryEnableRaw(requestParameters: SystemApiSystemWriteReplicationDrPrimaryEnableOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationDrPrimaryEnable(systemWriteReplicationDrPrimaryEnableRequest: SystemWriteReplicationDrPrimaryEnableRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationDrPrimaryRevokeSecondaryRaw(requestParameters: SystemApiSystemWriteReplicationDrPrimaryRevokeSecondaryOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationDrPrimaryRevokeSecondary(systemWriteReplicationDrPrimaryRevokeSecondaryRequest: SystemWriteReplicationDrPrimaryRevokeSecondaryRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationDrPrimarySecondaryTokenRaw(requestParameters: SystemApiSystemWriteReplicationDrPrimarySecondaryTokenOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationDrPrimarySecondaryToken(systemWriteReplicationDrPrimarySecondaryTokenRequest: SystemWriteReplicationDrPrimarySecondaryTokenRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Reload the given subsystem
     */
    systemWriteReplicationDrSecondaryConfigReloadSubsystemRaw(requestParameters: SystemApiSystemWriteReplicationDrSecondaryConfigReloadSubsystemRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Reload the given subsystem
     */
    systemWriteReplicationDrSecondaryConfigReloadSubsystem(subsystem: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationDrSecondaryDisableRaw(requestParameters: SystemApiSystemWriteReplicationDrSecondaryDisableOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationDrSecondaryDisable(systemWriteReplicationDrSecondaryDisableRequest: SystemWriteReplicationDrSecondaryDisableRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationDrSecondaryEnableRaw(requestParameters: SystemApiSystemWriteReplicationDrSecondaryEnableOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationDrSecondaryEnable(systemWriteReplicationDrSecondaryEnableRequest: SystemWriteReplicationDrSecondaryEnableRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationDrSecondaryGeneratePublicKeyRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationDrSecondaryGeneratePublicKey(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationDrSecondaryMerkleCheckRaw(requestParameters: SystemApiSystemWriteReplicationDrSecondaryMerkleCheckOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationDrSecondaryMerkleCheck(systemWriteReplicationDrSecondaryMerkleCheckRequest: SystemWriteReplicationDrSecondaryMerkleCheckRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationDrSecondaryOperationTokenDeleteRaw(requestParameters: SystemApiSystemWriteReplicationDrSecondaryOperationTokenDeleteOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationDrSecondaryOperationTokenDelete(systemWriteReplicationDrSecondaryOperationTokenDeleteRequest: SystemWriteReplicationDrSecondaryOperationTokenDeleteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationDrSecondaryPromoteRaw(requestParameters: SystemApiSystemWriteReplicationDrSecondaryPromoteOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationDrSecondaryPromote(systemWriteReplicationDrSecondaryPromoteRequest: SystemWriteReplicationDrSecondaryPromoteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationDrSecondaryRecoverRaw(requestParameters: SystemApiSystemWriteReplicationDrSecondaryRecoverOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationDrSecondaryRecover(systemWriteReplicationDrSecondaryRecoverRequest: SystemWriteReplicationDrSecondaryRecoverRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationDrSecondaryReindexRaw(requestParameters: SystemApiSystemWriteReplicationDrSecondaryReindexOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationDrSecondaryReindex(systemWriteReplicationDrSecondaryReindexRequest: SystemWriteReplicationDrSecondaryReindexRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationDrSecondaryUpdatePrimaryRaw(requestParameters: SystemApiSystemWriteReplicationDrSecondaryUpdatePrimaryOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationDrSecondaryUpdatePrimary(systemWriteReplicationDrSecondaryUpdatePrimaryRequest: SystemWriteReplicationDrSecondaryUpdatePrimaryRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * force corrupting stuff
     */
    systemWriteReplicationForceCorruptionRaw(requestParameters: SystemApiSystemWriteReplicationForceCorruptionOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * force corrupting stuff
     */
    systemWriteReplicationForceCorruption(systemWriteReplicationForceCorruptionRequest: SystemWriteReplicationForceCorruptionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationMerkleCheckRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationMerkleCheck(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationPerformancePrimaryDemoteRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationPerformancePrimaryDemote(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationPerformancePrimaryDisableRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationPerformancePrimaryDisable(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationPerformancePrimaryEnableRaw(requestParameters: SystemApiSystemWriteReplicationPerformancePrimaryEnableOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationPerformancePrimaryEnable(systemWriteReplicationPerformancePrimaryEnableRequest: SystemWriteReplicationPerformancePrimaryEnableRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationPerformancePrimaryPathsFilterIdRaw(requestParameters: SystemApiSystemWriteReplicationPerformancePrimaryPathsFilterIdOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationPerformancePrimaryPathsFilterId(id: string, systemWriteReplicationPerformancePrimaryPathsFilterIdRequest: SystemWriteReplicationPerformancePrimaryPathsFilterIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationPerformancePrimaryRevokeSecondaryRaw(requestParameters: SystemApiSystemWriteReplicationPerformancePrimaryRevokeSecondaryOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationPerformancePrimaryRevokeSecondary(systemWriteReplicationPerformancePrimaryRevokeSecondaryRequest: SystemWriteReplicationPerformancePrimaryRevokeSecondaryRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationPerformancePrimarySecondaryTokenRaw(requestParameters: SystemApiSystemWriteReplicationPerformancePrimarySecondaryTokenOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationPerformancePrimarySecondaryToken(systemWriteReplicationPerformancePrimarySecondaryTokenRequest: SystemWriteReplicationPerformancePrimarySecondaryTokenRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationPerformanceSecondaryDisableRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationPerformanceSecondaryDisable(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationPerformanceSecondaryEnableRaw(requestParameters: SystemApiSystemWriteReplicationPerformanceSecondaryEnableOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationPerformanceSecondaryEnable(systemWriteReplicationPerformanceSecondaryEnableRequest: SystemWriteReplicationPerformanceSecondaryEnableRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationPerformanceSecondaryGeneratePublicKeyRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationPerformanceSecondaryGeneratePublicKey(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationPerformanceSecondaryPromoteRaw(requestParameters: SystemApiSystemWriteReplicationPerformanceSecondaryPromoteOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationPerformanceSecondaryPromote(systemWriteReplicationPerformanceSecondaryPromoteRequest: SystemWriteReplicationPerformanceSecondaryPromoteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationPerformanceSecondaryUpdatePrimaryRaw(requestParameters: SystemApiSystemWriteReplicationPerformanceSecondaryUpdatePrimaryOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationPerformanceSecondaryUpdatePrimary(systemWriteReplicationPerformanceSecondaryUpdatePrimaryRequest: SystemWriteReplicationPerformanceSecondaryUpdatePrimaryRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationPrimaryDemoteRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationPrimaryDemote(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationPrimaryDisableRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationPrimaryDisable(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationPrimaryEnableRaw(requestParameters: SystemApiSystemWriteReplicationPrimaryEnableOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationPrimaryEnable(systemWriteReplicationPrimaryEnableRequest: SystemWriteReplicationPrimaryEnableRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationPrimaryRevokeSecondaryRaw(requestParameters: SystemApiSystemWriteReplicationPrimaryRevokeSecondaryOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationPrimaryRevokeSecondary(systemWriteReplicationPrimaryRevokeSecondaryRequest: SystemWriteReplicationPrimaryRevokeSecondaryRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationPrimarySecondaryTokenRaw(requestParameters: SystemApiSystemWriteReplicationPrimarySecondaryTokenOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationPrimarySecondaryToken(systemWriteReplicationPrimarySecondaryTokenRequest: SystemWriteReplicationPrimarySecondaryTokenRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationRecoverRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationRecover(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationReindexRaw(requestParameters: SystemApiSystemWriteReplicationReindexOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationReindex(systemWriteReplicationReindexRequest: SystemWriteReplicationReindexRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationSecondaryDisableRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationSecondaryDisable(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationSecondaryEnableRaw(requestParameters: SystemApiSystemWriteReplicationSecondaryEnableOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationSecondaryEnable(systemWriteReplicationSecondaryEnableRequest: SystemWriteReplicationSecondaryEnableRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationSecondaryPromoteRaw(requestParameters: SystemApiSystemWriteReplicationSecondaryPromoteOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationSecondaryPromote(systemWriteReplicationSecondaryPromoteRequest: SystemWriteReplicationSecondaryPromoteRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteReplicationSecondaryUpdatePrimaryRaw(requestParameters: SystemApiSystemWriteReplicationSecondaryUpdatePrimaryOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    systemWriteReplicationSecondaryUpdatePrimary(systemWriteReplicationSecondaryUpdatePrimaryRequest: SystemWriteReplicationSecondaryUpdatePrimaryRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Start a seal rewrap process
     */
    systemWriteSealwrapRewrapRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Start a seal rewrap process
     */
    systemWriteSealwrapRewrap(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Update automated raft snapshot configuration
     */
    systemWriteStorageRaftSnapshotAutoConfigNameRaw(requestParameters: SystemApiSystemWriteStorageRaftSnapshotAutoConfigNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Update automated raft snapshot configuration
     */
    systemWriteStorageRaftSnapshotAutoConfigName(name: string, systemWriteStorageRaftSnapshotAutoConfigNameRequest: SystemWriteStorageRaftSnapshotAutoConfigNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    systemWriteSyncDestinationsAwsSmNameRaw(requestParameters: SystemApiSystemWriteSyncDestinationsAwsSmNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemWriteSyncDestinationsAwsSmNameResponse>>;
    /**
     */
    systemWriteSyncDestinationsAwsSmName(name: string, systemWriteSyncDestinationsAwsSmNameRequest: SystemWriteSyncDestinationsAwsSmNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemWriteSyncDestinationsAwsSmNameResponse>;
    /**
     */
    systemWriteSyncDestinationsAzureKvNameRaw(requestParameters: SystemApiSystemWriteSyncDestinationsAzureKvNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemWriteSyncDestinationsAzureKvNameResponse>>;
    /**
     */
    systemWriteSyncDestinationsAzureKvName(name: string, systemWriteSyncDestinationsAzureKvNameRequest: SystemWriteSyncDestinationsAzureKvNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemWriteSyncDestinationsAzureKvNameResponse>;
    /**
     */
    systemWriteSyncDestinationsGcpSmNameRaw(requestParameters: SystemApiSystemWriteSyncDestinationsGcpSmNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemWriteSyncDestinationsGcpSmNameResponse>>;
    /**
     */
    systemWriteSyncDestinationsGcpSmName(name: string, systemWriteSyncDestinationsGcpSmNameRequest: SystemWriteSyncDestinationsGcpSmNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemWriteSyncDestinationsGcpSmNameResponse>;
    /**
     */
    systemWriteSyncDestinationsGhNameRaw(requestParameters: SystemApiSystemWriteSyncDestinationsGhNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemWriteSyncDestinationsGhNameResponse>>;
    /**
     */
    systemWriteSyncDestinationsGhName(name: string, systemWriteSyncDestinationsGhNameRequest: SystemWriteSyncDestinationsGhNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemWriteSyncDestinationsGhNameResponse>;
    /**
     */
    systemWriteSyncDestinationsInMemNameRaw(requestParameters: SystemApiSystemWriteSyncDestinationsInMemNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemWriteSyncDestinationsInMemNameResponse>>;
    /**
     */
    systemWriteSyncDestinationsInMemName(name: string, systemWriteSyncDestinationsInMemNameRequest: SystemWriteSyncDestinationsInMemNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemWriteSyncDestinationsInMemNameResponse>;
    /**
     */
    systemWriteSyncDestinationsTypeNameAssociationsRemoveRaw(requestParameters: SystemApiSystemWriteSyncDestinationsTypeNameAssociationsRemoveOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemWriteSyncDestinationsTypeNameAssociationsRemoveResponse>>;
    /**
     */
    systemWriteSyncDestinationsTypeNameAssociationsRemove(name: string, type: string, systemWriteSyncDestinationsTypeNameAssociationsRemoveRequest: SystemWriteSyncDestinationsTypeNameAssociationsRemoveRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemWriteSyncDestinationsTypeNameAssociationsRemoveResponse>;
    /**
     */
    systemWriteSyncDestinationsTypeNameAssociationsSetRaw(requestParameters: SystemApiSystemWriteSyncDestinationsTypeNameAssociationsSetOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemWriteSyncDestinationsTypeNameAssociationsSetResponse>>;
    /**
     */
    systemWriteSyncDestinationsTypeNameAssociationsSet(name: string, type: string, systemWriteSyncDestinationsTypeNameAssociationsSetRequest: SystemWriteSyncDestinationsTypeNameAssociationsSetRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemWriteSyncDestinationsTypeNameAssociationsSetResponse>;
    /**
     */
    systemWriteSyncDestinationsVercelProjectNameRaw(requestParameters: SystemApiSystemWriteSyncDestinationsVercelProjectNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemWriteSyncDestinationsVercelProjectNameResponse>>;
    /**
     */
    systemWriteSyncDestinationsVercelProjectName(name: string, systemWriteSyncDestinationsVercelProjectNameRequest: SystemWriteSyncDestinationsVercelProjectNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemWriteSyncDestinationsVercelProjectNameResponse>;
    /**
     */
    systemWriteSyncGithubAppsNameRaw(requestParameters: SystemApiSystemWriteSyncGithubAppsNameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemWriteSyncGithubAppsNameResponse>>;
    /**
     */
    systemWriteSyncGithubAppsName(name: string, systemWriteSyncGithubAppsNameRequest: SystemWriteSyncGithubAppsNameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemWriteSyncGithubAppsNameResponse>;
    /**
     * Gets manual license reporting data
     * returns manual license reporting report data
     */
    systemWriteUtilizationRaw(requestParameters: SystemApiSystemWriteUtilizationOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SystemWriteUtilizationResponse>>;
    /**
     * Gets manual license reporting data
     * returns manual license reporting report data
     */
    systemWriteUtilization(systemWriteUtilizationRequest: SystemWriteUtilizationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SystemWriteUtilizationResponse>;
    /**
     * Delete custom message
     */
    uiConfigDeleteCustomMessageRaw(requestParameters: SystemApiUiConfigDeleteCustomMessageRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Delete custom message
     */
    uiConfigDeleteCustomMessage(id: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Lists custom messages
     */
    uiConfigListCustomMessagesRaw(requestParameters: SystemApiUiConfigListCustomMessagesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UiConfigListCustomMessagesResponse>>;
    /**
     * Lists custom messages
     */
    uiConfigListCustomMessages(list: UiConfigListCustomMessagesListEnum, active?: boolean, authenticated?: boolean, type?: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UiConfigListCustomMessagesResponse>;
    /**
     * Read custom message
     */
    uiConfigReadCustomMessageRaw(requestParameters: SystemApiUiConfigReadCustomMessageRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UiConfigReadCustomMessageResponse>>;
    /**
     * Read custom message
     */
    uiConfigReadCustomMessage(id: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UiConfigReadCustomMessageResponse>;
    /**
     * Update custom message
     */
    uiConfigUpdateCustomMessageRaw(requestParameters: SystemApiUiConfigUpdateCustomMessageOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UiConfigUpdateCustomMessageResponse>>;
    /**
     * Update custom message
     */
    uiConfigUpdateCustomMessage(id: string, uiConfigUpdateCustomMessageRequest: UiConfigUpdateCustomMessageRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UiConfigUpdateCustomMessageResponse>;
    /**
     * Configure the values to be returned for the UI header.
     */
    uiHeadersConfigureRaw(requestParameters: SystemApiUiHeadersConfigureOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Configure the values to be returned for the UI header.
     */
    uiHeadersConfigure(header: string, uiHeadersConfigureRequest: UiHeadersConfigureRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Remove a UI header.
     */
    uiHeadersDeleteConfigurationRaw(requestParameters: SystemApiUiHeadersDeleteConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Remove a UI header.
     */
    uiHeadersDeleteConfiguration(header: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Return a list of configured UI headers.
     */
    uiHeadersListRaw(requestParameters: SystemApiUiHeadersListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UiHeadersListResponse>>;
    /**
     * Return a list of configured UI headers.
     */
    uiHeadersList(list: UiHeadersListListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UiHeadersListResponse>;
    /**
     * Return the given UI header\'s configuration
     */
    uiHeadersReadConfigurationRaw(requestParameters: SystemApiUiHeadersReadConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UiHeadersReadConfigurationResponse>>;
    /**
     * Return the given UI header\'s configuration
     */
    uiHeadersReadConfiguration(header: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UiHeadersReadConfigurationResponse>;
    /**
     * Configure Default Auth method for UI Login.
     */
    uiLoginDefaultAuthConfigureRaw(requestParameters: SystemApiUiLoginDefaultAuthConfigureOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Configure Default Auth method for UI Login.
     */
    uiLoginDefaultAuthConfigure(name: string, uiLoginDefaultAuthConfigureRequest: UiLoginDefaultAuthConfigureRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Remove Default Auth config for UI Login.
     */
    uiLoginDefaultAuthDeleteConfigurationRaw(requestParameters: SystemApiUiLoginDefaultAuthDeleteConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Remove Default Auth config for UI Login.
     */
    uiLoginDefaultAuthDeleteConfiguration(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Return a list of configured default auth methods for the UI.
     */
    uiLoginDefaultAuthListRaw(requestParameters: SystemApiUiLoginDefaultAuthListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UiLoginDefaultAuthListResponse>>;
    /**
     * Return a list of configured default auth methods for the UI.
     */
    uiLoginDefaultAuthList(list: UiLoginDefaultAuthListListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UiLoginDefaultAuthListResponse>;
    /**
     * Return the given Default Auth configuration
     */
    uiLoginDefaultAuthReadConfigurationRaw(requestParameters: SystemApiUiLoginDefaultAuthReadConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Return the given Default Auth configuration
     */
    uiLoginDefaultAuthReadConfiguration(name: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Unseal the Vault.
     */
    unsealRaw(requestParameters: SystemApiUnsealOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<UnsealResponse>>;
    /**
     * Unseal the Vault.
     */
    unseal(unsealRequest: UnsealRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<UnsealResponse>;
    /**
     */
    unwrapRaw(requestParameters: SystemApiUnwrapOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    unwrap(unwrapRequest: UnwrapRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Returns map of historical version change entries
     */
    versionHistoryRaw(requestParameters: SystemApiVersionHistoryRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<VersionHistoryResponse>>;
    /**
     * Returns map of historical version change entries
     */
    versionHistory(list: VersionHistoryListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<VersionHistoryResponse>;
    /**
     */
    wellKnownListLabelsRaw(requestParameters: SystemApiWellKnownListLabelsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<WellKnownListLabelsResponse>>;
    /**
     */
    wellKnownListLabels(list: WellKnownListLabelsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<WellKnownListLabelsResponse>;
    /**
     */
    wellKnownListLabels2Raw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<WellKnownListLabels2Response>>;
    /**
     */
    wellKnownListLabels2(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<WellKnownListLabels2Response>;
    /**
     * Retrieve the associated mount information for a registered well-known label.
     */
    wellKnownReadLabelRaw(requestParameters: SystemApiWellKnownReadLabelRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<WellKnownReadLabelResponse>>;
    /**
     * Retrieve the associated mount information for a registered well-known label.
     */
    wellKnownReadLabel(label: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<WellKnownReadLabelResponse>;
    /**
     */
    wrapRaw(requestParameters: SystemApiWrapRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    wrap(requestBody: {
        [key: string]: any;
    }, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
}
/**
  * @export
  * @enum {string}
  */
export declare enum LeasesLookUpListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum PluginsCatalogListPluginsWithTypeListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum PluginsRuntimesCatalogListPluginsRuntimes0ListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum PoliciesListAclPoliciesListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum PoliciesListAclPolicies3ListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum PoliciesListPasswordPoliciesListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum RateLimitQuotasListListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum RawListListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum SubscriptionsListEventsSubscriptionsListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum SystemListManagedKeysTypeListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum SystemListMfaMethodListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum SystemListNamespacesListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum SystemListPoliciesEgpListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum SystemListPoliciesRgpListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum SystemListQuotasLeaseCountListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum SystemListStorageRaftSnapshotAutoConfigListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum SystemListSyncAssociationsListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum SystemListSyncDestinationsListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum SystemListSyncDestinationsTypeListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum SystemListSyncGithubAppsListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum UiConfigListCustomMessagesListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum UiHeadersListListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum UiLoginDefaultAuthListListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum VersionHistoryListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum WellKnownListLabelsListEnum {
    TRUE = "true"
}
