/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
import * as runtime from '../runtime';
import type { AliCloudLoginRequest, AliCloudWriteAuthRoleRequest, AppRoleDestroySecretIdByAccessorRequest, AppRoleDestroySecretIdRequest, AppRoleLoginRequest, AppRoleLookUpSecretIdByAccessorRequest, AppRoleLookUpSecretIdByAccessorResponse, AppRoleLookUpSecretIdRequest, AppRoleLookUpSecretIdResponse, AppRoleReadBindSecretIdResponse, AppRoleReadBoundCidrListResponse, AppRoleReadLocalSecretIdsResponse, AppRoleReadPeriodResponse, AppRoleReadPoliciesResponse, AppRoleReadRoleIdResponse, AppRoleReadRoleResponse, AppRoleReadSecretIdBoundCidrsResponse, AppRoleReadSecretIdNumUsesResponse, AppRoleReadSecretIdTtlResponse, AppRoleReadTokenBoundCidrsResponse, AppRoleReadTokenMaxTtlResponse, AppRoleReadTokenNumUsesResponse, AppRoleReadTokenTtlResponse, AppRoleWriteBindSecretIdRequest, AppRoleWriteBoundCidrListRequest, AppRoleWriteCustomSecretIdRequest, AppRoleWriteCustomSecretIdResponse, AppRoleWritePeriodRequest, AppRoleWritePoliciesRequest, AppRoleWriteRoleIdRequest, AppRoleWriteRoleRequest, AppRoleWriteSecretIdBoundCidrsRequest, AppRoleWriteSecretIdNumUsesRequest, AppRoleWriteSecretIdRequest, AppRoleWriteSecretIdResponse, AppRoleWriteSecretIdTtlRequest, AppRoleWriteTokenBoundCidrsRequest, AppRoleWriteTokenMaxTtlRequest, AppRoleWriteTokenNumUsesRequest, AppRoleWriteTokenTtlRequest, AwsConfigureCertificateRequest, AwsConfigureClientRequest, AwsConfigureIdentityAccessListTidyOperationRequest, AwsConfigureIdentityIntegrationRequest, AwsConfigureIdentityWhitelistTidyOperationRequest, AwsConfigureRoleTagBlacklistTidyOperationRequest, AwsConfigureRoleTagDenyListTidyOperationRequest, AwsLoginRequest, AwsTidyIdentityAccessListRequest, AwsTidyIdentityWhitelistRequest, AwsTidyRoleTagBlacklistRequest, AwsTidyRoleTagDenyListRequest, AwsWriteAuthRoleRequest, AwsWriteRoleTagRequest, AwsWriteStsRoleRequest, AzureConfigureAuthRequest, AzureLoginRequest, AzureWriteAuthRoleRequest, CertConfigureRequest, CertLoginRequest, CertWriteCertificateRequest, CertWriteCrlRequest, CloudFoundryConfigureRequest, CloudFoundryLoginRequest, CloudFoundryWriteRoleRequest, GithubConfigureRequest, GithubLoginRequest, GithubWriteTeamMappingRequest, GithubWriteUserMappingRequest, GoogleCloudConfigureAuthRequest, GoogleCloudEditLabelsForRoleRequest, GoogleCloudEditServiceAccountsForRoleRequest, GoogleCloudLoginRequest, GoogleCloudWriteRoleRequest, JwtConfigureRequest, JwtLoginRequest, JwtOidcCallbackFormPostRequest, JwtOidcRequestAuthorizationUrlRequest, JwtWriteRoleRequest, KerberosConfigureLdapRequest, KerberosConfigureRequest, KerberosLoginRequest, KerberosWriteGroupRequest, KubernetesConfigureAuthRequest, KubernetesLoginRequest, KubernetesWriteAuthRoleRequest, LdapConfigureAuthRequest, LdapLoginRequest, LdapWriteGroupRequest, LdapWriteUserRequest, OciConfigureRequest, OciLoginRequest, OciWriteRoleRequest, OktaConfigureRequest, OktaLoginRequest, OktaWriteGroupRequest, OktaWriteUserRequest, RadiusConfigureRequest, RadiusLoginRequest, RadiusLoginWithUsernameRequest, RadiusWriteUserRequest, StandardListResponse, TokenCreateAgainstRoleRequest, TokenCreateOrphanRequest, TokenCreateRequest, TokenLookUpAccessorRequest, TokenLookUpRequest, TokenLookUpSelf2Request, TokenRenewAccessorRequest, TokenRenewRequest, TokenRenewSelfRequest, TokenRevokeAccessorRequest, TokenRevokeOrphanRequest, TokenRevokeRequest, TokenWriteRoleRequest, UserpassLoginRequest, UserpassResetPasswordRequest, UserpassUpdatePoliciesRequest, UserpassWriteUserRequest } from '../models/index';
export interface AuthApiAliCloudDeleteAuthRoleRequest {
    role: string;
    alicloudMountPath: string;
}
export interface AuthApiAliCloudListAuthRolesRequest {
    alicloudMountPath: string;
    list: AliCloudListAuthRolesListEnum;
}
export interface AuthApiAliCloudListAuthRoles2Request {
    alicloudMountPath: string;
    list: AliCloudListAuthRoles2ListEnum;
}
export interface AuthApiAliCloudLoginOperationRequest {
    alicloudMountPath: string;
    aliCloudLoginRequest: AliCloudLoginRequest;
}
export interface AuthApiAliCloudReadAuthRoleRequest {
    role: string;
    alicloudMountPath: string;
}
export interface AuthApiAliCloudWriteAuthRoleOperationRequest {
    role: string;
    alicloudMountPath: string;
    aliCloudWriteAuthRoleRequest: AliCloudWriteAuthRoleRequest;
}
export interface AuthApiAppRoleDeleteBindSecretIdRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleDeleteBoundCidrListRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleDeletePeriodRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleDeletePoliciesRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleDeleteRoleRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleDeleteSecretIdBoundCidrsRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleDeleteSecretIdNumUsesRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleDeleteSecretIdTtlRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleDeleteTokenBoundCidrsRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleDeleteTokenMaxTtlRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleDeleteTokenNumUsesRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleDeleteTokenTtlRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleDestroySecretIdOperationRequest {
    roleName: string;
    approleMountPath: string;
    appRoleDestroySecretIdRequest: AppRoleDestroySecretIdRequest;
}
export interface AuthApiAppRoleDestroySecretId2Request {
    roleName: string;
    approleMountPath: string;
    secretId?: string;
}
export interface AuthApiAppRoleDestroySecretIdByAccessorOperationRequest {
    roleName: string;
    approleMountPath: string;
    appRoleDestroySecretIdByAccessorRequest: AppRoleDestroySecretIdByAccessorRequest;
}
export interface AuthApiAppRoleDestroySecretIdByAccessor2Request {
    roleName: string;
    approleMountPath: string;
    secretIdAccessor?: string;
}
export interface AuthApiAppRoleListRolesRequest {
    approleMountPath: string;
    list: AppRoleListRolesListEnum;
}
export interface AuthApiAppRoleListSecretIdsRequest {
    roleName: string;
    approleMountPath: string;
    list: AppRoleListSecretIdsListEnum;
}
export interface AuthApiAppRoleLoginOperationRequest {
    approleMountPath: string;
    appRoleLoginRequest: AppRoleLoginRequest;
}
export interface AuthApiAppRoleLookUpSecretIdOperationRequest {
    roleName: string;
    approleMountPath: string;
    appRoleLookUpSecretIdRequest: AppRoleLookUpSecretIdRequest;
}
export interface AuthApiAppRoleLookUpSecretIdByAccessorOperationRequest {
    roleName: string;
    approleMountPath: string;
    appRoleLookUpSecretIdByAccessorRequest: AppRoleLookUpSecretIdByAccessorRequest;
}
export interface AuthApiAppRoleReadBindSecretIdRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleReadBoundCidrListRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleReadLocalSecretIdsRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleReadPeriodRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleReadPoliciesRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleReadRoleRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleReadRoleIdRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleReadSecretIdBoundCidrsRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleReadSecretIdNumUsesRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleReadSecretIdTtlRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleReadTokenBoundCidrsRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleReadTokenMaxTtlRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleReadTokenNumUsesRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleReadTokenTtlRequest {
    roleName: string;
    approleMountPath: string;
}
export interface AuthApiAppRoleTidySecretIdRequest {
    approleMountPath: string;
}
export interface AuthApiAppRoleWriteBindSecretIdOperationRequest {
    roleName: string;
    approleMountPath: string;
    appRoleWriteBindSecretIdRequest: AppRoleWriteBindSecretIdRequest;
}
export interface AuthApiAppRoleWriteBoundCidrListOperationRequest {
    roleName: string;
    approleMountPath: string;
    appRoleWriteBoundCidrListRequest: AppRoleWriteBoundCidrListRequest;
}
export interface AuthApiAppRoleWriteCustomSecretIdOperationRequest {
    roleName: string;
    approleMountPath: string;
    appRoleWriteCustomSecretIdRequest: AppRoleWriteCustomSecretIdRequest;
}
export interface AuthApiAppRoleWritePeriodOperationRequest {
    roleName: string;
    approleMountPath: string;
    appRoleWritePeriodRequest: AppRoleWritePeriodRequest;
}
export interface AuthApiAppRoleWritePoliciesOperationRequest {
    roleName: string;
    approleMountPath: string;
    appRoleWritePoliciesRequest: AppRoleWritePoliciesRequest;
}
export interface AuthApiAppRoleWriteRoleOperationRequest {
    roleName: string;
    approleMountPath: string;
    appRoleWriteRoleRequest: AppRoleWriteRoleRequest;
}
export interface AuthApiAppRoleWriteRoleIdOperationRequest {
    roleName: string;
    approleMountPath: string;
    appRoleWriteRoleIdRequest: AppRoleWriteRoleIdRequest;
}
export interface AuthApiAppRoleWriteSecretIdOperationRequest {
    roleName: string;
    approleMountPath: string;
    appRoleWriteSecretIdRequest: AppRoleWriteSecretIdRequest;
}
export interface AuthApiAppRoleWriteSecretIdBoundCidrsOperationRequest {
    roleName: string;
    approleMountPath: string;
    appRoleWriteSecretIdBoundCidrsRequest: AppRoleWriteSecretIdBoundCidrsRequest;
}
export interface AuthApiAppRoleWriteSecretIdNumUsesOperationRequest {
    roleName: string;
    approleMountPath: string;
    appRoleWriteSecretIdNumUsesRequest: AppRoleWriteSecretIdNumUsesRequest;
}
export interface AuthApiAppRoleWriteSecretIdTtlOperationRequest {
    roleName: string;
    approleMountPath: string;
    appRoleWriteSecretIdTtlRequest: AppRoleWriteSecretIdTtlRequest;
}
export interface AuthApiAppRoleWriteTokenBoundCidrsOperationRequest {
    roleName: string;
    approleMountPath: string;
    appRoleWriteTokenBoundCidrsRequest: AppRoleWriteTokenBoundCidrsRequest;
}
export interface AuthApiAppRoleWriteTokenMaxTtlOperationRequest {
    roleName: string;
    approleMountPath: string;
    appRoleWriteTokenMaxTtlRequest: AppRoleWriteTokenMaxTtlRequest;
}
export interface AuthApiAppRoleWriteTokenNumUsesOperationRequest {
    roleName: string;
    approleMountPath: string;
    appRoleWriteTokenNumUsesRequest: AppRoleWriteTokenNumUsesRequest;
}
export interface AuthApiAppRoleWriteTokenTtlOperationRequest {
    roleName: string;
    approleMountPath: string;
    appRoleWriteTokenTtlRequest: AppRoleWriteTokenTtlRequest;
}
export interface AuthApiAwsConfigureCertificateOperationRequest {
    certName: string;
    awsMountPath: string;
    awsConfigureCertificateRequest: AwsConfigureCertificateRequest;
}
export interface AuthApiAwsConfigureClientOperationRequest {
    awsMountPath: string;
    awsConfigureClientRequest: AwsConfigureClientRequest;
}
export interface AuthApiAwsConfigureIdentityAccessListTidyOperationOperationRequest {
    awsMountPath: string;
    awsConfigureIdentityAccessListTidyOperationRequest: AwsConfigureIdentityAccessListTidyOperationRequest;
}
export interface AuthApiAwsConfigureIdentityIntegrationOperationRequest {
    awsMountPath: string;
    awsConfigureIdentityIntegrationRequest: AwsConfigureIdentityIntegrationRequest;
}
export interface AuthApiAwsConfigureIdentityWhitelistTidyOperationOperationRequest {
    awsMountPath: string;
    awsConfigureIdentityWhitelistTidyOperationRequest: AwsConfigureIdentityWhitelistTidyOperationRequest;
}
export interface AuthApiAwsConfigureRoleTagBlacklistTidyOperationOperationRequest {
    awsMountPath: string;
    awsConfigureRoleTagBlacklistTidyOperationRequest: AwsConfigureRoleTagBlacklistTidyOperationRequest;
}
export interface AuthApiAwsConfigureRoleTagDenyListTidyOperationOperationRequest {
    awsMountPath: string;
    awsConfigureRoleTagDenyListTidyOperationRequest: AwsConfigureRoleTagDenyListTidyOperationRequest;
}
export interface AuthApiAwsDeleteAuthRoleRequest {
    role: string;
    awsMountPath: string;
}
export interface AuthApiAwsDeleteCertificateConfigurationRequest {
    certName: string;
    awsMountPath: string;
}
export interface AuthApiAwsDeleteClientConfigurationRequest {
    awsMountPath: string;
}
export interface AuthApiAwsDeleteIdentityAccessListRequest {
    instanceId: string;
    awsMountPath: string;
}
export interface AuthApiAwsDeleteIdentityAccessListTidySettingsRequest {
    awsMountPath: string;
}
export interface AuthApiAwsDeleteIdentityWhitelistRequest {
    instanceId: string;
    awsMountPath: string;
}
export interface AuthApiAwsDeleteIdentityWhitelistTidySettingsRequest {
    awsMountPath: string;
}
export interface AuthApiAwsDeleteRoleTagBlacklistRequest {
    roleTag: string;
    awsMountPath: string;
}
export interface AuthApiAwsDeleteRoleTagBlacklistTidySettingsRequest {
    awsMountPath: string;
}
export interface AuthApiAwsDeleteRoleTagDenyListRequest {
    roleTag: string;
    awsMountPath: string;
}
export interface AuthApiAwsDeleteRoleTagDenyListTidySettingsRequest {
    awsMountPath: string;
}
export interface AuthApiAwsDeleteStsRoleRequest {
    accountId: string;
    awsMountPath: string;
}
export interface AuthApiAwsListAuthRolesRequest {
    awsMountPath: string;
    list: AwsListAuthRolesListEnum;
}
export interface AuthApiAwsListAuthRoles2Request {
    awsMountPath: string;
    list: AwsListAuthRoles2ListEnum;
}
export interface AuthApiAwsListCertificateConfigurationsRequest {
    awsMountPath: string;
    list: AwsListCertificateConfigurationsListEnum;
}
export interface AuthApiAwsListIdentityAccessListRequest {
    awsMountPath: string;
    list: AwsListIdentityAccessListListEnum;
}
export interface AuthApiAwsListIdentityWhitelistRequest {
    awsMountPath: string;
    list: AwsListIdentityWhitelistListEnum;
}
export interface AuthApiAwsListRoleTagBlacklistsRequest {
    awsMountPath: string;
    list: AwsListRoleTagBlacklistsListEnum;
}
export interface AuthApiAwsListRoleTagDenyListsRequest {
    awsMountPath: string;
    list: AwsListRoleTagDenyListsListEnum;
}
export interface AuthApiAwsListStsRoleRelationshipsRequest {
    awsMountPath: string;
    list: AwsListStsRoleRelationshipsListEnum;
}
export interface AuthApiAwsLoginOperationRequest {
    awsMountPath: string;
    awsLoginRequest: AwsLoginRequest;
}
export interface AuthApiAwsReadAuthRoleRequest {
    role: string;
    awsMountPath: string;
}
export interface AuthApiAwsReadCertificateConfigurationRequest {
    certName: string;
    awsMountPath: string;
}
export interface AuthApiAwsReadClientConfigurationRequest {
    awsMountPath: string;
}
export interface AuthApiAwsReadIdentityAccessListRequest {
    instanceId: string;
    awsMountPath: string;
}
export interface AuthApiAwsReadIdentityAccessListTidySettingsRequest {
    awsMountPath: string;
}
export interface AuthApiAwsReadIdentityIntegrationConfigurationRequest {
    awsMountPath: string;
}
export interface AuthApiAwsReadIdentityWhitelistRequest {
    instanceId: string;
    awsMountPath: string;
}
export interface AuthApiAwsReadIdentityWhitelistTidySettingsRequest {
    awsMountPath: string;
}
export interface AuthApiAwsReadRoleTagBlacklistRequest {
    roleTag: string;
    awsMountPath: string;
}
export interface AuthApiAwsReadRoleTagBlacklistTidySettingsRequest {
    awsMountPath: string;
}
export interface AuthApiAwsReadRoleTagDenyListRequest {
    roleTag: string;
    awsMountPath: string;
}
export interface AuthApiAwsReadRoleTagDenyListTidySettingsRequest {
    awsMountPath: string;
}
export interface AuthApiAwsReadStsRoleRequest {
    accountId: string;
    awsMountPath: string;
}
export interface AuthApiAwsRotateRootCredentialsRequest {
    awsMountPath: string;
}
export interface AuthApiAwsTidyIdentityAccessListOperationRequest {
    awsMountPath: string;
    awsTidyIdentityAccessListRequest: AwsTidyIdentityAccessListRequest;
}
export interface AuthApiAwsTidyIdentityWhitelistOperationRequest {
    awsMountPath: string;
    awsTidyIdentityWhitelistRequest: AwsTidyIdentityWhitelistRequest;
}
export interface AuthApiAwsTidyRoleTagBlacklistOperationRequest {
    awsMountPath: string;
    awsTidyRoleTagBlacklistRequest: AwsTidyRoleTagBlacklistRequest;
}
export interface AuthApiAwsTidyRoleTagDenyListOperationRequest {
    awsMountPath: string;
    awsTidyRoleTagDenyListRequest: AwsTidyRoleTagDenyListRequest;
}
export interface AuthApiAwsWriteAuthRoleOperationRequest {
    role: string;
    awsMountPath: string;
    awsWriteAuthRoleRequest: AwsWriteAuthRoleRequest;
}
export interface AuthApiAwsWriteRoleTagOperationRequest {
    role: string;
    awsMountPath: string;
    awsWriteRoleTagRequest: AwsWriteRoleTagRequest;
}
export interface AuthApiAwsWriteRoleTagBlacklistRequest {
    roleTag: string;
    awsMountPath: string;
}
export interface AuthApiAwsWriteRoleTagDenyListRequest {
    roleTag: string;
    awsMountPath: string;
}
export interface AuthApiAwsWriteStsRoleOperationRequest {
    accountId: string;
    awsMountPath: string;
    awsWriteStsRoleRequest: AwsWriteStsRoleRequest;
}
export interface AuthApiAzureConfigureAuthOperationRequest {
    azureMountPath: string;
    azureConfigureAuthRequest: AzureConfigureAuthRequest;
}
export interface AuthApiAzureDeleteAuthConfigurationRequest {
    azureMountPath: string;
}
export interface AuthApiAzureDeleteAuthRoleRequest {
    name: string;
    azureMountPath: string;
}
export interface AuthApiAzureListAuthRolesRequest {
    azureMountPath: string;
    list: AzureListAuthRolesListEnum;
}
export interface AuthApiAzureLoginOperationRequest {
    azureMountPath: string;
    azureLoginRequest: AzureLoginRequest;
}
export interface AuthApiAzureReadAuthConfigurationRequest {
    azureMountPath: string;
}
export interface AuthApiAzureReadAuthRoleRequest {
    name: string;
    azureMountPath: string;
}
export interface AuthApiAzureRotateRootCredentialsRequest {
    azureMountPath: string;
}
export interface AuthApiAzureWriteAuthRoleOperationRequest {
    name: string;
    azureMountPath: string;
    azureWriteAuthRoleRequest: AzureWriteAuthRoleRequest;
}
export interface AuthApiCertConfigureOperationRequest {
    certMountPath: string;
    certConfigureRequest: CertConfigureRequest;
}
export interface AuthApiCertDeleteCertificateRequest {
    name: string;
    certMountPath: string;
}
export interface AuthApiCertDeleteCrlRequest {
    name: string;
    certMountPath: string;
}
export interface AuthApiCertListCertificatesRequest {
    certMountPath: string;
    list: CertListCertificatesListEnum;
}
export interface AuthApiCertListCrlsRequest {
    certMountPath: string;
    list: CertListCrlsListEnum;
}
export interface AuthApiCertLoginOperationRequest {
    certMountPath: string;
    certLoginRequest: CertLoginRequest;
}
export interface AuthApiCertReadCertificateRequest {
    name: string;
    certMountPath: string;
}
export interface AuthApiCertReadConfigurationRequest {
    certMountPath: string;
}
export interface AuthApiCertReadCrlRequest {
    name: string;
    certMountPath: string;
}
export interface AuthApiCertWriteCertificateOperationRequest {
    name: string;
    certMountPath: string;
    certWriteCertificateRequest: CertWriteCertificateRequest;
}
export interface AuthApiCertWriteCrlOperationRequest {
    name: string;
    certMountPath: string;
    certWriteCrlRequest: CertWriteCrlRequest;
}
export interface AuthApiCloudFoundryConfigureOperationRequest {
    cfMountPath: string;
    cloudFoundryConfigureRequest: CloudFoundryConfigureRequest;
}
export interface AuthApiCloudFoundryDeleteConfigurationRequest {
    cfMountPath: string;
}
export interface AuthApiCloudFoundryDeleteRoleRequest {
    role: string;
    cfMountPath: string;
}
export interface AuthApiCloudFoundryListRolesRequest {
    cfMountPath: string;
    list: CloudFoundryListRolesListEnum;
}
export interface AuthApiCloudFoundryLoginOperationRequest {
    cfMountPath: string;
    cloudFoundryLoginRequest: CloudFoundryLoginRequest;
}
export interface AuthApiCloudFoundryReadConfigurationRequest {
    cfMountPath: string;
}
export interface AuthApiCloudFoundryReadRoleRequest {
    role: string;
    cfMountPath: string;
}
export interface AuthApiCloudFoundryWriteRoleOperationRequest {
    role: string;
    cfMountPath: string;
    cloudFoundryWriteRoleRequest: CloudFoundryWriteRoleRequest;
}
export interface AuthApiGithubConfigureOperationRequest {
    githubMountPath: string;
    githubConfigureRequest: GithubConfigureRequest;
}
export interface AuthApiGithubDeleteTeamMappingRequest {
    key: string;
    githubMountPath: string;
}
export interface AuthApiGithubDeleteUserMappingRequest {
    key: string;
    githubMountPath: string;
}
export interface AuthApiGithubListTeamsRequest {
    githubMountPath: string;
    list: GithubListTeamsListEnum;
}
export interface AuthApiGithubListTeams2Request {
    githubMountPath: string;
}
export interface AuthApiGithubListUsersRequest {
    githubMountPath: string;
    list: GithubListUsersListEnum;
}
export interface AuthApiGithubListUsers2Request {
    githubMountPath: string;
}
export interface AuthApiGithubLoginOperationRequest {
    githubMountPath: string;
    githubLoginRequest: GithubLoginRequest;
}
export interface AuthApiGithubReadConfigurationRequest {
    githubMountPath: string;
}
export interface AuthApiGithubReadTeamMappingRequest {
    key: string;
    githubMountPath: string;
}
export interface AuthApiGithubReadUserMappingRequest {
    key: string;
    githubMountPath: string;
}
export interface AuthApiGithubWriteTeamMappingOperationRequest {
    key: string;
    githubMountPath: string;
    githubWriteTeamMappingRequest: GithubWriteTeamMappingRequest;
}
export interface AuthApiGithubWriteUserMappingOperationRequest {
    key: string;
    githubMountPath: string;
    githubWriteUserMappingRequest: GithubWriteUserMappingRequest;
}
export interface AuthApiGoogleCloudConfigureAuthOperationRequest {
    gcpMountPath: string;
    googleCloudConfigureAuthRequest: GoogleCloudConfigureAuthRequest;
}
export interface AuthApiGoogleCloudDeleteRoleRequest {
    name: string;
    gcpMountPath: string;
}
export interface AuthApiGoogleCloudEditLabelsForRoleOperationRequest {
    name: string;
    gcpMountPath: string;
    googleCloudEditLabelsForRoleRequest: GoogleCloudEditLabelsForRoleRequest;
}
export interface AuthApiGoogleCloudEditServiceAccountsForRoleOperationRequest {
    name: string;
    gcpMountPath: string;
    googleCloudEditServiceAccountsForRoleRequest: GoogleCloudEditServiceAccountsForRoleRequest;
}
export interface AuthApiGoogleCloudListRolesRequest {
    gcpMountPath: string;
    list: GoogleCloudListRolesListEnum;
}
export interface AuthApiGoogleCloudListRoles2Request {
    gcpMountPath: string;
    list: GoogleCloudListRoles2ListEnum;
}
export interface AuthApiGoogleCloudLoginOperationRequest {
    gcpMountPath: string;
    googleCloudLoginRequest: GoogleCloudLoginRequest;
}
export interface AuthApiGoogleCloudReadAuthConfigurationRequest {
    gcpMountPath: string;
}
export interface AuthApiGoogleCloudReadRoleRequest {
    name: string;
    gcpMountPath: string;
}
export interface AuthApiGoogleCloudRotateRootCredentialsRequest {
    gcpMountPath: string;
}
export interface AuthApiGoogleCloudWriteRoleOperationRequest {
    name: string;
    gcpMountPath: string;
    googleCloudWriteRoleRequest: GoogleCloudWriteRoleRequest;
}
export interface AuthApiJwtConfigureOperationRequest {
    jwtMountPath: string;
    jwtConfigureRequest: JwtConfigureRequest;
}
export interface AuthApiJwtDeleteRoleRequest {
    name: string;
    jwtMountPath: string;
}
export interface AuthApiJwtListRolesRequest {
    jwtMountPath: string;
    list: JwtListRolesListEnum;
}
export interface AuthApiJwtLoginOperationRequest {
    jwtMountPath: string;
    jwtLoginRequest: JwtLoginRequest;
}
export interface AuthApiJwtOidcCallbackRequest {
    jwtMountPath: string;
    clientNonce?: string;
    code?: string;
    state?: string;
}
export interface AuthApiJwtOidcCallbackFormPostOperationRequest {
    jwtMountPath: string;
    jwtOidcCallbackFormPostRequest: JwtOidcCallbackFormPostRequest;
}
export interface AuthApiJwtOidcRequestAuthorizationUrlOperationRequest {
    jwtMountPath: string;
    jwtOidcRequestAuthorizationUrlRequest: JwtOidcRequestAuthorizationUrlRequest;
}
export interface AuthApiJwtReadConfigurationRequest {
    jwtMountPath: string;
}
export interface AuthApiJwtReadRoleRequest {
    name: string;
    jwtMountPath: string;
}
export interface AuthApiJwtWriteRoleOperationRequest {
    name: string;
    jwtMountPath: string;
    jwtWriteRoleRequest: JwtWriteRoleRequest;
}
export interface AuthApiKerberosConfigureOperationRequest {
    kerberosMountPath: string;
    kerberosConfigureRequest: KerberosConfigureRequest;
}
export interface AuthApiKerberosConfigureLdapOperationRequest {
    kerberosMountPath: string;
    kerberosConfigureLdapRequest: KerberosConfigureLdapRequest;
}
export interface AuthApiKerberosDeleteGroupRequest {
    name: string;
    kerberosMountPath: string;
}
export interface AuthApiKerberosListGroupsRequest {
    kerberosMountPath: string;
    list: KerberosListGroupsListEnum;
}
export interface AuthApiKerberosLoginOperationRequest {
    kerberosMountPath: string;
    kerberosLoginRequest: KerberosLoginRequest;
}
export interface AuthApiKerberosLogin2Request {
    kerberosMountPath: string;
}
export interface AuthApiKerberosReadConfigurationRequest {
    kerberosMountPath: string;
}
export interface AuthApiKerberosReadGroupRequest {
    name: string;
    kerberosMountPath: string;
}
export interface AuthApiKerberosReadLdapConfigurationRequest {
    kerberosMountPath: string;
}
export interface AuthApiKerberosWriteGroupOperationRequest {
    name: string;
    kerberosMountPath: string;
    kerberosWriteGroupRequest: KerberosWriteGroupRequest;
}
export interface AuthApiKubernetesConfigureAuthOperationRequest {
    kubernetesMountPath: string;
    kubernetesConfigureAuthRequest: KubernetesConfigureAuthRequest;
}
export interface AuthApiKubernetesDeleteAuthRoleRequest {
    name: string;
    kubernetesMountPath: string;
}
export interface AuthApiKubernetesListAuthRolesRequest {
    kubernetesMountPath: string;
    list: KubernetesListAuthRolesListEnum;
}
export interface AuthApiKubernetesLoginOperationRequest {
    kubernetesMountPath: string;
    kubernetesLoginRequest: KubernetesLoginRequest;
}
export interface AuthApiKubernetesReadAuthConfigurationRequest {
    kubernetesMountPath: string;
}
export interface AuthApiKubernetesReadAuthRoleRequest {
    name: string;
    kubernetesMountPath: string;
}
export interface AuthApiKubernetesWriteAuthRoleOperationRequest {
    name: string;
    kubernetesMountPath: string;
    kubernetesWriteAuthRoleRequest: KubernetesWriteAuthRoleRequest;
}
export interface AuthApiLdapConfigureAuthOperationRequest {
    ldapMountPath: string;
    ldapConfigureAuthRequest: LdapConfigureAuthRequest;
}
export interface AuthApiLdapDeleteGroupRequest {
    name: string;
    ldapMountPath: string;
}
export interface AuthApiLdapDeleteUserRequest {
    name: string;
    ldapMountPath: string;
}
export interface AuthApiLdapListGroupsRequest {
    ldapMountPath: string;
    list: LdapListGroupsListEnum;
}
export interface AuthApiLdapListUsersRequest {
    ldapMountPath: string;
    list: LdapListUsersListEnum;
}
export interface AuthApiLdapLoginOperationRequest {
    username: string;
    ldapMountPath: string;
    ldapLoginRequest: LdapLoginRequest;
}
export interface AuthApiLdapReadAuthConfigurationRequest {
    ldapMountPath: string;
}
export interface AuthApiLdapReadGroupRequest {
    name: string;
    ldapMountPath: string;
}
export interface AuthApiLdapReadUserRequest {
    name: string;
    ldapMountPath: string;
}
export interface AuthApiLdapRotateRootCredentialsRequest {
    ldapMountPath: string;
}
export interface AuthApiLdapWriteGroupOperationRequest {
    name: string;
    ldapMountPath: string;
    ldapWriteGroupRequest: LdapWriteGroupRequest;
}
export interface AuthApiLdapWriteUserOperationRequest {
    name: string;
    ldapMountPath: string;
    ldapWriteUserRequest: LdapWriteUserRequest;
}
export interface AuthApiOciConfigureOperationRequest {
    ociMountPath: string;
    ociConfigureRequest: OciConfigureRequest;
}
export interface AuthApiOciDeleteConfigurationRequest {
    ociMountPath: string;
}
export interface AuthApiOciDeleteRoleRequest {
    role: string;
    ociMountPath: string;
}
export interface AuthApiOciListRolesRequest {
    ociMountPath: string;
    list: OciListRolesListEnum;
}
export interface AuthApiOciLoginOperationRequest {
    role: string;
    ociMountPath: string;
    ociLoginRequest: OciLoginRequest;
}
export interface AuthApiOciReadConfigurationRequest {
    ociMountPath: string;
}
export interface AuthApiOciReadRoleRequest {
    role: string;
    ociMountPath: string;
}
export interface AuthApiOciWriteRoleOperationRequest {
    role: string;
    ociMountPath: string;
    ociWriteRoleRequest: OciWriteRoleRequest;
}
export interface AuthApiOktaConfigureOperationRequest {
    oktaMountPath: string;
    oktaConfigureRequest: OktaConfigureRequest;
}
export interface AuthApiOktaDeleteGroupRequest {
    name: string;
    oktaMountPath: string;
}
export interface AuthApiOktaDeleteUserRequest {
    name: string;
    oktaMountPath: string;
}
export interface AuthApiOktaListGroupsRequest {
    oktaMountPath: string;
    list: OktaListGroupsListEnum;
}
export interface AuthApiOktaListUsersRequest {
    oktaMountPath: string;
    list: OktaListUsersListEnum;
}
export interface AuthApiOktaLoginOperationRequest {
    username: string;
    oktaMountPath: string;
    oktaLoginRequest: OktaLoginRequest;
}
export interface AuthApiOktaReadConfigurationRequest {
    oktaMountPath: string;
}
export interface AuthApiOktaReadGroupRequest {
    name: string;
    oktaMountPath: string;
}
export interface AuthApiOktaReadUserRequest {
    name: string;
    oktaMountPath: string;
}
export interface AuthApiOktaVerifyRequest {
    nonce: string;
    oktaMountPath: string;
}
export interface AuthApiOktaWriteGroupOperationRequest {
    name: string;
    oktaMountPath: string;
    oktaWriteGroupRequest: OktaWriteGroupRequest;
}
export interface AuthApiOktaWriteUserOperationRequest {
    name: string;
    oktaMountPath: string;
    oktaWriteUserRequest: OktaWriteUserRequest;
}
export interface AuthApiRadiusConfigureOperationRequest {
    radiusMountPath: string;
    radiusConfigureRequest: RadiusConfigureRequest;
}
export interface AuthApiRadiusDeleteUserRequest {
    name: string;
    radiusMountPath: string;
}
export interface AuthApiRadiusListUsersRequest {
    radiusMountPath: string;
    list: RadiusListUsersListEnum;
}
export interface AuthApiRadiusLoginOperationRequest {
    radiusMountPath: string;
    radiusLoginRequest: RadiusLoginRequest;
}
export interface AuthApiRadiusLoginWithUsernameOperationRequest {
    urlusername: string;
    radiusMountPath: string;
    radiusLoginWithUsernameRequest: RadiusLoginWithUsernameRequest;
}
export interface AuthApiRadiusReadConfigurationRequest {
    radiusMountPath: string;
}
export interface AuthApiRadiusReadUserRequest {
    name: string;
    radiusMountPath: string;
}
export interface AuthApiRadiusWriteUserOperationRequest {
    name: string;
    radiusMountPath: string;
    radiusWriteUserRequest: RadiusWriteUserRequest;
}
export interface AuthApiTokenCreateOperationRequest {
    tokenCreateRequest: TokenCreateRequest;
}
export interface AuthApiTokenCreateAgainstRoleOperationRequest {
    roleName: string;
    tokenCreateAgainstRoleRequest: TokenCreateAgainstRoleRequest;
}
export interface AuthApiTokenCreateOrphanOperationRequest {
    tokenCreateOrphanRequest: TokenCreateOrphanRequest;
}
export interface AuthApiTokenDeleteRoleRequest {
    roleName: string;
}
export interface AuthApiTokenListAccessorsRequest {
    list: TokenListAccessorsListEnum;
}
export interface AuthApiTokenListRolesRequest {
    list: TokenListRolesListEnum;
}
export interface AuthApiTokenLookUpOperationRequest {
    tokenLookUpRequest: TokenLookUpRequest;
}
export interface AuthApiTokenLookUp2Request {
    token?: string;
}
export interface AuthApiTokenLookUpAccessorOperationRequest {
    tokenLookUpAccessorRequest: TokenLookUpAccessorRequest;
}
export interface AuthApiTokenLookUpSelf2OperationRequest {
    tokenLookUpSelf2Request: TokenLookUpSelf2Request;
}
export interface AuthApiTokenReadRoleRequest {
    roleName: string;
}
export interface AuthApiTokenRenewOperationRequest {
    tokenRenewRequest: TokenRenewRequest;
}
export interface AuthApiTokenRenewAccessorOperationRequest {
    tokenRenewAccessorRequest: TokenRenewAccessorRequest;
}
export interface AuthApiTokenRenewSelfOperationRequest {
    tokenRenewSelfRequest: TokenRenewSelfRequest;
}
export interface AuthApiTokenRevokeOperationRequest {
    tokenRevokeRequest: TokenRevokeRequest;
}
export interface AuthApiTokenRevokeAccessorOperationRequest {
    tokenRevokeAccessorRequest: TokenRevokeAccessorRequest;
}
export interface AuthApiTokenRevokeOrphanOperationRequest {
    tokenRevokeOrphanRequest: TokenRevokeOrphanRequest;
}
export interface AuthApiTokenWriteRoleOperationRequest {
    roleName: string;
    tokenWriteRoleRequest: TokenWriteRoleRequest;
}
export interface AuthApiUserpassDeleteUserRequest {
    username: string;
    userpassMountPath: string;
}
export interface AuthApiUserpassListUsersRequest {
    userpassMountPath: string;
    list: UserpassListUsersListEnum;
}
export interface AuthApiUserpassLoginOperationRequest {
    username: string;
    userpassMountPath: string;
    userpassLoginRequest: UserpassLoginRequest;
}
export interface AuthApiUserpassReadUserRequest {
    username: string;
    userpassMountPath: string;
}
export interface AuthApiUserpassResetPasswordOperationRequest {
    username: string;
    userpassMountPath: string;
    userpassResetPasswordRequest: UserpassResetPasswordRequest;
}
export interface AuthApiUserpassUpdatePoliciesOperationRequest {
    username: string;
    userpassMountPath: string;
    userpassUpdatePoliciesRequest: UserpassUpdatePoliciesRequest;
}
export interface AuthApiUserpassWriteUserOperationRequest {
    username: string;
    userpassMountPath: string;
    userpassWriteUserRequest: UserpassWriteUserRequest;
}
/**
 *
 */
export declare class AuthApi extends runtime.BaseAPI {
    /**
     * Create a role and associate policies to it.
     */
    aliCloudDeleteAuthRoleRaw(requestParameters: AuthApiAliCloudDeleteAuthRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Create a role and associate policies to it.
     */
    aliCloudDeleteAuthRole(role: string, alicloudMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Lists all the roles that are registered with Vault.
     */
    aliCloudListAuthRolesRaw(requestParameters: AuthApiAliCloudListAuthRolesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * Lists all the roles that are registered with Vault.
     */
    aliCloudListAuthRoles(alicloudMountPath: string, list: AliCloudListAuthRolesListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * Lists all the roles that are registered with Vault.
     */
    aliCloudListAuthRoles2Raw(requestParameters: AuthApiAliCloudListAuthRoles2Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * Lists all the roles that are registered with Vault.
     */
    aliCloudListAuthRoles2(alicloudMountPath: string, list: AliCloudListAuthRoles2ListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * Authenticates an RAM entity with Vault.
     */
    aliCloudLoginRaw(requestParameters: AuthApiAliCloudLoginOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Authenticates an RAM entity with Vault.
     */
    aliCloudLogin(alicloudMountPath: string, aliCloudLoginRequest: AliCloudLoginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Create a role and associate policies to it.
     */
    aliCloudReadAuthRoleRaw(requestParameters: AuthApiAliCloudReadAuthRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Create a role and associate policies to it.
     */
    aliCloudReadAuthRole(role: string, alicloudMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Create a role and associate policies to it.
     */
    aliCloudWriteAuthRoleRaw(requestParameters: AuthApiAliCloudWriteAuthRoleOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Create a role and associate policies to it.
     */
    aliCloudWriteAuthRole(role: string, alicloudMountPath: string, aliCloudWriteAuthRoleRequest: AliCloudWriteAuthRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleDeleteBindSecretIdRaw(requestParameters: AuthApiAppRoleDeleteBindSecretIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleDeleteBindSecretId(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleDeleteBoundCidrListRaw(requestParameters: AuthApiAppRoleDeleteBoundCidrListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleDeleteBoundCidrList(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleDeletePeriodRaw(requestParameters: AuthApiAppRoleDeletePeriodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleDeletePeriod(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleDeletePoliciesRaw(requestParameters: AuthApiAppRoleDeletePoliciesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleDeletePolicies(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleDeleteRoleRaw(requestParameters: AuthApiAppRoleDeleteRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleDeleteRole(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleDeleteSecretIdBoundCidrsRaw(requestParameters: AuthApiAppRoleDeleteSecretIdBoundCidrsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleDeleteSecretIdBoundCidrs(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleDeleteSecretIdNumUsesRaw(requestParameters: AuthApiAppRoleDeleteSecretIdNumUsesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleDeleteSecretIdNumUses(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleDeleteSecretIdTtlRaw(requestParameters: AuthApiAppRoleDeleteSecretIdTtlRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleDeleteSecretIdTtl(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleDeleteTokenBoundCidrsRaw(requestParameters: AuthApiAppRoleDeleteTokenBoundCidrsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleDeleteTokenBoundCidrs(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleDeleteTokenMaxTtlRaw(requestParameters: AuthApiAppRoleDeleteTokenMaxTtlRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleDeleteTokenMaxTtl(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleDeleteTokenNumUsesRaw(requestParameters: AuthApiAppRoleDeleteTokenNumUsesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleDeleteTokenNumUses(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleDeleteTokenTtlRaw(requestParameters: AuthApiAppRoleDeleteTokenTtlRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleDeleteTokenTtl(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleDestroySecretIdRaw(requestParameters: AuthApiAppRoleDestroySecretIdOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleDestroySecretId(roleName: string, approleMountPath: string, appRoleDestroySecretIdRequest: AppRoleDestroySecretIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleDestroySecretId2Raw(requestParameters: AuthApiAppRoleDestroySecretId2Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleDestroySecretId2(roleName: string, approleMountPath: string, secretId?: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleDestroySecretIdByAccessorRaw(requestParameters: AuthApiAppRoleDestroySecretIdByAccessorOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleDestroySecretIdByAccessor(roleName: string, approleMountPath: string, appRoleDestroySecretIdByAccessorRequest: AppRoleDestroySecretIdByAccessorRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleDestroySecretIdByAccessor2Raw(requestParameters: AuthApiAppRoleDestroySecretIdByAccessor2Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleDestroySecretIdByAccessor2(roleName: string, approleMountPath: string, secretIdAccessor?: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleListRolesRaw(requestParameters: AuthApiAppRoleListRolesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    appRoleListRoles(approleMountPath: string, list: AppRoleListRolesListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    appRoleListSecretIdsRaw(requestParameters: AuthApiAppRoleListSecretIdsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    appRoleListSecretIds(roleName: string, approleMountPath: string, list: AppRoleListSecretIdsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    appRoleLoginRaw(requestParameters: AuthApiAppRoleLoginOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleLogin(approleMountPath: string, appRoleLoginRequest: AppRoleLoginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleLookUpSecretIdRaw(requestParameters: AuthApiAppRoleLookUpSecretIdOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AppRoleLookUpSecretIdResponse>>;
    /**
     */
    appRoleLookUpSecretId(roleName: string, approleMountPath: string, appRoleLookUpSecretIdRequest: AppRoleLookUpSecretIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AppRoleLookUpSecretIdResponse>;
    /**
     */
    appRoleLookUpSecretIdByAccessorRaw(requestParameters: AuthApiAppRoleLookUpSecretIdByAccessorOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AppRoleLookUpSecretIdByAccessorResponse>>;
    /**
     */
    appRoleLookUpSecretIdByAccessor(roleName: string, approleMountPath: string, appRoleLookUpSecretIdByAccessorRequest: AppRoleLookUpSecretIdByAccessorRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AppRoleLookUpSecretIdByAccessorResponse>;
    /**
     */
    appRoleReadBindSecretIdRaw(requestParameters: AuthApiAppRoleReadBindSecretIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AppRoleReadBindSecretIdResponse>>;
    /**
     */
    appRoleReadBindSecretId(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AppRoleReadBindSecretIdResponse>;
    /**
     */
    appRoleReadBoundCidrListRaw(requestParameters: AuthApiAppRoleReadBoundCidrListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AppRoleReadBoundCidrListResponse>>;
    /**
     */
    appRoleReadBoundCidrList(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AppRoleReadBoundCidrListResponse>;
    /**
     */
    appRoleReadLocalSecretIdsRaw(requestParameters: AuthApiAppRoleReadLocalSecretIdsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AppRoleReadLocalSecretIdsResponse>>;
    /**
     */
    appRoleReadLocalSecretIds(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AppRoleReadLocalSecretIdsResponse>;
    /**
     */
    appRoleReadPeriodRaw(requestParameters: AuthApiAppRoleReadPeriodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AppRoleReadPeriodResponse>>;
    /**
     */
    appRoleReadPeriod(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AppRoleReadPeriodResponse>;
    /**
     */
    appRoleReadPoliciesRaw(requestParameters: AuthApiAppRoleReadPoliciesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AppRoleReadPoliciesResponse>>;
    /**
     */
    appRoleReadPolicies(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AppRoleReadPoliciesResponse>;
    /**
     */
    appRoleReadRoleRaw(requestParameters: AuthApiAppRoleReadRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AppRoleReadRoleResponse>>;
    /**
     */
    appRoleReadRole(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AppRoleReadRoleResponse>;
    /**
     */
    appRoleReadRoleIdRaw(requestParameters: AuthApiAppRoleReadRoleIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AppRoleReadRoleIdResponse>>;
    /**
     */
    appRoleReadRoleId(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AppRoleReadRoleIdResponse>;
    /**
     */
    appRoleReadSecretIdBoundCidrsRaw(requestParameters: AuthApiAppRoleReadSecretIdBoundCidrsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AppRoleReadSecretIdBoundCidrsResponse>>;
    /**
     */
    appRoleReadSecretIdBoundCidrs(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AppRoleReadSecretIdBoundCidrsResponse>;
    /**
     */
    appRoleReadSecretIdNumUsesRaw(requestParameters: AuthApiAppRoleReadSecretIdNumUsesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AppRoleReadSecretIdNumUsesResponse>>;
    /**
     */
    appRoleReadSecretIdNumUses(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AppRoleReadSecretIdNumUsesResponse>;
    /**
     */
    appRoleReadSecretIdTtlRaw(requestParameters: AuthApiAppRoleReadSecretIdTtlRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AppRoleReadSecretIdTtlResponse>>;
    /**
     */
    appRoleReadSecretIdTtl(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AppRoleReadSecretIdTtlResponse>;
    /**
     */
    appRoleReadTokenBoundCidrsRaw(requestParameters: AuthApiAppRoleReadTokenBoundCidrsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AppRoleReadTokenBoundCidrsResponse>>;
    /**
     */
    appRoleReadTokenBoundCidrs(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AppRoleReadTokenBoundCidrsResponse>;
    /**
     */
    appRoleReadTokenMaxTtlRaw(requestParameters: AuthApiAppRoleReadTokenMaxTtlRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AppRoleReadTokenMaxTtlResponse>>;
    /**
     */
    appRoleReadTokenMaxTtl(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AppRoleReadTokenMaxTtlResponse>;
    /**
     */
    appRoleReadTokenNumUsesRaw(requestParameters: AuthApiAppRoleReadTokenNumUsesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AppRoleReadTokenNumUsesResponse>>;
    /**
     */
    appRoleReadTokenNumUses(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AppRoleReadTokenNumUsesResponse>;
    /**
     */
    appRoleReadTokenTtlRaw(requestParameters: AuthApiAppRoleReadTokenTtlRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AppRoleReadTokenTtlResponse>>;
    /**
     */
    appRoleReadTokenTtl(roleName: string, approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AppRoleReadTokenTtlResponse>;
    /**
     */
    appRoleTidySecretIdRaw(requestParameters: AuthApiAppRoleTidySecretIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleTidySecretId(approleMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleWriteBindSecretIdRaw(requestParameters: AuthApiAppRoleWriteBindSecretIdOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleWriteBindSecretId(roleName: string, approleMountPath: string, appRoleWriteBindSecretIdRequest: AppRoleWriteBindSecretIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleWriteBoundCidrListRaw(requestParameters: AuthApiAppRoleWriteBoundCidrListOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleWriteBoundCidrList(roleName: string, approleMountPath: string, appRoleWriteBoundCidrListRequest: AppRoleWriteBoundCidrListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleWriteCustomSecretIdRaw(requestParameters: AuthApiAppRoleWriteCustomSecretIdOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AppRoleWriteCustomSecretIdResponse>>;
    /**
     */
    appRoleWriteCustomSecretId(roleName: string, approleMountPath: string, appRoleWriteCustomSecretIdRequest: AppRoleWriteCustomSecretIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AppRoleWriteCustomSecretIdResponse>;
    /**
     */
    appRoleWritePeriodRaw(requestParameters: AuthApiAppRoleWritePeriodOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleWritePeriod(roleName: string, approleMountPath: string, appRoleWritePeriodRequest: AppRoleWritePeriodRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleWritePoliciesRaw(requestParameters: AuthApiAppRoleWritePoliciesOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleWritePolicies(roleName: string, approleMountPath: string, appRoleWritePoliciesRequest: AppRoleWritePoliciesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleWriteRoleRaw(requestParameters: AuthApiAppRoleWriteRoleOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleWriteRole(roleName: string, approleMountPath: string, appRoleWriteRoleRequest: AppRoleWriteRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleWriteRoleIdRaw(requestParameters: AuthApiAppRoleWriteRoleIdOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleWriteRoleId(roleName: string, approleMountPath: string, appRoleWriteRoleIdRequest: AppRoleWriteRoleIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleWriteSecretIdRaw(requestParameters: AuthApiAppRoleWriteSecretIdOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<AppRoleWriteSecretIdResponse>>;
    /**
     */
    appRoleWriteSecretId(roleName: string, approleMountPath: string, appRoleWriteSecretIdRequest: AppRoleWriteSecretIdRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<AppRoleWriteSecretIdResponse>;
    /**
     */
    appRoleWriteSecretIdBoundCidrsRaw(requestParameters: AuthApiAppRoleWriteSecretIdBoundCidrsOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleWriteSecretIdBoundCidrs(roleName: string, approleMountPath: string, appRoleWriteSecretIdBoundCidrsRequest: AppRoleWriteSecretIdBoundCidrsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleWriteSecretIdNumUsesRaw(requestParameters: AuthApiAppRoleWriteSecretIdNumUsesOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleWriteSecretIdNumUses(roleName: string, approleMountPath: string, appRoleWriteSecretIdNumUsesRequest: AppRoleWriteSecretIdNumUsesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleWriteSecretIdTtlRaw(requestParameters: AuthApiAppRoleWriteSecretIdTtlOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleWriteSecretIdTtl(roleName: string, approleMountPath: string, appRoleWriteSecretIdTtlRequest: AppRoleWriteSecretIdTtlRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleWriteTokenBoundCidrsRaw(requestParameters: AuthApiAppRoleWriteTokenBoundCidrsOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleWriteTokenBoundCidrs(roleName: string, approleMountPath: string, appRoleWriteTokenBoundCidrsRequest: AppRoleWriteTokenBoundCidrsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleWriteTokenMaxTtlRaw(requestParameters: AuthApiAppRoleWriteTokenMaxTtlOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleWriteTokenMaxTtl(roleName: string, approleMountPath: string, appRoleWriteTokenMaxTtlRequest: AppRoleWriteTokenMaxTtlRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleWriteTokenNumUsesRaw(requestParameters: AuthApiAppRoleWriteTokenNumUsesOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleWriteTokenNumUses(roleName: string, approleMountPath: string, appRoleWriteTokenNumUsesRequest: AppRoleWriteTokenNumUsesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    appRoleWriteTokenTtlRaw(requestParameters: AuthApiAppRoleWriteTokenTtlOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    appRoleWriteTokenTtl(roleName: string, approleMountPath: string, appRoleWriteTokenTtlRequest: AppRoleWriteTokenTtlRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsConfigureCertificateRaw(requestParameters: AuthApiAwsConfigureCertificateOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsConfigureCertificate(certName: string, awsMountPath: string, awsConfigureCertificateRequest: AwsConfigureCertificateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsConfigureClientRaw(requestParameters: AuthApiAwsConfigureClientOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsConfigureClient(awsMountPath: string, awsConfigureClientRequest: AwsConfigureClientRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsConfigureIdentityAccessListTidyOperationRaw(requestParameters: AuthApiAwsConfigureIdentityAccessListTidyOperationOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsConfigureIdentityAccessListTidyOperation(awsMountPath: string, awsConfigureIdentityAccessListTidyOperationRequest: AwsConfigureIdentityAccessListTidyOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsConfigureIdentityIntegrationRaw(requestParameters: AuthApiAwsConfigureIdentityIntegrationOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsConfigureIdentityIntegration(awsMountPath: string, awsConfigureIdentityIntegrationRequest: AwsConfigureIdentityIntegrationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsConfigureIdentityWhitelistTidyOperationRaw(requestParameters: AuthApiAwsConfigureIdentityWhitelistTidyOperationOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsConfigureIdentityWhitelistTidyOperation(awsMountPath: string, awsConfigureIdentityWhitelistTidyOperationRequest: AwsConfigureIdentityWhitelistTidyOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsConfigureRoleTagBlacklistTidyOperationRaw(requestParameters: AuthApiAwsConfigureRoleTagBlacklistTidyOperationOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsConfigureRoleTagBlacklistTidyOperation(awsMountPath: string, awsConfigureRoleTagBlacklistTidyOperationRequest: AwsConfigureRoleTagBlacklistTidyOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsConfigureRoleTagDenyListTidyOperationRaw(requestParameters: AuthApiAwsConfigureRoleTagDenyListTidyOperationOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsConfigureRoleTagDenyListTidyOperation(awsMountPath: string, awsConfigureRoleTagDenyListTidyOperationRequest: AwsConfigureRoleTagDenyListTidyOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsDeleteAuthRoleRaw(requestParameters: AuthApiAwsDeleteAuthRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsDeleteAuthRole(role: string, awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsDeleteCertificateConfigurationRaw(requestParameters: AuthApiAwsDeleteCertificateConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsDeleteCertificateConfiguration(certName: string, awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsDeleteClientConfigurationRaw(requestParameters: AuthApiAwsDeleteClientConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsDeleteClientConfiguration(awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsDeleteIdentityAccessListRaw(requestParameters: AuthApiAwsDeleteIdentityAccessListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsDeleteIdentityAccessList(instanceId: string, awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsDeleteIdentityAccessListTidySettingsRaw(requestParameters: AuthApiAwsDeleteIdentityAccessListTidySettingsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsDeleteIdentityAccessListTidySettings(awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsDeleteIdentityWhitelistRaw(requestParameters: AuthApiAwsDeleteIdentityWhitelistRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsDeleteIdentityWhitelist(instanceId: string, awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsDeleteIdentityWhitelistTidySettingsRaw(requestParameters: AuthApiAwsDeleteIdentityWhitelistTidySettingsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsDeleteIdentityWhitelistTidySettings(awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsDeleteRoleTagBlacklistRaw(requestParameters: AuthApiAwsDeleteRoleTagBlacklistRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsDeleteRoleTagBlacklist(roleTag: string, awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsDeleteRoleTagBlacklistTidySettingsRaw(requestParameters: AuthApiAwsDeleteRoleTagBlacklistTidySettingsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsDeleteRoleTagBlacklistTidySettings(awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsDeleteRoleTagDenyListRaw(requestParameters: AuthApiAwsDeleteRoleTagDenyListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsDeleteRoleTagDenyList(roleTag: string, awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsDeleteRoleTagDenyListTidySettingsRaw(requestParameters: AuthApiAwsDeleteRoleTagDenyListTidySettingsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsDeleteRoleTagDenyListTidySettings(awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsDeleteStsRoleRaw(requestParameters: AuthApiAwsDeleteStsRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsDeleteStsRole(accountId: string, awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsListAuthRolesRaw(requestParameters: AuthApiAwsListAuthRolesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    awsListAuthRoles(awsMountPath: string, list: AwsListAuthRolesListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    awsListAuthRoles2Raw(requestParameters: AuthApiAwsListAuthRoles2Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    awsListAuthRoles2(awsMountPath: string, list: AwsListAuthRoles2ListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    awsListCertificateConfigurationsRaw(requestParameters: AuthApiAwsListCertificateConfigurationsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    awsListCertificateConfigurations(awsMountPath: string, list: AwsListCertificateConfigurationsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    awsListIdentityAccessListRaw(requestParameters: AuthApiAwsListIdentityAccessListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    awsListIdentityAccessList(awsMountPath: string, list: AwsListIdentityAccessListListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    awsListIdentityWhitelistRaw(requestParameters: AuthApiAwsListIdentityWhitelistRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    awsListIdentityWhitelist(awsMountPath: string, list: AwsListIdentityWhitelistListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    awsListRoleTagBlacklistsRaw(requestParameters: AuthApiAwsListRoleTagBlacklistsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    awsListRoleTagBlacklists(awsMountPath: string, list: AwsListRoleTagBlacklistsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    awsListRoleTagDenyListsRaw(requestParameters: AuthApiAwsListRoleTagDenyListsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    awsListRoleTagDenyLists(awsMountPath: string, list: AwsListRoleTagDenyListsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    awsListStsRoleRelationshipsRaw(requestParameters: AuthApiAwsListStsRoleRelationshipsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    awsListStsRoleRelationships(awsMountPath: string, list: AwsListStsRoleRelationshipsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    awsLoginRaw(requestParameters: AuthApiAwsLoginOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsLogin(awsMountPath: string, awsLoginRequest: AwsLoginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsReadAuthRoleRaw(requestParameters: AuthApiAwsReadAuthRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsReadAuthRole(role: string, awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsReadCertificateConfigurationRaw(requestParameters: AuthApiAwsReadCertificateConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsReadCertificateConfiguration(certName: string, awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsReadClientConfigurationRaw(requestParameters: AuthApiAwsReadClientConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsReadClientConfiguration(awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsReadIdentityAccessListRaw(requestParameters: AuthApiAwsReadIdentityAccessListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsReadIdentityAccessList(instanceId: string, awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsReadIdentityAccessListTidySettingsRaw(requestParameters: AuthApiAwsReadIdentityAccessListTidySettingsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsReadIdentityAccessListTidySettings(awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsReadIdentityIntegrationConfigurationRaw(requestParameters: AuthApiAwsReadIdentityIntegrationConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsReadIdentityIntegrationConfiguration(awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsReadIdentityWhitelistRaw(requestParameters: AuthApiAwsReadIdentityWhitelistRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsReadIdentityWhitelist(instanceId: string, awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsReadIdentityWhitelistTidySettingsRaw(requestParameters: AuthApiAwsReadIdentityWhitelistTidySettingsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsReadIdentityWhitelistTidySettings(awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsReadRoleTagBlacklistRaw(requestParameters: AuthApiAwsReadRoleTagBlacklistRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsReadRoleTagBlacklist(roleTag: string, awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsReadRoleTagBlacklistTidySettingsRaw(requestParameters: AuthApiAwsReadRoleTagBlacklistTidySettingsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsReadRoleTagBlacklistTidySettings(awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsReadRoleTagDenyListRaw(requestParameters: AuthApiAwsReadRoleTagDenyListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsReadRoleTagDenyList(roleTag: string, awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsReadRoleTagDenyListTidySettingsRaw(requestParameters: AuthApiAwsReadRoleTagDenyListTidySettingsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsReadRoleTagDenyListTidySettings(awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsReadStsRoleRaw(requestParameters: AuthApiAwsReadStsRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsReadStsRole(accountId: string, awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsRotateRootCredentialsRaw(requestParameters: AuthApiAwsRotateRootCredentialsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsRotateRootCredentials(awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsTidyIdentityAccessListRaw(requestParameters: AuthApiAwsTidyIdentityAccessListOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsTidyIdentityAccessList(awsMountPath: string, awsTidyIdentityAccessListRequest: AwsTidyIdentityAccessListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsTidyIdentityWhitelistRaw(requestParameters: AuthApiAwsTidyIdentityWhitelistOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsTidyIdentityWhitelist(awsMountPath: string, awsTidyIdentityWhitelistRequest: AwsTidyIdentityWhitelistRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsTidyRoleTagBlacklistRaw(requestParameters: AuthApiAwsTidyRoleTagBlacklistOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsTidyRoleTagBlacklist(awsMountPath: string, awsTidyRoleTagBlacklistRequest: AwsTidyRoleTagBlacklistRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsTidyRoleTagDenyListRaw(requestParameters: AuthApiAwsTidyRoleTagDenyListOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsTidyRoleTagDenyList(awsMountPath: string, awsTidyRoleTagDenyListRequest: AwsTidyRoleTagDenyListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsWriteAuthRoleRaw(requestParameters: AuthApiAwsWriteAuthRoleOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsWriteAuthRole(role: string, awsMountPath: string, awsWriteAuthRoleRequest: AwsWriteAuthRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsWriteRoleTagRaw(requestParameters: AuthApiAwsWriteRoleTagOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsWriteRoleTag(role: string, awsMountPath: string, awsWriteRoleTagRequest: AwsWriteRoleTagRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsWriteRoleTagBlacklistRaw(requestParameters: AuthApiAwsWriteRoleTagBlacklistRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsWriteRoleTagBlacklist(roleTag: string, awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsWriteRoleTagDenyListRaw(requestParameters: AuthApiAwsWriteRoleTagDenyListRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsWriteRoleTagDenyList(roleTag: string, awsMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    awsWriteStsRoleRaw(requestParameters: AuthApiAwsWriteStsRoleOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    awsWriteStsRole(accountId: string, awsMountPath: string, awsWriteStsRoleRequest: AwsWriteStsRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    azureConfigureAuthRaw(requestParameters: AuthApiAzureConfigureAuthOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    azureConfigureAuth(azureMountPath: string, azureConfigureAuthRequest: AzureConfigureAuthRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    azureDeleteAuthConfigurationRaw(requestParameters: AuthApiAzureDeleteAuthConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    azureDeleteAuthConfiguration(azureMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    azureDeleteAuthRoleRaw(requestParameters: AuthApiAzureDeleteAuthRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    azureDeleteAuthRole(name: string, azureMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    azureListAuthRolesRaw(requestParameters: AuthApiAzureListAuthRolesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    azureListAuthRoles(azureMountPath: string, list: AzureListAuthRolesListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    azureLoginRaw(requestParameters: AuthApiAzureLoginOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    azureLogin(azureMountPath: string, azureLoginRequest: AzureLoginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    azureReadAuthConfigurationRaw(requestParameters: AuthApiAzureReadAuthConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    azureReadAuthConfiguration(azureMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    azureReadAuthRoleRaw(requestParameters: AuthApiAzureReadAuthRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    azureReadAuthRole(name: string, azureMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    azureRotateRootCredentialsRaw(requestParameters: AuthApiAzureRotateRootCredentialsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    azureRotateRootCredentials(azureMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    azureWriteAuthRoleRaw(requestParameters: AuthApiAzureWriteAuthRoleOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    azureWriteAuthRole(name: string, azureMountPath: string, azureWriteAuthRoleRequest: AzureWriteAuthRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    certConfigureRaw(requestParameters: AuthApiCertConfigureOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    certConfigure(certMountPath: string, certConfigureRequest: CertConfigureRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage trusted certificates used for authentication.
     */
    certDeleteCertificateRaw(requestParameters: AuthApiCertDeleteCertificateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage trusted certificates used for authentication.
     */
    certDeleteCertificate(name: string, certMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage Certificate Revocation Lists checked during authentication.
     */
    certDeleteCrlRaw(requestParameters: AuthApiCertDeleteCrlRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage Certificate Revocation Lists checked during authentication.
     */
    certDeleteCrl(name: string, certMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage trusted certificates used for authentication.
     */
    certListCertificatesRaw(requestParameters: AuthApiCertListCertificatesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * Manage trusted certificates used for authentication.
     */
    certListCertificates(certMountPath: string, list: CertListCertificatesListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    certListCrlsRaw(requestParameters: AuthApiCertListCrlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    certListCrls(certMountPath: string, list: CertListCrlsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    certLoginRaw(requestParameters: AuthApiCertLoginOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    certLogin(certMountPath: string, certLoginRequest: CertLoginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage trusted certificates used for authentication.
     */
    certReadCertificateRaw(requestParameters: AuthApiCertReadCertificateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage trusted certificates used for authentication.
     */
    certReadCertificate(name: string, certMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    certReadConfigurationRaw(requestParameters: AuthApiCertReadConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    certReadConfiguration(certMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage Certificate Revocation Lists checked during authentication.
     */
    certReadCrlRaw(requestParameters: AuthApiCertReadCrlRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage Certificate Revocation Lists checked during authentication.
     */
    certReadCrl(name: string, certMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage trusted certificates used for authentication.
     */
    certWriteCertificateRaw(requestParameters: AuthApiCertWriteCertificateOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage trusted certificates used for authentication.
     */
    certWriteCertificate(name: string, certMountPath: string, certWriteCertificateRequest: CertWriteCertificateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage Certificate Revocation Lists checked during authentication.
     */
    certWriteCrlRaw(requestParameters: AuthApiCertWriteCrlOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage Certificate Revocation Lists checked during authentication.
     */
    certWriteCrl(name: string, certMountPath: string, certWriteCrlRequest: CertWriteCrlRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    cloudFoundryConfigureRaw(requestParameters: AuthApiCloudFoundryConfigureOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    cloudFoundryConfigure(cfMountPath: string, cloudFoundryConfigureRequest: CloudFoundryConfigureRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    cloudFoundryDeleteConfigurationRaw(requestParameters: AuthApiCloudFoundryDeleteConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    cloudFoundryDeleteConfiguration(cfMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    cloudFoundryDeleteRoleRaw(requestParameters: AuthApiCloudFoundryDeleteRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    cloudFoundryDeleteRole(role: string, cfMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    cloudFoundryListRolesRaw(requestParameters: AuthApiCloudFoundryListRolesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    cloudFoundryListRoles(cfMountPath: string, list: CloudFoundryListRolesListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    cloudFoundryLoginRaw(requestParameters: AuthApiCloudFoundryLoginOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    cloudFoundryLogin(cfMountPath: string, cloudFoundryLoginRequest: CloudFoundryLoginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    cloudFoundryReadConfigurationRaw(requestParameters: AuthApiCloudFoundryReadConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    cloudFoundryReadConfiguration(cfMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    cloudFoundryReadRoleRaw(requestParameters: AuthApiCloudFoundryReadRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    cloudFoundryReadRole(role: string, cfMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    cloudFoundryWriteRoleRaw(requestParameters: AuthApiCloudFoundryWriteRoleOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    cloudFoundryWriteRole(role: string, cfMountPath: string, cloudFoundryWriteRoleRequest: CloudFoundryWriteRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    githubConfigureRaw(requestParameters: AuthApiGithubConfigureOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    githubConfigure(githubMountPath: string, githubConfigureRequest: GithubConfigureRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read/write/delete a single teams mapping
     */
    githubDeleteTeamMappingRaw(requestParameters: AuthApiGithubDeleteTeamMappingRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read/write/delete a single teams mapping
     */
    githubDeleteTeamMapping(key: string, githubMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read/write/delete a single users mapping
     */
    githubDeleteUserMappingRaw(requestParameters: AuthApiGithubDeleteUserMappingRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read/write/delete a single users mapping
     */
    githubDeleteUserMapping(key: string, githubMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read mappings for teams
     */
    githubListTeamsRaw(requestParameters: AuthApiGithubListTeamsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * Read mappings for teams
     */
    githubListTeams(githubMountPath: string, list: GithubListTeamsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * Read mappings for teams
     */
    githubListTeams2Raw(requestParameters: AuthApiGithubListTeams2Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read mappings for teams
     */
    githubListTeams2(githubMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read mappings for users
     */
    githubListUsersRaw(requestParameters: AuthApiGithubListUsersRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * Read mappings for users
     */
    githubListUsers(githubMountPath: string, list: GithubListUsersListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * Read mappings for users
     */
    githubListUsers2Raw(requestParameters: AuthApiGithubListUsers2Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read mappings for users
     */
    githubListUsers2(githubMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    githubLoginRaw(requestParameters: AuthApiGithubLoginOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    githubLogin(githubMountPath: string, githubLoginRequest: GithubLoginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    githubReadConfigurationRaw(requestParameters: AuthApiGithubReadConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    githubReadConfiguration(githubMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read/write/delete a single teams mapping
     */
    githubReadTeamMappingRaw(requestParameters: AuthApiGithubReadTeamMappingRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read/write/delete a single teams mapping
     */
    githubReadTeamMapping(key: string, githubMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read/write/delete a single users mapping
     */
    githubReadUserMappingRaw(requestParameters: AuthApiGithubReadUserMappingRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read/write/delete a single users mapping
     */
    githubReadUserMapping(key: string, githubMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read/write/delete a single teams mapping
     */
    githubWriteTeamMappingRaw(requestParameters: AuthApiGithubWriteTeamMappingOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read/write/delete a single teams mapping
     */
    githubWriteTeamMapping(key: string, githubMountPath: string, githubWriteTeamMappingRequest: GithubWriteTeamMappingRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read/write/delete a single users mapping
     */
    githubWriteUserMappingRaw(requestParameters: AuthApiGithubWriteUserMappingOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read/write/delete a single users mapping
     */
    githubWriteUserMapping(key: string, githubMountPath: string, githubWriteUserMappingRequest: GithubWriteUserMappingRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    googleCloudConfigureAuthRaw(requestParameters: AuthApiGoogleCloudConfigureAuthOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    googleCloudConfigureAuth(gcpMountPath: string, googleCloudConfigureAuthRequest: GoogleCloudConfigureAuthRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Create a GCP role with associated policies and required attributes.
     */
    googleCloudDeleteRoleRaw(requestParameters: AuthApiGoogleCloudDeleteRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Create a GCP role with associated policies and required attributes.
     */
    googleCloudDeleteRole(name: string, gcpMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Add or remove labels for an existing \'gce\' role
     */
    googleCloudEditLabelsForRoleRaw(requestParameters: AuthApiGoogleCloudEditLabelsForRoleOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Add or remove labels for an existing \'gce\' role
     */
    googleCloudEditLabelsForRole(name: string, gcpMountPath: string, googleCloudEditLabelsForRoleRequest: GoogleCloudEditLabelsForRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Add or remove service accounts for an existing `iam` role
     */
    googleCloudEditServiceAccountsForRoleRaw(requestParameters: AuthApiGoogleCloudEditServiceAccountsForRoleOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Add or remove service accounts for an existing `iam` role
     */
    googleCloudEditServiceAccountsForRole(name: string, gcpMountPath: string, googleCloudEditServiceAccountsForRoleRequest: GoogleCloudEditServiceAccountsForRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Lists all the roles that are registered with Vault.
     */
    googleCloudListRolesRaw(requestParameters: AuthApiGoogleCloudListRolesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * Lists all the roles that are registered with Vault.
     */
    googleCloudListRoles(gcpMountPath: string, list: GoogleCloudListRolesListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * Lists all the roles that are registered with Vault.
     */
    googleCloudListRoles2Raw(requestParameters: AuthApiGoogleCloudListRoles2Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * Lists all the roles that are registered with Vault.
     */
    googleCloudListRoles2(gcpMountPath: string, list: GoogleCloudListRoles2ListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    googleCloudLoginRaw(requestParameters: AuthApiGoogleCloudLoginOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    googleCloudLogin(gcpMountPath: string, googleCloudLoginRequest: GoogleCloudLoginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    googleCloudReadAuthConfigurationRaw(requestParameters: AuthApiGoogleCloudReadAuthConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    googleCloudReadAuthConfiguration(gcpMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Create a GCP role with associated policies and required attributes.
     */
    googleCloudReadRoleRaw(requestParameters: AuthApiGoogleCloudReadRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Create a GCP role with associated policies and required attributes.
     */
    googleCloudReadRole(name: string, gcpMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    googleCloudRotateRootCredentialsRaw(requestParameters: AuthApiGoogleCloudRotateRootCredentialsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    googleCloudRotateRootCredentials(gcpMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Create a GCP role with associated policies and required attributes.
     */
    googleCloudWriteRoleRaw(requestParameters: AuthApiGoogleCloudWriteRoleOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Create a GCP role with associated policies and required attributes.
     */
    googleCloudWriteRole(name: string, gcpMountPath: string, googleCloudWriteRoleRequest: GoogleCloudWriteRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * The JWT authentication backend validates JWTs (or OIDC) using the configured credentials. If using OIDC Discovery, the URL must be provided, along with (optionally) the CA cert to use for the connection. If performing JWT validation locally, a set of public keys must be provided.
     * Configure the JWT authentication backend.
     */
    jwtConfigureRaw(requestParameters: AuthApiJwtConfigureOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * The JWT authentication backend validates JWTs (or OIDC) using the configured credentials. If using OIDC Discovery, the URL must be provided, along with (optionally) the CA cert to use for the connection. If performing JWT validation locally, a set of public keys must be provided.
     * Configure the JWT authentication backend.
     */
    jwtConfigure(jwtMountPath: string, jwtConfigureRequest: JwtConfigureRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Delete an existing role.
     */
    jwtDeleteRoleRaw(requestParameters: AuthApiJwtDeleteRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Delete an existing role.
     */
    jwtDeleteRole(name: string, jwtMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * The list will contain the names of the roles.
     * Lists all the roles registered with the backend.
     */
    jwtListRolesRaw(requestParameters: AuthApiJwtListRolesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * The list will contain the names of the roles.
     * Lists all the roles registered with the backend.
     */
    jwtListRoles(jwtMountPath: string, list: JwtListRolesListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * Authenticates to Vault using a JWT (or OIDC) token.
     */
    jwtLoginRaw(requestParameters: AuthApiJwtLoginOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Authenticates to Vault using a JWT (or OIDC) token.
     */
    jwtLogin(jwtMountPath: string, jwtLoginRequest: JwtLoginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Callback endpoint to complete an OIDC login.
     */
    jwtOidcCallbackRaw(requestParameters: AuthApiJwtOidcCallbackRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Callback endpoint to complete an OIDC login.
     */
    jwtOidcCallback(jwtMountPath: string, clientNonce?: string, code?: string, state?: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Callback endpoint to handle form_posts.
     */
    jwtOidcCallbackFormPostRaw(requestParameters: AuthApiJwtOidcCallbackFormPostOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Callback endpoint to handle form_posts.
     */
    jwtOidcCallbackFormPost(jwtMountPath: string, jwtOidcCallbackFormPostRequest: JwtOidcCallbackFormPostRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Request an authorization URL to start an OIDC login flow.
     */
    jwtOidcRequestAuthorizationUrlRaw(requestParameters: AuthApiJwtOidcRequestAuthorizationUrlOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Request an authorization URL to start an OIDC login flow.
     */
    jwtOidcRequestAuthorizationUrl(jwtMountPath: string, jwtOidcRequestAuthorizationUrlRequest: JwtOidcRequestAuthorizationUrlRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read the current JWT authentication backend configuration.
     */
    jwtReadConfigurationRaw(requestParameters: AuthApiJwtReadConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read the current JWT authentication backend configuration.
     */
    jwtReadConfiguration(jwtMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Read an existing role.
     */
    jwtReadRoleRaw(requestParameters: AuthApiJwtReadRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Read an existing role.
     */
    jwtReadRole(name: string, jwtMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * A role is required to authenticate with this backend. The role binds   JWT token information with token policies and settings.   The bindings, token polices and token settings can all be configured   using this endpoint
     * Register an role with the backend.
     */
    jwtWriteRoleRaw(requestParameters: AuthApiJwtWriteRoleOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * A role is required to authenticate with this backend. The role binds   JWT token information with token policies and settings.   The bindings, token polices and token settings can all be configured   using this endpoint
     * Register an role with the backend.
     */
    jwtWriteRole(name: string, jwtMountPath: string, jwtWriteRoleRequest: JwtWriteRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    kerberosConfigureRaw(requestParameters: AuthApiKerberosConfigureOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    kerberosConfigure(kerberosMountPath: string, kerberosConfigureRequest: KerberosConfigureRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    kerberosConfigureLdapRaw(requestParameters: AuthApiKerberosConfigureLdapOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    kerberosConfigureLdap(kerberosMountPath: string, kerberosConfigureLdapRequest: KerberosConfigureLdapRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    kerberosDeleteGroupRaw(requestParameters: AuthApiKerberosDeleteGroupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    kerberosDeleteGroup(name: string, kerberosMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    kerberosListGroupsRaw(requestParameters: AuthApiKerberosListGroupsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     */
    kerberosListGroups(kerberosMountPath: string, list: KerberosListGroupsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    kerberosLoginRaw(requestParameters: AuthApiKerberosLoginOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    kerberosLogin(kerberosMountPath: string, kerberosLoginRequest: KerberosLoginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    kerberosLogin2Raw(requestParameters: AuthApiKerberosLogin2Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    kerberosLogin2(kerberosMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    kerberosReadConfigurationRaw(requestParameters: AuthApiKerberosReadConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    kerberosReadConfiguration(kerberosMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    kerberosReadGroupRaw(requestParameters: AuthApiKerberosReadGroupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    kerberosReadGroup(name: string, kerberosMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    kerberosReadLdapConfigurationRaw(requestParameters: AuthApiKerberosReadLdapConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    kerberosReadLdapConfiguration(kerberosMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    kerberosWriteGroupRaw(requestParameters: AuthApiKerberosWriteGroupOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    kerberosWriteGroup(name: string, kerberosMountPath: string, kerberosWriteGroupRequest: KerberosWriteGroupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    kubernetesConfigureAuthRaw(requestParameters: AuthApiKubernetesConfigureAuthOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    kubernetesConfigureAuth(kubernetesMountPath: string, kubernetesConfigureAuthRequest: KubernetesConfigureAuthRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Register an role with the backend.
     */
    kubernetesDeleteAuthRoleRaw(requestParameters: AuthApiKubernetesDeleteAuthRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Register an role with the backend.
     */
    kubernetesDeleteAuthRole(name: string, kubernetesMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Lists all the roles registered with the backend.
     */
    kubernetesListAuthRolesRaw(requestParameters: AuthApiKubernetesListAuthRolesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * Lists all the roles registered with the backend.
     */
    kubernetesListAuthRoles(kubernetesMountPath: string, list: KubernetesListAuthRolesListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * Authenticates Kubernetes service accounts with Vault.
     */
    kubernetesLoginRaw(requestParameters: AuthApiKubernetesLoginOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Authenticates Kubernetes service accounts with Vault.
     */
    kubernetesLogin(kubernetesMountPath: string, kubernetesLoginRequest: KubernetesLoginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    kubernetesReadAuthConfigurationRaw(requestParameters: AuthApiKubernetesReadAuthConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    kubernetesReadAuthConfiguration(kubernetesMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Register an role with the backend.
     */
    kubernetesReadAuthRoleRaw(requestParameters: AuthApiKubernetesReadAuthRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Register an role with the backend.
     */
    kubernetesReadAuthRole(name: string, kubernetesMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Register an role with the backend.
     */
    kubernetesWriteAuthRoleRaw(requestParameters: AuthApiKubernetesWriteAuthRoleOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Register an role with the backend.
     */
    kubernetesWriteAuthRole(name: string, kubernetesMountPath: string, kubernetesWriteAuthRoleRequest: KubernetesWriteAuthRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    ldapConfigureAuthRaw(requestParameters: AuthApiLdapConfigureAuthOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    ldapConfigureAuth(ldapMountPath: string, ldapConfigureAuthRequest: LdapConfigureAuthRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    ldapDeleteGroupRaw(requestParameters: AuthApiLdapDeleteGroupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    ldapDeleteGroup(name: string, ldapMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage users allowed to authenticate.
     */
    ldapDeleteUserRaw(requestParameters: AuthApiLdapDeleteUserRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage users allowed to authenticate.
     */
    ldapDeleteUser(name: string, ldapMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    ldapListGroupsRaw(requestParameters: AuthApiLdapListGroupsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    ldapListGroups(ldapMountPath: string, list: LdapListGroupsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * Manage users allowed to authenticate.
     */
    ldapListUsersRaw(requestParameters: AuthApiLdapListUsersRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * Manage users allowed to authenticate.
     */
    ldapListUsers(ldapMountPath: string, list: LdapListUsersListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * Log in with a username and password.
     */
    ldapLoginRaw(requestParameters: AuthApiLdapLoginOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Log in with a username and password.
     */
    ldapLogin(username: string, ldapMountPath: string, ldapLoginRequest: LdapLoginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    ldapReadAuthConfigurationRaw(requestParameters: AuthApiLdapReadAuthConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    ldapReadAuthConfiguration(ldapMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    ldapReadGroupRaw(requestParameters: AuthApiLdapReadGroupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    ldapReadGroup(name: string, ldapMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage users allowed to authenticate.
     */
    ldapReadUserRaw(requestParameters: AuthApiLdapReadUserRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage users allowed to authenticate.
     */
    ldapReadUser(name: string, ldapMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    ldapRotateRootCredentialsRaw(requestParameters: AuthApiLdapRotateRootCredentialsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    ldapRotateRootCredentials(ldapMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    ldapWriteGroupRaw(requestParameters: AuthApiLdapWriteGroupOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    ldapWriteGroup(name: string, ldapMountPath: string, ldapWriteGroupRequest: LdapWriteGroupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage users allowed to authenticate.
     */
    ldapWriteUserRaw(requestParameters: AuthApiLdapWriteUserOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage users allowed to authenticate.
     */
    ldapWriteUser(name: string, ldapMountPath: string, ldapWriteUserRequest: LdapWriteUserRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    ociConfigureRaw(requestParameters: AuthApiOciConfigureOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    ociConfigure(ociMountPath: string, ociConfigureRequest: OciConfigureRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    ociDeleteConfigurationRaw(requestParameters: AuthApiOciDeleteConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    ociDeleteConfiguration(ociMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Create a role and associate policies to it.
     */
    ociDeleteRoleRaw(requestParameters: AuthApiOciDeleteRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Create a role and associate policies to it.
     */
    ociDeleteRole(role: string, ociMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Lists all the roles that are registered with Vault.
     */
    ociListRolesRaw(requestParameters: AuthApiOciListRolesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * Lists all the roles that are registered with Vault.
     */
    ociListRoles(ociMountPath: string, list: OciListRolesListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * Authenticates to Vault using OCI credentials
     */
    ociLoginRaw(requestParameters: AuthApiOciLoginOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Authenticates to Vault using OCI credentials
     */
    ociLogin(role: string, ociMountPath: string, ociLoginRequest: OciLoginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    ociReadConfigurationRaw(requestParameters: AuthApiOciReadConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    ociReadConfiguration(ociMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Create a role and associate policies to it.
     */
    ociReadRoleRaw(requestParameters: AuthApiOciReadRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Create a role and associate policies to it.
     */
    ociReadRole(role: string, ociMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Create a role and associate policies to it.
     */
    ociWriteRoleRaw(requestParameters: AuthApiOciWriteRoleOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Create a role and associate policies to it.
     */
    ociWriteRole(role: string, ociMountPath: string, ociWriteRoleRequest: OciWriteRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oktaConfigureRaw(requestParameters: AuthApiOktaConfigureOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oktaConfigure(oktaMountPath: string, oktaConfigureRequest: OktaConfigureRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage users allowed to authenticate.
     */
    oktaDeleteGroupRaw(requestParameters: AuthApiOktaDeleteGroupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage users allowed to authenticate.
     */
    oktaDeleteGroup(name: string, oktaMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    oktaDeleteUserRaw(requestParameters: AuthApiOktaDeleteUserRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    oktaDeleteUser(name: string, oktaMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage users allowed to authenticate.
     */
    oktaListGroupsRaw(requestParameters: AuthApiOktaListGroupsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * Manage users allowed to authenticate.
     */
    oktaListGroups(oktaMountPath: string, list: OktaListGroupsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    oktaListUsersRaw(requestParameters: AuthApiOktaListUsersRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    oktaListUsers(oktaMountPath: string, list: OktaListUsersListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * Log in with a username and password.
     */
    oktaLoginRaw(requestParameters: AuthApiOktaLoginOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Log in with a username and password.
     */
    oktaLogin(username: string, oktaMountPath: string, oktaLoginRequest: OktaLoginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oktaReadConfigurationRaw(requestParameters: AuthApiOktaReadConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oktaReadConfiguration(oktaMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage users allowed to authenticate.
     */
    oktaReadGroupRaw(requestParameters: AuthApiOktaReadGroupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage users allowed to authenticate.
     */
    oktaReadGroup(name: string, oktaMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    oktaReadUserRaw(requestParameters: AuthApiOktaReadUserRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    oktaReadUser(name: string, oktaMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    oktaVerifyRaw(requestParameters: AuthApiOktaVerifyRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    oktaVerify(nonce: string, oktaMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage users allowed to authenticate.
     */
    oktaWriteGroupRaw(requestParameters: AuthApiOktaWriteGroupOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage users allowed to authenticate.
     */
    oktaWriteGroup(name: string, oktaMountPath: string, oktaWriteGroupRequest: OktaWriteGroupRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    oktaWriteUserRaw(requestParameters: AuthApiOktaWriteUserOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    oktaWriteUser(name: string, oktaMountPath: string, oktaWriteUserRequest: OktaWriteUserRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    radiusConfigureRaw(requestParameters: AuthApiRadiusConfigureOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    radiusConfigure(radiusMountPath: string, radiusConfigureRequest: RadiusConfigureRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage users allowed to authenticate.
     */
    radiusDeleteUserRaw(requestParameters: AuthApiRadiusDeleteUserRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage users allowed to authenticate.
     */
    radiusDeleteUser(name: string, radiusMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage users allowed to authenticate.
     */
    radiusListUsersRaw(requestParameters: AuthApiRadiusListUsersRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * Manage users allowed to authenticate.
     */
    radiusListUsers(radiusMountPath: string, list: RadiusListUsersListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * Log in with a username and password.
     */
    radiusLoginRaw(requestParameters: AuthApiRadiusLoginOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Log in with a username and password.
     */
    radiusLogin(radiusMountPath: string, radiusLoginRequest: RadiusLoginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Log in with a username and password.
     */
    radiusLoginWithUsernameRaw(requestParameters: AuthApiRadiusLoginWithUsernameOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Log in with a username and password.
     */
    radiusLoginWithUsername(urlusername: string, radiusMountPath: string, radiusLoginWithUsernameRequest: RadiusLoginWithUsernameRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    radiusReadConfigurationRaw(requestParameters: AuthApiRadiusReadConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    radiusReadConfiguration(radiusMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage users allowed to authenticate.
     */
    radiusReadUserRaw(requestParameters: AuthApiRadiusReadUserRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage users allowed to authenticate.
     */
    radiusReadUser(name: string, radiusMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage users allowed to authenticate.
     */
    radiusWriteUserRaw(requestParameters: AuthApiRadiusWriteUserOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage users allowed to authenticate.
     */
    radiusWriteUser(name: string, radiusMountPath: string, radiusWriteUserRequest: RadiusWriteUserRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * The token create path is used to create new tokens.
     */
    tokenCreateRaw(requestParameters: AuthApiTokenCreateOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * The token create path is used to create new tokens.
     */
    tokenCreate(tokenCreateRequest: TokenCreateRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * This token create path is used to create new tokens adhering to the given role.
     */
    tokenCreateAgainstRoleRaw(requestParameters: AuthApiTokenCreateAgainstRoleOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * This token create path is used to create new tokens adhering to the given role.
     */
    tokenCreateAgainstRole(roleName: string, tokenCreateAgainstRoleRequest: TokenCreateAgainstRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * The token create path is used to create new orphan tokens.
     */
    tokenCreateOrphanRaw(requestParameters: AuthApiTokenCreateOrphanOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * The token create path is used to create new orphan tokens.
     */
    tokenCreateOrphan(tokenCreateOrphanRequest: TokenCreateOrphanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    tokenDeleteRoleRaw(requestParameters: AuthApiTokenDeleteRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    tokenDeleteRole(roleName: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * List token accessors, which can then be be used to iterate and discover their properties or revoke them. Because this can be used to cause a denial of service, this endpoint requires \'sudo\' capability in addition to \'list\'.
     */
    tokenListAccessorsRaw(requestParameters: AuthApiTokenListAccessorsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * List token accessors, which can then be be used to iterate and discover their properties or revoke them. Because this can be used to cause a denial of service, this endpoint requires \'sudo\' capability in addition to \'list\'.
     */
    tokenListAccessors(list: TokenListAccessorsListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * This endpoint lists configured roles.
     */
    tokenListRolesRaw(requestParameters: AuthApiTokenListRolesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * This endpoint lists configured roles.
     */
    tokenListRoles(list: TokenListRolesListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     */
    tokenLookUpRaw(requestParameters: AuthApiTokenLookUpOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    tokenLookUp(tokenLookUpRequest: TokenLookUpRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    tokenLookUp2Raw(requestParameters: AuthApiTokenLookUp2Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    tokenLookUp2(token?: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * This endpoint will lookup a token associated with the given accessor and its properties. Response will not contain the token ID.
     */
    tokenLookUpAccessorRaw(requestParameters: AuthApiTokenLookUpAccessorOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * This endpoint will lookup a token associated with the given accessor and its properties. Response will not contain the token ID.
     */
    tokenLookUpAccessor(tokenLookUpAccessorRequest: TokenLookUpAccessorRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    tokenLookUpSelfRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    tokenLookUpSelf(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    tokenLookUpSelf2Raw(requestParameters: AuthApiTokenLookUpSelf2OperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    tokenLookUpSelf2(tokenLookUpSelf2Request: TokenLookUpSelf2Request, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    tokenReadRoleRaw(requestParameters: AuthApiTokenReadRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    tokenReadRole(roleName: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * This endpoint will renew the given token and prevent expiration.
     */
    tokenRenewRaw(requestParameters: AuthApiTokenRenewOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * This endpoint will renew the given token and prevent expiration.
     */
    tokenRenew(tokenRenewRequest: TokenRenewRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * This endpoint will renew a token associated with the given accessor and its properties. Response will not contain the token ID.
     */
    tokenRenewAccessorRaw(requestParameters: AuthApiTokenRenewAccessorOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * This endpoint will renew a token associated with the given accessor and its properties. Response will not contain the token ID.
     */
    tokenRenewAccessor(tokenRenewAccessorRequest: TokenRenewAccessorRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * This endpoint will renew the token used to call it and prevent expiration.
     */
    tokenRenewSelfRaw(requestParameters: AuthApiTokenRenewSelfOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * This endpoint will renew the token used to call it and prevent expiration.
     */
    tokenRenewSelf(tokenRenewSelfRequest: TokenRenewSelfRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * This endpoint will delete the given token and all of its child tokens.
     */
    tokenRevokeRaw(requestParameters: AuthApiTokenRevokeOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * This endpoint will delete the given token and all of its child tokens.
     */
    tokenRevoke(tokenRevokeRequest: TokenRevokeRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * This endpoint will delete the token associated with the accessor and all of its child tokens.
     */
    tokenRevokeAccessorRaw(requestParameters: AuthApiTokenRevokeAccessorOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * This endpoint will delete the token associated with the accessor and all of its child tokens.
     */
    tokenRevokeAccessor(tokenRevokeAccessorRequest: TokenRevokeAccessorRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * This endpoint will delete the token and orphan its child tokens.
     */
    tokenRevokeOrphanRaw(requestParameters: AuthApiTokenRevokeOrphanOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * This endpoint will delete the token and orphan its child tokens.
     */
    tokenRevokeOrphan(tokenRevokeOrphanRequest: TokenRevokeOrphanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * This endpoint will delete the token used to call it and all of its child tokens.
     */
    tokenRevokeSelfRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * This endpoint will delete the token used to call it and all of its child tokens.
     */
    tokenRevokeSelf(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * This endpoint performs cleanup tasks that can be run if certain error conditions have occurred.
     */
    tokenTidyRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * This endpoint performs cleanup tasks that can be run if certain error conditions have occurred.
     */
    tokenTidy(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     */
    tokenWriteRoleRaw(requestParameters: AuthApiTokenWriteRoleOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     */
    tokenWriteRole(roleName: string, tokenWriteRoleRequest: TokenWriteRoleRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage users allowed to authenticate.
     */
    userpassDeleteUserRaw(requestParameters: AuthApiUserpassDeleteUserRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage users allowed to authenticate.
     */
    userpassDeleteUser(username: string, userpassMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage users allowed to authenticate.
     */
    userpassListUsersRaw(requestParameters: AuthApiUserpassListUsersRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<StandardListResponse>>;
    /**
     * Manage users allowed to authenticate.
     */
    userpassListUsers(userpassMountPath: string, list: UserpassListUsersListEnum, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<StandardListResponse>;
    /**
     * Log in with a username and password.
     */
    userpassLoginRaw(requestParameters: AuthApiUserpassLoginOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Log in with a username and password.
     */
    userpassLogin(username: string, userpassMountPath: string, userpassLoginRequest: UserpassLoginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage users allowed to authenticate.
     */
    userpassReadUserRaw(requestParameters: AuthApiUserpassReadUserRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage users allowed to authenticate.
     */
    userpassReadUser(username: string, userpassMountPath: string, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Reset user\'s password.
     */
    userpassResetPasswordRaw(requestParameters: AuthApiUserpassResetPasswordOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Reset user\'s password.
     */
    userpassResetPassword(username: string, userpassMountPath: string, userpassResetPasswordRequest: UserpassResetPasswordRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Update the policies associated with the username.
     */
    userpassUpdatePoliciesRaw(requestParameters: AuthApiUserpassUpdatePoliciesOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Update the policies associated with the username.
     */
    userpassUpdatePolicies(username: string, userpassMountPath: string, userpassUpdatePoliciesRequest: UserpassUpdatePoliciesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
    /**
     * Manage users allowed to authenticate.
     */
    userpassWriteUserRaw(requestParameters: AuthApiUserpassWriteUserOperationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<runtime.VoidResponse>>;
    /**
     * Manage users allowed to authenticate.
     */
    userpassWriteUser(username: string, userpassMountPath: string, userpassWriteUserRequest: UserpassWriteUserRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.VoidResponse>;
}
/**
  * @export
  * @enum {string}
  */
export declare enum AliCloudListAuthRolesListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum AliCloudListAuthRoles2ListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum AppRoleListRolesListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum AppRoleListSecretIdsListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum AwsListAuthRolesListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum AwsListAuthRoles2ListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum AwsListCertificateConfigurationsListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum AwsListIdentityAccessListListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum AwsListIdentityWhitelistListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum AwsListRoleTagBlacklistsListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum AwsListRoleTagDenyListsListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum AwsListStsRoleRelationshipsListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum AzureListAuthRolesListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum CertListCertificatesListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum CertListCrlsListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum CloudFoundryListRolesListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum GithubListTeamsListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum GithubListUsersListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum GoogleCloudListRolesListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum GoogleCloudListRoles2ListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum JwtListRolesListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum KerberosListGroupsListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum KubernetesListAuthRolesListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum LdapListGroupsListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum LdapListUsersListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum OciListRolesListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum OktaListGroupsListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum OktaListUsersListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum RadiusListUsersListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum TokenListAccessorsListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum TokenListRolesListEnum {
    TRUE = "true"
}
/**
  * @export
  * @enum {string}
  */
export declare enum UserpassListUsersListEnum {
    TRUE = "true"
}
