"use strict";
/* tslint:disable */
/* eslint-disable */
/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserpassListUsersListEnum = exports.TokenListRolesListEnum = exports.TokenListAccessorsListEnum = exports.RadiusListUsersListEnum = exports.OktaListUsersListEnum = exports.OktaListGroupsListEnum = exports.OciListRolesListEnum = exports.LdapListUsersListEnum = exports.LdapListGroupsListEnum = exports.KubernetesListAuthRolesListEnum = exports.KerberosListGroupsListEnum = exports.JwtListRolesListEnum = exports.GoogleCloudListRoles2ListEnum = exports.GoogleCloudListRolesListEnum = exports.GithubListUsersListEnum = exports.GithubListTeamsListEnum = exports.CloudFoundryListRolesListEnum = exports.CertListCrlsListEnum = exports.CertListCertificatesListEnum = exports.AzureListAuthRolesListEnum = exports.AwsListStsRoleRelationshipsListEnum = exports.AwsListRoleTagDenyListsListEnum = exports.AwsListRoleTagBlacklistsListEnum = exports.AwsListIdentityWhitelistListEnum = exports.AwsListIdentityAccessListListEnum = exports.AwsListCertificateConfigurationsListEnum = exports.AwsListAuthRoles2ListEnum = exports.AwsListAuthRolesListEnum = exports.AppRoleListSecretIdsListEnum = exports.AppRoleListRolesListEnum = exports.AliCloudListAuthRoles2ListEnum = exports.AliCloudListAuthRolesListEnum = exports.AuthApi = void 0;
const runtime = require("../runtime");
const index_1 = require("../models/index");
/**
 *
 */
class AuthApi extends runtime.BaseAPI {
    /**
     * Create a role and associate policies to it.
     */
    aliCloudDeleteAuthRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['role'] == null) {
                throw new runtime.RequiredError('role', 'Required parameter "role" was null or undefined when calling aliCloudDeleteAuthRole().');
            }
            if (requestParameters['alicloudMountPath'] == null) {
                throw new runtime.RequiredError('alicloudMountPath', 'Required parameter "alicloudMountPath" was null or undefined when calling aliCloudDeleteAuthRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{alicloud_mount_path}/role/{role}`.replace(`{${"role"}}`, encodeURIComponent(String(requestParameters['role']))).replace(`{${"alicloud_mount_path"}}`, encodeURIComponent(String(requestParameters['alicloudMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Create a role and associate policies to it.
     */
    aliCloudDeleteAuthRole(role, alicloudMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.aliCloudDeleteAuthRoleRaw({ role: role, alicloudMountPath: alicloudMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Lists all the roles that are registered with Vault.
     */
    aliCloudListAuthRolesRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['alicloudMountPath'] == null) {
                throw new runtime.RequiredError('alicloudMountPath', 'Required parameter "alicloudMountPath" was null or undefined when calling aliCloudListAuthRoles().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling aliCloudListAuthRoles().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{alicloud_mount_path}/role/`.replace(`{${"alicloud_mount_path"}}`, encodeURIComponent(String(requestParameters['alicloudMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     * Lists all the roles that are registered with Vault.
     */
    aliCloudListAuthRoles(alicloudMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.aliCloudListAuthRolesRaw({ alicloudMountPath: alicloudMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Lists all the roles that are registered with Vault.
     */
    aliCloudListAuthRoles2Raw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['alicloudMountPath'] == null) {
                throw new runtime.RequiredError('alicloudMountPath', 'Required parameter "alicloudMountPath" was null or undefined when calling aliCloudListAuthRoles2().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling aliCloudListAuthRoles2().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{alicloud_mount_path}/roles/`.replace(`{${"alicloud_mount_path"}}`, encodeURIComponent(String(requestParameters['alicloudMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     * Lists all the roles that are registered with Vault.
     */
    aliCloudListAuthRoles2(alicloudMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.aliCloudListAuthRoles2Raw({ alicloudMountPath: alicloudMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Authenticates an RAM entity with Vault.
     */
    aliCloudLoginRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['alicloudMountPath'] == null) {
                throw new runtime.RequiredError('alicloudMountPath', 'Required parameter "alicloudMountPath" was null or undefined when calling aliCloudLogin().');
            }
            if (requestParameters['aliCloudLoginRequest'] == null) {
                throw new runtime.RequiredError('aliCloudLoginRequest', 'Required parameter "aliCloudLoginRequest" was null or undefined when calling aliCloudLogin().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{alicloud_mount_path}/login`.replace(`{${"alicloud_mount_path"}}`, encodeURIComponent(String(requestParameters['alicloudMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AliCloudLoginRequestToJSON)(requestParameters['aliCloudLoginRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Authenticates an RAM entity with Vault.
     */
    aliCloudLogin(alicloudMountPath, aliCloudLoginRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.aliCloudLoginRaw({ alicloudMountPath: alicloudMountPath, aliCloudLoginRequest: aliCloudLoginRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Create a role and associate policies to it.
     */
    aliCloudReadAuthRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['role'] == null) {
                throw new runtime.RequiredError('role', 'Required parameter "role" was null or undefined when calling aliCloudReadAuthRole().');
            }
            if (requestParameters['alicloudMountPath'] == null) {
                throw new runtime.RequiredError('alicloudMountPath', 'Required parameter "alicloudMountPath" was null or undefined when calling aliCloudReadAuthRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{alicloud_mount_path}/role/{role}`.replace(`{${"role"}}`, encodeURIComponent(String(requestParameters['role']))).replace(`{${"alicloud_mount_path"}}`, encodeURIComponent(String(requestParameters['alicloudMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Create a role and associate policies to it.
     */
    aliCloudReadAuthRole(role, alicloudMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.aliCloudReadAuthRoleRaw({ role: role, alicloudMountPath: alicloudMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Create a role and associate policies to it.
     */
    aliCloudWriteAuthRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['role'] == null) {
                throw new runtime.RequiredError('role', 'Required parameter "role" was null or undefined when calling aliCloudWriteAuthRole().');
            }
            if (requestParameters['alicloudMountPath'] == null) {
                throw new runtime.RequiredError('alicloudMountPath', 'Required parameter "alicloudMountPath" was null or undefined when calling aliCloudWriteAuthRole().');
            }
            if (requestParameters['aliCloudWriteAuthRoleRequest'] == null) {
                throw new runtime.RequiredError('aliCloudWriteAuthRoleRequest', 'Required parameter "aliCloudWriteAuthRoleRequest" was null or undefined when calling aliCloudWriteAuthRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{alicloud_mount_path}/role/{role}`.replace(`{${"role"}}`, encodeURIComponent(String(requestParameters['role']))).replace(`{${"alicloud_mount_path"}}`, encodeURIComponent(String(requestParameters['alicloudMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AliCloudWriteAuthRoleRequestToJSON)(requestParameters['aliCloudWriteAuthRoleRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Create a role and associate policies to it.
     */
    aliCloudWriteAuthRole(role, alicloudMountPath, aliCloudWriteAuthRoleRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.aliCloudWriteAuthRoleRaw({ role: role, alicloudMountPath: alicloudMountPath, aliCloudWriteAuthRoleRequest: aliCloudWriteAuthRoleRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleDeleteBindSecretIdRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleDeleteBindSecretId().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleDeleteBindSecretId().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/bind-secret-id`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleDeleteBindSecretId(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleDeleteBindSecretIdRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleDeleteBoundCidrListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleDeleteBoundCidrList().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleDeleteBoundCidrList().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/bound-cidr-list`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleDeleteBoundCidrList(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleDeleteBoundCidrListRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleDeletePeriodRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleDeletePeriod().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleDeletePeriod().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/period`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleDeletePeriod(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleDeletePeriodRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleDeletePoliciesRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleDeletePolicies().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleDeletePolicies().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/policies`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleDeletePolicies(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleDeletePoliciesRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleDeleteRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleDeleteRole().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleDeleteRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleDeleteRole(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleDeleteRoleRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleDeleteSecretIdBoundCidrsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleDeleteSecretIdBoundCidrs().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleDeleteSecretIdBoundCidrs().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/secret-id-bound-cidrs`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleDeleteSecretIdBoundCidrs(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleDeleteSecretIdBoundCidrsRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleDeleteSecretIdNumUsesRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleDeleteSecretIdNumUses().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleDeleteSecretIdNumUses().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/secret-id-num-uses`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleDeleteSecretIdNumUses(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleDeleteSecretIdNumUsesRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleDeleteSecretIdTtlRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleDeleteSecretIdTtl().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleDeleteSecretIdTtl().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/secret-id-ttl`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleDeleteSecretIdTtl(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleDeleteSecretIdTtlRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleDeleteTokenBoundCidrsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleDeleteTokenBoundCidrs().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleDeleteTokenBoundCidrs().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/token-bound-cidrs`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleDeleteTokenBoundCidrs(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleDeleteTokenBoundCidrsRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleDeleteTokenMaxTtlRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleDeleteTokenMaxTtl().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleDeleteTokenMaxTtl().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/token-max-ttl`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleDeleteTokenMaxTtl(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleDeleteTokenMaxTtlRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleDeleteTokenNumUsesRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleDeleteTokenNumUses().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleDeleteTokenNumUses().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/token-num-uses`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleDeleteTokenNumUses(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleDeleteTokenNumUsesRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleDeleteTokenTtlRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleDeleteTokenTtl().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleDeleteTokenTtl().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/token-ttl`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleDeleteTokenTtl(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleDeleteTokenTtlRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleDestroySecretIdRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleDestroySecretId().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleDestroySecretId().');
            }
            if (requestParameters['appRoleDestroySecretIdRequest'] == null) {
                throw new runtime.RequiredError('appRoleDestroySecretIdRequest', 'Required parameter "appRoleDestroySecretIdRequest" was null or undefined when calling appRoleDestroySecretId().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/secret-id/destroy`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AppRoleDestroySecretIdRequestToJSON)(requestParameters['appRoleDestroySecretIdRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleDestroySecretId(roleName, approleMountPath, appRoleDestroySecretIdRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleDestroySecretIdRaw({ roleName: roleName, approleMountPath: approleMountPath, appRoleDestroySecretIdRequest: appRoleDestroySecretIdRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleDestroySecretId2Raw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleDestroySecretId2().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleDestroySecretId2().');
            }
            const queryParameters = {};
            if (requestParameters['secretId'] != null) {
                queryParameters['secret_id'] = requestParameters['secretId'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/secret-id/destroy`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleDestroySecretId2(roleName, approleMountPath, secretId, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleDestroySecretId2Raw({ roleName: roleName, approleMountPath: approleMountPath, secretId: secretId }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleDestroySecretIdByAccessorRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleDestroySecretIdByAccessor().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleDestroySecretIdByAccessor().');
            }
            if (requestParameters['appRoleDestroySecretIdByAccessorRequest'] == null) {
                throw new runtime.RequiredError('appRoleDestroySecretIdByAccessorRequest', 'Required parameter "appRoleDestroySecretIdByAccessorRequest" was null or undefined when calling appRoleDestroySecretIdByAccessor().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/secret-id-accessor/destroy`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AppRoleDestroySecretIdByAccessorRequestToJSON)(requestParameters['appRoleDestroySecretIdByAccessorRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleDestroySecretIdByAccessor(roleName, approleMountPath, appRoleDestroySecretIdByAccessorRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleDestroySecretIdByAccessorRaw({ roleName: roleName, approleMountPath: approleMountPath, appRoleDestroySecretIdByAccessorRequest: appRoleDestroySecretIdByAccessorRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleDestroySecretIdByAccessor2Raw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleDestroySecretIdByAccessor2().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleDestroySecretIdByAccessor2().');
            }
            const queryParameters = {};
            if (requestParameters['secretIdAccessor'] != null) {
                queryParameters['secret_id_accessor'] = requestParameters['secretIdAccessor'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/secret-id-accessor/destroy`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleDestroySecretIdByAccessor2(roleName, approleMountPath, secretIdAccessor, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleDestroySecretIdByAccessor2Raw({ roleName: roleName, approleMountPath: approleMountPath, secretIdAccessor: secretIdAccessor }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleListRolesRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleListRoles().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling appRoleListRoles().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/`.replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    appRoleListRoles(approleMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleListRolesRaw({ approleMountPath: approleMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleListSecretIdsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleListSecretIds().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleListSecretIds().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling appRoleListSecretIds().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/secret-id/`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    appRoleListSecretIds(roleName, approleMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleListSecretIdsRaw({ roleName: roleName, approleMountPath: approleMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleLoginRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleLogin().');
            }
            if (requestParameters['appRoleLoginRequest'] == null) {
                throw new runtime.RequiredError('appRoleLoginRequest', 'Required parameter "appRoleLoginRequest" was null or undefined when calling appRoleLogin().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/login`.replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AppRoleLoginRequestToJSON)(requestParameters['appRoleLoginRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleLogin(approleMountPath, appRoleLoginRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleLoginRaw({ approleMountPath: approleMountPath, appRoleLoginRequest: appRoleLoginRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleLookUpSecretIdRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleLookUpSecretId().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleLookUpSecretId().');
            }
            if (requestParameters['appRoleLookUpSecretIdRequest'] == null) {
                throw new runtime.RequiredError('appRoleLookUpSecretIdRequest', 'Required parameter "appRoleLookUpSecretIdRequest" was null or undefined when calling appRoleLookUpSecretId().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/secret-id/lookup`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AppRoleLookUpSecretIdRequestToJSON)(requestParameters['appRoleLookUpSecretIdRequest']),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.AppRoleLookUpSecretIdResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    appRoleLookUpSecretId(roleName, approleMountPath, appRoleLookUpSecretIdRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleLookUpSecretIdRaw({ roleName: roleName, approleMountPath: approleMountPath, appRoleLookUpSecretIdRequest: appRoleLookUpSecretIdRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleLookUpSecretIdByAccessorRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleLookUpSecretIdByAccessor().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleLookUpSecretIdByAccessor().');
            }
            if (requestParameters['appRoleLookUpSecretIdByAccessorRequest'] == null) {
                throw new runtime.RequiredError('appRoleLookUpSecretIdByAccessorRequest', 'Required parameter "appRoleLookUpSecretIdByAccessorRequest" was null or undefined when calling appRoleLookUpSecretIdByAccessor().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/secret-id-accessor/lookup`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AppRoleLookUpSecretIdByAccessorRequestToJSON)(requestParameters['appRoleLookUpSecretIdByAccessorRequest']),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.AppRoleLookUpSecretIdByAccessorResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    appRoleLookUpSecretIdByAccessor(roleName, approleMountPath, appRoleLookUpSecretIdByAccessorRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleLookUpSecretIdByAccessorRaw({ roleName: roleName, approleMountPath: approleMountPath, appRoleLookUpSecretIdByAccessorRequest: appRoleLookUpSecretIdByAccessorRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleReadBindSecretIdRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleReadBindSecretId().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleReadBindSecretId().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/bind-secret-id`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.AppRoleReadBindSecretIdResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    appRoleReadBindSecretId(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleReadBindSecretIdRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleReadBoundCidrListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleReadBoundCidrList().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleReadBoundCidrList().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/bound-cidr-list`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.AppRoleReadBoundCidrListResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    appRoleReadBoundCidrList(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleReadBoundCidrListRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleReadLocalSecretIdsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleReadLocalSecretIds().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleReadLocalSecretIds().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/local-secret-ids`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.AppRoleReadLocalSecretIdsResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    appRoleReadLocalSecretIds(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleReadLocalSecretIdsRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleReadPeriodRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleReadPeriod().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleReadPeriod().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/period`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.AppRoleReadPeriodResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    appRoleReadPeriod(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleReadPeriodRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleReadPoliciesRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleReadPolicies().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleReadPolicies().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/policies`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.AppRoleReadPoliciesResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    appRoleReadPolicies(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleReadPoliciesRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleReadRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleReadRole().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleReadRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.AppRoleReadRoleResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    appRoleReadRole(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleReadRoleRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleReadRoleIdRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleReadRoleId().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleReadRoleId().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/role-id`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.AppRoleReadRoleIdResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    appRoleReadRoleId(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleReadRoleIdRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleReadSecretIdBoundCidrsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleReadSecretIdBoundCidrs().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleReadSecretIdBoundCidrs().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/secret-id-bound-cidrs`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.AppRoleReadSecretIdBoundCidrsResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    appRoleReadSecretIdBoundCidrs(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleReadSecretIdBoundCidrsRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleReadSecretIdNumUsesRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleReadSecretIdNumUses().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleReadSecretIdNumUses().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/secret-id-num-uses`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.AppRoleReadSecretIdNumUsesResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    appRoleReadSecretIdNumUses(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleReadSecretIdNumUsesRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleReadSecretIdTtlRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleReadSecretIdTtl().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleReadSecretIdTtl().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/secret-id-ttl`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.AppRoleReadSecretIdTtlResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    appRoleReadSecretIdTtl(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleReadSecretIdTtlRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleReadTokenBoundCidrsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleReadTokenBoundCidrs().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleReadTokenBoundCidrs().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/token-bound-cidrs`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.AppRoleReadTokenBoundCidrsResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    appRoleReadTokenBoundCidrs(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleReadTokenBoundCidrsRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleReadTokenMaxTtlRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleReadTokenMaxTtl().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleReadTokenMaxTtl().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/token-max-ttl`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.AppRoleReadTokenMaxTtlResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    appRoleReadTokenMaxTtl(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleReadTokenMaxTtlRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleReadTokenNumUsesRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleReadTokenNumUses().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleReadTokenNumUses().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/token-num-uses`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.AppRoleReadTokenNumUsesResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    appRoleReadTokenNumUses(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleReadTokenNumUsesRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleReadTokenTtlRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleReadTokenTtl().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleReadTokenTtl().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/token-ttl`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.AppRoleReadTokenTtlResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    appRoleReadTokenTtl(roleName, approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleReadTokenTtlRaw({ roleName: roleName, approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleTidySecretIdRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleTidySecretId().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/tidy/secret-id`.replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleTidySecretId(approleMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleTidySecretIdRaw({ approleMountPath: approleMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleWriteBindSecretIdRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleWriteBindSecretId().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleWriteBindSecretId().');
            }
            if (requestParameters['appRoleWriteBindSecretIdRequest'] == null) {
                throw new runtime.RequiredError('appRoleWriteBindSecretIdRequest', 'Required parameter "appRoleWriteBindSecretIdRequest" was null or undefined when calling appRoleWriteBindSecretId().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/bind-secret-id`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AppRoleWriteBindSecretIdRequestToJSON)(requestParameters['appRoleWriteBindSecretIdRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleWriteBindSecretId(roleName, approleMountPath, appRoleWriteBindSecretIdRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleWriteBindSecretIdRaw({ roleName: roleName, approleMountPath: approleMountPath, appRoleWriteBindSecretIdRequest: appRoleWriteBindSecretIdRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleWriteBoundCidrListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleWriteBoundCidrList().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleWriteBoundCidrList().');
            }
            if (requestParameters['appRoleWriteBoundCidrListRequest'] == null) {
                throw new runtime.RequiredError('appRoleWriteBoundCidrListRequest', 'Required parameter "appRoleWriteBoundCidrListRequest" was null or undefined when calling appRoleWriteBoundCidrList().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/bound-cidr-list`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AppRoleWriteBoundCidrListRequestToJSON)(requestParameters['appRoleWriteBoundCidrListRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleWriteBoundCidrList(roleName, approleMountPath, appRoleWriteBoundCidrListRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleWriteBoundCidrListRaw({ roleName: roleName, approleMountPath: approleMountPath, appRoleWriteBoundCidrListRequest: appRoleWriteBoundCidrListRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleWriteCustomSecretIdRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleWriteCustomSecretId().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleWriteCustomSecretId().');
            }
            if (requestParameters['appRoleWriteCustomSecretIdRequest'] == null) {
                throw new runtime.RequiredError('appRoleWriteCustomSecretIdRequest', 'Required parameter "appRoleWriteCustomSecretIdRequest" was null or undefined when calling appRoleWriteCustomSecretId().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/custom-secret-id`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AppRoleWriteCustomSecretIdRequestToJSON)(requestParameters['appRoleWriteCustomSecretIdRequest']),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.AppRoleWriteCustomSecretIdResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    appRoleWriteCustomSecretId(roleName, approleMountPath, appRoleWriteCustomSecretIdRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleWriteCustomSecretIdRaw({ roleName: roleName, approleMountPath: approleMountPath, appRoleWriteCustomSecretIdRequest: appRoleWriteCustomSecretIdRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleWritePeriodRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleWritePeriod().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleWritePeriod().');
            }
            if (requestParameters['appRoleWritePeriodRequest'] == null) {
                throw new runtime.RequiredError('appRoleWritePeriodRequest', 'Required parameter "appRoleWritePeriodRequest" was null or undefined when calling appRoleWritePeriod().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/period`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AppRoleWritePeriodRequestToJSON)(requestParameters['appRoleWritePeriodRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleWritePeriod(roleName, approleMountPath, appRoleWritePeriodRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleWritePeriodRaw({ roleName: roleName, approleMountPath: approleMountPath, appRoleWritePeriodRequest: appRoleWritePeriodRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleWritePoliciesRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleWritePolicies().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleWritePolicies().');
            }
            if (requestParameters['appRoleWritePoliciesRequest'] == null) {
                throw new runtime.RequiredError('appRoleWritePoliciesRequest', 'Required parameter "appRoleWritePoliciesRequest" was null or undefined when calling appRoleWritePolicies().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/policies`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AppRoleWritePoliciesRequestToJSON)(requestParameters['appRoleWritePoliciesRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleWritePolicies(roleName, approleMountPath, appRoleWritePoliciesRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleWritePoliciesRaw({ roleName: roleName, approleMountPath: approleMountPath, appRoleWritePoliciesRequest: appRoleWritePoliciesRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleWriteRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleWriteRole().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleWriteRole().');
            }
            if (requestParameters['appRoleWriteRoleRequest'] == null) {
                throw new runtime.RequiredError('appRoleWriteRoleRequest', 'Required parameter "appRoleWriteRoleRequest" was null or undefined when calling appRoleWriteRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AppRoleWriteRoleRequestToJSON)(requestParameters['appRoleWriteRoleRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleWriteRole(roleName, approleMountPath, appRoleWriteRoleRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleWriteRoleRaw({ roleName: roleName, approleMountPath: approleMountPath, appRoleWriteRoleRequest: appRoleWriteRoleRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleWriteRoleIdRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleWriteRoleId().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleWriteRoleId().');
            }
            if (requestParameters['appRoleWriteRoleIdRequest'] == null) {
                throw new runtime.RequiredError('appRoleWriteRoleIdRequest', 'Required parameter "appRoleWriteRoleIdRequest" was null or undefined when calling appRoleWriteRoleId().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/role-id`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AppRoleWriteRoleIdRequestToJSON)(requestParameters['appRoleWriteRoleIdRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleWriteRoleId(roleName, approleMountPath, appRoleWriteRoleIdRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleWriteRoleIdRaw({ roleName: roleName, approleMountPath: approleMountPath, appRoleWriteRoleIdRequest: appRoleWriteRoleIdRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleWriteSecretIdRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleWriteSecretId().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleWriteSecretId().');
            }
            if (requestParameters['appRoleWriteSecretIdRequest'] == null) {
                throw new runtime.RequiredError('appRoleWriteSecretIdRequest', 'Required parameter "appRoleWriteSecretIdRequest" was null or undefined when calling appRoleWriteSecretId().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/secret-id`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AppRoleWriteSecretIdRequestToJSON)(requestParameters['appRoleWriteSecretIdRequest']),
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.AppRoleWriteSecretIdResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    appRoleWriteSecretId(roleName, approleMountPath, appRoleWriteSecretIdRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleWriteSecretIdRaw({ roleName: roleName, approleMountPath: approleMountPath, appRoleWriteSecretIdRequest: appRoleWriteSecretIdRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleWriteSecretIdBoundCidrsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleWriteSecretIdBoundCidrs().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleWriteSecretIdBoundCidrs().');
            }
            if (requestParameters['appRoleWriteSecretIdBoundCidrsRequest'] == null) {
                throw new runtime.RequiredError('appRoleWriteSecretIdBoundCidrsRequest', 'Required parameter "appRoleWriteSecretIdBoundCidrsRequest" was null or undefined when calling appRoleWriteSecretIdBoundCidrs().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/secret-id-bound-cidrs`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AppRoleWriteSecretIdBoundCidrsRequestToJSON)(requestParameters['appRoleWriteSecretIdBoundCidrsRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleWriteSecretIdBoundCidrs(roleName, approleMountPath, appRoleWriteSecretIdBoundCidrsRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleWriteSecretIdBoundCidrsRaw({ roleName: roleName, approleMountPath: approleMountPath, appRoleWriteSecretIdBoundCidrsRequest: appRoleWriteSecretIdBoundCidrsRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleWriteSecretIdNumUsesRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleWriteSecretIdNumUses().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleWriteSecretIdNumUses().');
            }
            if (requestParameters['appRoleWriteSecretIdNumUsesRequest'] == null) {
                throw new runtime.RequiredError('appRoleWriteSecretIdNumUsesRequest', 'Required parameter "appRoleWriteSecretIdNumUsesRequest" was null or undefined when calling appRoleWriteSecretIdNumUses().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/secret-id-num-uses`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AppRoleWriteSecretIdNumUsesRequestToJSON)(requestParameters['appRoleWriteSecretIdNumUsesRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleWriteSecretIdNumUses(roleName, approleMountPath, appRoleWriteSecretIdNumUsesRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleWriteSecretIdNumUsesRaw({ roleName: roleName, approleMountPath: approleMountPath, appRoleWriteSecretIdNumUsesRequest: appRoleWriteSecretIdNumUsesRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleWriteSecretIdTtlRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleWriteSecretIdTtl().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleWriteSecretIdTtl().');
            }
            if (requestParameters['appRoleWriteSecretIdTtlRequest'] == null) {
                throw new runtime.RequiredError('appRoleWriteSecretIdTtlRequest', 'Required parameter "appRoleWriteSecretIdTtlRequest" was null or undefined when calling appRoleWriteSecretIdTtl().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/secret-id-ttl`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AppRoleWriteSecretIdTtlRequestToJSON)(requestParameters['appRoleWriteSecretIdTtlRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleWriteSecretIdTtl(roleName, approleMountPath, appRoleWriteSecretIdTtlRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleWriteSecretIdTtlRaw({ roleName: roleName, approleMountPath: approleMountPath, appRoleWriteSecretIdTtlRequest: appRoleWriteSecretIdTtlRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleWriteTokenBoundCidrsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleWriteTokenBoundCidrs().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleWriteTokenBoundCidrs().');
            }
            if (requestParameters['appRoleWriteTokenBoundCidrsRequest'] == null) {
                throw new runtime.RequiredError('appRoleWriteTokenBoundCidrsRequest', 'Required parameter "appRoleWriteTokenBoundCidrsRequest" was null or undefined when calling appRoleWriteTokenBoundCidrs().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/token-bound-cidrs`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AppRoleWriteTokenBoundCidrsRequestToJSON)(requestParameters['appRoleWriteTokenBoundCidrsRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleWriteTokenBoundCidrs(roleName, approleMountPath, appRoleWriteTokenBoundCidrsRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleWriteTokenBoundCidrsRaw({ roleName: roleName, approleMountPath: approleMountPath, appRoleWriteTokenBoundCidrsRequest: appRoleWriteTokenBoundCidrsRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleWriteTokenMaxTtlRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleWriteTokenMaxTtl().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleWriteTokenMaxTtl().');
            }
            if (requestParameters['appRoleWriteTokenMaxTtlRequest'] == null) {
                throw new runtime.RequiredError('appRoleWriteTokenMaxTtlRequest', 'Required parameter "appRoleWriteTokenMaxTtlRequest" was null or undefined when calling appRoleWriteTokenMaxTtl().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/token-max-ttl`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AppRoleWriteTokenMaxTtlRequestToJSON)(requestParameters['appRoleWriteTokenMaxTtlRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleWriteTokenMaxTtl(roleName, approleMountPath, appRoleWriteTokenMaxTtlRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleWriteTokenMaxTtlRaw({ roleName: roleName, approleMountPath: approleMountPath, appRoleWriteTokenMaxTtlRequest: appRoleWriteTokenMaxTtlRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleWriteTokenNumUsesRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleWriteTokenNumUses().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleWriteTokenNumUses().');
            }
            if (requestParameters['appRoleWriteTokenNumUsesRequest'] == null) {
                throw new runtime.RequiredError('appRoleWriteTokenNumUsesRequest', 'Required parameter "appRoleWriteTokenNumUsesRequest" was null or undefined when calling appRoleWriteTokenNumUses().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/token-num-uses`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AppRoleWriteTokenNumUsesRequestToJSON)(requestParameters['appRoleWriteTokenNumUsesRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleWriteTokenNumUses(roleName, approleMountPath, appRoleWriteTokenNumUsesRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleWriteTokenNumUsesRaw({ roleName: roleName, approleMountPath: approleMountPath, appRoleWriteTokenNumUsesRequest: appRoleWriteTokenNumUsesRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    appRoleWriteTokenTtlRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling appRoleWriteTokenTtl().');
            }
            if (requestParameters['approleMountPath'] == null) {
                throw new runtime.RequiredError('approleMountPath', 'Required parameter "approleMountPath" was null or undefined when calling appRoleWriteTokenTtl().');
            }
            if (requestParameters['appRoleWriteTokenTtlRequest'] == null) {
                throw new runtime.RequiredError('appRoleWriteTokenTtlRequest', 'Required parameter "appRoleWriteTokenTtlRequest" was null or undefined when calling appRoleWriteTokenTtl().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{approle_mount_path}/role/{role_name}/token-ttl`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))).replace(`{${"approle_mount_path"}}`, encodeURIComponent(String(requestParameters['approleMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AppRoleWriteTokenTtlRequestToJSON)(requestParameters['appRoleWriteTokenTtlRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    appRoleWriteTokenTtl(roleName, approleMountPath, appRoleWriteTokenTtlRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.appRoleWriteTokenTtlRaw({ roleName: roleName, approleMountPath: approleMountPath, appRoleWriteTokenTtlRequest: appRoleWriteTokenTtlRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsConfigureCertificateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['certName'] == null) {
                throw new runtime.RequiredError('certName', 'Required parameter "certName" was null or undefined when calling awsConfigureCertificate().');
            }
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsConfigureCertificate().');
            }
            if (requestParameters['awsConfigureCertificateRequest'] == null) {
                throw new runtime.RequiredError('awsConfigureCertificateRequest', 'Required parameter "awsConfigureCertificateRequest" was null or undefined when calling awsConfigureCertificate().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/certificate/{cert_name}`.replace(`{${"cert_name"}}`, encodeURIComponent(String(requestParameters['certName']))).replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AwsConfigureCertificateRequestToJSON)(requestParameters['awsConfigureCertificateRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsConfigureCertificate(certName, awsMountPath, awsConfigureCertificateRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsConfigureCertificateRaw({ certName: certName, awsMountPath: awsMountPath, awsConfigureCertificateRequest: awsConfigureCertificateRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsConfigureClientRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsConfigureClient().');
            }
            if (requestParameters['awsConfigureClientRequest'] == null) {
                throw new runtime.RequiredError('awsConfigureClientRequest', 'Required parameter "awsConfigureClientRequest" was null or undefined when calling awsConfigureClient().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/client`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AwsConfigureClientRequestToJSON)(requestParameters['awsConfigureClientRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsConfigureClient(awsMountPath, awsConfigureClientRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsConfigureClientRaw({ awsMountPath: awsMountPath, awsConfigureClientRequest: awsConfigureClientRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsConfigureIdentityAccessListTidyOperationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsConfigureIdentityAccessListTidyOperation().');
            }
            if (requestParameters['awsConfigureIdentityAccessListTidyOperationRequest'] == null) {
                throw new runtime.RequiredError('awsConfigureIdentityAccessListTidyOperationRequest', 'Required parameter "awsConfigureIdentityAccessListTidyOperationRequest" was null or undefined when calling awsConfigureIdentityAccessListTidyOperation().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/tidy/identity-accesslist`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AwsConfigureIdentityAccessListTidyOperationRequestToJSON)(requestParameters['awsConfigureIdentityAccessListTidyOperationRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsConfigureIdentityAccessListTidyOperation(awsMountPath, awsConfigureIdentityAccessListTidyOperationRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsConfigureIdentityAccessListTidyOperationRaw({ awsMountPath: awsMountPath, awsConfigureIdentityAccessListTidyOperationRequest: awsConfigureIdentityAccessListTidyOperationRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsConfigureIdentityIntegrationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsConfigureIdentityIntegration().');
            }
            if (requestParameters['awsConfigureIdentityIntegrationRequest'] == null) {
                throw new runtime.RequiredError('awsConfigureIdentityIntegrationRequest', 'Required parameter "awsConfigureIdentityIntegrationRequest" was null or undefined when calling awsConfigureIdentityIntegration().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/identity`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AwsConfigureIdentityIntegrationRequestToJSON)(requestParameters['awsConfigureIdentityIntegrationRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsConfigureIdentityIntegration(awsMountPath, awsConfigureIdentityIntegrationRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsConfigureIdentityIntegrationRaw({ awsMountPath: awsMountPath, awsConfigureIdentityIntegrationRequest: awsConfigureIdentityIntegrationRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsConfigureIdentityWhitelistTidyOperationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsConfigureIdentityWhitelistTidyOperation().');
            }
            if (requestParameters['awsConfigureIdentityWhitelistTidyOperationRequest'] == null) {
                throw new runtime.RequiredError('awsConfigureIdentityWhitelistTidyOperationRequest', 'Required parameter "awsConfigureIdentityWhitelistTidyOperationRequest" was null or undefined when calling awsConfigureIdentityWhitelistTidyOperation().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/tidy/identity-whitelist`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AwsConfigureIdentityWhitelistTidyOperationRequestToJSON)(requestParameters['awsConfigureIdentityWhitelistTidyOperationRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsConfigureIdentityWhitelistTidyOperation(awsMountPath, awsConfigureIdentityWhitelistTidyOperationRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsConfigureIdentityWhitelistTidyOperationRaw({ awsMountPath: awsMountPath, awsConfigureIdentityWhitelistTidyOperationRequest: awsConfigureIdentityWhitelistTidyOperationRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsConfigureRoleTagBlacklistTidyOperationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsConfigureRoleTagBlacklistTidyOperation().');
            }
            if (requestParameters['awsConfigureRoleTagBlacklistTidyOperationRequest'] == null) {
                throw new runtime.RequiredError('awsConfigureRoleTagBlacklistTidyOperationRequest', 'Required parameter "awsConfigureRoleTagBlacklistTidyOperationRequest" was null or undefined when calling awsConfigureRoleTagBlacklistTidyOperation().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/tidy/roletag-blacklist`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AwsConfigureRoleTagBlacklistTidyOperationRequestToJSON)(requestParameters['awsConfigureRoleTagBlacklistTidyOperationRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsConfigureRoleTagBlacklistTidyOperation(awsMountPath, awsConfigureRoleTagBlacklistTidyOperationRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsConfigureRoleTagBlacklistTidyOperationRaw({ awsMountPath: awsMountPath, awsConfigureRoleTagBlacklistTidyOperationRequest: awsConfigureRoleTagBlacklistTidyOperationRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsConfigureRoleTagDenyListTidyOperationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsConfigureRoleTagDenyListTidyOperation().');
            }
            if (requestParameters['awsConfigureRoleTagDenyListTidyOperationRequest'] == null) {
                throw new runtime.RequiredError('awsConfigureRoleTagDenyListTidyOperationRequest', 'Required parameter "awsConfigureRoleTagDenyListTidyOperationRequest" was null or undefined when calling awsConfigureRoleTagDenyListTidyOperation().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/tidy/roletag-denylist`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AwsConfigureRoleTagDenyListTidyOperationRequestToJSON)(requestParameters['awsConfigureRoleTagDenyListTidyOperationRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsConfigureRoleTagDenyListTidyOperation(awsMountPath, awsConfigureRoleTagDenyListTidyOperationRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsConfigureRoleTagDenyListTidyOperationRaw({ awsMountPath: awsMountPath, awsConfigureRoleTagDenyListTidyOperationRequest: awsConfigureRoleTagDenyListTidyOperationRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsDeleteAuthRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['role'] == null) {
                throw new runtime.RequiredError('role', 'Required parameter "role" was null or undefined when calling awsDeleteAuthRole().');
            }
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsDeleteAuthRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/role/{role}`.replace(`{${"role"}}`, encodeURIComponent(String(requestParameters['role']))).replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsDeleteAuthRole(role, awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsDeleteAuthRoleRaw({ role: role, awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsDeleteCertificateConfigurationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['certName'] == null) {
                throw new runtime.RequiredError('certName', 'Required parameter "certName" was null or undefined when calling awsDeleteCertificateConfiguration().');
            }
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsDeleteCertificateConfiguration().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/certificate/{cert_name}`.replace(`{${"cert_name"}}`, encodeURIComponent(String(requestParameters['certName']))).replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsDeleteCertificateConfiguration(certName, awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsDeleteCertificateConfigurationRaw({ certName: certName, awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsDeleteClientConfigurationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsDeleteClientConfiguration().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/client`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsDeleteClientConfiguration(awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsDeleteClientConfigurationRaw({ awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsDeleteIdentityAccessListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['instanceId'] == null) {
                throw new runtime.RequiredError('instanceId', 'Required parameter "instanceId" was null or undefined when calling awsDeleteIdentityAccessList().');
            }
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsDeleteIdentityAccessList().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/identity-accesslist/{instance_id}`.replace(`{${"instance_id"}}`, encodeURIComponent(String(requestParameters['instanceId']))).replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsDeleteIdentityAccessList(instanceId, awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsDeleteIdentityAccessListRaw({ instanceId: instanceId, awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsDeleteIdentityAccessListTidySettingsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsDeleteIdentityAccessListTidySettings().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/tidy/identity-accesslist`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsDeleteIdentityAccessListTidySettings(awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsDeleteIdentityAccessListTidySettingsRaw({ awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsDeleteIdentityWhitelistRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['instanceId'] == null) {
                throw new runtime.RequiredError('instanceId', 'Required parameter "instanceId" was null or undefined when calling awsDeleteIdentityWhitelist().');
            }
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsDeleteIdentityWhitelist().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/identity-whitelist/{instance_id}`.replace(`{${"instance_id"}}`, encodeURIComponent(String(requestParameters['instanceId']))).replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsDeleteIdentityWhitelist(instanceId, awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsDeleteIdentityWhitelistRaw({ instanceId: instanceId, awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsDeleteIdentityWhitelistTidySettingsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsDeleteIdentityWhitelistTidySettings().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/tidy/identity-whitelist`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsDeleteIdentityWhitelistTidySettings(awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsDeleteIdentityWhitelistTidySettingsRaw({ awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsDeleteRoleTagBlacklistRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleTag'] == null) {
                throw new runtime.RequiredError('roleTag', 'Required parameter "roleTag" was null or undefined when calling awsDeleteRoleTagBlacklist().');
            }
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsDeleteRoleTagBlacklist().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/roletag-blacklist/{role_tag}`.replace(`{${"role_tag"}}`, encodeURIComponent(String(requestParameters['roleTag']))).replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsDeleteRoleTagBlacklist(roleTag, awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsDeleteRoleTagBlacklistRaw({ roleTag: roleTag, awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsDeleteRoleTagBlacklistTidySettingsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsDeleteRoleTagBlacklistTidySettings().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/tidy/roletag-blacklist`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsDeleteRoleTagBlacklistTidySettings(awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsDeleteRoleTagBlacklistTidySettingsRaw({ awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsDeleteRoleTagDenyListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleTag'] == null) {
                throw new runtime.RequiredError('roleTag', 'Required parameter "roleTag" was null or undefined when calling awsDeleteRoleTagDenyList().');
            }
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsDeleteRoleTagDenyList().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/roletag-denylist/{role_tag}`.replace(`{${"role_tag"}}`, encodeURIComponent(String(requestParameters['roleTag']))).replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsDeleteRoleTagDenyList(roleTag, awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsDeleteRoleTagDenyListRaw({ roleTag: roleTag, awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsDeleteRoleTagDenyListTidySettingsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsDeleteRoleTagDenyListTidySettings().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/tidy/roletag-denylist`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsDeleteRoleTagDenyListTidySettings(awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsDeleteRoleTagDenyListTidySettingsRaw({ awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsDeleteStsRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['accountId'] == null) {
                throw new runtime.RequiredError('accountId', 'Required parameter "accountId" was null or undefined when calling awsDeleteStsRole().');
            }
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsDeleteStsRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/sts/{account_id}`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))).replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsDeleteStsRole(accountId, awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsDeleteStsRoleRaw({ accountId: accountId, awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsListAuthRolesRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsListAuthRoles().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling awsListAuthRoles().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/role/`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    awsListAuthRoles(awsMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsListAuthRolesRaw({ awsMountPath: awsMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsListAuthRoles2Raw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsListAuthRoles2().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling awsListAuthRoles2().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/roles/`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    awsListAuthRoles2(awsMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsListAuthRoles2Raw({ awsMountPath: awsMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsListCertificateConfigurationsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsListCertificateConfigurations().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling awsListCertificateConfigurations().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/certificates/`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    awsListCertificateConfigurations(awsMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsListCertificateConfigurationsRaw({ awsMountPath: awsMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsListIdentityAccessListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsListIdentityAccessList().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling awsListIdentityAccessList().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/identity-accesslist/`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    awsListIdentityAccessList(awsMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsListIdentityAccessListRaw({ awsMountPath: awsMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsListIdentityWhitelistRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsListIdentityWhitelist().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling awsListIdentityWhitelist().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/identity-whitelist/`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    awsListIdentityWhitelist(awsMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsListIdentityWhitelistRaw({ awsMountPath: awsMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsListRoleTagBlacklistsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsListRoleTagBlacklists().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling awsListRoleTagBlacklists().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/roletag-blacklist/`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    awsListRoleTagBlacklists(awsMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsListRoleTagBlacklistsRaw({ awsMountPath: awsMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsListRoleTagDenyListsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsListRoleTagDenyLists().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling awsListRoleTagDenyLists().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/roletag-denylist/`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    awsListRoleTagDenyLists(awsMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsListRoleTagDenyListsRaw({ awsMountPath: awsMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsListStsRoleRelationshipsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsListStsRoleRelationships().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling awsListStsRoleRelationships().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/sts/`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    awsListStsRoleRelationships(awsMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsListStsRoleRelationshipsRaw({ awsMountPath: awsMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsLoginRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsLogin().');
            }
            if (requestParameters['awsLoginRequest'] == null) {
                throw new runtime.RequiredError('awsLoginRequest', 'Required parameter "awsLoginRequest" was null or undefined when calling awsLogin().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/login`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AwsLoginRequestToJSON)(requestParameters['awsLoginRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsLogin(awsMountPath, awsLoginRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsLoginRaw({ awsMountPath: awsMountPath, awsLoginRequest: awsLoginRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsReadAuthRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['role'] == null) {
                throw new runtime.RequiredError('role', 'Required parameter "role" was null or undefined when calling awsReadAuthRole().');
            }
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsReadAuthRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/role/{role}`.replace(`{${"role"}}`, encodeURIComponent(String(requestParameters['role']))).replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsReadAuthRole(role, awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsReadAuthRoleRaw({ role: role, awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsReadCertificateConfigurationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['certName'] == null) {
                throw new runtime.RequiredError('certName', 'Required parameter "certName" was null or undefined when calling awsReadCertificateConfiguration().');
            }
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsReadCertificateConfiguration().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/certificate/{cert_name}`.replace(`{${"cert_name"}}`, encodeURIComponent(String(requestParameters['certName']))).replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsReadCertificateConfiguration(certName, awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsReadCertificateConfigurationRaw({ certName: certName, awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsReadClientConfigurationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsReadClientConfiguration().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/client`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsReadClientConfiguration(awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsReadClientConfigurationRaw({ awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsReadIdentityAccessListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['instanceId'] == null) {
                throw new runtime.RequiredError('instanceId', 'Required parameter "instanceId" was null or undefined when calling awsReadIdentityAccessList().');
            }
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsReadIdentityAccessList().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/identity-accesslist/{instance_id}`.replace(`{${"instance_id"}}`, encodeURIComponent(String(requestParameters['instanceId']))).replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsReadIdentityAccessList(instanceId, awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsReadIdentityAccessListRaw({ instanceId: instanceId, awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsReadIdentityAccessListTidySettingsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsReadIdentityAccessListTidySettings().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/tidy/identity-accesslist`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsReadIdentityAccessListTidySettings(awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsReadIdentityAccessListTidySettingsRaw({ awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsReadIdentityIntegrationConfigurationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsReadIdentityIntegrationConfiguration().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/identity`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsReadIdentityIntegrationConfiguration(awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsReadIdentityIntegrationConfigurationRaw({ awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsReadIdentityWhitelistRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['instanceId'] == null) {
                throw new runtime.RequiredError('instanceId', 'Required parameter "instanceId" was null or undefined when calling awsReadIdentityWhitelist().');
            }
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsReadIdentityWhitelist().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/identity-whitelist/{instance_id}`.replace(`{${"instance_id"}}`, encodeURIComponent(String(requestParameters['instanceId']))).replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsReadIdentityWhitelist(instanceId, awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsReadIdentityWhitelistRaw({ instanceId: instanceId, awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsReadIdentityWhitelistTidySettingsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsReadIdentityWhitelistTidySettings().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/tidy/identity-whitelist`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsReadIdentityWhitelistTidySettings(awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsReadIdentityWhitelistTidySettingsRaw({ awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsReadRoleTagBlacklistRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleTag'] == null) {
                throw new runtime.RequiredError('roleTag', 'Required parameter "roleTag" was null or undefined when calling awsReadRoleTagBlacklist().');
            }
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsReadRoleTagBlacklist().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/roletag-blacklist/{role_tag}`.replace(`{${"role_tag"}}`, encodeURIComponent(String(requestParameters['roleTag']))).replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsReadRoleTagBlacklist(roleTag, awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsReadRoleTagBlacklistRaw({ roleTag: roleTag, awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsReadRoleTagBlacklistTidySettingsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsReadRoleTagBlacklistTidySettings().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/tidy/roletag-blacklist`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsReadRoleTagBlacklistTidySettings(awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsReadRoleTagBlacklistTidySettingsRaw({ awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsReadRoleTagDenyListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleTag'] == null) {
                throw new runtime.RequiredError('roleTag', 'Required parameter "roleTag" was null or undefined when calling awsReadRoleTagDenyList().');
            }
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsReadRoleTagDenyList().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/roletag-denylist/{role_tag}`.replace(`{${"role_tag"}}`, encodeURIComponent(String(requestParameters['roleTag']))).replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsReadRoleTagDenyList(roleTag, awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsReadRoleTagDenyListRaw({ roleTag: roleTag, awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsReadRoleTagDenyListTidySettingsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsReadRoleTagDenyListTidySettings().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/tidy/roletag-denylist`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsReadRoleTagDenyListTidySettings(awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsReadRoleTagDenyListTidySettingsRaw({ awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsReadStsRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['accountId'] == null) {
                throw new runtime.RequiredError('accountId', 'Required parameter "accountId" was null or undefined when calling awsReadStsRole().');
            }
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsReadStsRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/sts/{account_id}`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))).replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsReadStsRole(accountId, awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsReadStsRoleRaw({ accountId: accountId, awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsRotateRootCredentialsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsRotateRootCredentials().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/rotate-root`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsRotateRootCredentials(awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsRotateRootCredentialsRaw({ awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsTidyIdentityAccessListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsTidyIdentityAccessList().');
            }
            if (requestParameters['awsTidyIdentityAccessListRequest'] == null) {
                throw new runtime.RequiredError('awsTidyIdentityAccessListRequest', 'Required parameter "awsTidyIdentityAccessListRequest" was null or undefined when calling awsTidyIdentityAccessList().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/tidy/identity-accesslist`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AwsTidyIdentityAccessListRequestToJSON)(requestParameters['awsTidyIdentityAccessListRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsTidyIdentityAccessList(awsMountPath, awsTidyIdentityAccessListRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsTidyIdentityAccessListRaw({ awsMountPath: awsMountPath, awsTidyIdentityAccessListRequest: awsTidyIdentityAccessListRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsTidyIdentityWhitelistRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsTidyIdentityWhitelist().');
            }
            if (requestParameters['awsTidyIdentityWhitelistRequest'] == null) {
                throw new runtime.RequiredError('awsTidyIdentityWhitelistRequest', 'Required parameter "awsTidyIdentityWhitelistRequest" was null or undefined when calling awsTidyIdentityWhitelist().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/tidy/identity-whitelist`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AwsTidyIdentityWhitelistRequestToJSON)(requestParameters['awsTidyIdentityWhitelistRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsTidyIdentityWhitelist(awsMountPath, awsTidyIdentityWhitelistRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsTidyIdentityWhitelistRaw({ awsMountPath: awsMountPath, awsTidyIdentityWhitelistRequest: awsTidyIdentityWhitelistRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsTidyRoleTagBlacklistRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsTidyRoleTagBlacklist().');
            }
            if (requestParameters['awsTidyRoleTagBlacklistRequest'] == null) {
                throw new runtime.RequiredError('awsTidyRoleTagBlacklistRequest', 'Required parameter "awsTidyRoleTagBlacklistRequest" was null or undefined when calling awsTidyRoleTagBlacklist().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/tidy/roletag-blacklist`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AwsTidyRoleTagBlacklistRequestToJSON)(requestParameters['awsTidyRoleTagBlacklistRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsTidyRoleTagBlacklist(awsMountPath, awsTidyRoleTagBlacklistRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsTidyRoleTagBlacklistRaw({ awsMountPath: awsMountPath, awsTidyRoleTagBlacklistRequest: awsTidyRoleTagBlacklistRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsTidyRoleTagDenyListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsTidyRoleTagDenyList().');
            }
            if (requestParameters['awsTidyRoleTagDenyListRequest'] == null) {
                throw new runtime.RequiredError('awsTidyRoleTagDenyListRequest', 'Required parameter "awsTidyRoleTagDenyListRequest" was null or undefined when calling awsTidyRoleTagDenyList().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/tidy/roletag-denylist`.replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AwsTidyRoleTagDenyListRequestToJSON)(requestParameters['awsTidyRoleTagDenyListRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsTidyRoleTagDenyList(awsMountPath, awsTidyRoleTagDenyListRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsTidyRoleTagDenyListRaw({ awsMountPath: awsMountPath, awsTidyRoleTagDenyListRequest: awsTidyRoleTagDenyListRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsWriteAuthRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['role'] == null) {
                throw new runtime.RequiredError('role', 'Required parameter "role" was null or undefined when calling awsWriteAuthRole().');
            }
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsWriteAuthRole().');
            }
            if (requestParameters['awsWriteAuthRoleRequest'] == null) {
                throw new runtime.RequiredError('awsWriteAuthRoleRequest', 'Required parameter "awsWriteAuthRoleRequest" was null or undefined when calling awsWriteAuthRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/role/{role}`.replace(`{${"role"}}`, encodeURIComponent(String(requestParameters['role']))).replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AwsWriteAuthRoleRequestToJSON)(requestParameters['awsWriteAuthRoleRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsWriteAuthRole(role, awsMountPath, awsWriteAuthRoleRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsWriteAuthRoleRaw({ role: role, awsMountPath: awsMountPath, awsWriteAuthRoleRequest: awsWriteAuthRoleRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsWriteRoleTagRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['role'] == null) {
                throw new runtime.RequiredError('role', 'Required parameter "role" was null or undefined when calling awsWriteRoleTag().');
            }
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsWriteRoleTag().');
            }
            if (requestParameters['awsWriteRoleTagRequest'] == null) {
                throw new runtime.RequiredError('awsWriteRoleTagRequest', 'Required parameter "awsWriteRoleTagRequest" was null or undefined when calling awsWriteRoleTag().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/role/{role}/tag`.replace(`{${"role"}}`, encodeURIComponent(String(requestParameters['role']))).replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AwsWriteRoleTagRequestToJSON)(requestParameters['awsWriteRoleTagRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsWriteRoleTag(role, awsMountPath, awsWriteRoleTagRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsWriteRoleTagRaw({ role: role, awsMountPath: awsMountPath, awsWriteRoleTagRequest: awsWriteRoleTagRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsWriteRoleTagBlacklistRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleTag'] == null) {
                throw new runtime.RequiredError('roleTag', 'Required parameter "roleTag" was null or undefined when calling awsWriteRoleTagBlacklist().');
            }
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsWriteRoleTagBlacklist().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/roletag-blacklist/{role_tag}`.replace(`{${"role_tag"}}`, encodeURIComponent(String(requestParameters['roleTag']))).replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsWriteRoleTagBlacklist(roleTag, awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsWriteRoleTagBlacklistRaw({ roleTag: roleTag, awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsWriteRoleTagDenyListRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleTag'] == null) {
                throw new runtime.RequiredError('roleTag', 'Required parameter "roleTag" was null or undefined when calling awsWriteRoleTagDenyList().');
            }
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsWriteRoleTagDenyList().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/roletag-denylist/{role_tag}`.replace(`{${"role_tag"}}`, encodeURIComponent(String(requestParameters['roleTag']))).replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsWriteRoleTagDenyList(roleTag, awsMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsWriteRoleTagDenyListRaw({ roleTag: roleTag, awsMountPath: awsMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    awsWriteStsRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['accountId'] == null) {
                throw new runtime.RequiredError('accountId', 'Required parameter "accountId" was null or undefined when calling awsWriteStsRole().');
            }
            if (requestParameters['awsMountPath'] == null) {
                throw new runtime.RequiredError('awsMountPath', 'Required parameter "awsMountPath" was null or undefined when calling awsWriteStsRole().');
            }
            if (requestParameters['awsWriteStsRoleRequest'] == null) {
                throw new runtime.RequiredError('awsWriteStsRoleRequest', 'Required parameter "awsWriteStsRoleRequest" was null or undefined when calling awsWriteStsRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{aws_mount_path}/config/sts/{account_id}`.replace(`{${"account_id"}}`, encodeURIComponent(String(requestParameters['accountId']))).replace(`{${"aws_mount_path"}}`, encodeURIComponent(String(requestParameters['awsMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AwsWriteStsRoleRequestToJSON)(requestParameters['awsWriteStsRoleRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    awsWriteStsRole(accountId, awsMountPath, awsWriteStsRoleRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.awsWriteStsRoleRaw({ accountId: accountId, awsMountPath: awsMountPath, awsWriteStsRoleRequest: awsWriteStsRoleRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    azureConfigureAuthRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['azureMountPath'] == null) {
                throw new runtime.RequiredError('azureMountPath', 'Required parameter "azureMountPath" was null or undefined when calling azureConfigureAuth().');
            }
            if (requestParameters['azureConfigureAuthRequest'] == null) {
                throw new runtime.RequiredError('azureConfigureAuthRequest', 'Required parameter "azureConfigureAuthRequest" was null or undefined when calling azureConfigureAuth().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{azure_mount_path}/config`.replace(`{${"azure_mount_path"}}`, encodeURIComponent(String(requestParameters['azureMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AzureConfigureAuthRequestToJSON)(requestParameters['azureConfigureAuthRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    azureConfigureAuth(azureMountPath, azureConfigureAuthRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.azureConfigureAuthRaw({ azureMountPath: azureMountPath, azureConfigureAuthRequest: azureConfigureAuthRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    azureDeleteAuthConfigurationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['azureMountPath'] == null) {
                throw new runtime.RequiredError('azureMountPath', 'Required parameter "azureMountPath" was null or undefined when calling azureDeleteAuthConfiguration().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{azure_mount_path}/config`.replace(`{${"azure_mount_path"}}`, encodeURIComponent(String(requestParameters['azureMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    azureDeleteAuthConfiguration(azureMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.azureDeleteAuthConfigurationRaw({ azureMountPath: azureMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    azureDeleteAuthRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling azureDeleteAuthRole().');
            }
            if (requestParameters['azureMountPath'] == null) {
                throw new runtime.RequiredError('azureMountPath', 'Required parameter "azureMountPath" was null or undefined when calling azureDeleteAuthRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{azure_mount_path}/role/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"azure_mount_path"}}`, encodeURIComponent(String(requestParameters['azureMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    azureDeleteAuthRole(name, azureMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.azureDeleteAuthRoleRaw({ name: name, azureMountPath: azureMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    azureListAuthRolesRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['azureMountPath'] == null) {
                throw new runtime.RequiredError('azureMountPath', 'Required parameter "azureMountPath" was null or undefined when calling azureListAuthRoles().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling azureListAuthRoles().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{azure_mount_path}/role/`.replace(`{${"azure_mount_path"}}`, encodeURIComponent(String(requestParameters['azureMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    azureListAuthRoles(azureMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.azureListAuthRolesRaw({ azureMountPath: azureMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    azureLoginRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['azureMountPath'] == null) {
                throw new runtime.RequiredError('azureMountPath', 'Required parameter "azureMountPath" was null or undefined when calling azureLogin().');
            }
            if (requestParameters['azureLoginRequest'] == null) {
                throw new runtime.RequiredError('azureLoginRequest', 'Required parameter "azureLoginRequest" was null or undefined when calling azureLogin().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{azure_mount_path}/login`.replace(`{${"azure_mount_path"}}`, encodeURIComponent(String(requestParameters['azureMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AzureLoginRequestToJSON)(requestParameters['azureLoginRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    azureLogin(azureMountPath, azureLoginRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.azureLoginRaw({ azureMountPath: azureMountPath, azureLoginRequest: azureLoginRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    azureReadAuthConfigurationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['azureMountPath'] == null) {
                throw new runtime.RequiredError('azureMountPath', 'Required parameter "azureMountPath" was null or undefined when calling azureReadAuthConfiguration().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{azure_mount_path}/config`.replace(`{${"azure_mount_path"}}`, encodeURIComponent(String(requestParameters['azureMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    azureReadAuthConfiguration(azureMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.azureReadAuthConfigurationRaw({ azureMountPath: azureMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    azureReadAuthRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling azureReadAuthRole().');
            }
            if (requestParameters['azureMountPath'] == null) {
                throw new runtime.RequiredError('azureMountPath', 'Required parameter "azureMountPath" was null or undefined when calling azureReadAuthRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{azure_mount_path}/role/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"azure_mount_path"}}`, encodeURIComponent(String(requestParameters['azureMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    azureReadAuthRole(name, azureMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.azureReadAuthRoleRaw({ name: name, azureMountPath: azureMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    azureRotateRootCredentialsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['azureMountPath'] == null) {
                throw new runtime.RequiredError('azureMountPath', 'Required parameter "azureMountPath" was null or undefined when calling azureRotateRootCredentials().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{azure_mount_path}/rotate-root`.replace(`{${"azure_mount_path"}}`, encodeURIComponent(String(requestParameters['azureMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    azureRotateRootCredentials(azureMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.azureRotateRootCredentialsRaw({ azureMountPath: azureMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    azureWriteAuthRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling azureWriteAuthRole().');
            }
            if (requestParameters['azureMountPath'] == null) {
                throw new runtime.RequiredError('azureMountPath', 'Required parameter "azureMountPath" was null or undefined when calling azureWriteAuthRole().');
            }
            if (requestParameters['azureWriteAuthRoleRequest'] == null) {
                throw new runtime.RequiredError('azureWriteAuthRoleRequest', 'Required parameter "azureWriteAuthRoleRequest" was null or undefined when calling azureWriteAuthRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{azure_mount_path}/role/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"azure_mount_path"}}`, encodeURIComponent(String(requestParameters['azureMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.AzureWriteAuthRoleRequestToJSON)(requestParameters['azureWriteAuthRoleRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    azureWriteAuthRole(name, azureMountPath, azureWriteAuthRoleRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.azureWriteAuthRoleRaw({ name: name, azureMountPath: azureMountPath, azureWriteAuthRoleRequest: azureWriteAuthRoleRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    certConfigureRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['certMountPath'] == null) {
                throw new runtime.RequiredError('certMountPath', 'Required parameter "certMountPath" was null or undefined when calling certConfigure().');
            }
            if (requestParameters['certConfigureRequest'] == null) {
                throw new runtime.RequiredError('certConfigureRequest', 'Required parameter "certConfigureRequest" was null or undefined when calling certConfigure().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{cert_mount_path}/config`.replace(`{${"cert_mount_path"}}`, encodeURIComponent(String(requestParameters['certMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.CertConfigureRequestToJSON)(requestParameters['certConfigureRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    certConfigure(certMountPath, certConfigureRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.certConfigureRaw({ certMountPath: certMountPath, certConfigureRequest: certConfigureRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage trusted certificates used for authentication.
     */
    certDeleteCertificateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling certDeleteCertificate().');
            }
            if (requestParameters['certMountPath'] == null) {
                throw new runtime.RequiredError('certMountPath', 'Required parameter "certMountPath" was null or undefined when calling certDeleteCertificate().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{cert_mount_path}/certs/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"cert_mount_path"}}`, encodeURIComponent(String(requestParameters['certMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage trusted certificates used for authentication.
     */
    certDeleteCertificate(name, certMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.certDeleteCertificateRaw({ name: name, certMountPath: certMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage Certificate Revocation Lists checked during authentication.
     */
    certDeleteCrlRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling certDeleteCrl().');
            }
            if (requestParameters['certMountPath'] == null) {
                throw new runtime.RequiredError('certMountPath', 'Required parameter "certMountPath" was null or undefined when calling certDeleteCrl().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{cert_mount_path}/crls/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"cert_mount_path"}}`, encodeURIComponent(String(requestParameters['certMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage Certificate Revocation Lists checked during authentication.
     */
    certDeleteCrl(name, certMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.certDeleteCrlRaw({ name: name, certMountPath: certMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage trusted certificates used for authentication.
     */
    certListCertificatesRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['certMountPath'] == null) {
                throw new runtime.RequiredError('certMountPath', 'Required parameter "certMountPath" was null or undefined when calling certListCertificates().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling certListCertificates().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{cert_mount_path}/certs/`.replace(`{${"cert_mount_path"}}`, encodeURIComponent(String(requestParameters['certMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     * Manage trusted certificates used for authentication.
     */
    certListCertificates(certMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.certListCertificatesRaw({ certMountPath: certMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    certListCrlsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['certMountPath'] == null) {
                throw new runtime.RequiredError('certMountPath', 'Required parameter "certMountPath" was null or undefined when calling certListCrls().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling certListCrls().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{cert_mount_path}/crls/`.replace(`{${"cert_mount_path"}}`, encodeURIComponent(String(requestParameters['certMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    certListCrls(certMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.certListCrlsRaw({ certMountPath: certMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    certLoginRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['certMountPath'] == null) {
                throw new runtime.RequiredError('certMountPath', 'Required parameter "certMountPath" was null or undefined when calling certLogin().');
            }
            if (requestParameters['certLoginRequest'] == null) {
                throw new runtime.RequiredError('certLoginRequest', 'Required parameter "certLoginRequest" was null or undefined when calling certLogin().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{cert_mount_path}/login`.replace(`{${"cert_mount_path"}}`, encodeURIComponent(String(requestParameters['certMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.CertLoginRequestToJSON)(requestParameters['certLoginRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    certLogin(certMountPath, certLoginRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.certLoginRaw({ certMountPath: certMountPath, certLoginRequest: certLoginRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage trusted certificates used for authentication.
     */
    certReadCertificateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling certReadCertificate().');
            }
            if (requestParameters['certMountPath'] == null) {
                throw new runtime.RequiredError('certMountPath', 'Required parameter "certMountPath" was null or undefined when calling certReadCertificate().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{cert_mount_path}/certs/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"cert_mount_path"}}`, encodeURIComponent(String(requestParameters['certMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage trusted certificates used for authentication.
     */
    certReadCertificate(name, certMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.certReadCertificateRaw({ name: name, certMountPath: certMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    certReadConfigurationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['certMountPath'] == null) {
                throw new runtime.RequiredError('certMountPath', 'Required parameter "certMountPath" was null or undefined when calling certReadConfiguration().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{cert_mount_path}/config`.replace(`{${"cert_mount_path"}}`, encodeURIComponent(String(requestParameters['certMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    certReadConfiguration(certMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.certReadConfigurationRaw({ certMountPath: certMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage Certificate Revocation Lists checked during authentication.
     */
    certReadCrlRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling certReadCrl().');
            }
            if (requestParameters['certMountPath'] == null) {
                throw new runtime.RequiredError('certMountPath', 'Required parameter "certMountPath" was null or undefined when calling certReadCrl().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{cert_mount_path}/crls/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"cert_mount_path"}}`, encodeURIComponent(String(requestParameters['certMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage Certificate Revocation Lists checked during authentication.
     */
    certReadCrl(name, certMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.certReadCrlRaw({ name: name, certMountPath: certMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage trusted certificates used for authentication.
     */
    certWriteCertificateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling certWriteCertificate().');
            }
            if (requestParameters['certMountPath'] == null) {
                throw new runtime.RequiredError('certMountPath', 'Required parameter "certMountPath" was null or undefined when calling certWriteCertificate().');
            }
            if (requestParameters['certWriteCertificateRequest'] == null) {
                throw new runtime.RequiredError('certWriteCertificateRequest', 'Required parameter "certWriteCertificateRequest" was null or undefined when calling certWriteCertificate().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{cert_mount_path}/certs/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"cert_mount_path"}}`, encodeURIComponent(String(requestParameters['certMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.CertWriteCertificateRequestToJSON)(requestParameters['certWriteCertificateRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage trusted certificates used for authentication.
     */
    certWriteCertificate(name, certMountPath, certWriteCertificateRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.certWriteCertificateRaw({ name: name, certMountPath: certMountPath, certWriteCertificateRequest: certWriteCertificateRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage Certificate Revocation Lists checked during authentication.
     */
    certWriteCrlRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling certWriteCrl().');
            }
            if (requestParameters['certMountPath'] == null) {
                throw new runtime.RequiredError('certMountPath', 'Required parameter "certMountPath" was null or undefined when calling certWriteCrl().');
            }
            if (requestParameters['certWriteCrlRequest'] == null) {
                throw new runtime.RequiredError('certWriteCrlRequest', 'Required parameter "certWriteCrlRequest" was null or undefined when calling certWriteCrl().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{cert_mount_path}/crls/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"cert_mount_path"}}`, encodeURIComponent(String(requestParameters['certMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.CertWriteCrlRequestToJSON)(requestParameters['certWriteCrlRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage Certificate Revocation Lists checked during authentication.
     */
    certWriteCrl(name, certMountPath, certWriteCrlRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.certWriteCrlRaw({ name: name, certMountPath: certMountPath, certWriteCrlRequest: certWriteCrlRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    cloudFoundryConfigureRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['cfMountPath'] == null) {
                throw new runtime.RequiredError('cfMountPath', 'Required parameter "cfMountPath" was null or undefined when calling cloudFoundryConfigure().');
            }
            if (requestParameters['cloudFoundryConfigureRequest'] == null) {
                throw new runtime.RequiredError('cloudFoundryConfigureRequest', 'Required parameter "cloudFoundryConfigureRequest" was null or undefined when calling cloudFoundryConfigure().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{cf_mount_path}/config`.replace(`{${"cf_mount_path"}}`, encodeURIComponent(String(requestParameters['cfMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.CloudFoundryConfigureRequestToJSON)(requestParameters['cloudFoundryConfigureRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    cloudFoundryConfigure(cfMountPath, cloudFoundryConfigureRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.cloudFoundryConfigureRaw({ cfMountPath: cfMountPath, cloudFoundryConfigureRequest: cloudFoundryConfigureRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    cloudFoundryDeleteConfigurationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['cfMountPath'] == null) {
                throw new runtime.RequiredError('cfMountPath', 'Required parameter "cfMountPath" was null or undefined when calling cloudFoundryDeleteConfiguration().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{cf_mount_path}/config`.replace(`{${"cf_mount_path"}}`, encodeURIComponent(String(requestParameters['cfMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    cloudFoundryDeleteConfiguration(cfMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.cloudFoundryDeleteConfigurationRaw({ cfMountPath: cfMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    cloudFoundryDeleteRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['role'] == null) {
                throw new runtime.RequiredError('role', 'Required parameter "role" was null or undefined when calling cloudFoundryDeleteRole().');
            }
            if (requestParameters['cfMountPath'] == null) {
                throw new runtime.RequiredError('cfMountPath', 'Required parameter "cfMountPath" was null or undefined when calling cloudFoundryDeleteRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{cf_mount_path}/roles/{role}`.replace(`{${"role"}}`, encodeURIComponent(String(requestParameters['role']))).replace(`{${"cf_mount_path"}}`, encodeURIComponent(String(requestParameters['cfMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    cloudFoundryDeleteRole(role, cfMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.cloudFoundryDeleteRoleRaw({ role: role, cfMountPath: cfMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    cloudFoundryListRolesRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['cfMountPath'] == null) {
                throw new runtime.RequiredError('cfMountPath', 'Required parameter "cfMountPath" was null or undefined when calling cloudFoundryListRoles().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling cloudFoundryListRoles().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{cf_mount_path}/roles/`.replace(`{${"cf_mount_path"}}`, encodeURIComponent(String(requestParameters['cfMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    cloudFoundryListRoles(cfMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.cloudFoundryListRolesRaw({ cfMountPath: cfMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    cloudFoundryLoginRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['cfMountPath'] == null) {
                throw new runtime.RequiredError('cfMountPath', 'Required parameter "cfMountPath" was null or undefined when calling cloudFoundryLogin().');
            }
            if (requestParameters['cloudFoundryLoginRequest'] == null) {
                throw new runtime.RequiredError('cloudFoundryLoginRequest', 'Required parameter "cloudFoundryLoginRequest" was null or undefined when calling cloudFoundryLogin().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{cf_mount_path}/login`.replace(`{${"cf_mount_path"}}`, encodeURIComponent(String(requestParameters['cfMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.CloudFoundryLoginRequestToJSON)(requestParameters['cloudFoundryLoginRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    cloudFoundryLogin(cfMountPath, cloudFoundryLoginRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.cloudFoundryLoginRaw({ cfMountPath: cfMountPath, cloudFoundryLoginRequest: cloudFoundryLoginRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    cloudFoundryReadConfigurationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['cfMountPath'] == null) {
                throw new runtime.RequiredError('cfMountPath', 'Required parameter "cfMountPath" was null or undefined when calling cloudFoundryReadConfiguration().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{cf_mount_path}/config`.replace(`{${"cf_mount_path"}}`, encodeURIComponent(String(requestParameters['cfMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    cloudFoundryReadConfiguration(cfMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.cloudFoundryReadConfigurationRaw({ cfMountPath: cfMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    cloudFoundryReadRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['role'] == null) {
                throw new runtime.RequiredError('role', 'Required parameter "role" was null or undefined when calling cloudFoundryReadRole().');
            }
            if (requestParameters['cfMountPath'] == null) {
                throw new runtime.RequiredError('cfMountPath', 'Required parameter "cfMountPath" was null or undefined when calling cloudFoundryReadRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{cf_mount_path}/roles/{role}`.replace(`{${"role"}}`, encodeURIComponent(String(requestParameters['role']))).replace(`{${"cf_mount_path"}}`, encodeURIComponent(String(requestParameters['cfMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    cloudFoundryReadRole(role, cfMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.cloudFoundryReadRoleRaw({ role: role, cfMountPath: cfMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    cloudFoundryWriteRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['role'] == null) {
                throw new runtime.RequiredError('role', 'Required parameter "role" was null or undefined when calling cloudFoundryWriteRole().');
            }
            if (requestParameters['cfMountPath'] == null) {
                throw new runtime.RequiredError('cfMountPath', 'Required parameter "cfMountPath" was null or undefined when calling cloudFoundryWriteRole().');
            }
            if (requestParameters['cloudFoundryWriteRoleRequest'] == null) {
                throw new runtime.RequiredError('cloudFoundryWriteRoleRequest', 'Required parameter "cloudFoundryWriteRoleRequest" was null or undefined when calling cloudFoundryWriteRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{cf_mount_path}/roles/{role}`.replace(`{${"role"}}`, encodeURIComponent(String(requestParameters['role']))).replace(`{${"cf_mount_path"}}`, encodeURIComponent(String(requestParameters['cfMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.CloudFoundryWriteRoleRequestToJSON)(requestParameters['cloudFoundryWriteRoleRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    cloudFoundryWriteRole(role, cfMountPath, cloudFoundryWriteRoleRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.cloudFoundryWriteRoleRaw({ role: role, cfMountPath: cfMountPath, cloudFoundryWriteRoleRequest: cloudFoundryWriteRoleRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    githubConfigureRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['githubMountPath'] == null) {
                throw new runtime.RequiredError('githubMountPath', 'Required parameter "githubMountPath" was null or undefined when calling githubConfigure().');
            }
            if (requestParameters['githubConfigureRequest'] == null) {
                throw new runtime.RequiredError('githubConfigureRequest', 'Required parameter "githubConfigureRequest" was null or undefined when calling githubConfigure().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{github_mount_path}/config`.replace(`{${"github_mount_path"}}`, encodeURIComponent(String(requestParameters['githubMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.GithubConfigureRequestToJSON)(requestParameters['githubConfigureRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    githubConfigure(githubMountPath, githubConfigureRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.githubConfigureRaw({ githubMountPath: githubMountPath, githubConfigureRequest: githubConfigureRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Read/write/delete a single teams mapping
     */
    githubDeleteTeamMappingRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['key'] == null) {
                throw new runtime.RequiredError('key', 'Required parameter "key" was null or undefined when calling githubDeleteTeamMapping().');
            }
            if (requestParameters['githubMountPath'] == null) {
                throw new runtime.RequiredError('githubMountPath', 'Required parameter "githubMountPath" was null or undefined when calling githubDeleteTeamMapping().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{github_mount_path}/map/teams/{key}`.replace(`{${"key"}}`, encodeURIComponent(String(requestParameters['key']))).replace(`{${"github_mount_path"}}`, encodeURIComponent(String(requestParameters['githubMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Read/write/delete a single teams mapping
     */
    githubDeleteTeamMapping(key, githubMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.githubDeleteTeamMappingRaw({ key: key, githubMountPath: githubMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Read/write/delete a single users mapping
     */
    githubDeleteUserMappingRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['key'] == null) {
                throw new runtime.RequiredError('key', 'Required parameter "key" was null or undefined when calling githubDeleteUserMapping().');
            }
            if (requestParameters['githubMountPath'] == null) {
                throw new runtime.RequiredError('githubMountPath', 'Required parameter "githubMountPath" was null or undefined when calling githubDeleteUserMapping().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{github_mount_path}/map/users/{key}`.replace(`{${"key"}}`, encodeURIComponent(String(requestParameters['key']))).replace(`{${"github_mount_path"}}`, encodeURIComponent(String(requestParameters['githubMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Read/write/delete a single users mapping
     */
    githubDeleteUserMapping(key, githubMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.githubDeleteUserMappingRaw({ key: key, githubMountPath: githubMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Read mappings for teams
     */
    githubListTeamsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['githubMountPath'] == null) {
                throw new runtime.RequiredError('githubMountPath', 'Required parameter "githubMountPath" was null or undefined when calling githubListTeams().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling githubListTeams().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{github_mount_path}/map/teams/`.replace(`{${"github_mount_path"}}`, encodeURIComponent(String(requestParameters['githubMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     * Read mappings for teams
     */
    githubListTeams(githubMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.githubListTeamsRaw({ githubMountPath: githubMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Read mappings for teams
     */
    githubListTeams2Raw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['githubMountPath'] == null) {
                throw new runtime.RequiredError('githubMountPath', 'Required parameter "githubMountPath" was null or undefined when calling githubListTeams2().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{github_mount_path}/map/teams`.replace(`{${"github_mount_path"}}`, encodeURIComponent(String(requestParameters['githubMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Read mappings for teams
     */
    githubListTeams2(githubMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.githubListTeams2Raw({ githubMountPath: githubMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Read mappings for users
     */
    githubListUsersRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['githubMountPath'] == null) {
                throw new runtime.RequiredError('githubMountPath', 'Required parameter "githubMountPath" was null or undefined when calling githubListUsers().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling githubListUsers().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{github_mount_path}/map/users/`.replace(`{${"github_mount_path"}}`, encodeURIComponent(String(requestParameters['githubMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     * Read mappings for users
     */
    githubListUsers(githubMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.githubListUsersRaw({ githubMountPath: githubMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Read mappings for users
     */
    githubListUsers2Raw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['githubMountPath'] == null) {
                throw new runtime.RequiredError('githubMountPath', 'Required parameter "githubMountPath" was null or undefined when calling githubListUsers2().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{github_mount_path}/map/users`.replace(`{${"github_mount_path"}}`, encodeURIComponent(String(requestParameters['githubMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Read mappings for users
     */
    githubListUsers2(githubMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.githubListUsers2Raw({ githubMountPath: githubMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    githubLoginRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['githubMountPath'] == null) {
                throw new runtime.RequiredError('githubMountPath', 'Required parameter "githubMountPath" was null or undefined when calling githubLogin().');
            }
            if (requestParameters['githubLoginRequest'] == null) {
                throw new runtime.RequiredError('githubLoginRequest', 'Required parameter "githubLoginRequest" was null or undefined when calling githubLogin().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{github_mount_path}/login`.replace(`{${"github_mount_path"}}`, encodeURIComponent(String(requestParameters['githubMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.GithubLoginRequestToJSON)(requestParameters['githubLoginRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    githubLogin(githubMountPath, githubLoginRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.githubLoginRaw({ githubMountPath: githubMountPath, githubLoginRequest: githubLoginRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    githubReadConfigurationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['githubMountPath'] == null) {
                throw new runtime.RequiredError('githubMountPath', 'Required parameter "githubMountPath" was null or undefined when calling githubReadConfiguration().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{github_mount_path}/config`.replace(`{${"github_mount_path"}}`, encodeURIComponent(String(requestParameters['githubMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    githubReadConfiguration(githubMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.githubReadConfigurationRaw({ githubMountPath: githubMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Read/write/delete a single teams mapping
     */
    githubReadTeamMappingRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['key'] == null) {
                throw new runtime.RequiredError('key', 'Required parameter "key" was null or undefined when calling githubReadTeamMapping().');
            }
            if (requestParameters['githubMountPath'] == null) {
                throw new runtime.RequiredError('githubMountPath', 'Required parameter "githubMountPath" was null or undefined when calling githubReadTeamMapping().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{github_mount_path}/map/teams/{key}`.replace(`{${"key"}}`, encodeURIComponent(String(requestParameters['key']))).replace(`{${"github_mount_path"}}`, encodeURIComponent(String(requestParameters['githubMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Read/write/delete a single teams mapping
     */
    githubReadTeamMapping(key, githubMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.githubReadTeamMappingRaw({ key: key, githubMountPath: githubMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Read/write/delete a single users mapping
     */
    githubReadUserMappingRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['key'] == null) {
                throw new runtime.RequiredError('key', 'Required parameter "key" was null or undefined when calling githubReadUserMapping().');
            }
            if (requestParameters['githubMountPath'] == null) {
                throw new runtime.RequiredError('githubMountPath', 'Required parameter "githubMountPath" was null or undefined when calling githubReadUserMapping().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{github_mount_path}/map/users/{key}`.replace(`{${"key"}}`, encodeURIComponent(String(requestParameters['key']))).replace(`{${"github_mount_path"}}`, encodeURIComponent(String(requestParameters['githubMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Read/write/delete a single users mapping
     */
    githubReadUserMapping(key, githubMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.githubReadUserMappingRaw({ key: key, githubMountPath: githubMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Read/write/delete a single teams mapping
     */
    githubWriteTeamMappingRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['key'] == null) {
                throw new runtime.RequiredError('key', 'Required parameter "key" was null or undefined when calling githubWriteTeamMapping().');
            }
            if (requestParameters['githubMountPath'] == null) {
                throw new runtime.RequiredError('githubMountPath', 'Required parameter "githubMountPath" was null or undefined when calling githubWriteTeamMapping().');
            }
            if (requestParameters['githubWriteTeamMappingRequest'] == null) {
                throw new runtime.RequiredError('githubWriteTeamMappingRequest', 'Required parameter "githubWriteTeamMappingRequest" was null or undefined when calling githubWriteTeamMapping().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{github_mount_path}/map/teams/{key}`.replace(`{${"key"}}`, encodeURIComponent(String(requestParameters['key']))).replace(`{${"github_mount_path"}}`, encodeURIComponent(String(requestParameters['githubMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.GithubWriteTeamMappingRequestToJSON)(requestParameters['githubWriteTeamMappingRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Read/write/delete a single teams mapping
     */
    githubWriteTeamMapping(key, githubMountPath, githubWriteTeamMappingRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.githubWriteTeamMappingRaw({ key: key, githubMountPath: githubMountPath, githubWriteTeamMappingRequest: githubWriteTeamMappingRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Read/write/delete a single users mapping
     */
    githubWriteUserMappingRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['key'] == null) {
                throw new runtime.RequiredError('key', 'Required parameter "key" was null or undefined when calling githubWriteUserMapping().');
            }
            if (requestParameters['githubMountPath'] == null) {
                throw new runtime.RequiredError('githubMountPath', 'Required parameter "githubMountPath" was null or undefined when calling githubWriteUserMapping().');
            }
            if (requestParameters['githubWriteUserMappingRequest'] == null) {
                throw new runtime.RequiredError('githubWriteUserMappingRequest', 'Required parameter "githubWriteUserMappingRequest" was null or undefined when calling githubWriteUserMapping().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{github_mount_path}/map/users/{key}`.replace(`{${"key"}}`, encodeURIComponent(String(requestParameters['key']))).replace(`{${"github_mount_path"}}`, encodeURIComponent(String(requestParameters['githubMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.GithubWriteUserMappingRequestToJSON)(requestParameters['githubWriteUserMappingRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Read/write/delete a single users mapping
     */
    githubWriteUserMapping(key, githubMountPath, githubWriteUserMappingRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.githubWriteUserMappingRaw({ key: key, githubMountPath: githubMountPath, githubWriteUserMappingRequest: githubWriteUserMappingRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    googleCloudConfigureAuthRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['gcpMountPath'] == null) {
                throw new runtime.RequiredError('gcpMountPath', 'Required parameter "gcpMountPath" was null or undefined when calling googleCloudConfigureAuth().');
            }
            if (requestParameters['googleCloudConfigureAuthRequest'] == null) {
                throw new runtime.RequiredError('googleCloudConfigureAuthRequest', 'Required parameter "googleCloudConfigureAuthRequest" was null or undefined when calling googleCloudConfigureAuth().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{gcp_mount_path}/config`.replace(`{${"gcp_mount_path"}}`, encodeURIComponent(String(requestParameters['gcpMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.GoogleCloudConfigureAuthRequestToJSON)(requestParameters['googleCloudConfigureAuthRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    googleCloudConfigureAuth(gcpMountPath, googleCloudConfigureAuthRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.googleCloudConfigureAuthRaw({ gcpMountPath: gcpMountPath, googleCloudConfigureAuthRequest: googleCloudConfigureAuthRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Create a GCP role with associated policies and required attributes.
     */
    googleCloudDeleteRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling googleCloudDeleteRole().');
            }
            if (requestParameters['gcpMountPath'] == null) {
                throw new runtime.RequiredError('gcpMountPath', 'Required parameter "gcpMountPath" was null or undefined when calling googleCloudDeleteRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{gcp_mount_path}/role/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"gcp_mount_path"}}`, encodeURIComponent(String(requestParameters['gcpMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Create a GCP role with associated policies and required attributes.
     */
    googleCloudDeleteRole(name, gcpMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.googleCloudDeleteRoleRaw({ name: name, gcpMountPath: gcpMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Add or remove labels for an existing \'gce\' role
     */
    googleCloudEditLabelsForRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling googleCloudEditLabelsForRole().');
            }
            if (requestParameters['gcpMountPath'] == null) {
                throw new runtime.RequiredError('gcpMountPath', 'Required parameter "gcpMountPath" was null or undefined when calling googleCloudEditLabelsForRole().');
            }
            if (requestParameters['googleCloudEditLabelsForRoleRequest'] == null) {
                throw new runtime.RequiredError('googleCloudEditLabelsForRoleRequest', 'Required parameter "googleCloudEditLabelsForRoleRequest" was null or undefined when calling googleCloudEditLabelsForRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{gcp_mount_path}/role/{name}/labels`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"gcp_mount_path"}}`, encodeURIComponent(String(requestParameters['gcpMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.GoogleCloudEditLabelsForRoleRequestToJSON)(requestParameters['googleCloudEditLabelsForRoleRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Add or remove labels for an existing \'gce\' role
     */
    googleCloudEditLabelsForRole(name, gcpMountPath, googleCloudEditLabelsForRoleRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.googleCloudEditLabelsForRoleRaw({ name: name, gcpMountPath: gcpMountPath, googleCloudEditLabelsForRoleRequest: googleCloudEditLabelsForRoleRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Add or remove service accounts for an existing `iam` role
     */
    googleCloudEditServiceAccountsForRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling googleCloudEditServiceAccountsForRole().');
            }
            if (requestParameters['gcpMountPath'] == null) {
                throw new runtime.RequiredError('gcpMountPath', 'Required parameter "gcpMountPath" was null or undefined when calling googleCloudEditServiceAccountsForRole().');
            }
            if (requestParameters['googleCloudEditServiceAccountsForRoleRequest'] == null) {
                throw new runtime.RequiredError('googleCloudEditServiceAccountsForRoleRequest', 'Required parameter "googleCloudEditServiceAccountsForRoleRequest" was null or undefined when calling googleCloudEditServiceAccountsForRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{gcp_mount_path}/role/{name}/service-accounts`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"gcp_mount_path"}}`, encodeURIComponent(String(requestParameters['gcpMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.GoogleCloudEditServiceAccountsForRoleRequestToJSON)(requestParameters['googleCloudEditServiceAccountsForRoleRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Add or remove service accounts for an existing `iam` role
     */
    googleCloudEditServiceAccountsForRole(name, gcpMountPath, googleCloudEditServiceAccountsForRoleRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.googleCloudEditServiceAccountsForRoleRaw({ name: name, gcpMountPath: gcpMountPath, googleCloudEditServiceAccountsForRoleRequest: googleCloudEditServiceAccountsForRoleRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Lists all the roles that are registered with Vault.
     */
    googleCloudListRolesRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['gcpMountPath'] == null) {
                throw new runtime.RequiredError('gcpMountPath', 'Required parameter "gcpMountPath" was null or undefined when calling googleCloudListRoles().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling googleCloudListRoles().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{gcp_mount_path}/role/`.replace(`{${"gcp_mount_path"}}`, encodeURIComponent(String(requestParameters['gcpMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     * Lists all the roles that are registered with Vault.
     */
    googleCloudListRoles(gcpMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.googleCloudListRolesRaw({ gcpMountPath: gcpMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Lists all the roles that are registered with Vault.
     */
    googleCloudListRoles2Raw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['gcpMountPath'] == null) {
                throw new runtime.RequiredError('gcpMountPath', 'Required parameter "gcpMountPath" was null or undefined when calling googleCloudListRoles2().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling googleCloudListRoles2().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{gcp_mount_path}/roles/`.replace(`{${"gcp_mount_path"}}`, encodeURIComponent(String(requestParameters['gcpMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     * Lists all the roles that are registered with Vault.
     */
    googleCloudListRoles2(gcpMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.googleCloudListRoles2Raw({ gcpMountPath: gcpMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    googleCloudLoginRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['gcpMountPath'] == null) {
                throw new runtime.RequiredError('gcpMountPath', 'Required parameter "gcpMountPath" was null or undefined when calling googleCloudLogin().');
            }
            if (requestParameters['googleCloudLoginRequest'] == null) {
                throw new runtime.RequiredError('googleCloudLoginRequest', 'Required parameter "googleCloudLoginRequest" was null or undefined when calling googleCloudLogin().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{gcp_mount_path}/login`.replace(`{${"gcp_mount_path"}}`, encodeURIComponent(String(requestParameters['gcpMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.GoogleCloudLoginRequestToJSON)(requestParameters['googleCloudLoginRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    googleCloudLogin(gcpMountPath, googleCloudLoginRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.googleCloudLoginRaw({ gcpMountPath: gcpMountPath, googleCloudLoginRequest: googleCloudLoginRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    googleCloudReadAuthConfigurationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['gcpMountPath'] == null) {
                throw new runtime.RequiredError('gcpMountPath', 'Required parameter "gcpMountPath" was null or undefined when calling googleCloudReadAuthConfiguration().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{gcp_mount_path}/config`.replace(`{${"gcp_mount_path"}}`, encodeURIComponent(String(requestParameters['gcpMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    googleCloudReadAuthConfiguration(gcpMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.googleCloudReadAuthConfigurationRaw({ gcpMountPath: gcpMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Create a GCP role with associated policies and required attributes.
     */
    googleCloudReadRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling googleCloudReadRole().');
            }
            if (requestParameters['gcpMountPath'] == null) {
                throw new runtime.RequiredError('gcpMountPath', 'Required parameter "gcpMountPath" was null or undefined when calling googleCloudReadRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{gcp_mount_path}/role/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"gcp_mount_path"}}`, encodeURIComponent(String(requestParameters['gcpMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Create a GCP role with associated policies and required attributes.
     */
    googleCloudReadRole(name, gcpMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.googleCloudReadRoleRaw({ name: name, gcpMountPath: gcpMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    googleCloudRotateRootCredentialsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['gcpMountPath'] == null) {
                throw new runtime.RequiredError('gcpMountPath', 'Required parameter "gcpMountPath" was null or undefined when calling googleCloudRotateRootCredentials().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{gcp_mount_path}/config/rotate-root`.replace(`{${"gcp_mount_path"}}`, encodeURIComponent(String(requestParameters['gcpMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    googleCloudRotateRootCredentials(gcpMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.googleCloudRotateRootCredentialsRaw({ gcpMountPath: gcpMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Create a GCP role with associated policies and required attributes.
     */
    googleCloudWriteRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling googleCloudWriteRole().');
            }
            if (requestParameters['gcpMountPath'] == null) {
                throw new runtime.RequiredError('gcpMountPath', 'Required parameter "gcpMountPath" was null or undefined when calling googleCloudWriteRole().');
            }
            if (requestParameters['googleCloudWriteRoleRequest'] == null) {
                throw new runtime.RequiredError('googleCloudWriteRoleRequest', 'Required parameter "googleCloudWriteRoleRequest" was null or undefined when calling googleCloudWriteRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{gcp_mount_path}/role/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"gcp_mount_path"}}`, encodeURIComponent(String(requestParameters['gcpMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.GoogleCloudWriteRoleRequestToJSON)(requestParameters['googleCloudWriteRoleRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Create a GCP role with associated policies and required attributes.
     */
    googleCloudWriteRole(name, gcpMountPath, googleCloudWriteRoleRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.googleCloudWriteRoleRaw({ name: name, gcpMountPath: gcpMountPath, googleCloudWriteRoleRequest: googleCloudWriteRoleRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * The JWT authentication backend validates JWTs (or OIDC) using the configured credentials. If using OIDC Discovery, the URL must be provided, along with (optionally) the CA cert to use for the connection. If performing JWT validation locally, a set of public keys must be provided.
     * Configure the JWT authentication backend.
     */
    jwtConfigureRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['jwtMountPath'] == null) {
                throw new runtime.RequiredError('jwtMountPath', 'Required parameter "jwtMountPath" was null or undefined when calling jwtConfigure().');
            }
            if (requestParameters['jwtConfigureRequest'] == null) {
                throw new runtime.RequiredError('jwtConfigureRequest', 'Required parameter "jwtConfigureRequest" was null or undefined when calling jwtConfigure().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{jwt_mount_path}/config`.replace(`{${"jwt_mount_path"}}`, encodeURIComponent(String(requestParameters['jwtMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.JwtConfigureRequestToJSON)(requestParameters['jwtConfigureRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * The JWT authentication backend validates JWTs (or OIDC) using the configured credentials. If using OIDC Discovery, the URL must be provided, along with (optionally) the CA cert to use for the connection. If performing JWT validation locally, a set of public keys must be provided.
     * Configure the JWT authentication backend.
     */
    jwtConfigure(jwtMountPath, jwtConfigureRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.jwtConfigureRaw({ jwtMountPath: jwtMountPath, jwtConfigureRequest: jwtConfigureRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Delete an existing role.
     */
    jwtDeleteRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling jwtDeleteRole().');
            }
            if (requestParameters['jwtMountPath'] == null) {
                throw new runtime.RequiredError('jwtMountPath', 'Required parameter "jwtMountPath" was null or undefined when calling jwtDeleteRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{jwt_mount_path}/role/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"jwt_mount_path"}}`, encodeURIComponent(String(requestParameters['jwtMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Delete an existing role.
     */
    jwtDeleteRole(name, jwtMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.jwtDeleteRoleRaw({ name: name, jwtMountPath: jwtMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * The list will contain the names of the roles.
     * Lists all the roles registered with the backend.
     */
    jwtListRolesRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['jwtMountPath'] == null) {
                throw new runtime.RequiredError('jwtMountPath', 'Required parameter "jwtMountPath" was null or undefined when calling jwtListRoles().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling jwtListRoles().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{jwt_mount_path}/role/`.replace(`{${"jwt_mount_path"}}`, encodeURIComponent(String(requestParameters['jwtMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     * The list will contain the names of the roles.
     * Lists all the roles registered with the backend.
     */
    jwtListRoles(jwtMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.jwtListRolesRaw({ jwtMountPath: jwtMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Authenticates to Vault using a JWT (or OIDC) token.
     */
    jwtLoginRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['jwtMountPath'] == null) {
                throw new runtime.RequiredError('jwtMountPath', 'Required parameter "jwtMountPath" was null or undefined when calling jwtLogin().');
            }
            if (requestParameters['jwtLoginRequest'] == null) {
                throw new runtime.RequiredError('jwtLoginRequest', 'Required parameter "jwtLoginRequest" was null or undefined when calling jwtLogin().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{jwt_mount_path}/login`.replace(`{${"jwt_mount_path"}}`, encodeURIComponent(String(requestParameters['jwtMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.JwtLoginRequestToJSON)(requestParameters['jwtLoginRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Authenticates to Vault using a JWT (or OIDC) token.
     */
    jwtLogin(jwtMountPath, jwtLoginRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.jwtLoginRaw({ jwtMountPath: jwtMountPath, jwtLoginRequest: jwtLoginRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Callback endpoint to complete an OIDC login.
     */
    jwtOidcCallbackRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['jwtMountPath'] == null) {
                throw new runtime.RequiredError('jwtMountPath', 'Required parameter "jwtMountPath" was null or undefined when calling jwtOidcCallback().');
            }
            const queryParameters = {};
            if (requestParameters['clientNonce'] != null) {
                queryParameters['client_nonce'] = requestParameters['clientNonce'];
            }
            if (requestParameters['code'] != null) {
                queryParameters['code'] = requestParameters['code'];
            }
            if (requestParameters['state'] != null) {
                queryParameters['state'] = requestParameters['state'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{jwt_mount_path}/oidc/callback`.replace(`{${"jwt_mount_path"}}`, encodeURIComponent(String(requestParameters['jwtMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Callback endpoint to complete an OIDC login.
     */
    jwtOidcCallback(jwtMountPath, clientNonce, code, state, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.jwtOidcCallbackRaw({ jwtMountPath: jwtMountPath, clientNonce: clientNonce, code: code, state: state }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Callback endpoint to handle form_posts.
     */
    jwtOidcCallbackFormPostRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['jwtMountPath'] == null) {
                throw new runtime.RequiredError('jwtMountPath', 'Required parameter "jwtMountPath" was null or undefined when calling jwtOidcCallbackFormPost().');
            }
            if (requestParameters['jwtOidcCallbackFormPostRequest'] == null) {
                throw new runtime.RequiredError('jwtOidcCallbackFormPostRequest', 'Required parameter "jwtOidcCallbackFormPostRequest" was null or undefined when calling jwtOidcCallbackFormPost().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{jwt_mount_path}/oidc/callback`.replace(`{${"jwt_mount_path"}}`, encodeURIComponent(String(requestParameters['jwtMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.JwtOidcCallbackFormPostRequestToJSON)(requestParameters['jwtOidcCallbackFormPostRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Callback endpoint to handle form_posts.
     */
    jwtOidcCallbackFormPost(jwtMountPath, jwtOidcCallbackFormPostRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.jwtOidcCallbackFormPostRaw({ jwtMountPath: jwtMountPath, jwtOidcCallbackFormPostRequest: jwtOidcCallbackFormPostRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Request an authorization URL to start an OIDC login flow.
     */
    jwtOidcRequestAuthorizationUrlRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['jwtMountPath'] == null) {
                throw new runtime.RequiredError('jwtMountPath', 'Required parameter "jwtMountPath" was null or undefined when calling jwtOidcRequestAuthorizationUrl().');
            }
            if (requestParameters['jwtOidcRequestAuthorizationUrlRequest'] == null) {
                throw new runtime.RequiredError('jwtOidcRequestAuthorizationUrlRequest', 'Required parameter "jwtOidcRequestAuthorizationUrlRequest" was null or undefined when calling jwtOidcRequestAuthorizationUrl().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{jwt_mount_path}/oidc/auth_url`.replace(`{${"jwt_mount_path"}}`, encodeURIComponent(String(requestParameters['jwtMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.JwtOidcRequestAuthorizationUrlRequestToJSON)(requestParameters['jwtOidcRequestAuthorizationUrlRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Request an authorization URL to start an OIDC login flow.
     */
    jwtOidcRequestAuthorizationUrl(jwtMountPath, jwtOidcRequestAuthorizationUrlRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.jwtOidcRequestAuthorizationUrlRaw({ jwtMountPath: jwtMountPath, jwtOidcRequestAuthorizationUrlRequest: jwtOidcRequestAuthorizationUrlRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Read the current JWT authentication backend configuration.
     */
    jwtReadConfigurationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['jwtMountPath'] == null) {
                throw new runtime.RequiredError('jwtMountPath', 'Required parameter "jwtMountPath" was null or undefined when calling jwtReadConfiguration().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{jwt_mount_path}/config`.replace(`{${"jwt_mount_path"}}`, encodeURIComponent(String(requestParameters['jwtMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Read the current JWT authentication backend configuration.
     */
    jwtReadConfiguration(jwtMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.jwtReadConfigurationRaw({ jwtMountPath: jwtMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Read an existing role.
     */
    jwtReadRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling jwtReadRole().');
            }
            if (requestParameters['jwtMountPath'] == null) {
                throw new runtime.RequiredError('jwtMountPath', 'Required parameter "jwtMountPath" was null or undefined when calling jwtReadRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{jwt_mount_path}/role/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"jwt_mount_path"}}`, encodeURIComponent(String(requestParameters['jwtMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Read an existing role.
     */
    jwtReadRole(name, jwtMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.jwtReadRoleRaw({ name: name, jwtMountPath: jwtMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * A role is required to authenticate with this backend. The role binds   JWT token information with token policies and settings.   The bindings, token polices and token settings can all be configured   using this endpoint
     * Register an role with the backend.
     */
    jwtWriteRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling jwtWriteRole().');
            }
            if (requestParameters['jwtMountPath'] == null) {
                throw new runtime.RequiredError('jwtMountPath', 'Required parameter "jwtMountPath" was null or undefined when calling jwtWriteRole().');
            }
            if (requestParameters['jwtWriteRoleRequest'] == null) {
                throw new runtime.RequiredError('jwtWriteRoleRequest', 'Required parameter "jwtWriteRoleRequest" was null or undefined when calling jwtWriteRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{jwt_mount_path}/role/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"jwt_mount_path"}}`, encodeURIComponent(String(requestParameters['jwtMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.JwtWriteRoleRequestToJSON)(requestParameters['jwtWriteRoleRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * A role is required to authenticate with this backend. The role binds   JWT token information with token policies and settings.   The bindings, token polices and token settings can all be configured   using this endpoint
     * Register an role with the backend.
     */
    jwtWriteRole(name, jwtMountPath, jwtWriteRoleRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.jwtWriteRoleRaw({ name: name, jwtMountPath: jwtMountPath, jwtWriteRoleRequest: jwtWriteRoleRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    kerberosConfigureRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['kerberosMountPath'] == null) {
                throw new runtime.RequiredError('kerberosMountPath', 'Required parameter "kerberosMountPath" was null or undefined when calling kerberosConfigure().');
            }
            if (requestParameters['kerberosConfigureRequest'] == null) {
                throw new runtime.RequiredError('kerberosConfigureRequest', 'Required parameter "kerberosConfigureRequest" was null or undefined when calling kerberosConfigure().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{kerberos_mount_path}/config`.replace(`{${"kerberos_mount_path"}}`, encodeURIComponent(String(requestParameters['kerberosMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.KerberosConfigureRequestToJSON)(requestParameters['kerberosConfigureRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    kerberosConfigure(kerberosMountPath, kerberosConfigureRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.kerberosConfigureRaw({ kerberosMountPath: kerberosMountPath, kerberosConfigureRequest: kerberosConfigureRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    kerberosConfigureLdapRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['kerberosMountPath'] == null) {
                throw new runtime.RequiredError('kerberosMountPath', 'Required parameter "kerberosMountPath" was null or undefined when calling kerberosConfigureLdap().');
            }
            if (requestParameters['kerberosConfigureLdapRequest'] == null) {
                throw new runtime.RequiredError('kerberosConfigureLdapRequest', 'Required parameter "kerberosConfigureLdapRequest" was null or undefined when calling kerberosConfigureLdap().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{kerberos_mount_path}/config/ldap`.replace(`{${"kerberos_mount_path"}}`, encodeURIComponent(String(requestParameters['kerberosMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.KerberosConfigureLdapRequestToJSON)(requestParameters['kerberosConfigureLdapRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    kerberosConfigureLdap(kerberosMountPath, kerberosConfigureLdapRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.kerberosConfigureLdapRaw({ kerberosMountPath: kerberosMountPath, kerberosConfigureLdapRequest: kerberosConfigureLdapRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    kerberosDeleteGroupRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling kerberosDeleteGroup().');
            }
            if (requestParameters['kerberosMountPath'] == null) {
                throw new runtime.RequiredError('kerberosMountPath', 'Required parameter "kerberosMountPath" was null or undefined when calling kerberosDeleteGroup().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{kerberos_mount_path}/groups/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"kerberos_mount_path"}}`, encodeURIComponent(String(requestParameters['kerberosMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    kerberosDeleteGroup(name, kerberosMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.kerberosDeleteGroupRaw({ name: name, kerberosMountPath: kerberosMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    kerberosListGroupsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['kerberosMountPath'] == null) {
                throw new runtime.RequiredError('kerberosMountPath', 'Required parameter "kerberosMountPath" was null or undefined when calling kerberosListGroups().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling kerberosListGroups().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{kerberos_mount_path}/groups/`.replace(`{${"kerberos_mount_path"}}`, encodeURIComponent(String(requestParameters['kerberosMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     */
    kerberosListGroups(kerberosMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.kerberosListGroupsRaw({ kerberosMountPath: kerberosMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    kerberosLoginRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['kerberosMountPath'] == null) {
                throw new runtime.RequiredError('kerberosMountPath', 'Required parameter "kerberosMountPath" was null or undefined when calling kerberosLogin().');
            }
            if (requestParameters['kerberosLoginRequest'] == null) {
                throw new runtime.RequiredError('kerberosLoginRequest', 'Required parameter "kerberosLoginRequest" was null or undefined when calling kerberosLogin().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{kerberos_mount_path}/login`.replace(`{${"kerberos_mount_path"}}`, encodeURIComponent(String(requestParameters['kerberosMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.KerberosLoginRequestToJSON)(requestParameters['kerberosLoginRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    kerberosLogin(kerberosMountPath, kerberosLoginRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.kerberosLoginRaw({ kerberosMountPath: kerberosMountPath, kerberosLoginRequest: kerberosLoginRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    kerberosLogin2Raw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['kerberosMountPath'] == null) {
                throw new runtime.RequiredError('kerberosMountPath', 'Required parameter "kerberosMountPath" was null or undefined when calling kerberosLogin2().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{kerberos_mount_path}/login`.replace(`{${"kerberos_mount_path"}}`, encodeURIComponent(String(requestParameters['kerberosMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    kerberosLogin2(kerberosMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.kerberosLogin2Raw({ kerberosMountPath: kerberosMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    kerberosReadConfigurationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['kerberosMountPath'] == null) {
                throw new runtime.RequiredError('kerberosMountPath', 'Required parameter "kerberosMountPath" was null or undefined when calling kerberosReadConfiguration().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{kerberos_mount_path}/config`.replace(`{${"kerberos_mount_path"}}`, encodeURIComponent(String(requestParameters['kerberosMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    kerberosReadConfiguration(kerberosMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.kerberosReadConfigurationRaw({ kerberosMountPath: kerberosMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    kerberosReadGroupRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling kerberosReadGroup().');
            }
            if (requestParameters['kerberosMountPath'] == null) {
                throw new runtime.RequiredError('kerberosMountPath', 'Required parameter "kerberosMountPath" was null or undefined when calling kerberosReadGroup().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{kerberos_mount_path}/groups/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"kerberos_mount_path"}}`, encodeURIComponent(String(requestParameters['kerberosMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    kerberosReadGroup(name, kerberosMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.kerberosReadGroupRaw({ name: name, kerberosMountPath: kerberosMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    kerberosReadLdapConfigurationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['kerberosMountPath'] == null) {
                throw new runtime.RequiredError('kerberosMountPath', 'Required parameter "kerberosMountPath" was null or undefined when calling kerberosReadLdapConfiguration().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{kerberos_mount_path}/config/ldap`.replace(`{${"kerberos_mount_path"}}`, encodeURIComponent(String(requestParameters['kerberosMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    kerberosReadLdapConfiguration(kerberosMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.kerberosReadLdapConfigurationRaw({ kerberosMountPath: kerberosMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    kerberosWriteGroupRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling kerberosWriteGroup().');
            }
            if (requestParameters['kerberosMountPath'] == null) {
                throw new runtime.RequiredError('kerberosMountPath', 'Required parameter "kerberosMountPath" was null or undefined when calling kerberosWriteGroup().');
            }
            if (requestParameters['kerberosWriteGroupRequest'] == null) {
                throw new runtime.RequiredError('kerberosWriteGroupRequest', 'Required parameter "kerberosWriteGroupRequest" was null or undefined when calling kerberosWriteGroup().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{kerberos_mount_path}/groups/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"kerberos_mount_path"}}`, encodeURIComponent(String(requestParameters['kerberosMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.KerberosWriteGroupRequestToJSON)(requestParameters['kerberosWriteGroupRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    kerberosWriteGroup(name, kerberosMountPath, kerberosWriteGroupRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.kerberosWriteGroupRaw({ name: name, kerberosMountPath: kerberosMountPath, kerberosWriteGroupRequest: kerberosWriteGroupRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    kubernetesConfigureAuthRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['kubernetesMountPath'] == null) {
                throw new runtime.RequiredError('kubernetesMountPath', 'Required parameter "kubernetesMountPath" was null or undefined when calling kubernetesConfigureAuth().');
            }
            if (requestParameters['kubernetesConfigureAuthRequest'] == null) {
                throw new runtime.RequiredError('kubernetesConfigureAuthRequest', 'Required parameter "kubernetesConfigureAuthRequest" was null or undefined when calling kubernetesConfigureAuth().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{kubernetes_mount_path}/config`.replace(`{${"kubernetes_mount_path"}}`, encodeURIComponent(String(requestParameters['kubernetesMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.KubernetesConfigureAuthRequestToJSON)(requestParameters['kubernetesConfigureAuthRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    kubernetesConfigureAuth(kubernetesMountPath, kubernetesConfigureAuthRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.kubernetesConfigureAuthRaw({ kubernetesMountPath: kubernetesMountPath, kubernetesConfigureAuthRequest: kubernetesConfigureAuthRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Register an role with the backend.
     */
    kubernetesDeleteAuthRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling kubernetesDeleteAuthRole().');
            }
            if (requestParameters['kubernetesMountPath'] == null) {
                throw new runtime.RequiredError('kubernetesMountPath', 'Required parameter "kubernetesMountPath" was null or undefined when calling kubernetesDeleteAuthRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{kubernetes_mount_path}/role/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"kubernetes_mount_path"}}`, encodeURIComponent(String(requestParameters['kubernetesMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Register an role with the backend.
     */
    kubernetesDeleteAuthRole(name, kubernetesMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.kubernetesDeleteAuthRoleRaw({ name: name, kubernetesMountPath: kubernetesMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Lists all the roles registered with the backend.
     */
    kubernetesListAuthRolesRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['kubernetesMountPath'] == null) {
                throw new runtime.RequiredError('kubernetesMountPath', 'Required parameter "kubernetesMountPath" was null or undefined when calling kubernetesListAuthRoles().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling kubernetesListAuthRoles().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{kubernetes_mount_path}/role/`.replace(`{${"kubernetes_mount_path"}}`, encodeURIComponent(String(requestParameters['kubernetesMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     * Lists all the roles registered with the backend.
     */
    kubernetesListAuthRoles(kubernetesMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.kubernetesListAuthRolesRaw({ kubernetesMountPath: kubernetesMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Authenticates Kubernetes service accounts with Vault.
     */
    kubernetesLoginRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['kubernetesMountPath'] == null) {
                throw new runtime.RequiredError('kubernetesMountPath', 'Required parameter "kubernetesMountPath" was null or undefined when calling kubernetesLogin().');
            }
            if (requestParameters['kubernetesLoginRequest'] == null) {
                throw new runtime.RequiredError('kubernetesLoginRequest', 'Required parameter "kubernetesLoginRequest" was null or undefined when calling kubernetesLogin().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{kubernetes_mount_path}/login`.replace(`{${"kubernetes_mount_path"}}`, encodeURIComponent(String(requestParameters['kubernetesMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.KubernetesLoginRequestToJSON)(requestParameters['kubernetesLoginRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Authenticates Kubernetes service accounts with Vault.
     */
    kubernetesLogin(kubernetesMountPath, kubernetesLoginRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.kubernetesLoginRaw({ kubernetesMountPath: kubernetesMountPath, kubernetesLoginRequest: kubernetesLoginRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    kubernetesReadAuthConfigurationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['kubernetesMountPath'] == null) {
                throw new runtime.RequiredError('kubernetesMountPath', 'Required parameter "kubernetesMountPath" was null or undefined when calling kubernetesReadAuthConfiguration().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{kubernetes_mount_path}/config`.replace(`{${"kubernetes_mount_path"}}`, encodeURIComponent(String(requestParameters['kubernetesMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    kubernetesReadAuthConfiguration(kubernetesMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.kubernetesReadAuthConfigurationRaw({ kubernetesMountPath: kubernetesMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Register an role with the backend.
     */
    kubernetesReadAuthRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling kubernetesReadAuthRole().');
            }
            if (requestParameters['kubernetesMountPath'] == null) {
                throw new runtime.RequiredError('kubernetesMountPath', 'Required parameter "kubernetesMountPath" was null or undefined when calling kubernetesReadAuthRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{kubernetes_mount_path}/role/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"kubernetes_mount_path"}}`, encodeURIComponent(String(requestParameters['kubernetesMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Register an role with the backend.
     */
    kubernetesReadAuthRole(name, kubernetesMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.kubernetesReadAuthRoleRaw({ name: name, kubernetesMountPath: kubernetesMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Register an role with the backend.
     */
    kubernetesWriteAuthRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling kubernetesWriteAuthRole().');
            }
            if (requestParameters['kubernetesMountPath'] == null) {
                throw new runtime.RequiredError('kubernetesMountPath', 'Required parameter "kubernetesMountPath" was null or undefined when calling kubernetesWriteAuthRole().');
            }
            if (requestParameters['kubernetesWriteAuthRoleRequest'] == null) {
                throw new runtime.RequiredError('kubernetesWriteAuthRoleRequest', 'Required parameter "kubernetesWriteAuthRoleRequest" was null or undefined when calling kubernetesWriteAuthRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{kubernetes_mount_path}/role/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"kubernetes_mount_path"}}`, encodeURIComponent(String(requestParameters['kubernetesMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.KubernetesWriteAuthRoleRequestToJSON)(requestParameters['kubernetesWriteAuthRoleRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Register an role with the backend.
     */
    kubernetesWriteAuthRole(name, kubernetesMountPath, kubernetesWriteAuthRoleRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.kubernetesWriteAuthRoleRaw({ name: name, kubernetesMountPath: kubernetesMountPath, kubernetesWriteAuthRoleRequest: kubernetesWriteAuthRoleRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    ldapConfigureAuthRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['ldapMountPath'] == null) {
                throw new runtime.RequiredError('ldapMountPath', 'Required parameter "ldapMountPath" was null or undefined when calling ldapConfigureAuth().');
            }
            if (requestParameters['ldapConfigureAuthRequest'] == null) {
                throw new runtime.RequiredError('ldapConfigureAuthRequest', 'Required parameter "ldapConfigureAuthRequest" was null or undefined when calling ldapConfigureAuth().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{ldap_mount_path}/config`.replace(`{${"ldap_mount_path"}}`, encodeURIComponent(String(requestParameters['ldapMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.LdapConfigureAuthRequestToJSON)(requestParameters['ldapConfigureAuthRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    ldapConfigureAuth(ldapMountPath, ldapConfigureAuthRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.ldapConfigureAuthRaw({ ldapMountPath: ldapMountPath, ldapConfigureAuthRequest: ldapConfigureAuthRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    ldapDeleteGroupRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling ldapDeleteGroup().');
            }
            if (requestParameters['ldapMountPath'] == null) {
                throw new runtime.RequiredError('ldapMountPath', 'Required parameter "ldapMountPath" was null or undefined when calling ldapDeleteGroup().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{ldap_mount_path}/groups/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"ldap_mount_path"}}`, encodeURIComponent(String(requestParameters['ldapMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    ldapDeleteGroup(name, ldapMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.ldapDeleteGroupRaw({ name: name, ldapMountPath: ldapMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    ldapDeleteUserRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling ldapDeleteUser().');
            }
            if (requestParameters['ldapMountPath'] == null) {
                throw new runtime.RequiredError('ldapMountPath', 'Required parameter "ldapMountPath" was null or undefined when calling ldapDeleteUser().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{ldap_mount_path}/users/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"ldap_mount_path"}}`, encodeURIComponent(String(requestParameters['ldapMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    ldapDeleteUser(name, ldapMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.ldapDeleteUserRaw({ name: name, ldapMountPath: ldapMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    ldapListGroupsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['ldapMountPath'] == null) {
                throw new runtime.RequiredError('ldapMountPath', 'Required parameter "ldapMountPath" was null or undefined when calling ldapListGroups().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling ldapListGroups().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{ldap_mount_path}/groups/`.replace(`{${"ldap_mount_path"}}`, encodeURIComponent(String(requestParameters['ldapMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    ldapListGroups(ldapMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.ldapListGroupsRaw({ ldapMountPath: ldapMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    ldapListUsersRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['ldapMountPath'] == null) {
                throw new runtime.RequiredError('ldapMountPath', 'Required parameter "ldapMountPath" was null or undefined when calling ldapListUsers().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling ldapListUsers().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{ldap_mount_path}/users/`.replace(`{${"ldap_mount_path"}}`, encodeURIComponent(String(requestParameters['ldapMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    ldapListUsers(ldapMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.ldapListUsersRaw({ ldapMountPath: ldapMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Log in with a username and password.
     */
    ldapLoginRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['username'] == null) {
                throw new runtime.RequiredError('username', 'Required parameter "username" was null or undefined when calling ldapLogin().');
            }
            if (requestParameters['ldapMountPath'] == null) {
                throw new runtime.RequiredError('ldapMountPath', 'Required parameter "ldapMountPath" was null or undefined when calling ldapLogin().');
            }
            if (requestParameters['ldapLoginRequest'] == null) {
                throw new runtime.RequiredError('ldapLoginRequest', 'Required parameter "ldapLoginRequest" was null or undefined when calling ldapLogin().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{ldap_mount_path}/login/{username}`.replace(`{${"username"}}`, encodeURIComponent(String(requestParameters['username']))).replace(`{${"ldap_mount_path"}}`, encodeURIComponent(String(requestParameters['ldapMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.LdapLoginRequestToJSON)(requestParameters['ldapLoginRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Log in with a username and password.
     */
    ldapLogin(username, ldapMountPath, ldapLoginRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.ldapLoginRaw({ username: username, ldapMountPath: ldapMountPath, ldapLoginRequest: ldapLoginRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    ldapReadAuthConfigurationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['ldapMountPath'] == null) {
                throw new runtime.RequiredError('ldapMountPath', 'Required parameter "ldapMountPath" was null or undefined when calling ldapReadAuthConfiguration().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{ldap_mount_path}/config`.replace(`{${"ldap_mount_path"}}`, encodeURIComponent(String(requestParameters['ldapMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    ldapReadAuthConfiguration(ldapMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.ldapReadAuthConfigurationRaw({ ldapMountPath: ldapMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    ldapReadGroupRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling ldapReadGroup().');
            }
            if (requestParameters['ldapMountPath'] == null) {
                throw new runtime.RequiredError('ldapMountPath', 'Required parameter "ldapMountPath" was null or undefined when calling ldapReadGroup().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{ldap_mount_path}/groups/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"ldap_mount_path"}}`, encodeURIComponent(String(requestParameters['ldapMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    ldapReadGroup(name, ldapMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.ldapReadGroupRaw({ name: name, ldapMountPath: ldapMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    ldapReadUserRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling ldapReadUser().');
            }
            if (requestParameters['ldapMountPath'] == null) {
                throw new runtime.RequiredError('ldapMountPath', 'Required parameter "ldapMountPath" was null or undefined when calling ldapReadUser().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{ldap_mount_path}/users/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"ldap_mount_path"}}`, encodeURIComponent(String(requestParameters['ldapMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    ldapReadUser(name, ldapMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.ldapReadUserRaw({ name: name, ldapMountPath: ldapMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    ldapRotateRootCredentialsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['ldapMountPath'] == null) {
                throw new runtime.RequiredError('ldapMountPath', 'Required parameter "ldapMountPath" was null or undefined when calling ldapRotateRootCredentials().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{ldap_mount_path}/config/rotate-root`.replace(`{${"ldap_mount_path"}}`, encodeURIComponent(String(requestParameters['ldapMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    ldapRotateRootCredentials(ldapMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.ldapRotateRootCredentialsRaw({ ldapMountPath: ldapMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    ldapWriteGroupRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling ldapWriteGroup().');
            }
            if (requestParameters['ldapMountPath'] == null) {
                throw new runtime.RequiredError('ldapMountPath', 'Required parameter "ldapMountPath" was null or undefined when calling ldapWriteGroup().');
            }
            if (requestParameters['ldapWriteGroupRequest'] == null) {
                throw new runtime.RequiredError('ldapWriteGroupRequest', 'Required parameter "ldapWriteGroupRequest" was null or undefined when calling ldapWriteGroup().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{ldap_mount_path}/groups/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"ldap_mount_path"}}`, encodeURIComponent(String(requestParameters['ldapMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.LdapWriteGroupRequestToJSON)(requestParameters['ldapWriteGroupRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    ldapWriteGroup(name, ldapMountPath, ldapWriteGroupRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.ldapWriteGroupRaw({ name: name, ldapMountPath: ldapMountPath, ldapWriteGroupRequest: ldapWriteGroupRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    ldapWriteUserRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling ldapWriteUser().');
            }
            if (requestParameters['ldapMountPath'] == null) {
                throw new runtime.RequiredError('ldapMountPath', 'Required parameter "ldapMountPath" was null or undefined when calling ldapWriteUser().');
            }
            if (requestParameters['ldapWriteUserRequest'] == null) {
                throw new runtime.RequiredError('ldapWriteUserRequest', 'Required parameter "ldapWriteUserRequest" was null or undefined when calling ldapWriteUser().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{ldap_mount_path}/users/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"ldap_mount_path"}}`, encodeURIComponent(String(requestParameters['ldapMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.LdapWriteUserRequestToJSON)(requestParameters['ldapWriteUserRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    ldapWriteUser(name, ldapMountPath, ldapWriteUserRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.ldapWriteUserRaw({ name: name, ldapMountPath: ldapMountPath, ldapWriteUserRequest: ldapWriteUserRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    ociConfigureRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['ociMountPath'] == null) {
                throw new runtime.RequiredError('ociMountPath', 'Required parameter "ociMountPath" was null or undefined when calling ociConfigure().');
            }
            if (requestParameters['ociConfigureRequest'] == null) {
                throw new runtime.RequiredError('ociConfigureRequest', 'Required parameter "ociConfigureRequest" was null or undefined when calling ociConfigure().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{oci_mount_path}/config`.replace(`{${"oci_mount_path"}}`, encodeURIComponent(String(requestParameters['ociMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.OciConfigureRequestToJSON)(requestParameters['ociConfigureRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    ociConfigure(ociMountPath, ociConfigureRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.ociConfigureRaw({ ociMountPath: ociMountPath, ociConfigureRequest: ociConfigureRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    ociDeleteConfigurationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['ociMountPath'] == null) {
                throw new runtime.RequiredError('ociMountPath', 'Required parameter "ociMountPath" was null or undefined when calling ociDeleteConfiguration().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{oci_mount_path}/config`.replace(`{${"oci_mount_path"}}`, encodeURIComponent(String(requestParameters['ociMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    ociDeleteConfiguration(ociMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.ociDeleteConfigurationRaw({ ociMountPath: ociMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Create a role and associate policies to it.
     */
    ociDeleteRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['role'] == null) {
                throw new runtime.RequiredError('role', 'Required parameter "role" was null or undefined when calling ociDeleteRole().');
            }
            if (requestParameters['ociMountPath'] == null) {
                throw new runtime.RequiredError('ociMountPath', 'Required parameter "ociMountPath" was null or undefined when calling ociDeleteRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{oci_mount_path}/role/{role}`.replace(`{${"role"}}`, encodeURIComponent(String(requestParameters['role']))).replace(`{${"oci_mount_path"}}`, encodeURIComponent(String(requestParameters['ociMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Create a role and associate policies to it.
     */
    ociDeleteRole(role, ociMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.ociDeleteRoleRaw({ role: role, ociMountPath: ociMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Lists all the roles that are registered with Vault.
     */
    ociListRolesRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['ociMountPath'] == null) {
                throw new runtime.RequiredError('ociMountPath', 'Required parameter "ociMountPath" was null or undefined when calling ociListRoles().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling ociListRoles().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{oci_mount_path}/role/`.replace(`{${"oci_mount_path"}}`, encodeURIComponent(String(requestParameters['ociMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     * Lists all the roles that are registered with Vault.
     */
    ociListRoles(ociMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.ociListRolesRaw({ ociMountPath: ociMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Authenticates to Vault using OCI credentials
     */
    ociLoginRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['role'] == null) {
                throw new runtime.RequiredError('role', 'Required parameter "role" was null or undefined when calling ociLogin().');
            }
            if (requestParameters['ociMountPath'] == null) {
                throw new runtime.RequiredError('ociMountPath', 'Required parameter "ociMountPath" was null or undefined when calling ociLogin().');
            }
            if (requestParameters['ociLoginRequest'] == null) {
                throw new runtime.RequiredError('ociLoginRequest', 'Required parameter "ociLoginRequest" was null or undefined when calling ociLogin().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{oci_mount_path}/login/{role}`.replace(`{${"role"}}`, encodeURIComponent(String(requestParameters['role']))).replace(`{${"oci_mount_path"}}`, encodeURIComponent(String(requestParameters['ociMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.OciLoginRequestToJSON)(requestParameters['ociLoginRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Authenticates to Vault using OCI credentials
     */
    ociLogin(role, ociMountPath, ociLoginRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.ociLoginRaw({ role: role, ociMountPath: ociMountPath, ociLoginRequest: ociLoginRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    ociReadConfigurationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['ociMountPath'] == null) {
                throw new runtime.RequiredError('ociMountPath', 'Required parameter "ociMountPath" was null or undefined when calling ociReadConfiguration().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{oci_mount_path}/config`.replace(`{${"oci_mount_path"}}`, encodeURIComponent(String(requestParameters['ociMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    ociReadConfiguration(ociMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.ociReadConfigurationRaw({ ociMountPath: ociMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Create a role and associate policies to it.
     */
    ociReadRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['role'] == null) {
                throw new runtime.RequiredError('role', 'Required parameter "role" was null or undefined when calling ociReadRole().');
            }
            if (requestParameters['ociMountPath'] == null) {
                throw new runtime.RequiredError('ociMountPath', 'Required parameter "ociMountPath" was null or undefined when calling ociReadRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{oci_mount_path}/role/{role}`.replace(`{${"role"}}`, encodeURIComponent(String(requestParameters['role']))).replace(`{${"oci_mount_path"}}`, encodeURIComponent(String(requestParameters['ociMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Create a role and associate policies to it.
     */
    ociReadRole(role, ociMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.ociReadRoleRaw({ role: role, ociMountPath: ociMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Create a role and associate policies to it.
     */
    ociWriteRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['role'] == null) {
                throw new runtime.RequiredError('role', 'Required parameter "role" was null or undefined when calling ociWriteRole().');
            }
            if (requestParameters['ociMountPath'] == null) {
                throw new runtime.RequiredError('ociMountPath', 'Required parameter "ociMountPath" was null or undefined when calling ociWriteRole().');
            }
            if (requestParameters['ociWriteRoleRequest'] == null) {
                throw new runtime.RequiredError('ociWriteRoleRequest', 'Required parameter "ociWriteRoleRequest" was null or undefined when calling ociWriteRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{oci_mount_path}/role/{role}`.replace(`{${"role"}}`, encodeURIComponent(String(requestParameters['role']))).replace(`{${"oci_mount_path"}}`, encodeURIComponent(String(requestParameters['ociMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.OciWriteRoleRequestToJSON)(requestParameters['ociWriteRoleRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Create a role and associate policies to it.
     */
    ociWriteRole(role, ociMountPath, ociWriteRoleRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.ociWriteRoleRaw({ role: role, ociMountPath: ociMountPath, ociWriteRoleRequest: ociWriteRoleRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    oktaConfigureRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['oktaMountPath'] == null) {
                throw new runtime.RequiredError('oktaMountPath', 'Required parameter "oktaMountPath" was null or undefined when calling oktaConfigure().');
            }
            if (requestParameters['oktaConfigureRequest'] == null) {
                throw new runtime.RequiredError('oktaConfigureRequest', 'Required parameter "oktaConfigureRequest" was null or undefined when calling oktaConfigure().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{okta_mount_path}/config`.replace(`{${"okta_mount_path"}}`, encodeURIComponent(String(requestParameters['oktaMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.OktaConfigureRequestToJSON)(requestParameters['oktaConfigureRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    oktaConfigure(oktaMountPath, oktaConfigureRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.oktaConfigureRaw({ oktaMountPath: oktaMountPath, oktaConfigureRequest: oktaConfigureRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    oktaDeleteGroupRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling oktaDeleteGroup().');
            }
            if (requestParameters['oktaMountPath'] == null) {
                throw new runtime.RequiredError('oktaMountPath', 'Required parameter "oktaMountPath" was null or undefined when calling oktaDeleteGroup().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{okta_mount_path}/groups/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"okta_mount_path"}}`, encodeURIComponent(String(requestParameters['oktaMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    oktaDeleteGroup(name, oktaMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.oktaDeleteGroupRaw({ name: name, oktaMountPath: oktaMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    oktaDeleteUserRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling oktaDeleteUser().');
            }
            if (requestParameters['oktaMountPath'] == null) {
                throw new runtime.RequiredError('oktaMountPath', 'Required parameter "oktaMountPath" was null or undefined when calling oktaDeleteUser().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{okta_mount_path}/users/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"okta_mount_path"}}`, encodeURIComponent(String(requestParameters['oktaMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    oktaDeleteUser(name, oktaMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.oktaDeleteUserRaw({ name: name, oktaMountPath: oktaMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    oktaListGroupsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['oktaMountPath'] == null) {
                throw new runtime.RequiredError('oktaMountPath', 'Required parameter "oktaMountPath" was null or undefined when calling oktaListGroups().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling oktaListGroups().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{okta_mount_path}/groups/`.replace(`{${"okta_mount_path"}}`, encodeURIComponent(String(requestParameters['oktaMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    oktaListGroups(oktaMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.oktaListGroupsRaw({ oktaMountPath: oktaMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    oktaListUsersRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['oktaMountPath'] == null) {
                throw new runtime.RequiredError('oktaMountPath', 'Required parameter "oktaMountPath" was null or undefined when calling oktaListUsers().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling oktaListUsers().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{okta_mount_path}/users/`.replace(`{${"okta_mount_path"}}`, encodeURIComponent(String(requestParameters['oktaMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    oktaListUsers(oktaMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.oktaListUsersRaw({ oktaMountPath: oktaMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Log in with a username and password.
     */
    oktaLoginRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['username'] == null) {
                throw new runtime.RequiredError('username', 'Required parameter "username" was null or undefined when calling oktaLogin().');
            }
            if (requestParameters['oktaMountPath'] == null) {
                throw new runtime.RequiredError('oktaMountPath', 'Required parameter "oktaMountPath" was null or undefined when calling oktaLogin().');
            }
            if (requestParameters['oktaLoginRequest'] == null) {
                throw new runtime.RequiredError('oktaLoginRequest', 'Required parameter "oktaLoginRequest" was null or undefined when calling oktaLogin().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{okta_mount_path}/login/{username}`.replace(`{${"username"}}`, encodeURIComponent(String(requestParameters['username']))).replace(`{${"okta_mount_path"}}`, encodeURIComponent(String(requestParameters['oktaMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.OktaLoginRequestToJSON)(requestParameters['oktaLoginRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Log in with a username and password.
     */
    oktaLogin(username, oktaMountPath, oktaLoginRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.oktaLoginRaw({ username: username, oktaMountPath: oktaMountPath, oktaLoginRequest: oktaLoginRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    oktaReadConfigurationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['oktaMountPath'] == null) {
                throw new runtime.RequiredError('oktaMountPath', 'Required parameter "oktaMountPath" was null or undefined when calling oktaReadConfiguration().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{okta_mount_path}/config`.replace(`{${"okta_mount_path"}}`, encodeURIComponent(String(requestParameters['oktaMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    oktaReadConfiguration(oktaMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.oktaReadConfigurationRaw({ oktaMountPath: oktaMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    oktaReadGroupRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling oktaReadGroup().');
            }
            if (requestParameters['oktaMountPath'] == null) {
                throw new runtime.RequiredError('oktaMountPath', 'Required parameter "oktaMountPath" was null or undefined when calling oktaReadGroup().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{okta_mount_path}/groups/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"okta_mount_path"}}`, encodeURIComponent(String(requestParameters['oktaMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    oktaReadGroup(name, oktaMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.oktaReadGroupRaw({ name: name, oktaMountPath: oktaMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    oktaReadUserRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling oktaReadUser().');
            }
            if (requestParameters['oktaMountPath'] == null) {
                throw new runtime.RequiredError('oktaMountPath', 'Required parameter "oktaMountPath" was null or undefined when calling oktaReadUser().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{okta_mount_path}/users/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"okta_mount_path"}}`, encodeURIComponent(String(requestParameters['oktaMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    oktaReadUser(name, oktaMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.oktaReadUserRaw({ name: name, oktaMountPath: oktaMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    oktaVerifyRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['nonce'] == null) {
                throw new runtime.RequiredError('nonce', 'Required parameter "nonce" was null or undefined when calling oktaVerify().');
            }
            if (requestParameters['oktaMountPath'] == null) {
                throw new runtime.RequiredError('oktaMountPath', 'Required parameter "oktaMountPath" was null or undefined when calling oktaVerify().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{okta_mount_path}/verify/{nonce}`.replace(`{${"nonce"}}`, encodeURIComponent(String(requestParameters['nonce']))).replace(`{${"okta_mount_path"}}`, encodeURIComponent(String(requestParameters['oktaMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    oktaVerify(nonce, oktaMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.oktaVerifyRaw({ nonce: nonce, oktaMountPath: oktaMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    oktaWriteGroupRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling oktaWriteGroup().');
            }
            if (requestParameters['oktaMountPath'] == null) {
                throw new runtime.RequiredError('oktaMountPath', 'Required parameter "oktaMountPath" was null or undefined when calling oktaWriteGroup().');
            }
            if (requestParameters['oktaWriteGroupRequest'] == null) {
                throw new runtime.RequiredError('oktaWriteGroupRequest', 'Required parameter "oktaWriteGroupRequest" was null or undefined when calling oktaWriteGroup().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{okta_mount_path}/groups/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"okta_mount_path"}}`, encodeURIComponent(String(requestParameters['oktaMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.OktaWriteGroupRequestToJSON)(requestParameters['oktaWriteGroupRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    oktaWriteGroup(name, oktaMountPath, oktaWriteGroupRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.oktaWriteGroupRaw({ name: name, oktaMountPath: oktaMountPath, oktaWriteGroupRequest: oktaWriteGroupRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    oktaWriteUserRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling oktaWriteUser().');
            }
            if (requestParameters['oktaMountPath'] == null) {
                throw new runtime.RequiredError('oktaMountPath', 'Required parameter "oktaMountPath" was null or undefined when calling oktaWriteUser().');
            }
            if (requestParameters['oktaWriteUserRequest'] == null) {
                throw new runtime.RequiredError('oktaWriteUserRequest', 'Required parameter "oktaWriteUserRequest" was null or undefined when calling oktaWriteUser().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{okta_mount_path}/users/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"okta_mount_path"}}`, encodeURIComponent(String(requestParameters['oktaMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.OktaWriteUserRequestToJSON)(requestParameters['oktaWriteUserRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage additional groups for users allowed to authenticate.
     */
    oktaWriteUser(name, oktaMountPath, oktaWriteUserRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.oktaWriteUserRaw({ name: name, oktaMountPath: oktaMountPath, oktaWriteUserRequest: oktaWriteUserRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    radiusConfigureRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['radiusMountPath'] == null) {
                throw new runtime.RequiredError('radiusMountPath', 'Required parameter "radiusMountPath" was null or undefined when calling radiusConfigure().');
            }
            if (requestParameters['radiusConfigureRequest'] == null) {
                throw new runtime.RequiredError('radiusConfigureRequest', 'Required parameter "radiusConfigureRequest" was null or undefined when calling radiusConfigure().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{radius_mount_path}/config`.replace(`{${"radius_mount_path"}}`, encodeURIComponent(String(requestParameters['radiusMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.RadiusConfigureRequestToJSON)(requestParameters['radiusConfigureRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    radiusConfigure(radiusMountPath, radiusConfigureRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.radiusConfigureRaw({ radiusMountPath: radiusMountPath, radiusConfigureRequest: radiusConfigureRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    radiusDeleteUserRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling radiusDeleteUser().');
            }
            if (requestParameters['radiusMountPath'] == null) {
                throw new runtime.RequiredError('radiusMountPath', 'Required parameter "radiusMountPath" was null or undefined when calling radiusDeleteUser().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{radius_mount_path}/users/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"radius_mount_path"}}`, encodeURIComponent(String(requestParameters['radiusMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    radiusDeleteUser(name, radiusMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.radiusDeleteUserRaw({ name: name, radiusMountPath: radiusMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    radiusListUsersRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['radiusMountPath'] == null) {
                throw new runtime.RequiredError('radiusMountPath', 'Required parameter "radiusMountPath" was null or undefined when calling radiusListUsers().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling radiusListUsers().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{radius_mount_path}/users/`.replace(`{${"radius_mount_path"}}`, encodeURIComponent(String(requestParameters['radiusMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    radiusListUsers(radiusMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.radiusListUsersRaw({ radiusMountPath: radiusMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Log in with a username and password.
     */
    radiusLoginRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['radiusMountPath'] == null) {
                throw new runtime.RequiredError('radiusMountPath', 'Required parameter "radiusMountPath" was null or undefined when calling radiusLogin().');
            }
            if (requestParameters['radiusLoginRequest'] == null) {
                throw new runtime.RequiredError('radiusLoginRequest', 'Required parameter "radiusLoginRequest" was null or undefined when calling radiusLogin().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{radius_mount_path}/login`.replace(`{${"radius_mount_path"}}`, encodeURIComponent(String(requestParameters['radiusMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.RadiusLoginRequestToJSON)(requestParameters['radiusLoginRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Log in with a username and password.
     */
    radiusLogin(radiusMountPath, radiusLoginRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.radiusLoginRaw({ radiusMountPath: radiusMountPath, radiusLoginRequest: radiusLoginRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Log in with a username and password.
     */
    radiusLoginWithUsernameRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['urlusername'] == null) {
                throw new runtime.RequiredError('urlusername', 'Required parameter "urlusername" was null or undefined when calling radiusLoginWithUsername().');
            }
            if (requestParameters['radiusMountPath'] == null) {
                throw new runtime.RequiredError('radiusMountPath', 'Required parameter "radiusMountPath" was null or undefined when calling radiusLoginWithUsername().');
            }
            if (requestParameters['radiusLoginWithUsernameRequest'] == null) {
                throw new runtime.RequiredError('radiusLoginWithUsernameRequest', 'Required parameter "radiusLoginWithUsernameRequest" was null or undefined when calling radiusLoginWithUsername().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{radius_mount_path}/login/{urlusername}`.replace(`{${"urlusername"}}`, encodeURIComponent(String(requestParameters['urlusername']))).replace(`{${"radius_mount_path"}}`, encodeURIComponent(String(requestParameters['radiusMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.RadiusLoginWithUsernameRequestToJSON)(requestParameters['radiusLoginWithUsernameRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Log in with a username and password.
     */
    radiusLoginWithUsername(urlusername, radiusMountPath, radiusLoginWithUsernameRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.radiusLoginWithUsernameRaw({ urlusername: urlusername, radiusMountPath: radiusMountPath, radiusLoginWithUsernameRequest: radiusLoginWithUsernameRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    radiusReadConfigurationRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['radiusMountPath'] == null) {
                throw new runtime.RequiredError('radiusMountPath', 'Required parameter "radiusMountPath" was null or undefined when calling radiusReadConfiguration().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{radius_mount_path}/config`.replace(`{${"radius_mount_path"}}`, encodeURIComponent(String(requestParameters['radiusMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    radiusReadConfiguration(radiusMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.radiusReadConfigurationRaw({ radiusMountPath: radiusMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    radiusReadUserRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling radiusReadUser().');
            }
            if (requestParameters['radiusMountPath'] == null) {
                throw new runtime.RequiredError('radiusMountPath', 'Required parameter "radiusMountPath" was null or undefined when calling radiusReadUser().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{radius_mount_path}/users/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"radius_mount_path"}}`, encodeURIComponent(String(requestParameters['radiusMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    radiusReadUser(name, radiusMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.radiusReadUserRaw({ name: name, radiusMountPath: radiusMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    radiusWriteUserRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['name'] == null) {
                throw new runtime.RequiredError('name', 'Required parameter "name" was null or undefined when calling radiusWriteUser().');
            }
            if (requestParameters['radiusMountPath'] == null) {
                throw new runtime.RequiredError('radiusMountPath', 'Required parameter "radiusMountPath" was null or undefined when calling radiusWriteUser().');
            }
            if (requestParameters['radiusWriteUserRequest'] == null) {
                throw new runtime.RequiredError('radiusWriteUserRequest', 'Required parameter "radiusWriteUserRequest" was null or undefined when calling radiusWriteUser().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{radius_mount_path}/users/{name}`.replace(`{${"name"}}`, encodeURIComponent(String(requestParameters['name']))).replace(`{${"radius_mount_path"}}`, encodeURIComponent(String(requestParameters['radiusMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.RadiusWriteUserRequestToJSON)(requestParameters['radiusWriteUserRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    radiusWriteUser(name, radiusMountPath, radiusWriteUserRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.radiusWriteUserRaw({ name: name, radiusMountPath: radiusMountPath, radiusWriteUserRequest: radiusWriteUserRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * The token create path is used to create new tokens.
     */
    tokenCreateRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['tokenCreateRequest'] == null) {
                throw new runtime.RequiredError('tokenCreateRequest', 'Required parameter "tokenCreateRequest" was null or undefined when calling tokenCreate().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/token/create`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.TokenCreateRequestToJSON)(requestParameters['tokenCreateRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * The token create path is used to create new tokens.
     */
    tokenCreate(tokenCreateRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.tokenCreateRaw({ tokenCreateRequest: tokenCreateRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * This token create path is used to create new tokens adhering to the given role.
     */
    tokenCreateAgainstRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling tokenCreateAgainstRole().');
            }
            if (requestParameters['tokenCreateAgainstRoleRequest'] == null) {
                throw new runtime.RequiredError('tokenCreateAgainstRoleRequest', 'Required parameter "tokenCreateAgainstRoleRequest" was null or undefined when calling tokenCreateAgainstRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/token/create/{role_name}`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.TokenCreateAgainstRoleRequestToJSON)(requestParameters['tokenCreateAgainstRoleRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * This token create path is used to create new tokens adhering to the given role.
     */
    tokenCreateAgainstRole(roleName, tokenCreateAgainstRoleRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.tokenCreateAgainstRoleRaw({ roleName: roleName, tokenCreateAgainstRoleRequest: tokenCreateAgainstRoleRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * The token create path is used to create new orphan tokens.
     */
    tokenCreateOrphanRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['tokenCreateOrphanRequest'] == null) {
                throw new runtime.RequiredError('tokenCreateOrphanRequest', 'Required parameter "tokenCreateOrphanRequest" was null or undefined when calling tokenCreateOrphan().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/token/create-orphan`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.TokenCreateOrphanRequestToJSON)(requestParameters['tokenCreateOrphanRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * The token create path is used to create new orphan tokens.
     */
    tokenCreateOrphan(tokenCreateOrphanRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.tokenCreateOrphanRaw({ tokenCreateOrphanRequest: tokenCreateOrphanRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    tokenDeleteRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling tokenDeleteRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/token/roles/{role_name}`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    tokenDeleteRole(roleName, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.tokenDeleteRoleRaw({ roleName: roleName }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * List token accessors, which can then be be used to iterate and discover their properties or revoke them. Because this can be used to cause a denial of service, this endpoint requires \'sudo\' capability in addition to \'list\'.
     */
    tokenListAccessorsRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling tokenListAccessors().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/token/accessors/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     * List token accessors, which can then be be used to iterate and discover their properties or revoke them. Because this can be used to cause a denial of service, this endpoint requires \'sudo\' capability in addition to \'list\'.
     */
    tokenListAccessors(list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.tokenListAccessorsRaw({ list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * This endpoint lists configured roles.
     */
    tokenListRolesRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling tokenListRoles().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/token/roles/`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     * This endpoint lists configured roles.
     */
    tokenListRoles(list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.tokenListRolesRaw({ list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    tokenLookUpRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['tokenLookUpRequest'] == null) {
                throw new runtime.RequiredError('tokenLookUpRequest', 'Required parameter "tokenLookUpRequest" was null or undefined when calling tokenLookUp().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/token/lookup`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.TokenLookUpRequestToJSON)(requestParameters['tokenLookUpRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    tokenLookUp(tokenLookUpRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.tokenLookUpRaw({ tokenLookUpRequest: tokenLookUpRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    tokenLookUp2Raw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            if (requestParameters['token'] != null) {
                queryParameters['token'] = requestParameters['token'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/token/lookup`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    tokenLookUp2(token, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.tokenLookUp2Raw({ token: token }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * This endpoint will lookup a token associated with the given accessor and its properties. Response will not contain the token ID.
     */
    tokenLookUpAccessorRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['tokenLookUpAccessorRequest'] == null) {
                throw new runtime.RequiredError('tokenLookUpAccessorRequest', 'Required parameter "tokenLookUpAccessorRequest" was null or undefined when calling tokenLookUpAccessor().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/token/lookup-accessor`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.TokenLookUpAccessorRequestToJSON)(requestParameters['tokenLookUpAccessorRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * This endpoint will lookup a token associated with the given accessor and its properties. Response will not contain the token ID.
     */
    tokenLookUpAccessor(tokenLookUpAccessorRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.tokenLookUpAccessorRaw({ tokenLookUpAccessorRequest: tokenLookUpAccessorRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    tokenLookUpSelfRaw(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/token/lookup-self`,
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    tokenLookUpSelf(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.tokenLookUpSelfRaw(initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    tokenLookUpSelf2Raw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['tokenLookUpSelf2Request'] == null) {
                throw new runtime.RequiredError('tokenLookUpSelf2Request', 'Required parameter "tokenLookUpSelf2Request" was null or undefined when calling tokenLookUpSelf2().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/token/lookup-self`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.TokenLookUpSelf2RequestToJSON)(requestParameters['tokenLookUpSelf2Request']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    tokenLookUpSelf2(tokenLookUpSelf2Request, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.tokenLookUpSelf2Raw({ tokenLookUpSelf2Request: tokenLookUpSelf2Request }, initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    tokenReadRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling tokenReadRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/token/roles/{role_name}`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    tokenReadRole(roleName, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.tokenReadRoleRaw({ roleName: roleName }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * This endpoint will renew the given token and prevent expiration.
     */
    tokenRenewRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['tokenRenewRequest'] == null) {
                throw new runtime.RequiredError('tokenRenewRequest', 'Required parameter "tokenRenewRequest" was null or undefined when calling tokenRenew().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/token/renew`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.TokenRenewRequestToJSON)(requestParameters['tokenRenewRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * This endpoint will renew the given token and prevent expiration.
     */
    tokenRenew(tokenRenewRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.tokenRenewRaw({ tokenRenewRequest: tokenRenewRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * This endpoint will renew a token associated with the given accessor and its properties. Response will not contain the token ID.
     */
    tokenRenewAccessorRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['tokenRenewAccessorRequest'] == null) {
                throw new runtime.RequiredError('tokenRenewAccessorRequest', 'Required parameter "tokenRenewAccessorRequest" was null or undefined when calling tokenRenewAccessor().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/token/renew-accessor`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.TokenRenewAccessorRequestToJSON)(requestParameters['tokenRenewAccessorRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * This endpoint will renew a token associated with the given accessor and its properties. Response will not contain the token ID.
     */
    tokenRenewAccessor(tokenRenewAccessorRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.tokenRenewAccessorRaw({ tokenRenewAccessorRequest: tokenRenewAccessorRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * This endpoint will renew the token used to call it and prevent expiration.
     */
    tokenRenewSelfRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['tokenRenewSelfRequest'] == null) {
                throw new runtime.RequiredError('tokenRenewSelfRequest', 'Required parameter "tokenRenewSelfRequest" was null or undefined when calling tokenRenewSelf().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/token/renew-self`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.TokenRenewSelfRequestToJSON)(requestParameters['tokenRenewSelfRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * This endpoint will renew the token used to call it and prevent expiration.
     */
    tokenRenewSelf(tokenRenewSelfRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.tokenRenewSelfRaw({ tokenRenewSelfRequest: tokenRenewSelfRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * This endpoint will delete the given token and all of its child tokens.
     */
    tokenRevokeRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['tokenRevokeRequest'] == null) {
                throw new runtime.RequiredError('tokenRevokeRequest', 'Required parameter "tokenRevokeRequest" was null or undefined when calling tokenRevoke().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/token/revoke`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.TokenRevokeRequestToJSON)(requestParameters['tokenRevokeRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * This endpoint will delete the given token and all of its child tokens.
     */
    tokenRevoke(tokenRevokeRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.tokenRevokeRaw({ tokenRevokeRequest: tokenRevokeRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * This endpoint will delete the token associated with the accessor and all of its child tokens.
     */
    tokenRevokeAccessorRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['tokenRevokeAccessorRequest'] == null) {
                throw new runtime.RequiredError('tokenRevokeAccessorRequest', 'Required parameter "tokenRevokeAccessorRequest" was null or undefined when calling tokenRevokeAccessor().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/token/revoke-accessor`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.TokenRevokeAccessorRequestToJSON)(requestParameters['tokenRevokeAccessorRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * This endpoint will delete the token associated with the accessor and all of its child tokens.
     */
    tokenRevokeAccessor(tokenRevokeAccessorRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.tokenRevokeAccessorRaw({ tokenRevokeAccessorRequest: tokenRevokeAccessorRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * This endpoint will delete the token and orphan its child tokens.
     */
    tokenRevokeOrphanRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['tokenRevokeOrphanRequest'] == null) {
                throw new runtime.RequiredError('tokenRevokeOrphanRequest', 'Required parameter "tokenRevokeOrphanRequest" was null or undefined when calling tokenRevokeOrphan().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/token/revoke-orphan`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.TokenRevokeOrphanRequestToJSON)(requestParameters['tokenRevokeOrphanRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * This endpoint will delete the token and orphan its child tokens.
     */
    tokenRevokeOrphan(tokenRevokeOrphanRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.tokenRevokeOrphanRaw({ tokenRevokeOrphanRequest: tokenRevokeOrphanRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * This endpoint will delete the token used to call it and all of its child tokens.
     */
    tokenRevokeSelfRaw(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/token/revoke-self`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * This endpoint will delete the token used to call it and all of its child tokens.
     */
    tokenRevokeSelf(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.tokenRevokeSelfRaw(initOverrides);
            return yield response.value();
        });
    }
    /**
     * This endpoint performs cleanup tasks that can be run if certain error conditions have occurred.
     */
    tokenTidyRaw(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/token/tidy`,
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * This endpoint performs cleanup tasks that can be run if certain error conditions have occurred.
     */
    tokenTidy(initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.tokenTidyRaw(initOverrides);
            return yield response.value();
        });
    }
    /**
     */
    tokenWriteRoleRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['roleName'] == null) {
                throw new runtime.RequiredError('roleName', 'Required parameter "roleName" was null or undefined when calling tokenWriteRole().');
            }
            if (requestParameters['tokenWriteRoleRequest'] == null) {
                throw new runtime.RequiredError('tokenWriteRoleRequest', 'Required parameter "tokenWriteRoleRequest" was null or undefined when calling tokenWriteRole().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/token/roles/{role_name}`.replace(`{${"role_name"}}`, encodeURIComponent(String(requestParameters['roleName']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.TokenWriteRoleRequestToJSON)(requestParameters['tokenWriteRoleRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     */
    tokenWriteRole(roleName, tokenWriteRoleRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.tokenWriteRoleRaw({ roleName: roleName, tokenWriteRoleRequest: tokenWriteRoleRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    userpassDeleteUserRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['username'] == null) {
                throw new runtime.RequiredError('username', 'Required parameter "username" was null or undefined when calling userpassDeleteUser().');
            }
            if (requestParameters['userpassMountPath'] == null) {
                throw new runtime.RequiredError('userpassMountPath', 'Required parameter "userpassMountPath" was null or undefined when calling userpassDeleteUser().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{userpass_mount_path}/users/{username}`.replace(`{${"username"}}`, encodeURIComponent(String(requestParameters['username']))).replace(`{${"userpass_mount_path"}}`, encodeURIComponent(String(requestParameters['userpassMountPath']))),
                method: 'DELETE',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    userpassDeleteUser(username, userpassMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.userpassDeleteUserRaw({ username: username, userpassMountPath: userpassMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    userpassListUsersRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['userpassMountPath'] == null) {
                throw new runtime.RequiredError('userpassMountPath', 'Required parameter "userpassMountPath" was null or undefined when calling userpassListUsers().');
            }
            if (requestParameters['list'] == null) {
                throw new runtime.RequiredError('list', 'Required parameter "list" was null or undefined when calling userpassListUsers().');
            }
            const queryParameters = {};
            if (requestParameters['list'] != null) {
                queryParameters['list'] = requestParameters['list'];
            }
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{userpass_mount_path}/users/`.replace(`{${"userpass_mount_path"}}`, encodeURIComponent(String(requestParameters['userpassMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.JSONApiResponse(response, (jsonValue) => (0, index_1.StandardListResponseFromJSON)(jsonValue));
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    userpassListUsers(userpassMountPath, list, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.userpassListUsersRaw({ userpassMountPath: userpassMountPath, list: list }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Log in with a username and password.
     */
    userpassLoginRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['username'] == null) {
                throw new runtime.RequiredError('username', 'Required parameter "username" was null or undefined when calling userpassLogin().');
            }
            if (requestParameters['userpassMountPath'] == null) {
                throw new runtime.RequiredError('userpassMountPath', 'Required parameter "userpassMountPath" was null or undefined when calling userpassLogin().');
            }
            if (requestParameters['userpassLoginRequest'] == null) {
                throw new runtime.RequiredError('userpassLoginRequest', 'Required parameter "userpassLoginRequest" was null or undefined when calling userpassLogin().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{userpass_mount_path}/login/{username}`.replace(`{${"username"}}`, encodeURIComponent(String(requestParameters['username']))).replace(`{${"userpass_mount_path"}}`, encodeURIComponent(String(requestParameters['userpassMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.UserpassLoginRequestToJSON)(requestParameters['userpassLoginRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Log in with a username and password.
     */
    userpassLogin(username, userpassMountPath, userpassLoginRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.userpassLoginRaw({ username: username, userpassMountPath: userpassMountPath, userpassLoginRequest: userpassLoginRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    userpassReadUserRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['username'] == null) {
                throw new runtime.RequiredError('username', 'Required parameter "username" was null or undefined when calling userpassReadUser().');
            }
            if (requestParameters['userpassMountPath'] == null) {
                throw new runtime.RequiredError('userpassMountPath', 'Required parameter "userpassMountPath" was null or undefined when calling userpassReadUser().');
            }
            const queryParameters = {};
            const headerParameters = {};
            const response = yield this.request({
                path: `/auth/{userpass_mount_path}/users/{username}`.replace(`{${"username"}}`, encodeURIComponent(String(requestParameters['username']))).replace(`{${"userpass_mount_path"}}`, encodeURIComponent(String(requestParameters['userpassMountPath']))),
                method: 'GET',
                headers: headerParameters,
                query: queryParameters,
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    userpassReadUser(username, userpassMountPath, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.userpassReadUserRaw({ username: username, userpassMountPath: userpassMountPath }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Reset user\'s password.
     */
    userpassResetPasswordRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['username'] == null) {
                throw new runtime.RequiredError('username', 'Required parameter "username" was null or undefined when calling userpassResetPassword().');
            }
            if (requestParameters['userpassMountPath'] == null) {
                throw new runtime.RequiredError('userpassMountPath', 'Required parameter "userpassMountPath" was null or undefined when calling userpassResetPassword().');
            }
            if (requestParameters['userpassResetPasswordRequest'] == null) {
                throw new runtime.RequiredError('userpassResetPasswordRequest', 'Required parameter "userpassResetPasswordRequest" was null or undefined when calling userpassResetPassword().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{userpass_mount_path}/users/{username}/password`.replace(`{${"username"}}`, encodeURIComponent(String(requestParameters['username']))).replace(`{${"userpass_mount_path"}}`, encodeURIComponent(String(requestParameters['userpassMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.UserpassResetPasswordRequestToJSON)(requestParameters['userpassResetPasswordRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Reset user\'s password.
     */
    userpassResetPassword(username, userpassMountPath, userpassResetPasswordRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.userpassResetPasswordRaw({ username: username, userpassMountPath: userpassMountPath, userpassResetPasswordRequest: userpassResetPasswordRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Update the policies associated with the username.
     */
    userpassUpdatePoliciesRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['username'] == null) {
                throw new runtime.RequiredError('username', 'Required parameter "username" was null or undefined when calling userpassUpdatePolicies().');
            }
            if (requestParameters['userpassMountPath'] == null) {
                throw new runtime.RequiredError('userpassMountPath', 'Required parameter "userpassMountPath" was null or undefined when calling userpassUpdatePolicies().');
            }
            if (requestParameters['userpassUpdatePoliciesRequest'] == null) {
                throw new runtime.RequiredError('userpassUpdatePoliciesRequest', 'Required parameter "userpassUpdatePoliciesRequest" was null or undefined when calling userpassUpdatePolicies().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{userpass_mount_path}/users/{username}/policies`.replace(`{${"username"}}`, encodeURIComponent(String(requestParameters['username']))).replace(`{${"userpass_mount_path"}}`, encodeURIComponent(String(requestParameters['userpassMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.UserpassUpdatePoliciesRequestToJSON)(requestParameters['userpassUpdatePoliciesRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Update the policies associated with the username.
     */
    userpassUpdatePolicies(username, userpassMountPath, userpassUpdatePoliciesRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.userpassUpdatePoliciesRaw({ username: username, userpassMountPath: userpassMountPath, userpassUpdatePoliciesRequest: userpassUpdatePoliciesRequest }, initOverrides);
            return yield response.value();
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    userpassWriteUserRaw(requestParameters, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            if (requestParameters['username'] == null) {
                throw new runtime.RequiredError('username', 'Required parameter "username" was null or undefined when calling userpassWriteUser().');
            }
            if (requestParameters['userpassMountPath'] == null) {
                throw new runtime.RequiredError('userpassMountPath', 'Required parameter "userpassMountPath" was null or undefined when calling userpassWriteUser().');
            }
            if (requestParameters['userpassWriteUserRequest'] == null) {
                throw new runtime.RequiredError('userpassWriteUserRequest', 'Required parameter "userpassWriteUserRequest" was null or undefined when calling userpassWriteUser().');
            }
            const queryParameters = {};
            const headerParameters = {};
            headerParameters['Content-Type'] = 'application/json';
            const response = yield this.request({
                path: `/auth/{userpass_mount_path}/users/{username}`.replace(`{${"username"}}`, encodeURIComponent(String(requestParameters['username']))).replace(`{${"userpass_mount_path"}}`, encodeURIComponent(String(requestParameters['userpassMountPath']))),
                method: 'POST',
                headers: headerParameters,
                query: queryParameters,
                body: (0, index_1.UserpassWriteUserRequestToJSON)(requestParameters['userpassWriteUserRequest']),
            }, initOverrides);
            return new runtime.VoidApiResponse(response);
        });
    }
    /**
     * Manage users allowed to authenticate.
     */
    userpassWriteUser(username, userpassMountPath, userpassWriteUserRequest, initOverrides) {
        return __awaiter(this, void 0, void 0, function* () {
            const response = yield this.userpassWriteUserRaw({ username: username, userpassMountPath: userpassMountPath, userpassWriteUserRequest: userpassWriteUserRequest }, initOverrides);
            return yield response.value();
        });
    }
}
exports.AuthApi = AuthApi;
/**
  * @export
  * @enum {string}
  */
var AliCloudListAuthRolesListEnum;
(function (AliCloudListAuthRolesListEnum) {
    AliCloudListAuthRolesListEnum["TRUE"] = "true";
})(AliCloudListAuthRolesListEnum || (exports.AliCloudListAuthRolesListEnum = AliCloudListAuthRolesListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var AliCloudListAuthRoles2ListEnum;
(function (AliCloudListAuthRoles2ListEnum) {
    AliCloudListAuthRoles2ListEnum["TRUE"] = "true";
})(AliCloudListAuthRoles2ListEnum || (exports.AliCloudListAuthRoles2ListEnum = AliCloudListAuthRoles2ListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var AppRoleListRolesListEnum;
(function (AppRoleListRolesListEnum) {
    AppRoleListRolesListEnum["TRUE"] = "true";
})(AppRoleListRolesListEnum || (exports.AppRoleListRolesListEnum = AppRoleListRolesListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var AppRoleListSecretIdsListEnum;
(function (AppRoleListSecretIdsListEnum) {
    AppRoleListSecretIdsListEnum["TRUE"] = "true";
})(AppRoleListSecretIdsListEnum || (exports.AppRoleListSecretIdsListEnum = AppRoleListSecretIdsListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var AwsListAuthRolesListEnum;
(function (AwsListAuthRolesListEnum) {
    AwsListAuthRolesListEnum["TRUE"] = "true";
})(AwsListAuthRolesListEnum || (exports.AwsListAuthRolesListEnum = AwsListAuthRolesListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var AwsListAuthRoles2ListEnum;
(function (AwsListAuthRoles2ListEnum) {
    AwsListAuthRoles2ListEnum["TRUE"] = "true";
})(AwsListAuthRoles2ListEnum || (exports.AwsListAuthRoles2ListEnum = AwsListAuthRoles2ListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var AwsListCertificateConfigurationsListEnum;
(function (AwsListCertificateConfigurationsListEnum) {
    AwsListCertificateConfigurationsListEnum["TRUE"] = "true";
})(AwsListCertificateConfigurationsListEnum || (exports.AwsListCertificateConfigurationsListEnum = AwsListCertificateConfigurationsListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var AwsListIdentityAccessListListEnum;
(function (AwsListIdentityAccessListListEnum) {
    AwsListIdentityAccessListListEnum["TRUE"] = "true";
})(AwsListIdentityAccessListListEnum || (exports.AwsListIdentityAccessListListEnum = AwsListIdentityAccessListListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var AwsListIdentityWhitelistListEnum;
(function (AwsListIdentityWhitelistListEnum) {
    AwsListIdentityWhitelistListEnum["TRUE"] = "true";
})(AwsListIdentityWhitelistListEnum || (exports.AwsListIdentityWhitelistListEnum = AwsListIdentityWhitelistListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var AwsListRoleTagBlacklistsListEnum;
(function (AwsListRoleTagBlacklistsListEnum) {
    AwsListRoleTagBlacklistsListEnum["TRUE"] = "true";
})(AwsListRoleTagBlacklistsListEnum || (exports.AwsListRoleTagBlacklistsListEnum = AwsListRoleTagBlacklistsListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var AwsListRoleTagDenyListsListEnum;
(function (AwsListRoleTagDenyListsListEnum) {
    AwsListRoleTagDenyListsListEnum["TRUE"] = "true";
})(AwsListRoleTagDenyListsListEnum || (exports.AwsListRoleTagDenyListsListEnum = AwsListRoleTagDenyListsListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var AwsListStsRoleRelationshipsListEnum;
(function (AwsListStsRoleRelationshipsListEnum) {
    AwsListStsRoleRelationshipsListEnum["TRUE"] = "true";
})(AwsListStsRoleRelationshipsListEnum || (exports.AwsListStsRoleRelationshipsListEnum = AwsListStsRoleRelationshipsListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var AzureListAuthRolesListEnum;
(function (AzureListAuthRolesListEnum) {
    AzureListAuthRolesListEnum["TRUE"] = "true";
})(AzureListAuthRolesListEnum || (exports.AzureListAuthRolesListEnum = AzureListAuthRolesListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var CertListCertificatesListEnum;
(function (CertListCertificatesListEnum) {
    CertListCertificatesListEnum["TRUE"] = "true";
})(CertListCertificatesListEnum || (exports.CertListCertificatesListEnum = CertListCertificatesListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var CertListCrlsListEnum;
(function (CertListCrlsListEnum) {
    CertListCrlsListEnum["TRUE"] = "true";
})(CertListCrlsListEnum || (exports.CertListCrlsListEnum = CertListCrlsListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var CloudFoundryListRolesListEnum;
(function (CloudFoundryListRolesListEnum) {
    CloudFoundryListRolesListEnum["TRUE"] = "true";
})(CloudFoundryListRolesListEnum || (exports.CloudFoundryListRolesListEnum = CloudFoundryListRolesListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var GithubListTeamsListEnum;
(function (GithubListTeamsListEnum) {
    GithubListTeamsListEnum["TRUE"] = "true";
})(GithubListTeamsListEnum || (exports.GithubListTeamsListEnum = GithubListTeamsListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var GithubListUsersListEnum;
(function (GithubListUsersListEnum) {
    GithubListUsersListEnum["TRUE"] = "true";
})(GithubListUsersListEnum || (exports.GithubListUsersListEnum = GithubListUsersListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var GoogleCloudListRolesListEnum;
(function (GoogleCloudListRolesListEnum) {
    GoogleCloudListRolesListEnum["TRUE"] = "true";
})(GoogleCloudListRolesListEnum || (exports.GoogleCloudListRolesListEnum = GoogleCloudListRolesListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var GoogleCloudListRoles2ListEnum;
(function (GoogleCloudListRoles2ListEnum) {
    GoogleCloudListRoles2ListEnum["TRUE"] = "true";
})(GoogleCloudListRoles2ListEnum || (exports.GoogleCloudListRoles2ListEnum = GoogleCloudListRoles2ListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var JwtListRolesListEnum;
(function (JwtListRolesListEnum) {
    JwtListRolesListEnum["TRUE"] = "true";
})(JwtListRolesListEnum || (exports.JwtListRolesListEnum = JwtListRolesListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var KerberosListGroupsListEnum;
(function (KerberosListGroupsListEnum) {
    KerberosListGroupsListEnum["TRUE"] = "true";
})(KerberosListGroupsListEnum || (exports.KerberosListGroupsListEnum = KerberosListGroupsListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var KubernetesListAuthRolesListEnum;
(function (KubernetesListAuthRolesListEnum) {
    KubernetesListAuthRolesListEnum["TRUE"] = "true";
})(KubernetesListAuthRolesListEnum || (exports.KubernetesListAuthRolesListEnum = KubernetesListAuthRolesListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var LdapListGroupsListEnum;
(function (LdapListGroupsListEnum) {
    LdapListGroupsListEnum["TRUE"] = "true";
})(LdapListGroupsListEnum || (exports.LdapListGroupsListEnum = LdapListGroupsListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var LdapListUsersListEnum;
(function (LdapListUsersListEnum) {
    LdapListUsersListEnum["TRUE"] = "true";
})(LdapListUsersListEnum || (exports.LdapListUsersListEnum = LdapListUsersListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var OciListRolesListEnum;
(function (OciListRolesListEnum) {
    OciListRolesListEnum["TRUE"] = "true";
})(OciListRolesListEnum || (exports.OciListRolesListEnum = OciListRolesListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var OktaListGroupsListEnum;
(function (OktaListGroupsListEnum) {
    OktaListGroupsListEnum["TRUE"] = "true";
})(OktaListGroupsListEnum || (exports.OktaListGroupsListEnum = OktaListGroupsListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var OktaListUsersListEnum;
(function (OktaListUsersListEnum) {
    OktaListUsersListEnum["TRUE"] = "true";
})(OktaListUsersListEnum || (exports.OktaListUsersListEnum = OktaListUsersListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var RadiusListUsersListEnum;
(function (RadiusListUsersListEnum) {
    RadiusListUsersListEnum["TRUE"] = "true";
})(RadiusListUsersListEnum || (exports.RadiusListUsersListEnum = RadiusListUsersListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var TokenListAccessorsListEnum;
(function (TokenListAccessorsListEnum) {
    TokenListAccessorsListEnum["TRUE"] = "true";
})(TokenListAccessorsListEnum || (exports.TokenListAccessorsListEnum = TokenListAccessorsListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var TokenListRolesListEnum;
(function (TokenListRolesListEnum) {
    TokenListRolesListEnum["TRUE"] = "true";
})(TokenListRolesListEnum || (exports.TokenListRolesListEnum = TokenListRolesListEnum = {}));
/**
  * @export
  * @enum {string}
  */
var UserpassListUsersListEnum;
(function (UserpassListUsersListEnum) {
    UserpassListUsersListEnum["TRUE"] = "true";
})(UserpassListUsersListEnum || (exports.UserpassListUsersListEnum = UserpassListUsersListEnum = {}));
