; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#define MyAppName "Upplay"
#define MyAppVersion "1.9.6-npupnp-msvc-20250416-4b157efe"
#define MyAppPublisher "J.F. Dockes"
#define MyAppURL "http://www.lesbonscomptes.com/upplay"
#define MyAppExeName "upplay.exe"

; NPUPNP   git hash 52632b4830328475f939e2250d4a79f3bf4ac053
; LIBUPNPP git hash e7e626a39afe42b1ea9c3217bc5ab2d23c20e498
; UPPLAY   git hash 32d83b27b30a8ba5daa206f7636877808e16103e

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
AppId={{2F46F6CE-9FFF-41B0-9EE8-392FBABB4C35}
AppName={#MyAppName}
AppVersion={#MyAppVersion}
;AppVerName={#MyAppName} {#MyAppVersion}
ArchitecturesInstallIn64BitMode=x64compatible
ArchitecturesAllowed=x64compatible
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
ArchitecturesInstallIn64BitMode=x64compatible
ArchitecturesAllowed=x64compatible
DefaultGroupName={#MyAppName}
OutputDir=C:\Temp
Compression=lzma
SolidCompression=yes
;; Use either prv=adm and defaultdir={pf} or prv=lowest and defaultdir=userpf
;PrivilegesRequired=lowest
;DefaultDirName={userpf}\{#MyAppName}
PrivilegesRequired=admin
DefaultDirName={commonpf}\{#MyAppName}
LicenseFile=C:\Users\Bill\Documents\COPYING.txt
OutputBaseFilename=upplaysetup-{#MyAppVersion}
SetupIconFile=C:\install\upplay\upplay.ico

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked

[Files]
; VC++ redistributable runtime. Extracted by VC2017RedistNeedsInstall(), if needed.
Source: "C:\users\bill\Documents\recolldeps\vc_redist\VC_redist.x64.exe"; DestDir: {tmp}; Flags: dontcopy
Source: "C:\install\upplay\*"; DestDir: "{app}"; Flags: ignoreversion recursesubdirs createallsubdirs
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[Icons]
Name: "{group}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"; IconFilename: "{app}\upplay.ico"; 
Name: "{commondesktop}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"; IconFilename: "{app}\upplay.ico"; Tasks: desktopicon

[CustomMessages]
InstallingVCredist=Installing Microsoft VC++ redistributable

[Run]
Filename: "{tmp}\VC_redist.x64.exe"; \
  StatusMsg: "{cm:InstallingVCredist}"; \
  Parameters: "/quiet"; Check: VCRedistNeedsInstall; Flags: waituntilterminated
Filename: "{app}\{#MyAppExeName}"; Description: "{cm:LaunchProgram,{#StringChange(MyAppName, '&', '&&')}}"; Flags: nowait postinstall skipifsilent

[Code]
function VCRedistNeedsInstall: Boolean;
var 
  Version: String;
begin
  if RegQueryStringValue(HKEY_LOCAL_MACHINE,
       'SOFTWARE\Microsoft\VisualStudio\14.0\VC\Runtimes\x64', 'Version',
       Version) then
  begin
    // Is the installed version at least ours ? 
    Log('VC Redist Version check : found ' + Version);
    Result := (CompareStr(Version, 'v14.42.34438.00')<0);
  end
  else 
  begin
    // Not even an old version installed
    Result := True;
  end;
  if (Result) then
  begin
    ExtractTemporaryFile('VC_redist.x64.exe');
  end;
end;
