/* Copyright (C) 2014 J.F.Dockes
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the
 *     Free Software Foundation, Inc.,
 *     59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _UPPUTILS_H_INCLUDED_
#define _UPPUTILS_H_INCLUDED_

/** Small utilities mostly to translate from libupnpp to sayonara data 
 *  elements */

#include <string>
#include <memory>

#include <QString>
#include <QVariant>

inline std::string qs2utf8s(const QString& qs)
{
    return std::string((const char *)qs.toUtf8());
}

inline QString u8s2qs(const std::string us) 
{
    return QString::fromUtf8(us.c_str());
}

namespace UPnPClient {
    class UPnPDirObject;
}

struct MetaData;
class Playlist;

extern bool udirentToMetadata(
    const UPnPClient::UPnPDirObject *, MetaData *,
    std::shared_ptr<Playlist> pl = std::shared_ptr<Playlist>());

QString metaDataToHtml(const MetaData* metap);
QString metaDataToHtml(const MetaData* _metap, const UPnPClient::UPnPDirObject& dirent, bool okdir,
    bool showdidl = true);

bool playlistToCSV(const std::vector<MetaData>& pl, const QString& fn);
bool playlistToM3U(const std::vector<MetaData>& pl, const QString& fn);

// QSettings key name for renderer-specific variable varnm
std::string rendererSettingsKey(const QString& varnm, const QString& friendlyname);
// QSettings value for renderer-specific variable varnm
QVariant rendererSetting(const QString& varnm, const QString& friendlyname);

std::string quoteString(const std::string& in);
#endif /* _UPPUTILS_H_INCLUDED_ */
