/*
 * Copyright (C) 2015-2023 Jolla Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * This file was initially generated by qdbusxml2cpp version 0.8
 * qdbusxml2cpp is Copyright (C) 2020 The Qt Company Ltd.
 */

#include "mprisplayeradaptor_p.h"
#include "mprisplayer.h"
#include "mprisplayer_p.h"
#include "mprismetadata_p.h"
#include <QtCore/QMetaObject>
#include <QtCore/QByteArray>
#include <QtCore/QList>
#include <QtCore/QMap>
#include <QtCore/QString>
#include <QtCore/QStringList>
#include <QtCore/QVariant>

using namespace Amber;

/*
 * Implementation of adaptor class MprisPlayerAdaptor
 */

MprisPlayerAdaptor::MprisPlayerAdaptor(MprisPlayerPrivate *parent)
    : QDBusAbstractAdaptor(parent)
    , m_playerPrivate(parent)
{
    setAutoRelaySignals(true);
}

MprisPlayerAdaptor::~MprisPlayerAdaptor()
{
}

void MprisPlayerAdaptor::Next()
{
    // handle method call org.mpris.MediaPlayer2.Player.Next
    m_playerPrivate->Next();
}

void MprisPlayerAdaptor::OpenUri(const QString &Uri)
{
    m_playerPrivate->OpenUri(Uri);
}

void MprisPlayerAdaptor::Pause()
{
    // handle method call org.mpris.MediaPlayer2.Player.Pause
    m_playerPrivate->Pause();
}

void MprisPlayerAdaptor::Play()
{
    // handle method call org.mpris.MediaPlayer2.Player.Play
    m_playerPrivate->Play();
}

void MprisPlayerAdaptor::PlayPause()
{
    // handle method call org.mpris.MediaPlayer2.Player.PlayPause
    m_playerPrivate->PlayPause();
}

void MprisPlayerAdaptor::Previous()
{
    // handle method call org.mpris.MediaPlayer2.Player.Previous
    m_playerPrivate->Previous();
}

void MprisPlayerAdaptor::Seek(qlonglong Offset)
{
    // handle method call org.mpris.MediaPlayer2.Player.Seek
    m_playerPrivate->Seek(Offset);
}

void MprisPlayerAdaptor::SetPosition(const QDBusObjectPath &TrackId, qlonglong Position)
{
    // handle method call org.mpris.MediaPlayer2.Player.SetPosition
    m_playerPrivate->SetPosition(TrackId, Position);
}

void MprisPlayerAdaptor::Stop()
{
    // handle method call org.mpris.MediaPlayer2.Player.Stop
    m_playerPrivate->Stop();
}

