/* Copyright (C) 2011  Lucio Carreras
 * Copyright (C) 2025  J.F. Dockes <jf@dockes.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _HELPER_H
#define _HELPER_H

#include <QString>

namespace Helper {

bool read_file_into_str(const QString& filename, QString& content);
QString file_to_str(const QString& filename);

QString cvtMsecs2TitleLengthString(long int msec, bool colon = true, bool show_days = true);

void setIconStyle(const QString& subd);
QString getIconPath(const QString& nm);

// Data file locations
QString getSharePath();
QString getHomeDataPath();
// Get it either from home or central share path
QString getDataFilePath(QString basename);

// Make an HTML href
QString createLink(QString name, QString target = "", bool underline = true);

// Get the user-configurable HTML for displaying fields in the currently playing section.
QString getPlayerHtmlFrag();

}
#endif
