/* Copyright (C) 2011  Lucio Carreras
 * Copyright (C) 2025  J.F. Dockes
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef CSettingsStorage_H
#define CSettingsStorage_H

#include <QString>
#include <QSettings>
#include <QApplication>

#define GENCODE_VARIABLE(NM, TP, CTP)      \
    void set##NM(TP val) {                 \
        setValue(#NM, val);                \
    }                                      \
    TP get##NM () {                        \
        return value(#NM).to##CTP ();      \
    }


class CSettingsStorage : public QSettings {
    Q_OBJECT

public:
    static CSettingsStorage* getInstance();
    CSettingsStorage(const CSettingsStorage&) = delete;
    CSettingsStorage& operator=(const CSettingsStorage&) = delete;

    virtual ~CSettingsStorage () = default;

    // First time run check
    bool isRunFirstTime ();

private:
    CSettingsStorage(QObject *parent = 0) 
        : QSettings (QCoreApplication::organizationName(),
                     QCoreApplication::applicationName(), parent) {}

public:
    GENCODE_VARIABLE(Version, QString, String)
    GENCODE_VARIABLE(Volume, int, Int)
    GENCODE_VARIABLE(PlayerFullscreen, bool, Bool)
    GENCODE_VARIABLE(ShowNotifications, bool, Bool)
    GENCODE_VARIABLE(Notification, QString, String)
    GENCODE_VARIABLE(NotificationTimeout, int, Int)
    GENCODE_VARIABLE(NotificationScale, int, Int)
    GENCODE_VARIABLE(NoShowLibrary, bool, Bool)
    GENCODE_VARIABLE(MinimizeToTray, bool, Bool)
    GENCODE_VARIABLE(ShowSmallPlaylist, bool, Bool)
    GENCODE_VARIABLE(PlaylistNumbers, bool, Bool)
    GENCODE_VARIABLE(NotifyNewVersion, bool,  Bool)
    GENCODE_VARIABLE(PlayerUID, QString, String)
    // Splitter is the horiz split between player/playlist and lib
    GENCODE_VARIABLE(SplitterState, QByteArray, ByteArray)
    // VSplitter is the vert split between player and playlist
    GENCODE_VARIABLE(VSplitterState, QByteArray, ByteArray)
    GENCODE_VARIABLE(SortKind, int, Int);
    GENCODE_VARIABLE(SortCrits, QStringList, StringList);
    GENCODE_VARIABLE(PlaylistMode, int, Int);
};

#undef GENCODE_VARIABLE

#endif // CSettingsStorage_H
