
#include <QMouseEvent>
#include <QVBoxLayout>
#include <QLabel>

class TooltipWindow : public QWidget
{
    Q_OBJECT

public:
    enum flags {TTW_NONE, TTW_CLOSEONCLICK=1, TTW_CLOSEONLEAVE=2};
    // On Wayland this does need a parent else we get an error message about "transientparent" and
    // no popup.
    TooltipWindow(const QString& html, QWidget *parent, int flags = TTW_CLOSEONLEAVE)
        : QWidget(parent), m_flags(flags) {
        // Set window flags to make it behave like a tooltip
        setWindowFlags(Qt::Window | Qt::ToolTip | Qt::FramelessWindowHint);

        // Create a layout and add a label
        QVBoxLayout *layout = new QVBoxLayout(this);
        layout->setContentsMargins(0, 0, 0, 0);
        QLabel *label = new QLabel(html, this);
        label->setTextInteractionFlags(Qt::TextSelectableByMouse);
        layout->addWidget(label);

        // Set the layout
        setLayout(layout);

        // Adjust size to fit content
        adjustSize();
    }

protected:
    // Override the mouse press event to close the window on any click
    void mousePressEvent(QMouseEvent *event) override {
        Q_UNUSED(event);
        if (!(m_flags&TTW_CLOSEONCLICK))
            return;
        close();
        this->deleteLater();
    }
    void leaveEvent(QEvent *event) override {
        Q_UNUSED(event);
        if (!(m_flags&TTW_CLOSEONLEAVE))
            return;
        close();
        this->deleteLater();
    }
private:
    int m_flags;
};
