#ifndef _CDWEBPAGE_H_INCLUDED_
#define _CDWEBPAGE_H_INCLUDED_

/* Copyright (C) 2025 J.F.Dockes
 *
 * License: GPL 2.1
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

// A class to mask some webkit/webengine differences, and capture javascript console messages

#include "libupnpp/log.h"
#include "upadapt/upputils.h"

#ifdef USING_WEBENGINE
#include <QWebEngineView>
#include <QWebEngineProfile>

class QWebEngineProfile;

class CDWebPage: public QWebEnginePage {
    Q_OBJECT

public:
    CDWebPage(QWebEngineProfile *profile, QWidget *parent = nullptr) 
        : QWebEnginePage(profile, parent) {}

protected:
    virtual bool acceptNavigationRequest(const QUrl& url, NavigationType navType, bool);
    virtual void javaScriptConsoleMessage(
        JavaScriptConsoleMessageLevel, const QString& msg, int lineNum, const QString&) {
        LOGERR("JAVASCRIPT: "<< qs2utf8s(msg) << " at line " << lineNum << "\n");
    }

signals:
    void linkClicked(const QUrl& url);
};

#else // Using WEBKIT

#include <QWebView>

// A QObject to hold a QString. Maybe there would be a simpler way to
// do this but anyway... We use javascript to append HTML to the
// window content when new directory entries arrive. We could include
// the HTML in a javascript statement:
//     innerhtml += "html text"
// But then we'd have to escape all the double quotes. Instead we store
// the text inside the QObject text property and make the QObject
// available to javascript. The javascript statement becomes 
//       innerhtml += newtext.text
class StringObj : public QObject {
    Q_OBJECT;
    Q_PROPERTY(QString text READ text);
public:
    StringObj(const QString& s) : m_s(s) {}
    QString text() {
        return m_s;
    }
    QString m_s;
};

class CDWebPage: public QWebPage {
    Q_OBJECT;

public:
    CDWebPage(QWidget* parent = 0) : QWebPage(parent) {}
    virtual void javaScriptConsoleMessage(const QString& msg, int lineNum, const QString&) {
        LOGERR("JAVASCRIPT: "<< qs2utf8s(msg) << " at line " << lineNum << "\n");
    }
protected:
    QString userAgentForUrl(const QUrl&) const override {
        return QString("Upplay Control Point");
    }
};

#endif // WEBKIT

#endif /* _CDWEBPAGE_H_INCLUDED_ */
