/* Copyright (C) 2015 J.F.Dockes
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _MDATAWIDGET_H_INCLUDED_
#define _MDATAWIDGET_H_INCLUDED_

#ifdef USING_WEBENGINE
#include <QWebEngineView>
#include <QWebChannel>
#define QWEBVIEW QWebEngineView
#define QWEBPAGE QWebEnginePage
#define QWEBSETTINGS QWebEngineSettings
#else
#include <QWebView>
#define QWEBVIEW QWebView
#define QWEBPAGE QWebPage
#define QWEBSETTINGS QWebSettings
#endif

#include "HelperStructs/MetaData.h"


class QResizeEvent;
class QTimer;
class QPoint;
class QAction;

class JSHelper: public QObject{
    Q_OBJECT
public:
    using QObject::QObject;
Q_SIGNALS:
    void coverHover();
public Q_SLOTS:
    void onCoverHover(){
        Q_EMIT coverHover();
    }
};

class MDataWidget : public QWidget {
    Q_OBJECT;

public:
    MDataWidget(QWidget *parent = 0);
    virtual ~MDataWidget() {}

public slots:
    virtual void setData(const MetaData& md);
    virtual void setCoverImage(QString url);
    virtual void display();
    virtual void createPopupMenu(const QPoint&);
    virtual void onPopupTriggered(QAction *);
    virtual void coverZoom();
    virtual void refresh();
#ifndef USING_WEBENGINE
    virtual void connectJSHelper();
#endif
        
protected:
    virtual void resizeEvent(QResizeEvent *event) override;

private:
    QWEBVIEW *m_view{nullptr};
    MetaData m_data;
    QString m_imgurl;
    QTimer *m_timer{nullptr};
    JSHelper m_jslink;
#ifdef USING_WEBENGINE
    QWebChannel m_channel;
#endif
};

#endif /* _MDATAWIDGET_H_INCLUDED_ */
