/* Copyright (C) 2012  Lucio Carreras
 *
 * This file is part of sayonara player
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "mainw.h"

#include <QtNetwork/QNetworkReply>
#include <QIcon>
#include <QImageReader>
#include <QImage>
#include <QTemporaryFile>
#include <QDir>
#include <QSettings>
#include <QPushButton>


#include "libupnpp/log.hxx"
#include "upadapt/upputils.h"
#include "GUI/playerwidget/playerwidget.h"
#include "GUI/mdatawidget/mdatawidget.h"

void GUI_Player::fetch_cover(const QString& uri)
{
    LOGDEB("GUI_Player::fetch_cover: " << qs2utf8s(uri) << "\n");
    if (!m_netmanager) {
        LOGERR("GUI_Player::fetch_cover: No net manager !\n");
        m_currentCoverReply = 0;
        return;
    }
    QNetworkRequest req{QUrl(uri)};
    req.setHeader(QNetworkRequest::UserAgentHeader, "Upplay Control Point");
    m_currentCoverReply = m_netmanager->get(req);
}

void GUI_Player::sl_cover_fetch_done(QNetworkReply* reply)
{
    if (m_currentCoverReply && reply != m_currentCoverReply) {
        // Ignore answers to older requests
        LOGERR("GUI_Player::sl_cover_fetch_done:  diff reply "  << reply << " cur-reply " <<
               m_currentCoverReply << "\n");
        reply->deleteLater();
        return;
    }
    if (reply->error() != QNetworkReply::NoError) {
        reply->deleteLater();
        sl_no_cover_available();
        LOGDEB("GUI_Player::sl_cover_fetch_done: fetch failed\n");
        return;
    }

    QString smime = reply->header(QNetworkRequest::ContentTypeHeader).toString();
    LOGDEB("GUI_Player::sl_cover_fetch_done: mime: " << qs2utf8s(smime) << '\n');
    int scolon;
    if ((scolon = smime.indexOf(";")) > 0) {
        smime = smime.left(scolon);
    }
    const char *suffix;
    if (!smime.compare("image/png", Qt::CaseInsensitive)) {
        suffix = ".png";
    } else if (!smime.compare("image/jpeg", Qt::CaseInsensitive)) {
        suffix = ".jpg";
    } else if (!smime.compare("image/gif", Qt::CaseInsensitive)) {
        suffix = ".gif";
    } else {
        LOGDEB("GUI_Player::sl_cover_fetch_done: unsup. MIME type: " << qs2utf8s(smime) << '\n');
        reply->deleteLater();
        sl_no_cover_available();
        return;
    }
    QByteArray imdata = reply->readAll();

    QString tpath = QDir(QDir::tempPath()).absoluteFilePath(QString::fromUtf8("XXXXXX") + suffix);

    if (m_covertempfile) {
        delete(m_covertempfile);
        m_covertempfile = 0;
    }
    m_covertempfile = new QTemporaryFile(tpath, this);
    if (m_covertempfile) {
        m_covertempfile->open();
        m_covertempfile->write(imdata);
        m_covertempfile->close();
    }
    player()->mdata()->setCoverImage(m_covertempfile->fileName());
    reply->deleteLater();
}

void GUI_Player::setCoverSize(int)
{
}

void GUI_Player::sl_no_cover_available()
{
    m_currentCoverReply = 0;
    player()->mdata()->setCoverImage(Helper::getIconPath("logo.png"));
}
