/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import io.jenetics.Gene;
import io.jenetics.Genotype;
import io.jenetics.Optimize;
import io.jenetics.Phenotype;
import io.jenetics.engine.Codec;
import io.jenetics.engine.EvolutionDurations;
import io.jenetics.engine.EvolutionStart;
import io.jenetics.internal.util.Lazy;
import io.jenetics.stat.MinMax;
import io.jenetics.util.Factory;
import io.jenetics.util.ISeq;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Stream;

public final class EvolutionResult<G extends Gene<?, G>, C extends Comparable<? super C>>
implements Comparable<EvolutionResult<G, C>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Optimize _optimize;
    private final ISeq<Phenotype<G, C>> _population;
    private final long _generation;
    private final long _totalGenerations;
    private final EvolutionDurations _durations;
    private final int _killCount;
    private final int _invalidCount;
    private final int _alterCount;
    private final Lazy<Phenotype<G, C>> _best;
    private final Lazy<Phenotype<G, C>> _worst;

    private EvolutionResult(Optimize optimize, ISeq<Phenotype<G, C>> population, long generation, long totalGenerations, EvolutionDurations durations, int killCount, int invalidCount, int alterCount) {
        this._optimize = Objects.requireNonNull(optimize);
        this._population = Objects.requireNonNull(population);
        this._generation = generation;
        this._totalGenerations = totalGenerations;
        this._durations = Objects.requireNonNull(durations);
        this._killCount = killCount;
        this._invalidCount = invalidCount;
        this._alterCount = alterCount;
        this._best = Lazy.of(() -> this._population.stream().max(this._optimize.ascending()).orElse(null));
        this._worst = Lazy.of(() -> this._population.stream().min(this._optimize.ascending()).orElse(null));
    }

    public Optimize getOptimize() {
        return this._optimize;
    }

    public ISeq<Phenotype<G, C>> getPopulation() {
        return this._population;
    }

    public ISeq<Genotype<G>> getGenotypes() {
        return this._population.stream().map(Phenotype::getGenotype).collect(ISeq.toISeq());
    }

    public long getGeneration() {
        return this._generation;
    }

    public long getTotalGenerations() {
        return this._totalGenerations;
    }

    public EvolutionDurations getDurations() {
        return this._durations;
    }

    public int getKillCount() {
        return this._killCount;
    }

    public int getInvalidCount() {
        return this._invalidCount;
    }

    public int getAlterCount() {
        return this._alterCount;
    }

    public Phenotype<G, C> getBestPhenotype() {
        return this._best.get();
    }

    public Phenotype<G, C> getWorstPhenotype() {
        return this._worst.get();
    }

    public C getBestFitness() {
        return this._best.get() != null ? (C)this._best.get().getFitness() : null;
    }

    public C getWorstFitness() {
        return this._worst.get() != null ? (C)this._worst.get().getFitness() : null;
    }

    public EvolutionStart<G, C> next() {
        return EvolutionStart.of(this._population, this._totalGenerations + 1L);
    }

    public EvolutionStart<G, C> toEvolutionStart() {
        return EvolutionStart.of(this._population, this._totalGenerations);
    }

    @Override
    public int compareTo(EvolutionResult<G, C> other) {
        return this._optimize.compare((Comparable)this._best.get(), (Comparable)other._best.get());
    }

    private EvolutionResult<G, C> withTotalGenerations(long total) {
        return EvolutionResult.of(this._optimize, this._population, this._generation, total, this._durations, this._killCount, this._invalidCount, this._alterCount);
    }

    public int hashCode() {
        int hash = 17;
        hash += 31 * Objects.hashCode((Object)this._optimize) + 17;
        hash += 31 * Objects.hashCode(this._population) + 17;
        hash += 31 * Objects.hashCode(this._generation) + 17;
        hash += 31 * Objects.hashCode(this._totalGenerations) + 17;
        hash += 31 * Objects.hashCode(this._durations) + 17;
        hash += 31 * Objects.hashCode(this._killCount) + 17;
        hash += 31 * Objects.hashCode(this._invalidCount) + 17;
        hash += 31 * Objects.hashCode(this._alterCount) + 17;
        return hash += 31 * Objects.hashCode(this.getBestFitness()) + 17;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof EvolutionResult && Objects.equals((Object)this._optimize, (Object)((EvolutionResult)obj)._optimize) && Objects.equals(this._population, ((EvolutionResult)obj)._population) && Objects.equals(this._generation, ((EvolutionResult)obj)._generation) && Objects.equals(this._totalGenerations, ((EvolutionResult)obj)._totalGenerations) && Objects.equals(this._durations, ((EvolutionResult)obj)._durations) && Objects.equals(this._killCount, ((EvolutionResult)obj)._killCount) && Objects.equals(this._invalidCount, ((EvolutionResult)obj)._invalidCount) && Objects.equals(this._alterCount, ((EvolutionResult)obj)._alterCount) && Objects.equals(this.getBestFitness(), ((EvolutionResult)obj).getBestFitness());
    }

    public static <G extends Gene<?, G>, C extends Comparable<? super C>> Collector<EvolutionResult<G, C>, ?, EvolutionResult<G, C>> toBestEvolutionResult() {
        return Collector.of(MinMax::of, MinMax::accept, MinMax::combine, (A mm) -> mm.getMax() != null ? ((EvolutionResult)mm.getMax()).withTotalGenerations(mm.getCount()) : null, new Collector.Characteristics[0]);
    }

    public static <G extends Gene<?, G>, C extends Comparable<? super C>> Collector<EvolutionResult<G, C>, ?, Phenotype<G, C>> toBestPhenotype() {
        return Collector.of(MinMax::of, MinMax::accept, MinMax::combine, (A mm) -> mm.getMax() != null ? ((EvolutionResult)mm.getMax()).getBestPhenotype() : null, new Collector.Characteristics[0]);
    }

    public static <G extends Gene<?, G>, C extends Comparable<? super C>> Collector<EvolutionResult<G, C>, ?, Genotype<G>> toBestGenotype() {
        return Collector.of(MinMax::of, MinMax::accept, MinMax::combine, (A mm) -> mm.getMax() != null ? (((EvolutionResult)mm.getMax()).getBestPhenotype() != null ? ((EvolutionResult)mm.getMax()).getBestPhenotype().getGenotype() : null) : null, new Collector.Characteristics[0]);
    }

    public static <G extends Gene<?, G>, C extends Comparable<? super C>, T> Collector<EvolutionResult<G, C>, ?, T> toBestResult(Function<Genotype<G>, T> decoder) {
        Objects.requireNonNull(decoder);
        return Collector.of(MinMax::of, MinMax::accept, MinMax::combine, (A mm) -> mm.getMax() != null ? (((EvolutionResult)mm.getMax()).getBestPhenotype() != null ? decoder.apply(((EvolutionResult)mm.getMax()).getBestPhenotype().getGenotype()) : null) : null, new Collector.Characteristics[0]);
    }

    public static <G extends Gene<?, G>, C extends Comparable<? super C>, T> Collector<EvolutionResult<G, C>, ?, T> toBestResult(Codec<T, G> codec) {
        return EvolutionResult.toBestResult(codec.decoder());
    }

    public static <G extends Gene<?, G>, C extends Comparable<? super C>> UnaryOperator<EvolutionResult<G, C>> toUniquePopulation(Factory<Genotype<G>> factory, int maxRetries) {
        Objects.requireNonNull(false);
        return result -> {
            ISeq population = result.getPopulation();
            ISeq genotypes = result.getGenotypes();
            HashSet elements = new HashSet(genotypes.asList());
            EvolutionResult uniques = result;
            if (elements.size() < population.size()) {
                int retries = 0;
                while (elements.size() < population.size() && retries < maxRetries) {
                    if (elements.add(factory.newInstance())) continue;
                    ++retries;
                }
                uniques = result.with(Stream.concat(elements.stream(), genotypes.stream()).limit(population.size()).map(gt -> ((Phenotype)population.get(0)).newInstance((Genotype)factory.newInstance(), result.getGeneration())).collect(ISeq.toISeq()));
            }
            return uniques;
        };
    }

    EvolutionResult<G, C> with(ISeq<Phenotype<G, C>> population) {
        return EvolutionResult.of(this.getOptimize(), population, this.getGeneration(), this.getTotalGenerations(), this.getDurations(), this.getKillCount(), this.getInvalidCount(), this.getAlterCount());
    }

    public static <G extends Gene<?, G>, C extends Comparable<? super C>> UnaryOperator<EvolutionResult<G, C>> toUniquePopulation(Factory<Genotype<G>> factory) {
        return EvolutionResult.toUniquePopulation(factory, 100);
    }

    public static <G extends Gene<?, G>, C extends Comparable<? super C>> UnaryOperator<EvolutionResult<G, C>> toUniquePopulation(int maxRetries) {
        return result -> {
            Genotype factory = ((Phenotype)result.getPopulation().get(0)).getGenotype();
            UnaryOperator unifier = EvolutionResult.toUniquePopulation(factory, maxRetries);
            return (EvolutionResult)unifier.apply((EvolutionResult)result);
        };
    }

    public static <G extends Gene<?, G>, C extends Comparable<? super C>> UnaryOperator<EvolutionResult<G, C>> toUniquePopulation() {
        return result -> {
            Genotype factory = ((Phenotype)result.getPopulation().get(0)).getGenotype();
            UnaryOperator unifier = EvolutionResult.toUniquePopulation(factory);
            return (EvolutionResult)unifier.apply((EvolutionResult)result);
        };
    }

    public static <G extends Gene<?, G>, C extends Comparable<? super C>> EvolutionResult<G, C> of(Optimize optimize, ISeq<Phenotype<G, C>> population, long generation, long totalGenerations, EvolutionDurations durations, int killCount, int invalidCount, int alterCount) {
        return new EvolutionResult<G, C>(optimize, population, generation, totalGenerations, durations, killCount, invalidCount, alterCount);
    }

    public static <G extends Gene<?, G>, C extends Comparable<? super C>> EvolutionResult<G, C> of(Optimize optimize, ISeq<Phenotype<G, C>> population, long generation, EvolutionDurations durations, int killCount, int invalidCount, int alterCount) {
        return new EvolutionResult<G, C>(optimize, population, generation, generation, durations, killCount, invalidCount, alterCount);
    }
}

