# Релизы Timeweb Cloud CLI

В этом файле описаны все значимые изменения в Timeweb Cloud CLI. В выпусках мы придерживается правил [семантического версионирования](https://semver.org/lang/ru/).

# Версия 2.14.1 (2025.09.22)

## Исправлено

- Исправлена ошибка из-за которой нельзя было передать user-data файл для cloud-init в команде `twc server create`.

# Версия 2.14.0 (2025.09.15)

## Добавлено

- Добавлена новая команда `twc server list-configurators` с помощью которой можно просмотреть список доступных конфигураторов облачных серверов. Конфигуратор это набор ограничений для параметров виртуальной машины (CPU, RAM, диск и т.п.).

# Версия 2.13.2 (2025.06.19)

## Исправлено

- Исправлена ошибка фильтрации списка пресетов с опцией `--region` в команде `twc server list-presets`

# Версия 2.13.1 (2025.06.19)

## Исправлено

- Исправлена ошибка приводящая к `invalid_admin_privilege` при передаче пустого списка привилегий для юзера БД в команде `twc database create`.

# Версия 2.13.0 (2025.06.17)

## Добавлено

- Добавлена новая команда `twc apps` для управления сервисом Cloud Apps.

# Версия 2.12.0 (2025.04.11)

## Добавлено

- Добавлены опции `--max-connections`, `--connect-timeout`, `--client-timeout`, `--server-timeout` в команды `twc balancer create`, `twc balancer set`.
- В регионе `kz-1` для облачных серверов теперь доступен IPv6.

## Изменено

- Стандартный ендпоинт объектного хранилища изменён с `s3.timeweb.cloud` на `s3.twcstorage.ru`.

# Версия 2.11.0 (2025.04.01)

## Добавлено

- Добавлены новые опции к команде `twc balancer create`:
    - для настройки сети: `--network-id`, `--public-ip`, `--no-public-ip`, `--private-ip`;
    - для установки TLS: `--cert-type`, `--cert-domain`, `--cert-data`, `--cert-key`;
    - выбор локации и пресета: `--region`, `--availability-zone`, `--preset-id`;
    - дополнительные: `--desc` (описание балансировщика нагрузки).
- Добавлена новая команда для просмотра списка доступных пресетов балансировщиков нагрузки — `twc balancer list-presets`.

## Изменено

- Опция `--network` команды `twc balancer create` объявлена устаревшей и скрыта. Вместо неё используйте `--network-id`.

## Исправлено

- Исправлена ошибка в команде `twc server create` возникавшая при передаче парамера `--project-id`.

# Версия 2.10.1 (2025.03.25)

## Исправлено

- Исправлена ошибка получения публичного IP при создании кластера СУБД.

# Версия 2.10.0 (2025.03.24)

## Добавлено

- Добавлена поддержка региона `de-1` (зона `fra-1`) для облачных серверов.
- Добавлены новые опции к команде `twc database create`:
    - для создания пользователя СУБД: `--user-login`, `--user-password`, `--user-host`, `--user-privileges`, `--user-desc`;
    - для создания первой базы данных: `--db-name`, `--db-desc`;
    - для настроек сети в класетере СУБД: `--network-id`, `--private-ip`, `--public-ip`, `--no-public-ip`;
    - для настройки автоматических бэкапов кластера: `--enable-backups`, `--backup-keep`, `--backup-start-date`, `--backup-interval`, `--backup-day-of-week`.
- Добавлена новая команда `twc database list-types` для вывода доступных к созданию управляемых баз данных.
- Добавлена новая команда `twc database backup schedule` позволяющая настроить параметры автоматического резервного копирования кластера.
- Добавлены новые команды для управления пользователями в кластерах СУБД: `twc database user list`, `twc database user get`, `twc database user create`, `twc database user remove`.
- Добавлены новые команды для управления базами данных в кластерах СУБД: `twc database instance list`, `twc database instance create`, `twc database instance remove`.

## Изменено

- Опция `--network` команды `twc server create` объявлена устаревшей  и скрыта, добавлена эквивалентная опция `--network-id`.
- Опции `--login` и `--password` команды `twc database create` объявлены устаревшими и скрыты, вместо них теперь нужно использовать `--user-login` и `--user-password`.

# Версия 2.9.2 (2025.03.10)

## Исправлено

- Исправлена ошибка из-за которой на Windows не устанавливались аттрибуты накнфигурационный файл.

# Версия 2.9.1 (2025.03.07)

## Исправлено

- Исправлена ошибка в реализации опции `--gpu` в `twc server create`.

# Версия 2.9.0 (2025.03.06)

## Добавлено

- Поддержка заказа серверов с GPU
- Поддержка заказа серверов линейки Dedicated CPU
- Добавлены новые опции для команды `twc server create`: `--disable-ssh-password-auth`, `--gpus`, `--type`, `--configurator-id`.

## Изменено

- Мелкие улучшения в коде.

# Версия 2.8.0 (2025.02.13)

## Добавлено

- Поддержка SRV-записей для доменов.
- Теперь можно задавать TTL для DNS-записей.

# Версия 2.7.0 (2024.11.02)

## Добавлено

- Добавлена новая команда `twc whoami`, которая показывает логин аккаунта, в котором в текущий момент авторизован CLI.

## Изменено

- Команда `twc account status` теперь также отображает логин аккаунта.

## Исправлено

- Устранено падение программы при листинге образов (`twc image list`) и при создании сервера из образа.
- Исправлена ошибка при создании сервера с приватной сетью в зоне доступности SPB-3.
- Исправлены ошибки в командах `twc storage subdomain gencert` и `twc storage subdomain remove`, возникшие из-за нарушения обратной совместимости эндпоинтов API.
- Исправлена ошибка валидации приватного адреса при созаднии сервера — ошибочно запрещалось использовать 4-й по порядку адрес в подсети.
- Исправлена ошибка разбора JSON при выводе списка ресурсов в проекте.
- Исправлены ошибки добавления TXT записи для домена в команде `twc domain record add`.
- Исправлена ошибка парсинка субдомена в команде `twc domain record add`.
- Исправлены ошибки обновления DNS-записей на поддоменах.

# Версия 2.6.0 (2024.08.14)

## Добавлено

- В команды и API-клиент для управления облачным файрволом добавлена поддержка протоколов TCP6, UDP6, ICMP6 и настройка стандартной политики (DROP или ACCEPT).
- Добавлены новые команды: `twc firewall group get`, `twc firewall group dump` и `twc firewall group restore`.

## Изменено

- Улучшена валидация параметров и подстановка значений по умолчанию в командах `twc firewall`.
- Команда `twc firewall rule remove` теперь может принимать список UUID правил через пробел.
- В команде `twc firewall show` аргумент `all` стал необязательным.
- Зависимость `typer` заменена на `typer-slim`.

## Исправлено

- Исправлено определение ендпоинта объектного хранилища при вызове команды `twc storage genconfig`.

# Версия 2.5.0 (2024.07.24)

## Добавлено

- Добавлена поддержка зон доступности. Добавлен параметр конифгурации `availability_zone` (`TWC_AVAILABILITY_ZONE`).
- Добавлены новые опции для команды `twc server create`: `--availability-zone`, `--user-data`, `--public-ip`, `--no-public-ip`, `--private-ip`.
- Добавлена новая команда `twc ip` вместо устаревшей `twc server ip`. Поскольку IP-адреса сейчас являются отдельными ресурсами, управление ими вынесено из `twc server`.

## Изменено

- Минимальная поддерживаемая версия интерпретатора Python повышена до 3.8.
- Обновлены версии зависимостей.
- Обновлены команды и методы API-клиента для работы VPC.
- Удалён параметр `log_response` принимаемый как значение переменной окружения `TWC_LOG`, теперь тело ответа API логируется всегда.
- Команда `twc server ip` объявлена устаревшей (deprecated) и будет уделена в следующем мажорном релизе. Вместо неё используйте команду `twc ip`.
- Другие мелкие обновления CLI без нарушения обратной совместимости.

## Исправлено

- Исправлен метод удаления кластеров Kubernetes во встроенном API-клиенте.
- Исправлена ошибка разбора JSON при получении объекта сервера без IP.

# Версия 2.4.1 (2023.08.30)

## Исправлено

- Исправлена ошибка парсинга доменного имени в команде `twc domain record add`.

# Версия 2.4.0 (2023.08.21)

## Добавлено

- Добавлена команда `twc vpc` (`twc network`) для работы с сервисом VPC. Доступны все предоставляемые API операции с приватными сетями.
- В команды для создания облачных серверов и балансировщиков нагрузки добавлена опция `--network`, с помощью которой можно задать ID приватной сети.
- Добавлена команда `twc domain` для управления доменными именами (добавление, удаление) и DNS-записями. Спасибо @ranmasootome за вклад!
- Добавлена команда `twc firewall` для управления облачным файрволом.
- Добавлена команда `twc config profiles` для вывода списка профилей из конфигурационного файла.

## Изменено

- Удалена опция `--with-deleted` у команды `twc image list`.
- Изменён вывод команд `twc image list` и `twc image get`.
- Опция `--local-network` (`twc server create`) объявлена устаревшей и скрыта. Используйте `--network` вместо неё.
- Вызов команды без аргументов приведёт к показу текста справки вместо ошибки.
- В дополнение к `--help` добавлена опция `-h` для вызова справки.
- Мелкие улучшения кода.

## Исправлено

- Исправлена ошибка в API-клиенте в методе удаления балансировщиков нагрузки.
- Другие мелкие исправления.

# Версия 2.3.0 (2023.06.28)

## Добавлено

- Добавлено управление кластерами Kubernetes — команда `twc cluster`, алиасы: `clusters`, `kubernetes`, `k8s`.

## Изменено

- Улучшена обработка ошибок HTTP.
- Улучшена валидания пользозвательского ввода.

## Исправлено

- Изменён порядок аргументов у команды `twc ssh-key add`.
- Исправления мелких ошибок.

# Версия 2.2.0 (2023.06.07)

## Добавлено

- Добавлена команда `balancer` для управления балансировщиками нагрузки.

# Версия 2.1.1 (2023.06.07)

## Исправлено

- Исправлена ошибка приводившая к падению программы на Python 3.7 и 3.8.

# Версия 2.1.0 (2023.06.06)

## Добавлено

- Добавлена поддержка создания облачных серверов с произвольной конфигурацией во всех доступных локациях. Локацию можно указать через опцию `--region` команды `twc server create`. Для выбора региона по умолчанию для всех новых серверов можно задать переменную окружения `TWC_REGION` или параметр конфигурации `region`.
- В команду `twc server create` добавлена опция `--nat-mode`. Теперь можно определить режим работы NAT при создании сервера. При этом автоматически применяется флаг `--local-network`.

## Исправлено

- Команда `twc server list` не принимала значение `--limit` и показывала не более 100 серверов.
- Исправлена ошибка при создании сервера с произвольной конфигурацией.
- Исправлена ошибка в API-клиенте в методе получения списка инстансов DBaaS.

# Версия 2.0.2 (2023.05.24)

## Изменено

- Обновлена зависимость `requests` для закрытия уязвимости CVE-2023-32681.

# Версия 2.0.1 (2023.05.19)

## Добавлено

- Теперь собираем программу также в формате zipapp (`.pyz`). Пакет zipapp это исполняемый ZIP-архив с приложением внутри. Он не требует установки, всё что нужно для запуска это интерпретатор Python 3.7 или выше, все зависимости уже добавлены в пакет.

## Исправлено

- Исправлена ошибка типов в модуле `twc.api.exceptions`, которая приводила к краху на Python ниже версии 3.10.

# Версия 2.0.0 (2023.05.03)

Это обновление значительно повышает качество кода, унифицирует интерфейсы и упрощает дальнейшую разработку. Проведён масштабный рефакторинг всей кодовой базы (~5,5 тыс строк кода на момент начала работы).

Основные изменения в этом выпуске касаются парсера аргументов и API-клиента.

> ❗**ВАЖНО**  
> Версия 2.0.0 содержит обратно несовместимые изменения. Обязательно прочтите их список прежде чем обновляться.

## Добавлено

- Добавлена команда `twc config unset` обратная по смыслу команде `twc config set`, она позволяет удалить из конфигурации ранее заданный параметр.
- Для команды `twc config file` добавлен флаг `--locate`. Если он передан, то в файловом менеджере откроется директория с конфигом.
- Теперь приложение найдёт конфигурационный файл, если он называется `.twcrc.toml`, а не только `.twcrc`.
- Добавлена команда `twc server backup schedule` для управления расписанием и настройками автоматических бэкапов дисков. Это клон удалённой команды `twc server disk auto-backup`.
- В API-клиент добавлены методы Проектов для добавления ресурсов каждого типа. Ранее был реализован только универсальный метод `move_resource_to_project()`.
- Добавлен алиас `lsw` для субкоманды `twc server list-software`.
- В команды `twc server dash` и `twc server vnc` добавлена опция `--print` для печати ссылки вместо перехода по ней в веб-браузере.
- Улучшено логирование. HTTP-запросы и ответы теперь более удобочитаемы. Добавлена переменная окружения `TWC_LOG` для настройки параметров логгера. Сейчас доступен только один параметр — `log_response`. По умолчанию тело ответа не логируется чтобы не захламлять лог, но этой опцией логирование можно включить.

## Обратно совместимые изменения

- Библиотека [Click](https://click.palletsprojects.com/) заменена на библиотеку [Typer](https://typer.tiangolo.com/). Благодаря этому переходу:
    - Заработал вызов команды через интерпретатор. То есть теперь можно вызывать програму так: `python -m twc version`. С Click это не работало, хоть и ожидалось.
    - Теперь глобальные опции `--verbose`, `--config`, `--profile` можно писать как в начале команд, так и в конце. Ранее были проблемы с передачей контекста субкомандам, теперь они решены.
    - Появилась поддержка автодополнения команд для оболочки PowerShell.
    - В Click пришлось писать сразу два разных костыля для поддержки алиасов команд. Сейчас есть элегантное решение под Typer :).
    - Удалён костыль для вызова группы команд (без него нельзя было вызвать `twc config`). Эта задача решается Typer нативно.
    - Удалён костыль для создания взаимоисключающих опций Click, вместо этого теперь используется обычный оператор if.
- Изменены описания некоторых параметров CLI.
- Улучшены все тексты ошибок, теперь они более подробные и более явно указывают на проблему.
- Глобально задействован модуль typing. Изменены аннотации типов (type-hints) для всех функций, классов и их методов. Теперь они соответствуют документации API и точнее отражают суть.

## ❗Обратно несовместимые изменения в CLI
 
- Изменён ситаксис команды `twc server set-boot-mode`, новый синтаксис: `set-boot-mode SERVER_ID... MODE`.
- Изменён ситаксис команды `twc server set-nat-mode`, новый синтаксис: `set-nat-mode SERVER_ID... MODE`.
- Команда `twc server set-property` переименована в `twc server set`.
- Команда `twc server logs` переименована в `twc server history`.
- Изменён синтаксис команды `twc server ip add`. Новый синтаксис: `add [OPTIONS] SERVER_ID`.
- Команда `twc server ip set-ptr` заменена на `twc server ip set`, новый синтаксис: `set --ptr POINTER IP_ADDRESS`.
- Изменён синтаксис команды `twc server disk add`. Новый синтаксис: `add --size SIZE SERVER_ID`.
- Удалена команда `twc server disk auto-backup`. Вместо неё используйте `twc server backup schedule`, синтаксис и опции команды никак не отличаются от старых.
- Команда `twc server backup set-property` переименована в `twc server backup set`.
- Изменён синтаксис команды `twc ssh-key add`, новый синтаксис: `add SSH_KEY_ID... SERVER_ID`.
- Команда `twc image set-property` переименована в `twc image set`.
- Команда `twc project set-property` переименована в `twc project set`.
- Изменём синтаксис команды `twc project resource move`, новый синтаксис: `move --[resource-type] [resource_id] PROJECT_ID`. Для каждого типа ресурса добавлена своя опция, например `--bucket`, `--server` и т.д.

## ❗Обратно несовместимые изменения в API-клиенте

- Переименованы методы для работы с публичными IP-адресами серверов: `get_ips_by_server_id()` -> `get_ips()`, `add_ip_addr()` -> `add_ip()`, `delete_ip_addr()` -> `delete_ip()`, `update_ip_addr()` -> `update_ip()`. Также в этих функциях изменено имя аргумента `ip_addr` на `ip`.
- Удалены все старые исключения, полный список и код новых исключений в файле [exceptions.py](../../twc/api/exceptions.py).
- Теперь в случае ошибки API генерируется исключение класса `TimewebCloudException` в котором содержатся данные запроса и ответа, а также отдельно ключи из JSON, отправляемые API в случае ошибок. Итого получается такой набор: `request (<PreparedRequest>)`, `response (<Response>)`, `status_code`, `error_code`, `message`, `response_id`.
- HTTP-запросы теперь отправляются через специальную обёртку — `TimewebCloud._request()`. Это позволило сделать универсальный обработчик исключений и упростить работу с запросами и логирование.

## Исправлено

- Программа больше не падает, если у облачного сервера нет публичных IP-адресов.
- В API-клиенте не было обработки кода подтверждения при удалении облачного сервера.
- При вызове метода для получения списка выделенных серверов аккаунта выводился список баз данных.
- Исправлены ошибки валидации данных при создании сервера, которые проявлялись в редких сценариях.

# Версия 1.3.1 (2023.04.13)

## Изменено

- В команде `twc s3 mb` опция `--preset-id` теперь необязательная. Будет выбран минимальный пресет.

## Исправлено

- Исправлена ошибка при попытке создать дополнительный профиль через `twc config`.

# Версия 1.3.0 (2023.04.13)

## Добавлено

- Добавлена команда `twc storage` (алиас `twc s3`) для управления бакетами в объектном хранилище Timeweb Cloud. Доступны базовые операции с бакетами. Также реализованы субкоманды для работы с доменами и пользователями хранилища. Обратите внимание, что в twc не планируется добавлять реализацию S3-клиента, пользуйтесь любым совместимым клиентом, например, [s3cmd](https://s3tools.org/s3cmd) или [rclone](https://rclone.org/), команда `twc s3 genconfig` позволит сгенерировать конфигурационный файл для этих утилит (см. [документацию](docs/ru/README.md#получение-конфигурации-для-s3-клиентов)).
- Добавлены субкоманды для `twc config`. Теперь можно: сделать дамп настроек CLI (`twc config dump`), изменять настройки без ручного редактирования файла (`twc config set`), получить путь до файла (`twc config file`), открыть файл в редакторе по умолчанию (`twc config edit`).

## Изменено

- Изменены тексты ошибок при работе с конфигурационным файлом, теперь они более наглядные и явно указывают на проблему.
- Изменено поведение команды `twc config`. Теперь если уже иммется конфигурационный файл команда предложит добавить новый профиль или отредактировать существующий.

# Версия 1.2.0 (2023.04.03)

## Добавлено

- Добавлена команда `twc database` (алиас `twc db`). Теперь можно:
    - создавать и удалять управляемые базы данных;
    - изменять параметры базы данных;
    - работать с бэкапами баз данных.
- Реализована возможность работы с токенами, которые требуют подтверждения удаления сервисов через проверочные коды.
- Добавлены алиасы для основных команд, набирать команды стало ещё быстрее. Например, `twc server list` можно сократить до `twc s ls`. Смотрите список алиасов во встроенной справке `--help`.
- Добавлены команды `twc server dash` и `twc server vnc`. С их помощью можно быстро перейти в дашборд и веб-консоль сервера соответсвенно. Ссылки откроются в браузере по умолчанию.

## Изменено

- Поменялся вывод команд `twc server list-presets` и `twc server backup list`, скрыты малоинформативные колонки.
- Мелкие улучшения в коде.

# Версия 1.1.0 (2023.03.24)

## Добавлено

- Добавлена команда `twc image` для управления образами дисков. Можно создавать образы из существующих дисков, загрузить свой образ по ссылке, удалять образы и выполнять другие базовые операции.
- Добавлена возможность использовать UUID пользовательского образа при создании нового сервера (`twc server create`) и при переустановке сервера (`twc server reinstall`).
- Добавлена команда `twc project` для управления проектами и ресурсами в них: создание, удаление, редактирование проектов, перемещение ресурсов между проектами.
- В команду `twc server create` добавлена опция `--project-id`, которая позволяет переместить только что созданный сервер в указанный проект. Задать проект можно также через переменную окружения `TWC_PROJECT` и конфигурационный файл.
- В команду `twc server reinstall` добавлена опция `--add-ssh-key`. Теперь опционально после переустановки на сервер будут добавлены SSH-ключи, которые были на нём ранее.
- Добавлена команда `twc server disk list-all`. Она покажет список всех дисков со всех серверов.
- Опция `--filter` в командах где она есть теперь поддерживает поиск по полям, содержащим значения в мегабайтах и гагибайтах.

## Изменено

- Команда `twc server reinstall` теперь не требует `--image` как обязательный аргумент. Если опция не задана будет выбрана ОС, которая уже установлена на сервере.
- В команде `twc server clone` теперь используется новый метод клонирования сервера. В ответ команда вернёт информацию о клоне сервера.
- В командах `twc server list` и `twc server logs` увеличен стандартный `--limit` до 500.
- В локации `pl-1` (Польша, Гданьск) теперь разрешено добавлять IPv6-адреса.
- В выводе `twc server list-presets` RAM и объём системного диска в табличном виде теперь отображаются в гигабайтах.

## Исправлено

- В выводе команды `twc server list-os-images` теперь правильно отображаем поле `REQUIREMENTS`.
- Исправлена ошибка из-за которой опция `--filter` не фильтровала по ключам, содержащим знак подчёркивания.

# Версия 1.0.0 (2023.02.27)

Первый релиз.
