// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Terraform Plugin RPC protocol version 5.10
//
// This file defines version 5.10 of the RPC protocol. To implement a plugin
// against this protocol, copy this definition into your own codebase and
// use protoc to generate stubs for your target language.
//
// Any minor versions of protocol 5 to follow should modify this file while
// maintaining backwards compatibility. Breaking changes, if any are required,
// will come in a subsequent major version with its own separate proto definition.
//
// Note that only the proto files included in a release tag of Terraform are
// official protocol releases. Proto files taken from other commits may include
// incomplete changes or features that did not make it into a final release.
// In all reasonable cases, plugin developers should take the proto file from
// the tag of the most recent release of Terraform, and not from the main
// branch or any other development branch.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.15.6
// source: tfplugin5.proto

package tfplugin5

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type StringKind int32

const (
	StringKind_PLAIN    StringKind = 0
	StringKind_MARKDOWN StringKind = 1
)

// Enum value maps for StringKind.
var (
	StringKind_name = map[int32]string{
		0: "PLAIN",
		1: "MARKDOWN",
	}
	StringKind_value = map[string]int32{
		"PLAIN":    0,
		"MARKDOWN": 1,
	}
)

func (x StringKind) Enum() *StringKind {
	p := new(StringKind)
	*p = x
	return p
}

func (x StringKind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StringKind) Descriptor() protoreflect.EnumDescriptor {
	return file_tfplugin5_proto_enumTypes[0].Descriptor()
}

func (StringKind) Type() protoreflect.EnumType {
	return &file_tfplugin5_proto_enumTypes[0]
}

func (x StringKind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StringKind.Descriptor instead.
func (StringKind) EnumDescriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{0}
}

type Diagnostic_Severity int32

const (
	Diagnostic_INVALID Diagnostic_Severity = 0
	Diagnostic_ERROR   Diagnostic_Severity = 1
	Diagnostic_WARNING Diagnostic_Severity = 2
)

// Enum value maps for Diagnostic_Severity.
var (
	Diagnostic_Severity_name = map[int32]string{
		0: "INVALID",
		1: "ERROR",
		2: "WARNING",
	}
	Diagnostic_Severity_value = map[string]int32{
		"INVALID": 0,
		"ERROR":   1,
		"WARNING": 2,
	}
)

func (x Diagnostic_Severity) Enum() *Diagnostic_Severity {
	p := new(Diagnostic_Severity)
	*p = x
	return p
}

func (x Diagnostic_Severity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Diagnostic_Severity) Descriptor() protoreflect.EnumDescriptor {
	return file_tfplugin5_proto_enumTypes[1].Descriptor()
}

func (Diagnostic_Severity) Type() protoreflect.EnumType {
	return &file_tfplugin5_proto_enumTypes[1]
}

func (x Diagnostic_Severity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Diagnostic_Severity.Descriptor instead.
func (Diagnostic_Severity) EnumDescriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{1, 0}
}

type Schema_NestedBlock_NestingMode int32

const (
	Schema_NestedBlock_INVALID Schema_NestedBlock_NestingMode = 0
	Schema_NestedBlock_SINGLE  Schema_NestedBlock_NestingMode = 1
	Schema_NestedBlock_LIST    Schema_NestedBlock_NestingMode = 2
	Schema_NestedBlock_SET     Schema_NestedBlock_NestingMode = 3
	Schema_NestedBlock_MAP     Schema_NestedBlock_NestingMode = 4
	Schema_NestedBlock_GROUP   Schema_NestedBlock_NestingMode = 5
)

// Enum value maps for Schema_NestedBlock_NestingMode.
var (
	Schema_NestedBlock_NestingMode_name = map[int32]string{
		0: "INVALID",
		1: "SINGLE",
		2: "LIST",
		3: "SET",
		4: "MAP",
		5: "GROUP",
	}
	Schema_NestedBlock_NestingMode_value = map[string]int32{
		"INVALID": 0,
		"SINGLE":  1,
		"LIST":    2,
		"SET":     3,
		"MAP":     4,
		"GROUP":   5,
	}
)

func (x Schema_NestedBlock_NestingMode) Enum() *Schema_NestedBlock_NestingMode {
	p := new(Schema_NestedBlock_NestingMode)
	*p = x
	return p
}

func (x Schema_NestedBlock_NestingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Schema_NestedBlock_NestingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_tfplugin5_proto_enumTypes[2].Descriptor()
}

func (Schema_NestedBlock_NestingMode) Type() protoreflect.EnumType {
	return &file_tfplugin5_proto_enumTypes[2]
}

func (x Schema_NestedBlock_NestingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Schema_NestedBlock_NestingMode.Descriptor instead.
func (Schema_NestedBlock_NestingMode) EnumDescriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{9, 2, 0}
}

// Reason is the reason for deferring the change.
type Deferred_Reason int32

const (
	// UNKNOWN is the default value, and should not be used.
	Deferred_UNKNOWN Deferred_Reason = 0
	// RESOURCE_CONFIG_UNKNOWN is used when the config is partially unknown and the real
	// values need to be known before the change can be planned.
	Deferred_RESOURCE_CONFIG_UNKNOWN Deferred_Reason = 1
	// PROVIDER_CONFIG_UNKNOWN is used when parts of the provider configuration
	// are unknown, e.g. the provider configuration is only known after the apply is done.
	Deferred_PROVIDER_CONFIG_UNKNOWN Deferred_Reason = 2
	// ABSENT_PREREQ is used when a hard dependency has not been satisfied.
	Deferred_ABSENT_PREREQ Deferred_Reason = 3
)

// Enum value maps for Deferred_Reason.
var (
	Deferred_Reason_name = map[int32]string{
		0: "UNKNOWN",
		1: "RESOURCE_CONFIG_UNKNOWN",
		2: "PROVIDER_CONFIG_UNKNOWN",
		3: "ABSENT_PREREQ",
	}
	Deferred_Reason_value = map[string]int32{
		"UNKNOWN":                 0,
		"RESOURCE_CONFIG_UNKNOWN": 1,
		"PROVIDER_CONFIG_UNKNOWN": 2,
		"ABSENT_PREREQ":           3,
	}
)

func (x Deferred_Reason) Enum() *Deferred_Reason {
	p := new(Deferred_Reason)
	*p = x
	return p
}

func (x Deferred_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Deferred_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_tfplugin5_proto_enumTypes[3].Descriptor()
}

func (Deferred_Reason) Type() protoreflect.EnumType {
	return &file_tfplugin5_proto_enumTypes[3]
}

func (x Deferred_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Deferred_Reason.Descriptor instead.
func (Deferred_Reason) EnumDescriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{13, 0}
}

// DynamicValue is an opaque encoding of terraform data, with the field name
// indicating the encoding scheme used.
type DynamicValue struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Msgpack       []byte                 `protobuf:"bytes,1,opt,name=msgpack,proto3" json:"msgpack,omitempty"`
	Json          []byte                 `protobuf:"bytes,2,opt,name=json,proto3" json:"json,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DynamicValue) Reset() {
	*x = DynamicValue{}
	mi := &file_tfplugin5_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DynamicValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DynamicValue) ProtoMessage() {}

func (x *DynamicValue) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DynamicValue.ProtoReflect.Descriptor instead.
func (*DynamicValue) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{0}
}

func (x *DynamicValue) GetMsgpack() []byte {
	if x != nil {
		return x.Msgpack
	}
	return nil
}

func (x *DynamicValue) GetJson() []byte {
	if x != nil {
		return x.Json
	}
	return nil
}

type Diagnostic struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Severity      Diagnostic_Severity    `protobuf:"varint,1,opt,name=severity,proto3,enum=tfplugin5.Diagnostic_Severity" json:"severity,omitempty"`
	Summary       string                 `protobuf:"bytes,2,opt,name=summary,proto3" json:"summary,omitempty"`
	Detail        string                 `protobuf:"bytes,3,opt,name=detail,proto3" json:"detail,omitempty"`
	Attribute     *AttributePath         `protobuf:"bytes,4,opt,name=attribute,proto3" json:"attribute,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Diagnostic) Reset() {
	*x = Diagnostic{}
	mi := &file_tfplugin5_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Diagnostic) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Diagnostic) ProtoMessage() {}

func (x *Diagnostic) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Diagnostic.ProtoReflect.Descriptor instead.
func (*Diagnostic) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{1}
}

func (x *Diagnostic) GetSeverity() Diagnostic_Severity {
	if x != nil {
		return x.Severity
	}
	return Diagnostic_INVALID
}

func (x *Diagnostic) GetSummary() string {
	if x != nil {
		return x.Summary
	}
	return ""
}

func (x *Diagnostic) GetDetail() string {
	if x != nil {
		return x.Detail
	}
	return ""
}

func (x *Diagnostic) GetAttribute() *AttributePath {
	if x != nil {
		return x.Attribute
	}
	return nil
}

type FunctionError struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Text  string                 `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// The optional function_argument records the index position of the
	// argument which caused the error.
	FunctionArgument *int64 `protobuf:"varint,2,opt,name=function_argument,json=functionArgument,proto3,oneof" json:"function_argument,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *FunctionError) Reset() {
	*x = FunctionError{}
	mi := &file_tfplugin5_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FunctionError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionError) ProtoMessage() {}

func (x *FunctionError) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionError.ProtoReflect.Descriptor instead.
func (*FunctionError) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{2}
}

func (x *FunctionError) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *FunctionError) GetFunctionArgument() int64 {
	if x != nil && x.FunctionArgument != nil {
		return *x.FunctionArgument
	}
	return 0
}

type AttributePath struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Steps         []*AttributePath_Step  `protobuf:"bytes,1,rep,name=steps,proto3" json:"steps,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AttributePath) Reset() {
	*x = AttributePath{}
	mi := &file_tfplugin5_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttributePath) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributePath) ProtoMessage() {}

func (x *AttributePath) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributePath.ProtoReflect.Descriptor instead.
func (*AttributePath) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{3}
}

func (x *AttributePath) GetSteps() []*AttributePath_Step {
	if x != nil {
		return x.Steps
	}
	return nil
}

type Stop struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Stop) Reset() {
	*x = Stop{}
	mi := &file_tfplugin5_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Stop) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Stop) ProtoMessage() {}

func (x *Stop) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Stop.ProtoReflect.Descriptor instead.
func (*Stop) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{4}
}

// RawState holds the stored state for a resource to be upgraded by the
// provider. It can be in one of two formats, the current json encoded format
// in bytes, or the legacy flatmap format as a map of strings.
type RawState struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Json          []byte                 `protobuf:"bytes,1,opt,name=json,proto3" json:"json,omitempty"`
	Flatmap       map[string]string      `protobuf:"bytes,2,rep,name=flatmap,proto3" json:"flatmap,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RawState) Reset() {
	*x = RawState{}
	mi := &file_tfplugin5_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RawState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RawState) ProtoMessage() {}

func (x *RawState) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RawState.ProtoReflect.Descriptor instead.
func (*RawState) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{5}
}

func (x *RawState) GetJson() []byte {
	if x != nil {
		return x.Json
	}
	return nil
}

func (x *RawState) GetFlatmap() map[string]string {
	if x != nil {
		return x.Flatmap
	}
	return nil
}

// ResourceIdentitySchema represents the structure and types of data used to identify
// a managed resource type. Effectively, resource identity is a versioned object
// that can be used to compare resources, whether already managed and/or being
// discovered.
type ResourceIdentitySchema struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// version is the identity version and separate from the Schema version.
	// Any time the structure or format of identity_attributes changes, this version
	// should be incremented. Versioning implicitly starts at 0 and by convention
	// should be incremented by 1 each change.
	//
	// When comparing identity_attributes data, differing versions should always be treated
	// as inequal.
	Version int64 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// identity_attributes are the individual value definitions which define identity data
	// for a managed resource type. This information is used to decode DynamicValue of
	// identity data.
	//
	// These attributes are intended for permanent identity data and must be wholly
	// representative of all data necessary to compare two managed resource instances
	// with no other data. This generally should include account, endpoint, location,
	// and automatically generated identifiers. For some resources, this may include
	// configuration-based data, such as a required name which must be unique.
	IdentityAttributes []*ResourceIdentitySchema_IdentityAttribute `protobuf:"bytes,2,rep,name=identity_attributes,json=identityAttributes,proto3" json:"identity_attributes,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ResourceIdentitySchema) Reset() {
	*x = ResourceIdentitySchema{}
	mi := &file_tfplugin5_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceIdentitySchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceIdentitySchema) ProtoMessage() {}

func (x *ResourceIdentitySchema) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceIdentitySchema.ProtoReflect.Descriptor instead.
func (*ResourceIdentitySchema) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{6}
}

func (x *ResourceIdentitySchema) GetVersion() int64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *ResourceIdentitySchema) GetIdentityAttributes() []*ResourceIdentitySchema_IdentityAttribute {
	if x != nil {
		return x.IdentityAttributes
	}
	return nil
}

type ResourceIdentityData struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// identity_data is the resource identity data for the given definition. It should
	// be decoded using the identity schema.
	//
	// This data is considered permanent for the identity version and suitable for
	// longer-term storage.
	IdentityData  *DynamicValue `protobuf:"bytes,1,opt,name=identity_data,json=identityData,proto3" json:"identity_data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourceIdentityData) Reset() {
	*x = ResourceIdentityData{}
	mi := &file_tfplugin5_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceIdentityData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceIdentityData) ProtoMessage() {}

func (x *ResourceIdentityData) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceIdentityData.ProtoReflect.Descriptor instead.
func (*ResourceIdentityData) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{7}
}

func (x *ResourceIdentityData) GetIdentityData() *DynamicValue {
	if x != nil {
		return x.IdentityData
	}
	return nil
}

// ActionSchema defines the schema for an action that can be invoked by Terraform.
type ActionSchema struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Schema        *Schema                `protobuf:"bytes,1,opt,name=schema,proto3" json:"schema,omitempty"` // of the action itself
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ActionSchema) Reset() {
	*x = ActionSchema{}
	mi := &file_tfplugin5_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ActionSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionSchema) ProtoMessage() {}

func (x *ActionSchema) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionSchema.ProtoReflect.Descriptor instead.
func (*ActionSchema) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{8}
}

func (x *ActionSchema) GetSchema() *Schema {
	if x != nil {
		return x.Schema
	}
	return nil
}

// Schema is the configuration schema for a Resource, Provider, or Provisioner.
type Schema struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The version of the schema.
	// Schemas are versioned, so that providers can upgrade a saved resource
	// state when the schema is changed.
	Version int64 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// Block is the top level configuration block for this schema.
	Block         *Schema_Block `protobuf:"bytes,2,opt,name=block,proto3" json:"block,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Schema) Reset() {
	*x = Schema{}
	mi := &file_tfplugin5_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Schema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema) ProtoMessage() {}

func (x *Schema) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema.ProtoReflect.Descriptor instead.
func (*Schema) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{9}
}

func (x *Schema) GetVersion() int64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *Schema) GetBlock() *Schema_Block {
	if x != nil {
		return x.Block
	}
	return nil
}

type Function struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// parameters is the ordered list of positional function parameters.
	Parameters []*Function_Parameter `protobuf:"bytes,1,rep,name=parameters,proto3" json:"parameters,omitempty"`
	// variadic_parameter is an optional final parameter which accepts
	// zero or more argument values, in which Terraform will send an
	// ordered list of the parameter type.
	VariadicParameter *Function_Parameter `protobuf:"bytes,2,opt,name=variadic_parameter,json=variadicParameter,proto3" json:"variadic_parameter,omitempty"`
	// Return is the function return parameter.
	Return *Function_Return `protobuf:"bytes,3,opt,name=return,proto3" json:"return,omitempty"`
	// summary is the human-readable shortened documentation for the function.
	Summary string `protobuf:"bytes,4,opt,name=summary,proto3" json:"summary,omitempty"`
	// description is human-readable documentation for the function.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// description_kind is the formatting of the description.
	DescriptionKind StringKind `protobuf:"varint,6,opt,name=description_kind,json=descriptionKind,proto3,enum=tfplugin5.StringKind" json:"description_kind,omitempty"`
	// deprecation_message is human-readable documentation if the
	// function is deprecated.
	DeprecationMessage string `protobuf:"bytes,7,opt,name=deprecation_message,json=deprecationMessage,proto3" json:"deprecation_message,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *Function) Reset() {
	*x = Function{}
	mi := &file_tfplugin5_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Function) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Function) ProtoMessage() {}

func (x *Function) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Function.ProtoReflect.Descriptor instead.
func (*Function) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{10}
}

func (x *Function) GetParameters() []*Function_Parameter {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *Function) GetVariadicParameter() *Function_Parameter {
	if x != nil {
		return x.VariadicParameter
	}
	return nil
}

func (x *Function) GetReturn() *Function_Return {
	if x != nil {
		return x.Return
	}
	return nil
}

func (x *Function) GetSummary() string {
	if x != nil {
		return x.Summary
	}
	return ""
}

func (x *Function) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Function) GetDescriptionKind() StringKind {
	if x != nil {
		return x.DescriptionKind
	}
	return StringKind_PLAIN
}

func (x *Function) GetDeprecationMessage() string {
	if x != nil {
		return x.DeprecationMessage
	}
	return ""
}

// ServerCapabilities allows providers to communicate extra information
// regarding supported protocol features. This is used to indicate
// availability of certain forward-compatible changes which may be optional
// in a major protocol version, but cannot be tested for directly.
type ServerCapabilities struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The plan_destroy capability signals that a provider expects a call
	// to PlanResourceChange when a resource is going to be destroyed.
	PlanDestroy bool `protobuf:"varint,1,opt,name=plan_destroy,json=planDestroy,proto3" json:"plan_destroy,omitempty"`
	// The get_provider_schema_optional capability indicates that this
	// provider does not require calling GetProviderSchema to operate
	// normally, and the caller can used a cached copy of the provider's
	// schema.
	GetProviderSchemaOptional bool `protobuf:"varint,2,opt,name=get_provider_schema_optional,json=getProviderSchemaOptional,proto3" json:"get_provider_schema_optional,omitempty"`
	// The move_resource_state capability signals that a provider supports the
	// MoveResourceState RPC.
	MoveResourceState bool `protobuf:"varint,3,opt,name=move_resource_state,json=moveResourceState,proto3" json:"move_resource_state,omitempty"`
	// The generate_resource_config capability signals that a provider supports
	// GenerateResourceConfig.
	GenerateResourceConfig bool `protobuf:"varint,4,opt,name=generate_resource_config,json=generateResourceConfig,proto3" json:"generate_resource_config,omitempty"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *ServerCapabilities) Reset() {
	*x = ServerCapabilities{}
	mi := &file_tfplugin5_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServerCapabilities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerCapabilities) ProtoMessage() {}

func (x *ServerCapabilities) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerCapabilities.ProtoReflect.Descriptor instead.
func (*ServerCapabilities) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{11}
}

func (x *ServerCapabilities) GetPlanDestroy() bool {
	if x != nil {
		return x.PlanDestroy
	}
	return false
}

func (x *ServerCapabilities) GetGetProviderSchemaOptional() bool {
	if x != nil {
		return x.GetProviderSchemaOptional
	}
	return false
}

func (x *ServerCapabilities) GetMoveResourceState() bool {
	if x != nil {
		return x.MoveResourceState
	}
	return false
}

func (x *ServerCapabilities) GetGenerateResourceConfig() bool {
	if x != nil {
		return x.GenerateResourceConfig
	}
	return false
}

// ClientCapabilities allows Terraform to publish information regarding
// supported protocol features. This is used to indicate availability of
// certain forward-compatible changes which may be optional in a major
// protocol version, but cannot be tested for directly.
type ClientCapabilities struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The deferral_allowed capability signals that the client is able to
	// handle deferred responses from the provider.
	DeferralAllowed bool `protobuf:"varint,1,opt,name=deferral_allowed,json=deferralAllowed,proto3" json:"deferral_allowed,omitempty"`
	// The write_only_attributes_allowed capability signals that the client
	// is able to handle write_only attributes for managed resources.
	WriteOnlyAttributesAllowed bool `protobuf:"varint,2,opt,name=write_only_attributes_allowed,json=writeOnlyAttributesAllowed,proto3" json:"write_only_attributes_allowed,omitempty"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *ClientCapabilities) Reset() {
	*x = ClientCapabilities{}
	mi := &file_tfplugin5_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ClientCapabilities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClientCapabilities) ProtoMessage() {}

func (x *ClientCapabilities) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClientCapabilities.ProtoReflect.Descriptor instead.
func (*ClientCapabilities) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{12}
}

func (x *ClientCapabilities) GetDeferralAllowed() bool {
	if x != nil {
		return x.DeferralAllowed
	}
	return false
}

func (x *ClientCapabilities) GetWriteOnlyAttributesAllowed() bool {
	if x != nil {
		return x.WriteOnlyAttributesAllowed
	}
	return false
}

// Deferred is a message that indicates that change is deferred for a reason.
type Deferred struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// reason is the reason for deferring the change.
	Reason        Deferred_Reason `protobuf:"varint,1,opt,name=reason,proto3,enum=tfplugin5.Deferred_Reason" json:"reason,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Deferred) Reset() {
	*x = Deferred{}
	mi := &file_tfplugin5_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Deferred) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Deferred) ProtoMessage() {}

func (x *Deferred) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Deferred.ProtoReflect.Descriptor instead.
func (*Deferred) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{13}
}

func (x *Deferred) GetReason() Deferred_Reason {
	if x != nil {
		return x.Reason
	}
	return Deferred_UNKNOWN
}

type GetMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMetadata) Reset() {
	*x = GetMetadata{}
	mi := &file_tfplugin5_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata) ProtoMessage() {}

func (x *GetMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata.ProtoReflect.Descriptor instead.
func (*GetMetadata) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{14}
}

type GetProviderSchema struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetProviderSchema) Reset() {
	*x = GetProviderSchema{}
	mi := &file_tfplugin5_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetProviderSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProviderSchema) ProtoMessage() {}

func (x *GetProviderSchema) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProviderSchema.ProtoReflect.Descriptor instead.
func (*GetProviderSchema) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{15}
}

type PrepareProviderConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PrepareProviderConfig) Reset() {
	*x = PrepareProviderConfig{}
	mi := &file_tfplugin5_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrepareProviderConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrepareProviderConfig) ProtoMessage() {}

func (x *PrepareProviderConfig) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrepareProviderConfig.ProtoReflect.Descriptor instead.
func (*PrepareProviderConfig) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{16}
}

type UpgradeResourceState struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpgradeResourceState) Reset() {
	*x = UpgradeResourceState{}
	mi := &file_tfplugin5_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpgradeResourceState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeResourceState) ProtoMessage() {}

func (x *UpgradeResourceState) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeResourceState.ProtoReflect.Descriptor instead.
func (*UpgradeResourceState) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{17}
}

type GetResourceIdentitySchemas struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetResourceIdentitySchemas) Reset() {
	*x = GetResourceIdentitySchemas{}
	mi := &file_tfplugin5_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetResourceIdentitySchemas) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetResourceIdentitySchemas) ProtoMessage() {}

func (x *GetResourceIdentitySchemas) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetResourceIdentitySchemas.ProtoReflect.Descriptor instead.
func (*GetResourceIdentitySchemas) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{18}
}

type UpgradeResourceIdentity struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpgradeResourceIdentity) Reset() {
	*x = UpgradeResourceIdentity{}
	mi := &file_tfplugin5_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpgradeResourceIdentity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeResourceIdentity) ProtoMessage() {}

func (x *UpgradeResourceIdentity) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeResourceIdentity.ProtoReflect.Descriptor instead.
func (*UpgradeResourceIdentity) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{19}
}

type ValidateResourceTypeConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateResourceTypeConfig) Reset() {
	*x = ValidateResourceTypeConfig{}
	mi := &file_tfplugin5_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateResourceTypeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateResourceTypeConfig) ProtoMessage() {}

func (x *ValidateResourceTypeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateResourceTypeConfig.ProtoReflect.Descriptor instead.
func (*ValidateResourceTypeConfig) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{20}
}

type ValidateDataSourceConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateDataSourceConfig) Reset() {
	*x = ValidateDataSourceConfig{}
	mi := &file_tfplugin5_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateDataSourceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateDataSourceConfig) ProtoMessage() {}

func (x *ValidateDataSourceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateDataSourceConfig.ProtoReflect.Descriptor instead.
func (*ValidateDataSourceConfig) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{21}
}

type ValidateEphemeralResourceConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateEphemeralResourceConfig) Reset() {
	*x = ValidateEphemeralResourceConfig{}
	mi := &file_tfplugin5_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateEphemeralResourceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateEphemeralResourceConfig) ProtoMessage() {}

func (x *ValidateEphemeralResourceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateEphemeralResourceConfig.ProtoReflect.Descriptor instead.
func (*ValidateEphemeralResourceConfig) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{22}
}

type Configure struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Configure) Reset() {
	*x = Configure{}
	mi := &file_tfplugin5_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Configure) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Configure) ProtoMessage() {}

func (x *Configure) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Configure.ProtoReflect.Descriptor instead.
func (*Configure) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{23}
}

type ReadResource struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReadResource) Reset() {
	*x = ReadResource{}
	mi := &file_tfplugin5_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadResource) ProtoMessage() {}

func (x *ReadResource) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadResource.ProtoReflect.Descriptor instead.
func (*ReadResource) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{24}
}

type PlanResourceChange struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PlanResourceChange) Reset() {
	*x = PlanResourceChange{}
	mi := &file_tfplugin5_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanResourceChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanResourceChange) ProtoMessage() {}

func (x *PlanResourceChange) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanResourceChange.ProtoReflect.Descriptor instead.
func (*PlanResourceChange) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{25}
}

type ApplyResourceChange struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ApplyResourceChange) Reset() {
	*x = ApplyResourceChange{}
	mi := &file_tfplugin5_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApplyResourceChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyResourceChange) ProtoMessage() {}

func (x *ApplyResourceChange) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyResourceChange.ProtoReflect.Descriptor instead.
func (*ApplyResourceChange) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{26}
}

type ImportResourceState struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ImportResourceState) Reset() {
	*x = ImportResourceState{}
	mi := &file_tfplugin5_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportResourceState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportResourceState) ProtoMessage() {}

func (x *ImportResourceState) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportResourceState.ProtoReflect.Descriptor instead.
func (*ImportResourceState) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{27}
}

type GenerateResourceConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GenerateResourceConfig) Reset() {
	*x = GenerateResourceConfig{}
	mi := &file_tfplugin5_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateResourceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateResourceConfig) ProtoMessage() {}

func (x *GenerateResourceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateResourceConfig.ProtoReflect.Descriptor instead.
func (*GenerateResourceConfig) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{28}
}

type MoveResourceState struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *MoveResourceState) Reset() {
	*x = MoveResourceState{}
	mi := &file_tfplugin5_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MoveResourceState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveResourceState) ProtoMessage() {}

func (x *MoveResourceState) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveResourceState.ProtoReflect.Descriptor instead.
func (*MoveResourceState) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{29}
}

type ReadDataSource struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReadDataSource) Reset() {
	*x = ReadDataSource{}
	mi := &file_tfplugin5_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadDataSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadDataSource) ProtoMessage() {}

func (x *ReadDataSource) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadDataSource.ProtoReflect.Descriptor instead.
func (*ReadDataSource) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{30}
}

type GetProvisionerSchema struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetProvisionerSchema) Reset() {
	*x = GetProvisionerSchema{}
	mi := &file_tfplugin5_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetProvisionerSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProvisionerSchema) ProtoMessage() {}

func (x *GetProvisionerSchema) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProvisionerSchema.ProtoReflect.Descriptor instead.
func (*GetProvisionerSchema) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{31}
}

type ValidateProvisionerConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateProvisionerConfig) Reset() {
	*x = ValidateProvisionerConfig{}
	mi := &file_tfplugin5_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateProvisionerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateProvisionerConfig) ProtoMessage() {}

func (x *ValidateProvisionerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateProvisionerConfig.ProtoReflect.Descriptor instead.
func (*ValidateProvisionerConfig) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{32}
}

type ProvisionResource struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProvisionResource) Reset() {
	*x = ProvisionResource{}
	mi := &file_tfplugin5_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProvisionResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProvisionResource) ProtoMessage() {}

func (x *ProvisionResource) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProvisionResource.ProtoReflect.Descriptor instead.
func (*ProvisionResource) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{33}
}

type OpenEphemeralResource struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OpenEphemeralResource) Reset() {
	*x = OpenEphemeralResource{}
	mi := &file_tfplugin5_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenEphemeralResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenEphemeralResource) ProtoMessage() {}

func (x *OpenEphemeralResource) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenEphemeralResource.ProtoReflect.Descriptor instead.
func (*OpenEphemeralResource) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{34}
}

type RenewEphemeralResource struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RenewEphemeralResource) Reset() {
	*x = RenewEphemeralResource{}
	mi := &file_tfplugin5_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RenewEphemeralResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenewEphemeralResource) ProtoMessage() {}

func (x *RenewEphemeralResource) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenewEphemeralResource.ProtoReflect.Descriptor instead.
func (*RenewEphemeralResource) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{35}
}

type CloseEphemeralResource struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CloseEphemeralResource) Reset() {
	*x = CloseEphemeralResource{}
	mi := &file_tfplugin5_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseEphemeralResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseEphemeralResource) ProtoMessage() {}

func (x *CloseEphemeralResource) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseEphemeralResource.ProtoReflect.Descriptor instead.
func (*CloseEphemeralResource) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{36}
}

type GetFunctions struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetFunctions) Reset() {
	*x = GetFunctions{}
	mi := &file_tfplugin5_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFunctions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFunctions) ProtoMessage() {}

func (x *GetFunctions) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFunctions.ProtoReflect.Descriptor instead.
func (*GetFunctions) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{37}
}

type CallFunction struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CallFunction) Reset() {
	*x = CallFunction{}
	mi := &file_tfplugin5_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CallFunction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CallFunction) ProtoMessage() {}

func (x *CallFunction) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CallFunction.ProtoReflect.Descriptor instead.
func (*CallFunction) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{38}
}

type ListResource struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListResource) Reset() {
	*x = ListResource{}
	mi := &file_tfplugin5_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListResource) ProtoMessage() {}

func (x *ListResource) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListResource.ProtoReflect.Descriptor instead.
func (*ListResource) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{39}
}

type ValidateListResourceConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateListResourceConfig) Reset() {
	*x = ValidateListResourceConfig{}
	mi := &file_tfplugin5_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateListResourceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateListResourceConfig) ProtoMessage() {}

func (x *ValidateListResourceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateListResourceConfig.ProtoReflect.Descriptor instead.
func (*ValidateListResourceConfig) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{40}
}

type PlanAction struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PlanAction) Reset() {
	*x = PlanAction{}
	mi := &file_tfplugin5_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanAction) ProtoMessage() {}

func (x *PlanAction) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanAction.ProtoReflect.Descriptor instead.
func (*PlanAction) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{41}
}

type InvokeAction struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InvokeAction) Reset() {
	*x = InvokeAction{}
	mi := &file_tfplugin5_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InvokeAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InvokeAction) ProtoMessage() {}

func (x *InvokeAction) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InvokeAction.ProtoReflect.Descriptor instead.
func (*InvokeAction) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{42}
}

type ValidateActionConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateActionConfig) Reset() {
	*x = ValidateActionConfig{}
	mi := &file_tfplugin5_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateActionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateActionConfig) ProtoMessage() {}

func (x *ValidateActionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateActionConfig.ProtoReflect.Descriptor instead.
func (*ValidateActionConfig) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{43}
}

type AttributePath_Step struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Selector:
	//
	//	*AttributePath_Step_AttributeName
	//	*AttributePath_Step_ElementKeyString
	//	*AttributePath_Step_ElementKeyInt
	Selector      isAttributePath_Step_Selector `protobuf_oneof:"selector"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AttributePath_Step) Reset() {
	*x = AttributePath_Step{}
	mi := &file_tfplugin5_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AttributePath_Step) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributePath_Step) ProtoMessage() {}

func (x *AttributePath_Step) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributePath_Step.ProtoReflect.Descriptor instead.
func (*AttributePath_Step) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{3, 0}
}

func (x *AttributePath_Step) GetSelector() isAttributePath_Step_Selector {
	if x != nil {
		return x.Selector
	}
	return nil
}

func (x *AttributePath_Step) GetAttributeName() string {
	if x != nil {
		if x, ok := x.Selector.(*AttributePath_Step_AttributeName); ok {
			return x.AttributeName
		}
	}
	return ""
}

func (x *AttributePath_Step) GetElementKeyString() string {
	if x != nil {
		if x, ok := x.Selector.(*AttributePath_Step_ElementKeyString); ok {
			return x.ElementKeyString
		}
	}
	return ""
}

func (x *AttributePath_Step) GetElementKeyInt() int64 {
	if x != nil {
		if x, ok := x.Selector.(*AttributePath_Step_ElementKeyInt); ok {
			return x.ElementKeyInt
		}
	}
	return 0
}

type isAttributePath_Step_Selector interface {
	isAttributePath_Step_Selector()
}

type AttributePath_Step_AttributeName struct {
	// Set "attribute_name" to represent looking up an attribute
	// in the current object value.
	AttributeName string `protobuf:"bytes,1,opt,name=attribute_name,json=attributeName,proto3,oneof"`
}

type AttributePath_Step_ElementKeyString struct {
	// Set "element_key_*" to represent looking up an element in
	// an indexable collection type.
	ElementKeyString string `protobuf:"bytes,2,opt,name=element_key_string,json=elementKeyString,proto3,oneof"`
}

type AttributePath_Step_ElementKeyInt struct {
	ElementKeyInt int64 `protobuf:"varint,3,opt,name=element_key_int,json=elementKeyInt,proto3,oneof"`
}

func (*AttributePath_Step_AttributeName) isAttributePath_Step_Selector() {}

func (*AttributePath_Step_ElementKeyString) isAttributePath_Step_Selector() {}

func (*AttributePath_Step_ElementKeyInt) isAttributePath_Step_Selector() {}

type Stop_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Stop_Request) Reset() {
	*x = Stop_Request{}
	mi := &file_tfplugin5_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Stop_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Stop_Request) ProtoMessage() {}

func (x *Stop_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Stop_Request.ProtoReflect.Descriptor instead.
func (*Stop_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{4, 0}
}

type Stop_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Error         string                 `protobuf:"bytes,1,opt,name=Error,proto3" json:"Error,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Stop_Response) Reset() {
	*x = Stop_Response{}
	mi := &file_tfplugin5_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Stop_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Stop_Response) ProtoMessage() {}

func (x *Stop_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Stop_Response.ProtoReflect.Descriptor instead.
func (*Stop_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{4, 1}
}

func (x *Stop_Response) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

// IdentityAttribute represents one value of data within resource identity. These
// are always used in resource identity comparisons.
type ResourceIdentitySchema_IdentityAttribute struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// name is the identity attribute name
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// type is the identity attribute type
	Type []byte `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// required_for_import when enabled signifies that this attribute must be
	// defined for ImportResourceState to complete successfully
	RequiredForImport bool `protobuf:"varint,3,opt,name=required_for_import,json=requiredForImport,proto3" json:"required_for_import,omitempty"`
	// optional_for_import when enabled signifies that this attribute is not
	// required for ImportResourceState, because it can be supplied by the
	// provider. It is still possible to supply this attribute during import.
	OptionalForImport bool `protobuf:"varint,4,opt,name=optional_for_import,json=optionalForImport,proto3" json:"optional_for_import,omitempty"`
	// description is a human-readable description of the attribute in Markdown
	Description   string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResourceIdentitySchema_IdentityAttribute) Reset() {
	*x = ResourceIdentitySchema_IdentityAttribute{}
	mi := &file_tfplugin5_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResourceIdentitySchema_IdentityAttribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceIdentitySchema_IdentityAttribute) ProtoMessage() {}

func (x *ResourceIdentitySchema_IdentityAttribute) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceIdentitySchema_IdentityAttribute.ProtoReflect.Descriptor instead.
func (*ResourceIdentitySchema_IdentityAttribute) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{6, 0}
}

func (x *ResourceIdentitySchema_IdentityAttribute) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ResourceIdentitySchema_IdentityAttribute) GetType() []byte {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *ResourceIdentitySchema_IdentityAttribute) GetRequiredForImport() bool {
	if x != nil {
		return x.RequiredForImport
	}
	return false
}

func (x *ResourceIdentitySchema_IdentityAttribute) GetOptionalForImport() bool {
	if x != nil {
		return x.OptionalForImport
	}
	return false
}

func (x *ResourceIdentitySchema_IdentityAttribute) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

type Schema_Block struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	Version         int64                  `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	Attributes      []*Schema_Attribute    `protobuf:"bytes,2,rep,name=attributes,proto3" json:"attributes,omitempty"`
	BlockTypes      []*Schema_NestedBlock  `protobuf:"bytes,3,rep,name=block_types,json=blockTypes,proto3" json:"block_types,omitempty"`
	Description     string                 `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	DescriptionKind StringKind             `protobuf:"varint,5,opt,name=description_kind,json=descriptionKind,proto3,enum=tfplugin5.StringKind" json:"description_kind,omitempty"`
	Deprecated      bool                   `protobuf:"varint,6,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Schema_Block) Reset() {
	*x = Schema_Block{}
	mi := &file_tfplugin5_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Schema_Block) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema_Block) ProtoMessage() {}

func (x *Schema_Block) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema_Block.ProtoReflect.Descriptor instead.
func (*Schema_Block) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{9, 0}
}

func (x *Schema_Block) GetVersion() int64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *Schema_Block) GetAttributes() []*Schema_Attribute {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *Schema_Block) GetBlockTypes() []*Schema_NestedBlock {
	if x != nil {
		return x.BlockTypes
	}
	return nil
}

func (x *Schema_Block) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Schema_Block) GetDescriptionKind() StringKind {
	if x != nil {
		return x.DescriptionKind
	}
	return StringKind_PLAIN
}

func (x *Schema_Block) GetDeprecated() bool {
	if x != nil {
		return x.Deprecated
	}
	return false
}

type Schema_Attribute struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	Name            string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Type            []byte                 `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	Description     string                 `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	Required        bool                   `protobuf:"varint,4,opt,name=required,proto3" json:"required,omitempty"`
	Optional        bool                   `protobuf:"varint,5,opt,name=optional,proto3" json:"optional,omitempty"`
	Computed        bool                   `protobuf:"varint,6,opt,name=computed,proto3" json:"computed,omitempty"`
	Sensitive       bool                   `protobuf:"varint,7,opt,name=sensitive,proto3" json:"sensitive,omitempty"`
	DescriptionKind StringKind             `protobuf:"varint,8,opt,name=description_kind,json=descriptionKind,proto3,enum=tfplugin5.StringKind" json:"description_kind,omitempty"`
	Deprecated      bool                   `protobuf:"varint,9,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
	WriteOnly       bool                   `protobuf:"varint,10,opt,name=write_only,json=writeOnly,proto3" json:"write_only,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Schema_Attribute) Reset() {
	*x = Schema_Attribute{}
	mi := &file_tfplugin5_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Schema_Attribute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema_Attribute) ProtoMessage() {}

func (x *Schema_Attribute) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema_Attribute.ProtoReflect.Descriptor instead.
func (*Schema_Attribute) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{9, 1}
}

func (x *Schema_Attribute) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Schema_Attribute) GetType() []byte {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *Schema_Attribute) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Schema_Attribute) GetRequired() bool {
	if x != nil {
		return x.Required
	}
	return false
}

func (x *Schema_Attribute) GetOptional() bool {
	if x != nil {
		return x.Optional
	}
	return false
}

func (x *Schema_Attribute) GetComputed() bool {
	if x != nil {
		return x.Computed
	}
	return false
}

func (x *Schema_Attribute) GetSensitive() bool {
	if x != nil {
		return x.Sensitive
	}
	return false
}

func (x *Schema_Attribute) GetDescriptionKind() StringKind {
	if x != nil {
		return x.DescriptionKind
	}
	return StringKind_PLAIN
}

func (x *Schema_Attribute) GetDeprecated() bool {
	if x != nil {
		return x.Deprecated
	}
	return false
}

func (x *Schema_Attribute) GetWriteOnly() bool {
	if x != nil {
		return x.WriteOnly
	}
	return false
}

type Schema_NestedBlock struct {
	state         protoimpl.MessageState         `protogen:"open.v1"`
	TypeName      string                         `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Block         *Schema_Block                  `protobuf:"bytes,2,opt,name=block,proto3" json:"block,omitempty"`
	Nesting       Schema_NestedBlock_NestingMode `protobuf:"varint,3,opt,name=nesting,proto3,enum=tfplugin5.Schema_NestedBlock_NestingMode" json:"nesting,omitempty"`
	MinItems      int64                          `protobuf:"varint,4,opt,name=min_items,json=minItems,proto3" json:"min_items,omitempty"`
	MaxItems      int64                          `protobuf:"varint,5,opt,name=max_items,json=maxItems,proto3" json:"max_items,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Schema_NestedBlock) Reset() {
	*x = Schema_NestedBlock{}
	mi := &file_tfplugin5_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Schema_NestedBlock) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Schema_NestedBlock) ProtoMessage() {}

func (x *Schema_NestedBlock) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Schema_NestedBlock.ProtoReflect.Descriptor instead.
func (*Schema_NestedBlock) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{9, 2}
}

func (x *Schema_NestedBlock) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *Schema_NestedBlock) GetBlock() *Schema_Block {
	if x != nil {
		return x.Block
	}
	return nil
}

func (x *Schema_NestedBlock) GetNesting() Schema_NestedBlock_NestingMode {
	if x != nil {
		return x.Nesting
	}
	return Schema_NestedBlock_INVALID
}

func (x *Schema_NestedBlock) GetMinItems() int64 {
	if x != nil {
		return x.MinItems
	}
	return 0
}

func (x *Schema_NestedBlock) GetMaxItems() int64 {
	if x != nil {
		return x.MaxItems
	}
	return 0
}

type Function_Parameter struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// name is the human-readable display name for the parameter.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// type is the type constraint for the parameter.
	Type []byte `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// allow_null_value when enabled denotes that a null argument value can
	// be passed to the provider. When disabled, Terraform returns an error
	// if the argument value is null.
	AllowNullValue bool `protobuf:"varint,3,opt,name=allow_null_value,json=allowNullValue,proto3" json:"allow_null_value,omitempty"`
	// allow_unknown_values when enabled denotes that only wholly known
	// argument values will be passed to the provider. When disabled,
	// Terraform skips the function call entirely and assumes an unknown
	// value result from the function.
	AllowUnknownValues bool `protobuf:"varint,4,opt,name=allow_unknown_values,json=allowUnknownValues,proto3" json:"allow_unknown_values,omitempty"`
	// description is human-readable documentation for the parameter.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// description_kind is the formatting of the description.
	DescriptionKind StringKind `protobuf:"varint,6,opt,name=description_kind,json=descriptionKind,proto3,enum=tfplugin5.StringKind" json:"description_kind,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Function_Parameter) Reset() {
	*x = Function_Parameter{}
	mi := &file_tfplugin5_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Function_Parameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Function_Parameter) ProtoMessage() {}

func (x *Function_Parameter) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Function_Parameter.ProtoReflect.Descriptor instead.
func (*Function_Parameter) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{10, 0}
}

func (x *Function_Parameter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Function_Parameter) GetType() []byte {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *Function_Parameter) GetAllowNullValue() bool {
	if x != nil {
		return x.AllowNullValue
	}
	return false
}

func (x *Function_Parameter) GetAllowUnknownValues() bool {
	if x != nil {
		return x.AllowUnknownValues
	}
	return false
}

func (x *Function_Parameter) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Function_Parameter) GetDescriptionKind() StringKind {
	if x != nil {
		return x.DescriptionKind
	}
	return StringKind_PLAIN
}

type Function_Return struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// type is the type constraint for the function result.
	Type          []byte `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Function_Return) Reset() {
	*x = Function_Return{}
	mi := &file_tfplugin5_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Function_Return) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Function_Return) ProtoMessage() {}

func (x *Function_Return) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Function_Return.ProtoReflect.Descriptor instead.
func (*Function_Return) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{10, 1}
}

func (x *Function_Return) GetType() []byte {
	if x != nil {
		return x.Type
	}
	return nil
}

type GetMetadata_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMetadata_Request) Reset() {
	*x = GetMetadata_Request{}
	mi := &file_tfplugin5_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata_Request) ProtoMessage() {}

func (x *GetMetadata_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata_Request.ProtoReflect.Descriptor instead.
func (*GetMetadata_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{14, 0}
}

type GetMetadata_Response struct {
	state              protoimpl.MessageState            `protogen:"open.v1"`
	ServerCapabilities *ServerCapabilities               `protobuf:"bytes,1,opt,name=server_capabilities,json=serverCapabilities,proto3" json:"server_capabilities,omitempty"`
	Diagnostics        []*Diagnostic                     `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	DataSources        []*GetMetadata_DataSourceMetadata `protobuf:"bytes,3,rep,name=data_sources,json=dataSources,proto3" json:"data_sources,omitempty"`
	Resources          []*GetMetadata_ResourceMetadata   `protobuf:"bytes,4,rep,name=resources,proto3" json:"resources,omitempty"`
	// functions returns metadata for any functions.
	Functions          []*GetMetadata_FunctionMetadata     `protobuf:"bytes,5,rep,name=functions,proto3" json:"functions,omitempty"`
	EphemeralResources []*GetMetadata_EphemeralMetadata    `protobuf:"bytes,6,rep,name=ephemeral_resources,json=ephemeralResources,proto3" json:"ephemeral_resources,omitempty"`
	ListResources      []*GetMetadata_ListResourceMetadata `protobuf:"bytes,7,rep,name=list_resources,json=listResources,proto3" json:"list_resources,omitempty"`
	Actions            []*GetMetadata_ActionMetadata       `protobuf:"bytes,8,rep,name=actions,proto3" json:"actions,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *GetMetadata_Response) Reset() {
	*x = GetMetadata_Response{}
	mi := &file_tfplugin5_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata_Response) ProtoMessage() {}

func (x *GetMetadata_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata_Response.ProtoReflect.Descriptor instead.
func (*GetMetadata_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{14, 1}
}

func (x *GetMetadata_Response) GetServerCapabilities() *ServerCapabilities {
	if x != nil {
		return x.ServerCapabilities
	}
	return nil
}

func (x *GetMetadata_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *GetMetadata_Response) GetDataSources() []*GetMetadata_DataSourceMetadata {
	if x != nil {
		return x.DataSources
	}
	return nil
}

func (x *GetMetadata_Response) GetResources() []*GetMetadata_ResourceMetadata {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *GetMetadata_Response) GetFunctions() []*GetMetadata_FunctionMetadata {
	if x != nil {
		return x.Functions
	}
	return nil
}

func (x *GetMetadata_Response) GetEphemeralResources() []*GetMetadata_EphemeralMetadata {
	if x != nil {
		return x.EphemeralResources
	}
	return nil
}

func (x *GetMetadata_Response) GetListResources() []*GetMetadata_ListResourceMetadata {
	if x != nil {
		return x.ListResources
	}
	return nil
}

func (x *GetMetadata_Response) GetActions() []*GetMetadata_ActionMetadata {
	if x != nil {
		return x.Actions
	}
	return nil
}

type GetMetadata_EphemeralMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMetadata_EphemeralMetadata) Reset() {
	*x = GetMetadata_EphemeralMetadata{}
	mi := &file_tfplugin5_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata_EphemeralMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata_EphemeralMetadata) ProtoMessage() {}

func (x *GetMetadata_EphemeralMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata_EphemeralMetadata.ProtoReflect.Descriptor instead.
func (*GetMetadata_EphemeralMetadata) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{14, 2}
}

func (x *GetMetadata_EphemeralMetadata) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

type GetMetadata_FunctionMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// name is the function name.
	Name          string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMetadata_FunctionMetadata) Reset() {
	*x = GetMetadata_FunctionMetadata{}
	mi := &file_tfplugin5_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata_FunctionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata_FunctionMetadata) ProtoMessage() {}

func (x *GetMetadata_FunctionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata_FunctionMetadata.ProtoReflect.Descriptor instead.
func (*GetMetadata_FunctionMetadata) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{14, 3}
}

func (x *GetMetadata_FunctionMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type GetMetadata_DataSourceMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMetadata_DataSourceMetadata) Reset() {
	*x = GetMetadata_DataSourceMetadata{}
	mi := &file_tfplugin5_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata_DataSourceMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata_DataSourceMetadata) ProtoMessage() {}

func (x *GetMetadata_DataSourceMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata_DataSourceMetadata.ProtoReflect.Descriptor instead.
func (*GetMetadata_DataSourceMetadata) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{14, 4}
}

func (x *GetMetadata_DataSourceMetadata) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

type GetMetadata_ResourceMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMetadata_ResourceMetadata) Reset() {
	*x = GetMetadata_ResourceMetadata{}
	mi := &file_tfplugin5_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata_ResourceMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata_ResourceMetadata) ProtoMessage() {}

func (x *GetMetadata_ResourceMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata_ResourceMetadata.ProtoReflect.Descriptor instead.
func (*GetMetadata_ResourceMetadata) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{14, 5}
}

func (x *GetMetadata_ResourceMetadata) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

type GetMetadata_ListResourceMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMetadata_ListResourceMetadata) Reset() {
	*x = GetMetadata_ListResourceMetadata{}
	mi := &file_tfplugin5_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata_ListResourceMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata_ListResourceMetadata) ProtoMessage() {}

func (x *GetMetadata_ListResourceMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata_ListResourceMetadata.ProtoReflect.Descriptor instead.
func (*GetMetadata_ListResourceMetadata) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{14, 6}
}

func (x *GetMetadata_ListResourceMetadata) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

type GetMetadata_ActionMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetMetadata_ActionMetadata) Reset() {
	*x = GetMetadata_ActionMetadata{}
	mi := &file_tfplugin5_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadata_ActionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadata_ActionMetadata) ProtoMessage() {}

func (x *GetMetadata_ActionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadata_ActionMetadata.ProtoReflect.Descriptor instead.
func (*GetMetadata_ActionMetadata) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{14, 7}
}

func (x *GetMetadata_ActionMetadata) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

type GetProviderSchema_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetProviderSchema_Request) Reset() {
	*x = GetProviderSchema_Request{}
	mi := &file_tfplugin5_proto_msgTypes[62]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetProviderSchema_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProviderSchema_Request) ProtoMessage() {}

func (x *GetProviderSchema_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[62]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProviderSchema_Request.ProtoReflect.Descriptor instead.
func (*GetProviderSchema_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{15, 0}
}

type GetProviderSchema_Response struct {
	state                    protoimpl.MessageState   `protogen:"open.v1"`
	Provider                 *Schema                  `protobuf:"bytes,1,opt,name=provider,proto3" json:"provider,omitempty"`
	ResourceSchemas          map[string]*Schema       `protobuf:"bytes,2,rep,name=resource_schemas,json=resourceSchemas,proto3" json:"resource_schemas,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	DataSourceSchemas        map[string]*Schema       `protobuf:"bytes,3,rep,name=data_source_schemas,json=dataSourceSchemas,proto3" json:"data_source_schemas,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Functions                map[string]*Function     `protobuf:"bytes,7,rep,name=functions,proto3" json:"functions,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	EphemeralResourceSchemas map[string]*Schema       `protobuf:"bytes,8,rep,name=ephemeral_resource_schemas,json=ephemeralResourceSchemas,proto3" json:"ephemeral_resource_schemas,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	ListResourceSchemas      map[string]*Schema       `protobuf:"bytes,9,rep,name=list_resource_schemas,json=listResourceSchemas,proto3" json:"list_resource_schemas,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	ActionSchemas            map[string]*ActionSchema `protobuf:"bytes,11,rep,name=action_schemas,json=actionSchemas,proto3" json:"action_schemas,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Diagnostics              []*Diagnostic            `protobuf:"bytes,4,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	ProviderMeta             *Schema                  `protobuf:"bytes,5,opt,name=provider_meta,json=providerMeta,proto3" json:"provider_meta,omitempty"`
	ServerCapabilities       *ServerCapabilities      `protobuf:"bytes,6,opt,name=server_capabilities,json=serverCapabilities,proto3" json:"server_capabilities,omitempty"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *GetProviderSchema_Response) Reset() {
	*x = GetProviderSchema_Response{}
	mi := &file_tfplugin5_proto_msgTypes[63]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetProviderSchema_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProviderSchema_Response) ProtoMessage() {}

func (x *GetProviderSchema_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[63]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProviderSchema_Response.ProtoReflect.Descriptor instead.
func (*GetProviderSchema_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{15, 1}
}

func (x *GetProviderSchema_Response) GetProvider() *Schema {
	if x != nil {
		return x.Provider
	}
	return nil
}

func (x *GetProviderSchema_Response) GetResourceSchemas() map[string]*Schema {
	if x != nil {
		return x.ResourceSchemas
	}
	return nil
}

func (x *GetProviderSchema_Response) GetDataSourceSchemas() map[string]*Schema {
	if x != nil {
		return x.DataSourceSchemas
	}
	return nil
}

func (x *GetProviderSchema_Response) GetFunctions() map[string]*Function {
	if x != nil {
		return x.Functions
	}
	return nil
}

func (x *GetProviderSchema_Response) GetEphemeralResourceSchemas() map[string]*Schema {
	if x != nil {
		return x.EphemeralResourceSchemas
	}
	return nil
}

func (x *GetProviderSchema_Response) GetListResourceSchemas() map[string]*Schema {
	if x != nil {
		return x.ListResourceSchemas
	}
	return nil
}

func (x *GetProviderSchema_Response) GetActionSchemas() map[string]*ActionSchema {
	if x != nil {
		return x.ActionSchemas
	}
	return nil
}

func (x *GetProviderSchema_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *GetProviderSchema_Response) GetProviderMeta() *Schema {
	if x != nil {
		return x.ProviderMeta
	}
	return nil
}

func (x *GetProviderSchema_Response) GetServerCapabilities() *ServerCapabilities {
	if x != nil {
		return x.ServerCapabilities
	}
	return nil
}

type PrepareProviderConfig_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Config        *DynamicValue          `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PrepareProviderConfig_Request) Reset() {
	*x = PrepareProviderConfig_Request{}
	mi := &file_tfplugin5_proto_msgTypes[70]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrepareProviderConfig_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrepareProviderConfig_Request) ProtoMessage() {}

func (x *PrepareProviderConfig_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[70]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrepareProviderConfig_Request.ProtoReflect.Descriptor instead.
func (*PrepareProviderConfig_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{16, 0}
}

func (x *PrepareProviderConfig_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

type PrepareProviderConfig_Response struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	PreparedConfig *DynamicValue          `protobuf:"bytes,1,opt,name=prepared_config,json=preparedConfig,proto3" json:"prepared_config,omitempty"`
	Diagnostics    []*Diagnostic          `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *PrepareProviderConfig_Response) Reset() {
	*x = PrepareProviderConfig_Response{}
	mi := &file_tfplugin5_proto_msgTypes[71]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrepareProviderConfig_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrepareProviderConfig_Response) ProtoMessage() {}

func (x *PrepareProviderConfig_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[71]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrepareProviderConfig_Response.ProtoReflect.Descriptor instead.
func (*PrepareProviderConfig_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{16, 1}
}

func (x *PrepareProviderConfig_Response) GetPreparedConfig() *DynamicValue {
	if x != nil {
		return x.PreparedConfig
	}
	return nil
}

func (x *PrepareProviderConfig_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

// Request is the message that is sent to the provider during the
// UpgradeResourceState RPC.
//
// This message intentionally does not include configuration data as any
// configuration-based or configuration-conditional changes should occur
// during the PlanResourceChange RPC. Additionally, the configuration is
// not guaranteed to exist (in the case of resource destruction), be wholly
// known, nor match the given prior state, which could lead to unexpected
// provider behaviors for practitioners.
type UpgradeResourceState_Request struct {
	state    protoimpl.MessageState `protogen:"open.v1"`
	TypeName string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	// version is the schema_version number recorded in the state file
	Version int64 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	// raw_state is the raw states as stored for the resource.  Core does
	// not have access to the schema of prior_version, so it's the
	// provider's responsibility to interpret this value using the
	// appropriate older schema. The raw_state will be the json encoded
	// state, or a legacy flat-mapped format.
	RawState      *RawState `protobuf:"bytes,3,opt,name=raw_state,json=rawState,proto3" json:"raw_state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpgradeResourceState_Request) Reset() {
	*x = UpgradeResourceState_Request{}
	mi := &file_tfplugin5_proto_msgTypes[72]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpgradeResourceState_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeResourceState_Request) ProtoMessage() {}

func (x *UpgradeResourceState_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[72]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeResourceState_Request.ProtoReflect.Descriptor instead.
func (*UpgradeResourceState_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{17, 0}
}

func (x *UpgradeResourceState_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *UpgradeResourceState_Request) GetVersion() int64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *UpgradeResourceState_Request) GetRawState() *RawState {
	if x != nil {
		return x.RawState
	}
	return nil
}

type UpgradeResourceState_Response struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// new_state is a msgpack-encoded data structure that, when interpreted with
	// the _current_ schema for this resource type, is functionally equivalent to
	// that which was given in prior_state_raw.
	UpgradedState *DynamicValue `protobuf:"bytes,1,opt,name=upgraded_state,json=upgradedState,proto3" json:"upgraded_state,omitempty"`
	// diagnostics describes any errors encountered during migration that could not
	// be safely resolved, and warnings about any possibly-risky assumptions made
	// in the upgrade process.
	Diagnostics   []*Diagnostic `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpgradeResourceState_Response) Reset() {
	*x = UpgradeResourceState_Response{}
	mi := &file_tfplugin5_proto_msgTypes[73]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpgradeResourceState_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeResourceState_Response) ProtoMessage() {}

func (x *UpgradeResourceState_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[73]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeResourceState_Response.ProtoReflect.Descriptor instead.
func (*UpgradeResourceState_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{17, 1}
}

func (x *UpgradeResourceState_Response) GetUpgradedState() *DynamicValue {
	if x != nil {
		return x.UpgradedState
	}
	return nil
}

func (x *UpgradeResourceState_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type GetResourceIdentitySchemas_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetResourceIdentitySchemas_Request) Reset() {
	*x = GetResourceIdentitySchemas_Request{}
	mi := &file_tfplugin5_proto_msgTypes[74]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetResourceIdentitySchemas_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetResourceIdentitySchemas_Request) ProtoMessage() {}

func (x *GetResourceIdentitySchemas_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[74]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetResourceIdentitySchemas_Request.ProtoReflect.Descriptor instead.
func (*GetResourceIdentitySchemas_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{18, 0}
}

type GetResourceIdentitySchemas_Response struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// identity_schemas is a mapping of resource type names to their identity schemas.
	IdentitySchemas map[string]*ResourceIdentitySchema `protobuf:"bytes,1,rep,name=identity_schemas,json=identitySchemas,proto3" json:"identity_schemas,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// diagnostics is the collection of warning and error diagnostics for this request.
	Diagnostics   []*Diagnostic `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetResourceIdentitySchemas_Response) Reset() {
	*x = GetResourceIdentitySchemas_Response{}
	mi := &file_tfplugin5_proto_msgTypes[75]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetResourceIdentitySchemas_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetResourceIdentitySchemas_Response) ProtoMessage() {}

func (x *GetResourceIdentitySchemas_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[75]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetResourceIdentitySchemas_Response.ProtoReflect.Descriptor instead.
func (*GetResourceIdentitySchemas_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{18, 1}
}

func (x *GetResourceIdentitySchemas_Response) GetIdentitySchemas() map[string]*ResourceIdentitySchema {
	if x != nil {
		return x.IdentitySchemas
	}
	return nil
}

func (x *GetResourceIdentitySchemas_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type UpgradeResourceIdentity_Request struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// type_name is the managed resource type name
	TypeName string `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	// version is the version of the resource identity data to upgrade
	Version int64 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	// raw_identity is the raw identity as stored for the resource. Core does
	// not have access to the identity schema of prior_version, so it's the
	// provider's responsibility to interpret this value using the
	// appropriate older schema. The raw_identity will be json encoded.
	RawIdentity   *RawState `protobuf:"bytes,3,opt,name=raw_identity,json=rawIdentity,proto3" json:"raw_identity,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpgradeResourceIdentity_Request) Reset() {
	*x = UpgradeResourceIdentity_Request{}
	mi := &file_tfplugin5_proto_msgTypes[77]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpgradeResourceIdentity_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeResourceIdentity_Request) ProtoMessage() {}

func (x *UpgradeResourceIdentity_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[77]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeResourceIdentity_Request.ProtoReflect.Descriptor instead.
func (*UpgradeResourceIdentity_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{19, 0}
}

func (x *UpgradeResourceIdentity_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *UpgradeResourceIdentity_Request) GetVersion() int64 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *UpgradeResourceIdentity_Request) GetRawIdentity() *RawState {
	if x != nil {
		return x.RawIdentity
	}
	return nil
}

type UpgradeResourceIdentity_Response struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// upgraded_identity returns the upgraded resource identity data
	UpgradedIdentity *ResourceIdentityData `protobuf:"bytes,1,opt,name=upgraded_identity,json=upgradedIdentity,proto3" json:"upgraded_identity,omitempty"`
	// diagnostics is the collection of warning and error diagnostics for this request
	Diagnostics   []*Diagnostic `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpgradeResourceIdentity_Response) Reset() {
	*x = UpgradeResourceIdentity_Response{}
	mi := &file_tfplugin5_proto_msgTypes[78]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpgradeResourceIdentity_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeResourceIdentity_Response) ProtoMessage() {}

func (x *UpgradeResourceIdentity_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[78]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeResourceIdentity_Response.ProtoReflect.Descriptor instead.
func (*UpgradeResourceIdentity_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{19, 1}
}

func (x *UpgradeResourceIdentity_Response) GetUpgradedIdentity() *ResourceIdentityData {
	if x != nil {
		return x.UpgradedIdentity
	}
	return nil
}

func (x *UpgradeResourceIdentity_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type ValidateResourceTypeConfig_Request struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	TypeName           string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Config             *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	ClientCapabilities *ClientCapabilities    `protobuf:"bytes,3,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ValidateResourceTypeConfig_Request) Reset() {
	*x = ValidateResourceTypeConfig_Request{}
	mi := &file_tfplugin5_proto_msgTypes[79]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateResourceTypeConfig_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateResourceTypeConfig_Request) ProtoMessage() {}

func (x *ValidateResourceTypeConfig_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[79]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateResourceTypeConfig_Request.ProtoReflect.Descriptor instead.
func (*ValidateResourceTypeConfig_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{20, 0}
}

func (x *ValidateResourceTypeConfig_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ValidateResourceTypeConfig_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *ValidateResourceTypeConfig_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

type ValidateResourceTypeConfig_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateResourceTypeConfig_Response) Reset() {
	*x = ValidateResourceTypeConfig_Response{}
	mi := &file_tfplugin5_proto_msgTypes[80]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateResourceTypeConfig_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateResourceTypeConfig_Response) ProtoMessage() {}

func (x *ValidateResourceTypeConfig_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[80]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateResourceTypeConfig_Response.ProtoReflect.Descriptor instead.
func (*ValidateResourceTypeConfig_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{20, 1}
}

func (x *ValidateResourceTypeConfig_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type ValidateDataSourceConfig_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Config        *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateDataSourceConfig_Request) Reset() {
	*x = ValidateDataSourceConfig_Request{}
	mi := &file_tfplugin5_proto_msgTypes[81]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateDataSourceConfig_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateDataSourceConfig_Request) ProtoMessage() {}

func (x *ValidateDataSourceConfig_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[81]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateDataSourceConfig_Request.ProtoReflect.Descriptor instead.
func (*ValidateDataSourceConfig_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{21, 0}
}

func (x *ValidateDataSourceConfig_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ValidateDataSourceConfig_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

type ValidateDataSourceConfig_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateDataSourceConfig_Response) Reset() {
	*x = ValidateDataSourceConfig_Response{}
	mi := &file_tfplugin5_proto_msgTypes[82]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateDataSourceConfig_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateDataSourceConfig_Response) ProtoMessage() {}

func (x *ValidateDataSourceConfig_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[82]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateDataSourceConfig_Response.ProtoReflect.Descriptor instead.
func (*ValidateDataSourceConfig_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{21, 1}
}

func (x *ValidateDataSourceConfig_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type ValidateEphemeralResourceConfig_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Config        *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateEphemeralResourceConfig_Request) Reset() {
	*x = ValidateEphemeralResourceConfig_Request{}
	mi := &file_tfplugin5_proto_msgTypes[83]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateEphemeralResourceConfig_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateEphemeralResourceConfig_Request) ProtoMessage() {}

func (x *ValidateEphemeralResourceConfig_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[83]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateEphemeralResourceConfig_Request.ProtoReflect.Descriptor instead.
func (*ValidateEphemeralResourceConfig_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{22, 0}
}

func (x *ValidateEphemeralResourceConfig_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ValidateEphemeralResourceConfig_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

type ValidateEphemeralResourceConfig_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateEphemeralResourceConfig_Response) Reset() {
	*x = ValidateEphemeralResourceConfig_Response{}
	mi := &file_tfplugin5_proto_msgTypes[84]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateEphemeralResourceConfig_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateEphemeralResourceConfig_Response) ProtoMessage() {}

func (x *ValidateEphemeralResourceConfig_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[84]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateEphemeralResourceConfig_Response.ProtoReflect.Descriptor instead.
func (*ValidateEphemeralResourceConfig_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{22, 1}
}

func (x *ValidateEphemeralResourceConfig_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type Configure_Request struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	TerraformVersion   string                 `protobuf:"bytes,1,opt,name=terraform_version,json=terraformVersion,proto3" json:"terraform_version,omitempty"`
	Config             *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	ClientCapabilities *ClientCapabilities    `protobuf:"bytes,3,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *Configure_Request) Reset() {
	*x = Configure_Request{}
	mi := &file_tfplugin5_proto_msgTypes[85]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Configure_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Configure_Request) ProtoMessage() {}

func (x *Configure_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[85]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Configure_Request.ProtoReflect.Descriptor instead.
func (*Configure_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{23, 0}
}

func (x *Configure_Request) GetTerraformVersion() string {
	if x != nil {
		return x.TerraformVersion
	}
	return ""
}

func (x *Configure_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Configure_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

type Configure_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Configure_Response) Reset() {
	*x = Configure_Response{}
	mi := &file_tfplugin5_proto_msgTypes[86]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Configure_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Configure_Response) ProtoMessage() {}

func (x *Configure_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[86]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Configure_Response.ProtoReflect.Descriptor instead.
func (*Configure_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{23, 1}
}

func (x *Configure_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

// Request is the message that is sent to the provider during the
// ReadResource RPC.
//
// This message intentionally does not include configuration data as any
// configuration-based or configuration-conditional changes should occur
// during the PlanResourceChange RPC. Additionally, the configuration is
// not guaranteed to be wholly known nor match the given prior state, which
// could lead to unexpected provider behaviors for practitioners.
type ReadResource_Request struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	TypeName           string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	CurrentState       *DynamicValue          `protobuf:"bytes,2,opt,name=current_state,json=currentState,proto3" json:"current_state,omitempty"`
	Private            []byte                 `protobuf:"bytes,3,opt,name=private,proto3" json:"private,omitempty"`
	ProviderMeta       *DynamicValue          `protobuf:"bytes,4,opt,name=provider_meta,json=providerMeta,proto3" json:"provider_meta,omitempty"`
	ClientCapabilities *ClientCapabilities    `protobuf:"bytes,5,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	CurrentIdentity    *ResourceIdentityData  `protobuf:"bytes,6,opt,name=current_identity,json=currentIdentity,proto3" json:"current_identity,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ReadResource_Request) Reset() {
	*x = ReadResource_Request{}
	mi := &file_tfplugin5_proto_msgTypes[87]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadResource_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadResource_Request) ProtoMessage() {}

func (x *ReadResource_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[87]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadResource_Request.ProtoReflect.Descriptor instead.
func (*ReadResource_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{24, 0}
}

func (x *ReadResource_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ReadResource_Request) GetCurrentState() *DynamicValue {
	if x != nil {
		return x.CurrentState
	}
	return nil
}

func (x *ReadResource_Request) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

func (x *ReadResource_Request) GetProviderMeta() *DynamicValue {
	if x != nil {
		return x.ProviderMeta
	}
	return nil
}

func (x *ReadResource_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

func (x *ReadResource_Request) GetCurrentIdentity() *ResourceIdentityData {
	if x != nil {
		return x.CurrentIdentity
	}
	return nil
}

type ReadResource_Response struct {
	state       protoimpl.MessageState `protogen:"open.v1"`
	NewState    *DynamicValue          `protobuf:"bytes,1,opt,name=new_state,json=newState,proto3" json:"new_state,omitempty"`
	Diagnostics []*Diagnostic          `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	Private     []byte                 `protobuf:"bytes,3,opt,name=private,proto3" json:"private,omitempty"`
	// deferred is set if the provider is deferring the change. If set the caller
	// needs to handle the deferral.
	Deferred      *Deferred             `protobuf:"bytes,4,opt,name=deferred,proto3" json:"deferred,omitempty"`
	NewIdentity   *ResourceIdentityData `protobuf:"bytes,5,opt,name=new_identity,json=newIdentity,proto3" json:"new_identity,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReadResource_Response) Reset() {
	*x = ReadResource_Response{}
	mi := &file_tfplugin5_proto_msgTypes[88]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadResource_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadResource_Response) ProtoMessage() {}

func (x *ReadResource_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[88]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadResource_Response.ProtoReflect.Descriptor instead.
func (*ReadResource_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{24, 1}
}

func (x *ReadResource_Response) GetNewState() *DynamicValue {
	if x != nil {
		return x.NewState
	}
	return nil
}

func (x *ReadResource_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *ReadResource_Response) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

func (x *ReadResource_Response) GetDeferred() *Deferred {
	if x != nil {
		return x.Deferred
	}
	return nil
}

func (x *ReadResource_Response) GetNewIdentity() *ResourceIdentityData {
	if x != nil {
		return x.NewIdentity
	}
	return nil
}

type PlanResourceChange_Request struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	TypeName           string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	PriorState         *DynamicValue          `protobuf:"bytes,2,opt,name=prior_state,json=priorState,proto3" json:"prior_state,omitempty"`
	ProposedNewState   *DynamicValue          `protobuf:"bytes,3,opt,name=proposed_new_state,json=proposedNewState,proto3" json:"proposed_new_state,omitempty"`
	Config             *DynamicValue          `protobuf:"bytes,4,opt,name=config,proto3" json:"config,omitempty"`
	PriorPrivate       []byte                 `protobuf:"bytes,5,opt,name=prior_private,json=priorPrivate,proto3" json:"prior_private,omitempty"`
	ProviderMeta       *DynamicValue          `protobuf:"bytes,6,opt,name=provider_meta,json=providerMeta,proto3" json:"provider_meta,omitempty"`
	ClientCapabilities *ClientCapabilities    `protobuf:"bytes,7,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	PriorIdentity      *ResourceIdentityData  `protobuf:"bytes,8,opt,name=prior_identity,json=priorIdentity,proto3" json:"prior_identity,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *PlanResourceChange_Request) Reset() {
	*x = PlanResourceChange_Request{}
	mi := &file_tfplugin5_proto_msgTypes[89]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanResourceChange_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanResourceChange_Request) ProtoMessage() {}

func (x *PlanResourceChange_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[89]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanResourceChange_Request.ProtoReflect.Descriptor instead.
func (*PlanResourceChange_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{25, 0}
}

func (x *PlanResourceChange_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *PlanResourceChange_Request) GetPriorState() *DynamicValue {
	if x != nil {
		return x.PriorState
	}
	return nil
}

func (x *PlanResourceChange_Request) GetProposedNewState() *DynamicValue {
	if x != nil {
		return x.ProposedNewState
	}
	return nil
}

func (x *PlanResourceChange_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *PlanResourceChange_Request) GetPriorPrivate() []byte {
	if x != nil {
		return x.PriorPrivate
	}
	return nil
}

func (x *PlanResourceChange_Request) GetProviderMeta() *DynamicValue {
	if x != nil {
		return x.ProviderMeta
	}
	return nil
}

func (x *PlanResourceChange_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

func (x *PlanResourceChange_Request) GetPriorIdentity() *ResourceIdentityData {
	if x != nil {
		return x.PriorIdentity
	}
	return nil
}

type PlanResourceChange_Response struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	PlannedState    *DynamicValue          `protobuf:"bytes,1,opt,name=planned_state,json=plannedState,proto3" json:"planned_state,omitempty"`
	RequiresReplace []*AttributePath       `protobuf:"bytes,2,rep,name=requires_replace,json=requiresReplace,proto3" json:"requires_replace,omitempty"`
	PlannedPrivate  []byte                 `protobuf:"bytes,3,opt,name=planned_private,json=plannedPrivate,proto3" json:"planned_private,omitempty"`
	Diagnostics     []*Diagnostic          `protobuf:"bytes,4,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	// This may be set only by the helper/schema "SDK" in the main Terraform
	// repository, to request that Terraform Core >=0.12 permit additional
	// inconsistencies that can result from the legacy SDK type system
	// and its imprecise mapping to the >=0.12 type system.
	// The change in behavior implied by this flag makes sense only for the
	// specific details of the legacy SDK type system, and are not a general
	// mechanism to avoid proper type handling in providers.
	//
	//	====              DO NOT USE THIS              ====
	//	==== THIS MUST BE LEFT UNSET IN ALL OTHER SDKS ====
	//	====              DO NOT USE THIS              ====
	LegacyTypeSystem bool `protobuf:"varint,5,opt,name=legacy_type_system,json=legacyTypeSystem,proto3" json:"legacy_type_system,omitempty"`
	// deferred is set if the provider is deferring the change. If set the caller
	// needs to handle the deferral.
	Deferred        *Deferred             `protobuf:"bytes,6,opt,name=deferred,proto3" json:"deferred,omitempty"`
	PlannedIdentity *ResourceIdentityData `protobuf:"bytes,7,opt,name=planned_identity,json=plannedIdentity,proto3" json:"planned_identity,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *PlanResourceChange_Response) Reset() {
	*x = PlanResourceChange_Response{}
	mi := &file_tfplugin5_proto_msgTypes[90]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanResourceChange_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanResourceChange_Response) ProtoMessage() {}

func (x *PlanResourceChange_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[90]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanResourceChange_Response.ProtoReflect.Descriptor instead.
func (*PlanResourceChange_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{25, 1}
}

func (x *PlanResourceChange_Response) GetPlannedState() *DynamicValue {
	if x != nil {
		return x.PlannedState
	}
	return nil
}

func (x *PlanResourceChange_Response) GetRequiresReplace() []*AttributePath {
	if x != nil {
		return x.RequiresReplace
	}
	return nil
}

func (x *PlanResourceChange_Response) GetPlannedPrivate() []byte {
	if x != nil {
		return x.PlannedPrivate
	}
	return nil
}

func (x *PlanResourceChange_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *PlanResourceChange_Response) GetLegacyTypeSystem() bool {
	if x != nil {
		return x.LegacyTypeSystem
	}
	return false
}

func (x *PlanResourceChange_Response) GetDeferred() *Deferred {
	if x != nil {
		return x.Deferred
	}
	return nil
}

func (x *PlanResourceChange_Response) GetPlannedIdentity() *ResourceIdentityData {
	if x != nil {
		return x.PlannedIdentity
	}
	return nil
}

type ApplyResourceChange_Request struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	TypeName        string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	PriorState      *DynamicValue          `protobuf:"bytes,2,opt,name=prior_state,json=priorState,proto3" json:"prior_state,omitempty"`
	PlannedState    *DynamicValue          `protobuf:"bytes,3,opt,name=planned_state,json=plannedState,proto3" json:"planned_state,omitempty"`
	Config          *DynamicValue          `protobuf:"bytes,4,opt,name=config,proto3" json:"config,omitempty"`
	PlannedPrivate  []byte                 `protobuf:"bytes,5,opt,name=planned_private,json=plannedPrivate,proto3" json:"planned_private,omitempty"`
	ProviderMeta    *DynamicValue          `protobuf:"bytes,6,opt,name=provider_meta,json=providerMeta,proto3" json:"provider_meta,omitempty"`
	PlannedIdentity *ResourceIdentityData  `protobuf:"bytes,7,opt,name=planned_identity,json=plannedIdentity,proto3" json:"planned_identity,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *ApplyResourceChange_Request) Reset() {
	*x = ApplyResourceChange_Request{}
	mi := &file_tfplugin5_proto_msgTypes[91]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApplyResourceChange_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyResourceChange_Request) ProtoMessage() {}

func (x *ApplyResourceChange_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[91]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyResourceChange_Request.ProtoReflect.Descriptor instead.
func (*ApplyResourceChange_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{26, 0}
}

func (x *ApplyResourceChange_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ApplyResourceChange_Request) GetPriorState() *DynamicValue {
	if x != nil {
		return x.PriorState
	}
	return nil
}

func (x *ApplyResourceChange_Request) GetPlannedState() *DynamicValue {
	if x != nil {
		return x.PlannedState
	}
	return nil
}

func (x *ApplyResourceChange_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *ApplyResourceChange_Request) GetPlannedPrivate() []byte {
	if x != nil {
		return x.PlannedPrivate
	}
	return nil
}

func (x *ApplyResourceChange_Request) GetProviderMeta() *DynamicValue {
	if x != nil {
		return x.ProviderMeta
	}
	return nil
}

func (x *ApplyResourceChange_Request) GetPlannedIdentity() *ResourceIdentityData {
	if x != nil {
		return x.PlannedIdentity
	}
	return nil
}

type ApplyResourceChange_Response struct {
	state       protoimpl.MessageState `protogen:"open.v1"`
	NewState    *DynamicValue          `protobuf:"bytes,1,opt,name=new_state,json=newState,proto3" json:"new_state,omitempty"`
	Private     []byte                 `protobuf:"bytes,2,opt,name=private,proto3" json:"private,omitempty"`
	Diagnostics []*Diagnostic          `protobuf:"bytes,3,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	// This may be set only by the helper/schema "SDK" in the main Terraform
	// repository, to request that Terraform Core >=0.12 permit additional
	// inconsistencies that can result from the legacy SDK type system
	// and its imprecise mapping to the >=0.12 type system.
	// The change in behavior implied by this flag makes sense only for the
	// specific details of the legacy SDK type system, and are not a general
	// mechanism to avoid proper type handling in providers.
	//
	//	====              DO NOT USE THIS              ====
	//	==== THIS MUST BE LEFT UNSET IN ALL OTHER SDKS ====
	//	====              DO NOT USE THIS              ====
	LegacyTypeSystem bool                  `protobuf:"varint,4,opt,name=legacy_type_system,json=legacyTypeSystem,proto3" json:"legacy_type_system,omitempty"`
	NewIdentity      *ResourceIdentityData `protobuf:"bytes,5,opt,name=new_identity,json=newIdentity,proto3" json:"new_identity,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *ApplyResourceChange_Response) Reset() {
	*x = ApplyResourceChange_Response{}
	mi := &file_tfplugin5_proto_msgTypes[92]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApplyResourceChange_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyResourceChange_Response) ProtoMessage() {}

func (x *ApplyResourceChange_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[92]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyResourceChange_Response.ProtoReflect.Descriptor instead.
func (*ApplyResourceChange_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{26, 1}
}

func (x *ApplyResourceChange_Response) GetNewState() *DynamicValue {
	if x != nil {
		return x.NewState
	}
	return nil
}

func (x *ApplyResourceChange_Response) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

func (x *ApplyResourceChange_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *ApplyResourceChange_Response) GetLegacyTypeSystem() bool {
	if x != nil {
		return x.LegacyTypeSystem
	}
	return false
}

func (x *ApplyResourceChange_Response) GetNewIdentity() *ResourceIdentityData {
	if x != nil {
		return x.NewIdentity
	}
	return nil
}

type ImportResourceState_Request struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	TypeName           string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Id                 string                 `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	ClientCapabilities *ClientCapabilities    `protobuf:"bytes,3,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	Identity           *ResourceIdentityData  `protobuf:"bytes,4,opt,name=identity,proto3" json:"identity,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ImportResourceState_Request) Reset() {
	*x = ImportResourceState_Request{}
	mi := &file_tfplugin5_proto_msgTypes[93]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportResourceState_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportResourceState_Request) ProtoMessage() {}

func (x *ImportResourceState_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[93]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportResourceState_Request.ProtoReflect.Descriptor instead.
func (*ImportResourceState_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{27, 0}
}

func (x *ImportResourceState_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ImportResourceState_Request) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ImportResourceState_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

func (x *ImportResourceState_Request) GetIdentity() *ResourceIdentityData {
	if x != nil {
		return x.Identity
	}
	return nil
}

type ImportResourceState_ImportedResource struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	State         *DynamicValue          `protobuf:"bytes,2,opt,name=state,proto3" json:"state,omitempty"`
	Private       []byte                 `protobuf:"bytes,3,opt,name=private,proto3" json:"private,omitempty"`
	Identity      *ResourceIdentityData  `protobuf:"bytes,4,opt,name=identity,proto3" json:"identity,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ImportResourceState_ImportedResource) Reset() {
	*x = ImportResourceState_ImportedResource{}
	mi := &file_tfplugin5_proto_msgTypes[94]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportResourceState_ImportedResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportResourceState_ImportedResource) ProtoMessage() {}

func (x *ImportResourceState_ImportedResource) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[94]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportResourceState_ImportedResource.ProtoReflect.Descriptor instead.
func (*ImportResourceState_ImportedResource) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{27, 1}
}

func (x *ImportResourceState_ImportedResource) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ImportResourceState_ImportedResource) GetState() *DynamicValue {
	if x != nil {
		return x.State
	}
	return nil
}

func (x *ImportResourceState_ImportedResource) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

func (x *ImportResourceState_ImportedResource) GetIdentity() *ResourceIdentityData {
	if x != nil {
		return x.Identity
	}
	return nil
}

type ImportResourceState_Response struct {
	state             protoimpl.MessageState                  `protogen:"open.v1"`
	ImportedResources []*ImportResourceState_ImportedResource `protobuf:"bytes,1,rep,name=imported_resources,json=importedResources,proto3" json:"imported_resources,omitempty"`
	Diagnostics       []*Diagnostic                           `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	// deferred is set if the provider is deferring the change. If set the caller
	// needs to handle the deferral.
	Deferred      *Deferred `protobuf:"bytes,3,opt,name=deferred,proto3" json:"deferred,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ImportResourceState_Response) Reset() {
	*x = ImportResourceState_Response{}
	mi := &file_tfplugin5_proto_msgTypes[95]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportResourceState_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportResourceState_Response) ProtoMessage() {}

func (x *ImportResourceState_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[95]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportResourceState_Response.ProtoReflect.Descriptor instead.
func (*ImportResourceState_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{27, 2}
}

func (x *ImportResourceState_Response) GetImportedResources() []*ImportResourceState_ImportedResource {
	if x != nil {
		return x.ImportedResources
	}
	return nil
}

func (x *ImportResourceState_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *ImportResourceState_Response) GetDeferred() *Deferred {
	if x != nil {
		return x.Deferred
	}
	return nil
}

type GenerateResourceConfig_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	State         *DynamicValue          `protobuf:"bytes,2,opt,name=state,proto3" json:"state,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GenerateResourceConfig_Request) Reset() {
	*x = GenerateResourceConfig_Request{}
	mi := &file_tfplugin5_proto_msgTypes[96]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateResourceConfig_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateResourceConfig_Request) ProtoMessage() {}

func (x *GenerateResourceConfig_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[96]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateResourceConfig_Request.ProtoReflect.Descriptor instead.
func (*GenerateResourceConfig_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{28, 0}
}

func (x *GenerateResourceConfig_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *GenerateResourceConfig_Request) GetState() *DynamicValue {
	if x != nil {
		return x.State
	}
	return nil
}

type GenerateResourceConfig_Response struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// config is the provided state modified such that it represents a valid resource configuration value.
	Config        *DynamicValue `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	Diagnostics   []*Diagnostic `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GenerateResourceConfig_Response) Reset() {
	*x = GenerateResourceConfig_Response{}
	mi := &file_tfplugin5_proto_msgTypes[97]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateResourceConfig_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateResourceConfig_Response) ProtoMessage() {}

func (x *GenerateResourceConfig_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[97]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateResourceConfig_Response.ProtoReflect.Descriptor instead.
func (*GenerateResourceConfig_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{28, 1}
}

func (x *GenerateResourceConfig_Response) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *GenerateResourceConfig_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type MoveResourceState_Request struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The address of the provider the resource is being moved from.
	SourceProviderAddress string `protobuf:"bytes,1,opt,name=source_provider_address,json=sourceProviderAddress,proto3" json:"source_provider_address,omitempty"`
	// The resource type that the resource is being moved from.
	SourceTypeName string `protobuf:"bytes,2,opt,name=source_type_name,json=sourceTypeName,proto3" json:"source_type_name,omitempty"`
	// The schema version of the resource type that the resource is being
	// moved from.
	SourceSchemaVersion int64 `protobuf:"varint,3,opt,name=source_schema_version,json=sourceSchemaVersion,proto3" json:"source_schema_version,omitempty"`
	// The raw state of the resource being moved. Only the json field is
	// populated, as there should be no legacy providers using the flatmap
	// format that support newly introduced RPCs.
	SourceState *RawState `protobuf:"bytes,4,opt,name=source_state,json=sourceState,proto3" json:"source_state,omitempty"`
	// The resource type that the resource is being moved to.
	TargetTypeName string `protobuf:"bytes,5,opt,name=target_type_name,json=targetTypeName,proto3" json:"target_type_name,omitempty"`
	// The private state of the resource being moved.
	SourcePrivate []byte `protobuf:"bytes,6,opt,name=source_private,json=sourcePrivate,proto3" json:"source_private,omitempty"`
	// The raw identity of the resource being moved. Only the json field is
	// populated, as there should be no legacy providers using the flatmap
	// format that support newly introduced RPCs.
	SourceIdentity *RawState `protobuf:"bytes,7,opt,name=source_identity,json=sourceIdentity,proto3" json:"source_identity,omitempty"`
	// The identity schema version of the resource type that the resource
	// is being moved from.
	SourceIdentitySchemaVersion int64 `protobuf:"varint,8,opt,name=source_identity_schema_version,json=sourceIdentitySchemaVersion,proto3" json:"source_identity_schema_version,omitempty"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *MoveResourceState_Request) Reset() {
	*x = MoveResourceState_Request{}
	mi := &file_tfplugin5_proto_msgTypes[98]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MoveResourceState_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveResourceState_Request) ProtoMessage() {}

func (x *MoveResourceState_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[98]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveResourceState_Request.ProtoReflect.Descriptor instead.
func (*MoveResourceState_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{29, 0}
}

func (x *MoveResourceState_Request) GetSourceProviderAddress() string {
	if x != nil {
		return x.SourceProviderAddress
	}
	return ""
}

func (x *MoveResourceState_Request) GetSourceTypeName() string {
	if x != nil {
		return x.SourceTypeName
	}
	return ""
}

func (x *MoveResourceState_Request) GetSourceSchemaVersion() int64 {
	if x != nil {
		return x.SourceSchemaVersion
	}
	return 0
}

func (x *MoveResourceState_Request) GetSourceState() *RawState {
	if x != nil {
		return x.SourceState
	}
	return nil
}

func (x *MoveResourceState_Request) GetTargetTypeName() string {
	if x != nil {
		return x.TargetTypeName
	}
	return ""
}

func (x *MoveResourceState_Request) GetSourcePrivate() []byte {
	if x != nil {
		return x.SourcePrivate
	}
	return nil
}

func (x *MoveResourceState_Request) GetSourceIdentity() *RawState {
	if x != nil {
		return x.SourceIdentity
	}
	return nil
}

func (x *MoveResourceState_Request) GetSourceIdentitySchemaVersion() int64 {
	if x != nil {
		return x.SourceIdentitySchemaVersion
	}
	return 0
}

type MoveResourceState_Response struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The state of the resource after it has been moved.
	TargetState *DynamicValue `protobuf:"bytes,1,opt,name=target_state,json=targetState,proto3" json:"target_state,omitempty"`
	// Any diagnostics that occurred during the move.
	Diagnostics []*Diagnostic `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	// The private state of the resource after it has been moved.
	TargetPrivate  []byte                `protobuf:"bytes,3,opt,name=target_private,json=targetPrivate,proto3" json:"target_private,omitempty"`
	TargetIdentity *ResourceIdentityData `protobuf:"bytes,4,opt,name=target_identity,json=targetIdentity,proto3" json:"target_identity,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *MoveResourceState_Response) Reset() {
	*x = MoveResourceState_Response{}
	mi := &file_tfplugin5_proto_msgTypes[99]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MoveResourceState_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveResourceState_Response) ProtoMessage() {}

func (x *MoveResourceState_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[99]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveResourceState_Response.ProtoReflect.Descriptor instead.
func (*MoveResourceState_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{29, 1}
}

func (x *MoveResourceState_Response) GetTargetState() *DynamicValue {
	if x != nil {
		return x.TargetState
	}
	return nil
}

func (x *MoveResourceState_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *MoveResourceState_Response) GetTargetPrivate() []byte {
	if x != nil {
		return x.TargetPrivate
	}
	return nil
}

func (x *MoveResourceState_Response) GetTargetIdentity() *ResourceIdentityData {
	if x != nil {
		return x.TargetIdentity
	}
	return nil
}

type ReadDataSource_Request struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	TypeName           string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Config             *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	ProviderMeta       *DynamicValue          `protobuf:"bytes,3,opt,name=provider_meta,json=providerMeta,proto3" json:"provider_meta,omitempty"`
	ClientCapabilities *ClientCapabilities    `protobuf:"bytes,4,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *ReadDataSource_Request) Reset() {
	*x = ReadDataSource_Request{}
	mi := &file_tfplugin5_proto_msgTypes[100]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadDataSource_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadDataSource_Request) ProtoMessage() {}

func (x *ReadDataSource_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[100]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadDataSource_Request.ProtoReflect.Descriptor instead.
func (*ReadDataSource_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{30, 0}
}

func (x *ReadDataSource_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ReadDataSource_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *ReadDataSource_Request) GetProviderMeta() *DynamicValue {
	if x != nil {
		return x.ProviderMeta
	}
	return nil
}

func (x *ReadDataSource_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

type ReadDataSource_Response struct {
	state       protoimpl.MessageState `protogen:"open.v1"`
	State       *DynamicValue          `protobuf:"bytes,1,opt,name=state,proto3" json:"state,omitempty"`
	Diagnostics []*Diagnostic          `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	// deferred is set if the provider is deferring the change. If set the caller
	// needs to handle the deferral.
	Deferred      *Deferred `protobuf:"bytes,3,opt,name=deferred,proto3" json:"deferred,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReadDataSource_Response) Reset() {
	*x = ReadDataSource_Response{}
	mi := &file_tfplugin5_proto_msgTypes[101]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadDataSource_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadDataSource_Response) ProtoMessage() {}

func (x *ReadDataSource_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[101]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadDataSource_Response.ProtoReflect.Descriptor instead.
func (*ReadDataSource_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{30, 1}
}

func (x *ReadDataSource_Response) GetState() *DynamicValue {
	if x != nil {
		return x.State
	}
	return nil
}

func (x *ReadDataSource_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *ReadDataSource_Response) GetDeferred() *Deferred {
	if x != nil {
		return x.Deferred
	}
	return nil
}

type GetProvisionerSchema_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetProvisionerSchema_Request) Reset() {
	*x = GetProvisionerSchema_Request{}
	mi := &file_tfplugin5_proto_msgTypes[102]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetProvisionerSchema_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProvisionerSchema_Request) ProtoMessage() {}

func (x *GetProvisionerSchema_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[102]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProvisionerSchema_Request.ProtoReflect.Descriptor instead.
func (*GetProvisionerSchema_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{31, 0}
}

type GetProvisionerSchema_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Provisioner   *Schema                `protobuf:"bytes,1,opt,name=provisioner,proto3" json:"provisioner,omitempty"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetProvisionerSchema_Response) Reset() {
	*x = GetProvisionerSchema_Response{}
	mi := &file_tfplugin5_proto_msgTypes[103]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetProvisionerSchema_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProvisionerSchema_Response) ProtoMessage() {}

func (x *GetProvisionerSchema_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[103]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProvisionerSchema_Response.ProtoReflect.Descriptor instead.
func (*GetProvisionerSchema_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{31, 1}
}

func (x *GetProvisionerSchema_Response) GetProvisioner() *Schema {
	if x != nil {
		return x.Provisioner
	}
	return nil
}

func (x *GetProvisionerSchema_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type ValidateProvisionerConfig_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Config        *DynamicValue          `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateProvisionerConfig_Request) Reset() {
	*x = ValidateProvisionerConfig_Request{}
	mi := &file_tfplugin5_proto_msgTypes[104]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateProvisionerConfig_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateProvisionerConfig_Request) ProtoMessage() {}

func (x *ValidateProvisionerConfig_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[104]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateProvisionerConfig_Request.ProtoReflect.Descriptor instead.
func (*ValidateProvisionerConfig_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{32, 0}
}

func (x *ValidateProvisionerConfig_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

type ValidateProvisionerConfig_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateProvisionerConfig_Response) Reset() {
	*x = ValidateProvisionerConfig_Response{}
	mi := &file_tfplugin5_proto_msgTypes[105]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateProvisionerConfig_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateProvisionerConfig_Response) ProtoMessage() {}

func (x *ValidateProvisionerConfig_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[105]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateProvisionerConfig_Response.ProtoReflect.Descriptor instead.
func (*ValidateProvisionerConfig_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{32, 1}
}

func (x *ValidateProvisionerConfig_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type ProvisionResource_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Config        *DynamicValue          `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	Connection    *DynamicValue          `protobuf:"bytes,2,opt,name=connection,proto3" json:"connection,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProvisionResource_Request) Reset() {
	*x = ProvisionResource_Request{}
	mi := &file_tfplugin5_proto_msgTypes[106]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProvisionResource_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProvisionResource_Request) ProtoMessage() {}

func (x *ProvisionResource_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[106]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProvisionResource_Request.ProtoReflect.Descriptor instead.
func (*ProvisionResource_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{33, 0}
}

func (x *ProvisionResource_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *ProvisionResource_Request) GetConnection() *DynamicValue {
	if x != nil {
		return x.Connection
	}
	return nil
}

type ProvisionResource_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Output        string                 `protobuf:"bytes,1,opt,name=output,proto3" json:"output,omitempty"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProvisionResource_Response) Reset() {
	*x = ProvisionResource_Response{}
	mi := &file_tfplugin5_proto_msgTypes[107]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProvisionResource_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProvisionResource_Response) ProtoMessage() {}

func (x *ProvisionResource_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[107]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProvisionResource_Response.ProtoReflect.Descriptor instead.
func (*ProvisionResource_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{33, 1}
}

func (x *ProvisionResource_Response) GetOutput() string {
	if x != nil {
		return x.Output
	}
	return ""
}

func (x *ProvisionResource_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type OpenEphemeralResource_Request struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	TypeName           string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Config             *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	ClientCapabilities *ClientCapabilities    `protobuf:"bytes,3,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *OpenEphemeralResource_Request) Reset() {
	*x = OpenEphemeralResource_Request{}
	mi := &file_tfplugin5_proto_msgTypes[108]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenEphemeralResource_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenEphemeralResource_Request) ProtoMessage() {}

func (x *OpenEphemeralResource_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[108]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenEphemeralResource_Request.ProtoReflect.Descriptor instead.
func (*OpenEphemeralResource_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{34, 0}
}

func (x *OpenEphemeralResource_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *OpenEphemeralResource_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *OpenEphemeralResource_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

type OpenEphemeralResource_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	RenewAt       *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=renew_at,json=renewAt,proto3,oneof" json:"renew_at,omitempty"`
	Result        *DynamicValue          `protobuf:"bytes,3,opt,name=result,proto3" json:"result,omitempty"`
	Private       []byte                 `protobuf:"bytes,4,opt,name=private,proto3,oneof" json:"private,omitempty"`
	Deferred      *Deferred              `protobuf:"bytes,5,opt,name=deferred,proto3" json:"deferred,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OpenEphemeralResource_Response) Reset() {
	*x = OpenEphemeralResource_Response{}
	mi := &file_tfplugin5_proto_msgTypes[109]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpenEphemeralResource_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpenEphemeralResource_Response) ProtoMessage() {}

func (x *OpenEphemeralResource_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[109]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpenEphemeralResource_Response.ProtoReflect.Descriptor instead.
func (*OpenEphemeralResource_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{34, 1}
}

func (x *OpenEphemeralResource_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *OpenEphemeralResource_Response) GetRenewAt() *timestamppb.Timestamp {
	if x != nil {
		return x.RenewAt
	}
	return nil
}

func (x *OpenEphemeralResource_Response) GetResult() *DynamicValue {
	if x != nil {
		return x.Result
	}
	return nil
}

func (x *OpenEphemeralResource_Response) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

func (x *OpenEphemeralResource_Response) GetDeferred() *Deferred {
	if x != nil {
		return x.Deferred
	}
	return nil
}

type RenewEphemeralResource_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Private       []byte                 `protobuf:"bytes,2,opt,name=private,proto3,oneof" json:"private,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RenewEphemeralResource_Request) Reset() {
	*x = RenewEphemeralResource_Request{}
	mi := &file_tfplugin5_proto_msgTypes[110]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RenewEphemeralResource_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenewEphemeralResource_Request) ProtoMessage() {}

func (x *RenewEphemeralResource_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[110]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenewEphemeralResource_Request.ProtoReflect.Descriptor instead.
func (*RenewEphemeralResource_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{35, 0}
}

func (x *RenewEphemeralResource_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *RenewEphemeralResource_Request) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

type RenewEphemeralResource_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	RenewAt       *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=renew_at,json=renewAt,proto3,oneof" json:"renew_at,omitempty"`
	Private       []byte                 `protobuf:"bytes,3,opt,name=private,proto3,oneof" json:"private,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RenewEphemeralResource_Response) Reset() {
	*x = RenewEphemeralResource_Response{}
	mi := &file_tfplugin5_proto_msgTypes[111]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RenewEphemeralResource_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenewEphemeralResource_Response) ProtoMessage() {}

func (x *RenewEphemeralResource_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[111]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenewEphemeralResource_Response.ProtoReflect.Descriptor instead.
func (*RenewEphemeralResource_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{35, 1}
}

func (x *RenewEphemeralResource_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *RenewEphemeralResource_Response) GetRenewAt() *timestamppb.Timestamp {
	if x != nil {
		return x.RenewAt
	}
	return nil
}

func (x *RenewEphemeralResource_Response) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

type CloseEphemeralResource_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Private       []byte                 `protobuf:"bytes,2,opt,name=private,proto3,oneof" json:"private,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CloseEphemeralResource_Request) Reset() {
	*x = CloseEphemeralResource_Request{}
	mi := &file_tfplugin5_proto_msgTypes[112]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseEphemeralResource_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseEphemeralResource_Request) ProtoMessage() {}

func (x *CloseEphemeralResource_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[112]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseEphemeralResource_Request.ProtoReflect.Descriptor instead.
func (*CloseEphemeralResource_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{36, 0}
}

func (x *CloseEphemeralResource_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *CloseEphemeralResource_Request) GetPrivate() []byte {
	if x != nil {
		return x.Private
	}
	return nil
}

type CloseEphemeralResource_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CloseEphemeralResource_Response) Reset() {
	*x = CloseEphemeralResource_Response{}
	mi := &file_tfplugin5_proto_msgTypes[113]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloseEphemeralResource_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloseEphemeralResource_Response) ProtoMessage() {}

func (x *CloseEphemeralResource_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[113]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloseEphemeralResource_Response.ProtoReflect.Descriptor instead.
func (*CloseEphemeralResource_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{36, 1}
}

func (x *CloseEphemeralResource_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type GetFunctions_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetFunctions_Request) Reset() {
	*x = GetFunctions_Request{}
	mi := &file_tfplugin5_proto_msgTypes[114]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFunctions_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFunctions_Request) ProtoMessage() {}

func (x *GetFunctions_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[114]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFunctions_Request.ProtoReflect.Descriptor instead.
func (*GetFunctions_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{37, 0}
}

type GetFunctions_Response struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// functions is a mapping of function names to definitions.
	Functions map[string]*Function `protobuf:"bytes,1,rep,name=functions,proto3" json:"functions,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// diagnostics is any warnings or errors.
	Diagnostics   []*Diagnostic `protobuf:"bytes,2,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetFunctions_Response) Reset() {
	*x = GetFunctions_Response{}
	mi := &file_tfplugin5_proto_msgTypes[115]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetFunctions_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFunctions_Response) ProtoMessage() {}

func (x *GetFunctions_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[115]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFunctions_Response.ProtoReflect.Descriptor instead.
func (*GetFunctions_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{37, 1}
}

func (x *GetFunctions_Response) GetFunctions() map[string]*Function {
	if x != nil {
		return x.Functions
	}
	return nil
}

func (x *GetFunctions_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type CallFunction_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Arguments     []*DynamicValue        `protobuf:"bytes,2,rep,name=arguments,proto3" json:"arguments,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CallFunction_Request) Reset() {
	*x = CallFunction_Request{}
	mi := &file_tfplugin5_proto_msgTypes[117]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CallFunction_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CallFunction_Request) ProtoMessage() {}

func (x *CallFunction_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[117]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CallFunction_Request.ProtoReflect.Descriptor instead.
func (*CallFunction_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{38, 0}
}

func (x *CallFunction_Request) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CallFunction_Request) GetArguments() []*DynamicValue {
	if x != nil {
		return x.Arguments
	}
	return nil
}

type CallFunction_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Result        *DynamicValue          `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
	Error         *FunctionError         `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CallFunction_Response) Reset() {
	*x = CallFunction_Response{}
	mi := &file_tfplugin5_proto_msgTypes[118]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CallFunction_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CallFunction_Response) ProtoMessage() {}

func (x *CallFunction_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[118]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CallFunction_Response.ProtoReflect.Descriptor instead.
func (*CallFunction_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{38, 1}
}

func (x *CallFunction_Response) GetResult() *DynamicValue {
	if x != nil {
		return x.Result
	}
	return nil
}

func (x *CallFunction_Response) GetError() *FunctionError {
	if x != nil {
		return x.Error
	}
	return nil
}

type ListResource_Request struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// type_name is the list resource type name.
	TypeName string `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	// configuration is the list ConfigSchema-based configuration data.
	Config *DynamicValue `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// when include_resource_object is set to true, the provider should
	// include the full resource object for each result
	IncludeResourceObject bool `protobuf:"varint,3,opt,name=include_resource_object,json=includeResourceObject,proto3" json:"include_resource_object,omitempty"`
	// The maximum number of results that Terraform is expecting.
	// The stream will stop, once this limit is reached.
	Limit         int64 `protobuf:"varint,4,opt,name=limit,proto3" json:"limit,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListResource_Request) Reset() {
	*x = ListResource_Request{}
	mi := &file_tfplugin5_proto_msgTypes[119]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListResource_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListResource_Request) ProtoMessage() {}

func (x *ListResource_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[119]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListResource_Request.ProtoReflect.Descriptor instead.
func (*ListResource_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{39, 0}
}

func (x *ListResource_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ListResource_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *ListResource_Request) GetIncludeResourceObject() bool {
	if x != nil {
		return x.IncludeResourceObject
	}
	return false
}

func (x *ListResource_Request) GetLimit() int64 {
	if x != nil {
		return x.Limit
	}
	return 0
}

type ListResource_Event struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// identity is the resource identity data of the resource instance.
	Identity *ResourceIdentityData `protobuf:"bytes,1,opt,name=identity,proto3" json:"identity,omitempty"`
	// display_name can be displayed in a UI to make it easier for humans to identify a resource
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// optional resource object which can be useful when combining list blocks in configuration
	ResourceObject *DynamicValue `protobuf:"bytes,3,opt,name=resource_object,json=resourceObject,proto3,oneof" json:"resource_object,omitempty"`
	// A warning or error diagnostics for this event
	Diagnostic    []*Diagnostic `protobuf:"bytes,4,rep,name=diagnostic,proto3" json:"diagnostic,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListResource_Event) Reset() {
	*x = ListResource_Event{}
	mi := &file_tfplugin5_proto_msgTypes[120]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListResource_Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListResource_Event) ProtoMessage() {}

func (x *ListResource_Event) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[120]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListResource_Event.ProtoReflect.Descriptor instead.
func (*ListResource_Event) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{39, 1}
}

func (x *ListResource_Event) GetIdentity() *ResourceIdentityData {
	if x != nil {
		return x.Identity
	}
	return nil
}

func (x *ListResource_Event) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ListResource_Event) GetResourceObject() *DynamicValue {
	if x != nil {
		return x.ResourceObject
	}
	return nil
}

func (x *ListResource_Event) GetDiagnostic() []*Diagnostic {
	if x != nil {
		return x.Diagnostic
	}
	return nil
}

type ValidateListResourceConfig_Request struct {
	state                 protoimpl.MessageState `protogen:"open.v1"`
	TypeName              string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Config                *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	IncludeResourceObject *DynamicValue          `protobuf:"bytes,3,opt,name=include_resource_object,json=includeResourceObject,proto3" json:"include_resource_object,omitempty"`
	Limit                 *DynamicValue          `protobuf:"bytes,4,opt,name=limit,proto3" json:"limit,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *ValidateListResourceConfig_Request) Reset() {
	*x = ValidateListResourceConfig_Request{}
	mi := &file_tfplugin5_proto_msgTypes[121]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateListResourceConfig_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateListResourceConfig_Request) ProtoMessage() {}

func (x *ValidateListResourceConfig_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[121]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateListResourceConfig_Request.ProtoReflect.Descriptor instead.
func (*ValidateListResourceConfig_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{40, 0}
}

func (x *ValidateListResourceConfig_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ValidateListResourceConfig_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *ValidateListResourceConfig_Request) GetIncludeResourceObject() *DynamicValue {
	if x != nil {
		return x.IncludeResourceObject
	}
	return nil
}

func (x *ValidateListResourceConfig_Request) GetLimit() *DynamicValue {
	if x != nil {
		return x.Limit
	}
	return nil
}

type ValidateListResourceConfig_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateListResourceConfig_Response) Reset() {
	*x = ValidateListResourceConfig_Response{}
	mi := &file_tfplugin5_proto_msgTypes[122]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateListResourceConfig_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateListResourceConfig_Response) ProtoMessage() {}

func (x *ValidateListResourceConfig_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[122]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateListResourceConfig_Response.ProtoReflect.Descriptor instead.
func (*ValidateListResourceConfig_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{40, 1}
}

func (x *ValidateListResourceConfig_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type PlanAction_Request struct {
	state      protoimpl.MessageState `protogen:"open.v1"`
	ActionType string                 `protobuf:"bytes,1,opt,name=action_type,json=actionType,proto3" json:"action_type,omitempty"`
	// config of the action, based on the schema of the actual action
	Config *DynamicValue `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// metadata
	ClientCapabilities *ClientCapabilities `protobuf:"bytes,3,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *PlanAction_Request) Reset() {
	*x = PlanAction_Request{}
	mi := &file_tfplugin5_proto_msgTypes[123]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanAction_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanAction_Request) ProtoMessage() {}

func (x *PlanAction_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[123]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanAction_Request.ProtoReflect.Descriptor instead.
func (*PlanAction_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{41, 0}
}

func (x *PlanAction_Request) GetActionType() string {
	if x != nil {
		return x.ActionType
	}
	return ""
}

func (x *PlanAction_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *PlanAction_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

type PlanAction_Response struct {
	state       protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	// metadata
	Deferred      *Deferred `protobuf:"bytes,2,opt,name=deferred,proto3" json:"deferred,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PlanAction_Response) Reset() {
	*x = PlanAction_Response{}
	mi := &file_tfplugin5_proto_msgTypes[124]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlanAction_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlanAction_Response) ProtoMessage() {}

func (x *PlanAction_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[124]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlanAction_Response.ProtoReflect.Descriptor instead.
func (*PlanAction_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{41, 1}
}

func (x *PlanAction_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

func (x *PlanAction_Response) GetDeferred() *Deferred {
	if x != nil {
		return x.Deferred
	}
	return nil
}

type InvokeAction_Request struct {
	state      protoimpl.MessageState `protogen:"open.v1"`
	ActionType string                 `protobuf:"bytes,1,opt,name=action_type,json=actionType,proto3" json:"action_type,omitempty"`
	// response from the plan
	Config *DynamicValue `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// metadata
	ClientCapabilities *ClientCapabilities `protobuf:"bytes,3,opt,name=client_capabilities,json=clientCapabilities,proto3" json:"client_capabilities,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *InvokeAction_Request) Reset() {
	*x = InvokeAction_Request{}
	mi := &file_tfplugin5_proto_msgTypes[125]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InvokeAction_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InvokeAction_Request) ProtoMessage() {}

func (x *InvokeAction_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[125]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InvokeAction_Request.ProtoReflect.Descriptor instead.
func (*InvokeAction_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{42, 0}
}

func (x *InvokeAction_Request) GetActionType() string {
	if x != nil {
		return x.ActionType
	}
	return ""
}

func (x *InvokeAction_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *InvokeAction_Request) GetClientCapabilities() *ClientCapabilities {
	if x != nil {
		return x.ClientCapabilities
	}
	return nil
}

type InvokeAction_Event struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Type:
	//
	//	*InvokeAction_Event_Progress_
	//	*InvokeAction_Event_Completed_
	Type          isInvokeAction_Event_Type `protobuf_oneof:"type"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InvokeAction_Event) Reset() {
	*x = InvokeAction_Event{}
	mi := &file_tfplugin5_proto_msgTypes[126]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InvokeAction_Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InvokeAction_Event) ProtoMessage() {}

func (x *InvokeAction_Event) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[126]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InvokeAction_Event.ProtoReflect.Descriptor instead.
func (*InvokeAction_Event) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{42, 1}
}

func (x *InvokeAction_Event) GetType() isInvokeAction_Event_Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *InvokeAction_Event) GetProgress() *InvokeAction_Event_Progress {
	if x != nil {
		if x, ok := x.Type.(*InvokeAction_Event_Progress_); ok {
			return x.Progress
		}
	}
	return nil
}

func (x *InvokeAction_Event) GetCompleted() *InvokeAction_Event_Completed {
	if x != nil {
		if x, ok := x.Type.(*InvokeAction_Event_Completed_); ok {
			return x.Completed
		}
	}
	return nil
}

type isInvokeAction_Event_Type interface {
	isInvokeAction_Event_Type()
}

type InvokeAction_Event_Progress_ struct {
	Progress *InvokeAction_Event_Progress `protobuf:"bytes,1,opt,name=progress,proto3,oneof"`
}

type InvokeAction_Event_Completed_ struct {
	Completed *InvokeAction_Event_Completed `protobuf:"bytes,2,opt,name=completed,proto3,oneof"`
}

func (*InvokeAction_Event_Progress_) isInvokeAction_Event_Type() {}

func (*InvokeAction_Event_Completed_) isInvokeAction_Event_Type() {}

type InvokeAction_Event_Progress struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// message to be printed in the console / HCPT
	Message       string `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InvokeAction_Event_Progress) Reset() {
	*x = InvokeAction_Event_Progress{}
	mi := &file_tfplugin5_proto_msgTypes[127]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InvokeAction_Event_Progress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InvokeAction_Event_Progress) ProtoMessage() {}

func (x *InvokeAction_Event_Progress) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[127]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InvokeAction_Event_Progress.ProtoReflect.Descriptor instead.
func (*InvokeAction_Event_Progress) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{42, 1, 0}
}

func (x *InvokeAction_Event_Progress) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

type InvokeAction_Event_Completed struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *InvokeAction_Event_Completed) Reset() {
	*x = InvokeAction_Event_Completed{}
	mi := &file_tfplugin5_proto_msgTypes[128]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InvokeAction_Event_Completed) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InvokeAction_Event_Completed) ProtoMessage() {}

func (x *InvokeAction_Event_Completed) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[128]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InvokeAction_Event_Completed.ProtoReflect.Descriptor instead.
func (*InvokeAction_Event_Completed) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{42, 1, 1}
}

func (x *InvokeAction_Event_Completed) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

type ValidateActionConfig_Request struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TypeName      string                 `protobuf:"bytes,1,opt,name=type_name,json=typeName,proto3" json:"type_name,omitempty"`
	Config        *DynamicValue          `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateActionConfig_Request) Reset() {
	*x = ValidateActionConfig_Request{}
	mi := &file_tfplugin5_proto_msgTypes[129]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateActionConfig_Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateActionConfig_Request) ProtoMessage() {}

func (x *ValidateActionConfig_Request) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[129]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateActionConfig_Request.ProtoReflect.Descriptor instead.
func (*ValidateActionConfig_Request) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{43, 0}
}

func (x *ValidateActionConfig_Request) GetTypeName() string {
	if x != nil {
		return x.TypeName
	}
	return ""
}

func (x *ValidateActionConfig_Request) GetConfig() *DynamicValue {
	if x != nil {
		return x.Config
	}
	return nil
}

type ValidateActionConfig_Response struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Diagnostics   []*Diagnostic          `protobuf:"bytes,1,rep,name=diagnostics,proto3" json:"diagnostics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ValidateActionConfig_Response) Reset() {
	*x = ValidateActionConfig_Response{}
	mi := &file_tfplugin5_proto_msgTypes[130]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateActionConfig_Response) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateActionConfig_Response) ProtoMessage() {}

func (x *ValidateActionConfig_Response) ProtoReflect() protoreflect.Message {
	mi := &file_tfplugin5_proto_msgTypes[130]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateActionConfig_Response.ProtoReflect.Descriptor instead.
func (*ValidateActionConfig_Response) Descriptor() ([]byte, []int) {
	return file_tfplugin5_proto_rawDescGZIP(), []int{43, 1}
}

func (x *ValidateActionConfig_Response) GetDiagnostics() []*Diagnostic {
	if x != nil {
		return x.Diagnostics
	}
	return nil
}

var File_tfplugin5_proto protoreflect.FileDescriptor

const file_tfplugin5_proto_rawDesc = "" +
	"\n" +
	"\x0ftfplugin5.proto\x12\ttfplugin5\x1a\x1fgoogle/protobuf/timestamp.proto\"<\n" +
	"\fDynamicValue\x12\x18\n" +
	"\amsgpack\x18\x01 \x01(\fR\amsgpack\x12\x12\n" +
	"\x04json\x18\x02 \x01(\fR\x04json\"\xe3\x01\n" +
	"\n" +
	"Diagnostic\x12:\n" +
	"\bseverity\x18\x01 \x01(\x0e2\x1e.tfplugin5.Diagnostic.SeverityR\bseverity\x12\x18\n" +
	"\asummary\x18\x02 \x01(\tR\asummary\x12\x16\n" +
	"\x06detail\x18\x03 \x01(\tR\x06detail\x126\n" +
	"\tattribute\x18\x04 \x01(\v2\x18.tfplugin5.AttributePathR\tattribute\"/\n" +
	"\bSeverity\x12\v\n" +
	"\aINVALID\x10\x00\x12\t\n" +
	"\x05ERROR\x10\x01\x12\v\n" +
	"\aWARNING\x10\x02\"k\n" +
	"\rFunctionError\x12\x12\n" +
	"\x04text\x18\x01 \x01(\tR\x04text\x120\n" +
	"\x11function_argument\x18\x02 \x01(\x03H\x00R\x10functionArgument\x88\x01\x01B\x14\n" +
	"\x12_function_argument\"\xdc\x01\n" +
	"\rAttributePath\x123\n" +
	"\x05steps\x18\x01 \x03(\v2\x1d.tfplugin5.AttributePath.StepR\x05steps\x1a\x95\x01\n" +
	"\x04Step\x12'\n" +
	"\x0eattribute_name\x18\x01 \x01(\tH\x00R\rattributeName\x12.\n" +
	"\x12element_key_string\x18\x02 \x01(\tH\x00R\x10elementKeyString\x12(\n" +
	"\x0felement_key_int\x18\x03 \x01(\x03H\x00R\relementKeyIntB\n" +
	"\n" +
	"\bselector\"3\n" +
	"\x04Stop\x1a\t\n" +
	"\aRequest\x1a \n" +
	"\bResponse\x12\x14\n" +
	"\x05Error\x18\x01 \x01(\tR\x05Error\"\x96\x01\n" +
	"\bRawState\x12\x12\n" +
	"\x04json\x18\x01 \x01(\fR\x04json\x12:\n" +
	"\aflatmap\x18\x02 \x03(\v2 .tfplugin5.RawState.FlatmapEntryR\aflatmap\x1a:\n" +
	"\fFlatmapEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"\xd8\x02\n" +
	"\x16ResourceIdentitySchema\x12\x18\n" +
	"\aversion\x18\x01 \x01(\x03R\aversion\x12d\n" +
	"\x13identity_attributes\x18\x02 \x03(\v23.tfplugin5.ResourceIdentitySchema.IdentityAttributeR\x12identityAttributes\x1a\xbd\x01\n" +
	"\x11IdentityAttribute\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x12\n" +
	"\x04type\x18\x02 \x01(\fR\x04type\x12.\n" +
	"\x13required_for_import\x18\x03 \x01(\bR\x11requiredForImport\x12.\n" +
	"\x13optional_for_import\x18\x04 \x01(\bR\x11optionalForImport\x12 \n" +
	"\vdescription\x18\x05 \x01(\tR\vdescription\"T\n" +
	"\x14ResourceIdentityData\x12<\n" +
	"\ridentity_data\x18\x01 \x01(\v2\x17.tfplugin5.DynamicValueR\fidentityData\"9\n" +
	"\fActionSchema\x12)\n" +
	"\x06schema\x18\x01 \x01(\v2\x11.tfplugin5.SchemaR\x06schema\"\xeb\a\n" +
	"\x06Schema\x12\x18\n" +
	"\aversion\x18\x01 \x01(\x03R\aversion\x12-\n" +
	"\x05block\x18\x02 \x01(\v2\x17.tfplugin5.Schema.BlockR\x05block\x1a\xa2\x02\n" +
	"\x05Block\x12\x18\n" +
	"\aversion\x18\x01 \x01(\x03R\aversion\x12;\n" +
	"\n" +
	"attributes\x18\x02 \x03(\v2\x1b.tfplugin5.Schema.AttributeR\n" +
	"attributes\x12>\n" +
	"\vblock_types\x18\x03 \x03(\v2\x1d.tfplugin5.Schema.NestedBlockR\n" +
	"blockTypes\x12 \n" +
	"\vdescription\x18\x04 \x01(\tR\vdescription\x12@\n" +
	"\x10description_kind\x18\x05 \x01(\x0e2\x15.tfplugin5.StringKindR\x0fdescriptionKind\x12\x1e\n" +
	"\n" +
	"deprecated\x18\x06 \x01(\bR\n" +
	"deprecated\x1a\xc8\x02\n" +
	"\tAttribute\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x12\n" +
	"\x04type\x18\x02 \x01(\fR\x04type\x12 \n" +
	"\vdescription\x18\x03 \x01(\tR\vdescription\x12\x1a\n" +
	"\brequired\x18\x04 \x01(\bR\brequired\x12\x1a\n" +
	"\boptional\x18\x05 \x01(\bR\boptional\x12\x1a\n" +
	"\bcomputed\x18\x06 \x01(\bR\bcomputed\x12\x1c\n" +
	"\tsensitive\x18\a \x01(\bR\tsensitive\x12@\n" +
	"\x10description_kind\x18\b \x01(\x0e2\x15.tfplugin5.StringKindR\x0fdescriptionKind\x12\x1e\n" +
	"\n" +
	"deprecated\x18\t \x01(\bR\n" +
	"deprecated\x12\x1d\n" +
	"\n" +
	"write_only\x18\n" +
	" \x01(\bR\twriteOnly\x1a\xa7\x02\n" +
	"\vNestedBlock\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12-\n" +
	"\x05block\x18\x02 \x01(\v2\x17.tfplugin5.Schema.BlockR\x05block\x12C\n" +
	"\anesting\x18\x03 \x01(\x0e2).tfplugin5.Schema.NestedBlock.NestingModeR\anesting\x12\x1b\n" +
	"\tmin_items\x18\x04 \x01(\x03R\bminItems\x12\x1b\n" +
	"\tmax_items\x18\x05 \x01(\x03R\bmaxItems\"M\n" +
	"\vNestingMode\x12\v\n" +
	"\aINVALID\x10\x00\x12\n" +
	"\n" +
	"\x06SINGLE\x10\x01\x12\b\n" +
	"\x04LIST\x10\x02\x12\a\n" +
	"\x03SET\x10\x03\x12\a\n" +
	"\x03MAP\x10\x04\x12\t\n" +
	"\x05GROUP\x10\x05\"\x8e\x05\n" +
	"\bFunction\x12=\n" +
	"\n" +
	"parameters\x18\x01 \x03(\v2\x1d.tfplugin5.Function.ParameterR\n" +
	"parameters\x12L\n" +
	"\x12variadic_parameter\x18\x02 \x01(\v2\x1d.tfplugin5.Function.ParameterR\x11variadicParameter\x122\n" +
	"\x06return\x18\x03 \x01(\v2\x1a.tfplugin5.Function.ReturnR\x06return\x12\x18\n" +
	"\asummary\x18\x04 \x01(\tR\asummary\x12 \n" +
	"\vdescription\x18\x05 \x01(\tR\vdescription\x12@\n" +
	"\x10description_kind\x18\x06 \x01(\x0e2\x15.tfplugin5.StringKindR\x0fdescriptionKind\x12/\n" +
	"\x13deprecation_message\x18\a \x01(\tR\x12deprecationMessage\x1a\xf3\x01\n" +
	"\tParameter\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x12\n" +
	"\x04type\x18\x02 \x01(\fR\x04type\x12(\n" +
	"\x10allow_null_value\x18\x03 \x01(\bR\x0eallowNullValue\x120\n" +
	"\x14allow_unknown_values\x18\x04 \x01(\bR\x12allowUnknownValues\x12 \n" +
	"\vdescription\x18\x05 \x01(\tR\vdescription\x12@\n" +
	"\x10description_kind\x18\x06 \x01(\x0e2\x15.tfplugin5.StringKindR\x0fdescriptionKind\x1a\x1c\n" +
	"\x06Return\x12\x12\n" +
	"\x04type\x18\x01 \x01(\fR\x04type\"\xe2\x01\n" +
	"\x12ServerCapabilities\x12!\n" +
	"\fplan_destroy\x18\x01 \x01(\bR\vplanDestroy\x12?\n" +
	"\x1cget_provider_schema_optional\x18\x02 \x01(\bR\x19getProviderSchemaOptional\x12.\n" +
	"\x13move_resource_state\x18\x03 \x01(\bR\x11moveResourceState\x128\n" +
	"\x18generate_resource_config\x18\x04 \x01(\bR\x16generateResourceConfig\"\x82\x01\n" +
	"\x12ClientCapabilities\x12)\n" +
	"\x10deferral_allowed\x18\x01 \x01(\bR\x0fdeferralAllowed\x12A\n" +
	"\x1dwrite_only_attributes_allowed\x18\x02 \x01(\bR\x1awriteOnlyAttributesAllowed\"\xa2\x01\n" +
	"\bDeferred\x122\n" +
	"\x06reason\x18\x01 \x01(\x0e2\x1a.tfplugin5.Deferred.ReasonR\x06reason\"b\n" +
	"\x06Reason\x12\v\n" +
	"\aUNKNOWN\x10\x00\x12\x1b\n" +
	"\x17RESOURCE_CONFIG_UNKNOWN\x10\x01\x12\x1b\n" +
	"\x17PROVIDER_CONFIG_UNKNOWN\x10\x02\x12\x11\n" +
	"\rABSENT_PREREQ\x10\x03\"\x9c\a\n" +
	"\vGetMetadata\x1a\t\n" +
	"\aRequest\x1a\xdf\x04\n" +
	"\bResponse\x12N\n" +
	"\x13server_capabilities\x18\x01 \x01(\v2\x1d.tfplugin5.ServerCapabilitiesR\x12serverCapabilities\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\x12L\n" +
	"\fdata_sources\x18\x03 \x03(\v2).tfplugin5.GetMetadata.DataSourceMetadataR\vdataSources\x12E\n" +
	"\tresources\x18\x04 \x03(\v2'.tfplugin5.GetMetadata.ResourceMetadataR\tresources\x12E\n" +
	"\tfunctions\x18\x05 \x03(\v2'.tfplugin5.GetMetadata.FunctionMetadataR\tfunctions\x12Y\n" +
	"\x13ephemeral_resources\x18\x06 \x03(\v2(.tfplugin5.GetMetadata.EphemeralMetadataR\x12ephemeralResources\x12R\n" +
	"\x0elist_resources\x18\a \x03(\v2+.tfplugin5.GetMetadata.ListResourceMetadataR\rlistResources\x12?\n" +
	"\aactions\x18\b \x03(\v2%.tfplugin5.GetMetadata.ActionMetadataR\aactions\x1a0\n" +
	"\x11EphemeralMetadata\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x1a&\n" +
	"\x10FunctionMetadata\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x1a1\n" +
	"\x12DataSourceMetadata\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x1a/\n" +
	"\x10ResourceMetadata\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x1a3\n" +
	"\x14ListResourceMetadata\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x1a-\n" +
	"\x0eActionMetadata\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\"\xbc\v\n" +
	"\x11GetProviderSchema\x1a\t\n" +
	"\aRequest\x1a\x9b\v\n" +
	"\bResponse\x12-\n" +
	"\bprovider\x18\x01 \x01(\v2\x11.tfplugin5.SchemaR\bprovider\x12e\n" +
	"\x10resource_schemas\x18\x02 \x03(\v2:.tfplugin5.GetProviderSchema.Response.ResourceSchemasEntryR\x0fresourceSchemas\x12l\n" +
	"\x13data_source_schemas\x18\x03 \x03(\v2<.tfplugin5.GetProviderSchema.Response.DataSourceSchemasEntryR\x11dataSourceSchemas\x12R\n" +
	"\tfunctions\x18\a \x03(\v24.tfplugin5.GetProviderSchema.Response.FunctionsEntryR\tfunctions\x12\x81\x01\n" +
	"\x1aephemeral_resource_schemas\x18\b \x03(\v2C.tfplugin5.GetProviderSchema.Response.EphemeralResourceSchemasEntryR\x18ephemeralResourceSchemas\x12r\n" +
	"\x15list_resource_schemas\x18\t \x03(\v2>.tfplugin5.GetProviderSchema.Response.ListResourceSchemasEntryR\x13listResourceSchemas\x12_\n" +
	"\x0eaction_schemas\x18\v \x03(\v28.tfplugin5.GetProviderSchema.Response.ActionSchemasEntryR\ractionSchemas\x127\n" +
	"\vdiagnostics\x18\x04 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\x126\n" +
	"\rprovider_meta\x18\x05 \x01(\v2\x11.tfplugin5.SchemaR\fproviderMeta\x12N\n" +
	"\x13server_capabilities\x18\x06 \x01(\v2\x1d.tfplugin5.ServerCapabilitiesR\x12serverCapabilities\x1aU\n" +
	"\x14ResourceSchemasEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12'\n" +
	"\x05value\x18\x02 \x01(\v2\x11.tfplugin5.SchemaR\x05value:\x028\x01\x1aW\n" +
	"\x16DataSourceSchemasEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12'\n" +
	"\x05value\x18\x02 \x01(\v2\x11.tfplugin5.SchemaR\x05value:\x028\x01\x1aQ\n" +
	"\x0eFunctionsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12)\n" +
	"\x05value\x18\x02 \x01(\v2\x13.tfplugin5.FunctionR\x05value:\x028\x01\x1a^\n" +
	"\x1dEphemeralResourceSchemasEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12'\n" +
	"\x05value\x18\x02 \x01(\v2\x11.tfplugin5.SchemaR\x05value:\x028\x01\x1aY\n" +
	"\x18ListResourceSchemasEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12'\n" +
	"\x05value\x18\x02 \x01(\v2\x11.tfplugin5.SchemaR\x05value:\x028\x01\x1aY\n" +
	"\x12ActionSchemasEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12-\n" +
	"\x05value\x18\x02 \x01(\v2\x17.tfplugin5.ActionSchemaR\x05value:\x028\x01J\x04\b\n" +
	"\x10\v\"\xdb\x01\n" +
	"\x15PrepareProviderConfig\x1a:\n" +
	"\aRequest\x12/\n" +
	"\x06config\x18\x01 \x01(\v2\x17.tfplugin5.DynamicValueR\x06config\x1a\x85\x01\n" +
	"\bResponse\x12@\n" +
	"\x0fprepared_config\x18\x01 \x01(\v2\x17.tfplugin5.DynamicValueR\x0epreparedConfig\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\"\x90\x02\n" +
	"\x14UpgradeResourceState\x1ar\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12\x18\n" +
	"\aversion\x18\x02 \x01(\x03R\aversion\x120\n" +
	"\traw_state\x18\x03 \x01(\v2\x13.tfplugin5.RawStateR\brawState\x1a\x83\x01\n" +
	"\bResponse\x12>\n" +
	"\x0eupgraded_state\x18\x01 \x01(\v2\x17.tfplugin5.DynamicValueR\rupgradedState\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\"\xc4\x02\n" +
	"\x1aGetResourceIdentitySchemas\x1a\t\n" +
	"\aRequest\x1a\x9a\x02\n" +
	"\bResponse\x12n\n" +
	"\x10identity_schemas\x18\x01 \x03(\v2C.tfplugin5.GetResourceIdentitySchemas.Response.IdentitySchemasEntryR\x0fidentitySchemas\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\x1ae\n" +
	"\x14IdentitySchemasEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x127\n" +
	"\x05value\x18\x02 \x01(\v2!.tfplugin5.ResourceIdentitySchemaR\x05value:\x028\x01\"\xa7\x02\n" +
	"\x17UpgradeResourceIdentity\x1ax\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12\x18\n" +
	"\aversion\x18\x02 \x01(\x03R\aversion\x126\n" +
	"\fraw_identity\x18\x03 \x01(\v2\x13.tfplugin5.RawStateR\vrawIdentity\x1a\x91\x01\n" +
	"\bResponse\x12L\n" +
	"\x11upgraded_identity\x18\x01 \x01(\v2\x1f.tfplugin5.ResourceIdentityDataR\x10upgradedIdentity\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\"\x8b\x02\n" +
	"\x1aValidateResourceTypeConfig\x1a\xa7\x01\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin5.DynamicValueR\x06config\x12N\n" +
	"\x13client_capabilities\x18\x03 \x01(\v2\x1d.tfplugin5.ClientCapabilitiesR\x12clientCapabilities\x1aC\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\"\xb8\x01\n" +
	"\x18ValidateDataSourceConfig\x1aW\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin5.DynamicValueR\x06config\x1aC\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\"\xbf\x01\n" +
	"\x1fValidateEphemeralResourceConfig\x1aW\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin5.DynamicValueR\x06config\x1aC\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\"\x8a\x02\n" +
	"\tConfigure\x1a\xb7\x01\n" +
	"\aRequest\x12+\n" +
	"\x11terraform_version\x18\x01 \x01(\tR\x10terraformVersion\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin5.DynamicValueR\x06config\x12N\n" +
	"\x13client_capabilities\x18\x03 \x01(\v2\x1d.tfplugin5.ClientCapabilitiesR\x12clientCapabilities\x1aC\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\"\xf4\x04\n" +
	"\fReadResource\x1a\xd8\x02\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12<\n" +
	"\rcurrent_state\x18\x02 \x01(\v2\x17.tfplugin5.DynamicValueR\fcurrentState\x12\x18\n" +
	"\aprivate\x18\x03 \x01(\fR\aprivate\x12<\n" +
	"\rprovider_meta\x18\x04 \x01(\v2\x17.tfplugin5.DynamicValueR\fproviderMeta\x12N\n" +
	"\x13client_capabilities\x18\x05 \x01(\v2\x1d.tfplugin5.ClientCapabilitiesR\x12clientCapabilities\x12J\n" +
	"\x10current_identity\x18\x06 \x01(\v2\x1f.tfplugin5.ResourceIdentityDataR\x0fcurrentIdentity\x1a\x88\x02\n" +
	"\bResponse\x124\n" +
	"\tnew_state\x18\x01 \x01(\v2\x17.tfplugin5.DynamicValueR\bnewState\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\x12\x18\n" +
	"\aprivate\x18\x03 \x01(\fR\aprivate\x12/\n" +
	"\bdeferred\x18\x04 \x01(\v2\x13.tfplugin5.DeferredR\bdeferred\x12B\n" +
	"\fnew_identity\x18\x05 \x01(\v2\x1f.tfplugin5.ResourceIdentityDataR\vnewIdentity\"\x87\a\n" +
	"\x12PlanResourceChange\x1a\xd3\x03\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x128\n" +
	"\vprior_state\x18\x02 \x01(\v2\x17.tfplugin5.DynamicValueR\n" +
	"priorState\x12E\n" +
	"\x12proposed_new_state\x18\x03 \x01(\v2\x17.tfplugin5.DynamicValueR\x10proposedNewState\x12/\n" +
	"\x06config\x18\x04 \x01(\v2\x17.tfplugin5.DynamicValueR\x06config\x12#\n" +
	"\rprior_private\x18\x05 \x01(\fR\fpriorPrivate\x12<\n" +
	"\rprovider_meta\x18\x06 \x01(\v2\x17.tfplugin5.DynamicValueR\fproviderMeta\x12N\n" +
	"\x13client_capabilities\x18\a \x01(\v2\x1d.tfplugin5.ClientCapabilitiesR\x12clientCapabilities\x12F\n" +
	"\x0eprior_identity\x18\b \x01(\v2\x1f.tfplugin5.ResourceIdentityDataR\rpriorIdentity\x1a\x9a\x03\n" +
	"\bResponse\x12<\n" +
	"\rplanned_state\x18\x01 \x01(\v2\x17.tfplugin5.DynamicValueR\fplannedState\x12C\n" +
	"\x10requires_replace\x18\x02 \x03(\v2\x18.tfplugin5.AttributePathR\x0frequiresReplace\x12'\n" +
	"\x0fplanned_private\x18\x03 \x01(\fR\x0eplannedPrivate\x127\n" +
	"\vdiagnostics\x18\x04 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\x12,\n" +
	"\x12legacy_type_system\x18\x05 \x01(\bR\x10legacyTypeSystem\x12/\n" +
	"\bdeferred\x18\x06 \x01(\v2\x13.tfplugin5.DeferredR\bdeferred\x12J\n" +
	"\x10planned_identity\x18\a \x01(\v2\x1f.tfplugin5.ResourceIdentityDataR\x0fplannedIdentity\"\xa2\x05\n" +
	"\x13ApplyResourceChange\x1a\x82\x03\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x128\n" +
	"\vprior_state\x18\x02 \x01(\v2\x17.tfplugin5.DynamicValueR\n" +
	"priorState\x12<\n" +
	"\rplanned_state\x18\x03 \x01(\v2\x17.tfplugin5.DynamicValueR\fplannedState\x12/\n" +
	"\x06config\x18\x04 \x01(\v2\x17.tfplugin5.DynamicValueR\x06config\x12'\n" +
	"\x0fplanned_private\x18\x05 \x01(\fR\x0eplannedPrivate\x12<\n" +
	"\rprovider_meta\x18\x06 \x01(\v2\x17.tfplugin5.DynamicValueR\fproviderMeta\x12J\n" +
	"\x10planned_identity\x18\a \x01(\v2\x1f.tfplugin5.ResourceIdentityDataR\x0fplannedIdentity\x1a\x85\x02\n" +
	"\bResponse\x124\n" +
	"\tnew_state\x18\x01 \x01(\v2\x17.tfplugin5.DynamicValueR\bnewState\x12\x18\n" +
	"\aprivate\x18\x02 \x01(\fR\aprivate\x127\n" +
	"\vdiagnostics\x18\x03 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\x12,\n" +
	"\x12legacy_type_system\x18\x04 \x01(\bR\x10legacyTypeSystem\x12B\n" +
	"\fnew_identity\x18\x05 \x01(\v2\x1f.tfplugin5.ResourceIdentityDataR\vnewIdentity\"\xea\x04\n" +
	"\x13ImportResourceState\x1a\xc3\x01\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12\x0e\n" +
	"\x02id\x18\x02 \x01(\tR\x02id\x12N\n" +
	"\x13client_capabilities\x18\x03 \x01(\v2\x1d.tfplugin5.ClientCapabilitiesR\x12clientCapabilities\x12;\n" +
	"\bidentity\x18\x04 \x01(\v2\x1f.tfplugin5.ResourceIdentityDataR\bidentity\x1a\xb5\x01\n" +
	"\x10ImportedResource\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12-\n" +
	"\x05state\x18\x02 \x01(\v2\x17.tfplugin5.DynamicValueR\x05state\x12\x18\n" +
	"\aprivate\x18\x03 \x01(\fR\aprivate\x12;\n" +
	"\bidentity\x18\x04 \x01(\v2\x1f.tfplugin5.ResourceIdentityDataR\bidentity\x1a\xd4\x01\n" +
	"\bResponse\x12^\n" +
	"\x12imported_resources\x18\x01 \x03(\v2/.tfplugin5.ImportResourceState.ImportedResourceR\x11importedResources\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\x12/\n" +
	"\bdeferred\x18\x03 \x01(\v2\x13.tfplugin5.DeferredR\bdeferred\"\xe5\x01\n" +
	"\x16GenerateResourceConfig\x1aU\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12-\n" +
	"\x05state\x18\x02 \x01(\v2\x17.tfplugin5.DynamicValueR\x05state\x1at\n" +
	"\bResponse\x12/\n" +
	"\x06config\x18\x01 \x01(\v2\x17.tfplugin5.DynamicValueR\x06config\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\"\xb4\x05\n" +
	"\x11MoveResourceState\x1a\xab\x03\n" +
	"\aRequest\x126\n" +
	"\x17source_provider_address\x18\x01 \x01(\tR\x15sourceProviderAddress\x12(\n" +
	"\x10source_type_name\x18\x02 \x01(\tR\x0esourceTypeName\x122\n" +
	"\x15source_schema_version\x18\x03 \x01(\x03R\x13sourceSchemaVersion\x126\n" +
	"\fsource_state\x18\x04 \x01(\v2\x13.tfplugin5.RawStateR\vsourceState\x12(\n" +
	"\x10target_type_name\x18\x05 \x01(\tR\x0etargetTypeName\x12%\n" +
	"\x0esource_private\x18\x06 \x01(\fR\rsourcePrivate\x12<\n" +
	"\x0fsource_identity\x18\a \x01(\v2\x13.tfplugin5.RawStateR\x0esourceIdentity\x12C\n" +
	"\x1esource_identity_schema_version\x18\b \x01(\x03R\x1bsourceIdentitySchemaVersion\x1a\xf0\x01\n" +
	"\bResponse\x12:\n" +
	"\ftarget_state\x18\x01 \x01(\v2\x17.tfplugin5.DynamicValueR\vtargetState\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\x12%\n" +
	"\x0etarget_private\x18\x03 \x01(\fR\rtargetPrivate\x12H\n" +
	"\x0ftarget_identity\x18\x04 \x01(\v2\x1f.tfplugin5.ResourceIdentityDataR\x0etargetIdentity\"\x9e\x03\n" +
	"\x0eReadDataSource\x1a\xe5\x01\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin5.DynamicValueR\x06config\x12<\n" +
	"\rprovider_meta\x18\x03 \x01(\v2\x17.tfplugin5.DynamicValueR\fproviderMeta\x12N\n" +
	"\x13client_capabilities\x18\x04 \x01(\v2\x1d.tfplugin5.ClientCapabilitiesR\x12clientCapabilities\x1a\xa3\x01\n" +
	"\bResponse\x12-\n" +
	"\x05state\x18\x01 \x01(\v2\x17.tfplugin5.DynamicValueR\x05state\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\x12/\n" +
	"\bdeferred\x18\x03 \x01(\v2\x13.tfplugin5.DeferredR\bdeferred\"\x9b\x01\n" +
	"\x14GetProvisionerSchema\x1a\t\n" +
	"\aRequest\x1ax\n" +
	"\bResponse\x123\n" +
	"\vprovisioner\x18\x01 \x01(\v2\x11.tfplugin5.SchemaR\vprovisioner\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\"\x9c\x01\n" +
	"\x19ValidateProvisionerConfig\x1a:\n" +
	"\aRequest\x12/\n" +
	"\x06config\x18\x01 \x01(\v2\x17.tfplugin5.DynamicValueR\x06config\x1aC\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\"\xe5\x01\n" +
	"\x11ProvisionResource\x1as\n" +
	"\aRequest\x12/\n" +
	"\x06config\x18\x01 \x01(\v2\x17.tfplugin5.DynamicValueR\x06config\x127\n" +
	"\n" +
	"connection\x18\x02 \x01(\v2\x17.tfplugin5.DynamicValueR\n" +
	"connection\x1a[\n" +
	"\bResponse\x12\x16\n" +
	"\x06output\x18\x01 \x01(\tR\x06output\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\"\xdd\x03\n" +
	"\x15OpenEphemeralResource\x1a\xa7\x01\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin5.DynamicValueR\x06config\x12N\n" +
	"\x13client_capabilities\x18\x03 \x01(\v2\x1d.tfplugin5.ClientCapabilitiesR\x12clientCapabilities\x1a\x99\x02\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\x12:\n" +
	"\brenew_at\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampH\x00R\arenewAt\x88\x01\x01\x12/\n" +
	"\x06result\x18\x03 \x01(\v2\x17.tfplugin5.DynamicValueR\x06result\x12\x1d\n" +
	"\aprivate\x18\x04 \x01(\fH\x01R\aprivate\x88\x01\x01\x12/\n" +
	"\bdeferred\x18\x05 \x01(\v2\x13.tfplugin5.DeferredR\bdeferredB\v\n" +
	"\t_renew_atB\n" +
	"\n" +
	"\b_private\"\xa5\x02\n" +
	"\x16RenewEphemeralResource\x1aQ\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12\x1d\n" +
	"\aprivate\x18\x02 \x01(\fH\x00R\aprivate\x88\x01\x01B\n" +
	"\n" +
	"\b_private\x1a\xb7\x01\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\x12:\n" +
	"\brenew_at\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampH\x00R\arenewAt\x88\x01\x01\x12\x1d\n" +
	"\aprivate\x18\x03 \x01(\fH\x01R\aprivate\x88\x01\x01B\v\n" +
	"\t_renew_atB\n" +
	"\n" +
	"\b_private\"\xb0\x01\n" +
	"\x16CloseEphemeralResource\x1aQ\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12\x1d\n" +
	"\aprivate\x18\x02 \x01(\fH\x00R\aprivate\x88\x01\x01B\n" +
	"\n" +
	"\b_private\x1aC\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\"\x81\x02\n" +
	"\fGetFunctions\x1a\t\n" +
	"\aRequest\x1a\xe5\x01\n" +
	"\bResponse\x12M\n" +
	"\tfunctions\x18\x01 \x03(\v2/.tfplugin5.GetFunctions.Response.FunctionsEntryR\tfunctions\x127\n" +
	"\vdiagnostics\x18\x02 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\x1aQ\n" +
	"\x0eFunctionsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12)\n" +
	"\x05value\x18\x02 \x01(\v2\x13.tfplugin5.FunctionR\x05value:\x028\x01\"\xd1\x01\n" +
	"\fCallFunction\x1aT\n" +
	"\aRequest\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x125\n" +
	"\targuments\x18\x02 \x03(\v2\x17.tfplugin5.DynamicValueR\targuments\x1ak\n" +
	"\bResponse\x12/\n" +
	"\x06result\x18\x01 \x01(\v2\x17.tfplugin5.DynamicValueR\x06result\x12.\n" +
	"\x05error\x18\x02 \x01(\v2\x18.tfplugin5.FunctionErrorR\x05error\"\xb2\x03\n" +
	"\fListResource\x1a\xa5\x01\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin5.DynamicValueR\x06config\x126\n" +
	"\x17include_resource_object\x18\x03 \x01(\bR\x15includeResourceObject\x12\x14\n" +
	"\x05limit\x18\x04 \x01(\x03R\x05limit\x1a\xf9\x01\n" +
	"\x05Event\x12;\n" +
	"\bidentity\x18\x01 \x01(\v2\x1f.tfplugin5.ResourceIdentityDataR\bidentity\x12!\n" +
	"\fdisplay_name\x18\x02 \x01(\tR\vdisplayName\x12E\n" +
	"\x0fresource_object\x18\x03 \x01(\v2\x17.tfplugin5.DynamicValueH\x00R\x0eresourceObject\x88\x01\x01\x125\n" +
	"\n" +
	"diagnostic\x18\x04 \x03(\v2\x15.tfplugin5.DiagnosticR\n" +
	"diagnosticB\x12\n" +
	"\x10_resource_object\"\xbb\x02\n" +
	"\x1aValidateListResourceConfig\x1a\xd7\x01\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin5.DynamicValueR\x06config\x12O\n" +
	"\x17include_resource_object\x18\x03 \x01(\v2\x17.tfplugin5.DynamicValueR\x15includeResourceObject\x12-\n" +
	"\x05limit\x18\x04 \x01(\v2\x17.tfplugin5.DynamicValueR\x05limit\x1aC\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\"\xb0\x02\n" +
	"\n" +
	"PlanAction\x1a\xab\x01\n" +
	"\aRequest\x12\x1f\n" +
	"\vaction_type\x18\x01 \x01(\tR\n" +
	"actionType\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin5.DynamicValueR\x06config\x12N\n" +
	"\x13client_capabilities\x18\x03 \x01(\v2\x1d.tfplugin5.ClientCapabilitiesR\x12clientCapabilities\x1at\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics\x12/\n" +
	"\bdeferred\x18\x02 \x01(\v2\x13.tfplugin5.DeferredR\bdeferred\"\xc9\x03\n" +
	"\fInvokeAction\x1a\xab\x01\n" +
	"\aRequest\x12\x1f\n" +
	"\vaction_type\x18\x01 \x01(\tR\n" +
	"actionType\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin5.DynamicValueR\x06config\x12N\n" +
	"\x13client_capabilities\x18\x03 \x01(\v2\x1d.tfplugin5.ClientCapabilitiesR\x12clientCapabilities\x1a\x8a\x02\n" +
	"\x05Event\x12D\n" +
	"\bprogress\x18\x01 \x01(\v2&.tfplugin5.InvokeAction.Event.ProgressH\x00R\bprogress\x12G\n" +
	"\tcompleted\x18\x02 \x01(\v2'.tfplugin5.InvokeAction.Event.CompletedH\x00R\tcompleted\x1a$\n" +
	"\bProgress\x12\x18\n" +
	"\amessage\x18\x01 \x01(\tR\amessage\x1aD\n" +
	"\tCompleted\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnosticsB\x06\n" +
	"\x04type\"\xb4\x01\n" +
	"\x14ValidateActionConfig\x1aW\n" +
	"\aRequest\x12\x1b\n" +
	"\ttype_name\x18\x01 \x01(\tR\btypeName\x12/\n" +
	"\x06config\x18\x02 \x01(\v2\x17.tfplugin5.DynamicValueR\x06config\x1aC\n" +
	"\bResponse\x127\n" +
	"\vdiagnostics\x18\x01 \x03(\v2\x15.tfplugin5.DiagnosticR\vdiagnostics*%\n" +
	"\n" +
	"StringKind\x12\t\n" +
	"\x05PLAIN\x10\x00\x12\f\n" +
	"\bMARKDOWN\x10\x012\x87\x16\n" +
	"\bProvider\x12N\n" +
	"\vGetMetadata\x12\x1e.tfplugin5.GetMetadata.Request\x1a\x1f.tfplugin5.GetMetadata.Response\x12X\n" +
	"\tGetSchema\x12$.tfplugin5.GetProviderSchema.Request\x1a%.tfplugin5.GetProviderSchema.Response\x12l\n" +
	"\x15PrepareProviderConfig\x12(.tfplugin5.PrepareProviderConfig.Request\x1a).tfplugin5.PrepareProviderConfig.Response\x12{\n" +
	"\x1aValidateResourceTypeConfig\x12-.tfplugin5.ValidateResourceTypeConfig.Request\x1a..tfplugin5.ValidateResourceTypeConfig.Response\x12u\n" +
	"\x18ValidateDataSourceConfig\x12+.tfplugin5.ValidateDataSourceConfig.Request\x1a,.tfplugin5.ValidateDataSourceConfig.Response\x12i\n" +
	"\x14UpgradeResourceState\x12'.tfplugin5.UpgradeResourceState.Request\x1a(.tfplugin5.UpgradeResourceState.Response\x12{\n" +
	"\x1aGetResourceIdentitySchemas\x12-.tfplugin5.GetResourceIdentitySchemas.Request\x1a..tfplugin5.GetResourceIdentitySchemas.Response\x12r\n" +
	"\x17UpgradeResourceIdentity\x12*.tfplugin5.UpgradeResourceIdentity.Request\x1a+.tfplugin5.UpgradeResourceIdentity.Response\x12H\n" +
	"\tConfigure\x12\x1c.tfplugin5.Configure.Request\x1a\x1d.tfplugin5.Configure.Response\x12Q\n" +
	"\fReadResource\x12\x1f.tfplugin5.ReadResource.Request\x1a .tfplugin5.ReadResource.Response\x12c\n" +
	"\x12PlanResourceChange\x12%.tfplugin5.PlanResourceChange.Request\x1a&.tfplugin5.PlanResourceChange.Response\x12f\n" +
	"\x13ApplyResourceChange\x12&.tfplugin5.ApplyResourceChange.Request\x1a'.tfplugin5.ApplyResourceChange.Response\x12f\n" +
	"\x13ImportResourceState\x12&.tfplugin5.ImportResourceState.Request\x1a'.tfplugin5.ImportResourceState.Response\x12`\n" +
	"\x11MoveResourceState\x12$.tfplugin5.MoveResourceState.Request\x1a%.tfplugin5.MoveResourceState.Response\x12W\n" +
	"\x0eReadDataSource\x12!.tfplugin5.ReadDataSource.Request\x1a\".tfplugin5.ReadDataSource.Response\x12o\n" +
	"\x16GenerateResourceConfig\x12).tfplugin5.GenerateResourceConfig.Request\x1a*.tfplugin5.GenerateResourceConfig.Response\x12\x8a\x01\n" +
	"\x1fValidateEphemeralResourceConfig\x122.tfplugin5.ValidateEphemeralResourceConfig.Request\x1a3.tfplugin5.ValidateEphemeralResourceConfig.Response\x12l\n" +
	"\x15OpenEphemeralResource\x12(.tfplugin5.OpenEphemeralResource.Request\x1a).tfplugin5.OpenEphemeralResource.Response\x12o\n" +
	"\x16RenewEphemeralResource\x12).tfplugin5.RenewEphemeralResource.Request\x1a*.tfplugin5.RenewEphemeralResource.Response\x12o\n" +
	"\x16CloseEphemeralResource\x12).tfplugin5.CloseEphemeralResource.Request\x1a*.tfplugin5.CloseEphemeralResource.Response\x12P\n" +
	"\fListResource\x12\x1f.tfplugin5.ListResource.Request\x1a\x1d.tfplugin5.ListResource.Event0\x01\x12{\n" +
	"\x1aValidateListResourceConfig\x12-.tfplugin5.ValidateListResourceConfig.Request\x1a..tfplugin5.ValidateListResourceConfig.Response\x12Q\n" +
	"\fGetFunctions\x12\x1f.tfplugin5.GetFunctions.Request\x1a .tfplugin5.GetFunctions.Response\x12Q\n" +
	"\fCallFunction\x12\x1f.tfplugin5.CallFunction.Request\x1a .tfplugin5.CallFunction.Response\x12K\n" +
	"\n" +
	"PlanAction\x12\x1d.tfplugin5.PlanAction.Request\x1a\x1e.tfplugin5.PlanAction.Response\x12P\n" +
	"\fInvokeAction\x12\x1f.tfplugin5.InvokeAction.Request\x1a\x1d.tfplugin5.InvokeAction.Event0\x01\x12i\n" +
	"\x14ValidateActionConfig\x12'.tfplugin5.ValidateActionConfig.Request\x1a(.tfplugin5.ValidateActionConfig.Response\x129\n" +
	"\x04Stop\x12\x17.tfplugin5.Stop.Request\x1a\x18.tfplugin5.Stop.Response2\x86\x03\n" +
	"\vProvisioner\x12^\n" +
	"\tGetSchema\x12'.tfplugin5.GetProvisionerSchema.Request\x1a(.tfplugin5.GetProvisionerSchema.Response\x12x\n" +
	"\x19ValidateProvisionerConfig\x12,.tfplugin5.ValidateProvisionerConfig.Request\x1a-.tfplugin5.ValidateProvisionerConfig.Response\x12b\n" +
	"\x11ProvisionResource\x12$.tfplugin5.ProvisionResource.Request\x1a%.tfplugin5.ProvisionResource.Response0\x01\x129\n" +
	"\x04Stop\x12\x17.tfplugin5.Stop.Request\x1a\x18.tfplugin5.Stop.ResponseB3Z1github.com/hashicorp/terraform/internal/tfplugin5b\x06proto3"

var (
	file_tfplugin5_proto_rawDescOnce sync.Once
	file_tfplugin5_proto_rawDescData []byte
)

func file_tfplugin5_proto_rawDescGZIP() []byte {
	file_tfplugin5_proto_rawDescOnce.Do(func() {
		file_tfplugin5_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_tfplugin5_proto_rawDesc), len(file_tfplugin5_proto_rawDesc)))
	})
	return file_tfplugin5_proto_rawDescData
}

var file_tfplugin5_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_tfplugin5_proto_msgTypes = make([]protoimpl.MessageInfo, 131)
var file_tfplugin5_proto_goTypes = []any{
	(StringKind)(0),                                  // 0: tfplugin5.StringKind
	(Diagnostic_Severity)(0),                         // 1: tfplugin5.Diagnostic.Severity
	(Schema_NestedBlock_NestingMode)(0),              // 2: tfplugin5.Schema.NestedBlock.NestingMode
	(Deferred_Reason)(0),                             // 3: tfplugin5.Deferred.Reason
	(*DynamicValue)(nil),                             // 4: tfplugin5.DynamicValue
	(*Diagnostic)(nil),                               // 5: tfplugin5.Diagnostic
	(*FunctionError)(nil),                            // 6: tfplugin5.FunctionError
	(*AttributePath)(nil),                            // 7: tfplugin5.AttributePath
	(*Stop)(nil),                                     // 8: tfplugin5.Stop
	(*RawState)(nil),                                 // 9: tfplugin5.RawState
	(*ResourceIdentitySchema)(nil),                   // 10: tfplugin5.ResourceIdentitySchema
	(*ResourceIdentityData)(nil),                     // 11: tfplugin5.ResourceIdentityData
	(*ActionSchema)(nil),                             // 12: tfplugin5.ActionSchema
	(*Schema)(nil),                                   // 13: tfplugin5.Schema
	(*Function)(nil),                                 // 14: tfplugin5.Function
	(*ServerCapabilities)(nil),                       // 15: tfplugin5.ServerCapabilities
	(*ClientCapabilities)(nil),                       // 16: tfplugin5.ClientCapabilities
	(*Deferred)(nil),                                 // 17: tfplugin5.Deferred
	(*GetMetadata)(nil),                              // 18: tfplugin5.GetMetadata
	(*GetProviderSchema)(nil),                        // 19: tfplugin5.GetProviderSchema
	(*PrepareProviderConfig)(nil),                    // 20: tfplugin5.PrepareProviderConfig
	(*UpgradeResourceState)(nil),                     // 21: tfplugin5.UpgradeResourceState
	(*GetResourceIdentitySchemas)(nil),               // 22: tfplugin5.GetResourceIdentitySchemas
	(*UpgradeResourceIdentity)(nil),                  // 23: tfplugin5.UpgradeResourceIdentity
	(*ValidateResourceTypeConfig)(nil),               // 24: tfplugin5.ValidateResourceTypeConfig
	(*ValidateDataSourceConfig)(nil),                 // 25: tfplugin5.ValidateDataSourceConfig
	(*ValidateEphemeralResourceConfig)(nil),          // 26: tfplugin5.ValidateEphemeralResourceConfig
	(*Configure)(nil),                                // 27: tfplugin5.Configure
	(*ReadResource)(nil),                             // 28: tfplugin5.ReadResource
	(*PlanResourceChange)(nil),                       // 29: tfplugin5.PlanResourceChange
	(*ApplyResourceChange)(nil),                      // 30: tfplugin5.ApplyResourceChange
	(*ImportResourceState)(nil),                      // 31: tfplugin5.ImportResourceState
	(*GenerateResourceConfig)(nil),                   // 32: tfplugin5.GenerateResourceConfig
	(*MoveResourceState)(nil),                        // 33: tfplugin5.MoveResourceState
	(*ReadDataSource)(nil),                           // 34: tfplugin5.ReadDataSource
	(*GetProvisionerSchema)(nil),                     // 35: tfplugin5.GetProvisionerSchema
	(*ValidateProvisionerConfig)(nil),                // 36: tfplugin5.ValidateProvisionerConfig
	(*ProvisionResource)(nil),                        // 37: tfplugin5.ProvisionResource
	(*OpenEphemeralResource)(nil),                    // 38: tfplugin5.OpenEphemeralResource
	(*RenewEphemeralResource)(nil),                   // 39: tfplugin5.RenewEphemeralResource
	(*CloseEphemeralResource)(nil),                   // 40: tfplugin5.CloseEphemeralResource
	(*GetFunctions)(nil),                             // 41: tfplugin5.GetFunctions
	(*CallFunction)(nil),                             // 42: tfplugin5.CallFunction
	(*ListResource)(nil),                             // 43: tfplugin5.ListResource
	(*ValidateListResourceConfig)(nil),               // 44: tfplugin5.ValidateListResourceConfig
	(*PlanAction)(nil),                               // 45: tfplugin5.PlanAction
	(*InvokeAction)(nil),                             // 46: tfplugin5.InvokeAction
	(*ValidateActionConfig)(nil),                     // 47: tfplugin5.ValidateActionConfig
	(*AttributePath_Step)(nil),                       // 48: tfplugin5.AttributePath.Step
	(*Stop_Request)(nil),                             // 49: tfplugin5.Stop.Request
	(*Stop_Response)(nil),                            // 50: tfplugin5.Stop.Response
	nil,                                              // 51: tfplugin5.RawState.FlatmapEntry
	(*ResourceIdentitySchema_IdentityAttribute)(nil), // 52: tfplugin5.ResourceIdentitySchema.IdentityAttribute
	(*Schema_Block)(nil),                             // 53: tfplugin5.Schema.Block
	(*Schema_Attribute)(nil),                         // 54: tfplugin5.Schema.Attribute
	(*Schema_NestedBlock)(nil),                       // 55: tfplugin5.Schema.NestedBlock
	(*Function_Parameter)(nil),                       // 56: tfplugin5.Function.Parameter
	(*Function_Return)(nil),                          // 57: tfplugin5.Function.Return
	(*GetMetadata_Request)(nil),                      // 58: tfplugin5.GetMetadata.Request
	(*GetMetadata_Response)(nil),                     // 59: tfplugin5.GetMetadata.Response
	(*GetMetadata_EphemeralMetadata)(nil),            // 60: tfplugin5.GetMetadata.EphemeralMetadata
	(*GetMetadata_FunctionMetadata)(nil),             // 61: tfplugin5.GetMetadata.FunctionMetadata
	(*GetMetadata_DataSourceMetadata)(nil),           // 62: tfplugin5.GetMetadata.DataSourceMetadata
	(*GetMetadata_ResourceMetadata)(nil),             // 63: tfplugin5.GetMetadata.ResourceMetadata
	(*GetMetadata_ListResourceMetadata)(nil),         // 64: tfplugin5.GetMetadata.ListResourceMetadata
	(*GetMetadata_ActionMetadata)(nil),               // 65: tfplugin5.GetMetadata.ActionMetadata
	(*GetProviderSchema_Request)(nil),                // 66: tfplugin5.GetProviderSchema.Request
	(*GetProviderSchema_Response)(nil),               // 67: tfplugin5.GetProviderSchema.Response
	nil,                                              // 68: tfplugin5.GetProviderSchema.Response.ResourceSchemasEntry
	nil,                                              // 69: tfplugin5.GetProviderSchema.Response.DataSourceSchemasEntry
	nil,                                              // 70: tfplugin5.GetProviderSchema.Response.FunctionsEntry
	nil,                                              // 71: tfplugin5.GetProviderSchema.Response.EphemeralResourceSchemasEntry
	nil,                                              // 72: tfplugin5.GetProviderSchema.Response.ListResourceSchemasEntry
	nil,                                              // 73: tfplugin5.GetProviderSchema.Response.ActionSchemasEntry
	(*PrepareProviderConfig_Request)(nil),            // 74: tfplugin5.PrepareProviderConfig.Request
	(*PrepareProviderConfig_Response)(nil),           // 75: tfplugin5.PrepareProviderConfig.Response
	(*UpgradeResourceState_Request)(nil),             // 76: tfplugin5.UpgradeResourceState.Request
	(*UpgradeResourceState_Response)(nil),            // 77: tfplugin5.UpgradeResourceState.Response
	(*GetResourceIdentitySchemas_Request)(nil),       // 78: tfplugin5.GetResourceIdentitySchemas.Request
	(*GetResourceIdentitySchemas_Response)(nil),      // 79: tfplugin5.GetResourceIdentitySchemas.Response
	nil,                                      // 80: tfplugin5.GetResourceIdentitySchemas.Response.IdentitySchemasEntry
	(*UpgradeResourceIdentity_Request)(nil),  // 81: tfplugin5.UpgradeResourceIdentity.Request
	(*UpgradeResourceIdentity_Response)(nil), // 82: tfplugin5.UpgradeResourceIdentity.Response
	(*ValidateResourceTypeConfig_Request)(nil),       // 83: tfplugin5.ValidateResourceTypeConfig.Request
	(*ValidateResourceTypeConfig_Response)(nil),      // 84: tfplugin5.ValidateResourceTypeConfig.Response
	(*ValidateDataSourceConfig_Request)(nil),         // 85: tfplugin5.ValidateDataSourceConfig.Request
	(*ValidateDataSourceConfig_Response)(nil),        // 86: tfplugin5.ValidateDataSourceConfig.Response
	(*ValidateEphemeralResourceConfig_Request)(nil),  // 87: tfplugin5.ValidateEphemeralResourceConfig.Request
	(*ValidateEphemeralResourceConfig_Response)(nil), // 88: tfplugin5.ValidateEphemeralResourceConfig.Response
	(*Configure_Request)(nil),                        // 89: tfplugin5.Configure.Request
	(*Configure_Response)(nil),                       // 90: tfplugin5.Configure.Response
	(*ReadResource_Request)(nil),                     // 91: tfplugin5.ReadResource.Request
	(*ReadResource_Response)(nil),                    // 92: tfplugin5.ReadResource.Response
	(*PlanResourceChange_Request)(nil),               // 93: tfplugin5.PlanResourceChange.Request
	(*PlanResourceChange_Response)(nil),              // 94: tfplugin5.PlanResourceChange.Response
	(*ApplyResourceChange_Request)(nil),              // 95: tfplugin5.ApplyResourceChange.Request
	(*ApplyResourceChange_Response)(nil),             // 96: tfplugin5.ApplyResourceChange.Response
	(*ImportResourceState_Request)(nil),              // 97: tfplugin5.ImportResourceState.Request
	(*ImportResourceState_ImportedResource)(nil),     // 98: tfplugin5.ImportResourceState.ImportedResource
	(*ImportResourceState_Response)(nil),             // 99: tfplugin5.ImportResourceState.Response
	(*GenerateResourceConfig_Request)(nil),           // 100: tfplugin5.GenerateResourceConfig.Request
	(*GenerateResourceConfig_Response)(nil),          // 101: tfplugin5.GenerateResourceConfig.Response
	(*MoveResourceState_Request)(nil),                // 102: tfplugin5.MoveResourceState.Request
	(*MoveResourceState_Response)(nil),               // 103: tfplugin5.MoveResourceState.Response
	(*ReadDataSource_Request)(nil),                   // 104: tfplugin5.ReadDataSource.Request
	(*ReadDataSource_Response)(nil),                  // 105: tfplugin5.ReadDataSource.Response
	(*GetProvisionerSchema_Request)(nil),             // 106: tfplugin5.GetProvisionerSchema.Request
	(*GetProvisionerSchema_Response)(nil),            // 107: tfplugin5.GetProvisionerSchema.Response
	(*ValidateProvisionerConfig_Request)(nil),        // 108: tfplugin5.ValidateProvisionerConfig.Request
	(*ValidateProvisionerConfig_Response)(nil),       // 109: tfplugin5.ValidateProvisionerConfig.Response
	(*ProvisionResource_Request)(nil),                // 110: tfplugin5.ProvisionResource.Request
	(*ProvisionResource_Response)(nil),               // 111: tfplugin5.ProvisionResource.Response
	(*OpenEphemeralResource_Request)(nil),            // 112: tfplugin5.OpenEphemeralResource.Request
	(*OpenEphemeralResource_Response)(nil),           // 113: tfplugin5.OpenEphemeralResource.Response
	(*RenewEphemeralResource_Request)(nil),           // 114: tfplugin5.RenewEphemeralResource.Request
	(*RenewEphemeralResource_Response)(nil),          // 115: tfplugin5.RenewEphemeralResource.Response
	(*CloseEphemeralResource_Request)(nil),           // 116: tfplugin5.CloseEphemeralResource.Request
	(*CloseEphemeralResource_Response)(nil),          // 117: tfplugin5.CloseEphemeralResource.Response
	(*GetFunctions_Request)(nil),                     // 118: tfplugin5.GetFunctions.Request
	(*GetFunctions_Response)(nil),                    // 119: tfplugin5.GetFunctions.Response
	nil,                                              // 120: tfplugin5.GetFunctions.Response.FunctionsEntry
	(*CallFunction_Request)(nil),                     // 121: tfplugin5.CallFunction.Request
	(*CallFunction_Response)(nil),                    // 122: tfplugin5.CallFunction.Response
	(*ListResource_Request)(nil),                     // 123: tfplugin5.ListResource.Request
	(*ListResource_Event)(nil),                       // 124: tfplugin5.ListResource.Event
	(*ValidateListResourceConfig_Request)(nil),       // 125: tfplugin5.ValidateListResourceConfig.Request
	(*ValidateListResourceConfig_Response)(nil),      // 126: tfplugin5.ValidateListResourceConfig.Response
	(*PlanAction_Request)(nil),                       // 127: tfplugin5.PlanAction.Request
	(*PlanAction_Response)(nil),                      // 128: tfplugin5.PlanAction.Response
	(*InvokeAction_Request)(nil),                     // 129: tfplugin5.InvokeAction.Request
	(*InvokeAction_Event)(nil),                       // 130: tfplugin5.InvokeAction.Event
	(*InvokeAction_Event_Progress)(nil),              // 131: tfplugin5.InvokeAction.Event.Progress
	(*InvokeAction_Event_Completed)(nil),             // 132: tfplugin5.InvokeAction.Event.Completed
	(*ValidateActionConfig_Request)(nil),             // 133: tfplugin5.ValidateActionConfig.Request
	(*ValidateActionConfig_Response)(nil),            // 134: tfplugin5.ValidateActionConfig.Response
	(*timestamppb.Timestamp)(nil),                    // 135: google.protobuf.Timestamp
}
var file_tfplugin5_proto_depIdxs = []int32{
	1,   // 0: tfplugin5.Diagnostic.severity:type_name -> tfplugin5.Diagnostic.Severity
	7,   // 1: tfplugin5.Diagnostic.attribute:type_name -> tfplugin5.AttributePath
	48,  // 2: tfplugin5.AttributePath.steps:type_name -> tfplugin5.AttributePath.Step
	51,  // 3: tfplugin5.RawState.flatmap:type_name -> tfplugin5.RawState.FlatmapEntry
	52,  // 4: tfplugin5.ResourceIdentitySchema.identity_attributes:type_name -> tfplugin5.ResourceIdentitySchema.IdentityAttribute
	4,   // 5: tfplugin5.ResourceIdentityData.identity_data:type_name -> tfplugin5.DynamicValue
	13,  // 6: tfplugin5.ActionSchema.schema:type_name -> tfplugin5.Schema
	53,  // 7: tfplugin5.Schema.block:type_name -> tfplugin5.Schema.Block
	56,  // 8: tfplugin5.Function.parameters:type_name -> tfplugin5.Function.Parameter
	56,  // 9: tfplugin5.Function.variadic_parameter:type_name -> tfplugin5.Function.Parameter
	57,  // 10: tfplugin5.Function.return:type_name -> tfplugin5.Function.Return
	0,   // 11: tfplugin5.Function.description_kind:type_name -> tfplugin5.StringKind
	3,   // 12: tfplugin5.Deferred.reason:type_name -> tfplugin5.Deferred.Reason
	54,  // 13: tfplugin5.Schema.Block.attributes:type_name -> tfplugin5.Schema.Attribute
	55,  // 14: tfplugin5.Schema.Block.block_types:type_name -> tfplugin5.Schema.NestedBlock
	0,   // 15: tfplugin5.Schema.Block.description_kind:type_name -> tfplugin5.StringKind
	0,   // 16: tfplugin5.Schema.Attribute.description_kind:type_name -> tfplugin5.StringKind
	53,  // 17: tfplugin5.Schema.NestedBlock.block:type_name -> tfplugin5.Schema.Block
	2,   // 18: tfplugin5.Schema.NestedBlock.nesting:type_name -> tfplugin5.Schema.NestedBlock.NestingMode
	0,   // 19: tfplugin5.Function.Parameter.description_kind:type_name -> tfplugin5.StringKind
	15,  // 20: tfplugin5.GetMetadata.Response.server_capabilities:type_name -> tfplugin5.ServerCapabilities
	5,   // 21: tfplugin5.GetMetadata.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	62,  // 22: tfplugin5.GetMetadata.Response.data_sources:type_name -> tfplugin5.GetMetadata.DataSourceMetadata
	63,  // 23: tfplugin5.GetMetadata.Response.resources:type_name -> tfplugin5.GetMetadata.ResourceMetadata
	61,  // 24: tfplugin5.GetMetadata.Response.functions:type_name -> tfplugin5.GetMetadata.FunctionMetadata
	60,  // 25: tfplugin5.GetMetadata.Response.ephemeral_resources:type_name -> tfplugin5.GetMetadata.EphemeralMetadata
	64,  // 26: tfplugin5.GetMetadata.Response.list_resources:type_name -> tfplugin5.GetMetadata.ListResourceMetadata
	65,  // 27: tfplugin5.GetMetadata.Response.actions:type_name -> tfplugin5.GetMetadata.ActionMetadata
	13,  // 28: tfplugin5.GetProviderSchema.Response.provider:type_name -> tfplugin5.Schema
	68,  // 29: tfplugin5.GetProviderSchema.Response.resource_schemas:type_name -> tfplugin5.GetProviderSchema.Response.ResourceSchemasEntry
	69,  // 30: tfplugin5.GetProviderSchema.Response.data_source_schemas:type_name -> tfplugin5.GetProviderSchema.Response.DataSourceSchemasEntry
	70,  // 31: tfplugin5.GetProviderSchema.Response.functions:type_name -> tfplugin5.GetProviderSchema.Response.FunctionsEntry
	71,  // 32: tfplugin5.GetProviderSchema.Response.ephemeral_resource_schemas:type_name -> tfplugin5.GetProviderSchema.Response.EphemeralResourceSchemasEntry
	72,  // 33: tfplugin5.GetProviderSchema.Response.list_resource_schemas:type_name -> tfplugin5.GetProviderSchema.Response.ListResourceSchemasEntry
	73,  // 34: tfplugin5.GetProviderSchema.Response.action_schemas:type_name -> tfplugin5.GetProviderSchema.Response.ActionSchemasEntry
	5,   // 35: tfplugin5.GetProviderSchema.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	13,  // 36: tfplugin5.GetProviderSchema.Response.provider_meta:type_name -> tfplugin5.Schema
	15,  // 37: tfplugin5.GetProviderSchema.Response.server_capabilities:type_name -> tfplugin5.ServerCapabilities
	13,  // 38: tfplugin5.GetProviderSchema.Response.ResourceSchemasEntry.value:type_name -> tfplugin5.Schema
	13,  // 39: tfplugin5.GetProviderSchema.Response.DataSourceSchemasEntry.value:type_name -> tfplugin5.Schema
	14,  // 40: tfplugin5.GetProviderSchema.Response.FunctionsEntry.value:type_name -> tfplugin5.Function
	13,  // 41: tfplugin5.GetProviderSchema.Response.EphemeralResourceSchemasEntry.value:type_name -> tfplugin5.Schema
	13,  // 42: tfplugin5.GetProviderSchema.Response.ListResourceSchemasEntry.value:type_name -> tfplugin5.Schema
	12,  // 43: tfplugin5.GetProviderSchema.Response.ActionSchemasEntry.value:type_name -> tfplugin5.ActionSchema
	4,   // 44: tfplugin5.PrepareProviderConfig.Request.config:type_name -> tfplugin5.DynamicValue
	4,   // 45: tfplugin5.PrepareProviderConfig.Response.prepared_config:type_name -> tfplugin5.DynamicValue
	5,   // 46: tfplugin5.PrepareProviderConfig.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	9,   // 47: tfplugin5.UpgradeResourceState.Request.raw_state:type_name -> tfplugin5.RawState
	4,   // 48: tfplugin5.UpgradeResourceState.Response.upgraded_state:type_name -> tfplugin5.DynamicValue
	5,   // 49: tfplugin5.UpgradeResourceState.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	80,  // 50: tfplugin5.GetResourceIdentitySchemas.Response.identity_schemas:type_name -> tfplugin5.GetResourceIdentitySchemas.Response.IdentitySchemasEntry
	5,   // 51: tfplugin5.GetResourceIdentitySchemas.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	10,  // 52: tfplugin5.GetResourceIdentitySchemas.Response.IdentitySchemasEntry.value:type_name -> tfplugin5.ResourceIdentitySchema
	9,   // 53: tfplugin5.UpgradeResourceIdentity.Request.raw_identity:type_name -> tfplugin5.RawState
	11,  // 54: tfplugin5.UpgradeResourceIdentity.Response.upgraded_identity:type_name -> tfplugin5.ResourceIdentityData
	5,   // 55: tfplugin5.UpgradeResourceIdentity.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	4,   // 56: tfplugin5.ValidateResourceTypeConfig.Request.config:type_name -> tfplugin5.DynamicValue
	16,  // 57: tfplugin5.ValidateResourceTypeConfig.Request.client_capabilities:type_name -> tfplugin5.ClientCapabilities
	5,   // 58: tfplugin5.ValidateResourceTypeConfig.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	4,   // 59: tfplugin5.ValidateDataSourceConfig.Request.config:type_name -> tfplugin5.DynamicValue
	5,   // 60: tfplugin5.ValidateDataSourceConfig.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	4,   // 61: tfplugin5.ValidateEphemeralResourceConfig.Request.config:type_name -> tfplugin5.DynamicValue
	5,   // 62: tfplugin5.ValidateEphemeralResourceConfig.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	4,   // 63: tfplugin5.Configure.Request.config:type_name -> tfplugin5.DynamicValue
	16,  // 64: tfplugin5.Configure.Request.client_capabilities:type_name -> tfplugin5.ClientCapabilities
	5,   // 65: tfplugin5.Configure.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	4,   // 66: tfplugin5.ReadResource.Request.current_state:type_name -> tfplugin5.DynamicValue
	4,   // 67: tfplugin5.ReadResource.Request.provider_meta:type_name -> tfplugin5.DynamicValue
	16,  // 68: tfplugin5.ReadResource.Request.client_capabilities:type_name -> tfplugin5.ClientCapabilities
	11,  // 69: tfplugin5.ReadResource.Request.current_identity:type_name -> tfplugin5.ResourceIdentityData
	4,   // 70: tfplugin5.ReadResource.Response.new_state:type_name -> tfplugin5.DynamicValue
	5,   // 71: tfplugin5.ReadResource.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	17,  // 72: tfplugin5.ReadResource.Response.deferred:type_name -> tfplugin5.Deferred
	11,  // 73: tfplugin5.ReadResource.Response.new_identity:type_name -> tfplugin5.ResourceIdentityData
	4,   // 74: tfplugin5.PlanResourceChange.Request.prior_state:type_name -> tfplugin5.DynamicValue
	4,   // 75: tfplugin5.PlanResourceChange.Request.proposed_new_state:type_name -> tfplugin5.DynamicValue
	4,   // 76: tfplugin5.PlanResourceChange.Request.config:type_name -> tfplugin5.DynamicValue
	4,   // 77: tfplugin5.PlanResourceChange.Request.provider_meta:type_name -> tfplugin5.DynamicValue
	16,  // 78: tfplugin5.PlanResourceChange.Request.client_capabilities:type_name -> tfplugin5.ClientCapabilities
	11,  // 79: tfplugin5.PlanResourceChange.Request.prior_identity:type_name -> tfplugin5.ResourceIdentityData
	4,   // 80: tfplugin5.PlanResourceChange.Response.planned_state:type_name -> tfplugin5.DynamicValue
	7,   // 81: tfplugin5.PlanResourceChange.Response.requires_replace:type_name -> tfplugin5.AttributePath
	5,   // 82: tfplugin5.PlanResourceChange.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	17,  // 83: tfplugin5.PlanResourceChange.Response.deferred:type_name -> tfplugin5.Deferred
	11,  // 84: tfplugin5.PlanResourceChange.Response.planned_identity:type_name -> tfplugin5.ResourceIdentityData
	4,   // 85: tfplugin5.ApplyResourceChange.Request.prior_state:type_name -> tfplugin5.DynamicValue
	4,   // 86: tfplugin5.ApplyResourceChange.Request.planned_state:type_name -> tfplugin5.DynamicValue
	4,   // 87: tfplugin5.ApplyResourceChange.Request.config:type_name -> tfplugin5.DynamicValue
	4,   // 88: tfplugin5.ApplyResourceChange.Request.provider_meta:type_name -> tfplugin5.DynamicValue
	11,  // 89: tfplugin5.ApplyResourceChange.Request.planned_identity:type_name -> tfplugin5.ResourceIdentityData
	4,   // 90: tfplugin5.ApplyResourceChange.Response.new_state:type_name -> tfplugin5.DynamicValue
	5,   // 91: tfplugin5.ApplyResourceChange.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	11,  // 92: tfplugin5.ApplyResourceChange.Response.new_identity:type_name -> tfplugin5.ResourceIdentityData
	16,  // 93: tfplugin5.ImportResourceState.Request.client_capabilities:type_name -> tfplugin5.ClientCapabilities
	11,  // 94: tfplugin5.ImportResourceState.Request.identity:type_name -> tfplugin5.ResourceIdentityData
	4,   // 95: tfplugin5.ImportResourceState.ImportedResource.state:type_name -> tfplugin5.DynamicValue
	11,  // 96: tfplugin5.ImportResourceState.ImportedResource.identity:type_name -> tfplugin5.ResourceIdentityData
	98,  // 97: tfplugin5.ImportResourceState.Response.imported_resources:type_name -> tfplugin5.ImportResourceState.ImportedResource
	5,   // 98: tfplugin5.ImportResourceState.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	17,  // 99: tfplugin5.ImportResourceState.Response.deferred:type_name -> tfplugin5.Deferred
	4,   // 100: tfplugin5.GenerateResourceConfig.Request.state:type_name -> tfplugin5.DynamicValue
	4,   // 101: tfplugin5.GenerateResourceConfig.Response.config:type_name -> tfplugin5.DynamicValue
	5,   // 102: tfplugin5.GenerateResourceConfig.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	9,   // 103: tfplugin5.MoveResourceState.Request.source_state:type_name -> tfplugin5.RawState
	9,   // 104: tfplugin5.MoveResourceState.Request.source_identity:type_name -> tfplugin5.RawState
	4,   // 105: tfplugin5.MoveResourceState.Response.target_state:type_name -> tfplugin5.DynamicValue
	5,   // 106: tfplugin5.MoveResourceState.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	11,  // 107: tfplugin5.MoveResourceState.Response.target_identity:type_name -> tfplugin5.ResourceIdentityData
	4,   // 108: tfplugin5.ReadDataSource.Request.config:type_name -> tfplugin5.DynamicValue
	4,   // 109: tfplugin5.ReadDataSource.Request.provider_meta:type_name -> tfplugin5.DynamicValue
	16,  // 110: tfplugin5.ReadDataSource.Request.client_capabilities:type_name -> tfplugin5.ClientCapabilities
	4,   // 111: tfplugin5.ReadDataSource.Response.state:type_name -> tfplugin5.DynamicValue
	5,   // 112: tfplugin5.ReadDataSource.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	17,  // 113: tfplugin5.ReadDataSource.Response.deferred:type_name -> tfplugin5.Deferred
	13,  // 114: tfplugin5.GetProvisionerSchema.Response.provisioner:type_name -> tfplugin5.Schema
	5,   // 115: tfplugin5.GetProvisionerSchema.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	4,   // 116: tfplugin5.ValidateProvisionerConfig.Request.config:type_name -> tfplugin5.DynamicValue
	5,   // 117: tfplugin5.ValidateProvisionerConfig.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	4,   // 118: tfplugin5.ProvisionResource.Request.config:type_name -> tfplugin5.DynamicValue
	4,   // 119: tfplugin5.ProvisionResource.Request.connection:type_name -> tfplugin5.DynamicValue
	5,   // 120: tfplugin5.ProvisionResource.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	4,   // 121: tfplugin5.OpenEphemeralResource.Request.config:type_name -> tfplugin5.DynamicValue
	16,  // 122: tfplugin5.OpenEphemeralResource.Request.client_capabilities:type_name -> tfplugin5.ClientCapabilities
	5,   // 123: tfplugin5.OpenEphemeralResource.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	135, // 124: tfplugin5.OpenEphemeralResource.Response.renew_at:type_name -> google.protobuf.Timestamp
	4,   // 125: tfplugin5.OpenEphemeralResource.Response.result:type_name -> tfplugin5.DynamicValue
	17,  // 126: tfplugin5.OpenEphemeralResource.Response.deferred:type_name -> tfplugin5.Deferred
	5,   // 127: tfplugin5.RenewEphemeralResource.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	135, // 128: tfplugin5.RenewEphemeralResource.Response.renew_at:type_name -> google.protobuf.Timestamp
	5,   // 129: tfplugin5.CloseEphemeralResource.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	120, // 130: tfplugin5.GetFunctions.Response.functions:type_name -> tfplugin5.GetFunctions.Response.FunctionsEntry
	5,   // 131: tfplugin5.GetFunctions.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	14,  // 132: tfplugin5.GetFunctions.Response.FunctionsEntry.value:type_name -> tfplugin5.Function
	4,   // 133: tfplugin5.CallFunction.Request.arguments:type_name -> tfplugin5.DynamicValue
	4,   // 134: tfplugin5.CallFunction.Response.result:type_name -> tfplugin5.DynamicValue
	6,   // 135: tfplugin5.CallFunction.Response.error:type_name -> tfplugin5.FunctionError
	4,   // 136: tfplugin5.ListResource.Request.config:type_name -> tfplugin5.DynamicValue
	11,  // 137: tfplugin5.ListResource.Event.identity:type_name -> tfplugin5.ResourceIdentityData
	4,   // 138: tfplugin5.ListResource.Event.resource_object:type_name -> tfplugin5.DynamicValue
	5,   // 139: tfplugin5.ListResource.Event.diagnostic:type_name -> tfplugin5.Diagnostic
	4,   // 140: tfplugin5.ValidateListResourceConfig.Request.config:type_name -> tfplugin5.DynamicValue
	4,   // 141: tfplugin5.ValidateListResourceConfig.Request.include_resource_object:type_name -> tfplugin5.DynamicValue
	4,   // 142: tfplugin5.ValidateListResourceConfig.Request.limit:type_name -> tfplugin5.DynamicValue
	5,   // 143: tfplugin5.ValidateListResourceConfig.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	4,   // 144: tfplugin5.PlanAction.Request.config:type_name -> tfplugin5.DynamicValue
	16,  // 145: tfplugin5.PlanAction.Request.client_capabilities:type_name -> tfplugin5.ClientCapabilities
	5,   // 146: tfplugin5.PlanAction.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	17,  // 147: tfplugin5.PlanAction.Response.deferred:type_name -> tfplugin5.Deferred
	4,   // 148: tfplugin5.InvokeAction.Request.config:type_name -> tfplugin5.DynamicValue
	16,  // 149: tfplugin5.InvokeAction.Request.client_capabilities:type_name -> tfplugin5.ClientCapabilities
	131, // 150: tfplugin5.InvokeAction.Event.progress:type_name -> tfplugin5.InvokeAction.Event.Progress
	132, // 151: tfplugin5.InvokeAction.Event.completed:type_name -> tfplugin5.InvokeAction.Event.Completed
	5,   // 152: tfplugin5.InvokeAction.Event.Completed.diagnostics:type_name -> tfplugin5.Diagnostic
	4,   // 153: tfplugin5.ValidateActionConfig.Request.config:type_name -> tfplugin5.DynamicValue
	5,   // 154: tfplugin5.ValidateActionConfig.Response.diagnostics:type_name -> tfplugin5.Diagnostic
	58,  // 155: tfplugin5.Provider.GetMetadata:input_type -> tfplugin5.GetMetadata.Request
	66,  // 156: tfplugin5.Provider.GetSchema:input_type -> tfplugin5.GetProviderSchema.Request
	74,  // 157: tfplugin5.Provider.PrepareProviderConfig:input_type -> tfplugin5.PrepareProviderConfig.Request
	83,  // 158: tfplugin5.Provider.ValidateResourceTypeConfig:input_type -> tfplugin5.ValidateResourceTypeConfig.Request
	85,  // 159: tfplugin5.Provider.ValidateDataSourceConfig:input_type -> tfplugin5.ValidateDataSourceConfig.Request
	76,  // 160: tfplugin5.Provider.UpgradeResourceState:input_type -> tfplugin5.UpgradeResourceState.Request
	78,  // 161: tfplugin5.Provider.GetResourceIdentitySchemas:input_type -> tfplugin5.GetResourceIdentitySchemas.Request
	81,  // 162: tfplugin5.Provider.UpgradeResourceIdentity:input_type -> tfplugin5.UpgradeResourceIdentity.Request
	89,  // 163: tfplugin5.Provider.Configure:input_type -> tfplugin5.Configure.Request
	91,  // 164: tfplugin5.Provider.ReadResource:input_type -> tfplugin5.ReadResource.Request
	93,  // 165: tfplugin5.Provider.PlanResourceChange:input_type -> tfplugin5.PlanResourceChange.Request
	95,  // 166: tfplugin5.Provider.ApplyResourceChange:input_type -> tfplugin5.ApplyResourceChange.Request
	97,  // 167: tfplugin5.Provider.ImportResourceState:input_type -> tfplugin5.ImportResourceState.Request
	102, // 168: tfplugin5.Provider.MoveResourceState:input_type -> tfplugin5.MoveResourceState.Request
	104, // 169: tfplugin5.Provider.ReadDataSource:input_type -> tfplugin5.ReadDataSource.Request
	100, // 170: tfplugin5.Provider.GenerateResourceConfig:input_type -> tfplugin5.GenerateResourceConfig.Request
	87,  // 171: tfplugin5.Provider.ValidateEphemeralResourceConfig:input_type -> tfplugin5.ValidateEphemeralResourceConfig.Request
	112, // 172: tfplugin5.Provider.OpenEphemeralResource:input_type -> tfplugin5.OpenEphemeralResource.Request
	114, // 173: tfplugin5.Provider.RenewEphemeralResource:input_type -> tfplugin5.RenewEphemeralResource.Request
	116, // 174: tfplugin5.Provider.CloseEphemeralResource:input_type -> tfplugin5.CloseEphemeralResource.Request
	123, // 175: tfplugin5.Provider.ListResource:input_type -> tfplugin5.ListResource.Request
	125, // 176: tfplugin5.Provider.ValidateListResourceConfig:input_type -> tfplugin5.ValidateListResourceConfig.Request
	118, // 177: tfplugin5.Provider.GetFunctions:input_type -> tfplugin5.GetFunctions.Request
	121, // 178: tfplugin5.Provider.CallFunction:input_type -> tfplugin5.CallFunction.Request
	127, // 179: tfplugin5.Provider.PlanAction:input_type -> tfplugin5.PlanAction.Request
	129, // 180: tfplugin5.Provider.InvokeAction:input_type -> tfplugin5.InvokeAction.Request
	133, // 181: tfplugin5.Provider.ValidateActionConfig:input_type -> tfplugin5.ValidateActionConfig.Request
	49,  // 182: tfplugin5.Provider.Stop:input_type -> tfplugin5.Stop.Request
	106, // 183: tfplugin5.Provisioner.GetSchema:input_type -> tfplugin5.GetProvisionerSchema.Request
	108, // 184: tfplugin5.Provisioner.ValidateProvisionerConfig:input_type -> tfplugin5.ValidateProvisionerConfig.Request
	110, // 185: tfplugin5.Provisioner.ProvisionResource:input_type -> tfplugin5.ProvisionResource.Request
	49,  // 186: tfplugin5.Provisioner.Stop:input_type -> tfplugin5.Stop.Request
	59,  // 187: tfplugin5.Provider.GetMetadata:output_type -> tfplugin5.GetMetadata.Response
	67,  // 188: tfplugin5.Provider.GetSchema:output_type -> tfplugin5.GetProviderSchema.Response
	75,  // 189: tfplugin5.Provider.PrepareProviderConfig:output_type -> tfplugin5.PrepareProviderConfig.Response
	84,  // 190: tfplugin5.Provider.ValidateResourceTypeConfig:output_type -> tfplugin5.ValidateResourceTypeConfig.Response
	86,  // 191: tfplugin5.Provider.ValidateDataSourceConfig:output_type -> tfplugin5.ValidateDataSourceConfig.Response
	77,  // 192: tfplugin5.Provider.UpgradeResourceState:output_type -> tfplugin5.UpgradeResourceState.Response
	79,  // 193: tfplugin5.Provider.GetResourceIdentitySchemas:output_type -> tfplugin5.GetResourceIdentitySchemas.Response
	82,  // 194: tfplugin5.Provider.UpgradeResourceIdentity:output_type -> tfplugin5.UpgradeResourceIdentity.Response
	90,  // 195: tfplugin5.Provider.Configure:output_type -> tfplugin5.Configure.Response
	92,  // 196: tfplugin5.Provider.ReadResource:output_type -> tfplugin5.ReadResource.Response
	94,  // 197: tfplugin5.Provider.PlanResourceChange:output_type -> tfplugin5.PlanResourceChange.Response
	96,  // 198: tfplugin5.Provider.ApplyResourceChange:output_type -> tfplugin5.ApplyResourceChange.Response
	99,  // 199: tfplugin5.Provider.ImportResourceState:output_type -> tfplugin5.ImportResourceState.Response
	103, // 200: tfplugin5.Provider.MoveResourceState:output_type -> tfplugin5.MoveResourceState.Response
	105, // 201: tfplugin5.Provider.ReadDataSource:output_type -> tfplugin5.ReadDataSource.Response
	101, // 202: tfplugin5.Provider.GenerateResourceConfig:output_type -> tfplugin5.GenerateResourceConfig.Response
	88,  // 203: tfplugin5.Provider.ValidateEphemeralResourceConfig:output_type -> tfplugin5.ValidateEphemeralResourceConfig.Response
	113, // 204: tfplugin5.Provider.OpenEphemeralResource:output_type -> tfplugin5.OpenEphemeralResource.Response
	115, // 205: tfplugin5.Provider.RenewEphemeralResource:output_type -> tfplugin5.RenewEphemeralResource.Response
	117, // 206: tfplugin5.Provider.CloseEphemeralResource:output_type -> tfplugin5.CloseEphemeralResource.Response
	124, // 207: tfplugin5.Provider.ListResource:output_type -> tfplugin5.ListResource.Event
	126, // 208: tfplugin5.Provider.ValidateListResourceConfig:output_type -> tfplugin5.ValidateListResourceConfig.Response
	119, // 209: tfplugin5.Provider.GetFunctions:output_type -> tfplugin5.GetFunctions.Response
	122, // 210: tfplugin5.Provider.CallFunction:output_type -> tfplugin5.CallFunction.Response
	128, // 211: tfplugin5.Provider.PlanAction:output_type -> tfplugin5.PlanAction.Response
	130, // 212: tfplugin5.Provider.InvokeAction:output_type -> tfplugin5.InvokeAction.Event
	134, // 213: tfplugin5.Provider.ValidateActionConfig:output_type -> tfplugin5.ValidateActionConfig.Response
	50,  // 214: tfplugin5.Provider.Stop:output_type -> tfplugin5.Stop.Response
	107, // 215: tfplugin5.Provisioner.GetSchema:output_type -> tfplugin5.GetProvisionerSchema.Response
	109, // 216: tfplugin5.Provisioner.ValidateProvisionerConfig:output_type -> tfplugin5.ValidateProvisionerConfig.Response
	111, // 217: tfplugin5.Provisioner.ProvisionResource:output_type -> tfplugin5.ProvisionResource.Response
	50,  // 218: tfplugin5.Provisioner.Stop:output_type -> tfplugin5.Stop.Response
	187, // [187:219] is the sub-list for method output_type
	155, // [155:187] is the sub-list for method input_type
	155, // [155:155] is the sub-list for extension type_name
	155, // [155:155] is the sub-list for extension extendee
	0,   // [0:155] is the sub-list for field type_name
}

func init() { file_tfplugin5_proto_init() }
func file_tfplugin5_proto_init() {
	if File_tfplugin5_proto != nil {
		return
	}
	file_tfplugin5_proto_msgTypes[2].OneofWrappers = []any{}
	file_tfplugin5_proto_msgTypes[44].OneofWrappers = []any{
		(*AttributePath_Step_AttributeName)(nil),
		(*AttributePath_Step_ElementKeyString)(nil),
		(*AttributePath_Step_ElementKeyInt)(nil),
	}
	file_tfplugin5_proto_msgTypes[109].OneofWrappers = []any{}
	file_tfplugin5_proto_msgTypes[110].OneofWrappers = []any{}
	file_tfplugin5_proto_msgTypes[111].OneofWrappers = []any{}
	file_tfplugin5_proto_msgTypes[112].OneofWrappers = []any{}
	file_tfplugin5_proto_msgTypes[120].OneofWrappers = []any{}
	file_tfplugin5_proto_msgTypes[126].OneofWrappers = []any{
		(*InvokeAction_Event_Progress_)(nil),
		(*InvokeAction_Event_Completed_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_tfplugin5_proto_rawDesc), len(file_tfplugin5_proto_rawDesc)),
			NumEnums:      4,
			NumMessages:   131,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_tfplugin5_proto_goTypes,
		DependencyIndexes: file_tfplugin5_proto_depIdxs,
		EnumInfos:         file_tfplugin5_proto_enumTypes,
		MessageInfos:      file_tfplugin5_proto_msgTypes,
	}.Build()
	File_tfplugin5_proto = out.File
	file_tfplugin5_proto_goTypes = nil
	file_tfplugin5_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ProviderClient is the client API for Provider service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ProviderClient interface {
	// GetMetadata returns upfront information about server capabilities and
	// supported resource types without requiring the server to instantiate all
	// schema information, which may be memory intensive.
	// This method is CURRENTLY UNUSED and it serves mostly for convenience
	// of code generation inside of terraform-plugin-mux.
	GetMetadata(ctx context.Context, in *GetMetadata_Request, opts ...grpc.CallOption) (*GetMetadata_Response, error)
	// GetSchema returns schema information for the provider, data resources,
	// and managed resources.
	GetSchema(ctx context.Context, in *GetProviderSchema_Request, opts ...grpc.CallOption) (*GetProviderSchema_Response, error)
	PrepareProviderConfig(ctx context.Context, in *PrepareProviderConfig_Request, opts ...grpc.CallOption) (*PrepareProviderConfig_Response, error)
	ValidateResourceTypeConfig(ctx context.Context, in *ValidateResourceTypeConfig_Request, opts ...grpc.CallOption) (*ValidateResourceTypeConfig_Response, error)
	ValidateDataSourceConfig(ctx context.Context, in *ValidateDataSourceConfig_Request, opts ...grpc.CallOption) (*ValidateDataSourceConfig_Response, error)
	UpgradeResourceState(ctx context.Context, in *UpgradeResourceState_Request, opts ...grpc.CallOption) (*UpgradeResourceState_Response, error)
	// GetResourceIdentitySchemas returns the identity schemas for all managed
	// resources.
	GetResourceIdentitySchemas(ctx context.Context, in *GetResourceIdentitySchemas_Request, opts ...grpc.CallOption) (*GetResourceIdentitySchemas_Response, error)
	// UpgradeResourceIdentityData should return the upgraded resource identity
	// data for a managed resource type.
	UpgradeResourceIdentity(ctx context.Context, in *UpgradeResourceIdentity_Request, opts ...grpc.CallOption) (*UpgradeResourceIdentity_Response, error)
	// ////// One-time initialization, called before other functions below
	Configure(ctx context.Context, in *Configure_Request, opts ...grpc.CallOption) (*Configure_Response, error)
	// ////// Managed Resource Lifecycle
	ReadResource(ctx context.Context, in *ReadResource_Request, opts ...grpc.CallOption) (*ReadResource_Response, error)
	PlanResourceChange(ctx context.Context, in *PlanResourceChange_Request, opts ...grpc.CallOption) (*PlanResourceChange_Response, error)
	ApplyResourceChange(ctx context.Context, in *ApplyResourceChange_Request, opts ...grpc.CallOption) (*ApplyResourceChange_Response, error)
	ImportResourceState(ctx context.Context, in *ImportResourceState_Request, opts ...grpc.CallOption) (*ImportResourceState_Response, error)
	MoveResourceState(ctx context.Context, in *MoveResourceState_Request, opts ...grpc.CallOption) (*MoveResourceState_Response, error)
	ReadDataSource(ctx context.Context, in *ReadDataSource_Request, opts ...grpc.CallOption) (*ReadDataSource_Response, error)
	GenerateResourceConfig(ctx context.Context, in *GenerateResourceConfig_Request, opts ...grpc.CallOption) (*GenerateResourceConfig_Response, error)
	// ////// Ephemeral Resource Lifecycle
	ValidateEphemeralResourceConfig(ctx context.Context, in *ValidateEphemeralResourceConfig_Request, opts ...grpc.CallOption) (*ValidateEphemeralResourceConfig_Response, error)
	OpenEphemeralResource(ctx context.Context, in *OpenEphemeralResource_Request, opts ...grpc.CallOption) (*OpenEphemeralResource_Response, error)
	RenewEphemeralResource(ctx context.Context, in *RenewEphemeralResource_Request, opts ...grpc.CallOption) (*RenewEphemeralResource_Response, error)
	CloseEphemeralResource(ctx context.Context, in *CloseEphemeralResource_Request, opts ...grpc.CallOption) (*CloseEphemeralResource_Response, error)
	// ///// List
	ListResource(ctx context.Context, in *ListResource_Request, opts ...grpc.CallOption) (Provider_ListResourceClient, error)
	ValidateListResourceConfig(ctx context.Context, in *ValidateListResourceConfig_Request, opts ...grpc.CallOption) (*ValidateListResourceConfig_Response, error)
	// GetFunctions returns the definitions of all functions.
	GetFunctions(ctx context.Context, in *GetFunctions_Request, opts ...grpc.CallOption) (*GetFunctions_Response, error)
	// ////// Provider-contributed Functions
	CallFunction(ctx context.Context, in *CallFunction_Request, opts ...grpc.CallOption) (*CallFunction_Response, error)
	// ////// Actions
	PlanAction(ctx context.Context, in *PlanAction_Request, opts ...grpc.CallOption) (*PlanAction_Response, error)
	InvokeAction(ctx context.Context, in *InvokeAction_Request, opts ...grpc.CallOption) (Provider_InvokeActionClient, error)
	ValidateActionConfig(ctx context.Context, in *ValidateActionConfig_Request, opts ...grpc.CallOption) (*ValidateActionConfig_Response, error)
	// ////// Graceful Shutdown
	Stop(ctx context.Context, in *Stop_Request, opts ...grpc.CallOption) (*Stop_Response, error)
}

type providerClient struct {
	cc grpc.ClientConnInterface
}

func NewProviderClient(cc grpc.ClientConnInterface) ProviderClient {
	return &providerClient{cc}
}

func (c *providerClient) GetMetadata(ctx context.Context, in *GetMetadata_Request, opts ...grpc.CallOption) (*GetMetadata_Response, error) {
	out := new(GetMetadata_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/GetMetadata", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) GetSchema(ctx context.Context, in *GetProviderSchema_Request, opts ...grpc.CallOption) (*GetProviderSchema_Response, error) {
	out := new(GetProviderSchema_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/GetSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) PrepareProviderConfig(ctx context.Context, in *PrepareProviderConfig_Request, opts ...grpc.CallOption) (*PrepareProviderConfig_Response, error) {
	out := new(PrepareProviderConfig_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/PrepareProviderConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ValidateResourceTypeConfig(ctx context.Context, in *ValidateResourceTypeConfig_Request, opts ...grpc.CallOption) (*ValidateResourceTypeConfig_Response, error) {
	out := new(ValidateResourceTypeConfig_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/ValidateResourceTypeConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ValidateDataSourceConfig(ctx context.Context, in *ValidateDataSourceConfig_Request, opts ...grpc.CallOption) (*ValidateDataSourceConfig_Response, error) {
	out := new(ValidateDataSourceConfig_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/ValidateDataSourceConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) UpgradeResourceState(ctx context.Context, in *UpgradeResourceState_Request, opts ...grpc.CallOption) (*UpgradeResourceState_Response, error) {
	out := new(UpgradeResourceState_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/UpgradeResourceState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) GetResourceIdentitySchemas(ctx context.Context, in *GetResourceIdentitySchemas_Request, opts ...grpc.CallOption) (*GetResourceIdentitySchemas_Response, error) {
	out := new(GetResourceIdentitySchemas_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/GetResourceIdentitySchemas", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) UpgradeResourceIdentity(ctx context.Context, in *UpgradeResourceIdentity_Request, opts ...grpc.CallOption) (*UpgradeResourceIdentity_Response, error) {
	out := new(UpgradeResourceIdentity_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/UpgradeResourceIdentity", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) Configure(ctx context.Context, in *Configure_Request, opts ...grpc.CallOption) (*Configure_Response, error) {
	out := new(Configure_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/Configure", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ReadResource(ctx context.Context, in *ReadResource_Request, opts ...grpc.CallOption) (*ReadResource_Response, error) {
	out := new(ReadResource_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/ReadResource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) PlanResourceChange(ctx context.Context, in *PlanResourceChange_Request, opts ...grpc.CallOption) (*PlanResourceChange_Response, error) {
	out := new(PlanResourceChange_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/PlanResourceChange", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ApplyResourceChange(ctx context.Context, in *ApplyResourceChange_Request, opts ...grpc.CallOption) (*ApplyResourceChange_Response, error) {
	out := new(ApplyResourceChange_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/ApplyResourceChange", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ImportResourceState(ctx context.Context, in *ImportResourceState_Request, opts ...grpc.CallOption) (*ImportResourceState_Response, error) {
	out := new(ImportResourceState_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/ImportResourceState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) MoveResourceState(ctx context.Context, in *MoveResourceState_Request, opts ...grpc.CallOption) (*MoveResourceState_Response, error) {
	out := new(MoveResourceState_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/MoveResourceState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ReadDataSource(ctx context.Context, in *ReadDataSource_Request, opts ...grpc.CallOption) (*ReadDataSource_Response, error) {
	out := new(ReadDataSource_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/ReadDataSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) GenerateResourceConfig(ctx context.Context, in *GenerateResourceConfig_Request, opts ...grpc.CallOption) (*GenerateResourceConfig_Response, error) {
	out := new(GenerateResourceConfig_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/GenerateResourceConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ValidateEphemeralResourceConfig(ctx context.Context, in *ValidateEphemeralResourceConfig_Request, opts ...grpc.CallOption) (*ValidateEphemeralResourceConfig_Response, error) {
	out := new(ValidateEphemeralResourceConfig_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/ValidateEphemeralResourceConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) OpenEphemeralResource(ctx context.Context, in *OpenEphemeralResource_Request, opts ...grpc.CallOption) (*OpenEphemeralResource_Response, error) {
	out := new(OpenEphemeralResource_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/OpenEphemeralResource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) RenewEphemeralResource(ctx context.Context, in *RenewEphemeralResource_Request, opts ...grpc.CallOption) (*RenewEphemeralResource_Response, error) {
	out := new(RenewEphemeralResource_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/RenewEphemeralResource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) CloseEphemeralResource(ctx context.Context, in *CloseEphemeralResource_Request, opts ...grpc.CallOption) (*CloseEphemeralResource_Response, error) {
	out := new(CloseEphemeralResource_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/CloseEphemeralResource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) ListResource(ctx context.Context, in *ListResource_Request, opts ...grpc.CallOption) (Provider_ListResourceClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Provider_serviceDesc.Streams[0], "/tfplugin5.Provider/ListResource", opts...)
	if err != nil {
		return nil, err
	}
	x := &providerListResourceClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Provider_ListResourceClient interface {
	Recv() (*ListResource_Event, error)
	grpc.ClientStream
}

type providerListResourceClient struct {
	grpc.ClientStream
}

func (x *providerListResourceClient) Recv() (*ListResource_Event, error) {
	m := new(ListResource_Event)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *providerClient) ValidateListResourceConfig(ctx context.Context, in *ValidateListResourceConfig_Request, opts ...grpc.CallOption) (*ValidateListResourceConfig_Response, error) {
	out := new(ValidateListResourceConfig_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/ValidateListResourceConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) GetFunctions(ctx context.Context, in *GetFunctions_Request, opts ...grpc.CallOption) (*GetFunctions_Response, error) {
	out := new(GetFunctions_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/GetFunctions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) CallFunction(ctx context.Context, in *CallFunction_Request, opts ...grpc.CallOption) (*CallFunction_Response, error) {
	out := new(CallFunction_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/CallFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) PlanAction(ctx context.Context, in *PlanAction_Request, opts ...grpc.CallOption) (*PlanAction_Response, error) {
	out := new(PlanAction_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/PlanAction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) InvokeAction(ctx context.Context, in *InvokeAction_Request, opts ...grpc.CallOption) (Provider_InvokeActionClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Provider_serviceDesc.Streams[1], "/tfplugin5.Provider/InvokeAction", opts...)
	if err != nil {
		return nil, err
	}
	x := &providerInvokeActionClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Provider_InvokeActionClient interface {
	Recv() (*InvokeAction_Event, error)
	grpc.ClientStream
}

type providerInvokeActionClient struct {
	grpc.ClientStream
}

func (x *providerInvokeActionClient) Recv() (*InvokeAction_Event, error) {
	m := new(InvokeAction_Event)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *providerClient) ValidateActionConfig(ctx context.Context, in *ValidateActionConfig_Request, opts ...grpc.CallOption) (*ValidateActionConfig_Response, error) {
	out := new(ValidateActionConfig_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/ValidateActionConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *providerClient) Stop(ctx context.Context, in *Stop_Request, opts ...grpc.CallOption) (*Stop_Response, error) {
	out := new(Stop_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provider/Stop", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ProviderServer is the server API for Provider service.
type ProviderServer interface {
	// GetMetadata returns upfront information about server capabilities and
	// supported resource types without requiring the server to instantiate all
	// schema information, which may be memory intensive.
	// This method is CURRENTLY UNUSED and it serves mostly for convenience
	// of code generation inside of terraform-plugin-mux.
	GetMetadata(context.Context, *GetMetadata_Request) (*GetMetadata_Response, error)
	// GetSchema returns schema information for the provider, data resources,
	// and managed resources.
	GetSchema(context.Context, *GetProviderSchema_Request) (*GetProviderSchema_Response, error)
	PrepareProviderConfig(context.Context, *PrepareProviderConfig_Request) (*PrepareProviderConfig_Response, error)
	ValidateResourceTypeConfig(context.Context, *ValidateResourceTypeConfig_Request) (*ValidateResourceTypeConfig_Response, error)
	ValidateDataSourceConfig(context.Context, *ValidateDataSourceConfig_Request) (*ValidateDataSourceConfig_Response, error)
	UpgradeResourceState(context.Context, *UpgradeResourceState_Request) (*UpgradeResourceState_Response, error)
	// GetResourceIdentitySchemas returns the identity schemas for all managed
	// resources.
	GetResourceIdentitySchemas(context.Context, *GetResourceIdentitySchemas_Request) (*GetResourceIdentitySchemas_Response, error)
	// UpgradeResourceIdentityData should return the upgraded resource identity
	// data for a managed resource type.
	UpgradeResourceIdentity(context.Context, *UpgradeResourceIdentity_Request) (*UpgradeResourceIdentity_Response, error)
	// ////// One-time initialization, called before other functions below
	Configure(context.Context, *Configure_Request) (*Configure_Response, error)
	// ////// Managed Resource Lifecycle
	ReadResource(context.Context, *ReadResource_Request) (*ReadResource_Response, error)
	PlanResourceChange(context.Context, *PlanResourceChange_Request) (*PlanResourceChange_Response, error)
	ApplyResourceChange(context.Context, *ApplyResourceChange_Request) (*ApplyResourceChange_Response, error)
	ImportResourceState(context.Context, *ImportResourceState_Request) (*ImportResourceState_Response, error)
	MoveResourceState(context.Context, *MoveResourceState_Request) (*MoveResourceState_Response, error)
	ReadDataSource(context.Context, *ReadDataSource_Request) (*ReadDataSource_Response, error)
	GenerateResourceConfig(context.Context, *GenerateResourceConfig_Request) (*GenerateResourceConfig_Response, error)
	// ////// Ephemeral Resource Lifecycle
	ValidateEphemeralResourceConfig(context.Context, *ValidateEphemeralResourceConfig_Request) (*ValidateEphemeralResourceConfig_Response, error)
	OpenEphemeralResource(context.Context, *OpenEphemeralResource_Request) (*OpenEphemeralResource_Response, error)
	RenewEphemeralResource(context.Context, *RenewEphemeralResource_Request) (*RenewEphemeralResource_Response, error)
	CloseEphemeralResource(context.Context, *CloseEphemeralResource_Request) (*CloseEphemeralResource_Response, error)
	// ///// List
	ListResource(*ListResource_Request, Provider_ListResourceServer) error
	ValidateListResourceConfig(context.Context, *ValidateListResourceConfig_Request) (*ValidateListResourceConfig_Response, error)
	// GetFunctions returns the definitions of all functions.
	GetFunctions(context.Context, *GetFunctions_Request) (*GetFunctions_Response, error)
	// ////// Provider-contributed Functions
	CallFunction(context.Context, *CallFunction_Request) (*CallFunction_Response, error)
	// ////// Actions
	PlanAction(context.Context, *PlanAction_Request) (*PlanAction_Response, error)
	InvokeAction(*InvokeAction_Request, Provider_InvokeActionServer) error
	ValidateActionConfig(context.Context, *ValidateActionConfig_Request) (*ValidateActionConfig_Response, error)
	// ////// Graceful Shutdown
	Stop(context.Context, *Stop_Request) (*Stop_Response, error)
}

// UnimplementedProviderServer can be embedded to have forward compatible implementations.
type UnimplementedProviderServer struct {
}

func (*UnimplementedProviderServer) GetMetadata(context.Context, *GetMetadata_Request) (*GetMetadata_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMetadata not implemented")
}
func (*UnimplementedProviderServer) GetSchema(context.Context, *GetProviderSchema_Request) (*GetProviderSchema_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSchema not implemented")
}
func (*UnimplementedProviderServer) PrepareProviderConfig(context.Context, *PrepareProviderConfig_Request) (*PrepareProviderConfig_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PrepareProviderConfig not implemented")
}
func (*UnimplementedProviderServer) ValidateResourceTypeConfig(context.Context, *ValidateResourceTypeConfig_Request) (*ValidateResourceTypeConfig_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateResourceTypeConfig not implemented")
}
func (*UnimplementedProviderServer) ValidateDataSourceConfig(context.Context, *ValidateDataSourceConfig_Request) (*ValidateDataSourceConfig_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateDataSourceConfig not implemented")
}
func (*UnimplementedProviderServer) UpgradeResourceState(context.Context, *UpgradeResourceState_Request) (*UpgradeResourceState_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpgradeResourceState not implemented")
}
func (*UnimplementedProviderServer) GetResourceIdentitySchemas(context.Context, *GetResourceIdentitySchemas_Request) (*GetResourceIdentitySchemas_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetResourceIdentitySchemas not implemented")
}
func (*UnimplementedProviderServer) UpgradeResourceIdentity(context.Context, *UpgradeResourceIdentity_Request) (*UpgradeResourceIdentity_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpgradeResourceIdentity not implemented")
}
func (*UnimplementedProviderServer) Configure(context.Context, *Configure_Request) (*Configure_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Configure not implemented")
}
func (*UnimplementedProviderServer) ReadResource(context.Context, *ReadResource_Request) (*ReadResource_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReadResource not implemented")
}
func (*UnimplementedProviderServer) PlanResourceChange(context.Context, *PlanResourceChange_Request) (*PlanResourceChange_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PlanResourceChange not implemented")
}
func (*UnimplementedProviderServer) ApplyResourceChange(context.Context, *ApplyResourceChange_Request) (*ApplyResourceChange_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApplyResourceChange not implemented")
}
func (*UnimplementedProviderServer) ImportResourceState(context.Context, *ImportResourceState_Request) (*ImportResourceState_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportResourceState not implemented")
}
func (*UnimplementedProviderServer) MoveResourceState(context.Context, *MoveResourceState_Request) (*MoveResourceState_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MoveResourceState not implemented")
}
func (*UnimplementedProviderServer) ReadDataSource(context.Context, *ReadDataSource_Request) (*ReadDataSource_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReadDataSource not implemented")
}
func (*UnimplementedProviderServer) GenerateResourceConfig(context.Context, *GenerateResourceConfig_Request) (*GenerateResourceConfig_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateResourceConfig not implemented")
}
func (*UnimplementedProviderServer) ValidateEphemeralResourceConfig(context.Context, *ValidateEphemeralResourceConfig_Request) (*ValidateEphemeralResourceConfig_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateEphemeralResourceConfig not implemented")
}
func (*UnimplementedProviderServer) OpenEphemeralResource(context.Context, *OpenEphemeralResource_Request) (*OpenEphemeralResource_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method OpenEphemeralResource not implemented")
}
func (*UnimplementedProviderServer) RenewEphemeralResource(context.Context, *RenewEphemeralResource_Request) (*RenewEphemeralResource_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenewEphemeralResource not implemented")
}
func (*UnimplementedProviderServer) CloseEphemeralResource(context.Context, *CloseEphemeralResource_Request) (*CloseEphemeralResource_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CloseEphemeralResource not implemented")
}
func (*UnimplementedProviderServer) ListResource(*ListResource_Request, Provider_ListResourceServer) error {
	return status.Errorf(codes.Unimplemented, "method ListResource not implemented")
}
func (*UnimplementedProviderServer) ValidateListResourceConfig(context.Context, *ValidateListResourceConfig_Request) (*ValidateListResourceConfig_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateListResourceConfig not implemented")
}
func (*UnimplementedProviderServer) GetFunctions(context.Context, *GetFunctions_Request) (*GetFunctions_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFunctions not implemented")
}
func (*UnimplementedProviderServer) CallFunction(context.Context, *CallFunction_Request) (*CallFunction_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CallFunction not implemented")
}
func (*UnimplementedProviderServer) PlanAction(context.Context, *PlanAction_Request) (*PlanAction_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PlanAction not implemented")
}
func (*UnimplementedProviderServer) InvokeAction(*InvokeAction_Request, Provider_InvokeActionServer) error {
	return status.Errorf(codes.Unimplemented, "method InvokeAction not implemented")
}
func (*UnimplementedProviderServer) ValidateActionConfig(context.Context, *ValidateActionConfig_Request) (*ValidateActionConfig_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateActionConfig not implemented")
}
func (*UnimplementedProviderServer) Stop(context.Context, *Stop_Request) (*Stop_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Stop not implemented")
}

func RegisterProviderServer(s *grpc.Server, srv ProviderServer) {
	s.RegisterService(&_Provider_serviceDesc, srv)
}

func _Provider_GetMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMetadata_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).GetMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/GetMetadata",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).GetMetadata(ctx, req.(*GetMetadata_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_GetSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProviderSchema_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).GetSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/GetSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).GetSchema(ctx, req.(*GetProviderSchema_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_PrepareProviderConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PrepareProviderConfig_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).PrepareProviderConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/PrepareProviderConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).PrepareProviderConfig(ctx, req.(*PrepareProviderConfig_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ValidateResourceTypeConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateResourceTypeConfig_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ValidateResourceTypeConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/ValidateResourceTypeConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ValidateResourceTypeConfig(ctx, req.(*ValidateResourceTypeConfig_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ValidateDataSourceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateDataSourceConfig_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ValidateDataSourceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/ValidateDataSourceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ValidateDataSourceConfig(ctx, req.(*ValidateDataSourceConfig_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_UpgradeResourceState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpgradeResourceState_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).UpgradeResourceState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/UpgradeResourceState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).UpgradeResourceState(ctx, req.(*UpgradeResourceState_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_GetResourceIdentitySchemas_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetResourceIdentitySchemas_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).GetResourceIdentitySchemas(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/GetResourceIdentitySchemas",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).GetResourceIdentitySchemas(ctx, req.(*GetResourceIdentitySchemas_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_UpgradeResourceIdentity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpgradeResourceIdentity_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).UpgradeResourceIdentity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/UpgradeResourceIdentity",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).UpgradeResourceIdentity(ctx, req.(*UpgradeResourceIdentity_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_Configure_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Configure_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).Configure(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/Configure",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).Configure(ctx, req.(*Configure_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ReadResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadResource_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ReadResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/ReadResource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ReadResource(ctx, req.(*ReadResource_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_PlanResourceChange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PlanResourceChange_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).PlanResourceChange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/PlanResourceChange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).PlanResourceChange(ctx, req.(*PlanResourceChange_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ApplyResourceChange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplyResourceChange_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ApplyResourceChange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/ApplyResourceChange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ApplyResourceChange(ctx, req.(*ApplyResourceChange_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ImportResourceState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportResourceState_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ImportResourceState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/ImportResourceState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ImportResourceState(ctx, req.(*ImportResourceState_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_MoveResourceState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveResourceState_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).MoveResourceState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/MoveResourceState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).MoveResourceState(ctx, req.(*MoveResourceState_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ReadDataSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadDataSource_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ReadDataSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/ReadDataSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ReadDataSource(ctx, req.(*ReadDataSource_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_GenerateResourceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateResourceConfig_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).GenerateResourceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/GenerateResourceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).GenerateResourceConfig(ctx, req.(*GenerateResourceConfig_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ValidateEphemeralResourceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateEphemeralResourceConfig_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ValidateEphemeralResourceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/ValidateEphemeralResourceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ValidateEphemeralResourceConfig(ctx, req.(*ValidateEphemeralResourceConfig_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_OpenEphemeralResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OpenEphemeralResource_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).OpenEphemeralResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/OpenEphemeralResource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).OpenEphemeralResource(ctx, req.(*OpenEphemeralResource_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_RenewEphemeralResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenewEphemeralResource_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).RenewEphemeralResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/RenewEphemeralResource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).RenewEphemeralResource(ctx, req.(*RenewEphemeralResource_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_CloseEphemeralResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CloseEphemeralResource_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).CloseEphemeralResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/CloseEphemeralResource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).CloseEphemeralResource(ctx, req.(*CloseEphemeralResource_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_ListResource_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListResource_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ProviderServer).ListResource(m, &providerListResourceServer{stream})
}

type Provider_ListResourceServer interface {
	Send(*ListResource_Event) error
	grpc.ServerStream
}

type providerListResourceServer struct {
	grpc.ServerStream
}

func (x *providerListResourceServer) Send(m *ListResource_Event) error {
	return x.ServerStream.SendMsg(m)
}

func _Provider_ValidateListResourceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateListResourceConfig_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ValidateListResourceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/ValidateListResourceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ValidateListResourceConfig(ctx, req.(*ValidateListResourceConfig_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_GetFunctions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFunctions_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).GetFunctions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/GetFunctions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).GetFunctions(ctx, req.(*GetFunctions_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_CallFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CallFunction_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).CallFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/CallFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).CallFunction(ctx, req.(*CallFunction_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_PlanAction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PlanAction_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).PlanAction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/PlanAction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).PlanAction(ctx, req.(*PlanAction_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_InvokeAction_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(InvokeAction_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ProviderServer).InvokeAction(m, &providerInvokeActionServer{stream})
}

type Provider_InvokeActionServer interface {
	Send(*InvokeAction_Event) error
	grpc.ServerStream
}

type providerInvokeActionServer struct {
	grpc.ServerStream
}

func (x *providerInvokeActionServer) Send(m *InvokeAction_Event) error {
	return x.ServerStream.SendMsg(m)
}

func _Provider_ValidateActionConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateActionConfig_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).ValidateActionConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/ValidateActionConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).ValidateActionConfig(ctx, req.(*ValidateActionConfig_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provider_Stop_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Stop_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProviderServer).Stop(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provider/Stop",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProviderServer).Stop(ctx, req.(*Stop_Request))
	}
	return interceptor(ctx, in, info, handler)
}

var _Provider_serviceDesc = grpc.ServiceDesc{
	ServiceName: "tfplugin5.Provider",
	HandlerType: (*ProviderServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetMetadata",
			Handler:    _Provider_GetMetadata_Handler,
		},
		{
			MethodName: "GetSchema",
			Handler:    _Provider_GetSchema_Handler,
		},
		{
			MethodName: "PrepareProviderConfig",
			Handler:    _Provider_PrepareProviderConfig_Handler,
		},
		{
			MethodName: "ValidateResourceTypeConfig",
			Handler:    _Provider_ValidateResourceTypeConfig_Handler,
		},
		{
			MethodName: "ValidateDataSourceConfig",
			Handler:    _Provider_ValidateDataSourceConfig_Handler,
		},
		{
			MethodName: "UpgradeResourceState",
			Handler:    _Provider_UpgradeResourceState_Handler,
		},
		{
			MethodName: "GetResourceIdentitySchemas",
			Handler:    _Provider_GetResourceIdentitySchemas_Handler,
		},
		{
			MethodName: "UpgradeResourceIdentity",
			Handler:    _Provider_UpgradeResourceIdentity_Handler,
		},
		{
			MethodName: "Configure",
			Handler:    _Provider_Configure_Handler,
		},
		{
			MethodName: "ReadResource",
			Handler:    _Provider_ReadResource_Handler,
		},
		{
			MethodName: "PlanResourceChange",
			Handler:    _Provider_PlanResourceChange_Handler,
		},
		{
			MethodName: "ApplyResourceChange",
			Handler:    _Provider_ApplyResourceChange_Handler,
		},
		{
			MethodName: "ImportResourceState",
			Handler:    _Provider_ImportResourceState_Handler,
		},
		{
			MethodName: "MoveResourceState",
			Handler:    _Provider_MoveResourceState_Handler,
		},
		{
			MethodName: "ReadDataSource",
			Handler:    _Provider_ReadDataSource_Handler,
		},
		{
			MethodName: "GenerateResourceConfig",
			Handler:    _Provider_GenerateResourceConfig_Handler,
		},
		{
			MethodName: "ValidateEphemeralResourceConfig",
			Handler:    _Provider_ValidateEphemeralResourceConfig_Handler,
		},
		{
			MethodName: "OpenEphemeralResource",
			Handler:    _Provider_OpenEphemeralResource_Handler,
		},
		{
			MethodName: "RenewEphemeralResource",
			Handler:    _Provider_RenewEphemeralResource_Handler,
		},
		{
			MethodName: "CloseEphemeralResource",
			Handler:    _Provider_CloseEphemeralResource_Handler,
		},
		{
			MethodName: "ValidateListResourceConfig",
			Handler:    _Provider_ValidateListResourceConfig_Handler,
		},
		{
			MethodName: "GetFunctions",
			Handler:    _Provider_GetFunctions_Handler,
		},
		{
			MethodName: "CallFunction",
			Handler:    _Provider_CallFunction_Handler,
		},
		{
			MethodName: "PlanAction",
			Handler:    _Provider_PlanAction_Handler,
		},
		{
			MethodName: "ValidateActionConfig",
			Handler:    _Provider_ValidateActionConfig_Handler,
		},
		{
			MethodName: "Stop",
			Handler:    _Provider_Stop_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ListResource",
			Handler:       _Provider_ListResource_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "InvokeAction",
			Handler:       _Provider_InvokeAction_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "tfplugin5.proto",
}

// ProvisionerClient is the client API for Provisioner service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ProvisionerClient interface {
	GetSchema(ctx context.Context, in *GetProvisionerSchema_Request, opts ...grpc.CallOption) (*GetProvisionerSchema_Response, error)
	ValidateProvisionerConfig(ctx context.Context, in *ValidateProvisionerConfig_Request, opts ...grpc.CallOption) (*ValidateProvisionerConfig_Response, error)
	ProvisionResource(ctx context.Context, in *ProvisionResource_Request, opts ...grpc.CallOption) (Provisioner_ProvisionResourceClient, error)
	Stop(ctx context.Context, in *Stop_Request, opts ...grpc.CallOption) (*Stop_Response, error)
}

type provisionerClient struct {
	cc grpc.ClientConnInterface
}

func NewProvisionerClient(cc grpc.ClientConnInterface) ProvisionerClient {
	return &provisionerClient{cc}
}

func (c *provisionerClient) GetSchema(ctx context.Context, in *GetProvisionerSchema_Request, opts ...grpc.CallOption) (*GetProvisionerSchema_Response, error) {
	out := new(GetProvisionerSchema_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provisioner/GetSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *provisionerClient) ValidateProvisionerConfig(ctx context.Context, in *ValidateProvisionerConfig_Request, opts ...grpc.CallOption) (*ValidateProvisionerConfig_Response, error) {
	out := new(ValidateProvisionerConfig_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provisioner/ValidateProvisionerConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *provisionerClient) ProvisionResource(ctx context.Context, in *ProvisionResource_Request, opts ...grpc.CallOption) (Provisioner_ProvisionResourceClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Provisioner_serviceDesc.Streams[0], "/tfplugin5.Provisioner/ProvisionResource", opts...)
	if err != nil {
		return nil, err
	}
	x := &provisionerProvisionResourceClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Provisioner_ProvisionResourceClient interface {
	Recv() (*ProvisionResource_Response, error)
	grpc.ClientStream
}

type provisionerProvisionResourceClient struct {
	grpc.ClientStream
}

func (x *provisionerProvisionResourceClient) Recv() (*ProvisionResource_Response, error) {
	m := new(ProvisionResource_Response)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *provisionerClient) Stop(ctx context.Context, in *Stop_Request, opts ...grpc.CallOption) (*Stop_Response, error) {
	out := new(Stop_Response)
	err := c.cc.Invoke(ctx, "/tfplugin5.Provisioner/Stop", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ProvisionerServer is the server API for Provisioner service.
type ProvisionerServer interface {
	GetSchema(context.Context, *GetProvisionerSchema_Request) (*GetProvisionerSchema_Response, error)
	ValidateProvisionerConfig(context.Context, *ValidateProvisionerConfig_Request) (*ValidateProvisionerConfig_Response, error)
	ProvisionResource(*ProvisionResource_Request, Provisioner_ProvisionResourceServer) error
	Stop(context.Context, *Stop_Request) (*Stop_Response, error)
}

// UnimplementedProvisionerServer can be embedded to have forward compatible implementations.
type UnimplementedProvisionerServer struct {
}

func (*UnimplementedProvisionerServer) GetSchema(context.Context, *GetProvisionerSchema_Request) (*GetProvisionerSchema_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSchema not implemented")
}
func (*UnimplementedProvisionerServer) ValidateProvisionerConfig(context.Context, *ValidateProvisionerConfig_Request) (*ValidateProvisionerConfig_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateProvisionerConfig not implemented")
}
func (*UnimplementedProvisionerServer) ProvisionResource(*ProvisionResource_Request, Provisioner_ProvisionResourceServer) error {
	return status.Errorf(codes.Unimplemented, "method ProvisionResource not implemented")
}
func (*UnimplementedProvisionerServer) Stop(context.Context, *Stop_Request) (*Stop_Response, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Stop not implemented")
}

func RegisterProvisionerServer(s *grpc.Server, srv ProvisionerServer) {
	s.RegisterService(&_Provisioner_serviceDesc, srv)
}

func _Provisioner_GetSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProvisionerSchema_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProvisionerServer).GetSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provisioner/GetSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProvisionerServer).GetSchema(ctx, req.(*GetProvisionerSchema_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provisioner_ValidateProvisionerConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateProvisionerConfig_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProvisionerServer).ValidateProvisionerConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provisioner/ValidateProvisionerConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProvisionerServer).ValidateProvisionerConfig(ctx, req.(*ValidateProvisionerConfig_Request))
	}
	return interceptor(ctx, in, info, handler)
}

func _Provisioner_ProvisionResource_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ProvisionResource_Request)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ProvisionerServer).ProvisionResource(m, &provisionerProvisionResourceServer{stream})
}

type Provisioner_ProvisionResourceServer interface {
	Send(*ProvisionResource_Response) error
	grpc.ServerStream
}

type provisionerProvisionResourceServer struct {
	grpc.ServerStream
}

func (x *provisionerProvisionResourceServer) Send(m *ProvisionResource_Response) error {
	return x.ServerStream.SendMsg(m)
}

func _Provisioner_Stop_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Stop_Request)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProvisionerServer).Stop(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tfplugin5.Provisioner/Stop",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProvisionerServer).Stop(ctx, req.(*Stop_Request))
	}
	return interceptor(ctx, in, info, handler)
}

var _Provisioner_serviceDesc = grpc.ServiceDesc{
	ServiceName: "tfplugin5.Provisioner",
	HandlerType: (*ProvisionerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetSchema",
			Handler:    _Provisioner_GetSchema_Handler,
		},
		{
			MethodName: "ValidateProvisionerConfig",
			Handler:    _Provisioner_ValidateProvisionerConfig_Handler,
		},
		{
			MethodName: "Stop",
			Handler:    _Provisioner_Stop_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ProvisionResource",
			Handler:       _Provisioner_ProvisionResource_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "tfplugin5.proto",
}
