/*
 * Huffman codes derived from nghttp2's huff_sym_table.
 * Copyright (c) 2013 Tatsuhiro Tsujikawa
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
static const struct hpack_huffman_code hpack_huffman_table[] = {
    {0xffc00000, 13, 0},
    {0xffffb000, 23, 1},
    {0xfffffe20, 28, 2},
    {0xfffffe30, 28, 3},
    {0xfffffe40, 28, 4},
    {0xfffffe50, 28, 5},
    {0xfffffe60, 28, 6},
    {0xfffffe70, 28, 7},
    {0xfffffe80, 28, 8},
    {0xffffea00, 24, 9},
    {0xfffffff0, 30, 10},
    {0xfffffe90, 28, 11},
    {0xfffffea0, 28, 12},
    {0xfffffff4, 30, 13},
    {0xfffffeb0, 28, 14},
    {0xfffffec0, 28, 15},
    {0xfffffed0, 28, 16},
    {0xfffffee0, 28, 17},
    {0xfffffef0, 28, 18},
    {0xffffff00, 28, 19},
    {0xffffff10, 28, 20},
    {0xffffff20, 28, 21},
    {0xfffffff8, 30, 22},
    {0xffffff30, 28, 23},
    {0xffffff40, 28, 24},
    {0xffffff50, 28, 25},
    {0xffffff60, 28, 26},
    {0xffffff70, 28, 27},
    {0xffffff80, 28, 28},
    {0xffffff90, 28, 29},
    {0xffffffa0, 28, 30},
    {0xffffffb0, 28, 31},
    {0x50000000, 6, 32},
    {0xfe000000, 10, 33},
    {0xfe400000, 10, 34},
    {0xffa00000, 12, 35},
    {0xffc80000, 13, 36},
    {0x54000000, 6, 37},
    {0xf8000000, 8, 38},
    {0xff400000, 11, 39},
    {0xfe800000, 10, 40},
    {0xfec00000, 10, 41},
    {0xf9000000, 8, 42},
    {0xff600000, 11, 43},
    {0xfa000000, 8, 44},
    {0x58000000, 6, 45},
    {0x5c000000, 6, 46},
    {0x60000000, 6, 47},
    {0x00000000, 5, 48},
    {0x08000000, 5, 49},
    {0x10000000, 5, 50},
    {0x64000000, 6, 51},
    {0x68000000, 6, 52},
    {0x6c000000, 6, 53},
    {0x70000000, 6, 54},
    {0x74000000, 6, 55},
    {0x78000000, 6, 56},
    {0x7c000000, 6, 57},
    {0xb8000000, 7, 58},
    {0xfb000000, 8, 59},
    {0xfff80000, 15, 60},
    {0x80000000, 6, 61},
    {0xffb00000, 12, 62},
    {0xff000000, 10, 63},
    {0xffd00000, 13, 64},
    {0x84000000, 6, 65},
    {0xba000000, 7, 66},
    {0xbc000000, 7, 67},
    {0xbe000000, 7, 68},
    {0xc0000000, 7, 69},
    {0xc2000000, 7, 70},
    {0xc4000000, 7, 71},
    {0xc6000000, 7, 72},
    {0xc8000000, 7, 73},
    {0xca000000, 7, 74},
    {0xcc000000, 7, 75},
    {0xce000000, 7, 76},
    {0xd0000000, 7, 77},
    {0xd2000000, 7, 78},
    {0xd4000000, 7, 79},
    {0xd6000000, 7, 80},
    {0xd8000000, 7, 81},
    {0xda000000, 7, 82},
    {0xdc000000, 7, 83},
    {0xde000000, 7, 84},
    {0xe0000000, 7, 85},
    {0xe2000000, 7, 86},
    {0xe4000000, 7, 87},
    {0xfc000000, 8, 88},
    {0xe6000000, 7, 89},
    {0xfd000000, 8, 90},
    {0xffd80000, 13, 91},
    {0xfffe0000, 19, 92},
    {0xffe00000, 13, 93},
    {0xfff00000, 14, 94},
    {0x88000000, 6, 95},
    {0xfffa0000, 15, 96},
    {0x18000000, 5, 97},
    {0x8c000000, 6, 98},
    {0x20000000, 5, 99},
    {0x90000000, 6, 100},
    {0x28000000, 5, 101},
    {0x94000000, 6, 102},
    {0x98000000, 6, 103},
    {0x9c000000, 6, 104},
    {0x30000000, 5, 105},
    {0xe8000000, 7, 106},
    {0xea000000, 7, 107},
    {0xa0000000, 6, 108},
    {0xa4000000, 6, 109},
    {0xa8000000, 6, 110},
    {0x38000000, 5, 111},
    {0xac000000, 6, 112},
    {0xec000000, 7, 113},
    {0xb0000000, 6, 114},
    {0x40000000, 5, 115},
    {0x48000000, 5, 116},
    {0xb4000000, 6, 117},
    {0xee000000, 7, 118},
    {0xf0000000, 7, 119},
    {0xf2000000, 7, 120},
    {0xf4000000, 7, 121},
    {0xf6000000, 7, 122},
    {0xfffc0000, 15, 123},
    {0xff800000, 11, 124},
    {0xfff40000, 14, 125},
    {0xffe80000, 13, 126},
    {0xffffffc0, 28, 127},
    {0xfffe6000, 20, 128},
    {0xffff4800, 22, 129},
    {0xfffe7000, 20, 130},
    {0xfffe8000, 20, 131},
    {0xffff4c00, 22, 132},
    {0xffff5000, 22, 133},
    {0xffff5400, 22, 134},
    {0xffffb200, 23, 135},
    {0xffff5800, 22, 136},
    {0xffffb400, 23, 137},
    {0xffffb600, 23, 138},
    {0xffffb800, 23, 139},
    {0xffffba00, 23, 140},
    {0xffffbc00, 23, 141},
    {0xffffeb00, 24, 142},
    {0xffffbe00, 23, 143},
    {0xffffec00, 24, 144},
    {0xffffed00, 24, 145},
    {0xffff5c00, 22, 146},
    {0xffffc000, 23, 147},
    {0xffffee00, 24, 148},
    {0xffffc200, 23, 149},
    {0xffffc400, 23, 150},
    {0xffffc600, 23, 151},
    {0xffffc800, 23, 152},
    {0xfffee000, 21, 153},
    {0xffff6000, 22, 154},
    {0xffffca00, 23, 155},
    {0xffff6400, 22, 156},
    {0xffffcc00, 23, 157},
    {0xffffce00, 23, 158},
    {0xffffef00, 24, 159},
    {0xffff6800, 22, 160},
    {0xfffee800, 21, 161},
    {0xfffe9000, 20, 162},
    {0xffff6c00, 22, 163},
    {0xffff7000, 22, 164},
    {0xffffd000, 23, 165},
    {0xffffd200, 23, 166},
    {0xfffef000, 21, 167},
    {0xffffd400, 23, 168},
    {0xffff7400, 22, 169},
    {0xffff7800, 22, 170},
    {0xfffff000, 24, 171},
    {0xfffef800, 21, 172},
    {0xffff7c00, 22, 173},
    {0xffffd600, 23, 174},
    {0xffffd800, 23, 175},
    {0xffff0000, 21, 176},
    {0xffff0800, 21, 177},
    {0xffff8000, 22, 178},
    {0xffff1000, 21, 179},
    {0xffffda00, 23, 180},
    {0xffff8400, 22, 181},
    {0xffffdc00, 23, 182},
    {0xffffde00, 23, 183},
    {0xfffea000, 20, 184},
    {0xffff8800, 22, 185},
    {0xffff8c00, 22, 186},
    {0xffff9000, 22, 187},
    {0xffffe000, 23, 188},
    {0xffff9400, 22, 189},
    {0xffff9800, 22, 190},
    {0xffffe200, 23, 191},
    {0xfffff800, 26, 192},
    {0xfffff840, 26, 193},
    {0xfffeb000, 20, 194},
    {0xfffe2000, 19, 195},
    {0xffff9c00, 22, 196},
    {0xffffe400, 23, 197},
    {0xffffa000, 22, 198},
    {0xfffff600, 25, 199},
    {0xfffff880, 26, 200},
    {0xfffff8c0, 26, 201},
    {0xfffff900, 26, 202},
    {0xfffffbc0, 27, 203},
    {0xfffffbe0, 27, 204},
    {0xfffff940, 26, 205},
    {0xfffff100, 24, 206},
    {0xfffff680, 25, 207},
    {0xfffe4000, 19, 208},
    {0xffff1800, 21, 209},
    {0xfffff980, 26, 210},
    {0xfffffc00, 27, 211},
    {0xfffffc20, 27, 212},
    {0xfffff9c0, 26, 213},
    {0xfffffc40, 27, 214},
    {0xfffff200, 24, 215},
    {0xffff2000, 21, 216},
    {0xffff2800, 21, 217},
    {0xfffffa00, 26, 218},
    {0xfffffa40, 26, 219},
    {0xffffffd0, 28, 220},
    {0xfffffc60, 27, 221},
    {0xfffffc80, 27, 222},
    {0xfffffca0, 27, 223},
    {0xfffec000, 20, 224},
    {0xfffff300, 24, 225},
    {0xfffed000, 20, 226},
    {0xffff3000, 21, 227},
    {0xffffa400, 22, 228},
    {0xffff3800, 21, 229},
    {0xffff4000, 21, 230},
    {0xffffe600, 23, 231},
    {0xffffa800, 22, 232},
    {0xffffac00, 22, 233},
    {0xfffff700, 25, 234},
    {0xfffff780, 25, 235},
    {0xfffff400, 24, 236},
    {0xfffff500, 24, 237},
    {0xfffffa80, 26, 238},
    {0xffffe800, 23, 239},
    {0xfffffac0, 26, 240},
    {0xfffffcc0, 27, 241},
    {0xfffffb00, 26, 242},
    {0xfffffb40, 26, 243},
    {0xfffffce0, 27, 244},
    {0xfffffd00, 27, 245},
    {0xfffffd20, 27, 246},
    {0xfffffd40, 27, 247},
    {0xfffffd60, 27, 248},
    {0xffffffe0, 28, 249},
    {0xfffffd80, 27, 250},
    {0xfffffda0, 27, 251},
    {0xfffffdc0, 27, 252},
    {0xfffffde0, 27, 253},
    {0xfffffe00, 27, 254},
    {0xfffffb80, 26, 255},
    {0xfffffffc, 30, 256},
};
#define HPACK_HUFFMAN_TABLE_LENGTH (sizeof(hpack_huffman_table) / sizeof(hpack_huffman_table[0]))
