/*
Copyright (C) 2020-2021 Signal Messenger, LLC.
SPDX-License-Identifier: AGPL-3.0-only
*/


#ifndef SIGNAL_FFI_H_
#define SIGNAL_FFI_H_

/* This file was automatically generated by cbindgen */

#include <stdarg.h>
#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>

#define SignalSVR_KEY_LEN 32

#define SignalBACKUP_KEY_LEN 32

#define SignalLOCAL_BACKUP_METADATA_KEY_LEN 32

#define SignalMEDIA_ID_LEN 15

#define SignalBACKUP_FORWARD_SECRECY_TOKEN_LEN 32

#define SignalMEDIA_ENCRYPTION_KEY_LEN (32 + 32)

#define SignalBackupId_LEN 16

#define SignalNUM_AUTH_CRED_ATTRIBUTES 3

#define SignalNUM_PROFILE_KEY_CRED_ATTRIBUTES 4

#define SignalNUM_RECEIPT_CRED_ATTRIBUTES 2

#define SignalPRESENTATION_VERSION_1 0

#define SignalPRESENTATION_VERSION_2 1

#define SignalPRESENTATION_VERSION_3 2

#define SignalPRESENTATION_VERSION_4 3

#define SignalAES_KEY_LEN 32

#define SignalAESGCM_NONCE_LEN 12

#define SignalAESGCM_TAG_LEN 16

#define SignalGROUP_MASTER_KEY_LEN 32

#define SignalGROUP_SECRET_PARAMS_LEN 289

#define SignalGROUP_PUBLIC_PARAMS_LEN 97

#define SignalGROUP_IDENTIFIER_LEN 32

#define SignalAUTH_CREDENTIAL_LEN 181

#define SignalAUTH_CREDENTIAL_PRESENTATION_V2_LEN 461

#define SignalAUTH_CREDENTIAL_RESPONSE_LEN 361

#define SignalAUTH_CREDENTIAL_WITH_PNI_LEN 265

#define SignalAUTH_CREDENTIAL_WITH_PNI_RESPONSE_LEN 425

#define SignalPROFILE_KEY_LEN 32

#define SignalPROFILE_KEY_CIPHERTEXT_LEN 65

#define SignalPROFILE_KEY_COMMITMENT_LEN 97

#define SignalEXPIRING_PROFILE_KEY_CREDENTIAL_LEN 153

#define SignalPROFILE_KEY_CREDENTIAL_PRESENTATION_V2_LEN 713

#define SignalPROFILE_KEY_CREDENTIAL_REQUEST_LEN 329

#define SignalPROFILE_KEY_CREDENTIAL_REQUEST_CONTEXT_LEN 473

#define SignalEXPIRING_PROFILE_KEY_CREDENTIAL_RESPONSE_LEN 497

#define SignalPROFILE_KEY_VERSION_LEN 32

#define SignalPROFILE_KEY_VERSION_ENCODED_LEN 64

#define SignalRECEIPT_CREDENTIAL_LEN 129

#define SignalRECEIPT_CREDENTIAL_PRESENTATION_LEN 329

#define SignalRECEIPT_CREDENTIAL_REQUEST_LEN 97

#define SignalRECEIPT_CREDENTIAL_REQUEST_CONTEXT_LEN 177

#define SignalRECEIPT_CREDENTIAL_RESPONSE_LEN 409

#define SignalRECEIPT_SERIAL_LEN 16

#define SignalRESERVED_LEN 1

#define SignalSERVER_SECRET_PARAMS_LEN 2721

#define SignalSERVER_PUBLIC_PARAMS_LEN 673

#define SignalUUID_CIPHERTEXT_LEN 65

#define SignalRANDOMNESS_LEN 32

#define SignalSIGNATURE_LEN 64

#define SignalUUID_LEN 16

#define SignalACCESS_KEY_LEN 16

/**
 * Seconds in a 24-hour cycle (ignoring leap seconds).
 */
#define SignalSECONDS_PER_DAY 86400

/**
 * The encoded length of a [`FourCC`], in bytes.
 */
#define SignalFourCC_ENCODED_LEN 4

enum SignalChallengeOption {
  SignalChallengeOptionPushChallenge,
  SignalChallengeOptionCaptcha,
};
typedef uint8_t SignalChallengeOption;

typedef enum {
  SignalCiphertextMessageTypeWhisper = 2,
  SignalCiphertextMessageTypePreKey = 3,
  SignalCiphertextMessageTypeSenderKey = 7,
  SignalCiphertextMessageTypePlaintext = 8,
} SignalCiphertextMessageType;

typedef enum {
  SignalContentHintDefault = 0,
  SignalContentHintResendable = 1,
  SignalContentHintImplicit = 2,
} SignalContentHint;

typedef enum {
  SignalDirectionSending = 0,
  SignalDirectionReceiving = 1,
} SignalDirection;

enum SignalFfiPublicKeyType {
  SignalFfiPublicKeyTypeECC,
  SignalFfiPublicKeyTypeKyber,
};
typedef uint8_t SignalFfiPublicKeyType;

/**
 * The result of saving a new identity key for a protocol address.
 */
typedef enum {
  /**
   * The protocol address didn't have an identity key or had the same key.
   */
  SignalIdentityChangeNewOrUnchanged,
  /**
   * The new identity key replaced a different key for the protocol address.
   */
  SignalIdentityChangeReplacedExisting,
} SignalIdentityChange;

typedef enum {
  SignalLogLevelError = 1,
  SignalLogLevelWarn,
  SignalLogLevelInfo,
  SignalLogLevelDebug,
  SignalLogLevelTrace,
} SignalLogLevel;

typedef enum {
  SignalErrorCodeUnknownError = 1,
  SignalErrorCodeInvalidState = 2,
  SignalErrorCodeInternalError = 3,
  SignalErrorCodeNullParameter = 4,
  SignalErrorCodeInvalidArgument = 5,
  SignalErrorCodeInvalidType = 6,
  SignalErrorCodeInvalidUtf8String = 7,
  SignalErrorCodeCancelled = 8,
  SignalErrorCodeProtobufError = 10,
  SignalErrorCodeLegacyCiphertextVersion = 21,
  SignalErrorCodeUnknownCiphertextVersion = 22,
  SignalErrorCodeUnrecognizedMessageVersion = 23,
  SignalErrorCodeInvalidMessage = 30,
  SignalErrorCodeSealedSenderSelfSend = 31,
  SignalErrorCodeInvalidKey = 40,
  SignalErrorCodeInvalidSignature = 41,
  SignalErrorCodeInvalidAttestationData = 42,
  SignalErrorCodeFingerprintVersionMismatch = 51,
  SignalErrorCodeFingerprintParsingError = 52,
  SignalErrorCodeUntrustedIdentity = 60,
  SignalErrorCodeInvalidKeyIdentifier = 70,
  SignalErrorCodeSessionNotFound = 80,
  SignalErrorCodeInvalidRegistrationId = 81,
  SignalErrorCodeInvalidSession = 82,
  SignalErrorCodeInvalidSenderKeySession = 83,
  SignalErrorCodeInvalidProtocolAddress = 84,
  SignalErrorCodeDuplicatedMessage = 90,
  SignalErrorCodeCallbackError = 100,
  SignalErrorCodeVerificationFailure = 110,
  SignalErrorCodeUsernameCannotBeEmpty = 120,
  SignalErrorCodeUsernameCannotStartWithDigit = 121,
  SignalErrorCodeUsernameMissingSeparator = 122,
  SignalErrorCodeUsernameBadDiscriminatorCharacter = 123,
  SignalErrorCodeUsernameBadNicknameCharacter = 124,
  SignalErrorCodeUsernameTooShort = 125,
  SignalErrorCodeUsernameTooLong = 126,
  SignalErrorCodeUsernameLinkInvalidEntropyDataLength = 127,
  SignalErrorCodeUsernameLinkInvalid = 128,
  SignalErrorCodeUsernameDiscriminatorCannotBeEmpty = 130,
  SignalErrorCodeUsernameDiscriminatorCannotBeZero = 131,
  SignalErrorCodeUsernameDiscriminatorCannotBeSingleDigit = 132,
  SignalErrorCodeUsernameDiscriminatorCannotHaveLeadingZeros = 133,
  SignalErrorCodeUsernameDiscriminatorTooLarge = 134,
  SignalErrorCodeIoError = 140,
  SignalErrorCodeInvalidMediaInput = 141,
  SignalErrorCodeUnsupportedMediaInput = 142,
  SignalErrorCodeConnectionTimedOut = 143,
  SignalErrorCodeNetworkProtocol = 144,
  SignalErrorCodeRateLimited = 145,
  SignalErrorCodeWebSocket = 146,
  SignalErrorCodeCdsiInvalidToken = 147,
  SignalErrorCodeConnectionFailed = 148,
  SignalErrorCodeChatServiceInactive = 149,
  SignalErrorCodeRequestTimedOut = 150,
  SignalErrorCodeRateLimitChallenge = 151,
  SignalErrorCodeSvrDataMissing = 160,
  SignalErrorCodeSvrRestoreFailed = 161,
  SignalErrorCodeSvrRotationMachineTooManySteps = 162,
  SignalErrorCodeSvrRequestFailed = 163,
  SignalErrorCodeAppExpired = 170,
  SignalErrorCodeDeviceDeregistered = 171,
  SignalErrorCodeConnectionInvalidated = 172,
  SignalErrorCodeConnectedElsewhere = 173,
  SignalErrorCodeBackupValidation = 180,
  SignalErrorCodeRegistrationInvalidSessionId = 190,
  SignalErrorCodeRegistrationUnknown = 192,
  SignalErrorCodeRegistrationSessionNotFound = 193,
  SignalErrorCodeRegistrationNotReadyForVerification = 194,
  SignalErrorCodeRegistrationSendVerificationCodeFailed = 195,
  SignalErrorCodeRegistrationCodeNotDeliverable = 196,
  SignalErrorCodeRegistrationSessionUpdateRejected = 197,
  SignalErrorCodeRegistrationCredentialsCouldNotBeParsed = 198,
  SignalErrorCodeRegistrationDeviceTransferPossible = 199,
  SignalErrorCodeRegistrationRecoveryVerificationFailed = 200,
  SignalErrorCodeRegistrationLock = 201,
  SignalErrorCodeKeyTransparencyError = 210,
  SignalErrorCodeKeyTransparencyVerificationFailed = 211,
} SignalErrorCode;

enum SignalSvr2CredentialsResult {
  SignalSvr2CredentialsResultMatch,
  SignalSvr2CredentialsResultNoMatch,
  SignalSvr2CredentialsResultInvalid,
};
typedef uint8_t SignalSvr2CredentialsResult;

typedef struct SignalAccountAttributes SignalAccountAttributes;

/**
 * A wrapper around [`ctr::Ctr32BE`] that uses a smaller nonce and supports an initial counter.
 */
typedef struct SignalAes256Ctr32 SignalAes256Ctr32;

typedef struct SignalAes256GcmDecryption SignalAes256GcmDecryption;

typedef struct SignalAes256GcmEncryption SignalAes256GcmEncryption;

typedef struct SignalAes256GcmSiv SignalAes256GcmSiv;

typedef struct SignalAuthenticatedChatConnection SignalAuthenticatedChatConnection;

typedef struct SignalBackupRestoreResponse SignalBackupRestoreResponse;

typedef struct SignalBackupStoreResponse SignalBackupStoreResponse;

typedef struct SignalBridgedStringMap SignalBridgedStringMap;

typedef struct SignalCdsiLookup SignalCdsiLookup;

typedef struct SignalCiphertextMessage SignalCiphertextMessage;

/**
 * Information about an established connection.
 */
typedef struct SignalConnectionInfo SignalConnectionInfo;

typedef struct SignalConnectionManager SignalConnectionManager;

typedef struct SignalConnectionProxyConfig SignalConnectionProxyConfig;

typedef struct SignalDecryptionErrorMessage SignalDecryptionErrorMessage;

typedef struct SignalFingerprint SignalFingerprint;

typedef struct SignalHsmEnclaveClient SignalHsmEnclaveClient;

typedef struct SignalHttpRequest SignalHttpRequest;

typedef struct SignalIncrementalMac SignalIncrementalMac;

typedef struct SignalKeyPair SignalKeyPair;

typedef struct SignalKeySecret SignalKeySecret;

typedef struct SignalKyberPreKeyRecord SignalKyberPreKeyRecord;

typedef struct SignalLookupRequest SignalLookupRequest;

typedef struct SignalMessageBackupKey SignalMessageBackupKey;

typedef struct SignalMessageBackupValidationOutcome SignalMessageBackupValidationOutcome;

typedef struct SignalOnlineBackupValidator SignalOnlineBackupValidator;

typedef struct SignalPinHash SignalPinHash;

typedef struct SignalPlaintextContent SignalPlaintextContent;

typedef struct SignalPreKeyBundle SignalPreKeyBundle;

typedef struct SignalPreKeyRecord SignalPreKeyRecord;

typedef struct SignalPreKeySignalMessage SignalPreKeySignalMessage;

typedef struct SignalPrivateKey SignalPrivateKey;

/**
 * Represents a unique Signal client instance as `(<user ID>, <device ID>)` pair.
 */
typedef struct SignalProtocolAddress SignalProtocolAddress;

typedef struct SignalPublicKey SignalPublicKey;

typedef struct SignalRegisterAccountRequest SignalRegisterAccountRequest;

typedef struct SignalRegisterAccountResponse SignalRegisterAccountResponse;

typedef struct SignalRegistrationService SignalRegistrationService;

typedef struct SignalRegistrationSession SignalRegistrationSession;

typedef struct SignalSanitizedMetadata SignalSanitizedMetadata;

typedef struct SignalSenderCertificate SignalSenderCertificate;

typedef struct SignalSenderKeyDistributionMessage SignalSenderKeyDistributionMessage;

typedef struct SignalSenderKeyMessage SignalSenderKeyMessage;

typedef struct SignalSenderKeyRecord SignalSenderKeyRecord;

typedef struct SignalServerCertificate SignalServerCertificate;

/**
 * Wraps a named type and a single-use guard around [`chat::server_requests::ResponseEnvelopeSender`].
 */
typedef struct SignalServerMessageAck SignalServerMessageAck;

typedef struct SignalServerPublicParams SignalServerPublicParams;

typedef struct SignalServerSecretParams SignalServerSecretParams;

typedef struct SignalSessionRecord SignalSessionRecord;

typedef struct SignalSgxClientState SignalSgxClientState;

/**
 * The top-level error type (opaquely) returned to C clients when something goes wrong.
 *
 * Ideally this would use [ThinBox][], and then we wouldn't need an extra level of indirection when
 * returning it to C, but unfortunately that isn't stable yet.
 *
 * [ThinBox]: https://doc.rust-lang.org/std/boxed/struct.ThinBox.html
 */
typedef struct SignalFfiError SignalFfiError;

typedef struct SignalMessage SignalMessage;

typedef struct SignalSignedPreKeyRecord SignalSignedPreKeyRecord;

typedef struct SignalTokioAsyncContext SignalTokioAsyncContext;

typedef struct SignalUnauthenticatedChatConnection SignalUnauthenticatedChatConnection;

typedef struct SignalUnidentifiedSenderMessageContent SignalUnidentifiedSenderMessageContent;

typedef struct SignalValidatingMac SignalValidatingMac;

typedef struct {
  SignalProtocolAddress *raw;
} SignalMutPointerProtocolAddress;

typedef struct {
  const SignalProtocolAddress *raw;
} SignalConstPointerProtocolAddress;

typedef struct {
  SignalAes256Ctr32 *raw;
} SignalMutPointerAes256Ctr32;

typedef struct {
  const unsigned char *base;
  size_t length;
} SignalBorrowedBuffer;

typedef struct {
  unsigned char *base;
  size_t length;
} SignalBorrowedMutableBuffer;

typedef struct {
  SignalAes256GcmDecryption *raw;
} SignalMutPointerAes256GcmDecryption;

/**
 * A representation of a array allocated on the Rust heap for use in C code.
 */
typedef struct {
  unsigned char *base;
  /**
   * The number of elements in the buffer (not necessarily the number of bytes).
   */
  size_t length;
} SignalOwnedBuffer;

typedef struct {
  SignalAes256GcmEncryption *raw;
} SignalMutPointerAes256GcmEncryption;

typedef struct {
  const SignalAes256GcmSiv *raw;
} SignalConstPointerAes256GcmSiv;

typedef struct {
  SignalAes256GcmSiv *raw;
} SignalMutPointerAes256GcmSiv;

typedef struct {
  SignalAuthenticatedChatConnection *raw;
} SignalMutPointerAuthenticatedChatConnection;

typedef uint64_t SignalCancellationId;

/**
 * A C callback used to report the results of Rust futures.
 *
 * cbindgen will produce independent C types like `SignalCPromisei32` and
 * `SignalCPromiseProtocolAddress`.
 *
 * This derives Copy because it behaves like a C type; nevertheless, a promise should still only be
 * completed once.
 */
typedef struct {
  void (*complete)(SignalFfiError *error, const SignalMutPointerAuthenticatedChatConnection *result, const void *context);
  const void *context;
  SignalCancellationId cancellation_id;
} SignalCPromiseMutPointerAuthenticatedChatConnection;

typedef struct {
  const SignalTokioAsyncContext *raw;
} SignalConstPointerTokioAsyncContext;

typedef struct {
  const SignalConnectionManager *raw;
} SignalConstPointerConnectionManager;

typedef struct {
  const size_t *base;
  size_t length;
} SignalBorrowedSliceOfusize;

typedef struct {
  SignalBorrowedBuffer bytes;
  SignalBorrowedSliceOfusize lengths;
} SignalBorrowedBytestringArray;

/**
 * A C callback used to report the results of Rust futures.
 *
 * cbindgen will produce independent C types like `SignalCPromisei32` and
 * `SignalCPromiseProtocolAddress`.
 *
 * This derives Copy because it behaves like a C type; nevertheless, a promise should still only be
 * completed once.
 */
typedef struct {
  void (*complete)(SignalFfiError *error, const bool *result, const void *context);
  const void *context;
  SignalCancellationId cancellation_id;
} SignalCPromisebool;

typedef struct {
  const SignalAuthenticatedChatConnection *raw;
} SignalConstPointerAuthenticatedChatConnection;

typedef SignalConnectionInfo SignalChatConnectionInfo;

typedef struct {
  SignalChatConnectionInfo *raw;
} SignalMutPointerChatConnectionInfo;

typedef void (*SignalReceivedIncomingMessage)(void *ctx, SignalOwnedBuffer envelope, uint64_t timestamp_millis, SignalServerMessageAck *cleanup);

typedef void (*SignalReceivedQueueEmpty)(void *ctx);

/**
 * A representation of a array allocated on the Rust heap for use in C code.
 */
typedef struct {
  size_t *base;
  /**
   * The number of elements in the buffer (not necessarily the number of bytes).
   */
  size_t length;
} SignalOwnedBufferOfusize;

typedef struct {
  SignalOwnedBuffer bytes;
  SignalOwnedBufferOfusize lengths;
} SignalBytestringArray;

typedef SignalBytestringArray SignalStringArray;

typedef void (*SignalReceivedAlerts)(void *ctx, SignalStringArray alerts);

typedef void (*SignalConnectionInterrupted)(void *ctx, SignalFfiError *error);

typedef void (*SignalDestroyChatListener)(void *ctx);

/**
 * Callbacks for [`ChatListener`].
 *
 * Callbacks will be serialized (i.e. two calls will not come in at the same time), but may not
 * always happen on the same thread. Calls should be responded to promptly to avoid blocking later
 * messages.
 *
 * # Safety
 *
 * This type contains raw pointers. Code that constructs an instance of this type must ensure
 * memory safety assuming that
 * - the callback function pointer fields are called with `ctx` as an argument;
 * - the `destroy` function pointer field is called with `ctx` as an argument;
 * - no function pointer fields are called after `destroy` is called.
 */
typedef struct {
  void *ctx;
  SignalReceivedIncomingMessage received_incoming_message;
  SignalReceivedQueueEmpty received_queue_empty;
  SignalReceivedAlerts received_alerts;
  SignalConnectionInterrupted connection_interrupted;
  SignalDestroyChatListener destroy;
} SignalFfiChatListenerStruct;

typedef struct {
  const SignalFfiChatListenerStruct *raw;
} SignalConstPointerFfiChatListenerStruct;

/**
 * A type alias to be used with [`OwnedBufferOf`], so that `OwnedBufferOf<c_char>` and
 * `OwnedBufferOf<*const c_char>` get distinct names.
 */
typedef const char *SignalCStringPtr;

/**
 * A representation of a array allocated on the Rust heap for use in C code.
 */
typedef struct {
  SignalCStringPtr *base;
  /**
   * The number of elements in the buffer (not necessarily the number of bytes).
   */
  size_t length;
} SignalOwnedBufferOfCStringPtr;

typedef struct {
  uint16_t status;
  const char *message;
  SignalOwnedBufferOfCStringPtr headers;
  SignalOwnedBuffer body;
} SignalFfiChatResponse;

/**
 * A C callback used to report the results of Rust futures.
 *
 * cbindgen will produce independent C types like `SignalCPromisei32` and
 * `SignalCPromiseProtocolAddress`.
 *
 * This derives Copy because it behaves like a C type; nevertheless, a promise should still only be
 * completed once.
 */
typedef struct {
  void (*complete)(SignalFfiError *error, const SignalFfiChatResponse *result, const void *context);
  const void *context;
  SignalCancellationId cancellation_id;
} SignalCPromiseFfiChatResponse;

typedef struct {
  const SignalHttpRequest *raw;
} SignalConstPointerHttpRequest;

/**
 * The fixed-width binary representation of a ServiceId.
 *
 * Rarely used. The variable-width format that privileges ACIs is preferred.
 */
typedef uint8_t SignalServiceIdFixedWidthBinaryBytes[17];

typedef struct {
  SignalPrivateKey *raw;
} SignalMutPointerPrivateKey;

typedef struct {
  SignalBackupRestoreResponse *raw;
} SignalMutPointerBackupRestoreResponse;

typedef struct {
  const SignalBackupRestoreResponse *raw;
} SignalConstPointerBackupRestoreResponse;

typedef struct {
  SignalBackupStoreResponse *raw;
} SignalMutPointerBackupStoreResponse;

typedef struct {
  const SignalBackupStoreResponse *raw;
} SignalConstPointerBackupStoreResponse;

typedef struct {
  SignalBridgedStringMap *raw;
} SignalMutPointerBridgedStringMap;

typedef struct {
  const SignalBridgedStringMap *raw;
} SignalConstPointerBridgedStringMap;

typedef struct {
  SignalSgxClientState *raw;
} SignalMutPointerSgxClientState;

typedef struct {
  /**
   * Telephone number, as an unformatted e164.
   */
  uint64_t e164;
  uint8_t rawAciUuid[16];
  uint8_t rawPniUuid[16];
} SignalFfiCdsiLookupResponseEntry;

/**
 * A representation of a array allocated on the Rust heap for use in C code.
 */
typedef struct {
  SignalFfiCdsiLookupResponseEntry *base;
  /**
   * The number of elements in the buffer (not necessarily the number of bytes).
   */
  size_t length;
} SignalOwnedBufferOfFfiCdsiLookupResponseEntry;

typedef struct {
  SignalOwnedBufferOfFfiCdsiLookupResponseEntry entries;
  int32_t debug_permits_used;
} SignalFfiCdsiLookupResponse;

/**
 * A C callback used to report the results of Rust futures.
 *
 * cbindgen will produce independent C types like `SignalCPromisei32` and
 * `SignalCPromiseProtocolAddress`.
 *
 * This derives Copy because it behaves like a C type; nevertheless, a promise should still only be
 * completed once.
 */
typedef struct {
  void (*complete)(SignalFfiError *error, const SignalFfiCdsiLookupResponse *result, const void *context);
  const void *context;
  SignalCancellationId cancellation_id;
} SignalCPromiseFfiCdsiLookupResponse;

typedef struct {
  const SignalCdsiLookup *raw;
} SignalConstPointerCdsiLookup;

typedef struct {
  SignalCdsiLookup *raw;
} SignalMutPointerCdsiLookup;

/**
 * A C callback used to report the results of Rust futures.
 *
 * cbindgen will produce independent C types like `SignalCPromisei32` and
 * `SignalCPromiseProtocolAddress`.
 *
 * This derives Copy because it behaves like a C type; nevertheless, a promise should still only be
 * completed once.
 */
typedef struct {
  void (*complete)(SignalFfiError *error, const SignalMutPointerCdsiLookup *result, const void *context);
  const void *context;
  SignalCancellationId cancellation_id;
} SignalCPromiseMutPointerCdsiLookup;

typedef struct {
  const SignalLookupRequest *raw;
} SignalConstPointerLookupRequest;

typedef struct {
  const SignalChatConnectionInfo *raw;
} SignalConstPointerChatConnectionInfo;

typedef struct {
  SignalCiphertextMessage *raw;
} SignalMutPointerCiphertextMessage;

typedef struct {
  const SignalPlaintextContent *raw;
} SignalConstPointerPlaintextContent;

typedef struct {
  const SignalCiphertextMessage *raw;
} SignalConstPointerCiphertextMessage;

typedef struct {
  SignalConnectionInfo *raw;
} SignalMutPointerConnectionInfo;

typedef struct {
  SignalConnectionManager *raw;
} SignalMutPointerConnectionManager;

typedef struct {
  const SignalConnectionProxyConfig *raw;
} SignalConstPointerConnectionProxyConfig;

typedef struct {
  SignalConnectionProxyConfig *raw;
} SignalMutPointerConnectionProxyConfig;

typedef struct {
  const SignalMessage *raw;
} SignalConstPointerSignalMessage;

typedef struct {
  SignalSessionRecord *raw;
} SignalMutPointerSessionRecord;

typedef int (*SignalLoadSession)(void *store_ctx, SignalMutPointerSessionRecord *recordp, SignalConstPointerProtocolAddress address);

typedef struct {
  const SignalSessionRecord *raw;
} SignalConstPointerSessionRecord;

typedef int (*SignalStoreSession)(void *store_ctx, SignalConstPointerProtocolAddress address, SignalConstPointerSessionRecord record);

typedef struct {
  void *ctx;
  SignalLoadSession load_session;
  SignalStoreSession store_session;
} SignalSessionStore;

typedef struct {
  const SignalSessionStore *raw;
} SignalConstPointerFfiSessionStoreStruct;

typedef int (*SignalGetIdentityKeyPair)(void *store_ctx, SignalMutPointerPrivateKey *keyp);

typedef int (*SignalGetLocalRegistrationId)(void *store_ctx, uint32_t *idp);

typedef struct {
  const SignalPublicKey *raw;
} SignalConstPointerPublicKey;

typedef int (*SignalSaveIdentityKey)(void *store_ctx, SignalConstPointerProtocolAddress address, SignalConstPointerPublicKey public_key);

typedef struct {
  SignalPublicKey *raw;
} SignalMutPointerPublicKey;

typedef int (*SignalGetIdentityKey)(void *store_ctx, SignalMutPointerPublicKey *public_keyp, SignalConstPointerProtocolAddress address);

typedef int (*SignalIsTrustedIdentity)(void *store_ctx, SignalConstPointerProtocolAddress address, SignalConstPointerPublicKey public_key, unsigned int direction);

typedef struct {
  void *ctx;
  SignalGetIdentityKeyPair get_identity_key_pair;
  SignalGetLocalRegistrationId get_local_registration_id;
  SignalSaveIdentityKey save_identity;
  SignalGetIdentityKey get_identity;
  SignalIsTrustedIdentity is_trusted_identity;
} SignalIdentityKeyStore;

typedef struct {
  const SignalIdentityKeyStore *raw;
} SignalConstPointerFfiIdentityKeyStoreStruct;

typedef struct {
  const SignalPreKeySignalMessage *raw;
} SignalConstPointerPreKeySignalMessage;

typedef struct {
  SignalPreKeyRecord *raw;
} SignalMutPointerPreKeyRecord;

typedef int (*SignalLoadPreKey)(void *store_ctx, SignalMutPointerPreKeyRecord *recordp, uint32_t id);

typedef struct {
  const SignalPreKeyRecord *raw;
} SignalConstPointerPreKeyRecord;

typedef int (*SignalStorePreKey)(void *store_ctx, uint32_t id, SignalConstPointerPreKeyRecord record);

typedef int (*SignalRemovePreKey)(void *store_ctx, uint32_t id);

typedef struct {
  void *ctx;
  SignalLoadPreKey load_pre_key;
  SignalStorePreKey store_pre_key;
  SignalRemovePreKey remove_pre_key;
} SignalPreKeyStore;

typedef struct {
  const SignalPreKeyStore *raw;
} SignalConstPointerFfiPreKeyStoreStruct;

typedef struct {
  SignalSignedPreKeyRecord *raw;
} SignalMutPointerSignedPreKeyRecord;

typedef int (*SignalLoadSignedPreKey)(void *store_ctx, SignalMutPointerSignedPreKeyRecord *recordp, uint32_t id);

typedef struct {
  const SignalSignedPreKeyRecord *raw;
} SignalConstPointerSignedPreKeyRecord;

typedef int (*SignalStoreSignedPreKey)(void *store_ctx, uint32_t id, SignalConstPointerSignedPreKeyRecord record);

typedef struct {
  void *ctx;
  SignalLoadSignedPreKey load_signed_pre_key;
  SignalStoreSignedPreKey store_signed_pre_key;
} SignalSignedPreKeyStore;

typedef struct {
  const SignalSignedPreKeyStore *raw;
} SignalConstPointerFfiSignedPreKeyStoreStruct;

typedef struct {
  SignalKyberPreKeyRecord *raw;
} SignalMutPointerKyberPreKeyRecord;

typedef int (*SignalLoadKyberPreKey)(void *store_ctx, SignalMutPointerKyberPreKeyRecord *recordp, uint32_t id);

typedef struct {
  const SignalKyberPreKeyRecord *raw;
} SignalConstPointerKyberPreKeyRecord;

typedef int (*SignalStoreKyberPreKey)(void *store_ctx, uint32_t id, SignalConstPointerKyberPreKeyRecord record);

typedef int (*SignalMarkKyberPreKeyUsed)(void *store_ctx, uint32_t id, uint32_t signed_prekey_id, SignalConstPointerPublicKey base_key);

typedef struct {
  void *ctx;
  SignalLoadKyberPreKey load_kyber_pre_key;
  SignalStoreKyberPreKey store_kyber_pre_key;
  SignalMarkKyberPreKeyUsed mark_kyber_pre_key_used;
} SignalKyberPreKeyStore;

typedef struct {
  const SignalKyberPreKeyStore *raw;
} SignalConstPointerFfiKyberPreKeyStoreStruct;

typedef struct {
  SignalDecryptionErrorMessage *raw;
} SignalMutPointerDecryptionErrorMessage;

typedef struct {
  const SignalDecryptionErrorMessage *raw;
} SignalConstPointerDecryptionErrorMessage;

/**
 * Like [`std::panic::AssertUnwindSafe`], but FFI-compatible.
 */
typedef const SignalFfiError *SignalUnwindSafeArgSignalFfiError;

typedef struct {
  SignalFingerprint *raw;
} SignalMutPointerFingerprint;

typedef struct {
  const SignalFingerprint *raw;
} SignalConstPointerFingerprint;

typedef struct {
  /**
   * The badge ID.
   */
  const char *id;
  /**
   * Whether the badge is currently configured to be visible.
   */
  bool visible;
  /**
   * When the badge expires.
   */
  double expiration_secs;
} SignalFfiRegisterResponseBadge;

/**
 * A representation of a array allocated on the Rust heap for use in C code.
 */
typedef struct {
  SignalFfiRegisterResponseBadge *base;
  /**
   * The number of elements in the buffer (not necessarily the number of bytes).
   */
  size_t length;
} SignalOwnedBufferOfFfiRegisterResponseBadge;

typedef struct {
  SignalSenderKeyRecord *raw;
} SignalMutPointerSenderKeyRecord;

typedef int (*SignalLoadSenderKey)(void *store_ctx, SignalMutPointerSenderKeyRecord*, SignalConstPointerProtocolAddress, const uint8_t (*distribution_id)[16]);

typedef struct {
  const SignalSenderKeyRecord *raw;
} SignalConstPointerSenderKeyRecord;

typedef int (*SignalStoreSenderKey)(void *store_ctx, SignalConstPointerProtocolAddress, const uint8_t (*distribution_id)[16], SignalConstPointerSenderKeyRecord);

typedef struct {
  void *ctx;
  SignalLoadSenderKey load_sender_key;
  SignalStoreSenderKey store_sender_key;
} SignalSenderKeyStore;

typedef struct {
  const SignalSenderKeyStore *raw;
} SignalConstPointerFfiSenderKeyStoreStruct;

typedef struct {
  const SignalServerSecretParams *raw;
} SignalConstPointerServerSecretParams;

typedef struct {
  const SignalBorrowedBuffer *base;
  size_t length;
} SignalBorrowedSliceOfBuffers;

typedef struct {
  const SignalServerPublicParams *raw;
} SignalConstPointerServerPublicParams;

typedef struct {
  SignalHsmEnclaveClient *raw;
} SignalMutPointerHsmEnclaveClient;

typedef struct {
  const SignalHsmEnclaveClient *raw;
} SignalConstPointerHsmEnclaveClient;

typedef struct {
  SignalHttpRequest *raw;
} SignalMutPointerHttpRequest;

typedef struct {
  const SignalPrivateKey *raw;
} SignalConstPointerPrivateKey;

typedef struct {
  SignalIncrementalMac *raw;
} SignalMutPointerIncrementalMac;

typedef void (*SignalLogCallback)(void *ctx, SignalLogLevel level, const char *file, uint32_t line, const char *message);

typedef void (*SignalLogFlushCallback)(void *ctx);

typedef struct {
  void *ctx;
  SignalLogCallback log;
  SignalLogFlushCallback flush;
} SignalFfiLogger;

/**
 * A C callback used to report the results of Rust futures.
 *
 * cbindgen will produce independent C types like `SignalCPromisei32` and
 * `SignalCPromiseProtocolAddress`.
 *
 * This derives Copy because it behaves like a C type; nevertheless, a promise should still only be
 * completed once.
 */
typedef struct {
  void (*complete)(SignalFfiError *error, const SignalOwnedBuffer *result, const void *context);
  const void *context;
  SignalCancellationId cancellation_id;
} SignalCPromiseOwnedBufferOfc_uchar;

typedef struct {
  const SignalUnauthenticatedChatConnection *raw;
} SignalConstPointerUnauthenticatedChatConnection;

typedef struct {
  bool present;
  SignalBorrowedBuffer value;
} SignalOptionalBorrowedSliceOfc_uchar;

typedef SignalKeyPair SignalKyberKeyPair;

typedef struct {
  SignalKyberKeyPair *raw;
} SignalMutPointerKyberKeyPair;

typedef struct {
  const SignalKyberKeyPair *raw;
} SignalConstPointerKyberKeyPair;

typedef SignalPublicKey SignalKyberPublicKey;

typedef struct {
  SignalKyberPublicKey *raw;
} SignalMutPointerKyberPublicKey;

/**
 * A KEM secret key with the ability to decapsulate a shared secret.
 */
typedef SignalKeySecret SignalSecretKey;

typedef SignalSecretKey SignalKyberSecretKey;

typedef struct {
  SignalKyberSecretKey *raw;
} SignalMutPointerKyberSecretKey;

typedef struct {
  const SignalKyberPublicKey *raw;
} SignalConstPointerKyberPublicKey;

typedef struct {
  const SignalKyberSecretKey *raw;
} SignalConstPointerKyberSecretKey;

typedef struct {
  SignalLookupRequest *raw;
} SignalMutPointerLookupRequest;

typedef struct {
  SignalMessageBackupKey *raw;
} SignalMutPointerMessageBackupKey;

typedef struct {
  const SignalMessageBackupKey *raw;
} SignalConstPointerMessageBackupKey;

typedef struct {
  SignalMessageBackupValidationOutcome *raw;
} SignalMutPointerMessageBackupValidationOutcome;

typedef struct {
  const SignalMessageBackupValidationOutcome *raw;
} SignalConstPointerMessageBackupValidationOutcome;

typedef int (*SignalRead)(void *ctx, uint8_t *buf, size_t buf_len, size_t *amount_read);

typedef int (*SignalSkip)(void *ctx, uint64_t amount);

typedef struct {
  void *ctx;
  SignalRead read;
  SignalSkip skip;
} SignalInputStream;

typedef struct {
  const SignalInputStream *raw;
} SignalConstPointerFfiInputStreamStruct;

typedef struct {
  SignalMessage *raw;
} SignalMutPointerSignalMessage;

typedef struct {
  SignalSanitizedMetadata *raw;
} SignalMutPointerSanitizedMetadata;

typedef struct {
  SignalOnlineBackupValidator *raw;
} SignalMutPointerOnlineBackupValidator;

typedef struct {
  const SignalPinHash *raw;
} SignalConstPointerPinHash;

typedef struct {
  SignalPinHash *raw;
} SignalMutPointerPinHash;

typedef struct {
  SignalPlaintextContent *raw;
} SignalMutPointerPlaintextContent;

typedef struct {
  SignalPreKeyBundle *raw;
} SignalMutPointerPreKeyBundle;

typedef struct {
  const SignalPreKeyBundle *raw;
} SignalConstPointerPreKeyBundle;

typedef struct {
  SignalPreKeySignalMessage *raw;
} SignalMutPointerPreKeySignalMessage;

typedef struct {
  const SignalSenderKeyDistributionMessage *raw;
} SignalConstPointerSenderKeyDistributionMessage;

typedef struct {
  SignalRegisterAccountRequest *raw;
} SignalMutPointerRegisterAccountRequest;

typedef struct {
  const SignalRegisterAccountRequest *raw;
} SignalConstPointerRegisterAccountRequest;

typedef struct {
  uint32_t key_id;
  SignalFfiPublicKeyType public_key_type;
  const void *public_key;
  SignalBorrowedBuffer signature;
} SignalFfiSignedPublicPreKey;

typedef struct {
  SignalRegisterAccountResponse *raw;
} SignalMutPointerRegisterAccountResponse;

typedef struct {
  const SignalRegisterAccountResponse *raw;
} SignalConstPointerRegisterAccountResponse;

typedef uint8_t SignalOptionalUuid[17];

typedef SignalAccountAttributes SignalRegistrationAccountAttributes;

typedef struct {
  SignalRegistrationAccountAttributes *raw;
} SignalMutPointerRegistrationAccountAttributes;

typedef struct {
  /**
   * Bridged as a string of bytes, but each entry is a UTF-8 `String` key
   * concatenated with a byte for the value.
   */
  SignalBytestringArray entries;
} SignalFfiCheckSvr2CredentialsResponse;

/**
 * A C callback used to report the results of Rust futures.
 *
 * cbindgen will produce independent C types like `SignalCPromisei32` and
 * `SignalCPromiseProtocolAddress`.
 *
 * This derives Copy because it behaves like a C type; nevertheless, a promise should still only be
 * completed once.
 */
typedef struct {
  void (*complete)(SignalFfiError *error, const SignalFfiCheckSvr2CredentialsResponse *result, const void *context);
  const void *context;
  SignalCancellationId cancellation_id;
} SignalCPromiseFfiCheckSvr2CredentialsResponse;

typedef struct {
  const SignalRegistrationService *raw;
} SignalConstPointerRegistrationService;

typedef struct {
  SignalRegistrationService *raw;
} SignalMutPointerRegistrationService;

/**
 * A C callback used to report the results of Rust futures.
 *
 * cbindgen will produce independent C types like `SignalCPromisei32` and
 * `SignalCPromiseProtocolAddress`.
 *
 * This derives Copy because it behaves like a C type; nevertheless, a promise should still only be
 * completed once.
 */
typedef struct {
  void (*complete)(SignalFfiError *error, const SignalMutPointerRegistrationService *result, const void *context);
  const void *context;
  SignalCancellationId cancellation_id;
} SignalCPromiseMutPointerRegistrationService;

typedef struct {
  const char *number;
  const char *push_token;
  const char *mcc;
  const char *mnc;
} SignalFfiRegistrationCreateSessionRequest;

typedef const SignalConnectionManager *(*SignalGetConnectChatConnectionManager)(void *ctx);

typedef void (*SignalDestroyConnectChatBridge)(void *ctx);

/**
 * A ref-counting pointer to a [`ConnectionManager`] and a callback to
 * decrement the count.
 */
typedef struct {
  void *ctx;
  SignalGetConnectChatConnectionManager get_connection_manager;
  SignalDestroyConnectChatBridge destroy;
} SignalFfiConnectChatBridgeStruct;

typedef struct {
  const SignalFfiConnectChatBridgeStruct *raw;
} SignalConstPointerFfiConnectChatBridgeStruct;

/**
 * A C callback used to report the results of Rust futures.
 *
 * cbindgen will produce independent C types like `SignalCPromisei32` and
 * `SignalCPromiseProtocolAddress`.
 *
 * This derives Copy because it behaves like a C type; nevertheless, a promise should still only be
 * completed once.
 */
typedef struct {
  void (*complete)(SignalFfiError *error, const SignalMutPointerRegisterAccountResponse *result, const void *context);
  const void *context;
  SignalCancellationId cancellation_id;
} SignalCPromiseMutPointerRegisterAccountResponse;

typedef struct {
  const SignalRegistrationAccountAttributes *raw;
} SignalConstPointerRegistrationAccountAttributes;

typedef struct {
  SignalRegistrationSession *raw;
} SignalMutPointerRegistrationSession;

typedef struct {
  const SignalRegistrationSession *raw;
} SignalConstPointerRegistrationSession;

typedef struct {
  const SignalSanitizedMetadata *raw;
} SignalConstPointerSanitizedMetadata;

typedef struct {
  const SignalConstPointerProtocolAddress *base;
  size_t length;
} SignalBorrowedSliceOfConstPointerProtocolAddress;

typedef struct {
  const SignalConstPointerSessionRecord *base;
  size_t length;
} SignalBorrowedSliceOfConstPointerSessionRecord;

typedef struct {
  const SignalUnidentifiedSenderMessageContent *raw;
} SignalConstPointerUnidentifiedSenderMessageContent;

typedef struct {
  SignalUnidentifiedSenderMessageContent *raw;
} SignalMutPointerUnidentifiedSenderMessageContent;

typedef uint8_t SignalBackupKeyBytes[SignalBACKUP_KEY_LEN];

/**
 * A C callback used to report the results of Rust futures.
 *
 * cbindgen will produce independent C types like `SignalCPromisei32` and
 * `SignalCPromiseProtocolAddress`.
 *
 * This derives Copy because it behaves like a C type; nevertheless, a promise should still only be
 * completed once.
 */
typedef struct {
  void (*complete)(SignalFfiError *error, const SignalMutPointerBackupRestoreResponse *result, const void *context);
  const void *context;
  SignalCancellationId cancellation_id;
} SignalCPromiseMutPointerBackupRestoreResponse;

/**
 * A C callback used to report the results of Rust futures.
 *
 * cbindgen will produce independent C types like `SignalCPromisei32` and
 * `SignalCPromiseProtocolAddress`.
 *
 * This derives Copy because it behaves like a C type; nevertheless, a promise should still only be
 * completed once.
 */
typedef struct {
  void (*complete)(SignalFfiError *error, const SignalMutPointerBackupStoreResponse *result, const void *context);
  const void *context;
  SignalCancellationId cancellation_id;
} SignalCPromiseMutPointerBackupStoreResponse;

typedef struct {
  SignalSenderCertificate *raw;
} SignalMutPointerSenderCertificate;

typedef struct {
  const SignalSenderCertificate *raw;
} SignalConstPointerSenderCertificate;

typedef struct {
  SignalServerCertificate *raw;
} SignalMutPointerServerCertificate;

typedef struct {
  const SignalServerCertificate *raw;
} SignalConstPointerServerCertificate;

typedef struct {
  const SignalConstPointerPublicKey *base;
  size_t length;
} SignalBorrowedSliceOfConstPointerPublicKey;

typedef struct {
  SignalSenderKeyDistributionMessage *raw;
} SignalMutPointerSenderKeyDistributionMessage;

typedef struct {
  SignalSenderKeyMessage *raw;
} SignalMutPointerSenderKeyMessage;

typedef struct {
  const SignalSenderKeyMessage *raw;
} SignalConstPointerSenderKeyMessage;

typedef struct {
  SignalServerMessageAck *raw;
} SignalMutPointerServerMessageAck;

typedef struct {
  const SignalServerMessageAck *raw;
} SignalConstPointerServerMessageAck;

typedef struct {
  SignalServerPublicParams *raw;
} SignalMutPointerServerPublicParams;

typedef struct {
  SignalServerSecretParams *raw;
} SignalMutPointerServerSecretParams;

typedef struct {
  const SignalSgxClientState *raw;
} SignalConstPointerSgxClientState;

typedef struct {
  SignalTokioAsyncContext *raw;
} SignalMutPointerTokioAsyncContext;

typedef struct {
  SignalUnauthenticatedChatConnection *raw;
} SignalMutPointerUnauthenticatedChatConnection;

/**
 * A C callback used to report the results of Rust futures.
 *
 * cbindgen will produce independent C types like `SignalCPromisei32` and
 * `SignalCPromiseProtocolAddress`.
 *
 * This derives Copy because it behaves like a C type; nevertheless, a promise should still only be
 * completed once.
 */
typedef struct {
  void (*complete)(SignalFfiError *error, const SignalMutPointerUnauthenticatedChatConnection *result, const void *context);
  const void *context;
  SignalCancellationId cancellation_id;
} SignalCPromiseMutPointerUnauthenticatedChatConnection;

/**
 * A C callback used to report the results of Rust futures.
 *
 * cbindgen will produce independent C types like `SignalCPromisei32` and
 * `SignalCPromiseProtocolAddress`.
 *
 * This derives Copy because it behaves like a C type; nevertheless, a promise should still only be
 * completed once.
 */
typedef struct {
  void (*complete)(SignalFfiError *error, const SignalOptionalUuid *result, const void *context);
  const void *context;
  SignalCancellationId cancellation_id;
} SignalCPromiseOptionalUuid;

typedef struct {
  SignalValidatingMac *raw;
} SignalMutPointerValidatingMac;

typedef SignalInputStream SignalSyncInputStream;

typedef struct {
  const SignalSyncInputStream *raw;
} SignalConstPointerFfiSyncInputStreamStruct;

typedef uint8_t SignalRandomnessBytes[SignalRANDOMNESS_LEN];

typedef uint8_t SignalUnidentifiedAccessKey[SignalACCESS_KEY_LEN];

SignalFfiError *signal_account_entropy_pool_derive_backup_key(uint8_t (*out)[SignalBACKUP_KEY_LEN], const char *account_entropy);

SignalFfiError *signal_account_entropy_pool_derive_svr_key(uint8_t (*out)[SignalSVR_KEY_LEN], const char *account_entropy);

SignalFfiError *signal_account_entropy_pool_generate(const char **out);

SignalFfiError *signal_account_entropy_pool_is_valid(bool *out, const char *account_entropy);

SignalFfiError *signal_address_clone(SignalMutPointerProtocolAddress *new_obj, SignalConstPointerProtocolAddress obj);

SignalFfiError *signal_address_destroy(SignalMutPointerProtocolAddress p);

SignalFfiError *signal_address_get_device_id(uint32_t *out, SignalConstPointerProtocolAddress obj);

SignalFfiError *signal_address_get_name(const char **out, SignalConstPointerProtocolAddress obj);

SignalFfiError *signal_address_new(SignalMutPointerProtocolAddress *out, const char *name, uint32_t device_id);

SignalFfiError *signal_aes256_ctr32_destroy(SignalMutPointerAes256Ctr32 p);

SignalFfiError *signal_aes256_ctr32_new(SignalMutPointerAes256Ctr32 *out, SignalBorrowedBuffer key, SignalBorrowedBuffer nonce, uint32_t initial_ctr);

SignalFfiError *signal_aes256_ctr32_process(SignalMutPointerAes256Ctr32 ctr, SignalBorrowedMutableBuffer data, uint32_t offset, uint32_t length);

SignalFfiError *signal_aes256_gcm_decryption_destroy(SignalMutPointerAes256GcmDecryption p);

SignalFfiError *signal_aes256_gcm_decryption_new(SignalMutPointerAes256GcmDecryption *out, SignalBorrowedBuffer key, SignalBorrowedBuffer nonce, SignalBorrowedBuffer associated_data);

SignalFfiError *signal_aes256_gcm_decryption_update(SignalMutPointerAes256GcmDecryption gcm, SignalBorrowedMutableBuffer data, uint32_t offset, uint32_t length);

SignalFfiError *signal_aes256_gcm_decryption_verify_tag(bool *out, SignalMutPointerAes256GcmDecryption gcm, SignalBorrowedBuffer tag);

SignalFfiError *signal_aes256_gcm_encryption_compute_tag(SignalOwnedBuffer *out, SignalMutPointerAes256GcmEncryption gcm);

SignalFfiError *signal_aes256_gcm_encryption_destroy(SignalMutPointerAes256GcmEncryption p);

SignalFfiError *signal_aes256_gcm_encryption_new(SignalMutPointerAes256GcmEncryption *out, SignalBorrowedBuffer key, SignalBorrowedBuffer nonce, SignalBorrowedBuffer associated_data);

SignalFfiError *signal_aes256_gcm_encryption_update(SignalMutPointerAes256GcmEncryption gcm, SignalBorrowedMutableBuffer data, uint32_t offset, uint32_t length);

SignalFfiError *signal_aes256_gcm_siv_decrypt(SignalOwnedBuffer *out, SignalConstPointerAes256GcmSiv aes_gcm_siv, SignalBorrowedBuffer ctext, SignalBorrowedBuffer nonce, SignalBorrowedBuffer associated_data);

SignalFfiError *signal_aes256_gcm_siv_destroy(SignalMutPointerAes256GcmSiv p);

SignalFfiError *signal_aes256_gcm_siv_encrypt(SignalOwnedBuffer *out, SignalConstPointerAes256GcmSiv aes_gcm_siv_obj, SignalBorrowedBuffer ptext, SignalBorrowedBuffer nonce, SignalBorrowedBuffer associated_data);

SignalFfiError *signal_aes256_gcm_siv_new(SignalMutPointerAes256GcmSiv *out, SignalBorrowedBuffer key);

SignalFfiError *signal_auth_credential_presentation_check_valid_contents(SignalBorrowedBuffer presentation_bytes);

SignalFfiError *signal_auth_credential_presentation_get_pni_ciphertext(unsigned char (*out)[SignalUUID_CIPHERTEXT_LEN], SignalBorrowedBuffer presentation_bytes);

SignalFfiError *signal_auth_credential_presentation_get_redemption_time(uint64_t *out, SignalBorrowedBuffer presentation_bytes);

SignalFfiError *signal_auth_credential_presentation_get_uuid_ciphertext(unsigned char (*out)[SignalUUID_CIPHERTEXT_LEN], SignalBorrowedBuffer presentation_bytes);

SignalFfiError *signal_auth_credential_with_pni_check_valid_contents(SignalBorrowedBuffer bytes);

SignalFfiError *signal_auth_credential_with_pni_response_check_valid_contents(SignalBorrowedBuffer bytes);

SignalFfiError *signal_authenticated_chat_connection_connect(SignalCPromiseMutPointerAuthenticatedChatConnection *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalConstPointerConnectionManager connection_manager, const char *username, const char *password, bool receive_stories, SignalBorrowedBytestringArray languages);

SignalFfiError *signal_authenticated_chat_connection_destroy(SignalMutPointerAuthenticatedChatConnection p);

SignalFfiError *signal_authenticated_chat_connection_disconnect(SignalCPromisebool *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalConstPointerAuthenticatedChatConnection chat);

SignalFfiError *signal_authenticated_chat_connection_info(SignalMutPointerChatConnectionInfo *out, SignalConstPointerAuthenticatedChatConnection chat);

SignalFfiError *signal_authenticated_chat_connection_init_listener(SignalConstPointerAuthenticatedChatConnection chat, SignalConstPointerFfiChatListenerStruct listener);

SignalFfiError *signal_authenticated_chat_connection_preconnect(SignalCPromisebool *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalConstPointerConnectionManager connection_manager);

SignalFfiError *signal_authenticated_chat_connection_send(SignalCPromiseFfiChatResponse *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalConstPointerAuthenticatedChatConnection chat, SignalConstPointerHttpRequest http_request, uint32_t timeout_millis);

SignalFfiError *signal_backup_auth_credential_check_valid_contents(SignalBorrowedBuffer params_bytes);

SignalFfiError *signal_backup_auth_credential_get_backup_id(uint8_t (*out)[16], SignalBorrowedBuffer credential_bytes);

SignalFfiError *signal_backup_auth_credential_get_backup_level(uint8_t *out, SignalBorrowedBuffer credential_bytes);

SignalFfiError *signal_backup_auth_credential_get_type(uint8_t *out, SignalBorrowedBuffer credential_bytes);

SignalFfiError *signal_backup_auth_credential_present_deterministic(SignalOwnedBuffer *out, SignalBorrowedBuffer credential_bytes, SignalBorrowedBuffer server_params_bytes, const uint8_t (*randomness)[SignalRANDOMNESS_LEN]);

SignalFfiError *signal_backup_auth_credential_presentation_check_valid_contents(SignalBorrowedBuffer presentation_bytes);

SignalFfiError *signal_backup_auth_credential_presentation_verify(SignalBorrowedBuffer presentation_bytes, uint64_t now, SignalBorrowedBuffer server_params_bytes);

SignalFfiError *signal_backup_auth_credential_request_check_valid_contents(SignalBorrowedBuffer request_bytes);

SignalFfiError *signal_backup_auth_credential_request_context_check_valid_contents(SignalBorrowedBuffer context_bytes);

SignalFfiError *signal_backup_auth_credential_request_context_get_request(SignalOwnedBuffer *out, SignalBorrowedBuffer context_bytes);

SignalFfiError *signal_backup_auth_credential_request_context_new(SignalOwnedBuffer *out, const uint8_t (*backup_key)[32], const uint8_t (*uuid)[16]);

SignalFfiError *signal_backup_auth_credential_request_context_receive_response(SignalOwnedBuffer *out, SignalBorrowedBuffer context_bytes, SignalBorrowedBuffer response_bytes, uint64_t expected_redemption_time, SignalBorrowedBuffer params_bytes);

SignalFfiError *signal_backup_auth_credential_request_issue_deterministic(SignalOwnedBuffer *out, SignalBorrowedBuffer request_bytes, uint64_t redemption_time, uint8_t backup_level, uint8_t credential_type, SignalBorrowedBuffer params_bytes, const uint8_t (*randomness)[SignalRANDOMNESS_LEN]);

SignalFfiError *signal_backup_auth_credential_response_check_valid_contents(SignalBorrowedBuffer response_bytes);

SignalFfiError *signal_backup_key_derive_backup_id(uint8_t (*out)[16], const uint8_t (*backup_key)[SignalBACKUP_KEY_LEN], const SignalServiceIdFixedWidthBinaryBytes *aci);

SignalFfiError *signal_backup_key_derive_ec_key(SignalMutPointerPrivateKey *out, const uint8_t (*backup_key)[SignalBACKUP_KEY_LEN], const SignalServiceIdFixedWidthBinaryBytes *aci);

SignalFfiError *signal_backup_key_derive_local_backup_metadata_key(uint8_t (*out)[SignalLOCAL_BACKUP_METADATA_KEY_LEN], const uint8_t (*backup_key)[SignalBACKUP_KEY_LEN]);

SignalFfiError *signal_backup_key_derive_media_encryption_key(uint8_t (*out)[SignalMEDIA_ENCRYPTION_KEY_LEN], const uint8_t (*backup_key)[SignalBACKUP_KEY_LEN], const uint8_t (*media_id)[SignalMEDIA_ID_LEN]);

SignalFfiError *signal_backup_key_derive_media_id(uint8_t (*out)[SignalMEDIA_ID_LEN], const uint8_t (*backup_key)[SignalBACKUP_KEY_LEN], const char *media_name);

SignalFfiError *signal_backup_key_derive_thumbnail_transit_encryption_key(uint8_t (*out)[SignalMEDIA_ENCRYPTION_KEY_LEN], const uint8_t (*backup_key)[SignalBACKUP_KEY_LEN], const uint8_t (*media_id)[SignalMEDIA_ID_LEN]);

SignalFfiError *signal_backup_restore_response_destroy(SignalMutPointerBackupRestoreResponse p);

SignalFfiError *signal_backup_restore_response_get_forward_secrecy_token(uint8_t (*out)[SignalBACKUP_FORWARD_SECRECY_TOKEN_LEN], SignalConstPointerBackupRestoreResponse response);

SignalFfiError *signal_backup_restore_response_get_next_backup_secret_data(SignalOwnedBuffer *out, SignalConstPointerBackupRestoreResponse response);

SignalFfiError *signal_backup_store_response_destroy(SignalMutPointerBackupStoreResponse p);

SignalFfiError *signal_backup_store_response_get_forward_secrecy_token(uint8_t (*out)[SignalBACKUP_FORWARD_SECRECY_TOKEN_LEN], SignalConstPointerBackupStoreResponse response);

SignalFfiError *signal_backup_store_response_get_next_backup_secret_data(SignalOwnedBuffer *out, SignalConstPointerBackupStoreResponse response);

SignalFfiError *signal_backup_store_response_get_opaque_metadata(SignalOwnedBuffer *out, SignalConstPointerBackupStoreResponse response);

SignalFfiError *signal_bridged_string_map_clone(SignalMutPointerBridgedStringMap *new_obj, SignalConstPointerBridgedStringMap obj);

SignalFfiError *signal_bridged_string_map_destroy(SignalMutPointerBridgedStringMap p);

SignalFfiError *signal_bridged_string_map_insert(SignalMutPointerBridgedStringMap map, const char *key, const char *value);

SignalFfiError *signal_bridged_string_map_new(SignalMutPointerBridgedStringMap *out, uint32_t initial_capacity);

SignalFfiError *signal_call_link_auth_credential_check_valid_contents(SignalBorrowedBuffer credential_bytes);

SignalFfiError *signal_call_link_auth_credential_present_deterministic(SignalOwnedBuffer *out, SignalBorrowedBuffer credential_bytes, const SignalServiceIdFixedWidthBinaryBytes *user_id, uint64_t redemption_time, SignalBorrowedBuffer server_params_bytes, SignalBorrowedBuffer call_link_params_bytes, const uint8_t (*randomness)[SignalRANDOMNESS_LEN]);

SignalFfiError *signal_call_link_auth_credential_presentation_check_valid_contents(SignalBorrowedBuffer presentation_bytes);

SignalFfiError *signal_call_link_auth_credential_presentation_get_user_id(unsigned char (*out)[SignalUUID_CIPHERTEXT_LEN], SignalBorrowedBuffer presentation_bytes);

SignalFfiError *signal_call_link_auth_credential_presentation_verify(SignalBorrowedBuffer presentation_bytes, uint64_t now, SignalBorrowedBuffer server_params_bytes, SignalBorrowedBuffer call_link_params_bytes);

SignalFfiError *signal_call_link_auth_credential_response_check_valid_contents(SignalBorrowedBuffer response_bytes);

SignalFfiError *signal_call_link_auth_credential_response_issue_deterministic(SignalOwnedBuffer *out, const SignalServiceIdFixedWidthBinaryBytes *user_id, uint64_t redemption_time, SignalBorrowedBuffer params_bytes, const uint8_t (*randomness)[SignalRANDOMNESS_LEN]);

SignalFfiError *signal_call_link_auth_credential_response_receive(SignalOwnedBuffer *out, SignalBorrowedBuffer response_bytes, const SignalServiceIdFixedWidthBinaryBytes *user_id, uint64_t redemption_time, SignalBorrowedBuffer params_bytes);

SignalFfiError *signal_call_link_public_params_check_valid_contents(SignalBorrowedBuffer params_bytes);

SignalFfiError *signal_call_link_secret_params_check_valid_contents(SignalBorrowedBuffer params_bytes);

SignalFfiError *signal_call_link_secret_params_decrypt_user_id(SignalServiceIdFixedWidthBinaryBytes *out, SignalBorrowedBuffer params_bytes, const unsigned char (*user_id)[SignalUUID_CIPHERTEXT_LEN]);

SignalFfiError *signal_call_link_secret_params_derive_from_root_key(SignalOwnedBuffer *out, SignalBorrowedBuffer root_key);

SignalFfiError *signal_call_link_secret_params_encrypt_user_id(unsigned char (*out)[SignalUUID_CIPHERTEXT_LEN], SignalBorrowedBuffer params_bytes, const SignalServiceIdFixedWidthBinaryBytes *user_id);

SignalFfiError *signal_call_link_secret_params_get_public_params(SignalOwnedBuffer *out, SignalBorrowedBuffer params_bytes);

SignalFfiError *signal_cds2_client_state_new(SignalMutPointerSgxClientState *out, SignalBorrowedBuffer mrenclave, SignalBorrowedBuffer attestation_msg, uint64_t current_timestamp);

SignalFfiError *signal_cdsi_lookup_complete(SignalCPromiseFfiCdsiLookupResponse *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalConstPointerCdsiLookup lookup);

SignalFfiError *signal_cdsi_lookup_destroy(SignalMutPointerCdsiLookup p);

SignalFfiError *signal_cdsi_lookup_new(SignalCPromiseMutPointerCdsiLookup *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalConstPointerConnectionManager connection_manager, const char *username, const char *password, SignalConstPointerLookupRequest request);

SignalFfiError *signal_cdsi_lookup_token(SignalOwnedBuffer *out, SignalConstPointerCdsiLookup lookup);

SignalFfiError *signal_chat_connection_info_description(const char **out, SignalConstPointerChatConnectionInfo connection_info);

SignalFfiError *signal_chat_connection_info_ip_version(uint8_t *out, SignalConstPointerChatConnectionInfo connection_info);

SignalFfiError *signal_chat_connection_info_local_port(uint16_t *out, SignalConstPointerChatConnectionInfo connection_info);

SignalFfiError *signal_ciphertext_message_destroy(SignalMutPointerCiphertextMessage p);

SignalFfiError *signal_ciphertext_message_from_plaintext_content(SignalMutPointerCiphertextMessage *out, SignalConstPointerPlaintextContent m);

SignalFfiError *signal_ciphertext_message_serialize(SignalOwnedBuffer *out, SignalConstPointerCiphertextMessage obj);

SignalFfiError *signal_ciphertext_message_type(uint8_t *out, SignalConstPointerCiphertextMessage msg);

SignalFfiError *signal_connection_info_destroy(SignalMutPointerConnectionInfo p);

SignalFfiError *signal_connection_manager_clear_proxy(SignalConstPointerConnectionManager connection_manager);

SignalFfiError *signal_connection_manager_destroy(SignalMutPointerConnectionManager p);

SignalFfiError *signal_connection_manager_new(SignalMutPointerConnectionManager *out, uint8_t environment, const char *user_agent, SignalMutPointerBridgedStringMap remote_config, uint8_t build_variant);

SignalFfiError *signal_connection_manager_on_network_change(SignalConstPointerConnectionManager connection_manager);

SignalFfiError *signal_connection_manager_set_censorship_circumvention_enabled(SignalConstPointerConnectionManager connection_manager, bool enabled);

SignalFfiError *signal_connection_manager_set_invalid_proxy(SignalConstPointerConnectionManager connection_manager);

SignalFfiError *signal_connection_manager_set_proxy(SignalConstPointerConnectionManager connection_manager, SignalConstPointerConnectionProxyConfig proxy);

SignalFfiError *signal_connection_manager_set_remote_config(SignalConstPointerConnectionManager connection_manager, SignalMutPointerBridgedStringMap remote_config, uint8_t build_variant);

SignalFfiError *signal_connection_proxy_config_clone(SignalMutPointerConnectionProxyConfig *new_obj, SignalConstPointerConnectionProxyConfig obj);

SignalFfiError *signal_connection_proxy_config_destroy(SignalMutPointerConnectionProxyConfig p);

SignalFfiError *signal_connection_proxy_config_new(SignalMutPointerConnectionProxyConfig *out, const char *scheme, const char *host, int32_t port, const char *username, const char *password);

SignalFfiError *signal_create_call_link_credential_check_valid_contents(SignalBorrowedBuffer params_bytes);

SignalFfiError *signal_create_call_link_credential_present_deterministic(SignalOwnedBuffer *out, SignalBorrowedBuffer credential_bytes, SignalBorrowedBuffer room_id, const SignalServiceIdFixedWidthBinaryBytes *user_id, SignalBorrowedBuffer server_params_bytes, SignalBorrowedBuffer call_link_params_bytes, const uint8_t (*randomness)[SignalRANDOMNESS_LEN]);

SignalFfiError *signal_create_call_link_credential_presentation_check_valid_contents(SignalBorrowedBuffer presentation_bytes);

SignalFfiError *signal_create_call_link_credential_presentation_verify(SignalBorrowedBuffer presentation_bytes, SignalBorrowedBuffer room_id, uint64_t now, SignalBorrowedBuffer server_params_bytes, SignalBorrowedBuffer call_link_params_bytes);

SignalFfiError *signal_create_call_link_credential_request_check_valid_contents(SignalBorrowedBuffer request_bytes);

SignalFfiError *signal_create_call_link_credential_request_context_check_valid_contents(SignalBorrowedBuffer context_bytes);

SignalFfiError *signal_create_call_link_credential_request_context_get_request(SignalOwnedBuffer *out, SignalBorrowedBuffer context_bytes);

SignalFfiError *signal_create_call_link_credential_request_context_new_deterministic(SignalOwnedBuffer *out, SignalBorrowedBuffer room_id, const uint8_t (*randomness)[SignalRANDOMNESS_LEN]);

SignalFfiError *signal_create_call_link_credential_request_context_receive_response(SignalOwnedBuffer *out, SignalBorrowedBuffer context_bytes, SignalBorrowedBuffer response_bytes, const SignalServiceIdFixedWidthBinaryBytes *user_id, SignalBorrowedBuffer params_bytes);

SignalFfiError *signal_create_call_link_credential_request_issue_deterministic(SignalOwnedBuffer *out, SignalBorrowedBuffer request_bytes, const SignalServiceIdFixedWidthBinaryBytes *user_id, uint64_t timestamp, SignalBorrowedBuffer params_bytes, const uint8_t (*randomness)[SignalRANDOMNESS_LEN]);

SignalFfiError *signal_create_call_link_credential_response_check_valid_contents(SignalBorrowedBuffer response_bytes);

SignalFfiError *signal_decrypt_message(SignalOwnedBuffer *out, SignalConstPointerSignalMessage message, SignalConstPointerProtocolAddress protocol_address, SignalConstPointerFfiSessionStoreStruct session_store, SignalConstPointerFfiIdentityKeyStoreStruct identity_key_store);

SignalFfiError *signal_decrypt_pre_key_message(SignalOwnedBuffer *out, SignalConstPointerPreKeySignalMessage message, SignalConstPointerProtocolAddress protocol_address, SignalConstPointerFfiSessionStoreStruct session_store, SignalConstPointerFfiIdentityKeyStoreStruct identity_key_store, SignalConstPointerFfiPreKeyStoreStruct prekey_store, SignalConstPointerFfiSignedPreKeyStoreStruct signed_prekey_store, SignalConstPointerFfiKyberPreKeyStoreStruct kyber_prekey_store);

SignalFfiError *signal_decryption_error_message_clone(SignalMutPointerDecryptionErrorMessage *new_obj, SignalConstPointerDecryptionErrorMessage obj);

SignalFfiError *signal_decryption_error_message_deserialize(SignalMutPointerDecryptionErrorMessage *out, SignalBorrowedBuffer data);

SignalFfiError *signal_decryption_error_message_destroy(SignalMutPointerDecryptionErrorMessage p);

SignalFfiError *signal_decryption_error_message_extract_from_serialized_content(SignalMutPointerDecryptionErrorMessage *out, SignalBorrowedBuffer bytes);

SignalFfiError *signal_decryption_error_message_for_original_message(SignalMutPointerDecryptionErrorMessage *out, SignalBorrowedBuffer original_bytes, uint8_t original_type, uint64_t original_timestamp, uint32_t original_sender_device_id);

SignalFfiError *signal_decryption_error_message_get_device_id(uint32_t *out, SignalConstPointerDecryptionErrorMessage obj);

SignalFfiError *signal_decryption_error_message_get_ratchet_key(SignalMutPointerPublicKey *out, SignalConstPointerDecryptionErrorMessage m);

SignalFfiError *signal_decryption_error_message_get_timestamp(uint64_t *out, SignalConstPointerDecryptionErrorMessage obj);

SignalFfiError *signal_decryption_error_message_serialize(SignalOwnedBuffer *out, SignalConstPointerDecryptionErrorMessage obj);

SignalFfiError *signal_device_transfer_generate_certificate(SignalOwnedBuffer *out, SignalBorrowedBuffer private_key, const char *name, uint32_t days_to_expire);

SignalFfiError *signal_device_transfer_generate_private_key(SignalOwnedBuffer *out);

SignalFfiError *signal_device_transfer_generate_private_key_with_format(SignalOwnedBuffer *out, uint8_t key_format);

SignalFfiError *signal_encrypt_message(SignalMutPointerCiphertextMessage *out, SignalBorrowedBuffer ptext, SignalConstPointerProtocolAddress protocol_address, SignalConstPointerFfiSessionStoreStruct session_store, SignalConstPointerFfiIdentityKeyStoreStruct identity_key_store, uint64_t now);

void signal_error_free(SignalFfiError *err);

SignalFfiError *signal_error_get_address(SignalMutPointerProtocolAddress *out, SignalUnwindSafeArgSignalFfiError err);

SignalFfiError *signal_error_get_invalid_protocol_address(const char **name_out, uint32_t *device_id_out, const SignalFfiError *err);

SignalFfiError *signal_error_get_message(const char **out, SignalUnwindSafeArgSignalFfiError err);

SignalFfiError *signal_error_get_our_fingerprint_version(uint32_t *out, SignalUnwindSafeArgSignalFfiError err);

SignalFfiError *signal_error_get_rate_limit_challenge(const char **out_token, SignalOwnedBuffer *out_options, const SignalFfiError *err);

SignalFfiError *signal_error_get_registration_error_not_deliverable(const char **out_reason, bool *out_permanent, const SignalFfiError *err);

SignalFfiError *signal_error_get_registration_lock(uint64_t *out_time_remaining_seconds, const char **out_svr2_username, const char **out_svr2_password, const SignalFfiError *err);

SignalFfiError *signal_error_get_retry_after_seconds(uint32_t *out, SignalUnwindSafeArgSignalFfiError err);

SignalFfiError *signal_error_get_their_fingerprint_version(uint32_t *out, SignalUnwindSafeArgSignalFfiError err);

SignalFfiError *signal_error_get_tries_remaining(uint32_t *out, SignalUnwindSafeArgSignalFfiError err);

uint32_t signal_error_get_type(const SignalFfiError *err);

SignalFfiError *signal_error_get_unknown_fields(SignalStringArray *out, SignalUnwindSafeArgSignalFfiError err);

SignalFfiError *signal_error_get_uuid(uint8_t (*out)[16], SignalUnwindSafeArgSignalFfiError err);

SignalFfiError *signal_expiring_profile_key_credential_check_valid_contents(SignalBorrowedBuffer buffer);

SignalFfiError *signal_expiring_profile_key_credential_get_expiration_time(uint64_t *out, const unsigned char (*credential)[SignalEXPIRING_PROFILE_KEY_CREDENTIAL_LEN]);

SignalFfiError *signal_expiring_profile_key_credential_response_check_valid_contents(SignalBorrowedBuffer buffer);

SignalFfiError *signal_fingerprint_clone(SignalMutPointerFingerprint *new_obj, SignalConstPointerFingerprint obj);

SignalFfiError *signal_fingerprint_compare(bool *out, SignalBorrowedBuffer fprint1, SignalBorrowedBuffer fprint2);

SignalFfiError *signal_fingerprint_destroy(SignalMutPointerFingerprint p);

SignalFfiError *signal_fingerprint_display_string(const char **out, SignalConstPointerFingerprint obj);

SignalFfiError *signal_fingerprint_new(SignalMutPointerFingerprint *out, uint32_t iterations, uint32_t version, SignalBorrowedBuffer local_identifier, SignalConstPointerPublicKey local_key, SignalBorrowedBuffer remote_identifier, SignalConstPointerPublicKey remote_key);

SignalFfiError *signal_fingerprint_scannable_encoding(SignalOwnedBuffer *out, SignalConstPointerFingerprint obj);

void signal_free_buffer(const unsigned char *buf, size_t buf_len);

void signal_free_bytestring_array(SignalBytestringArray array);

void signal_free_list_of_register_response_badges(SignalOwnedBufferOfFfiRegisterResponseBadge buffer);

void signal_free_list_of_strings(SignalOwnedBufferOfCStringPtr buffer);

void signal_free_lookup_response_entry_list(SignalOwnedBufferOfFfiCdsiLookupResponseEntry buffer);

void signal_free_string(const char *buf);

SignalFfiError *signal_generic_server_public_params_check_valid_contents(SignalBorrowedBuffer params_bytes);

SignalFfiError *signal_generic_server_secret_params_check_valid_contents(SignalBorrowedBuffer params_bytes);

SignalFfiError *signal_generic_server_secret_params_generate_deterministic(SignalOwnedBuffer *out, const uint8_t (*randomness)[SignalRANDOMNESS_LEN]);

SignalFfiError *signal_generic_server_secret_params_get_public_params(SignalOwnedBuffer *out, SignalBorrowedBuffer params_bytes);

SignalFfiError *signal_group_decrypt_message(SignalOwnedBuffer *out, SignalConstPointerProtocolAddress sender, SignalBorrowedBuffer message, SignalConstPointerFfiSenderKeyStoreStruct store);

SignalFfiError *signal_group_encrypt_message(SignalMutPointerCiphertextMessage *out, SignalConstPointerProtocolAddress sender, const uint8_t (*distribution_id)[16], SignalBorrowedBuffer message, SignalConstPointerFfiSenderKeyStoreStruct store);

SignalFfiError *signal_group_master_key_check_valid_contents(SignalBorrowedBuffer buffer);

SignalFfiError *signal_group_public_params_check_valid_contents(SignalBorrowedBuffer buffer);

SignalFfiError *signal_group_public_params_get_group_identifier(uint8_t (*out)[SignalGROUP_IDENTIFIER_LEN], const unsigned char (*group_public_params)[SignalGROUP_PUBLIC_PARAMS_LEN]);

SignalFfiError *signal_group_secret_params_check_valid_contents(SignalBorrowedBuffer buffer);

SignalFfiError *signal_group_secret_params_decrypt_blob_with_padding(SignalOwnedBuffer *out, const unsigned char (*params)[SignalGROUP_SECRET_PARAMS_LEN], SignalBorrowedBuffer ciphertext);

SignalFfiError *signal_group_secret_params_decrypt_profile_key(unsigned char (*out)[SignalPROFILE_KEY_LEN], const unsigned char (*params)[SignalGROUP_SECRET_PARAMS_LEN], const unsigned char (*profile_key)[SignalPROFILE_KEY_CIPHERTEXT_LEN], const SignalServiceIdFixedWidthBinaryBytes *user_id);

SignalFfiError *signal_group_secret_params_decrypt_service_id(SignalServiceIdFixedWidthBinaryBytes *out, const unsigned char (*params)[SignalGROUP_SECRET_PARAMS_LEN], const unsigned char (*ciphertext)[SignalUUID_CIPHERTEXT_LEN]);

SignalFfiError *signal_group_secret_params_derive_from_master_key(unsigned char (*out)[SignalGROUP_SECRET_PARAMS_LEN], const unsigned char (*master_key)[SignalGROUP_MASTER_KEY_LEN]);

SignalFfiError *signal_group_secret_params_encrypt_blob_with_padding_deterministic(SignalOwnedBuffer *out, const unsigned char (*params)[SignalGROUP_SECRET_PARAMS_LEN], const uint8_t (*randomness)[SignalRANDOMNESS_LEN], SignalBorrowedBuffer plaintext, uint32_t padding_len);

SignalFfiError *signal_group_secret_params_encrypt_profile_key(unsigned char (*out)[SignalPROFILE_KEY_CIPHERTEXT_LEN], const unsigned char (*params)[SignalGROUP_SECRET_PARAMS_LEN], const unsigned char (*profile_key)[SignalPROFILE_KEY_LEN], const SignalServiceIdFixedWidthBinaryBytes *user_id);

SignalFfiError *signal_group_secret_params_encrypt_service_id(unsigned char (*out)[SignalUUID_CIPHERTEXT_LEN], const unsigned char (*params)[SignalGROUP_SECRET_PARAMS_LEN], const SignalServiceIdFixedWidthBinaryBytes *service_id);

SignalFfiError *signal_group_secret_params_generate_deterministic(unsigned char (*out)[SignalGROUP_SECRET_PARAMS_LEN], const uint8_t (*randomness)[SignalRANDOMNESS_LEN]);

SignalFfiError *signal_group_secret_params_get_master_key(unsigned char (*out)[SignalGROUP_MASTER_KEY_LEN], const unsigned char (*params)[SignalGROUP_SECRET_PARAMS_LEN]);

SignalFfiError *signal_group_secret_params_get_public_params(unsigned char (*out)[SignalGROUP_PUBLIC_PARAMS_LEN], const unsigned char (*params)[SignalGROUP_SECRET_PARAMS_LEN]);

SignalFfiError *signal_group_send_derived_key_pair_check_valid_contents(SignalBorrowedBuffer bytes);

SignalFfiError *signal_group_send_derived_key_pair_for_expiration(SignalOwnedBuffer *out, uint64_t expiration, SignalConstPointerServerSecretParams server_params);

SignalFfiError *signal_group_send_endorsement_call_link_params_to_token(SignalOwnedBuffer *out, SignalBorrowedBuffer endorsement, SignalBorrowedBuffer call_link_secret_params_serialized);

SignalFfiError *signal_group_send_endorsement_check_valid_contents(SignalBorrowedBuffer bytes);

SignalFfiError *signal_group_send_endorsement_combine(SignalOwnedBuffer *out, SignalBorrowedSliceOfBuffers endorsements);

SignalFfiError *signal_group_send_endorsement_remove(SignalOwnedBuffer *out, SignalBorrowedBuffer endorsement, SignalBorrowedBuffer to_remove);

SignalFfiError *signal_group_send_endorsement_to_token(SignalOwnedBuffer *out, SignalBorrowedBuffer endorsement, const unsigned char (*group_params)[SignalGROUP_SECRET_PARAMS_LEN]);

SignalFfiError *signal_group_send_endorsements_response_check_valid_contents(SignalBorrowedBuffer bytes);

SignalFfiError *signal_group_send_endorsements_response_get_expiration(uint64_t *out, SignalBorrowedBuffer response_bytes);

SignalFfiError *signal_group_send_endorsements_response_issue_deterministic(SignalOwnedBuffer *out, SignalBorrowedBuffer concatenated_group_member_ciphertexts, SignalBorrowedBuffer key_pair, const uint8_t (*randomness)[SignalRANDOMNESS_LEN]);

SignalFfiError *signal_group_send_endorsements_response_receive_and_combine_with_ciphertexts(SignalBytestringArray *out, SignalBorrowedBuffer response_bytes, SignalBorrowedBuffer concatenated_group_member_ciphertexts, SignalBorrowedBuffer local_user_ciphertext, uint64_t now, SignalConstPointerServerPublicParams server_params);

SignalFfiError *signal_group_send_endorsements_response_receive_and_combine_with_service_ids(SignalBytestringArray *out, SignalBorrowedBuffer response_bytes, SignalBorrowedBuffer group_members, const SignalServiceIdFixedWidthBinaryBytes *local_user, uint64_t now, const unsigned char (*group_params)[SignalGROUP_SECRET_PARAMS_LEN], SignalConstPointerServerPublicParams server_params);

SignalFfiError *signal_group_send_full_token_check_valid_contents(SignalBorrowedBuffer bytes);

SignalFfiError *signal_group_send_full_token_get_expiration(uint64_t *out, SignalBorrowedBuffer token);

SignalFfiError *signal_group_send_full_token_verify(SignalBorrowedBuffer token, SignalBorrowedBuffer user_ids, uint64_t now, SignalBorrowedBuffer key_pair);

SignalFfiError *signal_group_send_token_check_valid_contents(SignalBorrowedBuffer bytes);

SignalFfiError *signal_group_send_token_to_full_token(SignalOwnedBuffer *out, SignalBorrowedBuffer token, uint64_t expiration);

SignalFfiError *signal_hex_encode(SignalBorrowedMutableBuffer output, SignalBorrowedBuffer input);

SignalFfiError *signal_hkdf_derive(SignalBorrowedMutableBuffer output, SignalBorrowedBuffer ikm, SignalBorrowedBuffer label, SignalBorrowedBuffer salt);

SignalFfiError *signal_hsm_enclave_client_complete_handshake(SignalMutPointerHsmEnclaveClient cli, SignalBorrowedBuffer handshake_received);

SignalFfiError *signal_hsm_enclave_client_destroy(SignalMutPointerHsmEnclaveClient p);

SignalFfiError *signal_hsm_enclave_client_established_recv(SignalOwnedBuffer *out, SignalMutPointerHsmEnclaveClient cli, SignalBorrowedBuffer received_ciphertext);

SignalFfiError *signal_hsm_enclave_client_established_send(SignalOwnedBuffer *out, SignalMutPointerHsmEnclaveClient cli, SignalBorrowedBuffer plaintext_to_send);

SignalFfiError *signal_hsm_enclave_client_initial_request(SignalOwnedBuffer *out, SignalConstPointerHsmEnclaveClient obj);

SignalFfiError *signal_hsm_enclave_client_new(SignalMutPointerHsmEnclaveClient *out, SignalBorrowedBuffer trusted_public_key, SignalBorrowedBuffer trusted_code_hashes);

SignalFfiError *signal_http_request_add_header(SignalConstPointerHttpRequest request, const char *name, const char *value);

SignalFfiError *signal_http_request_destroy(SignalMutPointerHttpRequest p);

SignalFfiError *signal_http_request_new_with_body(SignalMutPointerHttpRequest *out, const char *method, const char *path, SignalBorrowedBuffer body_as_slice);

SignalFfiError *signal_http_request_new_without_body(SignalMutPointerHttpRequest *out, const char *method, const char *path);

SignalFfiError *signal_identitykey_verify_alternate_identity(bool *out, SignalConstPointerPublicKey public_key, SignalConstPointerPublicKey other_identity, SignalBorrowedBuffer signature);

SignalFfiError *signal_identitykeypair_deserialize(SignalMutPointerPrivateKey *private_key, SignalMutPointerPublicKey *public_key, SignalBorrowedBuffer input);

SignalFfiError *signal_identitykeypair_serialize(SignalOwnedBuffer *out, SignalConstPointerPublicKey public_key, SignalConstPointerPrivateKey private_key);

SignalFfiError *signal_identitykeypair_sign_alternate_identity(SignalOwnedBuffer *out, SignalConstPointerPublicKey public_key, SignalConstPointerPrivateKey private_key, SignalConstPointerPublicKey other_identity);

SignalFfiError *signal_incremental_mac_calculate_chunk_size(uint32_t *out, uint32_t data_size);

SignalFfiError *signal_incremental_mac_destroy(SignalMutPointerIncrementalMac p);

SignalFfiError *signal_incremental_mac_finalize(SignalOwnedBuffer *out, SignalMutPointerIncrementalMac mac);

SignalFfiError *signal_incremental_mac_initialize(SignalMutPointerIncrementalMac *out, SignalBorrowedBuffer key, uint32_t chunk_size);

SignalFfiError *signal_incremental_mac_update(SignalOwnedBuffer *out, SignalMutPointerIncrementalMac mac, SignalBorrowedBuffer bytes, uint32_t offset, uint32_t length);

bool signal_init_logger(SignalLogLevel max_level, SignalFfiLogger logger);

SignalFfiError *signal_key_transparency_aci_search_key(SignalOwnedBuffer *out, const SignalServiceIdFixedWidthBinaryBytes *aci);

SignalFfiError *signal_key_transparency_distinguished(SignalCPromiseOwnedBufferOfc_uchar *promise, SignalConstPointerTokioAsyncContext async_runtime, uint8_t environment, SignalConstPointerUnauthenticatedChatConnection chat_connection, SignalOptionalBorrowedSliceOfc_uchar last_distinguished_tree_head);

SignalFfiError *signal_key_transparency_e164_search_key(SignalOwnedBuffer *out, const char *e164);

SignalFfiError *signal_key_transparency_monitor(SignalCPromiseOwnedBufferOfc_uchar *promise, SignalConstPointerTokioAsyncContext async_runtime, uint8_t environment, SignalConstPointerUnauthenticatedChatConnection chat_connection, const SignalServiceIdFixedWidthBinaryBytes *aci, SignalConstPointerPublicKey aci_identity_key, const char *e164, SignalOptionalBorrowedSliceOfc_uchar unidentified_access_key, SignalOptionalBorrowedSliceOfc_uchar username_hash, SignalOptionalBorrowedSliceOfc_uchar account_data, SignalBorrowedBuffer last_distinguished_tree_head, bool is_self_monitor);

SignalFfiError *signal_key_transparency_search(SignalCPromiseOwnedBufferOfc_uchar *promise, SignalConstPointerTokioAsyncContext async_runtime, uint8_t environment, SignalConstPointerUnauthenticatedChatConnection chat_connection, const SignalServiceIdFixedWidthBinaryBytes *aci, SignalConstPointerPublicKey aci_identity_key, const char *e164, SignalOptionalBorrowedSliceOfc_uchar unidentified_access_key, SignalOptionalBorrowedSliceOfc_uchar username_hash, SignalOptionalBorrowedSliceOfc_uchar account_data, SignalBorrowedBuffer last_distinguished_tree_head);

SignalFfiError *signal_key_transparency_username_hash_search_key(SignalOwnedBuffer *out, SignalBorrowedBuffer hash);

SignalFfiError *signal_kyber_key_pair_clone(SignalMutPointerKyberKeyPair *new_obj, SignalConstPointerKyberKeyPair obj);

SignalFfiError *signal_kyber_key_pair_destroy(SignalMutPointerKyberKeyPair p);

SignalFfiError *signal_kyber_key_pair_generate(SignalMutPointerKyberKeyPair *out);

SignalFfiError *signal_kyber_key_pair_get_public_key(SignalMutPointerKyberPublicKey *out, SignalConstPointerKyberKeyPair key_pair);

SignalFfiError *signal_kyber_key_pair_get_secret_key(SignalMutPointerKyberSecretKey *out, SignalConstPointerKyberKeyPair key_pair);

SignalFfiError *signal_kyber_pre_key_record_clone(SignalMutPointerKyberPreKeyRecord *new_obj, SignalConstPointerKyberPreKeyRecord obj);

SignalFfiError *signal_kyber_pre_key_record_deserialize(SignalMutPointerKyberPreKeyRecord *out, SignalBorrowedBuffer data);

SignalFfiError *signal_kyber_pre_key_record_destroy(SignalMutPointerKyberPreKeyRecord p);

SignalFfiError *signal_kyber_pre_key_record_get_id(uint32_t *out, SignalConstPointerKyberPreKeyRecord obj);

SignalFfiError *signal_kyber_pre_key_record_get_key_pair(SignalMutPointerKyberKeyPair *out, SignalConstPointerKyberPreKeyRecord obj);

SignalFfiError *signal_kyber_pre_key_record_get_public_key(SignalMutPointerKyberPublicKey *out, SignalConstPointerKyberPreKeyRecord obj);

SignalFfiError *signal_kyber_pre_key_record_get_secret_key(SignalMutPointerKyberSecretKey *out, SignalConstPointerKyberPreKeyRecord obj);

SignalFfiError *signal_kyber_pre_key_record_get_signature(SignalOwnedBuffer *out, SignalConstPointerKyberPreKeyRecord obj);

SignalFfiError *signal_kyber_pre_key_record_get_timestamp(uint64_t *out, SignalConstPointerKyberPreKeyRecord obj);

SignalFfiError *signal_kyber_pre_key_record_new(SignalMutPointerKyberPreKeyRecord *out, uint32_t id, uint64_t timestamp, SignalConstPointerKyberKeyPair key_pair, SignalBorrowedBuffer signature);

SignalFfiError *signal_kyber_pre_key_record_serialize(SignalOwnedBuffer *out, SignalConstPointerKyberPreKeyRecord obj);

SignalFfiError *signal_kyber_public_key_clone(SignalMutPointerKyberPublicKey *new_obj, SignalConstPointerKyberPublicKey obj);

SignalFfiError *signal_kyber_public_key_deserialize(SignalMutPointerKyberPublicKey *out, SignalBorrowedBuffer data);

SignalFfiError *signal_kyber_public_key_destroy(SignalMutPointerKyberPublicKey p);

SignalFfiError *signal_kyber_public_key_equals(bool *out, SignalConstPointerKyberPublicKey lhs, SignalConstPointerKyberPublicKey rhs);

SignalFfiError *signal_kyber_public_key_serialize(SignalOwnedBuffer *out, SignalConstPointerKyberPublicKey obj);

SignalFfiError *signal_kyber_secret_key_clone(SignalMutPointerKyberSecretKey *new_obj, SignalConstPointerKyberSecretKey obj);

SignalFfiError *signal_kyber_secret_key_deserialize(SignalMutPointerKyberSecretKey *out, SignalBorrowedBuffer data);

SignalFfiError *signal_kyber_secret_key_destroy(SignalMutPointerKyberSecretKey p);

SignalFfiError *signal_kyber_secret_key_serialize(SignalOwnedBuffer *out, SignalConstPointerKyberSecretKey obj);

SignalFfiError *signal_lookup_request_add_aci_and_access_key(SignalConstPointerLookupRequest request, const SignalServiceIdFixedWidthBinaryBytes *aci, SignalBorrowedBuffer access_key);

SignalFfiError *signal_lookup_request_add_e164(SignalConstPointerLookupRequest request, const char *e164);

SignalFfiError *signal_lookup_request_add_previous_e164(SignalConstPointerLookupRequest request, const char *e164);

SignalFfiError *signal_lookup_request_destroy(SignalMutPointerLookupRequest p);

SignalFfiError *signal_lookup_request_new(SignalMutPointerLookupRequest *out);

SignalFfiError *signal_lookup_request_set_token(SignalConstPointerLookupRequest request, SignalBorrowedBuffer token);

SignalFfiError *signal_message_backup_key_destroy(SignalMutPointerMessageBackupKey p);

SignalFfiError *signal_message_backup_key_from_account_entropy_pool(SignalMutPointerMessageBackupKey *out, const char *account_entropy, const SignalServiceIdFixedWidthBinaryBytes *aci, const uint8_t (*forward_secrecy_token)[SignalBACKUP_FORWARD_SECRECY_TOKEN_LEN]);

SignalFfiError *signal_message_backup_key_from_backup_key_and_backup_id(SignalMutPointerMessageBackupKey *out, const uint8_t (*backup_key)[32], const uint8_t (*backup_id)[16], const uint8_t (*forward_secrecy_token)[SignalBACKUP_FORWARD_SECRECY_TOKEN_LEN]);

SignalFfiError *signal_message_backup_key_get_aes_key(uint8_t (*out)[32], SignalConstPointerMessageBackupKey key);

SignalFfiError *signal_message_backup_key_get_hmac_key(uint8_t (*out)[32], SignalConstPointerMessageBackupKey key);

SignalFfiError *signal_message_backup_validation_outcome_destroy(SignalMutPointerMessageBackupValidationOutcome p);

SignalFfiError *signal_message_backup_validation_outcome_get_error_message(const char **out, SignalConstPointerMessageBackupValidationOutcome outcome);

SignalFfiError *signal_message_backup_validation_outcome_get_unknown_fields(SignalStringArray *out, SignalConstPointerMessageBackupValidationOutcome outcome);

SignalFfiError *signal_message_backup_validator_validate(SignalMutPointerMessageBackupValidationOutcome *out, SignalConstPointerMessageBackupKey key, SignalConstPointerFfiInputStreamStruct first_stream, SignalConstPointerFfiInputStreamStruct second_stream, uint64_t len, uint8_t purpose);

SignalFfiError *signal_message_clone(SignalMutPointerSignalMessage *new_obj, SignalConstPointerSignalMessage obj);

SignalFfiError *signal_message_deserialize(SignalMutPointerSignalMessage *out, SignalBorrowedBuffer data);

SignalFfiError *signal_message_destroy(SignalMutPointerSignalMessage p);

SignalFfiError *signal_message_get_body(SignalOwnedBuffer *out, SignalConstPointerSignalMessage obj);

SignalFfiError *signal_message_get_counter(uint32_t *out, SignalConstPointerSignalMessage obj);

SignalFfiError *signal_message_get_message_version(uint32_t *out, SignalConstPointerSignalMessage obj);

SignalFfiError *signal_message_get_pq_ratchet(SignalOwnedBuffer *out, SignalConstPointerSignalMessage msg);

SignalFfiError *signal_message_get_sender_ratchet_key(SignalMutPointerPublicKey *out, SignalConstPointerSignalMessage m);

SignalFfiError *signal_message_get_serialized(SignalOwnedBuffer *out, SignalConstPointerSignalMessage obj);

SignalFfiError *signal_message_new(SignalMutPointerSignalMessage *out, uint8_t message_version, SignalBorrowedBuffer mac_key, SignalConstPointerPublicKey sender_ratchet_key, uint32_t counter, uint32_t previous_counter, SignalBorrowedBuffer ciphertext, SignalConstPointerPublicKey sender_identity_key, SignalConstPointerPublicKey receiver_identity_key, SignalBorrowedBuffer pq_ratchet);

SignalFfiError *signal_message_verify_mac(bool *out, SignalConstPointerSignalMessage msg, SignalConstPointerPublicKey sender_identity_key, SignalConstPointerPublicKey receiver_identity_key, SignalBorrowedBuffer mac_key);

SignalFfiError *signal_mp4_sanitizer_sanitize(SignalMutPointerSanitizedMetadata *out, SignalConstPointerFfiInputStreamStruct input, uint64_t len);

SignalFfiError *signal_online_backup_validator_add_frame(SignalMutPointerOnlineBackupValidator backup, SignalBorrowedBuffer frame);

SignalFfiError *signal_online_backup_validator_destroy(SignalMutPointerOnlineBackupValidator p);

SignalFfiError *signal_online_backup_validator_finalize(SignalMutPointerOnlineBackupValidator backup);

SignalFfiError *signal_online_backup_validator_new(SignalMutPointerOnlineBackupValidator *out, SignalBorrowedBuffer backup_info_frame, uint8_t purpose);

SignalFfiError *signal_pin_hash_access_key(uint8_t (*out)[32], SignalConstPointerPinHash ph);

SignalFfiError *signal_pin_hash_clone(SignalMutPointerPinHash *new_obj, SignalConstPointerPinHash obj);

SignalFfiError *signal_pin_hash_destroy(SignalMutPointerPinHash p);

SignalFfiError *signal_pin_hash_encryption_key(uint8_t (*out)[32], SignalConstPointerPinHash ph);

SignalFfiError *signal_pin_hash_from_salt(SignalMutPointerPinHash *out, SignalBorrowedBuffer pin, const uint8_t (*salt)[32]);

SignalFfiError *signal_pin_hash_from_username_mrenclave(SignalMutPointerPinHash *out, SignalBorrowedBuffer pin, const char *username, SignalBorrowedBuffer mrenclave);

SignalFfiError *signal_pin_local_hash(const char **out, SignalBorrowedBuffer pin);

SignalFfiError *signal_pin_verify_local_hash(bool *out, const char *encoded_hash, SignalBorrowedBuffer pin);

SignalFfiError *signal_plaintext_content_clone(SignalMutPointerPlaintextContent *new_obj, SignalConstPointerPlaintextContent obj);

SignalFfiError *signal_plaintext_content_deserialize(SignalMutPointerPlaintextContent *out, SignalBorrowedBuffer data);

SignalFfiError *signal_plaintext_content_destroy(SignalMutPointerPlaintextContent p);

SignalFfiError *signal_plaintext_content_from_decryption_error_message(SignalMutPointerPlaintextContent *out, SignalConstPointerDecryptionErrorMessage m);

SignalFfiError *signal_plaintext_content_get_body(SignalOwnedBuffer *out, SignalConstPointerPlaintextContent obj);

SignalFfiError *signal_plaintext_content_serialize(SignalOwnedBuffer *out, SignalConstPointerPlaintextContent obj);

SignalFfiError *signal_pre_key_bundle_clone(SignalMutPointerPreKeyBundle *new_obj, SignalConstPointerPreKeyBundle obj);

SignalFfiError *signal_pre_key_bundle_destroy(SignalMutPointerPreKeyBundle p);

SignalFfiError *signal_pre_key_bundle_get_device_id(uint32_t *out, SignalConstPointerPreKeyBundle obj);

SignalFfiError *signal_pre_key_bundle_get_identity_key(SignalMutPointerPublicKey *out, SignalConstPointerPreKeyBundle p);

SignalFfiError *signal_pre_key_bundle_get_kyber_pre_key_id(uint32_t *out, SignalConstPointerPreKeyBundle obj);

SignalFfiError *signal_pre_key_bundle_get_kyber_pre_key_public(SignalMutPointerKyberPublicKey *out, SignalConstPointerPreKeyBundle bundle);

SignalFfiError *signal_pre_key_bundle_get_kyber_pre_key_signature(SignalOwnedBuffer *out, SignalConstPointerPreKeyBundle obj);

SignalFfiError *signal_pre_key_bundle_get_pre_key_id(uint32_t *out, SignalConstPointerPreKeyBundle obj);

SignalFfiError *signal_pre_key_bundle_get_pre_key_public(SignalMutPointerPublicKey *out, SignalConstPointerPreKeyBundle obj);

SignalFfiError *signal_pre_key_bundle_get_registration_id(uint32_t *out, SignalConstPointerPreKeyBundle obj);

SignalFfiError *signal_pre_key_bundle_get_signed_pre_key_id(uint32_t *out, SignalConstPointerPreKeyBundle obj);

SignalFfiError *signal_pre_key_bundle_get_signed_pre_key_public(SignalMutPointerPublicKey *out, SignalConstPointerPreKeyBundle obj);

SignalFfiError *signal_pre_key_bundle_get_signed_pre_key_signature(SignalOwnedBuffer *out, SignalConstPointerPreKeyBundle obj);

SignalFfiError *signal_pre_key_bundle_new(SignalMutPointerPreKeyBundle *out, uint32_t registration_id, uint32_t device_id, uint32_t prekey_id, SignalConstPointerPublicKey prekey, uint32_t signed_prekey_id, SignalConstPointerPublicKey signed_prekey, SignalBorrowedBuffer signed_prekey_signature, SignalConstPointerPublicKey identity_key, uint32_t kyber_prekey_id, SignalConstPointerKyberPublicKey kyber_prekey, SignalBorrowedBuffer kyber_prekey_signature);

SignalFfiError *signal_pre_key_record_clone(SignalMutPointerPreKeyRecord *new_obj, SignalConstPointerPreKeyRecord obj);

SignalFfiError *signal_pre_key_record_deserialize(SignalMutPointerPreKeyRecord *out, SignalBorrowedBuffer data);

SignalFfiError *signal_pre_key_record_destroy(SignalMutPointerPreKeyRecord p);

SignalFfiError *signal_pre_key_record_get_id(uint32_t *out, SignalConstPointerPreKeyRecord obj);

SignalFfiError *signal_pre_key_record_get_private_key(SignalMutPointerPrivateKey *out, SignalConstPointerPreKeyRecord obj);

SignalFfiError *signal_pre_key_record_get_public_key(SignalMutPointerPublicKey *out, SignalConstPointerPreKeyRecord obj);

SignalFfiError *signal_pre_key_record_new(SignalMutPointerPreKeyRecord *out, uint32_t id, SignalConstPointerPublicKey pub_key, SignalConstPointerPrivateKey priv_key);

SignalFfiError *signal_pre_key_record_serialize(SignalOwnedBuffer *out, SignalConstPointerPreKeyRecord obj);

SignalFfiError *signal_pre_key_signal_message_clone(SignalMutPointerPreKeySignalMessage *new_obj, SignalConstPointerPreKeySignalMessage obj);

SignalFfiError *signal_pre_key_signal_message_deserialize(SignalMutPointerPreKeySignalMessage *out, SignalBorrowedBuffer data);

SignalFfiError *signal_pre_key_signal_message_destroy(SignalMutPointerPreKeySignalMessage p);

SignalFfiError *signal_pre_key_signal_message_get_base_key(SignalMutPointerPublicKey *out, SignalConstPointerPreKeySignalMessage m);

SignalFfiError *signal_pre_key_signal_message_get_identity_key(SignalMutPointerPublicKey *out, SignalConstPointerPreKeySignalMessage m);

SignalFfiError *signal_pre_key_signal_message_get_pre_key_id(uint32_t *out, SignalConstPointerPreKeySignalMessage obj);

SignalFfiError *signal_pre_key_signal_message_get_registration_id(uint32_t *out, SignalConstPointerPreKeySignalMessage obj);

SignalFfiError *signal_pre_key_signal_message_get_signal_message(SignalMutPointerSignalMessage *out, SignalConstPointerPreKeySignalMessage m);

SignalFfiError *signal_pre_key_signal_message_get_signed_pre_key_id(uint32_t *out, SignalConstPointerPreKeySignalMessage obj);

SignalFfiError *signal_pre_key_signal_message_get_version(uint32_t *out, SignalConstPointerPreKeySignalMessage obj);

SignalFfiError *signal_pre_key_signal_message_new(SignalMutPointerPreKeySignalMessage *out, uint8_t message_version, uint32_t registration_id, uint32_t pre_key_id, uint32_t signed_pre_key_id, SignalConstPointerPublicKey base_key, SignalConstPointerPublicKey identity_key, SignalConstPointerSignalMessage signal_message);

SignalFfiError *signal_pre_key_signal_message_serialize(SignalOwnedBuffer *out, SignalConstPointerPreKeySignalMessage obj);

void signal_print_ptr(const void *p);

SignalFfiError *signal_privatekey_agree(SignalOwnedBuffer *out, SignalConstPointerPrivateKey private_key, SignalConstPointerPublicKey public_key);

SignalFfiError *signal_privatekey_clone(SignalMutPointerPrivateKey *new_obj, SignalConstPointerPrivateKey obj);

SignalFfiError *signal_privatekey_deserialize(SignalMutPointerPrivateKey *out, SignalBorrowedBuffer data);

SignalFfiError *signal_privatekey_destroy(SignalMutPointerPrivateKey p);

SignalFfiError *signal_privatekey_generate(SignalMutPointerPrivateKey *out);

SignalFfiError *signal_privatekey_get_public_key(SignalMutPointerPublicKey *out, SignalConstPointerPrivateKey k);

SignalFfiError *signal_privatekey_hpke_open(SignalOwnedBuffer *out, SignalConstPointerPrivateKey sk, SignalBorrowedBuffer ciphertext, SignalBorrowedBuffer info, SignalBorrowedBuffer associated_data);

SignalFfiError *signal_privatekey_serialize(SignalOwnedBuffer *out, SignalConstPointerPrivateKey obj);

SignalFfiError *signal_privatekey_sign(SignalOwnedBuffer *out, SignalConstPointerPrivateKey key, SignalBorrowedBuffer message);

SignalFfiError *signal_process_prekey_bundle(SignalConstPointerPreKeyBundle bundle, SignalConstPointerProtocolAddress protocol_address, SignalConstPointerFfiSessionStoreStruct session_store, SignalConstPointerFfiIdentityKeyStoreStruct identity_key_store, uint64_t now);

SignalFfiError *signal_process_sender_key_distribution_message(SignalConstPointerProtocolAddress sender, SignalConstPointerSenderKeyDistributionMessage sender_key_distribution_message, SignalConstPointerFfiSenderKeyStoreStruct store);

SignalFfiError *signal_profile_key_check_valid_contents(SignalBorrowedBuffer buffer);

SignalFfiError *signal_profile_key_ciphertext_check_valid_contents(SignalBorrowedBuffer buffer);

SignalFfiError *signal_profile_key_commitment_check_valid_contents(SignalBorrowedBuffer buffer);

SignalFfiError *signal_profile_key_credential_presentation_check_valid_contents(SignalBorrowedBuffer presentation_bytes);

SignalFfiError *signal_profile_key_credential_presentation_get_profile_key_ciphertext(unsigned char (*out)[SignalPROFILE_KEY_CIPHERTEXT_LEN], SignalBorrowedBuffer presentation_bytes);

SignalFfiError *signal_profile_key_credential_presentation_get_uuid_ciphertext(unsigned char (*out)[SignalUUID_CIPHERTEXT_LEN], SignalBorrowedBuffer presentation_bytes);

SignalFfiError *signal_profile_key_credential_request_check_valid_contents(SignalBorrowedBuffer buffer);

SignalFfiError *signal_profile_key_credential_request_context_check_valid_contents(SignalBorrowedBuffer buffer);

SignalFfiError *signal_profile_key_credential_request_context_get_request(unsigned char (*out)[SignalPROFILE_KEY_CREDENTIAL_REQUEST_LEN], const unsigned char (*context)[SignalPROFILE_KEY_CREDENTIAL_REQUEST_CONTEXT_LEN]);

SignalFfiError *signal_profile_key_derive_access_key(uint8_t (*out)[SignalACCESS_KEY_LEN], const unsigned char (*profile_key)[SignalPROFILE_KEY_LEN]);

SignalFfiError *signal_profile_key_get_commitment(unsigned char (*out)[SignalPROFILE_KEY_COMMITMENT_LEN], const unsigned char (*profile_key)[SignalPROFILE_KEY_LEN], const SignalServiceIdFixedWidthBinaryBytes *user_id);

SignalFfiError *signal_profile_key_get_profile_key_version(uint8_t (*out)[SignalPROFILE_KEY_VERSION_ENCODED_LEN], const unsigned char (*profile_key)[SignalPROFILE_KEY_LEN], const SignalServiceIdFixedWidthBinaryBytes *user_id);

SignalFfiError *signal_publickey_clone(SignalMutPointerPublicKey *new_obj, SignalConstPointerPublicKey obj);

SignalFfiError *signal_publickey_compare(int32_t *out, SignalConstPointerPublicKey key1, SignalConstPointerPublicKey key2);

SignalFfiError *signal_publickey_deserialize(SignalMutPointerPublicKey *out, SignalBorrowedBuffer data);

SignalFfiError *signal_publickey_destroy(SignalMutPointerPublicKey p);

SignalFfiError *signal_publickey_equals(bool *out, SignalConstPointerPublicKey lhs, SignalConstPointerPublicKey rhs);

SignalFfiError *signal_publickey_get_public_key_bytes(SignalOwnedBuffer *out, SignalConstPointerPublicKey obj);

SignalFfiError *signal_publickey_hpke_seal(SignalOwnedBuffer *out, SignalConstPointerPublicKey pk, SignalBorrowedBuffer plaintext, SignalBorrowedBuffer info, SignalBorrowedBuffer associated_data);

SignalFfiError *signal_publickey_serialize(SignalOwnedBuffer *out, SignalConstPointerPublicKey obj);

SignalFfiError *signal_publickey_verify(bool *out, SignalConstPointerPublicKey key, SignalBorrowedBuffer message, SignalBorrowedBuffer signature);

SignalFfiError *signal_receipt_credential_check_valid_contents(SignalBorrowedBuffer buffer);

SignalFfiError *signal_receipt_credential_get_receipt_expiration_time(uint64_t *out, const unsigned char (*receipt_credential)[SignalRECEIPT_CREDENTIAL_LEN]);

SignalFfiError *signal_receipt_credential_get_receipt_level(uint64_t *out, const unsigned char (*receipt_credential)[SignalRECEIPT_CREDENTIAL_LEN]);

SignalFfiError *signal_receipt_credential_presentation_check_valid_contents(SignalBorrowedBuffer buffer);

SignalFfiError *signal_receipt_credential_presentation_get_receipt_expiration_time(uint64_t *out, const unsigned char (*presentation)[SignalRECEIPT_CREDENTIAL_PRESENTATION_LEN]);

SignalFfiError *signal_receipt_credential_presentation_get_receipt_level(uint64_t *out, const unsigned char (*presentation)[SignalRECEIPT_CREDENTIAL_PRESENTATION_LEN]);

SignalFfiError *signal_receipt_credential_presentation_get_receipt_serial(uint8_t (*out)[SignalRECEIPT_SERIAL_LEN], const unsigned char (*presentation)[SignalRECEIPT_CREDENTIAL_PRESENTATION_LEN]);

SignalFfiError *signal_receipt_credential_request_check_valid_contents(SignalBorrowedBuffer buffer);

SignalFfiError *signal_receipt_credential_request_context_check_valid_contents(SignalBorrowedBuffer buffer);

SignalFfiError *signal_receipt_credential_request_context_get_request(unsigned char (*out)[SignalRECEIPT_CREDENTIAL_REQUEST_LEN], const unsigned char (*request_context)[SignalRECEIPT_CREDENTIAL_REQUEST_CONTEXT_LEN]);

SignalFfiError *signal_receipt_credential_response_check_valid_contents(SignalBorrowedBuffer buffer);

SignalFfiError *signal_register_account_request_create(SignalMutPointerRegisterAccountRequest *out);

SignalFfiError *signal_register_account_request_destroy(SignalMutPointerRegisterAccountRequest p);

SignalFfiError *signal_register_account_request_set_account_password(SignalConstPointerRegisterAccountRequest register_account, const char *account_password);

SignalFfiError *signal_register_account_request_set_apn_push_token(SignalConstPointerRegisterAccountRequest register_account, const char *apn_push_token);

SignalFfiError *signal_register_account_request_set_identity_pq_last_resort_pre_key(SignalConstPointerRegisterAccountRequest register_account, uint8_t identity_type, SignalFfiSignedPublicPreKey pq_last_resort_pre_key);

SignalFfiError *signal_register_account_request_set_identity_public_key(SignalConstPointerRegisterAccountRequest register_account, uint8_t identity_type, SignalConstPointerPublicKey identity_key);

SignalFfiError *signal_register_account_request_set_identity_signed_pre_key(SignalConstPointerRegisterAccountRequest register_account, uint8_t identity_type, SignalFfiSignedPublicPreKey signed_pre_key);

SignalFfiError *signal_register_account_request_set_skip_device_transfer(SignalConstPointerRegisterAccountRequest register_account);

SignalFfiError *signal_register_account_response_destroy(SignalMutPointerRegisterAccountResponse p);

SignalFfiError *signal_register_account_response_get_entitlement_backup_expiration_seconds(uint64_t *out, SignalConstPointerRegisterAccountResponse response);

SignalFfiError *signal_register_account_response_get_entitlement_backup_level(uint64_t *out, SignalConstPointerRegisterAccountResponse response);

SignalFfiError *signal_register_account_response_get_entitlement_badges(SignalOwnedBufferOfFfiRegisterResponseBadge *out, SignalConstPointerRegisterAccountResponse response);

SignalFfiError *signal_register_account_response_get_identity(SignalServiceIdFixedWidthBinaryBytes *out, SignalConstPointerRegisterAccountResponse response, uint8_t identity_type);

SignalFfiError *signal_register_account_response_get_number(const char **out, SignalConstPointerRegisterAccountResponse response);

SignalFfiError *signal_register_account_response_get_reregistration(bool *out, SignalConstPointerRegisterAccountResponse response);

SignalFfiError *signal_register_account_response_get_storage_capable(bool *out, SignalConstPointerRegisterAccountResponse response);

SignalFfiError *signal_register_account_response_get_username_hash(SignalOwnedBuffer *out, SignalConstPointerRegisterAccountResponse response);

SignalFfiError *signal_register_account_response_get_username_link_handle(SignalOptionalUuid *out, SignalConstPointerRegisterAccountResponse response);

SignalFfiError *signal_registration_account_attributes_create(SignalMutPointerRegistrationAccountAttributes *out, SignalBorrowedBuffer recovery_password, uint16_t aci_registration_id, uint16_t pni_registration_id, const char *registration_lock, const uint8_t (*unidentified_access_key)[16], bool unrestricted_unidentified_access, SignalBorrowedBytestringArray capabilities, bool discoverable_by_phone_number);

SignalFfiError *signal_registration_account_attributes_destroy(SignalMutPointerRegistrationAccountAttributes p);

SignalFfiError *signal_registration_service_check_svr2_credentials(SignalCPromiseFfiCheckSvr2CredentialsResponse *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalConstPointerRegistrationService service, SignalBorrowedBytestringArray svr_tokens);

SignalFfiError *signal_registration_service_create_session(SignalCPromiseMutPointerRegistrationService *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalFfiRegistrationCreateSessionRequest create_session, SignalConstPointerFfiConnectChatBridgeStruct connect_chat);

SignalFfiError *signal_registration_service_destroy(SignalMutPointerRegistrationService p);

SignalFfiError *signal_registration_service_register_account(SignalCPromiseMutPointerRegisterAccountResponse *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalConstPointerRegistrationService service, SignalConstPointerRegisterAccountRequest register_account, SignalConstPointerRegistrationAccountAttributes account_attributes);

SignalFfiError *signal_registration_service_registration_session(SignalMutPointerRegistrationSession *out, SignalConstPointerRegistrationService service);

SignalFfiError *signal_registration_service_request_push_challenge(SignalCPromisebool *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalConstPointerRegistrationService service, const char *push_token);

SignalFfiError *signal_registration_service_request_verification_code(SignalCPromisebool *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalConstPointerRegistrationService service, const char *transport, const char *client, SignalBorrowedBytestringArray languages);

SignalFfiError *signal_registration_service_reregister_account(SignalCPromiseMutPointerRegisterAccountResponse *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalConstPointerFfiConnectChatBridgeStruct connect_chat, const char *number, SignalConstPointerRegisterAccountRequest register_account, SignalConstPointerRegistrationAccountAttributes account_attributes);

SignalFfiError *signal_registration_service_resume_session(SignalCPromiseMutPointerRegistrationService *promise, SignalConstPointerTokioAsyncContext async_runtime, const char *session_id, const char *number, SignalConstPointerFfiConnectChatBridgeStruct connect_chat);

SignalFfiError *signal_registration_service_session_id(const char **out, SignalConstPointerRegistrationService service);

SignalFfiError *signal_registration_service_submit_captcha(SignalCPromisebool *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalConstPointerRegistrationService service, const char *captcha_value);

SignalFfiError *signal_registration_service_submit_push_challenge(SignalCPromisebool *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalConstPointerRegistrationService service, const char *push_challenge);

SignalFfiError *signal_registration_service_submit_verification_code(SignalCPromisebool *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalConstPointerRegistrationService service, const char *code);

SignalFfiError *signal_registration_session_destroy(SignalMutPointerRegistrationSession p);

SignalFfiError *signal_registration_session_get_allowed_to_request_code(bool *out, SignalConstPointerRegistrationSession session);

SignalFfiError *signal_registration_session_get_next_call_seconds(uint32_t *out, SignalConstPointerRegistrationSession session);

SignalFfiError *signal_registration_session_get_next_sms_seconds(uint32_t *out, SignalConstPointerRegistrationSession session);

SignalFfiError *signal_registration_session_get_next_verification_attempt_seconds(uint32_t *out, SignalConstPointerRegistrationSession session);

SignalFfiError *signal_registration_session_get_requested_information(SignalOwnedBuffer *out, SignalConstPointerRegistrationSession session);

SignalFfiError *signal_registration_session_get_verified(bool *out, SignalConstPointerRegistrationSession session);

SignalFfiError *signal_sanitized_metadata_clone(SignalMutPointerSanitizedMetadata *new_obj, SignalConstPointerSanitizedMetadata obj);

SignalFfiError *signal_sanitized_metadata_destroy(SignalMutPointerSanitizedMetadata p);

SignalFfiError *signal_sanitized_metadata_get_data_len(uint64_t *out, SignalConstPointerSanitizedMetadata sanitized);

SignalFfiError *signal_sanitized_metadata_get_data_offset(uint64_t *out, SignalConstPointerSanitizedMetadata sanitized);

SignalFfiError *signal_sanitized_metadata_get_metadata(SignalOwnedBuffer *out, SignalConstPointerSanitizedMetadata sanitized);

SignalFfiError *signal_sealed_sender_multi_recipient_encrypt(SignalOwnedBuffer *out, SignalBorrowedSliceOfConstPointerProtocolAddress recipients, SignalBorrowedSliceOfConstPointerSessionRecord recipient_sessions, SignalBorrowedBuffer excluded_recipients, SignalConstPointerUnidentifiedSenderMessageContent content, SignalConstPointerFfiIdentityKeyStoreStruct identity_key_store);

SignalFfiError *signal_sealed_sender_multi_recipient_message_for_single_recipient(SignalOwnedBuffer *out, SignalBorrowedBuffer encoded_multi_recipient_message);

SignalFfiError *signal_sealed_session_cipher_decrypt_to_usmc(SignalMutPointerUnidentifiedSenderMessageContent *out, SignalBorrowedBuffer ctext, SignalConstPointerFfiIdentityKeyStoreStruct identity_store);

SignalFfiError *signal_sealed_session_cipher_encrypt(SignalOwnedBuffer *out, SignalConstPointerProtocolAddress destination, SignalConstPointerUnidentifiedSenderMessageContent content, SignalConstPointerFfiIdentityKeyStoreStruct identity_key_store);

SignalFfiError *signal_secure_value_recovery_for_backups_create_new_backup_chain(SignalOwnedBuffer *out, uint8_t environment, const SignalBackupKeyBytes *backup_key);

SignalFfiError *signal_secure_value_recovery_for_backups_remove_backup(SignalCPromisebool *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalConstPointerConnectionManager connection_manager, const char *username, const char *password);

SignalFfiError *signal_secure_value_recovery_for_backups_restore_backup_from_server(SignalCPromiseMutPointerBackupRestoreResponse *promise, SignalConstPointerTokioAsyncContext async_runtime, const SignalBackupKeyBytes *backup_key, SignalBorrowedBuffer metadata, SignalConstPointerConnectionManager connection_manager, const char *username, const char *password);

SignalFfiError *signal_secure_value_recovery_for_backups_store_backup(SignalCPromiseMutPointerBackupStoreResponse *promise, SignalConstPointerTokioAsyncContext async_runtime, const SignalBackupKeyBytes *backup_key, SignalBorrowedBuffer previous_secret_data, SignalConstPointerConnectionManager connection_manager, const char *username, const char *password);

SignalFfiError *signal_sender_certificate_clone(SignalMutPointerSenderCertificate *new_obj, SignalConstPointerSenderCertificate obj);

SignalFfiError *signal_sender_certificate_deserialize(SignalMutPointerSenderCertificate *out, SignalBorrowedBuffer data);

SignalFfiError *signal_sender_certificate_destroy(SignalMutPointerSenderCertificate p);

SignalFfiError *signal_sender_certificate_get_certificate(SignalOwnedBuffer *out, SignalConstPointerSenderCertificate obj);

SignalFfiError *signal_sender_certificate_get_device_id(uint32_t *out, SignalConstPointerSenderCertificate obj);

SignalFfiError *signal_sender_certificate_get_expiration(uint64_t *out, SignalConstPointerSenderCertificate obj);

SignalFfiError *signal_sender_certificate_get_key(SignalMutPointerPublicKey *out, SignalConstPointerSenderCertificate obj);

SignalFfiError *signal_sender_certificate_get_sender_e164(const char **out, SignalConstPointerSenderCertificate obj);

SignalFfiError *signal_sender_certificate_get_sender_uuid(const char **out, SignalConstPointerSenderCertificate obj);

SignalFfiError *signal_sender_certificate_get_serialized(SignalOwnedBuffer *out, SignalConstPointerSenderCertificate obj);

SignalFfiError *signal_sender_certificate_get_server_certificate(SignalMutPointerServerCertificate *out, SignalConstPointerSenderCertificate cert);

SignalFfiError *signal_sender_certificate_get_signature(SignalOwnedBuffer *out, SignalConstPointerSenderCertificate obj);

SignalFfiError *signal_sender_certificate_new(SignalMutPointerSenderCertificate *out, const char *sender_uuid, const char *sender_e164, uint32_t sender_device_id, SignalConstPointerPublicKey sender_key, uint64_t expiration, SignalConstPointerServerCertificate signer_cert, SignalConstPointerPrivateKey signer_key);

SignalFfiError *signal_sender_certificate_validate(bool *out, SignalConstPointerSenderCertificate cert, SignalBorrowedSliceOfConstPointerPublicKey trust_roots, uint64_t time);

SignalFfiError *signal_sender_key_distribution_message_clone(SignalMutPointerSenderKeyDistributionMessage *new_obj, SignalConstPointerSenderKeyDistributionMessage obj);

SignalFfiError *signal_sender_key_distribution_message_create(SignalMutPointerSenderKeyDistributionMessage *out, SignalConstPointerProtocolAddress sender, const uint8_t (*distribution_id)[16], SignalConstPointerFfiSenderKeyStoreStruct store);

SignalFfiError *signal_sender_key_distribution_message_deserialize(SignalMutPointerSenderKeyDistributionMessage *out, SignalBorrowedBuffer data);

SignalFfiError *signal_sender_key_distribution_message_destroy(SignalMutPointerSenderKeyDistributionMessage p);

SignalFfiError *signal_sender_key_distribution_message_get_chain_id(uint32_t *out, SignalConstPointerSenderKeyDistributionMessage obj);

SignalFfiError *signal_sender_key_distribution_message_get_chain_key(SignalOwnedBuffer *out, SignalConstPointerSenderKeyDistributionMessage obj);

SignalFfiError *signal_sender_key_distribution_message_get_distribution_id(uint8_t (*out)[16], SignalConstPointerSenderKeyDistributionMessage obj);

SignalFfiError *signal_sender_key_distribution_message_get_iteration(uint32_t *out, SignalConstPointerSenderKeyDistributionMessage obj);

SignalFfiError *signal_sender_key_distribution_message_get_signature_key(SignalMutPointerPublicKey *out, SignalConstPointerSenderKeyDistributionMessage m);

SignalFfiError *signal_sender_key_distribution_message_new(SignalMutPointerSenderKeyDistributionMessage *out, uint8_t message_version, const uint8_t (*distribution_id)[16], uint32_t chain_id, uint32_t iteration, SignalBorrowedBuffer chainkey, SignalConstPointerPublicKey pk);

SignalFfiError *signal_sender_key_distribution_message_serialize(SignalOwnedBuffer *out, SignalConstPointerSenderKeyDistributionMessage obj);

SignalFfiError *signal_sender_key_message_clone(SignalMutPointerSenderKeyMessage *new_obj, SignalConstPointerSenderKeyMessage obj);

SignalFfiError *signal_sender_key_message_deserialize(SignalMutPointerSenderKeyMessage *out, SignalBorrowedBuffer data);

SignalFfiError *signal_sender_key_message_destroy(SignalMutPointerSenderKeyMessage p);

SignalFfiError *signal_sender_key_message_get_chain_id(uint32_t *out, SignalConstPointerSenderKeyMessage obj);

SignalFfiError *signal_sender_key_message_get_cipher_text(SignalOwnedBuffer *out, SignalConstPointerSenderKeyMessage obj);

SignalFfiError *signal_sender_key_message_get_distribution_id(uint8_t (*out)[16], SignalConstPointerSenderKeyMessage obj);

SignalFfiError *signal_sender_key_message_get_iteration(uint32_t *out, SignalConstPointerSenderKeyMessage obj);

SignalFfiError *signal_sender_key_message_new(SignalMutPointerSenderKeyMessage *out, uint8_t message_version, const uint8_t (*distribution_id)[16], uint32_t chain_id, uint32_t iteration, SignalBorrowedBuffer ciphertext, SignalConstPointerPrivateKey pk);

SignalFfiError *signal_sender_key_message_serialize(SignalOwnedBuffer *out, SignalConstPointerSenderKeyMessage obj);

SignalFfiError *signal_sender_key_message_verify_signature(bool *out, SignalConstPointerSenderKeyMessage skm, SignalConstPointerPublicKey pubkey);

SignalFfiError *signal_sender_key_record_clone(SignalMutPointerSenderKeyRecord *new_obj, SignalConstPointerSenderKeyRecord obj);

SignalFfiError *signal_sender_key_record_deserialize(SignalMutPointerSenderKeyRecord *out, SignalBorrowedBuffer data);

SignalFfiError *signal_sender_key_record_destroy(SignalMutPointerSenderKeyRecord p);

SignalFfiError *signal_sender_key_record_serialize(SignalOwnedBuffer *out, SignalConstPointerSenderKeyRecord obj);

SignalFfiError *signal_server_certificate_clone(SignalMutPointerServerCertificate *new_obj, SignalConstPointerServerCertificate obj);

SignalFfiError *signal_server_certificate_deserialize(SignalMutPointerServerCertificate *out, SignalBorrowedBuffer data);

SignalFfiError *signal_server_certificate_destroy(SignalMutPointerServerCertificate p);

SignalFfiError *signal_server_certificate_get_certificate(SignalOwnedBuffer *out, SignalConstPointerServerCertificate obj);

SignalFfiError *signal_server_certificate_get_key(SignalMutPointerPublicKey *out, SignalConstPointerServerCertificate obj);

SignalFfiError *signal_server_certificate_get_key_id(uint32_t *out, SignalConstPointerServerCertificate obj);

SignalFfiError *signal_server_certificate_get_serialized(SignalOwnedBuffer *out, SignalConstPointerServerCertificate obj);

SignalFfiError *signal_server_certificate_get_signature(SignalOwnedBuffer *out, SignalConstPointerServerCertificate obj);

SignalFfiError *signal_server_certificate_new(SignalMutPointerServerCertificate *out, uint32_t key_id, SignalConstPointerPublicKey server_key, SignalConstPointerPrivateKey trust_root);

SignalFfiError *signal_server_message_ack_destroy(SignalMutPointerServerMessageAck p);

SignalFfiError *signal_server_message_ack_send(SignalConstPointerServerMessageAck ack);

SignalFfiError *signal_server_public_params_create_auth_credential_with_pni_presentation_deterministic(SignalOwnedBuffer *out, SignalConstPointerServerPublicParams server_public_params, const uint8_t (*randomness)[SignalRANDOMNESS_LEN], const unsigned char (*group_secret_params)[SignalGROUP_SECRET_PARAMS_LEN], SignalBorrowedBuffer auth_credential_with_pni_bytes);

SignalFfiError *signal_server_public_params_create_expiring_profile_key_credential_presentation_deterministic(SignalOwnedBuffer *out, SignalConstPointerServerPublicParams server_public_params, const uint8_t (*randomness)[SignalRANDOMNESS_LEN], const unsigned char (*group_secret_params)[SignalGROUP_SECRET_PARAMS_LEN], const unsigned char (*profile_key_credential)[SignalEXPIRING_PROFILE_KEY_CREDENTIAL_LEN]);

SignalFfiError *signal_server_public_params_create_profile_key_credential_request_context_deterministic(unsigned char (*out)[SignalPROFILE_KEY_CREDENTIAL_REQUEST_CONTEXT_LEN], SignalConstPointerServerPublicParams server_public_params, const uint8_t (*randomness)[SignalRANDOMNESS_LEN], const SignalServiceIdFixedWidthBinaryBytes *user_id, const unsigned char (*profile_key)[SignalPROFILE_KEY_LEN]);

SignalFfiError *signal_server_public_params_create_receipt_credential_presentation_deterministic(unsigned char (*out)[SignalRECEIPT_CREDENTIAL_PRESENTATION_LEN], SignalConstPointerServerPublicParams server_public_params, const uint8_t (*randomness)[SignalRANDOMNESS_LEN], const unsigned char (*receipt_credential)[SignalRECEIPT_CREDENTIAL_LEN]);

SignalFfiError *signal_server_public_params_create_receipt_credential_request_context_deterministic(unsigned char (*out)[SignalRECEIPT_CREDENTIAL_REQUEST_CONTEXT_LEN], SignalConstPointerServerPublicParams server_public_params, const uint8_t (*randomness)[SignalRANDOMNESS_LEN], const uint8_t (*receipt_serial)[SignalRECEIPT_SERIAL_LEN]);

SignalFfiError *signal_server_public_params_deserialize(SignalMutPointerServerPublicParams *out, SignalBorrowedBuffer buffer);

SignalFfiError *signal_server_public_params_destroy(SignalMutPointerServerPublicParams p);

SignalFfiError *signal_server_public_params_get_endorsement_public_key(SignalOwnedBuffer *out, SignalConstPointerServerPublicParams params);

SignalFfiError *signal_server_public_params_receive_auth_credential_with_pni_as_service_id(SignalOwnedBuffer *out, SignalConstPointerServerPublicParams params, const SignalServiceIdFixedWidthBinaryBytes *aci, const SignalServiceIdFixedWidthBinaryBytes *pni, uint64_t redemption_time, SignalBorrowedBuffer auth_credential_with_pni_response_bytes);

SignalFfiError *signal_server_public_params_receive_expiring_profile_key_credential(unsigned char (*out)[SignalEXPIRING_PROFILE_KEY_CREDENTIAL_LEN], SignalConstPointerServerPublicParams server_public_params, const unsigned char (*request_context)[SignalPROFILE_KEY_CREDENTIAL_REQUEST_CONTEXT_LEN], const unsigned char (*response)[SignalEXPIRING_PROFILE_KEY_CREDENTIAL_RESPONSE_LEN], uint64_t current_time_in_seconds);

SignalFfiError *signal_server_public_params_receive_receipt_credential(unsigned char (*out)[SignalRECEIPT_CREDENTIAL_LEN], SignalConstPointerServerPublicParams server_public_params, const unsigned char (*request_context)[SignalRECEIPT_CREDENTIAL_REQUEST_CONTEXT_LEN], const unsigned char (*response)[SignalRECEIPT_CREDENTIAL_RESPONSE_LEN]);

SignalFfiError *signal_server_public_params_serialize(SignalOwnedBuffer *out, SignalConstPointerServerPublicParams handle);

SignalFfiError *signal_server_public_params_verify_signature(SignalConstPointerServerPublicParams server_public_params, SignalBorrowedBuffer message, const uint8_t (*notary_signature)[SignalSIGNATURE_LEN]);

SignalFfiError *signal_server_secret_params_deserialize(SignalMutPointerServerSecretParams *out, SignalBorrowedBuffer buffer);

SignalFfiError *signal_server_secret_params_destroy(SignalMutPointerServerSecretParams p);

SignalFfiError *signal_server_secret_params_generate_deterministic(SignalMutPointerServerSecretParams *out, const uint8_t (*randomness)[SignalRANDOMNESS_LEN]);

SignalFfiError *signal_server_secret_params_get_public_params(SignalMutPointerServerPublicParams *out, SignalConstPointerServerSecretParams params);

SignalFfiError *signal_server_secret_params_issue_auth_credential_with_pni_zkc_deterministic(SignalOwnedBuffer *out, SignalConstPointerServerSecretParams server_secret_params, const uint8_t (*randomness)[SignalRANDOMNESS_LEN], const SignalServiceIdFixedWidthBinaryBytes *aci, const SignalServiceIdFixedWidthBinaryBytes *pni, uint64_t redemption_time);

SignalFfiError *signal_server_secret_params_issue_expiring_profile_key_credential_deterministic(unsigned char (*out)[SignalEXPIRING_PROFILE_KEY_CREDENTIAL_RESPONSE_LEN], SignalConstPointerServerSecretParams server_secret_params, const uint8_t (*randomness)[SignalRANDOMNESS_LEN], const unsigned char (*request)[SignalPROFILE_KEY_CREDENTIAL_REQUEST_LEN], const SignalServiceIdFixedWidthBinaryBytes *user_id, const unsigned char (*commitment)[SignalPROFILE_KEY_COMMITMENT_LEN], uint64_t expiration_in_seconds);

SignalFfiError *signal_server_secret_params_issue_receipt_credential_deterministic(unsigned char (*out)[SignalRECEIPT_CREDENTIAL_RESPONSE_LEN], SignalConstPointerServerSecretParams server_secret_params, const uint8_t (*randomness)[SignalRANDOMNESS_LEN], const unsigned char (*request)[SignalRECEIPT_CREDENTIAL_REQUEST_LEN], uint64_t receipt_expiration_time, uint64_t receipt_level);

SignalFfiError *signal_server_secret_params_serialize(SignalOwnedBuffer *out, SignalConstPointerServerSecretParams handle);

SignalFfiError *signal_server_secret_params_sign_deterministic(uint8_t (*out)[SignalSIGNATURE_LEN], SignalConstPointerServerSecretParams params, const uint8_t (*randomness)[SignalRANDOMNESS_LEN], SignalBorrowedBuffer message);

SignalFfiError *signal_server_secret_params_verify_auth_credential_presentation(SignalConstPointerServerSecretParams server_secret_params, const unsigned char (*group_public_params)[SignalGROUP_PUBLIC_PARAMS_LEN], SignalBorrowedBuffer presentation_bytes, uint64_t current_time_in_seconds);

SignalFfiError *signal_server_secret_params_verify_profile_key_credential_presentation(SignalConstPointerServerSecretParams server_secret_params, const unsigned char (*group_public_params)[SignalGROUP_PUBLIC_PARAMS_LEN], SignalBorrowedBuffer presentation_bytes, uint64_t current_time_in_seconds);

SignalFfiError *signal_server_secret_params_verify_receipt_credential_presentation(SignalConstPointerServerSecretParams server_secret_params, const unsigned char (*presentation)[SignalRECEIPT_CREDENTIAL_PRESENTATION_LEN]);

SignalFfiError *signal_service_id_parse_from_service_id_binary(SignalServiceIdFixedWidthBinaryBytes *out, SignalBorrowedBuffer input);

SignalFfiError *signal_service_id_parse_from_service_id_string(SignalServiceIdFixedWidthBinaryBytes *out, const char *input);

SignalFfiError *signal_service_id_service_id_binary(SignalOwnedBuffer *out, const SignalServiceIdFixedWidthBinaryBytes *value);

SignalFfiError *signal_service_id_service_id_log(const char **out, const SignalServiceIdFixedWidthBinaryBytes *value);

SignalFfiError *signal_service_id_service_id_string(const char **out, const SignalServiceIdFixedWidthBinaryBytes *value);

SignalFfiError *signal_session_record_archive_current_state(SignalMutPointerSessionRecord session_record);

SignalFfiError *signal_session_record_clone(SignalMutPointerSessionRecord *new_obj, SignalConstPointerSessionRecord obj);

SignalFfiError *signal_session_record_current_ratchet_key_matches(bool *out, SignalConstPointerSessionRecord s, SignalConstPointerPublicKey key);

SignalFfiError *signal_session_record_deserialize(SignalMutPointerSessionRecord *out, SignalBorrowedBuffer data);

SignalFfiError *signal_session_record_destroy(SignalMutPointerSessionRecord p);

SignalFfiError *signal_session_record_get_local_registration_id(uint32_t *out, SignalConstPointerSessionRecord obj);

SignalFfiError *signal_session_record_get_remote_registration_id(uint32_t *out, SignalConstPointerSessionRecord obj);

SignalFfiError *signal_session_record_has_usable_sender_chain(bool *out, SignalConstPointerSessionRecord s, uint64_t now);

SignalFfiError *signal_session_record_serialize(SignalOwnedBuffer *out, SignalConstPointerSessionRecord obj);

SignalFfiError *signal_sgx_client_state_complete_handshake(SignalMutPointerSgxClientState cli, SignalBorrowedBuffer handshake_received);

SignalFfiError *signal_sgx_client_state_destroy(SignalMutPointerSgxClientState p);

SignalFfiError *signal_sgx_client_state_established_recv(SignalOwnedBuffer *out, SignalMutPointerSgxClientState cli, SignalBorrowedBuffer received_ciphertext);

SignalFfiError *signal_sgx_client_state_established_send(SignalOwnedBuffer *out, SignalMutPointerSgxClientState cli, SignalBorrowedBuffer plaintext_to_send);

SignalFfiError *signal_sgx_client_state_initial_request(SignalOwnedBuffer *out, SignalConstPointerSgxClientState obj);

SignalFfiError *signal_signal_media_check_available(void);

SignalFfiError *signal_signed_pre_key_record_clone(SignalMutPointerSignedPreKeyRecord *new_obj, SignalConstPointerSignedPreKeyRecord obj);

SignalFfiError *signal_signed_pre_key_record_deserialize(SignalMutPointerSignedPreKeyRecord *out, SignalBorrowedBuffer data);

SignalFfiError *signal_signed_pre_key_record_destroy(SignalMutPointerSignedPreKeyRecord p);

SignalFfiError *signal_signed_pre_key_record_get_id(uint32_t *out, SignalConstPointerSignedPreKeyRecord obj);

SignalFfiError *signal_signed_pre_key_record_get_private_key(SignalMutPointerPrivateKey *out, SignalConstPointerSignedPreKeyRecord obj);

SignalFfiError *signal_signed_pre_key_record_get_public_key(SignalMutPointerPublicKey *out, SignalConstPointerSignedPreKeyRecord obj);

SignalFfiError *signal_signed_pre_key_record_get_signature(SignalOwnedBuffer *out, SignalConstPointerSignedPreKeyRecord obj);

SignalFfiError *signal_signed_pre_key_record_get_timestamp(uint64_t *out, SignalConstPointerSignedPreKeyRecord obj);

SignalFfiError *signal_signed_pre_key_record_new(SignalMutPointerSignedPreKeyRecord *out, uint32_t id, uint64_t timestamp, SignalConstPointerPublicKey pub_key, SignalConstPointerPrivateKey priv_key, SignalBorrowedBuffer signature);

SignalFfiError *signal_signed_pre_key_record_serialize(SignalOwnedBuffer *out, SignalConstPointerSignedPreKeyRecord obj);

SignalFfiError *signal_svr2_client_new(SignalMutPointerSgxClientState *out, SignalBorrowedBuffer mrenclave, SignalBorrowedBuffer attestation_msg, uint64_t current_timestamp);

SignalFfiError *signal_tokio_async_context_cancel(SignalConstPointerTokioAsyncContext context, uint64_t raw_cancellation_id);

SignalFfiError *signal_tokio_async_context_destroy(SignalMutPointerTokioAsyncContext p);

SignalFfiError *signal_tokio_async_context_new(SignalMutPointerTokioAsyncContext *out);

SignalFfiError *signal_unauthenticated_chat_connection_connect(SignalCPromiseMutPointerUnauthenticatedChatConnection *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalConstPointerConnectionManager connection_manager, SignalBorrowedBytestringArray languages);

SignalFfiError *signal_unauthenticated_chat_connection_destroy(SignalMutPointerUnauthenticatedChatConnection p);

SignalFfiError *signal_unauthenticated_chat_connection_disconnect(SignalCPromisebool *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalConstPointerUnauthenticatedChatConnection chat);

SignalFfiError *signal_unauthenticated_chat_connection_info(SignalMutPointerChatConnectionInfo *out, SignalConstPointerUnauthenticatedChatConnection chat);

SignalFfiError *signal_unauthenticated_chat_connection_init_listener(SignalConstPointerUnauthenticatedChatConnection chat, SignalConstPointerFfiChatListenerStruct listener);

SignalFfiError *signal_unauthenticated_chat_connection_look_up_username_hash(SignalCPromiseOptionalUuid *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalConstPointerUnauthenticatedChatConnection chat, SignalBorrowedBuffer hash);

SignalFfiError *signal_unauthenticated_chat_connection_send(SignalCPromiseFfiChatResponse *promise, SignalConstPointerTokioAsyncContext async_runtime, SignalConstPointerUnauthenticatedChatConnection chat, SignalConstPointerHttpRequest http_request, uint32_t timeout_millis);

SignalFfiError *signal_unidentified_sender_message_content_deserialize(SignalMutPointerUnidentifiedSenderMessageContent *out, SignalBorrowedBuffer data);

SignalFfiError *signal_unidentified_sender_message_content_destroy(SignalMutPointerUnidentifiedSenderMessageContent p);

SignalFfiError *signal_unidentified_sender_message_content_get_content_hint(uint32_t *out, SignalConstPointerUnidentifiedSenderMessageContent m);

SignalFfiError *signal_unidentified_sender_message_content_get_contents(SignalOwnedBuffer *out, SignalConstPointerUnidentifiedSenderMessageContent obj);

SignalFfiError *signal_unidentified_sender_message_content_get_group_id_or_empty(SignalOwnedBuffer *out, SignalConstPointerUnidentifiedSenderMessageContent m);

SignalFfiError *signal_unidentified_sender_message_content_get_msg_type(uint8_t *out, SignalConstPointerUnidentifiedSenderMessageContent m);

SignalFfiError *signal_unidentified_sender_message_content_get_sender_cert(SignalMutPointerSenderCertificate *out, SignalConstPointerUnidentifiedSenderMessageContent m);

SignalFfiError *signal_unidentified_sender_message_content_new(SignalMutPointerUnidentifiedSenderMessageContent *out, SignalConstPointerCiphertextMessage message, SignalConstPointerSenderCertificate sender, uint32_t content_hint, SignalBorrowedBuffer group_id);

SignalFfiError *signal_unidentified_sender_message_content_new_from_content_and_type(SignalMutPointerUnidentifiedSenderMessageContent *out, SignalBorrowedBuffer message_content, uint8_t message_type, SignalConstPointerSenderCertificate sender, uint32_t content_hint, SignalBorrowedBuffer group_id);

SignalFfiError *signal_unidentified_sender_message_content_serialize(SignalOwnedBuffer *out, SignalConstPointerUnidentifiedSenderMessageContent obj);

SignalFfiError *signal_username_candidates_from(SignalStringArray *out, const char *nickname, uint32_t min_len, uint32_t max_len);

SignalFfiError *signal_username_hash(uint8_t (*out)[32], const char *username);

SignalFfiError *signal_username_hash_from_parts(uint8_t (*out)[32], const char *nickname, const char *discriminator, uint32_t min_len, uint32_t max_len);

SignalFfiError *signal_username_link_create(SignalOwnedBuffer *out, const char *username, SignalBorrowedBuffer entropy);

SignalFfiError *signal_username_link_decrypt_username(const char **out, SignalBorrowedBuffer entropy, SignalBorrowedBuffer encrypted_username);

SignalFfiError *signal_username_proof(SignalOwnedBuffer *out, const char *username, const uint8_t (*randomness)[32]);

SignalFfiError *signal_username_verify(SignalBorrowedBuffer proof, SignalBorrowedBuffer hash);

SignalFfiError *signal_uuid_ciphertext_check_valid_contents(SignalBorrowedBuffer buffer);

SignalFfiError *signal_validating_mac_destroy(SignalMutPointerValidatingMac p);

SignalFfiError *signal_validating_mac_finalize(int32_t *out, SignalMutPointerValidatingMac mac);

SignalFfiError *signal_validating_mac_initialize(SignalMutPointerValidatingMac *out, SignalBorrowedBuffer key, uint32_t chunk_size, SignalBorrowedBuffer digests);

SignalFfiError *signal_validating_mac_update(int32_t *out, SignalMutPointerValidatingMac mac, SignalBorrowedBuffer bytes, uint32_t offset, uint32_t length);

SignalFfiError *signal_webp_sanitizer_sanitize(SignalConstPointerFfiSyncInputStreamStruct input);

#endif  /* SIGNAL_FFI_H_ */
