
#define USE_SFT    // sft support in ftp server
#define USE_DCACHE // mainly for dview net files
#define REDUCE_CACHE_FILE_NAMES

#if !defined(VER_STR_OS) && defined(_WIN32)
 #define _WIN32_WINNT 0x0400 // for copyFileEx
#endif

#define FOR_SFK_INCLUDE
#include "sfkbase.hpp"

#if (defined(SFKWEB) || defined(SFKPIC) || defined(SFK_PROFILING))
 #include "sfkint.hpp"
#endif

// dmod text_match
#if (sfk_prog || sfk_text_match)
 #define SFKMATCH_IMPORTED
 #include "sfkmatch.hpp"
// emod
#endif // (sfk_prog || sfk_text_match)

// in case of linking problems concerning libsocket etc.,
// you may out-comment this to compile without tcp support:
#ifndef USE_SFK_BASE
 #define WITH_TCP
 #define SFK_FTP_TIMEOUT "30" // seconds, as string
#endif // USE_SFK_BASE

#define snprintf  mysnprintf
#define sprintf   mysprintf

// just close on a socket is not enough.
// myclosesocket also does the shutdown().
#define closesocket myclosesocket

#ifdef _WIN32
 #ifdef SFK_MEMTRACE
  #define  MEMDEB_JUST_DECLARE
  #include "memdeb.cpp"
 #endif
#endif

#include "sfkext.hpp"

#ifndef SO_REUSEPORT
 #define SO_REUSEPORT 15
#endif

int iGlblWebCnt=0;
FILE *fGlblWebDump=0;

// dmod net
#if (sfk_prog || sfk_net)

uint   glblFromTCPPort    = 0;
SOCKET glblFromTCPASocket = INVALID_SOCKET;
SOCKET glblFromTCPCSocket = INVALID_SOCKET;

TCPCon *aGlblUserSocket[20] =
   { 0,0,0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,0,0 };

// emod net
#endif // (sfk_prog || sfk_net)

#ifdef WITH_SSL

// ssl.step.0 link to latest libopenssl V1.1
int bGlblSSLInitDone = 0;

void prepareSSL()
{
   if (bGlblSSLInitDone)
      return;
   bGlblSSLInitDone = 1;

   // ssl.step.1 algorithms
   SSL_load_error_strings();
   SSLeay_add_ssl_algorithms();
}

#endif // WITH_SSL

#ifndef USE_SFK_BASE
// dmod net
#if (sfk_prog || sfk_net)
UDPIO sfkNetSrc; // for fromnet
// emod net
#endif // (sfk_prog || sfk_net)
#endif // USE_SFK_BASE

extern unsigned char abBuf[MAX_ABBUF_SIZE+100];
extern struct CommandStats cspre;
extern Array glblGrepPat;
extern Array glblUnzipMask;

#ifdef _WIN32
bool vname();
#endif

extern cchar *pszGlblBlank;
int printx(const char *pszFormat, ...);
int esys(const char *pszContext, const char *pszFormat, ...);
extern cchar *arcExtList[];
void tellMemLimitInfo();
int quietMode();
char *getHTTPUserAgent();
int getTwoDigitHex(char *psz);
extern char *ipAsString(struct sockaddr_in *pAddr, char *pszBuffer, int iBufferSize, uint uiFlags=0);
extern char *ipAsString(uint ip, int iport=0);
void printCopyCompleted(char *pszName, uint nflags);
void setTextColor(int n, bool bStdErr=0, bool bVerbose=0);
bool endsWithColon(char *pszPath);
int cloneAttributes(char *pszSrc, char *pszDst, int nTraceLine);
bool canWriteFile(char *pszName, bool bTryCreate);
int setWriteEnabled(char *pszFile);
void oprintf(cchar *pszFormat, ...);
void oprintf(StringPipe *pOutData, cchar *pszFormat, ...);
bool iseol(char c);
int loadInput(uchar **ppInText, char **ppInAttr, num *pInSize, bool bstdin, char *pszInFile, bool bColor);
int loadInputFilenames(uchar **ppInText, num *pInSize, bool bstdin=0, char *pszInFile=0);
FILE *openOutFile(int &rrc);
int pferr(const char *pszFile, const char *pszFormat, ...);
void encodeSub64(uchar in[3], uchar out[4], int nlen);
void decodeSub64(uchar in[4], uchar out[3]);
uchar mapchar(char ch);
bool validFromIPMask(char *pszmask);
bool encodeURL(char *pszRaw);
int execHttpLog(uint nPort, char *pszForward, int nForward);
int cbSFKMatchOutFN(int iFunction, char *pMask, int *pIOMaskLen, uchar **ppOut, int *pOutLen);
void copySFKMatchOptions();
int createOutDirTreeW(char *pszOutFile, KeyMap *pOptMap, bool bForDir=0);
int renderOutMask(char *pDstBuf, Coi *pcoi, char *pszMask, cchar *pszCmd, bool bUniPath=0);
int dumpOutput(uchar *pOutText, char *pOutAttr, num nOutSize, bool bHexDump);
bool anyHiCodes(char *psz);
int makeServerSocket(
   uint  &nNewPort,                 // i/o parm
   struct sockaddr_in &ServerAdr,   // i/o parm
   SOCKET &hServSock,
   cchar  *pszInfo,
   uint  nAltPort=0                 // e.g. 2121 for ftp
   );
num getCurrentTicks();
void initRandom(char *penv[]);
int callLabel(char *pScript, int argc, char *argx[], char *penv[],
   char *pszLabel, int iLocalParm, int nLocalParm,
   int &lRC, bool &bFatal);
bool flexMatch(char *pszhay, cchar *pszpat);
char *getAbsPathStart(char *pszin);
int nextLine(char **pp);
uint currentKBPerSec();
uint lastErrno();
extern bool glblUPatMode;

#ifdef _WIN32
   #define mypopen _popen
   #define mypclose _pclose
#else
   #define mypopen popen
   #define mypclose pclose
#endif

static const char aenc64loc[] =
   "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"
   "0123456789+/";

// dmod file_inst
#if (sfk_prog || sfk_file_inst)
bool  bGlblInstRevoke = 0;
bool  bGlblInstRedo   = 0;
bool  bGlblInstEol    = 0;
cchar *pszGlblInstInc  = "";
cchar *pszGlblInstMac  = "";
static bool bGlblTouchOnRevoke = 1;
// emod file_inst
#endif // (sfk_prog || sfk_file_inst)

#ifdef SFKWINST
int makeDeskIcon(HWND hwnd, char *pszTarget, char *pszShortCutName,
   char *pszWorkDir, char *pszArgs, bool bDelete);
int installSFK(char *pszFolder, bool byes);
#endif // SFKWINST

#ifdef SFKPIC
#define MAX_RECOL_COLORS 128
uint nGlblRecol = 0;
uint aGlblRecolSrc[MAX_RECOL_COLORS+4];
uint aGlblRecolDst[MAX_RECOL_COLORS+4];
#endif // SFKPIC

extern CoiTable glblFileListCache;

extern num  nGlblMemLimit;
extern int nGlblActiveFileAgeLimit;
extern bool bGlblIgnoreTime     ;
extern bool bGlblIgnore3600     ;
extern bool bGlblHexDumpWide    ;
extern int nGlblHexDumpForm     ;
extern num  nGlblHexDumpOff     ;
extern num  nGlblHexDumpLen     ;
extern char  *pszGlblCopySrc    ;
extern char  *pszGlblCopyDst    ;
extern uchar *pGlblWorkBuf      ;
extern num    nGlblWorkBufSize  ;
extern int   nGlblCopyStyle     ;
extern int   nGlblCopyShadows   ;
extern int   nGlblConsRows      ;
extern int   nGlblConsColumns   ;
extern num   nGlblShadowSizeLimit;
extern bool  bGlblUseCopyCache  ;
extern bool  bGlblShowSyncDiff  ;
extern num   nGlblMemLimit      ;
extern bool  bGlblMemLimitWasSet ;
extern bool  bGlblNoMemCheck     ;
extern char  *pGlblCurrentScript ;

extern int nGlblHeadColor      ;
extern int nGlblExampColor     ;
extern int nGlblFileColor      ;
extern int nGlblLinkColor      ;
extern int nGlblHitColor       ;
extern int nGlblRepColor       ;
extern int nGlblErrColor       ;
extern int nGlblWarnColor      ;
extern int nGlblPreColor       ;
extern int nGlblTimeColor      ;
extern int nGlblTraceIncColor  ;
extern int nGlblTraceExcColor  ;

extern bool bGlblRandSeeded;


// sfk1972 FROM HERE ON, ALL fread() and fwrite() calls are MAPPED to SAFE versions
// to work around Windows runtime bugs (60 MB I/O bug, stdin joined lines etc.)

size_t safefread(void *pBuf, size_t nBlockSize, size_t nBufSize, FILE *fin);
size_t safefwrite(const void *pBuf, size_t nBlockSize, size_t nBufSize, FILE *fin);

#define fread  safefread
#define fwrite safefwrite

// for num
unum getFlexNum(char *psz, bool bAllHex)
{
   /*
      123
      123.123.123.123
      010101011101010
      010.011.101.010
      ab2f37e9
      0x123
      0o234
      0b100
   */

   // pass 1: get overall type
   bool bbin=0,bdig=0,bxdig=bAllHex,bdots=0,bchar=0;
   if (strBegins(psz, "0x"))
      { bxdig=1; psz+=2; }
   else
   if (strBegins(psz, "0b"))
      { bbin=1; psz+=2; }
   else
   if (strBegins(psz, "0t"))
      { bchar=1; psz+=2; }
   else
   for (char *psz2=psz; *psz2; psz2++) {
      char c = tolower(*psz2);
      if (isdigit(c))
         { bdig=1; continue; }
      if (isxdigit(c))
         { bxdig=1; continue; }
      if (c=='0' || c=='1')
         { bbin=1; continue; }
      if (c=='.')
         { bdots=1; continue; }
      bchar=1;
   }

   int ibase=1;
   if (bxdig) ibase=16;
   else
   if (bdig)  ibase=10;
   else
   if (bbin)  ibase=2;

   // pass 2: collect number(s)
   unum ncur=0,nout=0;
   for (; *psz; psz++) {
      char c = tolower(*psz);
      if (c=='.') {
         nout = nout + ncur;
         nout = nout * 256;
         ncur = 0;
         continue;
      }
      if (bchar) {
         ncur = ncur * 256;
         ncur = ncur + (unum)(*psz);
         continue;
      }
      ncur = ncur * ibase;
      switch (c) {
         case '0': case '1': case '2': case '3': case '4':
         case '5': case '6': case '7': case '8': case '9':
            ncur = ncur + ((unum)c - '0');
            continue;
         case 'a': case 'b': case 'c': case 'd': case 'e': case 'f':
            ncur = ncur + 10 + ((unum)c - 'a');
            continue;
      }
   }

   nout = nout + ncur;

   return nout;
}

void detabLine(char *pszIn, char *pszOut, uint lMaxOut, int nTabSize)
{
   uint nInsert=0, iout=0;
   for (int icol=0; (pszIn[icol]!=0) && (iout<lMaxOut-1); icol++)
   {
      char c1 = pszIn[icol];
      if (c1 == '\t') {
         nInsert = nTabSize - (iout % nTabSize);
         for (uint i2=0; i2<nInsert; i2++)
            pszOut[iout++] = ' ';
      } else {
         pszOut[iout++] = c1;
      }
   }
   pszOut[iout] = '\0';
}

// dmod net_udp
#if (sfk_prog || sfk_net_udp)
UDPIO::UDPIO( )
{
   rawInit();
}

void UDPIO::rawInit( )
{
   memset(this, 0, sizeof(*this));

   fdClSocket = INVALID_SOCKET;
   mclear(szClDescription);
   mclear(clTargetAddr);
   mclear(clRawInAddr);
   mclear(clInBufInAddr);
   iClOwnReceivePort = 0;
   iClTargetSendPort = 0;
   bClMulticast = 0;
   bClVerbose = false;
   iClPackageSize = 1000;
   bClRawText = 0;
   iClReqNum = 1;
   iClTimeout = 1000;
   cClCurrentInColor = ' ';
   cClTellColor = '\0';
   iClUsingAltPortInsteadOf = -1;
   iClNonDuplexSendDelay = 10;
}

UDPIO::~UDPIO( )
{
   if (fdClSocket != INVALID_SOCKET)
   {
      closesocket(fdClSocket);
   }
}

bool UDPIO::isOpen( )
{
   return (fdClSocket != INVALID_SOCKET) ? 1 : 0;
}

int UDPIO::closeAll( )
{
   if (fdClSocket != INVALID_SOCKET)
   {
      closesocket(fdClSocket);
   }

   rawInit();
 
   return 0;
}

bool UDPIO::isMulticast( )
{
   return bClMulticast;
}

// RC  9 : cannot create socket
//    10 : cannot bind socket
//    11 : cannot multicast
int UDPIO::initSendReceive
 (
   const char *pszDescription,
   int iOwnReceivePort,
   int iTargetSendPort,
   char *pszTargetAddress,
   uint uiFlags
 )
{
   strcopy(szClDescription, pszDescription);

   iClOwnReceivePort = iOwnReceivePort;
   iClTargetSendPort = iTargetSendPort;
   iClUsingAltPortInsteadOf = -1;

   // printf("UDP: initSendReceive ownport=%d targport=%d addr=%s\n",
   //   iOwnReceivePort, iTargetSendPort, pszTargetAddress);

   bClMulticast = (uiFlags & 1) ? 1 : 0;
   bool bReuse  = (uiFlags & 2) ? 1 : 0;
   bool bRetry  = (uiFlags & 4) ? 1 : 0;
   bool bBroadcast = (uiFlags & 8) ? 1 : 0;

   if (pszTargetAddress && strchr(pszTargetAddress, '.'))
   {
      // check for multicast addresses "224.x" to "239.x"
      int iFirstPart = atoi(pszTargetAddress);
      if (iFirstPart >= 224 && iFirstPart <= 239)
         bClMulticast = true;
   }

   int fdTmp = socket(AF_INET, SOCK_DGRAM, 0);

   if (fdTmp < 0)
   {
      perr("Error creating socket for %s. errno=%u %s\n",
         szClDescription, netErrno(), netErrStr());
      return 9;
   }

   if (bReuse)
   {
      int nOnVal = 1;
      setsockopt(fdTmp, SOL_SOCKET, SO_REUSEADDR, (const char *)&nOnVal, sizeof(nOnVal));
   }
   if (bBroadcast)
   {
      int nOnVal = 1;
      setsockopt(fdTmp, SOL_SOCKET, SO_BROADCAST, (const char*)&nOnVal, sizeof(nOnVal));
   }

   if (iOwnReceivePort >= 0)
   {
      int iMaxTry = bRetry ? 5 : 1;

      for (int itry=0; itry<iMaxTry; itry++)
      {
         // on port conflict, retry 10 ports higher
         iClOwnReceivePort = iOwnReceivePort + itry * 10;
 
         // own address for input
         struct sockaddr_in saOwnAddr;
         memset((char *)&saOwnAddr, 0,sizeof(saOwnAddr));

         saOwnAddr.sin_family      = AF_INET;
         saOwnAddr.sin_port        = htons(iClOwnReceivePort);
         saOwnAddr.sin_addr.s_addr = INADDR_ANY;
 
         if (bind(fdTmp, (struct sockaddr *)&saOwnAddr, sizeof(saOwnAddr)) >= 0) {
            if (itry > 0)
               iClUsingAltPortInsteadOf = iOwnReceivePort;
            break; // OK
         }

         if (itry < iMaxTry-1) {
            pwarn("Cannot listen on port %d, retrying on %d.", iClOwnReceivePort, iClOwnReceivePort+10);
            // and reloop
         } else {
            perr("Cannot listen on port %d, rc=%d.", iClOwnReceivePort, netErrno());
            perr("Missing access rights, or port used by other program.\n");
            return 10;
         }
      }
   }

   if (isMulticast())
   {
      struct ip_mreq mreq;
      memset(&mreq, 0, sizeof(mreq));
      mreq.imr_interface.s_addr = htonl(INADDR_ANY);

      #if defined(MAC_OS_X) || defined(SOLARIS)
        #define SOL_IP IPPROTO_IP
      #endif

      #ifdef _WIN32
 
      char name[512];
      PHOSTENT hostinfo;
      mclear(name);
      mclear(hostinfo);

      if (gethostname(name, sizeof(name)))
         return 11+perr("gethostname failed\n");

      if (!(hostinfo=gethostbyname(name)))
         return 11+perr("get ownhost failed (%s) (2)\n", name);

      for (int i=0; hostinfo->h_addr_list[i]; i++) // sfk1962 mcast receive
      {
         struct in_addr *pin_addr = (struct in_addr *)hostinfo->h_addr_list[i];
         mreq.imr_interface.s_addr = pin_addr->s_addr;
         mreq.imr_multiaddr.s_addr = inet_addr(pszTargetAddress);
 
         // force IP_ADD_MEMBERSHIP of ws2tcpip.h
         #define MY_IP_ADD_MEMBERSHIP 12
 
         if (setsockopt(fdTmp, IPPROTO_IP, MY_IP_ADD_MEMBERSHIP, (char *)&mreq, sizeof(mreq)) != 0 )
            return 11+perr("Join multicast failed. Errno=%u (%s)",  netErrno(), netErrStr());
      }

      // in case of error 10042 see
      //    http://support.microsoft.com/kb/257460
      // wrong winsocket header, runtime linkage etc.
 
      #else

      if (inet_aton(pszTargetAddress, &mreq.imr_multiaddr) == 0)
      {
         perr("Join multicast failed: bad address %s\n", pszTargetAddress);
         return 11; // cannot multicast
      }

      if (setsockopt(fdTmp, SOL_IP, IP_ADD_MEMBERSHIP, &mreq, sizeof(mreq)) != 0 )
      {
         perr("No default-route to support multicast.");
         perr("Try 'route add -net 224.000 netmask 240.000 eth0'");
         return 11;
      }

      #endif
 
      // printf("mcast: fd=%d outport=%d inport=%d group=%s active.\n",
      //   fdTmp, iClTargetSendPort, iClOwnReceivePort, pszTargetAddress);

      // do not call gethostbyname, but set addr manually
      memset((char *)&clTargetAddr, 0,sizeof(clTargetAddr));

      clTargetAddr.sin_family      = AF_INET;
      clTargetAddr.sin_addr.s_addr = inet_addr(pszTargetAddress);
      clTargetAddr.sin_port        = htons((int)iClTargetSendPort);
   }
   else if (pszTargetAddress)
   {
      // printf("udp: fd=%d outport=%d inport=%d active.\n",
      //   fdTmp, iClTargetSendPort, iClOwnReceivePort);

      if (setTarget(pszTargetAddress, iClTargetSendPort))
         return 12;
   }
 
   fdClSocket = fdTmp;

   return 0;
}

int UDPIO::setTarget(char *pszTargetAddress, int iTargetPort)
{
   memset((char *)&clTargetAddr, 0,sizeof(clTargetAddr));
   bClIPWasExpanded = 0;

   clTargetAddr.sin_family = AF_INET;
   clTargetAddr.sin_port   = htons((int)iTargetPort);

   int isubrc = setaddr(&clTargetAddr, pszTargetAddress, 2);
   // rc 1: ip was expanded
   // rc 9: error

   if (isubrc >= 9)
      return 11;

   if (isubrc == 1)
      bClIPWasExpanded = 1;

   return 0;
}

// RC  0 : OK
//     9 : send failed, no socket
//    10 : send failed, transmission error
//    11 : send failed, wrong parameters
int UDPIO::sendData(uchar *pData, int iDataSize)
{
   if (fdClSocket == INVALID_SOCKET)
      return 9+perr("send: invalid UDP socket\n");

   if (sendto(fdClSocket, (char *)pData, iDataSize, 0,
          (struct sockaddr *)&clTargetAddr, sizeof(clTargetAddr)) != iDataSize)
   {
      perr("send: failed errno=%d %s\n", netErrno(), netErrStr());
      return 12;
   }

   return 0;
}

// RC >  0 : number of bytes received
// RC <= 0 : error
int UDPIO::receiveData(
   uchar *pBuffer, int iBufferSize,
   struct sockaddr_in *pAddrIncoming,
   int iSizeOfAddrIncoming
 )
{
   if (fdClSocket == INVALID_SOCKET)
      return -1;

   int iRead = 0;

   if (isDataAvailable(0, 0))
   {
      struct sockaddr addrIncoming;
      memset(&addrIncoming, 0, sizeof(addrIncoming));
 
      socklen_t clilen = sizeof(addrIncoming);
 
      // receive with 10 bytes buffer tolerance.
      // result is guaranteed to be zero terminated.
      iRead = recvfrom(fdClSocket, (char*)pBuffer, iBufferSize-10, 0, &addrIncoming, &clilen);
 
      if (pAddrIncoming != 0 && clilen == iSizeOfAddrIncoming)
         memcpy(pAddrIncoming, &addrIncoming, iSizeOfAddrIncoming);
   }

   // always guarantee zero termination.
   if (iRead >= 0)
      pBuffer[iRead] = '\0';

   return iRead;
}

bool UDPIO::isDataAvailable(int iSec, int iMSec)
{
   if (fdClSocket == INVALID_SOCKET)
      return false;

   struct timeval tv;
   fd_set fdvar;

   tv.tv_sec  = iSec;
   tv.tv_usec = iMSec ? iMSec * 1000 : 100;

   FD_ZERO(&fdvar);
   FD_SET(fdClSocket, &fdvar);

   if (select(fdClSocket+1, &fdvar, 0, 0, &tv) > 0)
      return 1;

   return 0;
}

// SYNC also: sendDuplexReply
int UDPIO::addHeader( )
{
   iClRecentReqNum = iClReqNum;

   char szStartColor[20];
   szStartColor[0] = '\0';
   if (cClTellColor)
   {
      sprintf(szStartColor, ",sc%c", cClTellColor);
      cClTellColor = '\0';
   }

   sprintf(aClRawOutBuf, ":sfktxt:v100,req%d%s,rt0%s%s,fl\n",
      iClReqNum++,
      bClDuplex ? ",copy" : "",
      bClColor ? ",cs1" : "",
      szStartColor
      );

   // remember index of retry number
   char *psz = strstr(aClRawOutBuf, ",rt0");
   if (psz)
      iClRetryOff = (psz - aClRawOutBuf) + 3;
 
   // remember index of split line indicator
   iClSLIOff = strlen(aClRawOutBuf) - 3;

   for (int i=0; i<iClCommand; i++)
   {
      strcat(aClRawOutBuf, ":");
      strcat(aClRawOutBuf, aClCommand[i]);
      strcat(aClRawOutBuf, "\n");
   }
   strcat(aClRawOutBuf, "\n");
 
   iClCommand = 0;

   iClHeadSize = strlen(aClRawOutBuf);
   iClOutIndex = iClHeadSize;
   return 0;
}

bool UDPIO::hasCachedOutput( )
{
   return iClOutIndex > iClHeadSize ? 1 : 0;
}

int UDPIO::flushSend(bool bTellAboutSplitLine)
{
   // set optional split line indicator in header
   if (   !bClRawText && bTellAboutSplitLine
       && iClSLIOff > 0 && iClSLIOff < iClHeadSize
      )
      aClRawOutBuf[iClSLIOff] = 's'; // ,fl -> ,sl

   int irc = 0;
   int itry = 0;
 
   // printf("-----------------------------\n");

   for (; itry<10; itry++)
   {
      if (itry >= 5) {
         perr("line broken, failed to send package %d times.\n", itry);
         irc = 9;
         break;
      }
 
      if (iClRetryOff > 0 && iClRetryOff < iClHeadSize) {
         aClRawOutBuf[iClRetryOff] = itry + '0';
      }

      if ((irc = sendData((uchar*)aClRawOutBuf, iClOutIndex)))
         break;
 
      // printf("SENT: %s\n", aClRawOutBuf);

      if (bClDuplex)
      {
         if (!isDataAvailable(0, iClTimeout))
            continue; // retry send

         aClRawInBuf2[0] = '\0';

         int i = receiveData((uchar*)aClRawInBuf2, sizeof(aClRawInBuf2)-100);
         if (i <= 0)
            continue; // retry send

         // printf("RECV: \"%s\" (%d)\n", aClRawInBuf2, i);

         // :sfktxt:v100,rep123,ok\n\n
         char *psz = strstr(aClRawInBuf2, ",rep");
         if (!psz) {
            perr("wrong -duplex reply received: %.30s", aClRawInBuf2);
            irc = 9;
            break;
         }

         int iReqNum = iClRecentReqNum;
         int iRepNum = atoi(psz+4);
         if (iRepNum < iReqNum)
         {
            // happens when sending retry requests which are answered
            // AFTER we already sent the next original request.
            pwarn("duplex: old reply record (%d/%d), lines may be duplicated\n", iReqNum, iRepNum);
            irc = 5;
            break;
         }
         else
         if (iRepNum != iReqNum)
         {
            // should not happen.
            pwarn("duplex: wrong reply record (%d/%d), lines may be invalid\n", iReqNum, iRepNum);
            irc = 5;
            break;
         }

         // package was fully confirmed
         break;
      }
      else
      {
         if (iClNonDuplexSendDelay)
            doSleep(iClNonDuplexSendDelay);
         break;
      }
   }

   iClHeadSize = 0;
   iClOutIndex = 0;
   iClCommand  = 0;
   iClSLIOff   = 0;

   return irc;
}

int UDPIO::addCommand(char *pszCmd)
{
   int iMaxCommands = sizeof(aClCommand)/sizeof(aClCommand[0]);
   if (iClCommand < 0 || iClCommand >= iMaxCommands-2)
      return 5;
 
   int iMaxCopy = sizeof(aClCommand[0])-2;
   strncpy(aClCommand[iClCommand], pszCmd, iMaxCopy);
   aClCommand[iClCommand][iMaxCopy-2] = '\0';
   iClCommand++;
 
   return 0;
}

char UDPIO::sfkToNetColor(char c)
{
   switch (c)
   {
      // keep these as is
      case 'r': case 'g': case 'b': case 'y': case 'c': case 'm':
      case 'R': case 'G': case 'B': case 'Y': case 'C': case 'M':
         return c;

      // white is sfk-internally coded as v to separate from
      // logical 'w'arning color.
      case 'v': return 'w';
      case 'V': return 'W';

      // default color ' ' is marked as 'd'
      case ' ': return 'd';
   }
 
   // all other cases are sfk logical colors
   extern int sfkMapAttrToColor(char cAttr);
   int nSFKIntColor = sfkMapAttrToColor(c);
 
   // bit   0:bright 1:red 2:green 3:blue
   // value     1       2      4      8
   switch (nSFKIntColor)
   {
      case  0: case 1: return 'd';
      case  2: return 'r';
      case  3: return 'R';
      case  4: return 'g';
      case  5: return 'G';
      case  6: return 'y';
      case  7: return 'Y';
      case  8: return 'b';
      case  9: return 'B';
      case 10: return 'm';
      case 11: return 'M';
      case 12: return 'c';
      case 13: return 'C';
      case 14: return 'w';
      case 15: return 'W';
   }

   // all other cases
   return 'd';
}

int UDPIO::checkTellCurrentColor(char cSFKAttrib)
{
   if (iClOutIndex > 0)
      return 5; // something was cached already

   cClTellColor = sfkToNetColor(cSFKAttrib);
 
   return 0;
}

int UDPIO::addOrSendText(char *pszInText, char *pszInAttr)
{
   if (bClRawText)
   {
      bClColor = 0;
      return addOrSendText(pszInText, strlen(pszInText), 0);
   }

   int iPhrase = 0;
   int iSrcCur = 0;
   int iAttCur = 0;
 
   // next addHeader should tell about color coding
   bClColor = 1;

   // if nothing was cached or sent yet, tell current color
   char cFirstColor = pszInAttr[0] ? pszInAttr[0] : ' ';
   checkTellCurrentColor(cFirstColor);

   // force setting of current color on every line start
   char aOld = '\0';

   char szCmd[30];

   memset(szCmd, 0, sizeof(szCmd));
   szCmd[0] = (char)0x1F;

   int irc = 0;

   while (1)
   {
      char c = pszInText[iSrcCur];
      char a = pszInAttr[iAttCur];

      if (!c)
         break;

      // attribs may end sooner, e.g. on LF of text
      if (a)
         iAttCur++;
      else
         a = aOld;

      if (a != aOld)
      {
         // color change: flush recent phrase, if any
         if (iSrcCur > iPhrase)
            if ((irc = addOrSendText(pszInText+iPhrase, iSrcCur-iPhrase, 0)))
               return irc;
         iPhrase = iSrcCur;

         // send \x1F and color code
         szCmd[1] = sfkToNetColor(a);
         if ((irc = addOrSendText(szCmd, 2, 1)))
            return irc;
 
         // switch current color
         aOld = a;
      }
 
      if (((uchar)c) == 0x1FU)
      {
         // input contains non control \x1F: flush phrase
         if (iSrcCur > iPhrase)
            if ((irc = addOrSendText(pszInText+iPhrase, iSrcCur-iPhrase, 0)))
               return irc;
         iPhrase = iSrcCur;

         // send escaped \x1F\x1F
         szCmd[1] = sfkToNetColor(a);
         if ((irc = addOrSendText(szCmd, 2, 1)))
            return irc;
      }
 
      iSrcCur++;
   }

   // flush remainder:
   if (iSrcCur > iPhrase)
      if ((irc = addOrSendText(pszInText+iPhrase, iSrcCur-iPhrase, 0)))
         return irc;

   return 0;
}

int UDPIO::addOrSendText(char *pszPhrase, int iPhraseLen, bool bNoWrap)
{
   int irc = 0;

   if (!iClOutIndex && !bClRawText)
      addHeader();

   // package size with tolerance for EOL etc.
   int iNettoPackSize = iClPackageSize - 4;

   int iSrcLenRaw = iPhraseLen;
   int iCopyLen   = iSrcLenRaw;

   char *pszSrcCur= pszPhrase;
   int iSrcRemain = iSrcLenRaw;

   // color control sequences should never be split
   if (bNoWrap != 0 && iClOutIndex + iCopyLen > iNettoPackSize)
   {
      // therefore don't try to wrap, but flush immediately
      if ((irc = flushSend(0)))
         return irc;

      if (!bClRawText)
         addHeader();

      // iClOutIndex was reset, is now after new header.
   }

   while (   iCopyLen > 0
          && iClOutIndex + iCopyLen > iNettoPackSize
         )
   {
      // phrase does not fit completely.
      // try a soft wrap based on CR or LF.
      // we do NOT consider control sequences here.
      int iWrap = 0;
      for (int i=0; iClOutIndex+i<iNettoPackSize;)
      {
         if (!strncmp(pszSrcCur+i, "\r\n", 2))
            { iWrap=i+2; i+=2; } // after EOL
         else
         if (pszSrcCur[i]=='\r' || pszSrcCur[i]=='\n')
            { iWrap=i+1; i++; }  // after EOL
         else
            i++;
      }

      bool bSplitLine = 0;

      if (iWrap > 0) {
         iCopyLen = iWrap; // until wrap point
         // printf("... soft wrap %d\n", iWrap);
      }
      else
      if (iClOutIndex - iClHeadSize > 0) {
         // found no soft wrap point, but there is cached text
         iCopyLen = 0;     // flush recent as is
         // printf("... flush recent %d\n", iClOutIndex - iClHeadSize);
      }
      else {               // hard wrap
         iCopyLen = iNettoPackSize - iClOutIndex;
         bSplitLine = 1;
         // printf("... hard wrap %d %d %d\n", iCopyLen, iNettoPackSize, iClOutIndex);
      }
 
      // printf("addOrSend: %.*s (%d)\n", (int)iCopyLen, pszSrcCur, iCopyLen);
 
      if (iCopyLen > 0)
         memcpy(aClRawOutBuf+iClOutIndex, pszSrcCur, iCopyLen);
      iClOutIndex += iCopyLen;

      if ((irc = flushSend(bSplitLine)))
         return irc;

      if (!bClRawText)
         addHeader();

      pszSrcCur  += iCopyLen;
      iSrcRemain -= iCopyLen;
      iCopyLen    = iSrcRemain;
   }
 
   if (iCopyLen > 0)
   {
      // add (last part of) phrase to cache
      memcpy(aClRawOutBuf+iClOutIndex, pszSrcCur, iCopyLen);
      iClOutIndex += iCopyLen;
   }
 
   return irc;
}

int UDPIO::storeHeader(char *pszRaw, int iHeadLen)
{
   /*
      :sfktxt:v100,req1,copy,scd\n
      :clear\n
      :setpos,10,10\n
      :status,step 1\n
   */

   if (iHeadLen > sizeof(aClHeaderBuf)-100)
       iHeadLen = sizeof(aClHeaderBuf)-100;
   memcpy(aClHeaderBuf, pszRaw, iHeadLen);
   aClHeaderBuf[iHeadLen] = '\0';

   char *pszLine = aClHeaderBuf;

   // parse headline
   while (*pszLine)
   {
      if (*pszLine=='\n')
         { pszLine++; break; }
      if (*pszLine==',') {
         pszLine++;
         if (!strncmp(pszLine, "req", 3))
            iClInReqNum = atoi(pszLine+3);
         if (!strncmp(pszLine, "rt", 2))
            iClInRetryNum = atoi(pszLine+2);
         if (!strncmp(pszLine, "copy", 4))
            bClCopyRequest = 1; // duplex
         if (!strncmp(pszLine, "cs1", 3))
            bClDecodeColor = 1;
         if (bClDecodeColor && !strncmp(pszLine, "sc", 2))
            cClCurrentInColor = pszLine[6]; // start color
         continue;
      }
      pszLine++;
   }
 
   // parse commands.
   while (*pszLine)
   {
      // valid command lines must end with LF
      char *pszNext = strchr(pszLine, '\n');
      if (!pszNext)
         break; // possibly truncated header
      *pszNext++ = '\0';

      if (!strcmp(pszLine, ":clear"))
         bClCmdClear = 1;

      // to next line
      pszLine = pszNext;
   }

   return 0;
}

// IN : aClRawInBuf1 with mixed text
// OUT: aClRawInBuf2 with plain text
//      aClRawInAttr2 with color attributes
int UDPIO::decodeColorText(int iFromOffset)
{
   aClRawInBuf2[0]  = '\0';
   aClRawInAttr2[0] = '\0';

   int iSrcCur = iFromOffset;

   int iDstCur = 0;
   int iDstMax = sizeof(aClRawInBuf2) - 100;
 
   int iAttCur = 0;
   int iAttMax = sizeof(aClRawInAttr2) - 100;

   char a = cClCurrentInColor;

   while (iDstCur < iDstMax)
   {
      char c = aClRawInBuf1[iSrcCur];

      if (!c)
         break;

      if (bClDecodeColor!=0 && ((uchar)c) == 0x1FU)
      {
         // control sequence. get next char.
         iSrcCur++;
         char c2 = aClRawInBuf1[iSrcCur];

         if (!c2)
         {
            // invalid sequence at end of text.
            // treat as single control char.
            aClRawInBuf2[iDstCur++] = c;
            if (iAttCur < iAttMax)
             aClRawInAttr2[iAttCur++] = a;
            pwarn("invalid control sequence in color text\n");
            break;
         }
 
         if (((uchar)c2) == 0x1FU)
         {
            // escaped \x1F. replace by single char.
            aClRawInBuf2[iDstCur++] = c;
            if (iAttCur < iAttMax)
             aClRawInAttr2[iAttCur++] = a;

            iSrcCur++;
            continue;
         }
 
         // change current color
         a = c2;
 
         // also remember for package spanning text
         cClCurrentInColor = a;
 
         iSrcCur++;
         continue;
      }
 
      // copy through plain text char
      aClRawInBuf2[iDstCur++] = c;
      if (iAttCur < iAttMax)
       aClRawInAttr2[iAttCur++] = a;

      iSrcCur++;
   }

   // MUST zero terminate.
   aClRawInBuf2[iDstCur] = '\0';
   aClRawInAttr2[iAttCur] = '\0';

   return 0;
}

int UDPIO::getClientIndex(struct sockaddr_in *pAddr, bool *pFound)
{
   int iEmpty  = -1;
   int nOldest =  0;
   int iOldest =  0;

   struct UCPClientState *pcln = 0;

   for (int i=0; i<UDPIO_MAX_CLIENTS; i++)
   {
      pcln = &aClClients[i];

      // empty slot?
      if (!pcln->ntime) {
         if (iEmpty < 0)
            iEmpty = i;
         continue;
      }
      // oldest slot?
      if (nOldest==0 || pcln->ntime<nOldest) {
         nOldest = pcln->ntime;
         iOldest = i;
      }
      // matching?
      if (   pAddr->sin_addr.s_addr == pcln->addr.sin_addr.s_addr
          && pAddr->sin_port == pcln->addr.sin_port
         )
      {
         *pFound = 1;
         return i;
      }
   }

   int iReuse = (iEmpty >= 0) ? iEmpty : iOldest;

   pcln = &aClClients[iReuse];

   memset(pcln, 0, sizeof(aClClients[iReuse]));
   pcln->ntime = getCurrentTime();
   pcln->reqnum = 0; // filled in later
   memcpy(&pcln->addr, pAddr, sizeof(struct sockaddr_in));
   pcln->color = 'd';

   return iReuse;
}

void dumpdata(const char *pszTitle, char *psz)
{
   printf("%s : \"", pszTitle);
   while (*psz) {
      switch (*psz) {
         case 0x1F: printf("{COL}"); break;
         case '\r': printf("{CR}"); break;
         case '\n': printf("{LF}"); break;
         default  : putchar(*psz);
      }
      psz++;
   }
   printf("\"\n");
}

bool UDPIO::hasCachedInput( )
{
   return iClRawInputCached > 0 ? 1 : 0;
}

int UDPIO::receiveText( )
{
   // to detect mixed input from different clients
   int iRecentClient = iClClient;
   bool bChangedClient = 0;

   if (!iClRawInputCached)
   {
      // cache is empty, get next network packet
      mclear(clRawInAddr);
      int clilen = sizeof(clRawInAddr);
      bool bSkipDecode = 0;
 
      // reinit per packet
      aClRawInBuf1[0]   = '\0';
      aClRawInBuf2[0]   = '\0';
      aClRawInAttr2[0]  = '\0';
      bClForceNextInput = 0;

      // taken from header, if any
      iClInReqNum = 0;
      iClInRetryNum = 0;
      bClCopyRequest = 0;
      cClCurrentInColor = 'd';
      bClCmdClear = 0;
      bClContinuedStream = 0;
      bClDecodeColor = 0;

      int iRawRead = receiveData((uchar*)aClRawInBuf1, sizeof(aClRawInBuf1)-100,
                                 &clRawInAddr, clilen);
      if (iRawRead <= 0)
         return 0;

      // data is zero terminated.
      // dumpdata("RECV", aClRawInBuf1); fflush(stdout);

      // set current client index by input address
      bool bClientRefound = 0;
      iClClient = getClientIndex(&clRawInAddr, &bClientRefound);

      // detect mixed client input
      if (iRecentClient != iClClient)
         bChangedClient = 1;
 
      bClRawText = 1;

      // parse header, if any
      if (!strncmp(aClRawInBuf1, ":sfktxt:", 8))
      {
         char *pszPastHeader = strstr(aClRawInBuf1, "\n\n");
         if (pszPastHeader)
         {
            // parse header
            pszPastHeader += 2; // keep the LFs
            int iHeadLen = pszPastHeader - aClRawInBuf1;
            storeHeader(aClRawInBuf1, iHeadLen);
            // sets reqnum, copyreq, currentcolor, cmdclear

            // is there a continued stream with a client?
            if (bClientRefound) {
               // normal transfer: reqnum increments by one
               if (iClInReqNum == aClClients[iClClient].reqnum + 1)
                  bClContinuedStream = 1;
               // retry transfer: trynum increments by one
               if (   iClInReqNum == aClClients[iClClient].reqnum
                   && iClInRetryNum == aClClients[iClClient].copytry + 1)
               {
                  // the client sent us same record TWICE because
                  // it received the first reply with a huge delay.
                  // repair this: the stream is still intact
                  bClContinuedStream = 1;
                  // we already replied for that reqnum, therefore
                  aClClients[iClClient].copytry++;
                  bClCopyRequest = 0;
                  // and the dup text must be dropped.
                  // because we skip colorDecode:
                  aClRawInBuf2[0] = '\0';
                  // leads to iToCopy == 0 below.
                  bSkipDecode = 1;
               }
            }
            aClClients[iClClient].reqnum = iClInReqNum;

            // then reuse recent color. redundant to storeHeader.
            if (bClContinuedStream && bClDecodeColor)
               cClCurrentInColor = aClClients[iClClient].color;

            // reply duplex request immediately
            if (bClCopyRequest) {
               bClCopyRequest = 0;
               sendDuplexReply(&clRawInAddr);
            }

            // apply color decoding. will just copy thru if bClDecodeColor==0
            if (!bSkipDecode) {
               int iText = pszPastHeader - aClRawInBuf1;
                decodeColorText(iText);
                // from InBuf1 to InBuf2
               aClClients[iClClient].color = cClCurrentInColor;
            }

            // cached in RawInBuf2, RawInAttr2
            bClRawText = 0;
 
            // printf("PART: \"%s\" clf=%d cstrm=%d\n", aClRawInBuf2, bClientRefound, bClContinuedStream);
         }
         // else fall thru as raw text
      }

      if (bClRawText)
      {
         // take plain UDP text as is
         memcpy(aClRawInBuf2, aClRawInBuf1, iRawRead);
         aClRawInBuf2[iRawRead] = '\0';
         memset(aClRawInAttr2, 'd', iRawRead);
         aClRawInAttr2[iRawRead] = '\0';
      }
   }

   // new or cached text input is now in RawInBuf2, RawInAttr2.
   int iToCopy = strlen(aClRawInBuf2);
   // can be NULL if input was just a color control sequence!
   // in this case, only state information like reqnum is cached.

   // when should we print collected chars to terminal?
   // - if the sfktxt client changed
   bool bShouldFlush = bChangedClient;
   // - OR if same client has no continued stream
   if (!bClContinuedStream)
        bShouldFlush = 1;
   // but never on raw text input, unless option LFOnRaw is set
   if (bClRawText && !bClAppendLFOnRaw)
      bShouldFlush = 0;

   // if there a partial line stored in output, we MUST feed the line
   // -  if the client changed
   // -  if the same client provides a mismatched request number
   if (iClInBufUsed > 0 && bShouldFlush)
   {
      // then the output line MUST be flushed now.
      // we keep current input in aClRawInBuf2.
      // all state like iClClient stays as is.
      iClRawInputCached = iToCopy; // can be NULL!
      bClForceNextInput = 1;
      // printf("back: caller must flush %d (1)\n", iClInBufUsed);
      return 1;
   }

   // is enough space in rejoin buffer for further text?
   if (iClInBufUsed + iToCopy > MAX_LINE_LEN)
   {
      // not enough space in inbuf for additional text.
      // caller must flush input. this flag signals
      // that no end of line char should be searched.
      iClRawInputCached = iToCopy; // can be NULL!
      bClForceNextInput = 1;
      // printf("back: caller must flush %d (2)\n", iClRawInputCached);
      return 1;
   }
 
   // add next line part to line rejoin buffer
   memcpy(aClInBuf+iClInBufUsed, aClRawInBuf2, iToCopy);
   memcpy(aClInAtt+iClInBufUsed, aClRawInAttr2, iToCopy);
 
   // on add of first part also copy sender info
   if (!iClInBufUsed)
      memcpy(&clInBufInAddr, &clRawInAddr, sizeof(clRawInAddr));

   // no cache remains
   iClRawInputCached = 0;

   iClInBufUsed += iToCopy;
 
   aClInBuf[iClInBufUsed] = '\0';
   aClInAtt[iClInBufUsed] = '\0';

   // caller must consume new input lines as soon as
   // getNextInput() returns a complete line.
 
   // printf("join: \"%s\"\n", aClInBuf);
 
   return 0;
}

int UDPIO::sendDuplexReply(struct sockaddr_in *pAddr)
{
   if (fdClSocket == INVALID_SOCKET)
      return 9;

   char szReply[200];
 
   snprintf(szReply, sizeof(szReply)-10,
      ":sfktxt:v100,rep%d,rt%d,ok\n\n",
      iClInReqNum, iClInRetryNum
      );

   int iSendSize = strlen(szReply);

   if (sendto(fdClSocket, szReply, iSendSize, 0,
          (struct sockaddr *)pAddr, sizeof(struct sockaddr_in)) != iSendSize
      )
      return 10;

   aClClients[iClClient].copyreq = iClInReqNum;
   aClClients[iClClient].copytry = iClInRetryNum;

   return 0;
}

char *UDPIO::getNextCommand( )
{
   if (bClCmdClear) {
      bClCmdClear = 0;
      return (char*)"clear";
   }
   return 0;
}

char *UDPIO::getNextInput(char **ppAttr, struct sockaddr_in *pSenderAddr, bool bDontCache)
{
   if (iClInBufUsed <= 0)
      return 0;

   bool bAllowJoin = 1;
   if (bClRawText && bClAppendLFOnRaw)
        bAllowJoin = 0;

   // when receiving raw text, take input as is.
   // if input buffer overflows, also take as is.
   if (!bDontCache && !bClForceNextInput && bAllowJoin)
   {
      // wait for next CR or LF
      char cLast = aClInBuf[iClInBufUsed-1];
      if (cLast!='\r' && cLast!='\n')
         return 0;
   }
 
   bClForceNextInput = 0;

   iClInBufUsed = 0;

   if (ppAttr)
      *ppAttr = aClInAtt;

   if (pSenderAddr)
      memcpy(pSenderAddr, &clInBufInAddr, sizeof(struct sockaddr_in));

   // dumpdata("nxin", aClInBuf);

   return aClInBuf;
}

int UDPIO::getTextSendDelay( )
{
   if (bClDuplex)
      return 0;

   return iClNonDuplexSendDelay;
}
// emod net_udp
#endif // (sfk_prog || sfk_net_udp)

// dmod net_tcp
#if (sfk_prog || sfk_net_tcp)
void setWebConfig(int iWhat, char *pszValue)
{
   int iValue = atoi(pszValue);

   switch (iWhat)
   {
      case 1:
         if (iValue < 200)
            return;
         gs.maxwebwait = cs.maxwebwait = atoi(pszValue);
         mtklog(("setWebConfig: timeout=%d", gs.maxwebwait));
         break;
      case 2:
         if (iValue < 1)
            return;
         gs.maxwebsize = cs.maxwebsize = atoi(pszValue) * 1000000;
         mtklog(("setWebConfig: limit=%d", (int)(gs.maxwebsize/1000000)));
         break;
      case 3: {
         char szBuf[200];
         char *pproxy = pszValue;
         strcopy(szBuf, pproxy);
         char *psz1 = szBuf;
         while (*psz1 && *psz1 != ':') psz1++;
         if (*psz1) *psz1++ = '\0';
         int nport = atol(psz1);
         if (!nport) nport = 80;
         TCPCore::setProxy(szBuf, nport);
         mtklog(("setWebConfig: proxy %s port %u",szBuf,nport));
      }
   }
}

bool TCPCore::bSysInitDone = 0;

ConAutoClose::ConAutoClose(TCPCore *pcore, TCPCon **ppcon, int nTraceLine)
{
   nClTraceLine = nTraceLine;
   pClCore  =  pcore;
   ppClCon  = ppcon;
}

ConAutoClose::~ConAutoClose( ) {
   TCPCon *pcon = *ppClCon;
   if (pcon) {
      // closes con AND deletes the object
      pClCore->close(pcon);
      *ppClCon = 0;
   } else {
      perr("unexpected NULL ptr on ConAutoClose, line %d", nClTraceLine);
   }
}

ConCache::ConCache( ) {
}

ConCache::~ConCache( )
{
   // no uncontrolled cleanup on exit
   //    reset("cc");
}

void ConCache::closeConnections( )
{__
   // close all connections, but keep
   // the http/ftp clients available.
   void *praw=0;
   for (int i=0; i<size(); i++) {
      if ((praw = iget(i))) {
         TCPCore *pcore = (TCPCore *)praw;
         pcore->closeConnections();
      }
   }
}

// NOTE: so far to be called only at program end
//       as it can NOT close individual objects
//       while leaving others usable.
// NOTE: glblSFL (and others?) must be shutdown BEFORE this.
//       ~coi > ~coidata > releaseHttp > refcnt 0.
void ConCache::reset(bool bfinal, const char *pszFromInfo)
{__
   mtklog(("ConCache-Reset size=%d from %s", size(), pszFromInfo));

   if (bfinal == 0)
   {
      // not allowed as reset can only drop ALL objects
      perr("int. #216718\n");
      return;
   }

   int itry = 0;
   int isuc = 0;

   // does also closeConnections
   void *praw=0;
   for (int i=0; i<size(); i++)
   {
      if ((praw = iget(i)))
      {
         TCPCore *pcore = (TCPCore *)praw;

         if (pcore->refcnt() > 0)
         {
            if (bfinal) {
               perr("found used tcpcon on exit: %d %p\n", pcore->refcnt(), pcore);
            } else {
               mtklog(("ConCache-Reset skips used=%d %p", pcore->refcnt(), pcore));
            }
            continue;
         }

         itry++;
         if (!closeAndDelete(praw))
            isuc++;
      }
   }

   // remove all invalid entries from keymap:
   KeyMap::reset();
   clFifo.reset();

   mtklog(("ConCache-Reset closed %d (tried %d)", isuc, itry));
}

int ConCache::closeAndDelete(void *praw)
{__
   // identify type of praw:
   TCPCore *pcore = (TCPCore *)praw;

   char *pszID = pcore->getID();

   if (pcore->refcnt() > 1) // 1: managed only by us
   {
      perr("connection in use, cannot close: %s %p %d", pszID, pcore, pcore->refcnt());
      return 9;
   }

   #ifdef USE_WEBCONCACHE
   if (strBegins(pszID, "http://") || strBegins(pszID, "https://")) {
      mtklog(("close-and-delete %p %s", praw, pszID));
      HTTPClient *pcl = (HTTPClient*)praw;
      pcl->close();  // in case curcon is active
      pcl->closeConnections();
      delete pcl;
   }
   else
   #endif
   if (strBegins(pszID, "ftp://")) {
      mtklog(("close-and-delete %p %s", praw, pszID));
      FTPClient *pcl = (FTPClient*)praw;
      pcl->logout(); // in case we're still logged in
      pcl->closeConnections(); // if any remaining
      delete pcl;
   }
   else
      perr("wrong cache entry type: %s %p", pcore->getID(), pcore);

   // stored value pointer is now INVALID,
   // but we're cleanup up all below

   return 0;
}

#ifdef USE_WEBCONCACHE
HTTPClient *ConCache::allocHttpClient(char *pBaseURL)
{__
   if (   !strBegins(pBaseURL, "http://")
       && !strBegins(pBaseURL, "https://")
      )
      return 0;

   void *praw = get(pBaseURL);

   // use existing client?
   if (praw) {
      mtklog(("concache-reuse %s %p", pBaseURL, praw));
      HTTPClient *pres = (HTTPClient *)praw;
      pres->incref("aht");
      return pres;
   }

   mtklog(("ConCache-alloc %s", pBaseURL));

   // create new, on demand:
   forceCacheLimit();

   HTTPClient *pres = new HTTPClient(pBaseURL);
   if (put(pBaseURL, pres)) return 0;

   // also remember sequence of adding:
   clFifo.put(nAddCnt++, pBaseURL);

   // as it is managed by concache, ref is always >= 1
   pres->incref("aht");

   return pres;
}

int ConCache::releaseClient(HTTPClient *pcln)
{__
   mtklog(("concache-release %p http", pcln));
   pcln->decref("crh");
   return 0;
}
#endif

FTPClient *ConCache::allocFtpClient(char *pBaseURL)
{
   if (!strBegins(pBaseURL, "ftp://")) return 0;

   mtklog(("ConCache-alloc %s", pBaseURL));

   void *praw = get(pBaseURL);

   // use existing client?
   if (praw) {
      FTPClient *pres = (FTPClient *)praw;
      if (pres->refcnt() > 1) { // 1: managed only by us
         perr("too many locks on connection: %s (%d)", pBaseURL, pres->refcnt());
         return 0;
      }
      pres->incref("aft");
      return pres;
   }

   // create new, on demand:
   forceCacheLimit();

   FTPClient *pres = new FTPClient(pBaseURL);
   if (put(pBaseURL, pres)) return 0;
   mtklog(("concache-put %s done", pBaseURL));

   // also remember sequence of adding:
   clFifo.put(nAddCnt++, pBaseURL);

   // as it is managed by concache, ref is always >= 1
   pres->incref("aft");

   return pres;
}

int ConCache::releaseClient(FTPClient *pcln)
{__
   mtklog(("concache-release %p ftp", pcln));
   pcln->decref("crf");
   return 0;
}

int ConCache::forceCacheLimit()
{__
   if (size() < 10)
   {
      mtklog(("concache-drop not required, size=%d", size()));
      return 0;
   }

   // return 0;

   // max. of 10 connections is kept in cache,
   // so drop the oldest one to keep some space:
   num nAddKey = 0;
   char *pBaseURL = (char*)clFifo.iget(0, &nAddKey);
   if (!pBaseURL) return 9+perr("int. #267281138");
   mtklog(("concache-iget first %s", pBaseURL));

   // fifo only stores keys, get matching tcpcore:
   TCPCore *pcon = (TCPCore *)get(pBaseURL);
   if (!pcon)
   {
      #ifdef SFKINT
      pinf("cache-get failed: %s\n", pBaseURL);
      #endif
      clFifo.remove(nAddKey);
      return 9+perr("int. #267281139");
   }

   // for now, assume the oldest one is unlocked
   if (pcon->refcnt() > 1) // 1: managed only by us
   {
      perr("connection cache overflow, %d %d", size(), pcon->refcnt());
      return 9;
   }

   // can drop the oldest connection
   mtklog(("concache-drop oldest connection %p %s", pcon, pBaseURL));

   // delete connection
   closeAndDelete(pcon);

   // must remove manually
   if (remove(pBaseURL))
      perr("int. #267281208");

   mtklog(("concache-remove done %p remain %d", pcon, size()));

   // also remove from fifo, deletes pBaseURL.
   if (clFifo.remove(nAddKey))
      perr("cannot remove from concache: %llx\n", nAddKey);

   return 0;
}

int TCPCon::nClIOBufSize = 4096;

TCPCon::TCPCon(SOCKET hsock, TCPCore *pcorein, int nTraceIn)
{__
   mtklog(("  tcpcon ctr %p line %d",this,nTraceIn));
   memset(this, 0, sizeof(*this));
   pClCore = pcorein;
   clSock  = hsock;
   nClTraceLine = nTraceIn;
   nClStartTime = getCurrentTime();
   iClMaxWait   = pClCore->iClMaxWait;
   iClPort      = 0;
}

TCPCon::~TCPCon( )
{__
   mtklog(("  tcpcon dtr %p used %d msec",this,(int)(getCurrentTime() - nClStartTime)));

   if (clSock != INVALID_SOCKET) {
      // close was forgotten. as tcpcon's are managed by the core,
      // this is probably never reached:
      perr("missing close on tcpcon %p hsock %xh line %d", this, (uint)clSock, nClTraceLine);
      rawClose();
   }

   if (pClUserData) delete pClUserData;
   if (pClIOBuf   ) delete [] pClIOBuf;

   memset(this, 0, sizeof(*this));
   clSock = INVALID_SOCKET;
}

void TCPCon::rawClose()
{__
   if (clSock != INVALID_SOCKET) {
      mtklog(("con %p close socket %u",this,(uint)clSock));
      myclosesocket(clSock);
   }
   clSock = INVALID_SOCKET;
}

static void localSetBlocking(SOCKET hSock, bool bYesNo)
{
   #ifdef _WIN32
   unsigned long ulParm = bYesNo ? 0 : 1;
   ioctlsocket(hSock, FIONBIO, &ulParm);
   #else
   if (bYesNo)
      fcntl(hSock, F_SETFL, (fcntl(hSock,F_GETFL) & ~O_NONBLOCK));
   else
      fcntl(hSock, F_SETFL, (fcntl(hSock,F_GETFL) | O_NONBLOCK));
   #endif
}

void  TCPCon::setBlocking (bool bYesNo)
{
   // unsigned long ulParm = bYesNo ? 0 : 1;
   // ioctlsocket(clSock, FIONBIO, &ulParm);
   localSetBlocking(clSock, bYesNo); // 169
}

#ifdef WITH_SSL

/*
   older ssl include:
		const SSL_METHOD *SSLv3_method(void);		-- SSLv3
		const SSL_METHOD *SSLv3_server_method(void);	-- SSLv3
		const SSL_METHOD *SSLv3_client_method(void);	-- SSLv3
		
		const SSL_METHOD *SSLv23_method(void);	-- SSLv3 but can rollback to v2
		const SSL_METHOD *SSLv23_server_method(void);	-- SSLv3 but can rollback to v2
		const SSL_METHOD *SSLv23_client_method(void);	-- SSLv3 but can rollback to v2
		
		const SSL_METHOD *TLSv1_method(void);		-- TLSv1.0
		const SSL_METHOD *TLSv1_server_method(void);	-- TLSv1.0
		const SSL_METHOD *TLSv1_client_method(void);	-- TLSv1.0
		
		const SSL_METHOD *TLSv1_1_method(void);		-- TLSv1.1
		const SSL_METHOD *TLSv1_1_server_method(void);	-- TLSv1.1
		const SSL_METHOD *TLSv1_1_client_method(void);	-- TLSv1.1
		
		const SSL_METHOD *TLSv1_2_method(void);		-- TLSv1.2
		const SSL_METHOD *TLSv1_2_server_method(void);	-- TLSv1.2
		const SSL_METHOD *TLSv1_2_client_method(void);	-- TLSv1.2

   newer ssl include:
      #define SSLv23_method           TLS_method
      #define SSLv23_server_method    TLS_server_method
      #define SSLv23_client_method    TLS_client_method
*/

#ifdef SSLv23_client_method
   #define SFK_NEW_SSL
#else
   #define TLS_client_method TLSv1_2_client_method
   #define TLS_server_method TLSv1_2_server_method
#endif

void apps_ssl_info_callback(const SSL *s, int where, int ret)
{
    const char *str;
    int w;

    w = where & ~SSL_ST_MASK;

    if (w & SSL_ST_CONNECT)
        str = "SSL_connect";
    else if (w & SSL_ST_ACCEPT)
        str = "SSL_accept";
    else
        str = "undefined";

    if (where & SSL_CB_LOOP) {
        printf("SSL: %s:%s\n", str, SSL_state_string_long(s));
    } else if (where & SSL_CB_ALERT) {
        str = (where & SSL_CB_READ) ? "read" : "write";
        printf("SSL: SSL3 alert %s:%s:%s\n",
                   str,
                   SSL_alert_type_string_long(ret),
                   SSL_alert_desc_string_long(ret));
    } else if (where & SSL_CB_EXIT) {
        if (ret == 0)
            printf("SSL: %s:failed in %s\n",
                       str, SSL_state_string_long(s));
        else if (ret < 0)
            printf("SSL: %s:error in %s\n",
                       str, SSL_state_string_long(s));
    }
}

void my_SSL_trace(int write_p, int version, int content_type,
               const void *buf, size_t msglen, SSL *ssl, void *arg)
{
   uchar *msg = (uchar*)buf;

   char sz[100]; sz[0]='\0';

   switch (content_type)
   {
      #ifdef SFK_NEW_SSL
      case SSL3_RT_HEADER:
         strcpy(sz, "headr"); break;
      case SSL3_RT_INNER_CONTENT_TYPE:
         sprintf(sz, "ctype %d", msg[0]); break;
      #endif
      case SSL3_RT_HANDSHAKE:
         strcpy(sz, "hshak"); break;
      case SSL3_RT_CHANGE_CIPHER_SPEC:
         strcpy(sz, "ccspc"); break;
      case SSL3_RT_ALERT:
         strcpy(sz, "alert"); break;
   }

   printf("SSL: msg type=0x%03x len=%02d vers=0x%04x %s %s\n",
      content_type, (int)msglen, version, sz,
      dataAsHex(msg, (int)msglen));
}

int TCPCon::sslConnect(char *phostorip, int iTraceLevel)
{
   prepareSSL();

   // ssl.step.2 up-to-date client methods
   if (!(pClSSLContext = SSL_CTX_new(TLS_client_method())))
   {
      perr("SSLContext init failed\n");
      return 9;
   }

   if (!(pClSSLSocket = SSL_new(pClSSLContext)))
   {
      perr("SSLSocket creation failed\n");
      return 9;
   }

   if (iTraceLevel>0)
   {
      printf("[ssl trace level: %d]\n", iTraceLevel);
      if (iTraceLevel > 1)
         SSL_set_msg_callback(pClSSLSocket, my_SSL_trace);
      SSL_CTX_set_info_callback(pClSSLContext, apps_ssl_info_callback);
   }

   SSL_set_fd(pClSSLSocket, clSock);

   // ssl.step.3 set tls hostname
   if (!SSL_set_tlsext_host_name(pClSSLSocket, phostorip))
   {
      perr("Unable to set TLS servername extension.\n");
      return 9;
   }
   if (cs.debug) printf("SSL: set tls host: %s\n", phostorip);

   int iErrCode = SSL_connect(pClSSLSocket);

   if (iErrCode < 0)
   {
      int isuberr = SSL_get_error(pClSSLSocket, iErrCode);
      perr("SSLConnect failed rc=%d/%d\n",
         iErrCode, isuberr);
      return 9;
   }

   const char *pszSSLVersion = SSL_get_version(pClSSLSocket);
   if (!pszSSLVersion) pszSSLVersion = "unknown-ssl";

   if (cs.debug)
      printf("SSL: %s connect done to %s\n", pszSSLVersion, phostorip);

   return 0;
}
#endif // WITH_SSL

int TCPCon::read(uchar *pBlock, uint nLen, bool bReturnAny)
{
   // if a foreground thread detects the escape key:
   if (bGlblEscape)
      return 0; // NOT -1, size_t problem

   IOStatusPhase ophase("read tcp");

   num tstart  = getCurrentTime();

   int nTotal   = 0;
   int nRemain  = nLen;
   int nCursor  = 0;
   int nMaxWait = iClMaxWait;
   int nDelays  = 0;
   int nRead    = 0;
   while (nRemain > 0)
   {
      // avoid using doSleep by select
      struct timeval tv;
      fd_set fdvar;
      tv.tv_sec  = 0;
      tv.tv_usec = 20 * 1000; // 20 msec
      FD_ZERO(&fdvar);
      FD_SET(clSock, &fdvar);
      if (nMaxWait > 0 && select(clSock+1, &fdvar, 0, 0, &tv) <= 0)
      {
         if (getCurrentTime() - tstart > nMaxWait) {
            if (cs.verbose > 1)
               pinf("read timeout (%d ms).   \n", (int)(getCurrentTime() - tstart));
            nCursor=0;
            break;
         }
         continue;
      }

      #ifdef WITH_SSL
      if (pClSSLSocket)
      {
         nRead = SSL_read(pClSSLSocket, (char*)pBlock+nCursor, nRemain);
      }
      else
      #endif // WITH_SSL
      {
         nRead = recv(clSock, (char*)pBlock+nCursor, nRemain, 0);
      }

      // printf("%d = tcp.recv(%d,%d) err %d\n",nRead,clSock,nRemain,netErrno());

      if (nRead <= 0)
      {
         if (nRead == -1 && netErrno() == WSAEWOULDBLOCK)
         {
            if (getCurrentTime() - tstart > nMaxWait)
            {
               if (cs.verbose > 1)
                  pinf("read timeout (%d ms).   \n", (int)(getCurrentTime() - tstart));
               nCursor=0;
               break;
            }
            doSleep(20);
            nDelays++;
            continue;
         }
         break;
      }

      countIOBytes(nRead);

      nTotal  += nRead;
      nRemain -= nRead;
      nCursor += nRead;

      if (bReturnAny)
         break;
   }
   if (nDelays > 0) {
      mtklog(("read using %d delays",nDelays));
   }
   if (nCursor < 1) {
      mtklog(("tcp.read: no data (%d,%d)\n",nRead,netErrno()));
   }

   // sfk1972 tcp: tcpcon.read return -1 on connection close
   if (nCursor == 0 && nRead < 0)
      return nRead;

   return nCursor;
}

int TCPCon::send(uchar *pBlock, uint nLen)
{__
   int ires = 0;

   #ifdef WITH_SSL
   if (pClSSLSocket)
   {
      ires = SSL_write(pClSSLSocket, (char*)pBlock, nLen);
   }
   else
   #endif // WITH_SSL
   {
      ires = ::send(clSock, (char*)pBlock, nLen, 0);
   }

   return ires;
}

char *TCPCon::buffer(int &rbufsize)
{
   if (!pClIOBuf) {
      pClIOBuf = new char[nClIOBufSize+100];
      memset(pClIOBuf, 0, nClIOBufSize+100);
   }
   rbufsize = nClIOBufSize;
   return pClIOBuf;
}

char *TCPCon::readLine(char *poptbuf, uint noptmaxbuf, bool braw)
{__
   // use which buffer?
   char *pBuf    = poptbuf;
   int  nBufMax = noptmaxbuf;

   // alloc internal buffer on demand:
   if (!pBuf) pBuf = buffer(nBufMax);

   IOStatusPhase ophase("read tcp");

   int nCursor = 0;
   int nRemain = nBufMax;
   pBuf[0] = '\0';

   // switching from readLine mode to readBinary is tricky,
   // therefore read char by char to exactly get the point
   // of CRLF, from which on we may switch to binary.
   while (nRemain > 10)
   {
      int nRead = read((uchar*)pBuf+nCursor, 1);
      if (nRead <= 0) {
         mtklog(("< readline: EOD"));
         return 0;
      }
      countIOBytes(nRead);
      nCursor += nRead;
      nRemain -= nRead;
      pBuf[nCursor] = '\0';
      if (nCursor >= 1 && pBuf[nCursor-1]=='\n')
         break;
   }

   // always return lines without CRLF.
   if (!braw)
      removeCRLF(pBuf);
   if (core().verbose())
      printf("< %s\n", pBuf);
   else {
      // mtklog(("< %.200s", pBuf));
   }

   return pBuf;
}

int TCPCon::puts(char *pline)
{__
   int nBufMax = 0;
   char *pBuf = buffer(nBufMax);
   nBufMax -= 10; // tolerance

   int nlen = strlen(pline);
   if (nlen > nBufMax) {
      perr("string overflow on send: %.200s", pline);
      return 9;
   }

   strncpy(pBuf, pline, nBufMax);
   pBuf[nBufMax] = '\0';

   // if no CRLF is found at end of string, append it
   nlen = strlen(pBuf);
   if (nlen < 2 || strncmp(pBuf+nlen-2, "\r\n", 2))
      strcat(pBuf, "\r\n");

   IOStatusPhase ophase("send tcp");

   // finally, send it:
   int nsent = send((uchar*)pBuf, strlen(pBuf));
   if (nsent != (int)strlen(pBuf)) return 9;

   mtklog(("> %s", pBuf));

   return 0;
}

int  TCPCon::putf(cchar *pmask, ...)
{__
   int nBufMax = 0;
   char *pBuf = buffer(nBufMax);
   nBufMax -= 10; // tolerance

   va_list argList;
   va_start(argList, pmask);
   ::vsnprintf(pBuf, nBufMax, pmask, argList);
   pBuf[nBufMax] = '\0';

   // if no CRLF is found at end of string, append it
   int nlen = strlen(pBuf);
   if (nlen < 2 || strncmp(pBuf+nlen-2, "\r\n", 2))
      strcat(pBuf, "\r\n");

   IOStatusPhase ophase("send tcp");

   // finally, send it:
   int nsent = send((uchar*)pBuf, strlen(pBuf));
   if (nsent != (int)strlen(pBuf)) return 9;

   mtklog(("> %s", pBuf));

   return 0;
}

int  TCPCon::setProtocol(char *psz) {
   return 9;
}

int  TCPCon::readReply(int nMinRC, int nMaxRC) {
   return 9;
}

TCPCore &TCPCon::core( ) {
   return *pClCore;
}

bool TCPCore::verbose( ) {
   return bClVerbose;
}

void TCPCore::wipe()
{__
   // safe replacement for memset(this)
   // in case that virtualization is used.
   // does NOT free any memory objects!
   pClID       = 0;
   nClCon      = 0;
   nClMaxSock    = 0;
   mclear(aClCon);
   mclear(clReadSet);
   mclear(clSetCopy);
   mclear(clSetCopyW);
   mclear(clSetCopyE);
   bClVerbose  = 0;
   nClRefs     = 0;
}

TCPCore::TCPCore(char *pszID, char cProtocol)
{__
   mtklog(("tcpcore ctr %p",this));

   if (sizeof(*this) > 20000)
      perr("tcpcore stack sizing problem");

   // sfk wide tcp default: 10 seconds
   iClMaxWait = 10000;

   if (cProtocol == 'h')
      iClMaxWait  = cs.maxwebwait;

   if (cProtocol == 'f')
      iClMaxWait  = cs.maxftpwait;

   wipe();

   pClID = strdup(pszID);
}

TCPCore::~TCPCore( )
{__
   mtklog(("tcpcore dtr %p",this));
   if (nClCon > 0)
      perr("missing shutdown() on tcpcore %p",this);
   shutdown();
   delete [] pClID;
   wipe();
}
TCPCore *TCPCore::pClGeneric = 0;

TCPCore &TCPCore::any() {
   if (pClGeneric == 0) {
      if (!(pClGeneric = new TCPCore(str("any"), 'h')))
         perr("TCPCore allocation failure");
   }
   return *pClGeneric;
}

char *TCPCore::getID( ) {
   return pClID;
}

char TCPCore::szClProxyHost[100];
int TCPCore::nClProxyPort = -1;
bool TCPCore::bClProxySet  =  0;

// this may also be called BEFORE sysInit().
int TCPCore::setProxy(char *phost, int nport)
{__
   strcopy(szClProxyHost, phost);
   nClProxyPort = nport;
   bClProxySet = 1;
   return 0;
}

int TCPCore::incref(cchar *pTraceFrom)
{
   mtklog(("tcp-ref-inc %p %d from %s", this, nClRefs+1, pTraceFrom));
   return ++nClRefs;
}

int TCPCore::decref(cchar *pTraceFrom)
{
   mtklog(("tcp-ref-dec %p %d from %s", this, nClRefs-1, pTraceFrom));
   return --nClRefs;
}

int TCPCore::refcnt( )  { return nClRefs;   }

int TCPCore::lastError( )
{
   #ifdef _WIN32
   return WSAGetLastError();
   #else
   return errno;
   #endif
}

int TCPCore::sysInit( )
{__
   #ifdef _WIN32
   // sfk1840: must use central init
   if (prepareTCP())
      return 9;
   #endif

   // it is possible that the proxy was set
   // by a call before sysInit().
   if (!bClProxySet) {
      mclear(szClProxyHost);
      nClProxyPort = 0;
      char *pproxy = getenv("SFK_PROXY");
      if (pproxy) {
         char szBuf[200];
         static bool bFirst = 1;
         strcopy(szBuf, pproxy);
         char *psz1 = szBuf;
         while (*psz1 && *psz1 != ':') psz1++;
         if (*psz1) *psz1++ = '\0';
         int nport = atol(psz1);
         if (!nport) nport = 80;
         setProxy(szBuf, nport); // env var
         if (cs.verbose && bFirst) {
            bFirst = 0;
            printf("[using proxy %s port %d]\n", szBuf, nport);
         }
      }
   }

   bSysInitDone = 1;

   return 0;
}

void TCPCore::sysCleanup( )
{__
   #ifdef _WIN32
   // if (bSysInitDone)
   //    WSACleanup(); // sfk1840 only on process exit
   #endif
   bSysInitDone = 0;
}

void TCPCore::closeConnections( )
{__
   mtklog(("tcpcore closecon %p ncon=%d", this, nClCon));
   while (nClCon > 0) {
      TCPCon *pcon = aClCon[0];
      close(pcon);
   }
   memset(aClCon, 0, sizeof(aClCon));
}

void TCPCore::shutdown( )
{__
   mtklog(("tcpcore shutdown %p", this));
   for (int i=0; i<nClCon; i++) {
      TCPCon *pcon = aClCon[i];
      delete pcon;
   }
   nClCon = 0;
   memset(aClCon, 0, sizeof(aClCon));
}

// rc 5: port is in use
int TCPCore::makeServerSocket(int nportin, TCPCon **ppout, bool bquiet)
{__
   if (checksys()) return 9;

   if (nClCon >= FD_SETSIZE-2)
      return 9+perr("too many sockets, cannot create server socket\n");

   uint nPort = (uint)nportin;

   struct sockaddr_in ServerAdr;
   socklen_t nSockAdrSize = sizeof(sockaddr_in);

   ServerAdr.sin_family      = AF_INET;
   ServerAdr.sin_addr.s_addr = htonl(INADDR_ANY);
   ServerAdr.sin_port        = htons((unsigned short)nPort);

   SOCKET hServSock = socket(AF_INET, SOCK_STREAM, 0);
   if (hServSock == INVALID_SOCKET) {
      if (!bquiet) perr("cannot create socket on port %u", nPort);
      return 5;
   }

   if (bind(hServSock, (struct sockaddr *)&ServerAdr, sizeof(sockaddr_in)) == SOCKET_ERROR) {
      if (!bquiet) perr("cannot bind socket on port %u", nPort);
      return 5;
   }

   int nerr = getsockname(hServSock, (struct sockaddr *)&ServerAdr, &nSockAdrSize);
   if (nerr == SOCKET_ERROR) {
      if (!bquiet) perr("getsockname failed, %d\n", lastError());
      return 5;
   }

   // make later accepts non-blocking:
   localSetBlocking(hServSock, 0); // 169

   if (listen(hServSock, 4) == SOCKET_ERROR) {
      if (!bquiet) perr("cannot listen on port %u", nPort);
      return 5;
   }

   // finally, create and remember the TCPCon
   TCPCon *pcon = new TCPCon(hServSock, this, __LINE__);
   // unblock was done above
   pcon->iClPort = nPort;
   addCon(pcon);

   if (ppout)
      *ppout = pcon;

   return 0;
}

int TCPCore::addCon(TCPCon *pcon)
{__
   if (nClCon >= FD_SETSIZE-2)
      return 9+perr("internal: too many connections");

   // add to fdset
   FD_SET(pcon->clSock, &clReadSet);

   // and to pointer table
   aClCon[nClCon++] = pcon;

   // prepare overall select
   nClMaxSock = mymax(nClMaxSock, pcon->clSock);

   return 0;
}

int TCPCore::remCon(TCPCon *pcon)
{__
   // remove from fdset
   FD_CLR(pcon->clSock, &clReadSet);

   // search in pointer table
   int nAtPos=0;
   for (nAtPos=0; nAtPos<nClCon; nAtPos++)
      if (aClCon[nAtPos] == pcon)
         break;

   if (nAtPos >= nClCon)
      return 9+perr("internal: cannot remove connection %p",this);

   // remove from pointer table
   for (int i=nAtPos; i<nClCon-1; i++)
      aClCon[i] = aClCon[i+1];
   aClCon[nClCon-1] = 0; // just in case

   nClCon--;

   return 0;
}

int TCPCore::accept(TCPCon *pServerCon, TCPCon **ppout)
{__
   if (checksys()) return 9;

   if (nClCon >= FD_SETSIZE-2)
      return 9+perr("too many sockets, cannot accept more");

   IOStatusPhase ophase("tcp accept");

   struct sockaddr_in ClientAdr;
   socklen_t nSoLen = sizeof(sockaddr_in);
   SOCKET hClient = ::accept(pServerCon->clSock, (struct sockaddr *)&ClientAdr, &nSoLen);
   if (hClient == INVALID_SOCKET)
      return 9; // perr("accept failed (%d)", lastError());

   TCPCon *pcon = new TCPCon(hClient, this, __LINE__);
   pcon->setBlocking(0);
   memcpy(&pcon->clFromAddr, &ClientAdr, sizeof(pcon->clFromAddr));
   addCon(pcon);

   *ppout = pcon;

   return 0;
}

int TCPCore::checksys( ) {
   if (bSysInitDone) return 0;
   return 9+perr("internal: missing tcp sysinit");
}

void setBlocking(SOCKET hSock, bool bYesNo)
{
   #ifdef _WIN32
   unsigned long ulParm = bYesNo ? 0 : 1;
   ioctlsocket(hSock, FIONBIO, &ulParm);
   #else
   if (bYesNo)
      fcntl(hSock, F_SETFL, (fcntl(hSock,F_GETFL) & ~O_NONBLOCK));
   else
      fcntl(hSock, F_SETFL, (fcntl(hSock,F_GETFL) | O_NONBLOCK));
   #endif
}

bool hasData(SOCKET &hSock, int lTimeoutMS, bool bOnConnect)
{
   struct timeval tv;
   tv.tv_sec  = 0;
   tv.tv_usec = lTimeoutMS * 1000;

   fd_set fds1, fds2, fds3;

   FD_ZERO(&fds1); // read
   FD_ZERO(&fds2); // write
   FD_ZERO(&fds3); // except

   FD_SET(hSock, &fds1);

   if (bOnConnect)
   {
      FD_SET(hSock, &fds2);
      FD_SET(hSock, &fds3);
   }

   return select(hSock+1, &fds1, &fds2, &fds3, &tv) > 0;
}

int myconnect(SOCKET hSock, struct sockaddr *paddr, int naddr, int iMaxWait,
   char *pszVerboseHostInfo, int iPortInfo)
{
   if (iMaxWait == 0)
   {
      mtklog(("myconnect: blocking connect"));
      int isubrc = connect(hSock, paddr, naddr);
      if (isubrc !=0 && pszVerboseHostInfo != 0)
         perr("cannot connect to %s:%u (%s)\n", pszVerboseHostInfo, iPortInfo, netErrStr());
      return isubrc;
   }

   setBlocking(hSock, 0);

   int isubrc = connect(hSock, paddr, naddr);

   num nstart = getCurrentTime();
 
   while (1)
   {
      if (getCurrentTime() - nstart > iMaxWait)
      {
         if (pszVerboseHostInfo)
            perr("cannot connect to %s:%u, timeout (%d ms)\n",
               pszVerboseHostInfo, iPortInfo, iMaxWait);
         return -1;
      }

      if (hasData(hSock, iMaxWait, 1))
      {
         mtklog(("myconnect: hasdata"));
         break;
      }

      doSleep(50);
   }

   setBlocking(hSock, 1);

   return 0;
}

int TCPCore::connect(char *pszHost, int nportin, TCPCon **ppout, bool bSSL)
{__
   mtklog(("tcp.connect: %s %d timeout=%d",pszHost,nportin,iClMaxWait));

   if (checksys())
      return 9;

   if (nClCon >= FD_SETSIZE-2)
      return 9+perr("too many sockets, cannot connect more");

   IOStatusPhase ophase("connect tcp");

   SOCKET hSock = socket(AF_INET, SOCK_STREAM, 0);
   if (hSock == INVALID_SOCKET)
      return 9+perr("cannot create socket (4)");

   mtklog(("tcp.connect: new socket %u",hSock));

   struct sockaddr_in oaddr;
   oaddr.sin_family = AF_INET;
   oaddr.sin_port = htons((unsigned short)nportin);
   if (setaddr(&oaddr,pszHost)) {
      mtklog(("setaddr failed: %s",pszHost));
      return 9;
   }

   int isubrc = myconnect(hSock, (struct sockaddr *)&oaddr, sizeof(oaddr), iClMaxWait, pszHost, nportin);

   mtklog(("tcp.connect: %d = connect(%u) %d",isubrc,hSock,netErrno()));

   if (isubrc == -1)
      return 9;

   TCPCon *pcon = new TCPCon(hSock, this, __LINE__);

   if (iClMaxWait > 0 && nportin != 443)
   {
      mtklog(("tcp.connect: set socket %u non blocking with maxwait=%d", hSock, iClMaxWait));
      pcon->setBlocking(0);
   }
   else
   {
      mtklog(("tcp.connect: use socket %u in blocking mode", hSock));
   }

   addCon(pcon);
   *ppout = pcon;

   #ifdef WITH_SSL
   if (bSSL) {
      if (pcon->sslConnect(pszHost,bSSL-1)) {
         close(pcon);
         *ppout = 0;
         return 9+perr("ssl connect failed");
      }
   }
   #endif // WITH_SSL

   return 0;
}

int TCPCore::close(TCPCon *pcon)
{__
   #ifdef WITH_SSL
   if (pcon->pClSSLSocket)
   {
      SSL_free(pcon->pClSSLSocket);
      pcon->pClSSLSocket = 0;
   }

   if (pcon->pClSSLContext)
   {
      SSL_CTX_free(pcon->pClSSLContext);
      pcon->pClSSLContext = 0;
   }
   #endif // WITH_SSL

   remCon(pcon);
   mtklog(("tcpcore %p close socket %u",this,(uint)pcon->clSock));
   myclosesocket(pcon->clSock);
   pcon->clSock = INVALID_SOCKET;
   delete pcon;
   return 0;
}

int  TCPCore::selectInput(TCPCon **ppNextActiveCon, TCPCon *pToQuery, int iMaxWaitMSec)
{__
   // printf("tcp-core select on %d connections\n",nClCon);

   if (nClCon < 1)
      return 1;

   IOStatusPhase ophase("tcp select");

   struct timeval tv;
   tv.tv_sec  = iMaxWaitMSec/1000;
   tv.tv_usec = (iMaxWaitMSec < 1000) ? iMaxWaitMSec * 1000 : 0;

   // fd_set is modified on select, therefore:
   memcpy(&clSetCopy , &clReadSet, sizeof(fd_set));
   int nrc = select(nClMaxSock+1,
      &clSetCopy,
      NULL,
      NULL,
      (iMaxWaitMSec > 0) ? &tv : NULL
      );
   if (nrc <= 0) {
      if (iMaxWaitMSec > 0)
         return 1; // timeout
      return 9+perr("select() failed, %d",lastError());
   }
   // identify connection with input
   mtklog(("tcp-core select rc %d",nrc));
   for (int i=0; i<nClCon; i++)
   {
      TCPCon *pcon = aClCon[i];
      if (FD_ISSET(pcon->clSock, &clSetCopy)) {
         if (pToQuery && (pcon != pToQuery)) {
            mtklog(("tcp-core: con is set: %p - not the query, skipping", pcon));
            continue;
         }
         mtklog(("tcp-core: con is set: %p - returning", pcon));
         *ppNextActiveCon = pcon;
         return 0;
      }
      mtklog(("tcp-core: con not set: %p", pcon));
   }
   return 1; // nothing to do
}

int  TCPCore::registerData(TCPCon *pcon, TCPConData *pUserData) {
   return 9;
}

void  TCPCore::setVerbose  (bool bYesNo) {
   bClVerbose = bYesNo;
}

// - - - http client - - -

HTTPClient::HTTPClient(char *pszID)
 : TCPCore(pszID, 'h')
{__
   wipe();
}

HTTPClient::~HTTPClient( )
{__
   if (pClCache) {
      // if (nClCacheUsed)
      //    pwarn("http: %d unused bytes remaining in cache, %p\n",nClCacheUsed,this);
      delete [] pClCache;
   }
   if (pszClLineCache) {
      delete [] pszClLineCache;
   }
   if (pClCurCon)
      perr("http: unclosed connection, %p", this);
   wipe();
}

void HTTPClient::resetCache()
{__
   nClCacheUsed = 0;
}

void HTTPClient::wipe( )
{__
   pClCurCon  = 0;

   mclear(aClURLBuf);
   pClCurPath = 0;

   mclear(aClHeadBuf);
   pClCurVal  = 0;

   mclear(aClJoinBuf);

   mclear(aClIOBuf);

   nClPort    = 80;
   iClWebRC   =  0;

   bClChunked   = 0;
   pClCache     = 0;
   nClCacheAlloc= 0;
   nClCacheUsed = 0;

   bClFirstReq  = 1;
   bClNoHead    = 0;
   bClNoCon     = 0;

   pszClLineCache = 0;

   bClSSL = 0;

   #ifdef WITH_SSL
   pClSSLContext = 0;
   pClSSLSocket = 0;
   #endif // WITH_SSL
}

char *HTTPClient::curname( ) {
   return aClHeadBuf;
}

char *HTTPClient::curval( ) {
   return pClCurVal ? pClCurVal : (char*)"";
}

bool isAbsoluteURL(char *psz) {
   if (strBegins(psz, "http://")) return 1;
   if (strBegins(psz, "https://")) return 1;
   return 0;
}

// "http://thehost.com/dir1/" + "../rel.txt"
// -> "http://thehost.com/rel.txt"
int HTTPClient::joinURL(char *pabs, char *pref)
{__
   // 1) "image.png"
   // 1) "subdir/the.txt"
   // 2) "/topdir/the.txt"
   // 3) "../../reldir/"
   // 4) "http://other.com/..."
   strcopy(aClJoinBuf, pabs);
   char *pmax = aClJoinBuf + sizeof(aClJoinBuf) - 10;

   // find last valid slash in current dir
   char *psla = strrchr(aClJoinBuf, '/');
   if (!psla) return 9; // shouldn't happen

   // drop junk
   if (!strncmp(pref, "./", 2))
      pref += 2;

   // if not about to step up
   if (strncmp(pref, "../", 3))
      psla++; // past slash

   // 4) external ref?
   if (   strBegins(pref, "http://")
       || strBegins(pref, "https://")
      )
   {
      return 9;
   }
   else
   // 2) "/topdir/the.txt" ?
   if (*pref == '/') {
      // step src
      while (*pref == '/')
         pref++;
      // set dst to host root
      psla  = aClJoinBuf;
      if (!strncmp(psla, "http://", 7))
         psla += 7;
      else
      if (!strncmp(psla, "https://", 8))
         psla += 8;
      else
         return 9;
      while (*psla && *psla != '/') psla++;
      if (!*psla) return 9;
      psla++; // behind http://thehost.com/
   }
   else
   // step slashes up as long as "../"
   while (!strncmp(pref, "../", 3)) {
      // step src
      pref += 3;
      // step dst
      while (psla > aClJoinBuf && *(psla-1) != '/')
         psla--;
   }

   // now join psla and pref
   *psla = '\0';
   int nreflen = strlen(pref);
   if (psla + nreflen > pmax)
      return 9+perr("url overflow: %.100s",pref);
   memcpy(psla, pref, nreflen);
   psla[nreflen] = '\0';

   mtklog(("join: %s + %s -> %s",pabs,pref,aClJoinBuf));

   if (fGlblWebDump) {
      fprintf(fGlblWebDump, "join.1: %s\n", pabs);
      fprintf(fGlblWebDump, "join.2: %s\n", pref);
      fprintf(fGlblWebDump, "join  > %s\n", aClJoinBuf);
   }

   return 0;
}

char *HTTPClient::curjoin( ) {
   return aClJoinBuf;
}

int HTTPClient::splitURL(char *purl)
{__
   // isolate hostname from url
   aClURLBuf[0] = '\0';

   char *psz1 = purl;

   bClSSL  = 0;
   nClPort = 80;

   if (!strncmp(purl, "https://", 8)) {
      #ifdef WITH_SSL
      psz1 = purl + 8;
      bClSSL = 1;
      nClPort = 443;
      #endif // WITH_SSL
      #ifndef WITH_SSL
      perr("SFK Base does not support SSL encryption (HTTPS).");
      static bool bfirst=1;
      if (bfirst) {
         bfirst=0;
         #ifdef _WIN32
         pinf("You may buy SFK Plus for HTTPS web access.\n");
         pinf("Find more infos on www.stahlworks.com\n");
         #else
         pinf("if you need https support, install curl, then:\n");
         pinf("curl -k -o outfile.dat https://website/in.dat\n");
         #endif
      }
      return 9;
      #endif
   }
   else
   if (!strncmp(purl, "http://", 7)) {
      psz1 = purl + 7;
   }
   else {
      perr("http: wrong url format: %s",purl);
      return 9;
   }

   // copy from thehost.com
   strcopy(aClURLBuf, psz1);
   char *pdst = aClURLBuf;

   // then null the first "/" or ":" or "?"
   char *psla = pdst;
   while (*psla && (*psla != '/' && *psla != ':' && *psla != '?')) psla++;
   if (*psla == ':') {
      // isolate embedded port number
      *psla++ = '\0';
      char *pport = psla;
      while (*psla && (*psla != '/' && *psla != '?')) psla++;
      if (*psla) *psla++ = '\0';
      nClPort = atoi(pport);
   } else {
      // no embedded port number
      if (*psla) *psla++ = '\0';
   }

   // anything after "/" is the relative path
   pClCurPath = psla;

   mtklog(("host=\"%s\" port=%d path=\"%s\"\n",aClURLBuf,nClPort,psla));

   return 0;
}

char *HTTPClient::curhost( ) {
   return aClURLBuf;
}

char *HTTPClient::curpath( ) {
   return pClCurPath ? pClCurPath : (char*)"";
}

int HTTPClient::splitHeader(char *phead)
{__
   // isolate hostname from url
   aClHeadBuf[0] = '\0';
   pClCurVal = 0;

   // content-type: text/html
   strcopy(aClHeadBuf, phead);

   char *psz1 = aClHeadBuf;
   while (*psz1 && *psz1 != ':') psz1++;
   if (!*psz1) return 9; // wrong header format

   *psz1++ = '\0';
   while (*psz1 && *psz1 == ' ') psz1++;
   pClCurVal = psz1;

   // make header name all lowercase
   for (psz1 = aClHeadBuf; *psz1; psz1++)
      *psz1 = tolower(*psz1);

   return 0;
}

char *HTTPClient::readLine(bool braw)
{
   if (!haveConnection())
      { perr("int. #175291 missing connection"); return 0; }

   #ifdef WITH_SSL

   if (bClSSL && pClSSLSocket)
   {
      SOCKET osock = pClCurCon->clSock;

      char *pBuf   = aClIOBuf;
      int  nBufMax = sizeof(aClIOBuf)-10;
 
      int nCursor = 0;
      int nRemain = nBufMax;
      pBuf[0] = '\0';
 
      int iTimeout = 5000;
 
      num tStart = getCurrentTime();
 
      while (nRemain > 10)
      {
         if (bGlblEscape)
         {
            printf("!HttpClient: Canceling http connect due to stop request (2)\n");
            return 0;
         }

         #if 1
         struct timeval tv;
         fd_set fdvar;
         tv.tv_sec  = 0;
         tv.tv_usec = 20 * 1000; // 200 msec
         FD_ZERO(&fdvar);
         FD_SET(osock, &fdvar);
         if (select(osock+1, &fdvar, 0, 0, &tv) <= 0) {
            if (getCurrentTime() - tStart > iTimeout) {
               printf("!HttpClient: timeout while reading web reply (%s)\n", curhost());
               return 0;
            }
            continue;
         }
         mtklog(("before read on sock %d",osock));
         mtklog(("SSL %p has fd %d",pClSSLSocket,SSL_get_fd(pClSSLSocket)));
         #else
         if (getCurrentTime() > tStart + iTimeout)
         {
            printf("!HttpClient: timeout while reading web reply (%s)\n", curhost());
            return 0;
         }
         #endif
 
         int nRead = SSL_read(pClSSLSocket, pBuf+nCursor, 1);

         if (nRead == 0) // no input yet available
            { doSleep(50); continue; }
 
         if (nRead < 0) { // end of stream, or error
            int ierr = SSL_get_error(pClSSLSocket, nRead);
            mtklog(("ssl.readline error: %d %d %d at %d",nRead,ierr,errno,nCursor));
            return 0;
         }

         nCursor += nRead;
         nRemain -= nRead;
         pBuf[nCursor] = '\0';
         if (nCursor >= 2 && !strncmp(pBuf+nCursor-2, "\r\n", 2))
            break;
         if (nCursor >= 1 && !strncmp(pBuf+nCursor-1, "\n", 1))
            break;
      }
 
      if (!braw)
      {
         char *pcr = strchr(pBuf, '\r'); if (pcr) *pcr = '\0';
               pcr = strchr(pBuf, '\n'); if (pcr) *pcr = '\0';
      }
 
      return pBuf;
   }

   #endif // WITH_SSL

   return pClCurCon->readLine(0, 0, braw);
}

// returns RC
int HTTPClient::sendLine(char *pline)
{
   if (!pClCurCon)
      { perr("int. #175292 missing connection"); return 9; }

   int ires = 0;

   #ifdef WITH_SSL
   if (bClSSL)
   {
      ires = SSL_write(pClSSLSocket, pline, strlen(pline));
   }
   else
   #endif // WITH_SSL
   {
      ires = pClCurCon->puts(pline);
   }

   return ires;
}

int HTTPClient::list(char *purl, CoiTable **pptable)
{
   return 9;
}

int HTTPClient::getFileHead(char *purl, Coi *pcoi, cchar *pinfo)
{__
   mtklog(("getFileHead %s %s", purl, pinfo));

   if (bClNoCon) {
      mtklog(("http-getfilehead: nocon set, blocked: %s", purl));
      return 9; // error issued before
   }

   if (splitURL(purl))
      return 9; // error was told

   char *phost = curhost();
   char *pfile = curpath();

   int nport = nClPort;
   if (connectHttp(phost, nport, &pClCurCon)) {
      bClNoCon = 1;
      return 9+perr("http connect failed: %s:%d",phost,nport);
   }

   ConAutoClose ocls(this, &pClCurCon, __LINE__);

   // header field container
   StringMap *pheads = &pcoi->headers(); // gets filled below
   if (!pheads) return 9+perr("out of memory, cannot read head");

   int nbail = 0;
   bool bfirstre = 1;

   do
   {
      // send request to return headers.
      // TODO: on first request, check suspicious HEAD replies
      //       like "image/gif" from a root directory.
      int nrc = 0;
      bool bHeadDone = 0;
      if (bClNoHead)
         nrc = sendReq("GET",pfile,phost,nport);
      else {
         nrc = sendReq("HEAD",pfile,phost,nport);
         bHeadDone = 1;
      }
      if (nrc) return nrc;
 
      // read headers on reply stream.
      int nwebrc = 0;
      pheads->reset();
      if (rawReadHeaders(nwebrc, purl, pcoi))
         return 9;
      // this also (re)sets the chunked mode

      // suspicious reply from root directory?
      char *pcont = pheads->get(str("content-type"));
      mtklog(("fr %d hd %d len %d cont %p %s",
         bClFirstReq, bHeadDone, strlen(pfile),
         pcont, pcont ? pcont : "<null>"));
      if (   bClFirstReq && bHeadDone
          && !strlen(pfile)
          && pcont && !strstr(pcont, "text")
         )
      {
         // no text data from root dir: disable HEAD requests
         bClNoHead = 1;
         // then repeat the request
         close();
         if (connectHttp(phost, nport, &pClCurCon))
            return 9+perr("http reconnect failed: %s:%d",phost,nport);
         continue;
      }
 
      if (nwebrc == 200)
         bClFirstReq = 0;

      // http redirect?
      if (nwebrc < 300 || nwebrc >= 400)
         break; // hopefully got the target
 
      // "HTTP/1.1 3xx" redirection
      if (bfirstre) {
         bfirstre = 0;
         pinf("redirect from %s\n", purl);
      }

      // "Location: main.html"
      char *ptarg = pheads->get(str("location"));
      if (!ptarg) return 9+perr("rc %d but no Location on %s", nwebrc, curpath());
      mtklog(("redir to %s", ptarg));

      // CHANGE FILENAME OF COI according to redirection:
      char *pabsnew = 0;

      if (strBegins(ptarg, "http:")) {
         // absolute url supplied: use directly
         pabsnew = ptarg; // will be copied
      }
      else
      if (strBegins(ptarg, "https:")) {
         pabsnew = ptarg; // will be copied
      } else {
         // relative url supplied: join with old url
         if (joinURL(purl, ptarg))
            return 9+perr("redirect failed: %s / %s",purl,ptarg);
         pabsnew = curjoin();
      }

      // now holding "http://thehost.com/newfile.txt"
      pcoi->setName(pabsnew); // is copied
      purl = pcoi->name();   // take copy
      pinf("redirect to   %s\n", purl);

      // evaluate new url for archive extensions
      if (endsWithArcExt(purl, 7)) {
         mtklog(("hth: archive detected by redirect: %s", purl));
         pcoi->setArc(1);
      }

      // block dup reads
      glblCircleMap.put(purl, 0); // if already set, does nothing

      // have to split this again
      if (splitURL(purl))
         return 9; // error was told
 
      // take redirected target
      phost = curhost();
      pfile = curpath();

      // repeat the request with the new target.
      // TODO: close and re-open connection in case of GET
      if (!bHeadDone) {
         close();
         if (connectHttp(phost, nport, &pClCurCon))
           return 9+perr("http reconnect failed: %s:%d",phost,nport);
      }
   }
   while (nbail++ < 5); // until no longer redirected, or bail out

   // connection is auto closed
   return 0;
}

char *nextNonBlank(char *psz) {
   while (*psz && *psz != ' ') psz++;
   while (*psz && *psz == ' ') psz++;
   return *psz ? psz : 0;
}

bool HTTPClient::haveConnection( )
{
   if (pClCurCon)
      return 1;

   return 0;
}

int HTTPClient::rawReadHeaders
 (
   int  &rwebrc,
   char    *purl, // for info
   Coi     *pcoi
 )
{__
   if (!haveConnection())
      { perr("int. #175293 missing connection"); return 9; }

   if (!pcoi) return 9+perr("int. #2167251");

   StringMap *pheads = &pcoi->headers();
   if (!pheads) return 9+perr("out of memory, cannot read headers");

   char *pline  = 0;
   bool  bfirst = 1;
   bool  btext  = 0;

   iClWebRC = 0;

   // always reset chunked flag until we know better
   bClChunked = 0;

   mtklog(("http: begin reading of headers"));

   if (fGlblWebDump)
      fprintf(fGlblWebDump, "-----head.begin-----\n");

   // Note: first line uses RAW reading, keeping CRLF ending
   while ((pline = readLine(bfirst)))
   {
      if (!strlen(pline))
         break; // end of header

      mtklog(("< %s (from %s)", pline, purl));

      if (fGlblWebDump) {
         if (bfirst)
            fprintf(fGlblWebDump, "%s", pline);
         else
            fprintf(fGlblWebDump, "%s\n", pline);
      }

      if (bfirst)
      {
         bfirst = 0;

         // header-free server?
         char *pprobe = pline;
         while (*pprobe==' ' || *pprobe=='\t') pprobe++;
         if (*pprobe == '<')
         {
            mtklog(("http: headless reply"));
            // cache first line of content WITH EOL
            if (pszClLineCache) delete [] pszClLineCache;
            pszClLineCache = new char[strlen(pline)+10];
            memcpy(pszClLineCache, pline, strlen(pline)+1);
            // assume this is text/html
            pcoi->setTypeFromContentType(str("text/html"));
            return 0; // "done headers"
         }

         // normal server: strip CRLF
         removeCRLF(pline);

         if (cs.showhdr & 4) {
            // chain.print('h', 1, "> %s", pline);
            printx("<head>> %s\n", pline);
         }

         // HTTP/1.1 200 OK
         char *psz1 = pline;
         while (*psz1 && *psz1 != ' ') psz1++;
         while (*psz1 && *psz1 == ' ') psz1++;
         iClWebRC = atol(psz1);
         rwebrc = iClWebRC;

         #ifdef USE_404
         // recoverable rc?
         if (iClWebRC == 404) {
            // continue to load the error page,
            // but remember rc for additional info.
            pheads->put("webrc", "404");
            continue;
         }
         #endif // USE_404

         // fatal error?
         if (iClWebRC >= 400) {
            perr("%.40s: %s",pline,purl);
            return 9;
         }

         continue;
      }
      else
      {
         // non first: crlf was stripped
         if (cs.showhdr & 4) {
            // chain.print('h', 1, "> %s", pline);
            printx("<head>> %s\n", pline);
         }
      }

      if (splitHeader(pline)) {
         perr("wrong http header on object: %s", purl);
         pinf("header line is: %s\n",pline);
         return 9;
      }

      mtklog(("   head \"%s\" val \"%s\"",curname(),curval()));

      // if map is supplied, store some headers there
      if (pheads) {
         if (   !strcmp(curname(), "location")
             || !strcmp(curname(), "content-type")
            )
            pheads->put(curname(), curval());
      }

      // interpret some headers directly
      // Transfer-Encoding: chunked
      if (   !mystricmp(curname(), "transfer-encoding")
          && !mystricmp(curval(), "chunked")) {
         bClChunked = 1;
         mtklog(("chunked read of reply"));
      }

      // if no coi is given, ignore header contents
      if (!pcoi)
         continue;

      // .gz  application/x-gzip
      // .zip application/x-zip-compressed
      // .bz2 application/x-bzip2
      // .tar application/x-tar
      // .tgz application/x-compressed
      // however, some servers say only "application/octet-stream"
      // for all archive files. in this case, the redirect file name
      // must be evaluated.

      // content-type: text/html, application/zip etc.
      if (!mystricmp(curname(), "content-type"))
      {
         pheads->put(str("content-type"), curval());
         pcoi->setTypeFromContentType(curval());
         continue;
      }

      // content-length: 20000
      if (!mystricmp(curname(), "content-length")) {
         pheads->put(str("content-length"), curval());
         pcoi->setSize(atonum(curval()));
         // for live stat display, if any
         void setIOStatMaxBytes(num n);
         setIOStatMaxBytes(atonum(curval()));
         continue;
      }

      // "Date" or
      // "Last-Modified" val "Tue, 01 Jan 2008 01:01:25 GMT"
      if (   !mystricmp(curname(), "date")
          || !mystricmp(curname(), "last-modified")
         )
      {
         pheads->put(str("last-modified"), curval());
         char *pstr = nextNonBlank(curval()); // skip "Tue, "
         num ntime  = 0;
         // force format "01 Jan 2008 01:01:25 GMT"
         //               012345678901234567890123
         int nlen  = strlen(pstr);
         if (nlen < 20) continue;
         if (pstr[14] != ':' || pstr[17] != ':') continue;
         if (!timeFromString(pstr, ntime, cs.verbose?0:1)) { // http.header
            // mtklog(("coi.mtime: set %u from http header",(uint)ntime));
            pcoi->setTime(ntime); // http header
            if (fGlblWebDump)
               fprintf(fGlblWebDump, "set time: %s %p\n", numtoa(pcoi->nClMTime), pcoi);
         }
         continue;
      }

      // sfk1990: always provide all header fields, not just selected
      if (strlen(curname()) > 0)
         pheads->put(curname(), curval());

      #ifndef DVIEW
      // servers that strictly want no console web access may set
      if (!mystricmp(curname(), "console-browse")) {
         if (!mystricmp(curval(), "disable"))
            return 9+pwarn("console web access is disabled by server.\n");
      }
      #endif
   }

   if (bfirst)
   {
      mtklog(("no headers, no data received"));
      if (fGlblWebDump)
         fprintf(fGlblWebDump, "-----head.end----- (no reply)\n");
      #ifdef WITH_SSL
      if (bClSSL && pClSSLSocket && cs.recurl)
         return 9;
      #endif // WITH_SSL
      return 9+perr("no data: %s", purl);
   }

   if (fGlblWebDump)
      fprintf(fGlblWebDump, "-----head.end-----\n");

   // connection is auto closed.
   return 0;
}

int HTTPClient::connectHttp(char *phostorip, int nport, TCPCon **ppout)
{__
   mtklog(("connect: %s port=%d ssl=%d", phostorip, nport, bClSSL));

   if (nClProxyPort < 0)
      return 9+perr("internal, wrong http initial state\n");

   int isubrc = 0;

   if (szClProxyHost[0])
      isubrc = connect(szClProxyHost, nClProxyPort, ppout);
   else
      isubrc = connect(phostorip, nport, ppout);

   if (isubrc) {
      mtklog(("connect rc %d",isubrc));
      return isubrc;
   }

   #ifdef WITH_SSL
   if (bClSSL && pClCurCon)
   {
      prepareSSL();

      // ssl.step.2 up-to-date client methods
      if (!(pClSSLContext = SSL_CTX_new(TLS_client_method())))
      {
         perr("SSLContext init failed\n");
         close();
         return 9;
      }

      if (!(pClSSLSocket = SSL_new(pClSSLContext)))
      {
         perr("SSLSocket creation failed\n");
         close();
         return 9;
      }
 
      SSL_set_fd(pClSSLSocket, pClCurCon->clSock);

      // ssl.step.3 set tls hostname
      if (!SSL_set_tlsext_host_name(pClSSLSocket, phostorip))
      {
         perr("Unable to set TLS servername extension.\n");
         return 9;
      }
      if (cs.debug) printf("SSL: set tls host: %s\n", phostorip);

      int iErrCode = SSL_connect(pClSSLSocket);

      if (iErrCode < 0)
      {
         int isuberr = SSL_get_error(pClSSLSocket, iErrCode);

         perr("SSLConnect failed rc=%d/%d fd=%d port=%d\n",
            iErrCode, isuberr,
            pClCurCon->clSock, nport
            );
         #ifdef WITH_VERBOSE_SSL // may cause link errors
         if (cs.verbose >= 2) // sfk198
            ERR_print_errors_fp(stdout);
         #endif

         close();
         return 9;
      }

      const char *pszSSLVersion = SSL_get_version(pClSSLSocket);
      if (!pszSSLVersion) pszSSLVersion = "unknown-ssl";

      if (cs.debug)
         printf("SSL: %s connect done to %s:%d\n", pszSSLVersion, phostorip, nport);
   }
   #endif // WITH_SSL

   return 0;
}

int HTTPClient::open(char *purl, cchar *pmode, Coi *pcoi)
{__
   if (splitURL(purl))
      return 9; // error was told

   if (bClNoCon) {
      mtklog(("http::open: nocon set, blocked: %s", purl));
      return 9; // error issued before
   }


   char *phost = curhost();
   char *pfile = curpath();

   if (fGlblWebDump) {
      fprintf(fGlblWebDump, "-----open.url:-----\n");
      fprintf(fGlblWebDump, "%s\n",purl);
      fprintf(fGlblWebDump, "host=%s port=%d\n",phost,nClPort);
      fflush(fGlblWebDump);
   }

   if (connectHttp(phost, nClPort, &pClCurCon)) {
      close();
      bClNoCon = 1;
      if (cs.verbose)
         perr("http connect failed: %s:%d",phost,nClPort);
      return 9;
   }

   // header field container
   StringMap *pheads = &pcoi->headers();
   if (!pheads) {
      close();
      return 9+perr("out of memory, cannot read meta data");
   }

   int nbail = 0;
   bool bfirstre = 1;

   do
   {
      // send request to return headers.
      int nrc = sendReq("GET",pfile,phost,nClPort);
      if (nrc) {
         close();
         return 9;
      }

      // read headers on reply stream.
      int nwebrc = 0;
      pheads->reset();
      if (rawReadHeaders(nwebrc, purl, pcoi))
      {
         close();
         return 10;
      }
      // this also (re)sets the chunked mode

      // http redirect?
      if (nwebrc < 300 || nwebrc >= 400)
         break; // hopefully got the target

      // "HTTP/1.1 3xx" redirection
      if (bfirstre) {
         bfirstre = 0;
         pinf("redirect from %s\n", purl);
      }

      // "Location: main.html"
      char *ptarg = pheads->get(str("location"));
      if (!ptarg) {
         close();
         return 9+perr("rc %d but no Location on %s", nwebrc, curpath());
      }
      mtklog(("redir to %s", ptarg));

      // CHANGE FILENAME OF COI according to redirection:
      char *pabsnew = 0;

      if (strBegins(ptarg, "http:")) {
         // absolute url supplied: use directly
         pabsnew = ptarg; // will be copied
      }
      else
      if (strBegins(ptarg, "https:")) {
         pabsnew = ptarg; // will be copied
      } else {
         // relative url supplied: join with old url
         if (joinURL(purl, ptarg)) {
            close();
            return 9+perr("redirect failed: %s / %s",purl,ptarg);
         }
         pabsnew = curjoin();
      }

      // now holding "http://thehost.com/newfile.txt"
      pcoi->setName(pabsnew); // is copied
      purl = pcoi->name();   // take copy
      pinf("redirect to   %s\n", purl);

      // evaluate new url for archive extensions
      if (endsWithArcExt(purl, 8)) {
         mtklog(("hto: archive detected by redirect: %s", purl));
         pcoi->setArc(1);
      }

      // block dup reads
      glblCircleMap.put(purl, 0); // if already set, does nothing

      // close now as splitURL inits stuff
      close();

      // fix: 1770: reset coi stats on redirect
      pheads->reset();
      pcoi->nClHave = 0;
      pcoi->nClSize = 0;

      // have to split this again
      if (splitURL(purl))
         return 9; // error was told

      // take redirected target
      phost = curhost();
      pfile = curpath();

      // repeat the request with the new target.
      if (connectHttp(phost, nClPort, &pClCurCon)) {
         return 9+perr("http reconnect failed: %s:%d",phost,nClPort);
      }
   }
   while (nbail++ < 5); // until no longer redirected, or bail out

   // connection is auto closed
   return 0;
}

int HTTPClient::postraw(char *purl, char *pszRawReq)
{__
   if (splitURL(purl))
      return 9; // error was told

   char *phost = curhost();
   char *pfile = curpath();

   if (connectHttp(phost, nClPort, &pClCurCon)) {
      close();
      if (cs.verbose)
         perr("http connect failed: %s:%d",phost,nClPort);
      return 9;
   }

   char *pReqBuf = pszRawReq;
   int   nReqLen = strlen(pszRawReq);

   size_t nsent = 0;

   #ifdef WITH_SSL
   if (bClSSL)
   {
      nsent = SSL_write(pClSSLSocket, pReqBuf, nReqLen);
   }
   else
   #endif // WITH_SSL
   {
      nsent = pClCurCon->send((uchar*)pReqBuf, nReqLen);
   }

   return 0;
}

// returns no. of bytes or 0
int HTTPClient::readraw(uchar *pbuf, int nbufsize)
{__
   if (!pClCurCon)
      { perr("int. #175294 missing connection"); return 0; }

   int ires = 0;

   #ifdef WITH_SSL
   if (bClSSL)
   {
      ires = SSL_read(pClSSLSocket, pbuf, nbufsize);
      mtklog(("%d = ssl_read maxbuf %d",ires,nbufsize));
   }
   else
   #endif // WITH_SSL
   {
      ires = pClCurCon->read(pbuf, nbufsize);
      mtklog(("%d = readraw maxbuf %d",ires,nbufsize));
   }

   return ires;
}

int HTTPClient::readrawfull(uchar *pBlock, uint nLen)
{
   // if a foreground thread detects the escape key:
   if (bGlblEscape)
      return 0; // NOT -1, size_t problem

   if (!pClCurCon)
      { perr("int. #175294 missing connection"); return 0; }

   SOCKET osock = pClCurCon->clSock;

   IOStatusPhase ophase("read tcp");

   num tstart  = getCurrentTime();

   int nTotal   = 0;
   int nRemain  = nLen;
   int nCursor  = 0;
   int nMaxWait = iClMaxWait;
   while (nRemain > 0)
   {
      struct timeval tv;
      fd_set fdvar;
      tv.tv_sec  = 0;
      tv.tv_usec = 20 * 1000; // 20 msec
      FD_ZERO(&fdvar);
      FD_SET(osock, &fdvar);
      if (nMaxWait > 0 && select(osock+1, &fdvar, 0, 0, &tv) <= 0)
      {
         if (getCurrentTime() - tstart > nMaxWait) {
            pinf("read timeout (%d ms).   \n", (int)(getCurrentTime() - tstart));
            nCursor=0;
            break;
         }
         continue;
      }

      int nRead = readraw(pBlock+nCursor, nRemain);

      if (nRead <= 0)
         break;

      countIOBytes(nRead);

      nTotal  += nRead;
      nRemain -= nRead;
      nCursor += nRead;
   }

   return nCursor;
}

// TODO: reorg error rc handling
int HTTPClient::read(uchar *pbuf, int nbufmax)
{__
   mtklog(("http::read max=%d chunked=%d incache=%d lcache=%p", nbufmax, bClChunked, nClCacheUsed, pszClLineCache));

   if (!pClCurCon)
      { perr("int. #175295 missing connection"); return 0; }

   int iprefix = 0;

   // pinf("read upto %d with lcache=%p   \r",nbufmax,pszClLineCache);

   if (pszClLineCache)
   {
      int nlen = strlen(pszClLineCache);
      int nrem = 0;
      if (nlen > nbufmax) {
         // huge line data was cached
         nrem=nlen-nbufmax;
         nlen=nbufmax;
         mtklog(("http::read use cacheline part len=%d remain=%d",nlen,nrem));
         memcpy(pbuf, pszClLineCache, nlen);
         if (nrem) {
            memmove(pszClLineCache, pszClLineCache+nlen, nrem+1); // WITH term
         } else {
            delete [] pszClLineCache;
            pszClLineCache = 0;
         }
         mtklog((" return linecache %d", nlen));
         return nlen;
      } else {
         // 1770: first line of content was cached, use as data start
         memcpy(pbuf, pszClLineCache, nlen);

         delete [] pszClLineCache;
         pszClLineCache = 0;

         pbuf += nlen;
         nbufmax -= nlen;
         mtklog(("http::read use cacheline prefix len=%d remain=%d",nlen,nbufmax));
         if (nbufmax <= 0)
            return nlen;
         // fall through and fill up
         iprefix = nlen;
      }
   }

   // FROM HERE, MIND PREFIX LEN FOR RC!

   if (!bClChunked)
   {
      int irawlen = readraw(pbuf, nbufmax);

      if (irawlen >= 0)
          irawlen += iprefix;

      return irawlen;
   }

   if (nClCacheUsed <= 0)
   {
      // cache is empty, read next chunk:
 
      // 1. read control line with size of next chunk
      char *pline = readLine(); // 1770, i/o raw readline

      // mtklog(("http next chunk control line \"%.30s\"", pline ? pline : "<null>"));

      if (!pline)
         return 0+perr("http read error, no chunk header");

      int nchunksize = strtol(pline, 0, 0x10);

      // mtklog(("http next chunk %d bytes \"%s\"", nchunksize, pline));

      if (!nchunksize)
         return 0; // EOD flagged by "0" chunk size
 
      // 2. force IOCache to provide enough space
      //    for the whole chunk. note that there may
      //    still be bytes left over from last read.
      int nCacheRemain = nClCacheAlloc - nClCacheUsed;
      if (nchunksize > nCacheRemain)
      {
         // expand cache
         int nMissing  = nchunksize - nCacheRemain;
         int nAllocNew = nClCacheAlloc + nMissing + 100;
         uchar *pnew = new uchar[nAllocNew+10];
         memcpy(pnew, pClCache, nClCacheUsed);
         // swap new and old
         delete [] pClCache;
         pClCache = pnew;
         nClCacheAlloc = nAllocNew;
         mtklog(("http cache resized to %d", nClCacheAlloc));
         // nClCacheUsed stays unchanged
         nCacheRemain = nClCacheAlloc - nClCacheUsed;
         if (nchunksize > nCacheRemain)
            return 0+perr("int. 167281949");
      }
 
      // 3. read exactly the chunk, adding it to cache
      uchar *pdst = pClCache + nClCacheUsed;
      int nread  = readrawfull(pdst, nchunksize); // 1770
      mtklog(("http read chunk with %d bytes", nread));
      if (nread < nchunksize)
         return 0+perr("http: incomplete chunk read, %d %d",nread,nchunksize);

      // every chunk is followed by CRLF
      readLine(); // 1770

      // fall through to copy from cache
      nClCacheUsed += nread;
   }

   // independent from chunk sizes,
   // return nbufmax OR LESS bytes.
   if (nClCacheUsed <= 0)
      return 0+perr("int. 167281950");

   int ntocopy = nbufmax;
   if (nClCacheUsed < ntocopy)
        ntocopy = nClCacheUsed;

   memcpy(pbuf, pClCache, ntocopy);

   // shrink cache contents
   uchar *psrc = pClCache + ntocopy;
   int   nrem = nClCacheUsed - ntocopy;
   memmove(pClCache, psrc, nrem);
   nClCacheUsed -= ntocopy;

   mtklog(("http cache remain %d alloc %d", nClCacheUsed, nClCacheAlloc));

   return iprefix+ntocopy;
}

void HTTPClient::close( )
{__
   mtklog(("http::close: pcon=%p cacheAlloc=%d cacheUsed=%d", pClCurCon, nClCacheAlloc, nClCacheUsed));

   if (pClCurCon)
   {
      TCPCore::close(pClCurCon);
      pClCurCon = 0;
   }

   #ifdef WITH_SSL
   if (pClSSLSocket)
   {
      SSL_free(pClSSLSocket);
      pClSSLSocket = 0;
   }

   if (pClSSLContext)
   {
      SSL_CTX_free(pClSSLContext);
      pClSSLContext = 0;
   }
   #endif // WITH_SSL

   bClSSL = false;

   nClCacheUsed = 0;
}

// - - - ftp client - - -

FTPClient::FTPClient(char *pszID)
 : TCPCore(pszID, 'f')
{__
   mtklog(("ftpclient ctr %p", this));
   wipe();
}

FTPClient::~FTPClient( )
{__
   mtklog(("ftpclient dtr %p", this));
   if (pClCtlCon)
      perr("ftp: unclosed control connection, %p",this);
   if (pClPassive) delete [] pClPassive;
   if (pszClHost ) delete [] pszClHost;
   if (file.name ) delete [] file.name;
   if (file.md5  ) delete file.md5;
   wipe();
}

char  *FTPClient::line( )    { return szClLineBuf; }
int   FTPClient::lineMax( ) { return sizeof(szClLineBuf)-100; }

void FTPClient::wipe( )
{__
   pClCtlCon   =  0;
   pClPassive  =  0;
   mclear(aClURLBuf);
   mclear(szClLineBuf);
   pClCurPath  =  0;
   bClLoggedIn =  0;
   pszClHost   =  0;
   nClPort     = 21;
   bClSFT      =  0;
   nClSFTVer   =  0;
   mclear(file);
}

char *FTPClient::curhost( ) {
   return aClURLBuf;
}

char *FTPClient::curpath( ) {
   return pClCurPath ? pClCurPath : (char*)"";
}

int FTPClient::curport( ) { return nClPort; }

int FTPClient::splitURL(char *purl)
{__
   // isolate hostname from url
   aClURLBuf[0] = '\0';

   // ftp://thehost.com/thedir/thefile.txt
   if (strncmp(purl, "ftp://", 6)) {
      perr("ftp: wrong url format: %s", purl);
      return 9;
   }

   char *psz1 = purl + 6;

   // copy from thehost.com
   strcopy(aClURLBuf, psz1);
   char *pdst = aClURLBuf;

   // then null the first "/" or ":" or "?"
   char *psla = pdst;
   while (*psla && (*psla != '/' && *psla != ':' && *psla != '?')) psla++;
   if (*psla == ':') {
      // isolate embedded port number
      *psla++ = '\0';
      char *pport = psla;
      while (*psla && (*psla != '/' && *psla != '?')) psla++;
      if (*psla) *psla++ = '\0';
      nClPort = atoi(pport);
   } else {
      // no embedded port number
      if (*psla) *psla++ = '\0';
   }

   // printf("host \"%s\" port %d path \"%s\"\n",aClURLBuf,nClPort,psla);

   // anything after "/" is the relative path
   pClCurPath = psla;

   return 0;
}

char *FTPClient::readLine( ) {
   return pClCtlCon->readLine();
}

int FTPClient::sendLine(char *pline) {
   return pClCtlCon->puts(pline);
}

// guarantees to set pline, even if empty
int FTPClient::readReply(char **ppline)
{__
   char *pline = str("");
   int ncode = 0;
   while ((pline = readLine())) {
      // e.g. "230-some text" or "230 login done"?
      int nlen = strlen(pline);
      ncode = atol(pline);
      if (nlen < 4) break;
      if (pline[3] != '-') break;
      // else continue reading the reply
      mtklog(("[reply %d continued]",ncode));
   }
   *ppline = pline ? pline : (char*)"";
   return pline ? ncode : 0;
}

int FTPClient::login(char *phostorip, int nport)
{__
   mtklog(("ftp-login %s", phostorip));

   if (pszClHost)  { delete [] pszClHost; pszClHost = 0; }

   if (connect(phostorip, nport, &pClCtlCon))
      return 9+perr("ftp login failed: %s:%d",phostorip,nport);

   char *pline = 0;
   int  ncode = 0;
_
   // expect "220 " or "220-"
   if (!(ncode = readReply(&pline)))
      return 9+perr("ftp: wrong server hello: %s", pline);
_
   // detect sfk ftp server with SFT
   char *psz1 = strstr(pline, ". sft ");
   if (psz1) {
      int nSFTVer = atol(psz1+6);
      if (nSFTVer >= 100) {
         bClSFT = 1;
         if (cs.verbose)
            printf("> server speaks sft %d. mget, mput enabled.\n", nSFTVer);
         nClSFTVer = nSFTVer;
      } else {
         printf("> unexpected sft info \"%s\"\n", psz1);
      }
   }
_
   if (sendLine(str("USER anonymous"))) return 9;
   if (!readLine()) return 9; // 331
   if (sendLine(str("PASS sft102@"))) return 9;
_
   // expect "230 login done"
   if (!(ncode = readReply(&pline)))
      return 9+perr("ftp: wrong login reply: %s", pline);
_
   if (sendLine(str("TYPE I"))) return 9;
   if (!readLine()) return 9; // 200 OK
_
   bClLoggedIn = 1;
   pszClHost   = strdup(phostorip);

   mtklog(("ftp-login done %s", phostorip));

   return 0;
}

int FTPClient::loginOnDemand(char *phostorip, int nport)
{__
   // TODO: check maybe by dummy command if line is still valid
   if (bClLoggedIn) {
      mtklog(("ftp-login-reuse: %s", phostorip));
      return 0;
      // logout();
   }
   return login(phostorip, nport);
}

void FTPClient::logout( )
{__
   if (bClLoggedIn) {
      mtklog(("ftp-logout: %s", pszClHost ? pszClHost:""));
      if (pClCtlCon) close(pClCtlCon);
      pClCtlCon = 0;
      bClLoggedIn = 0;
   }
}

int FTPClient::setPassive(TCPCon **ppout)
{__
   if (pClPassive) { delete [] pClPassive; pClPassive=0; }

   if (!pClPassive) {
      // first call to setPassive:
      if (sendLine(str("PASV"))) return 10;
      char *pTmp = 0;
      if (!(pTmp = readLine())) return 11;
      pClPassive = strdup(pTmp);
   }

   // (re)use reply string to PASV
   char *pBuf = pClPassive;

   // 227 Entering Passive Mode (127,0,0,1,117,246)
   char *psz = strchr(pBuf, '(');
   if (!psz) return 12+perr("set passive failed: \"%s\"",pBuf);
   psz++;
   uchar n[6];
   for (int i=0; i<6; i++) {
      n[i] = (uchar)atol(psz);
      psz = strchr(psz+1, ',');
      if (psz) psz++; else break;
   }
   char szIP[50];
   sprintf(szIP, "%d.%d.%d.%d",n[0],n[1],n[2],n[3]);
   uint nPort = (((uint)n[4])<<8)|((uint)n[5]);

   // if (connectSocket(szIP, nPort, SoAdr, hData, "pasv data")) return 9;
   SOCKET hSock = socket(AF_INET, SOCK_STREAM, 0);
   if (hSock == INVALID_SOCKET)
      return 9+perr("set passive failed: cannot create socket (5)");

   struct sockaddr_in ClntAdr;
   ClntAdr.sin_family = AF_INET;
   ClntAdr.sin_port = htons((unsigned short)nPort);
   if (setaddr(&ClntAdr,szIP,1))
      return 9+perr("set passive failed: cannot get host %s", szIP);

   IOStatusPhase ophase("connect ftp");

   if ((::connect(hSock, (struct sockaddr *)&ClntAdr, sizeof(struct sockaddr_in))) == -1)
      return 9+perr("set passive failed: cannot establish connection to %s", szIP);

   if (verbose())
      printf("< connected to %s:%u\n", szIP, nPort);

   // turn this into a tcpcore managed connection
   TCPCon *pcon = new TCPCon(hSock, this, __LINE__);
   // TODO: pcon->setBlocking(0) required?
   addCon(pcon);
   *ppout = pcon;

   return 0;
}

// list remote files of a directory
int FTPClient::list(char *pdir, CoiTable **ppout, char *pRootURL)
{__
   if (!pdir) return 9;

   if (!*pdir)    pdir = str(".");
   if (!pRootURL) pRootURL = str(""); // safety

   #ifdef DEEP_FTP
   // printf("ftp list begin: dir=%s root=%s\n",pdir,pRootURL);
   #endif

   int nrc = 0;

   TCPCon *pdat = 0;

   if (bClSFT) {
      // if (nClSFTVer >= 105) may use SLSB
      if (pClCtlCon->putf("SLST %s\r\n", pdir)) return 9;
      pdat = pClCtlCon;
   } else {
      // create a "passive" data connection
      if ((nrc = setPassive(&pdat)))
         return 9+perr("set passive failed, %d", nrc);
      pdat->setBlocking(0);
 
      // still send commands on control connection
      if (pClCtlCon->putf("LIST %s\r\n", pdir)) return 9;
   }

   char *pres = readLine(); // expect "150 Listing"
   if (!pres)
      return 9+perr("ftp list failed: %s", pdir);
   if (!strBegins(pres, "150 "))
      return 9+perr("ftp error: %s", pres);
 
   CoiTable  *ptab = *ppout;
   if (!ptab) ptab = new CoiTable();

   bool bGotDone = 0;

   // not at all a refname, just a buffer:
   char szTmpBuf1[300]; mclear(szTmpBuf1);
   char szTmpBuf2[500]; mclear(szTmpBuf2);

   // receive list of filenames on data connection
   while (1)
   {
      char *pline = 0;

      if (bClSFT) {
         if (!(pline = readLine()))
            return 9+perr("ftp list error: %s", pdir);
         if (!strncmp(pline, "226 ", 4)) {
            bGotDone = 1;
            break; // ok all done
         }
      } else {
         // any further lines on the data connection?
         TCPCon *prec = 0;
         int nrc = selectInput(&prec, pdat);
 
         if (nrc > 0) {
            // no: check control connection
            nrc = selectInput(&prec, pClCtlCon);
            if (nrc >= 5)
               return 9+perr("ftp list failed: %d", nrc);
            if (nrc == 1) // no status available
               { doSleep(500); continue; }
            if (!(pline = readLine()))
               return 9+perr("ftp list error: %s", pdir);
            mtklog(("from ctl: %s",pline));
            if (!strncmp(pline, "226 ", 4)) {
               bGotDone = 1;
               break; // ok all done
               // TODO: can really stop here w/o further data read?
            }
            pinf("%s", pline);
            continue;
         }
 
         // no: fall through to data read
         mtklog(("read from dcon %p", pdat));
         if (!(pline = pdat->readLine())) {
            mtklog(("eod from dcon"));
            break;
         }
      }

      // === extract meta data from pline ===

      // -rw-rw-rw-t 1 ftp ftp        30353 Sep 08 13:47   readme.txt
      //    0        1  2   3          4    5   6   7      8
      // drw-rw-rw-d 1 ftp ftp            0 20061231235959 mydir
      // -rw-rw-rw-b 1 ftp ftp        30353 20061231235959 test.dat
      //    0        1  2   3          4    5              6

      // since SFT 105, t/b are no longer provided.

      char *apcol[20];
      memset(apcol, 0, sizeof(apcol));

      char *pszFileRaw = pline;

      // parse raw line, copy from ftpClient()
      int ncol = 0;
      strcopy(szTmpBuf1, pszFileRaw);
      char *psz1 = szTmpBuf1;
      while (ncol < 15) {
         // store column start
         apcol[ncol++] = psz1;
         // find end of column
         skipToWhite(&psz1);
         if (!*psz1) break;
         *psz1++ = '\0';
         // find start of next column
         skipWhite(&psz1);
         if (!*psz1) break;
      }

      bool bIsDir = 0;
      bool bHaveBinInfo = 0;
      bool bIsBinary    = 0;
      char *pattr = apcol[0];
      if (pattr) {
         // 12345678901
         // drw-rw-rw-d
         // -rw-rw-rw-b : binary
         // -rw-rw-rw-t : text
         int nlen = strlen(pattr);
         if (pattr[0] == 'd') bIsDir = 1;
         if (nlen >= 11 && pattr[10] == 'b')
            { bHaveBinInfo=1; bIsBinary=1; }
         if (nlen >= 11 && pattr[10] == 't')
            { bHaveBinInfo=1; bIsBinary=0; }
      }

      char *pszMonTS = apcol[5]; // month or timestamp
      bool bHaveFlatTime = 0;
      if (pszMonTS && isdigit(*pszMonTS))
           bHaveFlatTime = 1;

      int iName = 8;
      if (bHaveFlatTime) {
         if (ncol < 7)
            {  pwarn("wrong format: %s - skipping\n", pszFileRaw); continue; }
         iName = 6;
      }
      else
      if (ncol < 9)
         {  pwarn("wrong format: %s - skipping\n", pszFileRaw); continue; }

      // always take filename from original buffer,
      // blanks may have been replaced by zeros in RefNameBuf.
      char *pszFile = pszFileRaw + (apcol[iName]-szTmpBuf1);
      char *pszSize = apcol[4];

      num nFileTime = 0;

      {
         if (bHaveFlatTime) {
            timeFromString(pszMonTS, nFileTime); // local ftp.list
         } else {
            if (apcol[5] && apcol[6] && apcol[7]) {
               sprintf(szTmpBuf2, "%s %s %s",apcol[5],apcol[6],apcol[7]);
               timeFromString(szTmpBuf2, nFileTime); // local ftp.list
            }
         }
      }

      num nFileSize = atonum(pszSize);
      if (!bIsDir && (nFileSize <= 0))
      {
         printf("] skip, size=%s: %s\n", pszSize, pszFile);
         continue;
      }

      // === end meta data extraction ===

      // prefix every entry by its source url
      cchar *pInsPath = "";
      cchar *pszTrail = "";

      int nlen = strlen(pRootURL);
      if (nlen > 0 && pRootURL[nlen-1] != '/')
            pInsPath = "/";
      int nRootUseLen = strlen(pRootURL);

      #ifdef DEEP_FTP
      // does the root contain pdir redundantly?
      int nSubDirLen = strlen(pdir);
      if (    nSubDirLen < nRootUseLen
          && !strcmp(pRootURL+nRootUseLen-nSubDirLen, pdir)
         )
      {
         // printf("root contains pdir\n");
         nRootUseLen -= nSubDirLen;
         if (nRootUseLen > 0 && pRootURL[nRootUseLen-1] != '/')
            pInsPath = "/";
         else
            pInsPath = "";
      } else {
         // printf("root does not contain dir \"%s\" \"%s\" \"%s\" %d %d\n",pRootURL+nRootUseLen-nSubDirLen,pdir,pRootURL,nRootUseLen,nSubDirLen);
      }
      if (bIsDir) pszTrail = "/"; // TODO: check if there's a slash already
      #endif

      snprintf(szTmpBuf2, sizeof(szTmpBuf2), "%.*s%s%s%s", nRootUseLen,pRootURL,pInsPath,pszFile,pszTrail);

      // force whole url to net slashes
      void setNetSlashes(char *pdst);
      setNetSlashes(szTmpBuf2);

      Coi ocoi(szTmpBuf2, pRootURL);

      SFKFindData myfdat;
      memset(&myfdat, 0, sizeof(myfdat));
      myfdat.size = nFileSize;
      myfdat.time_write = nFileTime;
      if (bIsDir) {
         // printf("copy dir : %s\n",ocoi.name());
         myfdat.attrib |= 0x10;
      } else {
         // printf("copy file: %s\n",ocoi.name());
      }

      ocoi.fillFrom(&myfdat);

      if (bHaveBinInfo) {
         ocoi.setBinaryFile(bIsBinary);
         mtklog(("ftp list: %s : %s",bIsBinary?"isbin":"istxt",ocoi.name()));
      }

      #ifdef DEEP_FTP
      // printf("ftp list: add entry: %s  (dir=%d)\n", ocoi.name(), bIsDir);
      #endif

      ptab->addEntry(ocoi);
   }

   if (pdat != pClCtlCon) {
      // ftp: close separate data connection
      close(pdat);
   }

   // expect 226 Closing
   if (!bGotDone)
      if (!readLine())
         return 9;

   // result is owned by caller
   *ppout = ptab;

   mtklog(("ftp list end: %s return %d entries",pdir,ptab->numberOfEntries()));

   return 0;
}

int FTPClient::readLine(TCPCon *pcon)
{__
   char *pszLineBuf = line();
   int  nMaxLineBuf = lineMax();

   if (!pcon->readLine(pszLineBuf, nMaxLineBuf))
      return 9;

   // sft101: optional skip records to enforce socket flushing
   if (strBegins(pszLineBuf, "SKIP "))
   {
      // read intermediate skip record
      uint nLen = (uint)atol(pszLineBuf+5);
      if ((int)nLen > nMaxLineBuf) return 9;
      if (nLen) {
         if (pcon->read((uchar*)pszLineBuf, nLen) < 0)
            return 9;
      }

      // now read the actual record
      if (!pcon->readLine(pszLineBuf, nMaxLineBuf))
         return 9;
   }

   mtklog(("ftp: < %s", pszLineBuf));

   return 0;
}

int FTPClient::readLong(TCPCon *pcon, uint &rOut, cchar *pszInfo)
{__
   uchar szBuf[100];
   if (pcon->read(szBuf, 4) != 4) return 9+perr("failed to read %s\n", pszInfo);
   uint nLen =   (((uint)szBuf[3])<<24)
                | (((uint)szBuf[2])<<16)
                | (((uint)szBuf[1])<< 8)
                | (((uint)szBuf[0])<< 0);
   rOut = nLen;
   return 0;
}

int FTPClient::sendLong(TCPCon *pcon, uint nOut, cchar *pszInfo)
{__
   uchar szBuf[100];
   szBuf[3] = ((uchar)(nOut >> 24));
   szBuf[2] = ((uchar)(nOut >> 16));
   szBuf[1] = ((uchar)(nOut >>  8));
   szBuf[0] = ((uchar)(nOut >>  0));
   int nSent = pcon->send(szBuf, 4);
   if (nSent != 4) return 9+perr("failed to send %s\n", pszInfo);
   return 0;
}

int FTPClient::readNum(TCPCon *pcon, num &rOut, cchar *pszInfo)
{__
   uchar szBuf[100];
   if (pcon->read(szBuf, 8) != 8) return 9;
   num nOut = 0;
   for (int i=0; i<8; i++) {
      nOut <<= 8;
      nOut |= (uint)szBuf[i];
   }
   rOut = nOut;
   return 0;
}

int FTPClient::readNum(uchar *pbuf, int &roff, num &rOut, cchar *pszInfo)
{__
   num nOut = 0;
   for (int i=0; i<8; i++) {
      nOut <<= 8;
      nOut |= (uint)pbuf[roff+i];
   }
   roff += 8;
   rOut = nOut;
   return 0;
}

int FTPClient::sendNum(TCPCon *pcon, num nOut, cchar *pszInfo)
{__
   uchar szBuf[100];
   // this may fail with num's >= 2 up 63.
   for (int i=7; i>=0; i--) {
      szBuf[i] = (uchar)(nOut & 0xFF);
      nOut >>= 8;
   }
   int nSent = pcon->send(szBuf, 8);
   if (nSent != 8) return 9+perr("failed to send %s\n", pszInfo);
   return 0;
}

extern int nGlblTCPMaxSizeMB;
extern char *localPath(char *pAbsFile);
extern int fastMode();

bool bGlblBulkFTPIO = 0;

void setBulkFTPIO(bool bYesNo) { bGlblBulkFTPIO = bYesNo; }

// open remote file for download
// RC:  9 == general error
//     10 == fatal communication error, connection invalid
int FTPClient::openFile(char *pfilename, cchar *pmode)
{__
   mtklog(("ftp: openFile: %s %s",pfilename,pmode));

   if (strcmp(pmode, "rb"))
      return 9+perr("cannot open ftp file, only read supported: %s", pfilename);

   TCPCon *pcon = pClCtlCon;

   #ifdef USE_SFT
   if (bClSFT)
   {
      // so far used only by dview:
      bool bbulk = bGlblBulkFTPIO;

      // request block mode transfer
      if (bbulk) {
         if (pcon->putf("SGET %s", pfilename)) return 10;
      } else {
         if (pcon->putf("SOPEN %s", pfilename)) return 10;
      }
      if (readLine(pcon)) return 10; // 200 OK
      if (!strBegins(line(), "200")) return 9;

      // read SFT file header meta infos
      uchar abHead[512+10];
 
      uint nMetaSize = 0;
      if (readLong(pcon, nMetaSize, "metalen")) return 9;
      if (nMetaSize > sizeof(abHead)-10)
         return 9+perr("unsupported SFT protocol version\n");
      if (pcon->read(abHead, nMetaSize) != (int)nMetaSize) return 9;
 
      // take from header what we need
      int ioff = 0;
 
      // meta 1: 8 bytes filesize
      num nLen = 0, nTime = 0, nFlags = 0;
      char szLocalTime[20]; mclear(szLocalTime);
      if (readNum(abHead, ioff, nLen, "size")) return 9;
 
      if (nGlblTCPMaxSizeMB)
         if (nLen > nGlblTCPMaxSizeMB * 1000000)
            return 9+perr("illegal length received, %s\n", numtoa(nLen));
 
      if (nClSFTVer >= 102) {
         if (readNum(abHead, ioff, nTime , "time" )) return 9;
         if (readNum(abHead, ioff, nFlags, "flags")) return 9;
      }

      if (nClSFTVer < 102) {
         // meta 2: md5 before content
         memcpy(file.abmd5, abHead+ioff, 16);
         ioff += 16;
      }

      if (file.name) delete [] file.name;
      file.name   = strdup(pfilename);

      if (file.md5)  delete file.md5;
      file.md5    = new SFKMD5();

      file.time   = nTime;
      file.size   = nLen;
      file.remain = nLen;

      file.blockmode = bbulk ? 0 : 1;
      file.block     = 0;

      // we do NOT really write a file here!
   }
   else
   #endif // USE_SFT
   {
      if (setPassive(&pClDatCon)) return 10;
      if (pClCtlCon->putf("RETR %s", pfilename)) return 10;
 
      // TODO: check actual RC if file exists
      if (!pClCtlCon->readLine()) return 10;
      // download started on data connection
 
      if (verbose()) {
         printf("< %s   \r", pfilename);
         fflush(stdout);
      }
   }

   return 0;
}

// read block of a file
int FTPClient::readFile(uchar *pbuf, int nmaxlen)
{__
   #ifdef USE_SFT
   if (bClSFT)
   {
      TCPCon *pcon = pClCtlCon;

      int nmaxin = nmaxlen; (void)nmaxin;

      if (nmaxlen > file.remain) nmaxlen = file.remain;

      if (nmaxlen <= 0) {
         mtklog(("ftp: readFile: max=%d return=%d", nmaxin, nmaxlen));
         return nmaxlen;
      }

      file.block++;

      if (nClSFTVer >= 102 && file.blockmode)
      {
         num nreqlen = nmaxlen;

         // optim: on the first block, request only maxlen.
         // from the second block, transfer all in one.
         // NOTE: there can be no upper limit for this
         //       all-in-one size, as otherwise we have
         //       to remember subblock lengths which can
         //       become complicated.

         extern int fastMode();

         // with fastmode, get all in one from first block.
         int nbiglatch = fastMode() ? 1 : 2;

         if (file.block == nbiglatch) {
            // request bulk transfer, no further SREAD.
            nreqlen = file.remain;
         }

         if (file.block <= nbiglatch) {
            mtklog(("ftp: request %d remain=%s", nreqlen, numtoa(file.remain)));
            if (pcon->putf("SREAD %s\n", numtoa(nreqlen))) {
               perr("failed to send block request");
               return 0; // NOT -1, size_t problem
            }
         }
      }

      int nread = pClCtlCon->read(pbuf, nmaxlen);

      mtklog(("ftp: read %d", nread));

      if (nread > 0)
      {
         if (file.md5) file.md5->update(pbuf, nread);
         file.remain -= nread;
         // reached end of content flank?
         if (file.remain == 0 && nClSFTVer >= 102)
         {
            if (file.blockmode) {
               // request md5_post
               mtklog(("ftp: req sum"));
               if (pcon->putf("SSUM\n")) {
                  perr("failed to request checksum");
                  return 0; // NOT -1, size_t problem
               }
            }
            mtklog(("ftp: wait for sum"));
            if (pClCtlCon->read(file.abmd5, 16) != 16) {
               perr("failed to receive checksum");
               return 0; // NOT -1, size_t problem
            }
         }
      }
      mtklog(("ftp: readFile: max=%d return=%d", nmaxin, nread));
      // SKIP record will follow after content, we ignore that
      return nread;
   }
   else
   #endif // USE_SFT
   {
      if (!pClDatCon) {
         perr("ftp: cannot read, no download open");
         return 0;
      }
      return pClDatCon->read(pbuf, nmaxlen);
   }
}

void FTPClient::closeFile( )
{__
   char szBuf[300];

   #ifdef USE_SFT
   if (bClSFT)
   {
      if (!pClCtlCon)
         return;

      // sender will wait now until we confirm successful transfer.
      TCPCon *pcon = pClCtlCon;

      mtklog(("ftp: closeFile %s remain=%d", file.name ? file.name : "", (int)file.remain));
 
      if (nClSFTVer >= 102) {
         if (file.blockmode) {
            // send close
            mtklog(("ftp: req close"));
            if (pcon->putf("SCLOSE\n")) {
               perr("failed to send close");
               return;
            }
         } else {
            // bulk SFT cannot handle premature file close
            if (file.remain > 0) {
               pwarn("bulk transfer but %d remaining for: %s\n", (int)file.remain, file.name ? file.name : "");
            }
            while (file.remain > 0) {
               int nread = readFile((uchar*)line(), lineMax());
               if (nread <= 0) break;
            }
         }
         // expect and receive SKIP record of any length
         mclear(szBuf);
         recv(pcon->clSock, (char*)szBuf, sizeof(szBuf)-10, 0);
         mtklog(("ftp: got past close: %s",szBuf));
         // ack is sent below
      } else {
         // old SFT cannot handle premature file close
         while (file.remain > 0) {
            int nread = readFile((uchar*)line(), lineMax());
            if (nread <= 0) break;
         }
      }

      if (!file.remain && file.md5)
      {
         // check and clear md5
         uchar abdig[20];
         memcpy(abdig, file.md5->digest(), 16);

         delete file.md5;
         file.md5 = 0;

         if (memcmp(abdig, file.abmd5, 16)) {
            pcon->send((uchar*)"EE\n\n", 4);
            perr("md5 mismatch - transfered file corrupted (size=%d)\n", (int)file.size);
            return ;
         }
      }

      // send short confirmation, so peer can safely close socket.
      int nSent = pcon->send((uchar*)"OK\n\n", 4);
      if (nSent != 4) {
         perr("failed to send reply, %d\n", nSent);
         return;
      }
   }
   else
   #endif // USE_SFT
   {
      if (!pClDatCon)
         return;

      close(pClDatCon);
      pClDatCon = 0;

      // expect reply on control connection
      char *pline = readLine();
      if (pline && !strBegins(pline, "226 "))
         perr("ftp: unexpected reply after download: %s", pline);
   }
}

// returns RC
int HTTPClient::sendReq
 (
   cchar *pcmd,
   char *pfile,
   char *phost,
   int  nport
 )
{
   if (!pClCurCon)
      { perr("int. #175296 missing connection"); return 9; }

   char szPort[20];
   szPort[0] = '\0';

   // 'hostname:443' causes redirect failure with some servers.
   if (nport != 80 && nport != 443)
      sprintf(szPort, ":%u", nport);

   char szAuth1[200];
   char szAuth2[200];
   szAuth1[0] = '\0';
   szAuth2[0] = '\0';
   if (cs.pwebuser && cs.pwebpass) { // sfk198 web access user/pw support
      snprintf(szAuth1,sizeof(szAuth1)-10, "%s:%s", cs.pwebuser, cs.pwebpass);
      encode64((uchar*)szAuth1,strlen(szAuth1),(uchar*)szAuth2,sizeof(szAuth2)-10,10000);
      // encode64 adds CRLF already!
      snprintf(szAuth1,sizeof(szAuth1)-10, "Authorization: Basic %s", szAuth2);
   }

   char *phdrs = cs.headers ? cs.headers : str("");
   char *pReqBuf = aClIOBuf;
   int   nReqLen = 0;

   if (cs.webreq)
   {
      char *preq = cs.webreq;
      while (iseol(*preq)) preq++;

      if (!mystrnicmp(preq, "POST", 4))
      {
         // POST: leave as is, use large input buffer
         pReqBuf = preq;
         nReqLen = cs.webreqlen ? cs.webreqlen : (int)strlen(pReqBuf);
      }
      else
      {
         // GET, HEAD, CONNECT etc: complete the header
         if (strlen(cs.webreq) > sizeof(aClIOBuf)-20)
            return 9+perr("web request too long: %.100s", cs.webreq);
         strcopy(aClIOBuf, cs.webreq);
         int nlen = strlen(aClIOBuf);
         int nmax = sizeof(aClIOBuf)-10;
         // fix missing double crlf at end
         if (nlen>4 && nlen+4<nmax
             && strncmp(&aClIOBuf[nlen-4], "\r\n\r\n", 4)!=0)
         {
            if (strncmp(&aClIOBuf[nlen-2], "\r\n", 2)==0)
               strcat(aClIOBuf, "\r\n");
            else
               strcat(aClIOBuf, "\r\n\r\n");
         }
         nReqLen = (int)strlen(aClIOBuf);
      }
   }
   else
   {
      int nmaxbuf = (int)sizeof(aClIOBuf)-10;

      if (szClProxyHost[0])
      snprintf(aClIOBuf, nmaxbuf,
         "%s http://%s%s/%s HTTP/1.1\r\n"
         "Host: %s%s\r\n"
         , pcmd, phost, szPort, pfile
         , phost, szPort);
      else
      snprintf(aClIOBuf, nmaxbuf,
         "%s /%s HTTP/1.1\r\n"
         "Host: %s%s\r\n"
         , pcmd, pfile, phost, szPort);
 
      if (strlen(phdrs) > 1) // skip prefix "\n"
         mystrcatf(aClIOBuf, nmaxbuf, "%s", phdrs+1);
 
      if (szAuth1[0] && !mystrstri(phdrs, "\nAuthorization:"))
         mystrcatf(aClIOBuf, nmaxbuf, "%s", szAuth1); // has CRLF already

      if (!mystrstri(phdrs, "\nUser-Agent:"))
         mystrcatf(aClIOBuf, nmaxbuf, "User-Agent: %s\r\n", getHTTPUserAgent());

      if (!mystrstri(phdrs, "\nAccept:"))
         mystrcatf(aClIOBuf, nmaxbuf, "Accept: text/html;q=0.9,*/*;q=0.8\r\n");
 
      if (!mystrstri(phdrs, "\nAccept-Language:"))
         mystrcatf(aClIOBuf, nmaxbuf, "Accept-Language: en-us,en;q=0.8\r\n");

      if (!cs.webnoclose) { // sfk198 option
         if (szClProxyHost[0]) {
            if (!mystrstri(phdrs, "\nProxy-Connection:"))
               mystrcatf(aClIOBuf, nmaxbuf, "Proxy-Connection: close\r\n");
         } else {
            if (!mystrstri(phdrs, "\nConnection:"))
               mystrcatf(aClIOBuf, nmaxbuf, "Connection: close\r\n");
         }
      }
 
      mystrcatf(aClIOBuf, nmaxbuf, "\r\n");

      if (strlen(aClIOBuf) > nmaxbuf-10)
         return 9+perr("web request too long: %.100s", aClIOBuf);

      nReqLen = (int)strlen(aClIOBuf);
   }

   if (cs.showreq)
      printx("<file>http://%s%s/%s\n", phost, szPort, pfile);

   if (cs.showhdr & 2) {
      char *psz = (char*)pReqBuf;
      char ccol = 'f';
      while (*psz!=0) {
         char *peol=psz;
         while (*peol && !iseol(*peol)) peol++;
         int ilen=peol-psz;
         // chain.print(ccol, 1, "< %.*s",ilen,psz);
         if (ccol=='f')
            printx("<file>< %.*s\n",ilen,psz);
         else
            printf("< %.*s\n",ilen,psz);
         if (!strncmp(peol, "\r\n\r\n", 4)
             || !strncmp(peol, "\n\n", 2)) {
            printf("< \n");
            break;
         }
         while (*peol && iseol(*peol)) peol++;
         psz = peol;
         ccol = ' ';
      }
   }

   if (fGlblWebDump) {
      fprintf(fGlblWebDump, "-----req.begin-----\n");
      fwrite(pReqBuf, 1, nReqLen, fGlblWebDump);
      fprintf(fGlblWebDump, "-----req.done-----\n");
      fflush(fGlblWebDump);
   }

   size_t nsent = 0;

   #ifdef WITH_SSL
   if (bClSSL)
   {
      nsent = SSL_write(pClSSLSocket, pReqBuf, nReqLen);
   }
   else
   #endif // WITH_SSL
   {
      nsent = pClCurCon->send((uchar*)pReqBuf, nReqLen);
   }

   return 0;
}

int CoiData::getFtp(char *purl)
{__
   TCPCore::sysInit();

   if (pClFtp) return 0; // reuse

   int nprelen = strlen("ftp://");
   if ((int)strlen(purl) <= nprelen) return 9;

   // isolate base url with the hostname
   char szBase[200];
   strcopy(szBase, purl);
   char *psz = szBase + nprelen;
   psz = strchr(psz, '/');
   if (!psz) return 9;
   *psz = '\0';

   // now try to alloc the relevant client
   if (!(pClFtp = glblConCache.allocFtpClient(szBase))) {
      perr("unable to ftp to: %s", szBase);
      return 9;
   }

   return 0; // ok, use pClFtp
}

int CoiData::getHttp(char *purl)
{__
   TCPCore::sysInit();

   if (pClHttp) return 0; // reuse

   int nprelen = 0;

   if (strBegins(purl, "http://")) nprelen = 7;
   else
   if (strBegins(purl, "https://")) nprelen = 8;
   else
      return 0;

   // isolate base url with the hostname
   char szBase[200];
   strcopy(szBase, purl);
   char *psz = szBase + nprelen;
   psz = strchr(psz, '/');

   if (psz)
      *psz = '\0';
   // else it is http://justhost

   // now try to alloc the relevant client
   #ifdef USE_WEBCONCACHE
   if (!(pClHttp = glblConCache.allocHttpClient(szBase))) {
      perr("unable to http to: %s", szBase);
      return 9;
   }
   #else
   if (!(pClHttp = new HTTPClient(szBase))) {
      perr("unable to http to: %s", szBase);
      return 9;
   }
   #endif

   mtklog(("coidata.http.alloc done %p", pClHttp));

   return 0; // ok, use pClHttp
}

int CoiData::releaseFtp( )
{__
   if (!pClFtp)
      return 9+perr("releaseFtp without ptr, %p", this);
   pClFtp->decref("rft");
   pClFtp = 0;
   return 0;
}

int CoiData::releaseHttp( )
{__
   if (!pClHttp)
      return 9+perr("releasehttp without ptr, %p", this);

   pClHttp->resetCache();

   #ifdef USE_WEBCONCACHE
   pClHttp->decref("rht");
   #else
   delete pClHttp;
   #endif

   pClHttp = 0;

   return 0;
}
// emod net_tcp
#endif // (sfk_prog || sfk_net_tcp)

// dmod net_wget
#if (sfk_prog || sfk_net_wget)
char *flatURLName(char *purl, char *pctype, char *pbuf, int nmaxbuf, uint nmode, bool &rdefault)
{__
   bool bpath2name = (nmode & 1) ? 1 : 0;
   bool bpath2path = (nmode & 2) ? 1 : 0;
   bool bwithdom   = (nmode & 4) ? 1 : 0;
   bool bskippath  = (!bpath2name && !bpath2path);
   // nmode & 8 is reserved
   bool bsynext    = (nmode & 16) ? 1 : 0;

   *pbuf = '\0'; // safety

   char *prel    = purl;
   char *purlmax = purl + strlen(purl);
   char *pCacheDir = getDiskCachePath();

   char szNameBuf[SFK_MAX_PATH+10];

   // only normalize net filenames,
   // or net files from the cache dir.
   if (strBegins(prel, "http://")) prel += strlen("http://");
   else
   if (strBegins(prel, "https://")) prel += strlen("https://");
   else
   if (strBegins(prel, "ftp://"))  prel += strlen("ftp://");
   else
   if (strBegins(prel, pCacheDir))
   {
      prel += strlen(pCacheDir);
      if (*prel == glblPathChar) prel++;

      // rebuild url from cache name format
      char *psrc = prel;
      char *pdst = szNameBuf;
      char *pdstmax = pdst+sizeof(szNameBuf)-10;
      szNameBuf[0] = '\0';

      if (strBegins(psrc, "http/") || strBegins(psrc, "http\\"))
         { psrc += 5; strcat(pdst, "http://"); pdst += 7; }
      else
      if (strBegins(psrc, "ftp/") || strBegins(psrc, "ftp\\"))
         { psrc += 4; strcat(pdst, "ftp://"); pdst += 6; }

      while (*psrc && (pdst < pdstmax))
      {
         if (!strncmp(psrc, "%2F", 3))
            { psrc+=3; *pdst++ = '/'; continue; }
         if (*psrc == '\\')
            { psrc++; *pdst++ = '/'; continue; }
         *pdst++ = *psrc++;
      }
      *pdst = '\0';

      // printf("-> \"%s\"\n", szNameBuf);

      prel = szNameBuf;
   }
   else
      return 0;

   char *pdst = pbuf;
   int  nrem = nmaxbuf - 10;

   if (nrem <= 100) { perr("int. #9529106"); return 0; }

   if (bskippath) {
      // the/sub/doc.zip -> doc.zip
      // http://foo.com/ -> ""
      char *psz2 = strrchr(prel, '/');
      if (psz2) {
         prel = psz2+1;
         if (!*prel) {
            strcpy(pdst, "index.html");
            rdefault = 1;
            return pbuf;
         }
      }
   }
   else
   if (!bwithdom) {
      // foobar.com/path -> path
      char *psz2 = strchr(prel, '/');
      if (psz2) {
         prel = psz2+1;
         if (!*prel) {
            strcpy(pdst, "index.html");
            rdefault = 1;
            return pbuf;
         }
      }
   }

   // convert and add rest of url.
   // http: $-_.+!*'(),
   char *psrc = prel;
   cchar *pext1 = 0;
   char *pext2 = 0;
   char  clast = 0;
   bool  lm    = 0; // last char was minus
   while (*psrc && (nrem > 0))
   {
      char c = *psrc++;
      clast  = c;
      if (isalnum(c)) {
         *pdst++ = c; nrem--; lm=0;
         continue;
      }
      if (!pext2) pext2 = psrc-1;
      switch (c) {
         case '.':
             pext1 = psrc-1; pext2 = 0;
         case '-': case '+': case '_':
            *pdst++ = c; nrem--; lm=0;
            continue;
         case '/':
            if (bpath2path) {
               *pdst++ = glblPathChar; nrem--; lm=0;
               continue;
            }
         default:
            if (!lm) {
               *pdst++ = '-'; nrem--; lm=1;
            }
            continue;
      }
      /*
      sprintf(szBuf, "%%%02X", (unsigned)c);
      *pdst++ = szBuf[0];
      *pdst++ = szBuf[1];
      *pdst++ = szBuf[2];
      nrem -= 3;
      */
   }

   // fix trailing slash
   if (clast == '/' && (nrem >= 12)) {
      strcpy(pdst, "index.html");
      pdst += strlen(pdst);
      pext1 = ".html";
      nrem -= 10;
      rdefault = 1;
   }

   *pdst = '\0';

   if (bsynext)
   {
      // create default extensions for well-known ctypes
      if (!pext1 && pctype) {
         if (strstr(pctype, "text"))   pext1 = ".txt";
         if (strstr(pctype, "html"))   pext1 = ".html";
      }
 
      if (!pext1) pext1 = ".dat";
 
      // if extension is not at end of name, append it again
      if (pext1)
      {
         int nlen   = strlen(pext1);
         bool binurl = (pext1 >= purl && pext1 <= purlmax);
         if (binurl && pext2 && (pext2 > pext1))
            nlen = pext2 - pext1;
         if (nlen > 7) { pext1 = ".dat"; nlen = 4; }
         char *pcmp = pdst - nlen;
         if (pcmp < pbuf) pcmp = pbuf;
         if (nlen <= 7 && nlen < nrem && strncmp(pcmp, pext1, nlen))
         {
            memcpy(pdst, pext1, nlen);
            pdst[nlen] = '\0';
            nrem -= nlen;
         }
      }
   }

   return pbuf;
}

int execWGet(Coi *psrc, char *pDstDir, uint nmode)
{__
   int lRC = 0;

   num nstart = getCurrentTime();

   char *pSrcName = psrc->name();

   bool bpath2path = (nmode &  2) ? 1 : 0;
   bool b1outfile  = (nmode &  8) ? 1 : 0;
   bool bdump      = (nmode & 32) ? 1 : 0;
   bool bnodump    = (nmode & 64) ? 1 : 0;
   bool btomem     = (nmode & 128) ? 1 : 0;
 
   // default on single output file
   char *pDstName = pDstDir;

   int nMaxDst= 500;
   char szDstBuf[500+10]; mclear(szDstBuf);

   if (!b1outfile && pDstDir)
   {
      mystrcopy(szDstBuf, pDstDir, nMaxDst);
      strcat(szDstBuf, glblPathStr);
   }

   int isubrc = psrc->open("rb");

   if (isubrc)
      return 9+pferr(psrc->name(), "cannot read: %s%s\n", psrc->name(),psrc->lasterr());

   num nSize = psrc->nClSize; // if any

   char *pctype = psrc->header("content-type");

   num    nalloc = 0;
   uchar *pdata  = 0;
   num    nused  = 0;

   // if there is cached data, reuse that
   if (psrc->data().src.data)
      btomem = 0;

   // make sure to use the redirected source name
   pSrcName = psrc->name();

   bool bSetDefault = 0;

   if (b1outfile)
   {
      if (cs.verbose)
         printf("write to single output file: %s\n", pDstName);
   }
   else
   {
      // create target filename without output dir

      char *pcat = szDstBuf + strlen(szDstBuf);
      int  nrem = nMaxDst  - strlen(szDstBuf);
 
      if (!flatURLName(pSrcName, pctype, pcat, nrem, nmode, bSetDefault))
         return 9+perr("wrong URL format: %s\n", pSrcName);

      pDstName = szDstBuf;

      if (cs.verbose)
         printf("write to joined output path: %s\n", pDstName);
   }

   if (bSetDefault && !nmode)
      return 9+perr("need -path2name or -fullpath on URLs like : %s\n", pSrcName);

   if (bpath2path)
      if (createOutDirTree(pDstName))
         return 9;

   Coi *pdst = 0;

   if (!bdump) {
      pdst = new Coi(pDstName, 0);
      if (!pdst) return 9+perr("out of memory");
   }
   CoiAutoDelete odel2(pdst, 0); // no decref

   num nread    = 0;
   num nWritten = 0;

   if (chain.coldata && !chain.colbinary)
      chain.addStreamAsLines(1,0,0);

   if (pdst && pdst->open("wb"))
      perr("cannot write: %s%s\n", pdst->name(),pdst->lasterr());
   else
   {
      if (pdst) info.setAction("write", pdst->name(), "");

      while ((nread = psrc->read(abBuf, sizeof(abBuf)-1000)) > 0)
      {
         if (bdump) {
            if (!bnodump) {
               if (chain.coldata) {
                  if (chain.colbinary) {
                     if (chain.addBinary(abBuf, nread))
                        { lRC=9; break; }
                  } else {
                     chain.addStreamAsLines(2, (char*)abBuf, nread);
                  }
               } else {
                  if (myfwrite(abBuf, nread, stdout))
                     { lRC=9; break; }
               }
            }
         }
         else
         if (pdst && pdst->write(abBuf, nread) != nread) {
            perr("cannot fully write %s, probably disk full.\n", pdst->name());
            break;
         }

         if (btomem)
         {
            num nrem = nalloc - nused;
            if (nrem < nread + 1000)
            {
               // expand buffer
               if (!nalloc) nalloc = 10000; // initial

               num nalloc2 = nalloc * 2 + nread;

               if (nalloc2 >= 100 * 1000000) {
                  pinf("download will not be cached (too large).\n");
                  btomem = 0;
                  delete [] pdata;
                  pdata  = 0;
                  nalloc = 0;
               } else {
                  uchar *ptmp = new uchar[nalloc2+100];
                  memcpy(ptmp, pdata, nused);
                  // swap old and new
                  delete [] pdata;
                  pdata  = ptmp;
                  nalloc = nalloc2;
                  nrem   = nalloc - nused;
               }
            }
         }

         if (btomem)
         {
            // add block to memory
            if (nused+nread > nalloc)
               { perr("int. #228290640"); btomem=0; break; }
            memcpy(pdata+nused, abBuf, nread);
            nused += nread;
         }

         nWritten += nread;
         info.setProgress(nSize, nWritten, "bytes");
      }
   }

   if (chain.coldata) chain.addStreamAsLines(3,0,0);

   if (pdst) pdst->close();
   psrc->close();

   if (btomem && pdata && nused)
      psrc->setContent(pdata, nused, psrc->nClMTime);

   // NO cleanup of pdata, as it is cached!

   int ielapsed = (int)(getCurrentTime() - nstart);

   if (pdst != 0 && cs.quiet < 2)
      info.print("done : %s (%s bytes, %d msec).\n", pdst->name(), numtoa(nWritten), ielapsed);
   else
      info.clear(); // fix sfk1814

   if (pdst && chain.colfiles)
   {
      // use tmp coi to make sure it is copied
      Coi ocoi(pdst->name(), 0);
      chain.addFile(ocoi); // is copied
   }

   return lRC;
}

// emod net_wget
#endif // (sfk_prog || sfk_net_wget)

// dmod net_proxy
#if (sfk_prog || sfk_net_proxy)
int wouldBlock(int ibytes)
{
   #ifdef _WIN32
   if (ibytes == -1 || WSAGetLastError() == WSAEWOULDBLOCK)
      return 1;
   #else
   if (ibytes == -1 || errno == EWOULDBLOCK)
      return 1;
   #endif
   return 0;
}

extern bool isws(char c,bool bext=1); // default for proxy ff

#define MAX_IODEF       100
#define MAX_CONDEF      100
#define MAX_CONNECTIONS 4096
#define MAX_BUFFER      10000
#define MAX_HOSTLEN     100
#define MAX_CONSTATEINFO 32

struct IODef {
   char *pszdef;  // copy of "tcp 80 server 3000 call udp3k to udp ... to file"
   char *psztarg; // points into pszdef's first target
   int  iwebmode;
        // 1: http header rewrite
        // 3: http proxy mode (to any)
   #ifdef WITH_SSL
   int  bfromssl;
   int  btossl;
   #endif // WITH_SSL
   char szfromip[MAX_HOSTLEN]; // with tcp, from reverse
   int  ifromport;
   char sztoip[MAX_HOSTLEN];   // with tcp, from reverse
   int  itoport;               // with tcp, from reverse
   int  iprefix;
   int  iverbose;
   int  imaxdump; // -1 = dump all
};

enum eConType {
   eTcpAccept  = 1,
   eTcpClient,
   eTcpForward,
   eRevAccept,
   eRevClient,
   eUdpListen,
   eRevGetPassive,
   eRevGetPending,
   eRevGetConnected
};

struct Connection
{
   int  id;
   int  icondef;  // == iodef
   int  itype;    // eConType
   int  isocket;
   int  ioutsocket; // for udp forward
   int  iport;
   int  ilink;
   int  iwebstate;

   uint8_t *pdata;   // pending for send
   int      ioffs;   // offset in pdata
   int      iremain; // remaining for send

   int      bwait; // waits for reply
   int      bconpend;
   unum     tlastio;
   char     cstate;  // aAvV
   unum     tlastcon;
   int      ioutport;
   uint     inip;
   int      inport;

   #ifdef WITH_SSL
   int      bssl;
   SSL_CTX *psctx;
   SSL     *pssock;
   #else
   void    *pssock;
   #endif // WITH_SSL

   char szouthost[200];
};

class Proxy
{
public:
      Proxy ( );

static Proxy *pClCurrent;
static Proxy &cur( );

   int   addiodef    (char *psz);
   int   addcondef   (char *psz);
   int   prepare     ( );
   int   run         ( );
   int   step        ( );
   int   process     (int s, int iwhat);
   int   numopen     ( ); // requires updateStats()
   int   numpend     ( );
   int   numwait     ( );
   void  listdef     ( );
   void  updateStats ( );
   int   processHttpRequest  (int bytes, int icondef);
   int   processHttpReply    (int bytes, int icon);
   void  closecon    (int i, int ifrom);
   void  closeall    (int i, int ifrom);
   int   getipandport(char **ppsz);
   void  gotin       (int icon, int ibytes, char cstate='.');
   void  sentout     (int icon, int ibytes, char cstate='.');
   #ifdef WITH_SSL
   int   sslconnect  (int i);
   int   sslaccept   (int i);
   #endif // WITH_SSL
   char *dumpData    (uchar *pbuf, int ilen, int icon, cchar *pprefix);
   int   setiodefopt (char **ppcur,int idef);
   void  setInfoStatus  ( );
   int   newcon      (int bWithNewID);
   int   setAddr     (struct sockaddr_in *pAddr, char *pszHost, int iPort);
   void  setNonblocking(int fd, bool b);
   int   call        (int icur, char *szlabel, uchar **pppata, int *pndata,
                      uint &nFromAddr, uint &nFromPort);
   char  *conState   ( );

   int   niodef, ncondef, ncon, blocking;
   int   iClOutPort, inextconid, bcongraph;
   int   iclopen, iclpend, iclwait, iclrevcon;
   int   icldebug, iclverbose, iclmaxdump;
   int   iClInPackets, iClOutPackets;
   unum  iClInBytes, iClOutBytes;

   char  **pclenv;

struct IODef      aiodef   [MAX_IODEF];
struct Connection acon     [MAX_CONNECTIONS];

char     szClOutHost[200];
char     szClConState[MAX_CONSTATEINFO+10];
uint8_t  abClBuf1[MAX_BUFFER+1000],
         abClBuf2[MAX_BUFFER+1000],
         abClDumpBuf[20000+100];
};

#define glblproxy Proxy::cur()

Proxy *Proxy::pClCurrent = 0;

Proxy &Proxy::cur( ) {
   if (!pClCurrent)
      pClCurrent = new Proxy();
   return *pClCurrent;
}

Proxy::Proxy( )
{
   memset(this, 0, sizeof(*this));
}

void Proxy::setNonblocking(int fd, bool b)
{
   if (blocking)
      return;

#ifdef _WIN32
    unsigned long ul = b;
    ioctlsocket(fd, FIONBIO, &ul);
#else
   if (b)
      fcntl(fd, F_SETFL, (fcntl(fd,F_GETFL) | O_NONBLOCK));
   else
      fcntl(fd, F_SETFL, (fcntl(fd,F_GETFL) & ~O_NONBLOCK));
#endif
}

void Proxy::setInfoStatus( )
{
   char szstatus[100],szin[100],szout[100];

   numtoa(iClInBytes/1000000,1,szin);
   numtoa(iClOutBytes/1000000,1,szout);
   int idelta = iClOutBytes-iClInBytes;

   updateStats();

   if (iclrevcon)
      sprintf(szstatus, ">%05u <%05u c=%u r=%u",
         iClInPackets, iClOutPackets, numopen(), iclrevcon);
   else
   if (numopen())
      sprintf(szstatus, ">%05u <%05u c=%u %s",
         iClInPackets, iClOutPackets, numopen(), conState());
   else
      sprintf(szstatus, ">%05u <%05u",
         iClInPackets, iClOutPackets);

   info.setStatus("proxy", szstatus);
}

void Proxy::gotin(int icon, int ibytes, char cstate) {
   iClInPackets++;
   iClInBytes += ibytes;
   if (icon>=0 && icon<MAX_CONNECTIONS) {
      acon[icon].tlastio = getCurrentTime();
      acon[icon].cstate = cstate;
   }
}
void Proxy::sentout(int icon, int ibytes, char cstate) {
   iClOutPackets++;
   iClOutBytes += ibytes;
   if (icon>=0 && icon<MAX_CONNECTIONS) {
      acon[icon].tlastio = getCurrentTime();
      acon[icon].cstate = cstate;
   }
}

char *Proxy::dumpData(uchar *pAnyData, int iDataSize, int icon, cchar *pprefix)
{
   if (iDataSize == -1)
       iDataSize = strlen((char*)pAnyData);

   int idef = acon[icon].icondef;
   int imaxdump = aiodef[idef].imaxdump;

   char *pszBuf = (char*)abClDumpBuf;
   int iMaxBuf  = sizeof(abClDumpBuf)-100;

   if (imaxdump == 0) imaxdump = 128;
   if (imaxdump == -1) imaxdump = iMaxBuf;

   // look for binary
   bool bbinary = 0;
   for (int i=0; i<iDataSize; i++)
      if (!pAnyData[i])
         { bbinary=1; break; }
   if (bbinary==1 && acon[icon].iwebstate>0 && imaxdump>0)
      iMaxBuf = mymin(imaxdump,iMaxBuf);

   // look for header
   int iheadlen=0;
   if (strbeg((char*)pAnyData,str("HTTP/"))
       || strbeg((char*)pAnyData,str("GET "))
       || strbeg((char*)pAnyData,str("POST "))
       || strbeg((char*)pAnyData,str("CONNECT ")))
   {
      char *pend=strstr((char*)pAnyData,"\r\n\r\n");
      if (pend) {
         iheadlen=(pend-(char*)pAnyData)+4;
         iMaxBuf = mymin(iheadlen+imaxdump,iMaxBuf);
      }
   }
   else {
      iMaxBuf = mymin(imaxdump,iMaxBuf);
   }

   uchar *pSrcCur = (uchar *)pAnyData;
   uchar *pSrcMax = pSrcCur + iDataSize;
 
   char *pszDstCur = pszBuf;
   char *pszDstMax = pszBuf + iMaxBuf - 20;
 
   while (pSrcCur < pSrcMax && pszDstCur < pszDstMax)
   {
      int irelpos = pSrcCur-(uchar*)pAnyData;

      uchar uc = *pSrcCur++;
 
      if (isprint((char)uc))
      {
         *pszDstCur++ = (char)uc;
         continue;
      }

      // if (irelpos<iheadlen && uc=='\r')
      //    continue;
      // if (irelpos<iheadlen && uc=='\n')
      //    { *pszDstCur++ = '\n'; continue; }

      sprintf(pszDstCur, "{%02X}", uc);
      pszDstCur += 4;
   }
 
   *pszDstCur = '\0';

   // --- dump ---

   char *pdata = pszBuf;
   while (*pdata)
   {
      char *peol = strstr(pdata,"{0D}{0A}");
      if (peol) {
         int ilen=peol-pdata;
         if (ilen>0)
            printf("%s%.*s\n",pprefix,ilen,pdata);
         else {
            // printf("%s[eol]\n",pprefix);
            printf("%s\n",pprefix);
         }
         pdata += ilen+8;
      } else {
         printf("%s%.110s\n",pprefix,pdata);
         if (strlen(pdata) <= 110)
            break;
         pdata += 110;
      }
   }
 
   return pszBuf;
}

// in: "pat." means "pat:" or "pat " or "pat{null}"
static int strmatch(char **ppsz, const char *pat, int &rtoken, int itoken)
{
   char *psz = *ppsz;
   int  nlen = strlen(pat);
   bool bfuzz= 0;
   if (nlen>0 && pat[nlen-1]=='.')
       { nlen--; bfuzz=1; }
   if (!strncmp(psz, pat, nlen)) {
      psz += nlen;
      if (bfuzz==1 && *psz!=0 && *psz!=':' && isws(*psz)==0)
         return 0;
      if (*psz==':') psz++;
      while (isws(*psz)) psz++;
      *ppsz = psz;
      rtoken = itoken;
      return 1;
   }
   return 0;
}

int Proxy::addiodef(char *pszdefin)
{
   if (niodef >= MAX_IODEF)
      return 9+perr("too many from definitions");

   struct IODef *pdef = &aiodef[niodef];
   pdef->pszdef = strdup(pszdefin);
   pdef->iverbose = iclverbose;
   pdef->imaxdump = iclmaxdump;

   char *pcur = pszdefin;

   int itoken = 0;

   if (strmatch(&pcur, "tcp.", itoken, 1)
       #ifdef WITH_SSL
       || strmatch(&pcur, "http -ssl", itoken, 3)
       #endif // WITH_SSL
       || strmatch(&pcur, "http.", itoken, 2)
      )
   {
      if (itoken==2)
         pdef->iwebmode = 1;
      #ifdef WITH_SSL
      if (itoken==3)
         { pdef->iwebmode = 1; pdef->bfromssl = 1; }
      #endif // WITH_SSL

      // seek "to tcp ip:port" single target
      // seek "to http ip:port" single target
      for (; *pcur!=0; pcur++)
      {
         char *pold=pcur;
         if (
             #ifdef WITH_SSL
                strmatch(&pcur, "to tcp -ssl", itoken, 3) // internal
             || strmatch(&pcur, "to http -ssl", itoken, 4)
             ||
             #endif // WITH_SSL
                strmatch(&pcur, "to tcp.", itoken, 1)
             || strmatch(&pcur, "to http.", itoken, 2)
            )
         {
            char *pend=pcur;
            while (*pend!=0 && *pend!=':' && *pend!=' ') pend++;
            int ilen=pend-pcur;
            if (ilen+4>sizeof(pdef->sztoip)) return 11;
            memcpy(pdef->sztoip,pcur,ilen);
            pdef->sztoip[ilen]='\0';
            switch (itoken) {
               case 2: pdef->itoport=80; break;
               #ifdef WITH_SSL
               case 3: pdef->btossl=1; break;
               case 4: pdef->itoport=443; pdef->btossl=1; break;
               #endif // WITH_SSL
            }
            if (*pend==':')
               pdef->itoport=atoi(pend+1);
            if (!pdef->itoport)
               return 9+perr("missing target port: %s",pszdefin);
            break;
         }
         else
         if (strmatch(&pcur, "to any", itoken, 0)) {
            if (pdef->iwebmode<1)
               return 9+perr("'to any' requires http");
            pdef->iwebmode |= 2;
            break;
         }
         else
         if (strmatch(&pcur, "to ", itoken, 0)) {
            perr("invalid 'to' target: %s",pszdefin);
            pinf("use to http, to tcp or to udp.\n");
            return 9;
         }
      }
   }
   else
   if (strmatch(&pcur, "udp.", itoken, 1))
      { } // all done in prepare
   else
   if (strmatch(&pcur, "reverse.", itoken, 1)) // FROM reverse
   {
      // from reverse sourcehostip port
      char *pend=pcur;
      while (*pend!=0 && *pend!=':' && *pend!=' ') pend++;
      int ilen=pend-pcur;
      if (ilen+4>sizeof(pdef->sztoip)) return 11;
      memcpy(pdef->sztoip,pcur,ilen);
      pdef->sztoip[ilen]='\0';
      if (*pend==':') pend++;
      while (isws(*pend)) pend++;
      if (!isdigit(*pend))
         return 19+perr("missing port: %s",pszdefin);
      pdef->itoport=atoi(pend+1);
   }
   else
   {
      perr("unknown from: %s", pszdefin);
      pinf("supply protocol: udp tcp http\n");
      return 9;
   }

   niodef++;

   return 0;
}

void Proxy::listdef()
{
   for (int i=0; i<niodef; i++)
   {
      IODef *pdef = &aiodef[i];

      if (pdef->sztoip[0])
         printf("Def #%d tcp target %s:%d from %.32s...\n",
            i+1, pdef->sztoip, pdef->itoport, pdef->pszdef);
      else
         printf("Def #%d from %.64s ...\n",
            i+1, pdef->pszdef);
   }
}

int Proxy::setiodefopt(char **ppcur,int idef)
{
   char *pcur=*ppcur;

   IODef *pdef = &aiodef[idef];
   int itoken = 0;
 
   while (*pcur=='-') {
      if (strmatch(&pcur, "-verbose=2", itoken, 0))
         { pdef->iverbose=2; continue; }
      if (strmatch(&pcur, "-verbose", itoken, 0))
         { pdef->iverbose=1; continue; }
      if (strmatch(&pcur, "-maxdump=", itoken, 0)) {
         pdef->iverbose=2;
         pdef->imaxdump=atoi(pcur);
         while (isdigit(*pcur)) pcur++;
         while (isws(*pcur)) pcur++;
         continue;
      }
      if (strmatch(&pcur, "-fulldump", itoken, 0)) {
         pdef->iverbose=2;
         pdef->imaxdump=-1;
         continue;
      }
      return 9+perr("option not supported here: %s",pcur);
   }

   *ppcur=pcur;
   return 0;
}

int Proxy::prepare( )
{
   prepareTCP();

   socklen_t fromlen;
   struct sockaddr_in saOwnAddr, outAddr;
   fromlen = (int)sizeof(outAddr);

   for (int i=0; i<niodef; i++)
   {
      if (ncon >= MAX_CONNECTIONS)
         return 9;

      /*
         tcp 80 to tcp 192.168.1.100:80
         http 80 to http 192.168.1.100:80
         http 80 to any
         udp 224.0.23.12:5671
            server 3000
            to udp 192.168.1.101:3000
            to udp 192.168.1.102:3000
         server 192.168.1.100:3000
            to udp 224.0.23.12:5671 -prefix
      */

      IODef *pdef = &aiodef[i];
      char *pcur = pdef->pszdef;

      if (!pcur) break;

      Connection *pcon = &acon[ncon];

      int itoken = 0;

      if (strmatch(&pcur, "tcp.", itoken, 1)
          #ifdef WITH_SSL
          || strmatch(&pcur, "http -ssl", itoken, 3) // internal
          #endif // WITH_SSL
          || strmatch(&pcur, "http.", itoken, 2)
         )
      {
         int iport = 0;
         switch (itoken) {
            case 2: iport=80; break;
            case 3: iport=443; break;
         }
         if (isdigit(*pcur)) {
            iport=atoi(pcur);
            while (isdigit(*pcur)) pcur++;
            while (isws(*pcur)) pcur++;
         }
         if (setiodefopt(&pcur,i))
            return 9;
         if (!pdef->psztarg)
            pdef->psztarg = pcur;
         pdef->ifromport = iport;

         pcon->icondef = i;
         pcon->itype   = eTcpAccept;
         pcon->iport   = iport;
         pcon->isocket = socket(AF_INET, SOCK_STREAM, 0);
         if (pcon->isocket < 0)
            return 10;
         memset((char *)&saOwnAddr, 0,sizeof(saOwnAddr));

         saOwnAddr.sin_family      = AF_INET;
         saOwnAddr.sin_addr.s_addr = htonl(INADDR_ANY);
         saOwnAddr.sin_port        = htons(pcon->iport);
 
         int on = 1;
         setsockopt(pcon->isocket, SOL_SOCKET, SO_REUSEADDR, (const char *)&on, sizeof(on));
         on = 1;
         setsockopt(pcon->isocket, SOL_SOCKET, SO_REUSEPORT, (const char *)&on, sizeof(on));
 
         setNonblocking(pcon->isocket, true);
 
         if (bind(pcon->isocket, (struct sockaddr *)&saOwnAddr, sizeof(saOwnAddr)) != 0)
            return 11+perr("cannot bind on port %d. %s",pcon->iport,(pcon->iport<1024)?"(missing admin rights?)":"");
 
         if (listen(pcon->isocket, 50))
            return 12;

         if (!cs.quiet)
            printf("Con #%d listens on tcp port %d with target(s): \"%s\"\n",
               ncon+1, pcon->iport, pdef->psztarg);

         ncon++;

         continue;
      }

      if (strmatch(&pcur, "udp.", itoken, 1))
      {
         char szgroup[100];
         szgroup[0] = '\0';
         int iport = 0;

         if (strmatch(&pcur, "-bonjour", itoken, 2)
             || strmatch(&pcur, "-bon", itoken, 2)) {
            strcpy(szgroup, "224.0.0.251");
            iport=5353;
         }
         else if (strmatch(&pcur, "-knx", itoken, 3)) {
            strcpy(szgroup, "224.0.23.12");
            iport=3671;
         } else {
            char *pend=pcur;
            while (*pend!=0 && *pend!='.' && *pend!=':' && *pend!=' ')
               pend++;
            if (*pend=='.') {
               while (*pend!=0 && *pend!=':' && *pend!=' ')
                  pend++;
               int ilen=pend-pcur;
               if (ilen+10>sizeof(szgroup))
                  return 13;
               memcpy(szgroup,pcur,ilen);
               szgroup[ilen]='\0';
               if (*pend==':') pend++;
               while (isws(*pend)) pend++;
               pcur=pend;
            }
            if (isdigit(*pcur)) {
               iport=atoi(pcur);
               while (isdigit(*pcur)) pcur++;
               while (isws(*pcur)) pcur++;
            }
         }
         if (setiodefopt(&pcur,i))
            return 9;
         if (!pdef->psztarg)
            pdef->psztarg = pcur;

         // udp listen socket
         pcon->icondef = i;
         pcon->itype   = eUdpListen;
         pcon->iport   = iport;
         pcon->isocket = socket(AF_INET, SOCK_DGRAM, 0);
         if (pcon->isocket < 0)
            return 14;
         memset((char *)&saOwnAddr, 0,sizeof(saOwnAddr));

         saOwnAddr.sin_family      = AF_INET;
         saOwnAddr.sin_addr.s_addr = htonl(INADDR_ANY);
         saOwnAddr.sin_port        = htons(pcon->iport);
 
         int on = 1;
         setsockopt(pcon->isocket, SOL_SOCKET, SO_REUSEADDR, (const char *)&on, sizeof(on));
         on = 1;
         setsockopt(pcon->isocket, SOL_SOCKET, SO_REUSEPORT, (const char *)&on, sizeof(on));
 
         if (bind(pcon->isocket, (struct sockaddr *)&saOwnAddr, sizeof(saOwnAddr)) != 0)
            return 15+perr("cannot bind on port %d. %s",pcon->iport,(pcon->iport<1024)?"(missing admin rights?)":"");

         if (szgroup[0])
         {
            // multicast receive
            struct ip_mreq mreq;
            memset(&mreq, 0, sizeof(mreq));
            mreq.imr_interface.s_addr = htonl(INADDR_ANY);
 
            #if defined(MAC_OS_X) || defined(SOLARIS)
               #define SOL_IP IPPROTO_IP
            #endif
 
            #ifdef _WIN32
 
            char name[512];
            PHOSTENT hostinfo;
            mclear(name);
            mclear(hostinfo);
 
            if (gethostname(name, sizeof(name)))
               { perr("gethostname failed\n"); break; }
 
            if (!(hostinfo = sfkhostbyname(name)))
               { perr("get ownhost failed (%s) (1)\n", name); break; }
 
            int iRC = 0;
            int ndone = 0;
            for (int i=0; hostinfo->h_addr_list[i]; i++) // sfk1962 mcast receive
            {
               struct in_addr *pin_addr = (struct in_addr *)hostinfo->h_addr_list[i];
 
               mreq.imr_interface.s_addr = pin_addr->s_addr;
               mreq.imr_multiaddr.s_addr = inet_addr(szgroup);
 
               // force IP_ADD_MEMBERSHIP of ws2tcpip.h
               #define MY_IP_ADD_MEMBERSHIP 12
 
               if (iRC = setsockopt(pcon->isocket, IPPROTO_IP, MY_IP_ADD_MEMBERSHIP, (char *)&mreq, sizeof(mreq))) {
                  perr("cannot join multicast: rc=%d %s", iRC, netErrno());
                  perr("host=%s sock=%d group=%s",name,pcon->isocket,szgroup);
                  break;
                  // in case of error 10042 see
                  //    http://support.microsoft.com/kb/257460
                  // wrong winsock header, runtime linkage etc.
               }
               ndone++;
            }
            if (iRC) break;
 
            #else
 
            if (inet_aton(szgroup, &mreq.imr_multiaddr) == 0)
               { perr("bad address: %s", szgroup); break; }
 
            if (setsockopt(pcon->isocket, SOL_IP, IP_ADD_MEMBERSHIP, &mreq, sizeof(mreq)) != 0 ) {
               perr("no default route to support multicast.");
               perr("try 'route add -net 224.000 netmask 240.000 eth0'");
               break;
            }
 
            #endif
         }

         // optional reverse proxy socket
         //    within psztarg: to reverse 3000
         if (strmatch(&pcur, "to reverse.", itoken, 1)) // TO reverse
         {
            int iport = atoi(pcur);
            if (iport < 1 || iport > 65535)
               { perr("invalid reverse port in %s",pdef->pszdef); exit(9); }
            while (isdigit(*pcur)) pcur++;
            while (isws(*pcur)) pcur++;

            Connection *pudp = pcon;

            ncon++;

            // add tcp accept socket
            pcon = &acon[ncon];

            pcon->icondef = i;
            pcon->itype   = eRevAccept;
            pcon->iport   = iport;
            pcon->isocket = socket(AF_INET, SOCK_STREAM, 0);
            if (pcon->isocket < 0)
               return 16;
            memset((char *)&saOwnAddr, 0,sizeof(saOwnAddr));
 
            saOwnAddr.sin_family      = AF_INET;
            saOwnAddr.sin_addr.s_addr = htonl(INADDR_ANY);
            saOwnAddr.sin_port        = htons(pcon->iport);
 
            int on = 1;
            setsockopt(pcon->isocket, SOL_SOCKET, SO_REUSEADDR, (const char *)&on, sizeof(on));
            on = 1;
            setsockopt(pcon->isocket, SOL_SOCKET, SO_REUSEPORT, (const char *)&on, sizeof(on));
 
            setNonblocking(pcon->isocket, true);
 
            if (bind(pcon->isocket, (struct sockaddr *)&saOwnAddr, sizeof(saOwnAddr)) != 0)
               return 17+perr("cannot bind on port %d. %s",pcon->iport,(pcon->iport<1024)?"(missing admin rights?)":"");
 
            if (listen(pcon->isocket, 50))
               return 18;
 
            if (!cs.quiet) {
               printf("Con #%d listens on udp '%s' %d target(s): %s\n",
                  ncon, szgroup, pudp->iport, pdef->psztarg);
 
               printf("Con #%d listens on tcp port %d for reverse connects\n",
                  ncon+1, pcon->iport);
            }

            ncon++;
         }
         else
         {
            if (!cs.quiet)
               printf("Con #%d listens on udp '%s' %d with target(s): \"%s\"\n",
                  ncon+1, szgroup, pcon->iport, pdef->psztarg);
            ncon++;
         }

         continue;
      }

      if (strmatch(&pcur, "reverse.", itoken, 1))
      {
         char szhost[100];
         szhost[0] = '\0';
         int iport = 0;

         char *pend=pcur;
         while (*pend!=0 && *pend!=':' && *pend!=' ')
            pend++;
         if (*pend!=0) {
            int ilen=pend-pcur;
            if (ilen+10>sizeof(szhost))
               return 19;
            memcpy(szhost,pcur,ilen);
            szhost[ilen]='\0';
            if (*pend==':') pend++;
            while (isws(*pend)) pend++;
            pcur=pend;
         }
         if (isdigit(*pcur)) {
            iport=atoi(pcur);
            while (isdigit(*pcur)) pcur++;
            while (isws(*pcur)) pcur++;
         }
         if (!pdef->psztarg)
            pdef->psztarg = pcur;

         strcopy(pdef->szfromip, szhost);
         pdef->ifromport=iport;

         // tcp client socket
         pcon->icondef = i;
         pcon->itype   = eRevGetPassive;
         pcon->iport   = iport;
         pcon->isocket = socket(AF_INET, SOCK_STREAM, 0);
         if (pcon->isocket < 0)
            return 20;
         pcon->ioutsocket = socket(AF_INET, SOCK_DGRAM, 0);
         if (pcon->ioutsocket < 0)
            return 21;

         // setNonblocking(pcon->isocket, true);

         /*
         struct hostent *ph = sfkhostbyname(szhost);
         if (!ph)
            return 22+perr("cannot get hostname: %s", szhost);
         memset(&outAddr, 0, (int)sizeof(outAddr));
         memcpy(&outAddr.sin_addr.s_addr, ph->h_addr, ph->h_length);
         outAddr.sin_family = AF_INET;
         outAddr.sin_port = htons(iport);

         // check NOW if connect works, else STOP.
         int rc = connect(pcon->isocket, (struct sockaddr *)&outAddr, sizeof(outAddr));
         if (rc)
            return 23+perr("connect failed to: %s:%d", szhost, iport);

         if (icldebug)
            printf("c#%04d > fcon s%03d revserver %s:%d errno=%d\n",
               ncon+1,pcon->isocket,szhost,iport,netErrno());
         */

         ncon++;

         continue;
      }
   }

   return 0;
}

int Proxy::step( )
{
   for (int icur=0; icur<ncon; icur++)
   {
      if (acon[icur].isocket <= 0)
         continue;

      Connection *pcur = &acon[icur];
      Connection *ppeer = 0;
      int icondef = acon[icur].icondef;
      IODef *pdef = &aiodef[icondef];
      int ipeer = pcur->ilink;
      if (ipeer >= 0 && ipeer < MAX_CONNECTIONS)
         ppeer = &acon[ipeer];
      int iverbose = pdef->iverbose;

      if ((pcur->itype == eTcpClient
           || pcur->itype == eTcpForward)
          && pcur->bconpend == 0
          && pcur->pdata != 0)
      {
         // send (part of) pending data
         uchar *pdata = pcur->pdata+pcur->ioffs;
         int    ndata = pcur->iremain;

         int n = 0;
         cchar *pextinf = "";

         #ifdef WITH_SSL
         if (pcur->pssock) {
            n = SSL_write(pcur->pssock, (char*)pdata, ndata);
            pextinf = "SSL ";
         } else
         #endif // WITH_SSL
            n = send(pcur->isocket, (char*)pdata, ndata, MSG_NOSIGNAL);

         if (n>0 && iverbose>0) {
            printf("c#%04d < send %d %s%serno=%d: \n",
               pcur->id,n,pextinf,(n<1)?"wouldblock ":"",netErrno());
            dumpData(pdata,ndata,icur,"   ");
         }

         if (n>0) {
            sentout(ipeer,n,(pcur->itype==eTcpClient)?'V':'A');
            pcur->ioffs += n;
            pcur->iremain -= n;
            if (pcur->iremain < 1) {
               delete [] pcur->pdata;
               pcur->pdata = 0;
            }
            if (pcur->iwebstate == 1)
               pcur->iwebstate = 2;
         } else {
            if (icldebug) {
               printf("send would block, waiting\n");
               doSleep(500);
            }
            doSleep(20);
         }

         // else wouldblock, try again later
         continue;
      }

      if (pcur->itype == eRevClient)
      {
         if (pcur->tlastio==0
             || getCurrentTime()-pcur->tlastio>=5000)
         {
            pcur->tlastio=getCurrentTime();

            // send keepalive
            uchar ablen[2];
            memset(ablen, 0, sizeof(ablen));
            int n = send(pcur->isocket,(char*)ablen,2,MSG_NOSIGNAL);
            if (n != 2)
               Proxy::closecon(icur,101);
         }
         continue;
      }

      if (pcur->itype == eRevGetConnected)
      {
         if (pcur->tlastio > 0
             && getCurrentTime()-pcur->tlastio>=10000)
         {
            // timeout
            if (icldebug)
               printf("c#%04d > timeout to revserver\n",ncon+1);
            closecon(icur,102);

            // back to passive
            pcur->isocket = socket(AF_INET, SOCK_STREAM, 0);
            if (pcur->isocket < 0)
               return 20;
            pcur->itype = eRevGetPassive;
         }
         continue;
      }

      if (pcur->itype == eRevGetPassive)
      {
         int icondef = pcur->icondef;
         if (icondef<0 || icondef>=MAX_CONDEF)
            continue;
         IODef *pdef=&aiodef[icondef];
 
         if (pcur->tlastcon==0
             || getCurrentTime()-pcur->tlastcon>=5000)
         {
            pcur->tlastcon=getCurrentTime();
 
            socklen_t fromlen;
            struct sockaddr_in outAddr;
            fromlen = (int)sizeof(outAddr);
 
            struct hostent *ph = sfkhostbyname(pdef->szfromip);
            if (!ph)
               return 22+perr("cannot get hostname: %s", pdef->szfromip);
 
            memset(&outAddr, 0, (int)sizeof(outAddr));
            memcpy(&outAddr.sin_addr.s_addr, ph->h_addr, ph->h_length);
            outAddr.sin_family = AF_INET;
            outAddr.sin_port = htons(pdef->ifromport);
 
            setNonblocking(pcur->isocket, true);
 
            // start connect
            int rc = connect(pcur->isocket, (struct sockaddr *)&outAddr, sizeof(outAddr));
 
            if (icldebug)
               printf("c#%04d > startcon s%03d revserver %s:%d errno=%d\n",
                  ncon+1,pcur->isocket,pdef->szfromip,pdef->ifromport,netErrno());
 
            pcur->itype = eRevGetPending;
            pcur->bconpend = 1;

            continue;
         }
      }
   }

   return 0;
}

int Proxy::run( )
{
   int rc = prepare();
   if (rc)
      return 9+perr("prepare failed, rc=%d\n", rc);

   int fd, i, s, icycle1=0,icycle2=0;

   struct sockaddr_in inAddr;
   memset(&inAddr, 0, (int)sizeof(inAddr));
   socklen_t fromlen = (int)sizeof(inAddr);

   fd_set fdread;
   fd_set fdwrite;
   fd_set fdexcept;
   int iMaxFD = -1;
   struct timeval tv;
   tv.tv_sec  = 0;
   tv.tv_usec = (uint32_t)5*1000 + 1000;

   while (1)
   {
      FD_ZERO(&fdread);
      FD_ZERO(&fdwrite);
      FD_ZERO(&fdexcept);

      iMaxFD = -1;
      for (int i=0; i<ncon; i++) {
         if (acon[i].isocket <= 0)
            continue;
         if (acon[i].itype == eRevGetPassive)
            continue;
         FD_SET(acon[i].isocket, &fdread);
         if (acon[i].bconpend)
         {
            FD_SET(acon[i].isocket, &fdwrite);
         }
         if (acon[i].isocket > iMaxFD)
            iMaxFD = acon[i].isocket;
      }

      rc = select(iMaxFD+1, &fdread, &fdwrite, &fdexcept, &tv);

      if (rc == 0) {
         doSleep(10); // avoid full cpu load
         if (((icycle1++) % 20) == 0)
            setInfoStatus();
         step();
         continue;
      }

      for (int i=0; i<ncon; i++) {
         if (acon[i].isocket <= 0)
            continue;
         if (acon[i].itype == eRevGetPassive)
            continue;
         s = acon[i].isocket;
         int iwhat=0;
         if (FD_ISSET(s, &fdread)) iwhat |= 1;
         if (FD_ISSET(s, &fdwrite)) iwhat |= 2;
         if (FD_ISSET(s, &fdexcept)) iwhat |= 4;
         if (iwhat)
         {
            // if (icldebug>=2) printf("process s=%d begin\n",s);
            rc = process(s,iwhat);
            // if (icldebug>=2) printf("process s=%d done\n",s);
            if (rc == 5)
               break;
         }
      }

      doYield();

      step();

      if (((icycle1++) % 20) == 0)
         setInfoStatus();
   }

   return 0;
}

void Proxy::updateStats( )
{
   iclopen=0;
   iclpend=0;
   iclwait=0;
   iclrevcon=0;
   for (int l=0; l<ncon; l++) {
      if (acon[l].pdata != 0) // yes, no matter if socket
         iclpend++;
      if (acon[l].isocket <= 0)
         continue;
      switch (acon[l].itype) {
         case eTcpClient:
         case eTcpForward:
         case eRevClient:
            iclopen++;
            break;
         case eRevGetConnected:
            iclrevcon++;
            break;
      }
      if (acon[l].bwait)
         iclwait++;
   }
}

int Proxy::numopen( ) { return iclopen; } // requires updateStats()
int Proxy::numpend( ) { return iclpend; }
int Proxy::numwait( ) { return iclwait; }

// in:  abClBuf1
// out: abClBuf1 (edited)
//      rc=bytes (edited)
//      szClOutHost, iClOutPort
//      rc = -3: unsupported CONNECT try to https
int Proxy::processHttpRequest(int bytes, int icon)
{
   char *psrccur = (char*)abClBuf1;
   char *psrcmax = psrccur+bytes;
   char *psrcnex = 0;
   char *pdstcur = (char*)abClBuf2;
   char *pdstmax = pdstcur+MAX_BUFFER;

   bool bfirst=true;
   while (1)
   {
      char *psrcnex = psrccur;
      while (*psrcnex!=0 && *psrcnex!='\r' && *psrcnex!='\n')
         psrcnex++;
      char *pprot = psrcnex; // just for first line
      if (*psrcnex=='\r') *psrcnex++='\0';
      if (*psrcnex=='\n') *psrcnex++='\0';

      if (bfirst)
      {
         bfirst=false;
         // rewrite GET line
         while (pprot>psrccur && mystrnicmp(pprot, " HTTP/", 6)!=0)
            pprot--;
         if (mystrnicmp(pprot, " HTTP/", 6)!=0)
            return -1;
         *pprot++ = '\0';
         // host:port/path is now zero terminated.
         char *pcmd = psrccur;
         char *ppath = pcmd;
         while (*ppath!=0 && *ppath!=' ') ppath++;
         if (*ppath) *ppath++ = '\0';
         while (*ppath!=0 && *ppath==' ') ppath++;
         // path now on http: or host or path
         bool bonhost=1;
         if (!mystrnicmp(ppath, "http://", 7))
            { ppath+=7; iClOutPort=80; }
         else
         if (!mystrnicmp(ppath, "https://", 8))
            { ppath+=8; iClOutPort=443; }
         else
         if (!strchr(ppath, ':')) // not CONNECT host:port
            bonhost=0;
         char *phost=szClOutHost;
         if (bonhost) {
            phost=ppath;
            while (*ppath!=0 && *ppath!=':' && *ppath!='/') ppath++;
            int ilen=ppath-phost;
            if (ilen+4 > sizeof(szClOutHost)) return -2;
            memcpy(szClOutHost,phost,ilen);
            szClOutHost[ilen]='\0';
            if (*ppath==':') {
               ppath++;
               iClOutPort=atoi(ppath);
               while (*ppath!=0 && isdigit(*ppath)) ppath++;
            }
            // NOTE: this happens on CONNECT when client tries to build
            // https connection. we cannot handle CONNECT at all, therefore stop here.
            if (*ppath!='/') return -3;
            // TODO: on CONNECT, open tcp connection but send no request.
            //       then send to client: HTTP/1.1 200 Connection Established
            bonhost=0;
         }
         // rebuild GET line
         if (mystrnicmp(pcmd, "CONNECT", 7)) {
            // make GET/POST/DEL /path HTTP/1.1
            snprintf(pdstcur, MAX_BUFFER, "%s %s %s\r\n", pcmd, ppath, pprot);
         } else {
            // make CONNECT host:port HTTP/1.1
            snprintf(pdstcur, MAX_BUFFER, "%s %s %s\r\n", pcmd, phost, pprot);
         }
         pdstcur += strlen(pdstcur);
      }
      else do
      {
         // header line. relevant is:
         //    Host: foo.com
         if (!mystrnicmp(psrccur, "host:", 5)) {
            // no matter what client sends, replace it by sane target host
            if (pdstcur+strlen(szClOutHost)+10 > pdstmax) return -4;
            // NEVER write port in the host header
            sprintf(pdstcur, "Host: %s\r\n", szClOutHost);
            if (icldebug)
               printf("EDIT-Host: %s\n", szClOutHost);
            pdstcur += strlen(pdstcur);
            break;
         }
         #ifdef WITH_SSL
         else
         if (acon[icon].bssl && mystrstri(psrccur, "secur"))
            break; // skip header
         #endif // WITH_SSL

         if (pdstcur + strlen(psrccur) + 4 > pdstmax) return -5;
         sprintf(pdstcur, "%s\r\n", psrccur);
         pdstcur += strlen(pdstcur);
      }
      while (0);

      if (*psrcnex==0)
         return -6;

      if (*psrcnex!='\r' && *psrcnex!='\n') {
         psrccur = psrcnex;
         continue;
      }

      // end of header reached, POST payload may follow
      int ilen=psrcmax-psrcnex;
      if (pdstcur+ilen > pdstmax) return -7;
      memcpy(pdstcur, psrcnex, ilen);
      pdstcur += ilen;
      *pdstcur='\0';

      int irc = pdstcur-(char*)abClBuf2;

      if (icldebug) {
         int i=0;
         while (abClBuf2[i]!=0 && abClBuf2[i]!='\r' && abClBuf2[i]!='\n') i++;
         printf("EDIT-Reqs: %04d %.*s\n",irc,i,(char*)abClBuf2);
      }

      memcpy(abClBuf1, abClBuf2, irc);
      abClBuf1[irc] = '\0';

      return irc;
   }

   return 0;
}

int Proxy::processHttpReply(int bytes, int icon)
{
   int icondef = acon[icon].icondef;
   if (icondef<0 || icondef>=MAX_CONDEF)
      return -1+perr("invalid condef");

   char *psrccur = (char*)abClBuf1;
   char *psrcmax = psrccur+bytes;
   char *psrcnex = 0;
   char *pdstcur = (char*)abClBuf2;
   char *pdstmax = pdstcur+MAX_BUFFER;

   bool bfirst=true;
   while (1)
   {
      char *psrcnex = psrccur;
      while (*psrcnex!=0 && *psrcnex!='\r' && *psrcnex!='\n')
         psrcnex++;
      char *pprot = psrcnex; // just for first line
      if (*psrcnex=='\r') *psrcnex++='\0';
      if (*psrcnex=='\n') *psrcnex++='\0';

      if (bfirst)
      {
         bfirst=false;
         // HTTP/1.1 200 OK
         if (pdstcur + strlen(psrccur) + 4 > pdstmax) return -5;
         sprintf(pdstcur, "%s\r\n", psrccur);
         pdstcur += strlen(pdstcur);
      }
      else do
      {
         // reply header line
         #ifdef WITH_SSL
         // experimental
         if (aiodef[icondef].btossl) {
            #if 0
            if (mystrstri(psrccur, "secur")
                || mystrstri(psrccur, "frame-options")
                || mystrstri(psrccur, "protection")
                || mystrstri(psrccur, "varnish")
                || mystrstri(psrccur, "x-content")
                || mystrstri(psrccur, "cache-control")
               )
            {
               if (icldebug)
                  printf("DROP: %s\n", psrccur);
               break;
            }
            #endif
         }
         #endif // WITH_SSL
         // pass-thru all other
         if (pdstcur + strlen(psrccur) + 4 > pdstmax) return -5;
         sprintf(pdstcur, "%s\r\n", psrccur);
         pdstcur += strlen(pdstcur);
      }
      while (0);

      if (*psrcnex==0)
         return -6;

      if (*psrcnex!='\r' && *psrcnex!='\n') {
         psrccur = psrcnex;
         continue;
      }

      // end of header reached, payload follows
      int ilen=psrcmax-psrcnex;
      if (pdstcur+ilen > pdstmax) return -7;
      memcpy(pdstcur, psrcnex, ilen);
      pdstcur += ilen;
      *pdstcur='\0';

      int irc = pdstcur-(char*)abClBuf2;

      if (icldebug) {
         int i=0;
         while (abClBuf2[i]!=0 && abClBuf2[i]!='\r' && abClBuf2[i]!='\n') i++;
         printf("\nEDIT-Rep: %04d %.*s\n",irc,i,(char*)abClBuf2);
      }

      memcpy(abClBuf1, abClBuf2, irc);
      abClBuf1[irc] = '\0';

      return irc;
   }

   return 0;
}

void Proxy::closecon(int i, int ifrom)
{
   #ifdef WITH_SSL
   if (acon[i].pssock)
      SSL_free(acon[i].pssock);
   if (acon[i].psctx)
      SSL_CTX_free(acon[i].psctx);
   #endif // WITH_SSL

   int s = acon[i].isocket;
   int n = numopen();

   if (acon[i].isocket > 0)
      closesocket(acon[i].isocket); // clear done below

   if (acon[i].ioutsocket > 0)
      closesocket(acon[i].ioutsocket); // clear done below

   if (acon[i].pdata)
      delete [] acon[i].pdata;

   memset(&acon[i], 0, sizeof(acon[i]));

   updateStats();

   if (icldebug)
      printf("c#%04d - clsd s%03d. open=%d pend=%d wait=%d. from=%d\n",
         acon[i].id, s, numopen(), numpend(), numwait(), ifrom);
}

void Proxy::closeall(int i, int ifrom)
{
   int ilink = acon[i].ilink;
   if (ilink >= 0 && ilink < MAX_CONNECTIONS)
      closecon(ilink, ifrom);
   closecon(i, ifrom);
}

#ifdef WITH_SSL

int Proxy::sslconnect(int i)
{__
   prepareSSL();

   // ssl.step.2 up-to-date client methods
   acon[i].psctx = SSL_CTX_new(TLS_client_method());

   if (!acon[i].psctx)
   {
      perr("SSLContext init failed\n");
      return 9;
   }

   if (!(acon[i].pssock = SSL_new(acon[i].psctx)))
   {
      perr("SSLSocket creation failed\n");
      return 10;
   }

   if (icldebug)
   {
      if (icldebug>=2)
         SSL_set_msg_callback(acon[i].pssock, my_SSL_trace);
      SSL_CTX_set_info_callback(acon[i].psctx, apps_ssl_info_callback);
   }

   if (icldebug)
      printf("SSL: set s%d for ssock=%p\n",acon[i].isocket,acon[i].pssock);
   SSL_set_fd(acon[i].pssock, acon[i].isocket);

   // ssl.step.3 set tls hostname
   bool ballnum=1;
   char *psz=acon[i].szouthost;
   for (int k=0;psz[k];k++) {
      if (isdigit(psz[k])) continue;
      if (psz[k]=='.') continue;
      ballnum=0; break;
   }
   if (!ballnum) {
      if (!SSL_set_tlsext_host_name(acon[i].pssock, acon[i].szouthost))
      {
         perr("Unable to set TLS servername extension.\n");
         return 11;
      }
      if (icldebug)
         printf("SSL: set tls host: %s\n", acon[i].szouthost);
   }

   int iErrCode = SSL_connect(acon[i].pssock);
   if (iErrCode < 0) {
      int isuberr = SSL_get_error(acon[i].pssock, iErrCode);
      perr("SSLConnect failed rc=%d/%d\n", iErrCode, isuberr);
      #ifdef WITH_VERBOSE_SSL // may cause link errors
      if (iclverbose)
         ERR_print_errors_fp(stdout);
      #endif
      return 12;
   }

   const char *pszSSLVersion = SSL_get_version(acon[i].pssock);
   if (!pszSSLVersion) pszSSLVersion = "unknown-ssl";

   if (icldebug)
      printf("SSL: %s connect done to %s\n", pszSSLVersion, acon[i].szouthost);

   return 0;

}

int Proxy::sslaccept(int i)
{__
   prepareSSL();

   acon[i].psctx = SSL_CTX_new(TLS_server_method());
   if (!acon[i].psctx)
   {
      perr("SSLContext init failed\n");
      return 9;
   }

   if (!(acon[i].pssock = SSL_new(acon[i].psctx)))
   {
      perr("SSLSocket creation failed\n");
      return 10;
   }

   if (icldebug)
   {
      if (icldebug>=2)
         SSL_set_msg_callback(acon[i].pssock, my_SSL_trace);
      SSL_CTX_set_info_callback(acon[i].psctx, apps_ssl_info_callback);
   }

   if (icldebug)
      printf("SSL: set s%d for ssock=%p\n",acon[i].isocket,acon[i].pssock);
   SSL_set_fd(acon[i].pssock, acon[i].isocket);

   int iErrCode = SSL_accept(acon[i].pssock);

   if (iErrCode <= 0) {
      int isuberr = SSL_get_error(acon[i].pssock, iErrCode);
      perr("SSLAccept failed rc=%d/%d\n", iErrCode, isuberr);
      #ifdef WITH_VERBOSE_SSL // may cause link errors
      if (iclverbose)
         ERR_print_errors_fp(stdout);
      #endif
      return 12;
   }

   const char *pszSSLVersion = SSL_get_version(acon[i].pssock);
   if (!pszSSLVersion) pszSSLVersion = "unknown-ssl";

   if (icldebug)
      printf("SSL: %s accept done\n", pszSSLVersion);

   return 0;
}

#endif // WITH_SSL

int Proxy::getipandport(char **ppsz)
{
   char *psz=*ppsz;

   char *pcur=psz;
   char *pend=pcur;
   while (*pend!=0 && *pend!=':' && *pend!=' ') pend++;
   if (!*pend)
      return 9+perr("invalid ip:port: '%s'",psz);
   int ilen=pend-pcur;
   if (ilen+4>sizeof(szClOutHost))
      return 9+perr("invalid ip:port: '%s'",psz);
   memcpy(szClOutHost,pcur,ilen);
   szClOutHost[ilen]='\0';
   pcur=pend;
   while (*pcur!=0 && (*pcur==':' || isws(*pcur)!=0)) pcur++;
   iClOutPort=atoi(pcur);
   if (!iClOutPort)
      return 9+perr("invalid ip:port: '%s'",psz);

   while (isdigit(*pcur)) pcur++;
   while (isws(*pcur)) pcur++;
 
   *ppsz=pcur;

   return 0;
}

uint IPFromString(char *psz) {
   uint n=0;
   while (*psz) {
      n <<= 8;
      n |= atoi(psz);
      while (*psz!=0 && *psz!='.') psz++;
      if (*psz=='.') psz++;
   }
   return n;
}

int Proxy::newcon(int bWithNewID)
{__
   int k=0;
   for (; k<MAX_CONNECTIONS; k++)
      if (acon[k].isocket <= 0)
         break;
   if (k >= MAX_CONNECTIONS)
      return -1+perr("Connection overflow\n");
   memset(&acon[k], 0, sizeof(acon[k]));
   if (bWithNewID)
      acon[k].id = ++inextconid; // may be changed
   if (ncon < k+1)
      ncon = k+1;
   return k;
}

int Proxy::setAddr(struct sockaddr_in *pAddr,
   char *pszHost, int iPort)
{
   if (!pszHost || !strlen(pszHost))
      return 12+perr("empty hostname on setAddr");
   struct hostent *ph = sfkhostbyname(pszHost);
   if (!ph)
      return 11+perr("cannot get hostname: %s", pszHost);
   memset(pAddr, 0, (int)sizeof(struct sockaddr_in));
   pAddr->sin_family = AF_INET;
   memcpy(&pAddr->sin_addr.s_addr, ph->h_addr, ph->h_length);
   pAddr->sin_port = htons(iPort);
   return 0;
}

int Proxy::call(int icur, char *szlabel, uchar **ppdata, int *pndata,
   uint &nFromAddr, uint &nFromPort
   )
{__
   uchar *pData = *ppdata;
   int nData = *pndata;

   char szaddr[100],szport[100],sztoport[100];

   Connection *pcur = &acon[icur];
   int icondef = acon[icur].icondef;
   IODef *pdef = &aiodef[icondef];

   // --- proxy call label begin ---
   num tstart=getCurrentTime();
   char *pScript = strdup(pGlblCurrentScript);
   if (!pScript)
      return 31+perr("outofmem on call %s",szlabel);
   // input data
   sprintf(szaddr, "%u.%u.%u.%u",
      (nFromAddr>>24)&0xFFU,(nFromAddr>>16)&0xFFU,
      (nFromAddr>> 8)&0xFFU,(nFromAddr>> 0)&0xFFU);
   sprintf(szport, "%u", nFromPort);
   sfksetvar(str("fromip"),(uchar*)szaddr,strlen(szaddr));
   sfksetvar(str("fromport"),(uchar*)szport,strlen(szport));
   sfksetvar(str("toip"),(uchar*)pdef->sztoip,strlen(pdef->sztoip));
   sprintf(sztoport,"%u",pdef->itoport);
   sfksetvar(str("toport"),(uchar*)sztoport,strlen(sztoport));
   sfksetvar(str("data"),pData,nData);
   // iLocalParm==-1 will ignore argc, argv
   int lRC=0; bool bFatal=0;
   int iExecRC = callLabel(pScript, 0, 0, pclenv, // proxy
         szlabel, -1, 0, lRC, bFatal);
   delete [] pScript; // was modified with zero terms
   if (iExecRC) // fatal errors that stop chaining
      return iExecRC;
   if (lRC >= 9) return lRC;
   // output data
   int    nOutLen = 0;
   uchar *pOutData = sfkgetvar(str("data"),&nOutLen);
   if (pOutData) {
      pData=pOutData;
      nData=nOutLen; // can be NULL length to drop packet
   }
   char *fromip2 = (char*)sfkgetvar(str("fromip"),&nOutLen);
   if (fromip2 && strcmp(fromip2,szaddr))
      nFromAddr = IPFromString(fromip2);
   char *fromport2 = (char*)sfkgetvar(str("fromport"),&nOutLen);
   if (fromport2 && strcmp(fromport2,szport))
      nFromPort = atoi(fromport2);
   // call done
   int ielapsed=(int)(getCurrentTime()-tstart);
   if (icldebug>0 && ielapsed>0)
      printf("call %s done in %d msec\n",szlabel,ielapsed);
   // --- proxy call label end ---

   *ppdata = pData;
   *pndata = nData;

   return 0;
}

char *Proxy::conState( )
{
   int iout=0,icur=0;

   if (bcongraph)
   {
      for (icur=0; icur<ncon; icur++)
      {
         if (acon[icur].isocket <= 0)
            continue;
         switch (acon[icur].itype) {
            case eTcpClient:
            case eTcpForward:
            case eRevClient:
               break;
            default:
               // e.g. accept socket
               continue;
         }
         char cstate = acon[icur].cstate;
         if (cstate == 0)
              cstate = '0'+acon[icur].itype;
         szClConState[iout++] = cstate;
 
         if (iout >= MAX_CONSTATEINFO)
            break;
      }
      szClConState[iout++] = ' ';
   }

   szClConState[iout] = '\0';
   return szClConState;
}

int Proxy::process(int scur, int iwhat)
{__
   int fd, rc, itoken;
   struct sockaddr_in inAddr, outAddr;
   socklen_t fromlen = (int)sizeof(inAddr);
   char szlabel[100],szaddr[100],szport[100];

   int bReadEvent = (iwhat&1) ? 1 : 0;
   int bWriteEvent = (iwhat&2) ? 1 : 0;
   int bExceptEvent = (iwhat&4) ? 1 : 0;

   int icur=0,icln=0,ipeer=0;

   if (scur <= 0) return 9;

   for (icur=0; icur<ncon; icur++)
   {
      if (acon[icur].isocket != scur)
         continue;

      Connection *pcur = &acon[icur];
      int icondef = acon[icur].icondef;
      IODef *pdef = &aiodef[icondef];

      int ipeer = pcur->ilink;
      if (ipeer < 0 || ipeer >= MAX_CONNECTIONS)
          ipeer = -1;
      int npeerremain = 0;
      if (ipeer >= 0)
          npeerremain = acon[ipeer].iremain;

      int iverbose = pdef->iverbose;
      static int icnt = 0;

      if (icldebug>=2)
         printf("process s=%d type=%d what=%u conpend=%d premain=%u - %u\n",
            scur,acon[icur].itype,iwhat,acon[icur].bconpend,npeerremain,icnt++);

      if (pcur->itype == eTcpAccept
          || pcur->itype == eRevAccept)
      {
         // accept incoming back connection
         memset(&inAddr, 0, (int)sizeof(inAddr));
         int fd = accept(scur, (struct sockaddr *)&inAddr, &fromlen);
         if (fd <= 0)
            return 9+perr("Failed to accept socket errno=%u '%s'\n", errno, strerror(errno));
         int icln = newcon(1);
         if (icln<0) return 10;
         acon[icln].icondef = icondef;
         if (pcur->itype == eTcpAccept)
            acon[icln].itype   = eTcpClient;
         else
            acon[icln].itype   = eRevClient;
         acon[icln].isocket = fd;
         acon[icln].ilink   = -1; // done on first message
         acon[icln].bwait   = 0;
         acon[icln].inip    = ntohl(inAddr.sin_addr.s_addr);
         acon[icln].inport  = pdef->ifromport;
         acon[icln].iport   = pcur->iport; // just to match it later [20210729]
         acon[icln].cstate  = '.';
         if (icldebug)
            printf("c#%04d > acp %s s%03d -> s%03d ncon=%d idef=%d iwhat=%d\n",
               acon[icln].id,ipAsString(acon[icln].inip,acon[icln].inport),
               scur,fd,ncon,icondef,iwhat);

         #ifdef WITH_SSL
         if (pdef->bfromssl) {
            acon[icln].bssl = 1;
            setNonblocking(fd,false);
            if (sslaccept(icln))
               return 9;
         }
         #endif // WITH_SSL

         if (pdef->iwebmode)
         {
            // http: first message is always from back
            //    and may contain the target to connect to.
            acon[icln].iwebstate = 1;
            return 5;
         }

         // plain tcp: instant connect to front,
         //    because first message may be sent by front.
         if (pcur->itype == eTcpAccept // sfk1982
             && pdef->psztarg && strlen(pdef->psztarg)
             && pdef->sztoip && strlen(pdef->sztoip)) // sfk1982
         {
            char *pOutHost = pdef->sztoip;
            int   iOutPort = pdef->itoport;
            if (setAddr(&outAddr,pOutHost,iOutPort))
               return 11;

            // !!! ipeer is changed !!!

            ipeer = newcon(0);

            if (ipeer<0) return 10;

            int fdpeer = socket(AF_INET, SOCK_STREAM, 0);
            if (fdpeer < 0)
               return 10+perr("out of sockets\n");
            setNonblocking(fdpeer, true);

            int rc = connect(fdpeer, (struct sockaddr *)&outAddr, sizeof(outAddr));
            if (iverbose>=2)
               printf("c#%04d > fcon s%03d target %s:%d erno=%d.\n",
                  pcur->id,fdpeer,pOutHost,iOutPort,netErrno());

            // add forward connection
            acon[ipeer].id      = pcur->id;
            acon[ipeer].icondef = icondef;
            acon[ipeer].itype   = eTcpForward;
            acon[ipeer].isocket = fdpeer;
            acon[ipeer].ilink   = icln;
            acon[ipeer].bwait   = 0;
            #ifdef WITH_SSL
            strcopy(acon[ipeer].szouthost, pOutHost);
            acon[ipeer].ioutport = iOutPort;
            if (aiodef[icondef].btossl) {
               acon[ipeer].bssl = 1;
               setNonblocking(fdpeer, false);
            }
            #endif // WITH_SSL
            acon[icln].ilink = ipeer;
            acon[ipeer].tlastio = getCurrentTime();
            // WAIT for connect confirm.
         }
         return 5;
      }

      if (pcur->itype == eTcpForward && pcur->bconpend == 1)
      {
         // connect confirmed
         if (icldebug)
            printf("fw.con.confirmed\n");
         #ifdef WITH_SSL
         if (pcur->bssl) {
            setNonblocking(scur,false);
            if (sslconnect(icur))
               return 9;
         }
         #endif // WITH_SSL
         pcur->bconpend = 0;
         // may send pending data now, in step()
         return 0;
      }

      if ((pcur->itype == eTcpClient || pcur->itype == eTcpForward)
          && bExceptEvent == 1)
      {
         if (!cs.quiet)
            printf("except/close on s=%d\n",scur);
         closeall(icur, 100);
         return 5;
      }

      if (pcur->itype == eTcpClient && bReadEvent == 1)
      do
      {
         // printf("c#%04d - read event\n",pcur->id);

         if (ipeer >= 0 && acon[ipeer].pdata != 0) {
            if (icldebug)
               printf("c#%04d - peer would block (%d)\n",
                  pcur->id, acon[ipeer].iremain);
            doSleep(20);
            return 0;
         }

         // read message from back
         int bytes = 0;
         #ifdef WITH_SSL
         if (pcur->pssock)
            bytes = SSL_read(pcur->pssock, (char*)abClBuf1, MAX_BUFFER);
         else
         #endif // WITH_SSL
            bytes = (int)recv(scur, (char*)abClBuf1, MAX_BUFFER, 0);
         if (wouldBlock(bytes)) {
            if (icldebug) {
               printf("c#%04d - would block\n",pcur->id);
               doSleep(500);
            }
            doSleep(20);
            return 0; // avoid further action below
         }
         if (bytes <= 0) {
            if (icldebug)
               printf("c#%04d - closing\n",pcur->id);
            closeall(icur, 301);
            return 5;
         }
         abClBuf1[bytes] = '\0';
         gotin(icur,bytes,'a');

         // forward at all?
         if (!pdef->psztarg || !strlen(pdef->psztarg)) {
            if (iverbose) {
               printf("c#%04d > tcp %s b=%04d. no target, closing connection.\n",
                  pcur->id,ipAsString(pcur->inip,pcur->inport),bytes);
               dumpData(abClBuf1,bytes,icur,"   ");
            }
            closeall(icur, 302);
            return 5;
         }

         // set default target host, if any.
         // - http req edit may take over this host
         // - or szClOutHost may be changed by proxy header
         strcopy(szClOutHost,pdef->sztoip);
         iClOutPort = pdef->itoport;
         if (pcur->iwebstate) {
            // pcur->iwebstate = 2;
            if (iverbose) {
               printf("c#%04d > tcp %s b=%04d. processing request.\n",
                  pcur->id,ipAsString(pcur->inip,pcur->inport),bytes);
               dumpData(abClBuf1,bytes,icur,"   ");
            }
            bytes = processHttpRequest(bytes, icur); // reqfromback.first
            if (bytes <= 0) {
               if (bytes == -3)
                  printf("ERROR: unsupported HTTPS Connect request from s=%d\n",scur);
               else
                  printf("ERROR: header error %d from s=%d\n",bytes,scur);
               closeall(icur, 5);
               return 5;
            }
         }

         uchar *pData = abClBuf1;
         int    nData = bytes;
         uint   nFromAddr=0, nFromPort=0;

         char *pszcur = pdef->psztarg;
         if (strmatch(&pszcur, "call ", itoken, 1))
         {
            char *plabel = pszcur;
            while (*pszcur && !isws(*pszcur)) pszcur++;
            int ilen=pszcur-plabel;
            if (ilen<1 || ilen+4 >= sizeof(szlabel))
               return 30+perr("invalid label name: %s",plabel);
            memcpy(szlabel,plabel,ilen);
            szlabel[ilen]='\0';
            while (isws(*pszcur,1)) pszcur++;

            call(icur, szlabel, &pData, &nData, nFromAddr, nFromPort);
            // pData may have changed
         }

         rc = 0;

         // forward-connect now? (http)
         if (ipeer == -1)
         {
            // define front
            char *pOutHost = pdef->sztoip;
            int   iOutPort = pdef->itoport;
            if (szClOutHost[0]) pOutHost = szClOutHost;
            if (iClOutPort) iOutPort = iClOutPort;
            if (setAddr(&outAddr,pOutHost,iOutPort))
               return 11+perr("cannot forward-connect to: %s port %d",pOutHost,iOutPort);
 
            // connect to front
            int fdpeer = socket(AF_INET, SOCK_STREAM, 0);
            if (fdpeer < 0)
               return 10+perr("out of sockets\n");
            setNonblocking(fdpeer, true);

            // !!! ipeer is now changed !!!
 
            ipeer = newcon(0);

            if (ipeer<0) return 11;
 
            connect(fdpeer, (struct sockaddr *)&outAddr, sizeof(outAddr));
            // must be wouldblock
            if (iverbose>=2) {
               printf("c#%04d > fcon s%03d target %s:%d erno=%d. store %d bytes:\n",
                  pcur->id,fdpeer,pOutHost,iOutPort,netErrno(),nData);
               dumpData(pData,nData,ipeer," - ");
            }
            // add forward connection
            acon[ipeer].id      = pcur->id;
            acon[ipeer].icondef = icondef;
            acon[ipeer].itype   = eTcpForward;
            acon[ipeer].isocket = fdpeer;
            acon[ipeer].ilink   = icur;
            acon[ipeer].bwait   = 0;
            acon[ipeer].bconpend = 1;
            acon[ipeer].iwebstate = 1;
            strcopy(acon[ipeer].szouthost, pOutHost);
            acon[ipeer].ioutport = iOutPort;
            acon[ipeer].cstate  = 'c';
            #ifdef WITH_SSL
            if (pdef->btossl) {
               acon[ipeer].bssl = 1;
               setNonblocking(fdpeer, false);
            }
            #endif // WITH_SSL
            // forward-connection links to backcon.
            // backcon links to forward-connection:
            pcur->ilink = ipeer;
            acon[ipeer].tlastio = pcur->tlastio = getCurrentTime();

            rc = 5;
         }

         // store data as PENDING FOR SEND.
         acon[ipeer].pdata = new uint8_t[nData+4];
         if (acon[ipeer].pdata == 0)
            return 12+perr("outofmem\n");
         memcpy(acon[ipeer].pdata, pData, nData);
         acon[ipeer].pdata[nData] = '\0';
         acon[ipeer].ioffs = 0;
         acon[ipeer].iremain = nData;

         return rc;
      }
      while (0);

      if (pcur->itype == eTcpClient || acon[icur].itype == eTcpForward)
      {
         // 2nd ff message from back or front.
         // there must be a linked connection.
         if (ipeer == -1)
            return 12+perr("missing linked connection\n");

         if (ipeer >= 0 && acon[ipeer].pdata != 0) {
            if (icldebug)
               printf("c#%04d - peer would block (%d)\n",
                  pcur->id, acon[ipeer].iremain);
            doSleep(20);
            return 0;
         }

         int fdpeer = acon[ipeer].isocket;
         if (fdpeer <= 0) {
            perr("invalid linked connection\n");
            return 13;
         }
         // receive from back OR front
         if (icldebug>=2) printf("proc.read.begin s=%d\n",scur);
         int bytes = 0;
         #ifdef WITH_SSL
         if (pcur->pssock)
            bytes = SSL_read(pcur->pssock, (char*)abClBuf1, MAX_BUFFER);
         else
         #endif // WITH_SSL
            bytes = (int)recv(scur, (char*)abClBuf1, MAX_BUFFER, 0);
         if (wouldBlock(bytes))
            return 0;
         if (bytes <= 0) {
            closeall(icur,10);
            return 5;
         }
         abClBuf1[bytes] = '\0';
         gotin(icur,bytes,(pcur->itype==eTcpClient)?'a':'v');

         if (pcur->itype == eTcpClient
             && pcur->iwebstate > 0) {
            // http request from back to front
            strcopy(szClOutHost,pdef->sztoip);
            iClOutPort = pdef->itoport;
            bytes = processHttpRequest(bytes, icur); // reqfromback.next
         }

         uchar *pData = abClBuf1;
         int    nData = bytes;
         uint   nFromAddr=0, nFromPort=0;

         char *pszcur = pdef->psztarg;
         if (strmatch(&pszcur, "call ", itoken, 1))
         {
            char *plabel = pszcur;
            while (*pszcur && !isws(*pszcur)) pszcur++;
            int ilen=pszcur-plabel;
            if (ilen<1 || ilen+4 >= sizeof(szlabel))
               return 30+perr("invalid label name: %s",plabel);
            memcpy(szlabel,plabel,ilen);
            szlabel[ilen]='\0';
            while (isws(*pszcur,1)) pszcur++;

            call(icur, szlabel, &pData, &nData, nFromAddr, nFromPort);
            // pData may have changed
         }

         int itodump=0;
         if (acon[ipeer].itype == eTcpForward) {
            // send to front
            acon[ipeer].bwait = 1;
            updateStats();
            if (iverbose)
               printf("c#%04d > send %05d bytes s%03d -> s%03d. open=%d pend=%d wait=%d\n",
                  acon[ipeer].id, nData, scur, fdpeer, numopen(), numpend(), numwait());
            itodump=ipeer;
            if (iverbose)
               dumpData(pData,nData,itodump,"   ");
         } else {
            // send to back
            pcur->bwait = 0;
            acon[ipeer].bwait = 0;
            updateStats();
            if (iverbose) {
               cchar *pextinf = "";
               #ifdef WITH_SSL
               if (pcur->pssock) pextinf=":SSL";
               #endif // WITH_SSL
               printf("c#%04d > recv %05d bytes s%03d%s -> s%03d. open=%d pend=%d wait=%d\n",
                  acon[ipeer].id, nData, scur, pextinf,
                  fdpeer, numopen(), numpend(), numwait());
            }
            itodump=icur;
            if (iverbose)
               dumpData(pData,nData,itodump,"   ");
         }

         // store data as PENDING FOR SEND.
         acon[ipeer].pdata = new uint8_t[nData+4];
         if (acon[ipeer].pdata == 0)
            return 12+perr("outofmem\n");
         memcpy(acon[ipeer].pdata, pData, nData);
         acon[ipeer].pdata[nData] = '\0';
         acon[ipeer].ioffs = 0;
         acon[ipeer].iremain = nData;

         if (icldebug>=2) printf("proc.read.done s=%d store %d bytes\n",scur,nData);

         return 0;
      }

      // --------------------- UDP --------------------

      if (pcur->itype == eUdpListen || pcur->itype == eRevGetConnected)
      {
         // receive udp or revserver udp
         struct sockaddr_in inAddr;
         socklen_t nadrlen = sizeof(inAddr);
         memset(&inAddr,0,sizeof(inAddr));
         int bytes=0;
         int bkeepalive=0;
         if (pcur->itype == eRevGetConnected) {
            uchar ablen[2];
            // for now, do a BLOCKING READ LOOP. [20210729]
            // proxy.todo: read timeout
            bytes=0;
            int iremain=2;
            while (iremain > 0) {
               int ipart = recv(scur, (char*)ablen+bytes, iremain, 0);
               if (bytes==0 && wouldBlock(ipart)==1)
                  return 0;
               if (ipart>0) {
                  bytes+=ipart;
                  iremain-=ipart;
               }
               if (iremain > 0)
                  doSleep(10);
            }
            uint nLen = ((uint)ablen[0]) << 8;
            nLen |= (uint)ablen[1];
            if (bytes==0) {
               gotin(icur,bytes);
               return 0; // keepalive
            }
            if (bytes<2) {
               perr("no data from reverse connection: bytes=%d err=%d %s", bytes, netErrno(), netErrStr());
               closeall(icur, 20);
               return 5;
            }
            if (nLen>MAX_BUFFER) {
               perr("invalid length from reverse connection: %02x %02x", ablen[0], ablen[1]);
               closeall(icur, 20);
               return 5;
            }
            // for now, do a BLOCKING READ LOOP.
            // proxy.todo: read timeout
            bytes=0;
            iremain=nLen;
            while (iremain > 0) {
               int ipart = (int)recv(scur, (char*)abClBuf1+bytes, iremain, 0);
               if (ipart > 0) {
                  bytes   += ipart;
                  iremain -= ipart;
               }
               if (iremain > 0)
                  doSleep(10);
            }
            abClBuf1[bytes] = '\0';
            if (bytes==0)
               bkeepalive=1;
            else
               gotin(icur,bytes);
         } else {
            bytes = recvfrom(scur, (char*)abClBuf1, MAX_BUFFER, 0, (struct sockaddr *)&inAddr, &nadrlen);
            if (wouldBlock(bytes))
               return 0;
            if (bytes <= 0) {
               // close own
               closeall(icur, 303);
               return 5;
            }
            abClBuf1[bytes] = '\0';
            gotin(icur,bytes);
         }

         // source ip prefix handling
         uchar *pData  = abClBuf1;
         int    nData  = bytes;
         int    nRead  = bytes;
         uchar *pData2 = abClBuf2;
         int    nData2 = bytes;
         uint   nSrcAddr = 0;
         uint   nSrcPort = 0;
         uint  nFromAddr = htonl(inAddr.sin_addr.s_addr);
         uint  nFromPort = htons(inAddr.sin_port);

         // if (pcur->itype == eUdpListen)
         //      nFromPort = pcur->iport;

         int iPrefixMode = pdef->iprefix;
         memset(abClBuf2, 0, nData2);

         // read prefix if present
         if (   nData >= 14
             && memcmp(pData, "SFK\0FW4", 7) == 0
            )
         {
            uint nHeader = pData[7];
            if (nHeader >= 6) {
               nSrcAddr =     (((uint)pData[8])  << 24)
                           |  (((uint)pData[9])  << 16)
                           |  (((uint)pData[10]) <<  8)
                           |  (((uint)pData[11]) <<  0);
               nSrcPort =     (((uint)pData[12]) <<  8)
                           |  (((uint)pData[13]) <<  0);
               nFromAddr = nSrcAddr;
               nFromPort = nSrcPort;
            }
            if (iPrefixMode == 0) {
               // drop prefix in source
               uint  nhead = 8+nHeader;
               uchar *psrc = pData+nhead;
               uchar *pmax = pData+nRead;
               uchar *pdst = pData;
               uint  ncopy = nRead-nhead;
               if (psrc+ncopy <= pmax)
               {
                  memmove(pdst,psrc,ncopy);
                  nRead -= nhead;
                  nData -= nhead;
               }
            }
         }

         if (iverbose && !bkeepalive) {
            printf("c#%04d > udp %s b=%04d:\n",
               pcur->id,ipAsString(nFromAddr,nFromPort),bytes);
            int ntodump=bytes;
            if (cs.maxdump) ntodump = mymin(cs.maxdump,ntodump);
            termHexdump(abClBuf1,ntodump);
         }

         // for prefixed output
         memcpy(abClBuf2, abClBuf1, nData);
         nData2 = nData;

         bool bDonePrefix = 0;

         // send udp to all given targets
         char *pszcur = pdef->psztarg;
         while (*pszcur)
         {
            // packet filter, dump, or edit
            if (strmatch(&pszcur, "call ", itoken, 1))
            {
               char *plabel = pszcur;
               while (*pszcur && !isws(*pszcur)) pszcur++;
               int ilen=pszcur-plabel;
               if (ilen<1 || ilen+4 >= sizeof(szlabel))
                  return 30+perr("invalid label name: %s",plabel);
               memcpy(szlabel,plabel,ilen);
               szlabel[ilen]='\0';
               while (isws(*pszcur,1)) pszcur++;

               call(icur, szlabel, &pData, &nData, nFromAddr, nFromPort);
               // pData may have changed

               continue;
            }

            // prepare prefixed output after possible call
            if (bDonePrefix==0 && nData>0 && nData<MAX_BUFFER
                && memcmp(pData, "SFK\0FW4", 7) != 0)
            {
               bDonePrefix = 1;
               uint nPrefixPort = nFromPort;
               abClBuf2[0] = 0; // length field high
               abClBuf2[1] = 0; // length field low
               uchar *pExt = (uchar *)abClBuf2+2;
               memcpy(pExt, "SFK\0FW4", 7);
               pExt[7] = 6;
               pExt[8]  = (nFromAddr >> 24);
               pExt[9]  = (nFromAddr >> 16);
               pExt[10] = (nFromAddr >>  8);
               pExt[11] = (nFromAddr >>  0);
               pExt[12] = (nPrefixPort >>  8);
               pExt[13] = (nPrefixPort >>  0);
               memcpy(pExt+14, pData, nData);
               pData2 = pExt;
               nData2 = nData + 14;
               // abClBuf1 contains original (unprefixed) data
               // abClBuf2 contains prefixed data
            }

            // to udp [opts] ip:port [opts] to ...
            if (strmatch(&pszcur, "to udp.", itoken, 1))
            {
               int iprefixed=0;

               while (*pszcur!=0)
               {
                  if (!strncmp(pszcur, "to ", 3))
                     break;

                  if (strmatch(&pszcur, "-prefixed", itoken, 1) // proxy.process.1
                      || strmatch(&pszcur, "-prefix", itoken, 1))
                     { iprefixed=1; continue; }

                  if (*pszcur=='-')
                     { perr("unknown option: %s",pszcur); exit(9); }

                  if (getipandport(&pszcur))
                     exit(9);
               }

               if (nData == 0)
                  continue;

               char *pdstip = szClOutHost;
               int ndstport = iClOutPort;
 
               struct sockaddr_in oAddr;
               socklen_t iAddrLen = sizeof(oAddr);
 
               memset((char *)&oAddr, 0,sizeof(oAddr));
               oAddr.sin_family      = AF_INET;
               oAddr.sin_port        = htons(ndstport);
               oAddr.sin_addr.s_addr = inet_addr(pdstip);

               int sout = scur;
               if (pcur->ioutsocket > 0)
                   sout = pcur->ioutsocket;

               if (iprefixed == 1) {
                  if (icldebug)
                     printf("Con #%d passes %03u bytes to %s:%d pinip=%08x poutip=%08x\n",
                        icur+1,nData2,pdstip,ndstport,nSrcAddr,nFromAddr);
                  sendto(sout, (char*)pData2, nData2, 0, (struct sockaddr *)&oAddr, iAddrLen);
               } else {
                  if (icldebug)
                     printf("Con #%d passes %03u bytes to %s:%d\n",icur+1,nData,pdstip,ndstport);
                  sendto(sout, (char*)pData, nData, 0, (struct sockaddr *)&oAddr, iAddrLen);
               }
               sentout(icur,nData);
               continue;
            }

            // reverse: always prefixed
            if (strmatch(&pszcur, "to reverse.", itoken, 1))
            {
               int iport = atoi(pszcur);
               while (isdigit(*pszcur)) pszcur++;
               while (isws(*pszcur)) pszcur++;

               if (nData == 0)
                  continue;

               // send to reverse clients
               for (int k=0; k<MAX_CONNECTIONS; k++)
               {
                  if (acon[k].itype != eRevClient) continue;
                  if (acon[k].isocket <= 0) continue;
                  if (acon[k].iport != iport) continue; // on multi rev cons [20210729]

                  if (icldebug)
                     printf("Con #%d passes %03u prefixed bytes to reverse s=%d (2)\n",icur+1,nData2,acon[k].isocket);

                  // combine with length prefix and send
                  abClBuf2[0] = (uchar)(nData2 >> 8);
                  abClBuf2[1] = (uchar)(nData2 >> 0);

                  int rc = send(acon[k].isocket, (char*)abClBuf2, nData2+2, MSG_NOSIGNAL);
                  if (rc != nData2+2) {
                     // connection probably closed
                     printf("failed to send to s=%d errno=%d\n", acon[k].isocket, netErrno());
                     closeall(k, 6);
                     return 5;
                  }
                  sentout(k,rc);
               }
 
               continue;
            }

            perr("unknown target: '%s' (from %s)", pszcur, pdef->pszdef);
            pinf("supply protocol: udp tcp http\n");
            exit(9);
         }
      }
      else
      if (pcur->itype == eRevGetPending)
      {
         if (iwhat==2) {
            if (icldebug)
               printf("Con #%d connected to %s:%d\n",icur+1,
                  pdef->szfromip,
                  pdef->ifromport);
            pcur->itype = eRevGetConnected;
            pcur->bconpend = 0;
            updateStats();
            continue;
         }
         if (iwhat==4) {
            if (icldebug)
               printf("Con #%d failed to connect to %s:%d\n",icur+1,
                  pdef->szfromip,
                  pdef->ifromport);
            pcur->itype = eRevGetPassive;
            pcur->bconpend = 0;
            pcur->tlastcon = getCurrentTime();
            updateStats();
            continue;
         }
      }

   }

   return 1;
}

// emod net_proxy
#endif // (sfk_prog || sfk_net_proxy)

#ifdef VFILEBASE
CoiTable &CoiData::elements( )
{
   if (!pelements) pelements = new CoiTable();
   return *pelements;
}

StringMap &CoiData::headers( )
{
   if (!pClHeaders) pClHeaders = new StringMap();
   return *pClHeaders;
}

StringMap &Coi::headers( ) {
   return data().headers();
}

char *Coi::header(cchar *pname) {
   if (!hasData()) return 0;
   if (!data().pClHeaders) return 0;
   return data().headers().get((char*)pname);
}

// TODO: exakte definition was sameDomain eigentlich macht!
// ACHTUNG was will der aufrufer bei skiplen!
bool sameDomainNew(char *psz1inpre, char *psz2inpre, int &rskiplen1)
{
   char szin1[300];
   char szin2[300];

   // enforce: foo.com -> foo.com/
   strcopy(szin1, psz1inpre); szin1[280]='\0';
   strcopy(szin2, psz2inpre); szin2[280]='\0';
   strcat(szin1, "/"); // sfk1920 getpic -dir ...
   strcat(szin2, "/");
   char *psz1in = szin1;
   char *psz2in = szin2;

   char *psz1  = psz1in;
   char *psz2  = psz2in;
   char *edom1 = 0;
   char *edom2 = 0;
   char *psla1 = 0;
   char *psla2 = 0;

   if (strBegins(psz1, "http://"))  psz1 += 7;
   else
   if (strBegins(psz1, "https://")) psz1 += 8;
   else {
      if (cs.debug) printf("samedom.fail.1\n");
      return 0;
   }

   if (strBegins(psz2, "http://"))  psz2 += 7;
   else
   if (strBegins(psz2, "https://")) psz2 += 8;
   else {
      if (cs.debug) printf("samedom.fail.2\n");
      return 0;
   }

   // ignore any www.
   if (striBegins(psz1, "www.")) psz1 += 4;
   if (striBegins(psz2, "www.")) psz2 += 4;

   // isolate main domains from foo.com/ or foo.com:80/
   // todo: foo.com vs foo.com/bar.txt
   for (; *psz1!=0; psz1++) {
      if (*psz1==':' || *psz1=='/') {
         if (!edom1) edom1 = psz1-1;
      }
      if (*psz1=='/') {
         if (!psla1) psla1 = psz1;
      }
   }
   for (; *psz2!=0; psz2++) {
      if (*psz2==':' || *psz2=='/') {
         if (!edom2) edom2 = psz2-1;
      }
      if (*psz2=='/') {
         if (!psla2) psla2 = psz2;
      }
   }

   if (!edom1 || !edom2 || !psla1 || !psla2) {
      if (cs.debug) printf("samedom.fail.3 %p %p %p %p\n",edom1,edom2,psla1,psla2);
      if (cs.debug) printf("dom1: %s\n", psz1in);
      if (cs.debug) printf("dom2: %s\n", psz2in);
      return 0;
   }

   // set this to last char of domain name
   psz1 = edom1;
   psz2 = edom2;

   // step 2 dots back, or until /
   int ndots = 2;
   for (; psz1 > psz1in; psz1--) {
      if (*psz1 == '.' && !(--ndots)) break;
      if (*psz1 == '/') break;
   }
   char *pdom1 = psz1+1;
   int  nlen1 = edom1 - pdom1;

   // same on psz2
   ndots = 2;
   for (; psz2 > psz2in; psz2--) {
      if (*psz2 == '.' && !(--ndots)) break;
      if (*psz2 == '/') break;
   }
   char *pdom2 = psz2+1;
   int  nlen2 = edom2 - pdom2;

   if (nlen1 != nlen2) {
      if (cs.debug) printf("samedom.fail.4\n");
      return 0;
   }

   bool brc = strncmp(pdom1, pdom2, nlen1) ? 0 : 1;

   if (brc) rskiplen1 = (int)((psla1 + 1) - psz1in);

   if (cs.debug) printf("samedom.fail.5\n");

   return brc;
}

// list of non-traversable binary extensions
cchar *apBinExtList[] = {
   "jpg","gif","png",
   0 // EOD
};

int Coi::setTypeFromHeaders( )
{
   StringMap *pheads = &headers();
   if (!pheads)
      return 5;

   char *pctype = pheads->get(str("content-type"));

   if (!pctype)
      return 5;

   return setTypeFromContentType(pctype);
}

int Coi::setTypeFromContentType(char *pctype)
{
   bClWebText=0;
   bClWebBinary=0;
   bClWebPage=0;
   bClWebJpeg=0;
   bClWebPNG=0;
   bClWebImage=0;
 
   if (striBegins(pctype, "image/jpeg")) {
      bClWebImage=1; bClWebJpeg=1;
      bClWebBinary=1; bClWebText=0;
      setBinaryFile(1);
      return 0;
   }
   if (striBegins(pctype, "image/png")) {
      bClWebImage=1; bClWebPNG=1;
      bClWebBinary=1; bClWebText=0;
      setBinaryFile(1);
      return 0;
   }
   if (   striBegins(pctype, "image/")
       || striBegins(pctype, "audio/")
       || striBegins(pctype, "video/")
       || striBegins(pctype, "application/x-msdos-program")
       || striBegins(pctype, "application/pdf")
       || striBegins(pctype, "application/zip")
      )
   {
      bClWebBinary=1; bClWebText=0;
      setBinaryFile(1);
      return 0;
   }
   if (   striBegins(pctype, "text/html")
       || striBegins(pctype, "application/xhtml")
       || striBegins(pctype, "application/rss+xml")
      )
   {
      bClWebText=1; bClWebPage=1;
      setBinaryFile(0);
      return 0;
   }
   if (   striBegins(pctype, "text/")
       || striBegins(pctype, "application/javascript")
       || striBegins(pctype, "application/x-javascript")
       || striBegins(pctype, "application/json")
       || striBegins(pctype, "application/xml")
      )
   {
      bClWebText=1;
      setBinaryFile(0);
      return 0;
   }
   if (  (strBegins(pctype, "application/") && strstr(pctype, "zip"))
       || strBegins(pctype, "application/x-tar")
       || strBegins(pctype, "application/x-compressed")
      )
   {
      setBinaryFile(1); // is binary
      setArc(1);        // but also an archive
      return 0;
   }

   return 5;
}

int Coi::preloadFromWeb( )
{
   num nMaxSize = cs.maxwebsize;

   if (nMaxSize < 1000000)
       nMaxSize = 1000000;

   uchar *pLoadBuf  = new uchar[nMaxSize+1000];
   if (!pLoadBuf)
      return 9+perr("out of memory");

   int irc = 0;

   int iopenrc=0,iopenrc2=0;
   if ((iopenrc = open("rb")))
   {
      #ifndef SFKWEB
      return 5;
      #endif
   }

   char szCType[100]; mclear(szCType);

   int  iTotalRead  = 0;

   if ((nClHave & COI_HAVE_BINARY) == 0)
   {
      mtklog(("read probe"));

      // we have ZERO information. read probe.
      memset(pLoadBuf, 0, 1024);

      iTotalRead = read(pLoadBuf, 1024);

      if (iTotalRead > 0) {
         if (fGlblWebDump) {
            fprintf(fGlblWebDump, "-----probe.beg-----\n");
            fwrite(pLoadBuf,1,mymin(128,iTotalRead),fGlblWebDump);
            fprintf(fGlblWebDump, "-----probe.done-----\n");
            fflush(fGlblWebDump);
         }
         pLoadBuf[iTotalRead]='\0';
         // detect binary by content
         uchar *p = pLoadBuf;
         if (memchr(pLoadBuf, 0, iTotalRead)) {
            // detect image by content
            if (p[1]=='P' && p[2]=='N' && p[3]=='G') {
               bClWebImage=1; bClWebPNG=1;
               bClWebBinary=1; bClWebText=0;
               setBinaryFile(1);
            } else if (p[0]==0xFF && p[1]==0xD8) {
               bClWebImage=1; bClWebJpeg=1;
               bClWebBinary=1; bClWebText=0;
               setBinaryFile(1);
            } else {
               bClBinary = 1;
            }
         } else {
            bClBinary = 0;
         }
      } else {
         bClBinary = 0;
      }
      nClHave |= COI_HAVE_BINARY;

      bClWebBinary = bClBinary;
      bClWebText   = bClWebBinary ? 0 : 1;
   }

   // complete loading of object contents
   int iMaxRead = nMaxSize;

   do
   {
      if (nClHave & COI_HAVE_SIZE)
      {
         if (getSize() > iMaxRead)
         {
            pwarn("file too large: %s (%dm)\n", name(), (int)getSize()/1000000);
            pinf("use option -weblimit=n to change limit.\n");
            irc = 5;
            break;
         }
         iMaxRead = getSize();
      }
 
      while (iTotalRead < iMaxRead)
      {
         // it may be important to read all in one call
         int iRemainSpace = iMaxRead - iTotalRead;
         int iBytes = read(pLoadBuf+iTotalRead, iRemainSpace);
         if (iBytes <= 0)
            break;
         iTotalRead += iBytes;
      }
 
      // store a copy in coi which becomes owner
      uchar *ptmp = new uchar[iTotalRead+10];

      if (!ptmp)
         return 9+perr("outofmem");

      memcpy(ptmp, pLoadBuf, iTotalRead);
      ptmp[iTotalRead] = '\0';

      setContent(ptmp, iTotalRead, nClMTime);

      mtklog(("preload sets CACHED DATA with %d bytes", iTotalRead));
   }
   while (0);

   close();
 
   delete [] pLoadBuf;

   return irc;
}

// vfile processing caches
CoiMap glblVCache;      // downloaded zip's cache
ConCache glblConCache;  // ftp and http connection cache

#define COI_CAPABILITY_NET (1UL<<0)
uint nGlblCoiConfig = 0xFFFFUL;

class DiskCacheConfig {
public:
   DiskCacheConfig ( );

   char *getPath   ( );
   int  setPath   (char *ppath);

   bool  getActive ( );
   void  setActive (bool byesno);

   char szPath[SFK_MAX_PATH+10];
   bool bactive;
};

DiskCacheConfig::DiskCacheConfig()
{
   memset(this, 0, sizeof(*this));
   // is active by default,
   // but TEMP will be accessed on demand.
   bactive = 1;
}

// guarantees non-void pointer
char *DiskCacheConfig::getPath( )
{
   if (szPath[0]) return szPath;

   char *ptmp = getenv("TEMP");

   if (!ptmp)
         ptmp = getenv("TMP");

   if (!ptmp) {
      bactive = 0;
      static bool btold1 = 0;
      if (!btold1) {
         btold1 = 1;
         if (infoAllowed())
            pinf("cannot cache to disk: no TEMP variable found.\n");
      }
      return szPath; // i.e. return empty
   }

   // set: "c:\temp\00-sfk-cache\"
   snprintf(szPath, sizeof(szPath)-10, "%s%c00-sfk-cache", ptmp, glblPathChar);

   /*
   static bool bFirstCall = 1;
   if (bFirstCall) {
      bFirstCall = 0;
      if (infoAllowed())
         pinf("using cache %s\n", szPath);
   }
   */

   return szPath;
}

int DiskCacheConfig::setPath(char *ppath)
{
   strcopy(szPath, ppath);

   char szSubName[100];
   sprintf(szSubName, "%c00-sfk-cache", glblPathChar);
   int nsublen = strlen(szSubName);

   // always force "00-sfk-cache" as subdir:
   int nlen = strlen(szPath);
   if (nlen >= nsublen && !strcmp(szPath+nlen-nsublen, szSubName))
      return 0;

   if (nlen > 0 && szPath[nlen-1] == '/' ) szPath[nlen-1] = '\0';
   if (nlen > 0 && szPath[nlen-1] == '\\') szPath[nlen-1] = '\0';

   nlen = strlen(szPath);
   int nrem = (sizeof(szPath)-10)-nlen;
   if (nrem < nsublen)
      return 9+perr("cache path too long: %s", ppath);

   strcat(szPath, szSubName);

   return 0;
}

void DiskCacheConfig::setActive(bool byesno) { bactive = byesno; }
bool DiskCacheConfig::getActive( ) { return bactive; }

DiskCacheConfig glblDiskCache;

// optional query callback on first download
bool (*pGlblDiskCacheAskSave)() = 0;

void  setDiskCacheActive(bool b) { glblDiskCache.setActive(b); }
bool  getDiskCacheActive( )      { return glblDiskCache.getActive(); }
void  setDiskCachePath(char *p)  { glblDiskCache.setPath(p); }
// guarantees non-void pointer: on error, path is "".
char *getDiskCachePath( )        { return glblDiskCache.getPath(); }

CoiMap::CoiMap( )
{
   #ifdef USE_DCACHE_EXT
   nClDAlloc   = 0;
   nClDUsed    = 0;
   apClDMeta   = 0;
   apClDFifo   = 0;
   #endif // USE_DCACHE_EXT

   nClByteSize = 0;
   nClBytesMax = 0;
   nClDropped  = 0;

   reset(0, "ct");
}

CoiMap::~CoiMap( ) {
   reset(0, "dt");
}

void CoiMap::reset(bool bWithDiskCache, const char *pszFromInfo)
{__
   mtklog(("CoiMap-reset diskcache=%d from %s", bWithDiskCache, pszFromInfo));

   // delete all clFifo entries
   ListEntry *pcur  = clFifo.first();
   ListEntry *pnext = 0;
   for (;pcur; pcur=pnext)
   {
      Coi *pcoi = (Coi *)pcur->data;
      if (pcoi->refcnt() > 1) { // 1: managed only by us
         if (!bGlblEscape) {
            pinf("cannot drop cache entry with %d refs: %s (%p)\n", pcoi->refcnt(), pcoi->name(), pcoi);
         }
      } else {
         nClByteSize -= pcoi->getUsedBytes();
         pcoi->decref();
         delete pcoi;
      }
      pnext = pcur->next();
      delete pcur;
   }
   // is now ready for flat reset
   clFifo.reset();

   extern int (*pGlblSFKStatusCallBack)(int nMsgType, char *pmsg);

   KeyMap::reset();
   if (nClByteSize != 0) {
      // TODO: so far, the bytesize is just an approximate value.
      nClByteSize = 0;
   }

   #ifdef USE_DCACHE_EXT
   if (bWithDiskCache)
   {
      mtklog(("dcache.release alloc=%d used=%d",nClDAlloc,nClDUsed));
      if (apClDMeta) { delete [] apClDMeta; apClDMeta = 0; }
      if (apClDFifo) { delete [] apClDFifo; apClDFifo = 0; }
      nClDAlloc = 0;
      nClDUsed  = 0;
   }
   #endif // USE_DCACHE_EXT
}

int CoiMap::tellByteSizeChange(Coi *pcoi, num nOldSize, num nNewSize)
{
   if (!pcoi || !pcoi->bClInCache) return 9;

   nClByteSize += (nNewSize - nOldSize);

   if (nClByteSize > nClBytesMax)
       nClBytesMax = nClByteSize;

   return 0;
}

num CoiMap::byteSize(bool bCalcFromList)
{
   if (!bCalcFromList)
      return nClByteSize;

   // expensive recalc:
   int nelem  = size();
   num  nbytes = 0;
   for (int i=0; i<nelem; i++) {
      Coi *pcoi = (Coi*)iget(i);
      if (!pcoi) { perr("int. #108281302"); break; }
      if (pcoi->hasData())
         nbytes += pcoi->getUsedBytes();
   }
   return nbytes;
}

num CoiMap::bytesMax( )     { return nClBytesMax; }
num CoiMap::filesDropped( ) { return nClDropped; }

int CoiMap::put(char *pkey, Coi *pcoi, const char *pTraceFrom, int nmode)
{__
   if (!pkey) return 9+perr("int. #208290634");
   if (!pcoi) return 9+perr("int. #208290635");

   bool bSkipDiskCache = (nmode & 1) ? 1 : 0;

   mtklog(("cache: put %s from=%s coiname=%s", pkey, pTraceFrom, pcoi->name()));

   if (pcoi->bClInCache)
      return 1+pwarn("cache-put twice, ignoring: %s", pkey);

   num nAddSize = pcoi->getUsedBytes();

   // drop cache entries due to memlimit?
   while (nClByteSize + nAddSize > nGlblMemLimit)
   {
      // drop first entry with refcnt == 1.
      // scan first 1000 cache entries, then bail out.
      // list is CHANGED below, therefore have always to re-run from start.
      ListEntry *plx = clFifo.first();
      int nbail = 1000;
      for (; plx; plx = plx->next()) {
         Coi *pxcoi = (Coi*)plx->data;
         if (pxcoi && pxcoi->refcnt() <= 1) break;
         if (nbail-- <= 0) break;
      }

      if (!plx) {
         bool btold = 0;
         if (!btold) { btold = 1;
            pwarn("cache overflow (%d), try to increase -memlimit (current=%d).\n", (int)size(), (int)(nGlblMemLimit/1000000));
         }
      }
      else
      {
         Coi *pxcoi = (Coi*)plx->data;
         if (!pxcoi) break;
 
         char *pxkey = pxcoi->name();
         // int nkeylen = strlen(pxkey);
 
         if (!quietMode())
         {
            char szAddInfo[100];
            snprintf(szAddInfo, sizeof(szAddInfo)-10, "%u files %u mb", size(), (uint)(nClByteSize/1000000UL));
            info.setAddInfoWidth(strlen(szAddInfo));
            info.setStatus("free", pxkey, szAddInfo, eKeepAdd);
            // pinf("cache-drop: %d %d %.50s\n", ndropmb, ncachmb, pxinfo);
         }
 
         mtklog(("cache-drop: %s", pxkey));
 
         // successful remove will DELETE pxcoi AND pxkey!
         if (remove(pxkey))
            { perr("int. #258282159 on cache drop"); break; }

         nClDropped++;
      }
   }

   // overwriting an existing cache entry?
   if (KeyMap::isset(pkey)) {
      // CoiMap::remove takes care of references
      mtklog(("cache-drop: %s (existing)", pkey));
      remove(pkey);
      nClDropped++;
   }

   int nrc = KeyMap::put(pkey, pcoi);
   if (!nrc) {
      // base put ok, add also in fifo list
      ListEntry *pentry = new ListEntry();
      pentry->data = pcoi;
      clFifo.add(pentry);
   }

   // INCREMENT THE REFCNT.
   pcoi->incref("cput");

   pcoi->bClInCache = 1;

   nClByteSize += pcoi->getUsedBytes();

   if (nClByteSize > nClBytesMax)
       nClBytesMax = nClByteSize;

   #ifdef USE_DCACHE
   // cache only net files
   if (   !bSkipDiskCache && pcoi->isNet()
       && pcoi->isKnownArc() && !pcoi->isZipSubEntry()
       && pcoi->hasContent()
      )
   {
      // no matter if active or not, if this is set
      if (pGlblDiskCacheAskSave)
      {
         // then ask back on first download
         bool nrc = pGlblDiskCacheAskSave();
         glblDiskCache.setActive(nrc);
         pGlblDiskCacheAskSave = 0;
      }

      if (glblDiskCache.getActive()) {
         putDiskCache(pkey, pcoi, pTraceFrom);
      } else {
         mtklog(("cache-put : no disk caching (active=%d cont=%d)", glblDiskCache.bactive, pcoi->hasContent()));
      }
   }
   else
   {
      mtklog(("cache-put: skip disk, bskip=%d isnet=%d isarc=%d issub=%d cont=%d",
         bSkipDiskCache, pcoi->isNet(), pcoi->isKnownArc(),
         pcoi->isZipSubEntry(), pcoi->hasContent()
         ));
   }
   #endif // USE_DCACHE

   return nrc;
}

int md5FromString(char *psz, num &rsumhi, num &rsumlo)
{
   SFKMD5 md5;
   md5.update((uchar*)psz, strlen(psz));
   uchar *pdig = md5.digest();
   num nlo=0, nhi=0;
   memcpy(&nhi, pdig+0, 8);
   memcpy(&nlo, pdig+8, 8);
   rsumhi = nhi;
   rsumlo = nlo;
   return 0;
}

#ifdef USE_DCACHE
char *Coi::cacheName(char *pnamein, char *pbuf, int nmaxbuf, int *pDirPartLen)
{__
   char *prel = pnamein;

   // only cache net files to disk.
   cchar *pprot = "";
   if (strBegins(prel, "http://"))
      { pprot="http"; prel += strlen("http://"); }
   else
   if (strBegins(prel, "https://"))
      { pprot="https"; prel += strlen("https://"); }
   else
   if (strBegins(prel, "ftp://"))
      { pprot="ftp"; prel += strlen("ftp://"); }
   else {
      // local file: do NOT cache to disk
      return 0;
   }

   //  in: http://foo.com/sub/dir/get.php?a=1&b=5&sess=c9352ff7
   // out: c:\temp\00-sfk-cache\foo.com\subdirget.phpa1b5sessc9352ff7
   char *pCacheDir = glblDiskCache.getPath();
   if (!pCacheDir) return 0; // error was told

   if (nmaxbuf < 100) {
      static bool btold2 = 0;
      if (!btold2) { btold2=1; pwarn("cannot cache to disk: name buffer too small.\n"); }
      return 0;
   }

   nmaxbuf -= 10; // safety

   // add: "c:\temp\00-sfk-cache" and "\"
   mystrcopy(pbuf, pCacheDir, nmaxbuf);
   strcat(pbuf, glblPathStr);

   // also add protocol to allow rebuild of url
   strcat(pbuf, pprot);
   strcat(pbuf, glblPathStr);

   char *pdst = pbuf + strlen(pbuf);
   int  nrem = nmaxbuf - strlen(pbuf);

   if (pDirPartLen) *pDirPartLen = strlen(pbuf);

   // prel: foo.com/sub/dir/get.php?a=1&b=5&sess=c9352ff7
   char *prel2 = strchr(prel, '/');
   if (!prel2) return 0; // wrong name format
   int ndomlen = prel2 - prel;
   prel2++;

   // prel2: sub/dir/get.php?a=1&b=5&sess=c9352ff7
   // add: "foo.com\"
   if (ndomlen >= nrem) {
      pwarn("cannot cache to disk, name too long: %s\n", pnamein);
      return 0;
   }
   memcpy(pdst, prel, ndomlen);
   pdst += ndomlen; nrem -= ndomlen;
   *pdst++ = glblPathChar; nrem--;
   *pdst = '\0';

   // convert and add rest of url.
   // be very careful on name reductions,
   // to avoid mixup with archive sub entries
   // when retrieving stuff from the cache later.

   // http: $-_.+!*'(),
   char szBuf[10];
   char *psrc = prel2;
   while (*psrc && (nrem > 0))
   {
      char c = *psrc++;
      if (isalnum(c))
         { *pdst++ = c; nrem--; continue; }

      #ifdef REDUCE_CACHE_FILE_NAMES
      // if finding ".zip?parm=..." then stop here.
      // but make sure ".zip\\" or ".zip//" is never stripped,
      // to avoid mixup with sub entries later.
      if (c == '.')
      {
         // scan for the longest .tar.gz etc. extension.
         // arcExtList is sorted by reverse length.
         for (int i=0; arcExtList[i]; i++)
         {
            if (!mystrnicmp(psrc-1, arcExtList[i], strlen(arcExtList[i])))
            {
               // an extension match is found, but how does it continue?
               int nextlen = strlen(arcExtList[i]);
               if (nextlen < 1) break; // safety
               char *pcont  = psrc - 1 + nextlen;

               // never strip sub archive identifiers
               if (!strncmp(pcont, "\\\\", 2)) continue;
               if (!strncmp(pcont, "//", 2))   continue;

               memcpy(pdst, arcExtList[i], nextlen);
               pdst[nextlen] = '\0';

               // EARLY EXIT: archive extension found
               mtklog(("cache: built aext name: %s", pbuf));
               return pbuf;
            }
         }
      }
      #endif

      switch (c)
      {
         case '-': case '+': case '.': case '_':
            *pdst++ = c; nrem--; continue;

         // case '_':
         //    *pdst++ = '-'; nrem--; continue;

         // case '/':
         // case '\\':
         //    *pdst++ = '_'; nrem--; continue;
      }
      sprintf(szBuf, "%%%02X", (unsigned)c);
      *pdst++ = szBuf[0];
      *pdst++ = szBuf[1];
      *pdst++ = szBuf[2];
      nrem -= 3;
   }
   *pdst = '\0';

   if (nrem <= 0) {
      pwarn("cannot cache to disk, name too long: %s\n", pnamein);
      return 0;
   }
 
   return pbuf;
}

// make sure coi has cached data before calling this
int CoiMap::putDiskCache(char *pkey, Coi *pcoi, const char *pTraceFrom)
{__
   char szCacheName[SFK_MAX_PATH+10];

   uchar *pdata = pcoi->data().src.data;
   num    nsize = pcoi->data().src.size;

   if (!pdata) return 9+perr("int. 35291439");

   // the coi may have been redirected. in that case,
   // the dstname is different from the srcname.
   char *psrcname = pkey;
   char *pdstname = pcoi->name();

   int  nCacheDirLen = 0;
   char *pszCacheName = Coi::cacheName(pdstname, szCacheName, SFK_MAX_PATH, &nCacheDirLen);
   if (!pszCacheName) return 0;

   if (createOutDirTree(pszCacheName))
      return 5+pwarn("cannot create caching dir for: %s", pszCacheName);

   if (infoAllowed())
      pinf("saving %s\n", pszCacheName);

   FILE *fout = fopen(pszCacheName, "wb");
   if (!fout)
      return 5+pwarn("cannot write cache file: %s", pszCacheName);

   mtklog(("cache: disk: write pdata=%p size=%d", pdata, (int)nsize));

   if (myfwrite(pdata, nsize, fout) != nsize) {
      fclose(fout);
      return 5+pwarn("failed to write cache file, probably disk full: %s", pszCacheName);
   }

   fclose(fout);

   // if the coi was redirected, also store the source info.
   if (strcmp(psrcname, pdstname))
   {
      pszCacheName = Coi::cacheName(psrcname, szCacheName, SFK_MAX_PATH, &nCacheDirLen);
      if (!pszCacheName) return 0;
 
      if (createOutDirTree(pszCacheName))
         return 5+pwarn("cannot create caching dir for: %s", pszCacheName);
 
      if (infoAllowed())
         pinf("saving %s\n", pszCacheName);
 
      FILE *fout = fopen(pszCacheName, "wb");
      if (!fout)
         return 5+pwarn("cannot write cache meta file: %s", pszCacheName);

      fprintf(fout, "[sfk-cache-redirect]\n%s\n", pdstname);
 
      fclose(fout);
   }

   mtklog(("cache: put on disk: %s (%s)", pkey, pszCacheName));

   return 0;
}
#endif // USE_DCACHE

#ifdef USE_DCACHE_EXT
// rc =0:found_and_index_set
// rc <0:insert_before_index
// rc >0:insert_after_index
int CoiMap::bfindDMeta(num nsumlo,num nsumhi,int &rindex)
{__
   // binary search for key, or insert position
   uint nbot=0,ndist=0,nhalf=0,imid=0;
   uint ntop=nClArrayUsed; // exclusive

   num   ntmphi=0,ntmplo=0;

   int    ncmp=-1;   // if empty, insert before index 0

   while (1)
   {
      if (nbot > ntop) // shouldn't happen
         { perr("int. 187281850"); ncmp=-1; break; }

      ndist = ntop - nbot;
      // mtklog(("dist %d bot %d top %d",ndist,nbot,ntop));
      if (ndist == 0) break; // nothing left
      nhalf = ndist >> 1;
      imid  = nbot + nhalf;

      ntmphi= apClDMeta[imid].sumhi;
      ntmplo= apClDMeta[imid].sumlo;

      // 128 bit comparison
      if (nsumhi < ntmphi) ncmp = -1;
      else
      if (nsumhi > ntmphi) ncmp =  1;
      else
      if (nsumlo < ntmplo) ncmp = -1;
      else
      if (nsumlo > ntmplo) ncmp =  1;
      else
         ncmp = 0;

      if (ncmp < 0) {
         // select lower half, if any
         // mtklog((" take lower %xh %xh %d",nval,ntmp,imid));
         if (ntop == imid) break; // safety
         ntop = imid;
      }
      else
      if (ncmp > 0) {
         // select upper half, if any
         // mtklog((" take upper %xh %xh %d",nval,ntmp,imid));
         if (nbot == imid+1) break; // required
         nbot = imid+1;
      } else {
         // straight match
         mtklog(("%d = indexof(%xh) used=%u",imid,(uint)nsumhi,nClDAlloc));
         break; // found
      }
   }

   rindex = imid;
   return ncmp;
}

int CoiMap::putDiskCache(char *pkey, Coi *pcoi)
{__
   int nfree = nClDAlloc - nClDUsed;
   if (nfree < 10) {
      // expand arrays: alloc new
      int nAllocNew = nClDAlloc + (nClDAlloc ? nClDAlloc : 100);
      DMetaEntry *pdnew = new DMetaEntry[nAllocNew+10];
      DFifoEntry *pfnew = new DFifoEntry[nAllocNew+10];
      if (nClDUsed) {
         memcpy(pdnew, apClDMeta, sizeof(DMetaEntry)*nClDUsed);
         memcpy(pfnew, apClDFifo, sizeof(DFifoEntry)*nClDUsed);
      }
      // then free old and swap
      delete [] apClDMeta;
      delete [] apClDFifo;
      apClDMeta = pdnew;
      apClDFifo = pfnew;
      nClDAlloc = nAllocNew;
      nfree = nClDAlloc - nClDUsed;
   }
   // put basic infos into (mem) cached meta data
   num nsumlo=0,nsumhi=0;
   md5FromString(pkey,nsumlo,nsumhi);

   // find insert position
   int nindex = 0;
   int nrc = bfindDMeta(nsumlo,nsumhi,nindex);
   if (!nrc) return 1;  // already in cache

   if (nrc < 0) {
      // insert before index
   } else {
      // insert after index
      nindex++;
   }
   int ntomove = nClDUsed - nindex;
   if (ntomove > 0)
      memmove(&apClDMeta[nindex+1], &apClDMeta[nindex+0],
         sizeof(DMetaEntry) * ntomove);
   // now, set at index
   DMetaEntry *pdmet = &apClDMeta[nindex];
   pdmet->sumhi = nsumhi;
   pdmet->sumlo = nsumlo;
   pdmet->size  = pcoi->getSize();
   pdmet->time  = pcoi->getTime();
   // append key entry to fifo
   DFifoEntry *pdfif = &apClDFifo[nClDUsed];
   pdfif->sumhi = nsumhi;
   pdfif->sumlo = nsumlo;
   // finally, count new entry
   nClDUsed++;
   mtklog("dcache.insert at %d of %d: sumlo=%s key=%s", nindex, nClDUsed,
      numtohex(nsumlo), pkey);
   return 0;
}
#endif // USE_DCACHE_EXT

// caller MUST release object after use!
Coi *CoiMap::get(char *pkey)
{__
   Coi *pcoi = (Coi*)KeyMap::get(pkey);
   if (pcoi) {
      pcoi->incref("cget");
      mtklog(("cache: %p = cache.get( %s )",pcoi,pkey));
      return pcoi;
   }

   #ifdef USE_DCACHE

   // disk cache is yet used only for net files
   if (   !strBegins(pkey, "http://")
       && !strBegins(pkey, "https://")
       && !strBegins(pkey, "ftp://"))
      return 0;

   // not yet in mem cache, but maybe in disk cache?
   if (!glblDiskCache.bactive) return 0;

   mtklog(("cache: cache.get( %s ) begin",pkey));

   char szCachePathBuf[SFK_MAX_PATH+10];
   char szCacheReDirBuf[SFK_MAX_PATH+10];
   char *pszDiskCacheFile = Coi::cacheName(pkey, szCachePathBuf, SFK_MAX_PATH, 0);

   if (!pszDiskCacheFile) {
      mtklog(("cache: no disk name: %s",pkey));
      return 0;
   }

   num nFileSize = getFileSize(pszDiskCacheFile);
   if (nFileSize < 0) {
      return 0;
   }

   // reject cache files beyond the memory limit
   if (nFileSize > nGlblMemLimit) {
      pinf("cache file too large, cannot load: %s\n", pszDiskCacheFile);
      return 0;
   }

   if (infoAllowed())
      pinf("using cache file %s\n", pszDiskCacheFile);

   // exists in disk cache: create a memory coi in mem cache.
   uchar *pdata = loadBinaryFile(pszDiskCacheFile, nFileSize);
   if (!pdata) {
      pinf("failed to load cache file: %s\n", pszDiskCacheFile);
      return 0;
   }

   mtklog(("cache: loaded, size=%d: %s",(int)nFileSize,pszDiskCacheFile));

   if (strBegins((char*)pdata, "[sfk-cache-redirect]"))
   {
      // have to load another file with actual content
      char *pdstname = (char*)pdata + strlen("[sfk-cache-redirect]");
      while (*pdstname && (*pdstname != '\n')) pdstname++;
      if (*pdstname) pdstname++;
      char *psz2 = pdstname;
      while (*psz2 && *psz2 != '\r' && *psz2 != '\n') psz2++;
      *psz2 = '\0';

      strcopy(szCacheReDirBuf, pdstname);
      pdstname = szCacheReDirBuf;

      // target name isolated, clear temporary:
      delete [] pdata; pdata = 0;
      // ptr will be reused immediately

      // now holding the virtual filename in pdstname (http://...)
      // build cache name from that.
      pszDiskCacheFile = Coi::cacheName(pdstname, szCachePathBuf, SFK_MAX_PATH, 0);
      if (!pszDiskCacheFile) {
         mtklog(("cache: no cache name for: %s", pdstname));
         return 0;
      }

      pinf("using cache file %s\n", pszDiskCacheFile);

      pdata = loadBinaryFile(pszDiskCacheFile, nFileSize);
      if (!pdata) {
         pinf("failed to load cache file: %s\n", pszDiskCacheFile);
         return 0;
      }

      mtklog(("cache: loaded redir, size=%d: %s",(int)nFileSize,pszDiskCacheFile));
   }

   // the cacheName function must make sure that keys for subentries
   // never return a cache file name pointing to the overall .zip.
   // i.e. if the name is reduced, reduction shall not strip sub infos,
   // otherwise we retrieve wrong data (and coi names) here.
   pcoi = new Coi(pszDiskCacheFile, 0);

   pcoi->setContent(pdata, nFileSize);

   mtklog(("cache: put entry: key=%s", pkey));
   mtklog(("cache: put entry: coi=%s", pcoi->name()));

   put(pkey, pcoi, "dcache", 1); // skipping disk cache write
   // TODO: what to do if memCachePut fails after diskCacheLoad?

   // put() sets the refcnt to 1.
   // but as get() was originally called,
   // we must return refcnt==2:
   pcoi->incref("cget2");

   #endif // USE_DCACHE

   return pcoi;
}

int CoiMap::remove(char *pkey)
{
   // get coi, need it for fifo search
   // do NOT use CoiMap::get() as it increments the ref!
   Coi *pcoi = (Coi*)KeyMap::get(pkey);
   if (!pcoi) return 1; // not found

   // remove map entry
   int nrc = KeyMap::remove(pkey);

   // remove from fifo list as well
   ListEntry *plx = clFifo.first();
   for (;plx; plx=plx->next())
      if (plx->data == pcoi)
         break;

   // no list entry should NOT happen
   if (plx) {
      clFifo.remove(plx);
      delete plx;
      plx = 0;
   } else {
      perr("int. 187282050");
   }

   // finally, delete the managed coi
   if (pcoi->refcnt() > 1) { // 1: managed only by us
      if (!bGlblEscape) {
         pinf("cannot drop cache entry with %d refs: %s", pcoi->refcnt(), pcoi->name());
      }
   }
   else
   {
      nClByteSize -= pcoi->getUsedBytes();

      pcoi->bClInCache = 0;

      pcoi->decref();

      delete pcoi;
   }

   return nrc;
}

int Coi::rawLoadDir(int ilevel)
{__
   if (data().bloaddirdone) {
      mtklog(("coi::loaddir: done, %d entries", data().elements().numberOfEntries()));
      return 1; // already done
   }
   data().bloaddirdone = 1;

   #ifdef SFKOFFICE
   if (isOffice(106)) return rawLoadOfficeDir();
   #endif // SFKOFFICE

   #ifdef SFKDEEPZIP
   if (cs.probefiles)
      probeFile();
   #endif // SFKDEEPZIP


   #ifdef VFILEBASE
   if (isFtp())   return rawLoadFtpDir();
   #endif // VFILEBASE

   return 9; // n/a with fsdirs
}

// caller MUST RELEASE COI after use!
Coi *Coi::rawNextFtpEntry( )
{
   if (!data().bdiropen) {
      perr("ftp nextEntry() called without openDir()");
      return 0;
   }

   Coi *psubsrc = 0;

   #ifndef DEEP_FTP
   do
   #endif
   {
      // something left to return?
      if (data().nNextElemEntry >= data().elements().numberOfEntries())
         return 0; // end of list

      // return a COPY from the internal list entries.
      psubsrc = data().elements().getEntry(data().nNextElemEntry, __LINE__);
      data().nNextElemEntry++;
   }
   #ifndef DEEP_FTP
   while (psubsrc->isTravelDir()); // for now, SKIP dir entries of ftp
   #endif

   // if there is a global cache entry machting this sub,
   Coi *pcached = glblVCache.get(psubsrc->name());

   // caller MUST RELEASE COI after use!

   if (pcached)
   {
      bool bhasptr = pcached->data().src.data ? 1 : 0; (void)bhasptr;
      mtklog(("coi::nextftpentry cache hit %d %d %s", (int)bhasptr, (int)pcached->data().src.size, pcached->name()));
      return pcached;
   }
   else
   {
      Coi *psubdst = psubsrc->copy();
      psubdst->incref("nft");
      mtklog(("coi::nextftpentry cache miss, returning copy of %s", psubdst->name()));
      return psubdst;
   }
}

void Coi::rawCloseFtpDir( ) {
   // see remarks in rawCloseZipDir
   data().bdiropen = 0;
}

int Coi::rawOpenFtpSubFile(cchar *pmode)
{
   if (!isFtp()) return 9;
   if (strcmp(pmode, "rb")) return 9;

   // get client for that base url
   if (data().getFtp(name())) return 9;

   // use supplied client, release after dir download
   FTPClient *pftp = data().pClFtp;

   // isolate hostname from url
   if (pftp->splitURL(name()))
      return 9; // error was told

   // nRelIndex is now the relative path start index.
   char *phost    = pftp->curhost();
   char *prelfile = pftp->curpath();
   int  nport    = pftp->curport();

   mtklog((" ftp open host \"%s\" file \"%s\"", phost, prelfile));

   int nrc = 0;

   for (int itry=0; itry<2; itry++)
   {
      if (pftp->loginOnDemand(phost, nport))
         return 9;

      nrc = pftp->openFile(prelfile, pmode);
      // RC  9 == general error, e.g. file not available
      // RC 10 == communication failed, connection invalid

      if (nrc < 10)
         break;

      // loginOnDemand thought the line is still valid, but it isn't.
      pinf("ftp session expired, retrying\n");
 
      // devalidate session, relogin and retry
      pftp->logout();
   }
 
   if (nrc) {
      if (nrc > 9) {
         pinf("ftp communication failed (connection closed)\n");
         pftp->logout();
      }
      data().releaseFtp();  // failed
   }
   else
      data().bfileopen = 1;

   // general releaseFtp is done after file download.

   return nrc;
}

int Coi::rawOpenHttpSubFile(cchar *pmode)
{__
   if (!isHttp()) return 9;
   if (strcmp(pmode, "rb")) return 9;

   if (data().getHttp(name())) return 9;
   HTTPClient *phttp = data().pClHttp;

   mtklog(("http-open %s",name()));

   int nrc = phttp->open(name(), pmode, this);
   // may redirect and change current coi's name!

   if (nrc) {
      if (nrc==11 && !cs.verbose)
         { }
      else
      {
         if (root(1)) pinf("[nopre] from : %s\n", root());
         if (ref(1))  pinf("[nopre] ref  : %s\n", ref());
      }
   } else {
      data().bfileopen = 1;
   }

   return nrc;
}

extern char *getxlinfo();
extern num   getxllim();

size_t Coi::rawReadFtpSubFile(void *pbufin, size_t nBufSize)
{
   if (!data().pClFtp || !data().bfileopen) {
      perr("ftp not open, cannot read: %s (%d)", name(), data().bfileopen);
      return 0;
   }

   int nread = data().pClFtp->readFile((uchar*)pbufin, (int)nBufSize);
   mtklog((" ftp read %s %u done %d", name(), (uint)nBufSize, nread));

   return (nread >= 0) ? nread : 0;
}

size_t Coi::rawReadHttpSubFile(void *pbufin, size_t nBufSize)
{__
   if (!data().pClHttp || !data().bfileopen) {
      perr("http not open, cannot read: %s (%d)", name(), data().bfileopen);
      return 0;
   }

   int nread = data().pClHttp->read((uchar*)pbufin, (int)nBufSize);
   mtklog(("http-read done=%d buf=%p max=%d", nread, pbufin, (int)nBufSize));

   return (nread >= 0) ? nread : 0;
}

void Coi::rawCloseFtpSubFile( )
{
   mtklog(("ftp-close %s", name()));

   if (!data().pClFtp) {
      mtklog(("close.ftp already done: %s",name()));
      return;
   }

   data().pClFtp->closeFile();

   // release connection ptr, without closing it:
   data().releaseFtp();

   data().bfileopen = 0;
}

void Coi::rawCloseHttpSubFile( )
{__
   mtklog(("http-close %s", name()));

   if (!hasData()) {
      mtklog(("close.http already done: %s",name()));
      return;
   }

   if (!data().pClHttp) {
      mtklog(("close.http already done: %s",name()));
      return;
   }

   // so far, coi http core can NOT reuse the same connection
   // for multiple commands, so we MUST close the socket.
   // (otherwise GET without full read must be avoided)
   data().pClHttp->close();

   // release connection ptr, without closing it:
   data().releaseHttp();

   data().bfileopen = 0;
}

int Coi::prefetch(bool bLoadNonArcBinaries, num nFogSizeLimit, num nHardSizeLimit)
{
   return preload("dvw", 0, bLoadNonArcBinaries ? 1 : 2); // dview
}

int Coi::preload(cchar *pszFromInfo, uchar **ppout, num &rsize, int iStopMode)
{
   int isubrc = preload(pszFromInfo, 0, iStopMode, 1); // internal
   if (isubrc) return isubrc;

   *ppout = data().src.data;
   rsize  = data().src.size;

   return 0;
}

// stopmode 0: load everything
// stopmode 1: load no binaries except archives
// stopmode 2: load no binaries
int Coi::preload(cchar *pszFromInfo, bool bsilent, int iStopMode, bool bfile)
{
   if (data().src.data)
      return 0; // nothing to do

   if (cs.debug)
      printf("preload.1: %s %d mode=%d file=%d %s\n", pszFromInfo, bsilent, iStopMode, bfile, name());

   #ifdef SFKPACK
   if (isOfficeSubEntry())
      return loadOfficeSubFile("preload");
   #endif // SFKPACK

   bool bIsZipTrav = isTravelZip(111,1);
   bool bIsZipSub  = isZipSubEntry();
   bool bIsZipAny  = (bIsZipTrav || bIsZipSub);

   if (isNet()) // && bIsZipTrav)
      {_ } // accept, need to cache whole file
   else
   if (bIsZipSub)
      {_ } // accept, need to cache sub entry via parent
   else
   if (!bfile) {
      // physical file: no preload
      return 0;
   }

   num  nLoadLimit   = nGlblMemLimit;
   cchar *pszLimitOpt= "-memlimit";
   num  nAllocSize   = 2000000; // 2 mb
   bool bStreamLoad  = 1;


   if (isHttp()) {
      nLoadLimit  = cs.maxwebsize;
      pszLimitOpt = "-weblimit";
   }

   int iopenrc=0,iopenrc2=0;

   if ((iopenrc = open("rb")))
   do
   {
      if (isHttp())
      {
      }

      // if (!bsilent)
      //    pwarn("cannot read: %s\n", name());

      return 9;
   }
   while (0);

   if (hasSize()) {
      nAllocSize  = getSize();
      bStreamLoad = 0;
      if (cs.debug) printf("preload.2: have=%u size=%d\n",nClHave,(int)nAllocSize);
   } else {
      if (cs.debug) printf("preload.2: have=%u alloc=%d\n",nClHave,(int)nAllocSize);
   }

   if (nAllocSize < 0) {
      close();
      return 9;
   }

   if (nAllocSize > nLoadLimit) {
      close();
      if (!bsilent) {
         pwarn("file too large, skipping: %s (%d mb)\n", name(), (int)(nAllocSize/1000000));
         if (pszLimitOpt)
            pinf("use option %s to change load limit\n", pszLimitOpt);
      }
      return 1; // block loading
   }

   uchar *pdata  = new uchar[nAllocSize+100];
   num    nused  = 0;

   if (!pdata) { // safety
      close();
      return 9+perr("out of memory (%d)\n", (int)(nAllocSize/1000000));
   }

   if (   iStopMode > 0
       && (nClHave & COI_HAVE_BINARY) == 0
      )
   {
      mtklog(("read probe"));

      int nProbeSize = mymin(1024, nAllocSize);

      memset(pdata, 0, nProbeSize);

      nused = read(pdata, nProbeSize);

      if (nused < 0) {
         close();
         return 9+perr("cannot read: %s\n", name());
      }

      pdata[nused]='\0';
      uchar *p = pdata;

      if (nused>0 && memchr(pdata, 0, nused)) {
         if (p[1]=='P' && p[2]=='N' && p[3]=='G') {
            bClWebImage=1; bClWebPNG=1;
            bClWebBinary=1; bClWebText=0;
            setBinaryFile(1);
         } else if (p[0]==0xFF && p[1]==0xD8) {
            bClWebImage=1; bClWebJpeg=1;
            bClWebBinary=1; bClWebText=0;
            setBinaryFile(1);
         } else {
            bClBinary = 1;
         }
      } else {
         bClBinary = 0;
      }
      nClHave |= COI_HAVE_BINARY;

      bClWebBinary = bClBinary;
      bClWebText   = bClWebBinary ? 0 : 1;
   }

   bool bIsKnownBinary = ((nClHave & COI_HAVE_BINARY) && bClBinary) ? 1 : 0;
   bool bIsKnownArc    = ((nClHave & COI_HAVE_ARC   ) && bClArc   ) ? 1 : 0;

   switch (iStopMode)
   {
      case 0: // load everything
         break;

      case 1: // load no binaries except archives
         if (bIsKnownBinary && !bIsKnownArc)
         {
            if (cs.debug)
               printf("preload stop: binary and no archive\n");
            close();
            return 2; // skip download and caching as it's not text, and no archive
         }
         break;

      case 2: // load no binaries
         if (bIsKnownBinary)
         {
            if (cs.debug)
               printf("preload stop: binary\n");
            close();
            return 3; // skip download and caching as it's not text, and no archive
         }
         break;
   }

   if (cs.debug) printf("preload.4: probe=%d\n",(int)nused);
 
   while (1)
   {
      num nrem = nAllocSize - nused;

      if (bStreamLoad)
      {
         // expand buffer by next stream data
         if (nrem < nAllocSize / 4)
         {
            num nAllocSize2 = nAllocSize * 2;
            uchar *ptmp = new uchar[nAllocSize2+100];
            memcpy(ptmp, pdata, nused);
            delete [] pdata;
            pdata  = ptmp;

            nAllocSize = nAllocSize2;
            nrem       = nAllocSize - nused;
         }
      }
      else if (nused >= nAllocSize)
      {
         break;
      }

      num nread = read(pdata+nused, nrem);

      // if (cs.debug) printf("preload.5: read %d\n",(int)nread);

      if (nread <= 0)
         break;

      nused += nread;
   }

   if (bStreamLoad)
   {
      // how much is left empty in read cache?
      num nrem = nAllocSize - nused;
      if (nrem > 1000)
      {
         // adapt to the size really used
         num nAllocSize2 = nused + 100;
         uchar *ptmp = new uchar[nAllocSize2];
         memcpy(ptmp, pdata, nused);
         delete [] pdata;
         pdata  = ptmp;

         nAllocSize = nAllocSize2;
      }
   }

   close();

   pdata[nused] = '\0'; // is guaranteed

   if (cs.debug) printf("preload.6: data %p used=%d\n",pdata,(int)nused);
 
   setContent(pdata, nused, nClMTime);

   return 0;
}

int Coi::provideInput(cchar *pszFromInfo, bool bsilent)
{
   return preload(pszFromInfo, bsilent, 1); // provideInput
}

Coi *Coi::getElementByAbsName(char *pabsname)
{__
   if (!data().elements().numberOfEntries())
      if (rawLoadDir() >= 5)
         return 0;

   // check absname, if it matches ourselves at all
   if (!striBegins(pabsname, name())) {
      // should NOT happen
      pwarn("cannot get element, name mismatch: %s / %s", pabsname, name());
      return 0;
   }

   Coi *psub = 0;
   for (int i=0; i<data().elements().numberOfEntries(); i++)
   {
      psub = data().elements().getEntry(i, __LINE__);
      if (!strcmp(psub->name(), pabsname)) break;
   }

   return psub;
}

bool Coi::isFtp() {
   #ifdef VFILENET
   if (nGlblCoiConfig & COI_CAPABILITY_NET)
      return strBegins(name(), "ftp://");
   #endif // VFILENET
   return 0;
}

bool Coi::isHttp(char *pszOptURL) {
   #ifdef VFILENET
   char *psz = pszOptURL ? pszOptURL : name();
   if (nGlblCoiConfig & COI_CAPABILITY_NET) {
      if (strBegins(psz, "http://"))
         return 1;
      if (strBegins(psz, "https://"))
         return 1;
   }
   #endif // VFILENET
   return 0;
}

bool Coi::isNet() {
   return isHttp() || isFtp();
}

bool Coi::isVirtual(bool bWithRootZips)
{
   if (isNet() || isZipSubEntry())     return 1;
   if (bWithRootZips && isTravelZip(109)) return 1;
   return 0;
}

bool Coi::rawIsFtpDir()
{
   if (!isFtp()) return 0;

   // try to detect by name
   char *pnam = name();
   int nlen  = strlen(pnam);
   if (nlen > 0 && pnam[nlen-1] == '/')
      return 1;

   // but also use the coi flag
   return bClDir;
}

int Coi::readWebHead( )
{
   if (!isHttp())
      return 9;

   if (data().getHttp(name()))
      return 9;

   HTTPClient *phttp = data().pClHttp;

   if (phttp->getFileHead(name(), this, "head"))
      return 9+perr("cannot get headers: %s", name());

   return 0;
}

// TODO: rework error rc handling?
bool Coi::rawIsHttpDir(int ilevel)
{__

   #ifdef SFKINT
   pwarn("isdir: wrong http call sequence.\n");
   #endif

   return 0;
}

int Coi::rawLoadFtpDir( )
{
   if (!isFtp()) return 9;

   // get client for that base url
   if (data().getFtp(name())) return 9;

   // use supplied client, release after dir download
   FTPClient *pftp = data().pClFtp;
   if (pftp->splitURL(name())) {
      data().releaseFtp();
      return 9; // error was told
   }
   // nRelIndex is now the relative path start index.
   char *phost = pftp->curhost();
   char *ppath = pftp->curpath();
   int  nport = pftp->curport();

   mtklog((" ftp open host \"%s\" path \"%s\"", phost, ppath));

   if (pftp->loginOnDemand(phost, nport)) {
      data().releaseFtp();
      return 9+perr("ftp login failed: %s", phost);
   }

   // let the ftp client fill our elements list.
   // it must prefix any name by our name.
   CoiTable *plist = &data().elements();
   plist->resetEntries(); // if any
   if (pftp->list(ppath, &plist, name())) {
      data().releaseFtp();
      return 9+perr("ftp list failed: %s", phost);
   }

   // list downloaded: do NOT close connection
   //   pftp->logout();
   // as it may be used for subsequent downloads

   // start from zip entry 0
   data().nNextElemEntry = 0;

   // current I/O job done: release the client,
   // meaning the refcnt is dec'ed, but NO logout.
   data().releaseFtp();

   return 0;
}

num Coi::getUsedBytes()
{
   num nsize = sizeof(*this);

   if (pszClName)   nsize += strlen(pszClName)+1;
   if (pszClRoot)   nsize += strlen(pszClRoot)+1;
   if (pszClRef)    nsize += strlen(pszClRef)+1;
   if (pszClExtStr) nsize += strlen(pszClExtStr)+1;

   if (hasData()) {
      nsize += sizeof(CoiData);
      CoiData *p = pdata;
      nsize += p->src.size;
      if (p->prelsubname)  nsize += strlen(p->prelsubname)+1;
      if (p->pdirpat    )  nsize += strlen(p->pdirpat)+1;
   }

   // NOT considered, as they are volatile and may have
   // different values on cache put and remove:
   //    rbuf.data, pzip

   return nsize;
}

#endif // VFILEBASE

// dmod text_uni
#if (sfk_prog || sfk_text_uni)

// --- unicode lowercase mapping tables ---

static cchar *adict[] = {
   "",
"LETTER", "SMALL", "LATIN", "WITH", "CAPITAL", "CYRILLIC", "GREEK", "AND", "COPTIC",
"O", "HOOK", "DOT", "STROKE", "BELOW", "U", "GLAGOLITIC", "E", "A",
"CHEROKEE", "ABOVE", "GEORGIAN", "DASIA", "ARMENIAN", "ACUTE", "PSILI", "CIRCUMFLEX", "I",
"DIAERESIS", "VARIA", "TILDE", "OXIA", "ALPHA", "OMEGA", "R", "MACRON", "GRAVE",
"FULLWIDTH", "CIRCLED", "L", "S", "ETA", "BREVE", "N", "COMBINING", "CARON",
"TURNED", "PERISPOMENI", "IOTA", "DESCENDER", "T", "H", "G", "D", "Z",
"YPOGEGRAMMENI", "Y", "UPSILON", "K", "C", "OLD", "DOUBLE", "MIDDLE", "PROSGEGRAMMENI",
"CEDILLA", "PARENTHESIZED", "V", "TAIL", "P", "HORN", "YUS", "W", "M",
"B", "SUBSCRIPT", "REVERSED", "OMICRON", "J", "EPSILON", "F", "X", "PALATAL",
"RING", "RETROFLEX", "OPEN", "LINE", "HA", "TONOS", "KOMI", "KA", "LONG",
"INVERTED", "INSULAR", "Q", "EN", "CHE", "IOTIFIED", "OGONEK", "GHE", "EL",
"DIALYTIKA", "LEG", "DIGRAPH", "DIAGONAL", "CURL", "BAR", "ZHE", "SCHWA", "RIGHT",
"OBLIQUE", "ESH", "AE", "TE", "SHORT", "LIMBU", "LEFT", "EZH", "ZE",
"YERU", "SOFT", "SHEI", "PE", "NUBIAN", "LITTLE", "IE", "DIALECT-P", "DE",
"CRYPTOGRAMMIC", "CROSSED-TAIL", "BIG", "ABKHASIAN", "YU", "SIGN", "OE", "NI", "GAMMA",
"CLOSED", "CHI", "BARRED", "YAT", "VRACHY", "VOLAPUK", "TONE", "THROUGH", "THORN",
"SIDEWAYS", "SHIMA", "SHA", "RHO", "PSI", "KHEI", "IZHITSA", "HORI", "GANGIA",
"EM", "DZE", "DZ", "COMMA", "BETA", "YI", "WE", "UK", "TSE",
"SCRIPT", "SAMPI", "ROTUNDA", "PHI", "LOW", "HALF", "FLOURISH", "FISHHOOK", "ES",
"AV", "YN", "YER", "VERTICAL", "TOPBAR", "TAU", "SWASH", "STRAIGHT", "SHHA",
"SAN", "PI", "OOU", "NJE", "MYSLITE", "MONOCULAR", "MIDDLE-WELSH", "LOOP", "LJE",
"KSI", "KOPPA", "KAPA", "IZHE", "IOTATED", "FITA", "ET", "ER", "EIE",
"EGYPTOLOGICAL", "DZELO", "DOTLESS", "DJE", "DELTA", "CUATRILLO", "CROSSED", "ALEF", "AIN",
"YO", "YA", "VE", "UE", "TSI", "TALL", "SIGMA", "RUM", "RA",
"NU", "MU", "MI", "HORIZONTAL", "HO", "HIGH", "HENG", "HE", "HARD",
"ETH", "ENG", "DIGAMMA", "DA", "BLACKLETTER", "BELT", "ARCHAIC", "AO", "ZJE",
"ZHWE", "ZHIVETE", "ZHAR", "ZETA", "ZEN", "ZEMLYA", "ZEMLJA", "ZATA", "ZA",
"YOGH", "YIWN", "YESTU", "YERI", "YATI", "YAE", "XI", "XEH", "XAN",
"WAU", "VY", "VO", "VISIGOTHIC", "VIN", "VIDA", "VEW", "VEND", "VEDE",
"UPTURN", "UN", "UKU", "UKRAINIAN", "UI", "UA", "TZ", "TWO", "TWE",
"TVRIDO", "TSWE", "TSSE", "TSHE", "TROKUTASTI", "TRESILLO", "TO", "TJE", "TIWN",
"TITLO", "TICK", "THETHE", "THETA", "TCHE", "TAR", "TAN", "TA", "SUPERSCRIPT",
"STOP", "SQUIRREL", "SPIDERY", "SOU", "SLOVO", "SJE", "SIX", "SIMA", "SHWE",
"SHTAPIC", "SHTA", "SHO", "SHIN", "SHCHA", "SHARP", "SERIF", "SEMISOFT", "SEH",
"SALTILLO", "ROUND", "RO", "RITSI", "RHA", "REH", "RAE", "QAR", "QA",
"POKOJI", "PIWR", "PHAR", "PEH", "PAR", "PAMPHYLIAN", "OVERLAY", "OU", "OTU",
"OT", "OPEN-O", "OO", "ONU", "ON", "OI", "OH", "NYI", "NOW",
"NJ", "NGI", "NEUTRAL", "NASHI", "NAR", "NA", "MONOGRAPH", "MEN", "MAN",
"MA", "LL", "LJUDIJE", "LJ", "LIWN", "LIGHT", "LHA", "LAULA", "LATINATE",
"LAS", "LAMDA", "LA", "L-SHAPED", "KJE", "KHI", "KHAR", "KHAKASSIAN", "KEN",
"KEH", "KAPPA", "KAN", "KAKO", "JIL", "JHEH", "JHAN", "JE", "JA",
"IS", "IO", "INITIAL", "INI", "IN", "IAUDA", "HWE", "HV", "HOE",
"HIE", "HETA", "HERU", "HEI", "HATE", "HAT", "HAR", "HAE", "GLOTTAL",
"GLAGOLI", "GJE", "GIM", "GHAN", "GHAD", "GAN", "FRITU", "FIVE", "FI",
"FEI", "FEH", "EH", "EF", "ECH", "DZZHE", "DZZE", "DZWE", "DZJE",
"DZHE", "DWE", "DON", "DOBRO", "DJERVI", "DJERV", "DJA", "DEI", "DCHE",
"DALDA", "CON", "CO", "CIL", "CHRIVI", "CHIN", "CHEH", "CHAR", "CHA",
"CENTRALIZATION", "CCHE", "CAN", "CA", "BYELORUSSIAN-UKRAINIAN", "BUKY", "BROKEN", "BROAD", "BOHAIRIC",
"BLENDED", "BINOCULAR", "BEN", "BE", "BASHKIR", "BAN", "BACK", "AZU", "AYB",
"AY", "AU", "AN", "ALFA", "ALEUT", "AKHMIMIC", "AEN", "ACCENT", "AA",
"YV", "YOT", "YE", "WYNN", "WV", "WU", "WO", "WITHOUT", "WIDE",
"WI", "WA", "UO", "UNBLENDED", "UM", "TUM", "TSV", "TSU", "TSO",
"TSA", "TS", "TOP", "TLV", "TLU", "TLO", "TLI", "TLE", "TLA",
"TI", "THREE-LEGGED", "TH", "TESH", "TC", "TAILLESS", "SV", "SU", "STRIKETHROUGH",
"STIRRUP", "STIGMA", "SQUAT", "SO", "SI", "SE", "SAKHA", "SA", "ROUNDED",
"REVERSED-SCHWA", "RAMS", "QUV", "QUU", "QUO", "QUI", "QUE", "QUA", "QP",
"PRECEDED", "PALOCHKA", "PA", "NV", "NUM", "NOTCH", "NO", "NGA", "NE",
"NARROW", "NAH", "MV", "MUM", "MO", "ME", "LZ", "LV", "LUM",
"LU", "LS", "LONG-LEGGED", "LO", "LI", "LEZH", "LENIS", "LE", "LAZY",
"LAMBDA", "KRA", "INSIDE", "HWAIR", "HU", "HNA", "HI", "HANDLE", "GV",
"GU", "GO", "GI", "GE", "GA", "FLATTENED", "FINAL", "FENG", "DV",
"DUM", "DU", "DO", "DLA", "DIAERESIZED", "DI", "DEZH", "DB", "BY", "BOTTOM", "BASELINE",
"APOSTROPHE", "ANUSVARA", "AFRICAN",
0 };

unsigned short atol1to1[] = {
0x0041, 0x0061, 0x0042, 0x0062, 0x0043, 0x0063, 0x0044, 0x0064, 0x0045, 0x0065, 0x0046, 0x0066, 0x0047, 0x0067, 0x0048, 0x0068,
0x0049, 0x0069, 0x004A, 0x006A, 0x004B, 0x006B, 0x004C, 0x006C, 0x004D, 0x006D, 0x004E, 0x006E, 0x004F, 0x006F, 0x0050, 0x0070,
0x0051, 0x0071, 0x0052, 0x0072, 0x0053, 0x0073, 0x0054, 0x0074, 0x0055, 0x0075, 0x0056, 0x0076, 0x0057, 0x0077, 0x0058, 0x0078,
0x0059, 0x0079, 0x005A, 0x007A, 0x00C0, 0x00E0, 0x00C1, 0x00E1, 0x00C2, 0x00E2, 0x00C3, 0x00E3, 0x00C4, 0x00E4, 0x00C5, 0x00E5,
0x00C6, 0x00E6, 0x00C7, 0x00E7, 0x00C8, 0x00E8, 0x00C9, 0x00E9, 0x00CA, 0x00EA, 0x00CB, 0x00EB, 0x00CC, 0x00EC, 0x00CD, 0x00ED,
0x00CE, 0x00EE, 0x00CF, 0x00EF, 0x00D0, 0x00F0, 0x00D1, 0x00F1, 0x00D2, 0x00F2, 0x00D3, 0x00F3, 0x00D4, 0x00F4, 0x00D5, 0x00F5,
0x00D6, 0x00F6, 0x00D8, 0x00F8, 0x00D9, 0x00F9, 0x00DA, 0x00FA, 0x00DB, 0x00FB, 0x00DC, 0x00FC, 0x00DD, 0x00FD, 0x00DE, 0x00FE,
0x0100, 0x0101, 0x0102, 0x0103, 0x0104, 0x0105, 0x0106, 0x0107, 0x0108, 0x0109, 0x010A, 0x010B, 0x010C, 0x010D, 0x010E, 0x010F,
0x0110, 0x0111, 0x0112, 0x0113, 0x0114, 0x0115, 0x0116, 0x0117, 0x0118, 0x0119, 0x011A, 0x011B, 0x011C, 0x011D, 0x011E, 0x011F,
0x0120, 0x0121, 0x0122, 0x0123, 0x0124, 0x0125, 0x0126, 0x0127, 0x0128, 0x0129, 0x012A, 0x012B, 0x012C, 0x012D, 0x012E, 0x012F,
0x0134, 0x0135, 0x0136, 0x0137, 0x0139, 0x013A, 0x013B, 0x013C, 0x013D, 0x013E, 0x013F, 0x0140, 0x0141, 0x0142, 0x0143, 0x0144,
0x0145, 0x0146, 0x0147, 0x0148, 0x014A, 0x014B, 0x014C, 0x014D, 0x014E, 0x014F, 0x0150, 0x0151, 0x0154, 0x0155, 0x0156, 0x0157,
0x0158, 0x0159, 0x015A, 0x015B, 0x015C, 0x015D, 0x015E, 0x015F, 0x0160, 0x0161, 0x0162, 0x0163, 0x0164, 0x0165, 0x0166, 0x0167,
0x0168, 0x0169, 0x016A, 0x016B, 0x016C, 0x016D, 0x016E, 0x016F, 0x0170, 0x0171, 0x0172, 0x0173, 0x0174, 0x0175, 0x0176, 0x0177,
0x0178, 0x00FF, 0x0179, 0x017A, 0x017B, 0x017C, 0x017D, 0x017E, 0x0181, 0x0253, 0x0182, 0x0183, 0x0184, 0x0185, 0x0186, 0x0254,
0x0187, 0x0188, 0x018A, 0x0257, 0x018B, 0x018C, 0x018E, 0x0258, 0x018F, 0x0259, 0x0190, 0x025B, 0x0191, 0x0192, 0x0193, 0x0260,
0x0194, 0x0263, 0x0196, 0x0269, 0x0197, 0x0268, 0x0198, 0x0199, 0x019C, 0x026F, 0x019D, 0x0272, 0x01A0, 0x01A1, 0x01A2, 0x01A3,
0x01A4, 0x01A5, 0x01A7, 0x01A8, 0x01A9, 0x0283, 0x01AC, 0x01AD, 0x01AE, 0x0288, 0x01AF, 0x01B0, 0x01B1, 0x028A, 0x01B2, 0x028B,
0x01B3, 0x01B4, 0x01B5, 0x01B6, 0x01B7, 0x0292, 0x01B8, 0x01B9, 0x01BC, 0x01BD, 0x01C4, 0x01C6, 0x01C7, 0x01C9, 0x01CA, 0x01CC,
0x01CD, 0x01CE, 0x01CF, 0x01D0, 0x01D1, 0x01D2, 0x01D3, 0x01D4, 0x01D5, 0x01D6, 0x01D7, 0x01D8, 0x01D9, 0x01DA, 0x01DB, 0x01DC,
0x01DE, 0x01DF, 0x01E0, 0x01E1, 0x01E2, 0x01E3, 0x01E4, 0x01E5, 0x01E6, 0x01E7, 0x01E8, 0x01E9, 0x01EA, 0x01EB, 0x01EC, 0x01ED,
0x01EE, 0x01EF, 0x01F1, 0x01F3, 0x01F4, 0x01F5, 0x01F8, 0x01F9, 0x01FA, 0x01FB, 0x01FC, 0x01FD, 0x01FE, 0x01FF, 0x0200, 0x0201,
0x0202, 0x0203, 0x0204, 0x0205, 0x0206, 0x0207, 0x0208, 0x0209, 0x020A, 0x020B, 0x020C, 0x020D, 0x020E, 0x020F, 0x0210, 0x0211,
0x0212, 0x0213, 0x0214, 0x0215, 0x0216, 0x0217, 0x0218, 0x0219, 0x021A, 0x021B, 0x021C, 0x021D, 0x021E, 0x021F, 0x0220, 0x019E,
0x0222, 0x0223, 0x0224, 0x0225, 0x0226, 0x0227, 0x0228, 0x0229, 0x022A, 0x022B, 0x022C, 0x022D, 0x022E, 0x022F, 0x0230, 0x0231,
0x0232, 0x0233, 0x023A, 0x2C65, 0x023B, 0x023C, 0x023D, 0x019A, 0x023E, 0x2C66, 0x0241, 0x0242, 0x0243, 0x0180, 0x0244, 0x0289,
0x0245, 0x028C, 0x0246, 0x0247, 0x0248, 0x0249, 0x024C, 0x024D, 0x024E, 0x024F, 0x0370, 0x0371, 0x0372, 0x0373, 0x0376, 0x0377,
0x0386, 0x03AC, 0x0388, 0x03AD, 0x0389, 0x03AE, 0x038A, 0x03AF, 0x038C, 0x03CC, 0x038E, 0x03CD, 0x038F, 0x03CE, 0x0391, 0x03B1,
0x0392, 0x03B2, 0x0393, 0x03B3, 0x0394, 0x03B4, 0x0395, 0x03B5, 0x0396, 0x03B6, 0x0397, 0x03B7, 0x0398, 0x03B8, 0x0399, 0x03B9,
0x039A, 0x03BA, 0x039B, 0x03BB, 0x039C, 0x03BC, 0x039D, 0x03BD, 0x039E, 0x03BE, 0x039F, 0x03BF, 0x03A0, 0x03C0, 0x03A1, 0x03C1,
0x03A3, 0x03C3, 0x03A4, 0x03C4, 0x03A5, 0x03C5, 0x03A6, 0x03C6, 0x03A7, 0x03C7, 0x03A8, 0x03C8, 0x03A9, 0x03C9, 0x03AA, 0x03CA,
0x03AB, 0x03CB, 0x03E2, 0x03E3, 0x03E4, 0x03E5, 0x03E6, 0x03E7, 0x03E8, 0x03E9, 0x03EA, 0x03EB, 0x03EC, 0x03ED, 0x03EE, 0x03EF,
0x03F7, 0x03F8, 0x03FA, 0x03FB, 0x0400, 0x0450, 0x0401, 0x0451, 0x0402, 0x0452, 0x0403, 0x0453, 0x0404, 0x0454, 0x0405, 0x0455,
0x0406, 0x0456, 0x0407, 0x0457, 0x0408, 0x0458, 0x0409, 0x0459, 0x040A, 0x045A, 0x040B, 0x045B, 0x040C, 0x045C, 0x040D, 0x045D,
0x040E, 0x045E, 0x040F, 0x045F, 0x0410, 0x0430, 0x0411, 0x0431, 0x0412, 0x0432, 0x0413, 0x0433, 0x0414, 0x0434, 0x0415, 0x0435,
0x0416, 0x0436, 0x0417, 0x0437, 0x0418, 0x0438, 0x0419, 0x0439, 0x041A, 0x043A, 0x041B, 0x043B, 0x041C, 0x043C, 0x041D, 0x043D,
0x041E, 0x043E, 0x041F, 0x043F, 0x0420, 0x0440, 0x0421, 0x0441, 0x0422, 0x0442, 0x0423, 0x0443, 0x0424, 0x0444, 0x0425, 0x0445,
0x0426, 0x0446, 0x0427, 0x0447, 0x0428, 0x0448, 0x0429, 0x0449, 0x042A, 0x044A, 0x042B, 0x044B, 0x042C, 0x044C, 0x042D, 0x044D,
0x042E, 0x044E, 0x042F, 0x044F, 0x0460, 0x0461, 0x0462, 0x0463, 0x0464, 0x0465, 0x0466, 0x0467, 0x0468, 0x0469, 0x046A, 0x046B,
0x046C, 0x046D, 0x046E, 0x046F, 0x0470, 0x0471, 0x0472, 0x0473, 0x0474, 0x0475, 0x0476, 0x0477, 0x0478, 0x0479, 0x047A, 0x047B,
0x047C, 0x047D, 0x047E, 0x047F, 0x0480, 0x0481, 0x048A, 0x048B, 0x048C, 0x048D, 0x048E, 0x048F, 0x0490, 0x0491, 0x0492, 0x0493,
0x0494, 0x0495, 0x0496, 0x0497, 0x0498, 0x0499, 0x049A, 0x049B, 0x049C, 0x049D, 0x049E, 0x049F, 0x04A0, 0x04A1, 0x04A2, 0x04A3,
0x04A6, 0x04A7, 0x04A8, 0x04A9, 0x04AA, 0x04AB, 0x04AC, 0x04AD, 0x04AE, 0x04AF, 0x04B0, 0x04B1, 0x04B2, 0x04B3, 0x04B6, 0x04B7,
0x04B8, 0x04B9, 0x04BA, 0x04BB, 0x04BC, 0x04BD, 0x04BE, 0x04BF, 0x04C1, 0x04C2, 0x04C3, 0x04C4, 0x04C5, 0x04C6, 0x04C7, 0x04C8,
0x04C9, 0x04CA, 0x04CB, 0x04CC, 0x04CD, 0x04CE, 0x04D0, 0x04D1, 0x04D2, 0x04D3, 0x04D6, 0x04D7, 0x04D8, 0x04D9, 0x04DA, 0x04DB,
0x04DC, 0x04DD, 0x04DE, 0x04DF, 0x04E0, 0x04E1, 0x04E2, 0x04E3, 0x04E4, 0x04E5, 0x04E6, 0x04E7, 0x04E8, 0x04E9, 0x04EA, 0x04EB,
0x04EC, 0x04ED, 0x04EE, 0x04EF, 0x04F0, 0x04F1, 0x04F2, 0x04F3, 0x04F4, 0x04F5, 0x04F6, 0x04F7, 0x04F8, 0x04F9, 0x04FA, 0x04FB,
0x04FC, 0x04FD, 0x04FE, 0x04FF, 0x0500, 0x0501, 0x0502, 0x0503, 0x0504, 0x0505, 0x0506, 0x0507, 0x0508, 0x0509, 0x050A, 0x050B,
0x050C, 0x050D, 0x050E, 0x050F, 0x0510, 0x0511, 0x0512, 0x0513, 0x0514, 0x0515, 0x0516, 0x0517, 0x0518, 0x0519, 0x051A, 0x051B,
0x051C, 0x051D, 0x051E, 0x051F, 0x0520, 0x0521, 0x0522, 0x0523, 0x0524, 0x0525, 0x0526, 0x0527, 0x0528, 0x0529, 0x052A, 0x052B,
0x052C, 0x052D, 0x052E, 0x052F, 0x0531, 0x0561, 0x0532, 0x0562, 0x0533, 0x0563, 0x0534, 0x0564, 0x0535, 0x0565, 0x0536, 0x0566,
0x0537, 0x0567, 0x0538, 0x0568, 0x0539, 0x0569, 0x053A, 0x056A, 0x053B, 0x056B, 0x053C, 0x056C, 0x053D, 0x056D, 0x053E, 0x056E,
0x053F, 0x056F, 0x0540, 0x0570, 0x0541, 0x0571, 0x0542, 0x0572, 0x0543, 0x0573, 0x0544, 0x0574, 0x0545, 0x0575, 0x0546, 0x0576,
0x0547, 0x0577, 0x0548, 0x0578, 0x0549, 0x0579, 0x054A, 0x057A, 0x054B, 0x057B, 0x054C, 0x057C, 0x054D, 0x057D, 0x054E, 0x057E,
0x054F, 0x057F, 0x0550, 0x0580, 0x0551, 0x0581, 0x0552, 0x0582, 0x0553, 0x0583, 0x0554, 0x0584, 0x0555, 0x0585, 0x0556, 0x0586,
0x10A0, 0x2D00, 0x10A1, 0x2D01, 0x10A2, 0x2D02, 0x10A3, 0x2D03, 0x10A4, 0x2D04, 0x10A5, 0x2D05, 0x10A6, 0x2D06, 0x10A7, 0x2D07,
0x10A8, 0x2D08, 0x10A9, 0x2D09, 0x10AA, 0x2D0A, 0x10AB, 0x2D0B, 0x10AC, 0x2D0C, 0x10AD, 0x2D0D, 0x10AE, 0x2D0E, 0x10AF, 0x2D0F,
0x10B0, 0x2D10, 0x10B1, 0x2D11, 0x10B2, 0x2D12, 0x10B3, 0x2D13, 0x10B4, 0x2D14, 0x10B5, 0x2D15, 0x10B6, 0x2D16, 0x10B7, 0x2D17,
0x10B8, 0x2D18, 0x10B9, 0x2D19, 0x10BA, 0x2D1A, 0x10BB, 0x2D1B, 0x10BC, 0x2D1C, 0x10BD, 0x2D1D, 0x10BE, 0x2D1E, 0x10BF, 0x2D1F,
0x10C0, 0x2D20, 0x10C1, 0x2D21, 0x10C2, 0x2D22, 0x10C3, 0x2D23, 0x10C4, 0x2D24, 0x10C5, 0x2D25, 0x10C7, 0x2D27, 0x10CD, 0x2D2D,
0x1E00, 0x1E01, 0x1E02, 0x1E03, 0x1E04, 0x1E05, 0x1E06, 0x1E07, 0x1E08, 0x1E09, 0x1E0A, 0x1E0B, 0x1E0C, 0x1E0D, 0x1E0E, 0x1E0F,
0x1E10, 0x1E11, 0x1E12, 0x1E13, 0x1E14, 0x1E15, 0x1E16, 0x1E17, 0x1E18, 0x1E19, 0x1E1A, 0x1E1B, 0x1E1C, 0x1E1D, 0x1E1E, 0x1E1F,
0x1E20, 0x1E21, 0x1E22, 0x1E23, 0x1E24, 0x1E25, 0x1E26, 0x1E27, 0x1E28, 0x1E29, 0x1E2A, 0x1E2B, 0x1E2C, 0x1E2D, 0x1E2E, 0x1E2F,
0x1E30, 0x1E31, 0x1E32, 0x1E33, 0x1E34, 0x1E35, 0x1E36, 0x1E37, 0x1E38, 0x1E39, 0x1E3A, 0x1E3B, 0x1E3C, 0x1E3D, 0x1E3E, 0x1E3F,
0x1E40, 0x1E41, 0x1E42, 0x1E43, 0x1E44, 0x1E45, 0x1E46, 0x1E47, 0x1E48, 0x1E49, 0x1E4A, 0x1E4B, 0x1E4C, 0x1E4D, 0x1E4E, 0x1E4F,
0x1E50, 0x1E51, 0x1E52, 0x1E53, 0x1E54, 0x1E55, 0x1E56, 0x1E57, 0x1E58, 0x1E59, 0x1E5A, 0x1E5B, 0x1E5C, 0x1E5D, 0x1E5E, 0x1E5F,
0x1E60, 0x1E61, 0x1E62, 0x1E63, 0x1E64, 0x1E65, 0x1E66, 0x1E67, 0x1E68, 0x1E69, 0x1E6A, 0x1E6B, 0x1E6C, 0x1E6D, 0x1E6E, 0x1E6F,
0x1E70, 0x1E71, 0x1E72, 0x1E73, 0x1E74, 0x1E75, 0x1E76, 0x1E77, 0x1E78, 0x1E79, 0x1E7A, 0x1E7B, 0x1E7C, 0x1E7D, 0x1E7E, 0x1E7F,
0x1E80, 0x1E81, 0x1E82, 0x1E83, 0x1E84, 0x1E85, 0x1E86, 0x1E87, 0x1E88, 0x1E89, 0x1E8A, 0x1E8B, 0x1E8C, 0x1E8D, 0x1E8E, 0x1E8F,
0x1E90, 0x1E91, 0x1E92, 0x1E93, 0x1E94, 0x1E95, 0x1E9E, 0x00DF, 0x1EA0, 0x1EA1, 0x1EA2, 0x1EA3, 0x1EA4, 0x1EA5, 0x1EA6, 0x1EA7,
0x1EA8, 0x1EA9, 0x1EAA, 0x1EAB, 0x1EAC, 0x1EAD, 0x1EAE, 0x1EAF, 0x1EB0, 0x1EB1, 0x1EB2, 0x1EB3, 0x1EB4, 0x1EB5, 0x1EB6, 0x1EB7,
0x1EB8, 0x1EB9, 0x1EBA, 0x1EBB, 0x1EBC, 0x1EBD, 0x1EBE, 0x1EBF, 0x1EC0, 0x1EC1, 0x1EC2, 0x1EC3, 0x1EC4, 0x1EC5, 0x1EC6, 0x1EC7,
0x1EC8, 0x1EC9, 0x1ECA, 0x1ECB, 0x1ECC, 0x1ECD, 0x1ECE, 0x1ECF, 0x1ED0, 0x1ED1, 0x1ED2, 0x1ED3, 0x1ED4, 0x1ED5, 0x1ED6, 0x1ED7,
0x1ED8, 0x1ED9, 0x1EDA, 0x1EDB, 0x1EDC, 0x1EDD, 0x1EDE, 0x1EDF, 0x1EE0, 0x1EE1, 0x1EE2, 0x1EE3, 0x1EE4, 0x1EE5, 0x1EE6, 0x1EE7,
0x1EE8, 0x1EE9, 0x1EEA, 0x1EEB, 0x1EEC, 0x1EED, 0x1EEE, 0x1EEF, 0x1EF0, 0x1EF1, 0x1EF2, 0x1EF3, 0x1EF4, 0x1EF5, 0x1EF6, 0x1EF7,
0x1EF8, 0x1EF9, 0x1EFA, 0x1EFB, 0x1EFC, 0x1EFD, 0x1EFE, 0x1EFF, 0x1F08, 0x1F00, 0x1F09, 0x1F01, 0x1F0A, 0x1F02, 0x1F0B, 0x1F03,
0x1F0C, 0x1F04, 0x1F0D, 0x1F05, 0x1F0E, 0x1F06, 0x1F0F, 0x1F07, 0x1F18, 0x1F10, 0x1F19, 0x1F11, 0x1F1A, 0x1F12, 0x1F1B, 0x1F13,
0x1F1C, 0x1F14, 0x1F1D, 0x1F15, 0x1F28, 0x1F20, 0x1F29, 0x1F21, 0x1F2A, 0x1F22, 0x1F2B, 0x1F23, 0x1F2C, 0x1F24, 0x1F2D, 0x1F25,
0x1F2E, 0x1F26, 0x1F2F, 0x1F27, 0x1F38, 0x1F30, 0x1F39, 0x1F31, 0x1F3A, 0x1F32, 0x1F3B, 0x1F33, 0x1F3C, 0x1F34, 0x1F3D, 0x1F35,
0x1F3E, 0x1F36, 0x1F3F, 0x1F37, 0x1F48, 0x1F40, 0x1F49, 0x1F41, 0x1F4A, 0x1F42, 0x1F4B, 0x1F43, 0x1F4C, 0x1F44, 0x1F4D, 0x1F45,
0x1F59, 0x1F51, 0x1F5B, 0x1F53, 0x1F5D, 0x1F55, 0x1F5F, 0x1F57, 0x1F68, 0x1F60, 0x1F69, 0x1F61, 0x1F6A, 0x1F62, 0x1F6B, 0x1F63,
0x1F6C, 0x1F64, 0x1F6D, 0x1F65, 0x1F6E, 0x1F66, 0x1F6F, 0x1F67, 0x1FB8, 0x1FB0, 0x1FB9, 0x1FB1, 0x1FBA, 0x1F70, 0x1FBB, 0x1F71,
0x1FC8, 0x1F72, 0x1FC9, 0x1F73, 0x1FCA, 0x1F74, 0x1FCB, 0x1F75, 0x1FD8, 0x1FD0, 0x1FD9, 0x1FD1, 0x1FDA, 0x1F76, 0x1FDB, 0x1F77,
0x1FE8, 0x1FE0, 0x1FE9, 0x1FE1, 0x1FEA, 0x1F7A, 0x1FEB, 0x1F7B, 0x1FEC, 0x1FE5, 0x1FF8, 0x1F78, 0x1FF9, 0x1F79, 0x1FFA, 0x1F7C,
0x1FFB, 0x1F7D, 0x2C00, 0x2C30, 0x2C01, 0x2C31, 0x2C02, 0x2C32, 0x2C03, 0x2C33, 0x2C04, 0x2C34, 0x2C05, 0x2C35, 0x2C06, 0x2C36,
0x2C07, 0x2C37, 0x2C08, 0x2C38, 0x2C09, 0x2C39, 0x2C0A, 0x2C3A, 0x2C0B, 0x2C3B, 0x2C0C, 0x2C3C, 0x2C0D, 0x2C3D, 0x2C0E, 0x2C3E,
0x2C0F, 0x2C3F, 0x2C10, 0x2C40, 0x2C11, 0x2C41, 0x2C12, 0x2C42, 0x2C13, 0x2C43, 0x2C14, 0x2C44, 0x2C15, 0x2C45, 0x2C16, 0x2C46,
0x2C17, 0x2C47, 0x2C18, 0x2C48, 0x2C19, 0x2C49, 0x2C1A, 0x2C4A, 0x2C1B, 0x2C4B, 0x2C1C, 0x2C4C, 0x2C1D, 0x2C4D, 0x2C1E, 0x2C4E,
0x2C1F, 0x2C4F, 0x2C20, 0x2C50, 0x2C21, 0x2C51, 0x2C22, 0x2C52, 0x2C23, 0x2C53, 0x2C24, 0x2C54, 0x2C25, 0x2C55, 0x2C26, 0x2C56,
0x2C27, 0x2C57, 0x2C28, 0x2C58, 0x2C29, 0x2C59, 0x2C2A, 0x2C5A, 0x2C2B, 0x2C5B, 0x2C2C, 0x2C5C, 0x2C2D, 0x2C5D, 0x2C2E, 0x2C5E,
0x2C60, 0x2C61, 0x2C62, 0x026B, 0x2C63, 0x1D7D, 0x2C64, 0x027D, 0x2C67, 0x2C68, 0x2C69, 0x2C6A, 0x2C6B, 0x2C6C, 0x2C6D, 0x0251,
0x2C6E, 0x0271, 0x2C6F, 0x0250, 0x2C70, 0x0252, 0x2C72, 0x2C73, 0x2C75, 0x2C76, 0x2C7E, 0x023F, 0x2C7F, 0x0240, 0x2C80, 0x2C81,
0x2C82, 0x2C83, 0x2C84, 0x2C85, 0x2C86, 0x2C87, 0x2C88, 0x2C89, 0x2C8A, 0x2C8B, 0x2C8C, 0x2C8D, 0x2C8E, 0x2C8F, 0x2C90, 0x2C91,
0x2C92, 0x2C93, 0x2C94, 0x2C95, 0x2C96, 0x2C97, 0x2C98, 0x2C99, 0x2C9A, 0x2C9B, 0x2C9C, 0x2C9D, 0x2C9E, 0x2C9F, 0x2CA0, 0x2CA1,
0x2CA2, 0x2CA3, 0x2CA4, 0x2CA5, 0x2CA6, 0x2CA7, 0x2CA8, 0x2CA9, 0x2CAA, 0x2CAB, 0x2CAC, 0x2CAD, 0x2CAE, 0x2CAF, 0x2CB0, 0x2CB1,
0x2CB2, 0x2CB3, 0x2CB4, 0x2CB5, 0x2CB6, 0x2CB7, 0x2CB8, 0x2CB9, 0x2CBA, 0x2CBB, 0x2CBC, 0x2CBD, 0x2CBE, 0x2CBF, 0x2CC0, 0x2CC1,
0x2CC2, 0x2CC3, 0x2CC4, 0x2CC5, 0x2CC6, 0x2CC7, 0x2CC8, 0x2CC9, 0x2CCA, 0x2CCB, 0x2CCC, 0x2CCD, 0x2CCE, 0x2CCF, 0x2CD0, 0x2CD1,
0x2CD2, 0x2CD3, 0x2CD4, 0x2CD5, 0x2CD6, 0x2CD7, 0x2CD8, 0x2CD9, 0x2CDA, 0x2CDB, 0x2CDC, 0x2CDD, 0x2CDE, 0x2CDF, 0x2CE0, 0x2CE1,
0x2CE2, 0x2CE3, 0x2CEB, 0x2CEC, 0x2CED, 0x2CEE, 0x2CF2, 0x2CF3, 0xA640, 0xA641, 0xA642, 0xA643, 0xA644, 0xA645, 0xA646, 0xA647,
0xA648, 0xA649, 0xA64A, 0xA64B, 0xA64C, 0xA64D, 0xA64E, 0xA64F, 0xA650, 0xA651, 0xA652, 0xA653, 0xA654, 0xA655, 0xA656, 0xA657,
0xA658, 0xA659, 0xA65A, 0xA65B, 0xA65C, 0xA65D, 0xA65E, 0xA65F, 0xA660, 0xA661, 0xA662, 0xA663, 0xA664, 0xA665, 0xA666, 0xA667,
0xA668, 0xA669, 0xA66A, 0xA66B, 0xA66C, 0xA66D, 0xA680, 0xA681, 0xA682, 0xA683, 0xA684, 0xA685, 0xA686, 0xA687, 0xA688, 0xA689,
0xA68A, 0xA68B, 0xA68C, 0xA68D, 0xA68E, 0xA68F, 0xA690, 0xA691, 0xA692, 0xA693, 0xA694, 0xA695, 0xA696, 0xA697, 0xA698, 0xA699,
0xA69A, 0xA69B, 0xA722, 0xA723, 0xA724, 0xA725, 0xA726, 0xA727, 0xA728, 0xA729, 0xA72A, 0xA72B, 0xA72C, 0xA72D, 0xA72E, 0xA72F,
0xA732, 0xA733, 0xA734, 0xA735, 0xA736, 0xA737, 0xA738, 0xA739, 0xA73A, 0xA73B, 0xA73C, 0xA73D, 0xA73E, 0xA73F, 0xA740, 0xA741,
0xA742, 0xA743, 0xA744, 0xA745, 0xA746, 0xA747, 0xA748, 0xA749, 0xA74A, 0xA74B, 0xA74C, 0xA74D, 0xA74E, 0xA74F, 0xA750, 0xA751,
0xA752, 0xA753, 0xA754, 0xA755, 0xA756, 0xA757, 0xA758, 0xA759, 0xA75A, 0xA75B, 0xA75C, 0xA75D, 0xA75E, 0xA75F, 0xA760, 0xA761,
0xA762, 0xA763, 0xA764, 0xA765, 0xA766, 0xA767, 0xA768, 0xA769, 0xA76A, 0xA76B, 0xA76C, 0xA76D, 0xA76E, 0xA76F, 0xA779, 0xA77A,
0xA77B, 0xA77C, 0xA77D, 0x1D79, 0xA77E, 0xA77F, 0xA780, 0xA781, 0xA782, 0xA783, 0xA784, 0xA785, 0xA786, 0xA787, 0xA78B, 0xA78C,
0xA78D, 0x0265, 0xA790, 0xA791, 0xA792, 0xA793, 0xA796, 0xA797, 0xA798, 0xA799, 0xA79A, 0xA79B, 0xA79C, 0xA79D, 0xA79E, 0xA79F,
0xA7A0, 0xA7A1, 0xA7A2, 0xA7A3, 0xA7A4, 0xA7A5, 0xA7A6, 0xA7A7, 0xA7A8, 0xA7A9, 0xA7AA, 0x0266, 0xA7AB, 0x025C, 0xA7AC, 0x0261,
0xA7AD, 0x026C, 0xA7B0, 0x029E, 0xA7B1, 0x0287, 0xA7B2, 0x029D, 0xA7B3, 0xAB53, 0xA7B4, 0xA7B5, 0xA7B6, 0xA7B7,
0, 0 };

unsigned short atolfuzz[] = {
0x0041, 0x0061, 0x0042, 0x0062, 0x0043, 0x0063, 0x0044, 0x0064, 0x0045, 0x0065, 0x0046, 0x0066, 0x0047, 0x0067, 0x0048, 0x0068,
0x0049, 0x0069, 0x004A, 0x006A, 0x004B, 0x006B, 0x004C, 0x006C, 0x004D, 0x006D, 0x004E, 0x006E, 0x004F, 0x006F, 0x0050, 0x0070,
0x0051, 0x0071, 0x0052, 0x0072, 0x0053, 0x0073, 0x0054, 0x0074, 0x0055, 0x0075, 0x0056, 0x0076, 0x0057, 0x0077, 0x0058, 0x0078,
0x0059, 0x0079, 0x005A, 0x007A, 0x0061, 0x0061, 0x0062, 0x0062, 0x0063, 0x0063, 0x0064, 0x0064, 0x0065, 0x0065, 0x0066, 0x0066,
0x0067, 0x0067, 0x0068, 0x0068, 0x0069, 0x0069, 0x006A, 0x006A, 0x006B, 0x006B, 0x006C, 0x006C, 0x006D, 0x006D, 0x006E, 0x006E,
0x006F, 0x006F, 0x0070, 0x0070, 0x0071, 0x0071, 0x0072, 0x0072, 0x0073, 0x0073, 0x0074, 0x0074, 0x0075, 0x0075, 0x0076, 0x0076,
0x0077, 0x0077, 0x0078, 0x0078, 0x0079, 0x0079, 0x007A, 0x007A, 0x00C0, 0x0061, 0x00C1, 0x0061, 0x00C2, 0x0061, 0x00C3, 0x0061,
0x00C4, 0x0061, 0x00C5, 0x0061, 0x00C6, 0x00E6, 0x00C7, 0x0063, 0x00C8, 0x0065, 0x00C9, 0x0065, 0x00CA, 0x0065, 0x00CB, 0x0065,
0x00CC, 0x0069, 0x00CD, 0x0069, 0x00CE, 0x0069, 0x00CF, 0x0069, 0x00D0, 0x00F0, 0x00D1, 0x006E, 0x00D2, 0x006F, 0x00D3, 0x006F,
0x00D4, 0x006F, 0x00D5, 0x006F, 0x00D6, 0x006F, 0x00D8, 0x006F, 0x00D9, 0x0075, 0x00DA, 0x0075, 0x00DB, 0x0075, 0x00DC, 0x0075,
0x00DD, 0x0079, 0x00DE, 0x00FE, 0x00E0, 0x0061, 0x00E1, 0x0061, 0x00E2, 0x0061, 0x00E3, 0x0061, 0x00E4, 0x0061, 0x00E5, 0x0061,
0x00E6, 0x00E6, 0x00E7, 0x0063, 0x00E8, 0x0065, 0x00E9, 0x0065, 0x00EA, 0x0065, 0x00EB, 0x0065, 0x00EC, 0x0069, 0x00ED, 0x0069,
0x00EE, 0x0069, 0x00EF, 0x0069, 0x00F0, 0x00F0, 0x00F1, 0x006E, 0x00F2, 0x006F, 0x00F3, 0x006F, 0x00F4, 0x006F, 0x00F5, 0x006F,
0x00F6, 0x006F, 0x00F8, 0x006F, 0x00F9, 0x0075, 0x00FA, 0x0075, 0x00FB, 0x0075, 0x00FC, 0x0075, 0x00FD, 0x0079, 0x00FE, 0x00FE,
0x00FF, 0x0079, 0x0100, 0x0061, 0x0101, 0x0061, 0x0102, 0x0061, 0x0103, 0x0061, 0x0104, 0x0061, 0x0105, 0x0061, 0x0106, 0x0063,
0x0107, 0x0063, 0x0108, 0x0063, 0x0109, 0x0063, 0x010A, 0x0063, 0x010B, 0x0063, 0x010C, 0x0063, 0x010D, 0x0063, 0x010E, 0x0064,
0x010F, 0x0064, 0x0110, 0x0064, 0x0111, 0x0064, 0x0112, 0x0065, 0x0113, 0x0065, 0x0114, 0x0065, 0x0115, 0x0065, 0x0116, 0x0065,
0x0117, 0x0065, 0x0118, 0x0065, 0x0119, 0x0065, 0x011A, 0x0065, 0x011B, 0x0065, 0x011C, 0x0067, 0x011D, 0x0067, 0x011E, 0x0067,
0x011F, 0x0067, 0x0120, 0x0067, 0x0121, 0x0067, 0x0122, 0x0067, 0x0123, 0x0067, 0x0124, 0x0068, 0x0125, 0x0068, 0x0126, 0x0068,
0x0127, 0x0068, 0x0128, 0x0069, 0x0129, 0x0069, 0x012A, 0x0069, 0x012B, 0x0069, 0x012C, 0x0069, 0x012D, 0x0069, 0x012E, 0x0069,
0x012F, 0x0069, 0x0134, 0x006A, 0x0135, 0x006A, 0x0136, 0x006B, 0x0137, 0x006B, 0x0138, 0x0138, 0x0139, 0x006C, 0x013A, 0x006C,
0x013B, 0x006C, 0x013C, 0x006C, 0x013D, 0x006C, 0x013E, 0x006C, 0x013F, 0x006C, 0x0140, 0x006C, 0x0141, 0x006C, 0x0142, 0x006C,
0x0143, 0x006E, 0x0144, 0x006E, 0x0145, 0x006E, 0x0146, 0x006E, 0x0147, 0x006E, 0x0148, 0x006E, 0x0149, 0x006E, 0x014A, 0x014B,
0x014B, 0x014B, 0x014C, 0x006F, 0x014D, 0x006F, 0x014E, 0x006F, 0x014F, 0x006F, 0x0150, 0x006F, 0x0151, 0x006F, 0x0154, 0x0072,
0x0155, 0x0072, 0x0156, 0x0072, 0x0157, 0x0072, 0x0158, 0x0072, 0x0159, 0x0072, 0x015A, 0x0073, 0x015B, 0x0073, 0x015C, 0x0073,
0x015D, 0x0073, 0x015E, 0x0073, 0x015F, 0x0073, 0x0160, 0x0073, 0x0161, 0x0073, 0x0162, 0x0074, 0x0163, 0x0074, 0x0164, 0x0074,
0x0165, 0x0074, 0x0166, 0x0074, 0x0167, 0x0074, 0x0168, 0x0075, 0x0169, 0x0075, 0x016A, 0x0075, 0x016B, 0x0075, 0x016C, 0x0075,
0x016D, 0x0075, 0x016E, 0x0075, 0x016F, 0x0075, 0x0170, 0x0075, 0x0171, 0x0075, 0x0172, 0x0075, 0x0173, 0x0075, 0x0174, 0x0077,
0x0175, 0x0077, 0x0176, 0x0079, 0x0177, 0x0079, 0x0178, 0x0079, 0x0179, 0x007A, 0x017A, 0x007A, 0x017B, 0x007A, 0x017C, 0x007A,
0x017D, 0x007A, 0x017E, 0x007A, 0x0180, 0x0062, 0x0181, 0x0062, 0x0182, 0x0062, 0x0183, 0x0062, 0x0187, 0x0063, 0x0188, 0x0063,
0x018A, 0x0064, 0x018B, 0x0064, 0x018C, 0x0064, 0x018F, 0x0259, 0x0191, 0x0066, 0x0192, 0x0066, 0x0193, 0x0067, 0x0194, 0x0263,
0x0195, 0x0195, 0x0196, 0x0269, 0x0197, 0x0069, 0x0198, 0x006B, 0x0199, 0x006B, 0x019A, 0x006C, 0x019D, 0x006E, 0x019E, 0x006E,
0x01A0, 0x006F, 0x01A1, 0x006F, 0x01A2, 0x01A3, 0x01A3, 0x01A3, 0x01A4, 0x0070, 0x01A5, 0x0070, 0x01A9, 0x0283, 0x01AB, 0x0074,
0x01AC, 0x0074, 0x01AD, 0x0074, 0x01AE, 0x0074, 0x01AF, 0x0075, 0x01B0, 0x0075, 0x01B1, 0x028A, 0x01B2, 0x0076, 0x01B3, 0x0079,
0x01B4, 0x0079, 0x01B5, 0x007A, 0x01B6, 0x007A, 0x01B7, 0x0292, 0x01B8, 0x0292, 0x01B9, 0x0292, 0x01BA, 0x0292, 0x01C4, 0x01F3,
0x01C6, 0x01F3, 0x01C7, 0x01C9, 0x01C9, 0x01C9, 0x01CA, 0x01CC, 0x01CC, 0x01CC, 0x01CD, 0x0061, 0x01CE, 0x0061, 0x01CF, 0x0069,
0x01D0, 0x0069, 0x01D1, 0x006F, 0x01D2, 0x006F, 0x01D3, 0x0075, 0x01D4, 0x0075, 0x01D5, 0x0075, 0x01D6, 0x0075, 0x01D7, 0x0075,
0x01D8, 0x0075, 0x01D9, 0x0075, 0x01DA, 0x0075, 0x01DB, 0x0075, 0x01DC, 0x0075, 0x01DE, 0x0061, 0x01DF, 0x0061, 0x01E0, 0x0061,
0x01E1, 0x0061, 0x01E2, 0x00E6, 0x01E3, 0x00E6, 0x01E4, 0x0067, 0x01E5, 0x0067, 0x01E6, 0x0067, 0x01E7, 0x0067, 0x01E8, 0x006B,
0x01E9, 0x006B, 0x01EA, 0x006F, 0x01EB, 0x006F, 0x01EC, 0x006F, 0x01ED, 0x006F, 0x01EE, 0x0292, 0x01EF, 0x0292, 0x01F0, 0x006A,
0x01F1, 0x01F3, 0x01F3, 0x01F3, 0x01F4, 0x0067, 0x01F5, 0x0067, 0x01F8, 0x006E, 0x01F9, 0x006E, 0x01FA, 0x0061, 0x01FB, 0x0061,
0x01FC, 0x00E6, 0x01FD, 0x00E6, 0x01FE, 0x006F, 0x01FF, 0x006F, 0x0200, 0x0061, 0x0201, 0x0061, 0x0202, 0x0061, 0x0203, 0x0061,
0x0204, 0x0065, 0x0205, 0x0065, 0x0206, 0x0065, 0x0207, 0x0065, 0x0208, 0x0069, 0x0209, 0x0069, 0x020A, 0x0069, 0x020B, 0x0069,
0x020C, 0x006F, 0x020D, 0x006F, 0x020E, 0x006F, 0x020F, 0x006F, 0x0210, 0x0072, 0x0211, 0x0072, 0x0212, 0x0072, 0x0213, 0x0072,
0x0214, 0x0075, 0x0215, 0x0075, 0x0216, 0x0075, 0x0217, 0x0075, 0x0218, 0x0073, 0x0219, 0x0073, 0x021A, 0x0074, 0x021B, 0x0074,
0x021C, 0x021D, 0x021D, 0x021D, 0x021E, 0x0068, 0x021F, 0x0068, 0x0220, 0x006E, 0x0221, 0x0064, 0x0222, 0x0223, 0x0223, 0x0223,
0x0224, 0x007A, 0x0225, 0x007A, 0x0226, 0x0061, 0x0227, 0x0061, 0x0228, 0x0065, 0x0229, 0x0065, 0x022A, 0x006F, 0x022B, 0x006F,
0x022C, 0x006F, 0x022D, 0x006F, 0x022E, 0x006F, 0x022F, 0x006F, 0x0230, 0x006F, 0x0231, 0x006F, 0x0232, 0x0079, 0x0233, 0x0079,
0x0234, 0x006C, 0x0235, 0x006E, 0x0236, 0x0074, 0x023A, 0x0061, 0x023B, 0x0063, 0x023C, 0x0063, 0x023D, 0x006C, 0x023E, 0x0074,
0x023F, 0x0073, 0x0240, 0x007A, 0x0243, 0x0062, 0x0244, 0x0075, 0x0246, 0x0065, 0x0247, 0x0065, 0x0248, 0x006A, 0x0249, 0x006A,
0x024B, 0x0071, 0x024C, 0x0072, 0x024D, 0x0072, 0x024E, 0x0079, 0x024F, 0x0079, 0x0251, 0x0251, 0x0253, 0x0062, 0x0255, 0x0063,
0x0256, 0x0064, 0x0257, 0x0064, 0x0259, 0x0259, 0x025A, 0x0259, 0x0260, 0x0067, 0x0263, 0x0263, 0x0266, 0x0068, 0x0267, 0xA727,
0x0268, 0x0069, 0x0269, 0x0269, 0x026B, 0x006C, 0x026C, 0x006C, 0x026D, 0x006C, 0x026E, 0x026E, 0x0271, 0x006D, 0x0272, 0x006E,
0x0273, 0x006E, 0x0278, 0x0278, 0x027C, 0x0072, 0x027D, 0x0072, 0x027E, 0x0072, 0x0282, 0x0073, 0x0283, 0x0283, 0x0286, 0x0283,
0x0288, 0x0074, 0x0289, 0x0075, 0x028A, 0x028A, 0x028B, 0x0076, 0x0290, 0x007A, 0x0291, 0x007A, 0x0292, 0x0292, 0x0293, 0x0292,
0x029D, 0x006A, 0x02A0, 0x0071, 0x02A3, 0x01F3, 0x02A5, 0x01F3, 0x0370, 0x0371, 0x0371, 0x0371, 0x0386, 0x03B1, 0x0388, 0x03B5,
0x0389, 0x03B7, 0x038A, 0x03B9, 0x038C, 0x03BF, 0x038E, 0x03C5, 0x038F, 0x03C9, 0x0390, 0x03B9, 0x0391, 0x03B1, 0x0392, 0x03B2,
0x0393, 0x03B3, 0x0394, 0x03B4, 0x0395, 0x03B5, 0x0396, 0x03B6, 0x0397, 0x03B7, 0x0398, 0x03B8, 0x0399, 0x03B9, 0x039A, 0x03BA,
0x039B, 0x03BB, 0x039C, 0x03BC, 0x039D, 0x03BD, 0x039E, 0x03BE, 0x039F, 0x03BF, 0x03A0, 0x03C0, 0x03A1, 0x03C1, 0x03A3, 0x03C3,
0x03A4, 0x03C4, 0x03A5, 0x03C5, 0x03A6, 0x03C6, 0x03A7, 0x03C7, 0x03A8, 0x03C8, 0x03A9, 0x03C9, 0x03AA, 0x03B9, 0x03AB, 0x03C5,
0x03AC, 0x03B1, 0x03AD, 0x03B5, 0x03AE, 0x03B7, 0x03AF, 0x03B9, 0x03B0, 0x03C5, 0x03B1, 0x03B1, 0x03B2, 0x03B2, 0x03B3, 0x03B3,
0x03B4, 0x03B4, 0x03B5, 0x03B5, 0x03B6, 0x03B6, 0x03B7, 0x03B7, 0x03B8, 0x03B8, 0x03B9, 0x03B9, 0x03BA, 0x03BA, 0x03BB, 0x03BB,
0x03BC, 0x03BC, 0x03BD, 0x03BD, 0x03BE, 0x03BE, 0x03BF, 0x03BF, 0x03C0, 0x03C0, 0x03C1, 0x03C1, 0x03C3, 0x03C3, 0x03C4, 0x03C4,
0x03C5, 0x03C5, 0x03C6, 0x03C6, 0x03C7, 0x03C7, 0x03C8, 0x03C8, 0x03C9, 0x03C9, 0x03CA, 0x03B9, 0x03CB, 0x03C5, 0x03CC, 0x03BF,
0x03CD, 0x03C5, 0x03CE, 0x03C9, 0x03DB, 0x03DB, 0x03DD, 0x03DD, 0x03DF, 0x03DF, 0x03E1, 0x03E1, 0x03E2, 0x03E3, 0x03E3, 0x03E3,
0x03E4, 0x03E5, 0x03E5, 0x03E5, 0x03E6, 0x03E7, 0x03E7, 0x03E7, 0x03E8, 0x03E9, 0x03E9, 0x03E9, 0x03EA, 0x03EB, 0x03EB, 0x03EB,
0x03EC, 0x03ED, 0x03ED, 0x03ED, 0x03EE, 0x03EF, 0x03EF, 0x03EF, 0x03F7, 0x03F8, 0x03F8, 0x03F8, 0x03FA, 0x03FB, 0x03FB, 0x03FB,
0x0400, 0x0435, 0x0401, 0x0451, 0x0402, 0x0452, 0x0403, 0x0453, 0x0405, 0x0455, 0x0407, 0x0457, 0x0408, 0x0458, 0x0409, 0x0459,
0x040A, 0x045A, 0x040B, 0x045B, 0x040C, 0x045C, 0x040D, 0x0438, 0x040F, 0x045F, 0x0410, 0x0430, 0x0411, 0x0431, 0x0412, 0x0432,
0x0413, 0x0433, 0x0414, 0x0434, 0x0415, 0x0435, 0x0416, 0x0436, 0x0417, 0x0437, 0x0418, 0x0438, 0x041A, 0x043A, 0x041B, 0x043B,
0x041C, 0x043C, 0x041D, 0x043D, 0x041E, 0x043E, 0x041F, 0x043F, 0x0420, 0x0440, 0x0421, 0x0441, 0x0422, 0x0442, 0x0423, 0x0443,
0x0424, 0x0444, 0x0425, 0x0445, 0x0426, 0x0446, 0x0427, 0x0447, 0x0428, 0x0448, 0x0429, 0x0449, 0x042B, 0x044B, 0x042D, 0x044D,
0x042E, 0x044E, 0x042F, 0x044F, 0x0430, 0x0430, 0x0431, 0x0431, 0x0432, 0x0432, 0x0433, 0x0433, 0x0434, 0x0434, 0x0435, 0x0435,
0x0436, 0x0436, 0x0437, 0x0437, 0x0438, 0x0438, 0x043A, 0x043A, 0x043B, 0x043B, 0x043C, 0x043C, 0x043D, 0x043D, 0x043E, 0x043E,
0x043F, 0x043F, 0x0440, 0x0440, 0x0441, 0x0441, 0x0442, 0x0442, 0x0443, 0x0443, 0x0444, 0x0444, 0x0445, 0x0445, 0x0446, 0x0446,
0x0447, 0x0447, 0x0448, 0x0448, 0x0449, 0x0449, 0x044B, 0x044B, 0x044D, 0x044D, 0x044E, 0x044E, 0x044F, 0x044F, 0x0450, 0x0435,
0x0451, 0x0451, 0x0452, 0x0452, 0x0453, 0x0453, 0x0455, 0x0455, 0x0457, 0x0457, 0x0458, 0x0458, 0x0459, 0x0459, 0x045A, 0x045A,
0x045B, 0x045B, 0x045C, 0x045C, 0x045D, 0x0438, 0x045F, 0x045F, 0x0460, 0x0461, 0x0461, 0x0461, 0x0462, 0x0463, 0x0463, 0x0463,
0x046E, 0x046F, 0x046F, 0x046F, 0x0470, 0x0471, 0x0471, 0x0471, 0x0472, 0x0473, 0x0473, 0x0473, 0x0474, 0x0475, 0x0475, 0x0475,
0x0476, 0x0475, 0x0477, 0x0475, 0x0478, 0x0479, 0x0479, 0x0479, 0x047C, 0x0461, 0x047D, 0x0461, 0x047E, 0x047F, 0x047F, 0x047F,
0x0480, 0x0481, 0x0481, 0x0481, 0x048E, 0x0440, 0x048F, 0x0440, 0x0490, 0x0433, 0x0491, 0x0433, 0x0492, 0x0433, 0x0493, 0x0433,
0x0494, 0x0433, 0x0495, 0x0433, 0x0496, 0x0436, 0x0497, 0x0436, 0x0498, 0x0437, 0x0499, 0x0437, 0x049A, 0x043A, 0x049B, 0x043A,
0x049C, 0x043A, 0x049D, 0x043A, 0x049E, 0x043A, 0x049F, 0x043A, 0x04A2, 0x043D, 0x04A3, 0x043D, 0x04A6, 0x043F, 0x04A7, 0x043F,
0x04AA, 0x0441, 0x04AB, 0x0441, 0x04AC, 0x0442, 0x04AD, 0x0442, 0x04B2, 0x0445, 0x04B3, 0x0445, 0x04B6, 0x0447, 0x04B7, 0x0447,
0x04B8, 0x0447, 0x04B9, 0x0447, 0x04BA, 0x04BB, 0x04BB, 0x04BB, 0x04C1, 0x0436, 0x04C2, 0x0436, 0x04C3, 0x043A, 0x04C4, 0x043A,
0x04C5, 0x043B, 0x04C6, 0x043B, 0x04C7, 0x043D, 0x04C8, 0x043D, 0x04C9, 0x043D, 0x04CA, 0x043D, 0x04CD, 0x043C, 0x04CE, 0x043C,
0x04CF, 0x04CF, 0x04D0, 0x0430, 0x04D1, 0x0430, 0x04D2, 0x0430, 0x04D3, 0x0430, 0x04D6, 0x0435, 0x04D7, 0x0435, 0x04D8, 0x04D9,
0x04D9, 0x04D9, 0x04DA, 0x04D9, 0x04DB, 0x04D9, 0x04DC, 0x0436, 0x04DD, 0x0436, 0x04DE, 0x0437, 0x04DF, 0x0437, 0x04E2, 0x0438,
0x04E3, 0x0438, 0x04E4, 0x0438, 0x04E5, 0x0438, 0x04E6, 0x043E, 0x04E7, 0x043E, 0x04EC, 0x044D, 0x04ED, 0x044D, 0x04EE, 0x0443,
0x04EF, 0x0443, 0x04F0, 0x0443, 0x04F1, 0x0443, 0x04F2, 0x0443, 0x04F3, 0x0443, 0x04F4, 0x0447, 0x04F5, 0x0447, 0x04F6, 0x0433,
0x04F7, 0x0433, 0x04F8, 0x044B, 0x04F9, 0x044B, 0x04FA, 0x0433, 0x04FB, 0x0433, 0x04FC, 0x0445, 0x04FD, 0x0445, 0x04FE, 0x0445,
0x04FF, 0x0445, 0x0512, 0x043B, 0x0513, 0x043B, 0x0514, 0x0515, 0x0515, 0x0515, 0x0516, 0x0517, 0x0517, 0x0517, 0x0518, 0x0519,
0x0519, 0x0519, 0x051A, 0x051B, 0x051B, 0x051B, 0x051C, 0x051D, 0x051D, 0x051D, 0x0520, 0x043B, 0x0521, 0x043B, 0x0522, 0x043D,
0x0523, 0x043D, 0x0524, 0x043F, 0x0525, 0x043F, 0x0526, 0x04BB, 0x0527, 0x04BB, 0x0528, 0x043D, 0x0529, 0x043D, 0x052A, 0x052B,
0x052B, 0x052B, 0x052C, 0x052D, 0x052D, 0x052D, 0x052E, 0x043B, 0x052F, 0x043B, 0x0531, 0x0561, 0x0532, 0x0562, 0x0533, 0x0563,
0x0534, 0x0564, 0x0535, 0x0565, 0x0536, 0x0566, 0x0537, 0x0567, 0x0538, 0x0568, 0x0539, 0x0569, 0x053A, 0x056A, 0x053B, 0x056B,
0x053C, 0x056C, 0x053D, 0x056D, 0x053E, 0x056E, 0x053F, 0x056F, 0x0540, 0x0570, 0x0541, 0x0571, 0x0542, 0x0572, 0x0543, 0x0573,
0x0544, 0x0574, 0x0545, 0x0575, 0x0546, 0x0576, 0x0547, 0x0577, 0x0548, 0x0578, 0x0549, 0x0579, 0x054A, 0x057A, 0x054B, 0x057B,
0x054C, 0x057C, 0x054D, 0x057D, 0x054E, 0x057E, 0x054F, 0x057F, 0x0550, 0x0580, 0x0551, 0x0581, 0x0552, 0x0582, 0x0553, 0x0583,
0x0554, 0x0584, 0x0555, 0x0585, 0x0556, 0x0586, 0x0561, 0x0561, 0x0562, 0x0562, 0x0563, 0x0563, 0x0564, 0x0564, 0x0565, 0x0565,
0x0566, 0x0566, 0x0567, 0x0567, 0x0568, 0x0568, 0x0569, 0x0569, 0x056A, 0x056A, 0x056B, 0x056B, 0x056C, 0x056C, 0x056D, 0x056D,
0x056E, 0x056E, 0x056F, 0x056F, 0x0570, 0x0570, 0x0571, 0x0571, 0x0572, 0x0572, 0x0573, 0x0573, 0x0574, 0x0574, 0x0575, 0x0575,
0x0576, 0x0576, 0x0577, 0x0577, 0x0578, 0x0578, 0x0579, 0x0579, 0x057A, 0x057A, 0x057B, 0x057B, 0x057C, 0x057C, 0x057D, 0x057D,
0x057E, 0x057E, 0x057F, 0x057F, 0x0580, 0x0580, 0x0581, 0x0581, 0x0582, 0x0582, 0x0583, 0x0583, 0x0584, 0x0584, 0x0585, 0x0585,
0x0586, 0x0586, 0x10A0, 0x2D00, 0x10A1, 0x2D01, 0x10A2, 0x2D02, 0x10A3, 0x2D03, 0x10A4, 0x2D04, 0x10A5, 0x2D05, 0x10A6, 0x2D06,
0x10A7, 0x2D07, 0x10A8, 0x2D08, 0x10A9, 0x2D09, 0x10AA, 0x2D0A, 0x10AB, 0x2D0B, 0x10AC, 0x2D0C, 0x10AD, 0x2D0D, 0x10AE, 0x2D0E,
0x10AF, 0x2D0F, 0x10B0, 0x2D10, 0x10B1, 0x2D11, 0x10B2, 0x2D12, 0x10B3, 0x2D13, 0x10B4, 0x2D14, 0x10B5, 0x2D15, 0x10B6, 0x2D16,
0x10B7, 0x2D17, 0x10B8, 0x2D18, 0x10B9, 0x2D19, 0x10BA, 0x2D1A, 0x10BB, 0x2D1B, 0x10BC, 0x2D1C, 0x10BD, 0x2D1D, 0x10BE, 0x2D1E,
0x10BF, 0x2D1F, 0x10C0, 0x2D20, 0x10C1, 0x2D21, 0x10C2, 0x2D22, 0x10C3, 0x2D23, 0x10C4, 0x2D24, 0x10C5, 0x2D25, 0x10C7, 0x2D27,
0x10CD, 0x2D2D, 0x13F8, 0x13F8, 0x13F9, 0x13F9, 0x13FA, 0x13FA, 0x13FB, 0x13FB, 0x13FC, 0x13FC, 0x13FD, 0x13FD, 0x1930, 0x1930,
0x1931, 0x1931, 0x1932, 0x1932, 0x1933, 0x1933, 0x1934, 0x1934, 0x1935, 0x1935, 0x1936, 0x1936, 0x1937, 0x1937, 0x1938, 0x1938,
0x1D6B, 0x1D6B, 0x1D6C, 0x0062, 0x1D6D, 0x0064, 0x1D6E, 0x0066, 0x1D6F, 0x006D, 0x1D70, 0x006E, 0x1D71, 0x0070, 0x1D72, 0x0072,
0x1D73, 0x0072, 0x1D74, 0x0073, 0x1D75, 0x0074, 0x1D76, 0x007A, 0x1D7C, 0x0269, 0x1D7D, 0x0070, 0x1D7F, 0x028A, 0x1D80, 0x0062,
0x1D81, 0x0064, 0x1D82, 0x0066, 0x1D83, 0x0067, 0x1D84, 0x006B, 0x1D85, 0x006C, 0x1D86, 0x006D, 0x1D87, 0x006E, 0x1D88, 0x0070,
0x1D89, 0x0072, 0x1D8A, 0x0073, 0x1D8B, 0x0283, 0x1D8C, 0x0076, 0x1D8D, 0x0078, 0x1D8E, 0x007A, 0x1D8F, 0x0061, 0x1D90, 0x0251,
0x1D91, 0x0064, 0x1D92, 0x0065, 0x1D95, 0x0259, 0x1D96, 0x0069, 0x1D98, 0x0283, 0x1D99, 0x0075, 0x1D9A, 0x0292, 0x1E00, 0x0061,
0x1E01, 0x0061, 0x1E02, 0x0062, 0x1E03, 0x0062, 0x1E04, 0x0062, 0x1E05, 0x0062, 0x1E06, 0x0062, 0x1E07, 0x0062, 0x1E08, 0x0063,
0x1E09, 0x0063, 0x1E0A, 0x0064, 0x1E0B, 0x0064, 0x1E0C, 0x0064, 0x1E0D, 0x0064, 0x1E0E, 0x0064, 0x1E0F, 0x0064, 0x1E10, 0x0064,
0x1E11, 0x0064, 0x1E12, 0x0064, 0x1E13, 0x0064, 0x1E14, 0x0065, 0x1E15, 0x0065, 0x1E16, 0x0065, 0x1E17, 0x0065, 0x1E18, 0x0065,
0x1E19, 0x0065, 0x1E1A, 0x0065, 0x1E1B, 0x0065, 0x1E1C, 0x0065, 0x1E1D, 0x0065, 0x1E1E, 0x0066, 0x1E1F, 0x0066, 0x1E20, 0x0067,
0x1E21, 0x0067, 0x1E22, 0x0068, 0x1E23, 0x0068, 0x1E24, 0x0068, 0x1E25, 0x0068, 0x1E26, 0x0068, 0x1E27, 0x0068, 0x1E28, 0x0068,
0x1E29, 0x0068, 0x1E2A, 0x0068, 0x1E2B, 0x0068, 0x1E2C, 0x0069, 0x1E2D, 0x0069, 0x1E2E, 0x0069, 0x1E2F, 0x0069, 0x1E30, 0x006B,
0x1E31, 0x006B, 0x1E32, 0x006B, 0x1E33, 0x006B, 0x1E34, 0x006B, 0x1E35, 0x006B, 0x1E36, 0x006C, 0x1E37, 0x006C, 0x1E38, 0x006C,
0x1E39, 0x006C, 0x1E3A, 0x006C, 0x1E3B, 0x006C, 0x1E3C, 0x006C, 0x1E3D, 0x006C, 0x1E3E, 0x006D, 0x1E3F, 0x006D, 0x1E40, 0x006D,
0x1E41, 0x006D, 0x1E42, 0x006D, 0x1E43, 0x006D, 0x1E44, 0x006E, 0x1E45, 0x006E, 0x1E46, 0x006E, 0x1E47, 0x006E, 0x1E48, 0x006E,
0x1E49, 0x006E, 0x1E4A, 0x006E, 0x1E4B, 0x006E, 0x1E4C, 0x006F, 0x1E4D, 0x006F, 0x1E4E, 0x006F, 0x1E4F, 0x006F, 0x1E50, 0x006F,
0x1E51, 0x006F, 0x1E52, 0x006F, 0x1E53, 0x006F, 0x1E54, 0x0070, 0x1E55, 0x0070, 0x1E56, 0x0070, 0x1E57, 0x0070, 0x1E58, 0x0072,
0x1E59, 0x0072, 0x1E5A, 0x0072, 0x1E5B, 0x0072, 0x1E5C, 0x0072, 0x1E5D, 0x0072, 0x1E5E, 0x0072, 0x1E5F, 0x0072, 0x1E60, 0x0073,
0x1E61, 0x0073, 0x1E62, 0x0073, 0x1E63, 0x0073, 0x1E64, 0x0073, 0x1E65, 0x0073, 0x1E66, 0x0073, 0x1E67, 0x0073, 0x1E68, 0x0073,
0x1E69, 0x0073, 0x1E6A, 0x0074, 0x1E6B, 0x0074, 0x1E6C, 0x0074, 0x1E6D, 0x0074, 0x1E6E, 0x0074, 0x1E6F, 0x0074, 0x1E70, 0x0074,
0x1E71, 0x0074, 0x1E72, 0x0075, 0x1E73, 0x0075, 0x1E74, 0x0075, 0x1E75, 0x0075, 0x1E76, 0x0075, 0x1E77, 0x0075, 0x1E78, 0x0075,
0x1E79, 0x0075, 0x1E7A, 0x0075, 0x1E7B, 0x0075, 0x1E7C, 0x0076, 0x1E7D, 0x0076, 0x1E7E, 0x0076, 0x1E7F, 0x0076, 0x1E80, 0x0077,
0x1E81, 0x0077, 0x1E82, 0x0077, 0x1E83, 0x0077, 0x1E84, 0x0077, 0x1E85, 0x0077, 0x1E86, 0x0077, 0x1E87, 0x0077, 0x1E88, 0x0077,
0x1E89, 0x0077, 0x1E8A, 0x0078, 0x1E8B, 0x0078, 0x1E8C, 0x0078, 0x1E8D, 0x0078, 0x1E8E, 0x0079, 0x1E8F, 0x0079, 0x1E90, 0x007A,
0x1E91, 0x007A, 0x1E92, 0x007A, 0x1E93, 0x007A, 0x1E94, 0x007A, 0x1E95, 0x007A, 0x1E96, 0x0068, 0x1E97, 0x0074, 0x1E98, 0x0077,
0x1E99, 0x0079, 0x1E9A, 0x0061, 0x1E9F, 0x1E9F, 0x1EA0, 0x0061, 0x1EA1, 0x0061, 0x1EA2, 0x0061, 0x1EA3, 0x0061, 0x1EA4, 0x0061,
0x1EA5, 0x0061, 0x1EA6, 0x0061, 0x1EA7, 0x0061, 0x1EA8, 0x0061, 0x1EA9, 0x0061, 0x1EAA, 0x0061, 0x1EAB, 0x0061, 0x1EAC, 0x0061,
0x1EAD, 0x0061, 0x1EAE, 0x0061, 0x1EAF, 0x0061, 0x1EB0, 0x0061, 0x1EB1, 0x0061, 0x1EB2, 0x0061, 0x1EB3, 0x0061, 0x1EB4, 0x0061,
0x1EB5, 0x0061, 0x1EB6, 0x0061, 0x1EB7, 0x0061, 0x1EB8, 0x0065, 0x1EB9, 0x0065, 0x1EBA, 0x0065, 0x1EBB, 0x0065, 0x1EBC, 0x0065,
0x1EBD, 0x0065, 0x1EBE, 0x0065, 0x1EBF, 0x0065, 0x1EC0, 0x0065, 0x1EC1, 0x0065, 0x1EC2, 0x0065, 0x1EC3, 0x0065, 0x1EC4, 0x0065,
0x1EC5, 0x0065, 0x1EC6, 0x0065, 0x1EC7, 0x0065, 0x1EC8, 0x0069, 0x1EC9, 0x0069, 0x1ECA, 0x0069, 0x1ECB, 0x0069, 0x1ECC, 0x006F,
0x1ECD, 0x006F, 0x1ECE, 0x006F, 0x1ECF, 0x006F, 0x1ED0, 0x006F, 0x1ED1, 0x006F, 0x1ED2, 0x006F, 0x1ED3, 0x006F, 0x1ED4, 0x006F,
0x1ED5, 0x006F, 0x1ED6, 0x006F, 0x1ED7, 0x006F, 0x1ED8, 0x006F, 0x1ED9, 0x006F, 0x1EDA, 0x006F, 0x1EDB, 0x006F, 0x1EDC, 0x006F,
0x1EDD, 0x006F, 0x1EDE, 0x006F, 0x1EDF, 0x006F, 0x1EE0, 0x006F, 0x1EE1, 0x006F, 0x1EE2, 0x006F, 0x1EE3, 0x006F, 0x1EE4, 0x0075,
0x1EE5, 0x0075, 0x1EE6, 0x0075, 0x1EE7, 0x0075, 0x1EE8, 0x0075, 0x1EE9, 0x0075, 0x1EEA, 0x0075, 0x1EEB, 0x0075, 0x1EEC, 0x0075,
0x1EED, 0x0075, 0x1EEE, 0x0075, 0x1EEF, 0x0075, 0x1EF0, 0x0075, 0x1EF1, 0x0075, 0x1EF2, 0x0079, 0x1EF3, 0x0079, 0x1EF4, 0x0079,
0x1EF5, 0x0079, 0x1EF6, 0x0079, 0x1EF7, 0x0079, 0x1EF8, 0x0079, 0x1EF9, 0x0079, 0x1EFE, 0x0079, 0x1EFF, 0x0079, 0x1F00, 0x03B1,
0x1F01, 0x03B1, 0x1F02, 0x03B1, 0x1F03, 0x03B1, 0x1F04, 0x03B1, 0x1F05, 0x03B1, 0x1F06, 0x03B1, 0x1F07, 0x03B1, 0x1F08, 0x03B1,
0x1F09, 0x03B1, 0x1F0A, 0x03B1, 0x1F0B, 0x03B1, 0x1F0C, 0x03B1, 0x1F0D, 0x03B1, 0x1F0E, 0x03B1, 0x1F0F, 0x03B1, 0x1F10, 0x03B5,
0x1F11, 0x03B5, 0x1F12, 0x03B5, 0x1F13, 0x03B5, 0x1F14, 0x03B5, 0x1F15, 0x03B5, 0x1F18, 0x03B5, 0x1F19, 0x03B5, 0x1F1A, 0x03B5,
0x1F1B, 0x03B5, 0x1F1C, 0x03B5, 0x1F1D, 0x03B5, 0x1F20, 0x03B7, 0x1F21, 0x03B7, 0x1F22, 0x03B7, 0x1F23, 0x03B7, 0x1F24, 0x03B7,
0x1F25, 0x03B7, 0x1F26, 0x03B7, 0x1F27, 0x03B7, 0x1F28, 0x03B7, 0x1F29, 0x03B7, 0x1F2A, 0x03B7, 0x1F2B, 0x03B7, 0x1F2C, 0x03B7,
0x1F2D, 0x03B7, 0x1F2E, 0x03B7, 0x1F2F, 0x03B7, 0x1F30, 0x03B9, 0x1F31, 0x03B9, 0x1F32, 0x03B9, 0x1F33, 0x03B9, 0x1F34, 0x03B9,
0x1F35, 0x03B9, 0x1F36, 0x03B9, 0x1F37, 0x03B9, 0x1F38, 0x03B9, 0x1F39, 0x03B9, 0x1F3A, 0x03B9, 0x1F3B, 0x03B9, 0x1F3C, 0x03B9,
0x1F3D, 0x03B9, 0x1F3E, 0x03B9, 0x1F3F, 0x03B9, 0x1F40, 0x03BF, 0x1F41, 0x03BF, 0x1F42, 0x03BF, 0x1F43, 0x03BF, 0x1F44, 0x03BF,
0x1F45, 0x03BF, 0x1F48, 0x03BF, 0x1F49, 0x03BF, 0x1F4A, 0x03BF, 0x1F4B, 0x03BF, 0x1F4C, 0x03BF, 0x1F4D, 0x03BF, 0x1F50, 0x03C5,
0x1F51, 0x03C5, 0x1F52, 0x03C5, 0x1F53, 0x03C5, 0x1F54, 0x03C5, 0x1F55, 0x03C5, 0x1F56, 0x03C5, 0x1F57, 0x03C5, 0x1F59, 0x03C5,
0x1F5B, 0x03C5, 0x1F5D, 0x03C5, 0x1F5F, 0x03C5, 0x1F60, 0x03C9, 0x1F61, 0x03C9, 0x1F62, 0x03C9, 0x1F63, 0x03C9, 0x1F64, 0x03C9,
0x1F65, 0x03C9, 0x1F66, 0x03C9, 0x1F67, 0x03C9, 0x1F68, 0x03C9, 0x1F69, 0x03C9, 0x1F6A, 0x03C9, 0x1F6B, 0x03C9, 0x1F6C, 0x03C9,
0x1F6D, 0x03C9, 0x1F6E, 0x03C9, 0x1F6F, 0x03C9, 0x1F70, 0x03B1, 0x1F71, 0x03B1, 0x1F72, 0x03B5, 0x1F73, 0x03B5, 0x1F74, 0x03B7,
0x1F75, 0x03B7, 0x1F76, 0x03B9, 0x1F77, 0x03B9, 0x1F78, 0x03BF, 0x1F79, 0x03BF, 0x1F7A, 0x03C5, 0x1F7B, 0x03C5, 0x1F7C, 0x03C9,
0x1F7D, 0x03C9, 0x1F80, 0x03B1, 0x1F81, 0x03B1, 0x1F82, 0x03B1, 0x1F83, 0x03B1, 0x1F84, 0x03B1, 0x1F85, 0x03B1, 0x1F86, 0x03B1,
0x1F87, 0x03B1, 0x1F90, 0x03B7, 0x1F91, 0x03B7, 0x1F92, 0x03B7, 0x1F93, 0x03B7, 0x1F94, 0x03B7, 0x1F95, 0x03B7, 0x1F96, 0x03B7,
0x1F97, 0x03B7, 0x1FA0, 0x03C9, 0x1FA1, 0x03C9, 0x1FA2, 0x03C9, 0x1FA3, 0x03C9, 0x1FA4, 0x03C9, 0x1FA5, 0x03C9, 0x1FA6, 0x03C9,
0x1FA7, 0x03C9, 0x1FB0, 0x03B1, 0x1FB1, 0x03B1, 0x1FB2, 0x03B1, 0x1FB3, 0x03B1, 0x1FB4, 0x03B1, 0x1FB6, 0x03B1, 0x1FB7, 0x03B1,
0x1FB8, 0x03B1, 0x1FB9, 0x03B1, 0x1FBA, 0x03B1, 0x1FBB, 0x03B1, 0x1FC2, 0x03B7, 0x1FC3, 0x03B7, 0x1FC4, 0x03B7, 0x1FC6, 0x03B7,
0x1FC7, 0x03B7, 0x1FC8, 0x03B5, 0x1FC9, 0x03B5, 0x1FCA, 0x03B7, 0x1FCB, 0x03B7, 0x1FD0, 0x03B9, 0x1FD1, 0x03B9, 0x1FD2, 0x03B9,
0x1FD3, 0x03B9, 0x1FD6, 0x03B9, 0x1FD7, 0x03B9, 0x1FD8, 0x03B9, 0x1FD9, 0x03B9, 0x1FDA, 0x03B9, 0x1FDB, 0x03B9, 0x1FE0, 0x03C5,
0x1FE1, 0x03C5, 0x1FE2, 0x03C5, 0x1FE3, 0x03C5, 0x1FE4, 0x03C1, 0x1FE5, 0x03C1, 0x1FE6, 0x03C5, 0x1FE7, 0x03C5, 0x1FE8, 0x03C5,
0x1FE9, 0x03C5, 0x1FEA, 0x03C5, 0x1FEB, 0x03C5, 0x1FEC, 0x03C1, 0x1FF2, 0x03C9, 0x1FF3, 0x03C9, 0x1FF4, 0x03C9, 0x1FF6, 0x03C9,
0x1FF7, 0x03C9, 0x1FF8, 0x03BF, 0x1FF9, 0x03BF, 0x1FFA, 0x03C9, 0x1FFB, 0x03C9, 0x2C00, 0x2C30, 0x2C01, 0x2C31, 0x2C02, 0x2C32,
0x2C03, 0x2C33, 0x2C04, 0x2C34, 0x2C05, 0x2C35, 0x2C06, 0x2C36, 0x2C07, 0x2C37, 0x2C08, 0x2C38, 0x2C09, 0x2C39, 0x2C0B, 0x2C3B,
0x2C0C, 0x2C3C, 0x2C0D, 0x2C3D, 0x2C0E, 0x2C3E, 0x2C0F, 0x2C3F, 0x2C10, 0x2C40, 0x2C11, 0x2C41, 0x2C12, 0x2C42, 0x2C13, 0x2C43,
0x2C14, 0x2C44, 0x2C15, 0x2C45, 0x2C16, 0x2C46, 0x2C17, 0x2C47, 0x2C18, 0x2C48, 0x2C19, 0x2C49, 0x2C1A, 0x2C4A, 0x2C1B, 0x2C4B,
0x2C1C, 0x2C4C, 0x2C1D, 0x2C4D, 0x2C1E, 0x2C4E, 0x2C1F, 0x2C4F, 0x2C20, 0x2C50, 0x2C21, 0x2C51, 0x2C23, 0x2C53, 0x2C26, 0x2C56,
0x2C2A, 0x2C5A, 0x2C2B, 0x2C5B, 0x2C2C, 0x2C5C, 0x2C30, 0x2C30, 0x2C31, 0x2C31, 0x2C32, 0x2C32, 0x2C33, 0x2C33, 0x2C34, 0x2C34,
0x2C35, 0x2C35, 0x2C36, 0x2C36, 0x2C37, 0x2C37, 0x2C38, 0x2C38, 0x2C39, 0x2C39, 0x2C3B, 0x2C3B, 0x2C3C, 0x2C3C, 0x2C3D, 0x2C3D,
0x2C3E, 0x2C3E, 0x2C3F, 0x2C3F, 0x2C40, 0x2C40, 0x2C41, 0x2C41, 0x2C42, 0x2C42, 0x2C43, 0x2C43, 0x2C44, 0x2C44, 0x2C45, 0x2C45,
0x2C46, 0x2C46, 0x2C47, 0x2C47, 0x2C48, 0x2C48, 0x2C49, 0x2C49, 0x2C4A, 0x2C4A, 0x2C4B, 0x2C4B, 0x2C4C, 0x2C4C, 0x2C4D, 0x2C4D,
0x2C4E, 0x2C4E, 0x2C4F, 0x2C4F, 0x2C50, 0x2C50, 0x2C51, 0x2C51, 0x2C53, 0x2C53, 0x2C56, 0x2C56, 0x2C5A, 0x2C5A, 0x2C5B, 0x2C5B,
0x2C5C, 0x2C5C, 0x2C60, 0x006C, 0x2C61, 0x006C, 0x2C62, 0x006C, 0x2C63, 0x0070, 0x2C64, 0x0072, 0x2C65, 0x0061, 0x2C66, 0x0074,
0x2C67, 0x0068, 0x2C68, 0x0068, 0x2C69, 0x006B, 0x2C6A, 0x006B, 0x2C6B, 0x007A, 0x2C6C, 0x007A, 0x2C6D, 0x0251, 0x2C6E, 0x006D,
0x2C71, 0x0076, 0x2C72, 0x0077, 0x2C73, 0x0077, 0x2C74, 0x0076, 0x2C78, 0x0065, 0x2C7A, 0x006F, 0x2C7E, 0x0073, 0x2C7F, 0x007A,
0x2C80, 0x2C81, 0x2C81, 0x2C81, 0x2C82, 0x2C83, 0x2C83, 0x2C83, 0x2C84, 0x2C85, 0x2C85, 0x2C85, 0x2C86, 0x2C87, 0x2C87, 0x2C87,
0x2C88, 0x2C89, 0x2C89, 0x2C89, 0x2C8A, 0x2C8B, 0x2C8B, 0x2C8B, 0x2C8C, 0x2C8D, 0x2C8D, 0x2C8D, 0x2C8E, 0x2C8F, 0x2C8F, 0x2C8F,
0x2C90, 0x2C91, 0x2C91, 0x2C91, 0x2C92, 0x2C93, 0x2C93, 0x2C93, 0x2C94, 0x2C95, 0x2C95, 0x2C95, 0x2C96, 0x2C97, 0x2C97, 0x2C97,
0x2C98, 0x2C99, 0x2C99, 0x2C99, 0x2C9A, 0x2C9B, 0x2C9B, 0x2C9B, 0x2C9C, 0x2C9D, 0x2C9D, 0x2C9D, 0x2C9E, 0x2C9F, 0x2C9F, 0x2C9F,
0x2CA0, 0x2CA1, 0x2CA1, 0x2CA1, 0x2CA2, 0x2CA3, 0x2CA3, 0x2CA3, 0x2CA4, 0x2CA5, 0x2CA5, 0x2CA5, 0x2CA6, 0x2CA7, 0x2CA7, 0x2CA7,
0x2CA8, 0x2CA9, 0x2CA9, 0x2CA9, 0x2CAA, 0x2CAB, 0x2CAB, 0x2CAB, 0x2CAC, 0x2CAD, 0x2CAD, 0x2CAD, 0x2CAE, 0x2CAF, 0x2CAF, 0x2CAF,
0x2CB0, 0x2CB1, 0x2CB1, 0x2CB1, 0x2CC0, 0x2CC1, 0x2CC1, 0x2CC1, 0x2D00, 0x2D00, 0x2D01, 0x2D01, 0x2D02, 0x2D02, 0x2D03, 0x2D03,
0x2D04, 0x2D04, 0x2D05, 0x2D05, 0x2D06, 0x2D06, 0x2D07, 0x2D07, 0x2D08, 0x2D08, 0x2D09, 0x2D09, 0x2D0A, 0x2D0A, 0x2D0B, 0x2D0B,
0x2D0C, 0x2D0C, 0x2D0D, 0x2D0D, 0x2D0E, 0x2D0E, 0x2D0F, 0x2D0F, 0x2D10, 0x2D10, 0x2D11, 0x2D11, 0x2D12, 0x2D12, 0x2D13, 0x2D13,
0x2D14, 0x2D14, 0x2D15, 0x2D15, 0x2D16, 0x2D16, 0x2D17, 0x2D17, 0x2D18, 0x2D18, 0x2D19, 0x2D19, 0x2D1A, 0x2D1A, 0x2D1B, 0x2D1B,
0x2D1C, 0x2D1C, 0x2D1D, 0x2D1D, 0x2D1E, 0x2D1E, 0x2D1F, 0x2D1F, 0x2D20, 0x2D20, 0x2D21, 0x2D21, 0x2D22, 0x2D22, 0x2D23, 0x2D23,
0x2D24, 0x2D24, 0x2D25, 0x2D25, 0x2D27, 0x2D27, 0x2D2D, 0x2D2D, 0xA640, 0xA641, 0xA641, 0xA641, 0xA642, 0xA643, 0xA643, 0xA643,
0xA646, 0xA647, 0xA647, 0xA647, 0xA648, 0xA649, 0xA649, 0xA649, 0xA650, 0x044B, 0xA651, 0x044B, 0xA65E, 0xA65F, 0xA65F, 0xA65F,
0xA680, 0xA681, 0xA681, 0xA681, 0xA682, 0xA683, 0xA683, 0xA683, 0xA684, 0xA685, 0xA685, 0xA685, 0xA686, 0xA687, 0xA687, 0xA687,
0xA688, 0xA689, 0xA689, 0xA689, 0xA68A, 0x0442, 0xA68B, 0x0442, 0xA68C, 0xA68D, 0xA68D, 0xA68D, 0xA68E, 0xA68F, 0xA68F, 0xA68F,
0xA690, 0xA691, 0xA691, 0xA691, 0xA692, 0xA693, 0xA693, 0xA693, 0xA694, 0xA695, 0xA695, 0xA695, 0xA696, 0xA697, 0xA697, 0xA697,
0xA726, 0xA727, 0xA727, 0xA727, 0xA728, 0xA729, 0xA729, 0xA729, 0xA72A, 0xA72B, 0xA72B, 0xA72B, 0xA72C, 0xA72D, 0xA72D, 0xA72D,
0xA72E, 0xA72D, 0xA72F, 0xA72D, 0xA732, 0xA733, 0xA733, 0xA733, 0xA734, 0xA735, 0xA735, 0xA735, 0xA736, 0xA737, 0xA737, 0xA737,
0xA738, 0xA739, 0xA739, 0xA739, 0xA73A, 0xA739, 0xA73B, 0xA739, 0xA73C, 0xA73D, 0xA73D, 0xA73D, 0xA740, 0x006B, 0xA741, 0x006B,
0xA742, 0x006B, 0xA743, 0x006B, 0xA744, 0x006B, 0xA745, 0x006B, 0xA748, 0x006C, 0xA749, 0x006C, 0xA74A, 0x006F, 0xA74B, 0x006F,
0xA74C, 0x006F, 0xA74D, 0x006F, 0xA74E, 0xA74F, 0xA74F, 0xA74F, 0xA750, 0x0070, 0xA751, 0x0070, 0xA752, 0x0070, 0xA753, 0x0070,
0xA754, 0x0070, 0xA755, 0x0070, 0xA756, 0x0071, 0xA757, 0x0071, 0xA758, 0x0071, 0xA759, 0x0071, 0xA75A, 0x0072, 0xA75B, 0x0072,
0xA75C, 0xA775, 0xA75D, 0xA775, 0xA75E, 0x0076, 0xA75F, 0x0076, 0xA760, 0xA761, 0xA761, 0xA761, 0xA764, 0x00FE, 0xA765, 0x00FE,
0xA766, 0x00FE, 0xA767, 0x00FE, 0xA768, 0xA769, 0xA769, 0xA769, 0xA76A, 0xA76B, 0xA76B, 0xA76B, 0xA76C, 0xA76D, 0xA76D, 0xA76D,
0xA76E, 0xA76F, 0xA76F, 0xA76F, 0xA771, 0xA771, 0xA772, 0xA772, 0xA773, 0xA773, 0xA774, 0xA774, 0xA775, 0xA775, 0xA777, 0xA777,
0xA778, 0xA778, 0xA78B, 0xA78C, 0xA78C, 0xA78C, 0xA78E, 0x006C, 0xA790, 0x006E, 0xA791, 0x006E, 0xA792, 0x0063, 0xA793, 0x0063,
0xA794, 0x0063, 0xA795, 0x0068, 0xA796, 0x0062, 0xA797, 0x0062, 0xA798, 0x0066, 0xA799, 0x0066, 0xA7A0, 0x0067, 0xA7A1, 0x0067,
0xA7A2, 0x006B, 0xA7A3, 0x006B, 0xA7A4, 0x006E, 0xA7A5, 0x006E, 0xA7A6, 0x0072, 0xA7A7, 0x0072, 0xA7A8, 0x0073, 0xA7A9, 0x0073,
0xA7AA, 0x0068, 0xA7AD, 0x006C, 0xA7B2, 0x006A, 0xA7B3, 0xAB53, 0xA7B4, 0xA7B5, 0xA7B5, 0xA7B5, 0xA7B6, 0xA7B7, 0xA7B7, 0xA7B7,
0xAB31, 0x0061, 0xAB34, 0x0065, 0xAB37, 0x006C, 0xAB38, 0x006C, 0xAB39, 0x006C, 0xAB3A, 0x006D, 0xAB3B, 0x006E, 0xAB3C, 0x014B,
0xAB47, 0x0072, 0xAB49, 0x0072, 0xAB4E, 0x0075, 0xAB4F, 0x0075, 0xAB50, 0xAB50, 0xAB52, 0x0075, 0xAB53, 0xAB53, 0xAB54, 0xAB53,
0xAB55, 0xAB53, 0xAB56, 0x0078, 0xAB57, 0x0078, 0xAB58, 0x0078, 0xAB59, 0x0078, 0xAB5A, 0x0079, 0xAB63, 0xAB63, 0xAB70, 0xAB70,
0xAB71, 0xAB71, 0xAB72, 0xAB72, 0xAB73, 0xAB73, 0xAB74, 0xAB74, 0xAB75, 0xAB75, 0xAB76, 0xAB76, 0xAB77, 0xAB77, 0xAB78, 0xAB78,
0xAB79, 0xAB79, 0xAB7A, 0xAB7A, 0xAB7B, 0xAB7B, 0xAB7C, 0xAB7C, 0xAB7D, 0xAB7D, 0xAB7E, 0xAB7E, 0xAB7F, 0xAB7F, 0xAB80, 0xAB80,
0xAB81, 0xAB81, 0xAB82, 0xAB82, 0xAB83, 0xAB83, 0xAB84, 0xAB84, 0xAB85, 0xAB85, 0xAB86, 0xAB86, 0xAB87, 0xAB87, 0xAB88, 0xAB88,
0xAB89, 0xAB89, 0xAB8A, 0xAB8A, 0xAB8B, 0xAB8B, 0xAB8C, 0xAB8C, 0xAB8D, 0xAB8D, 0xAB8E, 0xAB8E, 0xAB8F, 0xAB8F, 0xAB90, 0xAB90,
0xAB91, 0xAB91, 0xAB92, 0xAB92, 0xAB93, 0xAB93, 0xAB94, 0xAB94, 0xAB95, 0xAB95, 0xAB96, 0xAB96, 0xAB97, 0xAB97, 0xAB98, 0xAB98,
0xAB99, 0xAB99, 0xAB9A, 0xAB9A, 0xAB9B, 0xAB9B, 0xAB9C, 0xAB9C, 0xAB9D, 0xAB9D, 0xAB9E, 0xAB9E, 0xAB9F, 0xAB9F, 0xABA0, 0xABA0,
0xABA1, 0xABA1, 0xABA2, 0xABA2, 0xABA3, 0xABA3, 0xABA4, 0xABA4, 0xABA5, 0xABA5, 0xABA6, 0xABA6, 0xABA7, 0xABA7, 0xABA8, 0xABA8,
0xABA9, 0xABA9, 0xABAA, 0xABAA, 0xABAB, 0xABAB, 0xABAC, 0xABAC, 0xABAD, 0xABAD, 0xABAE, 0xABAE, 0xABAF, 0xABAF, 0xABB0, 0xABB0,
0xABB1, 0xABB1, 0xABB2, 0xABB2, 0xABB3, 0xABB3, 0xABB4, 0xABB4, 0xABB5, 0xABB5, 0xABB6, 0xABB6, 0xABB7, 0xABB7, 0xABB8, 0xABB8,
0xABB9, 0xABB9, 0xABBA, 0xABBA, 0xABBB, 0xABBB, 0xABBC, 0xABBC, 0xABBD, 0xABBD, 0xABBE, 0xABBE, 0xABBF, 0xABBF,
0, 0 };

unsigned char auninames[] = {
0x41,0x03,0x05,0x01,0x12,0x00,0x42,0x03,0x05,0x01,0x49,0x00,0x43,0x03,0x05,0x01,0x3b,0x00,
0x44,0x03,0x05,0x01,0x35,0x00,0x45,0x03,0x05,0x01,0x11,0x00,0x46,0x03,0x05,0x01,0x4f,0x00,
0x47,0x03,0x05,0x01,0x34,0x00,0x48,0x03,0x05,0x01,0x33,0x00,0x49,0x03,0x05,0x01,0x1b,0x00,
0x4a,0x03,0x05,0x01,0x4d,0x00,0x4b,0x03,0x05,0x01,0x3a,0x00,0x4c,0x03,0x05,0x01,0x27,0x00,
0x4d,0x03,0x05,0x01,0x48,0x00,0x4e,0x03,0x05,0x01,0x2b,0x00,0x4f,0x03,0x05,0x01,0x0a,0x00,
0x50,0x03,0x05,0x01,0x44,0x00,0x51,0x03,0x05,0x01,0x5d,0x00,0x52,0x03,0x05,0x01,0x22,0x00,
0x53,0x03,0x05,0x01,0x28,0x00,0x54,0x03,0x05,0x01,0x32,0x00,0x55,0x03,0x05,0x01,0x0f,0x00,
0x56,0x03,0x05,0x01,0x42,0x00,0x57,0x03,0x05,0x01,0x47,0x00,0x58,0x03,0x05,0x01,0x50,0x00,
0x59,0x03,0x05,0x01,0x38,0x00,0x5a,0x03,0x05,0x01,0x36,0x00,0x61,0x03,0x02,0x01,0x12,0x00,
0x62,0x03,0x02,0x01,0x49,0x00,0x63,0x03,0x02,0x01,0x3b,0x00,0x64,0x03,0x02,0x01,0x35,0x00,
0x65,0x03,0x02,0x01,0x11,0x00,0x66,0x03,0x02,0x01,0x4f,0x00,0x67,0x03,0x02,0x01,0x34,0x00,
0x68,0x03,0x02,0x01,0x33,0x00,0x69,0x03,0x02,0x01,0x1b,0x00,0x6a,0x03,0x02,0x01,0x4d,0x00,
0x6b,0x03,0x02,0x01,0x3a,0x00,0x6c,0x03,0x02,0x01,0x27,0x00,0x6d,0x03,0x02,0x01,0x48,0x00,
0x6e,0x03,0x02,0x01,0x2b,0x00,0x6f,0x03,0x02,0x01,0x0a,0x00,0x70,0x03,0x02,0x01,0x44,0x00,
0x71,0x03,0x02,0x01,0x5d,0x00,0x72,0x03,0x02,0x01,0x22,0x00,0x73,0x03,0x02,0x01,0x28,0x00,
0x74,0x03,0x02,0x01,0x32,0x00,0x75,0x03,0x02,0x01,0x0f,0x00,0x76,0x03,0x02,0x01,0x42,0x00,
0x77,0x03,0x02,0x01,0x47,0x00,0x78,0x03,0x02,0x01,0x50,0x00,0x79,0x03,0x02,0x01,0x38,0x00,
0x7a,0x03,0x02,0x01,0x36,0x00,0xc0,0x01,0x03,0x05,0x01,0x12,0x04,0x24,0x00,0xc1,0x01,0x03,0x05,0x01,0x12,0x04,0x18,0x00,
0xc2,0x01,0x03,0x05,0x01,0x12,0x04,0x1a,0x00,0xc3,0x01,0x03,0x05,0x01,0x12,0x04,0x1e,0x00,0xc4,0x01,0x03,0x05,0x01,0x12,0x04,0x1c,0x00,
0xc5,0x01,0x03,0x05,0x01,0x12,0x04,0x52,0x14,0x00,0xc6,0x01,0x03,0x05,0x01,0x6f,0x00,0xc7,0x01,0x03,0x05,0x01,0x3b,0x04,0x40,0x00,
0xc8,0x01,0x03,0x05,0x01,0x11,0x04,0x24,0x00,0xc9,0x01,0x03,0x05,0x01,0x11,0x04,0x18,0x00,0xca,0x01,0x03,0x05,0x01,0x11,0x04,0x1a,0x00,
0xcb,0x01,0x03,0x05,0x01,0x11,0x04,0x1c,0x00,0xcc,0x01,0x03,0x05,0x01,0x1b,0x04,0x24,0x00,0xcd,0x01,0x03,0x05,0x01,0x1b,0x04,0x18,0x00,
0xce,0x01,0x03,0x05,0x01,0x1b,0x04,0x1a,0x00,0xcf,0x01,0x03,0x05,0x01,0x1b,0x04,0x1c,0x00,0xd0,0x01,0x03,0x05,0x01,0xe2,0x01,0x00,
0xd1,0x01,0x03,0x05,0x01,0x2b,0x04,0x1e,0x00,0xd2,0x01,0x03,0x05,0x01,0x0a,0x04,0x24,0x00,0xd3,0x01,0x03,0x05,0x01,0x0a,0x04,0x18,0x00,
0xd4,0x01,0x03,0x05,0x01,0x0a,0x04,0x1a,0x00,0xd5,0x01,0x03,0x05,0x01,0x0a,0x04,0x1e,0x00,0xd6,0x01,0x03,0x05,0x01,0x0a,0x04,0x1c,0x00,
0xd8,0x01,0x03,0x05,0x01,0x0a,0x04,0x0d,0x00,0xd9,0x01,0x03,0x05,0x01,0x0f,0x04,0x24,0x00,0xda,0x01,0x03,0x05,0x01,0x0f,0x04,0x18,0x00,
0xdb,0x01,0x03,0x05,0x01,0x0f,0x04,0x1a,0x00,0xdc,0x01,0x03,0x05,0x01,0x0f,0x04,0x1c,0x00,0xdd,0x01,0x03,0x05,0x01,0x38,0x04,0x18,0x00,
0xde,0x01,0x03,0x05,0x01,0x90,0x01,0x00,0xdf,0x01,0x03,0x02,0x01,0xaf,0x02,0x28,0x00,0xe0,0x01,0x03,0x02,0x01,0x12,0x04,0x24,0x00,
0xe1,0x01,0x03,0x02,0x01,0x12,0x04,0x18,0x00,0xe2,0x01,0x03,0x02,0x01,0x12,0x04,0x1a,0x00,0xe3,0x01,0x03,0x02,0x01,0x12,0x04,0x1e,0x00,
0xe4,0x01,0x03,0x02,0x01,0x12,0x04,0x1c,0x00,0xe5,0x01,0x03,0x02,0x01,0x12,0x04,0x52,0x14,0x00,0xe6,0x01,0x03,0x02,0x01,0x6f,0x00,
0xe7,0x01,0x03,0x02,0x01,0x3b,0x04,0x40,0x00,0xe8,0x01,0x03,0x02,0x01,0x11,0x04,0x24,0x00,0xe9,0x01,0x03,0x02,0x01,0x11,0x04,0x18,0x00,
0xea,0x01,0x03,0x02,0x01,0x11,0x04,0x1a,0x00,0xeb,0x01,0x03,0x02,0x01,0x11,0x04,0x1c,0x00,0xec,0x01,0x03,0x02,0x01,0x1b,0x04,0x24,0x00,
0xed,0x01,0x03,0x02,0x01,0x1b,0x04,0x18,0x00,0xee,0x01,0x03,0x02,0x01,0x1b,0x04,0x1a,0x00,0xef,0x01,0x03,0x02,0x01,0x1b,0x04,0x1c,0x00,
0xf0,0x01,0x03,0x02,0x01,0xe2,0x01,0x00,0xf1,0x01,0x03,0x02,0x01,0x2b,0x04,0x1e,0x00,0xf2,0x01,0x03,0x02,0x01,0x0a,0x04,0x24,0x00,
0xf3,0x01,0x03,0x02,0x01,0x0a,0x04,0x18,0x00,0xf4,0x01,0x03,0x02,0x01,0x0a,0x04,0x1a,0x00,0xf5,0x01,0x03,0x02,0x01,0x0a,0x04,0x1e,0x00,
0xf6,0x01,0x03,0x02,0x01,0x0a,0x04,0x1c,0x00,0xf8,0x01,0x03,0x02,0x01,0x0a,0x04,0x0d,0x00,0xf9,0x01,0x03,0x02,0x01,0x0f,0x04,0x24,0x00,
0xfa,0x01,0x03,0x02,0x01,0x0f,0x04,0x18,0x00,0xfb,0x01,0x03,0x02,0x01,0x0f,0x04,0x1a,0x00,0xfc,0x01,0x03,0x02,0x01,0x0f,0x04,0x1c,0x00,
0xfd,0x01,0x03,0x02,0x01,0x38,0x04,0x18,0x00,0xfe,0x01,0x03,0x02,0x01,0x90,0x01,0x00,0xff,0x01,0x03,0x02,0x01,0x38,0x04,0x1c,0x00,
0x80,0x02,0x03,0x05,0x01,0x12,0x04,0x23,0x00,0x81,0x02,0x03,0x02,0x01,0x12,0x04,0x23,0x00,0x82,0x02,0x03,0x05,0x01,0x12,0x04,0x2a,0x00,
0x83,0x02,0x03,0x02,0x01,0x12,0x04,0x2a,0x00,0x84,0x02,0x03,0x05,0x01,0x12,0x04,0x61,0x00,0x85,0x02,0x03,0x02,0x01,0x12,0x04,0x61,0x00,
0x86,0x02,0x03,0x05,0x01,0x3b,0x04,0x18,0x00,0x87,0x02,0x03,0x02,0x01,0x3b,0x04,0x18,0x00,0x88,0x02,0x03,0x05,0x01,0x3b,0x04,0x1a,0x00,
0x89,0x02,0x03,0x02,0x01,0x3b,0x04,0x1a,0x00,0x8a,0x02,0x03,0x05,0x01,0x3b,0x04,0x0c,0x14,0x00,0x8b,0x02,0x03,0x02,0x01,0x3b,0x04,0x0c,0x14,0x00,
0x8c,0x02,0x03,0x05,0x01,0x3b,0x04,0x2d,0x00,0x8d,0x02,0x03,0x02,0x01,0x3b,0x04,0x2d,0x00,0x8e,0x02,0x03,0x05,0x01,0x35,0x04,0x2d,0x00,
0x8f,0x02,0x03,0x02,0x01,0x35,0x04,0x2d,0x00,0x90,0x02,0x03,0x05,0x01,0x35,0x04,0x0d,0x00,0x91,0x02,0x03,0x02,0x01,0x35,0x04,0x0d,0x00,
0x92,0x02,0x03,0x05,0x01,0x11,0x04,0x23,0x00,0x93,0x02,0x03,0x02,0x01,0x11,0x04,0x23,0x00,0x94,0x02,0x03,0x05,0x01,0x11,0x04,0x2a,0x00,
0x95,0x02,0x03,0x02,0x01,0x11,0x04,0x2a,0x00,0x96,0x02,0x03,0x05,0x01,0x11,0x04,0x0c,0x14,0x00,0x97,0x02,0x03,0x02,0x01,0x11,0x04,0x0c,0x14,0x00,
0x98,0x02,0x03,0x05,0x01,0x11,0x04,0x61,0x00,0x99,0x02,0x03,0x02,0x01,0x11,0x04,0x61,0x00,0x9a,0x02,0x03,0x05,0x01,0x11,0x04,0x2d,0x00,
0x9b,0x02,0x03,0x02,0x01,0x11,0x04,0x2d,0x00,0x9c,0x02,0x03,0x05,0x01,0x34,0x04,0x1a,0x00,0x9d,0x02,0x03,0x02,0x01,0x34,0x04,0x1a,0x00,
0x9e,0x02,0x03,0x05,0x01,0x34,0x04,0x2a,0x00,0x9f,0x02,0x03,0x02,0x01,0x34,0x04,0x2a,0x00,0xa0,0x02,0x03,0x05,0x01,0x34,0x04,0x0c,0x14,0x00,
0xa1,0x02,0x03,0x02,0x01,0x34,0x04,0x0c,0x14,0x00,0xa2,0x02,0x03,0x05,0x01,0x34,0x04,0x40,0x00,0xa3,0x02,0x03,0x02,0x01,0x34,0x04,0x40,0x00,
0xa4,0x02,0x03,0x05,0x01,0x33,0x04,0x1a,0x00,0xa5,0x02,0x03,0x02,0x01,0x33,0x04,0x1a,0x00,0xa6,0x02,0x03,0x05,0x01,0x33,0x04,0x0d,0x00,
0xa7,0x02,0x03,0x02,0x01,0x33,0x04,0x0d,0x00,0xa8,0x02,0x03,0x05,0x01,0x1b,0x04,0x1e,0x00,0xa9,0x02,0x03,0x02,0x01,0x1b,0x04,0x1e,0x00,
0xaa,0x02,0x03,0x05,0x01,0x1b,0x04,0x23,0x00,0xab,0x02,0x03,0x02,0x01,0x1b,0x04,0x23,0x00,0xac,0x02,0x03,0x05,0x01,0x1b,0x04,0x2a,0x00,
0xad,0x02,0x03,0x02,0x01,0x1b,0x04,0x2a,0x00,0xae,0x02,0x03,0x05,0x01,0x1b,0x04,0x61,0x00,0xaf,0x02,0x03,0x02,0x01,0x1b,0x04,0x61,0x00,
0xb0,0x02,0x03,0x05,0x01,0x1b,0x04,0x0c,0x14,0x00,0xb1,0x02,0x03,0x02,0x01,0xc9,0x01,0x1b,0x00,0xb4,0x02,0x03,0x05,0x01,0x4d,0x04,0x1a,0x00,
0xb5,0x02,0x03,0x02,0x01,0x4d,0x04,0x1a,0x00,0xb6,0x02,0x03,0x05,0x01,0x3a,0x04,0x40,0x00,0xb7,0x02,0x03,0x02,0x01,0x3a,0x04,0x40,0x00,
0xb8,0x02,0x03,0x02,0x01,0x95,0x04,0x00,0xb9,0x02,0x03,0x05,0x01,0x27,0x04,0x18,0x00,0xba,0x02,0x03,0x02,0x01,0x27,0x04,0x18,0x00,
0xbb,0x02,0x03,0x05,0x01,0x27,0x04,0x40,0x00,0xbc,0x02,0x03,0x02,0x01,0x27,0x04,0x40,0x00,0xbd,0x02,0x03,0x05,0x01,0x27,0x04,0x2d,0x00,
0xbe,0x02,0x03,0x02,0x01,0x27,0x04,0x2d,0x00,0xbf,0x02,0x03,0x05,0x01,0x27,0x04,0x3e,0x0c,0x00,0xc0,0x02,0x03,0x02,0x01,0x27,0x04,0x3e,0x0c,0x00,
0xc1,0x02,0x03,0x05,0x01,0x27,0x04,0x0d,0x00,0xc2,0x02,0x03,0x02,0x01,0x27,0x04,0x0d,0x00,0xc3,0x02,0x03,0x05,0x01,0x2b,0x04,0x18,0x00,
0xc4,0x02,0x03,0x02,0x01,0x2b,0x04,0x18,0x00,0xc5,0x02,0x03,0x05,0x01,0x2b,0x04,0x40,0x00,0xc6,0x02,0x03,0x02,0x01,0x2b,0x04,0x40,0x00,
0xc7,0x02,0x03,0x05,0x01,0x2b,0x04,0x2d,0x00,0xc8,0x02,0x03,0x02,0x01,0x2b,0x04,0x2d,0x00,0xc9,0x02,0x03,0x02,0x01,0x2b,0xf9,0x03,0xae,0x04,0xb1,0x04,0x00,
0xca,0x02,0x03,0x05,0x01,0xe3,0x01,0x00,0xcb,0x02,0x03,0x02,0x01,0xe3,0x01,0x00,0xcc,0x02,0x03,0x05,0x01,0x0a,0x04,0x23,0x00,
0xcd,0x02,0x03,0x02,0x01,0x0a,0x04,0x23,0x00,0xce,0x02,0x03,0x05,0x01,0x0a,0x04,0x2a,0x00,0xcf,0x02,0x03,0x02,0x01,0x0a,0x04,0x2a,0x00,
0xd0,0x02,0x03,0x05,0x01,0x0a,0x04,0x3d,0x18,0x00,0xd1,0x02,0x03,0x02,0x01,0x0a,0x04,0x3d,0x18,0x00,0xd4,0x02,0x03,0x05,0x01,0x22,0x04,0x18,0x00,
0xd5,0x02,0x03,0x02,0x01,0x22,0x04,0x18,0x00,0xd6,0x02,0x03,0x05,0x01,0x22,0x04,0x40,0x00,0xd7,0x02,0x03,0x02,0x01,0x22,0x04,0x40,0x00,
0xd8,0x02,0x03,0x05,0x01,0x22,0x04,0x2d,0x00,0xd9,0x02,0x03,0x02,0x01,0x22,0x04,0x2d,0x00,0xda,0x02,0x03,0x05,0x01,0x28,0x04,0x18,0x00,
0xdb,0x02,0x03,0x02,0x01,0x28,0x04,0x18,0x00,0xdc,0x02,0x03,0x05,0x01,0x28,0x04,0x1a,0x00,0xdd,0x02,0x03,0x02,0x01,0x28,0x04,0x1a,0x00,
0xde,0x02,0x03,0x05,0x01,0x28,0x04,0x40,0x00,0xdf,0x02,0x03,0x02,0x01,0x28,0x04,0x40,0x00,0xe0,0x02,0x03,0x05,0x01,0x28,0x04,0x2d,0x00,
0xe1,0x02,0x03,0x02,0x01,0x28,0x04,0x2d,0x00,0xe2,0x02,0x03,0x05,0x01,0x32,0x04,0x40,0x00,0xe3,0x02,0x03,0x02,0x01,0x32,0x04,0x40,0x00,
0xe4,0x02,0x03,0x05,0x01,0x32,0x04,0x2d,0x00,0xe5,0x02,0x03,0x02,0x01,0x32,0x04,0x2d,0x00,0xe6,0x02,0x03,0x05,0x01,0x32,0x04,0x0d,0x00,
0xe7,0x02,0x03,0x02,0x01,0x32,0x04,0x0d,0x00,0xe8,0x02,0x03,0x05,0x01,0x0f,0x04,0x1e,0x00,0xe9,0x02,0x03,0x02,0x01,0x0f,0x04,0x1e,0x00,
0xea,0x02,0x03,0x05,0x01,0x0f,0x04,0x23,0x00,0xeb,0x02,0x03,0x02,0x01,0x0f,0x04,0x23,0x00,0xec,0x02,0x03,0x05,0x01,0x0f,0x04,0x2a,0x00,
0xed,0x02,0x03,0x02,0x01,0x0f,0x04,0x2a,0x00,0xee,0x02,0x03,0x05,0x01,0x0f,0x04,0x52,0x14,0x00,0xef,0x02,0x03,0x02,0x01,0x0f,0x04,0x52,0x14,0x00,
0xf0,0x02,0x03,0x05,0x01,0x0f,0x04,0x3d,0x18,0x00,0xf1,0x02,0x03,0x02,0x01,0x0f,0x04,0x3d,0x18,0x00,0xf2,0x02,0x03,0x05,0x01,0x0f,0x04,0x61,0x00,
0xf3,0x02,0x03,0x02,0x01,0x0f,0x04,0x61,0x00,0xf4,0x02,0x03,0x05,0x01,0x47,0x04,0x1a,0x00,0xf5,0x02,0x03,0x02,0x01,0x47,0x04,0x1a,0x00,
0xf6,0x02,0x03,0x05,0x01,0x38,0x04,0x1a,0x00,0xf7,0x02,0x03,0x02,0x01,0x38,0x04,0x1a,0x00,0xf8,0x02,0x03,0x05,0x01,0x38,0x04,0x1c,0x00,
0xf9,0x02,0x03,0x05,0x01,0x36,0x04,0x18,0x00,0xfa,0x02,0x03,0x02,0x01,0x36,0x04,0x18,0x00,0xfb,0x02,0x03,0x05,0x01,0x36,0x04,0x0c,0x14,0x00,
0xfc,0x02,0x03,0x02,0x01,0x36,0x04,0x0c,0x14,0x00,0xfd,0x02,0x03,0x05,0x01,0x36,0x04,0x2d,0x00,0xfe,0x02,0x03,0x02,0x01,0x36,0x04,0x2d,0x00,
0xff,0x02,0x03,0x02,0x01,0x5a,0x28,0x00,0x80,0x03,0x03,0x02,0x01,0x49,0x04,0x0d,0x00,0x81,0x03,0x03,0x05,0x01,0x49,0x04,0x0b,0x00,
0x82,0x03,0x03,0x05,0x01,0x49,0x04,0xb0,0x01,0x00,0x83,0x03,0x03,0x02,0x01,0x49,0x04,0xb0,0x01,0x00,0x84,0x03,0x03,0x05,0x01,0x8e,0x01,0xa7,0x02,0x00,
0x85,0x03,0x03,0x02,0x01,0x8e,0x01,0xa7,0x02,0x00,0x86,0x03,0x03,0x05,0x01,0x54,0x0a,0x00,0x87,0x03,0x03,0x05,0x01,0x3b,0x04,0x0b,0x00,
0x88,0x03,0x03,0x02,0x01,0x3b,0x04,0x0b,0x00,0x89,0x03,0x03,0x05,0x01,0xb3,0x04,0x35,0x00,0x8a,0x03,0x03,0x05,0x01,0x35,0x04,0x0b,0x00,
0x8b,0x03,0x03,0x05,0x01,0x35,0x04,0xb0,0x01,0x00,0x8c,0x03,0x03,0x02,0x01,0x35,0x04,0xb0,0x01,0x00,0x8d,0x03,0x03,0x02,0x01,0x2e,0xcb,0x01,0x00,
0x8e,0x03,0x03,0x05,0x01,0x4b,0x11,0x00,0x8f,0x03,0x03,0x05,0x01,0x6b,0x00,0x90,0x03,0x03,0x05,0x01,0x54,0x11,0x00,
0x91,0x03,0x03,0x05,0x01,0x4f,0x04,0x0b,0x00,0x92,0x03,0x03,0x02,0x01,0x4f,0x04,0x0b,0x00,0x93,0x03,0x03,0x05,0x01,0x34,0x04,0x0b,0x00,
0x94,0x03,0x03,0x05,0x01,0x87,0x01,0x00,0x95,0x03,0x03,0x02,0x01,0xf9,0x02,0x00,0x96,0x03,0x03,0x05,0x01,0x30,0x00,
0x97,0x03,0x03,0x05,0x01,0x1b,0x04,0x0d,0x00,0x98,0x03,0x03,0x05,0x01,0x3a,0x04,0x0b,0x00,0x99,0x03,0x03,0x02,0x01,0x3a,0x04,0x0b,0x00,
0x9a,0x03,0x03,0x02,0x01,0x27,0x04,0x69,0x00,0x9b,0x03,0x03,0x02,0x01,0x94,0x04,0x04,0x0d,0x00,0x9c,0x03,0x03,0x05,0x01,0x2e,0x48,0x00,
0x9d,0x03,0x03,0x05,0x01,0x2b,0x04,0x73,0x0b,0x00,0x9e,0x03,0x03,0x02,0x01,0x2b,0x04,0x5a,0x6c,0x65,0x00,0x9f,0x03,0x03,0x05,0x01,0x0a,0x04,0x3e,0x1e,0x00,
0xa0,0x03,0x03,0x05,0x01,0x0a,0x04,0x45,0x00,0xa1,0x03,0x03,0x02,0x01,0x0a,0x04,0x45,0x00,0xa2,0x03,0x03,0x05,0x01,0xca,0x02,0x00,
0xa3,0x03,0x03,0x02,0x01,0xca,0x02,0x00,0xa4,0x03,0x03,0x05,0x01,0x44,0x04,0x0b,0x00,0xa5,0x03,0x03,0x02,0x01,0x44,0x04,0x0b,0x00,
0xa7,0x03,0x03,0x05,0x01,0x8e,0x01,0x8d,0x02,0x00,0xa8,0x03,0x03,0x02,0x01,0x8e,0x01,0x8d,0x02,0x00,0xa9,0x03,0x03,0x05,0x01,0x6e,0x00,
0xab,0x03,0x03,0x02,0x01,0x32,0x04,0x51,0x0b,0x00,0xac,0x03,0x03,0x05,0x01,0x32,0x04,0x0b,0x00,0xad,0x03,0x03,0x02,0x01,0x32,0x04,0x0b,0x00,
0xae,0x03,0x03,0x05,0x01,0x32,0x04,0x53,0x0b,0x00,0xaf,0x03,0x03,0x05,0x01,0x0f,0x04,0x45,0x00,0xb0,0x03,0x03,0x02,0x01,0x0f,0x04,0x45,0x00,
0xb1,0x03,0x03,0x05,0x01,0x39,0x00,0xb2,0x03,0x03,0x05,0x01,0x42,0x04,0x0b,0x00,0xb3,0x03,0x03,0x05,0x01,0x38,0x04,0x0b,0x00,
0xb4,0x03,0x03,0x02,0x01,0x38,0x04,0x0b,0x00,0xb5,0x03,0x03,0x05,0x01,0x36,0x04,0x0d,0x00,0xb6,0x03,0x03,0x02,0x01,0x36,0x04,0x0d,0x00,
0xb7,0x03,0x03,0x05,0x01,0x74,0x00,0xb8,0x03,0x03,0x05,0x01,0x74,0x4b,0x00,0xb9,0x03,0x03,0x02,0x01,0x74,0x4b,0x00,
0xba,0x03,0x03,0x02,0x01,0x74,0x04,0x43,0x00,0xbc,0x03,0x03,0x05,0x01,0x8e,0x01,0x8b,0x03,0x00,0xbd,0x03,0x03,0x02,0x01,0x8e,0x01,0x8b,0x03,0x00,
0xc4,0x03,0x03,0x05,0x01,0x9c,0x01,0x04,0x2d,0x00,0xc5,0x03,0x03,0x05,0x01,0x35,0x04,0x02,0x01,0x36,0x04,0x2d,0x00,0xc6,0x03,0x03,0x02,0x01,0x9c,0x01,0x04,0x2d,0x00,
0xc7,0x03,0x03,0x05,0x01,0xda,0x02,0x00,0xc8,0x03,0x03,0x05,0x01,0x27,0x04,0x02,0x01,0x4d,0x00,0xc9,0x03,0x03,0x02,0x01,0xda,0x02,0x00,
0xca,0x03,0x03,0x05,0x01,0xce,0x02,0x00,0xcb,0x03,0x03,0x05,0x01,0x2b,0x04,0x02,0x01,0x4d,0x00,0xcc,0x03,0x03,0x02,0x01,0xce,0x02,0x00,
0xcd,0x03,0x03,0x05,0x01,0x12,0x04,0x2d,0x00,0xce,0x03,0x03,0x02,0x01,0x12,0x04,0x2d,0x00,0xcf,0x03,0x03,0x05,0x01,0x1b,0x04,0x2d,0x00,
0xd0,0x03,0x03,0x02,0x01,0x1b,0x04,0x2d,0x00,0xd1,0x03,0x03,0x05,0x01,0x0a,0x04,0x2d,0x00,0xd2,0x03,0x03,0x02,0x01,0x0a,0x04,0x2d,0x00,
0xd3,0x03,0x03,0x05,0x01,0x0f,0x04,0x2d,0x00,0xd4,0x03,0x03,0x02,0x01,0x0f,0x04,0x2d,0x00,0xd5,0x03,0x03,0x05,0x01,0x0f,0x04,0x1c,0x08,0x23,0x00,
0xd6,0x03,0x03,0x02,0x01,0x0f,0x04,0x1c,0x08,0x23,0x00,0xd7,0x03,0x03,0x05,0x01,0x0f,0x04,0x1c,0x08,0x18,0x00,0xd8,0x03,0x03,0x02,0x01,0x0f,0x04,0x1c,0x08,0x18,0x00,
0xd9,0x03,0x03,0x05,0x01,0x0f,0x04,0x1c,0x08,0x2d,0x00,0xda,0x03,0x03,0x02,0x01,0x0f,0x04,0x1c,0x08,0x2d,0x00,0xdb,0x03,0x03,0x05,0x01,0x0f,0x04,0x1c,0x08,0x24,0x00,
0xdc,0x03,0x03,0x02,0x01,0x0f,0x04,0x1c,0x08,0x24,0x00,0xdd,0x03,0x03,0x02,0x01,0x2e,0x11,0x00,0xde,0x03,0x03,0x05,0x01,0x12,0x04,0x1c,0x08,0x23,0x00,
0xdf,0x03,0x03,0x02,0x01,0x12,0x04,0x1c,0x08,0x23,0x00,0xe0,0x03,0x03,0x05,0x01,0x12,0x04,0x0c,0x14,0x08,0x23,0x00,0xe1,0x03,0x03,0x02,0x01,0x12,0x04,0x0c,0x14,0x08,0x23,0x00,
0xe2,0x03,0x03,0x05,0x01,0x6f,0x04,0x23,0x00,0xe3,0x03,0x03,0x02,0x01,0x6f,0x04,0x23,0x00,0xe4,0x03,0x03,0x05,0x01,0x34,0x04,0x0d,0x00,
0xe5,0x03,0x03,0x02,0x01,0x34,0x04,0x0d,0x00,0xe6,0x03,0x03,0x05,0x01,0x34,0x04,0x2d,0x00,0xe7,0x03,0x03,0x02,0x01,0x34,0x04,0x2d,0x00,
0xe8,0x03,0x03,0x05,0x01,0x3a,0x04,0x2d,0x00,0xe9,0x03,0x03,0x02,0x01,0x3a,0x04,0x2d,0x00,0xea,0x03,0x03,0x05,0x01,0x0a,0x04,0x61,0x00,
0xeb,0x03,0x03,0x02,0x01,0x0a,0x04,0x61,0x00,0xec,0x03,0x03,0x05,0x01,0x0a,0x04,0x61,0x08,0x23,0x00,0xed,0x03,0x03,0x02,0x01,0x0a,0x04,0x61,0x08,0x23,0x00,
0xee,0x03,0x03,0x05,0x01,0x74,0x04,0x2d,0x00,0xef,0x03,0x03,0x02,0x01,0x74,0x04,0x2d,0x00,0xf0,0x03,0x03,0x02,0x01,0x4d,0x04,0x2d,0x00,
0xf1,0x03,0x03,0x05,0x01,0x9c,0x01,0x00,0xf2,0x03,0x03,0x05,0x01,0x35,0x04,0x02,0x01,0x36,0x00,0xf3,0x03,0x03,0x02,0x01,0x9c,0x01,0x00,
0xf4,0x03,0x03,0x05,0x01,0x34,0x04,0x18,0x00,0xf5,0x03,0x03,0x02,0x01,0x34,0x04,0x18,0x00,0xf6,0x03,0x03,0x05,0x01,0x97,0x04,0x00,
0xf7,0x03,0x03,0x05,0x01,0xc6,0x03,0x00,0xf8,0x03,0x03,0x05,0x01,0x2b,0x04,0x24,0x00,0xf9,0x03,0x03,0x02,0x01,0x2b,0x04,0x24,0x00,
0xfa,0x03,0x03,0x05,0x01,0x12,0x04,0x52,0x14,0x08,0x18,0x00,0xfb,0x03,0x03,0x02,0x01,0x12,0x04,0x52,0x14,0x08,0x18,0x00,0xfc,0x03,0x03,0x05,0x01,0x6f,0x04,0x18,0x00,
0xfd,0x03,0x03,0x02,0x01,0x6f,0x04,0x18,0x00,0xfe,0x03,0x03,0x05,0x01,0x0a,0x04,0x0d,0x08,0x18,0x00,0xff,0x03,0x03,0x02,0x01,0x0a,0x04,0x0d,0x08,0x18,0x00,
0x80,0x04,0x03,0x05,0x01,0x12,0x04,0x3d,0x24,0x00,0x81,0x04,0x03,0x02,0x01,0x12,0x04,0x3d,0x24,0x00,0x82,0x04,0x03,0x05,0x01,0x12,0x04,0x5b,0x2a,0x00,
0x83,0x04,0x03,0x02,0x01,0x12,0x04,0x5b,0x2a,0x00,0x84,0x04,0x03,0x05,0x01,0x11,0x04,0x3d,0x24,0x00,0x85,0x04,0x03,0x02,0x01,0x11,0x04,0x3d,0x24,0x00,
0x86,0x04,0x03,0x05,0x01,0x11,0x04,0x5b,0x2a,0x00,0x87,0x04,0x03,0x02,0x01,0x11,0x04,0x5b,0x2a,0x00,0x88,0x04,0x03,0x05,0x01,0x1b,0x04,0x3d,0x24,0x00,
0x89,0x04,0x03,0x02,0x01,0x1b,0x04,0x3d,0x24,0x00,0x8a,0x04,0x03,0x05,0x01,0x1b,0x04,0x5b,0x2a,0x00,0x8b,0x04,0x03,0x02,0x01,0x1b,0x04,0x5b,0x2a,0x00,
0x8c,0x04,0x03,0x05,0x01,0x0a,0x04,0x3d,0x24,0x00,0x8d,0x04,0x03,0x02,0x01,0x0a,0x04,0x3d,0x24,0x00,0x8e,0x04,0x03,0x05,0x01,0x0a,0x04,0x5b,0x2a,0x00,
0x8f,0x04,0x03,0x02,0x01,0x0a,0x04,0x5b,0x2a,0x00,0x90,0x04,0x03,0x05,0x01,0x22,0x04,0x3d,0x24,0x00,0x91,0x04,0x03,0x02,0x01,0x22,0x04,0x3d,0x24,0x00,
0x92,0x04,0x03,0x05,0x01,0x22,0x04,0x5b,0x2a,0x00,0x93,0x04,0x03,0x02,0x01,0x22,0x04,0x5b,0x2a,0x00,0x94,0x04,0x03,0x05,0x01,0x0f,0x04,0x3d,0x24,0x00,
0x95,0x04,0x03,0x02,0x01,0x0f,0x04,0x3d,0x24,0x00,0x96,0x04,0x03,0x05,0x01,0x0f,0x04,0x5b,0x2a,0x00,0x97,0x04,0x03,0x02,0x01,0x0f,0x04,0x5b,0x2a,0x00,
0x98,0x04,0x03,0x05,0x01,0x28,0x04,0x9d,0x01,0x0e,0x00,0x99,0x04,0x03,0x02,0x01,0x28,0x04,0x9d,0x01,0x0e,0x00,0x9a,0x04,0x03,0x05,0x01,0x32,0x04,0x9d,0x01,0x0e,0x00,
0x9b,0x04,0x03,0x02,0x01,0x32,0x04,0x9d,0x01,0x0e,0x00,0x9c,0x04,0x03,0x05,0x01,0xf4,0x01,0x00,0x9d,0x04,0x03,0x02,0x01,0xf4,0x01,0x00,
0x9e,0x04,0x03,0x05,0x01,0x33,0x04,0x2d,0x00,0x9f,0x04,0x03,0x02,0x01,0x33,0x04,0x2d,0x00,0xa0,0x04,0x03,0x05,0x01,0x2b,0x04,0x5a,0x6c,0x65,0x00,
0xa1,0x04,0x03,0x02,0x01,0x35,0x04,0x68,0x00,0xa2,0x04,0x03,0x05,0x01,0xc3,0x02,0x00,0xa3,0x04,0x03,0x02,0x01,0xc3,0x02,0x00,
0xa4,0x04,0x03,0x05,0x01,0x36,0x04,0x0b,0x00,0xa5,0x04,0x03,0x02,0x01,0x36,0x04,0x0b,0x00,0xa6,0x04,0x03,0x05,0x01,0x12,0x04,0x0c,0x14,0x00,
0xa7,0x04,0x03,0x02,0x01,0x12,0x04,0x0c,0x14,0x00,0xa8,0x04,0x03,0x05,0x01,0x11,0x04,0x40,0x00,0xa9,0x04,0x03,0x02,0x01,0x11,0x04,0x40,0x00,
0xaa,0x04,0x03,0x05,0x01,0x0a,0x04,0x1c,0x08,0x23,0x00,0xab,0x04,0x03,0x02,0x01,0x0a,0x04,0x1c,0x08,0x23,0x00,0xac,0x04,0x03,0x05,0x01,0x0a,0x04,0x1e,0x08,0x23,0x00,
0xad,0x04,0x03,0x02,0x01,0x0a,0x04,0x1e,0x08,0x23,0x00,0xae,0x04,0x03,0x05,0x01,0x0a,0x04,0x0c,0x14,0x00,0xaf,0x04,0x03,0x02,0x01,0x0a,0x04,0x0c,0x14,0x00,
0xb0,0x04,0x03,0x05,0x01,0x0a,0x04,0x0c,0x14,0x08,0x23,0x00,0xb1,0x04,0x03,0x02,0x01,0x0a,0x04,0x0c,0x14,0x08,0x23,0x00,0xb2,0x04,0x03,0x05,0x01,0x38,0x04,0x23,0x00,
0xb3,0x04,0x03,0x02,0x01,0x38,0x04,0x23,0x00,0xb4,0x04,0x03,0x02,0x01,0x27,0x04,0x68,0x00,0xb5,0x04,0x03,0x02,0x01,0x2b,0x04,0x68,0x00,
0xb6,0x04,0x03,0x02,0x01,0x32,0x04,0x68,0x00,0xb7,0x04,0x03,0x02,0x01,0xc9,0x01,0x4d,0x00,0xb8,0x04,0x03,0x02,0x01,0xad,0x04,0x66,0x00,
0xb9,0x04,0x03,0x02,0x01,0xf8,0x03,0x66,0x00,0xba,0x04,0x03,0x05,0x01,0x12,0x04,0x0d,0x00,0xbb,0x04,0x03,0x05,0x01,0x3b,0x04,0x0d,0x00,
0xbc,0x04,0x03,0x02,0x01,0x3b,0x04,0x0d,0x00,0xbd,0x04,0x03,0x05,0x01,0x27,0x04,0x69,0x00,0xbe,0x04,0x03,0x05,0x01,0x32,0x04,0x67,0x0d,0x00,
0xbf,0x04,0x03,0x02,0x01,0x28,0x04,0xb2,0x01,0x43,0x00,0xc0,0x04,0x03,0x02,0x01,0x36,0x04,0xb2,0x01,0x43,0x00,0xc1,0x04,0x03,0x05,0x01,0x83,0x03,0xa1,0x02,0x00,
0xc2,0x04,0x03,0x02,0x01,0x83,0x03,0xa1,0x02,0x00,0xc3,0x04,0x03,0x05,0x01,0x49,0x04,0x0d,0x00,0xc4,0x04,0x03,0x05,0x01,0x0f,0x69,0x00,
0xc5,0x04,0x03,0x05,0x01,0x2e,0x42,0x00,0xc6,0x04,0x03,0x05,0x01,0x11,0x04,0x0d,0x00,0xc7,0x04,0x03,0x02,0x01,0x11,0x04,0x0d,0x00,
0xc8,0x04,0x03,0x05,0x01,0x4d,0x04,0x0d,0x00,0xc9,0x04,0x03,0x02,0x01,0x4d,0x04,0x0d,0x00,0xca,0x04,0x03,0x05,0x01,0x02,0x5d,0x04,0x0b,0x43,0x00,
0xcb,0x04,0x03,0x02,0x01,0x5d,0x04,0x0b,0x43,0x00,0xcc,0x04,0x03,0x05,0x01,0x22,0x04,0x0d,0x00,0xcd,0x04,0x03,0x02,0x01,0x22,0x04,0x0d,0x00,
0xce,0x04,0x03,0x05,0x01,0x38,0x04,0x0d,0x00,0xcf,0x04,0x03,0x02,0x01,0x38,0x04,0x0d,0x00,0xd0,0x04,0x03,0x02,0x01,0x2e,0x12,0x00,
0xd1,0x04,0x03,0x02,0x01,0x20,0x00,0xd2,0x04,0x03,0x02,0x01,0x2e,0x20,0x00,0xd3,0x04,0x03,0x02,0x01,0x49,0x04,0x0b,0x00,
0xd4,0x04,0x03,0x02,0x01,0x54,0x0a,0x00,0xd5,0x04,0x03,0x02,0x01,0x3b,0x04,0x68,0x00,0xd6,0x04,0x03,0x02,0x01,0x35,0x04,0x43,0x00,
0xd7,0x04,0x03,0x02,0x01,0x35,0x04,0x0b,0x00,0xd8,0x04,0x03,0x02,0x01,0x4b,0x11,0x00,0xd9,0x04,0x03,0x02,0x01,0x6b,0x00,
0xda,0x04,0x03,0x02,0x01,0x6b,0x04,0x0b,0x00,0xdb,0x04,0x03,0x02,0x01,0x54,0x11,0x00,0xdc,0x04,0x03,0x02,0x01,0x4b,0x54,0x11,0x00,
0xdd,0x04,0x03,0x02,0x01,0x4b,0x54,0x11,0x04,0x0b,0x00,0xde,0x04,0x03,0x02,0x01,0x88,0x01,0x4b,0x54,0x11,0x00,0xdf,0x04,0x03,0x02,0x01,0xc9,0x01,0x4d,0x04,0x0d,0x00,
0xe0,0x04,0x03,0x02,0x01,0x34,0x04,0x0b,0x00,0xe1,0x04,0x03,0x02,0x01,0xa3,0x01,0x34,0x00,0xe3,0x04,0x03,0x02,0x01,0x87,0x01,0x00,
0xe4,0x04,0x03,0x02,0x01,0xf1,0x03,0x45,0x00,0xe5,0x04,0x03,0x02,0x01,0x2e,0x33,0x00,0xe6,0x04,0x03,0x02,0x01,0x33,0x04,0x0b,0x00,
0xe7,0x04,0x03,0x02,0x01,0xdf,0x01,0x04,0x0b,0x00,0xe8,0x04,0x03,0x02,0x01,0x1b,0x04,0x0d,0x00,0xe9,0x04,0x03,0x02,0x01,0x30,0x00,
0xeb,0x04,0x03,0x02,0x01,0x27,0x04,0x3e,0x1e,0x00,0xec,0x04,0x03,0x02,0x01,0x27,0x04,0xe7,0x01,0x00,0xed,0x04,0x03,0x02,0x01,0x27,0x04,0x53,0x0b,0x00,
0xee,0x04,0x03,0x02,0x01,0x90,0x04,0x00,0xef,0x04,0x03,0x02,0x01,0x2e,0x48,0x00,0xf0,0x04,0x03,0x02,0x01,0x2e,0x48,0x04,0x5a,0x65,0x00,
0xf1,0x04,0x03,0x02,0x01,0x48,0x04,0x0b,0x00,0xf2,0x04,0x03,0x02,0x01,0x2b,0x04,0x73,0x0b,0x00,0xf3,0x04,0x03,0x02,0x01,0x2b,0x04,0x53,0x0b,0x00,
0xf5,0x04,0x03,0x02,0x01,0x8a,0x01,0x0a,0x00,0xf7,0x04,0x03,0x02,0x01,0x88,0x01,0x21,0x00,0xf8,0x04,0x03,0x02,0x01,0xa6,0x01,0x00,
0xf9,0x04,0x03,0x02,0x01,0x2e,0x22,0x00,0xfa,0x04,0x03,0x02,0x01,0x2e,0x22,0x04,0x5a,0x65,0x00,0xfb,0x04,0x03,0x02,0x01,0x2e,0x22,0x04,0x0b,0x00,
0xfc,0x04,0x03,0x02,0x01,0x22,0x04,0x5a,0x65,0x00,0xfd,0x04,0x03,0x02,0x01,0x22,0x04,0x43,0x00,0xfe,0x04,0x03,0x02,0x01,0x22,0x04,0xaa,0x01,0x00,
0xff,0x04,0x03,0x02,0x01,0x4b,0x22,0x04,0xaa,0x01,0x00,0x82,0x05,0x03,0x02,0x01,0x28,0x04,0x0b,0x00,0x83,0x05,0x03,0x02,0x01,0x6e,0x00,
0x84,0x05,0x03,0x02,0x01,0xc9,0x01,0x4d,0x04,0x0d,0x08,0x0b,0x00,0x85,0x05,0x03,0x02,0x01,0xe9,0x03,0x4b,0x6e,0x00,0x86,0x05,0x03,0x02,0x01,0x6e,0x04,0x68,0x00,
0x87,0x05,0x03,0x02,0x01,0x2e,0x32,0x00,0x88,0x05,0x03,0x02,0x01,0x32,0x04,0x53,0x0b,0x00,0x89,0x05,0x03,0x02,0x01,0x0f,0x69,0x00,
0x8a,0x05,0x03,0x02,0x01,0x39,0x00,0x8b,0x05,0x03,0x02,0x01,0x42,0x04,0x0b,0x00,0x8c,0x05,0x03,0x02,0x01,0x2e,0x42,0x00,
0x8d,0x05,0x03,0x02,0x01,0x2e,0x47,0x00,0x8e,0x05,0x03,0x02,0x01,0x2e,0x38,0x00,0x90,0x05,0x03,0x02,0x01,0x36,0x04,0x53,0x0b,0x00,
0x91,0x05,0x03,0x02,0x01,0x36,0x04,0x68,0x00,0x92,0x05,0x03,0x02,0x01,0x74,0x00,0x93,0x05,0x03,0x02,0x01,0x74,0x04,0x68,0x00,
0x9a,0x05,0x03,0x02,0x01,0x88,0x01,0x54,0x11,0x00,0x9d,0x05,0x03,0x02,0x01,0x4d,0x04,0x80,0x01,0x00,0x9e,0x05,0x03,0x02,0x01,0x2e,0x3a,0x00,
0xa0,0x05,0x03,0x02,0x01,0x5d,0x04,0x0b,0x00,0xa3,0x05,0x03,0x02,0x01,0x9c,0x01,0x66,0x00,0xa4,0x05,0x03,0x02,0x01,0xac,0x04,0x66,0x00,
0xa5,0x05,0x03,0x02,0x01,0x9c,0x01,0x66,0x04,0x68,0x00,0xa6,0x05,0x03,0x02,0x01,0xd6,0x03,0x66,0x00,0xa7,0x05,0x03,0x02,0x01,0xe1,0x03,0x66,0x00,
0xa8,0x05,0x03,0x02,0x01,0xe2,0x03,0x66,0x04,0x68,0x00,0xa9,0x05,0x03,0x02,0x01,0xa4,0x04,0x66,0x00,0xaa,0x05,0x03,0x02,0x01,0x8c,0x04,0x66,0x00,
0xab,0x05,0x03,0x02,0x01,0x88,0x04,0x66,0x00,0xae,0x05,0x03,0x02,0x01,0x2e,0x33,0x04,0xaa,0x01,0x00,0xaf,0x05,0x03,0x02,0x01,0x2e,0x33,0x04,0xaa,0x01,0x08,0x43,0x00,
0xe3,0x06,0x2c,0x03,0x02,0x01,0x12,0x00,0xe4,0x06,0x2c,0x03,0x02,0x01,0x11,0x00,0xe5,0x06,0x2c,0x03,0x02,0x01,0x1b,0x00,
0xe6,0x06,0x2c,0x03,0x02,0x01,0x0a,0x00,0xe7,0x06,0x2c,0x03,0x02,0x01,0x0f,0x00,0xe8,0x06,0x2c,0x03,0x02,0x01,0x3b,0x00,
0xe9,0x06,0x2c,0x03,0x02,0x01,0x35,0x00,0xea,0x06,0x2c,0x03,0x02,0x01,0x33,0x00,0xeb,0x06,0x2c,0x03,0x02,0x01,0x48,0x00,
0xec,0x06,0x2c,0x03,0x02,0x01,0x22,0x00,0xed,0x06,0x2c,0x03,0x02,0x01,0x32,0x00,0xee,0x06,0x2c,0x03,0x02,0x01,0x42,0x00,
0xef,0x06,0x2c,0x03,0x02,0x01,0x50,0x00,0xf0,0x06,0x07,0x05,0x01,0xfc,0x02,0x00,0xf1,0x06,0x07,0x02,0x01,0xfc,0x02,0x00,
0xf2,0x06,0x07,0x05,0x01,0xe8,0x01,0xa4,0x01,0x00,0xf3,0x06,0x07,0x02,0x01,0xe8,0x01,0xa4,0x01,0x00,0xf6,0x06,0x07,0x05,0x01,0xc1,0x02,0xe4,0x01,0x00,
0xf7,0x06,0x07,0x02,0x01,0xc1,0x02,0xe4,0x01,0x00,0xff,0x06,0x07,0x05,0x01,0xc4,0x03,0x00,0x86,0x07,0x07,0x05,0x01,0x20,0x04,0x57,0x00,
0x88,0x07,0x07,0x05,0x01,0x4e,0x04,0x57,0x00,0x89,0x07,0x07,0x05,0x01,0x29,0x04,0x57,0x00,0x8a,0x07,0x07,0x05,0x01,0x30,0x04,0x57,0x00,
0x8c,0x07,0x07,0x05,0x01,0x4c,0x04,0x57,0x00,0x8e,0x07,0x07,0x05,0x01,0x39,0x04,0x57,0x00,0x8f,0x07,0x07,0x05,0x01,0x21,0x04,0x57,0x00,
0x90,0x07,0x07,0x02,0x01,0x30,0x04,0x64,0x08,0x57,0x00,0x91,0x07,0x07,0x05,0x01,0x20,0x00,0x92,0x07,0x07,0x05,0x01,0x9e,0x01,0x00,
0x93,0x07,0x07,0x05,0x01,0x87,0x01,0x00,0x94,0x07,0x07,0x05,0x01,0xcb,0x01,0x00,0x95,0x07,0x07,0x05,0x01,0x4e,0x00,
0x96,0x07,0x07,0x05,0x01,0xee,0x01,0x00,0x97,0x07,0x07,0x05,0x01,0x29,0x00,0x98,0x07,0x07,0x05,0x01,0x9b,0x02,0x00,
0x99,0x07,0x07,0x05,0x01,0x30,0x00,0x9a,0x07,0x07,0x05,0x01,0xea,0x02,0x00,0x9b,0x07,0x07,0x05,0x01,0xe1,0x02,0x00,
0x9c,0x07,0x07,0x05,0x01,0xda,0x01,0x00,0x9d,0x07,0x07,0x05,0x01,0xd9,0x01,0x00,0x9e,0x07,0x07,0x05,0x01,0xfa,0x01,0x00,
0x9f,0x07,0x07,0x05,0x01,0x4c,0x00,0xa0,0x07,0x07,0x05,0x01,0xb6,0x01,0x00,0xa1,0x07,0x07,0x05,0x01,0x94,0x01,0x00,
0xa3,0x07,0x07,0x05,0x01,0xd6,0x01,0x00,0xa4,0x07,0x07,0x05,0x01,0xb1,0x01,0x00,0xa5,0x07,0x07,0x05,0x01,0x39,0x00,
0xa6,0x07,0x07,0x05,0x01,0xa6,0x01,0x00,0xa7,0x07,0x07,0x05,0x01,0x89,0x01,0x00,0xa8,0x07,0x07,0x05,0x01,0x95,0x01,0x00,
0xa9,0x07,0x07,0x05,0x01,0x21,0x00,0xaa,0x07,0x07,0x05,0x01,0x30,0x04,0x64,0x00,0xab,0x07,0x07,0x05,0x01,0x39,0x04,0x64,0x00,
0xac,0x07,0x07,0x02,0x01,0x20,0x04,0x57,0x00,0xad,0x07,0x07,0x02,0x01,0x4e,0x04,0x57,0x00,0xae,0x07,0x07,0x02,0x01,0x29,0x04,0x57,0x00,
0xaf,0x07,0x07,0x02,0x01,0x30,0x04,0x57,0x00,0xb0,0x07,0x07,0x02,0x01,0x39,0x04,0x64,0x08,0x57,0x00,0xb1,0x07,0x07,0x02,0x01,0x20,0x00,
0xb2,0x07,0x07,0x02,0x01,0x9e,0x01,0x00,0xb3,0x07,0x07,0x02,0x01,0x87,0x01,0x00,0xb4,0x07,0x07,0x02,0x01,0xcb,0x01,0x00,
0xb5,0x07,0x07,0x02,0x01,0x4e,0x00,0xb6,0x07,0x07,0x02,0x01,0xee,0x01,0x00,0xb7,0x07,0x07,0x02,0x01,0x29,0x00,
0xb8,0x07,0x07,0x02,0x01,0x9b,0x02,0x00,0xb9,0x07,0x07,0x02,0x01,0x30,0x00,0xba,0x07,0x07,0x02,0x01,0xea,0x02,0x00,
0xbb,0x07,0x07,0x02,0x01,0xe1,0x02,0x00,0xbc,0x07,0x07,0x02,0x01,0xda,0x01,0x00,0xbd,0x07,0x07,0x02,0x01,0xd9,0x01,0x00,
0xbe,0x07,0x07,0x02,0x01,0xfa,0x01,0x00,0xbf,0x07,0x07,0x02,0x01,0x4c,0x00,0xc0,0x07,0x07,0x02,0x01,0xb6,0x01,0x00,
0xc1,0x07,0x07,0x02,0x01,0x94,0x01,0x00,0xc2,0x07,0x07,0x02,0x01,0xa3,0x04,0xd6,0x01,0x00,0xc3,0x07,0x07,0x02,0x01,0xd6,0x01,0x00,
0xc4,0x07,0x07,0x02,0x01,0xb1,0x01,0x00,0xc5,0x07,0x07,0x02,0x01,0x39,0x00,0xc6,0x07,0x07,0x02,0x01,0xa6,0x01,0x00,
0xc7,0x07,0x07,0x02,0x01,0x89,0x01,0x00,0xc8,0x07,0x07,0x02,0x01,0x95,0x01,0x00,0xc9,0x07,0x07,0x02,0x01,0x21,0x00,
0xca,0x07,0x07,0x02,0x01,0x30,0x04,0x64,0x00,0xcb,0x07,0x07,0x02,0x01,0x39,0x04,0x64,0x00,0xcc,0x07,0x07,0x02,0x01,0x4c,0x04,0x57,0x00,
0xcd,0x07,0x07,0x02,0x01,0x39,0x04,0x57,0x00,0xce,0x07,0x07,0x02,0x01,0x21,0x04,0x57,0x00,0xd9,0x07,0x07,0x02,0x01,0xe8,0x01,0xbf,0x01,0x00,
0xdb,0x07,0x07,0x02,0x01,0xe8,0x03,0x00,0xdd,0x07,0x07,0x02,0x01,0xe4,0x01,0x00,0xdf,0x07,0x07,0x02,0x01,0xbf,0x01,0x00,
0xe1,0x07,0x07,0x02,0x01,0xa4,0x01,0x00,0xe2,0x07,0x09,0x05,0x01,0x78,0x00,0xe3,0x07,0x09,0x02,0x01,0x78,0x00,
0xe4,0x07,0x09,0x05,0x01,0x8d,0x03,0x00,0xe5,0x07,0x09,0x02,0x01,0x8d,0x03,0x00,0xe6,0x07,0x09,0x05,0x01,0x96,0x01,0x00,
0xe7,0x07,0x09,0x02,0x01,0x96,0x01,0x00,0xe8,0x07,0x09,0x05,0x01,0x98,0x01,0x00,0xe9,0x07,0x09,0x02,0x01,0x98,0x01,0x00,
0xea,0x07,0x09,0x05,0x01,0x99,0x01,0x00,0xeb,0x07,0x09,0x02,0x01,0x99,0x01,0x00,0xec,0x07,0x09,0x05,0x01,0x92,0x01,0x00,
0xed,0x07,0x09,0x02,0x01,0x92,0x01,0x00,0xee,0x07,0x09,0x05,0x01,0x9d,0x03,0x00,0xef,0x07,0x09,0x02,0x01,0x9d,0x03,0x00,
0xf7,0x07,0x07,0x05,0x01,0xac,0x02,0x00,0xf8,0x07,0x07,0x02,0x01,0xac,0x02,0x00,0xfa,0x07,0x07,0x05,0x01,0xb5,0x01,0x00,
0xfb,0x07,0x07,0x02,0x01,0xb5,0x01,0x00,0x80,0x08,0x06,0x05,0x01,0x7c,0x04,0x24,0x00,0x81,0x08,0x06,0x05,0x01,0xf3,0x02,0x00,
0x82,0x08,0x06,0x05,0x01,0xca,0x01,0x00,0x83,0x08,0x06,0x05,0x01,0x85,0x03,0x00,0x84,0x08,0x06,0x05,0x01,0x89,0x02,0x7c,0x00,
0x85,0x08,0x06,0x05,0x01,0x9b,0x01,0x00,0x86,0x08,0x06,0x05,0x01,0xac,0x03,0x1b,0x00,0x87,0x08,0x06,0x05,0x01,0x9f,0x01,0x00,
0x88,0x08,0x06,0x05,0x01,0xf0,0x02,0x00,0x89,0x08,0x06,0x05,0x01,0xbd,0x01,0x00,0x8a,0x08,0x06,0x05,0x01,0xb8,0x01,0x00,
0x8b,0x08,0x06,0x05,0x01,0x92,0x02,0x00,0x8c,0x08,0x06,0x05,0x01,0xe4,0x02,0x00,0x8d,0x08,0x06,0x05,0x01,0x1b,0x04,0x24,0x00,
0x8e,0x08,0x06,0x05,0x01,0x71,0x0f,0x00,0x8f,0x08,0x06,0x05,0x01,0x96,0x03,0x00,0x90,0x08,0x06,0x05,0x01,0x12,0x00,
0x91,0x08,0x06,0x05,0x01,0xb4,0x03,0x00,0x92,0x08,0x06,0x05,0x01,0xd2,0x01,0x00,0x93,0x08,0x06,0x05,0x01,0x62,0x00,
0x94,0x08,0x06,0x05,0x01,0x7e,0x00,0x95,0x08,0x06,0x05,0x01,0x7c,0x00,0x96,0x08,0x06,0x05,0x01,0x6a,0x00,
0x97,0x08,0x06,0x05,0x01,0x75,0x00,0x98,0x08,0x06,0x05,0x01,0x1b,0x00,0x99,0x08,0x06,0x05,0x01,0x71,0x1b,0x00,
0x9a,0x08,0x06,0x05,0x01,0x59,0x00,0x9b,0x08,0x06,0x05,0x01,0x63,0x00,0x9c,0x08,0x06,0x05,0x01,0x9a,0x01,0x00,
0x9d,0x08,0x06,0x05,0x01,0x5e,0x00,0x9e,0x08,0x06,0x05,0x01,0x0a,0x00,0x9f,0x08,0x06,0x05,0x01,0x79,0x00,
0xa0,0x08,0x06,0x05,0x01,0xc5,0x01,0x00,0xa1,0x08,0x06,0x05,0x01,0xab,0x01,0x00,0xa2,0x08,0x06,0x05,0x01,0x70,0x00,
0xa3,0x08,0x06,0x05,0x01,0x0f,0x00,0xa4,0x08,0x06,0x05,0x01,0x90,0x03,0x00,0xa5,0x08,0x06,0x05,0x01,0x56,0x00,
0xa6,0x08,0x06,0x05,0x01,0xa2,0x01,0x00,0xa7,0x08,0x06,0x05,0x01,0x5f,0x00,0xa8,0x08,0x06,0x05,0x01,0x93,0x01,0x00,
0xa9,0x08,0x06,0x05,0x01,0xae,0x02,0x00,0xaa,0x08,0x06,0x05,0x01,0xe1,0x01,0x84,0x01,0x00,0xab,0x08,0x06,0x05,0x01,0x76,0x00,
0xac,0x08,0x06,0x05,0x01,0x77,0x84,0x01,0x00,0xad,0x08,0x06,0x05,0x01,0x11,0x00,0xae,0x08,0x06,0x05,0x01,0x83,0x01,0x00,
0xaf,0x08,0x06,0x05,0x01,0xd1,0x01,0x00,0xb0,0x08,0x06,0x02,0x01,0x12,0x00,0xb1,0x08,0x06,0x02,0x01,0xb4,0x03,0x00,
0xb2,0x08,0x06,0x02,0x01,0xd2,0x01,0x00,0xb3,0x08,0x06,0x02,0x01,0x62,0x00,0xb4,0x08,0x06,0x02,0x01,0x7e,0x00,
0xb5,0x08,0x06,0x02,0x01,0x7c,0x00,0xb6,0x08,0x06,0x02,0x01,0x6a,0x00,0xb7,0x08,0x06,0x02,0x01,0x75,0x00,
0xb8,0x08,0x06,0x02,0x01,0x1b,0x00,0xb9,0x08,0x06,0x02,0x01,0x71,0x1b,0x00,0xba,0x08,0x06,0x02,0x01,0x59,0x00,
0xbb,0x08,0x06,0x02,0x01,0x63,0x00,0xbc,0x08,0x06,0x02,0x01,0x9a,0x01,0x00,0xbd,0x08,0x06,0x02,0x01,0x5e,0x00,
0xbe,0x08,0x06,0x02,0x01,0x0a,0x00,0xbf,0x08,0x06,0x02,0x01,0x79,0x00,0xc0,0x08,0x06,0x02,0x01,0xc5,0x01,0x00,
0xc1,0x08,0x06,0x02,0x01,0xab,0x01,0x00,0xc2,0x08,0x06,0x02,0x01,0x70,0x00,0xc3,0x08,0x06,0x02,0x01,0x0f,0x00,
0xc4,0x08,0x06,0x02,0x01,0x90,0x03,0x00,0xc5,0x08,0x06,0x02,0x01,0x56,0x00,0xc6,0x08,0x06,0x02,0x01,0xa2,0x01,0x00,
0xc7,0x08,0x06,0x02,0x01,0x5f,0x00,0xc8,0x08,0x06,0x02,0x01,0x93,0x01,0x00,0xc9,0x08,0x06,0x02,0x01,0xae,0x02,0x00,
0xca,0x08,0x06,0x02,0x01,0xe1,0x01,0x84,0x01,0x00,0xcb,0x08,0x06,0x02,0x01,0x76,0x00,0xcc,0x08,0x06,0x02,0x01,0x77,0x84,0x01,0x00,
0xcd,0x08,0x06,0x02,0x01,0x11,0x00,0xce,0x08,0x06,0x02,0x01,0x83,0x01,0x00,0xcf,0x08,0x06,0x02,0x01,0xd1,0x01,0x00,
0xd0,0x08,0x06,0x02,0x01,0x7c,0x04,0x24,0x00,0xd1,0x08,0x06,0x02,0x01,0xf3,0x02,0x00,0xd2,0x08,0x06,0x02,0x01,0xca,0x01,0x00,
0xd3,0x08,0x06,0x02,0x01,0x85,0x03,0x00,0xd4,0x08,0x06,0x02,0x01,0x89,0x02,0x7c,0x00,0xd5,0x08,0x06,0x02,0x01,0x9b,0x01,0x00,
0xd6,0x08,0x06,0x02,0x01,0xac,0x03,0x1b,0x00,0xd7,0x08,0x06,0x02,0x01,0x9f,0x01,0x00,0xd8,0x08,0x06,0x02,0x01,0xf0,0x02,0x00,
0xd9,0x08,0x06,0x02,0x01,0xbd,0x01,0x00,0xda,0x08,0x06,0x02,0x01,0xb8,0x01,0x00,0xdb,0x08,0x06,0x02,0x01,0x92,0x02,0x00,
0xdc,0x08,0x06,0x02,0x01,0xe4,0x02,0x00,0xdd,0x08,0x06,0x02,0x01,0x1b,0x04,0x24,0x00,0xde,0x08,0x06,0x02,0x01,0x71,0x0f,0x00,
0xdf,0x08,0x06,0x02,0x01,0x96,0x03,0x00,0xe0,0x08,0x06,0x05,0x01,0x21,0x00,0xe1,0x08,0x06,0x02,0x01,0x21,0x00,
0xe2,0x08,0x06,0x05,0x01,0x8b,0x01,0x00,0xe3,0x08,0x06,0x02,0x01,0x8b,0x01,0x00,0xe4,0x08,0x06,0x05,0x01,0x60,0x11,0x00,
0xe5,0x08,0x06,0x02,0x01,0x60,0x11,0x00,0xe6,0x08,0x06,0x05,0x01,0x7b,0x46,0x00,0xe7,0x08,0x06,0x02,0x01,0x7b,0x46,0x00,
0xe8,0x08,0x06,0x05,0x01,0x60,0x7b,0x46,0x00,0xe9,0x08,0x06,0x02,0x01,0x60,0x7b,0x46,0x00,0xea,0x08,0x06,0x05,0x01,0x81,0x01,0x46,0x00,
0xeb,0x08,0x06,0x02,0x01,0x81,0x01,0x46,0x00,0xec,0x08,0x06,0x05,0x01,0x60,0x81,0x01,0x46,0x00,0xed,0x08,0x06,0x02,0x01,0x60,0x81,0x01,0x46,0x00,
0xee,0x08,0x06,0x05,0x01,0xbe,0x01,0x00,0xef,0x08,0x06,0x02,0x01,0xbe,0x01,0x00,0xf0,0x08,0x06,0x05,0x01,0x95,0x01,0x00,
0xf1,0x08,0x06,0x02,0x01,0x95,0x01,0x00,0xf2,0x08,0x06,0x05,0x01,0xc3,0x01,0x00,0xf3,0x08,0x06,0x02,0x01,0xc3,0x01,0x00,
0xf4,0x08,0x06,0x05,0x01,0x97,0x01,0x00,0xf5,0x08,0x06,0x02,0x01,0x97,0x01,0x00,0xf6,0x08,0x06,0x05,0x01,0x97,0x01,0x04,0x3d,0x24,0xc1,0x03,0x00,
0xf7,0x08,0x06,0x02,0x01,0x97,0x01,0x04,0x3d,0x24,0xc1,0x03,0x00,0xf8,0x08,0x06,0x05,0x01,0xa1,0x01,0x00,0xf9,0x08,0x06,0x02,0x01,0xa1,0x01,0x00,
0xfa,0x08,0x06,0x05,0x01,0xb4,0x02,0x21,0x00,0xfb,0x08,0x06,0x02,0x01,0xb4,0x02,0x21,0x00,0xfc,0x08,0x06,0x05,0x01,0x21,0x04,0x98,0x02,0x00,
0xfd,0x08,0x06,0x02,0x01,0x21,0x04,0x98,0x02,0x00,0xfe,0x08,0x06,0x05,0x01,0xc5,0x02,0x00,0xff,0x08,0x06,0x02,0x01,0xc5,0x02,0x00,
0x80,0x09,0x06,0x05,0x01,0xbf,0x01,0x00,0x81,0x09,0x06,0x02,0x01,0xbf,0x01,0x00,0x8a,0x09,0x06,0x05,0x01,0x71,0x1b,0x04,0x43,0x00,
0x8b,0x09,0x06,0x02,0x01,0x71,0x1b,0x04,0x43,0x00,0x8c,0x09,0x06,0x05,0x01,0xb1,0x02,0x84,0x01,0x00,0x8d,0x09,0x06,0x02,0x01,0xb1,0x02,0x84,0x01,0x00,
0x8e,0x09,0x06,0x05,0x01,0xc5,0x01,0x04,0x99,0x02,0x00,0x8f,0x09,0x06,0x02,0x01,0xc5,0x01,0x04,0x99,0x02,0x00,0x90,0x09,0x06,0x05,0x01,0x62,0x04,0x86,0x02,0x00,
0x91,0x09,0x06,0x02,0x01,0x62,0x04,0x86,0x02,0x00,0x92,0x09,0x06,0x05,0x01,0x62,0x04,0x0d,0x00,0x93,0x09,0x06,0x02,0x01,0x62,0x04,0x0d,0x00,
0x94,0x09,0x06,0x05,0x01,0x62,0x04,0x3e,0x0b,0x00,0x95,0x09,0x06,0x02,0x01,0x62,0x04,0x3e,0x0b,0x00,0x96,0x09,0x06,0x05,0x01,0x6a,0x04,0x31,0x00,
0x97,0x09,0x06,0x02,0x01,0x6a,0x04,0x31,0x00,0x98,0x09,0x06,0x05,0x01,0x75,0x04,0x31,0x00,0x99,0x09,0x06,0x02,0x01,0x75,0x04,0x31,0x00,
0x9a,0x09,0x06,0x05,0x01,0x59,0x04,0x31,0x00,0x9b,0x09,0x06,0x02,0x01,0x59,0x04,0x31,0x00,0x9c,0x09,0x06,0x05,0x01,0x59,0x04,0xaf,0x01,0x0d,0x00,
0x9d,0x09,0x06,0x02,0x01,0x59,0x04,0xaf,0x01,0x0d,0x00,0x9e,0x09,0x06,0x05,0x01,0x59,0x04,0x0d,0x00,0x9f,0x09,0x06,0x02,0x01,0x59,0x04,0x0d,0x00,
0xa0,0x09,0x06,0x05,0x01,0xb5,0x03,0x59,0x00,0xa1,0x09,0x06,0x02,0x01,0xb5,0x03,0x59,0x00,0xa2,0x09,0x06,0x05,0x01,0x5e,0x04,0x31,0x00,
0xa3,0x09,0x06,0x02,0x01,0x5e,0x04,0x31,0x00,0xa6,0x09,0x06,0x05,0x01,0x79,0x04,0x3e,0x0b,0x00,0xa7,0x09,0x06,0x02,0x01,0x79,0x04,0x3e,0x0b,0x00,
0xa8,0x09,0x06,0x05,0x01,0x82,0x01,0x56,0x00,0xa9,0x09,0x06,0x02,0x01,0x82,0x01,0x56,0x00,0xaa,0x09,0x06,0x05,0x01,0xab,0x01,0x04,0x31,0x00,
0xab,0x09,0x06,0x02,0x01,0xab,0x01,0x04,0x31,0x00,0xac,0x09,0x06,0x05,0x01,0x70,0x04,0x31,0x00,0xad,0x09,0x06,0x02,0x01,0x70,0x04,0x31,0x00,
0xae,0x09,0x06,0x05,0x01,0xb3,0x01,0x0f,0x00,0xaf,0x09,0x06,0x02,0x01,0xb3,0x01,0x0f,0x00,0xb0,0x09,0x06,0x05,0x01,0xb3,0x01,0x0f,0x04,0x0d,0x00,
0xb1,0x09,0x06,0x02,0x01,0xb3,0x01,0x0f,0x04,0x0d,0x00,0xb2,0x09,0x06,0x05,0x01,0x56,0x04,0x31,0x00,0xb3,0x09,0x06,0x02,0x01,0x56,0x04,0x31,0x00,
0xb6,0x09,0x06,0x05,0x01,0x5f,0x04,0x31,0x00,0xb7,0x09,0x06,0x02,0x01,0x5f,0x04,0x31,0x00,0xb8,0x09,0x06,0x05,0x01,0x5f,0x04,0xaf,0x01,0x0d,0x00,
0xb9,0x09,0x06,0x02,0x01,0x5f,0x04,0xaf,0x01,0x0d,0x00,0xba,0x09,0x06,0x05,0x01,0xb4,0x01,0x00,0xbb,0x09,0x06,0x02,0x01,0xb4,0x01,0x00,
0xbc,0x09,0x06,0x05,0x01,0x82,0x01,0x5f,0x00,0xbd,0x09,0x06,0x02,0x01,0x82,0x01,0x5f,0x00,0xbe,0x09,0x06,0x05,0x01,0x82,0x01,0x5f,0x04,0x31,0x00,
0xbf,0x09,0x06,0x02,0x01,0x82,0x01,0x5f,0x04,0x31,0x00,0xc1,0x09,0x06,0x05,0x01,0x6a,0x04,0x2a,0x00,0xc2,0x09,0x06,0x02,0x01,0x6a,0x04,0x2a,0x00,
0xc3,0x09,0x06,0x05,0x01,0x59,0x04,0x0b,0x00,0xc4,0x09,0x06,0x02,0x01,0x59,0x04,0x0b,0x00,0xc5,0x09,0x06,0x05,0x01,0x63,0x04,0x43,0x00,
0xc6,0x09,0x06,0x02,0x01,0x63,0x04,0x43,0x00,0xc7,0x09,0x06,0x05,0x01,0x5e,0x04,0x0b,0x00,0xc8,0x09,0x06,0x02,0x01,0x5e,0x04,0x0b,0x00,
0xc9,0x09,0x06,0x05,0x01,0x5e,0x04,0x43,0x00,0xca,0x09,0x06,0x02,0x01,0x5e,0x04,0x43,0x00,0xcb,0x09,0x06,0x05,0x01,0xe7,0x02,0x5f,0x00,
0xcc,0x09,0x06,0x02,0x01,0xe7,0x02,0x5f,0x00,0xcd,0x09,0x06,0x05,0x01,0x9a,0x01,0x04,0x43,0x00,0xce,0x09,0x06,0x02,0x01,0x9a,0x01,0x04,0x43,0x00,
0xcf,0x09,0x06,0x02,0x01,0xfa,0x03,0x00,0xd0,0x09,0x06,0x05,0x01,0x12,0x04,0x2a,0x00,0xd1,0x09,0x06,0x02,0x01,0x12,0x04,0x2a,0x00,
0xd2,0x09,0x06,0x05,0x01,0x12,0x04,0x1c,0x00,0xd3,0x09,0x06,0x02,0x01,0x12,0x04,0x1c,0x00,0xd6,0x09,0x06,0x05,0x01,0x7c,0x04,0x2a,0x00,
0xd7,0x09,0x06,0x02,0x01,0x7c,0x04,0x2a,0x00,0xd8,0x09,0x06,0x05,0x01,0x6b,0x00,0xd9,0x09,0x06,0x02,0x01,0x6b,0x00,
0xda,0x09,0x06,0x05,0x01,0x6b,0x04,0x1c,0x00,0xdb,0x09,0x06,0x02,0x01,0x6b,0x04,0x1c,0x00,0xdc,0x09,0x06,0x05,0x01,0x6a,0x04,0x1c,0x00,
0xdd,0x09,0x06,0x02,0x01,0x6a,0x04,0x1c,0x00,0xde,0x09,0x06,0x05,0x01,0x75,0x04,0x1c,0x00,0xdf,0x09,0x06,0x02,0x01,0x75,0x04,0x1c,0x00,
0xe0,0x09,0x06,0x05,0x01,0x82,0x01,0x9b,0x01,0x00,0xe1,0x09,0x06,0x02,0x01,0x82,0x01,0x9b,0x01,0x00,0xe2,0x09,0x06,0x05,0x01,0x1b,0x04,0x23,0x00,
0xe3,0x09,0x06,0x02,0x01,0x1b,0x04,0x23,0x00,0xe4,0x09,0x06,0x05,0x01,0x1b,0x04,0x1c,0x00,0xe5,0x09,0x06,0x02,0x01,0x1b,0x04,0x1c,0x00,
0xe6,0x09,0x06,0x05,0x01,0x0a,0x04,0x1c,0x00,0xe7,0x09,0x06,0x02,0x01,0x0a,0x04,0x1c,0x00,0xe8,0x09,0x06,0x05,0x01,0x8a,0x01,0x0a,0x00,
0xe9,0x09,0x06,0x02,0x01,0x8a,0x01,0x0a,0x00,0xea,0x09,0x06,0x05,0x01,0x8a,0x01,0x0a,0x04,0x1c,0x00,0xeb,0x09,0x06,0x02,0x01,0x8a,0x01,0x0a,0x04,0x1c,0x00,
0xec,0x09,0x06,0x05,0x01,0x11,0x04,0x1c,0x00,0xed,0x09,0x06,0x02,0x01,0x11,0x04,0x1c,0x00,0xee,0x09,0x06,0x05,0x01,0x0f,0x04,0x23,0x00,
0xef,0x09,0x06,0x02,0x01,0x0f,0x04,0x23,0x00,0xf0,0x09,0x06,0x05,0x01,0x0f,0x04,0x1c,0x00,0xf1,0x09,0x06,0x02,0x01,0x0f,0x04,0x1c,0x00,
0xf2,0x09,0x06,0x05,0x01,0x0f,0x04,0x3d,0x18,0x00,0xf3,0x09,0x06,0x02,0x01,0x0f,0x04,0x3d,0x18,0x00,0xf4,0x09,0x06,0x05,0x01,0x5f,0x04,0x1c,0x00,
0xf5,0x09,0x06,0x02,0x01,0x5f,0x04,0x1c,0x00,0xf6,0x09,0x06,0x05,0x01,0x62,0x04,0x31,0x00,0xf7,0x09,0x06,0x02,0x01,0x62,0x04,0x31,0x00,
0xf8,0x09,0x06,0x05,0x01,0x76,0x04,0x1c,0x00,0xf9,0x09,0x06,0x02,0x01,0x76,0x04,0x1c,0x00,0xfa,0x09,0x06,0x05,0x01,0x62,0x04,0x0d,0x08,0x0b,0x00,
0xfb,0x09,0x06,0x02,0x01,0x62,0x04,0x0d,0x08,0x0b,0x00,0xfc,0x09,0x06,0x05,0x01,0x56,0x04,0x0b,0x00,0xfd,0x09,0x06,0x02,0x01,0x56,0x04,0x0b,0x00,
0xfe,0x09,0x06,0x05,0x01,0x56,0x04,0x0d,0x00,0xff,0x09,0x06,0x02,0x01,0x56,0x04,0x0d,0x00,0x80,0x0a,0x06,0x05,0x01,0x58,0x7e,0x00,
0x81,0x0a,0x06,0x02,0x01,0x58,0x7e,0x00,0x82,0x0a,0x06,0x05,0x01,0x58,0xca,0x01,0x00,0x83,0x0a,0x06,0x02,0x01,0x58,0xca,0x01,0x00,
0x84,0x0a,0x06,0x05,0x01,0x58,0xea,0x01,0x00,0x85,0x0a,0x06,0x02,0x01,0x58,0xea,0x01,0x00,0x86,0x0a,0x06,0x05,0x01,0x58,0x95,0x03,0x00,
0x87,0x0a,0x06,0x02,0x01,0x58,0x95,0x03,0x00,0x88,0x0a,0x06,0x05,0x01,0x58,0xbd,0x01,0x00,0x89,0x0a,0x06,0x02,0x01,0x58,0xbd,0x01,0x00,
0x8a,0x0a,0x06,0x05,0x01,0x58,0xb8,0x01,0x00,0x8b,0x0a,0x06,0x02,0x01,0x58,0xb8,0x01,0x00,0x8c,0x0a,0x06,0x05,0x01,0x58,0xa6,0x02,0x00,
0x8d,0x0a,0x06,0x02,0x01,0x58,0xa6,0x02,0x00,0x8e,0x0a,0x06,0x05,0x01,0x58,0x96,0x02,0x00,0x8f,0x0a,0x06,0x02,0x01,0x58,0x96,0x02,0x00,
0x90,0x0a,0x06,0x05,0x01,0x4b,0x75,0x00,0x91,0x0a,0x06,0x02,0x01,0x4b,0x75,0x00,0x92,0x0a,0x06,0x05,0x01,0x63,0x04,0x0b,0x00,
0x93,0x0a,0x06,0x02,0x01,0x63,0x04,0x0b,0x00,0x94,0x0a,0x06,0x05,0x01,0xdd,0x02,0x00,0x95,0x0a,0x06,0x02,0x01,0xdd,0x02,0x00,
0x96,0x0a,0x06,0x05,0x01,0xb7,0x02,0x00,0x97,0x0a,0x06,0x02,0x01,0xb7,0x02,0x00,0x98,0x0a,0x06,0x05,0x01,0xf9,0x01,0x00,
0x99,0x0a,0x06,0x02,0x01,0xf9,0x01,0x00,0x9a,0x0a,0x06,0x05,0x01,0xbb,0x02,0x00,0x9b,0x0a,0x06,0x02,0x01,0xbb,0x02,0x00,
0x9c,0x0a,0x06,0x05,0x01,0xa0,0x01,0x00,0x9d,0x0a,0x06,0x02,0x01,0xa0,0x01,0x00,0x9e,0x0a,0x06,0x05,0x01,0xbe,0x03,0x59,0x00,
0x9f,0x0a,0x06,0x02,0x01,0xbe,0x03,0x59,0x00,0xa0,0x0a,0x06,0x05,0x01,0x63,0x04,0x3e,0x0b,0x00,0xa1,0x0a,0x06,0x02,0x01,0x63,0x04,0x3e,0x0b,0x00,
0xa2,0x0a,0x06,0x05,0x01,0x5e,0x04,0x3e,0x0b,0x00,0xa3,0x0a,0x06,0x02,0x01,0x5e,0x04,0x3e,0x0b,0x00,0xa4,0x0a,0x06,0x05,0x01,0x79,0x04,0x31,0x00,
0xa5,0x0a,0x06,0x02,0x01,0x79,0x04,0x31,0x00,0xa6,0x0a,0x06,0x05,0x01,0xb4,0x01,0x04,0x31,0x00,0xa7,0x0a,0x06,0x02,0x01,0xb4,0x01,0x04,0x31,0x00,
0xa8,0x0a,0x06,0x05,0x01,0x5e,0x04,0x73,0x0b,0x00,0xa9,0x0a,0x06,0x02,0x01,0x5e,0x04,0x73,0x0b,0x00,0xaa,0x0a,0x06,0x05,0x01,0x92,0x03,0x00,
0xab,0x0a,0x06,0x02,0x01,0x92,0x03,0x00,0xac,0x0a,0x06,0x05,0x01,0x9e,0x03,0x00,0xad,0x0a,0x06,0x02,0x01,0x9e,0x03,0x00,
0xae,0x0a,0x06,0x05,0x01,0x63,0x04,0x31,0x00,0xaf,0x0a,0x06,0x02,0x01,0x63,0x04,0x31,0x00,0xb1,0x0a,0x17,0x05,0x01,0xb9,0x03,0x00,
0xb2,0x0a,0x17,0x05,0x01,0xb3,0x03,0x00,0xb3,0x0a,0x17,0x05,0x01,0x86,0x03,0x00,0xb4,0x0a,0x17,0x05,0x01,0xe5,0x01,0x00,
0xb5,0x0a,0x17,0x05,0x01,0x91,0x03,0x00,0xb6,0x0a,0x17,0x05,0x01,0xf3,0x01,0x00,0xb7,0x0a,0x17,0x05,0x01,0x8f,0x03,0x00,
0xb8,0x0a,0x17,0x05,0x01,0xc4,0x01,0x00,0xb9,0x0a,0x17,0x05,0x01,0x95,0x02,0x00,0xba,0x0a,0x17,0x05,0x01,0x6a,0x00,
0xbb,0x0a,0x17,0x05,0x01,0xf5,0x02,0x00,0xbc,0x0a,0x17,0x05,0x01,0xdb,0x02,0x00,0xbd,0x0a,0x17,0x05,0x01,0xfb,0x01,0x00,
0xbe,0x0a,0x17,0x05,0x01,0xab,0x03,0x00,0xbf,0x0a,0x17,0x05,0x01,0xe8,0x02,0x00,0xc0,0x0a,0x17,0x05,0x01,0xdd,0x01,0x00,
0xc1,0x0a,0x17,0x05,0x01,0xf1,0x02,0x00,0xc2,0x0a,0x17,0x05,0x01,0x88,0x03,0x00,0xc3,0x0a,0x17,0x05,0x01,0xa5,0x03,0x00,
0xc4,0x0a,0x17,0x05,0x01,0xd5,0x02,0x00,0xc5,0x0a,0x17,0x05,0x01,0x9f,0x01,0x00,0xc6,0x0a,0x17,0x05,0x01,0xcd,0x02,0x00,
0xc7,0x0a,0x17,0x05,0x01,0x93,0x01,0x00,0xc8,0x0a,0x17,0x05,0x01,0xff,0x01,0x00,0xc9,0x0a,0x17,0x05,0x01,0xa7,0x03,0x00,
0xca,0x0a,0x17,0x05,0x01,0xbf,0x02,0x00,0xcb,0x0a,0x17,0x05,0x01,0xee,0x02,0x00,0xcc,0x0a,0x17,0x05,0x01,0xd8,0x01,0x00,
0xcd,0x0a,0x17,0x05,0x01,0xb2,0x02,0x00,0xce,0x0a,0x17,0x05,0x01,0x83,0x02,0x00,0xcf,0x0a,0x17,0x05,0x01,0x97,0x02,0x00,
0xd0,0x0a,0x17,0x05,0x01,0xb8,0x02,0x00,0xd1,0x0a,0x17,0x05,0x01,0xa1,0x03,0x00,0xd2,0x0a,0x17,0x05,0x01,0xf5,0x01,0x00,
0xd3,0x0a,0x17,0x05,0x01,0xbd,0x02,0x00,0xd4,0x0a,0x17,0x05,0x01,0xe9,0x02,0x00,0xd5,0x0a,0x17,0x05,0x01,0xcb,0x02,0x00,
0xd6,0x0a,0x17,0x05,0x01,0x8e,0x03,0x00,0xe1,0x0a,0x17,0x02,0x01,0xb9,0x03,0x00,0xe2,0x0a,0x17,0x02,0x01,0xb3,0x03,0x00,
0xe3,0x0a,0x17,0x02,0x01,0x86,0x03,0x00,0xe4,0x0a,0x17,0x02,0x01,0xe5,0x01,0x00,0xe5,0x0a,0x17,0x02,0x01,0x91,0x03,0x00,
0xe6,0x0a,0x17,0x02,0x01,0xf3,0x01,0x00,0xe7,0x0a,0x17,0x02,0x01,0x8f,0x03,0x00,0xe8,0x0a,0x17,0x02,0x01,0xc4,0x01,0x00,
0xe9,0x0a,0x17,0x02,0x01,0x95,0x02,0x00,0xea,0x0a,0x17,0x02,0x01,0x6a,0x00,0xeb,0x0a,0x17,0x02,0x01,0xf5,0x02,0x00,
0xec,0x0a,0x17,0x02,0x01,0xdb,0x02,0x00,0xed,0x0a,0x17,0x02,0x01,0xfb,0x01,0x00,0xee,0x0a,0x17,0x02,0x01,0xab,0x03,0x00,
0xef,0x0a,0x17,0x02,0x01,0xe8,0x02,0x00,0xf0,0x0a,0x17,0x02,0x01,0xdd,0x01,0x00,0xf1,0x0a,0x17,0x02,0x01,0xf1,0x02,0x00,
0xf2,0x0a,0x17,0x02,0x01,0x88,0x03,0x00,0xf3,0x0a,0x17,0x02,0x01,0xa5,0x03,0x00,0xf4,0x0a,0x17,0x02,0x01,0xd5,0x02,0x00,
0xf5,0x0a,0x17,0x02,0x01,0x9f,0x01,0x00,0xf6,0x0a,0x17,0x02,0x01,0xcd,0x02,0x00,0xf7,0x0a,0x17,0x02,0x01,0x93,0x01,0x00,
0xf8,0x0a,0x17,0x02,0x01,0xff,0x01,0x00,0xf9,0x0a,0x17,0x02,0x01,0xa7,0x03,0x00,0xfa,0x0a,0x17,0x02,0x01,0xbf,0x02,0x00,
0xfb,0x0a,0x17,0x02,0x01,0xee,0x02,0x00,0xfc,0x0a,0x17,0x02,0x01,0xd8,0x01,0x00,0xfd,0x0a,0x17,0x02,0x01,0xb2,0x02,0x00,
0xfe,0x0a,0x17,0x02,0x01,0x83,0x02,0x00,0xff,0x0a,0x17,0x02,0x01,0x97,0x02,0x00,0x80,0x0b,0x17,0x02,0x01,0xb8,0x02,0x00,
0x81,0x0b,0x17,0x02,0x01,0xa1,0x03,0x00,0x82,0x0b,0x17,0x02,0x01,0xf5,0x01,0x00,0x83,0x0b,0x17,0x02,0x01,0xbd,0x02,0x00,
0x84,0x0b,0x17,0x02,0x01,0xe9,0x02,0x00,0x85,0x0b,0x17,0x02,0x01,0xcb,0x02,0x00,0x86,0x0b,0x17,0x02,0x01,0x8e,0x03,0x00,
0xa0,0x21,0x15,0x05,0x01,0xbc,0x03,0x00,0xa1,0x21,0x15,0x05,0x01,0xb6,0x03,0x00,0xa2,0x21,0x15,0x05,0x01,0x89,0x03,0x00,
0xa3,0x21,0x15,0x05,0x01,0x98,0x03,0x00,0xa4,0x21,0x15,0x05,0x01,0x5e,0x00,0xa5,0x21,0x15,0x05,0x01,0x81,0x02,0x00,
0xa6,0x21,0x15,0x05,0x01,0xef,0x01,0x00,0xa7,0x21,0x15,0x05,0x01,0x9e,0x02,0x00,0xa8,0x21,0x15,0x05,0x01,0xf6,0x02,0x00,
0xa9,0x21,0x15,0x05,0x01,0xeb,0x02,0x00,0xaa,0x21,0x15,0x05,0x01,0xe0,0x02,0x00,0xab,0x21,0x15,0x05,0x01,0xd6,0x02,0x00,
0xac,0x21,0x15,0x05,0x01,0xd2,0x02,0x00,0xad,0x21,0x15,0x05,0x01,0xc9,0x02,0x00,0xae,0x21,0x15,0x05,0x01,0xc0,0x02,0x00,
0xaf,0x21,0x15,0x05,0x01,0xed,0x01,0x00,0xb0,0x21,0x15,0x05,0x01,0xb9,0x02,0x00,0xb1,0x21,0x15,0x05,0x01,0xb5,0x01,0x00,
0xb2,0x21,0x15,0x05,0x01,0x9d,0x02,0x00,0xb3,0x21,0x15,0x05,0x01,0x87,0x02,0x00,0xb4,0x21,0x15,0x05,0x01,0xbe,0x02,0x00,
0xb5,0x21,0x15,0x05,0x01,0xe6,0x02,0x00,0xb6,0x21,0x15,0x05,0x01,0x87,0x03,0x00,0xb7,0x21,0x15,0x05,0x01,0xba,0x02,0x00,
0xb8,0x21,0x15,0x05,0x01,0xad,0x02,0x00,0xb9,0x21,0x15,0x05,0x01,0xa4,0x03,0x00,0xba,0x21,0x15,0x05,0x01,0xaa,0x03,0x00,
0xbb,0x21,0x15,0x05,0x01,0xed,0x02,0x00,0xbc,0x21,0x15,0x05,0x01,0xa2,0x03,0x00,0xbd,0x21,0x15,0x05,0x01,0xa6,0x03,0x00,
0xbe,0x21,0x15,0x05,0x01,0xfc,0x01,0x00,0xbf,0x21,0x15,0x05,0x01,0xef,0x02,0x00,0xc0,0x21,0x15,0x05,0x01,0x82,0x03,0x00,
0xc1,0x21,0x15,0x05,0x01,0xe0,0x01,0x00,0xc2,0x21,0x15,0x05,0x01,0xfb,0x02,0x00,0xc3,0x21,0x15,0x05,0x01,0xa0,0x01,0x00,
0xc4,0x21,0x15,0x05,0x01,0x81,0x03,0x00,0xc5,0x21,0x15,0x05,0x01,0xfa,0x02,0x00,0xc7,0x21,0x15,0x05,0x01,0xad,0x01,0x00,
0xcd,0x21,0x15,0x05,0x01,0xc0,0x03,0x00,0xf8,0x27,0x13,0x02,0x01,0xc5,0x03,0x00,0xf9,0x27,0x13,0x02,0x01,0x9f,0x01,0x00,
0xfa,0x27,0x13,0x02,0x01,0xd0,0x01,0x00,0xfb,0x27,0x13,0x02,0x01,0x83,0x01,0x00,0xfc,0x27,0x13,0x02,0x01,0xc3,0x03,0x00,
0xfd,0x27,0x13,0x02,0x01,0x84,0x04,0x00,0xb0,0x32,0x72,0x02,0x01,0x59,0x00,0xb1,0x32,0x72,0x02,0x01,0x80,0x04,0x00,
0xb2,0x32,0x72,0x02,0x01,0xb2,0x04,0x00,0xb3,0x32,0x72,0x02,0x01,0x9f,0x02,0x00,0xb4,0x32,0x72,0x02,0x01,0xd3,0x02,0x00,
0xb5,0x32,0x72,0x02,0x01,0xfb,0x03,0x00,0xb6,0x32,0x72,0x02,0x01,0xd7,0x02,0x00,0xb7,0x32,0x72,0x02,0x01,0xd8,0x01,0x00,
0xb8,0x32,0x72,0x02,0x01,0xe2,0x02,0x00,0x80,0x39,0x06,0x02,0x01,0xef,0x03,0xd2,0x01,0x00,0x81,0x39,0x06,0x02,0x01,0x8d,0x04,0x7e,0x00,
0x82,0x39,0x06,0x02,0x01,0x82,0x04,0x0a,0x00,0x83,0x39,0x06,0x02,0x01,0xcb,0x03,0xab,0x01,0x00,0x84,0x39,0x06,0x02,0x01,0xd5,0x01,0x70,0x00,
0x85,0x39,0x06,0x02,0x01,0xdf,0x03,0x70,0x00,0x86,0x39,0x06,0x02,0x01,0xd5,0x01,0xe1,0x01,0x84,0x01,0x00,0x87,0x39,0x06,0x02,0x01,0xd5,0x01,0x8b,0x01,0x00,
0x88,0x39,0x06,0x02,0x01,0xcf,0x03,0xa1,0x01,0x00,0x82,0x3a,0x03,0x02,0x01,0x2e,0x6f,0x00,0x88,0x3a,0x03,0x02,0x01,0x2e,0x54,0x11,0x00,
0x89,0x3a,0x03,0x02,0x01,0x2e,0x1b,0x00,0x91,0x3a,0x03,0x02,0x01,0x91,0x01,0x0a,0x00,0x92,0x3a,0x03,0x02,0x01,0x91,0x01,0x54,0x0a,0x00,
0x93,0x3a,0x03,0x02,0x01,0x91,0x01,0x0a,0x04,0x0d,0x00,0x94,0x3a,0x03,0x02,0x01,0x2e,0x85,0x01,0x00,0x96,0x3a,0x03,0x02,0x01,0xd7,0x03,0xa8,0x01,0x0a,0x00,
0x97,0x3a,0x03,0x02,0x01,0xaf,0x04,0xa8,0x01,0x0a,0x00,0x9d,0x3a,0x03,0x02,0x01,0x91,0x01,0x0f,0x00,0x9e,0x3a,0x03,0x02,0x01,0x91,0x01,0xaa,0x04,0x0f,0x00,
0x9f,0x3a,0x03,0x02,0x01,0x91,0x01,0x2e,0x48,0x00,0xe2,0x3a,0x03,0x4a,0x02,0x01,0x1b,0x00,0xe3,0x3a,0x03,0x4a,0x02,0x01,0x22,0x00,
0xe4,0x3a,0x03,0x4a,0x02,0x01,0x0f,0x00,0xe5,0x3a,0x03,0x4a,0x02,0x01,0x42,0x00,0xe6,0x3a,0x07,0x4a,0x02,0x01,0x9e,0x01,0x00,
0xe7,0x3a,0x07,0x4a,0x02,0x01,0x87,0x01,0x00,0xe8,0x3a,0x07,0x4a,0x02,0x01,0x94,0x01,0x00,0xe9,0x3a,0x07,0x4a,0x02,0x01,0xa6,0x01,0x00,
0xea,0x3a,0x07,0x4a,0x02,0x01,0x89,0x01,0x00,0xeb,0x3a,0x03,0x02,0x01,0xd3,0x01,0x00,0xec,0x3a,0x03,0x02,0x01,0x49,0x04,0x3e,0x1e,0x00,
0xed,0x3a,0x03,0x02,0x01,0x35,0x04,0x3e,0x1e,0x00,0xee,0x3a,0x03,0x02,0x01,0x4f,0x04,0x3e,0x1e,0x00,0xef,0x3a,0x03,0x02,0x01,0x48,0x04,0x3e,0x1e,0x00,
0xf0,0x3a,0x03,0x02,0x01,0x2b,0x04,0x3e,0x1e,0x00,0xf1,0x3a,0x03,0x02,0x01,0x44,0x04,0x3e,0x1e,0x00,0xf2,0x3a,0x03,0x02,0x01,0x22,0x04,0x3e,0x1e,0x00,
0xf3,0x3a,0x03,0x02,0x01,0x22,0x04,0xaa,0x01,0x08,0x3e,0x1e,0x00,0xf4,0x3a,0x03,0x02,0x01,0x28,0x04,0x3e,0x1e,0x00,0xf5,0x3a,0x03,0x02,0x01,0x32,0x04,0x3e,0x1e,0x00,
0xf6,0x3a,0x03,0x02,0x01,0x36,0x04,0x3e,0x1e,0x00,0xf7,0x3a,0x03,0x02,0x01,0x2e,0x34,0x00,0xf9,0x3a,0x03,0x02,0x01,0x5c,0x34,0x00,
0xfa,0x3a,0x03,0x02,0x01,0xe0,0x03,0x04,0xe6,0x03,0x00,0xfb,0x3a,0x03,0x02,0x05,0x01,0x1b,0x04,0x0d,0x00,0xfc,0x3a,0x03,0x02,0x01,0x30,0x04,0x0d,0x00,
0xfd,0x3a,0x03,0x02,0x01,0x44,0x04,0x0d,0x00,0xfe,0x3a,0x03,0x02,0x05,0x01,0x0f,0x04,0x0d,0x00,0xff,0x3a,0x03,0x02,0x01,0x39,0x04,0x0d,0x00,
0x80,0x3b,0x03,0x02,0x01,0x49,0x04,0x51,0x0b,0x00,0x81,0x3b,0x03,0x02,0x01,0x35,0x04,0x51,0x0b,0x00,0x82,0x3b,0x03,0x02,0x01,0x4f,0x04,0x51,0x0b,0x00,
0x83,0x3b,0x03,0x02,0x01,0x34,0x04,0x51,0x0b,0x00,0x84,0x3b,0x03,0x02,0x01,0x3a,0x04,0x51,0x0b,0x00,0x85,0x3b,0x03,0x02,0x01,0x27,0x04,0x51,0x0b,0x00,
0x86,0x3b,0x03,0x02,0x01,0x48,0x04,0x51,0x0b,0x00,0x87,0x3b,0x03,0x02,0x01,0x2b,0x04,0x51,0x0b,0x00,0x88,0x3b,0x03,0x02,0x01,0x44,0x04,0x51,0x0b,0x00,
0x89,0x3b,0x03,0x02,0x01,0x22,0x04,0x51,0x0b,0x00,0x8a,0x3b,0x03,0x02,0x01,0x28,0x04,0x51,0x0b,0x00,0x8b,0x3b,0x03,0x02,0x01,0x6e,0x04,0x51,0x0b,0x00,
0x8c,0x3b,0x03,0x02,0x01,0x42,0x04,0x51,0x0b,0x00,0x8d,0x3b,0x03,0x02,0x01,0x50,0x04,0x51,0x0b,0x00,0x8e,0x3b,0x03,0x02,0x01,0x36,0x04,0x51,0x0b,0x00,
0x8f,0x3b,0x03,0x02,0x01,0x12,0x04,0x53,0x0b,0x00,0x90,0x3b,0x03,0x02,0x01,0x20,0x04,0x53,0x0b,0x00,0x91,0x3b,0x03,0x02,0x01,0x35,0x04,0x0b,0x08,0x43,0x00,
0x92,0x3b,0x03,0x02,0x01,0x11,0x04,0x53,0x0b,0x00,0x93,0x3b,0x03,0x02,0x01,0x54,0x11,0x04,0x53,0x0b,0x00,0x94,0x3b,0x03,0x02,0x01,0x4b,0x54,0x11,0x04,0x53,0x0b,0x00,
0x95,0x3b,0x03,0x02,0x01,0x6b,0x04,0x53,0x0b,0x00,0x96,0x3b,0x03,0x02,0x01,0x1b,0x04,0x53,0x0b,0x00,0x97,0x3b,0x03,0x02,0x01,0x54,0x0a,0x04,0x53,0x0b,0x00,
0x98,0x3b,0x03,0x02,0x01,0x6e,0x04,0x53,0x0b,0x00,0x99,0x3b,0x03,0x02,0x01,0x0f,0x04,0x53,0x0b,0x00,0x9a,0x3b,0x03,0x02,0x01,0x74,0x04,0x53,0x0b,0x00,
0xca,0x3b,0x2c,0x03,0x02,0x01,0x22,0x0e,0x00,0xd3,0x3b,0x2c,0x03,0x02,0x01,0xa2,0x04,0x54,0x12,0x14,0x00,0xd4,0x3b,0x2c,0x03,0x02,0x01,0x6f,0x00,
0xd5,0x3b,0x2c,0x03,0x02,0x01,0xe9,0x01,0x00,0xd6,0x3b,0x2c,0x03,0x02,0x01,0xac,0x01,0x00,0xd7,0x3b,0x2c,0x03,0x02,0x01,0x3b,0x40,0x00,
0xd8,0x3b,0x2c,0x03,0x02,0x01,0x5c,0x35,0x00,0xd9,0x3b,0x2c,0x03,0x02,0x01,0xe2,0x01,0x00,0xda,0x3b,0x2c,0x03,0x02,0x01,0x34,0x00,
0xdc,0x3b,0x2c,0x03,0x02,0x01,0x3a,0x00,0xdd,0x3b,0x2c,0x03,0x02,0x01,0x27,0x00,0xe0,0x3b,0x2c,0x03,0x02,0x01,0x2b,0x00,
0xe3,0x3b,0x2c,0x03,0x02,0x01,0x22,0xa5,0x01,0x00,0xe4,0x3b,0x2c,0x03,0x02,0x01,0x28,0x00,0xe5,0x3b,0x2c,0x03,0x02,0x01,0x5a,0x28,0x00,
0xe6,0x3b,0x2c,0x03,0x02,0x01,0x36,0x00,0xe7,0x3b,0x2c,0x03,0x02,0x01,0x20,0x00,0xe8,0x3b,0x2c,0x03,0x02,0x01,0x49,0x00,
0xe9,0x3b,0x2c,0x03,0x02,0x01,0x9e,0x01,0x00,0xea,0x3b,0x2c,0x03,0x02,0x01,0x6b,0x00,0xeb,0x3b,0x2c,0x03,0x02,0x01,0x4f,0x00,
0xec,0x3b,0x2c,0x03,0x02,0x01,0x27,0x04,0x3d,0x3e,0x1e,0x00,0xed,0x3b,0x2c,0x03,0x02,0x01,0x0a,0x04,0xdc,0x02,0xa8,0x03,0x0d,0x00,0xee,0x3b,0x2c,0x03,0x02,0x01,0x44,0x00,
0xef,0x3b,0x2c,0x03,0x02,0x01,0x6e,0x00,0xf0,0x3b,0x2c,0x03,0x02,0x01,0x0f,0x04,0xdc,0x02,0xa8,0x03,0x0d,0x00,0xf1,0x3b,0x2c,0x03,0x02,0x01,0x47,0x00,
0xf2,0x3b,0x2c,0x03,0x02,0x01,0x12,0x04,0x1c,0x00,0xf3,0x3b,0x2c,0x03,0x02,0x01,0x0a,0x04,0x1c,0x00,0xf4,0x3b,0x2c,0x03,0x02,0x01,0x0f,0x04,0x1c,0x00,
0x80,0x3c,0x03,0x05,0x01,0x12,0x04,0x52,0x0e,0x00,0x81,0x3c,0x03,0x02,0x01,0x12,0x04,0x52,0x0e,0x00,0x82,0x3c,0x03,0x05,0x01,0x49,0x04,0x0c,0x14,0x00,
0x83,0x3c,0x03,0x02,0x01,0x49,0x04,0x0c,0x14,0x00,0x84,0x3c,0x03,0x05,0x01,0x49,0x04,0x0c,0x0e,0x00,0x85,0x3c,0x03,0x02,0x01,0x49,0x04,0x0c,0x0e,0x00,
0x86,0x3c,0x03,0x05,0x01,0x49,0x04,0x55,0x0e,0x00,0x87,0x3c,0x03,0x02,0x01,0x49,0x04,0x55,0x0e,0x00,0x88,0x3c,0x03,0x05,0x01,0x3b,0x04,0x40,0x08,0x18,0x00,
0x89,0x3c,0x03,0x02,0x01,0x3b,0x04,0x40,0x08,0x18,0x00,0x8a,0x3c,0x03,0x05,0x01,0x35,0x04,0x0c,0x14,0x00,0x8b,0x3c,0x03,0x02,0x01,0x35,0x04,0x0c,0x14,0x00,
0x8c,0x3c,0x03,0x05,0x01,0x35,0x04,0x0c,0x0e,0x00,0x8d,0x3c,0x03,0x02,0x01,0x35,0x04,0x0c,0x0e,0x00,0x8e,0x3c,0x03,0x05,0x01,0x35,0x04,0x55,0x0e,0x00,
0x8f,0x3c,0x03,0x02,0x01,0x35,0x04,0x55,0x0e,0x00,0x90,0x3c,0x03,0x05,0x01,0x35,0x04,0x40,0x00,0x91,0x3c,0x03,0x02,0x01,0x35,0x04,0x40,0x00,
0x92,0x3c,0x03,0x05,0x01,0x35,0x04,0x1a,0x0e,0x00,0x93,0x3c,0x03,0x02,0x01,0x35,0x04,0x1a,0x0e,0x00,0x94,0x3c,0x03,0x05,0x01,0x11,0x04,0x23,0x08,0x24,0x00,
0x95,0x3c,0x03,0x02,0x01,0x11,0x04,0x23,0x08,0x24,0x00,0x96,0x3c,0x03,0x05,0x01,0x11,0x04,0x23,0x08,0x18,0x00,0x97,0x3c,0x03,0x02,0x01,0x11,0x04,0x23,0x08,0x18,0x00,
0x98,0x3c,0x03,0x05,0x01,0x11,0x04,0x1a,0x0e,0x00,0x99,0x3c,0x03,0x02,0x01,0x11,0x04,0x1a,0x0e,0x00,0x9a,0x3c,0x03,0x05,0x01,0x11,0x04,0x1e,0x0e,0x00,
0x9b,0x3c,0x03,0x02,0x01,0x11,0x04,0x1e,0x0e,0x00,0x9c,0x3c,0x03,0x05,0x01,0x11,0x04,0x40,0x08,0x2a,0x00,0x9d,0x3c,0x03,0x02,0x01,0x11,0x04,0x40,0x08,0x2a,0x00,
0x9e,0x3c,0x03,0x05,0x01,0x4f,0x04,0x0c,0x14,0x00,0x9f,0x3c,0x03,0x02,0x01,0x4f,0x04,0x0c,0x14,0x00,0xa0,0x3c,0x03,0x05,0x01,0x34,0x04,0x23,0x00,
0xa1,0x3c,0x03,0x02,0x01,0x34,0x04,0x23,0x00,0xa2,0x3c,0x03,0x05,0x01,0x33,0x04,0x0c,0x14,0x00,0xa3,0x3c,0x03,0x02,0x01,0x33,0x04,0x0c,0x14,0x00,
0xa4,0x3c,0x03,0x05,0x01,0x33,0x04,0x0c,0x0e,0x00,0xa5,0x3c,0x03,0x02,0x01,0x33,0x04,0x0c,0x0e,0x00,0xa6,0x3c,0x03,0x05,0x01,0x33,0x04,0x1c,0x00,
0xa7,0x3c,0x03,0x02,0x01,0x33,0x04,0x1c,0x00,0xa8,0x3c,0x03,0x05,0x01,0x33,0x04,0x40,0x00,0xa9,0x3c,0x03,0x02,0x01,0x33,0x04,0x40,0x00,
0xaa,0x3c,0x03,0x05,0x01,0x33,0x04,0x2a,0x0e,0x00,0xab,0x3c,0x03,0x02,0x01,0x33,0x04,0x2a,0x0e,0x00,0xac,0x3c,0x03,0x05,0x01,0x1b,0x04,0x1e,0x0e,0x00,
0xad,0x3c,0x03,0x02,0x01,0x1b,0x04,0x1e,0x0e,0x00,0xae,0x3c,0x03,0x05,0x01,0x1b,0x04,0x1c,0x08,0x18,0x00,0xaf,0x3c,0x03,0x02,0x01,0x1b,0x04,0x1c,0x08,0x18,0x00,
0xb0,0x3c,0x03,0x05,0x01,0x3a,0x04,0x18,0x00,0xb1,0x3c,0x03,0x02,0x01,0x3a,0x04,0x18,0x00,0xb2,0x3c,0x03,0x05,0x01,0x3a,0x04,0x0c,0x0e,0x00,
0xb3,0x3c,0x03,0x02,0x01,0x3a,0x04,0x0c,0x0e,0x00,0xb4,0x3c,0x03,0x05,0x01,0x3a,0x04,0x55,0x0e,0x00,0xb5,0x3c,0x03,0x02,0x01,0x3a,0x04,0x55,0x0e,0x00,
0xb6,0x3c,0x03,0x05,0x01,0x27,0x04,0x0c,0x0e,0x00,0xb7,0x3c,0x03,0x02,0x01,0x27,0x04,0x0c,0x0e,0x00,0xb8,0x3c,0x03,0x05,0x01,0x27,0x04,0x0c,0x0e,0x08,0x23,0x00,
0xb9,0x3c,0x03,0x02,0x01,0x27,0x04,0x0c,0x0e,0x08,0x23,0x00,0xba,0x3c,0x03,0x05,0x01,0x27,0x04,0x55,0x0e,0x00,0xbb,0x3c,0x03,0x02,0x01,0x27,0x04,0x55,0x0e,0x00,
0xbc,0x3c,0x03,0x05,0x01,0x27,0x04,0x1a,0x0e,0x00,0xbd,0x3c,0x03,0x02,0x01,0x27,0x04,0x1a,0x0e,0x00,0xbe,0x3c,0x03,0x05,0x01,0x48,0x04,0x18,0x00,
0xbf,0x3c,0x03,0x02,0x01,0x48,0x04,0x18,0x00,0xc0,0x3c,0x03,0x05,0x01,0x48,0x04,0x0c,0x14,0x00,0xc1,0x3c,0x03,0x02,0x01,0x48,0x04,0x0c,0x14,0x00,
0xc2,0x3c,0x03,0x05,0x01,0x48,0x04,0x0c,0x0e,0x00,0xc3,0x3c,0x03,0x02,0x01,0x48,0x04,0x0c,0x0e,0x00,0xc4,0x3c,0x03,0x05,0x01,0x2b,0x04,0x0c,0x14,0x00,
0xc5,0x3c,0x03,0x02,0x01,0x2b,0x04,0x0c,0x14,0x00,0xc6,0x3c,0x03,0x05,0x01,0x2b,0x04,0x0c,0x0e,0x00,0xc7,0x3c,0x03,0x02,0x01,0x2b,0x04,0x0c,0x0e,0x00,
0xc8,0x3c,0x03,0x05,0x01,0x2b,0x04,0x55,0x0e,0x00,0xc9,0x3c,0x03,0x02,0x01,0x2b,0x04,0x55,0x0e,0x00,0xca,0x3c,0x03,0x05,0x01,0x2b,0x04,0x1a,0x0e,0x00,
0xcb,0x3c,0x03,0x02,0x01,0x2b,0x04,0x1a,0x0e,0x00,0xcc,0x3c,0x03,0x05,0x01,0x0a,0x04,0x1e,0x08,0x18,0x00,0xcd,0x3c,0x03,0x02,0x01,0x0a,0x04,0x1e,0x08,0x18,0x00,
0xce,0x3c,0x03,0x05,0x01,0x0a,0x04,0x1e,0x08,0x1c,0x00,0xcf,0x3c,0x03,0x02,0x01,0x0a,0x04,0x1e,0x08,0x1c,0x00,0xd0,0x3c,0x03,0x05,0x01,0x0a,0x04,0x23,0x08,0x24,0x00,
0xd1,0x3c,0x03,0x02,0x01,0x0a,0x04,0x23,0x08,0x24,0x00,0xd2,0x3c,0x03,0x05,0x01,0x0a,0x04,0x23,0x08,0x18,0x00,0xd3,0x3c,0x03,0x02,0x01,0x0a,0x04,0x23,0x08,0x18,0x00,
0xd4,0x3c,0x03,0x05,0x01,0x44,0x04,0x18,0x00,0xd5,0x3c,0x03,0x02,0x01,0x44,0x04,0x18,0x00,0xd6,0x3c,0x03,0x05,0x01,0x44,0x04,0x0c,0x14,0x00,
0xd7,0x3c,0x03,0x02,0x01,0x44,0x04,0x0c,0x14,0x00,0xd8,0x3c,0x03,0x05,0x01,0x22,0x04,0x0c,0x14,0x00,0xd9,0x3c,0x03,0x02,0x01,0x22,0x04,0x0c,0x14,0x00,
0xda,0x3c,0x03,0x05,0x01,0x22,0x04,0x0c,0x0e,0x00,0xdb,0x3c,0x03,0x02,0x01,0x22,0x04,0x0c,0x0e,0x00,0xdc,0x3c,0x03,0x05,0x01,0x22,0x04,0x0c,0x0e,0x08,0x23,0x00,
0xdd,0x3c,0x03,0x02,0x01,0x22,0x04,0x0c,0x0e,0x08,0x23,0x00,0xde,0x3c,0x03,0x05,0x01,0x22,0x04,0x55,0x0e,0x00,0xdf,0x3c,0x03,0x02,0x01,0x22,0x04,0x55,0x0e,0x00,
0xe0,0x3c,0x03,0x05,0x01,0x28,0x04,0x0c,0x14,0x00,0xe1,0x3c,0x03,0x02,0x01,0x28,0x04,0x0c,0x14,0x00,0xe2,0x3c,0x03,0x05,0x01,0x28,0x04,0x0c,0x0e,0x00,
0xe3,0x3c,0x03,0x02,0x01,0x28,0x04,0x0c,0x0e,0x00,0xe4,0x3c,0x03,0x05,0x01,0x28,0x04,0x18,0x08,0x0c,0x14,0x00,0xe5,0x3c,0x03,0x02,0x01,0x28,0x04,0x18,0x08,0x0c,0x14,0x00,
0xe6,0x3c,0x03,0x05,0x01,0x28,0x04,0x2d,0x08,0x0c,0x14,0x00,0xe7,0x3c,0x03,0x02,0x01,0x28,0x04,0x2d,0x08,0x0c,0x14,0x00,0xe8,0x3c,0x03,0x05,0x01,0x28,0x04,0x0c,0x0e,0x08,0x0c,0x14,0x00,
0xe9,0x3c,0x03,0x02,0x01,0x28,0x04,0x0c,0x0e,0x08,0x0c,0x14,0x00,0xea,0x3c,0x03,0x05,0x01,0x32,0x04,0x0c,0x14,0x00,0xeb,0x3c,0x03,0x02,0x01,0x32,0x04,0x0c,0x14,0x00,
0xec,0x3c,0x03,0x05,0x01,0x32,0x04,0x0c,0x0e,0x00,0xed,0x3c,0x03,0x02,0x01,0x32,0x04,0x0c,0x0e,0x00,0xee,0x3c,0x03,0x05,0x01,0x32,0x04,0x55,0x0e,0x00,
0xef,0x3c,0x03,0x02,0x01,0x32,0x04,0x55,0x0e,0x00,0xf0,0x3c,0x03,0x05,0x01,0x32,0x04,0x1a,0x0e,0x00,0xf1,0x3c,0x03,0x02,0x01,0x32,0x04,0x1a,0x0e,0x00,
0xf2,0x3c,0x03,0x05,0x01,0x0f,0x04,0x1c,0x0e,0x00,0xf3,0x3c,0x03,0x02,0x01,0x0f,0x04,0x1c,0x0e,0x00,0xf4,0x3c,0x03,0x05,0x01,0x0f,0x04,0x1e,0x0e,0x00,
0xf5,0x3c,0x03,0x02,0x01,0x0f,0x04,0x1e,0x0e,0x00,0xf6,0x3c,0x03,0x05,0x01,0x0f,0x04,0x1a,0x0e,0x00,0xf7,0x3c,0x03,0x02,0x01,0x0f,0x04,0x1a,0x0e,0x00,
0xf8,0x3c,0x03,0x05,0x01,0x0f,0x04,0x1e,0x08,0x18,0x00,0xf9,0x3c,0x03,0x02,0x01,0x0f,0x04,0x1e,0x08,0x18,0x00,0xfa,0x3c,0x03,0x05,0x01,0x0f,0x04,0x23,0x08,0x1c,0x00,
0xfb,0x3c,0x03,0x02,0x01,0x0f,0x04,0x23,0x08,0x1c,0x00,0xfc,0x3c,0x03,0x05,0x01,0x42,0x04,0x1e,0x00,0xfd,0x3c,0x03,0x02,0x01,0x42,0x04,0x1e,0x00,
0xfe,0x3c,0x03,0x05,0x01,0x42,0x04,0x0c,0x0e,0x00,0xff,0x3c,0x03,0x02,0x01,0x42,0x04,0x0c,0x0e,0x00,0x80,0x3d,0x03,0x05,0x01,0x47,0x04,0x24,0x00,
0x81,0x3d,0x03,0x02,0x01,0x47,0x04,0x24,0x00,0x82,0x3d,0x03,0x05,0x01,0x47,0x04,0x18,0x00,0x83,0x3d,0x03,0x02,0x01,0x47,0x04,0x18,0x00,
0x84,0x3d,0x03,0x05,0x01,0x47,0x04,0x1c,0x00,0x85,0x3d,0x03,0x02,0x01,0x47,0x04,0x1c,0x00,0x86,0x3d,0x03,0x05,0x01,0x47,0x04,0x0c,0x14,0x00,
0x87,0x3d,0x03,0x02,0x01,0x47,0x04,0x0c,0x14,0x00,0x88,0x3d,0x03,0x05,0x01,0x47,0x04,0x0c,0x0e,0x00,0x89,0x3d,0x03,0x02,0x01,0x47,0x04,0x0c,0x0e,0x00,
0x8a,0x3d,0x03,0x05,0x01,0x50,0x04,0x0c,0x14,0x00,0x8b,0x3d,0x03,0x02,0x01,0x50,0x04,0x0c,0x14,0x00,0x8c,0x3d,0x03,0x05,0x01,0x50,0x04,0x1c,0x00,
0x8d,0x3d,0x03,0x02,0x01,0x50,0x04,0x1c,0x00,0x8e,0x3d,0x03,0x05,0x01,0x38,0x04,0x0c,0x14,0x00,0x8f,0x3d,0x03,0x02,0x01,0x38,0x04,0x0c,0x14,0x00,
0x90,0x3d,0x03,0x05,0x01,0x36,0x04,0x1a,0x00,0x91,0x3d,0x03,0x02,0x01,0x36,0x04,0x1a,0x00,0x92,0x3d,0x03,0x05,0x01,0x36,0x04,0x0c,0x0e,0x00,
0x93,0x3d,0x03,0x02,0x01,0x36,0x04,0x0c,0x0e,0x00,0x94,0x3d,0x03,0x05,0x01,0x36,0x04,0x55,0x0e,0x00,0x95,0x3d,0x03,0x02,0x01,0x36,0x04,0x55,0x0e,0x00,
0x96,0x3d,0x03,0x02,0x01,0x33,0x04,0x55,0x0e,0x00,0x97,0x3d,0x03,0x02,0x01,0x32,0x04,0x1c,0x00,0x98,0x3d,0x03,0x02,0x01,0x47,0x04,0x52,0x14,0x00,
0x99,0x3d,0x03,0x02,0x01,0x38,0x04,0x52,0x14,0x00,0x9a,0x3d,0x03,0x02,0x01,0x12,0x04,0x6c,0xa8,0x01,0x52,0x00,0x9b,0x3d,0x03,0x02,0x01,0x5a,0x28,0x04,0x0c,0x14,0x00,
0x9c,0x3d,0x03,0x02,0x01,0x5a,0x28,0x04,0x67,0x0d,0x00,0x9d,0x3d,0x03,0x02,0x01,0x5a,0x28,0x04,0xde,0x01,0x0d,0x00,0x9e,0x3d,0x03,0x05,0x01,0xaf,0x02,0x28,0x00,
0x9f,0x3d,0x03,0x02,0x01,0xcb,0x01,0x00,0xa0,0x3d,0x03,0x05,0x01,0x12,0x04,0x0c,0x0e,0x00,0xa1,0x3d,0x03,0x02,0x01,0x12,0x04,0x0c,0x0e,0x00,
0xa2,0x3d,0x03,0x05,0x01,0x12,0x04,0x0b,0x14,0x00,0xa3,0x3d,0x03,0x02,0x01,0x12,0x04,0x0b,0x14,0x00,0xa4,0x3d,0x03,0x05,0x01,0x12,0x04,0x1a,0x08,0x18,0x00,
0xa5,0x3d,0x03,0x02,0x01,0x12,0x04,0x1a,0x08,0x18,0x00,0xa6,0x3d,0x03,0x05,0x01,0x12,0x04,0x1a,0x08,0x24,0x00,0xa7,0x3d,0x03,0x02,0x01,0x12,0x04,0x1a,0x08,0x24,0x00,
0xa8,0x3d,0x03,0x05,0x01,0x12,0x04,0x1a,0x08,0x0b,0x14,0x00,0xa9,0x3d,0x03,0x02,0x01,0x12,0x04,0x1a,0x08,0x0b,0x14,0x00,0xaa,0x3d,0x03,0x05,0x01,0x12,0x04,0x1a,0x08,0x1e,0x00,
0xab,0x3d,0x03,0x02,0x01,0x12,0x04,0x1a,0x08,0x1e,0x00,0xac,0x3d,0x03,0x05,0x01,0x12,0x04,0x1a,0x08,0x0c,0x0e,0x00,0xad,0x3d,0x03,0x02,0x01,0x12,0x04,0x1a,0x08,0x0c,0x0e,0x00,
0xae,0x3d,0x03,0x05,0x01,0x12,0x04,0x2a,0x08,0x18,0x00,0xaf,0x3d,0x03,0x02,0x01,0x12,0x04,0x2a,0x08,0x18,0x00,0xb0,0x3d,0x03,0x05,0x01,0x12,0x04,0x2a,0x08,0x24,0x00,
0xb1,0x3d,0x03,0x02,0x01,0x12,0x04,0x2a,0x08,0x24,0x00,0xb2,0x3d,0x03,0x05,0x01,0x12,0x04,0x2a,0x08,0x0b,0x14,0x00,0xb3,0x3d,0x03,0x02,0x01,0x12,0x04,0x2a,0x08,0x0b,0x14,0x00,
0xb4,0x3d,0x03,0x05,0x01,0x12,0x04,0x2a,0x08,0x1e,0x00,0xb5,0x3d,0x03,0x02,0x01,0x12,0x04,0x2a,0x08,0x1e,0x00,0xb6,0x3d,0x03,0x05,0x01,0x12,0x04,0x2a,0x08,0x0c,0x0e,0x00,
0xb7,0x3d,0x03,0x02,0x01,0x12,0x04,0x2a,0x08,0x0c,0x0e,0x00,0xb8,0x3d,0x03,0x05,0x01,0x11,0x04,0x0c,0x0e,0x00,0xb9,0x3d,0x03,0x02,0x01,0x11,0x04,0x0c,0x0e,0x00,
0xba,0x3d,0x03,0x05,0x01,0x11,0x04,0x0b,0x14,0x00,0xbb,0x3d,0x03,0x02,0x01,0x11,0x04,0x0b,0x14,0x00,0xbc,0x3d,0x03,0x05,0x01,0x11,0x04,0x1e,0x00,
0xbd,0x3d,0x03,0x02,0x01,0x11,0x04,0x1e,0x00,0xbe,0x3d,0x03,0x05,0x01,0x11,0x04,0x1a,0x08,0x18,0x00,0xbf,0x3d,0x03,0x02,0x01,0x11,0x04,0x1a,0x08,0x18,0x00,
0xc0,0x3d,0x03,0x05,0x01,0x11,0x04,0x1a,0x08,0x24,0x00,0xc1,0x3d,0x03,0x02,0x01,0x11,0x04,0x1a,0x08,0x24,0x00,0xc2,0x3d,0x03,0x05,0x01,0x11,0x04,0x1a,0x08,0x0b,0x14,0x00,
0xc3,0x3d,0x03,0x02,0x01,0x11,0x04,0x1a,0x08,0x0b,0x14,0x00,0xc4,0x3d,0x03,0x05,0x01,0x11,0x04,0x1a,0x08,0x1e,0x00,0xc5,0x3d,0x03,0x02,0x01,0x11,0x04,0x1a,0x08,0x1e,0x00,
0xc6,0x3d,0x03,0x05,0x01,0x11,0x04,0x1a,0x08,0x0c,0x0e,0x00,0xc7,0x3d,0x03,0x02,0x01,0x11,0x04,0x1a,0x08,0x0c,0x0e,0x00,0xc8,0x3d,0x03,0x05,0x01,0x1b,0x04,0x0b,0x14,0x00,
0xc9,0x3d,0x03,0x02,0x01,0x1b,0x04,0x0b,0x14,0x00,0xca,0x3d,0x03,0x05,0x01,0x1b,0x04,0x0c,0x0e,0x00,0xcb,0x3d,0x03,0x02,0x01,0x1b,0x04,0x0c,0x0e,0x00,
0xcc,0x3d,0x03,0x05,0x01,0x0a,0x04,0x0c,0x0e,0x00,0xcd,0x3d,0x03,0x02,0x01,0x0a,0x04,0x0c,0x0e,0x00,0xce,0x3d,0x03,0x05,0x01,0x0a,0x04,0x0b,0x14,0x00,
0xcf,0x3d,0x03,0x02,0x01,0x0a,0x04,0x0b,0x14,0x00,0xd0,0x3d,0x03,0x05,0x01,0x0a,0x04,0x1a,0x08,0x18,0x00,0xd1,0x3d,0x03,0x02,0x01,0x0a,0x04,0x1a,0x08,0x18,0x00,
0xd2,0x3d,0x03,0x05,0x01,0x0a,0x04,0x1a,0x08,0x24,0x00,0xd3,0x3d,0x03,0x02,0x01,0x0a,0x04,0x1a,0x08,0x24,0x00,0xd4,0x3d,0x03,0x05,0x01,0x0a,0x04,0x1a,0x08,0x0b,0x14,0x00,
0xd5,0x3d,0x03,0x02,0x01,0x0a,0x04,0x1a,0x08,0x0b,0x14,0x00,0xd6,0x3d,0x03,0x05,0x01,0x0a,0x04,0x1a,0x08,0x1e,0x00,0xd7,0x3d,0x03,0x02,0x01,0x0a,0x04,0x1a,0x08,0x1e,0x00,
0xd8,0x3d,0x03,0x05,0x01,0x0a,0x04,0x1a,0x08,0x0c,0x0e,0x00,0xd9,0x3d,0x03,0x02,0x01,0x0a,0x04,0x1a,0x08,0x0c,0x0e,0x00,0xda,0x3d,0x03,0x05,0x01,0x0a,0x04,0x45,0x08,0x18,0x00,
0xdb,0x3d,0x03,0x02,0x01,0x0a,0x04,0x45,0x08,0x18,0x00,0xdc,0x3d,0x03,0x05,0x01,0x0a,0x04,0x45,0x08,0x24,0x00,0xdd,0x3d,0x03,0x02,0x01,0x0a,0x04,0x45,0x08,0x24,0x00,
0xde,0x3d,0x03,0x05,0x01,0x0a,0x04,0x45,0x08,0x0b,0x14,0x00,0xdf,0x3d,0x03,0x02,0x01,0x0a,0x04,0x45,0x08,0x0b,0x14,0x00,0xe0,0x3d,0x03,0x05,0x01,0x0a,0x04,0x45,0x08,0x1e,0x00,
0xe1,0x3d,0x03,0x02,0x01,0x0a,0x04,0x45,0x08,0x1e,0x00,0xe2,0x3d,0x03,0x05,0x01,0x0a,0x04,0x45,0x08,0x0c,0x0e,0x00,0xe3,0x3d,0x03,0x02,0x01,0x0a,0x04,0x45,0x08,0x0c,0x0e,0x00,
0xe4,0x3d,0x03,0x05,0x01,0x0f,0x04,0x0c,0x0e,0x00,0xe5,0x3d,0x03,0x02,0x01,0x0f,0x04,0x0c,0x0e,0x00,0xe6,0x3d,0x03,0x05,0x01,0x0f,0x04,0x0b,0x14,0x00,
0xe7,0x3d,0x03,0x02,0x01,0x0f,0x04,0x0b,0x14,0x00,0xe8,0x3d,0x03,0x05,0x01,0x0f,0x04,0x45,0x08,0x18,0x00,0xe9,0x3d,0x03,0x02,0x01,0x0f,0x04,0x45,0x08,0x18,0x00,
0xea,0x3d,0x03,0x05,0x01,0x0f,0x04,0x45,0x08,0x24,0x00,0xeb,0x3d,0x03,0x02,0x01,0x0f,0x04,0x45,0x08,0x24,0x00,0xec,0x3d,0x03,0x05,0x01,0x0f,0x04,0x45,0x08,0x0b,0x14,0x00,
0xed,0x3d,0x03,0x02,0x01,0x0f,0x04,0x45,0x08,0x0b,0x14,0x00,0xee,0x3d,0x03,0x05,0x01,0x0f,0x04,0x45,0x08,0x1e,0x00,0xef,0x3d,0x03,0x02,0x01,0x0f,0x04,0x45,0x08,0x1e,0x00,
0xf0,0x3d,0x03,0x05,0x01,0x0f,0x04,0x45,0x08,0x0c,0x0e,0x00,0xf1,0x3d,0x03,0x02,0x01,0x0f,0x04,0x45,0x08,0x0c,0x0e,0x00,0xf2,0x3d,0x03,0x05,0x01,0x38,0x04,0x24,0x00,
0xf3,0x3d,0x03,0x02,0x01,0x38,0x04,0x24,0x00,0xf4,0x3d,0x03,0x05,0x01,0x38,0x04,0x0c,0x0e,0x00,0xf5,0x3d,0x03,0x02,0x01,0x38,0x04,0x0c,0x0e,0x00,
0xf6,0x3d,0x03,0x05,0x01,0x38,0x04,0x0b,0x14,0x00,0xf7,0x3d,0x03,0x02,0x01,0x38,0x04,0x0b,0x14,0x00,0xf8,0x3d,0x03,0x05,0x01,0x38,0x04,0x1e,0x00,
0xf9,0x3d,0x03,0x02,0x01,0x38,0x04,0x1e,0x00,0xfa,0x3d,0x03,0x05,0x01,0xbb,0x01,0xd8,0x02,0x00,0xfb,0x3d,0x03,0x02,0x01,0xbb,0x01,0xd8,0x02,0x00,
0xfc,0x3d,0x03,0x05,0x01,0xbb,0x01,0x42,0x00,0xfd,0x3d,0x03,0x02,0x01,0xbb,0x01,0x42,0x00,0xfe,0x3d,0x03,0x05,0x01,0x38,0x04,0xbc,0x01,0x00,
0xff,0x3d,0x03,0x02,0x01,0x38,0x04,0xbc,0x01,0x00,0x80,0x3e,0x07,0x02,0x01,0x20,0x04,0x19,0x00,0x81,0x3e,0x07,0x02,0x01,0x20,0x04,0x16,0x00,
0x82,0x3e,0x07,0x02,0x01,0x20,0x04,0x19,0x08,0x1d,0x00,0x83,0x3e,0x07,0x02,0x01,0x20,0x04,0x16,0x08,0x1d,0x00,0x84,0x3e,0x07,0x02,0x01,0x20,0x04,0x19,0x08,0x1f,0x00,
0x85,0x3e,0x07,0x02,0x01,0x20,0x04,0x16,0x08,0x1f,0x00,0x86,0x3e,0x07,0x02,0x01,0x20,0x04,0x19,0x08,0x2f,0x00,0x87,0x3e,0x07,0x02,0x01,0x20,0x04,0x16,0x08,0x2f,0x00,
0x88,0x3e,0x07,0x05,0x01,0x20,0x04,0x19,0x00,0x89,0x3e,0x07,0x05,0x01,0x20,0x04,0x16,0x00,0x8a,0x3e,0x07,0x05,0x01,0x20,0x04,0x19,0x08,0x1d,0x00,
0x8b,0x3e,0x07,0x05,0x01,0x20,0x04,0x16,0x08,0x1d,0x00,0x8c,0x3e,0x07,0x05,0x01,0x20,0x04,0x19,0x08,0x1f,0x00,0x8d,0x3e,0x07,0x05,0x01,0x20,0x04,0x16,0x08,0x1f,0x00,
0x8e,0x3e,0x07,0x05,0x01,0x20,0x04,0x19,0x08,0x2f,0x00,0x8f,0x3e,0x07,0x05,0x01,0x20,0x04,0x16,0x08,0x2f,0x00,0x90,0x3e,0x07,0x02,0x01,0x4e,0x04,0x19,0x00,
0x91,0x3e,0x07,0x02,0x01,0x4e,0x04,0x16,0x00,0x92,0x3e,0x07,0x02,0x01,0x4e,0x04,0x19,0x08,0x1d,0x00,0x93,0x3e,0x07,0x02,0x01,0x4e,0x04,0x16,0x08,0x1d,0x00,
0x94,0x3e,0x07,0x02,0x01,0x4e,0x04,0x19,0x08,0x1f,0x00,0x95,0x3e,0x07,0x02,0x01,0x4e,0x04,0x16,0x08,0x1f,0x00,0x98,0x3e,0x07,0x05,0x01,0x4e,0x04,0x19,0x00,
0x99,0x3e,0x07,0x05,0x01,0x4e,0x04,0x16,0x00,0x9a,0x3e,0x07,0x05,0x01,0x4e,0x04,0x19,0x08,0x1d,0x00,0x9b,0x3e,0x07,0x05,0x01,0x4e,0x04,0x16,0x08,0x1d,0x00,
0x9c,0x3e,0x07,0x05,0x01,0x4e,0x04,0x19,0x08,0x1f,0x00,0x9d,0x3e,0x07,0x05,0x01,0x4e,0x04,0x16,0x08,0x1f,0x00,0xa0,0x3e,0x07,0x02,0x01,0x29,0x04,0x19,0x00,
0xa1,0x3e,0x07,0x02,0x01,0x29,0x04,0x16,0x00,0xa2,0x3e,0x07,0x02,0x01,0x29,0x04,0x19,0x08,0x1d,0x00,0xa3,0x3e,0x07,0x02,0x01,0x29,0x04,0x16,0x08,0x1d,0x00,
0xa4,0x3e,0x07,0x02,0x01,0x29,0x04,0x19,0x08,0x1f,0x00,0xa5,0x3e,0x07,0x02,0x01,0x29,0x04,0x16,0x08,0x1f,0x00,0xa6,0x3e,0x07,0x02,0x01,0x29,0x04,0x19,0x08,0x2f,0x00,
0xa7,0x3e,0x07,0x02,0x01,0x29,0x04,0x16,0x08,0x2f,0x00,0xa8,0x3e,0x07,0x05,0x01,0x29,0x04,0x19,0x00,0xa9,0x3e,0x07,0x05,0x01,0x29,0x04,0x16,0x00,
0xaa,0x3e,0x07,0x05,0x01,0x29,0x04,0x19,0x08,0x1d,0x00,0xab,0x3e,0x07,0x05,0x01,0x29,0x04,0x16,0x08,0x1d,0x00,0xac,0x3e,0x07,0x05,0x01,0x29,0x04,0x19,0x08,0x1f,0x00,
0xad,0x3e,0x07,0x05,0x01,0x29,0x04,0x16,0x08,0x1f,0x00,0xae,0x3e,0x07,0x05,0x01,0x29,0x04,0x19,0x08,0x2f,0x00,0xaf,0x3e,0x07,0x05,0x01,0x29,0x04,0x16,0x08,0x2f,0x00,
0xb0,0x3e,0x07,0x02,0x01,0x30,0x04,0x19,0x00,0xb1,0x3e,0x07,0x02,0x01,0x30,0x04,0x16,0x00,0xb2,0x3e,0x07,0x02,0x01,0x30,0x04,0x19,0x08,0x1d,0x00,
0xb3,0x3e,0x07,0x02,0x01,0x30,0x04,0x16,0x08,0x1d,0x00,0xb4,0x3e,0x07,0x02,0x01,0x30,0x04,0x19,0x08,0x1f,0x00,0xb5,0x3e,0x07,0x02,0x01,0x30,0x04,0x16,0x08,0x1f,0x00,
0xb6,0x3e,0x07,0x02,0x01,0x30,0x04,0x19,0x08,0x2f,0x00,0xb7,0x3e,0x07,0x02,0x01,0x30,0x04,0x16,0x08,0x2f,0x00,0xb8,0x3e,0x07,0x05,0x01,0x30,0x04,0x19,0x00,
0xb9,0x3e,0x07,0x05,0x01,0x30,0x04,0x16,0x00,0xba,0x3e,0x07,0x05,0x01,0x30,0x04,0x19,0x08,0x1d,0x00,0xbb,0x3e,0x07,0x05,0x01,0x30,0x04,0x16,0x08,0x1d,0x00,
0xbc,0x3e,0x07,0x05,0x01,0x30,0x04,0x19,0x08,0x1f,0x00,0xbd,0x3e,0x07,0x05,0x01,0x30,0x04,0x16,0x08,0x1f,0x00,0xbe,0x3e,0x07,0x05,0x01,0x30,0x04,0x19,0x08,0x2f,0x00,
0xbf,0x3e,0x07,0x05,0x01,0x30,0x04,0x16,0x08,0x2f,0x00,0xc0,0x3e,0x07,0x02,0x01,0x4c,0x04,0x19,0x00,0xc1,0x3e,0x07,0x02,0x01,0x4c,0x04,0x16,0x00,
0xc2,0x3e,0x07,0x02,0x01,0x4c,0x04,0x19,0x08,0x1d,0x00,0xc3,0x3e,0x07,0x02,0x01,0x4c,0x04,0x16,0x08,0x1d,0x00,0xc4,0x3e,0x07,0x02,0x01,0x4c,0x04,0x19,0x08,0x1f,0x00,
0xc5,0x3e,0x07,0x02,0x01,0x4c,0x04,0x16,0x08,0x1f,0x00,0xc8,0x3e,0x07,0x05,0x01,0x4c,0x04,0x19,0x00,0xc9,0x3e,0x07,0x05,0x01,0x4c,0x04,0x16,0x00,
0xca,0x3e,0x07,0x05,0x01,0x4c,0x04,0x19,0x08,0x1d,0x00,0xcb,0x3e,0x07,0x05,0x01,0x4c,0x04,0x16,0x08,0x1d,0x00,0xcc,0x3e,0x07,0x05,0x01,0x4c,0x04,0x19,0x08,0x1f,0x00,
0xcd,0x3e,0x07,0x05,0x01,0x4c,0x04,0x16,0x08,0x1f,0x00,0xd0,0x3e,0x07,0x02,0x01,0x39,0x04,0x19,0x00,0xd1,0x3e,0x07,0x02,0x01,0x39,0x04,0x16,0x00,
0xd2,0x3e,0x07,0x02,0x01,0x39,0x04,0x19,0x08,0x1d,0x00,0xd3,0x3e,0x07,0x02,0x01,0x39,0x04,0x16,0x08,0x1d,0x00,0xd4,0x3e,0x07,0x02,0x01,0x39,0x04,0x19,0x08,0x1f,0x00,
0xd5,0x3e,0x07,0x02,0x01,0x39,0x04,0x16,0x08,0x1f,0x00,0xd6,0x3e,0x07,0x02,0x01,0x39,0x04,0x19,0x08,0x2f,0x00,0xd7,0x3e,0x07,0x02,0x01,0x39,0x04,0x16,0x08,0x2f,0x00,
0xd9,0x3e,0x07,0x05,0x01,0x39,0x04,0x16,0x00,0xdb,0x3e,0x07,0x05,0x01,0x39,0x04,0x16,0x08,0x1d,0x00,0xdd,0x3e,0x07,0x05,0x01,0x39,0x04,0x16,0x08,0x1f,0x00,
0xdf,0x3e,0x07,0x05,0x01,0x39,0x04,0x16,0x08,0x2f,0x00,0xe0,0x3e,0x07,0x02,0x01,0x21,0x04,0x19,0x00,0xe1,0x3e,0x07,0x02,0x01,0x21,0x04,0x16,0x00,
0xe2,0x3e,0x07,0x02,0x01,0x21,0x04,0x19,0x08,0x1d,0x00,0xe3,0x3e,0x07,0x02,0x01,0x21,0x04,0x16,0x08,0x1d,0x00,0xe4,0x3e,0x07,0x02,0x01,0x21,0x04,0x19,0x08,0x1f,0x00,
0xe5,0x3e,0x07,0x02,0x01,0x21,0x04,0x16,0x08,0x1f,0x00,0xe6,0x3e,0x07,0x02,0x01,0x21,0x04,0x19,0x08,0x2f,0x00,0xe7,0x3e,0x07,0x02,0x01,0x21,0x04,0x16,0x08,0x2f,0x00,
0xe8,0x3e,0x07,0x05,0x01,0x21,0x04,0x19,0x00,0xe9,0x3e,0x07,0x05,0x01,0x21,0x04,0x16,0x00,0xea,0x3e,0x07,0x05,0x01,0x21,0x04,0x19,0x08,0x1d,0x00,
0xeb,0x3e,0x07,0x05,0x01,0x21,0x04,0x16,0x08,0x1d,0x00,0xec,0x3e,0x07,0x05,0x01,0x21,0x04,0x19,0x08,0x1f,0x00,0xed,0x3e,0x07,0x05,0x01,0x21,0x04,0x16,0x08,0x1f,0x00,
0xee,0x3e,0x07,0x05,0x01,0x21,0x04,0x19,0x08,0x2f,0x00,0xef,0x3e,0x07,0x05,0x01,0x21,0x04,0x16,0x08,0x2f,0x00,0xf0,0x3e,0x07,0x02,0x01,0x20,0x04,0x1d,0x00,
0xf1,0x3e,0x07,0x02,0x01,0x20,0x04,0x1f,0x00,0xf2,0x3e,0x07,0x02,0x01,0x4e,0x04,0x1d,0x00,0xf3,0x3e,0x07,0x02,0x01,0x4e,0x04,0x1f,0x00,
0xf4,0x3e,0x07,0x02,0x01,0x29,0x04,0x1d,0x00,0xf5,0x3e,0x07,0x02,0x01,0x29,0x04,0x1f,0x00,0xf6,0x3e,0x07,0x02,0x01,0x30,0x04,0x1d,0x00,
0xf7,0x3e,0x07,0x02,0x01,0x30,0x04,0x1f,0x00,0xf8,0x3e,0x07,0x02,0x01,0x4c,0x04,0x1d,0x00,0xf9,0x3e,0x07,0x02,0x01,0x4c,0x04,0x1f,0x00,
0xfa,0x3e,0x07,0x02,0x01,0x39,0x04,0x1d,0x00,0xfb,0x3e,0x07,0x02,0x01,0x39,0x04,0x1f,0x00,0xfc,0x3e,0x07,0x02,0x01,0x21,0x04,0x1d,0x00,
0xfd,0x3e,0x07,0x02,0x01,0x21,0x04,0x1f,0x00,0x80,0x3f,0x07,0x02,0x01,0x20,0x04,0x19,0x08,0x37,0x00,0x81,0x3f,0x07,0x02,0x01,0x20,0x04,0x16,0x08,0x37,0x00,
0x82,0x3f,0x07,0x02,0x01,0x20,0x04,0x19,0x08,0x1d,0x08,0x37,0x00,0x83,0x3f,0x07,0x02,0x01,0x20,0x04,0x16,0x08,0x1d,0x08,0x37,0x00,0x84,0x3f,0x07,0x02,0x01,0x20,0x04,0x19,0x08,0x1f,0x08,0x37,0x00,
0x85,0x3f,0x07,0x02,0x01,0x20,0x04,0x16,0x08,0x1f,0x08,0x37,0x00,0x86,0x3f,0x07,0x02,0x01,0x20,0x04,0x19,0x08,0x2f,0x08,0x37,0x00,0x87,0x3f,0x07,0x02,0x01,0x20,0x04,0x16,0x08,0x2f,0x08,0x37,0x00,
0x88,0x3f,0x07,0x05,0x01,0x20,0x04,0x19,0x08,0x3f,0x00,0x89,0x3f,0x07,0x05,0x01,0x20,0x04,0x16,0x08,0x3f,0x00,0x8a,0x3f,0x07,0x05,0x01,0x20,0x04,0x19,0x08,0x1d,0x08,0x3f,0x00,
0x8b,0x3f,0x07,0x05,0x01,0x20,0x04,0x16,0x08,0x1d,0x08,0x3f,0x00,0x8c,0x3f,0x07,0x05,0x01,0x20,0x04,0x19,0x08,0x1f,0x08,0x3f,0x00,0x8d,0x3f,0x07,0x05,0x01,0x20,0x04,0x16,0x08,0x1f,0x08,0x3f,0x00,
0x8e,0x3f,0x07,0x05,0x01,0x20,0x04,0x19,0x08,0x2f,0x08,0x3f,0x00,0x8f,0x3f,0x07,0x05,0x01,0x20,0x04,0x16,0x08,0x2f,0x08,0x3f,0x00,0x90,0x3f,0x07,0x02,0x01,0x29,0x04,0x19,0x08,0x37,0x00,
0x91,0x3f,0x07,0x02,0x01,0x29,0x04,0x16,0x08,0x37,0x00,0x92,0x3f,0x07,0x02,0x01,0x29,0x04,0x19,0x08,0x1d,0x08,0x37,0x00,0x93,0x3f,0x07,0x02,0x01,0x29,0x04,0x16,0x08,0x1d,0x08,0x37,0x00,
0x94,0x3f,0x07,0x02,0x01,0x29,0x04,0x19,0x08,0x1f,0x08,0x37,0x00,0x95,0x3f,0x07,0x02,0x01,0x29,0x04,0x16,0x08,0x1f,0x08,0x37,0x00,0x96,0x3f,0x07,0x02,0x01,0x29,0x04,0x19,0x08,0x2f,0x08,0x37,0x00,
0x97,0x3f,0x07,0x02,0x01,0x29,0x04,0x16,0x08,0x2f,0x08,0x37,0x00,0x98,0x3f,0x07,0x05,0x01,0x29,0x04,0x19,0x08,0x3f,0x00,0x99,0x3f,0x07,0x05,0x01,0x29,0x04,0x16,0x08,0x3f,0x00,
0x9a,0x3f,0x07,0x05,0x01,0x29,0x04,0x19,0x08,0x1d,0x08,0x3f,0x00,0x9b,0x3f,0x07,0x05,0x01,0x29,0x04,0x16,0x08,0x1d,0x08,0x3f,0x00,0x9c,0x3f,0x07,0x05,0x01,0x29,0x04,0x19,0x08,0x1f,0x08,0x3f,0x00,
0x9d,0x3f,0x07,0x05,0x01,0x29,0x04,0x16,0x08,0x1f,0x08,0x3f,0x00,0x9e,0x3f,0x07,0x05,0x01,0x29,0x04,0x19,0x08,0x2f,0x08,0x3f,0x00,0x9f,0x3f,0x07,0x05,0x01,0x29,0x04,0x16,0x08,0x2f,0x08,0x3f,0x00,
0xa0,0x3f,0x07,0x02,0x01,0x21,0x04,0x19,0x08,0x37,0x00,0xa1,0x3f,0x07,0x02,0x01,0x21,0x04,0x16,0x08,0x37,0x00,0xa2,0x3f,0x07,0x02,0x01,0x21,0x04,0x19,0x08,0x1d,0x08,0x37,0x00,
0xa3,0x3f,0x07,0x02,0x01,0x21,0x04,0x16,0x08,0x1d,0x08,0x37,0x00,0xa4,0x3f,0x07,0x02,0x01,0x21,0x04,0x19,0x08,0x1f,0x08,0x37,0x00,0xa5,0x3f,0x07,0x02,0x01,0x21,0x04,0x16,0x08,0x1f,0x08,0x37,0x00,
0xa6,0x3f,0x07,0x02,0x01,0x21,0x04,0x19,0x08,0x2f,0x08,0x37,0x00,0xa7,0x3f,0x07,0x02,0x01,0x21,0x04,0x16,0x08,0x2f,0x08,0x37,0x00,0xa8,0x3f,0x07,0x05,0x01,0x21,0x04,0x19,0x08,0x3f,0x00,
0xa9,0x3f,0x07,0x05,0x01,0x21,0x04,0x16,0x08,0x3f,0x00,0xaa,0x3f,0x07,0x05,0x01,0x21,0x04,0x19,0x08,0x1d,0x08,0x3f,0x00,0xab,0x3f,0x07,0x05,0x01,0x21,0x04,0x16,0x08,0x1d,0x08,0x3f,0x00,
0xac,0x3f,0x07,0x05,0x01,0x21,0x04,0x19,0x08,0x1f,0x08,0x3f,0x00,0xad,0x3f,0x07,0x05,0x01,0x21,0x04,0x16,0x08,0x1f,0x08,0x3f,0x00,0xae,0x3f,0x07,0x05,0x01,0x21,0x04,0x19,0x08,0x2f,0x08,0x3f,0x00,
0xaf,0x3f,0x07,0x05,0x01,0x21,0x04,0x16,0x08,0x2f,0x08,0x3f,0x00,0xb0,0x3f,0x07,0x02,0x01,0x20,0x04,0x8c,0x01,0x00,0xb1,0x3f,0x07,0x02,0x01,0x20,0x04,0x23,0x00,
0xb2,0x3f,0x07,0x02,0x01,0x20,0x04,0x1d,0x08,0x37,0x00,0xb3,0x3f,0x07,0x02,0x01,0x20,0x04,0x37,0x00,0xb4,0x3f,0x07,0x02,0x01,0x20,0x04,0x1f,0x08,0x37,0x00,
0xb6,0x3f,0x07,0x02,0x01,0x20,0x04,0x2f,0x00,0xb7,0x3f,0x07,0x02,0x01,0x20,0x04,0x2f,0x08,0x37,0x00,0xb8,0x3f,0x07,0x05,0x01,0x20,0x04,0x8c,0x01,0x00,
0xb9,0x3f,0x07,0x05,0x01,0x20,0x04,0x23,0x00,0xba,0x3f,0x07,0x05,0x01,0x20,0x04,0x1d,0x00,0xbb,0x3f,0x07,0x05,0x01,0x20,0x04,0x1f,0x00,
0xbc,0x3f,0x07,0x05,0x01,0x20,0x04,0x3f,0x00,0xc2,0x3f,0x07,0x02,0x01,0x29,0x04,0x1d,0x08,0x37,0x00,0xc3,0x3f,0x07,0x02,0x01,0x29,0x04,0x37,0x00,
0xc4,0x3f,0x07,0x02,0x01,0x29,0x04,0x1f,0x08,0x37,0x00,0xc6,0x3f,0x07,0x02,0x01,0x29,0x04,0x2f,0x00,0xc7,0x3f,0x07,0x02,0x01,0x29,0x04,0x2f,0x08,0x37,0x00,
0xc8,0x3f,0x07,0x05,0x01,0x4e,0x04,0x1d,0x00,0xc9,0x3f,0x07,0x05,0x01,0x4e,0x04,0x1f,0x00,0xca,0x3f,0x07,0x05,0x01,0x29,0x04,0x1d,0x00,
0xcb,0x3f,0x07,0x05,0x01,0x29,0x04,0x1f,0x00,0xcc,0x3f,0x07,0x05,0x01,0x29,0x04,0x3f,0x00,0xd0,0x3f,0x07,0x02,0x01,0x30,0x04,0x8c,0x01,0x00,
0xd1,0x3f,0x07,0x02,0x01,0x30,0x04,0x23,0x00,0xd2,0x3f,0x07,0x02,0x01,0x30,0x04,0x64,0x08,0x1d,0x00,0xd3,0x3f,0x07,0x02,0x01,0x30,0x04,0x64,0x08,0x1f,0x00,
0xd6,0x3f,0x07,0x02,0x01,0x30,0x04,0x2f,0x00,0xd7,0x3f,0x07,0x02,0x01,0x30,0x04,0x64,0x08,0x2f,0x00,0xd8,0x3f,0x07,0x05,0x01,0x30,0x04,0x8c,0x01,0x00,
0xd9,0x3f,0x07,0x05,0x01,0x30,0x04,0x23,0x00,0xda,0x3f,0x07,0x05,0x01,0x30,0x04,0x1d,0x00,0xdb,0x3f,0x07,0x05,0x01,0x30,0x04,0x1f,0x00,
0xe0,0x3f,0x07,0x02,0x01,0x39,0x04,0x8c,0x01,0x00,0xe1,0x3f,0x07,0x02,0x01,0x39,0x04,0x23,0x00,0xe2,0x3f,0x07,0x02,0x01,0x39,0x04,0x64,0x08,0x1d,0x00,
0xe3,0x3f,0x07,0x02,0x01,0x39,0x04,0x64,0x08,0x1f,0x00,0xe4,0x3f,0x07,0x02,0x01,0x94,0x01,0x04,0x19,0x00,0xe5,0x3f,0x07,0x02,0x01,0x94,0x01,0x04,0x16,0x00,
0xe6,0x3f,0x07,0x02,0x01,0x39,0x04,0x2f,0x00,0xe7,0x3f,0x07,0x02,0x01,0x39,0x04,0x64,0x08,0x2f,0x00,0xe8,0x3f,0x07,0x05,0x01,0x39,0x04,0x8c,0x01,0x00,
0xe9,0x3f,0x07,0x05,0x01,0x39,0x04,0x23,0x00,0xea,0x3f,0x07,0x05,0x01,0x39,0x04,0x1d,0x00,0xeb,0x3f,0x07,0x05,0x01,0x39,0x04,0x1f,0x00,
0xec,0x3f,0x07,0x05,0x01,0x94,0x01,0x04,0x16,0x00,0xf2,0x3f,0x07,0x02,0x01,0x21,0x04,0x1d,0x08,0x37,0x00,0xf3,0x3f,0x07,0x02,0x01,0x21,0x04,0x37,0x00,
0xf4,0x3f,0x07,0x02,0x01,0x21,0x04,0x1f,0x08,0x37,0x00,0xf6,0x3f,0x07,0x02,0x01,0x21,0x04,0x2f,0x00,0xf7,0x3f,0x07,0x02,0x01,0x21,0x04,0x2f,0x08,0x37,0x00,
0xf8,0x3f,0x07,0x05,0x01,0x4c,0x04,0x1d,0x00,0xf9,0x3f,0x07,0x05,0x01,0x4c,0x04,0x1f,0x00,0xfa,0x3f,0x07,0x05,0x01,0x21,0x04,0x1d,0x00,
0xfb,0x3f,0x07,0x05,0x01,0x21,0x04,0x1f,0x00,0xfc,0x3f,0x07,0x05,0x01,0x21,0x04,0x3f,0x00,0xf1,0x40,0xa0,0x02,0x03,0x02,0x01,0x1b,0x00,
0xff,0x40,0xa0,0x02,0x03,0x02,0x01,0x2b,0x00,0x90,0x41,0x03,0x4a,0x02,0x01,0x12,0x00,0x91,0x41,0x03,0x4a,0x02,0x01,0x11,0x00,
0x92,0x41,0x03,0x4a,0x02,0x01,0x0a,0x00,0x93,0x41,0x03,0x4a,0x02,0x01,0x50,0x00,0x94,0x41,0x03,0x4a,0x02,0x01,0x6b,0x00,
0x95,0x41,0x03,0x4a,0x02,0x01,0x33,0x00,0x96,0x41,0x03,0x4a,0x02,0x01,0x3a,0x00,0x97,0x41,0x03,0x4a,0x02,0x01,0x27,0x00,
0x98,0x41,0x03,0x4a,0x02,0x01,0x48,0x00,0x99,0x41,0x03,0x4a,0x02,0x01,0x2b,0x00,0x9a,0x41,0x03,0x4a,0x02,0x01,0x44,0x00,
0x9b,0x41,0x03,0x4a,0x02,0x01,0x28,0x00,0x9c,0x41,0x03,0x4a,0x02,0x01,0x32,0x00,0xa9,0x42,0x2e,0x07,0x02,0x01,0x30,0x00,
0x84,0x43,0x03,0x02,0x01,0x4b,0x3b,0x00,0x9c,0x49,0x41,0x03,0x02,0x01,0x12,0x00,0x9d,0x49,0x41,0x03,0x02,0x01,0x49,0x00,
0x9e,0x49,0x41,0x03,0x02,0x01,0x3b,0x00,0x9f,0x49,0x41,0x03,0x02,0x01,0x35,0x00,0xa0,0x49,0x41,0x03,0x02,0x01,0x11,0x00,
0xa1,0x49,0x41,0x03,0x02,0x01,0x4f,0x00,0xa2,0x49,0x41,0x03,0x02,0x01,0x34,0x00,0xa3,0x49,0x41,0x03,0x02,0x01,0x33,0x00,
0xa4,0x49,0x41,0x03,0x02,0x01,0x1b,0x00,0xa5,0x49,0x41,0x03,0x02,0x01,0x4d,0x00,0xa6,0x49,0x41,0x03,0x02,0x01,0x3a,0x00,
0xa7,0x49,0x41,0x03,0x02,0x01,0x27,0x00,0xa8,0x49,0x41,0x03,0x02,0x01,0x48,0x00,0xa9,0x49,0x41,0x03,0x02,0x01,0x2b,0x00,
0xaa,0x49,0x41,0x03,0x02,0x01,0x0a,0x00,0xab,0x49,0x41,0x03,0x02,0x01,0x44,0x00,0xac,0x49,0x41,0x03,0x02,0x01,0x5d,0x00,
0xad,0x49,0x41,0x03,0x02,0x01,0x22,0x00,0xae,0x49,0x41,0x03,0x02,0x01,0x28,0x00,0xaf,0x49,0x41,0x03,0x02,0x01,0x32,0x00,
0xb0,0x49,0x41,0x03,0x02,0x01,0x0f,0x00,0xb1,0x49,0x41,0x03,0x02,0x01,0x42,0x00,0xb2,0x49,0x41,0x03,0x02,0x01,0x47,0x00,
0xb3,0x49,0x41,0x03,0x02,0x01,0x50,0x00,0xb4,0x49,0x41,0x03,0x02,0x01,0x38,0x00,0xb5,0x49,0x41,0x03,0x02,0x01,0x36,0x00,
0xb6,0x49,0x26,0x03,0x05,0x01,0x12,0x00,0xb7,0x49,0x26,0x03,0x05,0x01,0x49,0x00,0xb8,0x49,0x26,0x03,0x05,0x01,0x3b,0x00,
0xb9,0x49,0x26,0x03,0x05,0x01,0x35,0x00,0xba,0x49,0x26,0x03,0x05,0x01,0x11,0x00,0xbb,0x49,0x26,0x03,0x05,0x01,0x4f,0x00,
0xbc,0x49,0x26,0x03,0x05,0x01,0x34,0x00,0xbd,0x49,0x26,0x03,0x05,0x01,0x33,0x00,0xbe,0x49,0x26,0x03,0x05,0x01,0x1b,0x00,
0xbf,0x49,0x26,0x03,0x05,0x01,0x4d,0x00,0xc0,0x49,0x26,0x03,0x05,0x01,0x3a,0x00,0xc1,0x49,0x26,0x03,0x05,0x01,0x27,0x00,
0xc2,0x49,0x26,0x03,0x05,0x01,0x48,0x00,0xc3,0x49,0x26,0x03,0x05,0x01,0x2b,0x00,0xc4,0x49,0x26,0x03,0x05,0x01,0x0a,0x00,
0xc5,0x49,0x26,0x03,0x05,0x01,0x44,0x00,0xc6,0x49,0x26,0x03,0x05,0x01,0x5d,0x00,0xc7,0x49,0x26,0x03,0x05,0x01,0x22,0x00,
0xc8,0x49,0x26,0x03,0x05,0x01,0x28,0x00,0xc9,0x49,0x26,0x03,0x05,0x01,0x32,0x00,0xca,0x49,0x26,0x03,0x05,0x01,0x0f,0x00,
0xcb,0x49,0x26,0x03,0x05,0x01,0x42,0x00,0xcc,0x49,0x26,0x03,0x05,0x01,0x47,0x00,0xcd,0x49,0x26,0x03,0x05,0x01,0x50,0x00,
0xce,0x49,0x26,0x03,0x05,0x01,0x38,0x00,0xcf,0x49,0x26,0x03,0x05,0x01,0x36,0x00,0xd0,0x49,0x26,0x03,0x02,0x01,0x12,0x00,
0xd1,0x49,0x26,0x03,0x02,0x01,0x49,0x00,0xd2,0x49,0x26,0x03,0x02,0x01,0x3b,0x00,0xd3,0x49,0x26,0x03,0x02,0x01,0x35,0x00,
0xd4,0x49,0x26,0x03,0x02,0x01,0x11,0x00,0xd5,0x49,0x26,0x03,0x02,0x01,0x4f,0x00,0xd6,0x49,0x26,0x03,0x02,0x01,0x34,0x00,
0xd7,0x49,0x26,0x03,0x02,0x01,0x33,0x00,0xd8,0x49,0x26,0x03,0x02,0x01,0x1b,0x00,0xd9,0x49,0x26,0x03,0x02,0x01,0x4d,0x00,
0xda,0x49,0x26,0x03,0x02,0x01,0x3a,0x00,0xdb,0x49,0x26,0x03,0x02,0x01,0x27,0x00,0xdc,0x49,0x26,0x03,0x02,0x01,0x48,0x00,
0xdd,0x49,0x26,0x03,0x02,0x01,0x2b,0x00,0xde,0x49,0x26,0x03,0x02,0x01,0x0a,0x00,0xdf,0x49,0x26,0x03,0x02,0x01,0x44,0x00,
0xe0,0x49,0x26,0x03,0x02,0x01,0x5d,0x00,0xe1,0x49,0x26,0x03,0x02,0x01,0x22,0x00,0xe2,0x49,0x26,0x03,0x02,0x01,0x28,0x00,
0xe3,0x49,0x26,0x03,0x02,0x01,0x32,0x00,0xe4,0x49,0x26,0x03,0x02,0x01,0x0f,0x00,0xe5,0x49,0x26,0x03,0x02,0x01,0x42,0x00,
0xe6,0x49,0x26,0x03,0x02,0x01,0x47,0x00,0xe7,0x49,0x26,0x03,0x02,0x01,0x50,0x00,0xe8,0x49,0x26,0x03,0x02,0x01,0x38,0x00,
0xe9,0x49,0x26,0x03,0x02,0x01,0x36,0x00,0x80,0x58,0x10,0x05,0x01,0xb8,0x03,0x00,0x81,0x58,0x10,0x05,0x01,0xad,0x03,0x00,
0x82,0x58,0x10,0x05,0x01,0x85,0x02,0x00,0x83,0x58,0x10,0x05,0x01,0x84,0x03,0x00,0x84,0x58,0x10,0x05,0x01,0x99,0x03,0x00,
0x85,0x58,0x10,0x05,0x01,0xf6,0x01,0x00,0x86,0x58,0x10,0x05,0x01,0xec,0x01,0x00,0x87,0x58,0x10,0x05,0x01,0xc8,0x01,0x00,
0x88,0x58,0x10,0x05,0x01,0xf1,0x01,0x00,0x89,0x58,0x10,0x05,0x01,0xc1,0x01,0x00,0x8a,0x58,0x10,0x05,0x01,0xf4,0x02,0xc1,0x01,0x00,
0x8b,0x58,0x10,0x05,0x01,0x1b,0x00,0x8c,0x58,0x10,0x05,0x01,0x9a,0x03,0x00,0x8d,0x58,0x10,0x05,0x01,0xec,0x02,0x00,
0x8e,0x58,0x10,0x05,0x01,0xd9,0x02,0x00,0x8f,0x58,0x10,0x05,0x01,0xb9,0x01,0x00,0x90,0x58,0x10,0x05,0x01,0xd1,0x02,0x00,
0x91,0x58,0x10,0x05,0x01,0xc8,0x02,0x00,0x92,0x58,0x10,0x05,0x01,0xbc,0x02,0x00,0x93,0x58,0x10,0x05,0x01,0xb6,0x02,0x00,
0x94,0x58,0x10,0x05,0x01,0xa5,0x02,0x00,0x95,0x58,0x10,0x05,0x01,0x8f,0x02,0x00,0x96,0x58,0x10,0x05,0x01,0x88,0x02,0x00,
0x97,0x58,0x10,0x05,0x01,0x8a,0x03,0x00,0x98,0x58,0x10,0x05,0x01,0xfd,0x02,0x00,0x99,0x58,0x10,0x05,0x01,0xc4,0x02,0x00,
0x9a,0x58,0x10,0x05,0x01,0x79,0x00,0x9b,0x58,0x10,0x05,0x01,0xab,0x02,0x00,0x9c,0x58,0x10,0x05,0x01,0xd4,0x01,0x00,
0x9d,0x58,0x10,0x05,0x01,0xa3,0x03,0x00,0x9e,0x58,0x10,0x05,0x01,0x93,0x01,0x00,0x9f,0x58,0x10,0x05,0x01,0x76,0x00,
0xa0,0x58,0x10,0x05,0x01,0xf7,0x01,0x00,0xa1,0x58,0x10,0x05,0x01,0xf8,0x01,0x00,0xa2,0x58,0x10,0x05,0x01,0xa3,0x02,0x56,0x00,
0xa3,0x58,0x10,0x05,0x01,0x83,0x01,0x00,0xa4,0x58,0x10,0x05,0x01,0x02,0x46,0x00,0xa5,0x58,0x10,0x05,0x01,0x02,0x46,0x04,0x43,0x00,
0xa6,0x58,0x10,0x05,0x01,0xd0,0x01,0x00,0xa7,0x58,0x10,0x05,0x01,0xc2,0x01,0x02,0x46,0x00,0xa8,0x58,0x10,0x05,0x01,0x81,0x01,0x46,0x00,
0xa9,0x58,0x10,0x05,0x01,0xc2,0x01,0x81,0x01,0x46,0x00,0xaa,0x58,0x10,0x05,0x01,0xc3,0x01,0x00,0xab,0x58,0x10,0x05,0x01,0x97,0x01,0x00,
0xac,0x58,0x10,0x05,0x01,0xaa,0x02,0x00,0xad,0x58,0x10,0x05,0x01,0x93,0x02,0x12,0x00,0xae,0x58,0x10,0x05,0x01,0xdf,0x02,0xb9,0x01,0x00,
0xb0,0x58,0x10,0x02,0x01,0xb8,0x03,0x00,0xb1,0x58,0x10,0x02,0x01,0xad,0x03,0x00,0xb2,0x58,0x10,0x02,0x01,0x85,0x02,0x00,
0xb3,0x58,0x10,0x02,0x01,0x84,0x03,0x00,0xb4,0x58,0x10,0x02,0x01,0x99,0x03,0x00,0xb5,0x58,0x10,0x02,0x01,0xf6,0x01,0x00,
0xb6,0x58,0x10,0x02,0x01,0xec,0x01,0x00,0xb7,0x58,0x10,0x02,0x01,0xc8,0x01,0x00,0xb8,0x58,0x10,0x02,0x01,0xf1,0x01,0x00,
0xb9,0x58,0x10,0x02,0x01,0xc1,0x01,0x00,0xba,0x58,0x10,0x02,0x01,0xf4,0x02,0xc1,0x01,0x00,0xbb,0x58,0x10,0x02,0x01,0x1b,0x00,
0xbc,0x58,0x10,0x02,0x01,0x9a,0x03,0x00,0xbd,0x58,0x10,0x02,0x01,0xec,0x02,0x00,0xbe,0x58,0x10,0x02,0x01,0xd9,0x02,0x00,
0xbf,0x58,0x10,0x02,0x01,0xb9,0x01,0x00,0xc0,0x58,0x10,0x02,0x01,0xd1,0x02,0x00,0xc1,0x58,0x10,0x02,0x01,0xc8,0x02,0x00,
0xc2,0x58,0x10,0x02,0x01,0xbc,0x02,0x00,0xc3,0x58,0x10,0x02,0x01,0xb6,0x02,0x00,0xc4,0x58,0x10,0x02,0x01,0xa5,0x02,0x00,
0xc5,0x58,0x10,0x02,0x01,0x8f,0x02,0x00,0xc6,0x58,0x10,0x02,0x01,0x88,0x02,0x00,0xc7,0x58,0x10,0x02,0x01,0x8a,0x03,0x00,
0xc8,0x58,0x10,0x02,0x01,0xfd,0x02,0x00,0xc9,0x58,0x10,0x02,0x01,0xc4,0x02,0x00,0xca,0x58,0x10,0x02,0x01,0x79,0x00,
0xcb,0x58,0x10,0x02,0x01,0xab,0x02,0x00,0xcc,0x58,0x10,0x02,0x01,0xd4,0x01,0x00,0xcd,0x58,0x10,0x02,0x01,0xa3,0x03,0x00,
0xce,0x58,0x10,0x02,0x01,0x93,0x01,0x00,0xcf,0x58,0x10,0x02,0x01,0x76,0x00,0xd0,0x58,0x10,0x02,0x01,0xf7,0x01,0x00,
0xd1,0x58,0x10,0x02,0x01,0xf8,0x01,0x00,0xd2,0x58,0x10,0x02,0x01,0xa3,0x02,0x56,0x00,0xd3,0x58,0x10,0x02,0x01,0x83,0x01,0x00,
0xd4,0x58,0x10,0x02,0x01,0x02,0x46,0x00,0xd5,0x58,0x10,0x02,0x01,0x02,0x46,0x04,0x43,0x00,0xd6,0x58,0x10,0x02,0x01,0xd0,0x01,0x00,
0xd7,0x58,0x10,0x02,0x01,0xc2,0x01,0x02,0x46,0x00,0xd8,0x58,0x10,0x02,0x01,0x81,0x01,0x46,0x00,0xd9,0x58,0x10,0x02,0x01,0xc2,0x01,0x81,0x01,0x46,0x00,
0xda,0x58,0x10,0x02,0x01,0xc3,0x01,0x00,0xdb,0x58,0x10,0x02,0x01,0x97,0x01,0x00,0xdc,0x58,0x10,0x02,0x01,0xaa,0x02,0x00,
0xdd,0x58,0x10,0x02,0x01,0x93,0x02,0x12,0x00,0xde,0x58,0x10,0x02,0x01,0xdf,0x02,0xb9,0x01,0x00,0xe0,0x58,0x03,0x05,0x01,0x27,0x04,0x3d,0x69,0x00,
0xe1,0x58,0x03,0x02,0x01,0x27,0x04,0x3d,0x69,0x00,0xe2,0x58,0x03,0x05,0x01,0x27,0x04,0x3e,0x1e,0x00,0xe3,0x58,0x03,0x05,0x01,0x44,0x04,0x0d,0x00,
0xe4,0x58,0x03,0x05,0x01,0x22,0x04,0x43,0x00,0xe5,0x58,0x03,0x02,0x01,0x12,0x04,0x0d,0x00,0xe6,0x58,0x03,0x02,0x01,0x32,0x04,0x67,0x0d,0x00,
0xe7,0x58,0x03,0x05,0x01,0x33,0x04,0x31,0x00,0xe8,0x58,0x03,0x02,0x01,0x33,0x04,0x31,0x00,0xe9,0x58,0x03,0x05,0x01,0x3a,0x04,0x31,0x00,
0xea,0x58,0x03,0x02,0x01,0x3a,0x04,0x31,0x00,0xeb,0x58,0x03,0x05,0x01,0x36,0x04,0x31,0x00,0xec,0x58,0x03,0x02,0x01,0x36,0x04,0x31,0x00,
0xed,0x58,0x03,0x05,0x01,0x20,0x00,0xee,0x58,0x03,0x05,0x01,0x48,0x04,0x0b,0x00,0xef,0x58,0x03,0x05,0x01,0x2e,0x12,0x00,
0xf0,0x58,0x03,0x05,0x01,0x2e,0x20,0x00,0xf1,0x58,0x03,0x02,0x01,0x42,0x04,0x6c,0x0b,0x00,0xf2,0x58,0x03,0x05,0x01,0x47,0x04,0x0b,0x00,
0xf3,0x58,0x03,0x02,0x01,0x47,0x04,0x0b,0x00,0xf4,0x58,0x03,0x02,0x01,0x42,0x04,0x68,0x00,0xf5,0x58,0x03,0x05,0x01,0xa8,0x01,0x33,0x00,
0xf6,0x58,0x03,0x02,0x01,0xa8,0x01,0x33,0x00,0xf7,0x58,0x03,0x02,0x01,0xe3,0x03,0xa6,0x01,0x00,0xf8,0x58,0x03,0x02,0x01,0x11,0x04,0xfe,0x03,0x00,
0xf9,0x58,0x03,0x02,0x01,0x2e,0x22,0x04,0x43,0x00,0xfa,0x58,0x03,0x02,0x01,0x0a,0x04,0xa7,0x01,0x52,0x96,0x04,0x00,0xfc,0x58,0x03,0x4a,0x02,0x01,0x4d,0x00,
0xfe,0x58,0x03,0x05,0x01,0x28,0x04,0xb2,0x01,0x43,0x00,0xff,0x58,0x03,0x05,0x01,0x36,0x04,0xb2,0x01,0x43,0x00,0x80,0x59,0x09,0x05,0x01,0xbd,0x03,0x00,
0x81,0x59,0x09,0x02,0x01,0xbd,0x03,0x00,0x82,0x59,0x09,0x05,0x01,0x82,0x02,0x00,0x83,0x59,0x09,0x02,0x01,0x82,0x02,0x00,
0x84,0x59,0x09,0x05,0x01,0x87,0x01,0x00,0x85,0x59,0x09,0x02,0x01,0x87,0x01,0x00,0x86,0x59,0x09,0x05,0x01,0x9f,0x03,0x00,
0x87,0x59,0x09,0x02,0x01,0x9f,0x03,0x00,0x88,0x59,0x09,0x05,0x01,0xc6,0x01,0x00,0x89,0x59,0x09,0x02,0x01,0xc6,0x01,0x00,
0x8a,0x59,0x09,0x05,0x01,0xa4,0x02,0x00,0x8b,0x59,0x09,0x02,0x01,0xa4,0x02,0x00,0x8c,0x59,0x09,0x05,0x01,0xf2,0x01,0x00,
0x8d,0x59,0x09,0x02,0x01,0xf2,0x01,0x00,0x8e,0x59,0x09,0x05,0x01,0xff,0x02,0x00,0x8f,0x59,0x09,0x02,0x01,0xff,0x02,0x00,
0x90,0x59,0x09,0x05,0x01,0x9a,0x02,0x00,0x91,0x59,0x09,0x02,0x01,0x9a,0x02,0x00,0x92,0x59,0x09,0x05,0x01,0xf7,0x02,0x00,
0x93,0x59,0x09,0x02,0x01,0xf7,0x02,0x00,0x94,0x59,0x09,0x05,0x01,0xc0,0x01,0x00,0x95,0x59,0x09,0x02,0x01,0xc0,0x01,0x00,
0x96,0x59,0x09,0x05,0x01,0xde,0x02,0x00,0x97,0x59,0x09,0x02,0x01,0xde,0x02,0x00,0x98,0x59,0x09,0x05,0x01,0xdb,0x01,0x00,
0x99,0x59,0x09,0x02,0x01,0xdb,0x01,0x00,0x9a,0x59,0x09,0x05,0x01,0x86,0x01,0x00,0x9b,0x59,0x09,0x02,0x01,0x86,0x01,0x00,
0x9c,0x59,0x09,0x05,0x01,0xbe,0x01,0x00,0x9d,0x59,0x09,0x02,0x01,0xbe,0x01,0x00,0x9e,0x59,0x09,0x05,0x01,0x0a,0x00,
0x9f,0x59,0x09,0x02,0x01,0x0a,0x00,0xa0,0x59,0x09,0x05,0x01,0xb6,0x01,0x00,0xa1,0x59,0x09,0x02,0x01,0xb6,0x01,0x00,
0xa2,0x59,0x09,0x05,0x01,0xb5,0x02,0x00,0xa3,0x59,0x09,0x02,0x01,0xb5,0x02,0x00,0xa4,0x59,0x09,0x05,0x01,0xa8,0x02,0x00,
0xa5,0x59,0x09,0x02,0x01,0xa8,0x02,0x00,0xa6,0x59,0x09,0x05,0x01,0xb1,0x01,0x00,0xa7,0x59,0x09,0x02,0x01,0xb1,0x01,0x00,
0xa8,0x59,0x09,0x05,0x01,0x8b,0x02,0x00,0xa9,0x59,0x09,0x02,0x01,0x8b,0x02,0x00,0xaa,0x59,0x09,0x05,0x01,0x8c,0x03,0x00,
0xab,0x59,0x09,0x02,0x01,0x8c,0x03,0x00,0xac,0x59,0x09,0x05,0x01,0xe5,0x02,0x00,0xad,0x59,0x09,0x02,0x01,0xe5,0x02,0x00,
0xae,0x59,0x09,0x05,0x01,0x95,0x01,0x00,0xaf,0x59,0x09,0x02,0x01,0x95,0x01,0x00,0xb0,0x59,0x09,0x05,0x01,0xb7,0x01,0x00,
0xb1,0x59,0x09,0x02,0x01,0xb7,0x01,0x00,0xb2,0x59,0x09,0x05,0x01,0x7d,0xce,0x01,0x00,0xb3,0x59,0x09,0x02,0x01,0x7d,0xce,0x01,0x00,
0xb4,0x59,0x09,0x05,0x01,0x3c,0x09,0xcf,0x01,0x00,0xb5,0x59,0x09,0x02,0x01,0x3c,0x09,0xcf,0x01,0x00,0xb6,0x59,0x09,0x05,0x01,0x7f,0xc6,0x01,0x00,
0xb7,0x59,0x09,0x02,0x01,0x7f,0xc6,0x01,0x00,0xb8,0x59,0x09,0x05,0x01,0x7d,0xc0,0x01,0x00,0xb9,0x59,0x09,0x02,0x01,0x7d,0xc0,0x01,0x00,
0xba,0x59,0x09,0x05,0x01,0x7d,0x86,0x01,0x00,0xbb,0x59,0x09,0x02,0x01,0x7d,0x86,0x01,0x00,0xbc,0x59,0x09,0x05,0x01,0x7f,0x86,0x01,0x00,
0xbd,0x59,0x09,0x02,0x01,0x7f,0x86,0x01,0x00,0xbe,0x59,0x09,0x05,0x01,0x3c,0x09,0xb7,0x01,0x00,0xbf,0x59,0x09,0x02,0x01,0x3c,0x09,0xb7,0x01,0x00,
0xc0,0x59,0x09,0x05,0x01,0xa4,0x01,0x00,0xc1,0x59,0x09,0x02,0x01,0xa4,0x01,0x00,0xc2,0x59,0x09,0x05,0x01,0xcd,0x01,0x78,0x00,
0xc3,0x59,0x09,0x02,0x01,0xcd,0x01,0x78,0x00,0xc4,0x59,0x09,0x05,0x01,0x3c,0x09,0x78,0x00,0xc5,0x59,0x09,0x02,0x01,0x3c,0x09,0x78,0x00,
0xc6,0x59,0x09,0x05,0x01,0x3c,0x09,0x6e,0x00,0xc7,0x59,0x09,0x02,0x01,0x3c,0x09,0x6e,0x00,0xc8,0x59,0x09,0x05,0x01,0xbf,0x03,0x96,0x01,0x00,
0xc9,0x59,0x09,0x02,0x01,0xbf,0x03,0x96,0x01,0x00,0xca,0x59,0x09,0x05,0x01,0x7d,0x98,0x01,0x00,0xcb,0x59,0x09,0x02,0x01,0x7d,0x98,0x01,0x00,
0xcc,0x59,0x09,0x05,0x01,0x3c,0x09,0x98,0x01,0x00,0xcd,0x59,0x09,0x02,0x01,0x3c,0x09,0x98,0x01,0x00,0xce,0x59,0x09,0x05,0x01,0x3c,0x09,0x56,0x00,
0xcf,0x59,0x09,0x02,0x01,0x3c,0x09,0x56,0x00,0xd0,0x59,0x09,0x05,0x01,0xe3,0x02,0x56,0x00,0xd1,0x59,0x09,0x02,0x01,0xe3,0x02,0x56,0x00,
0xd2,0x59,0x09,0x05,0x01,0x3c,0x09,0xfe,0x02,0x00,0xd3,0x59,0x09,0x02,0x01,0x3c,0x09,0xfe,0x02,0x00,0xd4,0x59,0x09,0x05,0x01,0x3c,0x09,0x80,0x03,0x00,
0xd5,0x59,0x09,0x02,0x01,0x3c,0x09,0x80,0x03,0x00,0xd6,0x59,0x09,0x05,0x01,0x3c,0x09,0x99,0x01,0x00,0xd7,0x59,0x09,0x02,0x01,0x3c,0x09,0x99,0x01,0x00,
0xd8,0x59,0x09,0x05,0x01,0x3c,0x09,0x9c,0x03,0x00,0xd9,0x59,0x09,0x02,0x01,0x3c,0x09,0x9c,0x03,0x00,0xda,0x59,0x09,0x05,0x01,0x3c,0x09,0x92,0x01,0x00,
0xdb,0x59,0x09,0x02,0x01,0x3c,0x09,0x92,0x01,0x00,0xdc,0x59,0x09,0x05,0x01,0x3c,0x7a,0x92,0x01,0x00,0xdd,0x59,0x09,0x02,0x01,0x3c,0x7a,0x92,0x01,0x00,
0xde,0x59,0x09,0x05,0x01,0x3c,0x7a,0xcf,0x02,0x00,0xdf,0x59,0x09,0x02,0x01,0x3c,0x7a,0xcf,0x02,0x00,0xe0,0x59,0x09,0x05,0x01,0x3c,0x7a,0xcc,0x02,0x00,
0xe1,0x59,0x09,0x02,0x01,0x3c,0x7a,0xcc,0x02,0x00,0xe2,0x59,0x09,0x05,0x01,0x3c,0x7a,0xfd,0x01,0x00,0xe3,0x59,0x09,0x02,0x01,0x3c,0x7a,0xfd,0x01,0x00,
0xeb,0x59,0x09,0x05,0x01,0x7f,0x78,0x00,0xec,0x59,0x09,0x02,0x01,0x7f,0x78,0x00,0xed,0x59,0x09,0x05,0x01,0x7f,0x99,0x01,0x00,
0xee,0x59,0x09,0x02,0x01,0x7f,0x99,0x01,0x00,0xf2,0x59,0x09,0x05,0x01,0xb0,0x03,0x96,0x01,0x00,0xf3,0x59,0x09,0x02,0x01,0xb0,0x03,0x96,0x01,0x00,
0x80,0x5a,0x15,0x02,0x01,0xbc,0x03,0x00,0x81,0x5a,0x15,0x02,0x01,0xb6,0x03,0x00,0x82,0x5a,0x15,0x02,0x01,0x89,0x03,0x00,
0x83,0x5a,0x15,0x02,0x01,0x98,0x03,0x00,0x84,0x5a,0x15,0x02,0x01,0x5e,0x00,0x85,0x5a,0x15,0x02,0x01,0x81,0x02,0x00,
0x86,0x5a,0x15,0x02,0x01,0xef,0x01,0x00,0x87,0x5a,0x15,0x02,0x01,0x9e,0x02,0x00,0x88,0x5a,0x15,0x02,0x01,0xf6,0x02,0x00,
0x89,0x5a,0x15,0x02,0x01,0xeb,0x02,0x00,0x8a,0x5a,0x15,0x02,0x01,0xe0,0x02,0x00,0x8b,0x5a,0x15,0x02,0x01,0xd6,0x02,0x00,
0x8c,0x5a,0x15,0x02,0x01,0xd2,0x02,0x00,0x8d,0x5a,0x15,0x02,0x01,0xc9,0x02,0x00,0x8e,0x5a,0x15,0x02,0x01,0xc0,0x02,0x00,
0x8f,0x5a,0x15,0x02,0x01,0xed,0x01,0x00,0x90,0x5a,0x15,0x02,0x01,0xb9,0x02,0x00,0x91,0x5a,0x15,0x02,0x01,0xb5,0x01,0x00,
0x92,0x5a,0x15,0x02,0x01,0x9d,0x02,0x00,0x93,0x5a,0x15,0x02,0x01,0x87,0x02,0x00,0x94,0x5a,0x15,0x02,0x01,0xbe,0x02,0x00,
0x95,0x5a,0x15,0x02,0x01,0xe6,0x02,0x00,0x96,0x5a,0x15,0x02,0x01,0x87,0x03,0x00,0x97,0x5a,0x15,0x02,0x01,0xba,0x02,0x00,
0x98,0x5a,0x15,0x02,0x01,0xad,0x02,0x00,0x99,0x5a,0x15,0x02,0x01,0xa4,0x03,0x00,0x9a,0x5a,0x15,0x02,0x01,0xaa,0x03,0x00,
0x9b,0x5a,0x15,0x02,0x01,0xed,0x02,0x00,0x9c,0x5a,0x15,0x02,0x01,0xa2,0x03,0x00,0x9d,0x5a,0x15,0x02,0x01,0xa6,0x03,0x00,
0x9e,0x5a,0x15,0x02,0x01,0xfc,0x01,0x00,0x9f,0x5a,0x15,0x02,0x01,0xef,0x02,0x00,0xa0,0x5a,0x15,0x02,0x01,0x82,0x03,0x00,
0xa1,0x5a,0x15,0x02,0x01,0xe0,0x01,0x00,0xa2,0x5a,0x15,0x02,0x01,0xfb,0x02,0x00,0xa3,0x5a,0x15,0x02,0x01,0xa0,0x01,0x00,
0xa4,0x5a,0x15,0x02,0x01,0x81,0x03,0x00,0xa5,0x5a,0x15,0x02,0x01,0xfa,0x02,0x00,0xa7,0x5a,0x15,0x02,0x01,0xad,0x01,0x00,
0xad,0x5a,0x15,0x02,0x01,0xc0,0x03,0x00,0xc0,0xcc,0x02,0x06,0x05,0x01,0xf0,0x01,0x00,0xc1,0xcc,0x02,0x06,0x02,0x01,0xf0,0x01,0x00,
0xc2,0xcc,0x02,0x06,0x05,0x01,0xc8,0x01,0x00,0xc3,0xcc,0x02,0x06,0x02,0x01,0xc8,0x01,0x00,0xc4,0xcc,0x02,0x06,0x05,0x01,0x4b,0x9b,0x01,0x00,
0xc5,0xcc,0x02,0x06,0x02,0x01,0x4b,0x9b,0x01,0x00,0xc6,0xcc,0x02,0x06,0x05,0x01,0x30,0x00,0xc7,0xcc,0x02,0x06,0x02,0x01,0x30,0x00,
0xc8,0xcc,0x02,0x06,0x05,0x01,0x9b,0x03,0x00,0xc9,0xcc,0x02,0x06,0x02,0x01,0x9b,0x03,0x00,0xca,0xcc,0x02,0x06,0x05,0x01,0xd4,0x02,0xa1,0x01,0x00,
0xcb,0xcc,0x02,0x06,0x02,0x01,0xd4,0x02,0xa1,0x01,0x00,0xcc,0xcc,0x02,0x06,0x05,0x01,0xaf,0x03,0x21,0x00,0xcd,0xcc,0x02,0x06,0x02,0x01,0xaf,0x03,0x21,0x00,
0xce,0xcc,0x02,0x06,0x05,0x01,0xd0,0x02,0xae,0x01,0x00,0xcf,0xcc,0x02,0x06,0x02,0x01,0xd0,0x02,0xae,0x01,0x00,0xd0,0xcc,0x02,0x06,0x05,0x01,0x76,0x04,0xb7,0x03,0xae,0x01,0x00,
0xd1,0xcc,0x02,0x06,0x02,0x01,0x76,0x04,0xb7,0x03,0xae,0x01,0x00,0xd2,0xcc,0x02,0x06,0x05,0x01,0x60,0x8b,0x01,0x00,0xd3,0xcc,0x02,0x06,0x02,0x01,0x60,0x8b,0x01,0x00,
0xd4,0xcc,0x02,0x06,0x05,0x01,0x4b,0x83,0x01,0x00,0xd5,0xcc,0x02,0x06,0x02,0x01,0x4b,0x83,0x01,0x00,0xd6,0xcc,0x02,0x06,0x05,0x01,0x60,0x12,0x00,
0xd7,0xcc,0x02,0x06,0x02,0x01,0x60,0x12,0x00,0xd8,0xcc,0x02,0x06,0x05,0x01,0x88,0x01,0x7b,0x46,0x00,0xd9,0xcc,0x02,0x06,0x02,0x01,0x88,0x01,0x7b,0x46,0x00,
0xda,0xcc,0x02,0x06,0x05,0x01,0xb1,0x03,0x46,0x00,0xdb,0xcc,0x02,0x06,0x02,0x01,0xb1,0x03,0x46,0x00,0xdc,0xcc,0x02,0x06,0x05,0x01,0x60,0x88,0x01,0x7b,0x46,0x00,
0xdd,0xcc,0x02,0x06,0x02,0x01,0x60,0x88,0x01,0x7b,0x46,0x00,0xde,0xcc,0x02,0x06,0x05,0x01,0xad,0x01,0x00,0xdf,0xcc,0x02,0x06,0x02,0x01,0xad,0x01,0x00,
0xe0,0xcc,0x02,0x06,0x05,0x01,0x4b,0xa2,0x01,0x00,0xe1,0xcc,0x02,0x06,0x02,0x01,0x4b,0xa2,0x01,0x00,0xe2,0xcc,0x02,0x06,0x05,0x01,0x77,0x7e,0x00,
0xe3,0xcc,0x02,0x06,0x02,0x01,0x77,0x7e,0x00,0xe4,0xcc,0x02,0x06,0x05,0x01,0x77,0x63,0x00,0xe5,0xcc,0x02,0x06,0x02,0x01,0x77,0x63,0x00,
0xe6,0xcc,0x02,0x06,0x05,0x01,0x77,0x9a,0x01,0x00,0xe7,0xcc,0x02,0x06,0x02,0x01,0x77,0x9a,0x01,0x00,0xe8,0xcc,0x02,0x06,0x05,0x01,0xba,0x01,0x0a,0x00,
0xe9,0xcc,0x02,0x06,0x02,0x01,0xba,0x01,0x0a,0x00,0xea,0xcc,0x02,0x06,0x05,0x01,0xb2,0x03,0x0a,0x00,0xeb,0xcc,0x02,0x06,0x02,0x01,0xb2,0x03,0x0a,0x00,
0xec,0xcc,0x02,0x06,0x05,0x01,0x3d,0xba,0x01,0x0a,0x00,0xed,0xcc,0x02,0x06,0x02,0x01,0x3d,0xba,0x01,0x0a,0x00,0x80,0xcd,0x02,0x06,0x05,0x01,0x97,0x03,0x00,
0x81,0xcd,0x02,0x06,0x02,0x01,0x97,0x03,0x00,0x82,0xcd,0x02,0x06,0x05,0x01,0x94,0x03,0x00,0x83,0xcd,0x02,0x06,0x02,0x01,0x94,0x03,0x00,
0x84,0xcd,0x02,0x06,0x05,0x01,0xeb,0x01,0x00,0x85,0xcd,0x02,0x06,0x02,0x01,0xeb,0x01,0x00,0x86,0xcd,0x02,0x06,0x05,0x01,0xa9,0x03,0x00,
0x87,0xcd,0x02,0x06,0x02,0x01,0xa9,0x03,0x00,0x88,0xcd,0x02,0x06,0x05,0x01,0x93,0x03,0x00,0x89,0xcd,0x02,0x06,0x02,0x01,0x93,0x03,0x00,
0x8a,0xcd,0x02,0x06,0x05,0x01,0x70,0x04,0x3e,0x0b,0x00,0x8b,0xcd,0x02,0x06,0x02,0x01,0x70,0x04,0x3e,0x0b,0x00,0x8c,0xcd,0x02,0x06,0x05,0x01,0x8e,0x02,0x00,
0x8d,0xcd,0x02,0x06,0x02,0x01,0x8e,0x02,0x00,0x8e,0xcd,0x02,0x06,0x05,0x01,0x90,0x02,0x00,0x8f,0xcd,0x02,0x06,0x02,0x01,0x90,0x02,0x00,
0x90,0xcd,0x02,0x06,0x05,0x01,0x91,0x02,0x00,0x91,0xcd,0x02,0x06,0x02,0x01,0x91,0x02,0x00,0x92,0xcd,0x02,0x06,0x05,0x01,0x9c,0x02,0x00,
0x93,0xcd,0x02,0x06,0x02,0x01,0x9c,0x02,0x00,0x94,0xcd,0x02,0x06,0x05,0x01,0xf8,0x02,0x00,0x95,0xcd,0x02,0x06,0x02,0x01,0xf8,0x02,0x00,
0x96,0xcd,0x02,0x06,0x05,0x01,0xa9,0x02,0x00,0x97,0xcd,0x02,0x06,0x02,0x01,0xa9,0x02,0x00,0x98,0xcd,0x02,0x06,0x05,0x01,0x3d,0x0a,0x00,
0x99,0xcd,0x02,0x06,0x02,0x01,0x3d,0x0a,0x00,0x9a,0xcd,0x02,0x06,0x05,0x01,0xcd,0x01,0x0a,0x00,0x9b,0xcd,0x02,0x06,0x02,0x01,0xcd,0x01,0x0a,0x00,
0xa2,0xce,0x02,0x03,0x05,0x01,0xc7,0x01,0xce,0x01,0x00,0xa3,0xce,0x02,0x03,0x02,0x01,0xc7,0x01,0xce,0x01,0x00,0xa4,0xce,0x02,0x03,0x05,0x01,0xc7,0x01,0xcf,0x01,0x00,
0xa5,0xce,0x02,0x03,0x02,0x01,0xc7,0x01,0xcf,0x01,0x00,0xa6,0xce,0x02,0x03,0x05,0x01,0xdf,0x01,0x00,0xa7,0xce,0x02,0x03,0x02,0x01,0xdf,0x01,0x00,
0xa8,0xce,0x02,0x03,0x05,0x01,0x8c,0x02,0x00,0xa9,0xce,0x02,0x03,0x02,0x01,0x8c,0x02,0x00,0xaa,0xce,0x02,0x03,0x05,0x01,0x94,0x02,0x00,
0xab,0xce,0x02,0x03,0x02,0x01,0x94,0x02,0x00,0xac,0xce,0x02,0x03,0x05,0x01,0xcc,0x01,0x00,0xad,0xce,0x02,0x03,0x02,0x01,0xcc,0x01,0x00,
0xae,0xce,0x02,0x03,0x05,0x01,0xcc,0x01,0x04,0x9d,0x01,0x00,0xaf,0xce,0x02,0x03,0x02,0x01,0xcc,0x01,0x04,0x9d,0x01,0x00,0xb2,0xce,0x02,0x03,0x05,0x01,0xc2,0x03,0x00,
0xb3,0xce,0x02,0x03,0x02,0x01,0xc2,0x03,0x00,0xb4,0xce,0x02,0x03,0x05,0x01,0xe9,0x01,0x00,0xb5,0xce,0x02,0x03,0x02,0x01,0xe9,0x01,0x00,
0xb6,0xce,0x02,0x03,0x05,0x01,0xbb,0x03,0x00,0xb7,0xce,0x02,0x03,0x02,0x01,0xbb,0x03,0x00,0xb8,0xce,0x02,0x03,0x05,0x01,0xac,0x01,0x00,
0xb9,0xce,0x02,0x03,0x02,0x01,0xac,0x01,0x00,0xba,0xce,0x02,0x03,0x05,0x01,0xac,0x01,0x04,0xdc,0x01,0x69,0x00,0xbb,0xce,0x02,0x03,0x02,0x01,0xac,0x01,0x04,0xdc,0x01,0x69,0x00,
0xbc,0xce,0x02,0x03,0x05,0x01,0xba,0x03,0x00,0xbd,0xce,0x02,0x03,0x02,0x01,0xba,0x03,0x00,0xbe,0xce,0x02,0x03,0x05,0x01,0x4b,0x3b,0x04,0x0c,0x00,
0xbf,0xce,0x02,0x03,0x02,0x01,0x4b,0x3b,0x04,0x0c,0x00,0xc0,0xce,0x02,0x03,0x05,0x01,0x3a,0x04,0x0d,0x00,0xc1,0xce,0x02,0x03,0x02,0x01,0x3a,0x04,0x0d,0x00,
0xc2,0xce,0x02,0x03,0x05,0x01,0x3a,0x04,0x67,0x0d,0x00,0xc3,0xce,0x02,0x03,0x02,0x01,0x3a,0x04,0x67,0x0d,0x00,0xc4,0xce,0x02,0x03,0x05,0x01,0x3a,0x04,0x0d,0x08,0x67,0x0d,0x00,
0xc5,0xce,0x02,0x03,0x02,0x01,0x3a,0x04,0x0d,0x08,0x67,0x0d,0x00,0xc6,0xce,0x02,0x03,0x05,0x01,0xae,0x03,0x27,0x00,0xc7,0xce,0x02,0x03,0x02,0x01,0xae,0x03,0x27,0x00,
0xc8,0xce,0x02,0x03,0x05,0x01,0x27,0x04,0xde,0x01,0x0d,0x00,0xc9,0xce,0x02,0x03,0x02,0x01,0x27,0x04,0xde,0x01,0x0d,0x00,0xca,0xce,0x02,0x03,0x05,0x01,0x0a,0x04,0x5a,0x0d,0xc2,0x02,0x00,
0xcb,0xce,0x02,0x03,0x02,0x01,0x0a,0x04,0x5a,0x0d,0xc2,0x02,0x00,0xcc,0xce,0x02,0x03,0x05,0x01,0x0a,0x04,0xbc,0x01,0x00,0xcd,0xce,0x02,0x03,0x02,0x01,0x0a,0x04,0xbc,0x01,0x00,
0xce,0xce,0x02,0x03,0x05,0x01,0xc7,0x02,0x00,0xcf,0xce,0x02,0x03,0x02,0x01,0xc7,0x02,0x00,0xd0,0xce,0x02,0x03,0x05,0x01,0x44,0x04,0x0d,0x8f,0x01,0x31,0x00,
0xd1,0xce,0x02,0x03,0x02,0x01,0x44,0x04,0x0d,0x8f,0x01,0x31,0x00,0xd2,0xce,0x02,0x03,0x05,0x01,0x44,0x04,0xa9,0x01,0x00,0xd3,0xce,0x02,0x03,0x02,0x01,0x44,0x04,0xa9,0x01,0x00,
0xd4,0xce,0x02,0x03,0x05,0x01,0x44,0x04,0xa2,0x02,0x43,0x00,0xd5,0xce,0x02,0x03,0x02,0x01,0x44,0x04,0xa2,0x02,0x43,0x00,0xd6,0xce,0x02,0x03,0x05,0x01,0x5d,0x04,0x0d,0x8f,0x01,0x31,0x00,
0xd7,0xce,0x02,0x03,0x02,0x01,0x5d,0x04,0x0d,0x8f,0x01,0x31,0x00,0xd8,0xce,0x02,0x03,0x05,0x01,0x5d,0x04,0x67,0x0d,0x00,0xd9,0xce,0x02,0x03,0x02,0x01,0x5d,0x04,0x67,0x0d,0x00,
0xda,0xce,0x02,0x03,0x05,0x01,0x22,0xa5,0x01,0x00,0xdb,0xce,0x02,0x03,0x02,0x01,0x22,0xa5,0x01,0x00,0xdc,0xce,0x02,0x03,0x05,0x01,0xd7,0x01,0xa5,0x01,0x00,
0xdd,0xce,0x02,0x03,0x02,0x01,0xd7,0x01,0xa5,0x01,0x00,0xde,0xce,0x02,0x03,0x05,0x01,0x42,0x04,0x67,0x0d,0x00,0xdf,0xce,0x02,0x03,0x02,0x01,0x42,0x04,0x67,0x0d,0x00,
0xe0,0xce,0x02,0x03,0x05,0x01,0xfe,0x01,0x00,0xe1,0xce,0x02,0x03,0x02,0x01,0xfe,0x01,0x00,0xe2,0xce,0x02,0x03,0x05,0x01,0x80,0x02,0x36,0x00,
0xe3,0xce,0x02,0x03,0x02,0x01,0x80,0x02,0x36,0x00,0xe4,0xce,0x02,0x03,0x05,0x01,0x90,0x01,0x04,0x0d,0x00,0xe5,0xce,0x02,0x03,0x02,0x01,0x90,0x01,0x04,0x0d,0x00,
0xe6,0xce,0x02,0x03,0x05,0x01,0x90,0x01,0x04,0x0d,0x8f,0x01,0x31,0x00,0xe7,0xce,0x02,0x03,0x02,0x01,0x90,0x01,0x04,0x0d,0x8f,0x01,0x31,0x00,0xe8,0xce,0x02,0x03,0x05,0x01,0x84,0x02,0x00,
0xe9,0xce,0x02,0x03,0x02,0x01,0x84,0x02,0x00,0xea,0xce,0x02,0x03,0x05,0x01,0xc4,0x01,0x00,0xeb,0xce,0x02,0x03,0x02,0x01,0xc4,0x01,0x00,
0xec,0xce,0x02,0x03,0x05,0x01,0xf2,0x02,0x00,0xed,0xce,0x02,0x03,0x02,0x01,0xf2,0x02,0x00,0xee,0xce,0x02,0x03,0x05,0x01,0xa0,0x03,0x00,
0xef,0xce,0x02,0x03,0x02,0x01,0xa0,0x03,0x00,0xf1,0xce,0x02,0x03,0x02,0x01,0xa6,0x04,0x00,0xf2,0xce,0x02,0x03,0x02,0x01,0x8a,0x04,0x00,
0xf3,0xce,0x02,0x03,0x02,0x01,0x85,0x04,0x00,0xf4,0xce,0x02,0x03,0x02,0x01,0xfd,0x03,0x00,0xf5,0xce,0x02,0x03,0x02,0x01,0xd7,0x01,0x00,
0xf7,0xce,0x02,0x03,0x02,0x01,0xd1,0x03,0x00,0xf8,0xce,0x02,0x03,0x02,0x01,0xd0,0x03,0x00,0xf9,0xce,0x02,0x03,0x05,0x01,0x5c,0x35,0x00,
0xfa,0xce,0x02,0x03,0x02,0x01,0x5c,0x35,0x00,0xfb,0xce,0x02,0x03,0x05,0x01,0x5c,0x4f,0x00,0xfc,0xce,0x02,0x03,0x02,0x01,0x5c,0x4f,0x00,
0xfd,0xce,0x02,0x03,0x05,0x01,0x5c,0x34,0x00,0xfe,0xce,0x02,0x03,0x05,0x01,0x2e,0x5c,0x34,0x00,0xff,0xce,0x02,0x03,0x02,0x01,0x2e,0x5c,0x34,0x00,
0x80,0xcf,0x02,0x03,0x05,0x01,0x2e,0x27,0x00,0x81,0xcf,0x02,0x03,0x02,0x01,0x2e,0x27,0x00,0x82,0xcf,0x02,0x03,0x05,0x01,0x5c,0x22,0x00,
0x83,0xcf,0x02,0x03,0x02,0x01,0x5c,0x22,0x00,0x84,0xcf,0x02,0x03,0x05,0x01,0x5c,0x28,0x00,0x85,0xcf,0x02,0x03,0x02,0x01,0x5c,0x28,0x00,
0x86,0xcf,0x02,0x03,0x05,0x01,0x5c,0x32,0x00,0x87,0xcf,0x02,0x03,0x02,0x01,0x5c,0x32,0x00,0x8b,0xcf,0x02,0x03,0x05,0x01,0xb3,0x02,0x00,
0x8c,0xcf,0x02,0x03,0x02,0x01,0xb3,0x02,0x00,0x8d,0xcf,0x02,0x03,0x05,0x01,0x2e,0x33,0x00,0x8e,0xcf,0x02,0x03,0x02,0x01,0x27,0x04,0x53,0x0b,0x08,0xe7,0x01,0x00,
0x90,0xcf,0x02,0x03,0x05,0x01,0x2b,0x04,0x31,0x00,0x91,0xcf,0x02,0x03,0x02,0x01,0x2b,0x04,0x31,0x00,0x92,0xcf,0x02,0x03,0x05,0x01,0x3b,0x04,0x69,0x00,
0x93,0xcf,0x02,0x03,0x02,0x01,0x3b,0x04,0x69,0x00,0x94,0xcf,0x02,0x03,0x02,0x01,0x3b,0x04,0x51,0x0b,0x00,0x95,0xcf,0x02,0x03,0x02,0x01,0x33,0x04,0x51,0x0b,0x00,
0x96,0xcf,0x02,0x03,0x05,0x01,0x49,0x04,0xa9,0x01,0x00,0x97,0xcf,0x02,0x03,0x02,0x01,0x49,0x04,0xa9,0x01,0x00,0x98,0xcf,0x02,0x03,0x05,0x01,0x4f,0x04,0x0d,0x00,
0x99,0xcf,0x02,0x03,0x02,0x01,0x4f,0x04,0x0d,0x00,0x9a,0xcf,0x02,0x03,0x05,0x01,0x8d,0x01,0x6f,0x00,0x9b,0xcf,0x02,0x03,0x02,0x01,0x8d,0x01,0x6f,0x00,
0x9c,0xcf,0x02,0x03,0x05,0x01,0x8d,0x01,0x85,0x01,0x00,0x9d,0xcf,0x02,0x03,0x02,0x01,0x8d,0x01,0x85,0x01,0x00,0x9e,0xcf,0x02,0x03,0x05,0x01,0x8d,0x01,0xd3,0x01,0x00,
0x9f,0xcf,0x02,0x03,0x02,0x01,0x8d,0x01,0xd3,0x01,0x00,0xa0,0xcf,0x02,0x03,0x05,0x01,0x34,0x04,0x6d,0x0d,0x00,0xa1,0xcf,0x02,0x03,0x02,0x01,0x34,0x04,0x6d,0x0d,0x00,
0xa2,0xcf,0x02,0x03,0x05,0x01,0x3a,0x04,0x6d,0x0d,0x00,0xa3,0xcf,0x02,0x03,0x02,0x01,0x3a,0x04,0x6d,0x0d,0x00,0xa4,0xcf,0x02,0x03,0x05,0x01,0x2b,0x04,0x6d,0x0d,0x00,
0xa5,0xcf,0x02,0x03,0x02,0x01,0x2b,0x04,0x6d,0x0d,0x00,0xa6,0xcf,0x02,0x03,0x05,0x01,0x22,0x04,0x6d,0x0d,0x00,0xa7,0xcf,0x02,0x03,0x02,0x01,0x22,0x04,0x6d,0x0d,0x00,
0xa8,0xcf,0x02,0x03,0x05,0x01,0x28,0x04,0x6d,0x0d,0x00,0xa9,0xcf,0x02,0x03,0x02,0x01,0x28,0x04,0x6d,0x0d,0x00,0xaa,0xcf,0x02,0x03,0x05,0x01,0x33,0x04,0x0b,0x00,
0xab,0xcf,0x02,0x03,0x05,0x01,0x4b,0x54,0x11,0x00,0xac,0xcf,0x02,0x03,0x05,0x01,0xa3,0x01,0x34,0x00,0xad,0xcf,0x02,0x03,0x05,0x01,0x27,0x04,0xe7,0x01,0x00,
0xae,0xcf,0x02,0x03,0x05,0x01,0x02,0x05,0x1b,0x00,0xb0,0xcf,0x02,0x03,0x05,0x01,0x2e,0x3a,0x00,0xb1,0xcf,0x02,0x03,0x05,0x01,0x2e,0x32,0x00,
0xb2,0xcf,0x02,0x03,0x05,0x01,0x4d,0x04,0x80,0x01,0x00,0xb3,0xcf,0x02,0x03,0x05,0x01,0x89,0x01,0x00,0xb4,0xcf,0x02,0x03,0x05,0x01,0x9e,0x01,0x00,
0xb5,0xcf,0x02,0x03,0x02,0x01,0x9e,0x01,0x00,0xb6,0xcf,0x02,0x03,0x05,0x01,0x21,0x00,0xb7,0xcf,0x02,0x03,0x02,0x01,0x21,0x00,
0xb0,0xd6,0x02,0x03,0x02,0x01,0x8a,0x01,0x20,0x00,0xb1,0xd6,0x02,0x03,0x02,0x01,0x12,0xf0,0x03,0x00,0xb2,0xd6,0x02,0x03,0x02,0x01,0xe6,0x01,0x11,0x00,
0xb3,0xd6,0x02,0x03,0x02,0x01,0x8a,0x01,0x11,0x00,0xb4,0xd6,0x02,0x03,0x02,0x01,0x11,0x04,0xa9,0x01,0x00,0xb5,0xd6,0x02,0x03,0x02,0x01,0x91,0x04,0x4f,0x00,
0xb6,0xd6,0x02,0x03,0x02,0x01,0xa3,0x01,0x34,0x04,0x80,0x01,0x00,0xb7,0xd6,0x02,0x03,0x02,0x01,0x27,0x04,0x5b,0x93,0x04,0x28,0x00,0xb8,0xd6,0x02,0x03,0x02,0x01,0x27,0x04,0x3d,0x3e,0x1e,0x00,
0xb9,0xd6,0x02,0x03,0x02,0x01,0x27,0x04,0x3e,0x52,0x00,0xba,0xd6,0x02,0x03,0x02,0x01,0x48,0x04,0x80,0x01,0x00,0xbb,0xd6,0x02,0x03,0x02,0x01,0x2b,0x04,0x80,0x01,0x00,
0xbc,0xd6,0x02,0x03,0x02,0x01,0xe3,0x01,0x04,0x80,0x01,0x00,0xbd,0xd6,0x02,0x03,0x02,0x01,0xe6,0x01,0x0a,0x00,0xbe,0xd6,0x02,0x03,0x02,0x01,0xe6,0x01,0x0a,0x04,0x0d,0x00,
0xbf,0xd6,0x02,0x03,0x02,0x01,0x54,0x0a,0x04,0x0d,0x00,0xc0,0xd6,0x02,0x03,0x02,0x01,0x5b,0x85,0x01,0x00,0xc1,0xd6,0x02,0x03,0x02,0x01,0x2e,0x85,0x01,0x04,0x0d,0x00,
0xc2,0xd6,0x02,0x03,0x02,0x01,0x2e,0x85,0x01,0x04,0xdc,0x01,0x0d,0x00,0xc3,0xd6,0x02,0x03,0x02,0x01,0x2e,0x0a,0xc6,0x02,0x00,0xc4,0xd6,0x02,0x03,0x02,0x01,0x2e,0x0a,0xc6,0x02,0x04,0x0d,0x00,
0xc5,0xd6,0x02,0x03,0x02,0x01,0xe7,0x03,0x22,0x00,0xc7,0xd6,0x02,0x03,0x02,0x01,0x22,0xca,0x03,0x9b,0x04,0x00,0xc8,0xd6,0x02,0x03,0x02,0x01,0x3d,0x22,0x00,
0xc9,0xd6,0x02,0x03,0x02,0x01,0x22,0x04,0x80,0x01,0x00,0xca,0xd6,0x02,0x03,0x02,0x01,0x3d,0x22,0x04,0x80,0x01,0x00,0xcb,0xd6,0x02,0x03,0x02,0x01,0xa3,0x01,0x22,0x00,
0xcc,0xd6,0x02,0x03,0x02,0x01,0xa3,0x01,0x22,0x04,0x52,0x00,0xcd,0xd6,0x02,0x03,0x02,0x01,0xb0,0x04,0x6e,0x00,0xce,0xd6,0x02,0x03,0x02,0x01,0x0f,0x04,0x71,0x6c,0x65,0x00,
0xcf,0xd6,0x02,0x03,0x02,0x01,0x0f,0x69,0x04,0x71,0x6c,0x65,0x00,0xd0,0xd6,0x02,0x03,0x02,0x01,0x8a,0x02,0x00,0xd1,0xd6,0x02,0x03,0x02,0x01,0x2e,0x8a,0x02,0x00,
0xd2,0xd6,0x02,0x03,0x02,0x01,0x0f,0x04,0x73,0x0b,0x00,0xd3,0xd6,0x02,0x03,0x02,0x01,0x89,0x01,0x00,0xd4,0xd6,0x02,0x03,0x02,0x01,0x89,0x01,0x04,0xa7,0x01,0x6c,0x52,0x00,
0xd5,0xd6,0x02,0x03,0x02,0x01,0x89,0x01,0x04,0xa7,0x01,0x73,0xb0,0x02,0x00,0xd6,0xd6,0x02,0x03,0x02,0x01,0x50,0x04,0xa7,0x01,0x6c,0x52,0x00,0xd7,0xd6,0x02,0x03,0x02,0x01,0x50,0x04,0x5a,0x73,0x65,0x00,
0xd8,0xd6,0x02,0x03,0x02,0x01,0x50,0x04,0x5a,0x73,0x65,0x08,0xa7,0x01,0x6c,0x52,0x00,0xd9,0xd6,0x02,0x03,0x02,0x01,0x50,0x04,0x5a,0x73,0x65,0x04,0xb0,0x02,0x00,0xda,0xd6,0x02,0x03,0x02,0x01,0x38,0x04,0x71,0x6c,0x65,0x00,
0xe0,0xd6,0x02,0x03,0x02,0x01,0xed,0x03,0x8b,0x01,0x00,0xe1,0xd6,0x02,0x03,0x02,0x01,0x60,0x11,0x00,0xe2,0xd6,0x02,0x03,0x02,0x01,0x54,0x85,0x01,0x00,
0xe3,0xd6,0x02,0x03,0x02,0x01,0xce,0x03,0x00,0xe4,0xd6,0x02,0x03,0x02,0x01,0x5b,0x20,0x00,0xf0,0xd6,0x02,0x13,0x02,0x01,0x12,0x00,
0xf1,0xd6,0x02,0x13,0x02,0x01,0x11,0x00,0xf2,0xd6,0x02,0x13,0x02,0x01,0x1b,0x00,0xf3,0xd6,0x02,0x13,0x02,0x01,0x0a,0x00,
0xf4,0xd6,0x02,0x13,0x02,0x01,0x0f,0x00,0xf5,0xd6,0x02,0x13,0x02,0x01,0x42,0x00,0xf6,0xd6,0x02,0x13,0x02,0x01,0xa1,0x04,0x00,
0xf7,0xd6,0x02,0x13,0x02,0x01,0x59,0x00,0xf8,0xd6,0x02,0x13,0x02,0x01,0xa0,0x04,0x00,0xf9,0xd6,0x02,0x13,0x02,0x01,0x9f,0x04,0x00,
0xfa,0xd6,0x02,0x13,0x02,0x01,0x9e,0x04,0x00,0xfb,0xd6,0x02,0x13,0x02,0x01,0x9d,0x04,0x00,0xfc,0xd6,0x02,0x13,0x02,0x01,0x9c,0x04,0x00,
0xfd,0xd6,0x02,0x13,0x02,0x01,0x56,0x00,0xfe,0xd6,0x02,0x13,0x02,0x01,0xe0,0x01,0x00,0xff,0xd6,0x02,0x13,0x02,0x01,0x9a,0x04,0x00,
0x80,0xd7,0x02,0x13,0x02,0x01,0xdd,0x01,0x00,0x81,0xd7,0x02,0x13,0x02,0x01,0x98,0x04,0x00,0x82,0xd7,0x02,0x13,0x02,0x01,0xf9,0x02,0x00,
0x83,0xd7,0x02,0x13,0x02,0x01,0xe2,0x02,0x00,0x84,0xd7,0x02,0x13,0x02,0x01,0x92,0x04,0x00,0x85,0xd7,0x02,0x13,0x02,0x01,0x8f,0x04,0x00,
0x86,0xd7,0x02,0x13,0x02,0x01,0x8e,0x04,0x00,0x87,0xd7,0x02,0x13,0x02,0x01,0x8b,0x04,0x00,0x88,0xd7,0x02,0x13,0x02,0x01,0x89,0x04,0x00,
0x89,0xd7,0x02,0x13,0x02,0x01,0xd7,0x02,0x00,0x8a,0xd7,0x02,0x13,0x02,0x01,0x87,0x04,0x00,0x8b,0xd7,0x02,0x13,0x02,0x01,0xdb,0x01,0x00,
0x8c,0xd7,0x02,0x13,0x02,0x01,0x86,0x04,0x00,0x8d,0xd7,0x02,0x13,0x02,0x01,0xda,0x01,0x00,0x8e,0xd7,0x02,0x13,0x02,0x01,0xd3,0x02,0x00,
0x8f,0xd7,0x02,0x13,0x02,0x01,0x99,0x04,0x00,0x90,0xd7,0x02,0x13,0x02,0x01,0x83,0x04,0x00,0x91,0xd7,0x02,0x13,0x02,0x01,0x81,0x04,0x00,
0x92,0xd7,0x02,0x13,0x02,0x01,0x86,0x01,0x00,0x93,0xd7,0x02,0x13,0x02,0x01,0xff,0x03,0x00,0x94,0xd7,0x02,0x13,0x02,0x01,0xd9,0x01,0x00,
0x95,0xd7,0x02,0x13,0x02,0x01,0xfc,0x03,0x00,0x96,0xd7,0x02,0x13,0x02,0x01,0xf7,0x03,0x00,0x97,0xd7,0x02,0x13,0x02,0x01,0xf6,0x03,0x00,
0x98,0xd7,0x02,0x13,0x02,0x01,0xf5,0x03,0x00,0x99,0xd7,0x02,0x13,0x02,0x01,0xf4,0x03,0x00,0x9a,0xd7,0x02,0x13,0x02,0x01,0xf3,0x03,0x00,
0x9b,0xd7,0x02,0x13,0x02,0x01,0xf2,0x03,0x00,0x9c,0xd7,0x02,0x13,0x02,0x01,0xee,0x03,0x00,0x9d,0xd7,0x02,0x13,0x02,0x01,0x28,0x00,
0x9e,0xd7,0x02,0x13,0x02,0x01,0xec,0x03,0x00,0x9f,0xd7,0x02,0x13,0x02,0x01,0xeb,0x03,0x00,0xa0,0xd7,0x02,0x13,0x02,0x01,0xea,0x03,0x00,
0xa1,0xd7,0x02,0x13,0x02,0x01,0xe5,0x03,0x00,0xa2,0xd7,0x02,0x13,0x02,0x01,0xe4,0x03,0x00,0xa3,0xd7,0x02,0x13,0x02,0x01,0xe5,0x01,0x00,
0xa4,0xd7,0x02,0x13,0x02,0x01,0x9f,0x02,0x00,0xa5,0xd7,0x02,0x13,0x02,0x01,0x7e,0x00,0xa6,0xd7,0x02,0x13,0x02,0x01,0x70,0x00,
0xa7,0xd7,0x02,0x13,0x02,0x01,0xab,0x04,0x00,0xa8,0xd7,0x02,0x13,0x02,0x01,0xde,0x03,0x00,0xa9,0xd7,0x02,0x13,0x02,0x01,0xa8,0x04,0x00,
0xaa,0xd7,0x02,0x13,0x02,0x01,0xa7,0x04,0x00,0xab,0xd7,0x02,0x13,0x02,0x01,0xa5,0x04,0x00,0xac,0xd7,0x02,0x13,0x02,0x01,0xa9,0x04,0x00,
0xad,0xd7,0x02,0x13,0x02,0x01,0xdd,0x03,0x00,0xae,0xd7,0x02,0x13,0x02,0x01,0xdc,0x03,0x00,0xaf,0xd7,0x02,0x13,0x02,0x01,0xdb,0x03,0x00,
0xb0,0xd7,0x02,0x13,0x02,0x01,0xda,0x03,0x00,0xb1,0xd7,0x02,0x13,0x02,0x01,0xd9,0x03,0x00,0xb2,0xd7,0x02,0x13,0x02,0x01,0xd8,0x03,0x00,
0xb3,0xd7,0x02,0x13,0x02,0x01,0xd5,0x03,0x00,0xb4,0xd7,0x02,0x13,0x02,0x01,0xa2,0x01,0x00,0xb5,0xd7,0x02,0x13,0x02,0x01,0xd4,0x01,0x00,
0xb6,0xd7,0x02,0x13,0x02,0x01,0xd4,0x03,0x00,0xb7,0xd7,0x02,0x13,0x02,0x01,0xd3,0x03,0x00,0xb8,0xd7,0x02,0x13,0x02,0x01,0xd2,0x03,0x00,
0xb9,0xd7,0x02,0x13,0x02,0x01,0xcd,0x03,0x00,0xba,0xd7,0x02,0x13,0x02,0x01,0xa0,0x01,0x00,0xbb,0xd7,0x02,0x13,0x02,0x01,0xcc,0x03,0x00,
0xbc,0xd7,0x02,0x13,0x02,0x01,0xc9,0x03,0x00,0xbd,0xd7,0x02,0x13,0x02,0x01,0xc8,0x03,0x00,0xbe,0xd7,0x02,0x13,0x02,0x01,0xc7,0x03,0x00,
0xbf,0xd7,0x02,0x13,0x02,0x01,0xd1,0x01,0x00,0xa1,0xfe,0x03,0x25,0x03,0x05,0x01,0x12,0x00,0xa2,0xfe,0x03,0x25,0x03,0x05,0x01,0x49,0x00,
0xa3,0xfe,0x03,0x25,0x03,0x05,0x01,0x3b,0x00,0xa4,0xfe,0x03,0x25,0x03,0x05,0x01,0x35,0x00,0xa5,0xfe,0x03,0x25,0x03,0x05,0x01,0x11,0x00,
0xa6,0xfe,0x03,0x25,0x03,0x05,0x01,0x4f,0x00,0xa7,0xfe,0x03,0x25,0x03,0x05,0x01,0x34,0x00,0xa8,0xfe,0x03,0x25,0x03,0x05,0x01,0x33,0x00,
0xa9,0xfe,0x03,0x25,0x03,0x05,0x01,0x1b,0x00,0xaa,0xfe,0x03,0x25,0x03,0x05,0x01,0x4d,0x00,0xab,0xfe,0x03,0x25,0x03,0x05,0x01,0x3a,0x00,
0xac,0xfe,0x03,0x25,0x03,0x05,0x01,0x27,0x00,0xad,0xfe,0x03,0x25,0x03,0x05,0x01,0x48,0x00,0xae,0xfe,0x03,0x25,0x03,0x05,0x01,0x2b,0x00,
0xaf,0xfe,0x03,0x25,0x03,0x05,0x01,0x0a,0x00,0xb0,0xfe,0x03,0x25,0x03,0x05,0x01,0x44,0x00,0xb1,0xfe,0x03,0x25,0x03,0x05,0x01,0x5d,0x00,
0xb2,0xfe,0x03,0x25,0x03,0x05,0x01,0x22,0x00,0xb3,0xfe,0x03,0x25,0x03,0x05,0x01,0x28,0x00,0xb4,0xfe,0x03,0x25,0x03,0x05,0x01,0x32,0x00,
0xb5,0xfe,0x03,0x25,0x03,0x05,0x01,0x0f,0x00,0xb6,0xfe,0x03,0x25,0x03,0x05,0x01,0x42,0x00,0xb7,0xfe,0x03,0x25,0x03,0x05,0x01,0x47,0x00,
0xb8,0xfe,0x03,0x25,0x03,0x05,0x01,0x50,0x00,0xb9,0xfe,0x03,0x25,0x03,0x05,0x01,0x38,0x00,0xba,0xfe,0x03,0x25,0x03,0x05,0x01,0x36,0x00,
0xc1,0xfe,0x03,0x25,0x03,0x02,0x01,0x12,0x00,0xc2,0xfe,0x03,0x25,0x03,0x02,0x01,0x49,0x00,0xc3,0xfe,0x03,0x25,0x03,0x02,0x01,0x3b,0x00,
0xc4,0xfe,0x03,0x25,0x03,0x02,0x01,0x35,0x00,0xc5,0xfe,0x03,0x25,0x03,0x02,0x01,0x11,0x00,0xc6,0xfe,0x03,0x25,0x03,0x02,0x01,0x4f,0x00,
0xc7,0xfe,0x03,0x25,0x03,0x02,0x01,0x34,0x00,0xc8,0xfe,0x03,0x25,0x03,0x02,0x01,0x33,0x00,0xc9,0xfe,0x03,0x25,0x03,0x02,0x01,0x1b,0x00,
0xca,0xfe,0x03,0x25,0x03,0x02,0x01,0x4d,0x00,0xcb,0xfe,0x03,0x25,0x03,0x02,0x01,0x3a,0x00,0xcc,0xfe,0x03,0x25,0x03,0x02,0x01,0x27,0x00,
0xcd,0xfe,0x03,0x25,0x03,0x02,0x01,0x48,0x00,0xce,0xfe,0x03,0x25,0x03,0x02,0x01,0x2b,0x00,0xcf,0xfe,0x03,0x25,0x03,0x02,0x01,0x0a,0x00,
0xd0,0xfe,0x03,0x25,0x03,0x02,0x01,0x44,0x00,0xd1,0xfe,0x03,0x25,0x03,0x02,0x01,0x5d,0x00,0xd2,0xfe,0x03,0x25,0x03,0x02,0x01,0x22,0x00,
0xd3,0xfe,0x03,0x25,0x03,0x02,0x01,0x28,0x00,0xd4,0xfe,0x03,0x25,0x03,0x02,0x01,0x32,0x00,0xd5,0xfe,0x03,0x25,0x03,0x02,0x01,0x0f,0x00,
0xd6,0xfe,0x03,0x25,0x03,0x02,0x01,0x42,0x00,0xd7,0xfe,0x03,0x25,0x03,0x02,0x01,0x47,0x00,0xd8,0xfe,0x03,0x25,0x03,0x02,0x01,0x50,0x00,
0xd9,0xfe,0x03,0x25,0x03,0x02,0x01,0x38,0x00,0xda,0xfe,0x03,0x25,0x03,0x02,0x01,0x36,0x00,0 };

static ushort getshort(uchar **pp)
{
   ushort n=0;

   uchar *p = *pp;

   if (*p < 0x80) {
      n = *p++;
      *pp = p;
      return n;
   }

   n = *p & 0x7f;
   p++;

   ushort v = (ushort)*p;
   p++;
   if (v < 0x80) {
      n |= (v << 7);
   } else {
      n |= ((v & 0x7f) << 7);
      v = (ushort)*p;
      p++;
      n |= (v << 14);
   }

   *pp = p;

   return n;
}

char *getuniname(ushort ncode)
{
   static char szbuf[2][200];
   static int  ibuf=0;

   ibuf ^= 1;
   szbuf[ibuf][0] = '\0';

   uchar *pcur=auninames;

   bool bverb=0;

   while (*pcur)
   {
      // next record
      ushort ncode2 = getshort(&pcur);
      if (ncode2 != ncode) {
         while (getshort(&pcur) != 0)
            ;
         continue;
      }

      // printf("%04x ",ncode);
      while (1)
      {
         ushort nword = getshort(&pcur);
         if (!nword) break;
         // printf("%s ",adict[nword]);
         cchar *pword = adict[nword];
         if (!strcmp(pword, "SMALL"))
            pword = "SMALL  ";
         strcat(szbuf[ibuf], pword);
         strcat(szbuf[ibuf], " ");
      }
      // printf("\n");
      break;
   }

   char *psz=szbuf[ibuf];
   int   ilen=strlen(psz);
   for (; ilen>0 && psz[ilen-1]==' '; ilen--)
      psz[ilen-1]='\0';

   return szbuf[ibuf];
}

// emod text_uni
#endif // (sfk_prog || sfk_text_uni)

bool getistr(char *psz, int idigits, int ifrom, int ito, int &rout)
{
   int r=0;
   for (int i=0; i<idigits; i++)
   {
      char c = *psz++;
      if (!isdigit(c))
         return 0;
      r = r * 10 + (c - '0');
   }
   if (r < ifrom) return 0;
   if (r > ito) return 0;
   rout = r;
   return 1;
}

bool matchdate(char *pszsrcio, cchar *pszmask, int *adate, bool breorder=0)
{
   char *pszsrc = pszsrcio;

   int Y=0,M=0,D=0,h=0,m=0,s=0;
   int i=0,istate=0;

   int ireqdigits = 0;
   for (char *psz=(char*)pszmask; *psz; psz++)
      switch (*psz) {
         case 'Y': ireqdigits += 4; break;
         case 'M': ireqdigits += 2; break;
         case 'D': ireqdigits += 2; break;
         case 'h': ireqdigits += 2; break;
         case 'm': ireqdigits += 2; break;
         case 's': ireqdigits += 2; break;
      }

   int ihavedigits = 0;
   for (char *psz=pszsrc; *psz; psz++)
      if (isdigit(*psz))
         ihavedigits++;
      else
         break;

   if (ihavedigits < ireqdigits)
      return 0;

   while (*pszmask && *pszsrc)
   {
      switch (*pszmask)
      {
         case 'Y':
            if (!getistr(pszsrc,4,1970,3000,Y)) {
               if (istate) return 0;
               pszsrc++;
               continue;
            }
            adate[0] = Y;
            pszmask++;
            pszsrc += 4;
            istate=1;
            continue;
         case 'M':
            if (!getistr(pszsrc,2,01,12,M)) {
               if (istate) return 0;
               pszsrc++;
               continue;
            }
            adate[1] = M;
            pszmask++;
            pszsrc += 2;
            istate=1;
            continue;
         case 'D':
            if (!getistr(pszsrc,2,01,31,D)) {
               if (istate) return 0;
               pszsrc++;
               continue;
            }
            adate[2] = D;
            pszmask++;
            pszsrc += 2;
            istate=1;
            continue;
         case 'h':
            if (!getistr(pszsrc,2,00,23,h)) {
               if (istate) return 0;
               pszsrc++;
               continue;
            }
            adate[3] = h;
            pszmask++;
            pszsrc += 2;
            istate=1;
            continue;
         case 'm':
            if (!getistr(pszsrc,2,00,59,m)) {
               if (istate) return 0;
               pszsrc++;
               continue;
            }
            adate[4] = m;
            pszmask++;
            pszsrc += 2;
            istate=1;
            continue;
         case 's':
            if (!getistr(pszsrc,2,00,59,s)) {
               if (istate) return 0;
               pszsrc++;
               continue;
            }
            adate[5] = s;
            pszmask++;
            pszsrc += 2;
            istate=1;
            continue;
      }
   }

   if (!*pszmask)
   {
      if (breorder==1 && (pszsrc-pszsrcio)==8)
      {
         // rebuild date in order: YMD
         pszsrcio[0] = ((adate[0] / 1000) % 10) + '0';
         pszsrcio[1] = ((adate[0] /  100) % 10) + '0';
         pszsrcio[2] = ((adate[0] /   10) % 10) + '0';
         pszsrcio[3] = ((adate[0] /    1) % 10) + '0';
         pszsrcio[4] = ((adate[1] /   10) % 10) + '0';
         pszsrcio[5] = ((adate[1] /    1) % 10) + '0';
         pszsrcio[6] = ((adate[2] /   10) % 10) + '0';
         pszsrcio[7] = ((adate[2] /    1) % 10) + '0';
      }
      return 1;
   }

   return 0;
}

#ifdef SFK_W64
char *dataAsTraceQ(ushort *pAnyData)
{
   static char szBuf[300];

   char *pszBuf = szBuf;
   int  iMaxBuf = sizeof(szBuf);
 
   ushort *pSrcCur = (ushort *)pAnyData;
 
   char *pszDstCur = pszBuf;
   char *pszDstMax = pszBuf + iMaxBuf - 20;
 
   int i=0;
   for (; pSrcCur[i] != 0 && pszDstCur < pszDstMax; i++)
   {
      ushort uc = pSrcCur[i];
 
      if (uc < 0x100U && isprint((char)uc))
      {
         *pszDstCur++ = (char)uc;
         continue;
      }

      *pszDstCur++ = '?';
   }
 
   *pszDstCur = '\0';
 
   return pszBuf;
}

int execFixFile(ushort *ain, sfkfinddata64_t *pdata)
{
   cs.files++;

   // derive all possibly needed data

   ushort apure[1024];  // for dewide, rewide
   char   szpure[1024]; // same in ascii
   int    adate[20];    // for setftime
   uchar  szcp[50];

   int isrc=0,idst=0,iuni=0;
   int msrc=1000,mdst=1000;
   mclear(adate);

   while (ain[isrc]!=0 && isrc<msrc && idst<mdst)
   {
      ushort uc = ain[isrc++];
      if (uc >= 0x100U)
      {
         iuni++;

         if (cs.dewide)
            continue;

         if (cs.rewide)
         {
            sprintf((char*)szcp, "{%04x}", uc);
            for (int i=0; szcp[i]!=0 && idst<mdst; i++)
            {
               apure[idst] = szcp[i];
               szpure[idst] = szcp[i];
               idst++;
            }
            continue;
         }

         apure[idst] = uc;
         szpure[idst] = '?';
         idst++;
         continue;
      }
      apure[idst] = uc;
      szpure[idst] = (char)uc;
      idst++;
   }
   apure[idst] = 0;
   szpure[idst] = '\0';

   /*
      scan for date, time
      -------------------
      01312015    MDY   201501   hms
      20150131    YMD   2015     hm

      01172015-0737  MDYhm
      20150131201501 YMDhms
   */
   bool bdate=0,btime=0,btsdiff=0;
   char *psz = strrchr(szpure, glblPathChar);
   if (!psz)
         psz = szpure;
   while (*psz)
   {
      if (!bdate) {
         if (matchdate(psz, "MDY", adate, cs.setndate)) {
            if (cs.setndate) {
               // write back possible reordered date
               int ioff = psz-szpure;
               for (int i=0; i<8; i++) {
                  if (apure[ioff+i] != ((ushort)psz[i]&0xFFU))
                     btsdiff = 1;
                  apure[ioff+i] = psz[i];
               }
            }
            bdate=1;
            psz += 8;
            continue;
         }
         if (matchdate(psz, "YMD", adate))
            { bdate=1; psz += 8; continue; }
         psz++;
         continue;
      }
      if (!btime) {
         if (matchdate(psz, "hms", adate))
            { btime=1; psz += 6; continue; }
         if (matchdate(psz, "hm", adate))
            { btime=1; psz += 4; continue; }
         psz++;
         continue;
      }
      break;
   }

   bool bNameDiffers = memcmp(ain, apure, (isrc+1)*2) ? 1 : 0;

   mytime_t now = mytime(NULL);
   struct tm *tm = 0;
   tm = mylocaltime(&now); // safe
   if (tm == 0) return 9+perr("cannot get time"); // safety

   tm->tm_isdst = -1;
   tm->tm_year = adate[0] - 1900;
   tm->tm_mon  = adate[1] - 1;
   tm->tm_mday = adate[2];
   tm->tm_hour = adate[3];
   tm->tm_min  = adate[4];
   tm->tm_sec  = adate[5];

   mytime_t nTime = mymktime(tm);
   num nTime2 = (num)nTime;

   bool bTimeDiffers = 0;

   if (nTime2 > 0 && nTime2 != pdata->time_write)
      bTimeDiffers = 1;

   // ignore, list, change?
   bool bChgName=0, bChgTime=0;
 
   if ((cs.dewide || cs.rewide) && bNameDiffers)
      bChgName = 1;

   if (cs.setftime && bTimeDiffers)
      bChgTime = 1;

   if (btsdiff)
      bChgName = 1;

   if (!bChgName && !bChgTime)
      return 0;

   printx("$FROM:<def> <time>%s<def> %s\n",
      pdata->time_write > 0 ? timeAsString(pdata->time_write,1) : "[invalid time]",
      dataAsTraceQ(ain));

   // printx("$DIFF:<def> name=%d time=%d %llu %llu\n",bChgName,bChgTime,pdata->time_write,nTime2);
   num nTime3 = 0;
   if (pdata->time_write > 0)
      nTime3 = pdata->time_write; // display default: current file time
   if (bChgTime != 0 && nTime2 > 0)
      nTime3 = nTime2;
   cchar *ptimecol = (bChgTime != 0 && nTime2 > 0) ? "<rep>":"<time>";
   cchar *pnamecol = bChgName ? "<rep>":"";
   printx("$  TO:<def> %s%s<def> %s%s<def>\n", ptimecol, timeAsString(nTime3,1), // sfk1883
      pnamecol, dataAsTraceW(apure));

   if (idst < 1) {
      pwarn("... cannot change, name would be empty: %s\n", dataAsTraceW(ain));
      return 0;
   }

   if (cs.yes)
   {
      do
      {
         if (bChgName && _wrename((const wchar_t *)ain, (const wchar_t *)apure))
         {
            perr("... rename failed: %s\n", dataAsTraceW(ain));
            break;
         }

         bool berr = 0;

         if (bChgTime != 0 && nTime2 > 0)
         {
            HANDLE hDst = CreateFileW(
               (const wchar_t *)apure,
               FILE_WRITE_ATTRIBUTES,
               0,    // share
               0,    // security
               OPEN_EXISTING,
               FILE_ATTRIBUTE_NORMAL,
               0     // template file
               );
            if (hDst == INVALID_HANDLE_VALUE)
               { perr("... set filetime failed (1)\n"); break; }

            FILETIME nDstMTime, nDstCTime;
            FILETIME *pMTime=0, *pCTime=0;
 
            if (!makeWinFileTime(nTime2, nDstMTime)) // fixfile
               pMTime = &nDstMTime;
 
            // if (nClCTime > 0)
            // {
            //    if (!makeWinFileTime(nClCTime, nDstCTime))
            //       pCTime = &nDstCTime;
            // }

            if (pMTime || pCTime)
               if (!SetFileTime(hDst, pCTime, 0, pMTime))
                  { perr("... set filetime failed (2)\n"); berr=1; }

            CloseHandle(hDst);
         }

         if (!berr)
            cs.filesChg++; // fixfile
      }
      while (0);
   }
   else
   {
      cs.filesChg++; // fixfile
   }

   return 0;
}
#endif

// dmod file_conv
#if (sfk_prog || sfk_file_conv)

int ispuretext(char *psz, char ccurdelim, char coutdelim, char cquote)
{
   while (*psz)
   {
      char c = *psz++;
      if (c == ccurdelim)
         return 1;
      if (c == coutdelim)
         return 0;
      if (c == cquote)
         return 0;
   }

   return 1;
}

int ispurenum(char *psz, char ccurdelim, char coutdelim)
{
   /*
      +123.456e+10
      -234.387e3
      -234,387e-3
   */

   if (*psz=='+' || *psz=='-')
      psz++;

   int istate = 1;

   while (*psz != 0 && *psz != ccurdelim)
   {
      char c = *psz++;

      if (c == coutdelim)
         return 0;

      switch (istate)
      {
         case 1: // expect just digit
            if (isdigit(c)) {
               istate = 2;
               continue;
            }
            return 0;

         case 2: // expect digit . , e
            if (isdigit(c))
               continue;
            if (c == '.' || c == ',')
               continue;
            if (tolower(c) == 'e') {
               istate = 3;
               continue;
            }
            return 0;

         case 3: // after e: expect + - digit
            if (c == '+' || c == '-') {
               istate = 4;
               continue;
            }
         case 4:
            if (isdigit(c))
               continue;
            return 0;
      }
   }

   return 1;
}

int csvToTab(char *psrc, char *pdst, int imaxdst)
{
   char cdelim     = cs.cinsep;
   char ctab       = cs.coutsep;
   char cquote     = cs.cquote;
   char ctabescape = cs.coutsepesc;

   /*
      5324,John Smith,Los Angeles
      7936,"James Foo, Dr.",Atlanta
      3297,"Jack ""Goo"" Bar",San Diego
      5239,,Nowhere
      5240,Empty{TAB}City,
   */

   char *pSrcCur = psrc;
   char *pSrcMax = psrc + strlen(psrc);
   char *pDstCur = pdst;
   char *pDstMax = pdst + (imaxdst - 20);

   int istate   = 0;
   int binquote = 0;

   while (pSrcCur < pSrcMax && pDstCur < pDstMax)
   {
      char c  = *pSrcCur++;
      char c2 = *pSrcCur;  // NULL if at end

      switch (istate)
      {
         case 0:  // expect quote, start of data, delimiter
            if (c == cquote) {
               binquote = 1;
               istate = 1;
               continue;
            }
            if (c == cdelim) {
               *pDstCur++ = ctab;
               continue;
            }
            istate = 1;
            // fall through

         case 1:  // expect data byte, escaped quote, delimiter, EOR
            if (c == cquote && c2 == cquote) {
               *pDstCur++ = cquote;
               pSrcCur++;
               continue;
            }
            if (binquote == 0 && c == cdelim) {
               *pDstCur++ = ctab;
               istate = 0;
               continue;
            }
            if (binquote == 1 && c == cquote) {
               // delimiter or EOR must be next
               binquote = 0;
               continue;
            }
            if (c == ctab) {
               // remove tabs from input
               c = ctabescape;
            }
            *pDstCur++ = c;
            continue;
      }
   }

   if (pSrcCur >= pSrcMax)
   {
      // end of record checks
      if (pDstCur >= pDstMax)
         return 10;

      switch (istate)
      {
         case 0:  // expect quote, data, delimiter
            *pDstCur++ = '\0';
            return 0;

         case 1:  // expect data byte, escaped quote, delimiter, EOR
            if (binquote)
               return 11;
            *pDstCur++ = '\0';
            return 0;
      }
   }

   return 12;
}

int tabToCsv(char *psrc, char *pdst, int imaxdst)
{
   char ctab       = cs.cinsep;
   char cdelim     = cs.coutsep;
   char cquote     = cs.cquote;
   bool bquotetext = cs.quotetext;
   bool bfullquote = cs.quoteall;

   char *pSrcCur = psrc;
   char *pSrcMax = psrc + strlen(psrc);
   char *pDstCur = pdst;
   char *pDstMax = pdst + (imaxdst - 20);

   int istate   = 0;
   int binquote = 0;
   int boutquoteopen = 0;

   while (pSrcCur < pSrcMax && pDstCur < pDstMax)
   {
      char c  = *pSrcCur++;
      char c2 = *pSrcCur;  // NULL if at end

      switch (istate)
      {
         case 0:  // expect start of data, tab, quote-to-escape
            if (c == ctab) {
               if (bfullquote) {
                  *pDstCur++ = cquote;
                  *pDstCur++ = cquote;
               }
               *pDstCur++ = cdelim;
               continue;
            }
            // start of data, quote-to-escape
            if (   bfullquote == 1
                || (bquotetext && !ispurenum(pSrcCur-1, ctab, cdelim))
                || (!ispuretext(pSrcCur-1, ctab, cdelim, cquote))
               )
            {
               *pDstCur++ = cquote;
               boutquoteopen = 1;
            }
            istate = 1;
            // fall through

         case 1:  // expect tab, data byte, quote-to-escape
            if (c == ctab) {
               if (boutquoteopen)
                  *pDstCur++ = cquote;
               *pDstCur++ = cdelim;
               boutquoteopen = 0;
               istate = 0;
               // tab at end of record?
               if (pSrcCur >= pSrcMax) {
                  // then it means a trailing empty field
                  if (bfullquote) {
                     *pDstCur++ = cquote;
                     *pDstCur++ = cquote;
                  }
                  // but without extra separator
               }
               continue;
            }
            if (c == cquote) {
               // escape quote
               *pDstCur++ = cquote;
               *pDstCur++ = cquote;
               continue;
            }
            // continue data
            *pDstCur++ = c;
            continue;
      }
   }

   if (pSrcCur >= pSrcMax)
   {
      // end of record checks
      if (pDstCur >= pDstMax)
         return 10;

      switch (istate)
      {
         case 0:  // expect start of data, tab
            *pDstCur++ = '\0';
            return 0;

         case 1:  // expect tab, data byte
            if (boutquoteopen)
               *pDstCur++ = cquote;
            *pDstCur++ = '\0';
            return 0;
      }
   }

   return 12;
}

int execCsvConv(bool bToCsv, Coi *pcoi, FILE *fin, StringPipe *pInData, int nMaxLines, char *pszOutFile)
{
   FILE *fout = 0;

   // INPUT FILE CLOSES AUTOMATICALLY.
   FileCloser fcin(pcoi); // does nothing if pcoi == NULL

   if (pcoi)
   {
      if (pcoi->open("rb"))
         return 9+pferr(pcoi->name(), "cannot read: %s %s\n", pcoi->name(),pcoi->lasterr());
   }

   if (pszOutFile)
      if (!(fout = fopen(pszOutFile, "w")))
         return 10+perr("cannot write: %s\n", pszOutFile);

   int nMaxLineLen = sizeof(szLineBuf)-10;
   int ncheckcnt   = 0;
   int lRC         = 0;
   int nLine       = 0;

   myfgets_init();
   while (1)
   {
      // --- get next line to linebuf ---

      memset(szAttrBuf, ' ', MAX_LINE_LEN-10);
      szAttrBuf[MAX_LINE_LEN-10] = '\0';

      int nRead = 0;

      if (pInData) {
         if (pInData->eod())
            break;
         char *pattr = 0;
         char *psz = pInData->read(&pattr);
         mystrcopy(szLineBuf, psz, MAX_LINE_LEN);
         strcat(szLineBuf, "\n"); // force LF
         int nlen = strlen(szLineBuf);
         if (pattr) {
            mystrcopy(szAttrBuf, pattr, MAX_LINE_LEN);
            if ((int)strlen(szAttrBuf) < nlen-1) {
               memset(szAttrBuf, ' ', nlen);
               szAttrBuf[nlen] = '\0';
            }
         }
         nRead = nlen;
      } else if (pcoi) { // native or virtual file
         nRead = pcoi->readLine(szLineBuf, nMaxLineLen);
      } else if (fin)  { // probably stdin
         nRead = myfgets(szLineBuf, nMaxLineLen, fin, 0, szAttrBuf);
      }
      if (!nRead)
         break; // EOD

      if ((++ncheckcnt > 100000) && ((ncheckcnt & 65535)==0))
         if (userInterrupt())   // costs a bit of time
            {  lRC=9; break;  } // stop by escape

      szLineBuf[nRead] = '\0';
      szAttrBuf[nRead] = '\0';
      nLine++;
      removeCRLF(szLineBuf);

      // --- process line ---
      int isubrc = 0;
      if (bToCsv == 0)
         isubrc = csvToTab(szLineBuf, szLineBuf2, MAX_LINE_LEN);
      else
         isubrc = tabToCsv(szLineBuf, szLineBuf2, MAX_LINE_LEN);
      if (isubrc) {
         if (!cs.nowarn)
            pwarn("input line %d wrong format (%d): %s", nLine, isubrc, szLineBuf);
         snprintf(szLineBuf2, MAX_LINE_LEN, "[warning:%d]\t%s", isubrc, szLineBuf);
      }

      // -- write to output ---
      if (fout)
         fprintf(fout, "%s\n", szLineBuf2);
      else
      if (chain.coldata)
         chain.addLine(szLineBuf2, str(""));
      else
         printf("%s\n", szLineBuf2);
   }

   if (fout)
      fclose(fout);

   return lRC;
}

extern uint nGlblConvTarget;
extern uint aGlblConvStat[10];

int execFormConv(char *pszFile, char *pszOutFile)
{__
   bool bHaveOut = (pszOutFile != 0);
   if (!bHaveOut) pszOutFile = pszFile;

   num nFileSize = 0;
   char *pInFile = (char*)loadBinaryFile(pszFile, nFileSize);
   if (!pInFile) return 9;

   CharAutoDel odel(pInFile);

   // SFK 1.7.2: make sure no binary is truncated
   if (cs.textfiles) {
      if (memchr(pInFile, '\0', nFileSize)) {
         if (cs.verbose)
            printx("$skip <def> %s - binary\n", pszFile);
         return 0;
      }
   }

   bool bAny    = 0;
   bool berr    = 0;
   bool bshowle = (nGlblConvTarget & eConvFormat_ShowLE) ? 1 : 0;
   int ipasses  = bshowle ? 1 : 2;

   FILE *fOut = 0;

   uchar abCRLF[] = { 0xD, 0xA };

   int  icr=0, ilf=0, icrlf=0, iut=0;

   for (int ipass=0; ipass<ipasses && berr==0; ipass++)
   {
      char *pszSrcCur = pInFile;
      char *pszSrcMax = pszSrcCur + nFileSize;
      char *pszLine   = pszSrcCur;
      char *pszEOL    = 0;
      int   iLineLen  = 0;
      int   iEOLLen   = 0;
      uchar abEOL[10];
      char  c = 0;

      if (ipass)
      {
         if (!cs.writeall && !bAny) {
            if (cs.verbose)
               printx("$skip <def> %s - nothing to change\n", pszFile);
            return 0; // nothing to do
         }

         cs.files++;

         // write output file:
         //   if different output is specified, also create directory structure.
         if (bHaveOut) {
            if (createOutDirTree(pszOutFile))
               return 9;
            if (!cs.quiet) info.setStatus(cs.curcmd, pszOutFile);
         } else {
            if (!cs.quiet) info.setStatus(cs.curcmd, pszFile);
         }

         if (!cs.sim) {
            fOut = fopen(pszOutFile, "wb");
            if (!fOut) {
               delete [] pInFile;
               return 9+perr("cannot %swrite %s\n", bHaveOut?"":"over", pszOutFile);
            }
         }
      }

      while (pszSrcCur <= pszSrcMax)
      {
         if (pszSrcCur < pszSrcMax) {
            c = *pszSrcCur++;
         } else {
            // end of data
            if (pszLine == pszSrcCur)
               break;
            // line without (CR)LF exists
            c = '\0';
            iut++;
         }

         if (c == '\r' || c == '\n' || c == '\0')
         {
            // line end reached
            iEOLLen = 0;
            if (c) {
               pszEOL  = pszSrcCur-1;
               iEOLLen = 1;
            } else {
               pszEOL  = pszSrcCur;
               iEOLLen = 0;
            }

            if (c == '\r') {
               // eol by CR or CRLF
               if (*pszSrcCur == '\n') {
                  pszSrcCur++;
                  iEOLLen = 2;
                  icrlf++;
               } else {
                  icr++;
               }
            }
            else if (c == '\n') {
               ilf++;
            }

            iLineLen = pszEOL - pszLine;

            if (fOut)
            {
               // write line content
               if ((int)myfwrite((uchar*)pszLine, iLineLen, fOut) != iLineLen)
                  {  berr=1; break; }

               // write new line ending
               if (iEOLLen == 0 && cs.forcele == 0) {
                  // last line has no LF and should be kept as is
               }
               else
               if (nGlblConvTarget & eConvFormat_LF) {
                  if (fOut)
                     if (myfwrite(&abCRLF[1], 1, fOut) != 1)
                        {  berr=1; break; }
               }
               else
               if (nGlblConvTarget & eConvFormat_CRLF) {
                  if (fOut)
                     if (myfwrite(&abCRLF[0], 2, fOut) != 2)
                        {  berr=1; break; }
               }
            }
            else if (ipass == 0)
            {
               // check for differences
               abEOL[0] = '\0';
               abEOL[1] = '\0';

               if (iEOLLen == 0 && cs.forcele == 0) {
                  // last line has no LF and should be kept as is
               }
               else
               {
                  if (iEOLLen)
                     memcpy(abEOL, pszEOL, iEOLLen);
 
                  if (nGlblConvTarget & eConvFormat_LF) {
                     if (abEOL[0] != '\n')
                        bAny = 1;
                  }
                  else
                  if (nGlblConvTarget & eConvFormat_CRLF) {
                     if (memcmp(abEOL, "\r\n", 2))
                        bAny = 1;
                  }
               }
            }

            pszLine = pszSrcCur;
         }
 
         // else step over line content

      }  // endfor text

   }  // endfor pass

   if (fOut)
      fclose(fOut);

   if (bshowle) {
      printx("$%s %s %s %s<def> %s\n",
         icrlf ? "crlf" : "----",
         ilf   ? "lf"   : "--",
         iut   ? "ut"   : "--",
         icr   ? "cr"   : "--",
         pszFile
         );
      if (icrlf) aGlblConvStat[0]++;
      if (ilf  ) aGlblConvStat[1]++;
      if (iut  ) aGlblConvStat[2]++;
      if (icr  ) aGlblConvStat[3]++;
   }
   else if (!cs.quiet) {
      info.printLine(1<<2);
   }

   if (berr)
      return 9+esys("fwrite", "failed to write %s   \n", pszOutFile);

   return 0;
}

// emod
#endif // (sfk_prog || sfk_file_conv)

#ifndef USE_SFK_BASE

static unsigned char webdemo_abRawBlock[1358] = {
80,75,3,4,10,0,0,0,0,0,170,162,60,73,0,0,0,0,0,0,0,0,0,0,0,0,8,0,17,0,119,101,
98,100,101,109,111,47,85,84,13,0,7,32,10,236,87,224,235,234,87,250,181,236,87,80,75,3,4,20,0,0,0,8,
0,170,162,60,73,168,198,156,182,122,0,0,0,144,0,0,0,18,0,17,0,119,101,98,100,101,109,111,47,105,110,100,
101,120,46,104,116,109,108,85,84,13,0,7,32,10,236,87,224,235,234,87,19,182,236,87,53,142,193,10,194,48,16,68,
239,133,254,195,208,15,104,193,115,92,16,61,42,8,30,244,154,198,173,27,76,154,146,236,65,255,222,84,232,101,46,243,
120,51,70,52,6,50,99,122,126,169,109,140,236,232,230,227,18,24,119,30,113,112,142,75,193,137,99,194,213,190,216,12,
181,175,212,178,134,133,100,158,246,157,75,179,242,172,165,255,196,208,209,49,120,247,134,112,174,176,37,76,41,67,133,241,
184,156,177,129,8,190,104,191,105,134,255,116,53,175,63,218,230,7,80,75,3,4,20,0,0,0,8,0,170,162,60,73,
158,225,250,98,89,0,0,0,222,0,0,0,20,0,17,0,119,101,98,100,101,109,111,47,99,111,110,116,101,110,116,115,
46,120,109,108,85,84,13,0,7,32,10,236,87,224,235,234,87,27,182,236,87,179,41,202,47,47,182,227,229,82,176,73,
78,44,73,77,207,47,170,4,113,20,108,50,83,236,12,13,12,109,244,129,52,152,159,151,152,155,106,231,86,84,154,89,
82,108,163,15,230,128,244,232,35,107,194,102,130,17,154,9,97,169,233,169,37,137,73,57,169,36,153,98,140,102,138,83,
106,89,106,81,98,58,78,67,108,244,161,190,2,0,80,75,3,4,20,0,0,0,8,0,170,162,60,73,169,45,180,0,
91,0,0,0,13,1,0,0,28,0,17,0,119,101,98,100,101,109,111,47,112,114,111,100,117,99,116,95,108,105,115,116,
95,49,48,49,46,120,109,108,85,84,13,0,7,32,10,236,87,224,235,234,87,37,182,236,87,179,41,202,47,47,182,227,
229,82,80,80,176,1,50,237,108,242,18,115,83,237,28,11,10,114,82,139,109,244,193,28,176,36,24,216,20,20,101,38,
167,218,25,233,25,216,232,67,152,54,250,32,77,232,218,157,18,243,128,16,167,126,67,61,83,252,250,189,51,203,51,241,
232,54,199,175,219,189,40,177,0,159,227,141,209,181,131,105,80,32,0,0,80,75,3,4,20,0,0,0,8,0,170,162,
60,73,107,16,183,103,79,0,0,0,205,0,0,0,28,0,17,0,119,101,98,100,101,109,111,47,112,114,111,100,117,99,
116,95,108,105,115,116,95,49,48,50,46,120,109,108,85,84,13,0,7,32,10,236,87,224,235,234,87,39,182,236,87,179,
41,202,47,47,182,227,229,82,80,80,176,1,50,237,108,242,18,115,83,237,2,242,75,18,75,242,83,139,109,244,193,92,
176,52,24,216,20,20,101,38,167,218,25,234,25,217,232,67,152,54,250,32,109,232,6,56,165,38,230,225,209,109,129,95,
119,64,106,34,30,205,134,232,154,193,52,200,19,0,80,75,3,4,20,0,0,0,8,0,170,162,60,73,53,38,55,212,
83,0,0,0,208,0,0,0,28,0,17,0,119,101,98,100,101,109,111,47,112,114,111,100,117,99,116,95,108,105,115,116,
95,49,48,51,46,120,109,108,85,84,13,0,7,32,10,236,87,224,235,234,87,41,182,236,87,179,41,202,47,47,182,227,
229,82,80,80,176,1,50,237,108,242,18,115,83,237,194,19,75,82,139,108,244,193,108,176,28,24,216,20,20,101,38,167,
218,25,232,153,218,232,67,152,54,250,32,61,232,186,157,243,115,18,113,107,182,196,175,217,177,160,32,39,85,193,171,20,
168,2,183,25,230,232,102,128,105,144,63,0,80,75,1,2,23,11,10,0,0,0,0,0,170,162,60,73,0,0,0,0,
0,0,0,0,0,0,0,0,8,0,9,0,0,0,0,0,0,0,16,0,255,65,0,0,0,0,119,101,98,100,101,109,
111,47,85,84,5,0,7,32,10,236,87,80,75,1,2,23,11,20,0,0,0,8,0,170,162,60,73,168,198,156,182,122,
0,0,0,144,0,0,0,18,0,9,0,0,0,0,0,1,0,32,0,182,129,55,0,0,0,119,101,98,100,101,109,111,
47,105,110,100,101,120,46,104,116,109,108,85,84,5,0,7,32,10,236,87,80,75,1,2,23,11,20,0,0,0,8,0,
170,162,60,73,158,225,250,98,89,0,0,0,222,0,0,0,20,0,9,0,0,0,0,0,1,0,32,0,182,129,242,0,
0,0,119,101,98,100,101,109,111,47,99,111,110,116,101,110,116,115,46,120,109,108,85,84,5,0,7,32,10,236,87,80,
75,1,2,23,11,20,0,0,0,8,0,170,162,60,73,169,45,180,0,91,0,0,0,13,1,0,0,28,0,9,0,0,
0,0,0,1,0,32,0,182,129,142,1,0,0,119,101,98,100,101,109,111,47,112,114,111,100,117,99,116,95,108,105,115,
116,95,49,48,49,46,120,109,108,85,84,5,0,7,32,10,236,87,80,75,1,2,23,11,20,0,0,0,8,0,170,162,
60,73,107,16,183,103,79,0,0,0,205,0,0,0,28,0,9,0,0,0,0,0,1,0,32,0,182,129,52,2,0,0,
119,101,98,100,101,109,111,47,112,114,111,100,117,99,116,95,108,105,115,116,95,49,48,50,46,120,109,108,85,84,5,0,
7,32,10,236,87,80,75,1,2,23,11,20,0,0,0,8,0,170,162,60,73,53,38,55,212,83,0,0,0,208,0,0,
0,28,0,9,0,0,0,0,0,1,0,32,0,182,129,206,2,0,0,119,101,98,100,101,109,111,47,112,114,111,100,117,
99,116,95,108,105,115,116,95,49,48,51,46,120,109,108,85,84,5,0,7,32,10,236,87,80,75,5,6,0,0,0,0,
6,0,6,0,204,1,0,0,108,3,0,0,0,0,
};

#endif // USE_SFK_BASE

// dmod file_join
#if (sfk_prog || sfk_file_join)
char getYNAchar();

int getPartExtDigits(char *pszPartExt)
{
   if (strncmp(pszPartExt, ".part", 5))
      return 0;
 
   char *psz = pszPartExt + 5;
   int iDigits = 0;
   char c=0;
   while (c = *psz++)
   {
      if (!isdigit(c))
         return 0+perr("non-digit character '%c' is not allowed\n", c);
      iDigits++;
   }
 
   return iDigits;
}

int execJoin(char *pszFirstInput, char *pszDst, bool bTest, char *pszMD5Write)
{__
   char szAddInfo[200];

   int nWorkMB = 100;
   num nWorkBufSize = nWorkMB * 1000000;
   uchar *pWorkBuf = new uchar[nWorkBufSize+1000];
   if (!pWorkBuf) return 9+perr("out of memory, cannot allocate working buffer.\n");

   // NO RETURN W/O DELETE FROM HERE

   int   nChainFiles = chain.numberOfInFiles();
   int   ifile = 0;
   char *pszBaseName = 0;
   char *pszPartExt = 0;
   int   iDigits = 0;
   char *pszSrc = 0;

   if (nChainFiles > 0)
   {
      pszFirstInput = chain.getFile(ifile)->name();
      strcopy(szLineBuf, pszFirstInput);
   }
   else
   {
      // x.part1
      strcopy(szLineBuf, pszFirstInput);
      pszBaseName = szLineBuf;
      pszPartExt  = strrchr(szLineBuf, '.');
      iDigits = getPartExtDigits(pszPartExt);
      if (!pszPartExt || !iDigits) {
         delete [] pWorkBuf;
         return 9+perr("expecting input filename ending like .part1, .part001 etc.\n");
      }
   }

   // check if first input exists
   if (!fileExists(szLineBuf))
      return 9+perr("first input file not found: %s\n", szLineBuf);

   // cut ".part1" in szLineBuf
   if (pszPartExt) {
      *pszPartExt = '\0';
      // and use this as output filename
      if (!pszDst)
         pszDst = szLineBuf;
   }

   FILE *fout = 0;

   if (!bTest)
   {
      if (fileExists(pszDst) && !cs.force && !cs.yes)
         while (1) {
            printf("%s output file exists, overwrite? (y/n) ",pszDst);
            fflush(stdout);
            char nReply = getYNAchar();
            if (nReply == 'y') break;
            if (nReply == 'n') { delete [] pWorkBuf; return 5; }
            // printf("\n");
         }
 
      fout = fopen(pszDst, "wb");
      if (!fout) {
         delete [] pWorkBuf;
         return 9+perr("cannot write output file: %s\n",pszDst);
      }
   }

   num ntotal = 0;
   SFKMD5 md5;

   int nin = 1;
   bool bbail = 0;
   while (!bbail)
   {
      if (nChainFiles > 0) {
         if (ifile >= nChainFiles)
            break;
         pszSrc = chain.getFile(ifile)->name();
         ifile++;
      } else {
         sprintf(szLineBuf2, "%s.part%0*d", pszBaseName, iDigits, nin);
         pszSrc = szLineBuf2;
      }
 
      // internal check: first part's name must be the same as input
      if ((nin == 1) && strcmp(pszSrc, pszFirstInput))
         perr("int. error while building name: %s\n", pszSrc);

      FILE *fpart = fopen(pszSrc, "rb");
      if (!fpart)
         break;   // (probably) all done

      if (cs.debug)
         info.print("open.read: %s\n", pszSrc);

      nin++;

      while (!bbail)
      {
         num nTotalMB = ntotal / 1000000;

         if (pszMD5Write)
         {
            // printf("verifying part %d, %s mb done [Esc to skip] \r", nin-1, numtoa(nTotalMB));
            // fflush(stdout);
            sprintf(szAddInfo, "%s mb [Esc to skip]", numtoa(nTotalMB));
            info.setStatus("verfy", pszSrc, szAddInfo);
            if (userInterrupt(1)) {
               info.print("verify skipped.\n");
               fclose(fpart);
               bbail = 1;
               break;
            }
         }
         else
         {
            // printf("reading part %d, %s mb done \r", nin-1, numtoa(nTotalMB));
            // fflush(stdout);
            sprintf(szAddInfo, "%s mb", numtoa(nTotalMB));
            info.setStatus("read ", pszSrc, szAddInfo);
         }

         int nread = myfread(pWorkBuf, nWorkBufSize, fpart);

         if (cs.debug)
            info.print("read.blck: %d maxbuf=%d\n", nread, (int)nWorkBufSize);

         if (nread <= 0)
            break; // EOD

         if (!bTest)
         {
            int nwrite = myfwrite(pWorkBuf, nread, fout);

            if (cs.debug)
               info.print("writ.blck: %d\n", nwrite);

            if (nwrite != nread) {
               delete [] pWorkBuf;
               fclose(fout); fclose(fpart);
               remove(pszDst); // cleanup incomplete output
               return 9+esys("fwrite", "failed to write %s   \n", pszDst);
            }
         }

         md5.update(pWorkBuf, nread);

         ntotal += nread;
      }

      if (cs.debug)
         info.print("clos.read: %s totalDone=%d\n", pszSrc, (int)ntotal);

      fclose(fpart);
   }
 
   if (!bTest)
      fclose(fout);

   delete [] pWorkBuf;

   // NO RETURN W/O DELETE UNTIL HERE

   info.clear();

   if (bbail)
      return 0;

   if (bTest) {
      if (!pszMD5Write)
         printf("tested join of %d files, %s total bytes.\n", nin-1, numtoa(ntotal));
   } else {
      printf("%s created from %d files, %s total bytes.\n", pszDst, nin-1, numtoa(ntotal));
   }

   char szMD5Read[100];

   uchar *pmd5 = md5.digest();
   for (int i=0; i<16; i++)
      sprintf(&szMD5Read[i*2], "%02x", pmd5[i]);
   printf("md5 = %s   %s ", szMD5Read, pszMD5Write ? "[verify]" : "");

   if (pszMD5Write) {
      if (strcmp(pszMD5Write, szMD5Read)) {
         printf("\n");
         return 9+perr("checksum mismatch - re-read of output files failed.\n");
      }
      else
         printf("- OK\n");
   }
   else
      printf("\n");

   return 0;
}
// emod file_join
#endif // (sfk_prog || sfk_file_join)

// dmod file_copy
#if (sfk_prog || sfk_file_copy)
void ab8ToNum(uchar *pin, num &rn1) {
    num n1 =  (num)(*(pin+0)) & 0xFFUL;
    n1 = (n1 << 8) | ((num)(*(pin+1)) & 0xFFUL);
    n1 = (n1 << 8) | ((num)(*(pin+2)) & 0xFFUL);
    n1 = (n1 << 8) | ((num)(*(pin+3)) & 0xFFUL);
    n1 = (n1 << 8) | ((num)(*(pin+4)) & 0xFFUL);
    n1 = (n1 << 8) | ((num)(*(pin+5)) & 0xFFUL);
    n1 = (n1 << 8) | ((num)(*(pin+6)) & 0xFFUL);
    n1 = (n1 << 8) | ((num)(*(pin+7)) & 0xFFUL);
    rn1 = n1;
}

uint ab4toulong(uchar *pin) {
    uint n1 = (uint)(*(pin+0)) & 0xFFUL;
    n1 = (n1 << 8) | ((uint)(*(pin+1)) & 0xFFUL);
    n1 = (n1 << 8) | ((uint)(*(pin+2)) & 0xFFUL);
    n1 = (n1 << 8) | ((uint)(*(pin+3)) & 0xFFUL);
    return n1;
}

void ab16ToNum(uchar *pin, num &rn1, num &rn2) {
    ab8ToNum(pin+0, rn1);
    ab8ToNum(pin+8, rn2);
}

void numToAb8(num n1, uchar *pout) {
   pout[7]  = (uchar)n1;
   n1 = (n1 >> 8); pout[6] = (uchar)n1;
   n1 = (n1 >> 8); pout[5] = (uchar)n1;
   n1 = (n1 >> 8); pout[4] = (uchar)n1;
   n1 = (n1 >> 8); pout[3] = (uchar)n1;
   n1 = (n1 >> 8); pout[2] = (uchar)n1;
   n1 = (n1 >> 8); pout[1] = (uchar)n1;
   n1 = (n1 >> 8); pout[0] = (uchar)n1;
}

void ulongtoab4(uint n1, uchar *pout) {
   pout[3]  = (uchar)n1;
   n1 = (n1 >> 8); pout[2] = (uchar)n1;
   n1 = (n1 >> 8); pout[1] = (uchar)n1;
   n1 = (n1 >> 8); pout[0] = (uchar)n1;
}

void numToAb16(num n1, num n2, uchar *pout) {
   numToAb8(n1, pout+0);
   numToAb8(n2, pout+8);
}

char *FileMetaDB::pszClFileDBHead = (char*)"SFKSIG10";

FileMetaDB filedb;

FileMetaDB::FileMetaDB()
{
   pszClDBPath    = 0;
   pszClDBFile    = 0;
   pszClLineBuf   = 0;
   pszClMetaDir   = 0;
   nClMode        = 0;
   nClVerified    = 0;
   nClVerMissing  = 0;
   nClVerFailed   = 0;
}

int FileMetaDB::setMetaDir(char *psz)
{
   if (pszClMetaDir) delete [] pszClMetaDir;
   pszClMetaDir = strdup(psz);
   return 0;
}

bool FileMetaDB::isSignatureFile(char *pszBase)
{
   if (!pszClLineBuf)
      if (!(pszClLineBuf = new char[MAX_LINE_LEN+100]))
         { perr("outofmem.1\n"); return 0; }

   bool bChecked = 0;

   int i=0;
   for (i=1; i<=3 && !bChecked; i++)
   {
      SFKMD5 md5; // re-init per loop

      sprintf(pszClLineBuf, "%s-%02d.dat", pszBase, i);

      FILE *fin = fopen(pszClLineBuf, "rb");
      if (!fin) return 0;
 
      uchar abin[20];
      char *pszHead = pszClFileDBHead;
      int nread = fread(abin, 1, 8, fin);
      if (nread < 8) { fclose(fin); return 1; } // EOD
      abin[8] = '\0';
      if (!strcmp((char*)abin, pszHead))
         bChecked = 1;
 
      fclose(fin);
   }

   return bChecked;
}

int FileMetaDB::indexOf(char *pszInFile)
{
   int nEntries = aUnixTime.numberOfEntries();
   for (int i=0; i<nEntries; i++)
   {
      char *pszRefFile = aPath.getEntry(i, __LINE__);
      if (!strcmp(pszInFile, pszRefFile))
      {
         return i;
      }
   }
   return -1;
}

int FileMetaDB::loadDB(char *pszBase, bool bVerbose)
{
   if (pszClDBPath) { delete [] pszClDBPath; pszClDBPath=0; }
   pszClDBPath = strdup(pszBase);

   if (pszClDBFile) { delete [] pszClDBFile; pszClDBFile=0; }
   pszClDBFile = new char[strlen(pszClDBPath)+100];

   bool bChecked = 0;
   int nSigRes  = 0;

   // pass 1: check several sign files until a functional one is found
   int i=0;
   for (i=1; i<=3 && !bChecked; i++)
   {
      SFKMD5 md5; // re-init per loop

      sprintf(pszClDBFile, "%s-%02d.dat", pszClDBPath, i);

      // if (i > 1)
      //   pwarn("retrying on signature db: %s\n", pszClDBFile);

      if (fileExists(pszClDBFile))
      {
         // printf("load %s\n", pszClDBFile);

         FILE *fin = fopen(pszClDBFile, "rb");
         if (!fin)
            nSigRes = 3;
         else
         if (!loadHeader(fin, &md5))
         for (int nrec=1; ;nrec++)
         {
            int nrc = loadRecord(fin, &md5, 1); // uses szLineBuf
            // printf("   rec %d loaded, rc %d\n", nrec, nrc);
            if (nrc == 1)
               break; // EOD
            if (bChecked) {
               perr("unexpected record data at end of %s\n", pszClDBFile);
               break;
            }
            if (nrc == 2) {
               if (!(nSigRes = loadCheckEpilogue(fin, &md5)))
                  bChecked = 1;
            }
            if (nrc > 2) {
               perr("error while reading %s: wrong content format (%d)\n", pszClDBFile, nrc);
               break;
            }
         }

         fclose(fin);
      } else {
         nSigRes = 3;
      }

      if (!bChecked) {
         if (nSigRes == 3) {
            if (bVerbose)
               printf("signature db not found: %s\n", pszClDBFile);
         }
         else
         if (i < 3) {
            if (nSigRes == 2)
               pwarn("signature db modified: %s - retrying on copy\n", pszClDBFile);
            else
               pwarn("invalid signature db: %s - retrying on copy\n", pszClDBFile);
         } else {
            perr("all signature databases unreadable or modified.\n", pszClDBFile);
         }
      }
   }

   // pass 2: load the first functional file
   if (!bChecked) {
      return 9; // +perr("cannot find a valid signature database.");
   }
   else
   {
      // pszClDBFile is still the valid name
      FILE *fin = fopen(pszClDBFile, "rb");
      if (!fin) return 9+pferr(pszClDBFile, "cannot read: %s\n", pszClDBFile);

      SFKMD5 md5;

      if (!loadHeader(fin, &md5))
      while (1) {
         int nrc = loadRecord(fin, &md5, 0); // uses szLineBuf
         if (nrc == 1)
            break; // EOD
         if (nrc == 2) {
            if (loadCheckEpilogue(fin, &md5))
               { fclose(fin); return 9+perr("internal #11571940"); }
         }
         if (nrc > 2) {
            perr("error while reading %s: wrong content format\n", pszClDBFile);
            break;
         }
      }

      fclose(fin);
   }

   return 0;
}

int FileMetaDB::openUpdate(char *pszBase)
{__
   loadDB(pszBase, 0);
   // ignore rc

   nClMode = 2;

   return 0;
}

int FileMetaDB::openRead(char *pszBase, bool bVerbose)
{__
   if (loadDB(pszBase, bVerbose))
      return 9;

   nClMode = 1;

   return 0;
}

int FileMetaDB::verifyFile(char *pszName, char *pszShadow, bool bSilentAttribs)
{
   char *relName(char *pszRoot, char *pszAbs);
   char *pszRelName = pszName;

   if (pszGlblCopySrc)
      pszRelName = relName(pszGlblCopySrc, pszName);

   int nind = indexOf(pszRelName);
   if (nind < 0) {
      nClVerMissing++;
      return 8;   // not found
   }

   // get archived metadata
   num nUnixTime2  = aUnixTime.getEntry(nind, __LINE__);
   // num nWinTime2   = aWinTime.getEntry(nind, __LINE__);
   num nContSumLo2 = aContSumLo.getEntry(nind, __LINE__);
   num nContSumHi2 = aContSumHi.getEntry(nind, __LINE__);

   // build current metadata
   FileStat ofs;
   ofs.readFrom(pszName, 0, bSilentAttribs);
   num nUnixTime = ofs.getUnixTime();
   // num nWinTime  = ofs.getWinTime();
   num ncontlo, nconthi;
   uchar abContSum[20];
   if (getFileMD5(pszName, abContSum)) {
      perr("no such file: %s - cannot read checksum\n", pszName);
      return 9;
   }
   ab16ToNum(abContSum, ncontlo, nconthi);

   // let's expect that time is the same, all that matters is
   // if the content was tampered during transport:
   if (ncontlo != nContSumLo2 || nconthi != nContSumHi2)
   {
      nClVerFailed++;

      if (pszShadow && fileExists(pszShadow))
      {
         // try fallback to shadow file
         if (getFileMD5(pszShadow, abContSum)) {
            perr("no such file: %s - cannot read shadow file\n", pszShadow);
            return 9;
         }
         ab16ToNum(abContSum, ncontlo, nconthi);
         if (ncontlo == nContSumLo2 && nconthi == nContSumHi2)
            return 5;   // fallback to shadow is possible
      }

      return 9;
   }

   nClVerified++;

   if (nUnixTime != nUnixTime2)  return 1; // informal

   return 0;
}

int FileMetaDB::verifyFile(int nind, bool bCleanup)
{
   // if anything fails with this record, skip it on cleanup
   aFlags.updateEntry(0, nind); // no save by default

   // get archived metadata
   char *pszRelName = aPath.getEntry(nind, __LINE__);
   if (!pszRelName) return 9+perr("unexpected filedb entry at record %d\n", nind);

   num nUnixTime2  = aUnixTime.getEntry(nind, __LINE__);
   // num nWinTime2   = aWinTime.getEntry(nind, __LINE__);
   num nContSumLo2 = aContSumLo.getEntry(nind, __LINE__);
   num nContSumHi2 = aContSumHi.getEntry(nind, __LINE__);

   // create absolute filename
   if (!pszGlblCopySrc) return 9+perr("internal #0605071204");
   joinPath(szRefNameBuf, sizeof(szRefNameBuf)-10, pszGlblCopySrc, pszRelName);
   char *pszName = szRefNameBuf;

   joinShadowPath(szRefNameBuf2, sizeof(szRefNameBuf2)-10, pszGlblCopySrc, pszRelName);
   char *pszShadow = szRefNameBuf2;

   // show detailed info
   char szAddInfo[200];
   int nVerOK     = filedb.numberOfVerifies();
   int nVerFailed = filedb.numberOfVerFailed();
   if (nVerFailed > 0)
      sprintf(szAddInfo, "%u files ok, %d failed, %u mb %u kbs", nVerOK, nVerFailed, (uint)(cs.totalbytes/1000000UL), currentKBPerSec());
   else
      sprintf(szAddInfo, "%u files %u mb %u kbs", nVerOK, (uint)(cs.totalbytes/1000000UL), currentKBPerSec());
   info.setProgress(numberOfFiles(), nind, "files");
   info.setStatus("verfy", pszName, szAddInfo, eKeepProg);

   // build current metadata
   FileStat ofs;
   if (ofs.readFrom(pszName)) {
      nClVerMissing++;
      return 9+perr("file not found: %s\n", pszName);
   }
   num nUnixTime = ofs.getUnixTime();
   num nWinTime  = ofs.getWinTime();
   num ncontlo, nconthi;
   uchar abContSum[20];
   if (getFileMD5(pszName, abContSum)) {
      perr("no such file: %s - cannot read checksum\n", pszName);
      nClVerMissing++;
      return 9;
   }
   ab16ToNum(abContSum, ncontlo, nconthi);

   // check if the content was tampered during transport:
   if (ncontlo != nContSumLo2 || nconthi != nContSumHi2)
   {
      // primary file content corrupted
      nClVerFailed++;

      if (bCleanup) {
         setTextColor(nGlblErrColor);
         oprintf("DEL: %s - was modified, please resync\n", pszName);
         if (remove(pszName)) {
            if (setWriteEnabled(pszName))
               perr("cannot delete: %s\n", pszName);
            else
            if (remove(pszName))
               perr("cannot delete: %s\n", pszName);
         }
         setTextColor(-1);
         return 9;
      }

      if (pszShadow && fileExists(pszShadow))
      {
         // try fallback to shadow file
         if (getFileMD5(pszShadow, abContSum)) {
            perr("content modified  : %s\n", pszName);
            perr("cannot read shadow: %s\n", pszShadow);
            return 9;
         }

         ab16ToNum(abContSum, ncontlo, nconthi);

         if (ncontlo == nContSumLo2 && nconthi == nContSumHi2)
         {
            cs.shadowFallbacks++;
            pwarn("content modified: %s\n", pszName);
            pwarn("shadow file ok  : %s\n", pszShadow);
            return 5;   // fallback to shadow is possible
         }

         perr("content modified: %s\n", pszName);
         perr("shadow modified : %s\n", pszShadow);

         return 9;
      }

      perr("content modified: %s\n", pszName);

      return 9;
   }

   // produce only notic if time mismatches:
   if (nUnixTime != nUnixTime2)
   {
      num nTimeDiff = nUnixTime - nUnixTime2;
      if (nTimeDiff < -5 || nTimeDiff > 5)
      {
         pinf("time difference (%s sec), content ok: %s\n", numtoa(nTimeDiff), pszName);
         // in case cleanup is done: update with current times
         aUnixTime.updateEntry(nUnixTime, nind);
         if (nWinTime != 0)
            aWinTime.updateEntry(nWinTime, nind);
      }
      // else ignore: up to 5 sec time diff happens between file systems
   }

   nClVerified++;

   // record confirmed, keep it in case of cleanup.
   aFlags.updateEntry(1, nind);

   return 0;
}

int FileMetaDB::updateFile(char *pszName, uchar *pmd5cont, bool bJustKeep)
{
   // printf("updateFile %s, %02X%02X%02X%02X\n", pszName, *(pmd5cont+0),*(pmd5cont+1),*(pmd5cont+2),*(pmd5cont+3));

   char *relName(char *pszRoot, char *pszAbs);

   // printf("updatefile: %s\n", pszName);

   FileStat ofs;
   ofs.readFrom(pszName);

   num nUnixTime = ofs.getUnixTime();
   num nWinTime  = ofs.getWinTime();

   // strip x:\the\foo\bar.txt to the\foo\bar.txt
   char *pszRelName = relName(pszGlblCopySrc, pszName);

   int nind = indexOf(pszRelName);
   if (nind >= 0)
   {
      // we have this filename in the db.
      if (bJustKeep) {
         // unconditionally keep the entry of a non-synced file
         // e.g. on copy: target is newer than source (no copy)
         // if (aUnixTime.getEntry(nind, __LINE__) == nUnixTime) {
         aFlags.updateEntry(1, nind); // store file entry again
         return 0;
         // }
      }

      // update metadata:
      aUnixTime.updateEntry(nUnixTime, nind);
      aWinTime.updateEntry(nWinTime, nind);

      // update content checksum
      num ncontlo, nconthi;
      uchar abContSum[20];
      // take supplied content md5, or build now
      if (pmd5cont != 0)
         memcpy(abContSum, pmd5cont, 16);
      else
         if (getFileMD5(pszName, abContSum)) return 9;
      ab16ToNum(abContSum, ncontlo, nconthi);
      aContSumLo.updateEntry(ncontlo, nind);
      aContSumHi.updateEntry(nconthi, nind);

      // mark this record as updated, for save:
      aFlags.updateEntry(2, nind);
   }
   else
   {
      // not yet in the db
      if (aUnixTime.addEntry(nUnixTime))  return 9;
      if (aWinTime.addEntry(nWinTime))    return 9;

      // add content checksum
      num ncontlo, nconthi;
      uchar abContSum[20];
      // take supplied content md5, or build now
      if (pmd5cont != 0)
         memcpy(abContSum, pmd5cont, 16);
      else
         if (getFileMD5(pszName, abContSum)) return 9;
      ab16ToNum(abContSum, ncontlo, nconthi);
      if (aContSumLo.addEntry(ncontlo))   return 9;
      if (aContSumHi.addEntry(nconthi))   return 9;

      if (aFlags.addEntry(2)) return 9;

      // add also path for easier verify syntax
      if (aPath.addEntry(pszRelName)) return 9;
   }

   return 0;
}

int FileMetaDB::removeFile(char *pszName, bool bPrefixLF)
{
   char *relName(char *pszRoot, char *pszAbs);

   // strip x:\the\foo\bar.txt to the\foo\bar.txt
   char *pszRelName = relName(pszGlblCopySrc, pszName);

   int nind = indexOf(pszRelName);
   if (nind >= 0)
   {
      // mark this record as deleted, for save:
      aFlags.updateEntry(0, nind);
   }
   else
   {
      if (bPrefixLF) printf("\n");
      pwarn("cannot remove filename from metadb: %s\n", pszName);
   }

   return 0;
}

int FileMetaDB::checkFile(char *pszName)
{
   FileStat ofs;
   if (ofs.readFrom(pszName)) {
      perr("cannot read file infos: %s\n", pszName);
      return 5;
   }

   cs.files++;

   num nUnixTime = ofs.getUnixTime();
   // num nWinTime  = ofs.getWinTime();

   int nind = indexOf(pszName);
   if (nind >= 0)
   {
      // we have this filename in the db
      num nUnixTime2  = aUnixTime.getEntry(nind, __LINE__);
      // num nWinTime2   = aUnixTime.getEntry(nind, __LINE__);
      num nContSumLo2 = aContSumLo.getEntry(nind, __LINE__);
      num nContSumHi2 = aContSumHi.getEntry(nind, __LINE__);

      if (nUnixTime2 != nUnixTime) {
         printf("time: %s\n", pszName);
         return 0;
      }

      num ncontlo, nconthi;
      uchar abContSum[20];
      if (getFileMD5(pszName, abContSum)) return 9;
      ab16ToNum(abContSum, ncontlo, nconthi);

      if (ncontlo != nContSumLo2 || nconthi != nContSumHi2) {
         printf("cont: %s\n", pszName);
         return 0;
      }
   }

   return 0;
}

int FileMetaDB::updateDir(char *pszName)
{
    return 0;
}

int FileMetaDB::writeRecord(FILE *fout, int nIndex, SFKMD5 *pmd5, bool bIsLastRec)
{
   uchar about1[20];

   // since SFKSIG10, first field is uint nmetalen.
   uint nmetalen = 16+16+2;
   ulongtoab4(nmetalen, about1);
   if (myfwrite(about1, 4, fout, 0,0,pmd5) != 4) return 9;

   // file times
   numToAb16(aUnixTime.getEntry(nIndex, __LINE__),
             aWinTime.getEntry(nIndex, __LINE__) ,
             about1);
   if (myfwrite(about1, 16, fout, 0,0,pmd5) != 16) return 9;

   // content checksum
   numToAb16(aContSumLo.getEntry(nIndex, __LINE__),
             aContSumHi.getEntry(nIndex, __LINE__),
             about1);
   if (myfwrite(about1, 16, fout, 0,0,pmd5) != 16) return 9;

   // update flags
   uchar abFlags[2];
   uint nflags = aFlags.getEntry(nIndex, __LINE__);
   if (bIsLastRec)
      nflags |= 4;
   abFlags[0] = (uchar)(nflags >> 8);
   abFlags[1] = (uchar)(nflags     );
   if (myfwrite(abFlags, 2, fout, 0,0,pmd5) != 2) return 9;

   uchar abPathLen[2];
   memset(abPathLen, 0, sizeof(abPathLen));
   if (aPath.isSet(nIndex)) {
      char *psz  = aPath.getEntry(nIndex, __LINE__);
      // printf("WRITE %d %s\n", nIndex, psz);
      uint nlen = strlen(psz);
      abPathLen[0] = (uchar)(nlen >> 8);
      abPathLen[1] = (uchar)(nlen     );
      if (myfwrite(abPathLen,    2, fout, 0,0,pmd5) !=    2) return 9;
      if (myfwrite((uchar*)psz    , nlen, fout, 0,0,pmd5) != nlen) return 9;
   } else {
      // printf("WRITE %d [noname]\n", nIndex);
      if (myfwrite(abPathLen,    2, fout, 0,0,pmd5) != 2) return 9;
   }

   // printf(" saved record, %d %d\n", nflags, bIsLastRec);

   return 0;
}

int FileMetaDB::loadHeader(FILE *fin, SFKMD5 *pmd5)
{
   uchar abin[20];
   char *pszHead = pszClFileDBHead;
   int nread = myfread(abin, 8, fin, 0,0,pmd5);
   if (nread < 8) { fclose(fin); return 1; } // EOD
   abin[8] = '\0';
   if (strcmp((char*)abin, pszHead))
      return 9+perr("wrong signature db version: \"%s\"\n", abin);

   return 0;
}

int FileMetaDB::loadCheckEpilogue(FILE *fin, SFKMD5 *pmd5)
{
   uchar abin[20];

   int nread = myfread(abin, 16, fin, 0,0,0);
   if (nread < 16) {
      return 1; // EOD
   }

   uchar *pdig = pmd5->digest();
   if (memcmp(abin, pdig, 16)) {
      return 2; // mismatch
   }

   return 0;
}

// uses szLineBuf
int FileMetaDB::loadRecord(FILE *fin, SFKMD5 *pmd5, bool bSim)
{
   memset(abClRecBuf, 0, sizeof(abClRecBuf));
   uchar *abin = abClRecBuf;

   int nread = myfread(abin, 4, fin, 0,0,pmd5);
   if (nread < 4) return 1; // EOD, read after epilogue
   uint nmetalen = ab4toulong(abin);

   if (nmetalen > sizeof(abClRecBuf)-10)
      return 9+perr("metadb: header block too large (%u), cannot load.\n",nmetalen);

   if (nmetalen < 16+16+2)
      return 9+perr("metadb: header block too small (%u), cannot load.\n",nmetalen);

   nread = myfread(abin, nmetalen, fin, 0,0,pmd5);
   if (nread < (int)nmetalen) return 10; // unexpected

   num n1, n2;
   ab16ToNum(abin+0, n1, n2);
   if (!bSim) {
      if (aUnixTime.addEntry(n1)) return 9;
      if (aWinTime.addEntry(n2))  return 9;
   }

   ab16ToNum(abin+16, n1, n2);
   if (!bSim) {
      if (aContSumLo.addEntry(n1)) return 9;
      if (aContSumHi.addEntry(n2)) return 9;
   }

   // read flag value
   uchar abFlags[2];
   memcpy(abFlags, abin+32, 2);
   uint nflags = (((uint)abFlags[0]) << 8) | ((uint)abFlags[1]);
   if (!bSim) {
      // filter out flag "4" (last record marker):
      if (aFlags.addEntry(nflags & (255UL ^ 4))) return 9;
   }

   // read filename
   uchar abPathLen[2];
   nread = myfread(abPathLen, 2, fin, 0,0,pmd5);
   if (nread < 2) return 12; // unexpected
   uint nlen = (((uint)abPathLen[0]) << 8) | ((uint)abPathLen[1]);
   if (nlen > 0) {
      if (nlen > MAX_LINE_LEN-1) return 13;
      nread = myfread((uchar*)szLineBuf, nlen, fin, 0,0,pmd5);
      if (nread < (int)nlen) return 14;
      szLineBuf[nlen] = '\0';
      if (!bSim) {
         aPath.addEntry(szLineBuf);
      }
      // printf("LOADED NAME %s\n", szLineBuf);
   } else {
      // printf("LOADED NO NAME\n");
   }

   if (nflags & 4) {
      // printf("metadb load: lastrec found\n");
      return 2; // last data record read, md5 follows
   }

   return 0;
}

int FileMetaDB::writeEpilogue(FILE *fout, SFKMD5 *pmd5)
{
   uchar *pdig = pmd5->digest();
   if (myfwrite(pdig, 16, fout, 0,0,0) != 16) return 9;
   return 0;
}

int FileMetaDB::save(int &rnSignsWritten)
{__
   if (!pszClDBPath) return 9+perr("internal #11571945");

   if (pszClDBFile) { delete [] pszClDBFile; pszClDBFile=0; }
   pszClDBFile = new char[strlen(pszClDBPath)+100];

   int nCopies = 3;
   int nCopied = 0;

   // write signature db 3 times
   for (int i=1; i<=nCopies; i++)
   {
      sprintf(pszClDBFile, "%s-%02d.dat", pszClDBPath, i);
 
      SFKMD5 md5;
 
      // printf("saveto %s\n", pszClDBFile);
      FILE *fout = fopen(pszClDBFile, "wb");
      if (!fout) {
         perr("cannot write file meta db: %s\n", pszClDBFile);
         continue; // but retry with next
      }
 
      char *pszHead = pszClFileDBHead;
      if (myfwrite((uchar*)pszHead, 8, fout, 0,0,&md5) != 8)
         {  fclose(fout); continue; }
 
      bool bFailed = 0;
      bool bDoneLastRec = 0;

      int nEntries = aUnixTime.numberOfEntries();

      // identify last valid record to be saved
      int ilastval = 0;
      for (int k=0; k<nEntries; k++) {
         if (aFlags.getEntry(k, __LINE__) >= 1)
            ilastval = k;
      }

      int nWritten = 0;
      for (int i=0; i<nEntries; i++)
      {
         // write only added or updated records
         if (aFlags.getEntry(i, __LINE__) >= 1) {
            bool bIsLastRec = (i == ilastval);
            // printf("   write rec %d last=%d\n",i,bIsLastRec);
            if (writeRecord(fout, i, &md5, bIsLastRec)) {
               perr("error while writing file meta db: %s\n", pszClDBFile);
               bFailed = 1;
               break;
            } else {
               nWritten++;
               if (bIsLastRec)
                  bDoneLastRec = 1;
            }
         }
      }

      if (!bDoneLastRec)
         perr("internal: no lastrec saved %d %d\n",ilastval,nEntries);
 
      if (!bFailed)
         writeEpilogue(fout, &md5);
 
      fclose(fout);

      if (!bFailed) {
         rnSignsWritten = nWritten;
         nCopied++;
      }
   }

   if (nCopied <= 0)
      return 9+perr("failed to write any metadb copy.\n");

   if (nCopied < nCopies)
      return 5+perr("%d metadb copies written, %d failed.\n", nCopied, (nCopies-nCopied));

   return 0;
}

void FileMetaDB::reset( )
{
   if (pszClDBPath) {
      delete [] pszClDBPath;
      pszClDBPath = 0;
   }
   if (pszClDBFile) {
      delete [] pszClDBFile;
      pszClDBFile = 0;
   }
   if (pszClLineBuf) {
      delete [] pszClLineBuf;
      pszClLineBuf = 0;
   }
   if (pszClMetaDir) {
      delete [] pszClMetaDir;
      pszClMetaDir = 0;
   }
   aUnixTime.resetEntries();
   aWinTime.resetEntries();
   aContSumLo.resetEntries();
   aContSumHi.resetEntries();
   aFlags.resetEntries();
   aPath.resetEntries();
}

FileVerifier glblVerifier;

FileVerifier::FileVerifier()
{
   nClMatched = 0;
   nClFailed  = 0;
}

void FileVerifier::reset()
{
   aClSumHi.resetEntries();
   aClSumLo.resetEntries();
   aClDst.resetEntries();
}

int FileVerifier::remember(char *pszDst, num nsumhi, num nsumlo)
{
   if (aClSumHi.addEntry(nsumhi)) return 9;
   if (aClSumLo.addEntry(nsumlo)) return 9;
   if (aClDst.addEntry(pszDst))   return 9;
   return 0;
}

int FileVerifier::verify()
{
   char szAddInfo[200];

   int lRC = 0;

   int nFiles = totalFiles();
   for (int i=0; i<nFiles; i++)
   {
      if (userInterrupt(1, 1)) // silent, wait for release
      {
         info.print("verify stopped by user.\n");
         bGlblEscape = 0;
         return 1;
      }

      // get source file sum
      num nsrchi = aClSumHi.getEntry(i, __LINE__);
      num nsrclo = aClSumLo.getEntry(i, __LINE__);

      // build destination sum
      char *pszDst = aClDst.getEntry(i, __LINE__);
      info.setProgress(nFiles, i, "files");
      sprintf(szAddInfo, "file %d/%d", i+1, nFiles);
      info.setStatus("verfy", pszDst, szAddInfo);
      uchar abMD5Dst[20];
      if (getFileMD5NoCache(pszDst, abMD5Dst, 1)) // silent
      {
         if (userInterrupt(1, 1)) {
            pinf("[nopre] verify skipped.\n");
            lRC = 1;
            break;
         }
         perr("unable to read for verify: %s   \n", pszDst);
         lRC = 5; // file verify
         nClFailed++;
         continue;
      }
      uchar *pmd5dst = abMD5Dst;
      num ndstlo=0, ndsthi=0;
      for (int i=0,b=64-8; i<8; i++) {
         ndsthi = ndsthi | (((num)pmd5dst[0+i]&0xFF) << b);
         ndstlo = ndstlo | (((num)pmd5dst[8+i]&0xFF) << b);
         b -= 8;
      }

      // compare both
      if (nsrchi!=ndsthi || nsrclo!=ndstlo) {
         perr("verify failed, file differs: %s   \n", pszDst);
         nClFailed++;
         lRC = 6;
      } else {
         // info.setStatus("vryfd", pszDst); // , 0, eNoCycle);
         // info.printLine(1<<2); // w/o progress
         nClMatched++;
      }
   }

   return lRC;
}

void printCopyCompleted(char *pszName, uint nflags)
{
   info.clear();
   if (cs.quiet >= 2)
      return;
   cchar *pszpre = "";
   if (nflags & 8) {
      printx("<warn>##<def>"); pszpre=" ";
   }
   switch (nflags & 3) {
      case 1 : printx("<prefix>]<def>"); pszpre=" "; break;
      case 3 : printx("<warn>]<def>");   pszpre=" "; break;
   }
   if (nflags & 4) {
      printx("<prefix>><def>"); pszpre=" ";
   }
   oprintf("%s%s", pszpre, pszName);
   if (nflags & 8)
      printx(" <warn>[sync'ing older file]<def>");
   printf("\n");
}

CopyCache glblCopyCache;

CopyCache::CopyCache()
{
}

void CopyCache::setBuf(uchar *pBuf, num nBufSize)
{
   pClBuf      = pBuf;
   nClBufSize  = nBufSize;
   nClUsed     = 0;
}

int CopyCache::process(char *pszSrcFile, char *pszDstFile, char *pszShDst, uint nflags)
{
   if (!pszShDst) pszShDst = str("");

   // may another source file fit into the cache?
   FileStat ofsrc;
   if (ofsrc.readFrom(pszSrcFile))
      return 9+perr("unable to read: %s\n", pszSrcFile);
   num nSrcSize = ofsrc.getSize();
   num nRemain  = nClBufSize - nClUsed;
   if (nRemain < 0) return 9+perr("internal 612112001\n");

   // if not, write all cache contents
   if (nSrcSize + 1500 > nRemain) {
      int lRes = flush();
      if (lRes >= 9)
         return lRes;
      setEmpty(); // in case flush was interrupted
   }
 
   if (nSrcSize + 1500 > nClBufSize)
      return 1;   // file too large to fit into cache, copy directly
 
   // cache is ready to accept file
   num nUsedSave = nClUsed;

   // 1. filenames
   if (putBlock((uchar*)pszSrcFile, strlen(pszSrcFile)+1)) return 9+perr("internal 612112002\n");
   if (putBlock((uchar*)pszDstFile, strlen(pszDstFile)+1)) return 9+perr("internal 612112009\n");
   if (putBlock((uchar*)pszShDst  , strlen(pszShDst  )+1)) return 9+perr("internal 612112029\n");
 
   // 2. meta data: filestat and flags
   int nMetaSize = 0;
   uchar *pMeta = ofsrc.marshal(nMetaSize);
   if (putBlock(pMeta, nMetaSize)) return 9+perr("internal 612112006\n");

   uchar abflags[10];
   ulongtoab4(nflags, abflags);
   if (putBlock(abflags, 4)) return 9+perr("internal 612112006.2\n");

   // 3. if it's a directory,
   if (ofsrc.src.bIsDir)
   {
      // set zero-sized content, meta data is sufficient
      uchar *pCur = pClBuf+nClUsed;
      int nLongSize = 0;
      memcpy(pCur, &nLongSize, sizeof(int));
      pCur += sizeof(int);
      nClUsed += sizeof(int);
   }
   else
   {
      // else add the file content
      uchar *pCur = pClBuf+nClUsed;
      int nLongSize = (int)nSrcSize;
      memcpy(pCur, &nLongSize, sizeof(int));
      pCur += sizeof(int);
      nClUsed += sizeof(int);
 
      info.setStatProg("cache", pszSrcFile, nClBufSize, nUsedSave, "bytes");

      FILE *fin = fopen(pszSrcFile, "rb");
      if (!fin) {
         nClUsed = nUsedSave;
         return 5+perr("cannot open input file %s   \n", pszSrcFile);
         // non-fatal, proceed copy, but list error count at end.
      }
 
      size_t nRead = 0;
      if (cs.sim)
         nRead = nSrcSize;
      else
         nRead = myfread(pCur, (size_t)nSrcSize, fin, nClBufSize, nUsedSave);

      fclose(fin);
 
      if (nRead != nSrcSize) {
         perr("while reading %s: incomplete data\n", pszSrcFile);
         // fall back, remove metadata from cache
         nClUsed = nUsedSave;
      } else {
         SFKMD5 md5in;
         md5in.update(pCur, nSrcSize);
 
         nClUsed += nSrcSize;
         pCur += nSrcSize;
 
         // 4. md5
         uchar *pmd5in = md5in.digest();

         // remember source sum in case of late verify:
         if (cs.verifyLate) {
            num nsumlo=0, nsumhi=0;
            for (int i=0,b=64-8; i<8; i++) {
               nsumhi = nsumhi | (((num)pmd5in[0+i]&0xFF) << b);
               nsumlo = nsumlo | (((num)pmd5in[8+i]&0xFF) << b);
               b -= 8;
            }
            glblVerifier.remember(pszDstFile, nsumhi, nsumlo);
         }

         memcpy(pCur, pmd5in, 16);

         // printf("1] %02X%02X%02X%02X %s %p %s\n",pmd5in[0],pmd5in[1],pmd5in[2],pmd5in[3], numtoa(nSrcSize), pCur, pszSrcFile);

         pCur += 16;
         nClUsed += 16;

         // and also to filedb, if active
         if (filedb.canUpdate())
            if (filedb.updateFile(pszSrcFile, pmd5in))
               return 9;
      }
   }
 
   return 0;
}

int CopyCache::putBlock(uchar *pData, int nDataSize)
{
   uchar *pCur = pClBuf+nClUsed;
   num nRemain = nClBufSize-nClUsed;
   if (nDataSize > nRemain + 100) return 9;
   memcpy(pCur, &nDataSize, sizeof(int));
   memcpy(pCur+sizeof(int), pData, nDataSize);
   nClUsed += sizeof(int)+nDataSize;
   return 0;
}

void CopyCache::setEmpty()
{
   nClUsed = 0;
}

int CopyCache::flush()
{
   uchar *pCur = pClBuf;
   uchar *pMax = pClBuf+nClUsed;
   while (pCur < pMax)
   {
      bool bDoneFile = 0;

      // 1. filenames
      int nBlockSize = 0;
      if (pCur >= (pMax - sizeof(int))) return 9+perr("internal #113701\n");
      memcpy(&nBlockSize, pCur, sizeof(int));
      pCur += sizeof(int);
      char *pszSrc = (char*)pCur;
      pCur += nBlockSize;
      if (nBlockSize < 0 || pCur >= pMax) return 9+perr("internal #113702\n");

      memcpy(&nBlockSize, pCur, sizeof(int));
      pCur += sizeof(int);
      char *pszDst = (char*)pCur;
      pCur += nBlockSize;
      if (nBlockSize < 0 || pCur >= pMax) return 9+perr("internal #113703\n");

      memcpy(&nBlockSize, pCur, sizeof(int));
      pCur += sizeof(int);
      char *pszShDst = (char*)pCur;
      pCur += nBlockSize;
      if (nBlockSize < 0 || pCur >= pMax) return 9+perr("internal #113733\n");

      char *pszTell = chain.usefiles ? pszDst : pszSrc;
      if (cs.listTargets) pszTell = pszDst;

      // 2. meta data
      // filestat
      memcpy(&nBlockSize, pCur, sizeof(int));
      pCur += sizeof(int);
      uchar *pMeta = pCur;
      int nMetaSize = nBlockSize;
      pCur += nBlockSize;
      if (nBlockSize < 0 || pCur >= pMax) return 9+perr("internal #113704\n");

      // flags, also prefixed by blocksize (4)
      memcpy(&nBlockSize, pCur, sizeof(int));
      pCur += sizeof(int);
      if (nBlockSize != 4) return 9+perr("internal #113704.2\n");
      uchar abflags[10];
      memcpy(abflags, pCur, 4);
      pCur += 4;
      uint nflags = ab4toulong(abflags);
      // bit0: verified by checksum.
      // bit1: is shadow fallback.
      // bit2:
      // bit3: source is older than target (sync)

      // 3. file content
      memcpy(&nBlockSize, pCur, sizeof(int));
      pCur += sizeof(int);
      uchar *pContent = pCur;
      pCur += nBlockSize;
      if (nBlockSize < 0 || pCur > pMax) return 9+perr("internal #113705\n");

      FileStat ofsdst;
      if (ofsdst.setFrom(pMeta, nMetaSize))
         return 9;
 
      if (ofsdst.src.bIsDir)
      {
         // set target dir meta data
         if (cs.verbose > 2)
            info.print("[%s : about to copy time]\n", pszDst);
         if (!cs.sim)
            if (!ofsdst.writeTo(pszDst, __LINE__)) {
               cs.dirsCloned++;
               if (cs.verbose)
                  info.print("[%s : time copied]\n", pszDst);
            }
         // IGNORE rc. error messages are counted.
         // cs.dirs++;
      }
      else
      if (cs.sim)
      {
         // 4. skip md5
         pCur += 16;

         info.setStatus("", pszTell, "-----", eNoCycle);
         info.printLine(nGlblCopyStyle);
         cs.files++;
      }
      else
      {
         // 4. md5
         uchar *pmd5in = pCur;
         pCur += 16;

         for (int ntry=1; ntry<=3; ntry++)
         {
            // write target file
            info.setStatus("write", pszDst, "00");
 
            FILE *fout = myfopen(pszDst, "wb");
            if (!fout) {
               perr("cannot open output file %s (rc %d)\n", pszDst, (int)errno);
               break; // PROCEED with next file. errors are counted.
            }
 
            num nSize = ofsdst.src.nSize;
 
            size_t nWrite = myfwrite(pContent, nSize, fout, nSize, 0);
 
            myfclose(fout);
 
            if (bGlblEscape) {
               remove(pszDst);
               return 9+perr("failed to fully write %s, user interrupt\n", pszDst);
            }
            else
            if (nWrite != nSize)
               return 9+esys("fwrite", "failed to fully write %s   \n", pszDst);
               // do NOT proceed, this seems fatal.
 
            // set target meta data
            if (!ofsdst.writeTo(pszDst, __LINE__))
               cs.filesCloned++;
            // IGNORE rc. errors are counted.
 
            if (!cs.sim && cs.verifyEarly)
            {
               // run target verify
               info.setStatus("verfy", pszDst, "00");
               uchar abmd5[20];

               int nrcsub = getFileMD5NoCache(pszDst, abmd5, 1);

               if (userInterrupt(1))
               {
                  info.setAction("stop", pszDst, 0, 4);
                  info.printLine();
                  break;
               }
               else
               if (nrcsub == 0)
               {
                  if (memcmp(pmd5in, abmd5, 16)) {
                     if (ntry < 3) {
                        pwarn("verify failed, file differs: %s - retrying write\n", pszDst);
                        // fall through, next retry
                        remove(pszDst);
                     } else {
                        perr("verify failed, file differs: %s - giving up\n", pszDst);
                        remove(pszDst);
                     }
                  } else {
                     // verify succeeded
                     bDoneFile = 1;
                     cs.files++;
                     break;
                  }
               }
            }
            else
            {
               // no verify selected
               bDoneFile = 1;
               cs.files++;
               break;
            }
         }  // endfor tries

         // pszShDst must be set, but may be empty
         if (   filedb.canUpdate() && nGlblCopyShadows && strlen(pszShDst)
             && (!nGlblShadowSizeLimit || (ofsdst.src.nSize < nGlblShadowSizeLimit))
            )
         {
            // write shadow
            pszDst = pszShDst;

            info.setStatus("write", pszDst, "00");
            FILE *fout = myfopen(pszDst, "wb");
            if (!fout) {
               perr("cannot open output file %s (rc %d)\n", pszDst, (int)errno);
            } else {
               num nSize = ofsdst.src.nSize;
               size_t nWrite = myfwrite(pContent, nSize, fout, nSize, 0);
               myfclose(fout);
               if (bGlblEscape) {
                  remove(pszDst);
                  return 9+perr("failed to fully write %s, user interrupt\n", pszDst);
               }
               else
               if (nWrite != nSize)
                  return 9+esys("fwrite", "failed to fully write %s   \n", pszDst);
                  // do NOT proceed, this seems fatal.

               // set target meta data
               ofsdst.writeTo(pszDst, __LINE__);
               // IGNORE rc. errors are counted.
               nflags |= 4; // shadow written
               cs.shadowsWritten++;
            }
         }

         // print filename, tell how it was copied
         if (bDoneFile)
            printCopyCompleted(pszTell, nflags);
      }
   }
   setEmpty();
   return 0;
}

#ifdef _WIN32
DWORD CALLBACK cbCopyFileProgress(
   LARGE_INTEGER TotalFileSize,
   LARGE_INTEGER TotalBytesTransferred,
   LARGE_INTEGER StreamSize,
   LARGE_INTEGER StreamBytesTransferred,
   DWORD dwStreamNumber,
   DWORD dwCallbackReason,
   HANDLE hSourceFile,
   HANDLE hDestinationFile,
   LPVOID lpData  // optional
 )
{
   if (userInterrupt(1))
      return 1; // PROGRESS_CANCEL;

   num nTotal =  (((num)TotalFileSize.HighPart) << 32)
               | (((num)TotalFileSize.LowPart ) <<  0);

   num nDone  =  (((num)TotalBytesTransferred.HighPart) << 32)
               | (((num)TotalBytesTransferred.LowPart ) <<  0);

   info.setAddInfo("%u / %u mb", (uint)(nDone/1000000UL), (uint)(nTotal/1000000UL));
   info.setProgress(nTotal, nDone, "bytes");

   return 0; // PROGRESS_CONTINUE;
}

int copyFileWin(char *pszSrc, char *pszDst, char *pszShDst, uchar *pWorkBuf, num nBufSize, uint nflagsin)
{__
   char *pszTell = chain.usefiles ? pszDst : pszSrc;
   if (cs.listTargets) pszTell = pszDst;

   if (cs.sim) {
      info.setStatus("", pszTell, "-----", eNoCycle);
      if (!cs.dostat)
         info.printLine(nGlblCopyStyle);
      cs.files++;
      return 0;
   }

   info.setAction("copy ", pszTell, "00"); // fix sfk1933 not pszSrc

   DWORD nSysFlags = 0;

   // these are yet internal and completely untested
   if (cs.copyLinks)   nSysFlags |= 0x00000800UL; // COPY_FILE_COPY_SYMLINK;
   if (cs.copyNoBuf)   nSysFlags |= 0x00001000UL; // COPY_FILE_NO_BUFFERING;
   if (cs.copyDecrypt) nSysFlags |= 0x00000008UL; // COPY_FILE_ALLOW_DECRYPTED_DESTINATION;

   BOOL bcancel = 0;
   bool brc = CopyFileExA(pszSrc, pszDst, cbCopyFileProgress, 0, &bcancel, nSysFlags);

   if (!brc) {
      uint nerr = GetLastError();
      switch (nerr) {
         case ERROR_ACCESS_DENIED:
            perr("copy failed, access denied (rc=%u): %s\n", nerr, pszDst);
            pinf("make sure you have full access rights. maybe you have to be administrator.\n");
            break;
         case ERROR_REQUEST_ABORTED:
            // the OS cleaned up the target file.
            pwarn("copy stopped, cleanup done.\n");
            return 19; // stop all further processing
         default:
            perr("copy failed, rc=%u: %s\n", nerr, pszDst);
            break;
      }
   } else {
      cs.files++;
      printCopyCompleted(pszTell, nflagsin);
   }

   return brc ? 0 : 9;
}
#endif // _WIN32

int copyFile(char *pszSrc, char *pszDst, char *pszShDst, uchar *pWorkBuf, num nBufSize, uint nflags)
{__
   char *pszTell = chain.usefiles ? pszDst : pszSrc;
   if (cs.listTargets) pszTell = pszDst;

   if (cs.sim) {
      info.setStatus("", pszTell, "-----", eNoCycle);
      if (!cs.dostat)
         info.printLine(nGlblCopyStyle);
      cs.files++;
      return 0;
   }

   int lRC = 0;
   uchar abMD5Src[20];
   bool  bmdsrcset = 0;
   memset(abMD5Src, 0, sizeof(abMD5Src));

   bool bDoneFile = 0;

   // try to copy the file, upto 3 times
   for (int ntry=1; ntry<=3; ntry++)
   {
      info.setAction("read ", pszSrc, "00");
 
      num nFileSize = getFileSize(pszSrc);
 
      FILE *fin = fopen(pszSrc, "rb");
      if (!fin) return 9+perr("cannot open input file %s   \n", pszSrc);
 
      FILE *fout = myfopen(pszDst, "wb");
      if (!fout) {
         fclose(fin);
         return 9+perr("cannot open output file %s   \n", pszDst);
      }

      FILE *fsh = 0;
      if (   filedb.canUpdate() && nGlblCopyShadows && pszShDst
          && (!nGlblShadowSizeLimit || (nFileSize < nGlblShadowSizeLimit))
         )
      {
         fsh = fopen(pszShDst, "wb");
         if (!fsh)
            perr("cannot write shadow file %s   \n", pszShDst);
            // but continue, w/o shadow
      }
 
      num nTime1=0, nTime2=0, nReadTime=0, nWriteTime=0;
      num nReadBytes=0, nWriteBytes=0;
      uint nkbsread=0, nkbswrite=0;
      SFKMD5 md5in;
      int nBlock = 0;
      while (!userInterrupt())
      {
         nTime1 = getCurrentTime();
         info.setStatus("read ", pszSrc, "00");
         size_t nRead = 0;
         if (cs.sim)
            nRead = nBufSize;
         else
            nRead = myfread(pWorkBuf, (size_t)nBufSize, fin, nFileSize, nReadBytes);
         nTime2 = getCurrentTime();
         if (nRead <= 0)
            break; // EOD
         nReadTime  += (nTime2-nTime1);
         nReadBytes += nRead;
 
         md5in.update(pWorkBuf, nRead);
 
         nTime1 = getCurrentTime();
         info.setStatus("write", pszDst, "00");
         size_t nWrite = myfwrite(pWorkBuf, nRead, fout, nFileSize, nWriteBytes);
         nTime2 = getCurrentTime();
         if (nWrite != nRead) {
            lRC = 9;
            if (!bGlblEscape)
               esys("fwrite", "failed to write %s   \n", pszDst);
            break;
         }
         nWriteTime  += (nTime2-nTime1);
         nWriteBytes += nWrite;

         // extra shadow write
         if (fsh) {
            nWrite = myfwrite(pWorkBuf, nRead, fsh, nFileSize, nWriteBytes);
            if (nWrite != nRead) {
               // shadow writing fails silently
               fclose(fsh);
               remove(pszShDst);
               fsh = 0;
               pszShDst = 0;
            }
         }
 
         nkbsread  = (nReadBytes  / (nReadTime  ? nReadTime : 1));
         nkbswrite = (nWriteBytes / (nWriteTime ? nWriteTime : 1));
 
         nBlock++;
      }

      if (fsh) {
         fclose(fsh);
         nflags |= 4; // shadow written
         cs.shadowsWritten++;
      }
      pszShDst = 0; // block 2nd writing of shadow
 
      myfclose(fout);
      fclose(fin);
 
      if (bGlblEscape) {
         remove(pszDst);
         if (cs.verbose)
            pwarn("copy stopped, cleaning up: %s\n", pszDst);
         else
            pwarn("copy stopped, cleanup done.\n");
         return 19;
      }
 
      FileStat ofs;
      if (ofs.readFrom(pszSrc))
         return 9+perr("failed to read attributes: %s\n", pszSrc);
      if (ofs.writeTo(pszDst, __LINE__))
         return 9+perr("failed to write attributes: %s\n", pszDst);
      else
         cs.filesCloned++;

      uchar *pmd5in = md5in.digest();

      // remember source sum in case of late verify:
      if (cs.verifyLate) {
         num nsumlo=0, nsumhi=0;
         for (int i=0,b=64-8; i<8; i++) {
            nsumhi = nsumhi | (((num)pmd5in[0+i]&0xFF) << b);
            nsumlo = nsumlo | (((num)pmd5in[8+i]&0xFF) << b);
            b -= 8;
         }
         glblVerifier.remember(pszDst, nsumhi, nsumlo);
      }

      // remember src file md5 beyond this scope
      memcpy(abMD5Src, pmd5in, 16);
      bmdsrcset = 1;

      if (!cs.sim && cs.verifyEarly)
      {
         info.setAction("verfy", pszTell, "00");
 
         // run target verify
         uchar abmd5[20];
         int nrcsub = getFileMD5NoCache(pszDst, abmd5, 1);
 
         if (userInterrupt(1))
         {
            info.setAction("stop ", pszDst, 0, 4);
            info.printLine();
            break;
         }
         else
         if (nrcsub == 0)
         {
            if (memcmp(pmd5in, abmd5, 16)) {
               if (ntry < 3) {
                  pwarn("verify failed, file differs: %s - retrying write\n", pszDst);
                  // fall through, next retry
                  remove(pszDst);
               } else {
                  perr("verify failed, file differs: %s - giving up\n", pszDst);
                  remove(pszDst);
               }
            } else {
               // verify succeeded
               bDoneFile = 1;
               cs.files++;
               break;
            }
         }
      }
      else
      {
         // no verify selected
         bDoneFile = 1;
         cs.files++;
         break;
      }
   }  // endfor tries

   if (bDoneFile)
      printCopyCompleted(pszTell, nflags);

   if (lRC == 0) {
      if (!bmdsrcset) return 9+perr("internal #0505071820");
      filedb.updateFile(pszSrc, abMD5Src);
   }

   return lRC;
}

int moveFile(char *pszSrc, char *pszDst)
{__
   char *pszTell = chain.usefiles ? pszDst : pszSrc;
   if (cs.listTargets) pszTell = pszDst;

   info.clear();
   setTextColor(nGlblWarnColor);
   oprintf("from : %s\n", pszSrc);
   setTextColor(-1);
   oprintf("to   : %s\n", pszDst);

   if (cs.sim) {
      if (glblOutFileMap.isset(pszDst)) {
         printx("<err>would move twice to: %s\n", pszDst);
         cs.filesRedundant++;
      } else {
         glblOutFileMap.put(pszDst);
         cs.files++;
      }
      return 0;
   }

   if (rename(pszSrc, pszDst))
      return 9+perr("cannot move file %s   \n", pszSrc);

   cs.files++;

   return 0;
}

int execDirCopy(char *pszSrc, FileList &oDirFiles)
{__
   // copy metadata of directory
   char *pszDstRaw = pszGlblCopyDst;

   // expect Src to contain a RELATIVE path, e.g.
   //    data\tmp1.txt  data\sub\tmp2.txt
   // strip the original base path, if any
   char *pszRelSrc = relName(pszGlblCopySrc, pszSrc);

   cs.dirsScanned++;
   sprintf(szLineBuf, "%u files %u dirs", cs.filesScanned, cs.dirsScanned);
   if (strlen(szLineBuf) > 20)
      info.setAddInfoWidth(strlen(szLineBuf));
   info.setStatus("scan ", pszRelSrc, szLineBuf);

   // build full target name: d:/tmp/subdir
   joinPath(szRefNameBuf, sizeof(szRefNameBuf), pszDstRaw, pszRelSrc);
   // strip trailing / if any
   int nRefLen = strlen(szRefNameBuf);
   if ((nRefLen > 0) && (szRefNameBuf[nRefLen-1] == glblPathChar))
      szRefNameBuf[nRefLen-1] = '\0';

   // execFileCopy has created dir tree on demand,
   // so all dirs must exist, IF files have been copied.
   if (!isDir(szRefNameBuf)) {
      // sfk1972 -empty internal, yet incomplete.
      // e.g. dont want this if file masks are given.
      if (cs.withempty && isEmptyDir(pszSrc)) {
         if (createSubDirTree(szRefNameBuf, str("")))
            return 9;
         if (cs.verbose)
            info.print("%s : copying empty dir.\n",szRefNameBuf);
      } else {
         if (cs.verbose)
            info.print("%s : skip, no files copied.\n",szRefNameBuf);
         return 0; // no files have been copied in that dir.
      }
   }

   char szReason[50];
   szReason[0] = '\0';

   // check if we really need to copy attributes

   // win: don't try to clone x: to y: etc.
   #ifdef _WIN32
   if (endsWithColon(pszSrc)) return 0;
   if (endsWithColon(szRefNameBuf)) return 0;
   #endif

   // BEWARE OF MIXUP:
   //    sfk list -sincedir foo bar
   //       means for the user: FOO (szRefNameBuf) is the SOURCE.
   // NO problem here, as in
   //    sfk copy foo bar
   //       the provided pszSrc in here IS actually the SOURCE.

   FileStat ofsSrc;
   FileStat ofsDst;
   if (ofsSrc.readFrom(pszSrc)) {
      perr("cannot read dir time: %s\n", pszSrc);
      return 9;
   }

   char *pszTell = pszSrc;
   if (cs.listTargets) pszTell = szRefNameBuf;

   // checked isDir(szRefNameBuf) above
   if (!ofsDst.readFrom(szRefNameBuf))
   {
      // sfk1972 always sync folder dates, just like file dates.
      int ndif = ofsSrc.differs(ofsDst, 0); // NOT same if older src
      if (!ndif) {
         if (cs.verbose > 1)
            info.print("%s : no time / attrib change\n", szRefNameBuf);
         return 0;   // skip
      }
      if (ndif >= 7 && ndif <= 10 && cs.nodirtime != 0) {
         if (cs.verbose > 1)
            info.print("%s : ignore time difference (%d)\n", szRefNameBuf, ndif);
         return 0;   // skip
      }
      if (cs.verbose > 0)
         info.print("%s : copying attribs, ndif %d\n", szRefNameBuf, ndif);
      // sprintf(szReason, "%d", ndif);
   }

   bool bDone = 0;
   if (bGlblUseCopyCache) {
      int lRes = glblCopyCache.process(pszSrc, szRefNameBuf, 0, 0);
      if (lRes == 0)
         bDone = 1;
   }

   if (!bDone)
   {
      if (cs.sim) {
         cs.dirsCloned++;
      } else {
         if (cloneAttributes(pszSrc, szRefNameBuf, __LINE__))
            return 1; // error, but skip and continue
         cs.dirsCloned++;
      }

      setTextColor(nGlblTimeColor);
      info.setStatus("", pszTell, "copy time", eNoCycle);
      info.printLine(nGlblCopyStyle);
      setTextColor(-1);
   }

   return 0;
}

// USES:
//    szAttrBuf, szAttrBuf2, szRefNameBuf, szRefNameBuf2,
//    szLineBuf1/2 (indirectly)
int execFileCopy(Coi *pcoi)
{__
   char *pszSrc      = pcoi->name();
   char *pszOptRoot  = pcoi->root(1); // null if not set

   cs.filesScanned++;

   #if 0
   printf("copy.usefiles    %d\n", chain.usefiles);
   printf("copy.rootrelname %d\n", cs.rootrelname);
   printf("copy.rootabsname %d\n", cs.rootabsname);
   printf("copy.optroot     \"%s\"\n", pszOptRoot ? pszOptRoot : "<null>");
   #endif

   // with input chaining, glblCopySrc will not be set.
   char *pszSrcRaw = pszGlblCopySrc;
   if (chain.usefiles) {
      if (cs.rootrelname)
         pszSrcRaw = pszOptRoot; // user selected relative names
      else {
         // autodetect: include source root into target name?
         if (cs.rootabsname || (pszOptRoot && !isAbsolutePath(pszOptRoot)))
            // source root is NOT absolute, or -abs specified: take it
            pszSrcRaw = str("");
         else
            // source root IS absolute (e.g. C:\\) so strip it
            pszSrcRaw = pszOptRoot; // if null, produces error below
      }
   }
   if (!pszSrcRaw) return 9+perr("copy: missing source root dir. file=%s",pszSrc);

   // expect Dst to be a directory, e.g.
   //    x:    x:/   x:/tmp   x:/tmp/
   char *pszDstRaw = pszGlblCopyDst;

   // expect Src to contain a RELATIVE path, e.g.
   //    data\tmp1.txt  data\sub\tmp2.txt
   // strip the original base path, if any
   char *pszRelSrc  = relName(pszSrcRaw, pszSrc);
 
   if (cs.flat) {
      char cjoin = cs.cflatpat ? cs.cflatpat : '-';
      if (cs.flat == 2) {
         char *psla = strrchr(pszRelSrc, glblPathChar);
         if (psla!=0 && strlen(psla)>1)
            pszRelSrc = psla+1;
      }
      strcopy(szAttrBuf2, pszRelSrc);
      for (int i=0; szAttrBuf2[i]; i++) {
         if (!ispathchr(szAttrBuf2[i]))
            continue;
         szAttrBuf2[i] = cjoin;
      }
      pszRelSrc = szAttrBuf2;
   }

   #if 0
   printf("copy.src.raw %s\n",pszSrcRaw);
   printf("copy.src.abs %s\n",pszSrc);
   printf("copy.src.rel %s\n",pszRelSrc);
   printf("copy.dst.raw %s\n",pszDstRaw);
   #endif

   // build full target name: d:/tmp/subdir/thefile.txt
   joinPath(szRefNameBuf, sizeof(szRefNameBuf), pszDstRaw, pszRelSrc);

   if (cs.debug)
      printf("copy.check %s => %s [root=%s]\n",pszSrc,szRefNameBuf,pszSrcRaw);

   char *pszShSrc = 0, *pszShDst = 0;
   if (filedb.canRead()) {
      // create source shadow path
      if (!joinShadowPath(szRefNameBuf2, sizeof(szRefNameBuf2), pszSrcRaw, pszRelSrc))
         pszShSrc = szRefNameBuf2;
   } else {
      // create dest shadow path
      if (!joinShadowPath(szRefNameBuf2, sizeof(szRefNameBuf2), pszDstRaw, pszRelSrc))
         pszShDst = szRefNameBuf2;
   }
 
   // prepare target directory(s), if any. first we need the full path,
   strcopy(szAttrBuf, szRefNameBuf);
   char *psz1 = strrchr(szAttrBuf, glblPathChar);
   #ifdef _WIN32
   if (!psz1) {
      // c:thefile.txt -> c:
      if ( (strlen(szAttrBuf) >= 2) && (szAttrBuf[1] == ':' ) )
         psz1 = &szAttrBuf[2];
   }
   #endif
   if (!psz1) return 9+perr("unexpected target name format: %s\n",szAttrBuf);
   *psz1 = '\0';
   // to check if it exists or not,
   if (!cs.sim && !isDir(szAttrBuf)) {
      // then we need to isolate the relative target dir path,
      sprintf(szAttrBuf, "%c%s", glblPathChar, pszRelSrc);
      psz1 = strrchr(szAttrBuf, glblPathChar);
      if (!psz1) return 9+perr("unexpected target name format: %s\n",szAttrBuf);
      *psz1 = '\0';
      // to allow better processing in createSubDirTree.
      if (createSubDirTree(pszDstRaw, szAttrBuf, pszSrcRaw))
         return 9;
   }
   // else we have some path like c:thefile.txt - no directories to create.

   // same for dest. shadow, if any
   if (filedb.canUpdate() && nGlblCopyShadows && pszShDst)
   {
      strcopy(szAttrBuf, pszShDst);
      char *psz1 = strrchr(szAttrBuf, glblPathChar);
      #ifdef _WIN2
      if (!psz1) {
         // c:thefile.txt -> c:
         if ( (strlen(szAttrBuf) >= 2) && (szAttrBuf[1] == ':' ) )
            psz1 = &szAttrBuf[2];
      }
      #endif
      if (!psz1) return 9+perr("unexpected target name format: %s\n",szAttrBuf);
      *psz1 = '\0';
      // to check if it exists or not,
      if (!cs.sim && !isDir(szAttrBuf)) {
         // then we need to isolate the relative target dir path,
         sprintf(szAttrBuf, "%czz-shadow-01%s%s", glblPathChar, glblPathStr, pszRelSrc);
         psz1 = strrchr(szAttrBuf, glblPathChar);
         if (!psz1) return 9+perr("unexpected target name format: %s\n",szAttrBuf);
         *psz1 = '\0';
         // to allow better processing in createSubDirTree.
         if (createSubDirTree(pszDstRaw, szAttrBuf, pszSrcRaw))
            return 9;
      }
   }
 
   return execFileCopySub(pszSrc, szRefNameBuf, pszShSrc, pszShDst);
}

// does NOT create target subdirs. this is expected to be done by caller.
int execFileCopySub(char *pszSrc, char *pszDst, char *pszShSrc, char *pszShDst)
{__
   mtklog(("fcopysub: %s -> %s",pszSrc,pszDst));

   char szReason[50];
   szReason[0] = '\0';

   // if we tell the filename, do we take src or dst file?
   char *pszTell = chain.usefiles ? pszDst : pszSrc;
   if (cs.listTargets) pszTell = pszDst;
 
   // check if we really need to copy

   // BEWARE OF MIXUP:
   //    sfk list -sincedir foo bar
   //       means for the user: FOO (szRefNameBuf) is the SOURCE.
   // NO problem here, because with
   //    sfk copy foo bar
   //       the pszSrc provided in here REALLY is the SOURCE.

   bool bJustCopyTime = 0;
   bool bSrcIsOlder = 0;
   uint nflags = 0;
   bool bmove = cs.movefiles;

   FileStat ofsSrc;
   FileStat ofsDst;
   bool  bSrcUnreadable = 0;
   if (ofsSrc.readFrom(pszSrc)) {
      // filename exists in source, but file is unreadable:
      mtklog(("copy: src unreadable"));
      if (filedb.canRead() && pszShSrc) {
         // proceed, as we may use the shadow
         bSrcUnreadable = 1; // but don't issue same error twice
      } else {
         // printf("fatal, %d %p\n", filedb.canRead(), pszShSrc);
         return 9;
      }
   }
   num nFileSize = ofsSrc.getSize();
   if (fileExists(pszDst))
   {
      if (!ofsDst.readFrom(pszDst))
      {
         bool bSameIOS = cs.syncOlder ? 0 : 1;  // same if older src?
         int ndif = ofsSrc.differs(ofsDst, bSameIOS, &bSrcIsOlder);
         if (bSrcIsOlder) nflags |= (1<<3);
         if (!ndif && !bGlblIgnoreTime) {
            // only with copy, NOT with sync it may happen
            // that src is OLDER than target, skipping copy.
            // with sync, different times ALWAYS lead to copy.
            if (cs.syncFiles && bSrcIsOlder && !cs.noinfo) {
               if (bSrcIsOlder < 2) {
                  info.setStatus("skip", pszTell, "source is older");
                  info.printLine(1<<2);
               }
               // else dst jump, don't even tell notice
            }
            else
            if (cs.verbose)
               info.print("no diff, skip: %s\n", pszTell);
            if (filedb.canUpdate())
               filedb.updateFile(pszSrc, 0, true); // true:JustConfirm
            return 0;   // skip
         }
         // differs by timestamp (src is newer). but does it really mean
         // we have to copy the whole content?
         if (ofsSrc.getSize() == ofsDst.getSize()) {
            // compare file content
            uchar abMD5Src[20];
            if (equalFileContent(pszSrc, pszDst, abMD5Src)) {
               if (bGlblIgnoreTime) {
                  if (filedb.canUpdate())
                     filedb.updateFile(pszSrc, abMD5Src);
                  return 0; // same content, skip
               }
               bJustCopyTime = 1;
            }
            else
            if (!ndif && bGlblIgnoreTime) {
               int ndif2 = ofsSrc.differs(ofsDst, 0); // NOT same if older src
               if (!ndif2 && cs.sim) {
                  // critical: have file with same size and time, but dif. content
                  // this can be reached only through -ignoretime deep verify.
                  // if in simulation, create warning-like special listing
                  pwarn("same time/size, but content diff: %s\n", pszDst);
                  // indicates corrupted file - no filedb update here.
                  cs.files++;
                  return 0;
               }
            }
            if (cs.verbose)
               info.print("[%s : differs, rc %d%s]\n", pszDst, ndif,
                  bJustCopyTime ? ", same content":", diff. content");
         } else {
            if (cs.verbose)
               info.print("[%s : differs, rc %d]\n", pszDst, ndif);
         }
         // sprintf(szReason, "%d", ndif);
      }
   }

   if (bJustCopyTime)
   {
      // this flag says that both files exist with same content.
      if (cs.sim) {
         cs.filesCloned++;
      } else {
         // copy timestamp and attributes, but not the content.
         if (ofsSrc.writeTo(pszDst, __LINE__))
            return 1; // error, skip but continue
         cs.filesCloned++;
      }

      setTextColor(nGlblTimeColor);
      info.setStatus("", pszTell, "copy time", eNoCycle);
      info.printLine(nGlblCopyStyle);
      setTextColor(-1);

      // remember src and dst for verify pass
      // glblVerifier.remember(pszSrc, pszDst);
   }
   else
   {
      // prepare copy of file
      if (filedb.canRead()) {
         // try to check source file if it's still intact
         int nvrc = filedb.verifyFile(pszSrc, pszShSrc, bSrcUnreadable);
         if (nvrc >= 9)
            return 0+perr("check failed: %s - content changed, skipping copy\n", pszSrc);
         else
         if (nvrc == 8)
            return 0+perr("%s - not found in metadb, skipping copy\n", pszSrc);
         else
         if (nvrc == 5) {
            pwarn("master file modified, using shadow: %s\n", pszShSrc);
            pszSrc = pszShSrc;
            cs.shadowFallbacks++;
            nflags |= 3; // with checksum, but shadow
         }
         else
         if (nvrc > 5) {
            // unexpected, issue general message
            return 0+perr("check failed: %s - skipping copy (%d)\n", pszSrc, nvrc);
         } else {
            // rc < 5 is just informal, e.g. time difference
            nflags |= 1; // checksum verified
         }
      }

      // copy the actual file
      bool bDone = 0;
      if (!cs.sim && bGlblUseCopyCache) {
         int lRes = glblCopyCache.process(pszSrc, pszDst, pszShDst, nflags);
         if (lRes == 0)
            bDone = 1;
         if (lRes >= 9)
            return lRes; // fatal error
      }
 
      if (!bDone)
      {
         int iSubRC = 0;
         if (bmove) {
            // sfk187: move file
            if (iSubRC = moveFile(pszSrc, pszDst))
               return iSubRC;
         }
         else
         #ifdef _WIN32
         if (!nGlblCopyShadows) {
            if (iSubRC = copyFileWin(pszSrc, pszDst, pszShDst, pGlblWorkBuf, nGlblWorkBufSize, nflags))
               return iSubRC;
         }
         else
         #endif
         if (iSubRC = copyFile(pszSrc, pszDst, pszShDst, pGlblWorkBuf, nGlblWorkBufSize, nflags))
            return iSubRC;
      }

      // count direct file size
      cs.totalbytes += nFileSize;

      // count shadow size, if any
      if (   nGlblCopyShadows
          && (!nGlblShadowSizeLimit || (nFileSize < nGlblShadowSizeLimit))
         )
      {
         cs.totalbytes += nFileSize;
         cs.shadowsWritten++;
      }
   }
 
   return 0;
}

int execFileMoveSub(char *pszSrc, char *pszDst);

int execFileMove(Coi *pcoi)
{__
   char *pszSrc      = pcoi->name();
   char *pszOptRoot  = pcoi->root(1); // null if not set

   cs.filesScanned++;

   // with input chaining, glblCopySrc will not be set.
   char *pszSrcRaw = pszGlblCopySrc;
   if (chain.usefiles) {
      if (cs.rootrelname)
         pszSrcRaw = pszOptRoot; // user selected relative names
      else {
         // autodetect: include source root into target name?
         if (cs.rootabsname || (pszOptRoot && !isAbsolutePath(pszOptRoot)))
            // source root is NOT absolute, or -abs specified: take it
            pszSrcRaw = str("");
         else
            // source root IS absolute (e.g. C:\\) so strip it
            pszSrcRaw = pszOptRoot; // if null, produces error below
      }
   }
   if (!pszSrcRaw) return 9+perr("copy: missing source root dir. file=%s",pszSrc);

   // expect Dst to be a directory, e.g.
   //    x:    x:/   x:/tmp   x:/tmp/
   char *pszDstRaw = pszGlblCopyDst;

   // expect Src to contain a RELATIVE path, e.g.
   //    data\tmp1.txt  data\sub\tmp2.txt
   // strip the original base path, if any
   char *pszRelSrc  = relName(pszSrcRaw, pszSrc);
 
   if (cs.flat == 2) {
      pszRelSrc = pcoi->relName();
   } else if (cs.flat) {
      char cjoin = cs.cflatpat ? cs.cflatpat : '-';
      strcopy(szAttrBuf2, pszRelSrc);
      for (int i=0; szAttrBuf2[i]; i++) {
         if (!ispathchr(szAttrBuf2[i]))
            continue;
         szAttrBuf2[i] = cjoin;
      }
      pszRelSrc = szAttrBuf2;
   }

   // build full target name: d:/tmp/subdir/thefile.txt
   joinPath(szRefNameBuf, sizeof(szRefNameBuf), pszDstRaw, pszRelSrc);

   if (cs.debug)
      printf("copy.check %s => %s [root=%s]\n",pszSrc,szRefNameBuf,pszSrcRaw);

   // prepare target directory(s), if any. first we need the full path,
   strcopy(szAttrBuf, szRefNameBuf);
   char *psz1 = strrchr(szAttrBuf, glblPathChar);
   #ifdef _WIN32
   if (!psz1) {
      // c:thefile.txt -> c:
      if ( (strlen(szAttrBuf) >= 2) && (szAttrBuf[1] == ':' ) )
         psz1 = &szAttrBuf[2];
   }
   #endif
   if (!psz1) return 9+perr("unexpected target name format: %s\n",szAttrBuf);
   *psz1 = '\0';
   // to check if it exists or not,
   if (!cs.sim && !isDir(szAttrBuf)) {
      // then we need to isolate the relative target dir path,
      sprintf(szAttrBuf, "%c%s", glblPathChar, pszRelSrc);
      psz1 = strrchr(szAttrBuf, glblPathChar);
      if (!psz1) return 9+perr("unexpected target name format: %s\n",szAttrBuf);
      *psz1 = '\0';
      // to allow better processing in createSubDirTree.
      if (createSubDirTree(pszDstRaw, szAttrBuf, pszSrcRaw))
         return 9;
   }
   // else we have some path like c:thefile.txt - no directories to create.

   char *pszDst = szRefNameBuf;

   return execFileMoveSub(pszSrc, pszDst);
}

int execFileMoveSub(char *pszSrc, char *pszDst)
{
   if (!fileExists(pszSrc))
      return 9;

   if (fileExists(pszDst)) {
      info.clear();
      setTextColor(nGlblWarnColor);
      oprintf("from : %s\n", pszSrc);
      setTextColor(-1);
      if (cs.nostop) {
         setTextColor(nGlblErrColor);
         oprintf("skip : %s\n", pszDst);
         setTextColor(-1);
         cs.filesRedundant++;
         return 9;
      }
      perr("target file exists: %s\n", pszDst);
      return 19;
   }

   // cs.sim is handled inside
   return moveFile(pszSrc, pszDst);
}

int execDirMove(char *pszSrc, FileList &oDirFiles)
{
   return 0;
}

// USES:
//    szAttrBuf, szRefNameBuf, szLineBuf1/2 (indirectly)
int execFileCleanup(char *pszSrc)
{__
   cs.filesScanned++;

   // expect Dst to be a directory, e.g.
   //    x:    x:/   x:/tmp   x:/tmp/
   char *pszDstRaw = pszGlblCopyDst;

   // expect Src to contain a RELATIVE path, e.g.
   //    data\tmp1.txt  data\sub\tmp2.txt
   // strip the original base path, if any
   char *pszRelSrc = relName(pszGlblCopySrc, pszSrc);
 
   // build full target name: d:/tmp/subdir/thefile.txt
   joinPath(szRefNameBuf, sizeof(szRefNameBuf), pszDstRaw, pszRelSrc);
 
   // REORDER: currently, pszSrc is the TARGET file
   char *pszDst = pszSrc;
   pszSrc = szRefNameBuf;
   // NOW, pszSrc is the copy src, pszDst is the cleanup candidate.

   bool b1 = (bool)fileExists(pszSrc);
   bool b2 = (bool)fileExists(pszDst);

   if (!b1 && b2)
   {
      // old trash file, or backsync candidate?
      num nFileAge = getFileAge(pszDst);
      int nAgeDays = nFileAge / (24 * 3600);

      if (!cs.delStaleFiles && (nAgeDays < nGlblActiveFileAgeLimit))
      {
         int nRemain = nGlblActiveFileAgeLimit - nAgeDays;
         if (nRemain < 6)
            setTextColor(nGlblErrColor);
         else
            setTextColor(nGlblWarnColor);
         if (cs.verbose)
            info.print("stale: %s / %s - %d days until deletion\n",pszDst,pszSrc,nRemain);
         else
            info.print("stale: %s - %d days until deletion\n",pszDst,nRemain);
         setTextColor(-1);
         cs.filesStale++;
      }
      else
      {
         setTextColor(nGlblWarnColor);
         if (cs.verbose)
            info.print("DEL: %s / %s",pszDst,pszSrc);
         else
            info.print("DEL: %s",pszDst);
         setTextColor(-1);
 
         // NO LINEFEED FROM HERE
         if (!cs.sim && cs.yes)
         {
            // delete primary stale file
            if (!canWriteFile(pszDst, 0))
               setWriteEnabled(pszDst);
            if (remove(pszDst)) {
               printf("\n");
               perr("failed to delete: %s", pszDst);
            } else {
               cs.filesDeleted++;
               if (filedb.canUpdate()) {
                  // remove file from filedb
                  filedb.removeFile(pszDst, 1);
               }
            }
            // delete shadow, if any
            if (nGlblCopyShadows && cs.skipOwnMetaDir && (strlen(filedb.metaDir()) > 0))
            {
               char *pszMeta = filedb.metaDir();
               if (!strstr(pszMeta, "zz-shadow-")) {
                  printf("\n"); perr("wrong metadb name: %s", pszMeta);
               } else {
                  joinPath(szRefNameBuf, sizeof(szRefNameBuf), pszMeta, pszRelSrc);
                  char *pszShadow = szRefNameBuf;
                  if (fileExists(pszShadow)) {
                     if (!canWriteFile(pszShadow, 0))
                        setWriteEnabled(pszShadow);
                     if (remove(pszShadow)) {
                        printf("\n");
                        perr("failed to delete: %s", pszShadow);
                     } else {
                        printx("<time> +shadow<def>");
                     }
                  }
               }
            }
         } else {
            cs.filesDeleted++;
         }
         // NO LINEFEED UNTIL HERE

         printf("\n");
      }
   }
   else
   if (b1 && b2)
   {
      // list touched files
      FileStat ofsSrc;
      FileStat ofsDst;
      if (ofsSrc.readFrom(pszDst))  // SWAPPED
         return 9;
      if (!ofsDst.readFrom(pszSrc)) {  // SWAPPED
         int ndif = ofsSrc.differs(ofsDst, 1); // same if older src
         if (!ndif) {
            if (cs.verbose)
               info.print("no diff, skip: %s\n", pszSrc);
            return 0;   // skip
         }
         if (cs.verbose)
            info.print("[%s : differs, rc %d]\n", pszDst, ndif);
         // the target file was changed after copy
         cs.filesNewerInDst++;
         if (bGlblShowSyncDiff)
            info.print("DIF: %s   (%s)\n",pszDst,ofsSrc.diffReason(ndif));
      }
   }
 
   return 0;
}

int execDirCleanup(char *pszSrc, FileList &oDirFiles)
{__
   // copy metadata of directory
   char *pszDstRaw = pszGlblCopyDst;

   // expect Src to contain a RELATIVE path, e.g.
   //    data\tmp1.txt  data\sub\tmp2.txt
   // strip the original base path, if any
   char *pszRelSrc = relName(pszGlblCopySrc, pszSrc);

   cs.dirsScanned++;
   sprintf(szLineBuf, "%u files %u dirs", cs.filesScanned, cs.dirsScanned);
   if (strlen(szLineBuf) > 20)
      info.setAddInfoWidth(strlen(szLineBuf));
   info.setStatus("scan ", pszRelSrc, szLineBuf);

   // build full target name: d:/tmp/subdir
   joinPath(szRefNameBuf, sizeof(szRefNameBuf), pszDstRaw, pszRelSrc);

   // strip trailing / if any
   int nRefLen = strlen(szRefNameBuf);
   if ((nRefLen > 0) && (szRefNameBuf[nRefLen-1] == glblPathChar))
      szRefNameBuf[nRefLen-1] = '\0';

   // REORDER: currently, pszSrc is the TARGET dir
   char *pszDst = pszSrc;
   pszSrc = szRefNameBuf;
   // NOW, pszSrc is the copy src, pszDst is the cleanup candidate.

   if (!isDir(pszSrc) && isDir(pszDst))
   {
      if (isEmptyDir(pszDst))
      {
         setTextColor(nGlblWarnColor);
         info.print("DEL: %s\n", pszDst);
         setTextColor(-1);
         if (!cs.sim && cs.yes) {
            int nrc = rmdir(pszDst);
            if (nrc)
               perr("failed to delete: %s\n", pszDst);
            else
               cs.dirsDeleted++;
         } else {
            cs.dirsDeleted++;
         }
      }
   }

   return 0;
}
// emod file_copy
#endif // (sfk_prog || sfk_file_copy)

typedef struct {
    char chunkID[4];        // "RIFF"
    uint32_t chunkSize;     // Size of the entire file minus 8 bytes
    char format[4];         // "WAVE"
    char subchunk1ID[4];    // "fmt "
    uint32_t subchunk1Size; // Size of the format chunk (16 for PCM)
    uint16_t audioFormat;   // Audio format (1 for PCM)
    uint16_t numChannels;   // Number of channels (1 for mono, 2 for stereo)
    uint32_t sampleRate;    // Sample rate (44100 for 44.1 kHz)
    uint32_t byteRate;      // Number of bytes per second
    uint16_t blockAlign;    // Number of bytes per sample frame
    uint16_t bitsPerSample; // Bits per sample (16 for 16-bit audio)
    char subchunk2ID[4];    // "data"
    uint32_t subchunk2Size; // Size of the audio data
} MinWAVHeader;

typedef struct {
    uint16_t audioFormat;   // Audio format (1 for PCM)
    uint16_t numChannels;   // Number of channels (1 for mono, 2 for stereo)
    uint32_t sampleRate;    // Sample rate (44100 for 44.1 kHz)
    uint32_t byteRate;      // Number of bytes per second
    uint16_t blockAlign;    // Number of bytes per sample frame
    uint16_t bitsPerSample; // Bits per sample (16 for 16-bit audio)
} WAVFmtHeader;

class SFKSound
{
public:
   SFKSound ( );

   int setFrom(uchar *pdata, int nsize, char *pname, bool bverbose=0);
       // caller owns memory

   int setOffsetAndCut(int iOffFrames, int iCutFrames);

   char *getid();
   uint  getsize();

uchar *rawptr;
uint   rawlen;

WAVFmtHeader fmt;
uchar *dataptr;
uint   datalen;

uchar *pcur;
uchar *pmax;
char   chunkid[20];
uint   chunksize;
uint   riffChunkSize;
uint  *riffChunkSizePtr;
uint   fmtChunkSize;
uint   dataChunkSize;
uint  *dataChunkSizePtr;
};

SFKSound::SFKSound( ) { memset(this, 0, sizeof(*this)); }

int SFKSound::setOffsetAndCut(int iOffFrames, int iCutFrames)
{
   short *pdata = (short*)dataptr;
   int    nfram = datalen/4;

   pdata += iOffFrames;
   nfram -= iOffFrames;
   nfram -= iCutFrames;
   if (nfram < 1)
      return 9;

   dataptr = (uchar*)pdata;
   datalen = nfram * 4;

   return 0;
}

char *SFKSound::getid() {
   if (pcur+4 >= pmax) return str("?");
   chunkid[0]=(char)*pcur++;
   chunkid[1]=(char)*pcur++;
   chunkid[2]=(char)*pcur++;
   chunkid[3]=(char)*pcur++;
   chunkid[4]='\0';
   // printf("getid offs 0x%x = '%s'\n",(pcur-rawptr),chunkid);
   return chunkid;
}

uint SFKSound::getsize() {
   uint n = ((uint)*pcur++) << 0;
   n |= ((uint)*pcur++) << 8;
   n |= ((uint)*pcur++) << 16;
   n |= ((uint)*pcur++) << 24;
   return (int)n;
}

int SFKSound::setFrom(uchar *pdata, int nsize, char *pname, bool bverbose)
{
   rawptr=pdata;
   rawlen=nsize;   

   pcur=rawptr;
   pmax=pcur+rawlen;

   if (bverbose) {
      printf("%s\n   total file size: %d\n", pname, nsize);
   }

   if (strcmp(getid(), "RIFF")) {
      printf("no valid wav file: %s\n",pname);
      return 10;
   }
   riffChunkSizePtr=(uint*)pcur;
   riffChunkSize=getsize();
   if (bverbose)
      printf("   riff chunk size: %u (-%d)\n", riffChunkSize, (int)(nsize-riffChunkSize));
   if (strcmp(getid(), "WAVE")) {
      printf("no valid wav file: %s\n",pname);
      return 11;
   }
   while (pcur<pmax) 
   {
      getid();
      if (!strcmp(chunkid, "fmt ")) {
         fmtChunkSize=getsize();
         if (bverbose)
            printf("   fmt chunk size : %u\n", fmtChunkSize);
         if (fmtChunkSize<sizeof(WAVFmtHeader)) {
            printf("invalid format chunk size %d: %s\n",fmtChunkSize,pname);
            return 12;
         }
         // we only understand that size
         memcpy(&fmt,pcur,sizeof(WAVFmtHeader));
         // but skip given size
         pcur += fmtChunkSize;
         continue;
      }
      if (strcmp(chunkid, "data")) {
         uint iskipsize=getsize();
         if (bverbose)
            printf("   skipping '%s' with %u bytes\n", chunkid, iskipsize);
         pcur+=iskipsize;
         continue;
      }
      // data chunk
      dataChunkSizePtr=(uint*)pcur;
      dataChunkSize=getsize();
      dataptr=pcur;
      datalen=dataChunkSize;
      if (bverbose) {
         uint ndataoff = (uint)(pcur-rawptr);
         uint nremain  = rawlen-ndataoff;
         printf("   pcm data size  : %u (offset=%u)\n", datalen, (uint)(pcur-rawptr));
         printf("   bytes from pcm : %u (+%d)\n", nremain, (int)(nremain-datalen));
      }
      break;
   }
   if (dataptr==0) {
      printf("no pcm data found: %s\n",pname);
      return 13;
   }

   return 0;
}

// dmod audio
#if defined(sfk_audio)

#ifndef SFK_WIN_XP

int playMemorySound(SFKSound *psnd, bool basync=0)
{
   #ifdef _WIN32

   int nmode = SND_NODEFAULT|SND_MEMORY;
   if (basync) nmode |= SND_ASYNC;
   if (sndPlaySound((LPCSTR)psnd->rawptr, nmode))
      return 0;
   return 9;

   #else

   // to support async play:
   pid_t pid = fork();
   if (pid == 0) {
      // child process within sfk.
      // run aplay child outside sfk.
      FILE *fplay = popen("aplay -f cd >/dev/null 2>&1", "w");
      if (fplay == NULL)
         return 9;
      fwrite(psnd->dataptr, 1, psnd->datalen, fplay);
      pclose(fplay);
      exit(0);
   } else if (pid > 0) {
      // parent process, sfk continuing
      if (!basync)
         wait(NULL);
   } else {
      // fork failed
      printf("error: cannot fork for aplay\n");
      return 9;
   }
   return 0;

   #endif
}

int execPlay(Coi *pin, char *pszOutFile, char **argx, int icmd, int ncmd)
{
   char *pszInFile = pin->name();

   if (!strEnds(pszInFile, ".wav"))
      return 0;

   // load file and get meta data
   num nsize=0;
   uchar *pdata = loadBinaryFlex(*pin, nsize);
   if (!pdata)
      return 9+perr("cannot load: %s\n",pin->name());

   CharAutoDel odel((char*)pdata);

   bool bmustwrite = cs.rewrite;

   if (pszOutFile == 0)
      pszOutFile = pin->name();
   else
      bmustwrite = 1;

   SFKSound snd;
   if (snd.setFrom(pdata, (int)nsize, pin->name(), cs.verbose))
      return 9;

   if (snd.fmt.bitsPerSample != 16) {
      printf("unsupported %d bits per sample: %s\n",snd.fmt.bitsPerSample,pin->name());
      return 9;
   }

   // todo: not yet usable without split / get
   if (snd.setOffsetAndCut(cs.nwavoff, cs.nwavcut))
      return 9+perr("invalid offset or cut");

   if (cs.debug)
      printf("chan=%u srate=%u bps=%u datalen=%u %s\n",
         snd.fmt.numChannels,
         snd.fmt.sampleRate,
         snd.fmt.bitsPerSample,
         snd.datalen,
         pin->name());

   bool bcut = cs.nwavoff || cs.nwavcut;
   int nchan = snd.fmt.numChannels;
   int nrate = snd.fmt.sampleRate;
   int nsamp = (int)(snd.datalen / 2);

   uchar *pnext = snd.dataptr;
   int16_t *psamp = (int16_t *)pnext;

   int16_t nmax = 0;
   for (int i = 0; i < nsamp; i++)
       if (abs(psamp[i]) > nmax)
           nmax = abs(psamp[i]);

   int nmaxperc = nmax*100/32767;
   int ngain = 100-nmaxperc;
   double normfact = 32767.0f / nmax;

   int iframes = snd.datalen/4;
   double dsec = 0.0;
   if (snd.fmt.sampleRate>0)
      dsec = (iframes*1.0)/snd.fmt.sampleRate;
   double dkhz = snd.fmt.sampleRate/1000.0;

   short *psrc = (short*)snd.dataptr;
   short *psrcmax = (short*)(snd.dataptr+snd.datalen);

   if (!bcut && !cs.listwav && !cs.normwav && !icmd)
   {
      // just play from file showing minimal infos
      printf("%1.1fkhz %1.1fsec %s\r", dkhz, dsec, pszInFile);
      fflush(stdout);
      #ifdef _WIN32
      uint nmode = SND_FILENAME;
      if (PlaySound(pszInFile, 0, nmode))
         printf("\n");
      else
         return 9+perr("cannot play: %s\n", pszInFile);
      #else
      if (!system(myvtext("aplay -q %s >/dev/null 2>&1", pszInFile)))
         printf("\n");
      else
         return 9+perr("cannot play: %s\n", pszInFile);
      #endif
      return 0;
   }

   // normalize source
   int inormdone=0;
   if (cs.normwav) {
      if (ngain < 3) {
         inormdone=1;
      } else {
         inormdone=2;
         int isrcsamp=snd.datalen/2;
         for (int i=0;i<isrcsamp;i++)
            psrc[i] = (int16_t)(psrc[i] * normfact);
      }
   }

   // just list/play/write
   if (!icmd)
   {
    do
    {
      /*
         sfk wav -norm dvsnd
            -> just list
         sfk play -norm dvsnd
            -> just play
         sfk play|wav -norm dvsnd -write
            -> no play, just write  (bmustwrite)
         sfk play|wav -norm dvsnd -todir out
            -> no play, just write  (bmustwrite)
      */
      if (!bmustwrite) {
         if (cs.listwav) {
            if (cs.verbose)
               printx("   rate=%1.1f t=%1.1fs vmax=%03d%%\n",
                  snd.fmt.sampleRate/1000.0, dsec, nmaxperc);
            else
               printx("rate=%1.1f t=%1.1fs vmax=%03d%% %s\n",
                  snd.fmt.sampleRate/1000.0, dsec, nmaxperc, pin->name());
         } else {
            if (bcut)
               printx("rate=%1.1f t=%1.1fs vmax=%03d%% %s\n",
                  snd.fmt.sampleRate/1000.0, dsec, nmaxperc, pin->name());
            else
               printx("vmax=%03d%% gain=%03d%% %s\r", nmaxperc, ngain, pszOutFile);
            if (playMemorySound(&snd))
               perr("failed to play: %s\n", pszInFile);
            else
               printf("\n");
         }
         break;
      }

      if (ngain < 3) {
         printx("skip : vmax=%03d%% gain=%03d%% %s (gain too low)\n", nmaxperc, ngain, pszOutFile);
      } else if (cs.yes) {
         saveFile(pszOutFile, pdata, nsize);
         printx("wrote: vmax=%03d%% gain=%03d%% %s\n", nmaxperc, ngain, pszOutFile);
      } else {
         printx("would write: vmax=%03d%% gain=%03d%% %s\n", nmaxperc, ngain, pszOutFile);
      }
    }
    while (0);
    return 0;
   }

   // extra processing: -split ... -get

   do
   {
      /*
         split 105 get 1 2 3
      */
      int icmdmax=icmd+ncmd;
      char *pcmd=argx[icmd++];
      if (strcmp(pcmd,"split"))
         return 9+perr("unknown wav command: %s\n",pcmd);
      if (icmd>=icmdmax) return 9;
      int ibpm=atoi(argx[icmd++]);
      if (ibpm<1)
         return 9+perr("invalid bpm after split\n");
   
      int ioutfactor=3;
   
      int nframes=nsamp/2;
      double ttotal=nframes/44100.0;
      double nbeats=(ttotal/60.0)*ibpm;
      double nparts=nbeats/4;
      int nsamptotal=nsamp;
      double dsampperbeat=nsamp/nbeats;
      printf("t=%1.3f beats=%1.3f parts=%1.3f %s\n",
         ttotal,nbeats,nparts,pin->name());
      // todo: no cmd -> get 1-* if * < maxarg
      if (icmd>=icmdmax)
         break;
      pcmd=argx[icmd++];
      #define MAX_REMIX_ARG 150
      char aremarg[MAX_REMIX_ARG+4][20];
      char *apremarg[MAX_REMIX_ARG+4];
      int imaxrem=MAX_REMIX_ARG;
      if (!strcmp(pcmd,"remix")) {
         if (icmd>=icmdmax) return 9;
         int inewparts=atoi(argx[icmd]);
         if (inewparts>imaxrem)
            return 9+perr("too large remix\n");
         for (int i=0;i<inewparts;i++) {
            sprintf(aremarg[i],"%d",(rand()%((int)nparts))+1);
            apremarg[i]=aremarg[i];
         }
         argx=apremarg;
         icmd=0;
         icmdmax=inewparts;
      } else {
         if (strcmp(pcmd,"get"))
            return 9+perr("unknown split sub command: %s\n",pcmd);
         if (icmd>=icmdmax) return 9;
         pcmd=argx[icmd];
         if (strchr(pcmd,'-')) {
            // get 5-10 or 5-* similar to remix
            int ifrom=atoi(pcmd);
            if (*pcmd=='*')
               ifrom=1;
            while (*pcmd && *pcmd!='-') pcmd++;
            pcmd++;
            int ito=atoi(pcmd);
            if (*pcmd=='*')
                ito=nparts;
            int inewparts=ito-ifrom+1;
            if (inewparts>imaxrem)
               return 9+perr("too large remix\n");
            for (int i=0;i<inewparts;i++) {
               sprintf(aremarg[i],"%d",ifrom+i);
               apremarg[i]=aremarg[i];
            }
            argx=apremarg;
            icmd=0;
            icmdmax=inewparts;
         }
      }
      int ioutparts=icmdmax-icmd;
      int ipartfactor=ioutparts/nparts;
      ioutfactor = (ipartfactor+2);
      // printf("using part factor %d\n", ioutfactor);
   
      // join 1 or more parts in a new wav
      uchar *pnew=new uchar[nsize*ioutfactor];
      if (!pnew) return 9+perr("outofmem");
      memcpy(pnew,pdata,nsize);

      SFKSound onew;
      onew.setFrom(pnew,nsize*3,pin->name());
   
      short *pdst = (short*)onew.dataptr;
      short *pdstmax = (short*)(onew.dataptr+onew.datalen*ioutfactor);
   
      // clear output buffer
      short *pdstcur=pdst;
      while (pdstcur<pdstmax)
         *pdstcur++=0;
      pdstcur=pdst;
   
      int ifirst=icmd;
      while (icmd<icmdmax)
      {
         char *ppart=argx[icmd++];
         int npart=atoi(ppart);
         if (npart<1)
            return 9+perr("invalid get part: '%s'\n",ppart);
   
         int ipart=npart-1;
         int ibeatsta=ipart*4;
         int ibeatend=ibeatsta+4;
         int isampsta=ibeatsta*dsampperbeat;
         isampsta &= (0xfffffffe); // align to full frames
         int isamplen=4*dsampperbeat;
         isamplen &= (0xfffffffe);
         int isampend=isampsta+isamplen;
   
         double dsampsta=(isampsta/2)/44100.0;
   
         // printf("isampsta %d len %d spb %1.3f\n",isampsta,isamplen,dsampperbeat);
         printf("get part %02d @%07.3f with %d bytes\n",
            npart, dsampsta, isamplen*2);
   
         if (psrc+isampsta+isamplen>psrcmax) {
            printf("end of source, cutting\n");
            break;
         }
         if (pdstcur+isamplen>pdstmax) {
            printf("output buffer full, cutting\n");
            break;
         }
         memcpy(pdstcur,psrc+isampsta,isamplen*2);
         pdstcur+=isamplen;         
      }
      int idonesamp=pdstcur-pdst;
      double ddonesec=(idonesamp/2)/44100.0;
      *onew.dataChunkSizePtr = idonesamp*2;
   
      if (bmustwrite) {
         int nnewdata = idonesamp*2;
         uchar *pnewdataend = onew.dataptr+nnewdata;
         int nnewsize = pnewdataend - onew.rawptr;
         int inewriffsize = nnewsize-8;
         *onew.riffChunkSizePtr = inewriffsize;
         if (cs.verbose) {
            SFKSound otmp;
            otmp.setFrom(pnew,nnewsize,pszOutFile,1); // just to show infos
         }
         if (cs.yes) {
            printf("write %1.3f sec (%d bytes): %s\n",ddonesec,idonesamp*2,pszOutFile);
            saveFile(pszOutFile, pnew, nnewsize);
         } else {
            printf("would write %1.3f sec (%d bytes): %s\n",ddonesec,idonesamp*2,pszOutFile);
         }
      } else {
         #if 1
         printf("play %1.3f sec (%d bytes)\r",ddonesec,idonesamp*2);
         int itotalmsec=(int)(ddonesec*1000);
         int ilast=icmdmax;
         int iparts=ilast-ifirst;
         int ipartmsec=itotalmsec/iparts;
         // printf("\n%d parts of %d msec each (%d-%d)\n",iparts,ipartmsec,ifirst,ilast);
         playMemorySound(&onew, 1);
         for (int i=0;i<iparts;i++)
         {
            char *ppart=argx[ifirst+i];
            int npart=atoi(ppart);
 
            int ipart=npart-1;
            int ibeatsta=ipart*4;
            int ibeatend=ibeatsta+4;
            int isampsta=ibeatsta*dsampperbeat;
            isampsta &= (0xfffffffe); // align to full frames
 
            printf("\n%02d - %04x %04x\r",
               npart,
               (ushort)psrc[isampsta+0],(ushort)psrc[isampsta+1]);
            fflush(stdout);
 
            doSleep(ipartmsec);
         }
         printf("\n");
         #else
         #ifdef _WIN32
         printf("play %1.3f sec (%d bytes)\r",ddonesec,idonesamp*2);
         int itotalmsec=(int)(ddonesec*1000);
         int ilast=icmdmax;
         int iparts=ilast-ifirst;
         int ipartmsec=itotalmsec/iparts;
         // printf("\n%d parts of %d msec each (%d-%d)\n",iparts,ipartmsec,ifirst,ilast);
         sndPlaySound((LPCSTR)pnew, SND_ASYNC|SND_NODEFAULT|SND_MEMORY);
         for (int i=0;i<iparts;i++) 
         {
            char *ppart=argx[ifirst+i];
            int npart=atoi(ppart);
   
            int ipart=npart-1;
            int ibeatsta=ipart*4;
            int ibeatend=ibeatsta+4;
            int isampsta=ibeatsta*dsampperbeat;
            isampsta &= (0xfffffffe); // align to full frames
   
            printf("\n%02d - %04x %04x\r",
               npart,
               (ushort)psrc[isampsta+0],(ushort)psrc[isampsta+1]);
            fflush(stdout);
   
            doSleep(ipartmsec);
         }
         printf("\n");
         #endif
         #endif
      }
   
      delete [] pnew;

   } while (0);

   return 0;
}
#endif // not SFK_WIN_XP

// emod
#endif // (sfk_audio)

// dmod zip
#if (sfk_prog || sfk_zip)
#ifdef SFKPACK

#define FOR_SFK_INCLUDE
#ifndef USE_SFKLIB3
 #include "sfkpackio.hpp"
#endif

#define crc32 sfkPackSum

StringTable glblZipList;

// IN: if pout==0 use cs.outfile
int execPackFile(Coi *pin, Coi *pout, bool bPack) // for gzip, gunzip
{
   if (cs.debug)
      printf("execPackFile  :  %s\n", pin->name());

   if (cs.yes == 0)
   {
      num nFileSize = pin->getSize();
      info.print("file %03dm %s\n", (int)(nFileSize/1000000), pin->name());
      cs.totaloutbytes += nFileSize;
      return 0;
   }

   num nstart = getCurrentTime();
   num ntold  = nstart;

   if (pin->open("rb"))
      return 9+perr("cannot read: %s\n", pin->name());

   uint crcraw = 0;
   uint crcout = 0;
   uint crcthru= 0;

   num nTotalIn = pin->getSize();
   num nInTime  = pin->getTime();
   num nPosPackSize = 0;

   if (pout==0)
      return 9;
   if (pout->open("wb"))
      return 9;

   int iInBufSize  = 100000;
   int iOutBufSize = iInBufSize;
   int iOutCacheSize = 2000000;

   char *pInBuf  = new char[iInBufSize+100];
   char *pOutBuf = new char[iOutBufSize+100];
   char *pOutCache = new char[iOutCacheSize+100];

   if (!pInBuf || !pOutBuf || !pOutCache)
      return 9+perr("outofmem\n");

   CharAutoDel odel1(pInBuf);
   CharAutoDel odel2(pOutBuf);
   CharAutoDel odel3(pOutCache);

   SFKPackStream ostrm;
   mclear(ostrm);

   ostrm.bPack = bPack;
   ostrm.bFast = cs.fastcomp;

   sfkPackStart(&ostrm);

   bool bLastBlock = 0, bCopyThrough = 0;
   int  bReloop = 0, nRead = 0, isubrc = 0;

   num nDoneIn  = 0;
   num nDoneOut = 0;

   int irc = 0;

   char szAddInfo[100];    szAddInfo[0] = '\0';
   char szLeftInfo[100];   szLeftInfo[0] = '\0';

   strcpy(szLeftInfo,bPack?"pack":"unpak");

   info.setProgress(nTotalIn, nDoneIn, "bytes", 1);
   info.setAction(szLeftInfo, pin->name(), "");

   while (1)
   {
      if (bReloop == 0)
      {
         int iMaxRead = iInBufSize;

         nRead  = (int)pin->read(pInBuf, iMaxRead);

         if (nRead < 1)
            break;
         if (nRead < iMaxRead)
            bLastBlock = 1;

         nDoneIn += nRead;

         ostrm.pin  = (uchar*)pInBuf;
         ostrm.nin  = nRead;

         cs.totalinbytes += nRead;
         sprintf(szLeftInfo, "%04dm", (int)(cs.totalinbytes/1000000));
      }

      ostrm.pout = (uchar*)pOutBuf;
      ostrm.nout = iOutBufSize;

      isubrc = sfkPackProc(&ostrm, bLastBlock, &bReloop);

      if (   isubrc != 0
          && isubrc != 1  // EOD
          && isubrc != -5 // Z_BUF_ERROR is ignored!
         )
      {
         perr("extract error %d\n",isubrc);
         irc = isubrc;
         break;
      }

      if (ostrm.nout > 0)
      {
         nDoneOut += ostrm.nout;

         if (pout->write((uchar*)ostrm.pout, ostrm.nout) < ostrm.nout) {
            perr("cannot fully write, disk full\n");
            irc = 9;
            break;
         }
      }

      if (getCurrentTime() - ntold >= 5000)
      {
         info.setAction(szLeftInfo, pin->name(), 0, eKeepAdd);

         ntold = getCurrentTime();

         num iElapsed = getCurrentTime() - nstart;
         num nTimeEst = (nTotalIn * iElapsed) / (nDoneIn ? nDoneIn : 1);
         num nTimeRem = nTimeEst - iElapsed;

         // avoid 64 * 64 bit overflow on output estimation
         num nDoneOutMB = nDoneOut / 1000000;
         num nTotalInMB = nTotalIn / 1000000;
         num nDoneInMB  = nDoneIn  / 1000000;

         if (nDoneInMB > 0)
         {
            int iRatio    = (nDoneOut * 100) / (nDoneIn ? nDoneIn : 1);
            num nOutEstMB = (nDoneOutMB * nTotalInMB) / (nDoneInMB ? nDoneInMB : 1);
            sprintf(szAddInfo, "=> %02d%% %sm %ds", iRatio, numtoa(nOutEstMB), (int)(nTimeRem/1000));
            info.setStatus(szLeftInfo, pin->name(), szAddInfo);
         }
      }

      info.setProgress(nTotalIn, nDoneIn, "bytes", 1);
   }

   sfkPackEnd(&ostrm);

   pout->close();
   pin->close();

   cs.totaloutbytes += nDoneOut;

   int iElapsed = getCurrentTime() - nstart;

   int iRatio   = (nDoneOut * 100) / (nDoneIn ? nDoneIn : 1);

   info.print("%s %d/%d mb in %03d ms (%s/%s)\n",
      bPack?"packed":"unpked",
      (int)(nTotalIn/1000000), (int)(nDoneOut/1000000),
      iElapsed,
      numtoa(nTotalIn, 1, szLineBuf),
      numtoa(nDoneOut, 1, szLineBuf2)
      );

   return irc;
}

// --------------------- zip support ---------------------

typedef struct tm_zip_s
{
    uint tm_sec;
    uint tm_min;
    uint tm_hour;
    uint tm_mday;
    uint tm_mon;
    uint tm_year;
} tm_zip;

typedef struct
{
    tm_zip      tmz_date;
    ulong       dosDate;
    ulong       internal_fa;
    ulong       external_fa;
} zip_fileinfo;

extern "C"
{
int zipOpenNewFileInZip3_64(void *file, const char* filename,
  const zip_fileinfo* zipfi,
  const void* extrafield_local, uint size_extrafield_local,
  const void* extrafield_global, uint size_extrafield_global,
  const char* comment, int method, int level, int raw,
  int windowBits, int memLevel, int strategy,
  const char* password, ulong crcForCrypting, int zip64);

int zipOpenNewFileInZip4_64(void *file, const char* filename,
  const zip_fileinfo* zipfi,
  const void* extrafield_local, uint size_extrafield_local,
  const void* extrafield_global, uint size_extrafield_global,
  const char* comment, int method, int level, int raw,
  int windowBits, int memLevel, int strategy,
  const char* password, ulong crcForCrypting,
  uLong versionMadeBy, uLong flagBase, int zip64);

int zipWriteInFileInZip(void *file, const void* buf, unsigned int len);
int zipCloseFileInZip(void *file);
int zipClose(void *file, const char* global_comment);
}

#ifdef USE_SFKLIB3
extern "C" {
int sfkOpenNewFileInZip(void *file,
      const char* filename, const zip_fileinfo* zipfi,
      const void* extrafield_local, uInt size_extrafield_local,
      const void* extrafield_global, uInt size_extrafield_global,
      const char* comment, int method, int level, int raw,
      int windowBits,int memLevel, int strategy,
      const char* password, uLong crcForCrypting,
      uLong versionMadeBy, uLong flagBase, int zip64);
void zipGetStatus(void *file, sfkuint64 *pTotalOut);
}
#else
int sfkOpenNewFileInZip(void *file,
      const char* filename, const zip_fileinfo* zipfi,
      const void* extrafield_local, uInt size_extrafield_local,
      const void* extrafield_global, uInt size_extrafield_global,
      const char* comment, int method, int level, int raw,
      int windowBits,int memLevel, int strategy,
      const char* password, uLong crcForCrypting,
      uLong versionMadeBy, uLong flagBase, int zip64);
void zipGetStatus(void *file, sfkuint64 *pTotalOut);
#endif

#ifdef _WIN32
unum getWinFileTime(char *pszFileName)
{
   FileStat ofs;
   if (ofs.readFrom(pszFileName))
      return 0;

   FILETIME *pft = &ofs.src.ftMTime;
   unum nwft =     (((unum)pft->dwHighDateTime) << 32)
                |  (((unum)pft->dwLowDateTime));

   return nwft;
}
#endif

void printFile(cchar *pszVerb, cchar *pszName, num nDoneIn, num nDoneOut, int nflags=0)
{
   bool bloud       = (nflags & 1);
   bool bForceRatio = (nflags & 2) ? 1 : 0;
   bool bShowFlags  = (nflags & 8) ? 1 : 0;
   bool bIsUTF      = (nflags & 16) ? 1: 0;
   bool bIsExec     = (nflags & 32) ? 1: 0;
   bool bIsDir      = (nflags & 64) ? 1: 0;
   bool bIsAutoUTF  = (nflags & 128) ? 1: 0;

   if (bloud == 0 && cs.quiet > 0)
      return;

   char szAnsi[SFK_MAX_PATH+100];
   char szRatio[30]; szRatio[0]='\0';
   char szAttr[30];  szAttr[0]='\0';

   #ifdef _WIN32
   if (cs.uname && !cs.showrawname)
      utfToAnsi(szAnsi, SFK_MAX_PATH, (char*)pszName);
   else
   #endif
      strcopy(szAnsi, pszName);

   strcpy(szRatio, bForceRatio ? "---- " : "");

   num nToShow = nDoneIn;

   if (nDoneOut > 0) {
      nToShow = nDoneOut;
      int iRatio = (nDoneOut * 100) / (nDoneIn ? nDoneIn : 1);
      sprintf(szRatio, "%03d%% ", iRatio);
   } else {
      // strcpy(szRatio, "100% ");
   }

   if (bShowFlags)
   {
      bIsUTF |= bIsAutoUTF;
      char cExec = bIsDir ? ' ' : 'x';
      char cUTF  = bIsAutoUTF ? '*' : 'u';
      if (bIsUTF && !bIsExec)
         sprintf(szAttr, " $%c", cUTF);
      else if (!bIsUTF && bIsExec)
         sprintf(szAttr, " $%c", cExec);
      else if (bIsUTF==1 && bIsExec==1 && cExec!=' ')
         sprintf(szAttr, " $%c%c", cUTF, cExec); // rare case, indent change ok
      else
         strcpy(szAttr, " $ ");
   }

   cchar *pspc = pszVerb[0] ? " " : "";
   cchar *pvcol = strcmp(pszVerb, "replc") ? "" : "<warn>";

   if (nToShow == 0) // dir
      printx("%s%s%s<time>----%s<def><nocol> %s%s\n", pvcol, pszVerb, pspc, szAttr, szRatio, szAnsi);
   else if (nToShow < 1000)
      printx("%s%s%s<time>%03u %s<def><nocol> %s%s\n", pvcol, pszVerb, pspc, (uint)(nToShow), szAttr, szRatio, szAnsi);
   else if (nToShow < 1000000)
      printx("%s%s%s$%03uk%s<def><nocol> %s%s\n", pvcol, pszVerb, pspc, (uint)(nToShow/1000), szAttr, szRatio, szAnsi);
   else
      printx("%s%s%s#%03.0fm%s<def><nocol> %s%s\n", pvcol, pszVerb, pspc, (nToShow/1000000.0), szAttr, szRatio, szAnsi);
}

void printFileSimple(cchar *pszVerb, cchar *pszName, cchar *pszMid)
{
   char szAnsi[SFK_MAX_PATH+100];
   char szAttr[30];  szAttr[0]='\0';

   #ifdef _WIN32
   if (cs.uname && !cs.showrawname)
      utfToAnsi(szAnsi, SFK_MAX_PATH, (char*)pszName);
   else
   #endif
      strcopy(szAnsi, pszName);

   printx("%s%s%s\n", pszVerb, pszMid, szAnsi);
}

char *relativePath(char *psrc)
{
   #ifdef _WIN32
   int ilen = strlen(psrc);
   if (ilen>=2 && isalpha(*psrc)!=0 && psrc[1]==':') {
      psrc += 2;
      while (*psrc=='\\' || *psrc=='/')
         psrc++;
   } else {
      while (*psrc=='\\' || *psrc=='/')
         psrc++;
   }
   #else
   while (*psrc=='/')
      psrc++;
   #endif

   return psrc;
}

SFKChars zipchars; // cp437 support

StringTable glblZipDirs;
CoiTable    glblUnzipDirs;
CoiTable    glblZipSortSize;
CoiTable    glblZipSortTime;

void makeUniPathChars(char *psz) {
   for (; *psz; psz++)
      if (*psz=='\\')
         *psz='/';
}

void utftooem(char *poem, int imaxoem, char *putf)
{
   char *pmaxoem = poem+imaxoem;
   UTF8Codec utf((char*)putf, strlen(putf));
   while (utf.hasChar()) {
      if (poem+6 >= pmaxoem)
         break;
      ushort nuni = utf.nextChar();
      uchar noem = zipchars.unitooem(nuni);
      if (noem == 0) {
         sprintf(poem, "#U%04x", nuni);
         poem += 6;
      } else {
         *poem++ = noem;
      }
   }
   *poem='\0';
}

// bDir 1: physical folder
// bDir 2: virtual folder just in zip
int execZipFile(Coi *pin, int bDir, int iLevel)
{
   if (cs.debug) printf("----- execZipFile -----\n");

   // utf-mode only
   if (!cs.uname)
      return 9+perr("int. error #218411\n");

   #ifdef VFILEBASE
   // cannot accept http:// etc.
   if (pin->isNet()) {
      perr("cannot use for zip: %s", pin->name());
      pinf("download files before zipping.\n");
      return 9;
   }
   #endif

   // is this the add virtual folder call?
   bool bVDir = (bDir >= 2) ? 1 : 0;

   if (cs.aname && pin->bClBadName)
   {
      perr("cannot read unicode filename: %s\n", pin->name());
      cs.numBadFileNames++;
      return 9;
   }

   char szAbsNameUTF[SFK_MAX_PATH+100];   szAbsNameUTF[0]='\0';
   char szAbsPathUTF[SFK_MAX_PATH+100];   szAbsPathUTF[0]='\0';
   char szRelPathUTF[SFK_MAX_PATH+100];   szRelPathUTF[0]='\0';
   char szRelPathOEM[SFK_MAX_PATH+100];   szRelPathOEM[0]='\0';
   char szParPathUTF[SFK_MAX_PATH+100];   szParPathUTF[0]='\0';
   char szParPathSla[SFK_MAX_PATH+100];   szParPathSla[0]='\0';
   char szParPathOEM[SFK_MAX_PATH+100];   szParPathOEM[0]='\0';
   char szInZipNameUTF[SFK_MAX_PATH+100]; szInZipNameUTF[0]='\0';
   char szInZipNameOEM[SFK_MAX_PATH+100]; szInZipNameOEM[0]='\0';
   char szMatchBuf[SFK_MAX_PATH+100];     szMatchBuf[0]='\0';
   char szToMaskBuf[SFK_MAX_PATH+100];    szToMaskBuf[0]='\0';

   cchar *pind = pszGlblBlank;
   int    iind = iLevel;

   // --- 1. all must be utf internal ---

   char *pszToPackName = cs.rootrelname ? pin->rootRelName() : pin->name();

   if (strlen(pszToPackName) < 1)
      return 0;

   strcopy(szAbsNameUTF, pszToPackName);

   #ifdef _WIN32
   // handle sfk sel ... +zipto
   // sfk1935: fix double conversion by iLevel check
   if (cs.bzipto==1 && cspre.uname==0 && iLevel==0)
   {
      // filename list was passed, pin has no utf so far.
      // actively convert to utf-8.
      ansiToUTF(szAbsNameUTF, SFK_MAX_PATH, pszToPackName);
      // must do this as cs.uname expects utf name for access
      pin->setName(szAbsNameUTF);
   }
   #endif

   if (cs.debug) printf("%.*sAbsNameUTF: %s\n",iind,pind, szAbsNameUTF);

   bool bNameSeemsUTF = UTF8Codec::isValidUTF8(szAbsNameUTF);
   bool bAnyHiCodes   = anyHiCodes(szAbsNameUTF);

   if (bAnyHiCodes==1 && bNameSeemsUTF==0)
      cs.inonutfhicodes = 1;

   // --- 2. instant dir entry creation check ---

   strcopy(szAbsPathUTF, szAbsNameUTF);
   int iAbsPathLen = strlen(szAbsPathUTF);

   if (bVDir)
      { } // don't touch the vdir/ path
   if (bDir) {
      // get pure dir name without slash
      while (iAbsPathLen>0 && szAbsPathUTF[iAbsPathLen-1]==glblPathChar)
         iAbsPathLen--;
      szAbsPathUTF[iAbsPathLen]='\0';
   } else {
      // extract dir name from file name
      char *psz = strrchr(szAbsPathUTF,glblPathChar);
      if (psz)
         *psz='\0';
      else
         szAbsPathUTF[0]='\0'; // no path given
   }
   iAbsPathLen = strlen(szAbsPathUTF);

   if (cs.debug) printf("%.*sAbsPathUTF: %s\n",iind,pind, szAbsPathUTF);

   // only in main pass
   if (bVDir==0 && cs.toziplist==0)
   do
   {
      // path name valid at all?
      if (iAbsPathLen<1) break;
      #ifdef _WIN32
      if (szAbsPathUTF[iAbsPathLen-1]==':') break;
      #endif

      // is dir already contained in existing zip?
      // ziplist contains
      // -  non absolute path
      // -  forward slashes
      char *pszrel = relativePath(szAbsPathUTF);
      strcopy(szRelPathUTF, pszrel);
      strcat(szRelPathUTF, "/");
      makeUniPathChars(szRelPathUTF);
      utftooem(szRelPathOEM, SFK_MAX_PATH, szRelPathUTF);

      if (cs.debug) printf("%.*s  RelPathUTF: %s\n",iind,pind, szRelPathUTF);
      if (cs.debug) printf("%.*s  RelPathOEM: %s\n",iind,pind, szRelPathOEM);

      if (glblZipList.find(szRelPathUTF) != -1) break;
      if (glblZipList.find(szRelPathOEM) != -1) break;

      // instant add-dir due to first file of dir?
      if (bDir==0)
      {
         // if not yet done for this file
         if (glblZipDirs.find(szAbsPathUTF) != -1)
            break;
         Coi otmp(szAbsPathUTF,0);
         otmp.getSize(); // force reading now sfk1935
         otmp.getTime(); // force reading now
         // printf("maketmp1: %s %s level=%d\n",szAbsPathUTF,numtoa(otmp.getSize()),iLevel);
         execZipFile(&otmp,1,iLevel+1);
      }
      else
      {
         // this is the add-dir call
         do
         {
            // is there a parent dir?
            strcopy(szParPathUTF, szAbsPathUTF);
            char *psz = strrchr(szParPathUTF, glblPathChar);
            if (!psz) break;
            *psz = '\0';

            if (cs.debug) printf("%.*s  ParPathUTF: %s\n",iind,pind, szParPathUTF);

            int iParDirLen = strlen(szParPathUTF);
            if (iParDirLen < 1) break;
            #ifdef _WIN32
            if (szParPathUTF[iParDirLen-1]==':') break;
            #endif

            strcopy(szParPathSla, szParPathUTF);
            strcat(szParPathSla, "/");

            utftooem(szParPathOEM, SFK_MAX_PATH, szParPathSla);

            if (cs.debug) printf("%.*s  ParPathOEM: %s\n",iind,pind, szParPathOEM);

            if (glblZipList.find(szParPathSla) != -1) break; // in-zip utf
            if (glblZipList.find(szParPathOEM) != -1) break; // in-zip oem

            if (glblZipDirs.find(szParPathUTF) != -1) break; // created utf

            // then add parent dir first
            Coi otmp(szParPathUTF,0);
            otmp.getSize(); // force reading now sfk1935
            otmp.getTime(); // force reading now
            // printf("maketmp2: %s %s level=%d\n",szParPathUTF,numtoa(otmp.getSize()),iLevel);
            execZipFile(&otmp,1,iLevel+1);
         } while (0);

         // then add our path
         glblZipDirs.addEntry(szAbsPathUTF);
         // fall through
      }
   }
   while (0);

   // --- 3. setup in-zip raw file name ---

   // non absolute filename
   char *pszrel = relativePath(szAbsNameUTF);
   strcopy(szRelPathUTF, pszrel);
   makeUniPathChars(szRelPathUTF);

   // force slash after folder names
   int iRelPathLen = strlen(szRelPathUTF);
   if (bDir>0 && iRelPathLen>0 && szRelPathUTF[iRelPathLen-1]!='/')
      strcat(szRelPathUTF, "/");

   // block some path traversals
   if (   strBegins(szRelPathUTF, "../")
       #ifndef _WIN32
       || strBegins(szRelPathUTF, "~/")
       #endif
      )
   {
      perr("forbidden path start: %s", szRelPathUTF);
      pinf("cd to folder before zipping.\n");
      return 9;
   }

   // create in-zip filename:
   if (cs.tomask!=0 && bVDir==0)
   {
      ansiToUTF(szToMaskBuf, SFK_MAX_PATH, cs.tomask);
      Coi osub(szRelPathUTF, 0);
      int nrc = renderOutMask(szInZipNameUTF, &osub, szToMaskBuf, cs.curcmd, 1);
      if (nrc > 0)
         return 19+perr("invalid -asdir given");
   } else {
      strcopy(szInZipNameUTF, szRelPathUTF);
   }
   utftooem(szInZipNameOEM, SFK_MAX_PATH, szInZipNameUTF);

   if (cs.debug) printf("%.*sInZipNmUTF: %s\n",iind,pind, szInZipNameUTF);
   if (cs.debug) printf("%.*sInZipNmOEM: %s\n",iind,pind, szInZipNameOEM);

   // check against ziplist
   if (   glblZipList.find(szInZipNameUTF) != -1
       || glblZipList.find(szInZipNameOEM) != -1
      )
   {
      if (bDir) {
         // a folder entry already exists in the zip.
         // ignore silently, we cannot update the timestamp.
         return 0;
      }

      perr("already exists in zip: %s\n", szInZipNameUTF);
      cs.nzipredundant++;
      return 9;
   }
   if (glblZipDirs.find(szInZipNameUTF) != -1)
      return 0; // already created

   int nPrintFlags = 8 + (bDir ? 64 : 0);

   // ----- prepare setexec -----
   bool bSetExec = 0;
   int iMasks = glblGrepPat.numberOfEntries();
   for (int imask=0; imask<iMasks; imask++)
   {
      // TEMPORARY use of szAttrBuf2 to build /mask/
      snprintf(szMatchBuf, MAX_LINE_LEN, "/%s/", szInZipNameUTF);
      char *pmask = glblGrepPat.getString(imask);
      int n1=0, n2=0;
      bool bneg   = 0;
      if (*pmask==glblNotChar)
         { bneg=1; pmask++; }
      bool bmatch = matchstr(szMatchBuf, pmask, 0, n1, n2);
      if (bneg) {
         // apply blacklisting: -setexec .h !.html
         if (bmatch)
            { bSetExec=0; break; }
      } else {
         // apply whitelisting: -setexec .sh
         if (bmatch)
            { bSetExec=1; }
      }
   }
   if (bSetExec)
      nPrintFlags |= 32;

   /*
      we now have:
      -  szInZipNameUTF
      -  szInZipNameOEM, possibly with #Uxxxx marks
      with sfk zip
      -  create main filename as OEM
      -  create 7075 extension as UTF
         if utf differs at all
      with sfk zipuni (unameout)
      -  create main filename as UTF
   */
   bool  bNeedOutUTF = strcmp(szInZipNameOEM, szInZipNameUTF) ? 1 : 0;
   uLong nInZipFlags = 0;

   #ifdef _WIN32
   char *pszPriOutName = szInZipNameOEM;
   char *pszExtOutName = szInZipNameUTF;
   if (bNeedOutUTF) {
      if (cs.unameout) {
         pszPriOutName = szInZipNameUTF;
         pszExtOutName = 0;
         nInZipFlags = (1U << 11);
      }
      nPrintFlags |= 16;
      cs.iutfnames++;
   } else {
      pszExtOutName = 0;
   }
   #else
   // linux: only one name
   char *pszPriOutName = szInZipNameUTF;
   char *pszExtOutName = 0;
   if (UTF8Codec::isValidUTF8(szInZipNameUTF))
   {
      nInZipFlags = (1U << 11);
      nPrintFlags |= 16;
      cs.iutfnames++;
   }
   #endif

   if (cs.debug) printf("%.*s=> OutNamePri: %s\n",iind,pind, pszPriOutName);
   if (cs.debug) printf("%.*s=> OutNameExt: %s\n",iind,pind, pszExtOutName ? pszExtOutName : "");

   if (cs.yes == 0)
   {
      if (!cs.toziplist)
      {
         info.clear();
         printFile("add", szInZipNameUTF, pin->getSize(), 0, nPrintFlags);
         cs.totaloutbytes += pin->getSize();

         if (bDir == 0) {
            pin->setExtStr(szInZipNameUTF);
            if (cs.listBySize)
               glblZipSortSize.addSorted(*pin, 'S', 0);
            if (cs.listByTime)
               glblZipSortTime.addSorted(*pin, 't', 0);
            if (!bDir) cs.filesZip++; // zip
         }
      }
      return 0;
   }

   // --- render output subfile ---

   num nstart = getCurrentTime();
   num ntold  = nstart;

   int iInBufSize = 100000;

   char *pInBuf   = new char[iInBufSize+100];

   if (!pInBuf)
      return 19+perr("outofmem\n");

   CharAutoDel odel1(pInBuf);

   if (bDir==0)
      if (pin->open("rb"))
         return 9+perr("cannot read: %s\n", pin->name());

   uint crcraw = 0;
   uint crcout = 0;
   uint crcthru= 0;

   num nTotalIn = pin->getSize();
   num nInTime1 = pin->getTime();

   num nInTime2 = nInTime1;

   if (cs.mofftime != 0)
   do
   {
      int iFileInDst   = 0;
      mytime_t ntfile  = (mytime_t)nInTime1;
      struct tm *mytm  = mylocaltime(&ntfile); // safe
      if (!mytm) break;
      iFileInDst       = mytm->tm_isdst;

      mytime_t   nnow  = mytime(NULL);
      struct tm *pnow  = mylocaltime(&nnow); // safe
      if (!pnow) return 9+perr("cannot get time");
      if (pnow->tm_isdst) {
         // computer is in DST
         if (iFileInDst == 0 && nInTime2 >= 3600) {
            // and we have a winter range file
            if (cs.debug) printf("adjust time -1h : %s\n", pin->name());
            nInTime2 -= 3600;
         }
      } else {
         // computer is in winter
         if (iFileInDst != 0) {
            // and we have a summer range file
            if (cs.debug) printf("adjust time +1h : %s\n", pin->name());
            nInTime2 += 3600;
         }
      }
   }
   while (0);

   num nPosPackSize = 0;
   num nDoneIn  = 0;
   num nDoneOut = 0;

   int zip64 = (nTotalIn >= 2000 * 1000000) ? 1 : 0;

   if (cs.force64)
       zip64 = 1;

   zip_fileinfo zi;
   mclear(zi);

   uchar aExtraFields[SFK_MAX_PATH+200];
   mclear(aExtraFields);

   num  nTimeForNTFS = (cs.mofftime & 4) ? nInTime2 : nInTime1;
   unum nNTFSTime    = (nTimeForNTFS * 10000000) + 116444736000000000LL;

   #ifdef _WIN32
   // cannot handle vnames, due to getFileStat.
   //   nNTFSTime = getWinFileTime(pin->name());
   //   if (cs.verbose) printf("store ntfstime: %s\n",numtoa(nNTFSTime));
   #endif

   uchar *p = aExtraFields;
   ushort nExtraSize1=0, nExtraSize2=0, nExtraSize3=0;

   // --- NTFS Extra Field ---
 
   nExtraSize1 = 8 + 24; // from: reserved

   *p++ = 0x0A;   // ntfs tag
   *p++ = 0x00;
   *p++ = nExtraSize1;
   *p++ = (nExtraSize1 >> 8);

    p  += 4;      // reserved

   *p++ = 0x01;   // time tag
   *p++ = 0x00;

   *p++ = 24;     // tag len
   *p++ = 0;

   for (int k=0; k<3; k++)
   {
      uint nlo = (uint)(nNTFSTime);
      uint nhi = (uint)(nNTFSTime >> 32);
      for (int i=0; i<4; i++)
         { *p++ = nlo; nlo >>= 8; }
      for (int i=0; i<4; i++)
         { *p++ = nhi; nhi >>= 8; }
   }

   nExtraSize1 += 4; // add header

   // --- Unix Extra Field ---

   nExtraSize2 = 12; // from: access time

   *p++ = 0x0D;   // unix tag
   *p++ = 0x00;
   *p++ = nExtraSize2;
   *p++ = (nExtraSize2 >> 8);

   num  nTimeForUnix = (cs.mofftime & 2) ? nInTime2 : nInTime1;

   // printf("### UnixTime: %u 0x%x\n", (uint)nTimeForUnix, (uint)nTimeForUnix);

   uint nlo = (uint)(nTimeForUnix);   // access time
   for (int i=0; i<4; i++)
      { *p++ = nlo; nlo >>= 8; }

   nlo = (uint)(nTimeForUnix);   // mod time
   for (int i=0; i<4; i++)
      { *p++ = nlo; nlo >>= 8; }

   for (int i=0; i<4; i++)  // uid, gid
      *p++ = 0;

   nExtraSize2 += 4; // add header

   // --- windows: utf path extra field ---

   #ifdef _WIN32
   if (pszExtOutName)
   {
      // sfk zip (not zipuni): utf as extension
      uint iutflen = strlen(pszExtOutName);
      nExtraSize3 = 5 + iutflen;

      *p++ = 0x75;
      *p++ = 0x70;
      *p++ = nExtraSize3;
      *p++ = (nExtraSize3 >> 8);

      *p++ = 0x01;

      // uint ncrc = sfkPackSum((uchar*)pszExtOutName, iutflen, 0);
      uint ncrc = sfkPackSum((uchar*)pszPriOutName, strlen(pszPriOutName), 0);
      for (int i=0; i<4; i++)
         { *p++ = ncrc; ncrc >>= 8; }

      for (int i=0; i<iutflen; i++)
         *p++ = pszExtOutName[i];

      nExtraSize3 += 4; // add header
   }
   #endif

   // --- end extra fields ---

   ushort nTotalExtraSize = nExtraSize1 + nExtraSize2 + nExtraSize3;

   // versionMadeBy: important for +x flag support
   uLong nVersionMadeBy = 0;

   #ifdef _WIN32
   // this causes NAME DECODE FAILURE at other unzip tools.
   // therefore behave like 7zip.exe and NULL it.
   // Info-Zip zip.exe writes "11" here which is bullshit.
   //    nVersionMadeBy = ((uint)10) << 8;   // Windows NTFS
   #else
    #ifdef MAC_OS_X
    nVersionMadeBy = ((uint)7) << 8;   // Macintosh
    #else
    // this is required for +x support by extractors:
    nVersionMadeBy = ((uint)3) << 8;   // Unix
    #endif
   #endif

   // ziptime-dos

   num nTimeForDos = (cs.mofftime & 1) ? nInTime2 : nInTime1;

   mytime_t now        = (mytime_t)nTimeForDos;
   struct tm *mytm     = mylocaltime(&now); // safe

   if (!mytm) { // fix sfk1935 crash on umlaut folders
      if (cs.verbose)
         pinf("cannot store dos time %s for %s\n", numtoa(nTimeForDos), szInZipNameOEM);
   } else {
      zi.tmz_date.tm_sec  = mytm->tm_sec;
      zi.tmz_date.tm_min  = mytm->tm_min;
      zi.tmz_date.tm_hour = mytm->tm_hour;
      zi.tmz_date.tm_mday = mytm->tm_mday;
      zi.tmz_date.tm_mon  = mytm->tm_mon ;
      zi.tmz_date.tm_year = mytm->tm_year;
   }

   /*
   {
     FILETIME ointime = {0, 0};
     // timetToFileTime(nInTime1, &ointime);
     FILETIME localFileTime = { 0, 0 };
     FileTimeToLocalFileTime(&ointime, &localFileTime);
     FileTimeToDosTime(localFileTime, &zi.dosDate);
   }
   */

   // zi.dosDate = unix2dostime(nTimeForDos);
   // printf("### DosTime: %u 0x%x\n", zi.dosDate, zi.dosDate);

   #ifndef _WIN32
   // linux: set file mode as high word
   pin->nClStatus = 0;
   pin->readStat('a');
   uint nAttr = pin->getAttr();
   zi.external_fa = nAttr << 16; // linux +x flag
   #endif

   // apply -setexec .sh on all systems
   if (bSetExec)
   {
      // must fake Unix otherwise +x will be ignored
      if (nVersionMadeBy == 0)
         nVersionMadeBy = ((uint)3) << 8; // fake Unix
      zi.external_fa |= (((uint)0000100) << 16); // +x
   }

   // complete VersionMadeBy with zip version
   nVersionMadeBy |= 20; // zip version used for create

   int izmethod = cs.bzip2 ? Z_BZIP2ED : Z_DEFLATED;
   int izlevel  = cs.bzip2 ? Z_BEST_COMPRESSION : Z_DEFAULT_COMPRESSION;

   if (cs.nocomp)  izlevel = 0; // Z_NO_COMPRESSION;
   if (cs.maxcomp) izlevel = Z_BEST_COMPRESSION;

   int err = sfkOpenNewFileInZip(cs.zfout,
      pszPriOutName,
      &zi,
      aExtraFields, nTotalExtraSize,  // extrafield_local
      aExtraFields, nTotalExtraSize,  // extrafield_global
      NULL,    // comment
      izmethod, // Z_DEFLATED
      izlevel,  // Z_DEFAULT_COMPRESSION
      0,
      -15,     // MAX_WBITS
      8,       // DEF_MEM_LEVEL,
      Z_DEFAULT_STRATEGY,
      0,       // password,
      crcraw,
      nVersionMadeBy,
      nInZipFlags, // nInZipFlags
      zip64     // zip64
      );

   if (err) {
      pin->close();
      perr("cannot init compression (%d): %s",err,szAbsNameUTF);
      return 19;
   }

   info.setProgress(nTotalIn, nDoneIn, "bytes", 1);
   info.setAction("pack", szInZipNameUTF, "");

   char szAddInfo[200];
   char szOutEst[50];

   sfkuint64 n1=0,n2=0,n3=0;

   zipGetStatus(cs.zfout, &n1);

   int irc = 0;

   if (bDir==0)
   while (1)
   {
      if (userInterrupt())
         { irc = 19; break; }

      int nRead  = (int)pin->read(pInBuf, iInBufSize);
      if (nRead < 1)
         break;

      nDoneIn += nRead;

      if (zipWriteInFileInZip(cs.zfout, pInBuf, nRead))
         { irc = 20; break; }

      zipGetStatus(cs.zfout, &n2);
      nDoneOut = n2 - n1;

      num nnow = getCurrentTime();
      if (   nnow - nstart >= 3000
          && nnow - ntold  >= 1000
         )
      {
         info.setAction("pack", szInZipNameUTF, 0, eKeepAdd);

         ntold = getCurrentTime();

         num iElapsed = getCurrentTime() - nstart;
         num nTimeEst = (nTotalIn * iElapsed) / (nDoneIn ? nDoneIn : 1);
         num nTimeRem = nTimeEst - iElapsed;
         num nRemSec  = nTimeRem / 1000;
         num nRemDMin = nRemSec / 6;

         // avoid 64 * 64 bit overflow on output estimation
         num nDoneOutMB = nDoneOut / 1000000;
         num nTotalInMB = nTotalIn / 1000000;
         num nDoneInMB  = nDoneIn  / 1000000;

         if (nDoneInMB > 0)
         {
            int iRatio    = (nDoneOut * 100) / (nDoneIn ? nDoneIn : 1);
            num nOutEstMB = (nDoneOutMB * nTotalInMB) / (nDoneInMB ? nDoneInMB : 1);

            if (nOutEstMB >= 1000)
               sprintf(szOutEst, "%1.1fgb", nOutEstMB/1000.0);
            else
               sprintf(szOutEst, "%1.0fmb", nOutEstMB*1.0);

            if (nRemDMin >= 20)
               sprintf(szAddInfo, "=> %02d%% %s %1.0fmin", iRatio, szOutEst, nRemDMin/10.0);
            else
               sprintf(szAddInfo, "=> %02d%% %s %dsec", iRatio, szOutEst, (int)nRemSec);

            info.setStatus("pack", szInZipNameUTF, szAddInfo);
         }
      }

      info.setProgress(nTotalIn, nDoneIn, "bytes", 1);
   }

   if (zipCloseFileInZip(cs.zfout))
      irc = 21;

   zipGetStatus(cs.zfout, &n2);
   nDoneOut = n2 - n1;

   if (bDir==0)
      pin->close();

   info.clear();
   if (bDir)
      printFile("added", szInZipNameUTF, 0, 0, 2 | nPrintFlags);
   else
      printFile("added", szInZipNameUTF, nTotalIn, nDoneOut, nPrintFlags);

   cs.totaloutbytes += nDoneOut;
   if (!bDir) cs.filesZip++; // zip

   return irc;
}

void change_file_date2(const char *filename, uLong dosdate, tm_unz tmu_date)
{
#ifdef _WIN32
  HANDLE hFile;
  FILETIME ftm,ftLocal,ftCreate,ftLastAcc,ftLastWrite;
  hFile = CreateFileA(filename,GENERIC_READ | GENERIC_WRITE,
                      0,NULL,OPEN_EXISTING,0,NULL);
  GetFileTime(hFile,&ftCreate,&ftLastAcc,&ftLastWrite);
  DosDateTimeToFileTime((WORD)(dosdate>>16),(WORD)dosdate,&ftLocal);
  LocalFileTimeToFileTime(&ftLocal,&ftm);
  SetFileTime(hFile,&ftm,&ftLastAcc,&ftm);
  CloseHandle(hFile);
#else
  struct utimbuf ut;
  struct tm newdate;
  newdate.tm_sec = tmu_date.tm_sec;
  newdate.tm_min=tmu_date.tm_min;
  newdate.tm_hour=tmu_date.tm_hour;
  newdate.tm_mday=tmu_date.tm_mday;
  newdate.tm_mon=tmu_date.tm_mon;
  if (tmu_date.tm_year > 1900)
      newdate.tm_year=tmu_date.tm_year - 1900;
  else
      newdate.tm_year=tmu_date.tm_year ;
  newdate.tm_isdst=-1;
  ut.actime=ut.modtime=mktime(&newdate);
  utime(filename,&ut);
#endif
}

void getExtraTags(uchar abExtra[], uint nMaxExtra, unum aTimes[], int &b64size, char *pszUTFName)
{
   uchar *pcur = abExtra;
   uchar *pmax = pcur + nMaxExtra;

   while (pcur < pmax)
   {
      // printf(" extra %s\n", dataAsHex(abExtra,36));
      // 0    2    4        8    10   12
      // 0A00 2000 00000000 0100 1800 0062C2DA 2673D301 0062C2DA2673D3010062C2DA
      uint nextag =     ((uint)pcur[0])
                     |  ((uint)pcur[1] << 8);
      uint nexlen =     ((uint)pcur[2])
                     |  ((uint)pcur[3] << 8);

      if (nextag == 0)
         break;

      if (cs.verbose >= 3) { // sfk194
         printf("  ziptag: 0x%04x len=%02u %s\n",
            nextag, nexlen, dataAsHex(pcur,4+nexlen));
      }

      if (nextag == 0x01)
      {
         // 64 bit size tag
         b64size = 1;
      }
      else if (nextag == 0x0A)
      {
         // read NTFS tag:
         //  0           2           4
         //  ushort tag, ushort len, uint null,
         //  8              10
         //  ushort timeid, ushort timelen 24,
         //  12
         //  24 bytes of time
         uchar *p = pcur;
         ushort ntaglen = nexlen;
         if (ntaglen < 32)
            break;
         if (p[8]!=0x01 || p[9]!=0x00) // Time
            break;
         ushort ntimelen = ((ushort)p[10]) | ((ushort)p[11]<<8);
         if (ntimelen < 24)
            break;
         uchar *p2 = p + 12;
 
         for (int i=0; i<3; i++)
         {
            unum nlo  =    ((uint)p2[0])
                        |  (((uint)p2[1]) << 8)
                        |  (((uint)p2[2]) << 16)
                        |  (((uint)p2[3]) << 24);
            p2 += 4;
            unum nhi  =    ((uint)p2[0])
                        |  (((uint)p2[1]) << 8)
                        |  (((uint)p2[2]) << 16)
                        |  (((uint)p2[3]) << 24);
            aTimes[i] = (nhi << 32) | nlo;
         }
      }
      else if (nextag == 0x7075)
      {
         // read utf path tag:
         // 7570 1F00 01 749855A9 6D79...
         // 0    2    4  5        9
         // tag  len  vs namecrc  name
         uchar *p2 = pcur+4;
         uchar nversion = *p2++;
         unum ncrc =    ((uint)p2[0])
                     |  (((uint)p2[1]) << 8)
                     |  (((uint)p2[2]) << 16)
                     |  (((uint)p2[3]) << 24);
         p2 += 4;
         int nnamelen = nexlen - 5;
         // todo: utfname crc check
         if (nnamelen>0 && nnamelen<SFK_MAX_PATH) {
            memcpy(pszUTFName, p2, nnamelen);
            pszUTFName[nnamelen] = '\0';
         }
      }

      pcur += 4 + nexlen;
   }
}

mytime_t zipTimeToMainTime(num nZipTime);

bool anyHiCodes(char *psz)
{
   uchar *p = (uchar*)psz;
   for (; *p; p++)
      if (*p >= 0x80)
         return 1;
   return 0;
}

int zipOEMToUTF(char *pdst, int imaxdst, char *psrc)
{
   char *pdstcur=pdst;
   char *pdstmax=pdst+imaxdst;
   while (*psrc!=0 && pdstcur+10<pdstmax)
   {
      uchar cans  = *psrc++;
      ushort nuni = zipchars.oemtouni(cans);
      int iwrite  = UTF8Codec::toutf8((char*)pdstcur, 10, nuni);
      #if 0
      printf("oem %02x -> uni %04x -> %d %.*s %02x %02x\n",
         cans,nuni,iwrite,iwrite,pdstcur,(uint)pdstcur[0]&0xff,(uint)pdstcur[1]&0xff);
      #endif
      pdstcur += iwrite;
   }
   *pdstcur = '\0';
   return 0;
}

#ifdef SFKOFFICE
class OfficeFilter
{
public:
      OfficeFilter ( );

char *filter(char *pin, int ilen, int &routlen, char *pSharedStrings, char *pFilename);
bool  istag (char *pszcur, cchar *psztag);

int   nbadconv;
};

OfficeFilter::OfficeFilter( )
{
   nbadconv = 0;
}

bool OfficeFilter::istag(char *pszcur, cchar *psztag)
{
   /*
      "<tag "
      "<tag/"
      "<tag>"
   */
   int ilen = strlen(psztag);

   if (strncmp(pszcur,psztag,ilen))
      return 0;

   char cpost = pszcur[ilen];

   if (cpost==' ' || cpost=='/' || cpost=='>')
      return 1;

   return 0;
}

char officeUniToAnsi(uint nchar)
{
   char c = 0;

   switch (nchar)
   {
      case 0x2010: case 0x2011: case 0x2012: case 0x2013:
      case 0x2014: case 0x2015: c='-'; break;
      case 0x2016: c='|'; break;
      case 0x2017: c='_'; break;
      case 0x2018: case 0x2019: case 0x201A: case 0x201B: c='\''; break;
      case 0x201C: case 0x201D: case 0x201E: case 0x201F: c='\"'; break;
      case 0x2022: case 0x2023: c='*'; break;
      case 0x2024: case 0x2025: case 0x2026: case 0x2027: c='.'; break;
      default: c = sfkchars.unitoansi(nchar); // can be NULL
   }

   return c;
}

// pSharedStrings is modified!
char *OfficeFilter::filter(char *pin, int ilen, int &routlen, char *pSharedStrings,
   char *pFilename)
{
   char sztag[300];
   char szsubhead[500];

   bool bxlsx = pSharedStrings ? 1 : 0;

   UTF8Codec utf;
   utf.bdecodexml = 1;
   utf.bkeeputf   = cs.utfout; // sfk1942

   // <sst xmlns="..." count="3152" uniqueCount="2896">
   // the uniqueCount may or may not be given.
   int iXlsUniqueCount = 0;
   if (pSharedStrings) {
      char *psz = mystrstri(pSharedStrings, "uniqueCount=\"");
      if (psz != 0 && (psz-pSharedStrings) < 200)
         iXlsUniqueCount = atoi(psz+13);
      // printf("mapstr: %s\n",pFilename);
   }

   // prepare sharedStrings table
   char **ashared = 0;
   int    nshared = 0;

   if (bxlsx)
   for (int ipass=0; ipass<2; ipass++)
   {
      if (ipass)
      {
         ashared = new char*[nshared+4];
         if (!ashared)
            break;
         memset(ashared, 0, sizeof(char*)*nshared);
      }

      int ishared=0;
      char *psz=pSharedStrings;

      while (*psz)
      {
         // <si><t>mytext</t></si>
         // <si><t xml:space="preserve">...
         // <si><r><t xml:space etc. whatever
         // <si><t/> WITHOUT </t>
         // <si><r>...whatever...<t/></si>
         char *ptag = strstr(psz,"<si>");
         if (!ptag) break;
         ptag += 4;

         // handle just <t> and <t ...>
         // all other cases produce raw xml output
         bool bhavetopen=0;
         if (strbeg(ptag,"<t>")
             || strbeg(ptag,"<t "))
         {
            bhavetopen=1;
            while (*ptag!=0 && *ptag!='>') ptag++;
            if (*ptag=='>') ptag++;
         } else if (strbeg(ptag,"<t/>")) {
            ptag += 4;
         }

         if (ipass) {
            ashared[ishared++] = ptag;
         } else {
            nshared++;
         }

         char *pstart = ptag;

         if (bhavetopen) {
            ptag = strstr(ptag,"</t>");
         } else {
            ptag = strstr(ptag,"</si>");
         }
         if (!ptag) break;

         // if (!ipass) printf("TAG %d: %s\n",nshared-1,dataAsTrace(pstart,20));

         if (ipass)
         {
            *ptag = '\0';

            utf.init(pstart, ptag-pstart);
            char *pout = pstart;
            char c=0;
            int iold=0,icur=0;
            // printf("FROM '%.30s'\n",pstart);
            while (utf.hasChar()==1 && pout<ptag)
            {
               iold = utf.icur;
               c = officeUniToAnsi(utf.nextChar());
               icur = utf.icur;
               if (c) {
                  *pout++ = c;
               } else {
                  while (iold<icur)
                     *pout++ = pstart[iold++];
               }
            }
            *pout = '\0';
            // printf("  TO '%s'\n",pstart);
         }

         psz = ptag+1;
      }

      if (ipass == 0 && iXlsUniqueCount != 0
          && nshared != iXlsUniqueCount)
      {
         pwarn("unknown xls content (%d/%d): %s\n",nshared,iXlsUniqueCount,pFilename);
         return 0;
      }
   }

   // NO RETURN W/O DELETE BEGIN

   char *pout = 0;
   int noutsize = 0;

   for (int ipass=0; ipass<2; ipass++)
   {
      if (ipass==1) {
         // printf("alloc: %d\n",noutsize);
         pout = new char[noutsize+100];
      }

      utf.init(pin, ilen);

      int icur=0,iout=0,istate=0,iold=0;
      int ianytext=0,ianyxml=0;
      int itagstart=0,itaglen=0;
      int ioutcol=0,irownest=0,bwrapinrow=0;
      int isharedstate=0,iformula=0;
      int icurshown=0,ioutshown=0,idelay=0;
      cchar *padd=0;
      uint nchar=0;
      nbadconv=0;

      // sfk198: insert subfile headers on .xlsx
      if (bxlsx && cs.subnames)
      {
         char *psz = pFilename+strlen(pFilename);
         while (psz>pFilename && psz[-1]!=glblPathChar && psz[-1]!=glblWrongPChar)
            psz--;
         snprintf(szsubhead, sizeof(szsubhead)-10,
            "\n----- :file: %s -----\n"
            , psz);
         int nsubhead = strlen(szsubhead);
         if (ipass)
            memcpy(pout+iout, szsubhead, nsubhead);
         iout += nsubhead;
      }

      while (utf.hasChar() == 1)
      {
         if (bGlblEscape)
            break;

         if (ipass==1 && iout>noutsize) // accept == if only xml follows
            { perr("int. #2181221 %d %d",iout,noutsize); break; }

         iold  = utf.icur;
         nchar = utf.nextChar();
         icur  = utf.icur;

         // ON CHANGE TO icur WRITE BACK utf.icur !

         char c = officeUniToAnsi(nchar);

         if (c==0)
         {
            // utf does not map into our codepage.
            if (istate==0)
            {
               // visible text: copy thru even if it breaks encoding.
               int ilen = icur-iold;
               if (ipass)
                  memcpy(pout+iout, pin+iold, ilen);
               iout += ilen;
               ioutcol += ilen;
               nbadconv++;
               continue;
            }
            else
            {
               // in xml: don't care
               c = '?'; nbadconv++;
            }
         }
 
         switch (istate)
         {
            case 0:
               if (c=='<') {
                  istate=1;
                  ianyxml=1;
                  itagstart=icur-1;
                  continue;
               }
               break;
            case 1:
               if (c=='>')
               {
                  istate=0;
                  itaglen=icur-itagstart;
                  if (itaglen+10<sizeof(sztag))
                  {
                     memcpy(sztag,pin+itagstart,itaglen);
                     sztag[itaglen]='\0';
 
                     if (!irownest && (istag(sztag,"</text:p")
                         || istag(sztag,"</w:p")))
                     {
                        padd="\n\n";
                        c=0;
                        break;
                     }
 
                     if (istag(sztag,"<table:table-row")
                         || istag(sztag,"<w:tr")
                         || istag(sztag,"<row")
                        )
                     {
                        irownest++;
                        bwrapinrow=0;
                     }
 
                     if (irownest && (istag(sztag,"</table:table-cell")
                         || istag(sztag,"</w:tc")
                         || istag(sztag,"</c")
                        ))
                     {
                        if (bwrapinrow)
                           padd="\n\n";
                        else
                           padd="\t";
                     }
 
                     if (istag(sztag,"</table:table-row")
                         || istag(sztag,"</w:tr")
                         || istag(sztag,"</row")
                        )
                     {
                        irownest--;
                        padd="\n";
                        c=0;
                        break;
                     }

                     if (istag(sztag,"<text:line-break")
                         || istag(sztag,"<w:br")
                        )
                     {
                        padd="\n";
                        c=0;
                        break;
                     }

                     if (istag(sztag,"<text:tab")
                         || istag(sztag,"<w:tab")
                        )
                     {
                        padd="\t";
                        c=0;
                        break;
                     }

                     if (bxlsx) // .xlsx sheet specific
                     {
                        // shared string resolve
                        if (istag(sztag,"<c"))
                        {
                           // <c r="C4" s="1" t="s">
                           // -> t="s" means index in shared strings
                           isharedstate = 0;
                           if (strstr(sztag,"t=\"s\""))
                              isharedstate = 1; // expect <v> with index
                        }
                        if (istag(sztag,"<v")==1 && isharedstate==1)
                        {
                           // <v>0</v> means index 0 in shared strings
                           isharedstate = 2; // following value must be translated
                        }
                        // extra context
                        if (istag(sztag, "<f"))  iformula = 1;
                        if (istag(sztag, "</f")) iformula = 0;
                     }
                  }
               }
               continue;
         }
 
         if (padd)
         {
            if (ipass) {
               if (padd[0]=='\n' && iout>2
                   && pout[iout-1]=='\n'
                   && pout[iout-2]=='\n'
                  )
               {
                  // do NOT add further blank lines.
                  // correct the size stats.
                  noutsize -= strlen(padd);
               } else {
                  memcpy(pout+iout, padd, strlen(padd));
                  iout += strlen(padd);
               }
            } else {
               iout += strlen(padd);
            }
            ioutcol=0;
            padd=0;
            ianyxml=0;
         }

         if (ianyxml) {
            ianyxml=0;
            if (ianytext) {
               #if 0
               if (ipass)
                  pout[iout] = ' ';
               iout++;
               ioutcol++;
               #endif
            }
         }

         if (c==0)
            continue;

         if (isharedstate == 2)
         {
            isharedstate = 0;

            // take full numeric index: <v>123</v> -> 123
            char *pindcur  = pin+icur-1;
            char *pindpost = 0;
            uint iSharedIndex = strtoul(pindcur, &pindpost, 10);
            int iindlen = pindpost-pindcur;
            icur += (iindlen-1);

            utf.icur = icur; // UTF icur WRITE BACK

            // resolve shared string by index
            if (ashared != 0
                && iSharedIndex < nshared
                && ashared[iSharedIndex] != 0)
            {
               char *ptext = ashared[iSharedIndex];
               int   ntext = strlen(ptext);
               if (ipass==1 && iout+ntext<=noutsize) { // w/o term
                  memcpy(pout+iout, ptext, ntext+1);   // with term
                  #if 0
                  printf("MAP: %d -> %s len %d now on '%.5s'\n",
                     iSharedIndex,ptext,iindlen,pin+icur);
                  #endif
               }
               iout += ntext; // without term
               ioutcol += ntext;
               ianytext = 1;
            }
         }
         else if (iformula)
            { } // drop text
         else
         {
            // single char
            if (ipass)
               pout[iout] = c;
            iout++;
            ioutcol++;
            ianytext = 1;
         }
 
         if (ioutcol >= 60 && c == ' ')
         {
            if (ipass)
               pout[iout] = '\n';
            iout++;
            ioutcol=0;
            if (irownest)
               bwrapinrow=1;
         }

         // optional visual update during load
         if (ipass == 0
             && icur - icurshown > 1000
             && pGlblShowDataCallBack != 0)
         {
            if ((idelay++ & 63)==63)
               pGlblShowDataCallBack(pin+icurshown, icur - icurshown);
            icurshown = icur; // do not move up
         }
         else
         if (ipass == 1
             && iout - ioutshown > 1000
             && pGlblShowDataCallBack != 0)
         {
            if ((idelay++ & 7)==7)
               pGlblShowDataCallBack(pout+ioutshown, iout - ioutshown);
            ioutshown = iout; // do not move up
         }

      }  // endfor chars

      if (ipass==0)
         noutsize = iout;
      else
         pout[iout] = '\0';

   } // endfor pass

   if (ashared)
      delete [] ashared;

   // NO RETURN W/O DELETE END

   routlen = noutsize;

   return pout;
}

int Coi::loadOfficeSubFile(cchar *pszFromInfo)
{
   // printf("loadOfficeSubFile %s %s\n",name(),pszFromInfo);

   if (data().src.data)
      return 0; // nothing to do

   char *proot = strdup(name());
   CharAutoDel odel(proot);

   #ifdef _WIN32
   char *psz = strstr(proot, "\\\\");
   #else
   char *psz = strstr(proot, "//");
   #endif

   if (!psz)
      return 9+perr("not an office subfile: %s\n", name());

   *psz = 0;
   psz += 2;

   char *pSharedStrings = 0;

   cs.pOutCoi = this;
   cs.catzip = 1;

   int irc = 0;
 
   if (flexMatch(name(), "/sheet#.xml"))
      irc = execUnzip(proot, psz, 0, &pSharedStrings); // loadOfficeSubFile
   else
      irc = execUnzip(proot, psz, 0, 0); // loadOfficeSubFile

   cs.catzip = 0;
   cs.pOutCoi = 0;

   CharAutoDel odel2(pSharedStrings);

   // printf("-> sharedstrings: %p %d\n",pSharedStrings,pSharedStrings?strlen(pSharedStrings):0);

   if (cs.office < 2
       && data().src.data != 0)
   {
      OfficeFilter ofilt;
      int nOutSize = 0;
      char *pFiltOut = ofilt.filter((char*)data().src.data, data().src.size, nOutSize,
                                    pSharedStrings, name());

      if (nOutSize < 1) {
         if (pFiltOut)
            delete [] pFiltOut;
         setContent(0, 0, 0);
      } else {
         setContent((uchar*)pFiltOut, nOutSize, data().src.time);
      }
   }

   // shared strings, if any, are freed automatically

   return irc;
}

int Coi::rawLoadOfficeDir( )
{__
   cs.pOutCoi = this;
   cs.catzip = 0;
   int irc = execUnzip(name(), 0, cs.office); // rawLoadOfficeDir
   cs.pOutCoi = 0;
   return irc;
}

// caller MUST RELEASE COI after use!
Coi *Coi::rawNextOfficeEntry( )
{
   if (!data().bdiropen) {
      perr("nextEntry() called without openDir()");
      return 0;
   }

   Coi *psubsrc = 0;

   do
   {
      // something left to return?
      if (data().nNextElemEntry >= data().elements().numberOfEntries())
         return 0; // end of list

      // return a COPY from the internal list entries.
      psubsrc = data().elements().getEntry(data().nNextElemEntry, __LINE__);

      data().nNextElemEntry++;
   }
   while (0);

   // caller MUST RELEASE COI after use!
   Coi *psubdst = psubsrc->copy();

   psubdst->incref("nze");

   return psubdst;
}

void Coi::rawCloseOfficeDir( )
{
   if (!data().bdiropen) {
      pwarn("closeDir() called on non-open dir");
      return;
   }
   // all elements have been returned as copies,
   // and another processing is not possible.
   // so we MAY cleanup the elements() list here.
   // for now, do nothing. maybe later version
   // of elements() will store offsets within zipfile.
   data().bdiropen = 0;
}

#endif // SFKOFFICE

// todo: .xlsxm etc.
static cchar *pGlblOfficeSubFilter =

   ".docx document.xml\n"  // ms word
   ".dotx document.xml\n"  // ms word
   ".dotm document.xml\n"  // ms word

   ".xlsx *sheet#.xml\n"   // ms excel, and uses sharedStrings.xml
   ".xlsm *sheet#.xml\n"   // ms excel, and uses sharedStrings.xml

   ".odt content.xml\n"    // oo writer
   ".ods content.xml\n"    // oo calc

   ".pptx core.xml *slides/slide#.xml\n"    // ms powerpoint
   ".ppsx core.xml *slides/slide#.xml\n"    // ms powerpoint

   ;

// ppt\slides\slide1.xml
// slides/slide#.xml
bool flexMatch(char *pszhay, cchar *pszpat)
{
   // from rite to left
   cchar *phaycur=pszhay+strlen(pszhay);
   cchar *ppatcur=pszpat+strlen(pszpat);
   while (phaycur>pszhay && ppatcur>pszpat)
   {
      char cpat=tolower(ppatcur[-1]);
      char chay=tolower(phaycur[-1]);
      if (cpat=='#') {
         ppatcur--;
         bool bany=0;
         while (phaycur>pszhay
                && isdigit(phaycur[-1])!=0)
            { bany=1; phaycur--; }
         if (!bany) return 0;
         continue;
      }
      if (cpat=='/') {
         ppatcur--;
         if (chay!='/' && chay!='\\') return 0;
         phaycur--;
         continue;
      }
      if (cpat != chay) return 0;
      ppatcur--;
      phaycur--;
   }
   return 1;
}

bool keepOfficeSubFile(char *pszParName, char *pszSubName)
{
   char szpat[100];

   /*
      office\parent.docx   word\document.xml
   */
   char *pszParExt = strrchr(pszParName, '.');
   if (!pszParExt) return 0;

   char *psz = strstr(str(pGlblOfficeSubFilter), pszParExt);
   if (!psz) {
      // unlisted above: keep .xml generic
      if (strEnds(pszSubName, ".xml"))
         return 1;
      return 0;
   }

   // .pptx core slide\n
   psz = strchr(psz, ' ');
   if (!psz) return 0;
   psz++;

   // core slide
   while (*psz!=0 && *psz!='\n')
   {
      char *pnext=psz;
      while (*pnext!=0 && *pnext!=' ' && *pnext!='\n')
         pnext++;
      int ilen=pnext-psz;
      if (ilen+10 > sizeof(szpat)) return 0;
      memcpy(szpat,psz,ilen);
      szpat[ilen]='\0';

      // *core matches within
      // document.xml matches end
      if (szpat[0]=='*' && flexMatch(pszSubName,szpat+1)!=0) {
         // printf("match %s %s\n",pszSubName,szpat);
         return 1;
      }
      if (szpat[0]!='*' && strEnds(pszSubName,szpat)==1) {
         // printf("match %s %s\n",pszSubName,szpat);
         return 1;
      }

      psz=pnext;
      if (*psz==' ')
         psz++;
   }

   return 0;
}

int execUnzip(char *pszInFile, char *pszSubFile, int iOffice,
   char **ppSharedStrings)
{__
   // printf("execUnzip %s %s\n",pszInFile,pszSubFile);

   char szAddInfo[100];
   char szSizeBuf[100];
   char szTimeBuf[100];
   char szToMaskBuf[SFK_MAX_PATH+10];

   glblUnzipDirs.resetEntries();

   if (!fileExists(pszInFile))
      return 9+perr("cannot read: %s\n",pszInFile);

   // safety: display filename now in case of read crash
   if (cs.verbose)
      info.setAction("read", pszInFile, "", 0); // sfk194 unzip safe info

   int irc  = 0;

   int iout = 0;
   // 0: list content
   // 1: test integrity
   // 2: dump to terminal
   // 3: extract to files

   if (cs.catzip)    iout = 2;
   else if (cs.test) iout = 1;
   else if (cs.yes==1 && cs.pOutCoi==0)  iout = 3;

   uint size_buf = 8192;

   uchar *buf = new uchar[size_buf+100];

   if (!buf)
      return 9+perr("out of memory");

   UCharAutoDel odel(buf);

   // char *a=0; *a='\0'; // crash test

   unzFile uf = unzOpen64(pszInFile);
   if (uf == 0) {
      pwarn("invalid zip file: %s",pszInFile);
      pinf("[nopre] the central directory was not found. the file may be incomplete,\n");
      pinf("[nopre] part of a multi part archive (which is not supported by sfk),\n");
      pinf("[nopre] or no zip file at all.\n");
      return 9;
   }

   KeyMap newDirMap;
   SFKMD5 md5;

   // unz_global_info64 gi;
   unz_global_info gi;

   memset(&gi, 0, sizeof(gi));
   int opt_overwrite = 1;
   int opt_extract_without_path = 0;
   const char *password = 0;

   // todo: unzGetGlobalInfo64 struct size mismatch,
   // with crash after call due to corrupted stack.
   //  sizeof(unz_global_info64) outside: 12
   //  sizeof(unz_global_info64) inside : 16
   // printf("passing gi %d %d\n",sizeof(gi),sizeof(uLong));
   // int err = unzGetGlobalInfo64(uf, &gi); // crash after call

   int err = unzGetGlobalInfo(uf, &gi);

   if (err)
      return 10;

   // meta: os=win; code=850,utf; offtime; agent=sfk 1.9.2
   char szGlobalComment[200+10];
   mclear(szGlobalComment);

   // sfk1920: always get global zip comment for interpretation
   if (unzGetGlobalComment(uf, szGlobalComment, sizeof(szGlobalComment)-10) > 0)
   {
      if (!cs.yes && !cs.toziplist && !cs.hidezipcomment
          && !glblUnzipMask.numberOfEntries())
      {
         setTextColor(nGlblTimeColor);
         printf("%s\n", szGlobalComment);
         setTextColor(-1);
      }
      char *psz = szGlobalComment;
      char *psz2 = 0;
      if (strstr(psz, "; agent=sfk ")) {
         if (strstr(psz, " offtime; ")) {
            cs.mofftime = 7;
            if (cs.debug) printf("zip file uses offtime mode.\n");
         }
         if ((psz2 = strstr(psz, " offtime="))) {
            cs.mofftime = atoi(psz2+9);
            if (cs.debug) printf("zip file uses offtime mode %u.\n", cs.mofftime);
         }
      }
   }

   unz_file_info64 file_info;

   uchar abExtraField[1024+100]; mclear(abExtraField);
   char  szFileComment[300+100]; mclear(szFileComment);
   char  szflags[100];           mclear(szflags);
   char  szExtUTFName[SFK_MAX_PATH+20]; mclear(szExtUTFName);

   bool buname = cs.uname;
   cchar *pszFileFeed = "";

   // szRefNameBuf: original name/        within zip
   // szLineBuf2  : local    name\        relative
   // szLineBuf3  : local    outdir\name\ if used

   for (num i=0; i<gi.number_entry; i++)
   {
      mtklog(("zip.proc.entry %d/%d",(int)i,(int)gi.number_entry));

      szRefNameBuf[0] = '\0';
      szFileComment[0] = '\0';
      mclear(abExtraField);

      err = unzGetCurrentFileInfo64(uf, &file_info,
               szRefNameBuf, MAX_LINE_LEN,
               abExtraField, sizeof(abExtraField)-100,
               szFileComment, sizeof(szFileComment)-100);

      if (err)
         return 9+perr("zip format error, cannot get fileinfo (rc=%d)", err);

      // szRefNameBuf is now cp437 or UTF-8
      strcopy(szLineBuf2, szRefNameBuf);

      bool bNameSeemsUTF = UTF8Codec::isValidUTF8(szRefNameBuf);
      bool bAnyHiCodes   = anyHiCodes(szRefNameBuf);

      int  b64size   = 0;
      uint nVersionMadeBy = file_info.version;
      uint nverneed  = file_info.version_needed;
      uint nflag     = file_info.flag;
      uint ncmethod  = file_info.compression_method;
      uint crc       = file_info.crc;
      unum nRawSize  = file_info.uncompressed_size;
      unum nPackSize = file_info.compressed_size;
      uint dosDate   = file_info.dosDate;
      uint nFileAttrInt = file_info.internal_fa;
      uint nFileAttr = file_info.external_fa;
      tm_unz *pttime = &file_info.tmu_date;

      int nPrintFlags = 8;

      if (nflag & (1U << 11)) { // utf8
         cs.uname = 1;
      } else {
         cs.uname = buname;
         if (cs.uname) {
            if (bNameSeemsUTF)
               nPrintFlags |= 128; // unmarked utf
         } else {
            if (bNameSeemsUTF) {
               // conflict! name seems UTF8 but is not marked
               // correctly within the zip file.
               if (cs.unameauto) {
                  cs.uname = 1;
                  nPrintFlags |= 128;
               } else {
                  cs.iinvalidutfmarks++;
               }
            }
            if (!cs.uname) {
               // extend oem to utf
               zipOEMToUTF(szLineBuf3, MAX_LINE_LEN, szLineBuf2);
               #if 0
               printf("expand.from %s %d\n",szLineBuf2,zipchars.getocp());
               printf("expand.to   %s\n",szLineBuf3);
               #endif
               strcopy(szLineBuf2, szLineBuf3);
               cs.uname = 1;
            }
         }
      }

      unum aNTFSTime[3]; mclear(aNTFSTime);
      szExtUTFName[0]='\0';
 
      getExtraTags(abExtraField, sizeof(abExtraField)-100,
         aNTFSTime, b64size, szExtUTFName);

      if (cs.bnoextutf==0 && szExtUTFName[0]!=0) {
         strcopy(szLineBuf2, szExtUTFName);
         cs.uname = 1;
         nflag |= (1U << 11);
      } else {
         if (cs.bnoextutf==0 && bAnyHiCodes==1 && bNameSeemsUTF==0)
            cs.inonutfhicodes++;
      }

      if (cs.force<2 && isPathTraversal(szLineBuf2,1)!=0) {
         perr("invalid path start of zip entry: %s", szLineBuf2);
         pinf("use option -force=2 if you really want to extract this.\n");
         return 9;
      }

      unum nFileTime = 0;
      cchar *pszTimeInfo = "no";

      // -  if NTFS time is given
      //    -  under windows, use it directly
      //    -  under linux, derive linux time
      // -  else if unixtime is given, use that
      // -  else if dostime  is given, use that
      if (aNTFSTime[0] != 0)
      {
         nFileTime  = aNTFSTime[0];
         nFileTime -= 116444736000000000LL;
         nFileTime /= 10000000;
         pszTimeInfo = "ntfs";
      }
      else if (pttime->tm_year != 0)
      {
         uLong year = (uLong)pttime->tm_year;
         if (year>=1980)
             year-=1980;
         else if (year>=80)
             year-=80;
         dosDate =
             (uLong) (((pttime->tm_mday) + (32 * (pttime->tm_mon+1)) + (512 * year)) << 16) |
                     ((pttime->tm_sec/2) + (32* pttime->tm_min) + (2048 * (uLong)pttime->tm_hour));
         nFileTime  = zipTimeToMainTime(dosDate);
         pszTimeInfo = "tmu";
      }
      else if (dosDate != 0)
      {
         nFileTime  = zipTimeToMainTime(dosDate);
         pszTimeInfo = "dos";
      }

      if (cs.mofftime != 0)
      do
      {
         int iFileInDst   = 0;
         mytime_t ntfile  = (mytime_t)nFileTime;
         struct tm *mytm  = mylocaltime(&ntfile); // safe
         if (!mytm) break;
         iFileInDst       = mytm->tm_isdst;

         mytime_t   nnow  = mytime(NULL);
         struct tm *pnow  = mylocaltime(&nnow); // safe
         if (!pnow) break;
         if (pnow->tm_isdst) {
            // computer is in DST
            if (iFileInDst == 0) {
               // and we have a winter range file
               nFileTime += 3600;
               if (cs.debug) printf("adjusted time +1h : %s\n", szLineBuf2);
            }
         } else {
            // computer is in winter
            if (iFileInDst != 0 && nFileTime >= 3600) {
               // and we have a summer range file
               nFileTime -= 3600;
               if (cs.debug) printf("adjusted time -1h : %s\n", szLineBuf2);
            }
         }
      }
      while (0);

      // convert slashes to local.
      // change invalid characters.
      for (char *p=szLineBuf2; *p; p++)
      {
         if (*p == glblWrongPChar)
             *p = glblPathChar;
         #ifdef _WIN32
         if (*p == ':')
             *p = '_';
         #endif
      }

      bool bDir = 0;
      int iNameLen = strlen(szLineBuf2);
      if (iNameLen > 0 && szLineBuf2[iNameLen-1] == glblPathChar) {
         szLineBuf2[iNameLen-1] = '\0';
         bDir = 1;
      }

      bool bskip = 0;
      bool bSharedStrings = 0;

      int iMasks = glblUnzipMask.numberOfEntries();

      if (pszSubFile)
      {
         // ----- extract a single sub file -----
         if (ppSharedStrings != 0 && flexMatch(szLineBuf2, "/sharedStrings.xml") != 0)
            { bSharedStrings = 1; } // must keep
         else if (strcmp(szLineBuf2, pszSubFile))
            bskip = 1;
         // printf("check %d %s\n",bskip,szLineBuf2);
      }
      else if (iMasks > 0)
      {
         // ----- filter by masks -----
         int iPosMasks=0, iPosMatch=0;
         for (int imask=0; imask<iMasks; imask++)
         {
            // TEMPORARY use of szLineBuf3 to build /mask/
            snprintf(szLineBuf3, MAX_LINE_LEN, "%c%s%c", glblPathChar, szLineBuf2, glblPathChar);
            char *pmask = glblUnzipMask.getString(imask);
            int n1=0, n2=0;
            bool bneg   = 0;
            if (*pmask==glblNotChar)
               { bneg=1; pmask++; }
            bool bmatch = matchstr(szLineBuf3, pmask, 0, n1, n2);
            if (bneg) {
               // apply blacklisting: -pat .h !.html
               if (bmatch)
                  { iPosMasks=0; iPosMatch=0; bskip=1; break; }
            } else {
               // prepare whitelisting
               iPosMasks++;
               if (bmatch)
                  iPosMatch++;
            }
         }
         // apply whitelisting: -pat /mysubdir/
         if (iPosMasks>0 && iPosMatch==0)
            bskip = 1;
      }
      else if (cs.bjustcrc==1)
      {
         // with -crc=x do not list dir entries
         if (bDir != 0 || crc != cs.njustcrc)
            bskip = 1;
      }
      else if (iOffice == 1 || iOffice == 2)
      {
         // ----- office mode 1: use only .xml files -----
         if (!keepOfficeSubFile(pszInFile, szLineBuf2))
            bskip = 1;
      }

      if (bskip) {
         // jump past sub file
         if ((i+1) < gi.number_entry) {
            err = unzGoToNextFile(uf);
            if (err)
               { perr("failed to skip in file (%d)", err); break; }
         }
         continue;
      }

      // render output filename
      if (cs.todir)
      {
         #ifdef _WIN32
         if (cs.uname)
            ansiToUTF(szToMaskBuf, SFK_MAX_PATH, cs.todir);
         else
         #endif
            strcopy(szToMaskBuf, cs.todir);
         // sfk1982 -topdir support
         char *prite = szLineBuf2;
         if (cs.changetld) {
            char *prel = prite;
            while (*prel!=0 && *prel!='\\' && *prel!='/') prel++;
            if (prel[0]!=0 && prel[1]!=0) {
               // verify tld
               int ntldlen = prel-prite;
               uint ncrc = crc32((uchar*)prite, ntldlen, 0);
               if (cs.tldhash != 0 && ncrc != cs.tldhash) {
                  perr("option -asdir not possible, zip contains different folders.\n");
                  return 19;
               }
               cs.tldhash = ncrc;
               prite = prel+1;
            } else if (!bDir) {
               perr("option -asdir not possible, zip contains files outside folder.\n");
               return 19;
            }
         }
         joinPath(szLineBuf3, MAX_LINE_LEN, szToMaskBuf, prite);
         if (strlen(szLineBuf3)+10 >= SFK_MAX_PATH)
            return 9+perr("output name too long: %s\n", szLineBuf3);
      }
      else
      {
         strcopy(szLineBuf3, szLineBuf2);
      }

      Coi ocoi(szLineBuf3, 0);

      int bDirExists=0;
      int bFileExists=0;
      if ((bFileExists = ocoi.existsFile(1,&bDirExists)))
      {
         cs.filesExisting++;
         if (bDirExists==1 && bDir==0) {
            perr("folder exists: %s\n",ocoi.name());
            perr("cannot extract file with same name.\n");
            return 9;
         }
      }

      bool bNameIsUTF  = 0;
      strcpy(szflags, "----");

      if (nflag == (1U << 11)) {
         strcpy(szflags, "utf8");
         bNameIsUTF = 1;
         nPrintFlags |= 16;
      } else if (nflag > 0) {
         sprintf(szflags, "%04x", nflag);
      }

      strcpy(szSizeBuf, numtoa_blank(nRawSize, 10));
      strcpy(szTimeBuf, timeAsString(nFileTime, 0, 0));

      char szMethod[50];
      sprintf(szMethod, "m%02u", ncmethod);
      switch (ncmethod) {
         case 0         : strcpy(szMethod, "-------"); break;
         case Z_DEFLATED: strcpy(szMethod, "deflate"); break;
         case Z_BZIP2ED : strcpy(szMethod, "bzip2"); break;
      }

      char szAttr[50];
      uint nFileMode = (nFileAttr >> 16);
      sprintf(szAttr, "%c%c%c%c",
         nFileMode & 0040000 ? 'd':'-',
         nFileMode & 0000400 ? 'r':'-',
         nFileMode & 0000200 ? 'w':'-',
         nFileMode & 0000100 ? 'x':'-'
         );
      bool bAttrExec = (nFileMode & 0000100) ? 1 : 0;

      char szMadeBy[50]; szMadeBy[0]='\0';
      char szFromOS[50]; szFromOS[0]='\0';
      uint nVersionOS = (nVersionMadeBy >> 8);
      bool bFromLinuxMac = 0;
      switch (nVersionOS) {
         case 10: strcpy(szFromOS, "win " ); break;
         case  3: strcpy(szFromOS, "unix "); bFromLinuxMac=1; break;
         case  7: strcpy(szFromOS, "mac " ); bFromLinuxMac=1; break;
         case  0: break; // default otherwise name decode may fail
         default: sprintf(szFromOS, "os=%u ", nVersionOS); break;
      }
      if (bFromLinuxMac==1) {
         if ((nFileMode & 0000100)!=0) {
            nPrintFlags |= 32;
            if (bDir==0 && (nFileMode & 0040000)==0)
               cs.iexecfiles++;
         }
         if ((nFileMode & 0040000)!=0) nPrintFlags |= 64;
      }
      if (cs.verbose>1)
         sprintf(szMadeBy, "vm:%02u.%02u ",
            nVersionMadeBy >> 8,
            nVersionMadeBy & 0xFFU);

      if (cs.uname && bNameSeemsUTF)
         cs.iutfnames++;

      if (iout < 1)
      {
         if (cs.pOutCoi)
         {
            // create office dir entry
            mtklog(("office.dir.add begin"));

            Coi *ppar      = cs.pOutCoi;
            int nRootLen   = strlen(ppar->name());
            int nSubLen    = strlen(szRefNameBuf);
            char *psubname = new char[nRootLen+nSubLen+10];
            sprintf(psubname, "%s%c%c%s", ppar->name(), glblPathChar, glblPathChar, szRefNameBuf);
            setSystemSlashes(psubname + nRootLen + 2);

            Coi *psub = new Coi(psubname, ppar->root());
            psub->incref("clst");

            SFKFindData myfdat;
            memset(&myfdat, 0, sizeof(myfdat));
            myfdat.size = nRawSize;
            myfdat.time_write = nFileTime;
            psub->fillFrom(&myfdat);
            psub->crc = crc;

            ppar->data().elements().addEntry(*psub);

            if (!psub->decref())
               delete psub; // no refs remaining, not cached

            delete [] psubname;

            mtklog(("office.dir.add end"));
         }
         else
         if (cs.toziplist) {
            glblZipList.addEntry(szRefNameBuf);
         }
         else
         if (cs.verbose) {
            printf("%s %s %s%sv%02u %s %s %s %s %s %08x %s\n",
               szSizeBuf, szTimeBuf,
               szMadeBy, szFromOS,
               (uint)nverneed,
               // nFileMode,
               szAttr,
               szflags,
               b64size ? "x64" : "x32",
               pszTimeInfo,
               szMethod,
               (uint)crc,
               szRefNameBuf // ocoi.name()
               );
            if (szFileComment[0]) {
               setTextColor(nGlblTimeColor);
               printf("%s\n", szFileComment);
               setTextColor(-1);
            }
         } else {
            printFile((bFileExists && !bDir) ? "replc" : "write",
               ocoi.name(), nRawSize, 0, nPrintFlags);
            if (szFileComment[0]) {
               setTextColor(nGlblTimeColor);
               printf("           %s\n", szFileComment);
               setTextColor(-1);
            }
         }

         cs.totaloutbytes += nRawSize;
         if (!bDir) cs.filesZip++; // zip

         // jump past sub file
         if ((i+1) < gi.number_entry) {
            err = unzGoToNextFile(uf);
            if (err)
               { perr("failed to skip in file (%d)", err); break; }
         }
         continue;
      }

      // note: cs.pOutCoi ist set while .xlsx coi reads it's zip subfile
      // into internal cache. while doing so nothing should be printed.
      if (iout == 2 && cs.nonames == 0 && cs.pOutCoi == 0) {
         if (!chain.colany())
            printx("%s<file>%s\n", pszFileFeed, ocoi.name());
         else
            chain.print("%s:file:\n%s\n", pszFileFeed, ocoi.name());
         pszFileFeed = "\n";
      }

      if (bDir)
      {
         if (iout >= 3 && ocoi.rawIsDir() == 0)
         {
            // unzip create dir
            int isubrc=0;
            #ifdef _WIN32
            if (vname())
               isubrc = createOutDirTreeW(ocoi.name(), &newDirMap, 1);
            else
            #endif
               isubrc = createOutDirTree(ocoi.name(), &newDirMap, 1);
            if (isubrc)
               return 9;

            // set dir time
            if (nFileTime > 0)
            {
               #if 1
               // postpone settm as it changes on every file
               // created within the folder.
               ocoi.nClMTime = nFileTime;
               ocoi.setIsDir(1);
               ocoi.bClUniName = cs.uname;
               glblUnzipDirs.addEntry(ocoi);
               #else
               int isubrc = ocoi.setFileTime(nFileTime);
               info.print("settm %s\n", ocoi.name());
               #endif
            }
            else
            {
               info.print("keept %s\n", ocoi.name());
            }
         }

         // jump past sub file
         if ((i+1) < gi.number_entry) {
            err = unzGoToNextFile(uf);
            if (err)
               { perr("failed to skip in file (%d)", err); break; }
         }

         continue;
      }

      // extract subfile
      err = unzOpenCurrentFilePassword(uf, password);

      if (err) {
         switch (err) {
          case UNZ_BADZIPFILE: perr("bad content or crc: %s", ocoi.name()); break;
          case UNZ_CRCERROR  : perr("checksum mismatch: %s", ocoi.name());  break;
          default            : perr("cannot read subfile (rc=%d): %s", err, ocoi.name()); break;
         }
         irc = 9;
         break;
      }

      bool bCanWriteFile = 0;

      if (iout >= 3)
      {
         // should not be required
         int isubrc=0;
         #ifdef _WIN32
         if (vname())
            isubrc = createOutDirTreeW(ocoi.name(), &newDirMap);
         else
         #endif
            isubrc = createOutDirTree(ocoi.name(), &newDirMap);
         if (isubrc)
         {
            perr("cannot write: %s\n", ocoi.name());
            if (!cs.force) // unzip stop on file write failure
               return 9;
         }

         if (ocoi.open("wb"))
         {
            perr("cannot write: %s\n", ocoi.name());
            if (!cs.force) { // unzip stop on dir create failure
               static bool btold=0;
               if (!btold)
                  pinf("use option -force to ignore errors.\n");
               btold=1;
               return 9;
            }
            cs.numBadFiles++;
         }
         else
         {
            bCanWriteFile = 1;
         }
      }

      char szOutDone[50];

      uint crcraw = 0;
      uint crcout = 0;
      num  nDoneOut = 0;

      if (iout != 2) info.setAction(cs.test?"test":"unpak", ocoi.name(), "");

      num nstart = getCurrentTime();
      num ntold  = getCurrentTime();
      num nTotalOut = nRawSize;

      md5.reset();

      // collect buffer for office sub entry read
      char  *pColBuf = 0;
      num    nColCur = 0;
      num    nColRem = 0;
      CharAutoDelete oDelBuf(&pColBuf);

      if (iout == 2 && cs.pOutCoi != 0)
      {
         pColBuf = new char[nRawSize+100];
         if (!pColBuf) {
            perr("out of memory: cannot read %s\n", cs.pOutCoi->name());
            err = UNZ_PARAMERROR;
         }
         pColBuf[nRawSize] = 0;
         nColRem = nRawSize;
      }

      if (err == 0)
      while (1)
      {
         if (userInterrupt())
            { irc = 1; break; }

         int iread = unzReadCurrentFile(uf, buf, size_buf);

         if (iread == 0)
            break;

         if (iread<0)
         {
            printf("cannot read subfile (rc=%d): %s", iread, ocoi.name());
            irc = 9;
            break;
         }

         if (iread>0)
         {
            if (iout == 1)
               { }
            else if (iout == 2)
            {
               if (pColBuf!=0) {
                  if (nColRem < iread)
                     { perr("invalid size while reading"); break; }
                  memcpy(pColBuf+nColCur, buf, iread);
                  nColCur += iread;
                  nColRem -= iread;
               }
               else
               if (chain.coldata) {
                  // no binary support, we need the file headers.
                  if (chain.addStreamAsLines(2, (char*)buf, iread))
                     break;
               } else {
                  fwrite(buf, 1, iread, stdout);
               }
            }
            else if (bCanWriteFile)
            {
               if (ocoi.write((uchar*)buf, iread) < iread)
               {
                  perr("cannot fully write, disk full\n");
                  irc = 9;
                  break;
               }
            }

            crcraw = crc32((uchar*)buf, iread, crcraw);

            if (cs.makemd5)
               md5.update((uchar*)buf, iread);

            nDoneOut += iread;
            cs.totaloutbytes += iread;
         }

         num nnow = getCurrentTime();
         if (   (iout&1) != 0
             && nnow - nstart >= 3000
             && nnow - ntold  >= 1000
            )
         {
            ntold = getCurrentTime();
 
            num iElapsed = getCurrentTime() - nstart;
            num nTimeEst = (nRawSize * iElapsed) / (nDoneOut ? nDoneOut : 1);
            num nTimeRem = nTimeEst - iElapsed;
            num nRemSec  = nTimeRem / 1000;
            num nRemDMin = nRemSec / 6;
 
            // avoid 64 * 64 bit overflow on output estimation
            num nTotalOutMB = nTotalOut / 1000000;
            num nDoneOutMB  = nDoneOut  / 1000000;
 
            if (nTotalOutMB > 0)
            {
               if (nTotalOutMB >= 1000)
                  sprintf(szOutDone, "%1.1f/%1.1fgb", nDoneOutMB/1000.0, nTotalOutMB/1000.0);
               else
                  sprintf(szOutDone, "%1.0f/%1.0fmb", nDoneOutMB*1.0, nTotalOutMB*1.0);

               if (nRemDMin >= 20)
                  sprintf(szAddInfo, "=> %s %1.0fmin", szOutDone, nRemDMin/10.0);
               else
                  sprintf(szAddInfo, "=> %s %dsec", szOutDone, (int)(nRemSec));

               info.setStatus(cs.test?"test":"unpak", ocoi.name(), szAddInfo);
            }
         }

         if ((iout&1) != 0) info.setProgress(nTotalOut, nDoneOut, "bytes");
      }

      if (irc) {
         if (iout >= 3) {
            pinf("[nopre] cleaning up: %s\n", ocoi.name());
            ocoi.closeAndRemove();
         }
         break;
      }

      if (iout >= 3)
      {
         if (bCanWriteFile == 0)
         {
            info.print("skipd %s\n", ocoi.name());
         }
         else
         {
            if (cs.verbose)
               info.print("wrote %s (using %s time)\n", ocoi.name(), pszTimeInfo);
            else {
               info.clear();
               printFile("wrote", ocoi.name(), nRawSize, 0, nPrintFlags);
            }
 
            ocoi.close();
 
            int iElapsed = getCurrentTime() - nstart;
 
            // verify by file size
            if (nDoneOut != nRawSize)
               return 9+perr("output size mismatch (%s/%s)\n",
                  numtoa(nDoneOut,1,szLineBuf),numtoa(nRawSize));

            if (nFileTime > 0)
            {
               ocoi.setFileTime(nFileTime);
            }
 
            #ifndef _WIN32
            if (bFromLinuxMac && bAttrExec)
            {
               // set linux +x flag
               struct stat64 ostat;
               if (stat64(ocoi.name(), &ostat) == 0)
               {
                  // extend existing flags by +x
                  uint nattr = (1U << 31) | ostat.st_mode | (1U << 6) | (1U << 3) | (1U << 0);
                  Coi::writeAttrRaw(ocoi.name(), nattr, 0, 0);
               }
            }
            #endif
         }
      }

      err = unzCloseCurrentFile(uf);

      if (err) {
         switch (err) {
          case UNZ_BADZIPFILE: perr("bad content or crc: %s", ocoi.name()); break;
          case UNZ_CRCERROR  : perr("checksum mismatch: %s", ocoi.name());  break;
          default            : perr("cannot read subfile (rc=%d): %s", err, ocoi.name()); break;
         }
         if (iout >= 3 && cs.keepbadout == 0) {
            pinf("[nopre] cleaning up: %s\n", ocoi.name());
            ocoi.closeAndRemove();
         }
         irc = 9;
         break;
      } else if (iout == 1) {
         info.clear();
         if (cs.makemd5) {
            char szMD5[100];
            uchar *pdig = md5.digest();
            for (int i=0; i<16; i++)
               sprintf(szMD5+i*2,"%02x",pdig[i]);
            // chain.print("%s\t%s\n", szMD5, ocoi.name());
            printFileSimple(szMD5, ocoi.name(), cs.makemd5==2 ? " *":"\t");
         } else {
            printFile("tested", ocoi.name(), nRawSize, 0, nPrintFlags);
         }
      }

      if (cs.pOutCoi!=0 && pColBuf!=0)
      {
         if (ppSharedStrings && bSharedStrings)
         {
            *ppSharedStrings = pColBuf;
            // disable auto delete. caller owns this now.
            pColBuf = 0;
         }
         else
         {
            // office filtering is done by caller
            cs.pOutCoi->setContent((uchar*)pColBuf, nColCur, nFileTime);
            // disable auto delete. OutCoi owns this now.
            pColBuf = 0;
         }
      }

      cs.filesZip++; // zip

      // jump past sub file
      if ((i+1) < gi.number_entry)
      {
         err = unzGoToNextFile(uf);

         if (err!=UNZ_OK)
         {
            perr("error %d with zipfile in unzGoToNextFile\n",err);
            break;
         }
      }
   }

   unzClose(uf);

   // set times of all folders
   {
      int nDirs = glblUnzipDirs.numberOfEntries();
      for (int i=0; i<nDirs; i++)
      {
         Coi *pcoi = glblUnzipDirs.getEntry(i, __LINE__);
         if (cs.verbose)
            info.print("settm %s\n", pcoi->name());
         cs.uname = pcoi->bClUniName;
         int isubrc = pcoi->setFileTime(pcoi->nClMTime);
         if (isubrc)
            pwarn("cannot set dir time (%d): %s\n", isubrc, pcoi->name());
      }
      glblUnzipDirs.resetEntries();
   }

   cs.uname = buname;

   if (cs.verbose)
      info.clear(); // sfk194 due to safe name print

   return irc;
}


#endif // SFKPACK

// emod zip
#endif // (sfk_prog || sfk_zip)

// dmod phraser
#if (sfk_prog || sfk_text_data)
const char *szGlblPhraseData =
{
"#:sfk-phrase-db:100:\n"
"# content is converted as:\n"
"# ,  -> random selection\n"
"# \\, -> tab\n"
"# ;  -> ,\n"
"# \\; -> ;\n"
"# \\+ -> nothing\n"
"# \\n -> linefeed\n"
"# $1sym -> remember a random index in slot 1\n"
"#          for later repeat as $1sym\n"
"\n"
"$company: $namecom\\,$stradr\\,$city $statecode $zip\n"
"$person: $nameper\\,$stradr\\,$city $statecode $zip\n"
"$nameper: $name1 $name2\n"
"$name1: $preperm,$preperf\n"
"$preperm: Arthur,Alexander,Brian,Colin,Donald,Edward,Henry,\n"
"          Jack,James,Larry,Neil,Richard\n"
"$preperf: Alice,Brenda,Dora,Ellen,Grace,Helena,Ilona,Laura,\n"
"          Lena,Sandra,Susan\n"
"$name2: Smith,Jones,Harris,Young,Scott,Cole,Ellis,Porter,\n"
"          Anderson,Johnson,Peterson,Miller\n"
"$namecom: $comsyl1$comsyl2 $combra $comtype\n"
"$pvrfile: $nametv-$date-$timemin-$tvshow.mts\n"
"$tvshow:  $tvshow1,$tvshow2,$tvshow3\n"
"$tvshow1: The $nameper $tvwhat\n"
"$tvshow2: $nameper $tvwhat\n"
"$tvshow3: $newstype News\n"
"$newstype: Market,Technology,World\n"
"$tvwhat:  Show,News,Talk\n"
"$nametv:  $typetv$jointv$nameflat\n"
"$jointv:  $dig,_\n"
"$typetv:  Channel,Station,TV,News,Cable\n"
"$nameflat: $comsyl1$comsyl2\n"
"$comsyl1: Wel,Gen,Fram,Nap,Ken,Can,New,Al,Be,Dan,El\n"
"$comsyl2: ton,mond,dale,ney,kin,port,tree,way,nex,car,dyne\n"
"$cnsyl1: Che,Wo,Fi,Gu,Kan,Sel,Ben,Chong,Ching,Wing,Fon,Bun\n"
"$cnsyl2: che,wo,fi,gu,kan,sel,ben,chong,ching,wing,fon,bun\n"
"$combra: Machinery,Printing,Design,Furniture,Computers\n"
"$comtype: Inc,Ltd\n"
"$stradr: $num3 $namestr $strtype\n"
"$date: $year$month$day\n"
"$time: $hour$minsec$minsec\n"
"$timemin: $hour$minsec\n"
"$minute: $minsec\n" // sfk187
"$second: $minsec\n" // sfk187
"$hour: 01,02,03,04,05,06,07,08,09,10,11,12,13,14,15,16,17,18,19,20,21,22,23\n"
"$minsec: 01,02,03,04,05,06,07,08,09,10,11,12,13,14,15,16,17,18,19,20,\n"
"         21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,\n"
"         41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59\n"
"$year: 2011,2012,2013,2014\n"
"$month: 01,02,03,04,05,06,07,08,09,10,11\n"
"$day:  01,02,03,04,05,06,07,08,09,10,11,12,13,14,\n"
"       15,16,17,18,19,20,21,22,23,24,25,26,27,28\n"
"$num9: $dig1$dig$dig$dig$dig$dig$dig$dig$dig\n"
"$num8: $dig1$dig$dig$dig$dig$dig$dig$dig\n"
"$num7: $dig1$dig$dig$dig$dig$dig$dig\n"
"$num6: $dig1$dig$dig$dig$dig$dig\n"
"$num5: $dig1$dig$dig$dig$dig\n"
"$num4: $dig1$dig$dig$dig\n"
"$num3: $dig1$dig$dig\n"
"$dig1: 1,2,3,4,5,6,7,8,9\n"
"$dig: 0,1,2,3,4,5,6,7,8,9\n"
"$namestr: $comsyl1$comsyl2\n"
"$strtype: Dr,Rd\n"
"$zip: $num5\n"
"$city: London,Melville,Hertford,Denton,Framingham,Orlando,Irvine,\n"
"       Seattle,Toronto,Victoria,Portland,Wellington\n"
"$statecode: AL,MT,AK,NE,AZ,NV,AR,NH,CA,NJ,CO,NM,CT,NY,DE,NC,FL,\n"
"            ND,GA,OH,HI,OK,ID,OR,IL,PA,IN,RI,IA,SC,KS,SD,KY,TN,\n"
"            LA,TX,ME,UT,MD,VT,MA,VA,MI,WA,MN,WV,MS,WI,MO,WY\n"
"$char1: A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z\n"
"$country: USA,England,Australia,Canada,Argentina,Chile,China,\n"
"          France,Germany,Greece,Japan,Spain,Taiwan\n"
"$countrycode: US,EN,AU,CA,AR,CL,CN,\n"
"          FR,DE,GR,JP,ES,TW\n"
"\n"
"$ip4: $ip4part.$ip4part.$ip4part.$ip4part\n"
"$ip4part: 1$dig$dig\n"
"\n"
"$news: $1preperm $name2 created a new product; the $2verb $3sub with $social connectivity.\\n\n"
"       It allows to $4get $images from all $5friend\\+s around your $area live on $your $watch.\\n\n"
"       \"Everyone needs a $2verb $3sub\"; $1preperm says; \"it's the smart and social way to $4get $5friend\\+s\".\n"
"$verb: flying, rolling, jumping, hoovering, wireless, talking\n"
"$sub: clock, rubber duck, camera, ventilator, rice cooker,\n"
"      coffee machine, toaster, paper weight, car key, remote control\n"
"$get: keep track of, share, post\n"
"$images: images, sounds, videos\n"
"$your: your, a friends\n"
"$watch: watch, tv, smartphone, tablet\n"
"$friend: bird, dog, cat, squirrel, turtle, hamster\n"
"$area: area, house, couch, toilet, fridge, car, bathroom, garage\n"
"$social: facebook, twitter, google, tumblr, whats app, instagram\n"
"\n"
};

class Phraser;

class Symbol
{
public:
   Symbol   (char *pszName, Phraser *parent);
   void     collect(char *pszContent);
   char    *name() { return szClName; }
   char    *solve(char *pout, int nmaxout, int nlevel, int istatic);
   bool     issep(char c);
   bool     ispunctortab(char c);
private:
   char     szClName[100];
   char     szClOpt[100];
   char     szClCont[8192];
   char     szClBuf[100];
   char     szClBuf2[200];
   // int      astatic[100];
   Phraser  *phraser;
};

class Phraser
{
public:
   Phraser  ();
  ~Phraser  ();
   int     load(char *pszAll, char *pszData);
   int     load(char *pszFile);
   char    *solve(char *psz);
   int     add(Symbol *p);
   Symbol  *get(char *pszName,int *pstatic);
   void     reset();
   void     resetIndexes();
   int      astatic[1000+10];
private:
   void     fetch(char *pbuf, char *psrc, int nlen);
   char     *pszClFilename;
   char     szClBuf1[200];
   char     szClOut[10000];
   Symbol   *psym[1000];
   int     nsym;
public:
   StringMap clfixtext;
   KeyMap    clfixidx;
};

static bool skipspace(char **ppsz) {
   char *psz = *ppsz;
   while (*psz && isspace(*psz))
      psz++;
   *ppsz = psz;
   return (*psz != 0);
}

static bool skipto(char **ppsz, char c) {
   char *psz = *ppsz;
   while (*psz && *psz != c)
      psz++;
   *ppsz = psz;
   return (*psz != 0);
}

Symbol::Symbol(char *pszName, Phraser *parent)
{
   memset(this,0,sizeof(*this));
   szClOpt[0] = '\0';
   if (cs.debug)
      printf(" create symbol: %s\n", pszName);
   char *pszopt = strchr(pszName, ',');
   if (pszopt) {
      strncpy(szClName, pszName, pszopt-pszName);
      szClName[pszopt-pszName] = '\0';
      strcopy(szClOpt, pszopt);
   } else {
      strcopy(szClName, pszName);
   }
   memset(szClCont, 0, sizeof(szClCont));
   phraser = parent;
}

bool Symbol::issep(char c)
{
   if (c == ',' || c== '\t')
      return 1;
   return 0;
}

bool Symbol::ispunctortab(char c)
{
   if (ispunct(c))
      return 1;
   if (c == '\t' || c == '\x01')
      return 1;
   return 0;
}

void Symbol::collect(char *pszContent)
{
   szLineBuf2[0] = '\0';
   copyFromFormText(pszContent, strlen(pszContent), szLineBuf2, MAX_LINE_LEN, 2);

   if (strlen(szClCont) + strlen(szLineBuf2) + 10 > sizeof(szClCont)) {
      printf("buffer overflow, %s cannot add: %s\n", szClName, dataAsTrace(szLineBuf2));
      return;
   }

   if (cs.debug)
      printf("   %s collects \"%s\"\n", szClName, szLineBuf2);

   strcat(szClCont, szLineBuf2);

   if (cs.debug)
      printf("   %s now holds \"%s\"\n", szClName, szClCont);
}

char *Symbol::solve(char *pout, int nmaxout, int nlevel, int istatic)
{
   if (cs.debug)
      printf(" %s %p solves \"%s\"\n", szClName, this, szClCont);

   int   nold = strlen(pout);
   char *pold = pout+nold;

   char szFixName[100],szFixName2[100];
   snprintf(szFixName,sizeof(szFixName)-10,"%s.%d",szClName,istatic);

   char aUsedIdx[100];
   memset(aUsedIdx,0,sizeof(aUsedIdx));

   // sfk1982 really reuse $1foo
   if (istatic>0) {
      // get fixed text for $3foo, if any
      char *pfix = phraser->clfixtext.get(szFixName);
      if (pfix) {
         int nfix=strlen(pfix);
         if (nold+nfix+10 < nmaxout) {
            memcpy(pold,pfix,nfix);
            pold[nfix] = '\0';
         }
         return pout;
      }
   }

   char *pcont = szClCont;

   // if comma-separated phrases are given,
   // which are not escaped like \,
   bool biscsep = 0;
   char clast = 0;
   char *psz = 0;
   for (psz=pcont; *psz; psz++) {
      if (issep(*psz) == 1 && clast != '\\')
         {  biscsep=1; break; }
      clast = *psz;
   }

   int itarg = 0;

   if (biscsep)
   {
      // then random-select phrase

      // count phrases
      int nwords = 0;
      char *psz1 = pcont;
      for (clast=0; *psz1; psz1++) {
         if (issep(*psz1) == 1 && clast != '\\')
            nwords++;
         clast = *psz1;
      }
      nwords++;

      // select a phrase
      #if 1
      for (int itry=0; itry<100; itry++) {
         itarg = rand() % nwords;
         if (istatic<1)
            break;
         int bwasused=0;
         // make sure $3foo uses other index then $1foo and $2foo
         for (int i=1; i<istatic; i++) {
            snprintf(szFixName2,sizeof(szFixName2)-10,"%s.%d",szClName,i);
            int iusedix = (int)phraser->clfixidx.getnum(szFixName2);
            if (iusedix==itarg)
               bwasused=1;
         }
         if (!bwasused)
            break;
      }
      #else
      int imaxsymstat = (sizeof(phraser->astatic)/sizeof(int))-10;
      if (istatic > 0 && istatic < imaxsymstat) {
         if (phraser->astatic[istatic] < 0)
            phraser->astatic[istatic] = rand();
         itarg = phraser->astatic[istatic];
      } else {
         itarg = rand();
      }
      itarg = itarg % nwords;
      #endif
      int iword = 0;
      psz1 = pcont;
      while (psz1 && *psz1)
      {
         char *psz2 = psz1;
         for (clast=0; *psz2; psz2++) {
            if (issep(*psz2) == 1 && clast != '\\')
               break;
            clast = *psz2;
         }
         if (iword == itarg) {
            mystrcopy(szClBuf2, psz1, psz2-psz1+1);
            if (cs.debug)
               printf("   sel \"%s\"\n", szClBuf2);
            pcont = szClBuf2;
            break;
         }
         iword++;
         if (issep(*psz2) == 1) psz2++;
         while (*psz2 == ' ') psz2++;
         psz1 = psz2;
      }
      if (pcont == szClCont) {
         perr("syntax error: probably too many commas in line: %s\n",szClCont);
         return 0;
      }
   }

   int iout = strlen(pout);

   if (!strchr(pcont, '$')) {
      // solve terminal
      strcat(pout, pcont);
   } else {
      // solve non-terminal
      char *psz1 = pcont;
      while (psz1 && *psz1)
      {
         char *psz2 = psz1;
         // find next sub symbol call, if any
         while (*psz2 && *psz2 != '$') psz2++;
         if (*psz2 == '$')
         {
            // flush pre-symbol content
            if (psz2 > psz1) {
               mystrcopy(szClBuf, psz1, psz2-psz1+1);
               if (cs.debug)
                  printf("   cat \"%s\"\n", szClBuf);
               strcat(pout, szClBuf);
            }
            // then solve sub symbol
            char *psz3 = psz2+1;
            while (   *psz3 && *psz3 != ' '
                   && *psz3 != '\\'
                   && !ispunctortab(*psz3)) psz3++;
            mystrcopy(szClBuf, psz2, psz3-psz2+1); // +1 for mystrcopy
            if (cs.debug)
               printf("  call \"%s\"\n", szClBuf);
            int nstatic=0;
            Symbol *psub = phraser->get(szClBuf,&nstatic);
            if (!psub) { perr("no such symbol: \"%s\"\n", szClBuf); return 0; }
            if (!psub->solve(pout, nmaxout, nlevel+1, nstatic)) return 0;
            if (!strncmp(psz3, "\\+", 2))
               psz3 += 2;
            psz1 = psz3;
            if (cs.debug)
               printf("   now on \"%s\"\n",psz1);
            // strcat(pout, " ");
            continue;
         }
         // none found: flush rest of line
         if (cs.debug)
            printf("   cat \"%s\"\n", psz1);
         strcat(pout, psz1);
         // strcat(pout, " ");
         break;
      }
   }

   // post-process output:
   // printf("%02d appended \"%s\" at offs %d\n",nlevel,pout+iout,iout);

   // apply options, if any
   int nlen = strlen(pout);
   if (strstr(szClOpt, "upper") || strstr(szClOpt, "anycase"))
   {
      // random-vary word casing
      int ncase = 0;
      if (strstr(szClOpt, "anycase")) ncase = rand() % 4;
      if (strstr(szClOpt, "upper2"))  ncase = rand() % 2;
      // printf("%02d MIXCASE %d %c of %.30s\n",nlevel,ncase,pout[iout],pout+iout);
      int i=0;
      switch (ncase) {
         case 0: pout[iout] = sfktoupper(pout[iout]); break;
         case 1:
            for (i=iout; i<nlen; i++)
               pout[i] = sfktoupper(pout[i]);
            break;
         case 2: pout[iout] = sfktolower(pout[iout]); break;
         case 3:
            for (i=iout; i<nlen; i++)
               pout[i] = sfktolower(pout[i]);
            break;
         // case 4: break; // leave as it is
      }
   }

   // convert format strings
   for (psz=pout+iout; *psz; psz++) {
      char brep=0;
      int  ilen=0;
      if (clast == '\\')
       switch (*psz) {
         case ',' : brep=',' ; ilen=1; break;
         case 't' : brep='t' ; ilen=1; break;
         case '\t': brep='\t'; ilen=1; break;
         case 'n' : brep='n' ; ilen=1; break;
         case '\\': brep='\\'; ilen=1; break;
         case '+' : brep=' ' ; ilen=2; break;
       }
      if (brep) {
         // standing on "," of "\,"
         psz--;
         memmove(psz, psz+ilen, strlen(psz+ilen)+1);
         clast = 0;
         if (ilen==2)
            psz--;
         else
            *psz = brep;
      } else {
         clast = *psz;
      }
   }

   if (cs.verbose) printf("%s.%d solves as: %s\n",szClName,istatic,pold);

   // sfk1982 really remember $1foo for reuse
   if (istatic>0) {
      phraser->clfixtext.put(szFixName,pold);
      phraser->clfixidx.putnum(szFixName,itarg);
   }

   return pout;
}

Phraser::Phraser()
{
   pszClFilename = 0;
   memset(szClBuf1, 0, sizeof(szClBuf1));
   memset(psym, 0, sizeof(psym));
   nsym = 0;
   resetIndexes();
}

Phraser::~Phraser()
{
   reset();
}

void Phraser::resetIndexes()
{
   int imaxsymstat=sizeof(astatic)/sizeof(int);
   for (int i=0; i<imaxsymstat; i++)
      astatic[i]=-1;

   clfixtext.reset(); // sfk1982
   clfixidx.reset(); // sfk1982
}

void Phraser::reset()
{
   for (int i=0; i<nsym; i++)
      delete psym[i];
   nsym = 0;
}

int Phraser::add(Symbol *p)
{
   if (nsym > (int)(sizeof(psym)/sizeof(Symbol*))-5)
      return 9+perr("too many symbols\n");
   psym[nsym++] = p;
   return 0;
}

Symbol *Phraser::get(char *pszNameIn,int *pstatic)
{
   char szName[200];
   strcopy(szName, pszNameIn);
   int istatic=0;
   if (isdigit(szName[1])) {
      istatic=atoi(szName+1);
      int imove=1;
      while (isdigit(szName[imove]))
         imove++;
      memmove(szName+1,szName+imove,strlen(szName+imove)+1);
      if (pstatic)
         *pstatic=istatic;
   }
   for (int i=0; i<nsym; i++) {
      if (!psym[i])
         return 0;
      if (!strcmp(psym[i]->name(), szName))
         return psym[i];
   }
   return 0;
}

void Phraser::fetch(char *pbuf, char *psrc, int nlen) {
   if (nlen > (int)sizeof(szClBuf1)-4)
      {  perr("buffer overflow.1\n"); exit(9); }
   strncpy(pbuf, psrc, nlen);
   pbuf[nlen] = '\0';
}

int Phraser::load(char *pszAll, char *pszData)
{
   char *pszSymb = 0;
   Symbol *ps = 0;
   int nstate = 1, nline = 0;
   int  iLineLen = 0;
   bool bAddLineFeed = 0;

   char *pszSrcCur = pszData;
   char *pszNext   = 0;

   while (*pszSrcCur)
   {
      if (pszAll) {
         snprintf(szLineBuf, MAX_LINE_LEN, "all: %s", pszAll);
         pszAll = 0;
      } else {
         pszNext = strchr(pszSrcCur, '\n');
         if (!pszNext)
            pszNext = pszSrcCur + strlen(pszSrcCur);
         int ilen = (int)(pszNext - pszSrcCur);
         if (ilen > MAX_LINE_LEN)
             ilen = MAX_LINE_LEN;
         memcpy(szLineBuf, pszSrcCur, ilen);
         szLineBuf[ilen] = '\0';
      }

      // symbol: word1 word2 $symbol word4
      //         word5 $symbol word6 ...
      removeCRLF(szLineBuf);
      nline++;

      if (cs.debug)
         printf("LINE \"%s\"\n", szLineBuf);

      char *psz1 = szLineBuf;

      if (szLineBuf[0]=='#' || szLineBuf[0]=='\0')
      {
         // skip
      }
      else
      while (psz1 && *psz1)
      {
         if (cs.debug)
            printf("state %d on \"%s\"\n", nstate, psz1);
         char *psz2 = psz1;
         switch (nstate)
         {
            case 1:  // expect new symbol name
               if (!skipto(&psz2, ':'))
                  return 9+perr("syntax error: missing \"symbol:\" in line %d\n", nline);
               fetch(szClBuf1, psz1, psz2-psz1);
               pszSymb = szClBuf1;
               psz1 = psz2+1;
               nstate = 2;
               break;

            case 2:  // expect content in symbol name line
               if (!skipspace(&psz2))
                  return 9+perr("syntax error: missing content after \"%s:\"\n", pszSymb);
               ps = new Symbol(pszSymb, this);
               if (add(ps)) return 9;
            case 4:
               if (!skipspace(&psz2))
                  return 9+perr("syntax error in line %d\n",nline);
               iLineLen = strlen(psz2);
               bAddLineFeed = 0;
               if (iLineLen >= 2 && strncmp(psz2+iLineLen-2, "\\n", 2) == 0) {
                  psz2[iLineLen-2] = '\0';
                  bAddLineFeed = 1;
               }
               ps->collect(psz2);
               psz1 = 0;
               nstate = 3;
               break;

            case 3:  // either additional content, or new symbol name
               if (*psz2 == ' ') {
                  // additional content
                  if (bAddLineFeed)
                     ps->collect(str("\n"));
                  else
                     ps->collect(str(" "));
                  nstate = 4;
                  continue;
               } else {
                  // new symbol name
                  nstate = 1;
                  continue;
               }
         }
      }

      if (pszNext) {
         pszSrcCur = pszNext;
         if (*pszSrcCur)
            pszSrcCur++;
      }
   }

   return 0;
}

char *Phraser::solve(char *pszName)
{
   // e.g. solving "all"
   Symbol *proot = get(pszName,0);
   if (!proot) return 0;
   szClOut[0] = '\0';
   char *pres = proot->solve(szClOut, sizeof(szClOut)-10, 0, 0);
   // convert ,, replacement code back to printable ,
   if (pres) {
      char *psz = pres;
      while ((psz = strchr(psz, 0x01)))
         *psz++ = ',';
   }
   return pres;
}

int execPhraser(char *pszAll, char *pszSrc, int iNumRec)
{
   Phraser *p = new Phraser();
   if (p->load(pszAll, (char*)pszSrc))
      return 9;

   for (int i=0; i<iNumRec; i++)
   {
      p->resetIndexes();

      char *pres = p->solve(str("all"));
      if (!pres) return 9+perr("cannot solve 'all'\n");

      if (chain.coldata) {
         if (chain.colbinary) {
            if (chain.addBinary((uchar*)pres, strlen(pres)))
               return 9;
         } else {
            if (chain.addLine(pres, str("")))
               return 9;
         }
      }
      else if (chain.colfiles) {
         Coi ocoi(pres, 0);
         if (chain.addFile(ocoi)) // is copied
            return 9+perr("out of memory");
      } else {
         printf("%s\n", pres);
      }
   }

   p->reset();
   delete p;

   return 0;
}
// emod phraser
#endif // (sfk_prog || sfk_text_data)

// dmod file_bintext
#if (sfk_prog || sfk_file_bintext)
int dumpBlock(uchar *pCur, int lSize, int nmode)
{
   FILE *fout = fGlblOut;
   int i=0;
   switch (nmode)
   {
      case 2:
      {
         bool bAddPad = ((lSize & 1) != 0);
         fprintf(fout, "\t\"");
         uchar u1, u2;
         for (i=0; i<lSize; i += 2) {
            // if input has uneven size, the very last byte
            // is not read from input, but filled with dummy 0xFF.
            u1 = pCur[i+0];
            if (i < lSize-2 || !bAddPad)
               u2 = pCur[i+1];
            else
               u2 = 0xFF;
            fprintf(fout, "\\u%02x%02x", u1, u2);
         }
         fprintf(fout, "\",");
      }
         break;

      case 1:
         for (i=0; i<lSize; i++) {
            if (pCur[i])
               fprintf(fout, "0x%x,", pCur[i]);
            else
               fprintf(fout, "0,");
         }
         break;

      default:
         for (i=0; i<lSize; i++)
            fprintf(fout, "%u,", (unsigned int)pCur[i]);
         break;
   }
   fprintf(fout,"\n");
   return 0;
}

uchar *binPack(uchar *pIn, uint nInSize, ulong &rnOutSize)
{__
   ulong nOutSize = 0;
   uchar *pOut = 0;
   uchar *pMem = 0;
   uchar *pMax = pIn + nInSize;
   uchar *pCur = 0;
   uchar *pOld = 0;
   uchar *pNul = 0;

   for (uchar npass=1; npass <= 2; npass++)
   {
      if (npass == 1)
         pOut = pNul;
      else {
         pMem = new uchar[nOutSize];
         pOut = pMem;
      }

      pCur = pIn;
      pOld = pCur;

      while (pCur < pMax)
      {
         // detect repetition of patterns up to size 3
         uchar nbestsize = 0;
         uchar nbestgain = 0;
         uchar nbestrep  = 0;
         for (uchar isize = 1; isize <= 3; isize++) {
            uchar nrep  = 0;
            uchar bbail = 0;
            for (; (pCur+(nrep+1)*isize < pMax) && (nrep < 60) && !bbail; nrep++)
            {
               for (uchar i1=0; (i1<isize) && !bbail; i1++)
                  if (pCur[nrep*isize+i1] != pCur[i1])
                     bbail = 1;
               if (bbail)
                  break;
            }
            // this always results in nrep >= 1.
            uchar ngain = (nrep-1)*isize;
            if (ngain >= 3) {
               // there is a repetition, saving at least 3 bytes.
               // determine max savings accross all sizes.
               if (ngain > nbestgain) {
                  nbestgain = ngain;
                  nbestsize = isize;
                  nbestrep  = nrep;
               }
            }
         }
         // if (nbestrep > 0)
         //   printf("size %02u rep %02u gain %02u at %x\n", nbestsize, nbestrep, nbestgain, pCur-pIn);

         // if repeat pattern found,
         // OR if non-repeat exceeds maxsize
         if ( (nbestrep > 0) || ((pCur - pOld) >= 60) ) {
            // flush non-packable, if any
            if (pCur > pOld) {
               // printf("[flush non-pack %x]\n", pCur-pOld);
               uchar nDist = pCur-pOld;
               if (npass == 1) {
                  pOut++;
                  pOut += (pCur - pOld);
               } else {
                  *pOut++ = 0x00 | nDist;
                  while (pOld < pCur)
                     *pOut++ = *pOld++;
               }
               pOld  = pCur;
            }
            // flush packable, if any
            if (nbestrep > 0) {
               // printf("[pack %x %x]\n", nbestsize, nbestrep);
               if (npass == 1) {
                  pOut++;
                  pOut += nbestsize;
                  pCur += nbestsize;
               } else {
                  *pOut++ = (nbestsize << 6) | nbestrep;
                  for (uchar i1=0; i1<nbestsize; i1++)
                     *pOut++ = *pCur++;
               }
               pCur += (nbestrep-1)*nbestsize;
               pOld  = pCur;
            }
         } else {
            // count non-packable
            pCur++;
         }
      }

      // flush remainder, if any
      if (pCur > pOld) {
         // printf("[flush trailer %x]\n", pCur-pOld);
         uchar nDist = pCur-pOld;
         if (npass == 1) {
            pOut++;
            pOut += (pCur - pOld);
         } else {
            *pOut++ = 0x00 | nDist;
            while (pOld < pCur)
               *pOut++ = *pOld++;
         }
         pOld  = pCur;
      }

      if (npass == 1) {
         nOutSize = (ulong)(pOut - pNul);
         // printf("packsize %lu\n", nOutSize);
      }
   }

   rnOutSize = nOutSize;
   return pMem;
}

// unused?
uchar *binUnpack(uchar *pIn, uint nInSize, ulong &rnOutSize)
{__
   ulong nOutSize = 0;
   uchar *pOut = 0;
   uchar *pMem = 0;
   uchar *pMax = pIn + nInSize;
   uchar *pCur = 0;
   uchar *pOld = 0;
   uchar *pNul = 0;

   for (uchar npass=1; npass <= 2; npass++)
   {
      if (npass == 1)
         pOut = pNul;
      else {
         pMem = new uchar[nOutSize];
         pOut = pMem;
      }

      pCur = pIn;
      pOld = pCur;

      while (pCur < pMax)
      {
         uchar ncmd = *pCur++;
         if (ncmd >= 64) {
            // unpack repeat block
            uchar nsiz = ncmd >> 6;
            uchar nrep = ncmd & 0x3F;
            // printf("[upack-rep %x %x (%x)]\n", nsiz, nrep, ncmd);
            // reproduce reference pattern nrep times
            if (npass == 1)
               pOut += nrep * nsiz;
            else
            for (; nrep > 0; nrep--)
               for (uchar i1=0; i1<nsiz; i1++)
                  *pOut++ = *(pCur+i1);
            // skip reference pattern
            pCur += nsiz;
         } else {
            // unpack skip block
            uchar nrep = ncmd;
            // printf("[upack-skip %x]\n", nrep);
            if (npass == 1) {
               pOut += nrep;
               pCur += nrep;
            }
            else
            for (; (nrep > 0) && (pCur < pMax); nrep--)
               *pOut++ = *pCur++;
         }
      }

      if (npass == 1) {
         nOutSize = (ulong)(pOut - pNul);
         // printf("unpacksize %lu\n", nOutSize);
      }
   }

   rnOutSize = nOutSize;
   return pMem;
}

int execBinToJava(uchar *pIn, int lInSize, bool bPack, char *pszNameBase, bool bClass, int nRecSize)
{__
   FILE *fout = fGlblOut;

   if (bClass)
   fprintf(fout,
      "\n"
      "import java.io.*;\n"
      "\n"
      "public class %s {\n"
      "\n"
      "\tpublic static void main(String args[]) throws Throwable {\n"
      "\t\tbyte abData[] = %s_getBlock();\n"
      "\t\tFileOutputStream fout = new FileOutputStream(args[0]);\n"
      "\t\tfout.write(abData, 0, abData.length);\n"
      "\t}\n"
      "\n"
      ,pszNameBase,pszNameBase
      );

   fprintf(fout,
      "\tpublic static int %s_BlockSize = %d;\n"
      "\tstatic String %s_RawBlock[] = {\n"
      ,pszNameBase,lInSize,pszNameBase);

   int lRemain = lInSize;
   uchar *pCur  = pIn;
   while (lRemain > nRecSize) {
      dumpBlock(pCur, nRecSize, 2);
      lRemain -= nRecSize;
      pCur += nRecSize;
   }
   if (lRemain > 0)
      dumpBlock(pCur, lRemain, 2);

   fprintf(fout, "\t};\n\n");

   char *pname=pszNameBase;
   fprintf(fout,
      "\tpublic static byte[] %s_getBlock() {\n"
      "\t   int iout=0, nblen=%s_BlockSize;\n"
      "\t   char atmp[] = new char[%d];\n"
      "\t   byte aout[] = new byte[nblen];\n"
      "\t   for (int i=0; i<%s_RawBlock.length; i++) {\n"
      "\t      String stmp = %s_RawBlock[i];\n"
      "\t      int nlen = stmp.length();\n"
      "\t      stmp.getChars(0,nlen,atmp,0);\n"
      "\t      for (int k=0; k<nlen; k++) {\n"
      "\t         char c = atmp[k];\n"
      "\t         byte bhi = (byte)(c >> 8);\n"
      "\t         byte blo = (byte)(c >> 0);\n"
      "\t         aout[iout++] = bhi;\n"
      "\t         if (iout < nblen)\n"
      "\t            aout[iout++] = blo;\n"
      "\t      }\n"
      "\t   }\n"
      "\t   return aout;\n"
      "\t}\n\n"
      ,pname,pname,nRecSize,pname,pname
      );

   if (bClass)
   fprintf(fout,
      "}\n\n"
      );

   return 0;
}

int execBinToCpp(uchar *pIn, int lInSize, bool bPack, char *pszNameBase, bool bHex)
{__
   int lOldInSize = lInSize;

   if (bPack) {
      ulong nPackSize = 0;
      // binPack alloc's mem block with packed data
      pIn = binPack(pIn, lInSize, nPackSize);
      lInSize = (int)nPackSize;
   }

   fprintf(fGlblOut,"#define %s_BLOCK_SIZE %u\n\n", pszNameBase, lOldInSize);
   fprintf(fGlblOut,"static unsigned char %s_abRawBlock[%u] = {\n", pszNameBase, lInSize);
   int lRemain = lInSize;
   uchar *pCur  = pIn;
   while (lRemain > 32) {
      dumpBlock(pCur, 32, bHex ? 1 : 0);
      lRemain -= 32;
      pCur += 32;
   }
   if (lRemain > 0)
      dumpBlock(pCur, lRemain, bHex ? 1 : 0);
   fprintf(fGlblOut,"};\n");

   if (bPack) {
fprintf(fGlblOut,
   "\n"
   "// input : target buffer and buffer size.\n"
   "//         must have size >= %s_BLOCK_SIZE.\n"
   "// result: 0 if OK, 9 on buffer overflow.\n"
   "// note  : output data is not null terminated.\n"
   "int %s_getBlock(uchar *pOut, uint nOutSize)\n",
   pszNameBase, pszNameBase
   );
fprintf(fGlblOut,
   "{\n"
   "   uchar *pCur    = %s_abRawBlock;\n"
   "   uint nInSize  = %u;\n"
   "   uchar *pMax    = pCur + nInSize;\n"
   "   uchar *pOutMax = pOut + nOutSize;\n"
   "   while (pCur < pMax)\n"
   "   {\n"
   "      uchar ncmd = *pCur++;\n"
   "      if (ncmd >= 64) {\n"
   "         uchar nsiz = ncmd >> 6;\n"
   "         uchar nrep = ncmd & 0x3F;\n"
   "         for (; nrep > 0; nrep--)\n"
   "            for (uchar i1=0; i1<nsiz; i1++) {\n"
   "               if (pOut >= pOutMax) return 9;\n"
   "               *pOut++ = *(pCur+i1);\n"
   "            }\n"
   "         pCur += nsiz;\n"
   "      } else {\n"
   "         uchar nrep = ncmd;\n"
   "         for (; (nrep > 0) && (pCur < pMax); nrep--) {\n"
   "            if (pOut >= pOutMax) return 9;\n"
   "            *pOut++ = *pCur++;\n"
   "         }\n"
   "      }\n"
   "   }\n"
   "   return 0;\n"
   "}\n",
   pszNameBase, lInSize
      );
      delete [] pIn;
   }

   return 0;
}

cchar *szGlblXXEncode =
   "+-0123456789"
   "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
   "abcdefghijklmnopqrstuvwxyz";

static int uuenc(int c, int bxx)
{
   if (bxx)
      return szGlblXXEncode[c & 0x3F];

   return ((c) ? ((c) & 0x3F) + ' ': 0x60);
}

int execUUEncode(Coi *pcoi)
{
   num nFileTime = 0;
   num nFileSize = 0;
   uint nFileMode=0644;
   SFKMD5 md5;

   bool b64 = 0;
   bool buu = b64 ? 0 : 1;
   int  bxx = cs.xxencode;

   if (!cs.pure)
   {
      // force full status read
      pcoi->nClStatus = 0;
      pcoi->readStat('u');
      nFileTime = pcoi->getTime();
      nFileSize = pcoi->getSize();
      getFileMD5(pcoi, md5, 1, 0);
      #ifndef _WIN32
      nFileMode = pcoi->getAttr() & 0777;
      #endif
   }

   if (cs.sim) {
      info.print("add: %s\n", pcoi->name());
      cs.filesChg++;
      cs.totalinbytes += nFileSize;
      return 0;
   }

   if (pcoi->open("rb"))
      return 9+pferr(pcoi->name(), "cannot read: %s", pcoi->name());

   if (!cs.quiet && !cs.nonames && cs.overallOutFilename)
      info.print("add: %s\n", pcoi->name());

   if (!cs.pure) {
      uchar *p=md5.digest();
      char cform = bxx ? 'x' : 'u';
      if (b64) cform = 'b';
      chain.print("meta s%s t%s c%02x%02x%02x%02x f%c\n",
         numtoa(nFileSize, 1, szLineBuf),
         timeAsString(nFileTime, 1),
         p[0],p[1],p[2],p[3], cform);
   }

   strcopy(szLineBuf, pcoi->name());

   if (cs.outpathchar != 0)
      for (int i=0; szLineBuf[i]; i++)
         if (szLineBuf[i]=='\\' || szLineBuf[i]=='/')
            szLineBuf[i] = cs.outpathchar;

   chain.print("begin%s %o %s\n", b64?"-base64":"", nFileMode, szLineBuf);

   int    c=0, n=0, iDst=0;
   uchar *p=0;

   while ((n = pcoi->read(szLineBuf, 45)))
   {
      szLineBuf[n] = '\0';
      iDst=0;

      if (buu)
         szLineBuf2[iDst++] = uuenc(n, bxx);

      for (p=(uchar*)szLineBuf; n>0; n-=3, p+=3)
      {
         if (n < 3) {
            p[2] = '\0';
            if (n < 2)
               p[1] = '\0';
         }

         if (b64) {
            encodeSub64(p, (uchar*)szLineBuf2+iDst, n);
            iDst += 4;
         } else {
            c = uuenc(*p >> 2, bxx);
             szLineBuf2[iDst++] = c;
            c = uuenc(((*p << 4) & 0x30) | ((p[1] >> 4) & 0x0F), bxx);
             szLineBuf2[iDst++] = c;
            c = uuenc(((p[1] << 2) & 0x3C) | ((p[2] >> 6) & 0x03), bxx);
             szLineBuf2[iDst++] = c;
            c = uuenc(p[2] & 0x3F, bxx);
             szLineBuf2[iDst++] = c;
         }
      }

      szLineBuf2[iDst] = '\0';
      chain.print("%s\n",szLineBuf2);
   }

   if (b64) {
      chain.print("====\n\n");
   } else {
      if (bxx==0 || bxx==2)
         chain.print("%c\n", uuenc('\0', bxx));
      chain.print("end\n\n");
   }

   pcoi->close();

   cs.filesChg++;

   return 0;
}

static int uudec(int c, int bxx)
{
   if (bxx) {
      cchar *p = strchr(szGlblXXEncode, c);
      if (!p) return 0;
      int ival = (int)(p - szGlblXXEncode);
      return ival;
   }

   return (((c) - 32) & 0x3F);
}

static int uuisdec(int c, int bxx)
{
   if (bxx)
      return strchr(szGlblXXEncode, c) ? 1 : 0;

   return ((((c) - 32) >= 0) && (((c) - 32) <= 0x3F + 1));
}

int execUUDecode(char *pszInFile, char *pszToDir, int bxx)
{
   char szOutFile[SFK_MAX_PATH+100];
   char szInBuf[1024+100];
   char szPreBuf[1024+110];
   FILE *fout=0;

   int  istate=0, i=0, c=0, iLine=0, iend=0;
   char *p=0, *pszLine=0;
   bool b64=0,buu=1;

   num nOutBytes=0;
   num nMetaSize=0;
   char szTime[50];
   num nMetaTime=0;
   uchar abMetaMD[16]; mclear(abMetaMD);
   uchar abOwnMD[16]; mclear(abOwnMD);
   int imdlen=0, iexists=0;
   uint nFileMode=0644;

   szInBuf[0] = '\0';
   szPreBuf[0] = '\0';

   Coi *pcoi = 0;
   if (pszInFile)
      pcoi = new Coi(pszInFile, 0);
   CoiAutoDelete odel(pcoi, 0);
   if (pcoi && pcoi->open("rb"))
      return 9+pferr(pszInFile,"cannot read: %s",pszInFile);

   if (!cs.yes) printx("$[simulating:]\n");

   while (1)
   {
      strcopy(szPreBuf, szInBuf);
      if (pcoi) {
         if (pcoi->readLine(szInBuf, sizeof(szInBuf)-100) <= 0)
            break;
         pszLine = szInBuf;
      } else {
         if (iLine>=chain.indata->numberOfEntries())
            break;
         pszLine = chain.indata->getEntry(iLine, __LINE__);
         iLine++;
      }
      removeCRLF(pszLine);

      if (istate==0) {
         if (strBegins(pszLine, "meta ")) {
            char *psz=pszLine+5;
            while (isspace(*psz)) psz++;
            if (*psz!='s') // size
               continue;
             nMetaSize=atonum(psz+1);
            while (*psz && !isspace(*psz)) psz++;
            while (isspace(*psz)) psz++;
            if (*psz!='t') // time
               continue;
             strcopy(szTime,psz+1); szTime[14]='\0';
             timeFromString(szTime,nMetaTime,1); // local or UTC?
            while (*psz && !isspace(*psz)) psz++;
            while (isspace(*psz)) psz++;
            if (*psz!='c') // checksum
               continue;
            psz++;
            if (strlen(psz) >= 8) {
             for (int i=0;i<4 && isxdigit(psz[i*2]);i++) {
                abMetaMD[i]=(uchar)getTwoDigitHex(psz+i*2);
                imdlen=i+1;
             }
            }
            continue;
         }
         char *psz=0;
         if (strBegins(pszLine, "begin-base64 ")) // internal
            { b64=1; buu=0; psz=pszLine+13; }
         else if (strBegins(pszLine, "begin "))
            { b64=0; buu=1; psz=pszLine+6; }
         else
            continue;
         nFileMode=strtol(psz,0,8);
         while (*psz!=0 && isspace(*psz)==0) psz++;
         while (isspace(*psz)) psz++;
         strcopy(szOutFile, psz);
         fixPathChars(szOutFile);
         if (isPathTraversal(szOutFile, 1)) {
            pferr(szOutFile, "forbidden output path: %s", szOutFile);
            istate=0;
            continue;
         }

         int iMasks = glblUnzipMask.numberOfEntries();
         // ----- filter by masks -----
         int iPosMasks=0, iPosMatch=0, bskip=0;
         for (int imask=0; imask<iMasks; imask++)
         {
            // TEMPORARY use of szLineBuf3 to build /mask/
            snprintf(szLineBuf3, MAX_LINE_LEN, "%c%s%c", glblPathChar, szOutFile, glblPathChar);
            char *pmask = glblUnzipMask.getString(imask);
            int n1=0, n2=0;
            bool bneg   = 0;
            if (*pmask==glblNotChar)
               { bneg=1; pmask++; }
            bool bmatch = matchstr(szLineBuf3, pmask, 0, n1, n2);
            if (bneg) {
               // apply blacklisting: -pat .h !.html
               if (bmatch)
                  { iPosMasks=0; iPosMatch=0; bskip=1; break; }
            } else {
               // prepare whitelisting
               iPosMasks++;
               if (bmatch)
                  iPosMatch++;
            }
         }
         if (bskip)
            continue;
         if (iPosMasks>0 && iPosMatch==0)
            continue;

         if (pszToDir) {
            joinPath(szLineBuf3, MAX_LINE_LEN, pszToDir, szOutFile);
            if (strlen(szLineBuf3)+10 >= SFK_MAX_PATH)
               return 9+perr("output name too long: %s\n", szLineBuf3);
            strcopy(szOutFile, szLineBuf3);
         }
         if (!cs.yes && fileExists(szOutFile,1)) {
            printx("<warn>would overwrite: %s\n",szOutFile);
            iexists++;
         } else {
            printf("%swrite: %s\n",cs.yes?"":"would ",szOutFile);
         }
         if (cs.yes) {
            createOutDirTree(szOutFile);
            fout=fopen(szOutFile, "wb");
            if (!fout)
               return 9+pferr(szOutFile, "cannot write: %s", szOutFile);
            cs.filesChg++;
         }
         istate=1;
         iend=0;
         continue;
      }

      p = pszLine;

      /*
         xxencode format: every encoded line has at least 5 chars,
            so "end" is a safe end marker. no null record needed.

         uuencode format: can be detected by null record: \x60{eol}
      */

      if (strcmp(p, "end")==0)
         iend=1;

      if (   (b64 && strBegins(p, "===="))
          || (buu && ((i = uudec(*p, bxx)) <= 0))
          || (bxx==1 && strcmp(p, "end")==0)
         )
      {
         if (fout) {
            fclose(fout);
            #ifndef _WIN32
            chmod(szOutFile, nFileMode | S_IREAD | S_IWRITE);
            #endif
            fout=0;
            if (imdlen==4) {
               getFileMD5(szOutFile, abOwnMD);
               if (memcmp(abMetaMD,abOwnMD,4)==0) {
                  if (cs.verbose) printf("... sum checked, ok\n");
               } else {
                  perr("checksum mismatch: %s",szOutFile);
                  pinf("%02x%02x%02x%02x / %02x%02x%02x%02x\n",
                     abOwnMD[0],abOwnMD[1],abOwnMD[2],abOwnMD[3],
                     abMetaMD[0],abMetaMD[1],abMetaMD[2],abMetaMD[3]);
               }
            }
            if (nMetaSize) {
               num nOwnSize=getFileSize(szOutFile);
               if (nOwnSize!=nMetaSize)
                  perr("filesize mismatch: %s / %s",
                     numtoa(nOwnSize,1,szLineBuf),
                     numtoa(nMetaSize,1,szLineBuf2));
            }
            if (nMetaTime) {
               FileStat ofdst;
               ofdst.readFrom(szOutFile);
               #ifdef _WIN32
               ofdst.src.nHaveWFT=0;
               #endif
               ofdst.src.nMTime=nMetaTime;
               ofdst.writeTo(szOutFile, __LINE__, 1);
               if (cs.verbose) printf("... set filetime: %s %s\n",timeAsString(nMetaTime,0),szOutFile);
            }
            nMetaSize=0;
            nMetaTime=0;
            imdlen=0;
         }
         if (bxx==1 && iend==0) {
            perr("missing end record.\n");
            istate=4;
            break;
         }
         istate=0;
         continue;
      }

      if (b64) {
         uchar *psrc = (uchar*)pszLine;
         uchar *pmaxsrc = psrc + strlen(pszLine);
         uchar in[4], out[3], v;
         int i=0, nlen=0;
         mclear(in); mclear(out);
         while (psrc < pmaxsrc) {
            for (nlen=0, i=0; i < 4 && (psrc < pmaxsrc); i++ ) {
               v = 0;
               while ((psrc < pmaxsrc) && v == 0) {
                  v = *psrc++;
                  v = mapchar(v);
               }
               if (psrc <= pmaxsrc) {
                  if (v) {
                     nlen++;
                     in[i] = v - 1;
                  } else {
                     in[i] = 0;
                  }
               } else {
                  in[i] = 0;
               }
            }
            if (nlen) {
               decodeSub64(in, out);
               for (i=0; i<nlen-1; i++) {
                  if (fout)
                     fputc(out[i], fout);
                  nOutBytes++;
               }
            }
         }
      }
      else for (++p; i > 0; p += 4, i -= 3)
      {
         if (i >= 3) {
            if (!(uuisdec(*p, bxx) && uuisdec(*(p + 1), bxx) &&
                 uuisdec(*(p + 2), bxx) && uuisdec(*(p + 3), bxx)))
               { istate=4; break; }
            c = uudec(p[0], bxx) << 2 | uudec(p[1], bxx) >> 4;
            if (fout) fputc(c, fout);
            nOutBytes++;
            c = uudec(p[1], bxx) << 4 | uudec(p[2], bxx) >> 2;
            if (fout) fputc(c, fout);
            nOutBytes++;
            c = uudec(p[2], bxx) << 6 | uudec(p[3], bxx);
            if (fout) fputc(c, fout);
            nOutBytes++;
         }
         else {
            if (i >= 1) {
               if (!(uuisdec(*p, bxx) && uuisdec(*(p + 1), bxx)))
                  { istate=5; break; }
               c = uudec(p[0], bxx) << 2 | uudec(p[1], bxx) >> 4;
               if (fout) fputc(c, fout);
               nOutBytes++;
            }
            if (i >= 2) {
               if (!(uuisdec(*(p + 1), bxx) &&
                   uuisdec(*(p + 2), bxx)))
                  { istate=6; break; }
               c = uudec(p[1], bxx) << 4 | uudec(p[2], bxx) >> 2;
               if (fout) fputc(c, fout);
               nOutBytes++;
            }
            if (i >= 3) {
               if (!(uuisdec(*(p + 2), bxx) &&
                   uuisdec(*(p + 3), bxx)))
                  { istate=7; break; }
               c = uudec(p[2], bxx) << 6 | uudec(p[3], bxx);
               if (fout) fputc(c, fout);
               nOutBytes++;
            }
         }
      }

      if (istate >= 3)
         break;
   }

   if (fout)
      fclose(fout);

   if (pcoi)
      pcoi->close();

   if (istate >= 4) {
      perr("invalid encoding found.\n");
      if (bxx)
         pinf("try uudecode instead of xxdecode.\n");
      else
         pinf("try xxdecode instead of uudecode.\n");
      return 9;
   }

   if (iexists)
      printx("<warn>%d existing output files would be overwritten.\n",iexists);

   if (!cs.yes) printx("$[add -yes to execute.]\n");

   return 0;
}

// emod file_bintext
#endif // (sfk_prog || sfk_file_bintext)

int execTextJoinLines(char *pIn) {
   // join a text file with lines broken by mailing

   // 1. pre-scan for line length maximum
   char *psz = pIn;
   int nLineChars = 0;
   int nLineCharMax = 0;
   while (*psz)
   {
      char c = *psz++;
      if (c == '\r')
         continue;
      if (c == '\n') {
         if (nLineChars > nLineCharMax)
            nLineCharMax = nLineChars;
         nLineChars = 0;
         continue;
      }
      nLineChars++;
   }

   if (!cs.quiet)
      printf("[line break near %d]\n", nLineCharMax);

   // 2. join lines which are broken, pass-through others
   psz = pIn;
   nLineChars = 0;
   while (*psz)
   {
      char c = *psz++;

      if (c == '\r') // drop CR. LF-mapping is done by runtime.
         continue;

      if (c == '\n') {
         // line collected. what to do?
         if (   (nLineChars < nLineCharMax-1)
             || (nLineChars > nLineCharMax)
            )
         {
            fputc(c, fGlblOut);  // not near threshold: do not join
         }
         nLineChars = 0;
         continue;
      } else {
         fputc(c, fGlblOut);
      }

      nLineChars++;
   }
 
   return 0;
}

// dmod file_test
#if (sfk_prog || sfk_file_test)
// uses szLineBuf. pOutBuf must be >= 16 bytes.
int getFuzzyTextSum(char *pszFile, uchar *pOutBuf)
{
   // this function reads a text file line by line, and
   // - strips line endings
   // - turns all \\ slashes into /
   // - ignores the SEQUENCE of lines
   // to make result files of sfk commands comparable
   // both accross platforms, and independent from the sequence
   // in which files happen to be read from the file system.
   FILE *fin = fopen(pszFile, "rb");
   if (!fin) return 9+pferr(pszFile, "cannot read: %s\n", pszFile);
   uchar abSum[16];
   memset(abSum, 0, sizeof(abSum));
   myfgets_init();
   while (myfgets(szLineBuf, sizeof(szLineBuf)-10, fin))
   {
      szLineBuf[sizeof(szLineBuf)-10] = '\0';
      removeCRLF(szLineBuf);
      uint nLen = strlen(szLineBuf);
      // turn all non-/ slashes into /
      for (uint i=0; i<nLen; i++)
         if (szLineBuf[i] == '\\')
             szLineBuf[i] = '/';
      if (cs.verbose) printf("sum: \"%s\"\n", szLineBuf);
      // build local checksum over line
      SFKMD5 md5;
      md5.update((uchar*)szLineBuf, nLen);
      // xor this with overall checksum
      unsigned char *pmd5 = md5.digest();
      for (uint k=0; k<16; k++)
         abSum[k] ^= pmd5[k];
   }
   fclose(fin);
   memcpy(pOutBuf, abSum, 16);
   return 0;
}

int getFuzzyTextSum(char *pszText, int iTextLen, uchar *pOutBuf)
{
   uchar abSum[16];
   memset(abSum, 0, sizeof(abSum));
 
   char *pszCur = pszText;
   char *pszMax = pszText + iTextLen;

   bool bStop=0;
   while (pszCur < pszMax)
   {
      char *pszNext = strchr(pszCur, '\n');
      if (!pszNext) {
         pszNext = pszCur+strlen(pszCur);
         bStop=1;
      }

      int iLen = pszNext-pszCur;
      if (iLen > MAX_LINE_LEN)
         break;
      memcpy(szLineBuf, pszCur, iLen);
      szLineBuf[iLen] = '\0';

      removeCRLF(szLineBuf);
      uint nLen = strlen(szLineBuf);
      // turn all non-/ slashes into /
      for (uint i=0; i<nLen; i++)
         if (szLineBuf[i] == '\\')
             szLineBuf[i] = '/';
      if (cs.verbose) printf("sum: \"%s\"\n", szLineBuf);
      // build local checksum over line
      SFKMD5 md5;
      md5.update((uchar*)szLineBuf, nLen);
      // xor this with overall checksum
      unsigned char *pmd5 = md5.digest();
      for (uint k=0; k<16; k++)
         abSum[k] ^= pmd5[k];

      if (bStop)
         break;

      pszCur = pszNext;
      pszCur++;
   }

   memcpy(pOutBuf, abSum, 16);

   return 0;
}

class TestDB
{
public:
   TestDB   (char *pszFile);
  ~TestDB   ( );
   int     load     (bool bSilent);
   int     write    ( );
   void     shutdown ( );

   int     update   (char *pszInKey, char *pszInVal);
   char    *getValue (char *pszInKey);

private:
   char  *pszClFile;
   StringTable clKeys;
   StringTable clVals;
};

TestDB::TestDB(char *pszFile)
{
   pszClFile = strdup(pszFile);
}

TestDB::~TestDB() { shutdown(); }

void TestDB::shutdown() {
   if (pszClFile) { delete [] pszClFile; pszClFile = 0; }
}

// uses szLineBuf
int TestDB::load(bool bSilent) {
   FILE *fin = fopen(pszClFile, "r");
   if (!fin) {
      if (!bSilent)
         perr("unable to load %s\n", pszClFile);
      return 9;
   }
   int nLine = 0;
   while (fgets(szLineBuf, sizeof(szLineBuf)-10, fin)) {
      nLine++;
      removeCRLF(szLineBuf);
      char *psz = strchr(szLineBuf, ':');
      if (!psz) {
         perr("wrong record format in %s line %d\n", pszClFile, nLine);
         fclose(fin);
         return 9;
      }
      *psz = '\0';
      char *pszVal = psz+1;
      char *pszKey = szLineBuf;
      clKeys.addEntry(pszKey);
      clVals.addEntry(pszVal);
   }
   fclose(fin);
   return 0;
}

int TestDB::write() {
   FILE *fout = fopen(pszClFile, "w");
   if (!fout) return 9+perr("unable to write %s\n", pszClFile);
   int nRec = clKeys.numberOfEntries();
   for (int i=0; i<nRec; i++) {
      char *pszKey = clKeys.getEntry(i, __LINE__);
      char *pszVal = clVals.getEntry(i, __LINE__);
      if (!pszKey || !pszVal) { fclose(fout); return 9; }
      fprintf(fout, "%s:%s\n", pszKey, pszVal);
   }
   fclose(fout);
   return 0;
}

int TestDB::update(char *pszInKey, char *pszInVal) {
   int nRec = clKeys.numberOfEntries();
   for (int i=0; i<nRec; i++) {
      char *pszKey = clKeys.getEntry(i, __LINE__);
      char *pszVal = clVals.getEntry(i, __LINE__);
      if (!pszKey || !pszVal) return 9;
      if (!strcmp(pszKey, pszInKey)) {
         clVals.setEntry(i, pszInVal);
         return 0;
      }
   }
   // not yet contained:
   clKeys.addEntry(pszInKey);
   clVals.addEntry(pszInVal);
   return 0;
}

char *TestDB::getValue(char *pszInKey) {
   int nRec = clKeys.numberOfEntries();
   for (int i=0; i<nRec; i++) {
      char *pszKey = clKeys.getEntry(i, __LINE__);
      char *pszVal = clVals.getEntry(i, __LINE__);
      if (!pszKey || !pszVal) return 0;
      if (!strcmp(pszKey, pszInKey))
         return pszVal;
   }
   return 0;
}

// emod file_test
#endif // (sfk_prog || sfk_file_test)

// rc 5 : lines were truncated
int diffMemText(char *pleft, char *prite,
   char *padd, char *prem, char *psame, int astat[3]
   )
{__
   KeyMap omapFile,omapChain,omapMix;
   omapFile.setcase(cs.usecase);
   omapChain.setcase(cs.usecase);
   omapMix.setcase(cs.usecase);

   int irc=0,isame=0,iadd=0,irem=0;

   // read ref data, reducing dub lines
   char *psz=pleft;
   while (*psz!=0)
   {
      char *peol=psz;
      while (*peol!=0 && *peol!='\n') peol++;
      int ilen=peol-psz;
      if (ilen>MAX_LINE_LEN) {
         ilen = MAX_LINE_LEN;
         irc = 5;
      }
      memcpy(szLineBuf,psz,ilen);
      szLineBuf[ilen]='\0';
      removeCRLF(szLineBuf);
      omapFile.put(szLineBuf, 0);
      omapMix.put(szLineBuf, 0);
      psz=peol;
      if (*psz) psz++;
   }

   // read chain text, reducing dub lines
   psz=prite;
   while (*psz!=0)
   {
      char *peol=psz;
      while (*peol!=0 && *peol!='\n') peol++;
      int ilen=peol-psz;
      if (ilen>MAX_LINE_LEN) {
         ilen = MAX_LINE_LEN;
         irc = 5;
      }
      memcpy(szLineBuf,psz,ilen);
      szLineBuf[ilen]='\0';
      removeCRLF(szLineBuf);
      omapChain.put(szLineBuf, 0);
      omapMix.put(szLineBuf, 0);
      psz=peol;
      if (*psz) psz++;
   }

   // list differences
   for (int i=0; i<omapMix.size(); i++)
   {
      char *pszMixLine = 0;
      omapMix.iget(i, &pszMixLine);
      if (!pszMixLine) continue; // safety
 
      bool bChainSet = omapChain.isset(pszMixLine);
      bool bFileSet  = omapFile.isset(pszMixLine);

      char *ppre = 0;
      char  ccol = ' ';

      if (bChainSet && bFileSet) {
         if (psame)
            ppre = psame;
         ccol = 'b';
         isame++;
      }
      else
      if (bChainSet) {
         iadd++;
         ppre = padd;
         if (!irc) irc=1;
         if (psame)
            ccol = 'g';
      } else {
         irem++;
         ppre = prem;
         if (!irc) irc=1;
         ccol = 'R';
      }

      if (ppre) {
         // chain.print("%s %s\n", ppre, pszMixLine);
         snprintf(szLineBuf, MAX_LINE_LEN, "%s %s", ppre, pszMixLine);
         memset(szAttrBuf, ccol, strlen(szLineBuf));
         if (chain.colany())
            chain.addLine(szLineBuf, szAttrBuf);
         else
            printColorText(szLineBuf, szAttrBuf);
      }
   }

   astat[0] = isame;
   astat[1] = iadd;
   astat[2] = irem;

   return irc;
}

void dospell(char *pszWord, bool bNato, bool bPrefix)
{
   static const char *apszMixed[26] =
   {
      "Alpha", "Bravo",  "Charlie", "Delta",  "Echo",  "Foxtrot",  "Golf", "Hotel",
      "India", "Johnny", "King",    "London", "Mike",  "November", "Oscar", "Peter",
      "Queen", "Roger",  "Sierra",  "Tango",  "Union", "Victor",   "William",
      "X-ray", "Yankee", "Zebra"
   };

   static const char *apszNato[26] =
   {
      "Alpha", "Bravo", "Charlie", "Delta", "Echo", "Foxtrot", "Golf", "Hotel",
      "India", "Juliet", "Kilo", "Lima", "Mike", "November", "Oscar", "Papa",
      "Quebec", "Romeo", "Sierra", "Tango", "Uniform", "Victor", "Whisky",
      "X-ray", "Yankee", "Zulu"
   };

   const char **apsz = bNato ? apszNato : apszMixed;

   char szBuf[20];

   if (pszWord)
   {
      if (bPrefix) {
         if (chain.coldata) {
            chain.addToCurLine(pszWord, str(""));
            chain.addToCurLine(str(" : "), str(""));
         } else {
            printf("%s : ", pszWord);
         }
      }
      while (*pszWord)
      {
         char c = sfktolower(*pszWord++);
 
         if (c >= 'a' && c <= 'z') {
            if (chain.coldata)
               chain.addToCurLine((char*)apsz[c - 'a'], str(""));
            else
               printf("%s ", apsz[c - 'a']);
         } else {
            szBuf[0] = c;
            szBuf[1] = '\0';
            if (chain.coldata)
               chain.addToCurLine(szBuf, str(""));
            else
               printf("%s ", szBuf);
         }
         if (chain.coldata)
            chain.addToCurLine(str(" "), str(""));
      }
   }
   else
   for (int i=0; i<26; i++)
   {
      printf("%-10.10s ", apsz[i]);
      if ((i & 7) == 7)
         printf("\n");
   }
}

#define regetcol acol[((ilevel/2)+bval)&1]

int reformatjson(char *pinbuf, char *poutbuf, char *poutatt, int ioutmax)
{
   int ilevel=0;
   int istate=0;
   int bkeepquotes=1;

   cchar *acol = "hx";
   int icol = strlen(acol);
   int bval = 0;

   char *pout = poutbuf;
   char *pmax = poutbuf+(ioutmax-10);
   char *patt = poutatt;
   char cattr = ' ';

   char *pcur=pinbuf;
   while (*pcur != 0 && pout+10 < pmax)
   {
      cattr = regetcol;

      // handle quotes
      if (istate==0 && *pcur=='\"') {
         // ilevel += 2; cattr = regetcol;
         if (bkeepquotes)
            { *pout++ = *pcur++; *patt++ = cattr; }
         else
            pcur++;
         istate=1;
         continue;
      }
      if (istate==1) {
         if (!strncmp(pcur, "\\\"", 2)) {
            if (bkeepquotes)
               { *pout++ = *pcur++; *patt++ = cattr; }
            else
               pcur++;
            *pout++ = *pcur++; *patt++ = cattr;
            continue;
         }
         if (*pcur!='\"') {
            *pout++ = *pcur++; *patt++ = cattr;
            continue;
         }
         if (bkeepquotes)
            { *pout++ = *pcur++; *patt++ = cattr; }
         else
            pcur++;
         // ilevel -= 2; cattr = regetcol;
         istate=0;
         continue;
      }

      // optimize empty arrays
      if (!strncmp(pcur, "[[]]", 4)) {
         *pout++ = *pcur++; *patt++ = cattr;
         *pout++ = *pcur++; *patt++ = cattr;
         *pout++ = *pcur++; *patt++ = cattr;
         *pout++ = *pcur++; *patt++ = cattr;
         continue;
      }
      if (!strncmp(pcur, "[]", 2)) {
         *pout++ = *pcur++; *patt++ = cattr;
         *pout++ = *pcur++; *patt++ = cattr;
         continue;
      }

      char c = *pcur++;

      switch (c)
      {
         case '[':
         case '{':
            bval=0;
            if (pout > poutbuf
                && (pout[-1] == ' ' || pout[-1] == '\n')) {
            }
            else if (pout == poutbuf) {
            }
            else {
               *pout++ = '\n'; *patt++ = cattr;
               for (int i=0; i<ilevel; i++)
                  { *pout++ = ' '; *patt++ = cattr; }
            }
            *pout++ = c; *patt++ = cattr;
            ilevel += 2; cattr = regetcol;
            *pout++ = '\n'; *patt++ = cattr;
            for (int i=0; i<ilevel; i++)
               { *pout++ = ' '; *patt++ = cattr; }
            break;

         case ']':
         case '}':
            bval=0;
            if (pout > poutbuf && pout[-1] == ' ') {
               ilevel -= 2; cattr = regetcol;
               pout -= 2; patt -= 2;
            } else {
               *pout++ = '\n'; *patt++ = cattr;
               ilevel -= 2; cattr = regetcol;
               for (int i=0; i<ilevel; i++)
                  { *pout++ = ' '; *patt++ = cattr; }
            }
            *pout++ = c; *patt++ = cattr;
            if (*pcur == ',')
               { *pout++ = *pcur++; *patt++ = cattr; }
            *pout++ = '\n'; *patt++ = cattr;
            for (int i=0; i<ilevel; i++)
               { *pout++ = ' '; *patt++ = cattr; }
            break;

         case ',':
            *pout++ = c; *patt++ = cattr;
            *pout++ = '\n'; *patt++ = cattr;
            for (int i=0; i<ilevel; i++)
               { *pout++ = ' '; *patt++ = cattr; }
            bval=0;
            break;

         case ':':
            *pout++ = c; *patt++ = cattr;
            *pout++ = ' '; *patt++ = cattr;
            bval=1;
            break;

         default:
            *pout++ = c; *patt++ = cattr;
            break;
      }
   }
   *pout = '\0'; *patt = '\0';

   if (pout+10 >= pmax)
      return 10;

   return 0;
}

// dmod help
#if (sfk_prog || sfk_help)
uchar *getWebDemoData(int &isize) { isize = sizeof(webdemo_abRawBlock); return webdemo_abRawBlock; }

void printSamp(int nlang, char *pszOutFile, char *pszClassName, int bWriteFile, int iSystem)
{
      /*
         sfk fromclip +filt -srep "_\\_\\\\_" -srep "_\q_\\\q_" -sform "          \q$col1\\n\q"
         sfk filt src -rep "_%_%%_" -srep "_\\_\\\\_" -srep "_\q_\\\q_" -sform "         \q$col1\\n\q" +toclip
      */

      switch (nlang) {
      case 1:
      chain.print(
          "import java.io.*;\n"
          "\n"
          "public class %s\n"
          "{\n"
          "    static void log(String s) { System.out.println(\"main: \"+s); }\n"
          "\n"
          "    public static void main(String args[]) throws Throwable\n"
          "    {\n"
          "        if (args.length < 2)\n"
          "            { log(\"supply in- and output filename.\"); return; }\n"
          "\n"
          "        // copy or convert text file\n"
          "        BufferedReader rin = new BufferedReader(\n"
          "            new InputStreamReader(\n"
          "                new FileInputStream(args[0]), \"ISO-8859-1\"\n"
          "                // or US-ASCII,UTF-8,UTF-16BE,UTF-16LE,UTF-16\n"
          "                ));\n"
          "\n"
          "        PrintWriter pout = new PrintWriter(\n"
          "            new OutputStreamWriter(\n"
          "                new FileOutputStream(args[1]), \"ISO-8859-1\"\n"
          "                ));\n"
          "\n"
          "        while (true) {\n"
          "            String sline = rin.readLine();\n"
          "            if (sline == null) break; // EOD\n"
          "            log(\"copying line: \"+sline);\n"
          "            pout.println(sline);\n"
          "        }\n"
          "\n"
          "        pout.close();\n"
          "        rin.close();\n"
          "    }\n"
          "};\n",
          pszClassName
        );
         break;

      case 2:
      chain.print(
         "\n"
         "// simple c source template 1.0 for instant coding, free for any use.\n"
         "// beware that the simplified semantics may not fit into larger projects.\n"
         "\n"
         "#ifdef _WIN32\n"
         " #include <windows.h>\n"
         "#endif\n"
         "\n"
         "#include <stdio.h>\n"
         "#include <string.h>\n"
         "#include <stdarg.h>\n"
         "#include <stdlib.h>\n"
         "#include <ctype.h>\n"
         "#include <stdint.h>\n"
         "#include <sys/stat.h>\n"
         "\n"
         "#ifndef _WIN32\n"
         " #include <unistd.h>\n"
         " #include <sys/time.h>\n"
         "#endif\n"
         "\n"
         "// sfk quick types\n"
         "typedef unsigned char  uchar;\n"
         "typedef unsigned short ushort;\n"
         "typedef unsigned int   uint;\n"
         "typedef const char     cchar;\n"
         "#ifndef __cplusplus\n"
         "typedef unsigned char  bool;\n"
         "#endif\n"
         "#ifdef _WIN32\n"
         " typedef __int64 num;\n"
         " typedef unsigned __int64 unum;\n"
         "#else\n"
         " typedef long long num;\n"
         " typedef unsigned long long unum;\n"
         "#endif\n"
         "\n"
         "// print error message with variable parameters.\n"
         "int perr(const char *pszFormat, ...) {\n"
         "   va_list argList;\n"
         "   va_start(argList, pszFormat);\n"
         "   char szBuf[1024];\n"
         "   vsprintf(szBuf, pszFormat, argList);\n"
         "   fprintf(stderr, \"error: %%s\", szBuf);\n"
         "   return 0;\n"
         "}\n"
         "\n"
         "int merr(const char *pszWhere) {\n"
         "   fprintf(stderr, \"out of memory at %%s\", pszWhere);\n"
         "   return 0;\n"
         "}\n"
         "\n"
         "char *myvtext(const char *pszFormat, ...) {\n"
         "   static char szBuf[4096];\n"
         "   va_list argList;\n"
         "   va_start(argList, pszFormat);\n"
         "   vsnprintf(szBuf, sizeof(szBuf)-10, pszFormat, argList);\n"
         "   szBuf[sizeof(szBuf)-10] = '\\0';\n"
         "   return szBuf;\n"
         "}\n"
         "\n"
         "char *numtoa(num n) {\n"
         "   static char szBuf[100];\n"
         "   #ifdef _WIN32\n"
         "   sprintf(szBuf, \"%%I64d\", n);\n"
         "   #else\n"
         "   sprintf(szBuf, \"%%lld\", n);\n"
         "   #endif\n"
         "   return szBuf;\n"
         "}\n"
         "\n"
         "num atonum(char *psz) {\n"
         "   #ifdef _WIN32\n"
         "   return _atoi64(psz);\n"
         "   #else\n"
         "   return atoll(psz);\n"
         "   #endif\n"
         "}\n"
         "\n"
         "num currentTime() {\n"
         "   #ifdef _WIN32\n"
         "   return (num)GetTickCount();\n"
         "   #else\n"
         "   struct timeval tv;\n"
         "   gettimeofday(&tv, NULL);\n"
         "   return ((num)tv.tv_sec) * 1000 + ((num)tv.tv_usec) / 1000;\n"
         "   #endif\n"
         "}\n"
         "\n"
         "void doSleep(int nmsec) {\n"
         "   #ifdef _WIN32\n"
         "   Sleep(nmsec);\n"
         "   #else\n"
         "   // sleep(1);\n"
         "   // const timespec ts = { nmsec / 1000, nmsec %% 1000 * 1000000 };\n"
         "   // nanosleep(&ts, NULL);\n"
         "   usleep(nmsec*1000);\n"
         "   #endif\n"
         "}\n"
         "\n"
         "int mystricmp(char *psz1, cchar *psz2) {\n"
         "   while (*psz1 && *psz2 && tolower(*psz1) == tolower(*psz2))\n"
         "      { psz1++; psz2++; }\n"
         "   return tolower(*psz1) - tolower(*psz2);\n"
         "}\n"
         "\n"
         "int mystrnicmp(char *psz1, cchar *psz2, int nLen) {\n"
         "   int i=0;\n"
         "   for (i=0; i<nLen && psz1[i] && psz2[i]; i++)\n"
         "      if (tolower(psz1[i]) != tolower(psz2[i]))\n"
         "         return tolower(psz1[i]) - tolower(psz2[i]);\n"
         "   if (i >= nLen) return 0;\n"
         "   return tolower(psz1[i]) - tolower(psz2[i]);\n"
         "}\n"
         "\n"
         "bool strBegins(char *pszStr, cchar *pszPat)\n"
         "   { return strncmp(pszStr, pszPat, strlen(pszPat)) ? 0 : 1; }\n"
         "\n"
         "bool striBegins(char *pszStr, cchar *pszPat)\n"
         "   { return mystrnicmp(pszStr, pszPat, strlen(pszPat)) ? 0 : 1; }\n"
         "\n"
         "bool strEnds(char *pszStr, cchar *pszPat) {\n"
         "   int nhay = strlen(pszStr);\n"
         "   int npat = strlen(pszPat);\n"
         "   if (nhay < npat) return 0;\n"
         "   return strcmp(pszStr+nhay-npat, pszPat) ? 0 : 1;\n"
         "}\n"
         "\n"
         "bool striEnds(char *pszStr, cchar *pszPat) {\n"
         "   int nhay = strlen(pszStr);\n"
         "   int npat = strlen(pszPat);\n"
         "   if (nhay < npat) return 0;\n"
         "   return mystricmp(pszStr+nhay-npat, pszPat) ? 0 : 1;\n"
         "}\n"
         "\n"
         "char *mystrstri(char *phay, cchar *ppat) {\n"
         "   int i=0,j=0,ncmp=0,ndiff=0;\n"
         "   int llen = (int)strlen(phay);\n"
         "   int slen = (int)strlen(ppat);\n"
         "   ncmp = (llen-slen)+1;\n"
         "   if (ncmp < 0)\n"
         "      return 0;\n"
         "   for (j=0; j<ncmp; ++j) {\n"
         "      ndiff = 0;\n"
         "      for (i=0; (i<slen) && !ndiff; ++i)\n"
         "         ndiff = tolower(phay[j+i]) - tolower(ppat[i]);\n"
         "      if (!ndiff)\n"
         "         return (char *)phay+j;\n"
         "   }\n"
         "   return 0;\n"
         "}\n"
         "\n"
         "uchar *memFind(uchar *pNeedle, num nNeedleSize, uchar *pHayStack, num nHaySize) {\n"
         "   uchar *pCur = pHayStack;\n"
         "   uchar *pMax = pHayStack + nHaySize - nNeedleSize; // inclusive\n"
         "   uchar c1    = *pNeedle;\n"
         "   while (pCur <= pMax) {\n"
         "      uchar *p1 = pCur;\n"
         "      p1 = (uchar*)memchr(p1, c1, pMax - p1 + 1); // +1: pMax is inclusive\n"
         "      if (!p1 || (p1 > pMax))\n"
         "         return 0;\n"
         "      if ((p1 <= pMax) && !memcmp(p1, pNeedle, nNeedleSize))\n"
         "         return p1;  // hit\n"
         "      pCur = p1+1;\n"
         "   }\n"
         "   return 0;\n"
         "}\n"
         "\n"
         "// may fail with file sizes > 2 gb in 32 bit builds\n"
         "num getFileSize(char *pszName) {\n"
         "   struct stat buf;\n"
         "   if (stat(pszName, &buf))\n"
         "      return -1;\n"
         "   return buf.st_size;\n"
         "}\n"
         "\n"
         "// loads text and binary\n"
         "char *loadFile(char *pszFile, num *pOptOutSize=0)\n"
         "{\n"
         "   num nFileSize=0, nTolerance=10;\n"
         "   char *pOut; FILE *fin;\n"
         "   if ((nFileSize = getFileSize(pszFile)) < 0)\n"
         "      { perr(\"file not found: %%s\", pszFile); return 0; }\n"
         "   if (!(pOut = (char*)malloc(nFileSize+nTolerance+4)))\n"
         "      { perr(\"out of memory: %%s\\n\", pszFile); return 0; }\n"
         "   memset(pOut+nFileSize, 0, nTolerance); // added safety\n"
         "   if (!(fin = fopen(pszFile, \"rb\"))) {\n"
         "      perr(\"cannot read: %%s\\n\", pszFile);\n"
         "      free(pOut);\n"
         "      return 0;\n"
         "   }\n"
         "   int nRead = fread(pOut, 1, nFileSize, fin);\n"
         "   fclose(fin);\n"
         "   if (nRead != nFileSize) {\n"
         "      perr(\"cannot read: %%s (%%d %%d)\\n\", pszFile, nRead, nFileSize);\n"
         "      free(pOut);\n"
         "      return 0;\n"
         "   }\n"
         "   // loadFile guarantees zero termination after buffer:\n"
         "   pOut[nFileSize] = '\\0';\n"
         "   if (pOptOutSize)\n"
         "      *pOptOutSize = nFileSize;\n"
         "   return pOut;\n"
         "}\n"
         "\n"
         "int saveFile(char *pszName, uchar *pData, int iSize, const char *pszMode)\n"
         "{\n"
         "   FILE *fout;\n"
         "   if (!(fout = fopen(pszName, pszMode)))\n"
         "      return 9+perr(\"cannot write: %%s\\n\", pszName);\n"
         "   if (fwrite(pData, 1, iSize, fout) != iSize) {\n"
         "      fclose(fout);\n"
         "      return 10+perr(\"cannot fully write (disk full?): %%s\\n\", pszName);\n"
         "   }\n"
         "   fclose(fout);\n"
         "   return 0;\n"
         "}\n"
         "\n"
         "int existsFile(char *pszName, bool bOrDir) {\n"
         "   struct stat buf;\n"
         "   if (stat(pszName, &buf))\n"
         "      return 0;\n"
         "   if (!bOrDir && (buf.st_mode & 0040000)) // _S_IFDIR\n"
         "      return 0; // is a dir, not a file\n"
         "   return 1;\n"
         "}\n"
         "\n"
         "char *dataAsHex(void *pAnyData, int iDataSize) {\n"
         "   static char szBuf[300];\n"
         "   uchar *pSrcCur = (uchar *)pAnyData;\n"
         "   uchar *pSrcMax = pSrcCur + iDataSize;\n"
         "   char *pszDstCur = szBuf;\n"
         "   char *pszDstMax = szBuf+sizeof(szBuf)-30;\n"
         "   while (pSrcCur < pSrcMax && pszDstCur < pszDstMax) {\n"
         "      uchar uc = *pSrcCur++;\n"
         "      sprintf(pszDstCur, \"%%02X\", uc);\n"
         "      pszDstCur += 2;\n"
         "   }\n"
         "   *pszDstCur = '\\0';\n"
         "   return szBuf;\n"
         "}\n"
         "\n"
         "char *dataAsTrace(void *pAnyData, int iDataSize) {\n"
         "   static char szBuf[300];\n"
         "   if (iDataSize == -1)\n"
         "       iDataSize = strlen((char*)pAnyData);\n"
         "   uchar *pSrcCur = (uchar *)pAnyData;\n"
         "   uchar *pSrcMax = pSrcCur + iDataSize;\n"
         "   char *pszDstCur = szBuf;\n"
         "   char *pszDstMax = szBuf+sizeof(szBuf)-30;\n"
         "   while (pSrcCur < pSrcMax && pszDstCur < pszDstMax) {\n"
         "      uchar uc = *pSrcCur++;\n"
         "      if (isprint((char)uc)) {\n"
         "         *pszDstCur++ = (char)uc;\n"
         "         continue;\n"
         "      }\n"
         "      sprintf(pszDstCur, \"{%%02X}\", uc);\n"
         "      pszDstCur += 4;\n"
         "   }\n"
         "   *pszDstCur = '\\0';\n"
         "   return szBuf;\n"
         "}\n"
         "\n"
         "// copy text lines from one file into another.\n"
         "int main(int argc, char *argv[])\n"
         "{\n"
         "   char *pszInFile=0,*pszOutFile=0;\n"
         "\n"
         "   int iarg = 1;\n"
         "   for (;iarg<argc;iarg++) {\n"
         "      char *parg = argv[iarg];\n"
         "      if (!strcmp(parg,\"-?\") || !strcmp(parg,\"-h\")\n"
         "          || !strcmp(parg,\"-help\")) {\n"
         "         printf(\"usage: %%s infile outfile\\n\", argv[0]);\n"
         "         return 0;\n"
         "      }\n"
         "      if (!pszInFile)\n"
         "         { pszInFile = parg; continue; }\n"
         "      if (!pszOutFile)\n"
         "         { pszOutFile = parg; continue; }\n"
         "      return 9+perr(\"unexpected: %%s\\n\", parg);\n"
         "   }\n"
         "\n"
         "   if (!pszOutFile)\n"
         "      return 9+perr(\"specify input and output filename.\\n\");\n"
         "\n"
         "   FILE *fin  = fopen(pszInFile , \"rb\"); if (!fin ) return 9+perr(\"cannot read %%s\\n\" , pszInFile);\n"
         "   FILE *fout = fopen(pszOutFile, \"wb\"); if (!fout) return 9+perr(\"cannot write %%s\\n\", pszOutFile);\n"
         "\n"
         "   char szBuf[1024];\n"
         "   memset(szBuf, 0, sizeof(szBuf));\n"
         "   while (fgets(szBuf, sizeof(szBuf)-10, fin))\n"
         "   {\n"
         "      char *psz = strchr(szBuf, '\\r'); if (psz) *psz = '\\0'; // strip cr\n"
         "            psz = strchr(szBuf, '\\n'); if (psz) *psz = '\\0'; // strip lf\n"
         "      printf(\"line: \\\"%%s\\\"\\n\", szBuf);\n"
         "      strcat(szBuf, \"\\n\");\n"
         "      int nlen = strlen(szBuf);\n"
         "      if (fwrite(szBuf, 1, nlen, fout) != nlen)\n"
         "         return 9+perr(\"failed to fully write %%s\\n\", pszOutFile);\n"
         "   }\n"
         "\n"
         "   fclose(fout);\n"
         "   fclose(fin);\n"
         "\n"
         "   return 0;\n"
         "}\n"
         "\n"
        );
         break;

      case 3:
      chain.print(
         "@rem windows command shell batch example\n"
         "@echo off\n"
         "IF \"%%1\"==\"\" GOTO xerr01\n"
         "echo \"parameter is %%1\"\n"
         "GOTO xdone\n"
         "\n"
         ":xerr01\n"
         "echo \"please supply a parameter.\"\n"
         "echo \"example: mybat parm123\"\n"
         "GOTO xdone\n"
         "\n"
         ":xdone\n"
         );
         break;

      case 4:
      chain.print(
         "#!/bin/bash\n"
         "\n"
         "function pmsg {\n"
         "   # uses a local variable mystr\n"
         "   local mystr=\"info: $1\"\n"
         "   echo $mystr\n"
         "}\n"
         "\n"
         "myparm1=\"$1 and $2\"       # no blanks around \"=\"\n"
         "\n"
         "if [ \"$2\" = \"\" ]; then    # requires all blanks\n"
         "   pmsg \"please supply two parameters.\"\n"
         "else\n"
         "   pmsg \"you supplied \\\"$myparm1\\\".\"\n"
         "\n"
         "   #  < -lt   > -gt   <= -le   >= -ge   == -eq   != -ne\n"
         "   i=1\n"
         "   while [ $i -le 5 ]; do # not \"$i < 5\"\n"
         "      echo counting: $i   # quotes are optional\n"
         "      let i+=1            # not \"i += 1\" or \"$i+=1\"\n"
         "   done\n"
         "fi\n"
         );
         break;

      case 5:
      chain.print(
         "sfk select testfiles .txt .hpp .cpp\n"
         "\n"
         "   // find words supplied by user.\n"
         "   // note that %%1 is the same as $1.\n"
         "   +find\n"
         "      %%1 %%2 %%3 $4 $5 $6\n"
         "\n"
         "   // process files containing hits\n"
         "   +run -quiet \"sfk echo \\\"Found hit in: [green]$file[def]\\\"\" -yes\n"
         "\n"
         "   // run the script by:\n"
         "   //    sfk script \"%s\" pattern1 [pattern2 ...]\n",
         pszOutFile ? pszOutFile : "thisfile"
         );
         break;

      case 6:
      chain.print(
// --- sfk batch name.bat default script begin ---
"@echo off\n"
"sfk script \"%%~f0\" -from begin %%*\n"
"rem %%~f0 is the absolute batch file name.\n"
"GOTO xend\n"
"\n"
"sfk label begin -var\n"
"\n"
"   // default batch, with some variable support.\n"
"   // for a full file backup example use:\n"
"   //    sfk batch -full myfile.bat\n"
"\n"
"   +if \"%%1 = \" begin\n"
"      +tell \"[green]usage:[def]\"\n"
"      +tell \"   #(sys.ownscript.name) copy [-yes]\"\n"
"      +stop -all\n"
"      +endif\n"
"\n"
"   +setvar cmd=\"%%1\"\n"
"   +setvar yes=\"%%2\"\n"
"\n"
"   +if \"#(cmd) = copy\" begin\n"
"      +call docopy\n"
"      +stop\n"
"      +endif\n"
"\n"
"   +tell \"unknown command: #(cmd)\"\n"
"\n"
"   +end\n"
"\n"
"sfk label docopy\n"
"\n"
"   +copy -checkdirs\n"
"   \n"
"      mydir mydir2\n"
"\n"
"      -dir core doc db\n"
"\n"
"         -subdir !\\tmp !\\save\n"
"         -file   !.tmp\n"
"\n"
"         #(yes)\n"
"\n"
"   +end\n"
"\n"
":xend\n"
// --- sfk batch default script end ---
         );
         break;

      case 7:
      chain.print(
// --- sfk batch name.sh default script begin ---
"#!/bin/bash\n"
"sfk script \"$0\" -from begin $@\n"
"exit\n"
"function skip_block\n"
"{\n"
"sfk label begin -var -upat2\n"
"\n"
"   // default batch, with unified windows/linux syntax (-upat2).\n"
"   // for a full file backup example use:\n"
"   //    sfk batch -full myfile.sh\n"
"\n"
"   +if \"%%1 = \" begin\n"
"      +tell \"[green]usage:[def]\"\n"
"      +tell \"   #(sys.ownscript.name) copy [-yes]\"\n"
"      +stop -all\n"
"      +endif\n"
"\n"
"   +setvar cmd=\"%%1\"\n"
"   +setvar yes=\"%%2\"\n"
"\n"
"   +if \"#(cmd) = copy\" begin\n"
"      +call docopy\n"
"      +stop\n"
"      +endif\n"
"\n"
"   +tell \"unknown command: #(cmd)\"\n"
"\n"
"   +end\n"
"\n"
"sfk label docopy\n"
"\n"
"   +copy -checkdirs\n"
" \n"
"      mydir mydir2\n"
"\n"
"      -dir core doc db\n"
"\n"
"         -subdir :\\tmp :\\save\n"
"         -file   :.tmp\n"
"\n"
"         #(yes)\n"
"\n"
"   +end\n"
"}\n"
// --- sfk batch name.sh default script end ---
         );
         break;

      case 106:
      chain.print(
// --- sfk batch name.bat -full script begin ---
"@echo off\n"
"sfk script -anyparms \"%%~f0\" -from begin %%*\n"
"rem %%~f0 is the absolute batch file name.\n"
"rem %%* passes through every parameter given.\n"
"rem -anyparms allows words starting with '+'.\n"
"GOTO xend\n"
"\n"
"sfk label begin -var -checkdirs\n"
"\n"
"   // Selective file copy example. Just run this batch for infos.\n"
"   // Read detailed explanations of every step in the SFK e-Book,\n"
"   // under \"Backup and transfer of folders\".\n"
"\n"
"   +setvar cmd=\"%%1\"\n"
"   +setvar yes=\"%%2\"\n"
"   +setvar target=R:\\backup\n"
"\n"
"   // helper variables for short typing.\n"
"   // empty parms must be replaced by \"-noop\".\n"
"   +setvar s=\"#(sys.ownscript.name)\"\n"
"   +setvar m=\"[Magenta]\"\n"
"   +setvar d=\"[def]\"\n"
"\n"
"   // if \"view\" or \"+view\" is given with list, size, or big\n"
"   // then insert a variable command to view all output\n"
"   // comfortably and searcheable with Depeche View.\n"
"   +setvar todview=\"\"\n"
"   +if \"#(contains(yes,'view')) = 1\" setvar todview=\"+view\"\n"
"\n"
"   +if \"%%1 = \" begin\n"
"      +tell \"[green]DataWay:[def] PC Backup\"\n"
"      +tell \"   #(m)FROM#(d) C: and D: #(m)TO#(d) #(target)\"\n"
"      +tell \"   #(m)WITH#(d) org app work mail\"\n"
"      +tell \"   #(m)WITHOUT#(d) cache save, and tmp files\"\n"
"      +tell \" \"\n"
"      +tell \"[green]Usage:[def]\"\n"
"      +tell \"   #(s) command\"\n"
"      +tell \" \"\n"
"      +tell \"[green]Commands:[def]\"\n"
"      +tell \"   #(m)list#(d)        - list all selected source files.\"\n"
"      +tell \"                 press escape or ctrl+c to stop.\"\n"
"      +tell \"   #(m)size#(d)        - tell size of source folders,\"\n"
"      +tell \"                 list 50  mb blocks and larger\"\n"
"      +tell \"   #(m) size200#(d)    - list 200 mb blocks and larger\"\n"
"      +tell \"   #(m)big#(d)         - show biggest selected source files\"\n"
"      +tell \" \"\n"
"      +tell \"   #(m)copy#(d)        - simulate copy to #(target)\"\n"
"      +tell \"   #(m) copy -yes#(d)  - really   copy to #(target)\"\n"
"      +tell \" \"\n"
"      +tell \"   #(m)copy7d#(d)      - copy only files created or changed\"\n"
"      +tell \"                 in the last 7 days\"\n"
"      +tell \" \"\n"
"      +tell \"   #(m)sync#(d)        - simulate copy with DELETE of files\"\n"
"      +tell \"                 in #(target) which do not exist\"\n"
"      +tell \"                 in the source folders\"\n"
"      +tell \"   #(m) sync -yes#(d)  - really   sync to #(target)\"\n"
"      +stop\n"
"      +endif\n"
"\n"
"   // \"-using\" allows to use the same file set in multiple commands.\n"
"   // \"-root\" is a prefix for every -dir entry within -using.\n"
"   +if \"#(cmd) = list\" begin\n"
"      +dir -time -size\n"
"         -root C:\\ -using cdirs\n"
"         -root D:\\ -using ddirs\n"
"         #(todview)\n"
"      +stop\n"
"      +endif\n"
"\n"
"   +if \"#(begins(cmd,'size')) = 1\" begin\n"
"      +setvar minsize=#(substr(cmd,4))\n"
"      +if \"#(minsize) = \" setvar minsize=10\n"
"      +treesize -minsize=#(minsize)m\n"
"         -root C:\\ -using cdirs\n"
"         -root D:\\ -using ddirs\n"
"         #(todview)\n"
"      +stop\n"
"      +endif\n"
"\n"
"   +if \"#(cmd) = big\" begin\n"
"      +big -root C:\\ -using cdirs\n"
"           -root D:\\ -using ddirs\n"
"           #(todview)\n"
"      +stop\n"
"      +endif\n"
"\n"
"   +if \"#(cmd) = copy\" begin\n"
"      +copy #(yes) C:\\ #(target)\\c -using cdirs\n"
"      +copy #(yes) D:\\ #(target)\\d -using ddirs\n"
"      +stop\n"
"      +endif\n"
"\n"
"   +if \"#(begins(cmd,'copy')) = 1\" begin\n"
"      +setvar since=#(substr(cmd,4))\n"
"      +copy -since #(since) #(yes) C:\\ #(target)\\c -using cdirs\n"
"      +copy -since #(since) #(yes) D:\\ #(target)\\d -using ddirs\n"
"      +stop\n"
"      +endif\n"
"\n"
"   +if \"#(cmd) = sync\" begin\n"
"      +sync #(yes) -wipe C:\\ #(target)\\c -using cdirs\n"
"      +sync #(yes) -wipe D:\\ #(target)\\d -using ddirs\n"
"      +stop\n"
"      +endif\n"
"\n"
"   +tell \"unknown command: #(cmd)\"\n"
"\n"
"   +end\n"
"\n"
"sfk label cdirs\n"
"\n"
"   // copy C:\\org C:\\app etc.\n"
"   // variables #() are not supported.\n"
"   // every parameter with whitespaces must be quoted by \"\".\n"
"\n"
"   -dir     org\n"
"            app\n"
"            \"Users\\All Users\\VirtualBox\"\n"
"\n"
"      -subdir  !\\cache\\\n"
"               !\\save\\\n"
"               \"!\\unused stuff\\\"\n"
"\n"
"      -file    !.tmp\n"
"\n"
"   +end\n"
"\n"
"sfk label ddirs\n"
"\n"
"   // this will copy: D:\\work D:\\mail\n"
"\n"
"   -dir     work\n"
"\n"
"      -subdir  !\\.svn\n"
"               !\\old\\\n"
"               !\\save\\\n"
"    \n"
"      -file    !\\tmp*.*\n"
"               !.tmp\n"
"               !.bak\n"
"\n"
"   -dir     mail\n"
"\n"
"      -subdir  !\\cache\n"
"\n"
"   +end\n"
"\n"
":xend\n"
// --- sfk batch -full script end ---
         );
         break;

      case 107:
      chain.print(
// --- sfk batch name.sh -full script begin ---
"#!/bin/bash\n"
"sfk script \"$0\" -from begin $@\n"
"exit\n"
"function skip_block\n"
"{\n"
"sfk label begin -var -upat2 -checkdirs\n"
"\n"
"   // Selective file copy example. Just run this batch for infos.\n"
"   // Read detailed explanations of every step in the SFK e-Book,\n"
"   // under \"Backup and transfer of folders\".\n"
"\n"
"   +setvar cmd=\"%%1\"\n"
"   +setvar yes=\"%%2\"\n"
"   +setvar source=project\n"
"   +setvar target=project2\n"
"\n"
"   // helper variables for short typing.\n"
"   // empty parms must be replaced by \"-noop\".\n"
"   +setvar s=\"#(sys.ownscript.name)\"\n"
"   +setvar m=\"[Magenta]\"\n"
"   +setvar d=\"[def]\"\n"
"\n"
"   +if \"%%1 = \" begin\n"
"      +tell \"[green]DataWay:[def] copy #(source) folders\"\n"
"      +tell \"   #(m)FROM#(d) #(source) #(m)TO#(d) #(target)\"\n"
"      +tell \"   #(m)WITH#(d) core desktop mobile doc\"\n"
"      +tell \"   #(m)WITHOUT#(d) .svn old save, and some large files\"\n"
"      +tell \" \"\n"
"      +tell \"[green]Usage:[def]\"\n"
"      +tell \"   #(s) command\"\n"
"      +tell \" \"\n"
"      +tell \"[green]Commands:[def]\"\n"
"      +tell \"   #(m)list#(d)        - list all selected source files.\"\n"
"      +tell \"                 press escape or ctrl+c to stop.\"\n"
"      +tell \"   #(m)size#(d)        - tell size of source folders,\"\n"
"      +tell \"                 list 50  mb blocks and larger\"\n"
"      +tell \"   #(m) size200#(d)    - list 200 mb blocks and larger\"\n"
"      +tell \"   #(m)big#(d)         - show biggest selected source files\"\n"
"      +tell \" \"\n"
"      +tell \"   #(m)copy#(d)        - simulate copy to #(target)\"\n"
"      +tell \"   #(m) copy -yes#(d)  - really   copy to #(target)\"\n"
"      +tell \" \"\n"
"      +tell \"   #(m)copy7d#(d)      - copy only files created or changed\"\n"
"      +tell \"                 in the last 7 days\"\n"
"      +tell \" \"\n"
"      +tell \"   #(m)sync#(d)        - simulate copy with DELETE of files\"\n"
"      +tell \"                 in #(target) which do not exist\"\n"
"      +tell \"                 in the source folders\"\n"
"      +tell \"   #(m) sync -yes#(d)  - really   sync to #(target)\"\n"
"      +stop\n"
"      +endif\n"
"\n"
"   // \"-using\" allows to use the same file set in multiple commands.\n"
"   // \"-root\" is a prefix for every -dir entry within -using.\n"
"   +if \"#(cmd) = list\" begin\n"
"      +dir -time -size -root #(source) -using projdirs\n"
"      +stop\n"
"      +endif\n"
"\n"
"   +if \"#(begins(cmd,'size')) = 1\" begin\n"
"      +setvar minsize=#(substr(cmd,4))\n"
"      +if \"#(minsize) = \" setvar minsize=10\n"
"      +treesize -minsize=#(minsize)m -root #(source) -using projdirs\n"
"      +stop\n"
"      +endif\n"
"\n"
"   +if \"#(cmd) = big\" begin\n"
"      +big -root #(source) -using projdirs\n"
"      +stop\n"
"      +endif\n"
"\n"
"   +if \"#(cmd) = copy\" begin\n"
"      +copy #(yes) #(source) #(target) -using projdirs\n"
"      +stop\n"
"      +endif\n"
"\n"
"   +if \"#(begins(cmd,'copy')) = 1\" begin\n"
"      +setvar since=#(substr(cmd,4))\n"
"      +copy -since #(since) #(yes) #(source) #(target) -using projdirs\n"
"      +stop\n"
"      +endif\n"
"\n"
"   +if \"#(cmd) = sync\" begin\n"
"      +sync #(yes) -wipe #(source) #(target) -using projdirs\n"
"      +stop\n"
"      +endif\n"
"\n"
"   +tell \"unknown command: #(cmd)\"\n"
"\n"
"   +end\n"
"\n"
"// within label projdirs variables #() are not supported.\n"
"// every parameter with whitespaces must be quoted by \"\".\n"
"// -upat2 above allows unified syntax under linux/windows.\n"
"\n"
"// this will copy: project/core project/desktop ...\n"
"// to copy whole project use: -dir .\n"
"\n"
"sfk label projdirs\n"
"\n"
"   -dir     core\n"
"            desktop\n"
"            mobile\n"
"            doc\n"
"\n"
"      -subdir  :/.svn\n"
"               :/old/\n"
"               :/save/\n"
"               \":/unused stuff/\"\n"
"               :/tmpbin\n"
"\n"
"      -file    :.tmp \n"
"               :.tar :.tar.bz2\n"
"               :tmp%%.txt :.new\n"
"               :/a.out/\n"
"\n"
"   +end\n"
"}\n"
// --- sfk batch name.sh -full script end ---
         );
         break;

      case 8:
      chain.print(
         "\n"
         "// Example source code for image file conversion\n"
         "// and simple image processing with Java.\n"
         "// Requires SUN's Java Advanced Imaging I/O Tools.\n"
         "// Usage: java imtool input.png outbase\n"
         "// Creates: outbase-jpg.jpg and further.\n"
         "\n"
         "import java.io.*;\n"
         "import java.awt.image.*;\n"
         "import javax.imageio.*;\n"
         "import com.sun.image.codec.jpeg.*;\n"
         "\n"
         "public class %s\n"
         "{\n"
         "    static void log(String s) { System.out.println(s); }\n"
         "\n"
         "    public static void main(String args[]) throws Throwable\n"
         "    {\n"
         "        if (args.length < 2)\n"
         "            throw new Exception(\"specify input filename and output basename.\");\n"
         "\n"
         "        String src  = args[0];\n"
         "        String dst1 = args[1]+\"-jpg.jpg\";\n"
         "        String dst2 = args[1]+\"-png.png\";\n"
         "        String dst3 = args[1]+\"-green.jpg\";\n"
         "        String dst4 = args[1]+\"-green.png\";\n"
         "\n"
         "        // load a PNG image, with or without transparency (alpha channel).\n"
         "        BufferedImage buf = ImageIO.read(new File(src));\n"
         "        int nwidth  = buf.getWidth();\n"
         "        int nheight = buf.getHeight();\n"
         "        log(\"width = \"+nwidth+\" pixels, height = \"+nheight);\n"
         "\n"
         "        // trivial file conversion: save as a JPEG or PNG image.\n"
         "        // JPEG will work only if input contained no transparency.\n"
         "        ImageIO.write(buf, \"jpg\", new File(dst1)); log(dst1);\n"
         "        ImageIO.write(buf, \"png\", new File(dst2)); log(dst2);\n"
         "\n"
         "        // image processing: turn all transparent pixels into green.\n"
         "\n"
         "        // 1. get access to main pixels, and transparency.\n"
         "        WritableRaster rmain = buf.getRaster();\n"
         "        WritableRaster rtran = buf.getAlphaRaster();\n"
         "\n"
         "        // 2. create a memory image to write to, WITHOUT transparency.\n"
         "        BufferedImage bout  = new BufferedImage(nwidth,nheight,BufferedImage.TYPE_INT_RGB);\n"
         "        WritableRaster rout = bout.getRaster();\n"
         "\n"
         "        int apixm[] = new int[4]; // main  pixel\n"
         "        int apixt[] = new int[4]; // trans pixel\n"
         "        int apixr[] = new int[4]; // repl. color\n"
         "\n"
         "        apixt[0] = 0xFF; // default is non-transparent\n"
         "        apixr[1] = 0xFF; // set replacement color to green\n"
         "\n"
         "        for (int y=0; y<nheight; y++)\n"
         "         for (int x=0; x<nwidth; x++) \n"
         "         {\n"
         "            rmain.getPixel(x,y,apixm);\n"
         "            if (rtran != null)\n"
         "                rtran.getPixel(x,y,apixt);\n"
         "            if (apixt[0] == 0x00)\n"
         "                // pixel is fully transparent: set to green\n"
         "                rout.setPixel(x,y,apixr);\n"
         "            else\n"
         "                // else copy through, do not change.\n"
         "                rout.setPixel(x,y,apixm);\n"
         "         }\n"
         "\n"
         "        // save memory image as JPEG, with control of quality.\n"
         "        File file = new File(dst3);\n"
         "        FileOutputStream out = new FileOutputStream(file);\n"
         "        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder(out);\n"
         "        JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(bout);\n"
         "        param.setQuality((float)90.0, false); // 90 percent quality\n"
         "        encoder.setJPEGEncodeParam(param);\n"
         "        encoder.encode(bout);\n"
         "        out.close();\n"
         "        log(dst3);\n"
         "\n"
         "        // save memory image as PNG.\n"
         "        ImageIO.write(bout, \"png\", new File(dst4)); log(dst4);\n"
         "    }\n"
         "};\n"
         ,pszClassName
         );
         break;

      case 9:
      chain.print(
         "<?php\n"
         "   // simple text file read and write in php.\n"
         "   // requires the php command line interface:\n"
         "   // 1. get the php 5.x zip package\n"
         "   // 2. unzip into a dir like c:\\app\\php\n"
         "   // 3. set PATH=%PATH%;c:\\app\\php;c:\\app\\php\\ext\n"
         "   // then run this script by \"php %s\"\n"
         "\n"
         "   if ($argc < 3) {\n"
         "      print(\"usage: php %s infile outfile\\n\");\n"
         "      return;\n"
         "   }\n"
         "\n"
         "   $ssrc = $argv[1];\n"
         "   $sdst = $argv[2];\n"
         "\n"
         "   if (($fsrc = fopen($ssrc, \"r\")) === false) die(\"cannot read $ssrc\\n\");\n"
         "   if (($fdst = fopen($sdst, \"w\")) === false) die(\"cannot write $sdst\\n\");\n"
         "\n"
         "   $nlines = 0;\n"
         "   while (!feof($fsrc)) {\n"
         "      $sline = fgets($fsrc, 4096);\n"
         "      if (fputs($fdst, $sline) === false)\n"
         "         { print(\"failed to write (disk full?)\\n\"); break; }\n"
         "      $nlines++;\n"
         "   }\n"
         "\n"
         "   fclose($fdst);\n"
         "   fclose($fsrc);\n"
         "\n"
         "   print(\"$nlines lines copied from $ssrc to $sdst.\\n\");\n"
         "?>\n"
         ,pszOutFile ? pszOutFile : "thisfile.php"
         ,pszOutFile ? pszOutFile : "thisfile.php"
         );
         break;

      case 10:
      chain.print(
         "<?php\n"
         "   // create a thumbnail image from a large image.\n"
         "   // requires the php command line interface:\n"
         "   // 1. get the php 5.x zip package\n"
         "   // 2. unzip into a dir like c:\\app\\php\n"
         "   // 3. set PATH=PATH;c:\\app\\php;c:\\app\\php\\ext\n"
         "   // then run this script by \"php %s in.jpg out.jpg\"\n"
         "\n"
         "   if ($argc < 3) {\n"
         "      print(\"usage: php %s input.jpg output.jpg [targetwidth quality]\\n\");\n"
         "      return;\n"
         "   }\n"
         "\n"
         "   $ssrc = $argv[1];\n"
         "   $sdst = $argv[2];\n"
         "   $wdst = isset($argv[3]) ? $argv[3] : 100;\n"
         "   $nqty = isset($argv[4]) ? $argv[4] :  80;\n"
         "\n"
         "   if (strstr($ssrc, \".jpg\"))\n"
         "      $isrc = ImageCreateFromJPEG($ssrc);\n"
         "   else\n"
         "      $isrc = ImageCreateFromPNG($ssrc);\n"
         "   if ($isrc === false) die(\"cannot load: $ssrc\");\n"
         "\n"
         "   $nsrcw = ImageSX($isrc);\n"
         "   $nsrch = ImageSY($isrc);\n"
         "   print(\"input: $ssrc with $nsrcw\".\"x$nsrch pixels\\n\");\n"
         "\n"
         "   $hdst  = intval($wdst * $nsrch / $nsrcw);\n"
         "   $idst  = ImageCreateTrueColor($wdst, $hdst);\n"
         "   if ($idst === false) die(\"cannot create thumb\");\n"
         "\n"
         "   imagecopyresampled($idst, $isrc, 0,0,0,0, $wdst,$hdst, $nsrcw, $nsrch);\n"
         "   imagejpeg($idst, $sdst, $nqty);\n"
         "   print(\"thumb: $sdst with $wdst\".\"x$hdst pixels, quality=$nqty\\n\");\n"
         "\n"
         "   imagedestroy($idst);\n"
         "   imagedestroy($isrc);\n"
         "?>\n"
         ,pszOutFile ? pszOutFile : "thisfile.php"
         ,pszOutFile ? pszOutFile : "thisfile.php"
         );
         break;

      // sfk load sfksamp.py +toclip +clipsrc +toclip
      case 30:
      chain.print(
         "import sys\n"
         "import os\n"
         "\n"
         "def perr(message):\n"
         "    sys.stderr.write(message + \"\\n\")\n"
         "    return 9\n"
         "\n"
         "def main():\n"
         "    if len(sys.argv) < 3:\n"
         "        print(f\"usage: {sys.argv[0]} infile outfile\")\n"
         "        return 0\n"
         "    \n"
         "    psz_in_file = sys.argv[1]\n"
         "    psz_out_file = sys.argv[2]\n"
         "    \n"
         "    if not os.path.exists(psz_in_file):\n"
         "        return perr(f\"cannot read {psz_in_file}\")\n"
         "    \n"
         "    with open(psz_in_file, \"rb\") as fin, open(psz_out_file, \"wb\") as fout:\n"
         "        for line in fin:\n"
         "            line = line.rstrip(b\"\\r\\n\")\n"
         "            print(f'line: \"{line.decode(errors=\"ignore\")}\"')\n"
         "            fout.write(line + b\"\\n\")\n"
         "    \n"
         "    return 0\n"
         "\n"
         "if __name__ == \"__main__\":\n"
         "    sys.exit(main())\n"
         );
         break;

      // sfk load sfksampapp.cpp +toclip +clipsrc +toclip
      case 31:
      chain.print(
         "/*\n"
         "   simple sfk app example, free for any use.\n"
         "\n"
         "   cl -DSFKMAXCORE tmp.cpp sfk.cpp sfkext.cpp sfkpack.cpp kernel32.lib user32.lib gdi32.lib ws2_32.lib advapi32.lib shell32.lib\n"
         "   g++ -DSFKMAXCORE tmp.cpp sfk.cpp sfkext.cpp sfkpack.cpp -lkernel32 -luser32 -lgdi32 -lws2_32 -ladvapi32 -lshell32\n"
         "\n"
         "   beware that the simplified semantics may not fit into larger projects.\n"
         "*/\n"
         "\n"
         "#include \"sfkbase.hpp\"\n"
         "#include \"sfkext.hpp\"\n"
         "\n"
         "/*\n"
         "   provides:\n"
         "      int perr(const char *pszFormat, ...)\n"
         "      char *myvtext(const char *pszFormat, ...)\n"
         "      char *numtoa(num n)\n"
         "      num atonum(char *psz)\n"
         "      num getCurrentTime()\n"
         "      void doSleep(int nmsec)\n"
         "      int mystricmp(char *psz1, cchar *psz2)\n"
         "      int mystrnicmp(char *psz1, cchar *psz2, int nLen)\n"
         "      bool strBegins(char *pszStr, cchar *pszPat)\n"
         "      bool striBegins(char *pszStr, cchar *pszPat)\n"
         "      bool strEnds(char *pszStr, cchar *pszPat)\n"
         "      bool striEnds(char *pszStr, cchar *pszPat)\n"
         "      char *mystrstri(char *phay, cchar *ppat)\n"
         "      num getFileSize(char *pszName)\n"
         "      char *loadFile(char *pszFile, num *pOptOutSize=0)\n"
         "      int saveFile(char *pszName, uchar *pData, int iSize, const char *pszMode)\n"
         "      int existsFile(char *pszName, bool bOrDir)\n"
         "      char *dataAsHex(void *pAnyData, int iDataSize)\n"
         "      char *dataAsTrace(void *pAnyData, int iDataSize)\n"
         "*/\n"
         "\n"
         "// load a text or binary file, and save it to a new file.\n"
         "int main(int argc, char *argv[])\n"
         "{\n"
         "   char *pszInFile=0,*pszOutFile=0;\n"
         "\n"
         "   int iarg = 1;\n"
         "   for (;iarg<argc;iarg++) {\n"
         "      char *parg = argv[iarg];\n"
         "      if (!strcmp(parg,\"-?\") || !strcmp(parg,\"-h\")\n"
         "          || !strcmp(parg,\"-help\")) {\n"
         "         printf(\"usage: %%s infile outfile\\n\", argv[0]);\n"
         "         return 0;\n"
         "      }\n"
         "      if (!pszInFile)\n"
         "         { pszInFile = parg; continue; }\n"
         "      if (!pszOutFile)\n"
         "         { pszOutFile = parg; continue; }\n"
         "      return 9+perr(\"unexpected: %%s\\n\", parg);\n"
         "   }\n"
         "\n"
         "   if (!pszOutFile)\n"
         "      return 9+perr(\"specify input and output filename.\\n\");\n"
         "\n"
         "   num nsize = 0;\n"
         "   uchar *pdata = loadBinaryFile(pszInFile, nsize);\n"
         "   if (!pdata)\n"
         "      return 9+perr(\"cannot load: %%s\\n\", pszInFile);\n"
         "\n"
         "   char *pcur = (char*)pdata;\n"
         "   char *pmax = pcur+nsize;\n"
         "   while (pcur < pmax)\n"
         "   {\n"
         "      char *pnext = pcur;\n"
         "      while (*pnext != 0 && *pnext != '\\r' && *pnext != '\\n')\n"
         "         pnext++;\n"
         "      int ilen = pnext-pcur;\n"
         "      printf(\"line: \\\"%%.*s\\\"\\n\", ilen, pcur);\n"
         "      while (*pnext != 0 && (*pnext == '\\r' || *pnext == '\\n'))\n"
         "         pnext++;\n"
         "      pcur = pnext;\n"
         "   }\n"
         "\n"
         "   if (saveFile(pszOutFile, pdata, nsize))\n"
         "      return 9+perr(\"cannot write: %%s\\n\", pszOutFile);\n"
         "\n"
         "   delete [] pdata;\n"
         "\n"
         "   return 0;\n"
         "}\n"
         "\n"
         );
         break;

      case 11:
      chain.print(
         "<html>\n"
         " <head>\n"
         "  <title>Welcome to FooBar</title>\n"
         "   <style type=\"text/css\">\n"
         "      body     { font: 12px verdana,arial; }\n"
         "      table    { font: 12px verdana,arial; }\n"
         "      h1       { font: 16px verdana,arial; font-weight: bold; }\n"
         "      b.red    { color: #ee6622; }\n"
         "   </style>\n"
         "   <script type=\"text/javascript\">\n"
         "      function hello() {\n"
         "         document.write(\"hello from JavaScript.\");\n"
         "      }\n"
         "   </script>\n"
         " </head>\n"
         "<body leftmargin=\"0\" topmargin=\"0\" marginwidth=\"0\" marginheight=\"0\">\n"
         "\n"
         "<table width=\"980\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" border=\"0\">\n"
         "\n"
         " <tr>\n"
         "  <td width=\"120\" align=\"center\" valign=\"middle\">\n"
         "  &nbsp;<br>\n"
         "  home\n"
         "  </td>\n"
         "  <td width=\"740\" align=\"center\" valign=\"top\">\n"
         "  &nbsp;<br>\n"
         "  <h1>Welcome to FooBar.</h1>\n"
         "  </td>\n"
         "  <td width=\"120\" align=\"center\" valign=\"middle\">\n"
         "  &nbsp;<br>\n"
         "  other\n"
         "  </td>\n"
         " </tr>\n"
         "\n"
         " <tr>\n"
         "  <td align=\"center\" valign=\"top\">&nbsp;</td>\n"
         "  <td>\n"
         "      <b class=\"red\">bold</b> and normal text.\n"
         "      <p>\n"
         "      <script type=\"text/javascript\">\n"
         "         hello();\n"
         "      </script>\n"
         "  </td>\n"
         "  <td align=\"center\" valign=\"top\">&nbsp;</td>\n"
         " </tr>\n"
         "\n"
         "</table>\n"
         "\n"
         "</body>\n"
         "</html>\n"
         );
         break;

      case 12:
      chain.print(
         "@rem <?php print(\"\\r\"); /*\n"
         "@echo off\n"
         "\n"
         "IF \"%%1\"==\"\" GOTO xerr01\n"
         "\n"
         "sfk script \"%s\" -from begin %%*\n" // fix sfk1933 "" quotes
         "GOTO xend\n"
         "\n"
         ":xerr01\n"
         "sfk echo \"[green]jpeg image size lister.[def]\"\n"
         "sfk echo \"lists width, height of all .jpg in a dir.\"\n"
         "sfk echo \"usage: %s dirname\"\n"
         "GOTO xend\n"
         "\n"
         "   // this script requires the php command line interface:\n"
         "   // 1. get the php 5.x zip package\n"
         "   // 2. unzip into a dir like c:\\app\\php\n"
         "   // 3. set PATH=PATH;c:\\app\\php;c:\\app\\php\\ext\n"
         "\n"
         "   // ----- begin of sfk script code -----\n"
         "\n"
         "sfk label begin\n"
         "\n"
         "   +sel %%1 .jpg\n"
         "\n"
         "   +run -quiet -yes \"php %s $file\"\n"
         "\n"
         "   +end\n"
         "\n"
         "*/ // ----- end of sfk, begin of php script -----\n"
         "\n"
         "   // print the width and height in pixel\n"
         "   // of the supplied image file name:\n"
         "\n"
         "   $asize = getimagesize($argv[1]);\n"
         "   printf(\"w=%%04d h=%%04d %%s\\n\", $asize[0], $asize[1], $argv[1]);\n"
         "\n"
         "/* // ----- end of php script, end of batch -----\n"
         ":xend\n"
         "@rem */ ?>\n"
         ,pszOutFile ? pszOutFile : "thisfile.bat"
         ,pszOutFile ? pszOutFile : "thisfile.bat"
         ,pszOutFile ? pszOutFile : "thisfile.bat"
         );
         break;

      case 13:
      chain.print(
         "import java.io.*;\n"
         "\n"
         "public class %s\n"
         "{\n"
         "    static void log(String s) { System.out.println(s); }\n"
         "\n"
         "    // convert a single byte record into a hexdump record.\n"
         "    // by default, set nrec to 16, and ndoff to 0.\n"
         "    public static String hexRecord(byte ab[], int noffset, int nlen, int nrec, int ndoff)\n"
         "    {\n"
         "        // create hex and text representation\n"
         "        StringBuffer sline = new StringBuffer();\n"
         "        StringBuffer stext = new StringBuffer();\n"
         "        for (int i=0; i<nlen; i++) {\n"
         "            int nval = ab[noffset+i] & 0xFF;\n"
         "            if (nval < 0x10) sline.append(\"0\");\n"
         "            sline.append(Integer.toString(nval, 0x10));\n"
         "            sline.append(\" \");\n"
         "            if (Character.isLetter(nval))\n"
         "                stext.append((char)nval);\n"
         "            else\n"
         "                stext.append('.');\n"
         "        }\n"
         "        // fill rest of line, if any\n"
         "        int npadlen = nrec;\n"
         "        while (stext.length() < npadlen) stext.append(' ');\n"
         "        npadlen *= 3;\n"
         "        while (sline.length() < npadlen) sline.append(' ');\n"
         "        sline.setLength(sline.length()-1);\n"
         "        // create offset as hex value\n"
         "        String soffset = \"\";\n"
         "        soffset = Integer.toString(ndoff, 0x10).toUpperCase();\n"
         "        while (soffset.length() < 10) soffset = \"0\"+soffset;\n"
         "        // combine hex, text and offset\n"
         "        return \">\"+sline.toString().toUpperCase()+\"< \"+stext+\" \"+soffset;\n"
         "    }\n"
         "    \n"
         "    // hexdump a whole byte array, from a given offset.\n"
         "    // nrec is the number of bytes per output record, use 16 by default.\n"
         "    // ndosv is the display offset start value, use 0 by default.\n"
         "    public static void hexDump(byte ab[], int noffset, int nlen, int nrec, int ndoff)\n"
         "    {\n"
         "        while (nlen > 0) {\n"
         "            int nblock  = (nlen < nrec) ? nlen : nrec;\n"
         "            String srec = hexRecord(ab, noffset, nblock, nrec, ndoff);\n"
         "            System.out.println(srec);\n"
         "            noffset += nblock;\n"
         "            ndoff   += nblock;\n"
         "            nlen    -= nblock;\n"
         "        }\n"
         "    }\n"
         "\n"
         "    // hex dump a whole binary file's content\n"
         "    public static void main(String args[]) throws Throwable\n"
         "    {\n"
         "        if (args.length < 1)\n"
         "            { log(\"usage: java %s inputfilename\"); return; }\n"
         "\n"
         "        byte abBuf[] = new byte[1600];\n"
         "\n"
         "        FileInputStream oin = new FileInputStream(args[0]);\n"
         "\n"
         "        int nread  = 0;\n"
         "        int ntotal = 0;\n"
         "        do {\n"
         "            nread = oin.read(abBuf, 0, abBuf.length);\n"
         "            if (nread > 0) hexDump(abBuf, 0, nread, 16, ntotal);\n"
         "            ntotal += nread;\n"
         "        }   while (nread > 0);\n"
         "\n"
         "        oin.close();\n"
         "    }\n"
         "}\n"
          ,pszClassName,pszClassName
        );
         break;

      case 14:
      chain.print(
         "\n"
         "import java.awt.*;\n"
         "import java.awt.event.*;\n"
         "import java.io.*;\n"
         "import javax.swing.*;\n"
         "import java.util.*;\n"
         "\n"
         "// can be run both as an applet and a command line application\n"
         "public class %s extends JApplet implements ActionListener\n"
         "{\n"
         "    // a panel to collect all objects for display\n"
         "    Container clPane = null;\n"
         "\n"
         "    // a hashmap to collect the same objects for retrieval by an id\n"
         "    HashMap<String,Component> clComp = new HashMap<String,Component>();\n"
         "    // HashMap clComp = new HashMap(); // for JDK 1.4.2\n"
         "\n"
         "    // the current add position\n"
         "    int xadd = 0, yadd = 0;\n"
         "\n"
         "    // set component placement cursor to a position\n"
         "    void setPos(int x,int y) { xadd=x; yadd=y; }\n"
         "    \n"
         "    // add and remember a generic component for display.\n"
         "    // steps the placement cursor w pixels to the right.\n"
         "    void add(int x,int y,int w,int h,String id,Component o) {\n"
         "        o.setBounds(x,y,w,h);   // set absolute position of object\n"
         "        clPane.add(o);          // add to panel to display object\n"
         "        clComp.put(id, o);      // and remember object in a hashmap\n"
         "        xadd += w;              // step add position horizontally\n"
         "    }\n"
         "    \n"
         "    // add a non-editable text label\n"
         "    void addLabel(int w, int h, String id, String text)\n"
         "        { add(xadd,yadd,w,h, id, new JLabel(text)); }\n"
         "\n"
         "    // add a single line editable text field    \n"
         "    void addTextField(int w, int h, String id, String text)\n"
         "        { add(xadd,yadd,w,h, id, new JTextField(text)); }\n"
         "\n"
         "    // add a multi linex editable text area\n"
         "    void addTextArea(int w, int h, String id, String text) {\n"
         "        JTextArea   oarea   = new JTextArea(text);\n"
         "        JScrollPane oscroll = new JScrollPane(oarea);\n"
         "        oscroll.setBounds(xadd,yadd,w,h);\n"
         "        clPane.add(oscroll);\n"
         "        clComp.put(id,oarea);\n"
         "    }\n"
         "\n"
         "    // add a push button\n"
         "    void addButton(int w, int h, String id, String text) {\n"
         "        JButton o = new JButton(text);\n"
         "        o.addActionListener(this);\n"
         "        add(xadd,yadd,w,h, id, o);\n"
         "    }\n"
         "\n"
         "    // easy access to any object by its id\n"
         "    JTextField getTextField(String id) { return (JTextField)clComp.get(id); }\n"
         "    JTextArea  getTextArea (String id) { return (JTextArea )clComp.get(id); }\n"
         "    JLabel     getLabel    (String id) { return (JLabel    )clComp.get(id); }\n"
         "\n"
         "    // setup visible objects at absolute positions\n"
         "    private void fillPane() \n"
         "    {        \n"
         "        clPane.setLayout(null); // absolute positioning layout\n"
         "        \n"
         "        setPos      ( 20, 20);\n"
         "        addLabel    ( 70, 20, \"lname\", \"filename\");\n"
         "        addTextField(620, 20, \"tname\", \"c:\\\\test.txt\");\n"
         "\n"
         "        setPos      ( 90, yadd + 30);\n"
         "        addButton   (620, 20, \"bload\", \"load\");\n"
         "\n"
         "        setPos      ( 20, yadd + 30);\n"
         "        addLabel    ( 70, 20, \"lcont\", \"content\");\n"
         "        addTextArea (620,400, \"acont\", \"\");\n"
         "    }\n"
         "\n"
         ,pszClassName);
    chain.print(
         "    // process push button command    \n"
         "    public void actionPerformed(ActionEvent e) \n"
         "    {\n"
         "        String sout = \"\";\n"
         "        try {\n"
         "            String scmd = e.getActionCommand();\n"
         "            if (scmd.equals(\"load\")) \n"
         "            {\n"
         "                String sFilename = getTextField(\"tname\").getText();\n"
         "                BufferedReader rin = new BufferedReader(\n"
         "                    new InputStreamReader(new FileInputStream(sFilename), \"ISO-8859-1\"));\n"
         "                while (true) {\n"
         "                    String sline = rin.readLine();\n"
         "                    if (sline == null) break; // EOD\n"
         "                    sout += sline + \"\\n\";\n"
         "                }\n"
         "                rin.close();\n"
         "            }\n"
         "        } catch (Throwable t) {\n"
         "            sout = \"\"+t;\n"
         "        }\n"
         "        getTextArea(\"acont\").setText(sout);\n"
         "    }\n"
         "\n"
         "    // to run it from the command line:\n"
         "    public static void main(String[] args)\n"
         "        { new %s().main2(args); }\n"
         "\n"
         "    public void main2(String[] args) {\n"
         "        JFrame frame = new JFrame(\"Simple File Viewer\");\n"
         "        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);\n"
         "        clPane = frame.getContentPane();\n"
         "        fillPane();\n"
         "        frame.setSize(760, 560);\n"
         "        frame.setVisible(true);\n"
         "    }\n"
         "\n"
         "    // to run it as an applet:\n"
         "  public void init() {\n"
         "     clPane = new JPanel();\n"
         "     this.setContentPane(clPane);\n"
         "     fillPane();\n"
         "  }\n"
         "    /*\n"
         "       create a page \"show.html\" containing\n"
         "\n"
         "       <html><body>\n"
         "          <Applet Code=\"%s.class\" width=800 height=600></Applet>\n"
         "       </body></html>\n"
         "      \n"
         "       and then type \"appletviewer show.html\"\n"
         "    */\n"
         "}\n"
          ,pszClassName,pszClassName
        );
        break;

      case 16:
      chain.print(
          "/*\n"
          "   Example for sending UDP color text in C++.\n"
          "   For more details read \"sfk netlog\".\n"
          "\n"
          "   Compile like:\n"
          "      Windows gcc : g++ %s -lws2_32\n"
          "      Windows VC  : cl  %s ws2_32.lib\n"
          "      Linux/Mac   : g++ %s\n"
          "*/\n"
          "\n"
          "#include <stdio.h>\n"
          "#include <stdlib.h>\n"
          "#include <string.h>\n"
          "#include <stdarg.h>\n"
          "#include <errno.h>\n"
          "\n"
          "#ifdef _WIN32\n"
          "  #include <windows.h>\n"
          "  #ifdef _MSC_VER\n"
          "    #define snprintf  _snprintf \n"
          "    #define vsnprintf _vsnprintf \n"
          "    #define sockerrno WSAGetLastError()\n"
          "  #else\n"
          "    #include <ws2tcpip.h>\n"
          "    #define sockerrno errno\n"
          "  #endif\n"
          "  #define socklen_t int\n"
          "#else\n"
          "  #include <sys/socket.h>\n"
          "  #include <netdb.h>\n"
          "  #ifdef __APPLE__\n"
          "    #define SOL_IP IPPROTO_IP\n"
          "  #endif\n"
          "  #ifndef INVALID_SOCKET\n"
          "    #define INVALID_SOCKET -1\n"
          "  #endif\n"
          "  #define sockerrno errno\n"
          "#endif\n"
          "\n"
          "char szLineBuf[500];\n"
          "\n"
          "int iNetSock = INVALID_SOCKET;\n"
          "int iRequest = 1;\n"
          "struct sockaddr_in oAddr;\n"
          "socklen_t iAddrLen = sizeof(oAddr);\n"
          "\n"
          "int perr(const char *pszFormat, ...)\n"
          "{\n"
          "   va_list argList;\n"
          "   va_start(argList, pszFormat);\n"
          "   vsnprintf(szLineBuf, sizeof(szLineBuf)-10, pszFormat, argList);\n"
          "   szLineBuf[sizeof(szLineBuf)-10] = '\\0';\n"
          "   printf(\"Error: %s\\n\", szLineBuf);\n"
          "   return 0;\n"
          "}\n"
          "\n"
          "int netlog(const char *pszFormat, ...)\n"
          "{\n"
          "   char szHeadBuf[100];\n"
          "   int  iHeadLen = 0;\n"
          "\n"
          "   va_list argList;\n"
          "   va_start(argList, pszFormat);\n"
          "   vsnprintf(szLineBuf+100, sizeof(szLineBuf)-110, pszFormat, argList);\n"
          "   szLineBuf[sizeof(szLineBuf)-10] = '\\0';\n"
          "   \n"
          "   // change all [red] to compact color codes \\x1Fr\n"
          "   for (char *psz=szLineBuf+100; *psz; psz++)\n"
          "      if (psz[0]=='[')\n"
          "         for (int i=1; psz[i]; i++)\n"
          "            if (i>=2 && psz[i]==']')\n"
          "               { psz[0]=0x1F; memmove(psz+2, psz+i+1, strlen(psz+i+1)+1); break; }\n"
          "\n"
          "   // add sfktxt header before text\n"
          "   snprintf(szHeadBuf, sizeof(szHeadBuf)-10, \":sfktxt:v100,req%s,cs1\\n\\n\", iRequest++);\n"
          "   iHeadLen = strlen(szHeadBuf);\n"
          "   char *pData = szLineBuf+100-iHeadLen;\n"
          "   memcpy(pData, szHeadBuf, iHeadLen);\n"
          "\n"
          "   sendto(iNetSock, pData, strlen(pData), 0, (struct sockaddr *)&oAddr, iAddrLen);\n"
          "\n"
          "   return 0;\n"
          "}\n"
          "\n"
          "int main(int argc, char *argv[])\n"
          "{\n"
          "   const char *pszHost = \"localhost\";\n"
          "   unsigned short iPort = 21323;\n"
          "   \n"
          "   #ifdef _MSC_VER\n"
          "   WORD wVersionRequested = MAKEWORD(1,1);\n"
          "   WSADATA wsaData;\n"
          "   if (WSAStartup(wVersionRequested, &wsaData)!=0)\n"
          "      return 9+perr(\"WSAStartup failed\");\n"
          "   #endif\n"
          "\n"
          "   memset((char *)&oAddr, 0,sizeof(oAddr));\n"
          "   oAddr.sin_family      = AF_INET;\n"
          "   oAddr.sin_port        = htons(iPort);\n"
          "\n"
          "   struct hostent *pHost = gethostbyname(pszHost);\n"
          "   memcpy(&oAddr.sin_addr.s_addr, pHost->h_addr, pHost->h_length);\n"
          "\n"
          "   if ((iNetSock = socket(AF_INET, SOCK_DGRAM, 0)) < 0)\n"
          "      return 9+perr(\"cannot create socket\");\n"
          "\n"
          "   netlog(\"[Red]Foo[def] and [Blue]bar[def] went to the [Green]zoo[def].\\n\");\n"
          "   \n"
          "   return 0;\n"
          "}\n"
          "\n"
          , pszOutFile ? pszOutFile : "netlog.cpp"
          , pszOutFile ? pszOutFile : "netlog.cpp"
          , pszOutFile ? pszOutFile : "netlog.cpp"
          , "%s" // literally
          , "%d" // literally
         );
         if (!pszOutFile)
            printf("// to write .cpp file use:\n"
                   "// sfk samp cppnetlog netlog.cpp\n");
         break;
 
      case 17:
      if (!pszOutFile) pszClassName = str("netlog");
      chain.print(
          "/*\n"
          "   Example for sending UDP color text in Java.\n"
          "   For more details read \"sfk netlog\".\n"
          "*/\n"
          "\n"
          "import java.io.*;\n"
          "import java.net.*;\n"
          "\n"
          "public class %s\n"
          "{\n"
          "   public static DatagramSocket clSocket = null;\n"
          "   public static InetAddress clAddress = null;\n"
          "   public static int iClPort = -1;\n"
          "   static int iClRequest = 1;\n"
          "\n"
          "   public static void init(String sHost, int iPort) throws Throwable\n"
          "   {\n"
          "      clAddress = InetAddress.getByName(sHost);\n"
          "      iClPort = iPort;\n"
          "      clSocket = new DatagramSocket();\n"
          "   }\n"
          "\n"
          "   public static void log(String sTextIn) throws Throwable\n"
          "   {\n"
          "      String sText   = sTextIn+\"\\n\";\n"
          "\n"
          "      // change all [red] to compact color codes \\x1Fr\n"
          "      byte[] abData1 = sText.getBytes();\n"
          "      int    iSize1  = abData1.length;\n"
          "      byte[] abData2 = new byte[iSize1+100];\n"
          "\n"
          "      // keep 100 bytes space for header\n"
          "      int i2=100;\n"
          "      for (int i1=0; i1<iSize1;)\n"
          "      {\n"
          "         if (abData1[i1]=='[') {\n"
          "            i1++;\n"
          "            if (i1>=iSize1)\n"
          "               break;\n"
          "            abData2[i2++] = (byte)0x1F;\n"
          "            abData2[i2++] = abData1[i1++];\n"
          "            while (i1<iSize1 && abData1[i1]!=']')\n"
          "               i1++;\n"
          "            if (i1<iSize1)\n"
          "               i1++;\n"
          "         } else {\n"
          "            abData2[i2++] = abData1[i1++];\n"
          "         }\n"
          "      }\n"
          "      int iTextSize = i2-100;\n"
          "\n"
          "      // add sfktxt header before text\n"
          "      String sHead = \":sfktxt:v100,req\"+iClRequest+\",cs1\\n\\n\";\n"
          "      iClRequest++;\n"
          "      byte abHead[] = sHead.getBytes();\n"
          "      int iHeadLen  = abHead.length;\n"
          "      for (int i=0; i<iHeadLen; i++)\n"
          "         abData2[100-iHeadLen+i] = abHead[i];\n"
          "      int iStartOff = 100-iHeadLen;\n"
          "      int iFullSize = iHeadLen+iTextSize;\n"
          "\n"
          "      DatagramPacket packet = new DatagramPacket(abData2, iStartOff, iFullSize, clAddress, iClPort);\n"
          "      clSocket.send(packet);\n"
          "   }\n"
          "\n"
          "   public static void main(String args[]) throws Throwable\n"
          "   {\n"
          "      %s.init(\"localhost\", 21323);\n"
          "      %s.log(\"[Red]Foo[def] and [Blue]bar[def] went to the [Green]zoo[def].\");\n"
          "   }\n"
          "}\n"
          "\n"
          , pszClassName
          , pszClassName
          , pszClassName
          );
         if (!pszOutFile)
            printf("// to write .java file use:\n"
                   "// sfk samp javanetlog netlog.java\n");
         break;

         case 18:
         if (iSystem==1)
         chain.print(
            "@echo off\n"
            "sfk script \"%%~f0\" -from begin %%*\n" // fix sfk1933 "" quotes
            "rem \"%%~f0\" is the absolute batch file name.\n"
            "GOTO xend\n"
            "\n");
         else
         chain.print(
            "#!/bin/bash\n"
            "sfk script \"$0\" -from begin $@\n" // fix sfk1933 "" quotes
            "function skip_block\n"
            "{\n");

         chain.print(
            "sfk label begin -var\n"
            "   // the -var above enables variables everywhere.\n"
            "   +setvar \"baseurl=http://stahlworks.com/webdemo\"\n"
            "   +web \"#(baseurl)/contents.xml\"\n"
            "   +xex \"_<category>**<id>*</id>**<name>*<\n"
            "         _[part4] [part8]\\n_\"\n"
            "   +perline \"call listCategory #text\" -yes\n"
            "   +end\n"
            "\n"
            "sfk label listCategory\n"
            "   +echo \"[green]=== List of %%2: ===[def]\"\n"
            "   +echo -spat \"[yellow]Name         Price[def]\"\n"
            "   +then web \"#(baseurl)/product_list_%%1.xml\"\n"
            "   // +xmlform +stop -all\n"
            "   +xex \"=<row>**<name>*<**<price>*<\n"
            "         =[part4]\\t[part8] \\x24\\n=\"\n"
            "   +filter -upat -stabform \"#(-12col1) #col2\"\n"
            "   +end\n"
            "\n");

         if (iSystem==1)
         chain.print(
            "rem a longer example with input, output and detail\n"
            "rem explanations is available in the SFK Book.\n"
            "\n"
            ":xend\n");
         else
         chain.print(
            "# a longer example with input, output and detail\n"
            "# explanations is available in the SFK Book.\n"
            "\n"
            "}\n");
         break;

         case 19:
         {
            if (!pszOutFile)
               { perr("missing output filename\n"); return; }
            if (!strEnds(pszOutFile, ".zip"))
               { perr("output filename must end with .zip\n"); return; }
            if (!cs.force && fileExists(pszOutFile)) {
               perr("file already exists: %s\n", pszOutFile);
               pinf("add -force to overwrite.\n");
               return;
            }
            printf("writing: %s\n", pszOutFile);
            int    isize = 0;
            uchar *pdata = getWebDemoData(isize);
            saveFile(pszOutFile, pdata, isize);
            printf("you may now:\n"
                   "- unzip %s\n"
                   "- sfk httpserv -deep\n"
                   "- open a different shell, then adapt the batch\n"
                   "  from \"sfk samp http\" to use localhost.\n",
                   pszOutFile
                   );
            break;
         }

         case 20: // tcp.bat and tcp.sh
         if (iSystem==1)
         chain.print(
            "@echo off\n"
            "sfk script \"%%~f0\" -from begin %%*\n"
            "GOTO xend\n"
            "\n");
         else
         chain.print(
            "#!/bin/bash\n"
            "sfk script \"$0\" -from begin $@\n"
            "function skip_block\n"
            "{\n");

         chain.print(
            "sfk label begin -var\n"
            "   +if \"%%1 = \" stop -all \"usage: tcp client|server [host:]port\"\n"
            "   +call %%1 %%2\n"
            "   +end\n"
            "\n"
            "sfk label client\n"
            "   +tell \"connecting to %%1\"\n"
            "   +connect %%1\n"
            "   +send -spat \"GET / HTTP/1.1\\r\\n\\r\\n\"\n"
            "   +receive -timeout=3000\n"
            "   +disconnect\n"
            "   +end\n"
            "\n"
            "sfk label server\n"
            "   +tell \"waiting on port %%1\"\n"
            "   +accept %%1\n"
            "   +receive -line -tovar a\n"
            "   +echo -spat \"I got: #(a)\"\n"
            "      +setvar b\n"
            "   +send -fromvar b\n"
            "   +disconnect\n"
            "   +loop\n"
            "   +end\n"
            "\n");

         if (iSystem==1)
         chain.print(
            ":xend\n");
         else
         chain.print(
            "}\n");

         break;

         case 25: // tcpserv.bat and tcpserv.sh
         if (iSystem==1)
         chain.print(
            "@echo off\n"
            "sfk script \"%%~f0\" -from begin %%*\n"
            "GOTO xend\n"
            "\n");
         else
         chain.print(
            "#!/bin/bash\n"
            "sfk script \"$0\" -from begin $@\n"
            "function skip_block\n"
            "{\n");

         chain.print(
            "sfk label begin -var\n"
            "\n"
            "   +tell \"waiting for connection\"\n"
            "\n"
            "   +accept 80\n"
            "\n"
            "   +receive -until \"\\r\\n\\r\\n\"\n"
            "      -tovar request\n"
            "\n"
            "   +if \"#(contains(request,'GET / ')) = 1\" begin\n"
            "      +call sendindex\n"
            "   +elseif \"#(contains(request,'GET /test.png ')) = 1\"\n"
            "      +call sendimage\n"
            "   +else\n"
            "      +call senderror 404\n"
            "   +endif\n"
            "\n"
            "   +disconnect\n"
            "\n"
            "   +loop\n"
            "\n"
            "   +endif\n"
            "\n"
            "sfk label sendindex\n"
            "\n"
            "   +echo -join -spat -noline\n"
            "      \"\n"
            "      HTTP/1.1 200 OK\\r\\n\n"
            "      Connection: close\\r\\n\n"
            "      Content-Type: text/html\\r\\n\n"
            "      \\r\\n\n"
            "      <html><body>\n"
            "         Welcome to tcpserv.\n"
            "         <a href=\\qtest.png\\q>View a color pic here.</a>\n"
            "      </body></html>\n"
            "      \"\n"
            "      +setvar reply\n"
            "\n"
            "   +send -fromvar reply\n"
            "\n"
            "   +end\n"
            "\n"
            "sfk label sendimage\n"
            "\n"
            "   +echo\n"
            "      \"\n"
            "      iVBORw0KGgoAAAANSUhEUgAAADAAAAAICAIAAAAw\n"
            "      SesQAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8\n"
            "      YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAABDSURB\n"
            "      VDhPY/zv4MBAEPhDaXwgGErjASdloQw8gAlKDxow\n"
            "      6iBCgHE+MWlIDUrjA5pQGg94KgBl4AGjUUYIDDIH\n"
            "      MTAAAEPWBXmgMU/kAAAAAElFTkSuQmCC\n"
            "      \"\n"
            "      +decode -base64 +setvar data\n"
            "\n"
            "   +setvar ndata=#(size(data))\n"
            "\n"
            "   +echo -join -spat -noline\n"
            "      \"\n"
            "      HTTP/1.1 200 OK\\r\\n\n"
            "      Connection: close\\r\\n\n"
            "      Content-Length: #(ndata)\\r\\n\n"
            "      Content-Type: image/png\\r\\n\n"
            "      \\r\\n\n"
            "      \"\n"
            "      +setvar header\n"
            "\n"
            "   +send -fromvars header,data\n"
            "\n"
            "   +end\n"
            "\n"
            "sfk label senderror\n"
            "\n"
            "   +echo -join -spat -noline\n"
            "      \"\n"
            "      HTTP/1.1 %%1 Failed\\r\\n\n"
            "      Connection: close\\r\\n\n"
            "      Content-Type: text/plain\\r\\n\n"
            "      \\r\\n\n"
            "      Resource not found.\\r\\n\n"
            "      \"\n"
            "      +setvar reply\n"
            "\n"
            "   +send -fromvar reply\n"
            "\n"
            "   +end\n"
            );

         if (iSystem==1)
         chain.print(
            ":xend\n");
         else
         chain.print(
            "}\n");

         break;

         case 21: // vedit.bat
         chain.print(
"@echo off\n"
"sfk script \"%%~f0\" -from begin %%*\n"
"GOTO xend\n"
"\n"
"sfk label begin -var\n"
"\n"
"   +if \"%%1 = \" begin\n"
"      +tell \"[green]vedit 1.1 - edit a video file[def]\"\n"
"      +tell \"\"\n"
"      +tell \"vedit command input output[.ext] [-yes][def]\"\n"
"      +tell \"\"\n"
"      +tell \"1. run VLC with a video in the current folder\"\n"
"      +tell \"   (not in a sub folder), with a simple filename\"\n"
"      +tell \"   with just one extension (not foo.m3u8.mkv).\"\n"
"      +tell \"   press CTRL+B to show the bookmarks.\"\n"
"      +tell \"   mark start and end of each part to extract.\"\n"
"      +tell \"   there must be an even number of bookmarks.\"\n"
"      +tell \"   CTRL+Y and save playlist file: parts.xspf\"\n"
"      +tell \"\"\n"
"      +tell \"2. type one of these commands:\"\n"
"      +tell \"\"\n"
"      +tell \"   [green]vedit get parts.xspf outdir\\video01[def]\"\n"
"      +tell \"     get parts and store as outdir\\video01-part01/02/...\"\n"
"      +tell \"     keeping the original file extension/format\"\n"
"      +tell \"\"\n"
"      +tell \"   [green]vedit get parts.xspf outdir\\video01 .mpg[def]\"\n"
"      +tell \"     convert parts to .mpg format\"\n"
"      +tell \"\"\n"
"      +tell \"   [green]vedit join parts.xspf video01[def]\"\n"
"      +tell \"     get parts and rejoin as video01.xyz\"\n"
"      +tell \"     keeping the origial extension/format.\"\n"
"      +tell \"     requires ffmpeg 4.4.1 or higher.\"\n"
"      +tell \"\"\n"
"      +tell \"   [green]vedit join parts.xspf video01.mpg[def]\"\n"
"      +tell \"     join and convert to given format like .mpg\"\n"
"      +tell \"\"\n"
"      +tell \"   [green]vedit wipe[def]\"\n"
"      +tell \"     cleanup the zzsfktmp folder\"\n"
"      +tell \"\"\n"
"      +tell \"   [green]vedit shrink in.mov out.mov[def]\"\n"
"      +tell \"     create video with halve width and height\"\n"
"      +tell \"\"\n"
"      +tell \"   [green]vedit scale in.mov 640:400 out.mov[def]\"\n"
"      +tell \"     scale video to given resolution\"\n"
"      +tell \"\"\n"
"      +tell \"if it fails try simple filenames, without folders,\"\n"
"      +tell \"backslashes or special characters.\"\n"
"      +tell \"\"\n"
"      +stop\n"
"      +endif\n"
"\n"
"   +setvar partlist=\"\"\n"
"   +setvar lastext=\"\"\n"
"   +setvar diffext=0\n"
"   +setvar userext=\"\"\n"
"\n"
"   +if \"%%1 = wipe\" begin\n"
"      +rmtree zzsfktmp -yes\n"
"      +stop +endif\n"
"\n"
"   +if \"%%1 = get\" begin\n"
"      +if \"%%2 = \" stop \"missing input .xspf filename\"\n"
"      +if \"%%3 = \" stop \"missing output base, e.g. outdir\\video01\"\n"
"      +call getparts %%2 %%3 %%4 %%5\n"
"      +stop +endif\n"
"\n"
"   +if \"%%1 = join\" begin\n"
"      +if \"%%2 = \" stop \"missing input .xspf filename\"\n"
"      +if \"%%3 = \" stop \"missing output filebase/name, e.g. video01 or video.mpg\"\n"
"      +mkdir zzsfktmp\n"
"      +call getparts %%2 zzsfktmp/edit %%4\n"
"      +echo -pure \"%%3\" +xed _\\\\_/_ +setvar out\n"
"      +call joinparts #(out) %%4\n"
"      +stop +endif\n"
"\n"
"   +if \"%%1 = scale\" begin\n"
"      +if \"%%4 = \" stop -all \"usage: vedit scale in.mov 640:400 out.mov\"\n"
"      +setvar in=\"%%2\" +setvar out=\"%%4\"\n"
"      +run %%5 \"ffmpeg -y -i #(qin) -vf scale=%%3 #(qout)\"\n"
"      +if \"%%5 = -yes\" list -time -size #(in) #(out)\n"
"      +stop +endif\n"
"\n"
"   +if \"%%1 = shrink\" begin\n"
"      +if \"%%3 = \" stop -all \"usage: vedit shrink in.mov out.mov\"\n"
"      +setvar in=\"%%2\" +setvar out=\"%%3\"\n"
"      +run %%4 \"ffmpeg -y -i #(qin) -vf scale=iw/2:-1 #(qout)\"\n"
"      +if \"%%4 = -yes\" list -time -size \"#(in)\" \"#(out)\"\n"
"      +stop +endif\n"
"\n"
"   +tell \"unknown command: %%1\"\n"
"\n"
"   +end\n"
"\n"
"sfk label getparts\n"
"   // expects a VLC bookmark file like \"parts.xspf\" containing a record like:\n"
"   // <location>file:///C:/vid/foobar.mov</location>\n"
"   // <vlc:option>bookmarks={name=myfile.MOV #0,time=749.750},{name=myfile.MOV #1,time=844.500},{name=myfile.MOV #2,time=1680.250},{name=myfile.MOV #3,time=1751.250}</vlc:option>\n"
"   +setvar infile=\"%%1\"\n"
"   +setvar outbase=\"%%2\"\n"
"   +setvar userext=\"%%3\"\n"
"   +setvar yes=\"%%4\"\n"
"   +if \"#(userext) = -yes\" begin\n"
"      +setvar userext=\"\"\n"
"      +setvar yes=\"-yes\"\n"
"      +endif\n"
"   +if \"#(contains(infile,'.xspf')) = 0\" stop -all \"supply an .xspf file as input\"\n"
"   +setvar npart=1\n"
"   +xex %%1\n"
"      \"_<location>*</location>_[all]\\n_\"\n"
"      \"_<vlc:option>bookmarks=**</vlc:option>_[part2]\\n_\"\n"
"      +perline -setvar line \"call getpart1\" -yes\n"
"   +end\n"
"\n"
"sfk label getpart1\n"
"   +if \"#(contains(line,'<location>')) = 1\" begin\n"
"      +getvar line\n"
"         +xex \"_<location>*</location>_[setvar file][part2][endvar]_\"\n"
"      +getvar file +xed \"_*/__\" +decode -url +setvar file\n"
"      // +tell \"file: #(file)\"\n"
"      +stop +endif\n"
"   // +tell \"book: #(line)\"\n"
"   +getvar line\n"
"      +xex\n"
"         \"_{name=* #*,time=*},{name=* #*,time=*}_[part2]\\t[part6]\\t[part12]\\n_\"\n"
"      +perline -setvar book \"call getpart2\" -yes\n"
"   +end\n"
"   \n"
"sfk label getpart2\n"
"   +getvar book\n"
"      +xex \"_*\\t*\\t*\n"
"            _[setvar title][part1][endvar]\n"
"             [setvar sabs][part3][endvar]\n"
"             [setvar eabs][part5][endvar]_\"\n"
"   +setvar iext=\"#(strrpos(file,'.'))\"\n"
"   +setvar ext=\"#(substr(file,iext))\"\n"
"   +if \"#(userext) <> \" setvar ext=\"#(userext)\"\n"
"   +if \"#(lastext) = \" setvar lastext=#(ext)\n"
"   +if \"#(lastext) <> #(ext)\" setvar diffext=1\n"
"   +calc \"#(eabs)-#(sabs)\" +setvar duration\n"
"   +setvar partfileabs=\"#(outbase)-#(03npart)#(ext)\"\n"
"   +setvar partfilerel=\"edit-#(03npart)#(ext)\"\n"
"   +then run #(yes) \"ffmpeg -y -ss #(sabs) -i #(qfile) -c copy -t #(duration) #(qpartfileabs)\"\n"
"   +calc \"#(npart)+1\" +setvar npart\n"
"   +echo \"file '#(partfilerel)'\" +addtovar partlist\n"
"   +end\n"
"\n"
"sfk label joinparts\n"
"   +setvar outfile=\"%%1\"\n"
"   +setvar codec=\"\"\n"
"   +setvar iext=\"#(strrpos(outfile,'.'))\"\n"
"   +if \"#(iext) = -1\" begin\n"
"      +if \"#(diffext) = 1\" call multiformerr\n"
"      +if \"#(diffext) = 0\" setvar codec=\"-c copy\"\n"
"      +setvar outfile=\"%%1#(ext)\"\n"
"      +endif\n"
"   +if \"#(iext) <> -1\" begin\n"
"      +setvar oext=\"#(substr(outfile,iext))\"\n"
"      +if \"#(oext) = #(ext)\" setvar codec=\"-c copy\"\n"
"      +endif\n"
"   +getvar partlist +tofile zzsfktmp\\infiles.txt\n"
"   +then run %%2 \"ffmpeg -y -f concat -i zzsfktmp\\infiles.txt #(codec) -timecode 00:00:00.0 #(qoutfile)\"\n"
"   +if \"%%2 = -yes\" sel -time -size #(outfile)\n"
"   +end\n"
"\n"
"sfk label multiformerr\n"
"   +tell \"input files have multiple formats.\"\n"
"   +tell \"you must supply an output file extension, e.g. #(ext)\"\n"
"   +tell \"joining different input formats may not work at all.\"\n"
"   +stop -all\n"
"   +end\n"
"\n"
":xend\n"
"\n"
);
         break;

         case 24: // gallery.bat or gallery.sh
         if (iSystem==1)
         chain.print(
            "@echo off\n"
            "sfk script \"%%~f0\" -from begin %%*\n"
            "GOTO xend\n"
            "\n");
         else
         chain.print(
            "#!/bin/bash\n"
            "sfk script \"$0\" -from begin $@\n"
            "function skip_block\n"
            "{\n");

         chain.print(
"sfk label begin -var\n"
"\n"
"   +if \"%%2 = \" begin\n"
"      +tell \"create gallery html from an image folder.\\n\"\n"
"      +tell \"[green]usage:[def]\"\n"
"      +tell \"   #(sys.ownscript.name) out.html folder [.svg .png]\"\n"
"      +stop -all\n"
"      +endif\n"
"\n"
"   +setvar out=\"%%1\"\n"
"   +if \"#(contains(out,'.htm')) = 0\" begin\n"
"      +tell \"output filename must contain .html\"\n"
"      +stop 9\n"
"      +endif\n"
"\n"
"   +setvar folder=\"%%2\"\n"
"   +setvar m1=\"%%3\"\n"
"   +setvar m2=\"%%4\"\n"
"   +setvar m3=\"%%5\"\n"
"\n"
"   +echo \"<html><head><style>\"\n"
"      \"body { background-color: #dddddd; } \"\n"
"      \"h2 { text-align: center; } \"\n"
"      \"</style></head><body>\"\n"
"      +setvar a\n"
"\n"
"   +if \"#(m1) = \" begin\n"
"      +setvar mask=\".svg .png .jpg .jpeg .gif\"\n"
"      +sel #(folder) .svg .png .jpg .jpeg .gif +setvar flist\n"
"      +endif\n"
"\n"
"   +if \"#(m1) <> \" begin\n"
"      +setvar mask=\"#(m1) #(m2) #(m3)\"\n"
"      +sel #(folder) #(m1) #(m2) #(m3) +setvar flist\n"
"      +endif\n"
"\n"
"   +echo \"<h2>#(numlines(flist)) images of type #(mask)</h2>\"\n"
"      +addtovar a\n"
"\n"
"   +getvar flist\n"
"      +filt -spat -form \"<a href=\\q$col1\\q><img src=\\q$col1\\q height=\\q180\\q title=\\q$col1\\q></a>\"\n"
"         +addtovar a\n"
"\n"
"   +echo \"</body></html>\"\n"
"      +addtovar a\n"
"\n"
"   +getvar a\n"
"      +tofile #(out)\n"
"\n"
"   +end\n"
"\n");

         if (iSystem==1)
         chain.print(
            ":xend\n");
         else
         chain.print(
            "}\n");

         break;

         case 22: // proxy.bat and proxy.sh
         if (iSystem==1)
         chain.print(
            "@echo off\n"
            "sfk script \"%%~f0\" -from begin %%*\n"
            "GOTO xend\n"
            "\n");
         else
         chain.print(
            "#!/bin/bash\n"
            "sfk script \"$0\" -from begin $@\n"
            "function skip_block\n"
            "{\n");

         chain.print(
"sfk label begin -var\n"
"\n"
"   +proxy\n"
"\n"
"      from http 80 -verbose -maxdump=512\n"
"        to http 192.168.1.100:80\n"
"      // open 127.0.0.1 in your web browser to access\n"
"      // a http server on ip .100, and show traffic in console.\n"
"\n"
"      from http 8080 -verbose -maxdump=512\n"
"        call pertcp\n"
"        to http 127.0.0.1:8100\n"
"      // run in a separate cmd window: sfk webserv -port=8100\n"
"      // then type in your browser: 127.0.0.1:8080\n"
"      // to get an instant http traffic dump in the console.\n"
"\n"
"      from udp 224.0.0.251:5353 call perudp\n"
"      // listen for mDNS bonjour traffic, call label per packet\n"
"      // to print only packets containing text \"_raop\"\n"
"      // meaning AirPlay input announcements.\n"
"\n"
"   +end\n"
"\n"
"sfk label perudp\n"
"\n"
"   +getvar data\n"
"      +xex -justrc \"/_raop/\"\n"
"      +if \"rc=0\" stop 0\n"
"\n"
"   +tell \"Got packet from #(fromip) with #(size(data)) bytes:\"\n"
"   +getvar data\n"
"      +hexdump -maxdump=128\n"
"\n"
"   +end\n"
"\n"
"sfk label pertcp\n"
"\n"
"   // disable gzip encoding to allow content dump\n"
"   +getvar data\n"
"      +xed \"_accept-encoding:*[eol]__\"\n"
"         +setvar data\n"
"\n"
"   +end\n"
            );

         if (iSystem==1)
         chain.print(
            ":xend\n");
         else
         chain.print(
            "}\n");

         break;

         case 23: // webreq.bat and webreq.sh
         if (iSystem==1)
         chain.print(
            "@echo off\n"
            "sfk script \"%%~f0\" -from begin %%*\n"
            "GOTO xend\n"
            "\n");
         else
         chain.print(
            "#!/bin/bash\n"
            "sfk script \"$0\" -from begin $@\n"
            "function skip_block\n"
            "{\n");

         chain.print(
"sfk label begin -var\n"
"\n"
"   // example how to fully formulate a web request\n"
"   // to test different header lines on an url.\n"
"\n"
"   +web -headers\n"
" \n"
"      http://localhost/index.html\n"
" \n"
"   -request\n"
"\n"
"      \"GET / HTTP/1.1\n"
"       Host: localhost\n"
"       Accept: text/html;q=0.9,*/*;q=0.8\n"
"       Accept-Language: en-us,en;q=0.8\n"
"       Connection: close\n"
" \n"
"      \"\n"
"\n"
"   +end\n"
"\n"
            );

         if (iSystem==1)
         chain.print(
            ":xend\n");
         else
         chain.print(
            "}\n");

         break;

         case 26: // perline template
         if (iSystem==1)
         chain.print(
            "@echo off\n"
            "sfk script \"%%~f0\" -from begin %%*\n"
            "GOTO xend\n"
            "\n");
         else
         chain.print(
            "#!/bin/bash\n"
            "sfk script \"$0\" -from begin $@\n"
            "function skip_block\n"
            "{\n");

         chain.print(
            "sfk label begin -var\n"
            "\n"
            "   // +load in.txt +setvar intext\n"
            "\n"
            "   +echo -spat \"the quick\\nbrown fox\\njumps over\\nthe lazy dog.\"\n"
            "      +setvar intext\n"
            "\n"
            "   +setvar output=\"\"\n"
            "\n"
            "   +getvar intext\n"
            "      +perline -setvar line \"call single\" -yes\n"
            "\n"
            "   +getvar output\n"
            "\n"
            "   // +tofile out.txt\n"
            "\n"
            "   +end\n"
            "\n"
            "sfk label single\n"
            "\n"
            "   // the '*' consumes rest of line\n"
            "   +getvar line\n"
            "      +xex \"_[lstart][chars not ( \\t)]*\n"
            "            _[setvar word][part2][endvar]_\"\n"
            "\n"
            "   +echo \"first word: #(word)\"\n"
            "      +addtovar output\n"
            "\n"
            "   +end\n"
            );

         if (iSystem==1)
            chain.print(":xend\n");
         else
            chain.print("}\n");

         break;

      }
}

void printSearchReplaceCommands(bool bNoBlankLine)
{
printx("   $see also\n"
       "      #sfk xfind<def>     search  wildcard text in   plain text files\n"
       "      #sfk ofind<def>     search  in office files    .docx .xlsx .ods\n"
       "      #sfk xfindbin<def>  search  wildcard text in   text/binary files\n"
       "      #sfk xhexfind<def>  search  in text/binary with hex dump output\n"
       "      #sfk extract<def>   extract wildcard data from text/binary files\n"
       "      #sfk filter<def>    filter  and edit text with simple wildcards\n"
       "      #sfk find<def>      search  fixed    text in   text        files\n"
       "      #sfk findbin<def>   search  fixed    text in   text/binary files\n"
       "      #sfk hexfind<def>   search  fixed    text in        binary files\n"
       "      #sfk replace<def>   replace fixed    text in   text/binary files\n"
       "      #sfk view<def>      GUI tool to search text as you type\n"
       "      #sfk replace<def>   replace fixed    text with high performance\n"
       "      #sfk xreplace<def>  replace wildcard text in   text/binary files\n"
       "      #sfk setbytes<def>  change byte sequences at absolute position\n"
       "      #sfk partcopy<def>  copy, split and join parts of files\n"
       "%s",
       bNoBlankLine ? "" : "\n"
       );
}

void printSFKMatchHelp(bool bRepHelp, bool bFullHelp=1)
{
printx("   $wildcards and SFK expressions\n"
       "      SFK Expressions are simple patterns containing literal text,\n"
       "      wildcards * and ? and character classes in square brackets [].\n"
       "      basically, the syntax provides extended wilcards but no\n"
       "      further logic and is not related to regular expressions.\n"
       "\n"
       "      search patterns are surrounded by a separator character which\n"
       "      can be anything not contained in the search text, like / or _\n"
       "\n");
if (bRepHelp)
printx("      $within a pattern #/fromtext/totext/<def> $the #fromtext<def> $may contain:\n");
else
printx("      $within a search pattern #/fromtext/<def> $the #fromtext<def> $may contain:\n");
printx("\n"
       "        $*<def>                       - 0 to 4000 characters in the same\n"
       "                                  text line or paragraph, i.e. all\n"
       "                                  bytes not being CR, LF or NULL.\n"
       "                                  4000 is just a default maximum\n"
       "                                  that can be changed by:\n"
       "        $[0.100000 chars]<def>        - 0 to 100000 characters in the same\n"
       "                                  text line or paragraph, i.e. the\n"
       "                                  same as * but with a larger range.\n"
       "        $?<def>                       - one character.\n"
       "        $???\x3f\x3f<def>                   - same as $[5.5 chars]<def> or $[5 chars]<def>\n"
       "        $[bytes]<def>                 - 0 to 4000 bytes (with CR,LF,NULL)\n"
       "                                  i.e. it collects stream text\n"
       "                                  across lines, even in binary data\n"
       "        $**<def>                      - the same as [bytes].\n"
       "        $[0.100 bytes]<def>           - 0 to 100 bytes\n"
       "        $[.100000 bytes]<def>         - up to 100000 bytes\n"
       "        $[1.* bytes]<def>             - 1 to default maximum bytes\n"
       "        $[2 chars]<def>               - exactly 2 chars\n"
       "        $[30 bytes]<def>              - exactly 30 bytes\n"
       "        $[byte of aeiou]<def>         - one vocal (a OR A OR e OR ...),\n"
       "                                  case insensitive by default.\n"
       "                                  \"aeiou\" is a character list.\n"
       "        $[byte of \\\\\\x2f]<def>        - a backslash \\ or forw. slash /\n"
       "        $[bytes of \\r\\n \\t]<def>      - whitespace incl. line ends\n"
       "        $[bytes of (\\r\\n \\t)]<def>    - the same, () are optional\n"
       "        $[bytes not \\r\\n\\0]<def>      - up to 4000 bytes as long as no\n"
       "                                  CR, LF or NULL byte appears\n"
       );
printx("        $[chars]<def>                 - the same as $[bytes not \\r\\n\\0]<def>,\n"
       "                                  i.e. collect text in a line\n"
       "        $[char not ( \\t)]<def>        - same as $[byte not ( \\r\\n\\0\\t)]<def>,\n"
       "                                  everything not blanks and tabs\n"
       "        $[char not )( \\t]<def>        - not brackets, blanks and tabs,\n"
       "                                  same as $not (\\(\\) \\t)<def>\n"
       "        $[chars of a-z0-9]<def>       - means a-zA-Z0-9 as search is\n"
       "                                  case insensitive by default\n"
       "        $[chars of \\x61-\\x7A]<def>    - search a-z but not A-Z, or use\n"
       "                                  option -case for case search\n"
    // "        $[others]<def>                - all chars or bytes NOT searched\n"
    // "                                  by previous part\n"
       "        $[eol]<def>                   - end of line by characters:\n"
       "                                  CRLF or LF or CR\n"
    // "        $[start or byte of \\r\\n]<def> - start of file or CR or LF.\n"
    // "        $[end or byte of \\r\\n]<def>   - end of file or CR or LF.\n"
       "\n"
       );
printx("        $[white]<def>     = chars of (\\t )     - 0 or more whitespaces\n"
       "        $[xwhite]<def>    = bytes of (\\t \\r\\n) - same but across lines\n"
       "        $[1 white]<def>   = byte  of (\\t )     - 1 whitespace\n"
       "        $[digit]<def>     = byte  of (0-9)     - 1 digit\n"
       "        $[digits]<def>    = bytes of (0-9)     - 0 or more digits\n"
       "        $[hexdigit]<def>  = byte  of (0-9a-f)  - 1 hexadecimal digit\n"
       "        $[hexdigits]<def>  = bytes of (0-9a-f) - 0 or more hex digits\n"
       "\n"
       );
#ifdef SFK_LOR
printx("        special keywords that do not count as tokens:\n"
       "        $[skip]<def>   - at the start of a pattern: skip such text\n"
       "                   completely, do not count it as a search hit.\n"
       "        $[keep]<def>   - search also the following text but keep it\n"
       "                   in the input data, without consuming it.\n"
       "        $[ortext]<def> - foo[ortext]bar searches word foo or bar.\n"
       "                   [ortext] is allowed only between literals.\n"
       "\n"
       );
#endif // SFK_LOR
printx("        anchors that have no length of their own:\n"
       "        $[start]<def>  - start of file\n"
       "        $[end]<def>    - end of file\n"
       "        $[lstart]<def> - line start, i.e. start or CRLF or CR or LF\n"
       "        $[lend]<def>   - logical line end, i.e. eol or end of file.\n"
       "                   to replace line ends use [eol] instead.\n"
       "\n"
       );
printx("        $how to search or replace special characters:\n"
       "        -  to search or replace text containing the literal characters\n"
       "           $* ? \\ [ ]<def> then these must be escaped like #\\\\* \\? \\\\ \\[ \\]<def>\n"
       "        -  $( )<def> are escaped only within character lists, like #\\( \\)<def>\n"
       "        -  to search or replace the $forward slash '/'<def> type $\\x2f<def> or use\n"
       "           another char around from/to text, e.g. #_fromtext_totext_<def>\n"
       "        -  parameters with #blanks and non trivial characters<def> need double\n"
       "           quotes \"\", see also \"about Shell Command Characters\" below.\n"
       "\n"
       );
printx("        $expansion priorities:<def> (highest first)\n"
       "        if two search parts are side by side, and the same input\n"
       "        character matches both, then these priorities apply:\n"
       "\n"
       "          5:  start, end, lstart, lend\n"
       "          4:  literal text, eol\n"
       "          3:  whitelist classes: byte of, bytes of\n"
       "          2:  blacklist classes: chars not, bytes not\n"
       "          1:  plain wildcards: ?, *, **, byte, bytes, chars\n"
       "\n"
       "        this means in \"/[bytes]foo/\" the [bytes] will stop to collect\n"
       "        characters as soon as \"foo\" is found, as \"foo\" is a literal.\n"
       "        on same or higher priority the right side stops the left side.\n"
       "\n"
       );
printx("        #avoid overlapping character groups.<def> for example, $[chars][white]<def>\n"
       "        cannot work, as space and tab are part of chars. to fix this\n"
       "        extend chars by relevant exclusions: $[chars not ( \\t)][white]<def>\n"
       "\n"
       );
if (bRepHelp)
printx("      $the #totext<def> $may contain:\n"
       "\n"
       "        $[part 1]<def>            use first text part of the fromtext.\n"
       "                            e.g. the fromtext #/*foo[.100 chars]bar*/<def>\n"
       "                            contains parts :  # 1 2         3    4 5\n"
       "        $[part1]<def>             the same (blank is optional).\n"
       "        $[parts 1,2,3]<def>       use parts 1, 2 and 3.\n"
       "        $[parts 1-10]<def>        use parts 1 to 10.\n"
       "        $[strip(part1,\\0)]<def>   use part 1 but remove zero bytes.\n"
       "                            only zero bytes \"\\0\" can be removed.\n"
       "        $[file.name]<def>         full input filename with path\n"
       "        $[file.relname]<def>      input filename without path\n"
       "        $[file.path]<def>         input file's path\n"
       "        $[file.base]<def>         relname without last .extension\n"
       "        $[file.ext]<def>          input filename extension\n"
       "        $[all]<def>               use all parts from fromtext.\n"
       "\n"
       "        $[setvar name]...[endvar]<def>   set variable \"name\" with data\n"
       "                                   between setvar and endvar.\n"
       "        $[getvar name]<def>              fill in data from variable \"name\"\n"
       "\n"
       "        although anchors like lstart, lend count as a separate part\n"
       "        they need NOT be specified in the totext. this means that\n"
       "        /[lstart]foo[lend]/bar/ just changes the word \"foo\".\n"
       "\n"
       );
if (bRepHelp)
printx("      #if replace looses line endings in output\n"
       "      - when using $[eol]<def> in most cases you should add $[part...]<def>\n"
       "        to the output pattern, to copy the actual found line\n"
       "        separators, or line endings may get lost.\n"
       "\n"
       );
printx("   $supported slash patterns\n"
       "      $\\t<def>    = TAB\n"
       "      $\\r<def>    = CR\n"
       "      $\\n<def>    = LF\n"
       "      $\\x00<def>  = one byte with code 00 hexadecimal\n"
       "      $\\0<def>    = short form for \\x00\n"
       "      $\\q<def>    = a double quote \"\n"
       "      $\\\\ <def>   = the backslash character \\ itself\n"
       "      $\\[<def>    = the bracket open character [\n"
       "      $\\]<def>    = the bracket close character ]\n"
       "      $\\\\*<def>    = the literal star character *\n"
       "      $\\?<def>    = the literal question mark  ?\n"
       "      $\\-<def>    = to use literal \"-\" in a command\n"
       "      Within multi line -bylist files:\n"
       "      $\\ <def>    = slash+blank is changed to a single blank\n"
       "      Only within \"char of\" or \"byte not\" lists:\n"
       "      $\\(<def>    = to use literal character \"(\"\n"
       "      $\\)<def>    = to use literal character \")\"\n"
       "\n"
       );
printx("   $SFK expression options\n"
       "      -showpart(s)  print /from/ part numbers, range statistics\n"
       "                    and expansion priority points per part.\n"
       "                    done automatically if a required /to/ text\n"
       "                    is not given with a command.\n"
       "      -showbest     if a /from/ pattern finds nothing, use this to\n"
       "                    see how many parts would match so far, and with\n"
       "                    up to how many bytes per part. anchors like [lstart]\n"
       "                    may show a non zero length when matching (CR)LF.\n"
       "      -showlist     with -bylist, show the internal joined list if\n"
       "                    commands are spread across multiple lines.\n"
       "      -showall      show all of the above.\n"
       "      -xmaxlen=n    set default maximum length for chars or bytes commands,\n"
       "                    e.g. -xmaxlen=10000 means /foo*bar/ matches with up to\n"
       "                    10000 characters between foo and bar. the default max\n"
       "                    length without this option is 4000 characters.\n"
       "\n"
       );
printx("   $performance notes\n"
       "    - always use a string literal, or single byte or char, at the start\n"
       "      of your search expressions, like in $/foo*bar/ starting with 'f'.\n"
       "      #Do not use a wildcard like * at the start like in #/*foobar/<def>\n"
       "      when searching huge input data, as your search will #slow down by\n"
       "      #factor 256.<def> Use $/[lstart]*foobar/<def> instead.\n"
       "    - the system may cache output file(s), writing to disk in background\n"
       "      after sfk has finished. subsequent batch commands may execute slower.\n"
       "\n"
       );
}

void printAboutBracketExamples()
{
printx("   $about example numbers with [brackets]\n"
       "      if you see [1] type \"sfk cmd 1\" for whole command in one line.\n"
       "\n");
}

void printXRepExamples(char *pszCmd, bool bFind, bool bRep)
{
printAboutBracketExamples();
printx("   $bad examples with corrections\n"
       "      #if input text contains:\n"
       "         bool bClFoo;\n"
       "         bool bClBar   ;\n"
       "      #sfk xfind in.txt \"/bool[xwhite]bCl*[xwhite];/\"\n"
       "         does NOT match \"bool bClFoo;\" because * eats the\n"
       "         whole input line including \";\" so no input is left\n"
       "         for \"[xwhite];\" and the whole expression fails.\n"
       "      #sfk xfind in.txt \"/bool[xwhite]bCl[* not ;][xwhite];/\"\n"
       "         does both match \"bool bClFoo;\" and \"bool bClBar   ;\".\n"
       "         this means whenever your search fails to work write\n"
       "         in detail which characters (not) to collect where.\n"
       "      #sfk xex in.txt \"/[lstart]foo/[lstart]goo/\"\n"
       "         there is no need to write an anchor like [lstart]\n"
       "         within totext as it contains no data. use instead:\n"
       "            sfk xex in.txt \"/[lstart]foo/goo/\"\n"
       "      #sfk xex in.txt \"/foo[lend]bar/goo[part2]bar/\"\n"
       "         anchors like [lend] must be at start or end of fromtext\n"
       "         and cannot be referenced within totext. use instead:\n"
       "            sfk xex in.txt \"/foo[eol]bar/goo[part2]bar/\"\n"
       "\n"
       );

printx("   $working examples\n");

if (bRep)
{
printx("      #sfk xrep mydir \"/foo*bar/\"\n"
       "         an incomplete command (missing \"totext\" part in pattern).\n"
       "         sfk shows an info text telling about part numbers\n"
       "         and runs a search for \"foo*bar\" in all files of mydir.\n"
       "         nothing is changed so far.\n"
       "      #sfk xrep mydir \"/foo*bar/[part1]goo[part3]/\"\n"
       "         same as above, but now the /fromtext/totext/ is complete.\n"
       "         again sfk runs a search for \"foo*bar\", but now it displays\n"
       "         the changed output text (totext), with everything between\n"
       "         \"foo\" and \"bar\" being changed to \"goo\". add option\n"
       "         -dumpfrom to display the original found text instead.\n"
       "      #sfk sel mydir .txt +xrep \"/foo*bar/[part1]goo[part3]/\"\n"
       "         similar to above, replace in all .txt files of mydir.\n"
       "      #sfk xrep -text \"/class* CFoo/[part1][part3]/\" -dir mydir -file .hpp\n"
       "         search only .hpp files within mydir, and replace for example\n"
       "         \"class IMPORT CFoo\" by \"class CFoo\".\n"
       "      #sfk xrep -pat \"/[byte not \\n][end]/[part1]\\n/\"\n"
       "       #-dir mydir -file .cpp .hpp -dumpall\n"
       "         find all .cpp or .hpp files in mydir whose last line is not\n"
       "         ending with a linefeed, and add the linefeed. to check exactly\n"
       "         what is changed dump both input and output text. [23]\n"
       "      #sfk xrep -dir mydir -file .hpp -enddir\n"
       "       #-text \"/[byte not \\n][end]/[part1]\\n/\" -dumpall\n"
       "         same as above but with dir parameters first. [25]\n"
       "      #sfk xrep io.txt \"/[lstart][20 chars]*/[part3]/\"\n"
       "         cut first 20 characters in every line of io.txt.\n"
       );
printx("      #sfk xrep io.txt \"/[lstart][9 bytes]1001*/[part2]9009[part4]/\"\n"
       "         in fixed position text file data like:\n"
       "            rec. 001:5318 aef3 2751 1001\n"
       "            rec. 002:1001 aef5 275a 1001\n"
       "            rec. 003:ef49 aef7 2763 1001\n"
       "         replace \"1001\" where it appears in columns 10 to 13,\n"
       "         in this example only the first \"1001\" in record 2.\n");
printx("      #sfk xrep in.dat \"/\\xFF\\xFE[1 byte]\\x80\\x81/\\xFF\\xFE\\x00\\x80\\x81/\"\n"
       "         replace byte sequences (not ASCII text strings) in binary data.\n"
       "         searches byte groups starting with values 0xFF 0xFE, then any\n"
       "         single byte, then 0x80 0x81, and replaces the variable byte\n"
       "         by always a binary 0x00 value.\n"
       );
}
if (bFind)
{
printx("      #sfk xfind -text \"/class [bytes]{[bytes]}/[all]\\n\\n/\"\n"
       "       #-dir mydir -file .hpp +tofile out.txt\n"
       "         collect class definitions from mydir and write output\n"
       "         indirectly (via command chaining) to out.txt [13]\n");
printx("      #sfk xfind in.txt -text \"/foo*bar/\"\n"
       "         search in.txt for patterns starting with foo and ending\n"
       "         with bar, in the same line, with up to 4000 characters inbetween.\n");
#ifdef _WIN32
printx("      #sfk xfind in.txt -text \"/foo*bar/\" +view\n"
       "         same as above, but show the result in the depeche view\n"
       "         text browser tool for easy reading.\n");
#endif
printx("      #sfk xhex -text \"/foo[0.100000 bytes]bar/\" -dir mydir\n"
       "         search all text and binary files of mydir for patterns of\n"
       "         foo and bar with 0 to 100000 bytes (including NULL, CR\n"
       "         and LF) inbetween and print output as hex dump.\n"
       "      #sfk xfind -text \"/printf(**);/\" -dir mydir -file .cpp\n"
       "         find all printf statements in source code, including statements\n"
       "         across multiple lines.\n");
}
}

// for filter
void printBewareWide( )
{
   printx("   $beware of Shell Command Characters.\n" // filter, wide
          "      to find or replace text containing #spaces<def> or special characters like #<>|!&?*<def>\n"
          "      you #must add quotes \"\" around parameters or the shell will #destroy your command<def>.\n"
          "      it splits the command into parts and gives SFK only one part, causing errors.\n"
          "      therefore #-replace _ _&nbsp;_<def> must be written like: #-replace \"_ _&nbsp;_\"\n"
          #ifdef _WIN32
          "      within a $.bat or .cmd file<def> the #percent %%<def> must be escaped like #%%%%<def> even\n"
          "      within quoted strings: #sfk echo -spat \"percent %%%% is a percent \\x25\"<def>\n"
          #else
          "      within a $bash batch file the #dollar $$ must<def> be escaped like #\\$$<def> even\n"
          "      within quoted strings: #sfk echo -spat \"dollar \\$$ is a dollar \\x24\"<def>\n"
          #endif
          "\n"
          );
}

// for replace, xed
void printBewareLean( )
{
   printx("   $beware of Shell Command Characters.\n" // replace, lean
          "      to find or replace text patterns containing #spaces<def> or special\n"
          "      characters like #<>|!&?*<def> you #must add quotes \"\"<def> around parameters\n"
          "      or the shell environment will #destroy your command<def>. for example,\n"
          "      pattern #/foo bar/other/<def> must be written like #\"/foo bar/other/\"\n"
          #ifdef _WIN32
          "      within a $.bat or .cmd file<def> the #percent %%<def> must be escaped like #%%%%<def>\n"
          "      even within quotes: #sfk echo -spat \"percent %%%% is a percent \\x25\"<def>\n"
          #else
          "      within a $bash batch file the #dollar $$ must<def> be escaped like #\\$$<def> even\n"
          "      within quoted strings: #sfk echo -spat \"dollar \\$$ is a dollar \\x24\"<def>\n"
          #endif
          "\n"
          );
}

extern int  nGlblConsColumns;
extern int  bGlblConsColumnsSet;
extern cchar *officeExtList[];

void webref(cchar *pszIn);
void arcinf(int iind);

void printHelpText(cchar *pszSub, bool bhelp, int bext)
{
   #ifdef SFKOFFICE
   if (!strcmp(pszSub, "office"))
   {
      printx("$sfk office file support\n"
         "\n"
         "   sfk can read Open Document Format office files,\n"
         "   which are a standard since 2007, with these\n"
         "   filename extensions:\n"
         "\n");
      strcpy(szLineBuf, "   ");
      for (int i=0; officeExtList[i]; i++) {
         mystrcatf(szLineBuf, MAX_LINE_LEN, "%s ", officeExtList[i]);
         if ((i&7)==7) {
            printx("%s\n",szLineBuf);
            strcpy(szLineBuf, "   ");
         }
      }
      printx("%s\n",szLineBuf);

      printx("\n"
             "   sfk can $not<def> read older office file formats\n"
             "   like .doc .xls or .ppt.\n"
             );

      printx("\n"
         "   $supported commands:\n"
         "\n"
         "     #sfk olist mydir\n"
         "        list all office files in folder mydir.\n"
         "\n"
         "     #sfk ofind mydir \"/myword/\"\n"
         "        search office and plain text files in mydir\n"
         "        containing the word 'myword'.\n"
         "\n"
         "     #sfk ofind mydir \"/foo*bar/\"\n"
         "        search foo followed by bar in the same line.\n"
         "        for more infos type: #sfk ofind\n"
         "\n"
         "     #sfk ofilter in.xlsx -+foo\n"
         "        filter content of a spreadsheet table\n"
         "        for lines containing 'foo'\n"
         "        for more infos type: #sfk ofilter\n"
         "\n"
         "     #sfk oload in.xlsx\n"
         "        load and display content of in.xlsx\n"
         "\n"
         "     #sfk oload in.xlsx +xex \"/*\\tapple\\t/*\"\n"
         "        find fields containing just 'apple'\n"
         "        and get the whole row around.\n"
         "\n"
         "     #sfk oload in.xlsx +filt -spat -+\\tapple\\t\n"
         "        same as above, using +filter.\n"
         "        for more infos type: #sfk oload\n"
         "\n"
         "     #sfk snapto=alldoc.txt -office mydir\n"
         "        collect plain text, and text from office\n"
         "        files like .docx .xlsx .odt .ods,\n"
         "        from folder mydir into one file alldoc.txt\n"
         "     #sfk find alldoc.txt foo bar\n"
         "        search alldoc.txt for lines containing\n"
         "        the words foo and bar\n"
         "     #dview alldoc.txt\n"
         "        browse and search alldoc.txt interactively\n"
         "        with the Depeche View text file browser.\n"
         "        for details see: #sfk view\n"
         "\n"
         "     #sfk list mydir +fview -office\n"
         "        similar to above, view office file contents\n"
         "        and plain text contents in mydir, all in one\n"
         "        window using Depeche View (dview.exe)\n"
         "\n"
         "     #dview -office mydir\n"
         "        same as before, using dview directly.\n"
         "        for more infos type: #sfk view\n"
         "\n"
         "     #sfk unzip in.xlsx -todir tmp\n"
         "        extract all contents of in.xlsx\n"
         "        into a folder tmp. -todir is important\n"
         "        otherwise you end up with many files\n"
         "        in the current folder.\n"
         "\n"
         "     #sfk zip -rel out.xlsx tmp\n"
         "        recreate an office file out.xlsx\n"
         "        from all contents in tmp.\n"
         "        -rel is important to strip folder\n"
         "        name 'tmp' from the content filenames.\n"
         "\n");

      /*
      printx(
         "   $search office files interactively with DView\n"
         "     the GUI tool Depeche View can browse and\n"
         "     search text from office files directly.\n"
         "     for details type: #sfk view\n"
         "\n");

      printx(
         "   $special options:\n"
         "\n"
         "     $-names<def>   with ofind: list base filenames\n"
         "              of matching office files, for example\n"
         "              $mydir\\foo1.xlsx\n"
         "              for subsequent use with +copy or\n"
         "              other commands using the whole file\n"
         "\n"
         "     $-names2<def>  with ofind: list full content\n"
         "              filenames in matching files, like\n"
         "              $mydir\\foo1.xlsx\\\\xl\\workbook.xml\n"
         "              for further use with +ffilter or +xex\n"
         "              commands which read text content\n"
         "\n"
         "     $-crc<def>     with olist: also show crc\n"
         "              checksums of office file contents\n"
         "\n"
         "     $-crc=x<def>   with olist: list only office\n"
         "              file contents matching crc x.\n"
         "              allows to search, for example,\n"
         "              in which files a logo image is used.\n"
         "\n"
         "     $-office[2]<def>  enable office file content\n"
         "              reading with other commands, e.g.\n"
         "              #sfk index -office2 mydir\n"
         "              creates an index of mydir listing\n"
         "              all office contents in detail.\n"
         "\n"
         );
      */
   }
   #endif // SFKOFFICE

   if (!strcmp(pszSub, "xe"))
   {

      #ifndef VFILEMAX
      printx("<help>$about sfk xe:\n",
             bhelp ? " (type \"sfk help xe\")":"");
      printx("\n"
         "   Swiss File Knife Extended Edition (SFK XE) is a commercial\n"
         "   edition of SFK, available from StahlWorks Technologies.\n"
         );
      printx("\n"
         " $SFK XE Archive File Content Reading\n"
         "\n"
         "   Swiss File Knife Extended Edition features full content\n"
         "   reading of zip, tar and tar.gz files. Zip files are\n"
         "   detected by file extension or optional content scanning.\n"
         "   For the full list of directly supported zip file extensions\n"
         "   type \"sfk help opt\" and read more under option -arc.\n"
         "\n"
         "   sfk xe can not only read top-level contents of a zip,\n"
         "   but also contents of zips embedded within other zips,\n"
         "   e.g. jar archives within a zip package.\n"
         "\n"
         "   under xe, the following commands provide zip processing:\n"
         "\n"
         "      find, findbin, hexfind, xfind, xfindbin, xhexfind,\n"
         "      extract, list, filter, snapto\n"
         "\n"
         "   as usual, the output of such commands (text streams or filename lists)\n"
         "   can be processed by subsequent chain commands, just as with sfk base.\n"
         "\n"
         "   $LIMITATIONS:\n"
         "\n"
         "    - sfk xe can NOT extract office file text content embedded\n"
         "      in archive files, like in myarc.zip\\\\mytext.docx\n"
         "      i.e. it can do exactly the same office search as sfk base\n"
         "      but not more. xe can search raw xml data embedded in\n"
         "      nested archives, though, using xfind -arc\n"
         "\n"
         "    - zip file contents #must fit completely into memory<def>.\n"
         "      in general, zip files below 100 mb should be ok.\n"
         "      contents larger then the current -memlimit (default: 300mb)\n"
         "      will be skipped. if you increase the -memlimit, your machine\n"
         "      must have enough memory, or sfk may run endless or even crash.\n"
         "\n"
         "    - multi-part archives (split zip files) are #not<def> supported.\n"
         "      the whole content of a zip archive must be provided in one file.\n"
         "\n"
         "    - the zip files must use a #normal compression format (%s%s)<def>,\n"
         "      e.g. as it is produced by the InfoZIP or WinZIP tool.\n"
         "      (most zip files in the internet use normal compression.)\n"
         "      exotic compressions and 64-bit zip files are NOT supported.\n"
         "\n"
         "    - time or attribute informations (sfk list -time ...) of zip\n"
         "      file entries may be inaccurate or missing, all you get is\n"
         "      the actual contents (zip file entry data) for processing.\n"
         , "de", "flate"
         );


      printx("\n"
         "   $examples\n"
         "\n"
         "      #sfk list -arc -time -size -tofile lslrx .\n"
         "         list all files, all contents of zip, jar etc. archives,\n"
         "         and all files of archives contained within archives,\n"
         "         creating one large file list within file \"lslrx\".\n"
         "         type \"sfk list\" to get more infos on that example.\n"
         "\n"
         "      #sfk filt -arc \"-ls+public class\" -dir src.zip -file .java\n"
         "         find public classes in all .java files of src.zip\n"
         );

      printx("\n"
         " $SFK XE Fast Replace\n"
         "\n"
         "   Swiss File Knife Extended Edition contains a different\n"
         "   implementation of the replace command, allowing high speed\n"
         "   different-length replacements in large files. It can replace\n"
         "   directly from one file to another file, or use temporary files\n"
         "   to store the output intermediately. This means the file size\n"
         "   is not limited by the available memory, and even files with\n"
         "   many gigabytes of size can be processed.\n"
         );
 
      printx("\n"
         " $SFK XE Replace with Wildcards and SFK Expressions\n"
         "\n"
         "   Swiss File Knife Extended Edition contains command $xreplace<def>\n"
         "   supporting $wildcards * and ?<def> as well as $SFK Expressions<def>\n"
         "   $within brackets []<def>. SFK Expressions are NOT regular expressions\n"
         "   but use a simpler, human readable syntax.\n"
         "   Type #sfk help xpat<def> for the full SFK Expression syntax.\n"
         );

      printx("\n"
         "   $SFK Extended Edition is available from:\n"
         "\n"
         "      http://stahlworks.com/\n"
         "\n"
         );
      #endif


      return;
   }

   if (!strcmp(pszSub, "ftpprot"))
   {
      printx(
         #ifdef _WIN32
         "   $transfer protocol selection\n"
         "      since SFK 1.8.5, when using \"sfk ftpserv\" at the server\n"
         "      and \"sfk ftp\" at the windows client, plain FTP protocol\n"
         "      is used to avoid firewall restrictions via port 21.\n"
         "      to use SFT Simple File Transfer for better connectivity\n"
         "      and cput/cget support run the server as \"sfk sftserv\"\n"
         "      and the client as \"sfk sft\", which will use port 2121.\n"
         "\n"
         #endif
         "   $file attributes\n"
         "      since SFK 1.6.7, when using the SFT protocol,\n"
         "      linux file attributes are sent and written at the receiver,\n"
         "      except for file owner 'rw' flags which are set by default\n"
         "      to allow rewrite in future transfers. when sending from\n"
         "      linux to windows attributes like 'x' get lost.\n"
         "\n");
      return;
   }

   if (!strcmp(pszSub, "dupfind"))
   {
      printx("<help>$sfk dupfind -dir anydir [-file .ext1 .ext2]\n"
             "\n"
             "   find and list duplicate files, just by file content,\n"
             "   independent from filename. searches for files with same\n"
             "   size and then compares contents by md5 checksums.\n"
             "\n"
             "   $options\n"
             "      -diffdirs    list only duplicates residing in different\n"
             "                   root directories. this option requires that\n"
             "                   you specify at least two dirs after -dir.\n"
             "      -listorg     list all original filenames,\n"
             "                   leave out any duplicate filenames.\n"
             "      -minsize=n   compare only files with size >= n.\n"
             "                   examples for n are:\n"
             "                      5m = 5000000 bytes (5 mbytes)\n"
             "                    100k =  100000 bytes (5 kbytes)\n"
             "                      1M = 1048576 bytes (2<<20 bytes)\n"
             "                   9000b =    9000 bytes\n"
             "\n"
             "   $command chaining\n"
             "      - by default, this command passes the names\n"
             "        of found duplicate files to the next command.\n"
             "\n"
             "      - option -listorg does the opposite: it passes\n"
             "        only original filenames, but no duplicates,\n"
             "        to the next chain command.\n"
             "\n"
             "   $NOTE:\n"
             "      if identical files are found, the decision what is listed\n"
             "      as \"original\" or \"duplicate\" is currently based on the\n"
             "      order in the file system: the file found first is listed as\n"
             "      \"original\". check carefully if this is what you think,\n"
             "      before cleaning up any duplicates.\n"
             "\n");
      webref("dupfind");
      printx("   $examples\n"
             "      #sfk dupfind .\n"
             "         find all duplicates within the current directory tree.\n"
             "\n"
             "      #sfk dupfind -dir docs1 docs2 docs3\n"
             "         find all dups across and within the given directories.\n"
             "\n"
             "      #sfk dupfind -diffdir -dir docs1 docs2 docs3\n"
             "         find dups between docs1/docs2, docs2/docs3, docs1/docs3,\n"
             "         but does NOT list dups within the same root directory.\n"
             "\n"
             "      #sfk dupfind docs .doc +del\n"
             "         find all duplicate .doc files, within the docs\n"
             "         directory tree, and delete them.\n"
             "\n"
             "      #sfk dupfind -listorg docs .doc +run \"copy <run>file docs2\"\n"
             "         copy all .doc files from docs to docs2,\n"
             "         but leave out any duplicate files.\n"
             "\n"
             "      #sfk dupfind -dir pic1 -dir pic2 -dir pic3\n"
             "         find duplicates across three different directory trees.\n"
             "         specifying multiple -dirs is also a way of influencing\n"
             "         the result order; if a file is found both in pic1 and pic3,\n"
             "         the file from pic1 will be listed as original, the other one\n"
             "         as the duplicate.\n"
             "\n"
             "      #sfk sel -dir pic1 pic2 pic3 -file .jpg +dup -minsize=1m\n"
             "         similar to the above, this example uses command chaining:\n"
             "         list all .jpg files from the pic directories, then pass\n"
             "         this to the dupfind command, also filtering by size.\n"
             );
   }

   if (!strcmp(pszSub, "syncnames"))
   {
      printx("<help>$sfk syncnames [opts] -dir fromdir todir\n"
             "\n"
             "   synchronize folder (and file) name changes\n"
             "   from your local disk to an external backup disk,\n"
             "   without copying files.\n"
             "\n"
             "   #only for use before sfk sync,<def> to avoid long lasting\n"
             "   copy/delete actions on folder name changes.\n"
             "\n"
             "   #Warning: Heuristic command. Wrong renames may occur!<def>\n"
             "\n"
             "   this command may sometimes move/rename wrong files,\n"
             "   especially with option -unsafe and many files of\n"
             "   same size, same start and end, like uncompressed\n"
             "   images, and same creation date.\n"
             "\n"
             "   use it #only with not-so-important data<def> like folders\n"
             "   full of holiday snapshots and videos, where the one\n"
             "   or other misrenamed image or video is not a problem.\n"
             "\n"
             "   #must be followed by sfk sync,<def> on the same folders,\n"
             "   to cleanup possible wrong renames. (no guarantee\n"
             "   that cleanup always works.)\n"
             "\n"
             "   $options for faster processing\n"
             "      -byname   compare relative filenames\n"
             "      -bytime   compare file modification time\n"
             "      -unsafe   do not compare whole file content,\n"
             "                but only first and last 16 kbytes\n"
             "      -log x    log every rename in a logfile\n"
             "\n");
      printx("   $examples\n"
             "\n"
             "      #sfk syncnames -dir d:<sla>pic g:<sla>pic\n"
             "         synchronize name changes that occurred in\n"
             "         hard disk folder D:<sla>pic to backup G:<sla>pic.\n"
             "         takes long, as it compares whole files by crc.\n"
             "\n"
             "      #sfk syncnames -bytime -unsafe -log g:<sla>renlog.txt\n"
             "       #-dir d:<sla>pic g:<sla>pic\n"
             "         same as above, but much faster, as it only\n"
             "         compares file size, file start and end,\n"
             "         as well as file time for a bit more safety.\n"
             "         wrong renames may occur. a logfile renlog.txt\n"
             "         is written for later lookups.\n"
             "\n");
   }

   if (!strcmp(pszSub, "olist"))
   {
      printx("<help>$sfk olist dir\n"
             "\n"
             "   list all office files in a folder.\n"
             "\n"
             "   lists only file types supported by sfk,\n"
             "   like .docx .xlsx .odt .ods\n"
             "\n"
             "   $options\n"
             "      -stat     tell total number of files\n"
             "\n"
             "   $aliases\n"
             "      #sfk odir<def>  also tells statistics\n"
             "\n"
             "   $see also\n"
             "      #sfk list<def>  for further options\n"
             "\n"
             "   $examples\n"
             "      #sfk olist mydir\n"
             "         list all .docx .xlsx .odt .ods and other office\n"
             "         files within folder mydir.\n"
             "\n"
             "      #sfk odir -time -size mydir\n"
             "         list all office files with time, size,\n"
             "         and total number of files info.\n"
             "\n"
             "      #sfk olist mydir foo\n"
             "         list office files of folder mydir having \"foo\"\n"
             "         in their name.\n"
             "\n"
             "      #sfk olist mydir 20230706 +fview -office\n"
             "         show the content of all office files in mydir\n"
             "         having 20230706 in their filename, in a single\n"
             "         window, using Depeche View (dview.exe).\n"
             "\n"
             "      #dview -office mydir 20230706\n"
             "         same as above, using dview directly.\n"
             "         for more infos type: #sfk view\n"
             "\n"
             );
   }

   if (!strcmp(pszSub, "list"))
   {
      printx("<help>$sfk list [-time] [-size|-size=digits] [...] dir [mask]\n"
             "$sfk sel[ect] -dir dir1 dir2 -file .ext1 .ext2 !.ext3 [...]\n"
             "\n"
             "   list all or just selected files from a directory tree.\n"
             "   select is the same, but it ignores command chaining input.\n"
             "\n"
             "   $options\n"
             "      -nosub     do not list sub folder contents\n"
             "      -time      show date and modification time\n"
             "      -flattime  show date and time in a more compact format\n"
             "      -tab       separate columns by tab characters, not blanks\n"
             "      -size[=n]  show size of files [n characters wide]\n"
             "      -kbytes    or -kb lists sizes in kbytes instead of bytes\n"
             "      -mbytes    or -gbytes lists sizes in mbytes or gbytes\n"
             "      -kbpure    list without \"kb\" postfix\n"
             "      -xsize     show mixed size infos depending on file size\n"
             "      -stat      show statistics (number of files, dirs, bytes)\n"
             #ifdef _WIN32
             "                 and tell if hidden files or dirs were skipped.\n"
             #endif
             "      -juststat  show no filenames, just statistics.\n"
             #if (!defined(SFK_LIB5))
             "      -nofollow  or -nofo does not follow symbolic directory links.\n"
             "                 use this if list runs in an endless recursion.\n"
             #endif
             "      -withdirs  list also directories\n"
             "      -justdirs  list just directories\n"
             #ifdef _WIN32
             "      -hidden    list also hidden or system files\n"
             #endif
             #ifndef _WIN32
             "      -verbose   list also non-regular files\n"
             "      -withhead  tell 'listing n of n files' with chaining.\n"
             "      -showskip  tell whenever dir contents are skipped to avoid\n"
             "                 double processing caused by symbolic links.\n"
             "      -allowdups disable detection of duplicate dir contents.\n"
             #endif
             "      -sort[=n]  sort by name, list all or last n files\n"
             "      -sortrev   sort by name, in reverse order\n"
             "      -late[=n]  sort by time, list latest   [n] files last\n"
             "      -old[=n]   sort by time, list oldest   [n] files last\n"
             "      -big[=n]   sort by size, list biggest  [n] files last\n"
             "      -small[=n]   sort by size, list smallest [n] files last\n"
             "      -skiplate=n  sort by time, select all except newest n\n"
             );
      printx("      -minsize=s   list only files >= size, like 10b or 100k\n"
             "      -maxsize=s   list only files <= size, like 10m or 4g\n"
             "                   b=bytes k=kbytes m=megabytes g=gigabytes\n"
             "      -late=all  sort by time, list all files\n"
             "      -notime    don't list time, after -late or -old\n"
             "      -nosize    don't list size, after -big  or -small\n"
             "      -pure      pure list of filenames, leave out time, size,\n"
             "                 headline or statistics.\n"
             "      -quot      surround filenames by double quotes. needed when\n"
             "                 post-processing filename lists containing blanks.\n"
             "      -quiet     do not show the \"scan\" progress information\n"
             );
      printx("      -since     list only files since this timestamp, e.g.\n"
             "                 \"2006-01-31 12:15:59\" or 20060131121559,\n"
             "                 2006-01-31 or 20060131.\n"
             "                 today: files changed since midnight of today.\n"
             "                 1d: changed since 1 day, i.e. not counting\n"
             "                 from midnight, but 24 hours into the past.\n"
             "                 5h, 30m, 10s : 5 hours, 30 minutes, 10 seconds.\n"
             "      -before    select files modified before that timestamp.\n"
             "      -today     short replacement for \"-since today\".\n"
             "      -usectime  use or list creation time instead of modification time.\n"
             "                 may not be available on some filesystems.\n"
             "      -utc       or -gmt lists UTC/GMT time instead of local time.\n"
             "      -sincedir  compare against another directory, list files that\n"
             "       or -sd    have been added, have different time, or content.\n"
             "                 does not list files which have been removed.\n"
             "      -sinceadd  like -sincedir, list only added files.\n"
             "      -sincedif  like -sincedir, list only changed files.\n"
             "                 does not list files with diff. time but same content.\n"
             "                 does not list added files.\n"
             "      -sincechg  list files with different content, and added files.\n"
             "       or -sc    does not list files with diff. time but same content.\n"
             "      -ignoretime  by default -sincedir does not compare content of\n"
             "                   files with equal size and time. force a deep\n"
             "                   compare of all files with this option.\n"
      //     "      -incref    include names listed after -dir in sincedir references.\n"
      //     "      -verbose   lists non-existing reference directory names.\n"
             );
      printx("      -relnames  list filenames relative to specified directory(s),\n"
             "                 i.e. strip root directory names at the beginning.\n"
             "      -abs[olute]   list all filenames with full absolute path.\n"
             "      -tofile x  write all names directly to file x (using less memory\n"
             "                 than the chain command +tofile x).\n"
             "      -maxfiles=n      list a maximum of n files only.\n"
             "      -fileoff[set]=n  from all selected files, list only a subset,\n"
             "                 starting at index n. first file has index 0.\n"
             #ifdef _WIN32
             "      -upat      unix style exclusion syntax with : instead of !\n"
             "                 e.g. -subdir :/tmp does the same as -subdir !\\tmp\n"
             "      -upat2     also support wildcard %% instead of *\n"
             #endif
             "      -tomake .ext<def>  select only files that have no, or an older,\n"
             "                    counterpart file with extension .ext\n"
             "                    in the same folder.\n"
             "      -tomake outdir<sla><run>base.ext<def>  select only files that have no or\n"
             "                 an older counterpart file in outdir with .ext.\n"
             "                 see \"sfk run\" for example: .wav to .mp3 conversion\n"
             "\n");
      printx("   $important details of file name / extension selection:\n"
             "      - when specifying a filename pattern beginning with a dot \".\"\n"
             "        and no wildcard, only files with this extension will be selected.\n"
             "      - otherwise the pattern is searched anywhere within the filename.\n"
             "        to force a filename start comparison, say <sla>pattern (with a slash).\n"
             "      - filename means the relative filename, not directory or path name.\n"
             );
      printx("\n"
             "   $command chaining difference between list and select:\n"
             "      +list accepts files from previous commands. +select ignores them,\n"
             "      allowing scripts to run many independent selects in one chain.\n"
             );
             #ifdef VFILEBASE
      if (cs.xelike)
      printx("\n"
             "   $no default archive content processing:\n"
             "      .zip .jar .tar .tgz .bz2 archive contents are NOT listed by default,\n"
             "      as this is not desirable if you just want a quick dir tree overview.\n"
             "      specify -arc or -qarc to activate archive content listing.\n"
             "      type \"sfk help opt\" to list all supported archive extensions.\n");
             #endif // VFILEBASE
      printx("\n"
             "   $return codes for batch files\n"
             "      0   nothing found\n"
             "      1   any files or dirs found\n");
      #ifdef SFKOFFICE
      /*
      printx("\n"
             "   $office file support\n"
             "      #sfk olist<def>        list all contents within office files\n"
             "                       like .docx .xlsx .ods .odt etc.\n"
             "      #sfk help office<def>  for more infos and options\n"
             );
      */
      #endif // SFKOFFICE
      if (bhelp || !bext)
      {
      printx("\n"
             "   $aliases\n"
             "      #sfk dir<def>          same as \"sfk list -stat\".\n"
             "      #sfk select<def>       same as list, but ignoring chain input.\n"
             "      #sfk larc<def>         same as \"sfk list -arc\".\n"
             "      #sfk late<def>         same as \"sfk list -late\".\n"
             "      #sfk today<def>        same as \"sfk list -today\".\n"
             "      #sfk big<def>          same as \"sfk list -big\".\n"
             "      #sfk old<def>          same as \"sfk list -old\".\n"
             "      #sfk small<def>        same as \"sfk list -small\".\n"
             "      #sfk times<def>        same as \"sfk list -times\".\n"
             );
      printx("\n"
             "   $see also\n"
             "      #sfk help select<def>  the sfk file selection syntax.\n"
             "      #sfk help opt<def>     for further general options.\n"
             "      #sfk stat<def>         to list directory tree sizes.\n"
             "      #sfk filetime<def>     list all times of a file.\n"
             "\n");
      webref("list");
      printx("   $more in the SFK Book\n"
             "      the #SFK Book<def> contains a 60 page tutorial, including\n"
             "      sfk dir and list examples with input, command and output.\n"
             "      type \"#sfk book<def>\" for details.\n"
             "\n"
             );
      printx("   $examples\n"
             "      #sfk list .\n"
             "         list all files of current directory and all subdirectories.\n"
             "      #sfk list mydir <not>.bak <not>.tmp.txt\n"
             "         list all files within mydir, except .bak and .tmp.txt files.\n"
             "      #sfk list -dir . -file foo .htm .java\\%c\n"
             "         this will find and list the following sample filenames:\n"
             "            thefoobar.dat       matches anywhere-pattern \"foo\"\n"
             "            biginfo.htm         matches exact extension  \".htm\"\n"
             "            test.java.9.15      matches anywhere-pattern \".java\\%c\"\n"
             "         the command will NOT list the following sample filenames:\n"
             "            foosys\\thebar.dat   pattern must match filename, not path.\n"
             "            biginfo.html        does not match extension \".htm\"\n"
             "      #sfk list -dir mydir <not>tmp <not><sla>save<sla> -file .txt\n"
             "         list all .txt files within mydir, excluding all sub folders\n"
             "         having \"tmp\" in their name, or called exactly \"save\".\n"
             ,glblWildChar,glblWildChar
             );
      printx("      #sfk alias list = sfk list -noop\n"
             "         after this, just typing \"list\" lists the current directory.\n"
             "      #sfk list -dir src1 -file .cpp -dir src2 -file .hpp\n"
             "         list .cpp files from src1, .hpp files from src2.\n"
             "      #sfk list -dir src \"*examples*\"\n"
             "         list contents of all directories having a name with \"examples\",\n"
             "         located somewhere below src. note that \"*examples*\" defines a\n"
             "         path mask, whereas \"examples\" would be another root directory.\n"
             "         under linux, patterns with a * wildcard MUST have quotes \"\".\n"
             "      #sfk list -late -dir . -sub foo -file .jsp .java\n"
             "         list the most recent .jsp and .java files, in all dirs below\n"
             "         the current one (.) having \"foo\" in their pathname.\n"
             "      #sfk list -late -dir . <wild>foo -file .jsp .java\n"
             "         the same, only shorter to type.\n"
             "      #sfk list -justdirs -dir . <wild>foo<wild> -file .jsp .java\n"
             "         list all folders having \"foo\" in their pathname\n"
             "         and which contain any .jsp or .java files.\n"
             "      #sfk list -sincedir src5 src1 .cpp\n"
             "         provided that directory src5 is an older copy of src1, list the\n"
             "         .cpp files that have been added/changed since src5 was created.\n"
             "      #sfk list -pure -late=30 -quot | zip ..\\update.zip -@\n"
             "         collect the latest 30 files from current dir into a zip file,\n"
             "         using InfoZIP's option \"-@\" to use a filename list from stdin.\n"
             "      #sfk sel src .bak +del\n"
             "         select all .bak files in src, then delete them.\n"
             "      #sfk list -nosub -late mydir +sleep 5000 +loop\n"
             "         list most recent files of mydir every 5 seconds,\n"
             "         excluding all sub folder contents.\n"
             "      #sfk list . .jpg +count\n"
             "         tell the number of .jpg files in current directory tree.\n"
             "      #sfk list soundlib .wav -tomake outdir<sla><run>base.mp3\n"
             "         list all .wav files in folder soundlib that have no\n"
             "         or an older .mp3 file counterpart in folder outdir.\n"
             "         see \"sfk run\" for the full -tomake example.\n"
             "      #sfk load files.txt +list -noerr\n"
             "         from a list of filenames keep only filenames that exist\n"
             );
      printx("      #sfk list -nosub -flattime -tabs . .jpg +filter -stabform\n"
             "       #\"ren <run>qcol3 \\q<run>col1<run>col2-<run>col3\\q\" +run \"<run>text\"\n"
             "         rename all .jpg files in current folder to be prefixed by\n"
             "         their modification time (type whole command in one line). [27]\n"
          // "      #sfk list -withdirs -nosub mydir\n"
          // "         list mydir without going through sub folders,\n"
          // "         but show the contained sub folder names within mydir.\n"
          // "      #sfk list -withdirs -nosub2 mydir\n"
          // "         same as above, but hide all sub folder names.\n"
             #ifdef VFILEBASE
             "      #sfk larc src.zip +view\n"
             "         show content listing of zip file src.zip in Depeche View,\n"
             "         to search filenames interactively (\"sfk view\" for details).\n"
             #endif // VFILEBASE
             "      #sfk times mydir .txt\n"
             "         list times of all .txt files within mydir\n"
             "      #sfk sel -flist mylist.txt -time -size\n"
             "         read filenames from mylist.txt and show their time and size\n"
             );
      printx("      #sfk list <nofo>. >lslr\n"
             "         list files of the current directory and all subdirectories into\n"
             "         an index text file \"lslr\" (named after the unix command \"ls -lR\").\n"
             "         doing this in a root directory may take some while, but afterwards\n"
             "         you will find the location of every file in realtime, by simply\n"
             "         typing \"sfk find lslr your_filename_pattern\".\n"
             "      #sfk list <nofo>-qarc -tofile lslrx .\n"
             "         same as above, but including hidden and system files, as well as\n"
             "         the first content level of every .zip and .jar file. using -tofile\n"
             "         instead of \">lslrx\" redirection allows you to see a progress info.\n"
             "         doing this in a root dir like C:\\ may produce a filename listing\n"
             "         of several hundred MB in size.\n"
             );
      }
      #ifdef SFKOFFICE
      /*
      if (bhelp || bext)
      {
      printx("\n"
             "   $examples\n"
             "      #sfk olist mydir\n"
             "         list normal and office file contents in mydir\n"
             "      #sfk olist -dir mydir -subdir .xlsx\n"
             "         list only office contents in .xlsx files.\n"
             "         technically they are treated as sub directories.\n"
             "      #sfk olist mydir .xlsx\n"
             "         same as above. for your convenience sfk interprets\n"
             "         file pattern .xlsx as -subdir .xlsx\n"
             "      #sfk olist -crc mydir .jpg .jpeg .png\n"
             "         list crc checksums of images in office files in mydir.\n"
             "      #sfk olist -crc=9dad65f6 mydir\n"
             "         list only office file contents matching this crc,\n"
             "         e.g. to search for use of a logo image.\n"
             "      #sfk olist mydir .xml\n"
             "         list only .xml office file contents in mydir\n"
             );
      }
      */
      #endif // SFKOFFICE
   }

   if (!strcmp(pszSub, "filter"))
   {
      bool wfilt = (bext&1)?1:0;
      bool ofilt = (bext&2)?1:0;
      if (!ofilt)
      printx("<help>$sfk filter [fileOrDir] -selectoption(s) -processoption(s)\n"
             "$sfk filt -selectoption(s) -processoption(s) -dir mydir -file .ext1 .ext2\n"
             "$sfk filter [-memlimit=n] -write inoutfile -replacepattern(s)\n");
      printx("$sfk ofilter in.xlsx -+pattern\n"
             "\n"
             "   filter and change text lines, from standard input, or from file(s).\n"
             "   input lines may have a maximum length of %u characters.\n"
             "\n", (uint)(MAX_LINE_LEN-96));
      if (!ofilt)
      printx("   use ofilter to read plain text content from a single office\n"
             "   file like .docx .xls .ods ('sfk help office' for more).\n"
             "\n");
      printx("   $line selection options\n"
             "      -+pat1 -+pat2         include lines containing pat1 OR  pat2\n"
             "      -and+pat1 -and+pat2   include lines containing pat1 AND pat2\n"
             "                            in any order.\n"
             "      \"-+pat1*pat2\"         include lines containing pat1 AND pat2\n"
             "                            in the given order.\n"
             "      -ls+pat1              include lines starting with pat1\n"
             "      -le+pat1 -le+pat2     include lines ending   with pat1 OR pat2\n"
             "      \"-ls+pat1*pat2\"       include starting  pat1 and having pat2\n"
             "      -<not>pat1 -<not>pat2         exclude lines containing pat1 OR  pat2\n"
             "      -ls<not>pat1              exclude lines starting with pat1\n"
             "      -le<not>pat1 -le<not>pat2     exclude lines ending with pat1 or pat2\n"
             "      -no-empty-lines       exclude empty lines\n"
             "      -no-blank-lines       exclude lines containing just whitespaces\n"
             "      -inc[lude] p1 to p2   include only lines within blocks surrounded by\n"
             "                            boundary lines containing patterns p1 or p2\n"
             "      -inc-      p1 to p2   same, but exclude boundary lines on output\n"
             "      -cut[-]    p1 to p2   remove block of lines from p1 until p2\n"
             "      -inc[-]    \"*\" to p1  include all from text start until marker\n"
             "      -cut[-]    p1 to \"*\"  cut all from marker line until end of text\n"
             "      -head=n               read only first n lines of text files\n"
             "      -tail=n               read only last n lines of text files\n"
             "                            (up to a limit of %d bytes from file end)\n"
             "      -line=n               read only nth line from input\n"
             "      -skipfirst=n          skip first n lines. warns on hard wrap.\n"
             "      -force                accept hard wrapped lines with -skipfirst\n"
             "      -nocheck              with inc, cut: ignore endings without a start\n"
             "      -addmark txt          with inc, cut: insert txt after every block\n"
             "      -context=n            select n lines of context around hit lines\n"
             "      -precon=5:blue        select context before or after hit lines,\n"
             "      -postcon=5:cyan:---   in blue or cyan, with separator \"---\".\n"
             "      -unique [-case]       if same line occurs twice, keep only first.\n"
             "                            default is case insensitive text comparison.\n"
             "      -global-unique        when filtering multiple files in one command,\n"
             "         then -unique applies to lines in the same file, and -global-unique\n"
             "         applies across all files. this will cache the text of all files in\n"
             "         memory and may not be used with very large files.\n"
             "      -keep pattern         after -unique: make an exception for lines\n"
             "         containing the given pattern, and keep them even if redundant.\n"
             "      -keep-empty, -keep-blank always keep empty or whitespace lines.\n"
             "\n", (int)MAX_ABBUF_SIZE);
      printx("   $text processing options\n"
             "      applied <err>after<def> line selection options only.\n"
             "      -rep[lace] _src_dest_\n"
             "         replace string src by dest. first character is separator character (e.g. _).\n"
             "         src is case-insensitive. to select case-sensitive search, say -case.\n"
             "      -lsrep[lace], -lerep[lace]\n"
             "         same as -replace, but replaces only once at line start or line end.\n"
             "      -high[light] color pattern : highlight matching parts within lines.\n"
             "         color: red = dark red, Red = bright red, green, blue,\n"
             "                yellow, cyan, magenta, default.\n"
             "         pattern: e.g. \"GET * HTTP/\"\n"
             "         type \"sfk help colors\" for more about colors.\n"
             "      -lshigh[light], -lehigh[light]\n"
             "         same as -highlight, but only at line start or line end.\n"
             );
      printx("      -sep[arate] \"; \" -form \"<run>col1 mytext <run>[-0n.nq]col2 ...\"\n"
             "         break every line into columns separated by any character listed after -sep,\n"
             "         then reformat the text according to a user-defined mask similar to printf.\n"
             "         when leaving out -sep, the whole line is packed into column 1. if -spat was\n"
             "         specified, then -form also supports slash patterns like \\t.\n"
             "         google for \"printf syntax\" to get more details. example:\n"
             "      -form \"<run>40col1 <run>-3.5col2 <run>05qline <run>(10.10qcount+1000)\"\n"
             "         reformat column 1 as right-ordered with at least 40 chars, column 2 left-\n"
             "         ordered with at least 3 and a maximum of 5 chars, then add the input line\n"
             "         number, \"q\"uoted, right justified with 5 digits, prefixed by zeros,\n"
             "         then the output line number plus 1000 within quotes. NOTE: some examples\n"
             "         may not work in an sfk script, see section \"common errors\" below.\n"
             "         adding values so far only works with (q)line and (q)count.\n"
             "      -tabform \"<run>col1 mytext ...\"\n"
             "         split and reformat columns of tab separated csv data.\n"
             "      -stabform \"<run>col3\\t<run>col2\\t<run>col1\"\n"
             "         reorder three tab separated columns, creating tabbed output\n"
             "         using 's'lash patterns like \\t\n"
             #ifdef _WIN32
             "      -utabform \"##col1 mytext ...\"\n"
             "         same as -tabform but using unix style syntax, to create scripts\n"
             "         that run without changes on Windows and Linux.\n"
             "      -uform \"##40col1 ##-3.5col2 ##05qline\"\n"
             "         same as -form but using unix style syntax. short for filter -upat.\n"
             #endif
             );
      printx("      -trim  removes blanks and tab characters at line start and end.\n"
             "             use -ltrim or -rtrim to trim line start or end only.\n");
      printx("      -blocksep \" \" = treat blocks of whitespace as single whitespace separator.\n"
             "      -join[lines] join output lines, do not print linefeeds.\n"
             "      -wrap[=n]    wrap output lines near console width [or at column n].\n"
             "                   set SFK_CONFIG=columns:n to define or override the console width.\n"
             "      -toiso[=c]   converts UTF-8 text to ISO-8859-1. some chars beyond\n"
             "                   the 8 bit code range will be reduced to something similar, but\n"
             "                   most of them are changed to a dot '.', or character c.\n"
             "      -toutf       converts ISO-8859-1 text to UTF-8. if this is done with UTF-8\n"
             "                   input text then existing UTF-8 sequences will be destroyed!\n"
          // "      -toutfsafe   in mixed ISO/UFT-8 text: keep all valid UTF-8 sequences and\n"
          // "                   convert only remaining ISO characters to UTF-8. conversion may\n"
          // "                   not work if multiple ISO characters (accents) appear grouped.\n"
             );
      printx("      -tolower     or -toupper convers a-z to lower- or uppercase.\n"
             #ifdef _WIN32
             "      -ansitodos   convert Ansi to OEM codepage, for filenames from clipboard\n"
             "                   written to an >out.txt in the Windows cmd.exe environment.\n"
             #endif
             /*
             "      -decode:hex      decode hex data like 666f6f as foo\n"
             "      -decode:_hex     decode prefixed hex like _66_6f_6f as foo\n"
             "      -decode:\\x25hex  decode percent prefixed hex like %%66%%6f%%6f as foo\n"
             "      -decode:url      same as -decode:\\x25hex\n"
             "      -encode:hex      encode foo to 666F6F\n"
             "      -encode:_hex     encode foo to _66_6F_6F\n"
             "      -encode:\\x25hex:\\x20\\x21\\x3f   foo!? bar -> foo%%21%%3F%%20bar\n"
             "                       i.e. only chars in the list after hex: are encoded.\n"
             */
             "\n");
      printx("   $conditional text processing\n"
             "      -[ls/le]where pattern -replace | -highlight | -sep ... -form\n"
             "          replace, highlight or reformat lines matching the given pattern.\n"
             "          all lines that do not match the pattern stay unchanged.\n"
             "      -within pattern -replace _from_to_\n"
             "          replace text in a part of the line matching the given pattern.\n"
             "          the rest of the line text stays unchanged.\n"
             "\n");
      printx("   $pattern support\n"
             "      wildcards * and ? are active by default. add -lit[eral] to disable.\n"
             "      slash patterns are NOT active by default. add -spat to use \\t \\q etc.\n"
             "      if you need the wildcard * but ALSO want to find/replace '*' characters:\n"
             "      add -spat, then specify \\\\* or \\? to find/replace '*' or '?' characters.\n"
             "      instead of typing \"sfk filter -spat -rep\" all the time, you may use the\n"
             "      short form \"sfk filt -srep\". the same applies for -(s)sep, -(s)form etc.\n"
             #ifndef _WIN32
             "      Linux users: add quotes \"\" around everything that contains * or ?,\n"
             "      otherwise it will be misinterpreted by the linux command shell.\n"
             #endif
             "\n"
             "   $unified syntax\n"
             "      since sfk 1.5.4 you can also use -: -ls: -le: under windows.\n"
             "      filter ... -uform or filter -upat ... -form uses ## instead of $$.\n"
             "\n");
      printx("   $sfk variables versus -tabform\n"
             "      with -upat under windows, of sfk for linux, both filter -tabform\n"
             "      and sfk variables use the syntax ##(name) to insert values.\n"
             "      to solve this, variable parsing is not strict and may keep\n"
             "      undefined variable names as is.\n"
             "\n");
      printx("   $quoted multi line parameters are supported in scripts\n" // filt -rep and -form
             "      using full trim. type \"sfk script\" for details.\n"
             "\n");
      printx("   $further options\n");
      printx("      -case           compare case sensitive. default is case insensitive.\n"
             "                      for further options see: sfk help nocase\n"
             "      -lit[eral]      treat wildcards * and ? as normal chars (read more above).\n"
            );
      arcinf(12); // filt
      if (ofilt)
      printx("      -utfout         keep raw UTF-8 encoding on output, to use it\n"
             "                      with further commands requiring UTF-8 data.\n");
      printx("      -verbose        show names of all files which are currently scanned.\n"
             "                      with wfilter: tell current proxy settings, if any.\n"
             "      -write          do not print output to console but overwrite input file(s).\n"
             "                      only files with actual text changes will be rewritten.\n"
             "                      this function may be used only with plain ASCII files, not with\n"
             "                      binaries like .doc, .xls. see also \"sfk replace\".\n"
             "      -write -to msk  do not overwrite input files, but save according to mask msk,\n"
             "                      e.g. tmp<sla><run>file . saves only changed files. say -writeall\n"
             "                      to write all files, including those without changes.\n"
             "      -memlimit=mb    when using -write, output is cached in memory, which is limited\n"
             "                      to 300 mb. use this option to extend, e.g. -memlimit=400\n"
             "      -yes            -write simulates by default. add -yes to really write changes.\n"
             "      -snap           detect snapfiles and list subfile names having text matches.\n"
             "      -snapwithnames  same as -snap, but include subfile names in filtering.\n"
             "      -nofile[names]  do not list filenames, do not indent text lines.\n"
             "      -subnames       with ofilter: insert .xlsx sheet subfile names.\n"
             "      -count, -cnt    preceed all result lines by output line counter\n"
             "      -lnum           preceed all result lines by input  line number\n"
             #ifdef _WIN32
             "      -hidden         include hidden and system files.\n"
             #endif
          // "      -bin[ary]       process also files that look like binaries (replacing\n"
          // "                      characters with code 0x00 and 0x1A by '.')\n"
             "      -noinfo         do not warn on line selection combined with -write.\n"
             "      -noop \\\"        no operation, take the \\\" parameter but do nothing.\n"
             "                      may help if your (windows) shell miscounts quotations.\n"
             "      -hitfiles       if another command follows (e.g. +run or +ffilter),\n"
             "                      pass a list of files containing at least one hit.\n"
             #ifdef _WIN32
             "      -nocconv        disable umlaut and accent character conversions during\n"
             "                      output to console. \"sfk help opt\" for details.\n"
             #endif
             "      -justrc         print no output, just set return code on matching lines.\n"
             #ifdef _WIN32
             "      -upat           unix style syntax with -form, using ## instead of $$\n"
             #endif
             "      -timeout=n      with wfilt: wait up to n msec for web data.\n" // wto.wfilt
             "\n");
      if (!wfilt)
      printx("   $list of possible input sources\n"
             "      from stdin:                 type x.txt | sfk filter -+pattern\n"
             "      from single input file:     sfk filter x.txt -+pattern\n"
             "      text from chained command:  sfk list mydir .txt +filter -+pattern\n"
             "      from many files, directly:  sfk filter -+pattern -dir mydir -file .txt\n"
             "      from many files, by chain:  sfk list mydir .txt +filefilter -+pattern\n"
             "      in general, whenever you need to make sure that file contents (not the\n"
             "      file names) are processed, prefer to say \"filefilter\" or \"ffilt\".\n"
             "\n"
             "   $web access support\n"
             "      searching the word \"html\" in an http URL can be done like:\n"
             "      #sfk filter http://192.168.1.100/ -+html\n"
             "      #sfk filter http://.100/ -+html\n"
             "      #sfk wfilt .100 -+html\n"
             "      #sfk web .100 +filt -+html\n"
             "\n");
      printx("   $return codes for batch files\n"
             "      0   normal execution, no matching lines found.\n"
             "      1   normal execution,    matching lines found.\n"
             "          with -write: returns rc 1 only if any changes were written.\n"
             "     >1   major error occurred. see \"sfk help opt\" for error handling options.\n"
             );
      printx("\n"
             "   $common errors\n"
             "      when using filter -form within sfk scripts, expressions like <run>10.10col1\n"
             "      may collide with script parameters <run>1 <run>2 <run>3. to solve this, use brackets\n"
             "      like <run>(10.10col1), or \"sfk label ... -prefix=%%\", or -uform.\n"
             "\n");
      printx("   $aliases\n"
             "      #ifilt<def>               same as filter -i to read from stdin\n"
             "      #sfk ... +getcol n<def>   get column n of whitespace separated text.\n"
             "                          same as +filter -blocksep \" \" -form <run>coln\n"
             "      #sfk ... +tabcol n<def>   get column n of tab separated text.\n"
             "                          same as +filter -stabform <run>coln\n"
             "\n");
      if (!wfilt) {
         printSearchReplaceCommands(1);
         printx("      #sfk getvar<def>    fast single line lookup in multi line variable\n"
                "      #sfk difflines<def>      show different lines between two files\n"
                "      #sfk help unicode<def>   about wide character conversion functions\n"
                "\n");
      }
      printBewareWide();
      if (!wfilt && !ofilt)
      webref("filter");
      if (wfilt)
      {
      printx("   $automatic name expansions\n"
             "      http:// is added automatically. short ip's like .100 are\n"
             "      extended like 192.168.1.100 depending on your subnet.\n"
             "\n");
      printx("   $see also\n"
             "      #sfk web<def>   - call URL and print output to terminal\n"
             "\n");
      printx("   $examples\n"
             "      #sfk wfilter 192.168.1.100/log.txt -+error -+warning\n"
             "         download log.txt from IP 192.168.1.100 and show all lines\n"
             "         containing text \"error\" or \"warning\".\n"
             "      #sfk web .100/log.txt +filter -+error -+warning\n"
             "         the same, done by a command chain. gets log.txt from\n"
             "         local IP .100 and passes text to +filter.\n"
             "      #sfk wfilter .100/xml/status.xml -spat -+\\qrc\\q\n"
             "         get status xml data from .100 and extract lines\n"
             "         containing word \"rc\", surrounded by quotes, like\n"
             "            $<row name=\"rc\">0</row>\n"
             "      #sfk wfilt .100 -inc \"\\<head>\" to \"</head>\"\n"
             "         extracts the html page head section from local IP .100\n"
             );
      }
      else if (ofilt)
      {
      printx("   $see also\n"
             "      #sfk filter<def>    for more filtering examples\n"
             "\n");
      printx("   $examples\n"
             "      #sfk ofilter in.docx -+foo\n"
             "         get all lines from in.docx containing foo\n"
             "      #sfk ofilt in.xlsx -+apple -stabform <run>col2\\t<run>col3\n"
             "         get table rows containing 'apple',\n"
             "         then use only columns 2 and 3.\n"
             );
      }
      else
      {
      printx("   $more in the SFK Book\n"
             "      the #SFK Book<def> contains a 60 page tutorial, including\n"
             "      long filter examples with input, command and output.\n"
             "      type \"#sfk book<def>\" for details.\n"
             "\n"
             );
      printx("   $examples\n"
             "      #anyprog | sfk filter -+error: -<not>warning\n"
             "         run command anyprog, filter output for error messages, remove warning messages.\n"
             "      #sfk filter result.txt -rep \"_\\_/_\" -rep \"xC:/xD:/x\"\n"
             "         read result.txt, turn all \\ slashes into /, and C:/ expressions to D:/\n"
             "         the quotes \"\" are optional here, and just added for safety.\n"
             "      #sfk filter index.html -rep \"_<u>_<b>_\" -rep \"_</u>_</b>_\" -write\n"
             "         replace underlining by bold in an HTML text. quotes \"\" are strictly\n"
             "         required here, otherwise the shell environment would split the command\n"
             "         at the < and > characters. add option -yes to really rewrite the file.\n"
             "      #sfk filter export.csv -sep \";\" -format \"title: <run>(-40col2) remark: <run>(-60col5)\"\n"
             "         reformat comma-separated data, exported from spreadsheet, as ascii text.\n"
             "      #sfk stat . +filter -blocksep \" \" -format \"<run>(4col1) mb in folder: <run>(col5)\"\n"
             "         reformats output of the stat command. when using this in an sfk script\n"
             "         round brackets () are required to avoid parameter name collision.\n"

             "      #sfk filter mycsv.txt >out.txt -spat -rep _\\\"__ -rep _\\t__ -rep \"_;_\\\"\\t\\\"_\" -form \"<run>qcol1\"\n"
             "         read semicolon-separated spreadsheet data mycsv, strip all double colons\n"
             "         and tab characters from data fields. replace field separator \";\" by TAB,\n"
             "         and surround all fields by double colon. -form without -sep means \"pack the whole\n"
             "         line into <run>col1\", allowing -form to add quotes at start and end of each line.\n"

             "      #sfk filter logs\\access.log \"-+GET * 404\"\n"
             "         list all lines from access.log containing a phrase with GET and 404.\n"

             "      #sfk filter log.txt \"-ls<not>??.??.???? ??:??:?? * *\"\n"
             "         excludes lines from log.txt starting with a date, and having two more words,\n"
             "         like \"20.05.2007 07:23:09 org.whatever.server main\"\n"
             );
      printx("      #%s | sfk run -idirs \"sfk filt tpl.conf >httpd.conf -rep _AbsWorkDir_<run>path_\"\n"
             "         create httpd.conf from tpl.conf, replacing the word \"AbsWorkDir\" by the path\n"
             "         from which the command is run. note we can NOT use -spat in this case, otherwise\n"
             "         a pathname like C:\\temp would produce garbage (contains slash pattern \"\\t\").\n"
             #ifdef _WIN32
             , "cd"
             #else
             , "pwd"
             #endif
             );
      printx("      #sfk filter in.txt -spat -sep \"\\t\" -rep _\\q__ -form \"INSERT INTO MYDOCS (DOC_ID,\n"
             "       #DESCRIPTION) VALUES ('TestDoc<run>03line','<run>col2');\"\n"
             "         this example (typed in one line) creates a list of SQL statements, using tab-\n"
             "         separated, quoted input data, and using the input line number for document ids.\n"
             "         the -rep _\\q__ means the same as -rep _\\\"__ - it strips quotes from the input,\n"
             "         but using \\q is safer then \\\" as it doesn't let the shell miscount quotes.\n"
             );
      printx("      #sfk list documents .txt +filter -+big*foo -+wide*foo\n"
             "         from all .txt files in documents, filter the filenames (NOT the file contents)\n"
             "         for big*foo OR wide*foo.\n"
             );
      printx("      #sfk list documents .txt +filefilter -+big*foo -+wide*foo\n"
             "         from all .txt files in documents, filter the file contents (NOT the names)\n"
             "         for text lines containing big*foo OR wide*foo.\n"
             );
      printx("      #sfk list logfiles .txt +filefilter -global-unique +tofile mixedlog.txt\n"
             "         join all .txt files from logfiles into one output file mixedlog.txt,\n"
             "         dropping all redundant text lines. works only if logfile records are\n"
             "         prefixed by a unique record ID, and if overall text data is less than\n"
             "         available memory, because all data is cached during processing.\n"
             "      #sfk list logfiles .txt +ffilter -global-unique -write -to mytmp<sla><run>file\n"
             "      #sfk snapto=mixedlog.txt mytmp\n"
             "         same as above in two commands, using temporary files to allow more data.\n"
             );
             #ifdef _WIN32
      printx("      #bin\\runserver.bat 2>&1 | sfk filter -+exception\n"
             "         filter standard output AND error stream (\"2>\") for exceptions\n"
             "      #sfk filter result.txt -+error -justrc\n"
             "      #IF %%ERRORLEVEL%%==1 GOTO foundError\n"
             "         in a batchfile: jump to label foundError if text \"error\" was found\n"
             "         within file result.txt. with -justrc no output is printed to terminal.\n"
             );
             #else
      printx("      #./runserver.sh 2>&1 | sfk filter -+exception\n"
             "         filter standard output AND error stream (\"2>\") for exceptions\n"
             "      #sfk filter result.txt -+error -justrc\n"
             "      #iReturnCode=$$?\n"
             "      #if [ $$iReturnCode -eq 1 ]; then\n"
             "         echo \"error occured.\"\n"
             "      #fi\n"
             "         in a bash script: tells if text \"error\" was found within result.txt.\n"
             "         due to option -justrc no output is printed to terminal.\n"
             );
             #endif
      printx("      #sfk filt log.txt -high cyan \"*.*.*(*.java:*)\" -high green \"sql select *\"\n"
             "         dump log.txt, listing java stack traces in cyan, and sql selects in green.\n"
             );
      printx("      #sfk filt x.html -where \"000099\" -rep \"_<font*000099*>_<b>_\" -rep \"_</font>_</b>_\"\n"
             "         replaces html <font> commands by <b>, but only in lines with \"000099\" (=blue).\n"
             );
      printx("      #sfk filt foo.cpp -cut \"ifdef barmode\" to \"endif // barmode\"\n"
             "         strip blocks of lines from foo.cpp, surrounded by the given patterns.\n"
             );
      #ifdef _WIN32
      printx("      #sfk fromclip +filt -srep \"_\\\\_\\\\\\\\_\" -srep \"_\\q_\\\\\\q_\" -sform \"\\q$$col1\\\\n\\q\"\n"
             "         convert text from clipboard to source code, e.g. change\n"
             "            #the \"tab character\" is written like \\t\n"
             "         to a C++ or Java string literal like\n"
             "            #\"the \\\"tab character\\\" is written like \\\\t\\n\"\n");
      #endif
      printx("      #sfk filt csv.txt -spat -within \"\\q*\\q\" -rep _,_\\x01_ -rep _,_\\t_ -rep _\\x01_,_\n"
             "         change separators in comma separated data from comma to tab, also taking\n"
             "         care of quotes, by replacing in-quote commas by a placeholder (\\x01).\n"
             "         if the data contains escaped quotes like \"\" then further prefiltering\n"
             "         can be necessary, like removing those quotes by -sreplace _\\q\\q__\n"
             );
      #ifdef _WIN32
      printx("      #sfk filt mysrc.cpp \"-+fopen(\" -postcontext=3:blue:----- +view\n"
             "         filter source file \"mysrc.cpp\" for fopen calls, and list the following\n"
             "         three lines (post context) of every call, separating outputs by -----\n"
             "         and showing the whole result in Depeche View (\"sfk view\" for more).\n"
             );
      #endif
      printx("      #sfk filter -tail=10 -dir proj -file .cpp<def>\n"
             "         show last 10 lines of every .cpp file within folder proj.\n"
             "      #sfk select mydir .txt +ffilter -head=10 -+mypat\n"
             "         search first 10 lines of every .txt file of mydir for pattern mypat.\n"
             "         notice the ffilter to read file contents, not just filenames.\n"
             "      #sfk filt mydir -+foo +copy out\n"
             "         copy all files from mydir containing a pattern to out\n"
             "      #sfk filt -noname mydir -+foo +texttofilenames +copy out\n"
             "         copy from filenames found in text files. needs option\n"
             "         -noname to avoid filename headers and indention.\n"
             );
      }
   }

   if (!strncmp(pszSub, "color", 5))
   {
      printx("<help>$sfk color control (sfk help colors)\n"
             "\n");
      printx("<exp> SFK_COLORS=off|on,err:n,warn:n,head:n,examp:n,file:n,hit:n,rep:n,pre:n\n");
      printx("<exp> SFK_COLORS=bright|dark,theme:black|theme:white\n");
      printx("\n"
             "   color identifiers are\n"
             #ifndef _WIN32
             "      def       default color (black by default)\n"
             #endif
             "      err       error   messages\n"
             "      warn      warning messages\n"
             "      head      headlines in help text\n"
             "      examp     examples  in help text\n"
             "      file      filename listings in find\n"
             #ifndef _WIN32
             "      link      symbolic link files or directories\n"
             #endif
             "      hit       text pattern hits in find and filter\n"
             "      rep       replaced patterns in filter\n"
             "      pre       line prefix symbols in find\n"
             "      time      time or low-prio status infos\n"
             "      traceinc  with -tracesel, included names\n"
             "      traceexc  with -tracesel, excluded names\n"
             "\n"
             "   color code n is a combination of these values:\n"
             "      0 = black\n"
             "      1 = bright\n"
             "      2 = red\n"
             "      4 = green\n"
             "      8 = blue\n"
             "\n"
             "   some commands like \"sfk echo\" also accept direct color names:\n"
             "   red,green,blue,yellow,cyan,magenta,default,Red,Green,Blue...\n"
             "   sfk for windows tries to autoselect color brightness if a black\n"
             "   or white shell background is found. otherwise the spelling matters:\n"
             "   red means dark red, and Red means bright red.\n"
             "   you may also set SFK_COLORS to bright or dark, or specify options\n"
             "   -bright or -dark in your command, to force all plain text colors\n"
             "   to the same brightness, regardless of spelling.\n"
             "\n"
             "   examples for color schemes:\n"
             "\n"
             );
      printx("      neutral, compatible to black and white backgrounds:\n"
             "         <exp> SFK_COLORS=head:5,examp:11,file:11,hit:5,rep:7\n"
             "\n");
      printx("      black background optimized theme:\n"
             "         <exp> SFK_COLORS=theme:black\n"
             "         <exp> SFK_COLORS=b\n"
             "\n");
      printx("      white background optimized theme:\n"
             "         <exp> SFK_COLORS=theme:white\n"
             "         <exp> SFK_COLORS=w\n"
             "\n");
      printx("      switch off colored output:\n"
             "         <exp> SFK_COLORS=off\n\n");
      #ifdef _WIN32
      printx("   to switch off colors per command, use general option -nocol .\n");
      #else
      printx("   by default, colors are inactive on unix, as there are some potential problems\n"
             "   depending on the background color of your shell, and if you want to post-process\n"
             "   command output. if you feel lucky, add -col in front of a command, or say\n"
             "\n"
             "      export SFK_COLORS=on,def:0      or    export SFK_COLORS=on,def:14\n"
             "      with bright shell backgrounds         with black shell backgrounds\n"
             );
      #endif

      printx("\n"
             "   to TEST current active colors, type: sfk colortest\n"
             );
   }

   if (!strncmp(pszSub, "opt", 3))
   {
      printx("$sfk general options reference%s:\n",
             bhelp ? " (type \"sfk help options\")":"");

      printx("\n"
         "   Please note: some of these options are supported only by some commands.\n"
         "\n"
         );

      printx(
         "   #general processing options\n"
         "   $-var<def>        insert SFK variables by using ##(varname). type this\n"
         "               option directly after \"sfk\" to use it globally with all\n"
         "               commands in a chain or script. to print \"##(\" literally\n"
         "               then, escape it like ####(. for more on variables\n"
         "               type: sfk help var\n"
         "   $-yes<def>        fully execute the command. some commands like \"run\" are\n"
         "               running in simulation mode by default, to avoid damage to your\n"
         "               files, as long as you're unsure which files and dirs to select.\n"
         "               as soon as you add -yes, however, everything is fully executed.\n"
         "   $-keepchain<def>  never stop the command chain, even if commands that expect\n"
         "               filenames get none. default since sfk 1.9.9.\n" // sfk1990
         "               for more details: sfk help chain\n"
         "   $-stoponempty<def>  stop the command chain if commands that expect\n"
         "               filenames get none. default until sfk 1.9.8.2.\n" // sfk1990
         #ifdef _WIN32
         "   $-upat<def>       unix compatible file or text selection and patterns.\n"
         "               allows to use -subdir :/tmp instead of !\\tmp, filter -:foo\n"
         "               instead of -!foo and run \"##file\" instead of \"$$file\",\n"
         "               to create unified .sh batch files for Windows and Linux.\n"
         "   $-upat2<def>      same as -upat but also support wildcard %% instead of *\n"
         "               you may also set this by an environment variable like:\n"
         "               <exp> SFK_CONFIG=upat2\n"
         "   $-noesckey<def>   disable stop by escape key. (windows only)\n"
         #endif
         "\n");

      printx(
         "   #file input options\n"
         "   $-nosub<def>      or -norec does not include subdirectories (subfolders).\n"
         "               processing of subdirs is DEFAULT with most commands,\n"
         "               therefore you must specify -nosub to switch it off.\n"
         "   $-withsub<def>    include subdirs. is DEFAULT with most commands.\n"
         "   $-maxsub=n<def>   include contents of up to n subdir levels.\n"
         "   $-withdirs<def>   include (sub) folder names in processing.\n"
         "   $-justdirs<def>   use just (sub) folder names for processing.\n"
      // "   $-noqwild<def>    disable \"?\" wildcard in file selection.\n" // internal
         #if (!defined(SFK_LIB5))
         "   $-nofollow<def>   or -nofo does not follow symbolic directory links.\n"
         "               this option may NOT work with older Linux versions,\n"
         "               esp. those needing the \"lib5\" binary version of sfk.\n"
         #endif
         "   $-textfiles<def>  process only text files, no binaries. -text is the same,\n"
         "               but this may interfere with command-local -text options.\n"
         "               text/binary detection only checks the file's first 4 kbytes.\n"
         "   $-binfiles<def>   process only binary files. -bin is the same, but this may\n"
         "               interfere with some command's local -bin option.\n"
         "   $-hidden<def>     include hidden and system files.\n"
         "   $-nohidden<def>   exclude hidden and system files.\n"
         "   $-minsize=s<def>  select only files >= size, like 10b or 100k\n"
         "   $-maxsize=s<def>  select only files <= size, like 10m or 4g\n"
         "               b=bytes k=kbytes m=megabytes g=gigabytes=10^9 bytes\n"
         "               K=2^10 bytes M=2^20 bytes G=2^30 bytes\n"
         "   $-sincedir<def>   or -sincedif/add/chg: compare directory tree against\n"
         "               a reference tree, process only changed or added files.\n"
         "               see \"sfk list\" for details.\n"
         "   $-since<def>      process only files changed on or after the supplied\n"
         "               date/timestamp. \"sfk list\" for details.\n"
         "   $-before<def>     process only files changed before that date/timestamp.\n"
         "   $-flist fn<def>   or \"-fl fn\" reads list of filenames from file fn.\n"
         "   $-tomake .ext<def>   select only files that have no, or an older,\n"
         "               counterpart file with extension .ext in the same folder.\n"
         "   $-tomake outdir<sla><run>base.ext<def>  select only files that have no or\n"
         "               an older counterpart file in outdir with extension .ext.\n"
         "               see \"sfk run\" for example: .wav to .mp3 conversion\n"
         "   $-wchar<def>      activate EXPERIMENTAL utf-16 (ucs-2, wide char) decoding,\n"
         "               allowing sfk find or filter to search text in utf-16 files.\n"
         "               should not be used when (re)writing files. get more infos\n"
         "               by typing \"sfk help unicode\".\n"
         "\n");

      printx(
         "   #text input and filtering options\n"
         "   $-case<def>       activate case sensitive text comparison with some commands.\n"
         "               most text processing commands are case-insensitive by default.\n"
         "               filename comparison is always case insensitive.\n"
         "               for details see: sfk help nocase\n"
         "   $-spat<def>       activates interpretation of slash patterns:\n"
         "               \\t=TAB \\q=\" \\r=CR \\n=LF \\\\=\\ \\xnn=any char w/hex code nn\n"
         "               with some commands like replace, filter -form and -replace.\n"
         "   $-spats<def>      strict slash patterns, show error on wrong patterns like \\a.\n"
         "   $-literal<def>    or -lit disables interpretation of wildcards * and ?\n"
         "               and slash patterns, if they were activated previously.\n"
         "   $-nospat<def>     disables only slash patterns.\n"
         #ifdef _WIN32
         "   $-deacc<def>      use accent insensitive text search and filename selection,\n"
         "               i.e. a == a_accent or o == o_umlaut. may work only with\n"
         "               some windows code pages, but not with utf-8 text.\n"
         #endif
         "   $-binallchars<def>  with binary-to-text conversion, include all printable\n"
         "                 characters, like accents or non latin.\n"
         "\n");

      printx(
         "   #network options\n"
         "   $-header x<def>   or -head adds custom header x to http requests, like\n"
         "               -header \"Accept-Language: de,en-US;q=0.7,en;q=0.3\"\n"
         "               multiple header lines can be given. default headers\n"
         "               with the same name are replaced.\n"
         "\n");

      printx(
         "   #user information options\n"
         "   $-verbose<def>    print additional infos while running a command.\n"
         "               helpful if a command doesn't work as expected.\n"
         "               only some commands support -verbose. try also -verbose=2.\n");
  #ifdef _WIN32
  printx("   $-more<def>       pause output based on terminal height.\n");
  #else
  printx("   $-more<def>       pause output every %d lines approx.\n", nGlblConsRows);
  #endif
  printx("   $-more50<def>     paged output with 50 lines per page.\n"
         "               -more is experimental and may fail to count exactly.\n"
         "   $-quiet<def>      reduce output on some commands. e.g. the find command will\n"
         "               not display the \"scan\" status info while searching files.\n"
         "   $-quiet=2<def>    reduce output even more on some commands.\n"
         "   $-nowarn<def>     and -noerr, -nonote disable warn, error and note messages.\n"
         "   $-nohead<def>     no not list header/trailer info on some commands: the run cmd\n"
         "               will not tell \"simulating\" even if it's in simulation mode.\n"
         "   $-tracechain<def>   tell in detail how the command chain is executed.\n"
         "   $-tracesel<def>   give verbose infos why directories and files have been\n"
         "               selected or excluded. -tracedirs lists only directories,\n"
         "               -tracefiles lists only files.\n"
         "   $-debug<def>      print extra program flow infos to track errors.\n"
         #ifdef SFK_MEMTRACE
         "               also activates -memcheck under Windows.\n"
         #endif
         #ifdef SFK_MEMTRACE
         "   $-memcheck<def>   check memory list at the end of every command\n"
         "               to detect overwrites. reduces performance.\n"
         #endif
         "   $-exectime<def>   tell command execution time at program end.\n"
         "   $-headers<def>    print http headers with commands accessing the web.\n"
         "\n");

      printx(
         "   #file output options\n"
         "   $-tofile x<def>   specify a single output filename, which is taken as is\n"
         "               and not checked for any <run> patterns.\n"
         "   $-to mask<def>    specify where to write output files with some commands.\n"
         "               mask supports <run>file, <run>path, <run>relpath, <run>base, <run>ext and more,\n"
         "               like -to outdir<sla><run>base-modified.<run>ext\n"
         "               say \"sfk run\" for a list of possible keywords.\n"
         "   $-tmpdir x<def>   set directory x as temporary file directory. default is\n"
         #ifdef _WIN32
         "               to use the path specified by TEMP or TMP env variable.\n"
         #else
         "               to use the path specified by TEMP or TMP env variable,\n"
         "               or the /tmp directory, if no such variable is defined.\n"
         #endif
         "   $-showtmp<def>    tell verbosely which temporary files are created.\n"
         "   $-keeptmp<def>    do not delete the temporary files, if possible.\n"
         "\n");

      printx(
         "   #terminal output options\n"
         "   $-nocol<def>      disable all colored output. important if your shell has\n"
         "               a background color incompatible to the default color scheme,\n"
         "               or (under linux) if the sfk output text must be processed\n"
         "               further through pipelining, and needs to be stripped from\n"
         "               the color escape sequences.\n"
         "   $-col<def>        switch on colored output. \"sfk help colors\" for more.\n"
         #ifdef _WIN32
         "   $-nocconv<def>    when printing output to the windows console, sfk tries\n"
         "               to convert umlaut and accent characters to display them\n"
         "               correctly with codepage 850. set -nocconv to disable this.\n"
         "               whenever output is redirected to file, no conversion is done.\n"
         "   $-cconv<def>      force codepage conversions: if command output is redirected\n"
         "               to a file, codepage conversion is disabled by default.\n"
         "               use this option to activate, e.g. when post-processing\n"
         "               sfk run output which produced filename lists.\n"
         #endif
         "   $-html<def>       dump sfk help text (color control) in html format.\n"
         "               -html must be typed directly after \"sfk\".\n"
         "   $-htmlpage<def>   the same, but include a header to view it in a browser.\n"
         "\n");

      printx(
         "   #return code and error options\n"
         "   $-showrc<def>     print sfk return code at end of command or program.\n"
         "               may not print anything in case of fatal errors,\n"
         "               like wrong syntax (usually rc 9).\n"
         "   $-justrc<def>     let some commands print nothing and just produce an rc.\n"
         "   $-exterr<def>     in case of operating system related errors like file access,\n"
         "               prints extended error information, if available.\n"
         "   $-waitonerr<def>  wait for user input on every error.\n"
         "   $-waitonend<def>  wait for user input at program end.\n"
         "   $-stoponerr<def>  stop directory tree processing on first unreadable file.\n"
         "               default is to process as many files as possible, skipping\n"
         "               unreadable files and directories.\n"
         "   $-rcfromerr<def>  some commands like filter, find, hexfind tell by shell rc\n"
         "               that something was found. by default, skipped errors like\n"
         "               unreadable files do NOT change this rc. with -rcfromerr,\n"
         "               skipped errors do override the resulting shell rc.\n"
         "   $-echoonerr<def>  echo whole command to stderr when an error occurs.\n"
         "               see also the SFK_CONFIG setting \"echoonstart\" below.\n"
         "   to experiment with the above options, try \"sfk errortest\".\n"
         "\n");

      printx(
         "   #diverse options\n"
         "   $-qarc<def>       quick read top level archives but not nested ones.\n");
  printx("   $-weblimit=n<def>    change web access download limit to n mbytes, with\n"
         "                  functions like sfk web, filter, xex. default is 100 mb.\n"
         "                  you may also <exp> SFK_CONFIG=weblimit:30\n"
         "   $-webtimeout=n<def>  web access timeout in msec. default is 10000.\n" // wto.general
         "                  you may also <exp> SFK_CONFIG=webtimeout:3000\n"
         "   $-webuser=u<def>     together with -webpw=p set HTTP basic authentication\n"
         "                  with diverse commands supporting http:// web access.\n"
         );
  printx("   $-memlimit=n<def> set the caching memory limit to n mbytes (default=%d).\n"
         "               used if a function needs to load whole files into memory.\n"
         ,(int)(nGlblMemLimit / 1048576));
         #ifdef VFILEBASE
  printx("               if zip etc. archive processing is very slow, it may be caused by\n"
         "               a cache overflow. try to increase the -memlimit then.\n"
         "               if you think sfk uses too much memory while processing files,\n"
         "               try to reduce -memlimit (values below 200 are not recommended).\n"
         "               you may also set SFK_CONFIG (see end of this text).\n"
         "   $-cachestat<def>  tell amount of memory used by archive file cache.\n"
         "   $-nocache<def>    disable the disk cache (for network files).\n"
         );
         #endif // VFILEBASE
  printx("   $-noipex<def>     disable automatic IP expansion with some commands.\n"
         "   $-noop<def>       do nothing (no operation). sometimes helpful as a fill-in.\n"
      // "   $-delay=n<def>    wait n msec after every file\n"
         "\n");

  printx("   $command local versus global scope:\n"
         "\n"
         "      within a command chain, many options have an effect only locally\n"
         "      with the command where they are specified, e.g. in\n"
         "\n"
         "         #sfk filt x.txt -case -high red FooCase +filt -high blue TheBar\n"
         "\n"
         "      the \"-case\" is valid only for the first filter command.\n"
         "      but the following options can also be used globally, if specified\n"
         "      directly after \"sfk\":\n"
         "\n"
         "         $-nohead -noinfo -nofile -case -literal -spat\n"
         "\n"
         "      for example, in\n"
         "\n"
         "         #sfk -case filt x.txt -high red FooCase +filt -high blue TheBar\n"
         "\n"
         "      the \"-case\" is valid for ALL commands in the command chain.\n"
         "\n");

  printx("   $environment configuration:\n"
         "\n"
         "      $<exp> SFK_CONFIG=columns:n,active-file-age:n,memlimit:n,...\n"
         "        columns:\n"
         "          sfk (for windows) tries to autodetect the no. of console columns,\n"
         "          but you may also set this value through this config parm.\n");
  printx("        active-file-age:n\n"
         "          some functions need to tell if a file is 'recently edited' or rather\n"
         "          old and inactive. by default, files > 30 days of age are considered\n"
         "          non-active. reconfigure the no. of days threshold here.\n"
         "        memlimit:n\n"
         "          set memory limit to n mbytes.\n"
         "        echoonstart:\n"
         "          echo the whole sfk command on start, to stderr.\n"
         "        echoonerr:\n"
         "          echo the whole sfk command on errors, to stderr.\n"
         "        tmpdir:path\n"
         "          set folder for temporary files, used by some commands.\n"
         #ifdef _WIN32
         "          e.g. set SFK_CONFIG=tmpdir:d:\\tmp,memlimit:500\n"
         #else
         "          e.g. set SFK_CONFIG=tmpdir:~/mytmp,memlimit:500\n"
         #endif
         "\n");
         if (bGlblIgnore3600)
            printx("   info: files with a time difference of 1 hour AND an age > %d days\n"
                   "         are skipped by some commands, e.g. list -sincedir.\n\n", nGlblActiveFileAgeLimit);

         if (nGlblActiveFileAgeLimit != 30)
            printx("   info: active file age limit is currently set to %d days.\n", nGlblActiveFileAgeLimit);

         #ifdef _WIN32
         if (glblWildChar != '*')
         #else
         if (glblWildChar != '%')
         #endif
         {
            setTextColor(nGlblWarnColor);
            printx("   info: wildcard star '*' is currently configured as %c\n", glblWildChar);
            setTextColor(-1);
         }

  printx("      $<exp> SFK_ZIP_EXT=\".foo .bar .myext\"\n"
         "        set additional, user defined zip file extensions. in this example,\n"
         "        files ending with .foo, .bar or .myext are also treated like zip files.\n"
         "        for the list of default extensions, look above at the -arc option.\n"
         "\n");
 
         if (bGlblConsColumnsSet)
            printx("   sfk currently uses %d console columns for output with some commands.\n", nGlblConsColumns);
   }

   if (!strncmp(pszSub, "sel", 3))
   {
  printx("$sfk file selection reference%s:\n"
         "\n"
         "   $default principles of most sfk commands:\n"
         "\n"
         "      - subdirectory (subfolder) processing is done by default.\n"
         "      - filename comparison is case insensitive.\n"
         "      - hidden and system files are not processed,\n"
         "        except for some commands like copy.\n"
         "      - symbolic links are followed.\n"
         "\n"
         "        type \"sfk help options\" on how to change that.\n"
         "\n"
         "   $how to select directories and contained filenames:\n"
         "\n"
         "   sfk provides many ways of specifying which files you want to process,\n"
         "   from very simple but unflexible to very detailed.\n"
         "\n",
         bhelp ? " (type \"sfk help select\")":""
         );
  printx("   $1. short format file selection:\n"
         "\n"
         "      $dirname [filemask1] [filemask2] [<not>fileexcludemask] [...]\n"
         "\n"
         "      this format supports ONE directory name, followed by many file masks.\n"
         "      it can be used with most commands processing directory trees.\n"
         "\n"
         "      example:\n"
         "\n"
         "      #sfk list mydir foo bar .txt .zip <not>-tmp\n"
         "         selects all files\n"
         "         - in directory mydir and all its subdirectories\n"
         "         - having foo OR bar in their filename (no * required)\n"
         "         - OR which are ending with .txt OR .zip (no *.txt required)\n"
         "         - but not having -tmp in their filename\n"
         "\n"
         "      supported by commands:\n"
         "         list, select, stat, run, detab, scantab, hexdump and some more.\n"
         "\n"
         );
  printx("   $2. long format file selection:\n"
         "\n"
         "      $-dir root1 [root2] [<wild>pathmask<wild>] [...] [-file mask1 [mask2] [...]]\n"
         "         $[-dir root3 root4 <not>direxcludemask -file mask3 <not>xmask4] [...]\n"
         "\n"
         "      this format supports\n"
         "\n"
         "      - several root directory sets, starting with -dir, each of them\n"
         "        containing many directories, path masks or dir exclusion masks.\n"
         "        a path mask is an expression in a directory set containing a\n"
         "        wildcard character \"<wild>\". a dir exclusion mask is started\n"
         "        by <not> and may be surrounded by <sla> to select exact dir names.\n"
         "\n"
         "      - a file mask set per root directory set, starting with -file.\n"
         "        this may also contain file exclusions starting with <not>\n"
         "\n"
         "      supported by:\n"
         "         nearly every command than can process file sets.\n"
         "\n");
  printx("      $to select all dirs of current dir except something:\n"
         "      #-dir . <not>foo       <def>-> exclude subdirs like *foo*\n"
         "      #-dir . <not>.foo      <def>-> exclude with extension .foo\n"
         "      #-dir . <not><sla>foo      <def>-> exclude starting with foo\n"
         "      #-dir . <not>foo<sla>      <def>-> exclude ending with foo\n"
         "      #-dir . <not><sla>foo<sla>     <def>-> exclude exactly foo\n"
         "      #-dir . <not><sla>foo<sla>bar<sla> <def>-> exclude subdir combi\n"
         "      #-dir . <not><wild>.foo<wild>    <def>-> exclude with .foo anywhere\n"
         "\n"
         "      $to select only sub dirs of current dir with something:\n"
         "\n"
         "      using wide sub dir expressions:\n"
         "      #-dir . -subdir foo       <def>-> include paths having *foo*\n"
         "      #-dir . -subdir <sla>foo      <def>-> include paths having *<sla>foo\n"
         "      #-dir . -subdir foo<sla>      <def>-> include paths having *foo\n"
         "      #-dir . -subdir <sla>foo<sla>     <def>-> include paths exactly foo\n"
         "      #-dir . -subdir .foo      <def>-> include with extension .foo\n"
         "      #-dir . -subdir <sla>foo<sla>bar<sla> <def>-> include subdir combi\n"
         "      instead of -subdir, you may also type just -sub\n"
         "\n"
         "      using compact sub dir expressions:\n"
         "      #-dir . <wild>foo<wild>      <def>-> include paths having *foo*\n"
         "      #-dir . <wild><sla>foo      <def>-> include paths having <sla>foo\n"
         "      #-dir . <wild>foo<sla>      <def>-> include paths having foo<sla>\n"
         "      #-dir . <wild><sla>foo<sla>     <def>-> include paths exactly foo\n"
         "      #-dir . <wild>.foo      <def>-> include with extension .foo\n"
         "      #-dir . <wild><sla>foo<sla>bar<sla> <def>-> include subdir combi\n"
         "\n"
         "      $exclusion by filename:\n"
         "      #-file <not>foo        <def>-> exclude all files like *foo*\n"
         "      #-file <not><sla>foo       <def>-> exclude starting with foo\n"
         "      #-file <not>foo<sla>       <def>-> exclude ending with foo\n"
         "      #-file <not><sla>foo<sla>      <def>-> exclude exactly foo\n"
         "      #-file <not>.foo       <def>-> exclude extension foo\n"
         "\n"
         "      $inclusion by filename:\n"
         "      #-file foo         <def>-> include all files like *foo*\n"
         "      #-file <sla>foo        <def>-> include starting with foo\n"
         "      #-file foo<sla>        <def>-> include ending with foo\n"
         "      #-file <sla>foo<sla>       <def>-> include exactly foo\n"
         "      #-file .foo .bar   <def>-> select .foo and .bar files\n"
         "\n"
         "      $examples\n"
         "\n"
         "      #sfk scantab -dir mydir1 mydir2 <wild>include<wild> -file foo bar .hpp\n"
         "         scans all files for TAB characters\n"
         "         - in directory mydir1 and all its subdirectories\n"
         "           AND\n"
         "         - in directory mydir2 and all its subdirectories\n"
         "           IF\n"
         "           - 1. the file path contains the word \"include\",\n"
         "             e.g. mydir1\\core\\include\\foosys.hpp\n"
         "           - 2. the filename contains foo OR bar\n"
         "           - 3. or the filename ends with .hpp\n"
         "\n"
         "      #sfk scantab -dir mydir1 <not>include -file <not>.tmp <not>.save\n"
         "         scans all files for TAB characters in folder mydir1,\n"
         "         excluding all sub dirs having \"include\" in their name,\n"
         "         and excluding all .tmp and .save files.\n"
         "\n"
         "      #sfk list -dir source include -subdir save <not>.svn -file .bak\n"
         "         list .bak files from directory trees source and include,\n"
         "         within in sub directories having \"save\" in their name,\n"
         "         excluding sub directories ending with \".svn\".\n"
         "\n"
         "      #sfk list -dir source include <wild>save <not>.svn -file .bak\n"
         "         the same as above, written in compact subdir format:\n"
         "         subdir inclusion masks require a wildcard <wild> anywhere\n"
         "         to make it clear they're no root directories.\n"
         "         subdir exclusion masks can stay as they are.\n"
         "\n"
         );
  printx("      $file set reuse within scripts:\n"
         "\n"
         "      to allow reuse of the same -dir ... -file ...\n"
         "      parameters by different commands, these options exist:\n"
         "\n"
         "      $-root x<def>     prefix every -dir parameter by x,\n"
         "                  then remove x in the -dir parameters to\n"
         "                  make a fileset compatible to copy/sync\n"
         "      $-using l<def>    use -dir ... -file ... text given at label l.\n"
         "                  text in that label may contain // remarks,\n"
         "                  but no variables like ##(foo).\n"
         "      $-checkdirs<def>  stop if given -dir folders do not exist\n"
         "\n"
         "      to get a full example script type:\n"
         "\n"
         "         #sfk batch mytest.bat<def>    for a Windows .bat example\n"
         "         #sfk batch mytest.sh<def>     for a Cygwin/Linux .sh example\n"
         "\n");
  printx("   $3. single parameter file set selection:\n"
         "\n"
         "      some commands like find, filter or tail do not accept the full\n"
         "      short format, but only a single file or dir parameter, as it\n"
         "      would get too complicated mixing the short format with local\n"
         "      options. find more on that in the command's local help.\n"
         "\n"
         );
  printx("   $4. passing filename lists in command chains:\n"
         "\n"
         "      instead of selecting files in the current command, you may use\n"
         "      a filename list created by a previous command, for example:\n"
         "\n"
         "      #sfk select mydir .txt +detab=3\n"
         "         selects all .txt files from directory mydir, then passes\n"
         "         this file list to detab, where the files are detabbed.\n"
         "\n"
         "      command chaining is more intuitive, as you can play around\n"
         "      with different file sets before executing actual changes\n"
         "      on the selected files.\n"
         "\n"
         "      #sfk filter names.txt +texttofilenames +list -late\n"
         "         provided that names.txt contains a list of filenames,\n"
         "         this command chain lists the most recent of these files.\n"
         "         note that in this case, it is unclear if to pass\n"
         "         - the filename \"names.txt\" or\n"
         "         - the line contents from within names.txt\n"
         "         as filenames to \"list\", therefore we need to insert\n"
         "         +texttofilenames or +ttf to enforce a conversion.\n"
         "\n"
         "      supported by:\n"
         "         some commands. check each command's local help for more.\n"
         "\n"
         );
  printx("   $see also\n"
         "      #sfk help options<def>  general options for most commands.\n"
         "      #sfk list<def>          for more file selection examples.\n"
         );
   }

   if (!strcmp(pszSub, "chain"))
   {
      printx("$sfk command chaining reference%s:\n",
             bhelp ? " (type \"sfk help chain\")":"");
      printx("\n"
         "   several commands can be combined in a so-called \"command chain\".\n"
         "   this is done by appending command names prefixed by \"+\", for example:\n"
         "\n"
         "   #sfk list docs .txt +ffilter -+foo\n"
         "      \"list\" produces a filename list and passes this to \"filefilter\".\n"
         "      ffilter reads the contents of these files, looking for the word \"foo\".\n"
         "\n"
         "   $chain data types\n"
         "      three types of data can be passed from one command to another:\n"
         "\n"
         "         #- filename lists.\n"
         "         #- plain text records (lines).\n"
         "         #- stream text or binary data.\n"
         "\n"
         "      output is dependent on command. for example, sfk select produces\n"
         "      filename lists, sfk filter makes plain text records, xex/xed can\n"
         "      produce streams of text or binary data.\n"
         "\n"
         "   $chain data type conversion\n"
         "      vice versa, some commands accept filenames, or text input, or even both.\n"
         "      depending on what you want to do, it may be necessary to convert between\n"
         "      this types of data. this can be done by the keywords:\n"
         "\n"
         "         #+texttofilenames<def> or #+ttf<def>\n"
         "         #+filenamestotext<def> or #+ftt<def>\n"
         "\n"
         "      however, most sfk commands try to do such conversions automatically.\n"
         "\n");
  printx("   $using chain data between commands\n"
         "      #sfk cmd1 ... +then cmd2<def>   does not pass any data to cmd2,\n"
         "                                prints cmd1 output to terminal.\n"
         "      #sfk ... +toterm<def>           dumps current chain content to terminal.\n"
         "      #sfk ... +tofile outfile<def>   dumps chain content to file outfile.\n"
         "      #sfk ... +tovoid +cmd2<def>     does not pass any data to cmd2,\n"
         "                                drops cmd1 chain text silently.\n"
         "      in all cases, the chain is cleared. if another command is following,\n"
         "      it will receive no input from the chain.\n"
         "\n");
  printx("   $no data tunneling\n"
         "      chain data can only be passed\n"
         "      - from a data producing command like  #+echo mytext<def>\n"
         "      - directly to the following command\n"
         "        if it consumes data like            #+setvar myvar<def>\n"
         "      - but not through a non consumer like #+tell othertext<def>\n"
         "      $bad example:\n"
         "        #sfk echo mytext +tell hello +setvar a\n"
         "          stops with an error at setvar: no chain data\n"
         "      $good example:\n"
         "        #sfk echo mytext +setvar a +tell hello +getvar\n"
         "          mytext is stored, hello is printed\n"
         "\n"
         "      in other words, in a command chain like:\n"
         "      #sfk cmd1 +cmd2 +cmd3 +cmd4 +cmd5\n"
         "      it is not possible to send data from cmd1 to cmd3/4/5\n"
         "      if cmd2 does $not<def> use any chain data (e.g. if, tell).\n"
         "      since sfk 1.9.3 this bypassing of cmd2 is disabled\n"
         "      to avoid conflicts by unwanted chain data in cmd3/4/5.\n"
         "      the only exception is: $cmd1 +label name +cmd2<def>\n"
         "      use global option -keepdata or set environment variable\n"
         "         <exp> SFK_CONFIG=keepdata\n"
         "      for the sfk 1.9.2 behaviour which was inconsistent\n"
         "      and worked only with some commands.\n"
         "\n"
         "   $using chain data with call / label / end\n"
         "      #sfk ... +call myfunc<def>      passes no chain data into myfunc\n"
      // "      #sfk ... +tcall myfunc<def>     passes text data into myfunc\n"
      // "      #sfk ... +fcall myfunc<def>     passes filenames into myfunc\n"
         "      #sfk label ... +end<def>        returns no chain data\n"
      // "      #sfk label ... +tend<def>       returns text data\n"
      // "      #sfk label ... +fend<def>       returns a filename list\n"
         "\n");
  printx("   $if chaining stops with \"no files, stopping at x\":\n"
         "\n"
         "      this means command x expects a list of filenames,\n"
         "      but the previous command did not produce any.\n"
         "      you have three options then:\n"
         "\n"
         "      - use #+then x<def> if command x should never receive any\n"
         "        filenames from a previous command.\n"
         "\n"
         "      - or add #-keepchain<def> at the preceeding command, or\n"
         "        directly after sfk, to enforce execution of command x.\n"
         "\n"
         "      - or use #-nonote<def> to suppress the \"no files\" message.\n"
         "\n"
         "      note that #-keepchain<def> is default since sfk 1.9.9.\n" // sfk1990
         "      if you get a 'no files' stop although, look in options\n"
         "      and SFK_CONFIG if 'stoponempty' is set.\n"
         "\n");
  printx("   $scope and lifetime of options\n"
         "      most options are valid only for the command where they are specified.\n"
         "      if another command follows in the chain, the option is reset.\n"
         "      but some options may also be specified on a global scope.\n"
         "      read more on that under \"$sfk help options<def>\".\n"
         "\n"
         "   $global options\n"
         "      -tracechain   get verbose output while sfk steps\n"
         "                    through a command chain\n"
         "\n"
         );
         /*
         "   $tracing a data flow within a script\n"
         "      set global option $-iotrace<def> like:\n"
         "\n"
         "         #sfk -iotrace script myfile.bat -from begin<def>\n"
         "\n"
         "      which produces a mixed command output and iotrace.\n"
         "      to get only the clean iotrace without command output use\n"
         "\n"
         #ifdef _WIN32
         "         #myfile.bat >nul\n"
         #else
         "         #myfile.bat >/dev/null\n"
         #endif
         "\n"
         "      as iotrace goes to stderr instead of normal output.\n"
         "\n"
         "      if iotrace tells \"=> send to +cmd\" and you don't want\n"
         "      data being passed to that command, but instead want it\n"
         "      printed on terminal, use \"+then cmd\" in the chain.\n"
         "\n"
         */
  printx("   $more in the SFK Book\n"
         "      the #SFK Book<def> contains long examples with input,\n"
         "      output, script and detailed command explanations.\n"
         "      type \"#sfk book<def>\" for more.\n"
         "\n"
         "   $see also\n"
         "      #sfk batch<def>     create an example script\n"
         "      #sfk help var<def>  how to use sfk variables\n"
         "      #sfk script<def>    about sfk scripting\n"
         "      #sfk call<def>      calling a function in a script\n"
         "      #sfk label<def>     possible options with label\n"
         "      #sfk if<def>        conditional execution\n"
         "      #sfk goto<def>      jump to a local label\n"
         "      #sfk for<def>       repeat commands n times\n"
         "      #sfk load<def>      load text or data for chaining\n"
         );
   }

   if (!strncmp(pszSub, "env", 3))
   {
  printx("$sfk help env\n"
         "\n"
         "   $sfk supports these environment variables:\n"
         "\n"
         "      #SFK_CONFIG<def>   -> sfk help opt\n"
         "      #SFK_COLORS<def>   -> sfk help color\n"
         "      #SFK_OWN_IP<def>   -> sfk ip -h\n"
         "      #SFK_OWN_NET<def>  -> sfk ip -h\n"
         "      #SFK_LOGTO<def>    -> sfk tonetlog\n"
         "      #SFK_FTP_*<def>    -> sfk ftpserv -h, sfk ftp\n"
         "      #SFK_PROXY<def>    -> sfk wget, sfk web\n"
         "      #SFK_HOME<def>     -> sfk home -h\n"
         "      #SFK_PATH<def>     -> sfk mkcd, sfk alias\n"
         "      #SFK_ZIP_EXT<def>  -> sfk help opt\n"
         "\n"
         "   sfk also uses the PATH environment variable,\n"
         "   to find it's own location with some commands.\n"
         "      -> sfk mkcd\n"
         "      -> sfk alias\n"
         "\n");
   }

   if (!strncmp(pszSub, "var", 3))
   {
  printx("$sfk parameters and variables support\n"
         "\n"
         "   $sfk script parameters\n"
         "\n"
         "      -  look like #%%1 %%2 %%3<def> to #%%9<def>,\n"
         "         or with sfk for windows also like #$$1 $$2 $$3<def>.\n"
         "\n"
         "      -  are used with sfk #script<def> and #call / label<def>.\n"
         "\n"
         "      -  are passed into the script or label command chain\n"
         "         wherein they are never changed.\n"
         "\n");
  webref("helpvar");
  printx("      $example:\n"
         "         $--- file filt.bat begin ---\n"
         "         sfk #script<def> \"%%~f0\" -from begin %%*\n"
         "         GOTO end\n"
         "         sfk #label<def> begin\n"
         "            +filter %%1 %%2\n"
         "            +end\n"
         "         :end\n"
         "         $--- file filt.bat end ---\n"
         "         typing \"#filt.bat in.txt -+foo<def>\" will run sfk filter\n"
         "         using the parameters \"in.txt\" and \"-+foo\".\n"
         "         under windows %%~f0 is the absolute batch filename\n"
         "         itself including extension .bat or .cmd.\n"
         "\n");
  printx("   $sfk global variables\n"
         "\n"
         "      -  are set like:\n"
         "         sfk #setvar<def> myvar=\"the test text\" ...\n"
         "         sfk echo foo #+setvar<def> myvar ...\n"
         "         sfk xed in.txt \"/foo*bar/#[setvar myvar][part2][endvar]<def>/\" ...\n"
         "\n"
         "      -  are used by further commands in the chain like:\n"
         "         sfk ... #+getvar myvar\n"
         "         sfk ... +echo -var \"using <examp>##(myvar)<def>\"\n"
         "         sfk ... +xed \"_<foo>*</foo>_[part1]#[getvar myvar]<def>[part3]_\"\n"
         "\n"
         "      -  allowed variable names:\n"
         "         must start with a-z, then a-z0-9_\n"
         "\n"
         "      to use variable contents by a hash pattern <examp>##(name),\n"
         "      option #-var<def> must be given. this can be done locally\n"
         "      at the command, or globally directly after sfk:\n"
         "         sfk #-var<def> setvar a=foo +echo \"using ##(a)\"\n"
         "\n"
         "      when creating a sfk script batch file by\n"
         "         #sfk batch myfile.bat\n"
         "      this starts with \"sfk -var\" by default, as hash patterns\n"
         "      are mainly used in longer scripts.\n"
         "\n"
         "      $examples:\n"
         "         #sfk setvar file=in.txt +filter -var \"##(file)\" -+foo\n"
         "            runs sfk filter, giving the input filename by variable.\n"
         "         #sfk xex in.txt \"/foo=*/[setvar fooval][part2][endvar]/\"\n"
         "          #+echo -var \"foo is: ##(fooval)\"\n"
         "            extract foo=(any text) from in.txt, place the found\n"
         "            text into variable fooval, then print it. [19]\n"
         "\n");
  printx("   $sfk predefined variables\n"
         "\n"
         "      <examp>##(sys.slash)<def>    produces \\ under windows, / under linux.\n"
         "      <examp>##(sys.sfkver)<def>   current sfk version.\n"
         #ifdef _WIN32
         "      <examp>##(sys.numcols)<def>  number of console columns.\n"
         #endif
         "      <examp>##(sys.ownscript.name)<def>  filename of current script.\n"
         "\n"
         "      to get the text of the current script, use for example:\n"
         "      <examp>sfk ... +getvar sys.ownscript.text +filter ...\n"
         "\n");
  printx("   $environment variable access\n"
         "\n"
         "      can be done like ##(env.varname). varname is case\n"
         "      insensitive under windows and uses case on linux.\n"
         "\n"
         "      $example:\n"
         "         sfk -var echo \"tmp contains: ##(env.TMP)\"\n"
         "\n"
         );
  printx("   $sfk local command variables\n"
         "\n"
         "      -  are created directly from input text\n"
         "         produced by a previous command in the command chain\n"
         "\n"
         "      -  are suppported only within some commands like\n"
         "         #sfk run \"... <run>text ....\"\n"
         "            runs an external program once for every input line.\n"
         "         #sfk perline \"... <run>text ...\"\n"
         "            runs sfk internal commands once for every input line.\n"
         "         #sfk filter -tabform \"... <run>col1 ... <run>col2 ...\"\n"
         "            splits text lines by TAB char, allowing reformatting.\n"
         "         type #sfk run<def>, #sfk perline<def> etc. for further infos.\n"
         "\n");
  printx("   $see also\n"
         "      #sfk setvar<def>    set an SFK variable\n"
         "      #sfk addtovar<def>  append text lines to an SFK variable\n"
         "      #sfk incvar<def>    increment a numeric variable\n"
         "      #sfk decvar<def>    decrement a numeric variable\n"
         "      #sfk getvar<def>    get SFK or environment variable\n"
         "\n");
  printx("   $sfk variable output formatting\n"
         "\n"
         "      $formal syntax:\n"
         "\n"
         "         ##(-03.4varname)\n"
         "\n"
         "      $with possible control characters:\n"
         "         -   format left justified, else right\n"
         "         0   fill with zeros, else with blanks\n"
         "         .4  take up to 4 chars from variable\n"
         "\n"
         "      $example: if variable i contains \"1\" then\n"
         "\n"
         "         $command                 output\n"
         "         +echo -var \">##(i)<\"     >1<\n"
         "         +echo -var \">##(3i)<\"    >  1<\n"
         "         +echo -var \">##(-3i)<\"   >1  <\n"
         "         +echo -var \">##(03i)<\"   >001<\n"
         "\n"
         "      $example: if variable s contains \"abcde\" then\n"
         "\n"
         "         $command                 output\n"
         "         +echo -var \">##(.3s)<\"   >abc<\n"
         "         +echo -var \">##(5.3s)<\"  >  abc<\n"
         "\n");
  printx("   $sfk variable functions\n"
         "\n"
         "      when reading variable text like ##(varname) some extra\n"
         "      functions can be applied using ##(func(varname,...)).\n"
         "      available functions are:\n"
         "\n"
         "      #strpos(v,'text')<def>        get index of text within v.\n"
         "                              0=first char, -1=not found\n"
         "      #strpos(v,-case 'text')<def>  same, case sensitive (fast)\n"
         "      #strpos(v,myvar)<def>         get index of text from myvar\n"
         "                              within text of variable v.\n"
         "      #strpos(v,-spat '\\x20')<def>  search using slash patterns\n"
         "      #strrpos(v,'text')<def>       search from right side\n"
         "      #contains(v,'text')<def>      tells 1 if text is found in v,\n"
         "                              else 0. accepts -case and -spat\n"
         "      #contains(v,-case a)<def>     tells if text from variable a\n"
         "                              is contained within v using\n"
         "                              fast case sensitive search\n"
         "      #begins(v,'word')<def>        check if string starts with word.\n"
         "                              returns 1 (yes) or 0 (no).\n"
         "      #ends(v,'word')<def>          check if string ends with word.\n"
         "                              returns 1 (yes) or 0 (no).\n"
         "      #substr(v,o[,l])<def>         substring from offset o length l\n"
         "                              which can be variables themselves.\n"
         "                              offset 0 is first char. negative o\n"
         "                              starts from right side minus o.\n"
         "      #rsubstr(v,o[,l])<def>        substring from right side taking\n"
         "                              up to l chars in left direction.\n"
         "      #[l/r]trim(v)<def>            strip whitespace at sides\n"
      // "      #lpad(v,n)<def>               fill left side up to n chars\n"
      // "      #rpad(v,n)<def>               fill right side up to n chars\n"
         "      #isset(v)<def>                tells 1 if v is set, else 0\n"
         "      #isempty(v)<def>              tells 1 if not set or empty\n"
         "      #size(v)<def>                 number of bytes in v\n"
         "      #strlen(v)<def>               number of characters in v,\n"
         "                              if it contains just plain text\n"
         "      #numlines(v)<def>             number of lines in v\n"
         "\n");
      /*
         "      $examples:\n"
         "      #sfk -var setvar a=\"foo bar\"\n"
         "         #+echo \"##(substr(a,4,3))\"<def>    - prints 'bar'\n"
         "         #+echo \"##(strpos(a,'bar'))\"<def>  - prints '4'\n"
         "      #sfk -var setvar a=\"foo\"\n"
         "         #+echo \"##(lpad(a,6))\"<def>        - prints '   foo'\n"
         "\n"
         );
      */
  printx("      $example: if variable s contains \"foo bar\" then\n"
         "\n"
         "      $command                           output\n"
         "      +echo -var \"##(substr(a,4,3))\"     bar\n"
         "      +echo -var \"##(strpos(a,'bar'))\"   4\n"
         "\n");
   }

   if (!strcmp(pszSub, "shell"))
   {
      printx(
         "$Configure the windows Command Prompt this way:\n"
         "\n"
         "  1. if you don't have an 'sfk shell' icon already\n"
         "     create a shell shortcut on your desktop:\n"
         "     - Start/Programs/Accessories/Command Prompt,\n"
         "       right mouse button, select Copy.\n"
         "     - go to an empty place on the desktop.\n"
         "     - select Paste.\n"
         "\n"
         "  2. on the new desktop shortcut,\n"
         "     - press right mouse button, select Properties.\n"
         "\n"
         "  3. in the Command Prompt Properties, set\n"
         "     - #Options: activate QuickEdit and Insert mode.\n"
         "                disable line wrapping selection, if set,\n"
         "                to allow vertical text selection.\n"
      // "     - #Font   : select 8 x 12\n"
         "     - #Layout : Screen buffer size: Width 160, Height 3000\n"
         "       #         Window size       : Width 160, Height   30\n"
         "\n"
         "  4. close Properties by clicking OK.\n"
         "\n"
         "  5. double-click on the icon to open a new shell.\n"
         "\n"
         "$Now you have a well configured power shell:\n"
         "\n"
         "   - any command output is remembered #up to 3000 lines<def>.\n"
         "\n"
         "   - you may select command output anytime with left mouse button,\n"
         "     then click right button #to copy to clipboard<def>.\n"
         "     right click again to #paste clipboard as a command<def>.\n"
         "\n"
         "   - to #pause<def> a program that prints output to the screen,\n"
         "     do a #dummy-select<def> of text with the left mouse button.\n"
         "     to continue program execution, press right button, or enter.\n"
         "     this may not work with (default settings) of windows 11.\n"
         "\n"
         "$Automatic Command Completion\n"
         "\n"
         "   Question: #how do you enter the directory VeryMuchToTypeFooBarSystem ?\n"
         "\n"
         "   Answer 1: type \"cd verymuchtotypefoobarsystem\"\n"
         "\n"
         "             this is actually what most users do, and it's a waste of time.\n"
         "\n"
         "   Answer 2: #type \"cd very\" and then press the TAB key.\n"
         "\n"
         "             since Windows XP, command completion is default.\n"
         "\n"
         "   Under Win98 and Win2k, completion it is NOT default. As a workaround,\n"
         "   you may type \"cd very*\", or run regedit and set the registry key value\n"
         "   HKEY_CURRENT_USER\\Software\\Microsoft\\Command Processor\\CompletionChar to 9.\n"
         );
   }

   if (!strcmp(pszSub, "pat"))
   {
      printx("$sfk wildcards and text patterns%s:\n",
             bhelp ? " (type \"sfk help patterns\")":"");
      printx("\n"
         "   $available wildcards:\n"
         "      * = any number of characters.\n"
         "      ? = a single character.\n"
         "\n"
         "   $available slash patterns:\n"
         "      \\t   = TAB\n"
         "      \\q   = double quote \"\n"
         "      \\r   = carriage return\n"
         "      \\n   = linefeed\n"
         "      \\xnn = any character with hexadecimal value nn,\n"
         "             e.g. \\x09 is the same as \\t (TAB)\n"
         "      \\\\   = the backslash \\ itself\n"
         "      \\\\*   = the star '*' itself     [only with some commands]\n"
         "      \\?   = quotation mark '?'      [only with some commands]\n"
         "\n"
         "   $support by commands:\n"
         "\n"
         "      if any command supports slash patterns,\n"
         "\n"
         "      - they are not active by default, except for commands\n"
         "        starting with \"x\" that use SFK Expressions.\n"
         "\n"
         "      - to use, say -spat directly after the command name:\n"
         "        #sfk echo -spat \"three\\tlittle\\ttabs\\t.\"\n"
         "        prints: #three   little  tabs    .\n"
         "\n"
         "      - to activate slash patterns globally over multiple commands\n"
         "        of a command chain, say -spat directly after \"sfk\":\n"
         "        #sfk -spat echo \"two\\ttabs\" +filter -rep \"x\\tx_x\"\n"
         "        prints: #two_tabs\n"
         "\n"
         "      if any command supports wildcards,\n"
         "\n"
         "      - they are active by default.\n"
         "\n"
         "      - they can be deactivated by option -literal or -lit,\n"
         "        if you need to find/replace '*' or '?' characters themselves:\n"
         "        #sfk echo \"*** ok ***\" +filter -lit -rep \"_*_=_\"\n"
         "        prints: #=== ok ===\n"
         "\n"
         "      - to deactivate globally over multiple commands of a chain,\n"
         "        say -literal directly after \"sfk\":\n"
         "        #sfk -literal echo \"*** ok ???\" +filter -lit -rep \"_?_!_\"\n"
         "        prints: #*** ok !!!\n"
         "\n"
         "      - another way to find/replace '*' or '?' is to say -spat\n"
         "        and then to use \\\\* and \\? patterns:\n"
         "        #sfk echo \"*** ok ***\" +filter -spat -rep \"_\\\\*_=_\"\n"
         "        prints: #=== ok ===\n"
         "\n"
         "      further reading:\n"
         "\n"
         "         $sfk help options<def> - general options reference\n"
         "         $sfk help chain<def>   - about command chaining\n"
         );
   }

   if (!strcmp(pszSub, "chars"))
   {
      printx("$characters and codepages with SFK for Windows%s:\n",
             bhelp ? " (type \"sfk help chars\")":"");

      printx(
         "\n"
         "   SFK uses 8-bit character codes with a possible\n"
         "   range of 255 different characters. see: #sfk ascii\n"
         "\n"
         "   character codes 32-126, or hexadecimal 0x20-0x7E,\n"
         "   are 7-bit ASCII characters. within SFK they are\n"
         "   called \"Low Codes\", or #LoCodes<def>. as long as you\n"
         "   use only #a-z A-Z 0-9 !\"##$$%%&_<def> etc. you use #LoCodes,<def>\n"
         "   which will work the same on every computer in the\n"
         "   world, and you can #ignore code pages.\n"
         " \n"
         "   but as soon as you want to use #accent characters,\n"
         "   #umlauts, cyrillic, greek<def> etc. you need #HiCodes<def>\n"
         "   in the range 0x80-0xFF. these are dependent on the\n"
         "   codepages of your Windows system, and you can only\n"
         "   use chars of #your own language, plus English<def>.\n"
         "\n"
         );

      #ifdef _WIN32
      printx(
         "   $your Windows CMD.EXE command line uses two codepages:\n"
         "\n"
         "   #1. ANSI codepage %u for data processing.\n"
         "      every text within SFK is encoded in this codepage.\n"
         "      Most text editor programs like Notepad will\n"
         "      use this codepage by default.\n"
         " \n"
         "   #2. Dos/OEM codepage %u for input and display.\n"
         "      what you type on your keyboard is encoded in %u.\n"
         "      the CMD.EXE terminal can only display HiCodes in\n"
         "      this codepage correctly.\n"
         "\n"
         , GetACP()  // NOT sfkchars
         , GetOEMCP()
         , GetOEMCP()
         );
      #else
      printx(
         "   $the Windows CMD.EXE command line uses two codepages:\n"
         "\n"
         "   #1. ANSI codepage for data processing.\n"
         "      every text within SFK is encoded in this codepage.\n"
         "      Most text editor programs like Notepad will\n"
         "      use this codepage by default.\n"
         " \n"
         "   #2. Dos/OEM codepage for input and display.\n"
         "      what you type on your keyboard is encoded in that.\n"
         "      the CMD.EXE terminal can only display HiCodes in\n"
         "      this codepage correctly.\n"
         "\n"
         );
      #endif

      printx(
         "   $HiCode conversions step by step:\n"
         "\n"
         "   -  when you run sfk, and pass parameters, these are\n"
         "      converted from $OEM to Ansi<def> and then given to sfk.\n"
         "      so sfk gets only Ansi encoded parameters.\n"
         "\n"
         "   -  within SFK all data processing is $done with Ansi,<def>\n"
         "      e.g. filter ... +xed ... will pass Ansi text.\n"
         "\n"
         "   -  when $printing text to terminal,<def> SFK converts it\n"
         "      from $Ansi to OEM<def> for output. otherwise HiCodes\n"
         "      would all look wrong, as the terminal needs OEM.\n"
         "\n"
         "   -  when $writing text output to file,<def> like\n"
         "         filter ... >out.txt\n"
         "         filter ... +tofile out.txt\n"
         "      it is $written as Ansi,<def> without any conversion.\n"
         "      you can then open out.txt with the Notepad\n"
         "      or Depeche View, which expect Ansi text,\n"
         "      and HiChars will display correctly.\n"
         "\n"
         );
      printx(
         "   $Beware of HiCodes within batch files.\n"
         " \n"
         "   -  if you run SFK interactively like:\n"
         "         #sfk filter in.txt -+myword\n"
         "      and myword contains HiCodes, you type them\n"
         "      all as OEM chars, and it works.\n"
         " \n"
         "   -  if you create a batch file with Windows Notepad,\n"
         "      and therein type\n"
         "         #sfk filter in.txt -+myword\n"
         "      and myword contains HiCodes, you will find that\n"
         "      filter no longer finds the word.\n"
         "      Because Notepad created an Ansi encoded text file,\n"
         "      so the \"myword\" chars are Ansi encoded.\n"
         "\n"
         "      $what happens?\n"
         "      -  CMD.EXE still thinks \"myword\" is OEM,\n"
         "         and incorrectly \"converts\" it to Ansi,\n"
         "         which actually breaks all HiCode chars.\n"
         "      -  sfk.exe then gets myword with completely\n"
         "         wrong encoding, and the search fails.\n"
         "\n"
         "      $how to fix this:\n"
         "      -  #write your .bat files with OEM encoding.\n"
         "         this can be done with $Notepad++:\n"
         "         -  create a new file mytest.bat\n"
         "         -  select: #Encoding / Character Set / your area,\n"
         "            then select your OEM codepage.\n"
         "         -  now type sfk commands into the batch file,\n"
         "            and save it.\n"
         "      -  side effect: if you create sfk scripts\n"
         "         embedded in such a batch file, like:\n"
         "            #sfk batch mytest2.bat\n"
         "         searches therein will fail again if this\n"
         "         is OEM encoded. because by default \"sfk script\"\n"
         "         wants to load Ansi text. to fix this use\n"
         "         option -dos like: #sfk script -dos ...\n"
         "\n"
         );
      printx(
         "   $What is not possible?\n"
         " \n"
         "   SFK cannot process any text outside your Ansi codepage.\n"
         "\n"
         "   for example, if a computer uses Western Europe\n"
         "   codepage 1252, it is possible to search German umlauts\n"
         "   and some French accent characters. but it is impossible\n"
         "   to search and filter cyrillic text (encoded in 1251),\n"
         "   and it will even be impossible to type cyrillic chars\n"
         "   in the first place, as the keyboard has no such keys.\n"
         "\n"
         );
      printx(
         "   $see also:\n"
         "      #sfk help nocase<def>   about case insensitive search\n"
         "      #sfk help unicode<def>  unicode to Ansi conversion\n"
         "\n"
         );
   }

   if (!strcmp(pszSub, "nocase"))
   {
      printx("$case insensitive search and file selection%s:\n",
             bhelp ? " (type \"sfk help nocase\")":"");
      printx("\n"
         "   since version 1.9.0 $SFK for Windows<def> supports\n"
         "   case insensitive search $within the codepage of\n"
         "   $your Windows system<def>. for example,\n"
         "\n"
         "   - computers with german or french locale with codepage\n"
         "     1252 may search german and french text, ignoring case\n"
         "     for accent and umlaut characters.\n"
         "\n"
         "   - computers with russian locale with codepage 1251\n"
         "     may search cyrillic text, case insensitive.\n"
         "\n"
         "   but you may $not<def> search french text on a russian\n"
         "   locale case insensitive, as codepage 1251 does\n"
         "   not contain the required accent characters.\n"
         "\n"
         "   this means to use case insensitive search you are\n"
         "   limited to $search your own language<def>, plus english.\n"
         "\n"
         #ifdef _WIN32
         "   to see what codepage your system uses, type:\n"
         "\n"
         "      #sfk sysinfo\n"
         "\n"
         "   to force codepage 1252 (ISO 8859-1) internally in SFK,\n"
         "   no matter what the actual system codepage is,\n"
         "   use global option #-isochars<def> directly after sfk,\n"
         "   or set the environment like:\n"
         "\n"
         "      #SET SFK_CONFIG=isochars\n"
         "\n"
         "   this is recommended when creating script packackes\n"
         "   for distribution that must behave the same on any\n"
         "   computer, regardless of the local codepage.\n"
         "\n"
         #endif
         "   to see in detail how characters are mapped during\n"
         "   case insensitive search, use global option -tracecase:\n"
         "\n"
         "      #sfk -tracecase filter in.txt -+myword\n"
         "\n"
         "   use -tracecase2 to also show chars which are not mapped\n"
         "   because they are lowercase already, or not a letter.\n"
         "\n"
         #ifdef _WIN32
         "   for the full list of SFK character mappings see:\n"
         "\n"
         "      #sfk listcodes\n"
         "\n"
         #endif
         "   $case search options:\n"
         "      #-case<def>       search case sensitive, a != A\n"
         "      #-nocase<def>     search case insensitive (default),\n"
         "                  a == A and a_accent == A_accent\n"
         "                  depending on your codepage\n"
         "      #-nocasemin<def>  search case insensitive but only\n"
         "                  latin characters a-z (ASCII low codes)\n"
         #ifdef _WIN32
         "      #-deacc<def>      use accent insensitive text search\n"
         "                  and filename selection, i.e.\n"
         "                  a == A == a_accent == A_accent.\n"
         "                  cannot be combined with -case.\n"
         "                  can also be set by environment like:\n"
         "                  #SET SFK_CONFIG=deacc\n"
         "\n"
         "   $see also\n"
         "      #sfk help chars<def>   about codepages\n"
         #endif
         "\n"
         "   $SFK for Linux<def> can only search latin base characters\n"
         "   from A to Z case insensitive, without any accents.\n"
         );
   }

   if (!strcmp(pszSub, "wsp"))
   {
      printx("<help>$white space protection (sfk help wsp)\n"
             "\n"
             "   whitespace protection protects groups of spaces\n"
             "   and blank lines in a text, to make sure they are\n"
             "   kept in email text or forum posts.\n"
             "\n"
             "   If you write a structured plain ASCII text like\n"
             " \n"
             "      #shopping list:\n"
             " \n"
             "      #      fruit       price    quantity\n"
             "      #   -  apples      2.5         3\n"
             "      #   -  bananas     4.5         1\n"
             " \n"
             "      #   -  cakes:\n"
             "      #      -  strawberry\n"
             "      #      -  pineapple\n"
             " \n"
             "   and want to send this by email, or post it in a forum,\n"
             "   it may get reduced to junk like:\n"
             " \n"
             "      # shopping list:\n"
             " \n"
             "      # fruit price quantity\n"
             "      # - apples 2.5 3\n"
             "      # - bananas 4.5 1\n"
             "      # - cakes:\n"
             "      # - strawberry\n"
             "      # - pineapple\n"
             "\n"
             "   this sick behaviour is called \"whitespace normalization\",\n"
             "   nowadays contained in many programs. some mail or forum\n"
             "   clients allow to select plain text instead, but many do not.\n"
             "\n"
             "   whitespace is required to structure text.\n"
             "\n"
             "   so the only way to protect it is:\n"
             "\n"
             "   - copy your text to clipboard\n"
             "\n"
             "   - type: #sfk enmail.<def>     (with a dot '.')\n"
             "     this does: #sfk fromclip +encode -wsp +toclip\n"
             "\n"
             "   - and paste that into your email client.\n"
             "\n"
             "   basically, the text is stuffed with $protected spaces\n"
             "   (ASCII code 160 or \\xa0). they look like normal spaces,\n"
             "   but are not allowed to be removed.\n"
             "\n"
             "   the receiver may not even notice the protected spaces.\n"
             "   but if he wants to convert the text back to normal spaces:\n"
             " \n"
             "   - copy text from the email to clipboard\n"
             "   - type: #sfk demail.\n"
             "   - paste that into your editor.\n"
             "\n"
             "   $Please note:\n"
             "    - this function is intended only to keep the formatting\n"
             "      of a quick mail text or post. for longer text or even\n"
             "      tab separated data dumps, avoid wsp but use file attachments,\n"
             "      as the protected spaces may render text unusable\n"
             "      for other software.\n"
             "\n"
             );
   }

   if (!strcmp(pszSub, "offtime"))
   {
      printx("$about offtimes in zip files\n"
         "\n"
         "zip files contain 3 types of timestamps:\n"
         "\n"
         "-  NTFS UTC time\n"
         "-  Unix UTC time\n"
         "-  DOS  local time\n"
         "\n"
         "UTC is a global timestamp completely independent\n"
         "from time zones and DST (daylight saving time).\n"
         "so naturally, if a file has an UTC time 12345 stored\n"
         "on disk, the zip file entry should get UTC 12345 as well.\n"
         "\n"
         "but some complexity trolls invented this definition\n"
         "on how to store UTC time in a zip file:\n"
         "\n"
         "1. IF the computer currently runs in summer time,\n"
         "   THEN, for files in the winter time range,\n"
         "   reduce the time by 1 hour.\n"
         "\n"
         "2. IF the computer currently runs in winter time,\n"
         "   THEN, for files in the summer time range,\n"
         "   increase the time by 1 hour.\n"
         "\n"
         "3. Do this on Windows only, but not on Linux/Mac\n"
         "   to make those systems incompatible.\n"
         "\n"
         "4. Do this on NTFS only, but not on FAT file systems\n"
         "   to make zip files even more incompatible.\n"
         "\n"
         "this unlogic behaviour is called \"offtimes\" in sfk,\n"
         "and many zip processing programs show this behaviour,\n"
         "leading to pure chaos.\n"
         "\n"
         "sfk, on the opposite, stores only pure unmodified\n"
         "times by default. so to be on the safe side,\n"
         "create and extract archives with sfk only.\n"
         "\n"
         "if you really need time 'compatibility' with a\n"
         "specific program you may try option -offtime with\n"
         "sfk zip or unzip. this modifies times by one hour\n"
         "depending on DST, ignoring OS or file system.\n"
         "this is experimental, and may help or not.\n"
         );
   }

   if (!strcmp(pszSub, "basic"))
   {
   printx("$sfk basic informations (type \"sfk basic\"):\n"
          "\n");
   printx("   $All tree walking commands support file selection this way:\n"
          "\n"
          "   1. short format with ONE directory tree and MANY file name patterns:\n"
          "\n"
          "      #src1dir .cpp .hpp .xml bigbar <not>footmp\n"
          "\n"
          "   2. short format with a list of explicite file names:\n"
          "\n"
          "      #letter1.txt revenues9.xls report3<sla>turnover5.ppt\n"
          "\n"
          "   3. long format with MANY dir trees and file masks PER dir tree:\n"
          "\n"
          "      #-dir src1 src2 <not>src<sla>save -file foosys .cpp -dir bin5 -file .exe\n"
          "\n"
          "   For detailed help on file selection, type #\"sfk help select\"<def>.\n"
          "\n");
   printx("   %c and ? wildcards are supported within filenames. \"foo\" is interpreted\n"
          "   as \"%cfoo%c\", so you can leave out %c completely to search a part of a name.\n"
          "   For name start comparison, say \"%cfoo\" (finds foo.txt but not anyfoo.txt).\n"
          "\n"
          "   When you supply a directory name, by default this means \"take all files\".\n"
          ,glblWildChar,glblWildChar,glblWildChar,glblWildChar,glblPathChar);
   #ifndef _WIN32
   if (!bhelp) setTextColor(nGlblWarnColor);
   printx("   Use %c or \\* instead of *, and \\? instead of ?, as * and ? are eaten by the\n"
          "   command shell. You may also redefine %c through export SFK_CONFIG=wildstar:c\n"
          ,glblWildChar,glblWildChar);
   if (!bhelp) setTextColor(-1);
   #endif
   printx("\n"
          "      #sfk list mydir<def>                lists all files of mydir.\n"
          "      #sfk list mydir foo<def>            lists files having 'foo' in their name.\n"
          "      #sfk list mydir .cpp .hpp<def>      lists files ending .cpp or .hpp.\n"
          "      #sfk list mydir <not>.cfg<def>          lists all files of mydir except .cfg\n"
          "\n"
          );
   printx("   $general options:\n"
          "      -nosub     do not include files within subdirectories.\n"
          "      -tracesel  tells in detail which files and/or directories are included\n"
          "                 or excluded, and why (due to which user-supplied mask).\n"
          "      -quiet     or -nohead shows less output on some commands.\n"
          "      -nocol     before any command switches off color output.\n"
          #ifdef _WIN32
          "      -hidden    includes hidden and system files and dirs.\n"
          #endif
          "      For detailed help on all options, type #\"sfk help options\".\n"
          "\n");
   #ifdef _WIN32
   printx("   $configure your windows CMD.exe properly.\n"
          "      select many display columns, 3000 lines for scrollback\n"
          "      and copy/paste of displayed text. #\"sfk help shell\"<def> for more.\n"
          "\n");
   printx("   $beware of slash and quote caveats in CMD.exe\n"
          "   -  if you type #sfk tell \"dir c:\\\"<def> it prints $dir c:\"<def>\n"
          "      without slash. use \\\\\" instead.\n"
          "   -  if you use #sfk tell \"using: %%1\"<def> in a batch file tmp.bat,\n"
          "      then try: #tmp.bat -foo=bar<def> it prints: $using: -foo<def>\n"
          "      because CMD.exe drops the '=bar'. use #tmp.bat \"-foo=bar\"<def> instead.\n"
          "\n");
   #endif
   printx("   $beware of Shell Command Characters.\n" // main help, just reference
          "      parameters containing #spaces<def> or characters #<>|!&?*<def> must be #sur-\n"
          "      #rounded by quotes \"\"<def>. type \"#sfk filter<def>\" for details and examples.\n"
          "\n");
   #ifdef _WIN32
   printx("   $beware of Automated Data Processing on different machines.\n"
          "      if you write scripts for distribution on many Windows machines\n"
          "      they may behave different, depending on the system codepage.\n"
          "      to avoid this use -isochars. for details see: #sfk help nocase\n"
          "\n");
   #else
   printx("   $More output columns?\n"
          "      <exp> SFK_CONFIG=columns:160\n"
          "\n");
   #endif
   printx("   $WRONG COLORS? Use one of:\n"
          "      <exp> SFK_COLORS=on             for generic colors\n"
          "      <exp> SFK_COLORS=theme:black    for DARK    backgrounds\n"
          "      <exp> SFK_COLORS=theme:white    for BRIGHT  backgrounds\n"
          "      see also \"sfk help colors\"\n");
   }

   if (!strcmp(pszSub, "tcp"))   // sfk1972
   {
  printx("$sfk tcp toolkit\n"
         "\n"
         "   you can use in a script:\n"
         "\n"
         "   #+connect host:port\n"
         "      connect to a server\n"
         #ifdef WITH_SSL
         "      -ssl        using TLS/SSL\n"
         "      -verbose=2  show infos on SSL handshake\n"
         #endif // WITH_SSL
         "\n"
         "   #+send \"text\"\n"
         "      send text. when doing this in a script, multi line\n"
         "      text is joined as is, stripped from leading or\n"
         "      trailing blanks per line.\n"
         "      -addcrlf    add CRLF per line (no default).\n"
         "      -spat       use slash patterns like \\r\\n\n"
         "                  for details see: sfk help pat\n"
         "      -fromvar=a  send data from variable a\n"
         "      -verbose    tell exactly what is sent\n"
         "\n"
         "   #+receive [options]\n"
         "      receive some data.\n"
         "      -line       receive single text line until (CR)LF\n"
         "      -until p    receive until (slash) pattern p\n"
         "      -timeout=n  wait up to n msec, or until connection\n"
         "                  close is detected.\n"
         "      -nostop     don't try to detect connection close,\n"
         "                  wait the full timeout.\n"
         "      -maxlen=n   receive up to n bytes. default is 100000.\n"
         "      -tovar=a    put output into variable a.\n"
         "\n"
         "   #+disconnect\n"
         "      close connection\n"
         "\n"
         "   #+accept port\n"
         "      be a server, accept connections on given port.\n"
         "      this creates a server- and a client socket.\n"
         "\n"
         "   #+closeaccept\n"
         "      close server socket.\n"
         "\n"
         "   also see the help text of each command for possible\n"
         "   further options and examples.\n"
         "\n"
         "   $options for multiple connections\n"
         "      -chan[nel]=n  set a channel number (1-19).\n"
         "         default with connect/send/recv/disc is 1.\n"
         "         default for accept server socket is 2,\n"
         "                 for accept client socket is 1.\n"
         "\n"
         "   $see also\n"
         "      #sfk batch tcp.bat<def>      create example batch\n"
         "      #sfk batch tcp.sh<def>       create example .sh\n"
         #ifdef _WIN32
         "      #sfk batch tcpserv.bat<def>  a simple http server\n"
         #else
         "      #sfk batch tcpserv.sh<def>   a simple http server\n"
         #endif
         "\n"
         );
   }

   if (!strcmp(pszSub, "knxdump"))
   {
   printx("<help>$sfk knxdump\n"
          "\n"
          "   show incoming knx messages send by knx/ip router.\n"
          "   does not support secure knx, or knx interfaces.\n"
          "\n"
          "   $please note\n"
          "      because this uses multicast I/O it may\n"
          "      or may not work, depending on many factors.\n"
          "      see \"sfk udpdump\" for details.\n"
          "\n"
          "   $options\n"
          "      -full  show detail data\n"
          "\n"
          "   $see also\n"
          "      #sfk knxsend<def>   send knx messages.\n"
          "\n");
   printx("   $examples\n"
          "      #sfk knxdump\n"
          "          print messages on the default group 224.0.23.12\n"
          "          in a minimum single line format\n"
          "      #sfk knxdump -full 224.0.23.13\n"
          "          print full messages from an alternative IP group\n"
          "      #sfk knxdump -text \" 1/*/3 \" -from=100\n"
          "          print only messages having GA's starting 1 and\n"
          "          ending 3 in their knx header info text, coming from\n"
          "          an IP like 192.168.1.100 in the local network\n"
          "      #sfk knxdump -verbose\n"
          "          print a hex dump of search request responses\n"
          );
   }

   if (!strcmp(pszSub, "knxsend"))
   {
  printx("<help>$sfk knxsend cmdstring\n"
          "\n"
          "   send knx messages to a knx/ip router.\n"
          "   does not support secure knx, or knx interfaces.\n"
          "\n"
          "   $please note\n"
          "      because this uses multicast I/O it may\n"
          "      or may not work, depending on many factors.\n"
          "      see \"sfk udpdump\" for details.\n"
          "\n"
          "   $see also\n"
          "      #sfk knxdump<def>   show incoming knx messages.\n"
          "\n");
   printx("   $examples\n"
          "      #sfk knxsend \"1 2 3 1 0\"\n"
          "          send to group address 1/2/3 a 1 bit value \"0\".\n"
          "      #sfk knxsend \"1 2 3 8 255\"\n"
          "          send to group address 1/2/3 an 8 bit value \"255\".\n"
          "      #sfk knxsend \"1 2 3 16 0x0cb0\"\n"
          "          send to GA 1/2/3 the 16 bit (2 bytes) raw data\n"
          "          given as hex values. no conversion is done.\n"
          "      #sfk knxsend \"1 2 3 16 2400\"\n"
          "          send 16-bit decimal value which is converted to\n"
          "          knx mantissa/exponent value 0x0cb0. this example\n"
          "          could be a temperature of 24.00 degrees.\n"
          "      #sfk knxsend \"1 2 3 14 my test text\"\n"
          "          send a 14 bytes text message\n"
          "      #sfk knxsend 224.0.23.13 \"1 2 3 8 255\"\n"
          "          send on alternative IP group\n"
          "      #sfk knxsend 127.0.0.1:3671 \"31 7 255 1 1\"\n"
          "          send to unicast localhost address port 3671\n"
          "      #sfk knxsend \"1 2 3 4 1\"\n"
          "          send to address 1/2/3 a 4 bit dimm down start.\n"
          "      #sfk knxsend \"1 2 3 4 0\"\n"
          "          send to address 1/2/3 a 4 bit dimm stop.\n"
          "      #sfk knxsend search\n"
          "          sends an IP router search request.\n");
   printx("      #sfk knxsend \"1/2/3 int8 -128\"<def>            - send 8-bit negative value\n"
          "      #sfk knxsend \"1/2/3 int16 65535\"<def>          - send 16-bit unsigned value\n"
          "      #sfk knxsend \"1/2/3 int16 -32768\"<def>         - send 16-bit signed value\n"
          "      #sfk knxsend \"1/2/3 int32 2000000\"<def>        - send 32-bit unsigned value\n"
          "      #sfk knxsend \"1/2/3 int32 -2000000\"<def>       - send 32-bit signed value\n"
          "      #sfk knxsend \"1/2/3 float16 670760.96\"<def>    - send 16-bit float\n"
          "      #sfk knxsend \"1/2/3 float32 1.234\"<def>        - send IEEE 754 float\n"
          "      #sfk knxsend \"1/2/3 text testing 123\"<def>     - send text\n"
          "      #sfk knxsend \"1/2/3 time tue 11:53:30\"<def>    - send time with weekday\n"
          "      #sfk knxsend \"1/2/3 date 04.05.21\"<def>        - send date\n");
   }

   if (!strcmp(pszSub, "faq"))
   {
      printx(
"start of filename comparison: use \"\\pattern\". see also \"name start\"\n"
"traveling, walking subdirectories or subfolders: is default. type \"sfk help select\"\n"
"find in text files: \"sfk find\", \"sfk hexfind\", \"sfk filter\"\n"
"find text, data in binary files, binaries: \"sfk find\", \"sfk hexfind\"\n"
"find same, identical, duplicate files: \"sfk dupfind\"\n"
"compare directories, folders, differences: \"sfk list\" with -sincedir option\n"
"find different files, differences: \"sfk md5check\", \"sfk list\" with -sincedir\n"
"list, find newest, oldest, latest files of dir: \"sfk list\" with -late, -old\n"
"list, find most recent files of dir: \"sfk list\" with -late, -old\n"
"list, sort, order dir files by date, timestamp: \"sfk list\" with -late, -old\n"
"list, find largest, biggest, smallest dir files: \"sfk list\" with -big, -small\n"
"list, find files changed today, since a date: \"sfk list\" with -since\n"
"sort dir contents by date, time, size: \"sfk list\" with -late, -big\n"
"symbolic links: see \"sfk help opt\" option -nofollow\n"
"regular expressions: not supported, but see \"sfk help patterns\"\n"
"list, show files, directory tree size, largest dirtree: see \"sfk stat\"\n"
"split text lines, column data by characters: \"sfk filter\" with -sep, -form\n"
"extract, remove text blocks between marker lines: \"sfk filter\" with -inc, -cut\n"
"create, verify md5sum, md5 checksum for dir, files: \"sfk md5gento\", \"sfk md5check\", \"sfk md5\"\n"
"convert binary to c++, cpp, java sourcecode: \"sfk bin-to-src\"\n"
"split large text or binary files: \"sfk split\"\n"
"transfer files from windows host to linux vmware: \"sfk ftpserv\", \"sfk ftp\"\n"
"find, where are classes inside, within jar files tree: \"sfk list\" with -arc\n"
"all class packages in jar dirs: \"sfk list\" with -arc\n"
"list, get all files in jars in all dirs: \"sfk list -arc . .jar\"\n"
"find, replace words in text, binary files: \"sfk replace\", \"sfk filter\"\n"
"find, replace hex pattern in binary files: \"sfk hexfind\", \"sfk replace\"\n"
"patch binary file contents: \"sfk replace\"\n"
"convert text file, dos, windows, linux crlf line endings, format: \"sfk addcr\", \"sfk remcr\"\n"
"replace, add, remove, strip, convert text file crlf line endings: \"sfk addcr\", \"sfk remcr\"\n"
"find, print, read first, last lines of text files: \"sfk head\", \"sfk tail\"\n"
"print, read head or tail of files: \"sfk head\", \"sfk tail\"\n"
"find command, cmd, bat, exe file in path: \"sfk pathfind\"\n"
"remove, replace tabs by spaces in text file lines: \"sfk detab\"\n"
"insert, remove text in files: \"sfk replace\", \"sfk filter\" with -write\n"
"find, list files in a dir sorted by size, time: \"sfk list\" with -big, -late\n"
"copy content, extract, view text of a binary file: \"sfk partcopy\", \"sfk strings\"\n"
"run user defined command, processing many files: \"sfk run\"\n"
"run a command on each file, line of file: \"sfk run\", \"sfk filter thefile.txt +run \"mycmd <run>text\"\"\n"
"replace, remove spaces in filenames, dir names: \"sfk deblank\"\n"
"join, add text, binary files: \"sfk snapto\", \"sfk join\"\n"
"adding delay, pause to command file: \"sfk sleep\", \"sfk pause\"\n"
"set, create, define alias for .cmd, .bat, command path in shell: \"sfk alias\"\n"
"delete .bak, .tmp, temporary files: \"sfk sel . .bak +del\"\n"
"convert binary file to text, source code: \"sfk hexdump\", \"sfk bin-to-src\"\n"
"hex to byte, convert hex dump, file into binary file: \"sfk hextobin\"\n"
"count files in dir tree: \"sfk list ... +count\"\n"
"create text file from dir listing: \"sfk list ... +tofile\"\n"
"create large text, binary file for tests: \"sfk make-random-file\"\n"
"delete files by extension: \"sfk del mydir .ext\"\n"
"trace, hexdump, dump TCP data, browser connection: \"sfk tcpdump\"\n"
"tcpdump of http request in plain text: \"sfk tcpdump\" with -flat\n"
"echo staying on same line, without lf: \"sfk echo\" with -noline\n"
"shell echo with colored words in red, green, blue: \"sfk echo\"\n"
"open, read text from clipboard: \"sfk fromclip\"\n"
"file copy to clipboard: \"sfk filter ... +toclip\"\n");
printx(
"find unprintable, nonprintable characters : \"sfk hexfind\" with -bin\n"
"find duplicate lines in a text file: \"sfk count\" with -samelines\n"
"find data, hex numbers in binary files: \"sfk hexfind\"\n"
"find, replace text with wildcards: \"sfk filter\"\n"
"find, get, list files matching patterns: \"sfk list\"\n"
"cut, remove, filter empty, blank lines from text files: \"sfk filter\" with -no-blank-lines\n"
"replace any, accent, umlaut characters in text files: \"sfk replace\"\n"
"check, find dependencies of binaries, executables files: \"sfk deplist\"\n"
"find, list number of files in a directory: \"sfk list mydir +count\"\n"
"add current, any dir to a file list: \"sfk list . >>myfilelist.txt\"\n"
"strip, skip text file lines by filter, markers: \"sfk filter\" with -!mypattern or -cut\n"
"cut, strip, exclude lines by words from text files: \"sfk filter\" with -!word1 -!word2\n"
"list files of dir needing no wildcard: \"sfk list mydir *foo*\" == \"sfk list mydir foo\"\n"
"write shell script with command chaining: \"sfk script\", \"sfk samp\"\n"
#ifdef _WIN32
"to create multi line commands, use ^ at the end of .bat lines, or \"sfk script\"\n"
#else
"to create multi line commands, use \"sfk script\"\n"
#endif
"if content(s) are too large to load, see -memlimit under \"sfk help opt\"\n"
"replace colors in text lines: \"sfk filter\" with -highlight\n"
"jpeg, jpg, png image processing, conversion: \"sfk samp javaimg\", \"sfk samp phpimg\""
 " or google for imagemagick.\n"
"all zip tar gz bz2 file extensions recognized by sfk: type \"sfk help opt\"\n"
"process files changed from, until a date: see option -since and -before\n"
      );
#ifdef _WIN32
      printx(
"print, get, dump clipboard contents: \"sfk fromclip\"\n"
      );
#endif
   }
}

// emod help
#endif // (sfk_prog || sfk_help)

// dmod text_patch
#if (sfk_prog || sfk_file_patch)

#ifndef USE_SFK_BASE

// ------------- sfk patch - Text File Patching support -----------------

#define SFKPATCH_MAX_CMDLINES    10000 // max lines per :file ... :done block
#define SFKPATCH_MAX_CACHELINES  10000 // max lines per :from ... :to pattern
#define SFKPATCH_MAX_NUMCMD        500 // max number of :from commands per patchfile
#define SFKPATCH_MAX_OUTLINES   500000 // max lines per target file

class SFKPatch
{
public:
      SFKPatch ( );
     ~SFKPatch ( );
 
static SFKPatch
   *current    ( );

   int processCmdPatch(char *psz);
   int processCmdInfo (char *psz);
   void log(int nLevel, const char *pFormat, ... );
   int detabLine(char *pBuf, char *pTmp, int nBufSize, int nTabSize);
   int processCmdRoot (char *pszIn);
   int patchMainInt(int argc, char *argv[], int offs);
   char *skipspace(char *psz);
   int processPatchFile(char *pszPatchFileName);
   int processCmdFile(char *pszIn);
   int processCreateFile(char *pszIn);
   int processCreateDir(char *pszIn);
   void shrinkLine(char *psz, char *pszOut);
   int compareLines(char *psz1, char *psz2);
   int processFileUntilDone(char *pszTargFileName);

static SFKPatch
   *pClCurrent;

FILE *fpatch;
char *pszRoot;
char szCmdBuf[MAX_LINE_LEN];
int  bGlblRevoke;
int  bGlblBackup;
int  bGlblSimulate;
int  bGlblTouchOnRevoke;
int  nCmdFileLineEndings;
int  nGlblLine;
int  bGlblIgnoreWhiteSpace;
int  bGlblAlwaysSimulate;
int  bGlblVerbose;
int  bGlblQuickSum;
int  bGlblUnixOutput;
int  nGlblPatchedFiles;
int  nGlblRevokedFiles;
char *pszGlblRelWorkDir;
int  bGlblAnySelRep;
int  bGlblCheckSelRep;
int  bGlblStats;
int  nGlblDetabOutput;
int  bGlblVerify;
int  bGlblNoPID ;
int  bGlblIgnoreRoot;
char **apOut;

// select-replace table over all targets
#define MAX_GLOBAL_CHANGES 50
char *apGlobalChange[MAX_GLOBAL_CHANGES][3];
int anGlobalChange[MAX_GLOBAL_CHANGES];
int iGlobalChange;

// select-replace table local to current target
#define MAX_LOCAL_CHANGES 50
char *apLocalChange[MAX_LOCAL_CHANGES][3];
int anLocalChange[MAX_GLOBAL_CHANGES];
int iLocalChange;

char *aPatch[SFKPATCH_MAX_CMDLINES];
char *aBuf[SFKPATCH_MAX_CACHELINES];
int   aifrom[SFKPATCH_MAX_NUMCMD];
int   aifromlen[SFKPATCH_MAX_NUMCMD];
int   aito[SFKPATCH_MAX_NUMCMD];
int   aitolen[SFKPATCH_MAX_NUMCMD];

char szLine1[MAX_LINE_LEN];
char szLine2[MAX_LINE_LEN];
};

class PatchMemCover {
public:
   PatchMemCover  ( ) {
      bdead = 0;
      SFKPatch::current()->apOut = new char*[SFKPATCH_MAX_OUTLINES+10];
      if (!SFKPatch::current()->apOut)
         bdead = 1;
   }
   ~PatchMemCover ( ) {
      if (SFKPatch::current()->apOut) {
         delete [] SFKPatch::current()->apOut;
         SFKPatch::current()->apOut = 0;
      }
   }
   int bdead;
};

SFKPatch *SFKPatch :: pClCurrent = 0;

SFKPatch :: SFKPatch( )
{
   memset(this, 0, sizeof(*this));
   bGlblTouchOnRevoke = 1;
   nCmdFileLineEndings = -1;
   bGlblIgnoreWhiteSpace = 1;
}

SFKPatch *SFKPatch :: current( )
{
   if (!pClCurrent)
      pClCurrent = new SFKPatch();

   return pClCurrent;
}

int patchMain(int argc, char *argv[], int offs)
{
   return SFKPatch::current()->patchMainInt(argc, argv, offs);
}

int SFKPatch :: processCmdPatch(char *psz) { return 0; }
int SFKPatch :: processCmdInfo (char *psz) { return 0; }

// 0 == error, >0 == normal msg, >= 5 do not tell if in QuickSum mode
void SFKPatch :: log(int nLevel, const char *pFormat, ... )
{
   va_list argList;
   va_start(argList, pFormat);
   if (nLevel == 0) {
      vfprintf(stderr, pFormat, argList);
      fflush(stderr);
   } else {
      if (!(bGlblQuickSum && nLevel >= 5)) {
         vprintf(pFormat, argList);
         fflush(stdout);
      }
   }
   va_end(argList);
}

int SFKPatch :: detabLine(char *pBuf, char *pTmp, int nBufSize, int nTabSize)
{
   strcpy(pTmp, pBuf);
   int iout=0, nInsert=0;
   for (int icol=0; pTmp[icol] && iout < (nBufSize-nTabSize-2); icol++) {
      char c1 = pTmp[icol];
      if (c1 == '\t') {
         nInsert = nTabSize - (iout % nTabSize);
         for (int i2=0; i2<nInsert; i2++)
            pBuf[iout++] = ' ';
      } else {
         pBuf[iout++] = c1;
      }
   }
   pBuf[iout] = '\0';
   if (iout >= (nBufSize-nTabSize-2)) {
      log(0, "error  : detab: line buffer overflow. max line len supported is %d\n",(nBufSize-nTabSize-2));
      return 9;
   }
   return 0;
}

int SFKPatch :: processCmdRoot (char *pszIn) {
   strcpy(szCmdBuf, pszIn);
   char *psz = 0;
   if ((psz = strchr(szCmdBuf, '\r')) != 0) *psz = 0;
   if ((psz = strchr(szCmdBuf, '\n')) != 0) *psz = 0;
   pszRoot = strdup(szCmdBuf);
   if (!bGlblIgnoreRoot && strcmp(pszRoot, pszGlblRelWorkDir)) {
      log(0, "error  : you are not in the %s directory.\n",pszRoot);
      return 1+4;
   }
   return 0;
}

int SFKPatch :: patchMainInt(int argc, char *argv[], int offs)
{
   PatchMemCover mem;
   if (mem.bdead) {
      log(0, "error: out of memory in patchMain\n");
      return 9;
   }

   if (!strcmp(argv[1+offs], "-example"))
   {
      printx(
         "#patchfile example, containing all supported patchfile commands:\n\n"
         ":patch \"enable FooBar testing\"\n"
         ":info makes some stuff public, for direct access by test funcs\n"
         "\n"
         ":root foosrc\n"
         "\n"
         ":file include\\Foobar.hpp\n"
         ":from \n"
         "private:\n"
         "    bool                  isAvailable               (int nResource);\n"
         "    void                  openBar                   (int nMode);\n"
         ":to\n"
         "public: // [patch-id]\n"
         "    bool                  isAvailable               (int nResource);\n"
         "    void                  openBar                   (int nMode);\n"
         ":from \n"
         "    // returns the application type, 0x00 == not set.\n"
         "    UInt16                getAppType                ( );\n"
         ":to\n"
         "    // returns the application type, 0x00 == not set.\n"
         "    UInt16                getAppType                ( );\n"
         "    UInt32                getAppTypeInternal        ( );\n"
         ":done\n"
         "\n"
         ":## this is a remark, allowed only outside :file blocks.\n"
         ":## the above syntax is sufficient for most cases; but now follow some\n"
         ":## more commands for global replace, file and dir creation, etc.\n"
         ":## select-replace has 3 parms, and applies changes (parms 2+3) only\n"
         ":## in lines containing the search term (parm 1).\n"
         "\n"
         ":file include\\Another.cpp\n"
         ":select-replace /MY_TRACE(/\\n\"/\"/\n"
         ":select-replace _printf(\"spam: _printf(_while(0) printf(_\n"
         ":set only-lf-output\n"
         ":from \n"
         "    bool                  existsFile                (char *psz);\n"
         ":to\n"
         "    // [patch-id]\n"
         "    int                   existsFile                (char *psz);\n"
         ":done\n"
         "\n"
         ":mkdir sources\n"
         ":create sources\\MyOwnFix.hpp\n"
         "// this file is generated by sfk patch.\n"
         "##define OTHER_SYMBOL MY_OWN_SYMBOL\n"
         ":done\n"
         "\n"
         ":skip-begin\n"
         "this is outcommented stuff. the skip-end is optional.\n"
         ":skip-end\n"
         );
      return -1;
   }

   if (!strcmp(argv[1+offs], "-template") || !strcmp(argv[1+offs], "-tpl"))
   {
      printf(
         ":patch \"thepatch\"\n"
         "\n"
         ":root theproject\n"
         "\n"
         ":file include\\file1.hpp\n"
         ":from \n"
         ":to\n"
         "    // [patch-id]\n"
         ":from \n"
         ":to\n"
         ":done\n"
         "\n"
         ":file sources\\file1.cpp\n"
         ":from \n"
         ":to\n"
         "    // [patch-id]\n"
         ":done\n"
         "\n"
         );
      return -1;
   }

   szCmdBuf[0] = '\0';
   #ifdef _WIN32
   if (_getcwd(szCmdBuf,sizeof(szCmdBuf)-10)) { }
   #else
   if (getcwd(szCmdBuf,sizeof(szCmdBuf)-10)) { }
   #endif
   char *psz = strrchr(szCmdBuf, glblPathChar);
   if (!psz) {
      log(0, "error: cannot identify working dir. make sure you are in the correct directory.\n");
      return 9;
   }
   psz++;
   pszGlblRelWorkDir = strdup(psz);
 
   char *pszPatchFileName = 0;
   char *pszPatchFileBackup = 0;
   int bWantRevoke = 0;
   int bWantRedo   = 0;
   int bJustSim    = 0;

   for (int iarg=1; iarg<argc; iarg++) {
      if (!strcmp(argv[iarg+offs], "-revoke")) {
         bWantRevoke = true;
      }
      else
      if (!strcmp(argv[iarg+offs], "-redo")) {
         bWantRevoke = true;
         bWantRedo   = true;
      }
      else
      if (!strcmp(argv[iarg+offs], "-keep-dates")) {
         bGlblTouchOnRevoke = 0;
      }
      else
      if (!strcmp(argv[iarg+offs], "-exact-match")) {
         bGlblIgnoreWhiteSpace = 0;
      }
      else
      if (!strcmp(argv[iarg+offs], "-sim")) {
         bJustSim = 1;
      }
      else
      if (!strcmp(argv[iarg+offs], "-verify")) {
         bJustSim    = 1;
         bGlblVerify = 1;
      }
      else
      if (!strcmp(argv[iarg+offs], "-qs")) {
         bGlblQuickSum = 1;
      }
      else
      if (!strcmp(argv[iarg+offs], "-verbose")) {
         bGlblVerbose = 1;
      }
      else
      if (!strcmp(argv[iarg+offs], "-stat")) {
         bGlblStats = 1;
      }
      else
      if (!strcmp(argv[iarg+offs], "-nopid")) {
         bGlblNoPID = 1;
      }
      else
      if (!strcmp(argv[iarg+offs], "-anyroot")) {
         bGlblIgnoreRoot = 1;
      }
      else
      if (!strncmp(argv[iarg+offs], "-", 1)) {
         printf("unknown option: %s\nuse with no parameters to get help.\n",argv[iarg+offs]);
         return 9;
      }
      else {
         pszPatchFileName = argv[iarg+offs];
         char *psz = strrchr(pszPatchFileName, glblPathChar);
         if (!psz) psz = strrchr(pszPatchFileName,':');
         if (!psz) { psz = pszPatchFileName; } else psz++;
         sprintf(szCmdBuf,"save_patch%c%s", glblPathChar, psz);
         pszPatchFileBackup = strdup(szCmdBuf);
      }
   }

   // pass -1: check logic
   if (bJustSim && bWantRevoke) {
      log(0, "error  : cannot simulate and revoke together.\n");
      return 9;
   }

   // pass 0: init stats
   for (int i1=0; i1<MAX_GLOBAL_CHANGES; i1++)
      anGlobalChange[i1] = 0;
   for (int i2=0; i2<MAX_LOCAL_CHANGES; i2++)
      anLocalChange[i2]  = 0;

   // pass 1: revoke: always, unconditional.
   int iRC = 0;
   if (bWantRevoke) {
      bGlblRevoke = 1;
      if (fileExists(pszPatchFileBackup)) {
         log(5, "* revoking changes from: %s\n", pszPatchFileBackup);
         iRC = processPatchFile(pszPatchFileBackup);
      } else {
         log(5, "* revoking changes from: %s\n", pszPatchFileName);
         iRC = processPatchFile(pszPatchFileName);
      }
      bGlblRevoke = 0;
      if (!iRC && !bWantRedo) {
         if (bGlblQuickSum) {
            printf("* patch revoked: %s - %d target files\n",pszPatchFileName,nGlblRevokedFiles);
         } else {
            if (bGlblTouchOnRevoke)
               printf("* all changes revoked. the target files got the current time stamp,\n"
                      "* to ease recompile. you may use -keepdates to change this behaviour.\n");
            else
               printf("* all changes revoked, including original timestamps.\n");
         }
      }
      if (!iRC) {
         // remove patchfile backup
         if (fileExists(pszPatchFileBackup))
            if (remove(pszPatchFileBackup)) {
               log(0, "error  : cannot remove stale backup: %s\n",pszPatchFileBackup);
               return 1;
            }
      }
      if (!iRC && !bWantRedo)
         return 0;
   }

   // pass 2: pre-scan if all patches may be applied
   bGlblSimulate = 1;
   if (!iRC) {
      log(5, "* checking target file compliancies\n");
      iRC = processPatchFile(pszPatchFileName);
   }
   if (bJustSim) {
      if (!iRC) {
         if (bGlblQuickSum)
          printf("* patch %s: %s\n", bGlblVerify ? "intact" : "valid", pszPatchFileName);
         else
          printf("* all checked. the patch is %s.\n", bGlblVerify ? "still intact" : "valid and may be applied.");
         return 0;
      } else {
         if (bGlblQuickSum)
            log(0, "patch  : %s\n",pszPatchFileName);
         printf("* there were errors. the patch cannot be applied.\n");
         printf("* however, if an older patch is active, you may still -revoke it.\n");
         return 1;
      }
   }
   bGlblSimulate = 0;

   // pass 3: create backups
   if (!iRC && !bGlblNoPID) {
      log(5, "* creating backups\n");
      bGlblBackup = 1;
      iRC = processPatchFile(pszPatchFileName);
      bGlblBackup = 0;
   }

   // pass 3: apply patches
   if (!iRC) {
      log(5, "* applying patches%s\n", bGlblNoPID?" permanently":"");
      bGlblCheckSelRep = 1;
      iRC = processPatchFile(pszPatchFileName);
      if (!iRC) {
         if (bWantRedo) {
            if (bGlblQuickSum)
               printf("* all changes re-applied: %s - %d target files\n",pszPatchFileName,nGlblPatchedFiles);
            else
               printf("* all changes re-applied.\n");
         } else {
            if (bGlblQuickSum) {
               printf("* patch applied: %s - %d target files\n",pszPatchFileName,nGlblPatchedFiles);
            } else {
               printf("* all done.\n");
            }
         }
         // patch applied: save the patchfile for future revoke
         if (!bGlblNoPID)
         {
         #ifdef _WIN32
         _mkdir("save_patch");
         #else
         mkdir("save_patch", S_IREAD | S_IWRITE | S_IEXEC);
         #endif
         FILE *fout = fopen(pszPatchFileBackup,"w");
         if (fout) { fprintf(fout,"dummy"); fclose(fout); }
         #ifdef _WIN32
         sprintf(szCmdBuf, "xcopy /Q /K /Y %s %s >nul",pszPatchFileName,pszPatchFileBackup);
         #else
         sprintf(szCmdBuf, "cp -p %s %s",pszPatchFileName,pszPatchFileBackup);
         #endif
         iRC = system(szCmdBuf);
         if (iRC)
            log(0, "error  : cannot backup patchfile to: %s\n",pszPatchFileBackup);
         }
      } else {
         if (iRC & 4)
            log(0, "info   : make sure you are above the \"%s\" directory.\n",pszRoot);
      }
   } else {
      if (bGlblQuickSum)
         log(0, "patch  : %s\n",pszPatchFileName);
      if (iRC & 4) {
         log(0, "info   : make sure you are in the \"%s\" directory.\n",pszRoot);
         return iRC;
      }
      printf("* NOTHING CHANGED: i will either apply ALL changes, or NONE.\n"
             "* you may also try sfk patch -revoke or -redo.\n"
            );
      fflush(stdout);
   }

   return iRC;
}

char *SFKPatch :: skipspace(char *psz) {
   while (*psz && *psz == ' ')
      psz++;
   return psz;
}

int SFKPatch :: processPatchFile(char *pszPatchFileName)
{
   int iRC = 0;

   fpatch = fopen(pszPatchFileName, "r");
   if (!fpatch) { log(0, "error  : cannot open patchfile: %s\n",pszPatchFileName); return 2+4; }
   nGlblLine = 0;

   // parse patch file, exec commands
   int bWithinSkip = 0;
   char szBuf[MAX_LINE_LEN];
   while (fgets(szBuf,sizeof(szBuf)-10,fpatch) != NULL)
   {
      nGlblLine++;

      // determine line endings of the command file
      if (nCmdFileLineEndings == -1)
      {
         if (strstr(szBuf,"\r\n") != 0)
            nCmdFileLineEndings = 2;   // CR/LF
         else
            nCmdFileLineEndings = 1;   // LF only
      }

      if (strBegins(szBuf,":#"))
         continue;

      if (strBegins(szBuf,":skip-end")) {
         if (!bWithinSkip) {
            log(0, "error  : skip-end without skip-begin in line %d\n",nGlblLine);
            return 2;
         }
         bWithinSkip = 0;
         continue;
      }

      if (strBegins(szBuf,":skip-begin")) {
         if (bWithinSkip) {
            log(0, "error  : skip-begin twice in line %d\n",nGlblLine);
            return 2;
         }
         bWithinSkip = 1;
         continue;
      }

      if (bWithinSkip)
         continue;

      if (strBegins(szBuf,":patch ")) {
         iRC |= processCmdPatch(skipspace(szBuf+7));
         continue;
      }
      if (   strBegins(szBuf,":info ")
          || strBegins(szBuf,":info\r")
          || strBegins(szBuf,":info\n")
         )
      {
         iRC |= processCmdInfo(skipspace(szBuf+6));
         continue;
      }
      if (strBegins(szBuf,":root ")) {
         if (processCmdRoot(skipspace(szBuf+6)))
            return 1+4;
         continue;
      }
      if (strBegins(szBuf,":select-replace "))
      {
         bGlblAnySelRep = 1;
         if (iGlobalChange < MAX_GLOBAL_CHANGES-2) {
            char *psz = skipspace(szBuf+strlen(":select-replace "));
            char  nCC = *psz++;
            char *pszMaskBegin = psz;
            while (*psz && (*psz != nCC)) psz++;
            char *pszMaskEnd   = psz;
            if (*psz) psz++;
            char *pszFromBegin = psz;
            while (*psz && (*psz != nCC)) psz++;
            char *pszFromEnd   = psz;
            if (*psz) psz++;
            char *pszToBegin   = psz;
            while (*psz && (*psz != nCC)) psz++;
            char *pszToEnd     = psz;
            *pszMaskEnd = 0;
            *pszFromEnd = 0;
            *pszToEnd   = 0;
            if (strlen(pszFromBegin) > 0) {
               char *pszMaskDup = strdup(pszMaskBegin);
               char *pszFromDup = strdup(pszFromBegin);
               char *pszToDup   = strdup(pszToBegin);
               apGlobalChange[iGlobalChange][0] = pszMaskDup;
               apGlobalChange[iGlobalChange][1] = pszFromDup;
               apGlobalChange[iGlobalChange][2] = pszToDup;
               iGlobalChange++;
            }
         } else {
            log(0, "error  : too many global select-replace, only up to %d supported.\n",MAX_GLOBAL_CHANGES);
            return 2;
         }
         continue;
      }
      if (strBegins(szBuf,":create ")) {
         iRC |= processCreateFile(skipspace(szBuf+8));
         continue;
      }
      if (strBegins(szBuf,":mkdir ")) {
         iRC |= processCreateDir(skipspace(szBuf+7));
         continue;
      }
      if (strBegins(szBuf,":file ")) {
         iRC |= processCmdFile(skipspace(szBuf+6));
         continue;
      }
      if (strBegins(szBuf,":set only-lf-output")) {
         bGlblUnixOutput = 1;
         continue;
      }
      if (strBegins(szBuf,":set detab=")) {
         nGlblDetabOutput = atol(szBuf+strlen(":set detab="));
         log(5, "setting detab to %d\n",nGlblDetabOutput);
         continue;
      }
      if (strBegins(szBuf,":")) {
         log(0, "error  : unknown command in line %d: %s\n",nGlblLine,szBuf);
         return 1;
      }

      // everything else handled by processCmdFile
   }

   fclose(fpatch);

   // now that all was processed, cleanup table of global changes
   for (int i=0;i<iGlobalChange;i++) {
      if (bGlblCheckSelRep) {
         if (!anGlobalChange[i])
            log(5, "info   : global select-replace never applied: %s, %s, %s\n",apGlobalChange[i][0],apGlobalChange[i][1],apGlobalChange[i][2]);
         else
         if (bGlblStats || bGlblVerbose)
            log(5, "global select-replace applied %d times: %s, %s, %s\n",anGlobalChange[i],apGlobalChange[i][0],apGlobalChange[i][1],apGlobalChange[i][2]);
      }
      free(apGlobalChange[i][0]);
      free(apGlobalChange[i][1]);
      free(apGlobalChange[i][2]);
   }
   iGlobalChange = 0;

   return iRC;
}

int SFKPatch :: processCmdFile(char *pszIn)
{
   if (strlen(pszIn) < 1) { log(0, "error  : missing filename after :file\n"); return 2; }

   strcpy(szCmdBuf, pszIn);
   char *psz = 0;
   if ((psz = strchr(szCmdBuf, '\r')) != 0) *psz = 0;
   if ((psz = strchr(szCmdBuf, '\n')) != 0) *psz = 0;
   char *pszFile = strdup(szCmdBuf);
 
   strcpy(szCmdBuf, pszFile);

   // check if file exists
   if (!bGlblRevoke)
      if (!fileExists(szCmdBuf)) {
         log(0, "error  : unable to open file: %s\n",szCmdBuf);
         return 2+4;
      }

   iLocalChange = 0;
   int iRC = processFileUntilDone(szCmdBuf);

   // always cleanup this table, which is feeded by processFileUntilDone
   for (int i=0;i<iLocalChange;i++) {
      if (bGlblCheckSelRep) {
         if (!anLocalChange[i])
            log(5, "info   : local select-replace never applied: %s, %s, %s\n",apLocalChange[i][0],apLocalChange[i][1],apLocalChange[i][2]);
         else
         if (bGlblStats || bGlblVerbose)
            log(5, "local select-replace applied %d times: %s, %s, %s\n",anLocalChange[i],apLocalChange[i][0],apLocalChange[i][1],apLocalChange[i][2]);
      }
      free(apLocalChange[i][0]);
      free(apLocalChange[i][1]);
      free(apLocalChange[i][2]);
   }
   iLocalChange = 0;

   return iRC;
}

int SFKPatch :: processCreateFile(char *pszIn)
{
   if (strlen(pszIn) < 1) { log(0, "error  : missing filename after :create\n"); return 2; }

   strcpy(szCmdBuf, pszIn);
   char *psz = 0;
   if ((psz = strchr(szCmdBuf, '\r')) != 0) *psz = 0;
   if ((psz = strchr(szCmdBuf, '\n')) != 0) *psz = 0;
   char *pszFile = strdup(szCmdBuf);
 
   strcpy(szCmdBuf, pszFile);

   // any existing file?
   if (!bGlblRevoke && !bGlblBackup) {
      if (fileExists(szCmdBuf)) {
         if (!bGlblVerify)
            log(0, "warning: file already exists: %s\n", szCmdBuf);
      } else {
         if (bGlblVerify) {
            log(0, "error  : file no longer exists: %s\n", szCmdBuf);
            return 1;
         }
      }
   }

   FILE *fout = 0;

   if (!bGlblSimulate && bGlblRevoke) {
      // do exact opposite: delete old file
      if (remove(szCmdBuf))
         log(0, "warning: cannot remove: %s\n", szCmdBuf);
      else {
         nGlblRevokedFiles++;
         log(5, "removed: %s\n", szCmdBuf);
      }
   }
   else
   {
      // create new output file
      if (!bGlblSimulate && !bGlblRevoke && !bGlblBackup) {
         fout = fopen(szCmdBuf, "w");
         if (!fout) {
            log(0, "error  : cannot create file: %s\n", szCmdBuf); // return 2+4;
            // fall-through, continue to allow creation of other files.
         }
      }
   }

   // copy-through contents from patchfile until :done
   char szBuf[MAX_LINE_LEN];
   int iout = 0;
   int bGotDone = 0;
   int nStartLine = nGlblLine;
   while (fgets(szBuf,sizeof(szBuf)-10,fpatch) != NULL)
   {
      nGlblLine++;
      if (!strncmp(szBuf, ":done", 5)) {
         bGotDone = 1;
         break;
      }
      if (!bGlblSimulate && !bGlblRevoke && !bGlblBackup && fout) {
         fputs(szBuf, fout);
         iout++;
      }
   }

   // close output file
   if (!bGlblSimulate && !bGlblRevoke && !bGlblBackup && fout) {
      fflush(fout);
      fclose(fout);
      nGlblPatchedFiles++;
      log(5, "written: %s, %d lines.\n",szCmdBuf,iout);
   }

   if (!bGotDone) {
      if (!fout) { log(0, "error  : missing :done after :create of line %d\n", nStartLine); return 2; }
   }

   return 0;
}

int SFKPatch :: processCreateDir(char *pszIn)
{
   if (strlen(pszIn) < 1) { log(0, "error  : missing filename after :mkdir\n"); return 2; }

   strcpy(szCmdBuf, pszIn);
   char *psz = 0;
   if ((psz = strchr(szCmdBuf, '\r')) != 0) *psz = 0;
   if ((psz = strchr(szCmdBuf, '\n')) != 0) *psz = 0;
   char *pszFile = strdup(szCmdBuf);
 
   strcpy(szCmdBuf, pszFile);

   if (!bGlblSimulate && bGlblRevoke) {
      // not yet supported: remove dir on revoke (sequence problem)
      // _rmdir(szCmdBuf);
      return 0;
   }

   // create dir. have to use Win-specific API.
   if (!bGlblSimulate && !bGlblRevoke && !bGlblBackup) {
      #ifdef _WIN32
      int iRC = _mkdir(szCmdBuf);
      #else
      int iRC = mkdir(szCmdBuf, S_IREAD | S_IWRITE | S_IEXEC);
      #endif
      if (!iRC) log(5, "created: %s\n",szCmdBuf);
   }

   return 0;
}

void SFKPatch :: shrinkLine(char *psz, char *pszOut)
{
   int bWithinString = 0;
   int nWhiteCnt = 0;
   for (;*psz; psz++)
   {
      if (*psz == '\r' || *psz == '\n')
         break;   // strip also CR, LF from shrinked strings

      if (*psz == '\"' || *psz == '\'')
         bWithinString = 1-bWithinString;

      if (bWithinString)
         *pszOut++ = *psz;
      else
      if (*psz != ' ' && *psz != '\t') {
         *pszOut++ = *psz;
         nWhiteCnt = 0;
      }
      else {
         // always apply first whitespace
         nWhiteCnt++;
         if (nWhiteCnt == 1)
            *pszOut++ = ' ';
      }
   }
   *pszOut = 0;
}

int SFKPatch :: compareLines(char *psz1, char *psz2)
{
   if (bGlblIgnoreWhiteSpace)
   {
      shrinkLine(psz1, szLine1);
      shrinkLine(psz2, szLine2);
      int iRC = strcmp(szLine1,szLine2);
      if (bGlblVerbose)
      {
         if (iRC)
            printf("src-> %s\npat-> %s\n",szLine1,szLine2);
         else
            printf("src*> %s\npat*> %s\n",szLine1,szLine2);
      }
      return iRC;
   }
   return strcmp(psz1, psz2);
}

int SFKPatch :: processFileUntilDone(char *pszTargFileName)
{
   // INPUT implicite: fpatch stream

   // 1. read next block from patchfile until ":done"
   char szBuf[MAX_LINE_LEN];
   char szBuf2[MAX_LINE_LEN];
   int ipatch = 0;
   while (fgets(szBuf,sizeof(szBuf)-10,fpatch) != NULL)
   {
      nGlblLine++;
      aPatch[ipatch++] = strdup(szBuf);
      aPatch[ipatch] = 0;
      if (ipatch > SFKPATCH_MAX_CMDLINES) { log(0, "command block too large, max %d lines supported.\n",(int)SFKPATCH_MAX_CMDLINES); return 2; }
      if (!strncmp(szBuf, ":done", 5))
         break;
   }

   // 2. find commands
   int icmd=0; int iline=0; int bNextCmd=0; int bDone=0;
   int bWithinToBlock=0, bHavePatchIDForThisFile=0;
   int bFromPassed=0, nLocalDetabOutput=0;
   while (!bDone)
   {
      aifrom   [icmd]=-1;
      aifromlen[icmd]=-1;
      aito     [icmd]=-1;
      aitolen  [icmd]=-1;
      for (;iline<ipatch;iline++)
      {
         if (!strncmp(aPatch[iline],":select-replace ",strlen(":select-replace ")))
         {
            bGlblAnySelRep = 1;
            if (iLocalChange < MAX_LOCAL_CHANGES-2) {
               char *psz = aPatch[iline]+strlen(":select-replace ");
               char  nCC = *psz++;
               char *pszMaskBegin = psz;
               while (*psz && (*psz != nCC)) psz++;
               char *pszMaskEnd   = psz;
               if (*psz) psz++;
               char *pszFromBegin = psz;
               while (*psz && (*psz != nCC)) psz++;
               char *pszFromEnd   = psz;
               if (*psz) psz++;
               char *pszToBegin   = psz;
               while (*psz && (*psz != nCC)) psz++;
               char *pszToEnd     = psz;
               *pszMaskEnd = 0;
               *pszFromEnd = 0;
               *pszToEnd   = 0;
               if (strlen(pszFromBegin) > 0) {
                  char *pszMaskDup = strdup(pszMaskBegin);
                  char *pszFromDup = strdup(pszFromBegin);
                  char *pszToDup   = strdup(pszToBegin);
                  apLocalChange[iLocalChange][0] = pszMaskDup;
                  apLocalChange[iLocalChange][1] = pszFromDup;
                  apLocalChange[iLocalChange][2] = pszToDup;
                  iLocalChange++;
               }
            } else {
               log(0, "error  : too many select-replace in one :file, only up to %d supported.\n",MAX_LOCAL_CHANGES);
               return 2;
            }
            continue;
         }

         if (!strncmp(aPatch[iline],":set detab=",strlen(":set detab="))) {
            nLocalDetabOutput = atol(aPatch[iline]+strlen(":set detab="));
            // log(5, "setting local detab to %d\n",nLocalDetabOutput);
            continue;
         }

         if (!strncmp(aPatch[iline],":from",strlen(":from")))
         {
            bFromPassed = 1;
            bWithinToBlock = 0;
            if (aifrom[icmd] == -1) {
               // starts new command (only at file start)
               aifrom[icmd]    = iline+1;
            } else {
               // ends current command
               aitolen[icmd]   = iline-aito[icmd];
               bNextCmd = 1;
            }
         }

         if (!bFromPassed && !strncmp(aPatch[iline], ":", 1)) {
            log(0, "unexpected command: %s\n", aPatch[iline]);
            return 9;
         }

         if (!strncmp(aPatch[iline],":to",strlen(":to"))) {
            aito[icmd]      = iline+1;
            aifromlen[icmd] = aito[icmd]-aifrom[icmd]-1;
            bWithinToBlock  = 1;
         }

         if (!strncmp(aPatch[iline],":done",strlen(":done"))) {
            // only at EOF
            bWithinToBlock = 0;
            aitolen[icmd]   = iline-aito[icmd];
            bNextCmd = 1;
            bDone = 1;
         }

         if (strstr(aPatch[iline], "[patch-id]") != 0) {
            if (bWithinToBlock)
               bHavePatchIDForThisFile = 1;
            else {
               log(0, "error  : line %d: [patch-id] not allowed within :from block. expected in :to block.\n",nGlblLine);
               return 2;
            }
         }

         if (bNextCmd)
         {
            bNextCmd=0;
            if (aifrom[icmd]   ==-1) { log(0, "error  : line %d: :from block missing\n",nGlblLine); return 2; }
            if (aito[icmd]     ==-1) { log(0, "error  : line %d: :to block missing\n",nGlblLine); return 2; }
            if (aifromlen[icmd]<= 0) { log(0, "error  : line %d: :from block empty\n",nGlblLine); return 2; }
            if (aitolen[icmd]  <= 0) { log(0, "error  : line %d: :to block empty\n",nGlblLine);   return 2; }
            icmd++;
            if (icmd >= SFKPATCH_MAX_NUMCMD-2)   { log(0, "error  : too many commands, only %d supported\n",SFKPATCH_MAX_NUMCMD); return 2; }
            aifrom[icmd]    = iline+1;
            break;
         }

      }  // endfor inner loop

   }  // endfor outer loop (bDone)

   if (!bHavePatchIDForThisFile && !bGlblNoPID) {
      log(0, "error  : line %d: [patch-id] missing!\n",nGlblLine);
      log(0, "info   : you must supply at least one [patch-id] within a :to block per :file,\n"
             "info   : otherwise i cannot identify already-patched files.\n");
      return 2;
   }

   // =========== pre-scan the target file, find out if it's patched =====================

   int bTargetIsPatched = 0;

   FILE *ftarg2 = fopen(pszTargFileName, "r");

   if (!ftarg2) { log(0, "error  : cannot read target file: %s\n", pszTargFileName); return 2+4; }

   while (fgets(szBuf,sizeof(szBuf)-10,ftarg2) != NULL)
      if (strstr(szBuf,"[patch-id]") != 0)
         bTargetIsPatched = 1;

   fclose(ftarg2);

   // ====================================================================================

   char szProbeCmd[MAX_LINE_LEN];

 if (!bGlblSimulate)
 { // begin backup block

   // make a backup of the target file
   char szRelFileName[1024];
   char szBackupDir[MAX_LINE_LEN];
   strcpy(szBackupDir, pszTargFileName);
   char *pszLastDir = strrchr(szBackupDir, glblPathChar);
   // if (!pszLastDir) { log(0, "error  : no '%c' path character in %s, cannot create backup dir.\n", glblPathChar, szBackupDir); return 2; }
   if (pszLastDir) {
      pszLastDir++;
      strcpy(szRelFileName,pszLastDir);
      *pszLastDir = 0;
      strcat(szBackupDir, "save_patch");
   } else {
      // file name without any path:
      strcpy(szRelFileName, pszTargFileName);
      strcpy(szBackupDir, "save_patch");
   }

   // IS a backup file already existing?
   sprintf(szProbeCmd,"%s%c%s",szBackupDir,glblPathChar,szRelFileName);

   // are we by any chance in REVOKE mode?
   if (bGlblRevoke && bTargetIsPatched)
   {
      // YES: copy backup file back.
      char szCopyCmd[MAX_LINE_LEN];
      // 0. ensure backup exists
      if (!fileExists(szProbeCmd)) { log(0, "error  : cannot revoke, no backup file: %s\n",szProbeCmd); return 1+4; }
      // is there an old target?
      if (fileExists(pszTargFileName))
      {
         // 1. ensure target is writeable
         #ifdef _WIN32
         sprintf(szCopyCmd, "attrib -R %s",pszTargFileName);
         #else
         sprintf(szCopyCmd, "chmod +w %s", pszTargFileName);
         #endif
         if (system(szCopyCmd)) { }
         #ifdef _WIN32
         // 2. delete target to ensure copy will work
         sprintf(szCopyCmd, "del %s",pszTargFileName);
         if (system(szCopyCmd)) { }
         #endif
      }
      // 3. copy backup over target
      if (bGlblTouchOnRevoke) {
         // make sure target has current timestamp
         FILE *fsrc = fopen(szProbeCmd, "rb");
         if (!fsrc) { log(0, "error  : cannot open %s\n",szProbeCmd); return 2+4; }
         FILE *fdst = fopen(pszTargFileName,"wb");
         if (!fdst) { log(0, "error  : cannot open %s\n",pszTargFileName); return 2+4; }
         // quick binary block copy
         // size_t fread( void *buffer, size_t size, size_t count, FILE *stream );
         // size_t fwrite( const void *buffer, size_t size, size_t count, FILE *stream );
         size_t ntotal = 0;
         while (1) {
            size_t nread = fread(szCopyCmd, 1, sizeof(szCopyCmd), fsrc);
            if (nread <= 0)
               break;
            fwrite(szCopyCmd, 1, nread, fdst);
            ntotal += nread;
         }
         fclose(fdst);
         fclose(fsrc);
         // write-protect target
         #ifdef _WIN32
         sprintf(szCopyCmd, "attrib +R %s",pszTargFileName);
         #else
         sprintf(szCopyCmd, "chmod -w %s", pszTargFileName);
         #endif
         if (system(szCopyCmd)) { }
         log(5, "revoked: %s, %u bytes\n",pszTargFileName,(unsigned int)ntotal);
         nGlblRevokedFiles++;
      } else {
         // xcopy requires us to create a dummy, otherwise we get a prompting
         FILE *fdst = fopen(pszTargFileName,"w");
         if (!fdst) { log(0, "error  : cannot open %s\n",pszTargFileName); return 2+4; }
         fprintf(fdst, "tmp\n\n"); fflush(fdst);
         fclose(fdst);
         // no overwrite this with /K, keeping potential +R attributes
         #ifdef _WIN32
         sprintf(szCopyCmd, "xcopy /Q /K /Y %s %s >nul",szProbeCmd,pszTargFileName);
         #else
         sprintf(szCopyCmd, "cp -p %s %s",szProbeCmd,pszTargFileName);
         #endif
         int iRC = system(szCopyCmd);
         if (!iRC) {
            log(5, "revoked: %s\n",pszTargFileName);
            nGlblRevokedFiles++;
         } else {
            log(0, "revoke failed: %s\n",pszTargFileName);
            return 1;
         }
      }
      // 4. make backup writeable, and remove
      #ifdef _WIN32
      sprintf(szCopyCmd, "attrib -R %s",szProbeCmd);
      #else
      sprintf(szCopyCmd, "chmod +w %s", szProbeCmd);
      #endif
      if (system(szCopyCmd)) { }
      if (remove(szProbeCmd)) {
         log(0, "error  : cannot delete stale backup: %s\n",szProbeCmd);
         return 1;
      }
      return 0;
   }

   if (bGlblRevoke && !bTargetIsPatched)
   {
      if (!bTargetIsPatched) {
         log(0, "warning: isn't patched, will not revoke: %s\n",pszTargFileName);
      }
   }

   // otherwise continue creating a backup
   if (bGlblBackup)
   {
      // prepare: if stale backup, delete first
      if (fileExists(szProbeCmd))
      {
         // remove old backup, most probably stale
         char szCopyCmd[MAX_LINE_LEN];
         log(5, "del.bup: %s\n",szProbeCmd);
         #ifdef _WIN32
         sprintf(szCopyCmd, "attrib -R %s",szProbeCmd);
         #else
         sprintf(szCopyCmd, "chmod +w %s", szProbeCmd);
         #endif
         if (system(szCopyCmd)) { }
         if (remove(szProbeCmd)) {
            log(0, "error  : cannot delete stale backup: %s\n",szProbeCmd);
            return 1;
         }
      }

      // create backup dir and file
      char szCopyCmd[MAX_LINE_LEN];
      int iRC = 0;
      // sprintf(szCopyCmd,"mkdir %s",szBackupDir);
      // int iRC = system(szCopyCmd); // create backup dir, if not done yet
      #ifdef _WIN32
      if (_mkdir(szBackupDir))
      #else
      if (mkdir(szBackupDir, S_IREAD | S_IWRITE | S_IEXEC))
      #endif
      {
         // log(0, "warning: cannot create backup dir: %s\n",szBackupDir);
         // return 1;
      }
      #ifdef _WIN32
      sprintf(szCopyCmd,"xcopy /Q /K %s %s >nul",pszTargFileName,szBackupDir);
      #else
      sprintf(szCopyCmd,"cp -p %s %s",pszTargFileName,szBackupDir);
      #endif
      iRC = system(szCopyCmd); // create backup file
      if (iRC) {log(0, "error  : creation of backup file failed: RC %d\n",iRC); return 2+4; }
      if (fileExists(szProbeCmd)) {
         log(5, "backupd: %s\n",szProbeCmd);
      } else {
         log(0, "error  : verify of backup file failed: %s\n",szProbeCmd); return 2+4;
      }
      return 0;
   }

 } // end backup block

   if (bGlblRevoke)
      return 0;

   // 3. read and patch the target file
   FILE *ftarg = fopen(pszTargFileName, "r");
   if (!ftarg) { log(0, "error  : cannot read target file: %s\n", pszTargFileName); return 2+4; }

   // we cache the output in memory
   int iout = 0;

   int isrcbuf=0, ipatmatch=0;
   aBuf[0] = 0;
   int icmd2 = 0, nLine = 0, nTargLineEndings = -1;
   while (fgets(szBuf,sizeof(szBuf)-10,ftarg) != NULL)
   {
      nLine++;

      // make sure target file has SAME line endings as cmd file.
      if (nTargLineEndings == -1)
      {
         if (strstr(szBuf,"\r\n") != 0)
            nTargLineEndings = 2;   // CR/LF
         else
            nTargLineEndings = 1;   // LF only
         if (nCmdFileLineEndings != nTargLineEndings)
         {
            log(0, "error  : different line endings!\n");
            log(0, "error  :   the patch file uses %s line endings.\n",(nCmdFileLineEndings==2)?"CR/LF":"LF");
            log(0, "error  :   this target file uses %s line endings: %s\n",(nTargLineEndings==2)?"CR/LF":"LF",pszTargFileName);
            return 2;
         }
      }

      if (strstr(szBuf,"[patch-id]") != 0) {
         if (bGlblVerify) {
            if (!bGlblQuickSum)
               log(5, "checked: %s is still patched\n",pszTargFileName);
            return 0;
         }
         if (!bGlblNoPID) {
            log(0, "error  : %s already patched\n",pszTargFileName);
            return 1;
         }
      }

      // does current in-line match the CURRENT pattern's current line?
      if ((icmd2<icmd) && !compareLines(szBuf,aPatch[aifrom[icmd2]+ipatmatch]))
      {
         ipatmatch++;
         aBuf[isrcbuf++] = strdup(szBuf);
         if (isrcbuf > SFKPATCH_MAX_CACHELINES-10) { log(0, "pattern cache overflow, %d lines exceeded\n",(int)SFKPATCH_MAX_CACHELINES); return 2; }
         if (ipatmatch == aifromlen[icmd2]) {
            // full pattern match:
            // write replacement pattern
            for (int i3=0;i3<aitolen[icmd2];i3++) {
               apOut[iout++] = strdup(aPatch[aito[icmd2]+i3]);
               if (iout > SFKPATCH_MAX_OUTLINES-10) { log(0, "output cache overflow, %d lines exceeded\n",(int)SFKPATCH_MAX_OUTLINES); return 2; }
            }
            // drop the cache
            for (int i4=0;i4<isrcbuf;i4++)
               free(aBuf[i4]);
            // reset stats
            isrcbuf=0;
            ipatmatch=0;
            // switch to next command
            icmd2++;
         }
      } else {
         // flush and clear the cache, if any
         for (int i2=0;i2<isrcbuf;i2++) {
            apOut[iout++] = strdup(aBuf[i2]);
            if (iout > SFKPATCH_MAX_OUTLINES-10) { log(0, "output cache overflow, %d lines exceeded\n",(int)SFKPATCH_MAX_OUTLINES); return 2; }
            free(aBuf[i2]);
         }
         // flush also current line, which wasn't cached
         apOut[iout++] = strdup(szBuf);
         if (iout > SFKPATCH_MAX_OUTLINES-10) { log(0, "output cache overflow, %d lines exceeded\n",(int)SFKPATCH_MAX_OUTLINES); return 2; }
         // reset stats
         isrcbuf=0;
         ipatmatch=0;
      }
   }

   if (icmd2 != icmd) {
      log(0, "error  : from-pattern %d of %d mismatch, in file %s\n",icmd2+1,icmd,pszTargFileName);
      log(0, "info   : check pattern content and SEQUENCE (must match target sequence).\n");
      return 2;
   }

   fclose(ftarg);

 if (!bGlblSimulate)
 {
   // now, we hold the patched target file in apOut.
   // overwrite the target.
   int bSwitchedAttrib = 0;
   cchar *pszFileMode = "w";
   if (bGlblUnixOutput)
         pszFileMode = "wb";
   ftarg = fopen(pszTargFileName, pszFileMode);
   if (!ftarg) {
      // open for write failed? try switching attributes
      #ifdef _WIN32
      sprintf(szProbeCmd, "attrib -R %s",pszTargFileName);
      #else
      sprintf(szProbeCmd, "chmod +w %s", pszTargFileName);
      #endif
      if (system(szProbeCmd)) { }
      bSwitchedAttrib = 1;
      ftarg = fopen(pszTargFileName, pszFileMode);
   }
   if (!ftarg) {
      log(0, "error  : cannot overwrite target file: %s\n", pszTargFileName); return 2+4;
   }

   // write and free all memory lines
   for (int n=0; n<iout; n++)
   {
      strcpy(szBuf, apOut[n]);

      // apply local changes, which have priority over globals
      int ipat=0;
      for (ipat=0; ipat<iLocalChange; ipat++) {
         if (   (strstr(szBuf, apLocalChange[ipat][0]) != 0)
             && (strstr(szBuf, apLocalChange[ipat][1]) != 0)
            )
         {
            // replace pattern within line
            if (bGlblVerbose) { printf("lc1>%s",szBuf);fflush(stdout); }

            char *psz = strstr(szBuf, apLocalChange[ipat][1]);
            *psz = 0;
            strcpy(szBuf2,szBuf);
            strcat(szBuf2,apLocalChange[ipat][2]);
            psz += strlen(apLocalChange[ipat][1]);
            strcat(szBuf2,psz);
            strcpy(szBuf,szBuf2);

            if (bGlblVerbose) { printf("lc2>%s",szBuf);fflush(stdout); }

            anLocalChange[ipat]++;
         }
      }

      // apply global changes, if anything left to change
      for (ipat=0; ipat<iGlobalChange; ipat++) {
         if (   (strstr(szBuf, apGlobalChange[ipat][0]) != 0)
             && (strstr(szBuf, apGlobalChange[ipat][1]) != 0)
            )
         {
            // replace pattern within line
            if (bGlblVerbose) { printf("gc1>%s",szBuf);fflush(stdout); }

            char *psz = strstr(szBuf, apGlobalChange[ipat][1]);
            *psz = 0;
            strcpy(szBuf2,szBuf);
            strcat(szBuf2,apGlobalChange[ipat][2]);
            psz += strlen(apGlobalChange[ipat][1]);
            strcat(szBuf2,psz);
            strcpy(szBuf,szBuf2);

            if (bGlblVerbose) { printf("gc2>%s",szBuf);fflush(stdout); }

            anGlobalChange[ipat]++;
         }
      }

      // apply detabbing, if selected
      if (nLocalDetabOutput) {
         if (detabLine(szBuf, szBuf2, MAX_LINE_LEN, nLocalDetabOutput))
            return 9;
      }
      if (nGlblDetabOutput) {
         if (detabLine(szBuf, szBuf2, MAX_LINE_LEN, nGlblDetabOutput))
            return 9;
      }

      // apply unix conversion or not, and finally write
      if (bGlblUnixOutput) {
         char *psz = strrchr(szBuf,'\n'); if (psz) *psz = 0;
               psz = strrchr(szBuf,'\r'); if (psz) *psz = 0;
         fprintf(ftarg, "%s\n", szBuf);
      } else {
         fputs(szBuf,ftarg);
      }

      free(apOut[n]);
   }

   fclose(ftarg);

   // have to re-enable write protection?
   if (bSwitchedAttrib) {
      #ifdef _WIN32
      sprintf(szProbeCmd, "attrib +R %s",pszTargFileName);
      #else
      sprintf(szProbeCmd, "chmod -w %s", pszTargFileName);
      #endif
      if (system(szProbeCmd)) { }
   }

   if (bSwitchedAttrib) {
      log(5, "Patched: %s, %d lines.\n",pszTargFileName,iout);
   } else {
      log(5, "patched: %s, %d lines.\n",pszTargFileName,iout);
   }
   nGlblPatchedFiles++;
 }
 else {
   log(5, "checked: %s, %d lines.\n",pszTargFileName,iout);
 }

   if (bGlblVerify) {
      log(0, "error  : %s no longer patched - probably overwritten\n",pszTargFileName);
      return 1;
   }

   return 0;
}

#endif // USE_SFK_BASE

// emod text_patch
#endif // (sfk_prog || sfk_file_patch)

#if (defined(SFKINT) || defined(SFKPIC))
  #include "sfkint.cpp"
#endif // SFKINT

// dmod file_inst
#if (sfk_prog || sfk_file_inst)
#ifndef USE_SFK_BASE
// ----------- sfk inst - c++ source code instrumentation support --------------

#define SFKINST_TRBSIZE    200 // token ring buffer
#define SFKINST_BLINESIZE 1024
#define SFKINST_BLINEMAX    50

class SrcParse
{
public:
   SrcParse ( );
   uint processFile (char *pText, bool bSimulate, FILE *foutOptional);
   void  processLine (char *pBuf, bool bSimulate);

protected:
   void addtok    (char c);
   void addWord   ( );
   void addColon  ( );
   void addScope  ( );
   void addBra    ( );
   void addKet    ( );
   void addCBra   ( );
   void addCKet   ( );
   void addSemi   ( );
   void addRemark ( );
   bool hasFunctionStart (uint &rn1stline);
   char pretok    (uint &itok2, uint &nstepdowncnt, uint &rnline);
   void addDetectKeyword   (char **rpsz);
   void reduceSignature    (char *pszIn, char *pszOut);

   enum eSFKInstScanStates {
      ess_idle  = 1,
      ess_word  = 2,
      ess_num   = 3,
      ess_colon = 4,
      ess_slash = 5
      };

private:
   uchar atok[SFKINST_TRBSIZE+10];
   uint itok;
   uchar altok[SFKINST_TRBSIZE+10]; // just for the current line
   uint iltok;
   uint atokline[SFKINST_TRBSIZE+10]; // line number of token
   uint nline;
   char  abline[SFKINST_BLINEMAX][SFKINST_BLINESIZE+2];
   uint ibline;
   uint ibackscope;
   bool  bbackscope;
   FILE *clOut;
   cchar *peol;
   uint nClHits;

   char szLineBuf[MAX_LINE_LEN+10];
   char szLineBuf2[MAX_LINE_LEN+10];
   char szLineBuf3[MAX_LINE_LEN+10];
   char szBupDir[MAX_LINE_LEN+10];
   char szBupFile[MAX_LINE_LEN+10];
   char szCopyCmd[MAX_LINE_LEN+10];

public:
static bool
   bdebug,
   binsteol;

static cchar
   *pszGlblInclude,
   *pszGlblMacro;
};

bool   SrcParse::bdebug = 0;
bool   SrcParse::binsteol = 0;
cchar *SrcParse::pszGlblInclude = "";
cchar *SrcParse::pszGlblMacro   = "";

SrcParse::SrcParse()
{
   memset(this, 0, sizeof(*this));
   peol="\r\n";
}

uint SrcParse::processFile(char *pText, bool bSimulate, FILE *fout)
{
   // fix: sfk1901: consider lf only files
   if (strstr(pText, "\r\n"))
      peol="\r\n";
   else
      peol="\n";

   // fix: sfk1901: consider bom
   char *pbom=0;
   int nbom=0;
   if (!strncmp(pText, "\xef\xbb\xbf", 3)) {
      pbom=pText;
      nbom=3;
      pText += 3;
   }

   if (!bSimulate)
   {
      clOut = fout;
      if (pbom)
         fwrite(pbom, 1, nbom, fout);
      fprintf(fout, "#include \"%s\" // [instrumented]%s",
         pszGlblInclude, peol); // sfk1901
   }

   uint nTextLen = strlen(pText);
   char *pCopy = new char[nTextLen+10];
   if (!pCopy) { fprintf(stderr, "error  : out of memory at %d\n", __LINE__); return 0; }
   memcpy(pCopy, pText, nTextLen+1);

   nClHits = 0;

   // NO RETURNS FROM HERE

   uint nMaxLineLen = sizeof(szLineBuf)-10;
   char *psz1 = pCopy;
   char *pszContinue = 0;
   while (psz1)
   {
      char *psz2 = strchr(psz1, '\n');
      if (psz2)
      {
         pszContinue = psz2+1;
         int nLineLen = psz2 - psz1;
         if (nLineLen > (int)nMaxLineLen) nLineLen = nMaxLineLen;
         strncpy(szLineBuf, psz1, nLineLen);
         szLineBuf[nLineLen] = '\0';
         char *pszCR = strchr(szLineBuf, '\r');
         if (pszCR) *pszCR = '\0';
      }
      else
      {
         memset(szLineBuf, 0, sizeof(szLineBuf));
         strncpy(szLineBuf, psz1, nMaxLineLen);
         pszContinue = 0;
      }

      processLine(szLineBuf, bSimulate);
      psz1 = pszContinue;
   }

   // NO RETURNS UNTIL HERE

   delete [] pCopy;

   return nClHits;
}

bool isatoz(char c) { char c2=tolower(c); return (c2>='a' && c2<='z'); }
bool isnum_(char c) { return (c>='0' && c<='9') || (c=='_'); }

void SrcParse::reduceSignature(char *psz1, char *psz2)
{
   // reduce [type] class::method([parms])
   //     to class::method

   // goto last scope (in case there are many)
   //     cls1::type1 & cls2::type2::method3(
   char *pszs = strstr(psz1, "::");
   if (!pszs) { strcpy(psz2, psz1); return; }
   char *prbra = strrchr(psz1, '(');
   char *pszn;
   while ((pszn = strstr(pszs+1, "::")) && (pszn < prbra))
      pszs = pszn;
   // find head
   char *pszh = pszs-1;
   while (pszh >= psz1) {
      char c = *pszh;
      // if (!isnum_(c) && !isatoz(c))
      //    break;
      if (c == ' ' || c == '\t')
         break;
      pszh--;
   }
   while ((pszh<pszs) && !isatoz(*pszh))
      pszh++;
   // find tail
   char *pszt = pszs+2;
   while (*pszt) {
      char c = *pszt;
      // if ((c != '~') && !isnum_(c) && !isatoz(c))
      //   break;
      if (c == '(')
         break;
      pszt++;
   }
   while ((pszt > pszh) && (*pszt == ' ' || *pszt == '('))
      pszt--;
   pszt++;
   // check and copy
   if (pszh < pszt) {
      strncpy(psz2, pszh, pszt-pszh);
      psz2[pszt-pszh] = '\0';
   } else {
      strcpy(psz2, "?::?");
   }
}

void SrcParse::processLine(char *pszLine, bool bSimulate)
{
   nline++;

   char *pszx;
   if ((pszx = strchr(pszLine, '\n'))) *pszx = '\0';
   if ((pszx = strchr(pszLine, '\r'))) *pszx = '\0';

   // store in backline buffer
   strncpy(abline[ibline], pszLine, SFKINST_BLINESIZE-10);
   abline[ibline][SFKINST_BLINESIZE-10] = '\0';
   if (ibackscope == ibline) {
      bbackscope = 0; // got overwritten
   }

   // reset current line token buffer.
   // this is handled like a string, with zero terminator.
   iltok = 0;
   memset(altok, 0, sizeof(altok));

   // printf("] %s\n", pszLine);
   // printf("] %s\n", abline[ibline]);

   char *psz1 = pszLine;
   char c1;
   uchar nstate = ess_idle;
   do
   {
      c1 = *psz1; // incl. null at eol

      mtklog(("inst: %c %d",c1,nstate));

      if (isatoz(c1)) {
         switch (nstate) {
            case ess_idle:
               nstate=ess_word;
               addDetectKeyword(&psz1);
               break;
         }
      }
      else
      if (isnum_(c1)) {
         switch (nstate) {
            case ess_idle: nstate=ess_num ; break;
         }
      }
      else
      {
         // NOT alphanumeric
         switch (nstate) {
            case ess_word : nstate=ess_idle; addWord(); break;
         }

         if (c1 == '/') {
            switch (nstate) {
               case ess_idle : nstate=ess_slash; break;
               case ess_slash:
                  nstate=ess_idle ; addRemark(); c1=0; break;
            }
         }
         else
         if (c1 == '*') {
            switch (nstate) {
               case ess_slash:
                  nstate=ess_idle; addRemark(); break;
            }
         }
         else
         if (nstate == ess_slash)
             nstate = ess_idle;

         if (c1 == ':') {
            switch (nstate) {
               case ess_idle : nstate=ess_colon; break;
               case ess_colon: nstate=ess_idle ; addScope(); break;
            }
         }
         else
         if (nstate == ess_colon) {
             nstate = ess_idle;
             addColon();
         }
 
         if (c1 == '(') { nstate=ess_idle; addBra(); }
         else
         if (c1 == ')') { nstate=ess_idle; addKet(); }
         else
         if (c1 == '{') { nstate=ess_idle; addCBra(); }
         else
         if (c1 == '}') { nstate=ess_idle; addCKet(); }
         else
         if (c1 == ';') { nstate=ess_idle; addSemi(); }
      }

      psz1++;
   }
   while (c1);
   // printf("\n");

   // assumed function start in current line?
   if (   strstr((char*)altok, "wsw(")
       || strstr((char*)altok, "wsww(")
      )
   {
      ibackscope = ibline;
      bbackscope = 1;
   }

   strcpy(szLineBuf2, szLineBuf);

   // REDUCTION: so far, this accepts only "{" lines
   //            without anything else in it.
   if (hasFunctionStart(ibackscope))
   {
      char *pszMethodStartLine = abline[ibackscope];

      mtklog(("inst:   msline \"%.20s\"", pszMethodStartLine));

     if (bdebug)
     {
      printf("FN BODY at %d: %s\n", nline, (char*)atok);
      char *psz1;
      uint i2 = ibackscope;
      while ((psz1 = abline[i2])) {
         if (strlen(psz1))
            printf("] %s\n", psz1);
         if (i2 == ibline)
            break;
         if (++i2 >=  SFKINST_BLINEMAX)
            i2 = 0;
      }
     }

      // the current line contains the relevant "{" somewhere.
      // for now, we instrument only simple lines:
      mtklog(("inst:   lbuf2  \"%s\"", szLineBuf2));
      // accept "{" but also "[anywhitespace]{"
      char *pszs = szLineBuf2;
      while (*pszs && (*pszs==' ' || *pszs=='\t')) pszs++;
      if (!strcmp(pszs, "{")) {
         reduceSignature(pszMethodStartLine, szLineBuf3);
         sprintf(pszs, "{%s(\"%s\");", pszGlblMacro, szLineBuf3);
         // printf("=> %s \"%s\"\n", szLineBuf2, pszMethodStartLine);
         nClHits++;
      }
      else
      if (binsteol)
      do
      {
         // also instrument "{" at end of line
         char *pcur = strrchr(szLineBuf2, '{');
         if (!pcur) break;
         if (!strcmp(pcur, "{")) {
            reduceSignature(pszMethodStartLine, szLineBuf3);
            sprintf(pcur, "{%s(\"%s\");", pszGlblMacro, szLineBuf3);
            // printf("=> %s \"%s\"\n", szLineBuf2, pszMethodStartLine);
            nClHits++;
         }
      }
      while (0);
   }
   // else keep szLineBuf2 unchanged

   if (!bSimulate)
   {
      fwrite(szLineBuf2, 1, strlen(szLineBuf2), clOut);
      fwrite(peol, 1, strlen(peol), clOut); // sfk1901
   }

   if (++ibline >= SFKINST_BLINEMAX)
      ibline = 0;
}

void SrcParse::addDetectKeyword(char **rpsz)
{
   char *psz1 = *rpsz;
   if (!strncmp(psz1, "class ", strlen("class ")))
      {  addtok('k'); psz1+=strlen("class "); }
   else
   if (!strncmp(psz1, "struct ", strlen("struct ")))
      {  addtok('k'); psz1+=strlen("struct "); }
   *rpsz = psz1;
}

void SrcParse::addWord()   { addtok('w'); }
void SrcParse::addColon()  { addtok(':'); }
void SrcParse::addScope()  { addtok('s'); }
void SrcParse::addBra()    { addtok('('); }
void SrcParse::addKet()    { addtok(')'); }
void SrcParse::addCBra()   { addtok('{'); }
void SrcParse::addCKet()   { addtok('}'); }
void SrcParse::addSemi()   { addtok(';'); }
void SrcParse::addRemark() { addtok('r'); }

void SrcParse::addtok(char c)
{
   mtklog(("inst:  addtok %c", c));

   atok[itok] = c;
   atokline[itok] = ibline;
   if (++itok >= SFKINST_TRBSIZE)
      itok = 0;
   atok[itok] = '*';

   altok[iltok] = c;
   if (++iltok >= SFKINST_TRBSIZE)
      iltok = 0;
   altok[iltok] = '*';
   // printf("%c", c);
}

char SrcParse::pretok(uint &itok2, uint &nstepcnt, uint &rnline)
{
   if (nstepcnt == 0)
      return 0;
   else
      nstepcnt--;

   if (itok2 == 0)
      itok2 = SFKINST_TRBSIZE-1;
   else
      itok2--;

   rnline = atokline[itok2];
   return atok[itok2];
}

bool SrcParse::hasFunctionStart(uint &rnline)
{
   uint itok2 = itok;
   uint ncnt  = SFKINST_TRBSIZE;

   // W* S W B W* K ** {

   uint ntline = 0;
   char c1 = pretok(itok2, ncnt, ntline);
   if (!c1) return false;
   if (c1 != '{') {
      mtklog(("inst:   hasfs %c, false", c1));
      return false;
   }

   // have a curly braket:

   uint nBra = 0;
   uint nKet = 0;
   uint nrc  = 0;
   uint nScope = 0;
   uint nBraDist = 0; // word distance from last bra
 
   while (!nrc && (c1 = pretok(itok2, ncnt, ntline))) {
      switch (c1) {
         case 's':
            if (bdebug) printf("s-hit %d %d\n",nBra,nKet);
            if (nBra > 0 && (nBra == nKet) && (nBraDist==1))
            {
               rnline = ntline;
               // nrc = 1;
               nScope++;
            }
            break;
         case '{': nrc=2; break;
         case '}': nrc=3; break;
         case ';': nrc=4; break;
         case '(': nBra++; nBraDist=0; break;
         case ')': nKet++; break;
         case ':': nBra=nKet=0; break;
         case 'k': nrc=5; break; // class or struct
         case 'w':
            nBraDist++;
            if (nScope == 1) {
               // probably standing on wsw(
               nrc = 1;
            }
            break;
      }
   }

   if (nrc == 1) {
      mtklog(("inst:   hasfs true"));
      return true;
   }

   if (bdebug) {
      printf("MISS.%d: %s %d %d\n", nrc, (char*)atok,nBra,nKet);
      char *psz1;
      uint i2=ibackscope;
      while ((psz1 = abline[i2])) {
         if (strlen(psz1))
            printf("] %s\n", psz1);
         if (i2 == ibline)
            break;
         if (++i2 >=  SFKINST_BLINEMAX)
            i2 = 0;
      }
   }

   return false;
}

static int fileSize(char *pszFile)
{
   struct stat sinfo;
   if (stat(pszFile, &sinfo))
      return -1;
   return sinfo.st_size;
}

int sfkInstrument(char *pszFile, cchar *pszInc, cchar *pszMac, bool bRevoke, bool bRedo, bool bTouchOnRevoke, int nmode)
{
   char szLineBuf[MAX_LINE_LEN+10];
   char szLineBuf2[MAX_LINE_LEN+10];
   char szLineBuf3[MAX_LINE_LEN+10];
   char szBupDir[SFK_MAX_PATH+100];
   char szBupFile[SFK_MAX_PATH+100];
   char szCopyCmd[MAX_LINE_LEN+10];

   // printf("INST %s %u %s %s\n",pszFile,bRevoke,pszInc,pszMac);

   SrcParse::binsteol = (nmode & 1) ? 1 : 0;

   SrcParse::pszGlblInclude = pszInc;
   SrcParse::pszGlblMacro   = pszMac;

   #ifdef _WIN32
   if (strstr(pszFile, "save_inst\\"))
   #else
   if (strstr(pszFile, "save_inst/"))
   #endif
   {
      fprintf(stderr, "warning: exclude, cannot instrument: %s\n", pszFile);
      return 5;
   }

   // create backup infos
   strcpy(szBupDir, pszFile);
   char *pszPath = strrchr(szBupDir, glblPathChar);
   if (pszPath) *pszPath = '\0';
   else strcpy(szBupDir, ".");
   char *pszRelFile = strrchr(pszFile, glblPathChar);
   if (pszRelFile) pszRelFile++;
   else pszRelFile = pszFile;
   strcat(szBupDir, glblPathStr);
   strcat(szBupDir, "save_inst");
   sprintf(szBupFile, "%s%c%s", szBupDir, glblPathChar, pszRelFile);
   // printf("BUPDIR: %s\n", szBupDir);
   // printf("BUPFIL: %s\n", szBupFile);

   if (bRevoke)
   {
      // first check if the file is really instrumented
      char *pFile = loadFile(pszFile, 0);
      bool bisins = 1;
      if (pFile) {
         if (!strstr(pFile, "// [instrumented]"))
            bisins = 0;
         delete [] pFile;
      }

      if (!bisins)
      {
         if (!bRedo) {
            fprintf(stderr, "skipped: %s - not instrumented\n", pszFile);
            return 1;
         }  // else fall through
      }
      else
      {
         if (!fileExists(szBupFile)) { fprintf(stderr, "warning: cannot revoke, no backup: %s\n", pszFile); return 5; }
 
         if (!cs.yes) {
            printf("would %s: %s\n",bRedo?"redo":"revoke",pszFile);
            return 0;
         }

         if (fileExists(pszFile)) {
            // 1. ensure target is writeable
            #ifdef _WIN32
            sprintf(szCopyCmd, "attrib -R %s",pszFile);
            #else
            sprintf(szCopyCmd, "chmod +w %s", pszFile);
            #endif
            if (system(szCopyCmd)) { }
            #ifdef _WIN32
            // 2. delete target to ensure copy will work
            sprintf(szCopyCmd, "del %s",pszFile);
            if (system(szCopyCmd)) { }
            #endif
         }

         char *pszTargFileName = pszFile;

         if (bTouchOnRevoke)
         {
            // make sure target has current timestamp
            FILE *fsrc = fopen(szBupFile, "rb");
            if (!fsrc) { fprintf(stderr, "error  : cannot open %s\n",szBupFile); return 2+4; }
            FILE *fdst = fopen(pszTargFileName,"wb");
            if (!fdst) { fprintf(stderr, "error  : cannot open %s\n",pszTargFileName); return 2+4; }
            // quick binary block copy
            // size_t fread( void *buffer, size_t size, size_t count, FILE *stream );
            // size_t fwrite( const void *buffer, size_t size, size_t count, FILE *stream );
            size_t ntotal = 0;
            while (1) {
               size_t nread = fread(szCopyCmd, 1, sizeof(szCopyCmd), fsrc);
               if (nread <= 0)
                  break;
               fwrite(szCopyCmd, 1, nread, fdst);
               ntotal += nread;
            }
            fclose(fdst);
            fclose(fsrc);
            // write-protect target
            #ifdef _WIN32
            sprintf(szCopyCmd, "attrib +R %s",pszTargFileName);
            #else
            sprintf(szCopyCmd, "chmod -w %s", pszTargFileName);
            #endif
            if (system(szCopyCmd)) { }
            if (!bRedo) {
               printf("revoked: %s, %u bytes\n",pszTargFileName,(unsigned int)ntotal);
               return 0;
            }  // else fall through
         }
         else
         {
            // xcopy requires us to create a dummy, otherwise we get a prompting
            FILE *fdst = fopen(pszTargFileName,"w");
            if (!fdst) { fprintf(stderr, "error  : cannot open %s\n",pszTargFileName); return 9; }
            fprintf(fdst, "tmp\n\n"); fflush(fdst);
            fclose(fdst);
            // now overwrite this with /K, keeping potential +R attributes
            #ifdef _WIN32
            sprintf(szCopyCmd, "xcopy /Q /K /Y /R %s %s >nul",szBupFile,pszTargFileName);
            #else
            sprintf(szCopyCmd, "cp -p %s %s",szBupFile,pszTargFileName);
            #endif
            int iRC = system(szCopyCmd);
            if (!iRC) {
               if (!bRedo) {
                  printf("revoked: %s\n",pszTargFileName);
                  return 0;
               }  // else fall through
            } else {
               fprintf(stderr, "error  : revoke failed: %s\n",pszTargFileName);
               return 1;
            }
         }   // endelse touch-on-revoke
      }  // endelse is-instrumented
   }

   // instrument the target file

   int nsize = fileSize(pszFile);
   if (nsize <= 0) { fprintf(stderr, "skipped: %s - empty file\n", pszFile); return 5; }
   if (nsize > 50 * 1048576) { fprintf(stderr, "warning: too large, skipping: %s\n", pszFile); return 5; }

   char *pFile = loadFile(pszFile, 0);
   if (!pFile)
      return 9;

   // COVER ALL RETURNS WITH pFILE CLEANUP FROM HERE:

   if (strstr(pFile, "// [instrumented]")) {
      fprintf(stderr, "warning: already instrumented, skipping: %s\n", pszFile);
      delete [] pFile;
      return 5;
   }

   SrcParse *pparse1 = new SrcParse();
   uint nHits = pparse1->processFile(pFile, 1, 0);
   if (nHits == 0) {
      fprintf(stderr, "skipped: %s - nothing to change\n", pszFile);
      delete [] pFile;
      delete pparse1;
      return 5;
   }
   delete pparse1;

   if (!cs.yes) {
      printf("would change: %s, %d hits\n", pszFile, nHits);
      return 0;
   }

   // create backup file
   #ifdef _WIN32
   _mkdir(szBupDir);
   #else
   mkdir(szBupDir, S_IREAD | S_IWRITE | S_IEXEC);
   #endif
   FILE *ftmp = fopen(szBupFile,"w");
   if (ftmp) { fprintf(ftmp,"dummy"); fclose(ftmp); }
   #ifdef _WIN32
   sprintf(szLineBuf, "xcopy /Q /K /Y /R %s %s >nul",pszFile,szBupFile);
   #else
   sprintf(szLineBuf, "cp -p %s %s",pszFile,szBupFile);
   #endif
   int iRC = system(szLineBuf);
   if (iRC) {
      fprintf(stderr, "error  : cannot backup file to: %s\n",szBupFile);
      delete [] pFile;
      return 9;
   }

   // reopen target file for write
   FILE *fout = fopen(pszFile, "wb"); // sfk1901: wb
   if (!fout) {
      // probably write protected
      #ifdef _WIN32
      sprintf(szLineBuf, "attrib -R %s", pszFile);
      #else
      sprintf(szLineBuf, "chmod +w %s",  pszFile);
      #endif
      if (system(szLineBuf)) { }
      // retry
      if (!(fout = fopen(pszFile, "wb"))) {
         fprintf(stderr, "error  : unable to write: %s\n", pszFile);
         delete [] pFile;
         return 9;
      }
   }

   SrcParse *pparse2 = new SrcParse();
   nHits = pparse2->processFile(pFile, 0, fout);

   // cleanup
   delete pparse2;
   delete [] pFile;
   fclose(fout);

   if (bRedo)
      printf("redone : %s, %d hits\n", pszFile, nHits);
   else
      printf("inst'ed: %s, %d hits\n", pszFile, nHits);

   return 0;
}

int execInst(char *pszFileName, int lLevel, int &lFiles, int &lDirs, num &lBytes)
{__
   extern int sfkInstrument(char *pszFile, cchar *pszInc, cchar *pszMac, bool bRevoke, bool bRedo, bool bTouchOnRevoke, int nmode);

   // source code automatic instrumentation
   if (!strncmp(pszFileName, glblDotSlash, 2))
      pszFileName += 2;

   int nmode = bGlblInstEol ? 1 : 0;

   int nRC = sfkInstrument(pszFileName, pszGlblInstInc, pszGlblInstMac, bGlblInstRevoke, bGlblInstRedo, bGlblTouchOnRevoke, nmode);

   if (nRC < 9)
      return 0;

   return nRC;
}

#endif // USE_SFK_BASE
// emod file_inst
#endif // (sfk_prog || sfk_file_inst)

// dmod net_knx
#if (sfk_prog || sfk_net_knx)

int getGAPart(char **ppsz, const char *pszWhat)
{
   char *psz=*ppsz;
   if (!isdigit(*psz))
      return -1+perr("%s GA part must be a number: \"%s\"", pszWhat, psz);
   int n = atoi(psz);
   while (isdigit(*psz)) psz++;
   if (*psz==' ' || *psz=='/') psz++;
   *ppsz = psz;
   return n;
}

enum EKnxType
{
   knxint1  = 1,
   knxint4,
   knxint8,
   knxint16,
   knxint32,

   knxfloat16,
   knxfloat32,

   knxtime,
   knxdate,

   knxtext
};

const char *aKnxType[] =
{
   "",
   "int1",
   "int4",
   "int8",
   "int16",
   "int32",
   "float16",
   "float32",
   "time",
   "date",
   "text"
};

typedef union {
   float f;
   struct
   {
      // Order is important.
      // Here the members of the union data structure
      // use the same memory (32 bits).
      // The ordering is taken
      // from the LSB to the MSB.
      unsigned int mantissa : 23;
      unsigned int exponent : 8;
      unsigned int sign : 1;
   } raw;
   uint32_t nval;
} myfloat;

int parseKnxReq(uchar cmd[], char *psz, char szInfo[], int iMaxInfo, bool breply=0)
{
   /*
      1 2 3 1 0
      1/2/3 8bit -100
      1/2/3 text mytext
   */

   int ga1,ga2,ga3;

   if ((ga1 = getGAPart(&psz, "first")) < 0)  return 0;
   if ((ga2 = getGAPart(&psz, "second")) < 0) return 0;
   if ((ga3 = getGAPart(&psz, "third")) < 0)  return 0;

   skipWhite(&psz);

   // 1 8 14 16 bool int8 int16 int32 float16 float32 text
   // todo: dimm
   int etype = 0;
   if (strbeg(psz, "1 ")) etype = knxint1; else
   if (strbeg(psz, "int1 ")) etype = knxint1; else
   if (strbeg(psz, "bool ")) etype = knxint1; else
   if (strbeg(psz, "4 ")) etype = knxint4; else
   if (strbeg(psz, "8 ")) etype = knxint8; else
   if (strbeg(psz, "16 ")) etype = knxint16; else
   if (strbeg(psz, "int8 ")) etype = knxint8; else
   if (strbeg(psz, "int16 ")) etype = knxint16; else
   if (strbeg(psz, "int32 ")) etype = knxint32; else
   if (strbeg(psz, "float16 ")) etype = knxfloat16; else
   if (strbeg(psz, "float32 ")) etype = knxfloat32; else
   if (strbeg(psz, "time ")) etype = knxtime; else
   if (strbeg(psz, "date ")) etype = knxdate; else
   if (strbeg(psz, "text ")) etype = knxtext; else
      return 0+perr("invalid datatype: %s\n", psz);
   skipToWhite(&psz); skipWhite(&psz);

   uint8_t data[32];
   memset(data, 0, sizeof(data));

   // true/on false/off 100 -1234 3.5 -500.0 mytext
   double dval = 0.0;
   int64_t idata = 0, nval = 0;
   char *pszdata = 0;
   int64_t mantisse1=0, exponent1=0;

   if (etype == knxtext)
   {
      pszdata = psz;
      memcpy(data, pszdata, mymin(14,strlen(pszdata)));
   }
   else
   if (strbeg(psz, "true"))  idata = 1; else
   if (strbeg(psz, "on"))    idata = 1; else
   if (strbeg(psz, "false")) idata = 0; else
   if (strbeg(psz, "off"))   idata = 0; else
   if (etype >= knxint1 && etype <= knxint32)
   {
      // accepts negative and 0x hex values:
      idata = myatonum(psz);

      switch (etype) {
         case knxint1: case knxint4: case knxint8:
            data[0] = (uint8_t)idata; break;
         case knxint16:
            data[0] = (uint8_t)(idata >> 8);
            data[1] = (uint8_t)(idata >> 0); break;
         case knxint32:
            data[0] = (uint8_t)(idata >> 24);
            data[1] = (uint8_t)(idata >> 16);
            data[2] = (uint8_t)(idata >>  8);
            data[3] = (uint8_t)(idata >>  0); break;
      }
   }
   else if (etype == knxfloat16)
   {
      /* 345,678
         670760   7FFE
      */
      dval = atof(psz);
      nval = (int64_t)(dval * 100.0);
      mantisse1 = (nval < 0) ? (0-nval) : nval;
      exponent1 = 0;
      while (mantisse1 >= 2048) {
         mantisse1 /= 2;
         exponent1++;
      }
      // printf("m=%d e=%d s=%d\n",mantisse1,exponent1,(nval<0)?1:0);
      if (nval < 0)
         mantisse1 = 0 - mantisse1;

      unsigned char b1 = ((mantisse1 & 0x0700) >> 8);
      b1 |= exponent1 << 3;
      if (nval < 0)
         b1 |= 0x80;

      unsigned char b2 = mantisse1 & 0x00ff;

      data[0] = b1;
      data[1] = b2;

      idata =     (((int64_t)data[0])<<8)
               |  ((int64_t)data[1]);
   }
   else if (etype == knxfloat32)
   {
      /* 345,678
         43ACD6C8 01000011 10101100 11010110 11001000
         0E2CD6C9 00001110 00101100 11010110 11001001
      */
      dval = atof(psz);
