/*
 * Decompiled with CFR 0.152.
 */
package liqp.parser.v4;

import java.util.ArrayList;
import java.util.Map;
import liqp.LValue;
import liqp.ParseSettings;
import liqp.exceptions.LiquidException;
import liqp.filters.Filter;
import liqp.nodes.AndNode;
import liqp.nodes.AtomNode;
import liqp.nodes.AttributeNode;
import liqp.nodes.BlockNode;
import liqp.nodes.ContainsNode;
import liqp.nodes.EqNode;
import liqp.nodes.FilterNode;
import liqp.nodes.GtEqNode;
import liqp.nodes.GtNode;
import liqp.nodes.KeyValueNode;
import liqp.nodes.LNode;
import liqp.nodes.LookupNode;
import liqp.nodes.LtEqNode;
import liqp.nodes.LtNode;
import liqp.nodes.NEqNode;
import liqp.nodes.OrNode;
import liqp.nodes.OutputNode;
import liqp.nodes.TagNode;
import liqp.parser.Flavor;
import liqp.tags.Tag;
import liquid.parser.v4.LiquidParser;
import liquid.parser.v4.LiquidParserBaseVisitor;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class NodeVisitor
extends LiquidParserBaseVisitor<LNode> {
    private Map<String, Tag> tags;
    private Map<String, Filter> filters;
    private final ParseSettings parseSettings;
    private boolean isRootBlock = true;

    public NodeVisitor(Map<String, Tag> tags, Map<String, Filter> filters, ParseSettings parseSettings) {
        if (tags == null) {
            throw new IllegalArgumentException("tags == null");
        }
        if (filters == null) {
            throw new IllegalArgumentException("filters == null");
        }
        if (parseSettings == null) {
            throw new IllegalArgumentException("parseSettings == null");
        }
        this.tags = tags;
        this.filters = filters;
        this.parseSettings = parseSettings;
    }

    @Override
    public BlockNode visitParse(LiquidParser.ParseContext ctx) {
        return this.visitBlock(ctx.block());
    }

    @Override
    public BlockNode visitBlock(LiquidParser.BlockContext ctx) {
        BlockNode node = new BlockNode(this.isRootBlock);
        this.isRootBlock = false;
        for (LiquidParser.AtomContext child : ctx.atom()) {
            node.add((LNode)this.visit((ParseTree)child));
        }
        return node;
    }

    @Override
    public LNode visitAtom_others(LiquidParser.Atom_othersContext ctx) {
        return new AtomNode(ctx.getText());
    }

    @Override
    public LNode visitOther_tag(LiquidParser.Other_tagContext ctx) {
        Tag tag;
        ArrayList<LNode> expressions = new ArrayList<LNode>();
        if (ctx.other_tag_parameters() != null) {
            expressions.add(new AtomNode(ctx.other_tag_parameters().getText()));
        }
        if (ctx.other_tag_block() != null) {
            expressions.add(this.visitOther_tag_block(ctx.other_tag_block()));
        }
        if ((tag = this.tags.get(ctx.Id().getText())) == null) {
            throw new RuntimeException("The tag '" + ctx.Id().getText() + "' is not registered.");
        }
        return new TagNode(tag, expressions.toArray(new LNode[expressions.size()]));
    }

    @Override
    public BlockNode visitOther_tag_block(LiquidParser.Other_tag_blockContext ctx) {
        BlockNode node = new BlockNode(this.isRootBlock);
        for (LiquidParser.AtomContext child : ctx.atom()) {
            node.add((LNode)this.visit((ParseTree)child));
        }
        return node;
    }

    @Override
    public LNode visitRaw_tag(LiquidParser.Raw_tagContext ctx) {
        return new TagNode(this.tags.get("raw"), new AtomNode(ctx.raw_body().getText()));
    }

    @Override
    public LNode visitComment_tag(LiquidParser.Comment_tagContext ctx) {
        return new TagNode(this.tags.get("comment"), new AtomNode(ctx.getText()));
    }

    @Override
    public LNode visitIf_tag(LiquidParser.If_tagContext ctx) {
        ArrayList<Object> nodes = new ArrayList<Object>();
        nodes.add(this.visit((ParseTree)ctx.expr()));
        nodes.add(this.visitBlock(ctx.block()));
        for (LiquidParser.Elsif_tagContext elseIf : ctx.elsif_tag()) {
            nodes.add(this.visit((ParseTree)elseIf.expr()));
            nodes.add(this.visitBlock(elseIf.block()));
        }
        if (ctx.else_tag() != null) {
            nodes.add(new AtomNode("TRUE"));
            nodes.add(this.visitBlock(ctx.else_tag().block()));
        }
        return new TagNode(this.tags.get("if"), nodes.toArray(new LNode[nodes.size()]));
    }

    @Override
    public LNode visitUnless_tag(LiquidParser.Unless_tagContext ctx) {
        ArrayList<Object> nodes = new ArrayList<Object>();
        nodes.add(this.visit((ParseTree)ctx.expr()));
        nodes.add(this.visitBlock(ctx.block()));
        if (ctx.else_tag() != null) {
            nodes.add(new AtomNode(null));
            nodes.add(this.visitBlock(ctx.else_tag().block()));
        }
        return new TagNode(this.tags.get("unless"), nodes.toArray(new LNode[nodes.size()]));
    }

    @Override
    public LNode visitCase_tag(LiquidParser.Case_tagContext ctx) {
        ArrayList<Object> nodes = new ArrayList<Object>();
        nodes.add(this.visit((ParseTree)ctx.expr()));
        for (LiquidParser.When_tagContext child : ctx.when_tag()) {
            for (LiquidParser.TermContext grandChild : child.term()) {
                nodes.add(this.visit((ParseTree)grandChild));
            }
            nodes.add(this.visitBlock(child.block()));
        }
        if (ctx.else_tag() != null) {
            nodes.add(nodes.get(0));
            nodes.add(this.visitBlock(ctx.else_tag().block()));
        }
        return new TagNode(this.tags.get("case"), nodes.toArray(new LNode[nodes.size()]));
    }

    @Override
    public LNode visitCycle_tag(LiquidParser.Cycle_tagContext ctx) {
        ArrayList<Object> nodes = new ArrayList<Object>();
        nodes.add(ctx.cycle_group().expr() == null ? null : (LNode)this.visit((ParseTree)ctx.cycle_group().expr()));
        for (LiquidParser.ExprContext child : ctx.expr()) {
            nodes.add(this.visit((ParseTree)child));
        }
        return new TagNode(this.tags.get("cycle"), nodes.toArray(new LNode[nodes.size()]));
    }

    @Override
    public LNode visitFor_array(LiquidParser.For_arrayContext ctx) {
        ArrayList<Object> expressions = new ArrayList<Object>();
        expressions.add(new AtomNode(true));
        expressions.add(new AtomNode(ctx.Id().getText()));
        expressions.add(this.visit((ParseTree)ctx.lookup()));
        expressions.add(this.visitBlock(ctx.for_block().a));
        expressions.add(ctx.for_block().Else() == null ? null : this.visitBlock(ctx.for_block().b));
        expressions.add(new AtomNode(ctx.lookup().getText()));
        expressions.add(new AtomNode(ctx.Reversed() != null));
        for (LiquidParser.For_attributeContext attribute : ctx.for_attribute()) {
            expressions.add(this.visit((ParseTree)attribute));
        }
        return new TagNode(this.tags.get("for"), expressions.toArray(new LNode[expressions.size()]));
    }

    @Override
    public LNode visitFor_range(LiquidParser.For_rangeContext ctx) {
        ArrayList<Object> expressions = new ArrayList<Object>();
        expressions.add(new AtomNode(false));
        expressions.add(new AtomNode(ctx.Id().getText()));
        expressions.add(this.visit((ParseTree)ctx.from));
        expressions.add(this.visit((ParseTree)ctx.to));
        expressions.add(this.visitBlock(ctx.block()));
        expressions.add(new AtomNode("(" + ctx.from.getText() + ".." + ctx.to.getText() + ")"));
        expressions.add(new AtomNode(ctx.Reversed() != null));
        for (LiquidParser.For_attributeContext attribute : ctx.for_attribute()) {
            expressions.add(this.visit((ParseTree)attribute));
        }
        return new TagNode(this.tags.get("for"), expressions.toArray(new LNode[expressions.size()]));
    }

    @Override
    public LNode visitAttribute(LiquidParser.AttributeContext ctx) {
        if (ctx.Offset() != null) {
            return new AttributeNode(new AtomNode(ctx.Offset().getText()), (LNode)this.visit((ParseTree)ctx.expr()));
        }
        return new AttributeNode(new AtomNode(ctx.Id().getText()), (LNode)this.visit((ParseTree)ctx.expr()));
    }

    @Override
    public LNode visitFor_attribute(LiquidParser.For_attributeContext ctx) {
        if (ctx.Id() != null) {
            return new AttributeNode(new AtomNode(ctx.Id().getText()), (LNode)this.visit((ParseTree)ctx.expr()));
        }
        if (ctx.Continue() != null) {
            return new AttributeNode(new AtomNode(ctx.Offset().getText()), new AtomNode(LValue.CONTINUE));
        }
        return new AttributeNode(new AtomNode(ctx.Offset().getText()), (LNode)this.visit((ParseTree)ctx.expr()));
    }

    @Override
    public LNode visitContinue_tag(LiquidParser.Continue_tagContext ctx) {
        return new AtomNode(LValue.CONTINUE);
    }

    @Override
    public LNode visitTable_tag(LiquidParser.Table_tagContext ctx) {
        ArrayList<Object> expressions = new ArrayList<Object>();
        expressions.add(new AtomNode(ctx.Id().getText()));
        expressions.add(this.visit((ParseTree)ctx.lookup()));
        expressions.add(this.visitBlock(ctx.block()));
        for (LiquidParser.AttributeContext attribute : ctx.attribute()) {
            expressions.add(this.visit((ParseTree)attribute));
        }
        return new TagNode(this.tags.get("tablerow"), expressions.toArray(new LNode[expressions.size()]));
    }

    @Override
    public LNode visitCapture_tag_Id(LiquidParser.Capture_tag_IdContext ctx) {
        return new TagNode(this.tags.get("capture"), new AtomNode(ctx.Id().getText()), this.visitBlock(ctx.block()));
    }

    @Override
    public LNode visitCapture_tag_Str(LiquidParser.Capture_tag_StrContext ctx) {
        return new TagNode(this.tags.get("capture"), NodeVisitor.fromString(ctx.Str()), this.visitBlock(ctx.block()));
    }

    @Override
    public LNode visitInclude_tag(LiquidParser.Include_tagContext ctx) {
        if (ctx.jekyll != null) {
            return new TagNode(this.tags.get("include"), (LNode)this.visit((ParseTree)ctx.file_name_or_output()));
        }
        if (ctx.liquid != null) {
            if (ctx.Str() != null) {
                return new TagNode(this.tags.get("include"), (LNode)this.visit((ParseTree)ctx.expr()), new AtomNode(NodeVisitor.strip(ctx.Str().getText())));
            }
            return new TagNode(this.tags.get("include"), (LNode)this.visit((ParseTree)ctx.expr()));
        }
        throw new LiquidException("Unknown syntax of `Include` tag", ctx);
    }

    @Override
    public LNode visitJekyll_include_output(LiquidParser.Jekyll_include_outputContext ctx) {
        if (this.parseSettings.flavor != Flavor.JEKYLL) {
            throw new LiquidException("`{% include ouput %}` can only be used for Flavor.JEKYLL", ctx);
        }
        return this.visitOutput(ctx.output());
    }

    @Override
    public LNode visitJekyll_include_filename(LiquidParser.Jekyll_include_filenameContext ctx) {
        if (this.parseSettings.flavor != Flavor.JEKYLL) {
            throw new LiquidException("`{% include other_than_tag_end_out_start %}` can only be used for Flavor.JEKYLL", ctx);
        }
        Interval interval = Interval.of((int)ctx.filename().start.getStartIndex(), (int)ctx.filename().stop.getStopIndex());
        String filename = ctx.filename().start.getInputStream().getText(interval);
        if (filename.matches(".*\\s.*")) {
            throw new LiquidException("in `{% include filename %}` the `filename` is {" + filename + "}, but it cannot have spaces for Flavor.JEKYLL", ctx);
        }
        return new AtomNode(filename);
    }

    @Override
    public LNode visitFilename(LiquidParser.FilenameContext ctx) {
        return (LNode)super.visitFilename(ctx);
    }

    @Override
    public OutputNode visitOutput(LiquidParser.OutputContext ctx) {
        OutputNode node = new OutputNode((LNode)this.visit((ParseTree)ctx.expr()));
        for (LiquidParser.FilterContext child : ctx.filter()) {
            node.addFilter(this.visitFilter(child));
        }
        return node;
    }

    @Override
    public FilterNode visitFilter(LiquidParser.FilterContext ctx) {
        FilterNode node = new FilterNode(ctx, this.filters.get(ctx.Id().getText()));
        if (ctx.params() != null) {
            for (LiquidParser.Param_exprContext child : ctx.params().param_expr()) {
                node.add((LNode)this.visit((ParseTree)child));
            }
        }
        return node;
    }

    @Override
    public LNode visitParam_expr_key_value(LiquidParser.Param_expr_key_valueContext ctx) {
        return new KeyValueNode(ctx.id2().getText(), (LNode)this.visit((ParseTree)ctx.expr()));
    }

    @Override
    public LNode visitParam_expr_expr(LiquidParser.Param_expr_exprContext ctx) {
        return (LNode)this.visit((ParseTree)ctx.expr());
    }

    @Override
    public LNode visitAssignment(LiquidParser.AssignmentContext ctx) {
        AtomNode idNode = new AtomNode(ctx.Id().getText());
        LNode exprNode = (LNode)this.visit((ParseTree)ctx.expr());
        ArrayList<LNode> allNodes = new ArrayList<LNode>();
        allNodes.add(idNode);
        allNodes.add(exprNode);
        for (LiquidParser.FilterContext filterContext : ctx.filter()) {
            allNodes.add((LNode)this.visit((ParseTree)filterContext));
        }
        return new TagNode(this.tags.get("assign"), allNodes);
    }

    @Override
    public LNode visitExpr_rel(LiquidParser.Expr_relContext ctx) {
        switch (ctx.op.getType()) {
            case 16: {
                return new LtEqNode((LNode)this.visit((ParseTree)ctx.lhs), (LNode)this.visit((ParseTree)ctx.rhs));
            }
            case 17: {
                return new LtNode((LNode)this.visit((ParseTree)ctx.lhs), (LNode)this.visit((ParseTree)ctx.rhs));
            }
            case 14: {
                return new GtEqNode((LNode)this.visit((ParseTree)ctx.lhs), (LNode)this.visit((ParseTree)ctx.rhs));
            }
            case 15: {
                return new GtNode((LNode)this.visit((ParseTree)ctx.lhs), (LNode)this.visit((ParseTree)ctx.rhs));
            }
        }
        throw new RuntimeException("unknown operator: " + ctx.op.getText());
    }

    @Override
    public LNode visitExpr_contains(LiquidParser.Expr_containsContext ctx) {
        return new ContainsNode((LNode)this.visit((ParseTree)ctx.lhs), (LNode)this.visit((ParseTree)ctx.rhs));
    }

    @Override
    public LNode visitExpr_eq(LiquidParser.Expr_eqContext ctx) {
        switch (ctx.op.getType()) {
            case 12: {
                return new EqNode((LNode)this.visit((ParseTree)ctx.lhs), (LNode)this.visit((ParseTree)ctx.rhs));
            }
            case 11: {
                return new NEqNode((LNode)this.visit((ParseTree)ctx.lhs), (LNode)this.visit((ParseTree)ctx.rhs));
            }
        }
        throw new RuntimeException("unknown operator: " + ctx.op.getText());
    }

    @Override
    public LNode visitExpr_logic(LiquidParser.Expr_logicContext ctx) {
        switch (ctx.op.getType()) {
            case 50: {
                return new AndNode((LNode)this.visit((ParseTree)ctx.lhs), (LNode)this.visit((ParseTree)ctx.rhs));
            }
            case 51: {
                return new OrNode((LNode)this.visit((ParseTree)ctx.lhs), (LNode)this.visit((ParseTree)ctx.rhs));
            }
        }
        throw new RuntimeException("unknown operator: " + ctx.op.getText());
    }

    @Override
    public LNode visitExpr_term(LiquidParser.Expr_termContext ctx) {
        return (LNode)this.visit((ParseTree)ctx.term());
    }

    @Override
    public LNode visitTerm_DoubleNum(LiquidParser.Term_DoubleNumContext ctx) {
        return new AtomNode(new Double(ctx.DoubleNum().getText()));
    }

    @Override
    public LNode visitTerm_LongNum(LiquidParser.Term_LongNumContext ctx) {
        return new AtomNode(new Long(ctx.LongNum().getText()));
    }

    @Override
    public LNode visitTerm_Str(LiquidParser.Term_StrContext ctx) {
        return NodeVisitor.fromString(ctx.Str());
    }

    @Override
    public LNode visitTerm_True(LiquidParser.Term_TrueContext ctx) {
        return new AtomNode(true);
    }

    @Override
    public LNode visitTerm_False(LiquidParser.Term_FalseContext ctx) {
        return new AtomNode(false);
    }

    @Override
    public LNode visitTerm_Nil(LiquidParser.Term_NilContext ctx) {
        return new AtomNode(null);
    }

    @Override
    public LNode visitTerm_lookup(LiquidParser.Term_lookupContext ctx) {
        return (LNode)this.visit((ParseTree)ctx.lookup());
    }

    @Override
    public LNode visitTerm_Empty(LiquidParser.Term_EmptyContext ctx) {
        return AtomNode.EMPTY;
    }

    @Override
    public LNode visitTerm_Blank(LiquidParser.Term_BlankContext ctx) {
        return AtomNode.BLANK;
    }

    @Override
    public LNode visitTerm_expr(LiquidParser.Term_exprContext ctx) {
        return (LNode)this.visit((ParseTree)ctx.expr());
    }

    @Override
    public LNode visitLookup_empty(LiquidParser.Lookup_emptyContext ctx) {
        return AtomNode.EMPTY;
    }

    @Override
    public LookupNode visitLookup_id_indexes(LiquidParser.Lookup_id_indexesContext ctx) {
        LookupNode node = new LookupNode(ctx.id().getText());
        for (LiquidParser.IndexContext index : ctx.index()) {
            if (index.Dot() != null) {
                node.add(new LookupNode.Hash(index.id2().getText()));
                continue;
            }
            node.add(new LookupNode.Index((LNode)this.visit((ParseTree)index.expr()), index.expr().getText()));
        }
        return node;
    }

    @Override
    public LookupNode visitLookup_Str(LiquidParser.Lookup_StrContext ctx) {
        return new LookupNode(NodeVisitor.strip(ctx.Str().getText()));
    }

    @Override
    public LookupNode visitLookup_Id(LiquidParser.Lookup_IdContext ctx) {
        return new LookupNode("@" + ctx.Id().getText());
    }

    private static AtomNode fromString(TerminalNode str) {
        return new AtomNode(NodeVisitor.strip(str.getText()));
    }

    private static String strip(String str) {
        return str.substring(1, str.length() - 1);
    }
}

