const assert = require('node:assert');
const path = require('node:path');
const meta = { plugin: { initial: true } };

const ID_MAIN = path.join(__dirname, 'main.js');

module.exports = defineTest({
	description: 'does not modify meta objects passed in resolveId',
	options: {
		plugins: [
			{
				async resolveId(source, importer) {
					const { id } = await this.resolve(source, importer);
					return { id, meta };
				},
				transform(code) {
					return { code, meta: { otherPlugin: { ignored: true }, plugin: { replaced: true } } };
				},
				buildEnd() {
					assert.deepStrictEqual(meta, { plugin: { initial: true } });
					assert.deepStrictEqual(this.getModuleInfo(ID_MAIN).meta, {
						otherPlugin: { ignored: true },
						plugin: { replaced: true }
					});
				}
			}
		]
	}
});
