use swc_ecma_ast::{BlockStmt, Expr, Lit, Stmt};

use crate::convert_ast::converter::ast_constants::{
  BLOCK_STATEMENT_BODY_OFFSET, BLOCK_STATEMENT_RESERVED_BYTES, TYPE_BLOCK_STATEMENT,
};
use crate::convert_ast::converter::AstConverter;

impl<'a> AstConverter<'a> {
  pub fn store_block_statement(&mut self, block_statement: &BlockStmt, check_directive: bool) {
    let end_position = self.add_type_and_start(
      &TYPE_BLOCK_STATEMENT,
      &block_statement.span,
      BLOCK_STATEMENT_RESERVED_BYTES,
      false,
    );
    // body
    let mut keep_checking_directives = check_directive;
    self.convert_item_list_with_state(
      &block_statement.stmts,
      &mut keep_checking_directives,
      end_position + BLOCK_STATEMENT_BODY_OFFSET,
      |ast_converter, statement, can_be_directive| {
        if *can_be_directive {
          if let Stmt::Expr(expression) = statement {
            if let Expr::Lit(Lit::Str(string)) = &*expression.expr {
              ast_converter.store_directive(expression, &string.value);
              return true;
            }
          }
        }
        *can_be_directive = false;
        ast_converter.convert_statement(statement);
        true
      },
    );
    // end
    self.add_end(end_position, &block_statement.span);
  }
}
