## Highlights

This release [improves efficiency](https://blog.rabbitmq.com/posts/2022/05/rabbitmq-3.10-performance-improvements/) of quorum and classic queues.
Per-queue memory footprint was reduced for some
workloads. Queue operations produce less runtime GC pressure.

Quorum queues now support [message TTL](https://rabbitmq.com/ttl.html), at-most-once and at-least-once
strategies for dead-lettering, an operationally safer re-queue operation behavior,
and can be used for durable MQTT subscriptions in new clusters.

3.10.0 is the first release to introduce [Erlang 25 support](https://www.erlang.org/blog/my-otp-25-highlights/) at the time of writing)
which includes JIT support for 64-bit ARM processors.

Classic queues now ship a new message store and queue index implementation known as CQv2.
The operator must opt in to use them, CQv1 is still used by default.

Definition re-import on node restart now can be skipped if the source (a file, directory or a file retrieved over HTTPS)
has not changed. Queue and exchange re-import is now more efficient, the speed-up is over two orders of magnitude
in some environments.

The OAuth 2 plugin provides a way to map "non-standard" or "alias" scopes
to a set of RabbitMQ permissions.

## Obtaining Packages

RabbitMQ releases are distributed via [GitHub](https://github.com/rabbitmq/rabbitmq-server/releases), [Cloudsmith](https://cloudsmith.io/~rabbitmq/repos/), and [PackageCloud](https://packagecloud.io/rabbitmq).


### Erlang/OTP Compatibility Notes

This release [requires Erlang 23.2](https://www.rabbitmq.com/which-erlang.html) or later. Erlang 24 is recommended as it [offers 20%-50% throughput improvements](https://blog.rabbitmq.com/posts/2021/03/erlang-24-support-roadmap/) for many workloads.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains what package repositories and tools can be used to provision latest patch versions of Erlang 23.3.x and 24.x.



## Upgrading to 3.10

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for documentation on upgrades and [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

RabbitMQ 3.10.0 nodes can run alongside `3.9.x` nodes. `3.10.x`-specific features can only be made available when all nodes in the cluster
upgrade to 3.10.0 or any other patch release in the series.

While operating in mixed version mode, some aspects of the system may not behave as expected. The list of known behavior changes is covered below.
Once all nodes are upgraded to 3.10.0, these irregularities will go away.

Mixed version clusters are a mechanism that allows rolling upgrade and are not meant to be run for extended
periods of time (no more than a few hours).



## Compatibility Notes

### Client Library Compatibility

Client libraries that were compatible with RabbitMQ `3.9.x` will be compatible with `3.10.0`.


### Upgrading to Erlang 24.x

RabbitMQ `3.8.16` and later require Erlang `23.2` and support Erlang `24` (recommended).
Users of RabbitMQ versions that [do not support Erlang 23.2](https://www.rabbitmq.com/which-erlang.html) should first upgrade to the latest `3.8.x` patch release on Erlang 23.2,
then upgrade to `3.10.0`, and ideally Erlang 24.


### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).



## Changes Worth Mentioning

Release notes are kept under [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.10.x/release-notes).


### Core Server

#### Enhancements

 * Reduced memory footprint of quorum queues. Quorum queues now move enqueues messages to disk as quickly as
   possible, ignoring the `x-max-in-memory-length` and `x-max-in-memory-bytes` policy keys. This reduces per-queue memory footprint
   and makes throughput and latency less variable.

   GitHub issue: [#3898](https://github.com/rabbitmq/rabbitmq-server/issues/3898)

 * New classic queue index and message store implementations. This makes memory footprint of classic queues less variable
   and on average, lower than before. Consumer delivery is more efficient, potentially increasing throughput for workloads
   where consumers do keep up with producers.

   This implementation is not enabled by default. It can be enabled using a policy:

   ``` shell
   rabbitmqctl set_policy cq_version "^cq\." '{"queue-version": 2}' --priority 1 --apply-to queues
   ```

   or set via `rabbitmq.conf`:

   ``` ini
   classic_queue.default_version = 2
   ```
   GitHub issue: [#3029](https://github.com/rabbitmq/rabbitmq-server/pull/3029)

 * Quorum queues now support [message TTL](https://rabbitmq.com/ttl.html).

   GitHub issue: [#3121](https://github.com/rabbitmq/rabbitmq-server/pull/3121)

 * Reduced per-queue garbage collection.

   GitHub issue: [#4110](https://github.com/rabbitmq/rabbitmq-server/pull/4110)

 * Stream replication connections now adopt [TLS settings configured for inter-node communication links](https://rabbitmq.com/clustering-ssl.html).

   GitHub issue: [#3553](https://github.com/rabbitmq/rabbitmq-server/pull/3553)

 * Quorum queues now support two [dead lettering](https://rabbitmq.com/dlx.html) strategies, at-most-once (the 3.9 quorum queue and classic queue behavior)
   and at-least-once.

   To use at-least-once the user must opt-in.

   GitHub issue: [#3100](https://github.com/rabbitmq/rabbitmq-server/issues/3100)

 * Messages delivered by a quorum queue and negatively acknowledged with a requeue will be added to the back of the queue
   until the queue has redelivery limit set. With a redelivery limit, requeueing will use the original position of the message
   if possible.

   This improves operational safety: consumers that get stuck or requeue deliveries at a high rate will not indefinitely
   grow quorum queue Raft log, potentially driving the node out of disk space.

   ![Breaking change](https://img.shields.io/badge/-Breaking%20change-red) This is a **potentially breaking change**.
   Applications can make sure quorum queues have a redelivery limit
   set if the original behavior is important to keep.

   GitHub issue: [#3776](https://github.com/rabbitmq/rabbitmq-server/issues/3776)

 * [Boot time definition sync](https://rabbitmq.com/definitions.html#import-on-boot) now can be skipped if definition source (e.g. file or directory) contents
   have not changed:

   ``` ini
   definitions.skip_if_unchanged = true

   definitions.import_backend = local_filesystem
   definitions.local.path = /path/to/definitions/defs.json
   ```

   GitHub issue: [#4062](https://github.com/rabbitmq/rabbitmq-server/pull/4062)

 * Classic mirrored queues peak eager sync throughput now can be limited.

   Contributed by @thuandb (AWS).

   GitHub issue: [#3925](https://github.com/rabbitmq/rabbitmq-server/pull/3925)

 * [Optional queue arguments](https://rabbitmq.com/queues.html#optional-arguments) are now more strictly validated at queue
   declaration time, as are optional consumer arguments when new consumers subscribe.

   GitHub issue: [#4572](https://github.com/rabbitmq/rabbitmq-server/pull/4572)

 * Headers exchanges (AMQP 0-9-1) now support a new matching strategy, `"any-with-x"`,
   which works the same way as `"any"` but also considers headers that begin with
   an `"x-"`.

   GitHub issue: [#4143](https://github.com/rabbitmq/rabbitmq-server/pull/4143)

 * Queues can no longer be created in a vhost while deletion of that vhost is in progress

   Contributed by @tomyouyou.

   GitHub issue: [#4260](https://github.com/rabbitmq/rabbitmq-server/pull/4260)

 * rabbitmqctl encode/decode can now accept more values via standard input

   GitHub issue: [#4258](https://github.com/rabbitmq/rabbitmq-server/pull/4258)

 * rabbitmq_tracing now uses local time for timestamps

   GitHub issue: [#4277](https://github.com/rabbitmq/rabbitmq-server/pull/4277)


#### Internal API and Other Changes
 
 * Two rarely used classic queue metrics have been removed. Their removal reduces pressure
   on internal table writes and boosts classic queue v1 throughput by 10 to 20 percent.

   Contributed by @felixhuettner.

   GitHub issue: [#4431](https://github.com/rabbitmq/rabbitmq-server/pull/4431)

 * Tracing and `idle_since` timestamps now reflect local time in RFC 3339 format. Previously
   a custom format was used for these timestamps and they always reflected UTC time.

   GitHub issue: [#4276](https://github.com/rabbitmq/rabbitmq-server/pull/4276)
   
 * Inter-node message transfer is optimized for the case where a message is only routed to one queue.

   Contributed by @tomyouyou.

   GitHub issue: [#3865](https://github.com/rabbitmq/rabbitmq-server/pull/3865)

 * Definition import now can be extended to support arbitrary sources. This is done
   by providing a module that implements three functions: `is_enabled/0`, `load/1`, `load_with_hashing/3`.
   The module can then should be specified as the `definitions.import_backend` value:

   ``` ini
   definitions.import_backend = rabbit_definitions_import_our_custom_backend
   ```

   GitHub issue: [#3311](https://github.com/rabbitmq/rabbitmq-server/pull/3311)


 * Elixir 1.13 is now supported at build time.

   GitHub issue: [#4108](https://github.com/rabbitmq/rabbitmq-server/pull/4108)


#### Bug Fixes

This release includes all applicable [bug fixes that shipped in `3.9.x` releases](https://www.rabbitmq.com/changelog.html).

 * Addressed a performance regression for large fanouts when streams were not enabled.

   GitHub issue: [#4073](https://github.com/rabbitmq/rabbitmq-server/pull/4073)

 * Stream delivery rate could drop if concurrent stream consumers consumed in a way
   that made them reach the end of the stream often.

   GitHub issue: [#4371](https://github.com/rabbitmq/rabbitmq-server/pull/4371)

 * Channels could confirm a subset of messages published as mandatory in some cases.

   GitHub issue: [#3870](https://github.com/rabbitmq/rabbitmq-server/pull/3870)

 * Direct Erlang client initialisation had a race condition with earlier boot steps,
   which could lead plugins that depend on it to fail to open connections.

   GitHub issue: [#3685](https://github.com/rabbitmq/rabbitmq-server/pull/3685)

 * Exclusive queues are always placed on local node.

   [Exclusive queues](https://rabbitmq.com/queues.html#exclusive-queues) are by definition node-local because they are tied to the lifecycle of
   their declaring connection, which is node-local.

   GitHub issue: [#3341](https://github.com/rabbitmq/rabbitmq-server/pull/3341)


### Prometheus Plugin

#### Bug Fixes

 * Prometheus collector could run into an exception early on node's
   schema database sync.

   GitHub issue: [#4376](https://github.com/rabbitmq/rabbitmq-server/pull/4376)


### Management Plugin

#### Enhancements

 * `idle_since` field now uses RFC 3339 format.

   ![Breaking change](https://img.shields.io/badge/-Breaking%20change-red) This is a **potentially breaking change**.
   Sample value with the previous format: `2022-03-22 11:39:37`. With the new format: `2022-03-22T11:39:37.908+01:00`.
   Clients of the REST API should be able to parse values in the new format.

   GitHub issue: [#4276](https://github.com/rabbitmq/rabbitmq-server/issues/4276)

#### Bug Fixes

 * `rabbitmqadmin` now correctly loads TLS-related keys from its configuration file.

   Contributed by @fwolfsjaeger.

   GitHub issue: [#4408](https://github.com/rabbitmq/rabbitmq-server/pull/4408)


### MQTT Plugin

#### Enhancements

 * Durable (QoS 1) subscriptions now can be backed by [quorum queues](https://www.rabbitmq.com/quorum-queues.html) if configured so.

   This setting **can only be applied for new clusters**: existing durable classic
   queues will not be converted. Enabling this setting in a cluster with existing
   durable subscription data of MQTT clients will make it impossible for them to
   subscribe without **explicit queue deletion** by the cluster operator.

   To opt in to use quorum queues for durable MQTT subscriptions, use the `mqtt.durable_queue_type`
   configuration key in `rabbitmq.conf`:

   ``` ini
   mqtt.durable_queue_type = quorum
   ```

   GitHub issue: [#4401](https://github.com/rabbitmq/rabbitmq-server/pull/4401)


### OAuth 2 AuthN and AuthZ Backend Plugin

#### Enhancements

*  The plugin now supports scope aliases. In some environments, it's unrealistic to
   adopt JWTs that follow the `scope` convention assumed by the plugin. Instead,
   identity services fill `scope` or `claims` field with a "role name" or "role alias"
   that implicitly maps to a set of scopes/permissions.

   With this feature, RabbitMQ operators can map those values to a set of
   scopes that can be translated to RabbitMQ permissions.

   GitHub issue: [#4588](https://github.com/rabbitmq/rabbitmq-server/issues/4588)

 * Improvements to JKW support and new HTTPS settings.

   Contributed by @anhanhnguyen (Erlang Solutions).

   GitHub issue: [#3887](https://github.com/rabbitmq/rabbitmq-server/pull/3887)


### Shovel Plugin

#### Enhancements

 * Dynamic Shovels can be deleted or restarted from any cluster node

   Contributed by @kostakal.

   GitHub issue: [#4242](https://github.com/rabbitmq/rabbitmq-server/pull/4242)

#### Bug Fixes

 * Shovels with automatic deletion threshold of `0` are now correctly deleted immediately.

   Contribited by @luos (Erlang Solutions).

   GitHub issue: [#4098](https://github.com/rabbitmq/rabbitmq-server/pull/4098)


### Consul Peer Discovery Plugin

#### Bug Fixes

 * Handle a response code change in Consul 1.11.

   Contributed by @maestroes.

   GitHub issue: [#4149](https://github.com/rabbitmq/rabbitmq-server/issues/4149)


### Dependency Changes

 * `ra` upgraded from [`2.0.0` to `2.0.9`](https://github.com/rabbitmq/ra/compare/v2.0.0...v2.0.9)
 * `osiris` upgraded from [`1.0.0` to `1.2.6`](https://github.com/rabbitmq/osiris/compare/v1.0.0...v1.2.6)
 * `ranch` upgraded from [`2.0.0` to `2.1.0`](https://github.com/ninenines/ranch/compare/2.0.0...2.1.0)
 * `prometheus` upgraded from [`4.8.1` to `4.8.2`](https://github.com/deadtrickster/prometheus.erl/compare/06425c21a39c1564164f1cc3fe5bdfa8b23b1f78...v4.8.2)
 * `eetcd` upgraded from [`0.3.3` to `0.3.5`](https://github.com/zhongwencool/eetcd/compare/v0.3.3...v0.3.5)
 * `observer_cli` upgraded from [`1.6.2` to `1.7.3`](https://github.com/zhongwencool/observer_cli/compare/1.6.2...1.7.3)
 * `gen_batch_server` upgraded from [`0.8.6` to `0.8.7`](https://github.com/rabbitmq/gen-batch-server/compare/38191672ee0f22a8d5291c6c09f8c07178d565ca...v0.8.7)
