/* $NoKeywords: $ */
/*
//
// Copyright (c) 1993-2012 Robert McNeel & Associates. All rights reserved.
// OpenNURBS, Rhinoceros, and Rhino3D are registered trademarks of Robert
// McNeel & Associates.
//
// THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
// ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR PURPOSE AND OF
// MERCHANTABILITY ARE HEREBY DISCLAIMED.
//				
// For complete openNURBS copyright information see <http://www.opennurbs.org>.
//
////////////////////////////////////////////////////////////////
*/

#include "opennurbs.h"

#if !defined(ON_COMPILING_OPENNURBS)
// This check is included in all opennurbs source .c and .cpp files to insure
// ON_COMPILING_OPENNURBS is defined when opennurbs source is compiled.
// When opennurbs source is being compiled, ON_COMPILING_OPENNURBS is defined 
// and the opennurbs .h files alter what is declared and how it is declared.
#error ON_COMPILING_OPENNURBS must be defined when compiling opennurbs
#endif

#if !defined(ON_RUNTIME_WIN)
#error Do not use for Windows builds.
#endif


#include "opennurbs_internal_unicode_cp.h"

#if defined(ON_DOUBLE_BYTE_CODE_PAGE_SUPPORT)

/*
    default: code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter; break;
  }
  return code_point;  
}

#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
static ON__UINT32 Internal_MapWindowsCodePage932ToUnicode_0x(
  ON__UINT32 code_page_932_character_value
)
{
  ON__UINT32 code_point;
  switch (code_page_932_character_value)
  {

*/

/*
# JIS0208.TXT
# Date: 2015-12-02 23:50:00 GMT [KW]
# © 2015 Unicode®, Inc.
# For terms of use, see http://www.unicode.org/terms_of_use.html
#
#	Name:             JIS X 0208 (1990) to Unicode
#	Unicode version:  1.1
#	Table version:    2.0
#	Table format:     Format A
#	Date:             2011 October 14 (header updated: 2015 December 02)
#
#	General notes:
#
#
# This table contains one set of mappings from JIS X 0208 (1990) into Unicode.
# Note that these data are *possible* mappings only and may not be the
# same as those used by actual products, nor may they be the best suited
# for all uses.  For more information on the mappings between various code
# pages incorporating the repertoire of JIS X 0208 (1990) and Unicode, consult the
# VENDORS mapping data.
#
#
#	Format:  Four tab-separated columns
#		 Column #1 is the shift-JIS code (in hex)
#		 Column #2 is the JIS X 0208 code (in hex as 0xXXXX)
#		 Column #3 is the Unicode (in hex as 0xXXXX)
#		 Column #4 the Unicode name (follows a comment sign, '#')
#			The official names for Unicode characters U+4E00
#			to U+9FA5, inclusive, is "CJK UNIFIED IDEOGRAPH-XXXX",
#			where XXXX is the code point.  Including all these
#			names in this file increases its size substantially
#			and needlessly.  The token "<CJK>" is used for the
#			name of these characters.  If necessary, it can be
#			expanded algorithmically by a parser or editor.
#
#	The entries are in JIS X 0208 order
#
#	The following algorithms can be used to change the hex form
#		of JIS 0208 to other standard forms:
#
#		To change hex to EUC form, add 0x8080
#		To change hex to kuten form, first subtract 0x2020.  Then
#			the high and low bytes correspond to the ku and ten of
#			the kuten form.  For example, 0x2121 -> 0x0101 -> 0101;
#			0x7426 -> 0x5406 -> 8406
#
#  Revision History:
#
#    [v2.0, 2015 December 02]
#    updates to copyright notice and terms of use
#    no changes to character mappings
#
#    [v1.0, 2011 October 14]
#    Updated terms of use to current wording.
#    Updated contact information.
#    No changes to the mapping data.
#
#    [v0.9, 8 March 1994]
#    First release.
#
#  Use the Unicode reporting form <http://www.unicode.org/reporting.html>
#    for any questions or comments or to report errors in the data.
#
*/
/*
shift-JIS<SEP>JIS X 0208<SEP>UNICODE<SEP3>// name
0x8140<SEP>0x2121<SEP>0x3000<SEP3>// IDEOGRAPHIC SPACE
0x8141<SEP>0x2122<SEP>0x3001<SEP3>// IDEOGRAPHIC COMMA
0x8142<SEP>0x2123<SEP>0x3002<SEP3>// IDEOGRAPHIC FULL STOP
0x8143<SEP>0x2124<SEP>0xFF0C<SEP3>// FULLWIDTH COMMA
0x8144<SEP>0x2125<SEP>0xFF0E<SEP3>// FULLWIDTH FULL STOP
0x8145<SEP>0x2126<SEP>0x30FB<SEP3>// KATAKANA MIDDLE DOT
0x8146<SEP>0x2127<SEP>0xFF1A<SEP3>// FULLWIDTH COLON
0x8147<SEP>0x2128<SEP>0xFF1B<SEP3>// FULLWIDTH SEMICOLON
0x8148<SEP>0x2129<SEP>0xFF1F<SEP3>// FULLWIDTH QUESTION MARK
0x8149<SEP>0x212A<SEP>0xFF01<SEP3>// FULLWIDTH EXCLAMATION MARK
0x814A<SEP>0x212B<SEP>0x309B<SEP3>// KATAKANA-HIRAGANA VOICED SOUND MARK
0x814B<SEP>0x212C<SEP>0x309C<SEP3>// KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
0x814C<SEP>0x212D<SEP>0x00B4<SEP3>// ACUTE ACCENT
0x814D<SEP>0x212E<SEP>0xFF40<SEP3>// FULLWIDTH GRAVE ACCENT
0x814E<SEP>0x212F<SEP>0x00A8<SEP3>// DIAERESIS
0x814F<SEP>0x2130<SEP>0xFF3E<SEP3>// FULLWIDTH CIRCUMFLEX ACCENT
0x8150<SEP>0x2131<SEP>0xFFE3<SEP3>// FULLWIDTH MACRON
0x8151<SEP>0x2132<SEP>0xFF3F<SEP3>// FULLWIDTH LOW LINE
0x8152<SEP>0x2133<SEP>0x30FD<SEP3>// KATAKANA ITERATION MARK
0x8153<SEP>0x2134<SEP>0x30FE<SEP3>// KATAKANA VOICED ITERATION MARK
0x8154<SEP>0x2135<SEP>0x309D<SEP3>// HIRAGANA ITERATION MARK
0x8155<SEP>0x2136<SEP>0x309E<SEP3>// HIRAGANA VOICED ITERATION MARK
0x8156<SEP>0x2137<SEP>0x3003<SEP3>// DITTO MARK
0x8157<SEP>0x2138<SEP>0x4EDD<SEP3>// <CJK>
0x8158<SEP>0x2139<SEP>0x3005<SEP3>// IDEOGRAPHIC ITERATION MARK
0x8159<SEP>0x213A<SEP>0x3006<SEP3>// IDEOGRAPHIC CLOSING MARK
0x815A<SEP>0x213B<SEP>0x3007<SEP3>// IDEOGRAPHIC NUMBER ZERO
0x815B<SEP>0x213C<SEP>0x30FC<SEP3>// KATAKANA-HIRAGANA PROLONGED SOUND MARK
0x815C<SEP>0x213D<SEP>0x2015<SEP3>// HORIZONTAL BAR
0x815D<SEP>0x213E<SEP>0x2010<SEP3>// HYPHEN
0x815E<SEP>0x213F<SEP>0xFF0F<SEP3>// FULLWIDTH SOLIDUS
0x815F<SEP>0x2140<SEP>0x005C<SEP3>// REVERSE SOLIDUS
0x8160<SEP>0x2141<SEP>0x301C<SEP3>// WAVE DASH
0x8161<SEP>0x2142<SEP>0x2016<SEP3>// DOUBLE VERTICAL LINE
0x8162<SEP>0x2143<SEP>0xFF5C<SEP3>// FULLWIDTH VERTICAL LINE
0x8163<SEP>0x2144<SEP>0x2026<SEP3>// HORIZONTAL ELLIPSIS
0x8164<SEP>0x2145<SEP>0x2025<SEP3>// TWO DOT LEADER
0x8165<SEP>0x2146<SEP>0x2018<SEP3>// LEFT SINGLE QUOTATION MARK
0x8166<SEP>0x2147<SEP>0x2019<SEP3>// RIGHT SINGLE QUOTATION MARK
0x8167<SEP>0x2148<SEP>0x201C<SEP3>// LEFT DOUBLE QUOTATION MARK
0x8168<SEP>0x2149<SEP>0x201D<SEP3>// RIGHT DOUBLE QUOTATION MARK
0x8169<SEP>0x214A<SEP>0xFF08<SEP3>// FULLWIDTH LEFT PARENTHESIS
0x816A<SEP>0x214B<SEP>0xFF09<SEP3>// FULLWIDTH RIGHT PARENTHESIS
0x816B<SEP>0x214C<SEP>0x3014<SEP3>// LEFT TORTOISE SHELL BRACKET
0x816C<SEP>0x214D<SEP>0x3015<SEP3>// RIGHT TORTOISE SHELL BRACKET
0x816D<SEP>0x214E<SEP>0xFF3B<SEP3>// FULLWIDTH LEFT SQUARE BRACKET
0x816E<SEP>0x214F<SEP>0xFF3D<SEP3>// FULLWIDTH RIGHT SQUARE BRACKET
0x816F<SEP>0x2150<SEP>0xFF5B<SEP3>// FULLWIDTH LEFT CURLY BRACKET
0x8170<SEP>0x2151<SEP>0xFF5D<SEP3>// FULLWIDTH RIGHT CURLY BRACKET
0x8171<SEP>0x2152<SEP>0x3008<SEP3>// LEFT ANGLE BRACKET
0x8172<SEP>0x2153<SEP>0x3009<SEP3>// RIGHT ANGLE BRACKET
0x8173<SEP>0x2154<SEP>0x300A<SEP3>// LEFT DOUBLE ANGLE BRACKET
0x8174<SEP>0x2155<SEP>0x300B<SEP3>// RIGHT DOUBLE ANGLE BRACKET
0x8175<SEP>0x2156<SEP>0x300C<SEP3>// LEFT CORNER BRACKET
0x8176<SEP>0x2157<SEP>0x300D<SEP3>// RIGHT CORNER BRACKET
0x8177<SEP>0x2158<SEP>0x300E<SEP3>// LEFT WHITE CORNER BRACKET
0x8178<SEP>0x2159<SEP>0x300F<SEP3>// RIGHT WHITE CORNER BRACKET
0x8179<SEP>0x215A<SEP>0x3010<SEP3>// LEFT BLACK LENTICULAR BRACKET
0x817A<SEP>0x215B<SEP>0x3011<SEP3>// RIGHT BLACK LENTICULAR BRACKET
0x817B<SEP>0x215C<SEP>0xFF0B<SEP3>// FULLWIDTH PLUS SIGN
0x817C<SEP>0x215D<SEP>0x2212<SEP3>// MINUS SIGN
0x817D<SEP>0x215E<SEP>0x00B1<SEP3>// PLUS-MINUS SIGN
0x817E<SEP>0x215F<SEP>0x00D7<SEP3>// MULTIPLICATION SIGN
0x8180<SEP>0x2160<SEP>0x00F7<SEP3>// DIVISION SIGN
0x8181<SEP>0x2161<SEP>0xFF1D<SEP3>// FULLWIDTH EQUALS SIGN
0x8182<SEP>0x2162<SEP>0x2260<SEP3>// NOT EQUAL TO
0x8183<SEP>0x2163<SEP>0xFF1C<SEP3>// FULLWIDTH LESS-THAN SIGN
0x8184<SEP>0x2164<SEP>0xFF1E<SEP3>// FULLWIDTH GREATER-THAN SIGN
0x8185<SEP>0x2165<SEP>0x2266<SEP3>// LESS-THAN OVER EQUAL TO
0x8186<SEP>0x2166<SEP>0x2267<SEP3>// GREATER-THAN OVER EQUAL TO
0x8187<SEP>0x2167<SEP>0x221E<SEP3>// INFINITY
0x8188<SEP>0x2168<SEP>0x2234<SEP3>// THEREFORE
0x8189<SEP>0x2169<SEP>0x2642<SEP3>// MALE SIGN
0x818A<SEP>0x216A<SEP>0x2640<SEP3>// FEMALE SIGN
0x818B<SEP>0x216B<SEP>0x00B0<SEP3>// DEGREE SIGN
0x818C<SEP>0x216C<SEP>0x2032<SEP3>// PRIME
0x818D<SEP>0x216D<SEP>0x2033<SEP3>// DOUBLE PRIME
0x818E<SEP>0x216E<SEP>0x2103<SEP3>// DEGREE CELSIUS
0x818F<SEP>0x216F<SEP>0xFFE5<SEP3>// FULLWIDTH YEN SIGN
0x8190<SEP>0x2170<SEP>0xFF04<SEP3>// FULLWIDTH DOLLAR SIGN
0x8191<SEP>0x2171<SEP>0x00A2<SEP3>// CENT SIGN
0x8192<SEP>0x2172<SEP>0x00A3<SEP3>// POUND SIGN
0x8193<SEP>0x2173<SEP>0xFF05<SEP3>// FULLWIDTH PERCENT SIGN
0x8194<SEP>0x2174<SEP>0xFF03<SEP3>// FULLWIDTH NUMBER SIGN
0x8195<SEP>0x2175<SEP>0xFF06<SEP3>// FULLWIDTH AMPERSAND
0x8196<SEP>0x2176<SEP>0xFF0A<SEP3>// FULLWIDTH ASTERISK
0x8197<SEP>0x2177<SEP>0xFF20<SEP3>// FULLWIDTH COMMERCIAL AT
0x8198<SEP>0x2178<SEP>0x00A7<SEP3>// SECTION SIGN
0x8199<SEP>0x2179<SEP>0x2606<SEP3>// WHITE STAR
0x819A<SEP>0x217A<SEP>0x2605<SEP3>// BLACK STAR
0x819B<SEP>0x217B<SEP>0x25CB<SEP3>// WHITE CIRCLE
0x819C<SEP>0x217C<SEP>0x25CF<SEP3>// BLACK CIRCLE
0x819D<SEP>0x217D<SEP>0x25CE<SEP3>// BULLSEYE
0x819E<SEP>0x217E<SEP>0x25C7<SEP3>// WHITE DIAMOND
0x819F<SEP>0x2221<SEP>0x25C6<SEP3>// BLACK DIAMOND
0x81A0<SEP>0x2222<SEP>0x25A1<SEP3>// WHITE SQUARE
0x81A1<SEP>0x2223<SEP>0x25A0<SEP3>// BLACK SQUARE
0x81A2<SEP>0x2224<SEP>0x25B3<SEP3>// WHITE UP-POINTING TRIANGLE
0x81A3<SEP>0x2225<SEP>0x25B2<SEP3>// BLACK UP-POINTING TRIANGLE
0x81A4<SEP>0x2226<SEP>0x25BD<SEP3>// WHITE DOWN-POINTING TRIANGLE
0x81A5<SEP>0x2227<SEP>0x25BC<SEP3>// BLACK DOWN-POINTING TRIANGLE
0x81A6<SEP>0x2228<SEP>0x203B<SEP3>// REFERENCE MARK
0x81A7<SEP>0x2229<SEP>0x3012<SEP3>// POSTAL MARK
0x81A8<SEP>0x222A<SEP>0x2192<SEP3>// RIGHTWARDS ARROW
0x81A9<SEP>0x222B<SEP>0x2190<SEP3>// LEFTWARDS ARROW
0x81AA<SEP>0x222C<SEP>0x2191<SEP3>// UPWARDS ARROW
0x81AB<SEP>0x222D<SEP>0x2193<SEP3>// DOWNWARDS ARROW
0x81AC<SEP>0x222E<SEP>0x3013<SEP3>// GETA MARK
0x81B8<SEP>0x223A<SEP>0x2208<SEP3>// ELEMENT OF
0x81B9<SEP>0x223B<SEP>0x220B<SEP3>// CONTAINS AS MEMBER
0x81BA<SEP>0x223C<SEP>0x2286<SEP3>// SUBSET OF OR EQUAL TO
0x81BB<SEP>0x223D<SEP>0x2287<SEP3>// SUPERSET OF OR EQUAL TO
0x81BC<SEP>0x223E<SEP>0x2282<SEP3>// SUBSET OF
0x81BD<SEP>0x223F<SEP>0x2283<SEP3>// SUPERSET OF
0x81BE<SEP>0x2240<SEP>0x222A<SEP3>// UNION
0x81BF<SEP>0x2241<SEP>0x2229<SEP3>// INTERSECTION
0x81C8<SEP>0x224A<SEP>0x2227<SEP3>// LOGICAL AND
0x81C9<SEP>0x224B<SEP>0x2228<SEP3>// LOGICAL OR
0x81CA<SEP>0x224C<SEP>0x00AC<SEP3>// NOT SIGN
0x81CB<SEP>0x224D<SEP>0x21D2<SEP3>// RIGHTWARDS DOUBLE ARROW
0x81CC<SEP>0x224E<SEP>0x21D4<SEP3>// LEFT RIGHT DOUBLE ARROW
0x81CD<SEP>0x224F<SEP>0x2200<SEP3>// FOR ALL
0x81CE<SEP>0x2250<SEP>0x2203<SEP3>// THERE EXISTS
0x81DA<SEP>0x225C<SEP>0x2220<SEP3>// ANGLE
0x81DB<SEP>0x225D<SEP>0x22A5<SEP3>// UP TACK
0x81DC<SEP>0x225E<SEP>0x2312<SEP3>// ARC
0x81DD<SEP>0x225F<SEP>0x2202<SEP3>// PARTIAL DIFFERENTIAL
0x81DE<SEP>0x2260<SEP>0x2207<SEP3>// NABLA
0x81DF<SEP>0x2261<SEP>0x2261<SEP3>// IDENTICAL TO
0x81E0<SEP>0x2262<SEP>0x2252<SEP3>// APPROXIMATELY EQUAL TO OR THE IMAGE OF
0x81E1<SEP>0x2263<SEP>0x226A<SEP3>// MUCH LESS-THAN
0x81E2<SEP>0x2264<SEP>0x226B<SEP3>// MUCH GREATER-THAN
0x81E3<SEP>0x2265<SEP>0x221A<SEP3>// SQUARE ROOT
0x81E4<SEP>0x2266<SEP>0x223D<SEP3>// REVERSED TILDE
0x81E5<SEP>0x2267<SEP>0x221D<SEP3>// PROPORTIONAL TO
0x81E6<SEP>0x2268<SEP>0x2235<SEP3>// BECAUSE
0x81E7<SEP>0x2269<SEP>0x222B<SEP3>// INTEGRAL
0x81E8<SEP>0x226A<SEP>0x222C<SEP3>// DOUBLE INTEGRAL
0x81F0<SEP>0x2272<SEP>0x212B<SEP3>// ANGSTROM SIGN
0x81F1<SEP>0x2273<SEP>0x2030<SEP3>// PER MILLE SIGN
0x81F2<SEP>0x2274<SEP>0x266F<SEP3>// MUSIC SHARP SIGN
0x81F3<SEP>0x2275<SEP>0x266D<SEP3>// MUSIC FLAT SIGN
0x81F4<SEP>0x2276<SEP>0x266A<SEP3>// EIGHTH NOTE
0x81F5<SEP>0x2277<SEP>0x2020<SEP3>// DAGGER
0x81F6<SEP>0x2278<SEP>0x2021<SEP3>// DOUBLE DAGGER
0x81F7<SEP>0x2279<SEP>0x00B6<SEP3>// PILCROW SIGN
0x81FC<SEP>0x227E<SEP>0x25EF<SEP3>// LARGE CIRCLE
0x824F<SEP>0x2330<SEP>0xFF10<SEP3>// FULLWIDTH DIGIT ZERO
0x8250<SEP>0x2331<SEP>0xFF11<SEP3>// FULLWIDTH DIGIT ONE
0x8251<SEP>0x2332<SEP>0xFF12<SEP3>// FULLWIDTH DIGIT TWO
0x8252<SEP>0x2333<SEP>0xFF13<SEP3>// FULLWIDTH DIGIT THREE
0x8253<SEP>0x2334<SEP>0xFF14<SEP3>// FULLWIDTH DIGIT FOUR
0x8254<SEP>0x2335<SEP>0xFF15<SEP3>// FULLWIDTH DIGIT FIVE
0x8255<SEP>0x2336<SEP>0xFF16<SEP3>// FULLWIDTH DIGIT SIX
0x8256<SEP>0x2337<SEP>0xFF17<SEP3>// FULLWIDTH DIGIT SEVEN
0x8257<SEP>0x2338<SEP>0xFF18<SEP3>// FULLWIDTH DIGIT EIGHT
0x8258<SEP>0x2339<SEP>0xFF19<SEP3>// FULLWIDTH DIGIT NINE
0x8260<SEP>0x2341<SEP>0xFF21<SEP3>// FULLWIDTH LATIN CAPITAL LETTER A
0x8261<SEP>0x2342<SEP>0xFF22<SEP3>// FULLWIDTH LATIN CAPITAL LETTER B
0x8262<SEP>0x2343<SEP>0xFF23<SEP3>// FULLWIDTH LATIN CAPITAL LETTER C
0x8263<SEP>0x2344<SEP>0xFF24<SEP3>// FULLWIDTH LATIN CAPITAL LETTER D
0x8264<SEP>0x2345<SEP>0xFF25<SEP3>// FULLWIDTH LATIN CAPITAL LETTER E
0x8265<SEP>0x2346<SEP>0xFF26<SEP3>// FULLWIDTH LATIN CAPITAL LETTER F
0x8266<SEP>0x2347<SEP>0xFF27<SEP3>// FULLWIDTH LATIN CAPITAL LETTER G
0x8267<SEP>0x2348<SEP>0xFF28<SEP3>// FULLWIDTH LATIN CAPITAL LETTER H
0x8268<SEP>0x2349<SEP>0xFF29<SEP3>// FULLWIDTH LATIN CAPITAL LETTER I
0x8269<SEP>0x234A<SEP>0xFF2A<SEP3>// FULLWIDTH LATIN CAPITAL LETTER J
0x826A<SEP>0x234B<SEP>0xFF2B<SEP3>// FULLWIDTH LATIN CAPITAL LETTER K
0x826B<SEP>0x234C<SEP>0xFF2C<SEP3>// FULLWIDTH LATIN CAPITAL LETTER L
0x826C<SEP>0x234D<SEP>0xFF2D<SEP3>// FULLWIDTH LATIN CAPITAL LETTER M
0x826D<SEP>0x234E<SEP>0xFF2E<SEP3>// FULLWIDTH LATIN CAPITAL LETTER N
0x826E<SEP>0x234F<SEP>0xFF2F<SEP3>// FULLWIDTH LATIN CAPITAL LETTER O
0x826F<SEP>0x2350<SEP>0xFF30<SEP3>// FULLWIDTH LATIN CAPITAL LETTER P
0x8270<SEP>0x2351<SEP>0xFF31<SEP3>// FULLWIDTH LATIN CAPITAL LETTER Q
0x8271<SEP>0x2352<SEP>0xFF32<SEP3>// FULLWIDTH LATIN CAPITAL LETTER R
0x8272<SEP>0x2353<SEP>0xFF33<SEP3>// FULLWIDTH LATIN CAPITAL LETTER S
0x8273<SEP>0x2354<SEP>0xFF34<SEP3>// FULLWIDTH LATIN CAPITAL LETTER T
0x8274<SEP>0x2355<SEP>0xFF35<SEP3>// FULLWIDTH LATIN CAPITAL LETTER U
0x8275<SEP>0x2356<SEP>0xFF36<SEP3>// FULLWIDTH LATIN CAPITAL LETTER V
0x8276<SEP>0x2357<SEP>0xFF37<SEP3>// FULLWIDTH LATIN CAPITAL LETTER W
0x8277<SEP>0x2358<SEP>0xFF38<SEP3>// FULLWIDTH LATIN CAPITAL LETTER X
0x8278<SEP>0x2359<SEP>0xFF39<SEP3>// FULLWIDTH LATIN CAPITAL LETTER Y
0x8279<SEP>0x235A<SEP>0xFF3A<SEP3>// FULLWIDTH LATIN CAPITAL LETTER Z
0x8281<SEP>0x2361<SEP>0xFF41<SEP3>// FULLWIDTH LATIN SMALL LETTER A
0x8282<SEP>0x2362<SEP>0xFF42<SEP3>// FULLWIDTH LATIN SMALL LETTER B
0x8283<SEP>0x2363<SEP>0xFF43<SEP3>// FULLWIDTH LATIN SMALL LETTER C
0x8284<SEP>0x2364<SEP>0xFF44<SEP3>// FULLWIDTH LATIN SMALL LETTER D
0x8285<SEP>0x2365<SEP>0xFF45<SEP3>// FULLWIDTH LATIN SMALL LETTER E
0x8286<SEP>0x2366<SEP>0xFF46<SEP3>// FULLWIDTH LATIN SMALL LETTER F
0x8287<SEP>0x2367<SEP>0xFF47<SEP3>// FULLWIDTH LATIN SMALL LETTER G
0x8288<SEP>0x2368<SEP>0xFF48<SEP3>// FULLWIDTH LATIN SMALL LETTER H
0x8289<SEP>0x2369<SEP>0xFF49<SEP3>// FULLWIDTH LATIN SMALL LETTER I
0x828A<SEP>0x236A<SEP>0xFF4A<SEP3>// FULLWIDTH LATIN SMALL LETTER J
0x828B<SEP>0x236B<SEP>0xFF4B<SEP3>// FULLWIDTH LATIN SMALL LETTER K
0x828C<SEP>0x236C<SEP>0xFF4C<SEP3>// FULLWIDTH LATIN SMALL LETTER L
0x828D<SEP>0x236D<SEP>0xFF4D<SEP3>// FULLWIDTH LATIN SMALL LETTER M
0x828E<SEP>0x236E<SEP>0xFF4E<SEP3>// FULLWIDTH LATIN SMALL LETTER N
0x828F<SEP>0x236F<SEP>0xFF4F<SEP3>// FULLWIDTH LATIN SMALL LETTER O
0x8290<SEP>0x2370<SEP>0xFF50<SEP3>// FULLWIDTH LATIN SMALL LETTER P
0x8291<SEP>0x2371<SEP>0xFF51<SEP3>// FULLWIDTH LATIN SMALL LETTER Q
0x8292<SEP>0x2372<SEP>0xFF52<SEP3>// FULLWIDTH LATIN SMALL LETTER R
0x8293<SEP>0x2373<SEP>0xFF53<SEP3>// FULLWIDTH LATIN SMALL LETTER S
0x8294<SEP>0x2374<SEP>0xFF54<SEP3>// FULLWIDTH LATIN SMALL LETTER T
0x8295<SEP>0x2375<SEP>0xFF55<SEP3>// FULLWIDTH LATIN SMALL LETTER U
0x8296<SEP>0x2376<SEP>0xFF56<SEP3>// FULLWIDTH LATIN SMALL LETTER V
0x8297<SEP>0x2377<SEP>0xFF57<SEP3>// FULLWIDTH LATIN SMALL LETTER W
0x8298<SEP>0x2378<SEP>0xFF58<SEP3>// FULLWIDTH LATIN SMALL LETTER X
0x8299<SEP>0x2379<SEP>0xFF59<SEP3>// FULLWIDTH LATIN SMALL LETTER Y
0x829A<SEP>0x237A<SEP>0xFF5A<SEP3>// FULLWIDTH LATIN SMALL LETTER Z
0x829F<SEP>0x2421<SEP>0x3041<SEP3>// HIRAGANA LETTER SMALL A
0x82A0<SEP>0x2422<SEP>0x3042<SEP3>// HIRAGANA LETTER A
0x82A1<SEP>0x2423<SEP>0x3043<SEP3>// HIRAGANA LETTER SMALL I
0x82A2<SEP>0x2424<SEP>0x3044<SEP3>// HIRAGANA LETTER I
0x82A3<SEP>0x2425<SEP>0x3045<SEP3>// HIRAGANA LETTER SMALL U
0x82A4<SEP>0x2426<SEP>0x3046<SEP3>// HIRAGANA LETTER U
0x82A5<SEP>0x2427<SEP>0x3047<SEP3>// HIRAGANA LETTER SMALL E
0x82A6<SEP>0x2428<SEP>0x3048<SEP3>// HIRAGANA LETTER E
0x82A7<SEP>0x2429<SEP>0x3049<SEP3>// HIRAGANA LETTER SMALL O
0x82A8<SEP>0x242A<SEP>0x304A<SEP3>// HIRAGANA LETTER O
0x82A9<SEP>0x242B<SEP>0x304B<SEP3>// HIRAGANA LETTER KA
0x82AA<SEP>0x242C<SEP>0x304C<SEP3>// HIRAGANA LETTER GA
0x82AB<SEP>0x242D<SEP>0x304D<SEP3>// HIRAGANA LETTER KI
0x82AC<SEP>0x242E<SEP>0x304E<SEP3>// HIRAGANA LETTER GI
0x82AD<SEP>0x242F<SEP>0x304F<SEP3>// HIRAGANA LETTER KU
0x82AE<SEP>0x2430<SEP>0x3050<SEP3>// HIRAGANA LETTER GU
0x82AF<SEP>0x2431<SEP>0x3051<SEP3>// HIRAGANA LETTER KE
0x82B0<SEP>0x2432<SEP>0x3052<SEP3>// HIRAGANA LETTER GE
0x82B1<SEP>0x2433<SEP>0x3053<SEP3>// HIRAGANA LETTER KO
0x82B2<SEP>0x2434<SEP>0x3054<SEP3>// HIRAGANA LETTER GO
0x82B3<SEP>0x2435<SEP>0x3055<SEP3>// HIRAGANA LETTER SA
0x82B4<SEP>0x2436<SEP>0x3056<SEP3>// HIRAGANA LETTER ZA
0x82B5<SEP>0x2437<SEP>0x3057<SEP3>// HIRAGANA LETTER SI
0x82B6<SEP>0x2438<SEP>0x3058<SEP3>// HIRAGANA LETTER ZI
0x82B7<SEP>0x2439<SEP>0x3059<SEP3>// HIRAGANA LETTER SU
0x82B8<SEP>0x243A<SEP>0x305A<SEP3>// HIRAGANA LETTER ZU
0x82B9<SEP>0x243B<SEP>0x305B<SEP3>// HIRAGANA LETTER SE
0x82BA<SEP>0x243C<SEP>0x305C<SEP3>// HIRAGANA LETTER ZE
0x82BB<SEP>0x243D<SEP>0x305D<SEP3>// HIRAGANA LETTER SO
0x82BC<SEP>0x243E<SEP>0x305E<SEP3>// HIRAGANA LETTER ZO
0x82BD<SEP>0x243F<SEP>0x305F<SEP3>// HIRAGANA LETTER TA
0x82BE<SEP>0x2440<SEP>0x3060<SEP3>// HIRAGANA LETTER DA
0x82BF<SEP>0x2441<SEP>0x3061<SEP3>// HIRAGANA LETTER TI
0x82C0<SEP>0x2442<SEP>0x3062<SEP3>// HIRAGANA LETTER DI
0x82C1<SEP>0x2443<SEP>0x3063<SEP3>// HIRAGANA LETTER SMALL TU
0x82C2<SEP>0x2444<SEP>0x3064<SEP3>// HIRAGANA LETTER TU
0x82C3<SEP>0x2445<SEP>0x3065<SEP3>// HIRAGANA LETTER DU
0x82C4<SEP>0x2446<SEP>0x3066<SEP3>// HIRAGANA LETTER TE
0x82C5<SEP>0x2447<SEP>0x3067<SEP3>// HIRAGANA LETTER DE
0x82C6<SEP>0x2448<SEP>0x3068<SEP3>// HIRAGANA LETTER TO
0x82C7<SEP>0x2449<SEP>0x3069<SEP3>// HIRAGANA LETTER DO
0x82C8<SEP>0x244A<SEP>0x306A<SEP3>// HIRAGANA LETTER NA
0x82C9<SEP>0x244B<SEP>0x306B<SEP3>// HIRAGANA LETTER NI
0x82CA<SEP>0x244C<SEP>0x306C<SEP3>// HIRAGANA LETTER NU
0x82CB<SEP>0x244D<SEP>0x306D<SEP3>// HIRAGANA LETTER NE
0x82CC<SEP>0x244E<SEP>0x306E<SEP3>// HIRAGANA LETTER NO
0x82CD<SEP>0x244F<SEP>0x306F<SEP3>// HIRAGANA LETTER HA
0x82CE<SEP>0x2450<SEP>0x3070<SEP3>// HIRAGANA LETTER BA
0x82CF<SEP>0x2451<SEP>0x3071<SEP3>// HIRAGANA LETTER PA
0x82D0<SEP>0x2452<SEP>0x3072<SEP3>// HIRAGANA LETTER HI
0x82D1<SEP>0x2453<SEP>0x3073<SEP3>// HIRAGANA LETTER BI
0x82D2<SEP>0x2454<SEP>0x3074<SEP3>// HIRAGANA LETTER PI
0x82D3<SEP>0x2455<SEP>0x3075<SEP3>// HIRAGANA LETTER HU
0x82D4<SEP>0x2456<SEP>0x3076<SEP3>// HIRAGANA LETTER BU
0x82D5<SEP>0x2457<SEP>0x3077<SEP3>// HIRAGANA LETTER PU
0x82D6<SEP>0x2458<SEP>0x3078<SEP3>// HIRAGANA LETTER HE
0x82D7<SEP>0x2459<SEP>0x3079<SEP3>// HIRAGANA LETTER BE
0x82D8<SEP>0x245A<SEP>0x307A<SEP3>// HIRAGANA LETTER PE
0x82D9<SEP>0x245B<SEP>0x307B<SEP3>// HIRAGANA LETTER HO
0x82DA<SEP>0x245C<SEP>0x307C<SEP3>// HIRAGANA LETTER BO
0x82DB<SEP>0x245D<SEP>0x307D<SEP3>// HIRAGANA LETTER PO
0x82DC<SEP>0x245E<SEP>0x307E<SEP3>// HIRAGANA LETTER MA
0x82DD<SEP>0x245F<SEP>0x307F<SEP3>// HIRAGANA LETTER MI
0x82DE<SEP>0x2460<SEP>0x3080<SEP3>// HIRAGANA LETTER MU
0x82DF<SEP>0x2461<SEP>0x3081<SEP3>// HIRAGANA LETTER ME
0x82E0<SEP>0x2462<SEP>0x3082<SEP3>// HIRAGANA LETTER MO
0x82E1<SEP>0x2463<SEP>0x3083<SEP3>// HIRAGANA LETTER SMALL YA
0x82E2<SEP>0x2464<SEP>0x3084<SEP3>// HIRAGANA LETTER YA
0x82E3<SEP>0x2465<SEP>0x3085<SEP3>// HIRAGANA LETTER SMALL YU
0x82E4<SEP>0x2466<SEP>0x3086<SEP3>// HIRAGANA LETTER YU
0x82E5<SEP>0x2467<SEP>0x3087<SEP3>// HIRAGANA LETTER SMALL YO
0x82E6<SEP>0x2468<SEP>0x3088<SEP3>// HIRAGANA LETTER YO
0x82E7<SEP>0x2469<SEP>0x3089<SEP3>// HIRAGANA LETTER RA
0x82E8<SEP>0x246A<SEP>0x308A<SEP3>// HIRAGANA LETTER RI
0x82E9<SEP>0x246B<SEP>0x308B<SEP3>// HIRAGANA LETTER RU
0x82EA<SEP>0x246C<SEP>0x308C<SEP3>// HIRAGANA LETTER RE
0x82EB<SEP>0x246D<SEP>0x308D<SEP3>// HIRAGANA LETTER RO
0x82EC<SEP>0x246E<SEP>0x308E<SEP3>// HIRAGANA LETTER SMALL WA
0x82ED<SEP>0x246F<SEP>0x308F<SEP3>// HIRAGANA LETTER WA
0x82EE<SEP>0x2470<SEP>0x3090<SEP3>// HIRAGANA LETTER WI
0x82EF<SEP>0x2471<SEP>0x3091<SEP3>// HIRAGANA LETTER WE
0x82F0<SEP>0x2472<SEP>0x3092<SEP3>// HIRAGANA LETTER WO
0x82F1<SEP>0x2473<SEP>0x3093<SEP3>// HIRAGANA LETTER N
0x8340<SEP>0x2521<SEP>0x30A1<SEP3>// KATAKANA LETTER SMALL A
0x8341<SEP>0x2522<SEP>0x30A2<SEP3>// KATAKANA LETTER A
0x8342<SEP>0x2523<SEP>0x30A3<SEP3>// KATAKANA LETTER SMALL I
0x8343<SEP>0x2524<SEP>0x30A4<SEP3>// KATAKANA LETTER I
0x8344<SEP>0x2525<SEP>0x30A5<SEP3>// KATAKANA LETTER SMALL U
0x8345<SEP>0x2526<SEP>0x30A6<SEP3>// KATAKANA LETTER U
0x8346<SEP>0x2527<SEP>0x30A7<SEP3>// KATAKANA LETTER SMALL E
0x8347<SEP>0x2528<SEP>0x30A8<SEP3>// KATAKANA LETTER E
0x8348<SEP>0x2529<SEP>0x30A9<SEP3>// KATAKANA LETTER SMALL O
0x8349<SEP>0x252A<SEP>0x30AA<SEP3>// KATAKANA LETTER O
0x834A<SEP>0x252B<SEP>0x30AB<SEP3>// KATAKANA LETTER KA
0x834B<SEP>0x252C<SEP>0x30AC<SEP3>// KATAKANA LETTER GA
0x834C<SEP>0x252D<SEP>0x30AD<SEP3>// KATAKANA LETTER KI
0x834D<SEP>0x252E<SEP>0x30AE<SEP3>// KATAKANA LETTER GI
0x834E<SEP>0x252F<SEP>0x30AF<SEP3>// KATAKANA LETTER KU
0x834F<SEP>0x2530<SEP>0x30B0<SEP3>// KATAKANA LETTER GU
0x8350<SEP>0x2531<SEP>0x30B1<SEP3>// KATAKANA LETTER KE
0x8351<SEP>0x2532<SEP>0x30B2<SEP3>// KATAKANA LETTER GE
0x8352<SEP>0x2533<SEP>0x30B3<SEP3>// KATAKANA LETTER KO
0x8353<SEP>0x2534<SEP>0x30B4<SEP3>// KATAKANA LETTER GO
0x8354<SEP>0x2535<SEP>0x30B5<SEP3>// KATAKANA LETTER SA
0x8355<SEP>0x2536<SEP>0x30B6<SEP3>// KATAKANA LETTER ZA
0x8356<SEP>0x2537<SEP>0x30B7<SEP3>// KATAKANA LETTER SI
0x8357<SEP>0x2538<SEP>0x30B8<SEP3>// KATAKANA LETTER ZI
0x8358<SEP>0x2539<SEP>0x30B9<SEP3>// KATAKANA LETTER SU
0x8359<SEP>0x253A<SEP>0x30BA<SEP3>// KATAKANA LETTER ZU
0x835A<SEP>0x253B<SEP>0x30BB<SEP3>// KATAKANA LETTER SE
0x835B<SEP>0x253C<SEP>0x30BC<SEP3>// KATAKANA LETTER ZE
0x835C<SEP>0x253D<SEP>0x30BD<SEP3>// KATAKANA LETTER SO
0x835D<SEP>0x253E<SEP>0x30BE<SEP3>// KATAKANA LETTER ZO
0x835E<SEP>0x253F<SEP>0x30BF<SEP3>// KATAKANA LETTER TA
0x835F<SEP>0x2540<SEP>0x30C0<SEP3>// KATAKANA LETTER DA
0x8360<SEP>0x2541<SEP>0x30C1<SEP3>// KATAKANA LETTER TI
0x8361<SEP>0x2542<SEP>0x30C2<SEP3>// KATAKANA LETTER DI
0x8362<SEP>0x2543<SEP>0x30C3<SEP3>// KATAKANA LETTER SMALL TU
0x8363<SEP>0x2544<SEP>0x30C4<SEP3>// KATAKANA LETTER TU
0x8364<SEP>0x2545<SEP>0x30C5<SEP3>// KATAKANA LETTER DU
0x8365<SEP>0x2546<SEP>0x30C6<SEP3>// KATAKANA LETTER TE
0x8366<SEP>0x2547<SEP>0x30C7<SEP3>// KATAKANA LETTER DE
0x8367<SEP>0x2548<SEP>0x30C8<SEP3>// KATAKANA LETTER TO
0x8368<SEP>0x2549<SEP>0x30C9<SEP3>// KATAKANA LETTER DO
0x8369<SEP>0x254A<SEP>0x30CA<SEP3>// KATAKANA LETTER NA
0x836A<SEP>0x254B<SEP>0x30CB<SEP3>// KATAKANA LETTER NI
0x836B<SEP>0x254C<SEP>0x30CC<SEP3>// KATAKANA LETTER NU
0x836C<SEP>0x254D<SEP>0x30CD<SEP3>// KATAKANA LETTER NE
0x836D<SEP>0x254E<SEP>0x30CE<SEP3>// KATAKANA LETTER NO
0x836E<SEP>0x254F<SEP>0x30CF<SEP3>// KATAKANA LETTER HA
0x836F<SEP>0x2550<SEP>0x30D0<SEP3>// KATAKANA LETTER BA
0x8370<SEP>0x2551<SEP>0x30D1<SEP3>// KATAKANA LETTER PA
0x8371<SEP>0x2552<SEP>0x30D2<SEP3>// KATAKANA LETTER HI
0x8372<SEP>0x2553<SEP>0x30D3<SEP3>// KATAKANA LETTER BI
0x8373<SEP>0x2554<SEP>0x30D4<SEP3>// KATAKANA LETTER PI
0x8374<SEP>0x2555<SEP>0x30D5<SEP3>// KATAKANA LETTER HU
0x8375<SEP>0x2556<SEP>0x30D6<SEP3>// KATAKANA LETTER BU
0x8376<SEP>0x2557<SEP>0x30D7<SEP3>// KATAKANA LETTER PU
0x8377<SEP>0x2558<SEP>0x30D8<SEP3>// KATAKANA LETTER HE
0x8378<SEP>0x2559<SEP>0x30D9<SEP3>// KATAKANA LETTER BE
0x8379<SEP>0x255A<SEP>0x30DA<SEP3>// KATAKANA LETTER PE
0x837A<SEP>0x255B<SEP>0x30DB<SEP3>// KATAKANA LETTER HO
0x837B<SEP>0x255C<SEP>0x30DC<SEP3>// KATAKANA LETTER BO
0x837C<SEP>0x255D<SEP>0x30DD<SEP3>// KATAKANA LETTER PO
0x837D<SEP>0x255E<SEP>0x30DE<SEP3>// KATAKANA LETTER MA
0x837E<SEP>0x255F<SEP>0x30DF<SEP3>// KATAKANA LETTER MI
0x8380<SEP>0x2560<SEP>0x30E0<SEP3>// KATAKANA LETTER MU
0x8381<SEP>0x2561<SEP>0x30E1<SEP3>// KATAKANA LETTER ME
0x8382<SEP>0x2562<SEP>0x30E2<SEP3>// KATAKANA LETTER MO
0x8383<SEP>0x2563<SEP>0x30E3<SEP3>// KATAKANA LETTER SMALL YA
0x8384<SEP>0x2564<SEP>0x30E4<SEP3>// KATAKANA LETTER YA
0x8385<SEP>0x2565<SEP>0x30E5<SEP3>// KATAKANA LETTER SMALL YU
0x8386<SEP>0x2566<SEP>0x30E6<SEP3>// KATAKANA LETTER YU
0x8387<SEP>0x2567<SEP>0x30E7<SEP3>// KATAKANA LETTER SMALL YO
0x8388<SEP>0x2568<SEP>0x30E8<SEP3>// KATAKANA LETTER YO
0x8389<SEP>0x2569<SEP>0x30E9<SEP3>// KATAKANA LETTER RA
0x838A<SEP>0x256A<SEP>0x30EA<SEP3>// KATAKANA LETTER RI
0x838B<SEP>0x256B<SEP>0x30EB<SEP3>// KATAKANA LETTER RU
0x838C<SEP>0x256C<SEP>0x30EC<SEP3>// KATAKANA LETTER RE
0x838D<SEP>0x256D<SEP>0x30ED<SEP3>// KATAKANA LETTER RO
0x838E<SEP>0x256E<SEP>0x30EE<SEP3>// KATAKANA LETTER SMALL WA
0x838F<SEP>0x256F<SEP>0x30EF<SEP3>// KATAKANA LETTER WA
0x8390<SEP>0x2570<SEP>0x30F0<SEP3>// KATAKANA LETTER WI
0x8391<SEP>0x2571<SEP>0x30F1<SEP3>// KATAKANA LETTER WE
0x8392<SEP>0x2572<SEP>0x30F2<SEP3>// KATAKANA LETTER WO
0x8393<SEP>0x2573<SEP>0x30F3<SEP3>// KATAKANA LETTER N
0x8394<SEP>0x2574<SEP>0x30F4<SEP3>// KATAKANA LETTER VU
0x8395<SEP>0x2575<SEP>0x30F5<SEP3>// KATAKANA LETTER SMALL KA
0x8396<SEP>0x2576<SEP>0x30F6<SEP3>// KATAKANA LETTER SMALL KE
0x839F<SEP>0x2621<SEP>0x0391<SEP3>// GREEK CAPITAL LETTER ALPHA
0x83A0<SEP>0x2622<SEP>0x0392<SEP3>// GREEK CAPITAL LETTER BETA
0x83A1<SEP>0x2623<SEP>0x0393<SEP3>// GREEK CAPITAL LETTER GAMMA
0x83A2<SEP>0x2624<SEP>0x0394<SEP3>// GREEK CAPITAL LETTER DELTA
0x83A3<SEP>0x2625<SEP>0x0395<SEP3>// GREEK CAPITAL LETTER EPSILON
0x83A4<SEP>0x2626<SEP>0x0396<SEP3>// GREEK CAPITAL LETTER ZETA
0x83A5<SEP>0x2627<SEP>0x0397<SEP3>// GREEK CAPITAL LETTER ETA
0x83A6<SEP>0x2628<SEP>0x0398<SEP3>// GREEK CAPITAL LETTER THETA
0x83A7<SEP>0x2629<SEP>0x0399<SEP3>// GREEK CAPITAL LETTER IOTA
0x83A8<SEP>0x262A<SEP>0x039A<SEP3>// GREEK CAPITAL LETTER KAPPA
0x83A9<SEP>0x262B<SEP>0x039B<SEP3>// GREEK CAPITAL LETTER LAMDA
0x83AA<SEP>0x262C<SEP>0x039C<SEP3>// GREEK CAPITAL LETTER MU
0x83AB<SEP>0x262D<SEP>0x039D<SEP3>// GREEK CAPITAL LETTER NU
0x83AC<SEP>0x262E<SEP>0x039E<SEP3>// GREEK CAPITAL LETTER XI
0x83AD<SEP>0x262F<SEP>0x039F<SEP3>// GREEK CAPITAL LETTER OMICRON
0x83AE<SEP>0x2630<SEP>0x03A0<SEP3>// GREEK CAPITAL LETTER PI
0x83AF<SEP>0x2631<SEP>0x03A1<SEP3>// GREEK CAPITAL LETTER RHO
0x83B0<SEP>0x2632<SEP>0x03A3<SEP3>// GREEK CAPITAL LETTER SIGMA
0x83B1<SEP>0x2633<SEP>0x03A4<SEP3>// GREEK CAPITAL LETTER TAU
0x83B2<SEP>0x2634<SEP>0x03A5<SEP3>// GREEK CAPITAL LETTER UPSILON
0x83B3<SEP>0x2635<SEP>0x03A6<SEP3>// GREEK CAPITAL LETTER PHI
0x83B4<SEP>0x2636<SEP>0x03A7<SEP3>// GREEK CAPITAL LETTER CHI
0x83B5<SEP>0x2637<SEP>0x03A8<SEP3>// GREEK CAPITAL LETTER PSI
0x83B6<SEP>0x2638<SEP>0x03A9<SEP3>// GREEK CAPITAL LETTER OMEGA
0x83BF<SEP>0x2641<SEP>0x03B1<SEP3>// GREEK SMALL LETTER ALPHA
0x83C0<SEP>0x2642<SEP>0x03B2<SEP3>// GREEK SMALL LETTER BETA
0x83C1<SEP>0x2643<SEP>0x03B3<SEP3>// GREEK SMALL LETTER GAMMA
0x83C2<SEP>0x2644<SEP>0x03B4<SEP3>// GREEK SMALL LETTER DELTA
0x83C3<SEP>0x2645<SEP>0x03B5<SEP3>// GREEK SMALL LETTER EPSILON
0x83C4<SEP>0x2646<SEP>0x03B6<SEP3>// GREEK SMALL LETTER ZETA
0x83C5<SEP>0x2647<SEP>0x03B7<SEP3>// GREEK SMALL LETTER ETA
0x83C6<SEP>0x2648<SEP>0x03B8<SEP3>// GREEK SMALL LETTER THETA
0x83C7<SEP>0x2649<SEP>0x03B9<SEP3>// GREEK SMALL LETTER IOTA
0x83C8<SEP>0x264A<SEP>0x03BA<SEP3>// GREEK SMALL LETTER KAPPA
0x83C9<SEP>0x264B<SEP>0x03BB<SEP3>// GREEK SMALL LETTER LAMDA
0x83CA<SEP>0x264C<SEP>0x03BC<SEP3>// GREEK SMALL LETTER MU
0x83CB<SEP>0x264D<SEP>0x03BD<SEP3>// GREEK SMALL LETTER NU
0x83CC<SEP>0x264E<SEP>0x03BE<SEP3>// GREEK SMALL LETTER XI
0x83CD<SEP>0x264F<SEP>0x03BF<SEP3>// GREEK SMALL LETTER OMICRON
0x83CE<SEP>0x2650<SEP>0x03C0<SEP3>// GREEK SMALL LETTER PI
0x83CF<SEP>0x2651<SEP>0x03C1<SEP3>// GREEK SMALL LETTER RHO
0x83D0<SEP>0x2652<SEP>0x03C3<SEP3>// GREEK SMALL LETTER SIGMA
0x83D1<SEP>0x2653<SEP>0x03C4<SEP3>// GREEK SMALL LETTER TAU
0x83D2<SEP>0x2654<SEP>0x03C5<SEP3>// GREEK SMALL LETTER UPSILON
0x83D3<SEP>0x2655<SEP>0x03C6<SEP3>// GREEK SMALL LETTER PHI
0x83D4<SEP>0x2656<SEP>0x03C7<SEP3>// GREEK SMALL LETTER CHI
0x83D5<SEP>0x2657<SEP>0x03C8<SEP3>// GREEK SMALL LETTER PSI
0x83D6<SEP>0x2658<SEP>0x03C9<SEP3>// GREEK SMALL LETTER OMEGA
0x8440<SEP>0x2721<SEP>0x0410<SEP3>// CYRILLIC CAPITAL LETTER A
0x8441<SEP>0x2722<SEP>0x0411<SEP3>// CYRILLIC CAPITAL LETTER BE
0x8442<SEP>0x2723<SEP>0x0412<SEP3>// CYRILLIC CAPITAL LETTER VE
0x8443<SEP>0x2724<SEP>0x0413<SEP3>// CYRILLIC CAPITAL LETTER GHE
0x8444<SEP>0x2725<SEP>0x0414<SEP3>// CYRILLIC CAPITAL LETTER DE
0x8445<SEP>0x2726<SEP>0x0415<SEP3>// CYRILLIC CAPITAL LETTER IE
0x8446<SEP>0x2727<SEP>0x0401<SEP3>// CYRILLIC CAPITAL LETTER IO
0x8447<SEP>0x2728<SEP>0x0416<SEP3>// CYRILLIC CAPITAL LETTER ZHE
0x8448<SEP>0x2729<SEP>0x0417<SEP3>// CYRILLIC CAPITAL LETTER ZE
0x8449<SEP>0x272A<SEP>0x0418<SEP3>// CYRILLIC CAPITAL LETTER I
0x844A<SEP>0x272B<SEP>0x0419<SEP3>// CYRILLIC CAPITAL LETTER SHORT I
0x844B<SEP>0x272C<SEP>0x041A<SEP3>// CYRILLIC CAPITAL LETTER KA
0x844C<SEP>0x272D<SEP>0x041B<SEP3>// CYRILLIC CAPITAL LETTER EL
0x844D<SEP>0x272E<SEP>0x041C<SEP3>// CYRILLIC CAPITAL LETTER EM
0x844E<SEP>0x272F<SEP>0x041D<SEP3>// CYRILLIC CAPITAL LETTER EN
0x844F<SEP>0x2730<SEP>0x041E<SEP3>// CYRILLIC CAPITAL LETTER O
0x8450<SEP>0x2731<SEP>0x041F<SEP3>// CYRILLIC CAPITAL LETTER PE
0x8451<SEP>0x2732<SEP>0x0420<SEP3>// CYRILLIC CAPITAL LETTER ER
0x8452<SEP>0x2733<SEP>0x0421<SEP3>// CYRILLIC CAPITAL LETTER ES
0x8453<SEP>0x2734<SEP>0x0422<SEP3>// CYRILLIC CAPITAL LETTER TE
0x8454<SEP>0x2735<SEP>0x0423<SEP3>// CYRILLIC CAPITAL LETTER U
0x8455<SEP>0x2736<SEP>0x0424<SEP3>// CYRILLIC CAPITAL LETTER EF
0x8456<SEP>0x2737<SEP>0x0425<SEP3>// CYRILLIC CAPITAL LETTER HA
0x8457<SEP>0x2738<SEP>0x0426<SEP3>// CYRILLIC CAPITAL LETTER TSE
0x8458<SEP>0x2739<SEP>0x0427<SEP3>// CYRILLIC CAPITAL LETTER CHE
0x8459<SEP>0x273A<SEP>0x0428<SEP3>// CYRILLIC CAPITAL LETTER SHA
0x845A<SEP>0x273B<SEP>0x0429<SEP3>// CYRILLIC CAPITAL LETTER SHCHA
0x845B<SEP>0x273C<SEP>0x042A<SEP3>// CYRILLIC CAPITAL LETTER HARD SIGN
0x845C<SEP>0x273D<SEP>0x042B<SEP3>// CYRILLIC CAPITAL LETTER YERU
0x845D<SEP>0x273E<SEP>0x042C<SEP3>// CYRILLIC CAPITAL LETTER SOFT SIGN
0x845E<SEP>0x273F<SEP>0x042D<SEP3>// CYRILLIC CAPITAL LETTER E
0x845F<SEP>0x2740<SEP>0x042E<SEP3>// CYRILLIC CAPITAL LETTER YU
0x8460<SEP>0x2741<SEP>0x042F<SEP3>// CYRILLIC CAPITAL LETTER YA
0x8470<SEP>0x2751<SEP>0x0430<SEP3>// CYRILLIC SMALL LETTER A
0x8471<SEP>0x2752<SEP>0x0431<SEP3>// CYRILLIC SMALL LETTER BE
0x8472<SEP>0x2753<SEP>0x0432<SEP3>// CYRILLIC SMALL LETTER VE
0x8473<SEP>0x2754<SEP>0x0433<SEP3>// CYRILLIC SMALL LETTER GHE
0x8474<SEP>0x2755<SEP>0x0434<SEP3>// CYRILLIC SMALL LETTER DE
0x8475<SEP>0x2756<SEP>0x0435<SEP3>// CYRILLIC SMALL LETTER IE
0x8476<SEP>0x2757<SEP>0x0451<SEP3>// CYRILLIC SMALL LETTER IO
0x8477<SEP>0x2758<SEP>0x0436<SEP3>// CYRILLIC SMALL LETTER ZHE
0x8478<SEP>0x2759<SEP>0x0437<SEP3>// CYRILLIC SMALL LETTER ZE
0x8479<SEP>0x275A<SEP>0x0438<SEP3>// CYRILLIC SMALL LETTER I
0x847A<SEP>0x275B<SEP>0x0439<SEP3>// CYRILLIC SMALL LETTER SHORT I
0x847B<SEP>0x275C<SEP>0x043A<SEP3>// CYRILLIC SMALL LETTER KA
0x847C<SEP>0x275D<SEP>0x043B<SEP3>// CYRILLIC SMALL LETTER EL
0x847D<SEP>0x275E<SEP>0x043C<SEP3>// CYRILLIC SMALL LETTER EM
0x847E<SEP>0x275F<SEP>0x043D<SEP3>// CYRILLIC SMALL LETTER EN
0x8480<SEP>0x2760<SEP>0x043E<SEP3>// CYRILLIC SMALL LETTER O
0x8481<SEP>0x2761<SEP>0x043F<SEP3>// CYRILLIC SMALL LETTER PE
0x8482<SEP>0x2762<SEP>0x0440<SEP3>// CYRILLIC SMALL LETTER ER
0x8483<SEP>0x2763<SEP>0x0441<SEP3>// CYRILLIC SMALL LETTER ES
0x8484<SEP>0x2764<SEP>0x0442<SEP3>// CYRILLIC SMALL LETTER TE
0x8485<SEP>0x2765<SEP>0x0443<SEP3>// CYRILLIC SMALL LETTER U
0x8486<SEP>0x2766<SEP>0x0444<SEP3>// CYRILLIC SMALL LETTER EF
0x8487<SEP>0x2767<SEP>0x0445<SEP3>// CYRILLIC SMALL LETTER HA
0x8488<SEP>0x2768<SEP>0x0446<SEP3>// CYRILLIC SMALL LETTER TSE
0x8489<SEP>0x2769<SEP>0x0447<SEP3>// CYRILLIC SMALL LETTER CHE
0x848A<SEP>0x276A<SEP>0x0448<SEP3>// CYRILLIC SMALL LETTER SHA
0x848B<SEP>0x276B<SEP>0x0449<SEP3>// CYRILLIC SMALL LETTER SHCHA
0x848C<SEP>0x276C<SEP>0x044A<SEP3>// CYRILLIC SMALL LETTER HARD SIGN
0x848D<SEP>0x276D<SEP>0x044B<SEP3>// CYRILLIC SMALL LETTER YERU
0x848E<SEP>0x276E<SEP>0x044C<SEP3>// CYRILLIC SMALL LETTER SOFT SIGN
0x848F<SEP>0x276F<SEP>0x044D<SEP3>// CYRILLIC SMALL LETTER E
0x8490<SEP>0x2770<SEP>0x044E<SEP3>// CYRILLIC SMALL LETTER YU
0x8491<SEP>0x2771<SEP>0x044F<SEP3>// CYRILLIC SMALL LETTER YA
0x849F<SEP>0x2821<SEP>0x2500<SEP3>// BOX DRAWINGS LIGHT HORIZONTAL
0x84A0<SEP>0x2822<SEP>0x2502<SEP3>// BOX DRAWINGS LIGHT VERTICAL
0x84A1<SEP>0x2823<SEP>0x250C<SEP3>// BOX DRAWINGS LIGHT DOWN AND RIGHT
0x84A2<SEP>0x2824<SEP>0x2510<SEP3>// BOX DRAWINGS LIGHT DOWN AND LEFT
0x84A3<SEP>0x2825<SEP>0x2518<SEP3>// BOX DRAWINGS LIGHT UP AND LEFT
0x84A4<SEP>0x2826<SEP>0x2514<SEP3>// BOX DRAWINGS LIGHT UP AND RIGHT
0x84A5<SEP>0x2827<SEP>0x251C<SEP3>// BOX DRAWINGS LIGHT VERTICAL AND RIGHT
0x84A6<SEP>0x2828<SEP>0x252C<SEP3>// BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
0x84A7<SEP>0x2829<SEP>0x2524<SEP3>// BOX DRAWINGS LIGHT VERTICAL AND LEFT
0x84A8<SEP>0x282A<SEP>0x2534<SEP3>// BOX DRAWINGS LIGHT UP AND HORIZONTAL
0x84A9<SEP>0x282B<SEP>0x253C<SEP3>// BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
0x84AA<SEP>0x282C<SEP>0x2501<SEP3>// BOX DRAWINGS HEAVY HORIZONTAL
0x84AB<SEP>0x282D<SEP>0x2503<SEP3>// BOX DRAWINGS HEAVY VERTICAL
0x84AC<SEP>0x282E<SEP>0x250F<SEP3>// BOX DRAWINGS HEAVY DOWN AND RIGHT
0x84AD<SEP>0x282F<SEP>0x2513<SEP3>// BOX DRAWINGS HEAVY DOWN AND LEFT
0x84AE<SEP>0x2830<SEP>0x251B<SEP3>// BOX DRAWINGS HEAVY UP AND LEFT
0x84AF<SEP>0x2831<SEP>0x2517<SEP3>// BOX DRAWINGS HEAVY UP AND RIGHT
0x84B0<SEP>0x2832<SEP>0x2523<SEP3>// BOX DRAWINGS HEAVY VERTICAL AND RIGHT
0x84B1<SEP>0x2833<SEP>0x2533<SEP3>// BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
0x84B2<SEP>0x2834<SEP>0x252B<SEP3>// BOX DRAWINGS HEAVY VERTICAL AND LEFT
0x84B3<SEP>0x2835<SEP>0x253B<SEP3>// BOX DRAWINGS HEAVY UP AND HORIZONTAL
0x84B4<SEP>0x2836<SEP>0x254B<SEP3>// BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
0x84B5<SEP>0x2837<SEP>0x2520<SEP3>// BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
0x84B6<SEP>0x2838<SEP>0x252F<SEP3>// BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
0x84B7<SEP>0x2839<SEP>0x2528<SEP3>// BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
0x84B8<SEP>0x283A<SEP>0x2537<SEP3>// BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
0x84B9<SEP>0x283B<SEP>0x253F<SEP3>// BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
0x84BA<SEP>0x283C<SEP>0x251D<SEP3>// BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
0x84BB<SEP>0x283D<SEP>0x2530<SEP3>// BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
0x84BC<SEP>0x283E<SEP>0x2525<SEP3>// BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
0x84BD<SEP>0x283F<SEP>0x2538<SEP3>// BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
0x84BE<SEP>0x2840<SEP>0x2542<SEP3>// BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
0x889F<SEP>0x3021<SEP>0x4E9C<SEP3>// <CJK>
0x88A0<SEP>0x3022<SEP>0x5516<SEP3>// <CJK>
0x88A1<SEP>0x3023<SEP>0x5A03<SEP3>// <CJK>
0x88A2<SEP>0x3024<SEP>0x963F<SEP3>// <CJK>
0x88A3<SEP>0x3025<SEP>0x54C0<SEP3>// <CJK>
0x88A4<SEP>0x3026<SEP>0x611B<SEP3>// <CJK>
0x88A5<SEP>0x3027<SEP>0x6328<SEP3>// <CJK>
0x88A6<SEP>0x3028<SEP>0x59F6<SEP3>// <CJK>
0x88A7<SEP>0x3029<SEP>0x9022<SEP3>// <CJK>
0x88A8<SEP>0x302A<SEP>0x8475<SEP3>// <CJK>
0x88A9<SEP>0x302B<SEP>0x831C<SEP3>// <CJK>
0x88AA<SEP>0x302C<SEP>0x7A50<SEP3>// <CJK>
0x88AB<SEP>0x302D<SEP>0x60AA<SEP3>// <CJK>
0x88AC<SEP>0x302E<SEP>0x63E1<SEP3>// <CJK>
0x88AD<SEP>0x302F<SEP>0x6E25<SEP3>// <CJK>
0x88AE<SEP>0x3030<SEP>0x65ED<SEP3>// <CJK>
0x88AF<SEP>0x3031<SEP>0x8466<SEP3>// <CJK>
0x88B0<SEP>0x3032<SEP>0x82A6<SEP3>// <CJK>
0x88B1<SEP>0x3033<SEP>0x9BF5<SEP3>// <CJK>
0x88B2<SEP>0x3034<SEP>0x6893<SEP3>// <CJK>
0x88B3<SEP>0x3035<SEP>0x5727<SEP3>// <CJK>
0x88B4<SEP>0x3036<SEP>0x65A1<SEP3>// <CJK>
0x88B5<SEP>0x3037<SEP>0x6271<SEP3>// <CJK>
0x88B6<SEP>0x3038<SEP>0x5B9B<SEP3>// <CJK>
0x88B7<SEP>0x3039<SEP>0x59D0<SEP3>// <CJK>
0x88B8<SEP>0x303A<SEP>0x867B<SEP3>// <CJK>
0x88B9<SEP>0x303B<SEP>0x98F4<SEP3>// <CJK>
0x88BA<SEP>0x303C<SEP>0x7D62<SEP3>// <CJK>
0x88BB<SEP>0x303D<SEP>0x7DBE<SEP3>// <CJK>
0x88BC<SEP>0x303E<SEP>0x9B8E<SEP3>// <CJK>
0x88BD<SEP>0x303F<SEP>0x6216<SEP3>// <CJK>
0x88BE<SEP>0x3040<SEP>0x7C9F<SEP3>// <CJK>
0x88BF<SEP>0x3041<SEP>0x88B7<SEP3>// <CJK>
0x88C0<SEP>0x3042<SEP>0x5B89<SEP3>// <CJK>
0x88C1<SEP>0x3043<SEP>0x5EB5<SEP3>// <CJK>
0x88C2<SEP>0x3044<SEP>0x6309<SEP3>// <CJK>
0x88C3<SEP>0x3045<SEP>0x6697<SEP3>// <CJK>
0x88C4<SEP>0x3046<SEP>0x6848<SEP3>// <CJK>
0x88C5<SEP>0x3047<SEP>0x95C7<SEP3>// <CJK>
0x88C6<SEP>0x3048<SEP>0x978D<SEP3>// <CJK>
0x88C7<SEP>0x3049<SEP>0x674F<SEP3>// <CJK>
0x88C8<SEP>0x304A<SEP>0x4EE5<SEP3>// <CJK>
0x88C9<SEP>0x304B<SEP>0x4F0A<SEP3>// <CJK>
0x88CA<SEP>0x304C<SEP>0x4F4D<SEP3>// <CJK>
0x88CB<SEP>0x304D<SEP>0x4F9D<SEP3>// <CJK>
0x88CC<SEP>0x304E<SEP>0x5049<SEP3>// <CJK>
0x88CD<SEP>0x304F<SEP>0x56F2<SEP3>// <CJK>
0x88CE<SEP>0x3050<SEP>0x5937<SEP3>// <CJK>
0x88CF<SEP>0x3051<SEP>0x59D4<SEP3>// <CJK>
0x88D0<SEP>0x3052<SEP>0x5A01<SEP3>// <CJK>
0x88D1<SEP>0x3053<SEP>0x5C09<SEP3>// <CJK>
0x88D2<SEP>0x3054<SEP>0x60DF<SEP3>// <CJK>
0x88D3<SEP>0x3055<SEP>0x610F<SEP3>// <CJK>
0x88D4<SEP>0x3056<SEP>0x6170<SEP3>// <CJK>
0x88D5<SEP>0x3057<SEP>0x6613<SEP3>// <CJK>
0x88D6<SEP>0x3058<SEP>0x6905<SEP3>// <CJK>
0x88D7<SEP>0x3059<SEP>0x70BA<SEP3>// <CJK>
0x88D8<SEP>0x305A<SEP>0x754F<SEP3>// <CJK>
0x88D9<SEP>0x305B<SEP>0x7570<SEP3>// <CJK>
0x88DA<SEP>0x305C<SEP>0x79FB<SEP3>// <CJK>
0x88DB<SEP>0x305D<SEP>0x7DAD<SEP3>// <CJK>
0x88DC<SEP>0x305E<SEP>0x7DEF<SEP3>// <CJK>
0x88DD<SEP>0x305F<SEP>0x80C3<SEP3>// <CJK>
0x88DE<SEP>0x3060<SEP>0x840E<SEP3>// <CJK>
0x88DF<SEP>0x3061<SEP>0x8863<SEP3>// <CJK>
0x88E0<SEP>0x3062<SEP>0x8B02<SEP3>// <CJK>
0x88E1<SEP>0x3063<SEP>0x9055<SEP3>// <CJK>
0x88E2<SEP>0x3064<SEP>0x907A<SEP3>// <CJK>
0x88E3<SEP>0x3065<SEP>0x533B<SEP3>// <CJK>
0x88E4<SEP>0x3066<SEP>0x4E95<SEP3>// <CJK>
0x88E5<SEP>0x3067<SEP>0x4EA5<SEP3>// <CJK>
0x88E6<SEP>0x3068<SEP>0x57DF<SEP3>// <CJK>
0x88E7<SEP>0x3069<SEP>0x80B2<SEP3>// <CJK>
0x88E8<SEP>0x306A<SEP>0x90C1<SEP3>// <CJK>
0x88E9<SEP>0x306B<SEP>0x78EF<SEP3>// <CJK>
0x88EA<SEP>0x306C<SEP>0x4E00<SEP3>// <CJK>
0x88EB<SEP>0x306D<SEP>0x58F1<SEP3>// <CJK>
0x88EC<SEP>0x306E<SEP>0x6EA2<SEP3>// <CJK>
0x88ED<SEP>0x306F<SEP>0x9038<SEP3>// <CJK>
0x88EE<SEP>0x3070<SEP>0x7A32<SEP3>// <CJK>
0x88EF<SEP>0x3071<SEP>0x8328<SEP3>// <CJK>
0x88F0<SEP>0x3072<SEP>0x828B<SEP3>// <CJK>
0x88F1<SEP>0x3073<SEP>0x9C2F<SEP3>// <CJK>
0x88F2<SEP>0x3074<SEP>0x5141<SEP3>// <CJK>
0x88F3<SEP>0x3075<SEP>0x5370<SEP3>// <CJK>
0x88F4<SEP>0x3076<SEP>0x54BD<SEP3>// <CJK>
0x88F5<SEP>0x3077<SEP>0x54E1<SEP3>// <CJK>
0x88F6<SEP>0x3078<SEP>0x56E0<SEP3>// <CJK>
0x88F7<SEP>0x3079<SEP>0x59FB<SEP3>// <CJK>
0x88F8<SEP>0x307A<SEP>0x5F15<SEP3>// <CJK>
0x88F9<SEP>0x307B<SEP>0x98F2<SEP3>// <CJK>
0x88FA<SEP>0x307C<SEP>0x6DEB<SEP3>// <CJK>
0x88FB<SEP>0x307D<SEP>0x80E4<SEP3>// <CJK>
0x88FC<SEP>0x307E<SEP>0x852D<SEP3>// <CJK>
0x8940<SEP>0x3121<SEP>0x9662<SEP3>// <CJK>
0x8941<SEP>0x3122<SEP>0x9670<SEP3>// <CJK>
0x8942<SEP>0x3123<SEP>0x96A0<SEP3>// <CJK>
0x8943<SEP>0x3124<SEP>0x97FB<SEP3>// <CJK>
0x8944<SEP>0x3125<SEP>0x540B<SEP3>// <CJK>
0x8945<SEP>0x3126<SEP>0x53F3<SEP3>// <CJK>
0x8946<SEP>0x3127<SEP>0x5B87<SEP3>// <CJK>
0x8947<SEP>0x3128<SEP>0x70CF<SEP3>// <CJK>
0x8948<SEP>0x3129<SEP>0x7FBD<SEP3>// <CJK>
0x8949<SEP>0x312A<SEP>0x8FC2<SEP3>// <CJK>
0x894A<SEP>0x312B<SEP>0x96E8<SEP3>// <CJK>
0x894B<SEP>0x312C<SEP>0x536F<SEP3>// <CJK>
0x894C<SEP>0x312D<SEP>0x9D5C<SEP3>// <CJK>
0x894D<SEP>0x312E<SEP>0x7ABA<SEP3>// <CJK>
0x894E<SEP>0x312F<SEP>0x4E11<SEP3>// <CJK>
0x894F<SEP>0x3130<SEP>0x7893<SEP3>// <CJK>
0x8950<SEP>0x3131<SEP>0x81FC<SEP3>// <CJK>
0x8951<SEP>0x3132<SEP>0x6E26<SEP3>// <CJK>
0x8952<SEP>0x3133<SEP>0x5618<SEP3>// <CJK>
0x8953<SEP>0x3134<SEP>0x5504<SEP3>// <CJK>
0x8954<SEP>0x3135<SEP>0x6B1D<SEP3>// <CJK>
0x8955<SEP>0x3136<SEP>0x851A<SEP3>// <CJK>
0x8956<SEP>0x3137<SEP>0x9C3B<SEP3>// <CJK>
0x8957<SEP>0x3138<SEP>0x59E5<SEP3>// <CJK>
0x8958<SEP>0x3139<SEP>0x53A9<SEP3>// <CJK>
0x8959<SEP>0x313A<SEP>0x6D66<SEP3>// <CJK>
0x895A<SEP>0x313B<SEP>0x74DC<SEP3>// <CJK>
0x895B<SEP>0x313C<SEP>0x958F<SEP3>// <CJK>
0x895C<SEP>0x313D<SEP>0x5642<SEP3>// <CJK>
0x895D<SEP>0x313E<SEP>0x4E91<SEP3>// <CJK>
0x895E<SEP>0x313F<SEP>0x904B<SEP3>// <CJK>
0x895F<SEP>0x3140<SEP>0x96F2<SEP3>// <CJK>
0x8960<SEP>0x3141<SEP>0x834F<SEP3>// <CJK>
0x8961<SEP>0x3142<SEP>0x990C<SEP3>// <CJK>
0x8962<SEP>0x3143<SEP>0x53E1<SEP3>// <CJK>
0x8963<SEP>0x3144<SEP>0x55B6<SEP3>// <CJK>
0x8964<SEP>0x3145<SEP>0x5B30<SEP3>// <CJK>
0x8965<SEP>0x3146<SEP>0x5F71<SEP3>// <CJK>
0x8966<SEP>0x3147<SEP>0x6620<SEP3>// <CJK>
0x8967<SEP>0x3148<SEP>0x66F3<SEP3>// <CJK>
0x8968<SEP>0x3149<SEP>0x6804<SEP3>// <CJK>
0x8969<SEP>0x314A<SEP>0x6C38<SEP3>// <CJK>
0x896A<SEP>0x314B<SEP>0x6CF3<SEP3>// <CJK>
0x896B<SEP>0x314C<SEP>0x6D29<SEP3>// <CJK>
0x896C<SEP>0x314D<SEP>0x745B<SEP3>// <CJK>
0x896D<SEP>0x314E<SEP>0x76C8<SEP3>// <CJK>
0x896E<SEP>0x314F<SEP>0x7A4E<SEP3>// <CJK>
0x896F<SEP>0x3150<SEP>0x9834<SEP3>// <CJK>
0x8970<SEP>0x3151<SEP>0x82F1<SEP3>// <CJK>
0x8971<SEP>0x3152<SEP>0x885B<SEP3>// <CJK>
0x8972<SEP>0x3153<SEP>0x8A60<SEP3>// <CJK>
0x8973<SEP>0x3154<SEP>0x92ED<SEP3>// <CJK>
0x8974<SEP>0x3155<SEP>0x6DB2<SEP3>// <CJK>
0x8975<SEP>0x3156<SEP>0x75AB<SEP3>// <CJK>
0x8976<SEP>0x3157<SEP>0x76CA<SEP3>// <CJK>
0x8977<SEP>0x3158<SEP>0x99C5<SEP3>// <CJK>
0x8978<SEP>0x3159<SEP>0x60A6<SEP3>// <CJK>
0x8979<SEP>0x315A<SEP>0x8B01<SEP3>// <CJK>
0x897A<SEP>0x315B<SEP>0x8D8A<SEP3>// <CJK>
0x897B<SEP>0x315C<SEP>0x95B2<SEP3>// <CJK>
0x897C<SEP>0x315D<SEP>0x698E<SEP3>// <CJK>
0x897D<SEP>0x315E<SEP>0x53AD<SEP3>// <CJK>
0x897E<SEP>0x315F<SEP>0x5186<SEP3>// <CJK>
0x8980<SEP>0x3160<SEP>0x5712<SEP3>// <CJK>
0x8981<SEP>0x3161<SEP>0x5830<SEP3>// <CJK>
0x8982<SEP>0x3162<SEP>0x5944<SEP3>// <CJK>
0x8983<SEP>0x3163<SEP>0x5BB4<SEP3>// <CJK>
0x8984<SEP>0x3164<SEP>0x5EF6<SEP3>// <CJK>
0x8985<SEP>0x3165<SEP>0x6028<SEP3>// <CJK>
0x8986<SEP>0x3166<SEP>0x63A9<SEP3>// <CJK>
0x8987<SEP>0x3167<SEP>0x63F4<SEP3>// <CJK>
0x8988<SEP>0x3168<SEP>0x6CBF<SEP3>// <CJK>
0x8989<SEP>0x3169<SEP>0x6F14<SEP3>// <CJK>
0x898A<SEP>0x316A<SEP>0x708E<SEP3>// <CJK>
0x898B<SEP>0x316B<SEP>0x7114<SEP3>// <CJK>
0x898C<SEP>0x316C<SEP>0x7159<SEP3>// <CJK>
0x898D<SEP>0x316D<SEP>0x71D5<SEP3>// <CJK>
0x898E<SEP>0x316E<SEP>0x733F<SEP3>// <CJK>
0x898F<SEP>0x316F<SEP>0x7E01<SEP3>// <CJK>
0x8990<SEP>0x3170<SEP>0x8276<SEP3>// <CJK>
0x8991<SEP>0x3171<SEP>0x82D1<SEP3>// <CJK>
0x8992<SEP>0x3172<SEP>0x8597<SEP3>// <CJK>
0x8993<SEP>0x3173<SEP>0x9060<SEP3>// <CJK>
0x8994<SEP>0x3174<SEP>0x925B<SEP3>// <CJK>
0x8995<SEP>0x3175<SEP>0x9D1B<SEP3>// <CJK>
0x8996<SEP>0x3176<SEP>0x5869<SEP3>// <CJK>
0x8997<SEP>0x3177<SEP>0x65BC<SEP3>// <CJK>
0x8998<SEP>0x3178<SEP>0x6C5A<SEP3>// <CJK>
0x8999<SEP>0x3179<SEP>0x7525<SEP3>// <CJK>
0x899A<SEP>0x317A<SEP>0x51F9<SEP3>// <CJK>
0x899B<SEP>0x317B<SEP>0x592E<SEP3>// <CJK>
0x899C<SEP>0x317C<SEP>0x5965<SEP3>// <CJK>
0x899D<SEP>0x317D<SEP>0x5F80<SEP3>// <CJK>
0x899E<SEP>0x317E<SEP>0x5FDC<SEP3>// <CJK>
0x899F<SEP>0x3221<SEP>0x62BC<SEP3>// <CJK>
0x89A0<SEP>0x3222<SEP>0x65FA<SEP3>// <CJK>
0x89A1<SEP>0x3223<SEP>0x6A2A<SEP3>// <CJK>
0x89A2<SEP>0x3224<SEP>0x6B27<SEP3>// <CJK>
0x89A3<SEP>0x3225<SEP>0x6BB4<SEP3>// <CJK>
0x89A4<SEP>0x3226<SEP>0x738B<SEP3>// <CJK>
0x89A5<SEP>0x3227<SEP>0x7FC1<SEP3>// <CJK>
0x89A6<SEP>0x3228<SEP>0x8956<SEP3>// <CJK>
0x89A7<SEP>0x3229<SEP>0x9D2C<SEP3>// <CJK>
0x89A8<SEP>0x322A<SEP>0x9D0E<SEP3>// <CJK>
0x89A9<SEP>0x322B<SEP>0x9EC4<SEP3>// <CJK>
0x89AA<SEP>0x322C<SEP>0x5CA1<SEP3>// <CJK>
0x89AB<SEP>0x322D<SEP>0x6C96<SEP3>// <CJK>
0x89AC<SEP>0x322E<SEP>0x837B<SEP3>// <CJK>
0x89AD<SEP>0x322F<SEP>0x5104<SEP3>// <CJK>
0x89AE<SEP>0x3230<SEP>0x5C4B<SEP3>// <CJK>
0x89AF<SEP>0x3231<SEP>0x61B6<SEP3>// <CJK>
0x89B0<SEP>0x3232<SEP>0x81C6<SEP3>// <CJK>
0x89B1<SEP>0x3233<SEP>0x6876<SEP3>// <CJK>
0x89B2<SEP>0x3234<SEP>0x7261<SEP3>// <CJK>
0x89B3<SEP>0x3235<SEP>0x4E59<SEP3>// <CJK>
0x89B4<SEP>0x3236<SEP>0x4FFA<SEP3>// <CJK>
0x89B5<SEP>0x3237<SEP>0x5378<SEP3>// <CJK>
0x89B6<SEP>0x3238<SEP>0x6069<SEP3>// <CJK>
0x89B7<SEP>0x3239<SEP>0x6E29<SEP3>// <CJK>
0x89B8<SEP>0x323A<SEP>0x7A4F<SEP3>// <CJK>
0x89B9<SEP>0x323B<SEP>0x97F3<SEP3>// <CJK>
0x89BA<SEP>0x323C<SEP>0x4E0B<SEP3>// <CJK>
0x89BB<SEP>0x323D<SEP>0x5316<SEP3>// <CJK>
0x89BC<SEP>0x323E<SEP>0x4EEE<SEP3>// <CJK>
0x89BD<SEP>0x323F<SEP>0x4F55<SEP3>// <CJK>
0x89BE<SEP>0x3240<SEP>0x4F3D<SEP3>// <CJK>
0x89BF<SEP>0x3241<SEP>0x4FA1<SEP3>// <CJK>
0x89C0<SEP>0x3242<SEP>0x4F73<SEP3>// <CJK>
0x89C1<SEP>0x3243<SEP>0x52A0<SEP3>// <CJK>
0x89C2<SEP>0x3244<SEP>0x53EF<SEP3>// <CJK>
0x89C3<SEP>0x3245<SEP>0x5609<SEP3>// <CJK>
0x89C4<SEP>0x3246<SEP>0x590F<SEP3>// <CJK>
0x89C5<SEP>0x3247<SEP>0x5AC1<SEP3>// <CJK>
0x89C6<SEP>0x3248<SEP>0x5BB6<SEP3>// <CJK>
0x89C7<SEP>0x3249<SEP>0x5BE1<SEP3>// <CJK>
0x89C8<SEP>0x324A<SEP>0x79D1<SEP3>// <CJK>
0x89C9<SEP>0x324B<SEP>0x6687<SEP3>// <CJK>
0x89CA<SEP>0x324C<SEP>0x679C<SEP3>// <CJK>
0x89CB<SEP>0x324D<SEP>0x67B6<SEP3>// <CJK>
0x89CC<SEP>0x324E<SEP>0x6B4C<SEP3>// <CJK>
0x89CD<SEP>0x324F<SEP>0x6CB3<SEP3>// <CJK>
0x89CE<SEP>0x3250<SEP>0x706B<SEP3>// <CJK>
0x89CF<SEP>0x3251<SEP>0x73C2<SEP3>// <CJK>
0x89D0<SEP>0x3252<SEP>0x798D<SEP3>// <CJK>
0x89D1<SEP>0x3253<SEP>0x79BE<SEP3>// <CJK>
0x89D2<SEP>0x3254<SEP>0x7A3C<SEP3>// <CJK>
0x89D3<SEP>0x3255<SEP>0x7B87<SEP3>// <CJK>
0x89D4<SEP>0x3256<SEP>0x82B1<SEP3>// <CJK>
0x89D5<SEP>0x3257<SEP>0x82DB<SEP3>// <CJK>
0x89D6<SEP>0x3258<SEP>0x8304<SEP3>// <CJK>
0x89D7<SEP>0x3259<SEP>0x8377<SEP3>// <CJK>
0x89D8<SEP>0x325A<SEP>0x83EF<SEP3>// <CJK>
0x89D9<SEP>0x325B<SEP>0x83D3<SEP3>// <CJK>
0x89DA<SEP>0x325C<SEP>0x8766<SEP3>// <CJK>
0x89DB<SEP>0x325D<SEP>0x8AB2<SEP3>// <CJK>
0x89DC<SEP>0x325E<SEP>0x5629<SEP3>// <CJK>
0x89DD<SEP>0x325F<SEP>0x8CA8<SEP3>// <CJK>
0x89DE<SEP>0x3260<SEP>0x8FE6<SEP3>// <CJK>
0x89DF<SEP>0x3261<SEP>0x904E<SEP3>// <CJK>
0x89E0<SEP>0x3262<SEP>0x971E<SEP3>// <CJK>
0x89E1<SEP>0x3263<SEP>0x868A<SEP3>// <CJK>
0x89E2<SEP>0x3264<SEP>0x4FC4<SEP3>// <CJK>
0x89E3<SEP>0x3265<SEP>0x5CE8<SEP3>// <CJK>
0x89E4<SEP>0x3266<SEP>0x6211<SEP3>// <CJK>
0x89E5<SEP>0x3267<SEP>0x7259<SEP3>// <CJK>
0x89E6<SEP>0x3268<SEP>0x753B<SEP3>// <CJK>
0x89E7<SEP>0x3269<SEP>0x81E5<SEP3>// <CJK>
0x89E8<SEP>0x326A<SEP>0x82BD<SEP3>// <CJK>
0x89E9<SEP>0x326B<SEP>0x86FE<SEP3>// <CJK>
0x89EA<SEP>0x326C<SEP>0x8CC0<SEP3>// <CJK>
0x89EB<SEP>0x326D<SEP>0x96C5<SEP3>// <CJK>
0x89EC<SEP>0x326E<SEP>0x9913<SEP3>// <CJK>
0x89ED<SEP>0x326F<SEP>0x99D5<SEP3>// <CJK>
0x89EE<SEP>0x3270<SEP>0x4ECB<SEP3>// <CJK>
0x89EF<SEP>0x3271<SEP>0x4F1A<SEP3>// <CJK>
0x89F0<SEP>0x3272<SEP>0x89E3<SEP3>// <CJK>
0x89F1<SEP>0x3273<SEP>0x56DE<SEP3>// <CJK>
0x89F2<SEP>0x3274<SEP>0x584A<SEP3>// <CJK>
0x89F3<SEP>0x3275<SEP>0x58CA<SEP3>// <CJK>
0x89F4<SEP>0x3276<SEP>0x5EFB<SEP3>// <CJK>
0x89F5<SEP>0x3277<SEP>0x5FEB<SEP3>// <CJK>
0x89F6<SEP>0x3278<SEP>0x602A<SEP3>// <CJK>
0x89F7<SEP>0x3279<SEP>0x6094<SEP3>// <CJK>
0x89F8<SEP>0x327A<SEP>0x6062<SEP3>// <CJK>
0x89F9<SEP>0x327B<SEP>0x61D0<SEP3>// <CJK>
0x89FA<SEP>0x327C<SEP>0x6212<SEP3>// <CJK>
0x89FB<SEP>0x327D<SEP>0x62D0<SEP3>// <CJK>
0x89FC<SEP>0x327E<SEP>0x6539<SEP3>// <CJK>
0x8A40<SEP>0x3321<SEP>0x9B41<SEP3>// <CJK>
0x8A41<SEP>0x3322<SEP>0x6666<SEP3>// <CJK>
0x8A42<SEP>0x3323<SEP>0x68B0<SEP3>// <CJK>
0x8A43<SEP>0x3324<SEP>0x6D77<SEP3>// <CJK>
0x8A44<SEP>0x3325<SEP>0x7070<SEP3>// <CJK>
0x8A45<SEP>0x3326<SEP>0x754C<SEP3>// <CJK>
0x8A46<SEP>0x3327<SEP>0x7686<SEP3>// <CJK>
0x8A47<SEP>0x3328<SEP>0x7D75<SEP3>// <CJK>
0x8A48<SEP>0x3329<SEP>0x82A5<SEP3>// <CJK>
0x8A49<SEP>0x332A<SEP>0x87F9<SEP3>// <CJK>
0x8A4A<SEP>0x332B<SEP>0x958B<SEP3>// <CJK>
0x8A4B<SEP>0x332C<SEP>0x968E<SEP3>// <CJK>
0x8A4C<SEP>0x332D<SEP>0x8C9D<SEP3>// <CJK>
0x8A4D<SEP>0x332E<SEP>0x51F1<SEP3>// <CJK>
0x8A4E<SEP>0x332F<SEP>0x52BE<SEP3>// <CJK>
0x8A4F<SEP>0x3330<SEP>0x5916<SEP3>// <CJK>
0x8A50<SEP>0x3331<SEP>0x54B3<SEP3>// <CJK>
0x8A51<SEP>0x3332<SEP>0x5BB3<SEP3>// <CJK>
0x8A52<SEP>0x3333<SEP>0x5D16<SEP3>// <CJK>
0x8A53<SEP>0x3334<SEP>0x6168<SEP3>// <CJK>
0x8A54<SEP>0x3335<SEP>0x6982<SEP3>// <CJK>
0x8A55<SEP>0x3336<SEP>0x6DAF<SEP3>// <CJK>
0x8A56<SEP>0x3337<SEP>0x788D<SEP3>// <CJK>
0x8A57<SEP>0x3338<SEP>0x84CB<SEP3>// <CJK>
0x8A58<SEP>0x3339<SEP>0x8857<SEP3>// <CJK>
0x8A59<SEP>0x333A<SEP>0x8A72<SEP3>// <CJK>
0x8A5A<SEP>0x333B<SEP>0x93A7<SEP3>// <CJK>
0x8A5B<SEP>0x333C<SEP>0x9AB8<SEP3>// <CJK>
0x8A5C<SEP>0x333D<SEP>0x6D6C<SEP3>// <CJK>
0x8A5D<SEP>0x333E<SEP>0x99A8<SEP3>// <CJK>
0x8A5E<SEP>0x333F<SEP>0x86D9<SEP3>// <CJK>
0x8A5F<SEP>0x3340<SEP>0x57A3<SEP3>// <CJK>
0x8A60<SEP>0x3341<SEP>0x67FF<SEP3>// <CJK>
0x8A61<SEP>0x3342<SEP>0x86CE<SEP3>// <CJK>
0x8A62<SEP>0x3343<SEP>0x920E<SEP3>// <CJK>
0x8A63<SEP>0x3344<SEP>0x5283<SEP3>// <CJK>
0x8A64<SEP>0x3345<SEP>0x5687<SEP3>// <CJK>
0x8A65<SEP>0x3346<SEP>0x5404<SEP3>// <CJK>
0x8A66<SEP>0x3347<SEP>0x5ED3<SEP3>// <CJK>
0x8A67<SEP>0x3348<SEP>0x62E1<SEP3>// <CJK>
0x8A68<SEP>0x3349<SEP>0x64B9<SEP3>// <CJK>
0x8A69<SEP>0x334A<SEP>0x683C<SEP3>// <CJK>
0x8A6A<SEP>0x334B<SEP>0x6838<SEP3>// <CJK>
0x8A6B<SEP>0x334C<SEP>0x6BBB<SEP3>// <CJK>
0x8A6C<SEP>0x334D<SEP>0x7372<SEP3>// <CJK>
0x8A6D<SEP>0x334E<SEP>0x78BA<SEP3>// <CJK>
0x8A6E<SEP>0x334F<SEP>0x7A6B<SEP3>// <CJK>
0x8A6F<SEP>0x3350<SEP>0x899A<SEP3>// <CJK>
0x8A70<SEP>0x3351<SEP>0x89D2<SEP3>// <CJK>
0x8A71<SEP>0x3352<SEP>0x8D6B<SEP3>// <CJK>
0x8A72<SEP>0x3353<SEP>0x8F03<SEP3>// <CJK>
0x8A73<SEP>0x3354<SEP>0x90ED<SEP3>// <CJK>
0x8A74<SEP>0x3355<SEP>0x95A3<SEP3>// <CJK>
0x8A75<SEP>0x3356<SEP>0x9694<SEP3>// <CJK>
0x8A76<SEP>0x3357<SEP>0x9769<SEP3>// <CJK>
0x8A77<SEP>0x3358<SEP>0x5B66<SEP3>// <CJK>
0x8A78<SEP>0x3359<SEP>0x5CB3<SEP3>// <CJK>
0x8A79<SEP>0x335A<SEP>0x697D<SEP3>// <CJK>
0x8A7A<SEP>0x335B<SEP>0x984D<SEP3>// <CJK>
0x8A7B<SEP>0x335C<SEP>0x984E<SEP3>// <CJK>
0x8A7C<SEP>0x335D<SEP>0x639B<SEP3>// <CJK>
0x8A7D<SEP>0x335E<SEP>0x7B20<SEP3>// <CJK>
0x8A7E<SEP>0x335F<SEP>0x6A2B<SEP3>// <CJK>
0x8A80<SEP>0x3360<SEP>0x6A7F<SEP3>// <CJK>
0x8A81<SEP>0x3361<SEP>0x68B6<SEP3>// <CJK>
0x8A82<SEP>0x3362<SEP>0x9C0D<SEP3>// <CJK>
0x8A83<SEP>0x3363<SEP>0x6F5F<SEP3>// <CJK>
0x8A84<SEP>0x3364<SEP>0x5272<SEP3>// <CJK>
0x8A85<SEP>0x3365<SEP>0x559D<SEP3>// <CJK>
0x8A86<SEP>0x3366<SEP>0x6070<SEP3>// <CJK>
0x8A87<SEP>0x3367<SEP>0x62EC<SEP3>// <CJK>
0x8A88<SEP>0x3368<SEP>0x6D3B<SEP3>// <CJK>
0x8A89<SEP>0x3369<SEP>0x6E07<SEP3>// <CJK>
0x8A8A<SEP>0x336A<SEP>0x6ED1<SEP3>// <CJK>
0x8A8B<SEP>0x336B<SEP>0x845B<SEP3>// <CJK>
0x8A8C<SEP>0x336C<SEP>0x8910<SEP3>// <CJK>
0x8A8D<SEP>0x336D<SEP>0x8F44<SEP3>// <CJK>
0x8A8E<SEP>0x336E<SEP>0x4E14<SEP3>// <CJK>
0x8A8F<SEP>0x336F<SEP>0x9C39<SEP3>// <CJK>
0x8A90<SEP>0x3370<SEP>0x53F6<SEP3>// <CJK>
0x8A91<SEP>0x3371<SEP>0x691B<SEP3>// <CJK>
0x8A92<SEP>0x3372<SEP>0x6A3A<SEP3>// <CJK>
0x8A93<SEP>0x3373<SEP>0x9784<SEP3>// <CJK>
0x8A94<SEP>0x3374<SEP>0x682A<SEP3>// <CJK>
0x8A95<SEP>0x3375<SEP>0x515C<SEP3>// <CJK>
0x8A96<SEP>0x3376<SEP>0x7AC3<SEP3>// <CJK>
0x8A97<SEP>0x3377<SEP>0x84B2<SEP3>// <CJK>
0x8A98<SEP>0x3378<SEP>0x91DC<SEP3>// <CJK>
0x8A99<SEP>0x3379<SEP>0x938C<SEP3>// <CJK>
0x8A9A<SEP>0x337A<SEP>0x565B<SEP3>// <CJK>
0x8A9B<SEP>0x337B<SEP>0x9D28<SEP3>// <CJK>
0x8A9C<SEP>0x337C<SEP>0x6822<SEP3>// <CJK>
0x8A9D<SEP>0x337D<SEP>0x8305<SEP3>// <CJK>
0x8A9E<SEP>0x337E<SEP>0x8431<SEP3>// <CJK>
0x8A9F<SEP>0x3421<SEP>0x7CA5<SEP3>// <CJK>
0x8AA0<SEP>0x3422<SEP>0x5208<SEP3>// <CJK>
0x8AA1<SEP>0x3423<SEP>0x82C5<SEP3>// <CJK>
0x8AA2<SEP>0x3424<SEP>0x74E6<SEP3>// <CJK>
0x8AA3<SEP>0x3425<SEP>0x4E7E<SEP3>// <CJK>
0x8AA4<SEP>0x3426<SEP>0x4F83<SEP3>// <CJK>
0x8AA5<SEP>0x3427<SEP>0x51A0<SEP3>// <CJK>
0x8AA6<SEP>0x3428<SEP>0x5BD2<SEP3>// <CJK>
0x8AA7<SEP>0x3429<SEP>0x520A<SEP3>// <CJK>
0x8AA8<SEP>0x342A<SEP>0x52D8<SEP3>// <CJK>
0x8AA9<SEP>0x342B<SEP>0x52E7<SEP3>// <CJK>
0x8AAA<SEP>0x342C<SEP>0x5DFB<SEP3>// <CJK>
0x8AAB<SEP>0x342D<SEP>0x559A<SEP3>// <CJK>
0x8AAC<SEP>0x342E<SEP>0x582A<SEP3>// <CJK>
0x8AAD<SEP>0x342F<SEP>0x59E6<SEP3>// <CJK>
0x8AAE<SEP>0x3430<SEP>0x5B8C<SEP3>// <CJK>
0x8AAF<SEP>0x3431<SEP>0x5B98<SEP3>// <CJK>
0x8AB0<SEP>0x3432<SEP>0x5BDB<SEP3>// <CJK>
0x8AB1<SEP>0x3433<SEP>0x5E72<SEP3>// <CJK>
0x8AB2<SEP>0x3434<SEP>0x5E79<SEP3>// <CJK>
0x8AB3<SEP>0x3435<SEP>0x60A3<SEP3>// <CJK>
0x8AB4<SEP>0x3436<SEP>0x611F<SEP3>// <CJK>
0x8AB5<SEP>0x3437<SEP>0x6163<SEP3>// <CJK>
0x8AB6<SEP>0x3438<SEP>0x61BE<SEP3>// <CJK>
0x8AB7<SEP>0x3439<SEP>0x63DB<SEP3>// <CJK>
0x8AB8<SEP>0x343A<SEP>0x6562<SEP3>// <CJK>
0x8AB9<SEP>0x343B<SEP>0x67D1<SEP3>// <CJK>
0x8ABA<SEP>0x343C<SEP>0x6853<SEP3>// <CJK>
0x8ABB<SEP>0x343D<SEP>0x68FA<SEP3>// <CJK>
0x8ABC<SEP>0x343E<SEP>0x6B3E<SEP3>// <CJK>
0x8ABD<SEP>0x343F<SEP>0x6B53<SEP3>// <CJK>
0x8ABE<SEP>0x3440<SEP>0x6C57<SEP3>// <CJK>
0x8ABF<SEP>0x3441<SEP>0x6F22<SEP3>// <CJK>
0x8AC0<SEP>0x3442<SEP>0x6F97<SEP3>// <CJK>
0x8AC1<SEP>0x3443<SEP>0x6F45<SEP3>// <CJK>
0x8AC2<SEP>0x3444<SEP>0x74B0<SEP3>// <CJK>
0x8AC3<SEP>0x3445<SEP>0x7518<SEP3>// <CJK>
0x8AC4<SEP>0x3446<SEP>0x76E3<SEP3>// <CJK>
0x8AC5<SEP>0x3447<SEP>0x770B<SEP3>// <CJK>
0x8AC6<SEP>0x3448<SEP>0x7AFF<SEP3>// <CJK>
0x8AC7<SEP>0x3449<SEP>0x7BA1<SEP3>// <CJK>
0x8AC8<SEP>0x344A<SEP>0x7C21<SEP3>// <CJK>
0x8AC9<SEP>0x344B<SEP>0x7DE9<SEP3>// <CJK>
0x8ACA<SEP>0x344C<SEP>0x7F36<SEP3>// <CJK>
0x8ACB<SEP>0x344D<SEP>0x7FF0<SEP3>// <CJK>
0x8ACC<SEP>0x344E<SEP>0x809D<SEP3>// <CJK>
0x8ACD<SEP>0x344F<SEP>0x8266<SEP3>// <CJK>
0x8ACE<SEP>0x3450<SEP>0x839E<SEP3>// <CJK>
0x8ACF<SEP>0x3451<SEP>0x89B3<SEP3>// <CJK>
0x8AD0<SEP>0x3452<SEP>0x8ACC<SEP3>// <CJK>
0x8AD1<SEP>0x3453<SEP>0x8CAB<SEP3>// <CJK>
0x8AD2<SEP>0x3454<SEP>0x9084<SEP3>// <CJK>
0x8AD3<SEP>0x3455<SEP>0x9451<SEP3>// <CJK>
0x8AD4<SEP>0x3456<SEP>0x9593<SEP3>// <CJK>
0x8AD5<SEP>0x3457<SEP>0x9591<SEP3>// <CJK>
0x8AD6<SEP>0x3458<SEP>0x95A2<SEP3>// <CJK>
0x8AD7<SEP>0x3459<SEP>0x9665<SEP3>// <CJK>
0x8AD8<SEP>0x345A<SEP>0x97D3<SEP3>// <CJK>
0x8AD9<SEP>0x345B<SEP>0x9928<SEP3>// <CJK>
0x8ADA<SEP>0x345C<SEP>0x8218<SEP3>// <CJK>
0x8ADB<SEP>0x345D<SEP>0x4E38<SEP3>// <CJK>
0x8ADC<SEP>0x345E<SEP>0x542B<SEP3>// <CJK>
0x8ADD<SEP>0x345F<SEP>0x5CB8<SEP3>// <CJK>
0x8ADE<SEP>0x3460<SEP>0x5DCC<SEP3>// <CJK>
0x8ADF<SEP>0x3461<SEP>0x73A9<SEP3>// <CJK>
0x8AE0<SEP>0x3462<SEP>0x764C<SEP3>// <CJK>
0x8AE1<SEP>0x3463<SEP>0x773C<SEP3>// <CJK>
0x8AE2<SEP>0x3464<SEP>0x5CA9<SEP3>// <CJK>
0x8AE3<SEP>0x3465<SEP>0x7FEB<SEP3>// <CJK>
0x8AE4<SEP>0x3466<SEP>0x8D0B<SEP3>// <CJK>
0x8AE5<SEP>0x3467<SEP>0x96C1<SEP3>// <CJK>
0x8AE6<SEP>0x3468<SEP>0x9811<SEP3>// <CJK>
0x8AE7<SEP>0x3469<SEP>0x9854<SEP3>// <CJK>
0x8AE8<SEP>0x346A<SEP>0x9858<SEP3>// <CJK>
0x8AE9<SEP>0x346B<SEP>0x4F01<SEP3>// <CJK>
0x8AEA<SEP>0x346C<SEP>0x4F0E<SEP3>// <CJK>
0x8AEB<SEP>0x346D<SEP>0x5371<SEP3>// <CJK>
0x8AEC<SEP>0x346E<SEP>0x559C<SEP3>// <CJK>
0x8AED<SEP>0x346F<SEP>0x5668<SEP3>// <CJK>
0x8AEE<SEP>0x3470<SEP>0x57FA<SEP3>// <CJK>
0x8AEF<SEP>0x3471<SEP>0x5947<SEP3>// <CJK>
0x8AF0<SEP>0x3472<SEP>0x5B09<SEP3>// <CJK>
0x8AF1<SEP>0x3473<SEP>0x5BC4<SEP3>// <CJK>
0x8AF2<SEP>0x3474<SEP>0x5C90<SEP3>// <CJK>
0x8AF3<SEP>0x3475<SEP>0x5E0C<SEP3>// <CJK>
0x8AF4<SEP>0x3476<SEP>0x5E7E<SEP3>// <CJK>
0x8AF5<SEP>0x3477<SEP>0x5FCC<SEP3>// <CJK>
0x8AF6<SEP>0x3478<SEP>0x63EE<SEP3>// <CJK>
0x8AF7<SEP>0x3479<SEP>0x673A<SEP3>// <CJK>
0x8AF8<SEP>0x347A<SEP>0x65D7<SEP3>// <CJK>
0x8AF9<SEP>0x347B<SEP>0x65E2<SEP3>// <CJK>
0x8AFA<SEP>0x347C<SEP>0x671F<SEP3>// <CJK>
0x8AFB<SEP>0x347D<SEP>0x68CB<SEP3>// <CJK>
0x8AFC<SEP>0x347E<SEP>0x68C4<SEP3>// <CJK>
0x8B40<SEP>0x3521<SEP>0x6A5F<SEP3>// <CJK>
0x8B41<SEP>0x3522<SEP>0x5E30<SEP3>// <CJK>
0x8B42<SEP>0x3523<SEP>0x6BC5<SEP3>// <CJK>
0x8B43<SEP>0x3524<SEP>0x6C17<SEP3>// <CJK>
0x8B44<SEP>0x3525<SEP>0x6C7D<SEP3>// <CJK>
0x8B45<SEP>0x3526<SEP>0x757F<SEP3>// <CJK>
0x8B46<SEP>0x3527<SEP>0x7948<SEP3>// <CJK>
0x8B47<SEP>0x3528<SEP>0x5B63<SEP3>// <CJK>
0x8B48<SEP>0x3529<SEP>0x7A00<SEP3>// <CJK>
0x8B49<SEP>0x352A<SEP>0x7D00<SEP3>// <CJK>
0x8B4A<SEP>0x352B<SEP>0x5FBD<SEP3>// <CJK>
0x8B4B<SEP>0x352C<SEP>0x898F<SEP3>// <CJK>
0x8B4C<SEP>0x352D<SEP>0x8A18<SEP3>// <CJK>
0x8B4D<SEP>0x352E<SEP>0x8CB4<SEP3>// <CJK>
0x8B4E<SEP>0x352F<SEP>0x8D77<SEP3>// <CJK>
0x8B4F<SEP>0x3530<SEP>0x8ECC<SEP3>// <CJK>
0x8B50<SEP>0x3531<SEP>0x8F1D<SEP3>// <CJK>
0x8B51<SEP>0x3532<SEP>0x98E2<SEP3>// <CJK>
0x8B52<SEP>0x3533<SEP>0x9A0E<SEP3>// <CJK>
0x8B53<SEP>0x3534<SEP>0x9B3C<SEP3>// <CJK>
0x8B54<SEP>0x3535<SEP>0x4E80<SEP3>// <CJK>
0x8B55<SEP>0x3536<SEP>0x507D<SEP3>// <CJK>
0x8B56<SEP>0x3537<SEP>0x5100<SEP3>// <CJK>
0x8B57<SEP>0x3538<SEP>0x5993<SEP3>// <CJK>
0x8B58<SEP>0x3539<SEP>0x5B9C<SEP3>// <CJK>
0x8B59<SEP>0x353A<SEP>0x622F<SEP3>// <CJK>
0x8B5A<SEP>0x353B<SEP>0x6280<SEP3>// <CJK>
0x8B5B<SEP>0x353C<SEP>0x64EC<SEP3>// <CJK>
0x8B5C<SEP>0x353D<SEP>0x6B3A<SEP3>// <CJK>
0x8B5D<SEP>0x353E<SEP>0x72A0<SEP3>// <CJK>
0x8B5E<SEP>0x353F<SEP>0x7591<SEP3>// <CJK>
0x8B5F<SEP>0x3540<SEP>0x7947<SEP3>// <CJK>
0x8B60<SEP>0x3541<SEP>0x7FA9<SEP3>// <CJK>
0x8B61<SEP>0x3542<SEP>0x87FB<SEP3>// <CJK>
0x8B62<SEP>0x3543<SEP>0x8ABC<SEP3>// <CJK>
0x8B63<SEP>0x3544<SEP>0x8B70<SEP3>// <CJK>
0x8B64<SEP>0x3545<SEP>0x63AC<SEP3>// <CJK>
0x8B65<SEP>0x3546<SEP>0x83CA<SEP3>// <CJK>
0x8B66<SEP>0x3547<SEP>0x97A0<SEP3>// <CJK>
0x8B67<SEP>0x3548<SEP>0x5409<SEP3>// <CJK>
0x8B68<SEP>0x3549<SEP>0x5403<SEP3>// <CJK>
0x8B69<SEP>0x354A<SEP>0x55AB<SEP3>// <CJK>
0x8B6A<SEP>0x354B<SEP>0x6854<SEP3>// <CJK>
0x8B6B<SEP>0x354C<SEP>0x6A58<SEP3>// <CJK>
0x8B6C<SEP>0x354D<SEP>0x8A70<SEP3>// <CJK>
0x8B6D<SEP>0x354E<SEP>0x7827<SEP3>// <CJK>
0x8B6E<SEP>0x354F<SEP>0x6775<SEP3>// <CJK>
0x8B6F<SEP>0x3550<SEP>0x9ECD<SEP3>// <CJK>
0x8B70<SEP>0x3551<SEP>0x5374<SEP3>// <CJK>
0x8B71<SEP>0x3552<SEP>0x5BA2<SEP3>// <CJK>
0x8B72<SEP>0x3553<SEP>0x811A<SEP3>// <CJK>
0x8B73<SEP>0x3554<SEP>0x8650<SEP3>// <CJK>
0x8B74<SEP>0x3555<SEP>0x9006<SEP3>// <CJK>
0x8B75<SEP>0x3556<SEP>0x4E18<SEP3>// <CJK>
0x8B76<SEP>0x3557<SEP>0x4E45<SEP3>// <CJK>
0x8B77<SEP>0x3558<SEP>0x4EC7<SEP3>// <CJK>
0x8B78<SEP>0x3559<SEP>0x4F11<SEP3>// <CJK>
0x8B79<SEP>0x355A<SEP>0x53CA<SEP3>// <CJK>
0x8B7A<SEP>0x355B<SEP>0x5438<SEP3>// <CJK>
0x8B7B<SEP>0x355C<SEP>0x5BAE<SEP3>// <CJK>
0x8B7C<SEP>0x355D<SEP>0x5F13<SEP3>// <CJK>
0x8B7D<SEP>0x355E<SEP>0x6025<SEP3>// <CJK>
0x8B7E<SEP>0x355F<SEP>0x6551<SEP3>// <CJK>
0x8B80<SEP>0x3560<SEP>0x673D<SEP3>// <CJK>
0x8B81<SEP>0x3561<SEP>0x6C42<SEP3>// <CJK>
0x8B82<SEP>0x3562<SEP>0x6C72<SEP3>// <CJK>
0x8B83<SEP>0x3563<SEP>0x6CE3<SEP3>// <CJK>
0x8B84<SEP>0x3564<SEP>0x7078<SEP3>// <CJK>
0x8B85<SEP>0x3565<SEP>0x7403<SEP3>// <CJK>
0x8B86<SEP>0x3566<SEP>0x7A76<SEP3>// <CJK>
0x8B87<SEP>0x3567<SEP>0x7AAE<SEP3>// <CJK>
0x8B88<SEP>0x3568<SEP>0x7B08<SEP3>// <CJK>
0x8B89<SEP>0x3569<SEP>0x7D1A<SEP3>// <CJK>
0x8B8A<SEP>0x356A<SEP>0x7CFE<SEP3>// <CJK>
0x8B8B<SEP>0x356B<SEP>0x7D66<SEP3>// <CJK>
0x8B8C<SEP>0x356C<SEP>0x65E7<SEP3>// <CJK>
0x8B8D<SEP>0x356D<SEP>0x725B<SEP3>// <CJK>
0x8B8E<SEP>0x356E<SEP>0x53BB<SEP3>// <CJK>
0x8B8F<SEP>0x356F<SEP>0x5C45<SEP3>// <CJK>
0x8B90<SEP>0x3570<SEP>0x5DE8<SEP3>// <CJK>
0x8B91<SEP>0x3571<SEP>0x62D2<SEP3>// <CJK>
0x8B92<SEP>0x3572<SEP>0x62E0<SEP3>// <CJK>
0x8B93<SEP>0x3573<SEP>0x6319<SEP3>// <CJK>
0x8B94<SEP>0x3574<SEP>0x6E20<SEP3>// <CJK>
0x8B95<SEP>0x3575<SEP>0x865A<SEP3>// <CJK>
0x8B96<SEP>0x3576<SEP>0x8A31<SEP3>// <CJK>
0x8B97<SEP>0x3577<SEP>0x8DDD<SEP3>// <CJK>
0x8B98<SEP>0x3578<SEP>0x92F8<SEP3>// <CJK>
0x8B99<SEP>0x3579<SEP>0x6F01<SEP3>// <CJK>
0x8B9A<SEP>0x357A<SEP>0x79A6<SEP3>// <CJK>
0x8B9B<SEP>0x357B<SEP>0x9B5A<SEP3>// <CJK>
0x8B9C<SEP>0x357C<SEP>0x4EA8<SEP3>// <CJK>
0x8B9D<SEP>0x357D<SEP>0x4EAB<SEP3>// <CJK>
0x8B9E<SEP>0x357E<SEP>0x4EAC<SEP3>// <CJK>
0x8B9F<SEP>0x3621<SEP>0x4F9B<SEP3>// <CJK>
0x8BA0<SEP>0x3622<SEP>0x4FA0<SEP3>// <CJK>
0x8BA1<SEP>0x3623<SEP>0x50D1<SEP3>// <CJK>
0x8BA2<SEP>0x3624<SEP>0x5147<SEP3>// <CJK>
0x8BA3<SEP>0x3625<SEP>0x7AF6<SEP3>// <CJK>
0x8BA4<SEP>0x3626<SEP>0x5171<SEP3>// <CJK>
0x8BA5<SEP>0x3627<SEP>0x51F6<SEP3>// <CJK>
0x8BA6<SEP>0x3628<SEP>0x5354<SEP3>// <CJK>
0x8BA7<SEP>0x3629<SEP>0x5321<SEP3>// <CJK>
0x8BA8<SEP>0x362A<SEP>0x537F<SEP3>// <CJK>
0x8BA9<SEP>0x362B<SEP>0x53EB<SEP3>// <CJK>
0x8BAA<SEP>0x362C<SEP>0x55AC<SEP3>// <CJK>
0x8BAB<SEP>0x362D<SEP>0x5883<SEP3>// <CJK>
0x8BAC<SEP>0x362E<SEP>0x5CE1<SEP3>// <CJK>
0x8BAD<SEP>0x362F<SEP>0x5F37<SEP3>// <CJK>
0x8BAE<SEP>0x3630<SEP>0x5F4A<SEP3>// <CJK>
0x8BAF<SEP>0x3631<SEP>0x602F<SEP3>// <CJK>
0x8BB0<SEP>0x3632<SEP>0x6050<SEP3>// <CJK>
0x8BB1<SEP>0x3633<SEP>0x606D<SEP3>// <CJK>
0x8BB2<SEP>0x3634<SEP>0x631F<SEP3>// <CJK>
0x8BB3<SEP>0x3635<SEP>0x6559<SEP3>// <CJK>
0x8BB4<SEP>0x3636<SEP>0x6A4B<SEP3>// <CJK>
0x8BB5<SEP>0x3637<SEP>0x6CC1<SEP3>// <CJK>
0x8BB6<SEP>0x3638<SEP>0x72C2<SEP3>// <CJK>
0x8BB7<SEP>0x3639<SEP>0x72ED<SEP3>// <CJK>
0x8BB8<SEP>0x363A<SEP>0x77EF<SEP3>// <CJK>
0x8BB9<SEP>0x363B<SEP>0x80F8<SEP3>// <CJK>
0x8BBA<SEP>0x363C<SEP>0x8105<SEP3>// <CJK>
0x8BBB<SEP>0x363D<SEP>0x8208<SEP3>// <CJK>
0x8BBC<SEP>0x363E<SEP>0x854E<SEP3>// <CJK>
0x8BBD<SEP>0x363F<SEP>0x90F7<SEP3>// <CJK>
0x8BBE<SEP>0x3640<SEP>0x93E1<SEP3>// <CJK>
0x8BBF<SEP>0x3641<SEP>0x97FF<SEP3>// <CJK>
0x8BC0<SEP>0x3642<SEP>0x9957<SEP3>// <CJK>
0x8BC1<SEP>0x3643<SEP>0x9A5A<SEP3>// <CJK>
0x8BC2<SEP>0x3644<SEP>0x4EF0<SEP3>// <CJK>
0x8BC3<SEP>0x3645<SEP>0x51DD<SEP3>// <CJK>
0x8BC4<SEP>0x3646<SEP>0x5C2D<SEP3>// <CJK>
0x8BC5<SEP>0x3647<SEP>0x6681<SEP3>// <CJK>
0x8BC6<SEP>0x3648<SEP>0x696D<SEP3>// <CJK>
0x8BC7<SEP>0x3649<SEP>0x5C40<SEP3>// <CJK>
0x8BC8<SEP>0x364A<SEP>0x66F2<SEP3>// <CJK>
0x8BC9<SEP>0x364B<SEP>0x6975<SEP3>// <CJK>
0x8BCA<SEP>0x364C<SEP>0x7389<SEP3>// <CJK>
0x8BCB<SEP>0x364D<SEP>0x6850<SEP3>// <CJK>
0x8BCC<SEP>0x364E<SEP>0x7C81<SEP3>// <CJK>
0x8BCD<SEP>0x364F<SEP>0x50C5<SEP3>// <CJK>
0x8BCE<SEP>0x3650<SEP>0x52E4<SEP3>// <CJK>
0x8BCF<SEP>0x3651<SEP>0x5747<SEP3>// <CJK>
0x8BD0<SEP>0x3652<SEP>0x5DFE<SEP3>// <CJK>
0x8BD1<SEP>0x3653<SEP>0x9326<SEP3>// <CJK>
0x8BD2<SEP>0x3654<SEP>0x65A4<SEP3>// <CJK>
0x8BD3<SEP>0x3655<SEP>0x6B23<SEP3>// <CJK>
0x8BD4<SEP>0x3656<SEP>0x6B3D<SEP3>// <CJK>
0x8BD5<SEP>0x3657<SEP>0x7434<SEP3>// <CJK>
0x8BD6<SEP>0x3658<SEP>0x7981<SEP3>// <CJK>
0x8BD7<SEP>0x3659<SEP>0x79BD<SEP3>// <CJK>
0x8BD8<SEP>0x365A<SEP>0x7B4B<SEP3>// <CJK>
0x8BD9<SEP>0x365B<SEP>0x7DCA<SEP3>// <CJK>
0x8BDA<SEP>0x365C<SEP>0x82B9<SEP3>// <CJK>
0x8BDB<SEP>0x365D<SEP>0x83CC<SEP3>// <CJK>
0x8BDC<SEP>0x365E<SEP>0x887F<SEP3>// <CJK>
0x8BDD<SEP>0x365F<SEP>0x895F<SEP3>// <CJK>
0x8BDE<SEP>0x3660<SEP>0x8B39<SEP3>// <CJK>
0x8BDF<SEP>0x3661<SEP>0x8FD1<SEP3>// <CJK>
0x8BE0<SEP>0x3662<SEP>0x91D1<SEP3>// <CJK>
0x8BE1<SEP>0x3663<SEP>0x541F<SEP3>// <CJK>
0x8BE2<SEP>0x3664<SEP>0x9280<SEP3>// <CJK>
0x8BE3<SEP>0x3665<SEP>0x4E5D<SEP3>// <CJK>
0x8BE4<SEP>0x3666<SEP>0x5036<SEP3>// <CJK>
0x8BE5<SEP>0x3667<SEP>0x53E5<SEP3>// <CJK>
0x8BE6<SEP>0x3668<SEP>0x533A<SEP3>// <CJK>
0x8BE7<SEP>0x3669<SEP>0x72D7<SEP3>// <CJK>
0x8BE8<SEP>0x366A<SEP>0x7396<SEP3>// <CJK>
0x8BE9<SEP>0x366B<SEP>0x77E9<SEP3>// <CJK>
0x8BEA<SEP>0x366C<SEP>0x82E6<SEP3>// <CJK>
0x8BEB<SEP>0x366D<SEP>0x8EAF<SEP3>// <CJK>
0x8BEC<SEP>0x366E<SEP>0x99C6<SEP3>// <CJK>
0x8BED<SEP>0x366F<SEP>0x99C8<SEP3>// <CJK>
0x8BEE<SEP>0x3670<SEP>0x99D2<SEP3>// <CJK>
0x8BEF<SEP>0x3671<SEP>0x5177<SEP3>// <CJK>
0x8BF0<SEP>0x3672<SEP>0x611A<SEP3>// <CJK>
0x8BF1<SEP>0x3673<SEP>0x865E<SEP3>// <CJK>
0x8BF2<SEP>0x3674<SEP>0x55B0<SEP3>// <CJK>
0x8BF3<SEP>0x3675<SEP>0x7A7A<SEP3>// <CJK>
0x8BF4<SEP>0x3676<SEP>0x5076<SEP3>// <CJK>
0x8BF5<SEP>0x3677<SEP>0x5BD3<SEP3>// <CJK>
0x8BF6<SEP>0x3678<SEP>0x9047<SEP3>// <CJK>
0x8BF7<SEP>0x3679<SEP>0x9685<SEP3>// <CJK>
0x8BF8<SEP>0x367A<SEP>0x4E32<SEP3>// <CJK>
0x8BF9<SEP>0x367B<SEP>0x6ADB<SEP3>// <CJK>
0x8BFA<SEP>0x367C<SEP>0x91E7<SEP3>// <CJK>
0x8BFB<SEP>0x367D<SEP>0x5C51<SEP3>// <CJK>
0x8BFC<SEP>0x367E<SEP>0x5C48<SEP3>// <CJK>
0x8C40<SEP>0x3721<SEP>0x6398<SEP3>// <CJK>
0x8C41<SEP>0x3722<SEP>0x7A9F<SEP3>// <CJK>
0x8C42<SEP>0x3723<SEP>0x6C93<SEP3>// <CJK>
0x8C43<SEP>0x3724<SEP>0x9774<SEP3>// <CJK>
0x8C44<SEP>0x3725<SEP>0x8F61<SEP3>// <CJK>
0x8C45<SEP>0x3726<SEP>0x7AAA<SEP3>// <CJK>
0x8C46<SEP>0x3727<SEP>0x718A<SEP3>// <CJK>
0x8C47<SEP>0x3728<SEP>0x9688<SEP3>// <CJK>
0x8C48<SEP>0x3729<SEP>0x7C82<SEP3>// <CJK>
0x8C49<SEP>0x372A<SEP>0x6817<SEP3>// <CJK>
0x8C4A<SEP>0x372B<SEP>0x7E70<SEP3>// <CJK>
0x8C4B<SEP>0x372C<SEP>0x6851<SEP3>// <CJK>
0x8C4C<SEP>0x372D<SEP>0x936C<SEP3>// <CJK>
0x8C4D<SEP>0x372E<SEP>0x52F2<SEP3>// <CJK>
0x8C4E<SEP>0x372F<SEP>0x541B<SEP3>// <CJK>
0x8C4F<SEP>0x3730<SEP>0x85AB<SEP3>// <CJK>
0x8C50<SEP>0x3731<SEP>0x8A13<SEP3>// <CJK>
0x8C51<SEP>0x3732<SEP>0x7FA4<SEP3>// <CJK>
0x8C52<SEP>0x3733<SEP>0x8ECD<SEP3>// <CJK>
0x8C53<SEP>0x3734<SEP>0x90E1<SEP3>// <CJK>
0x8C54<SEP>0x3735<SEP>0x5366<SEP3>// <CJK>
0x8C55<SEP>0x3736<SEP>0x8888<SEP3>// <CJK>
0x8C56<SEP>0x3737<SEP>0x7941<SEP3>// <CJK>
0x8C57<SEP>0x3738<SEP>0x4FC2<SEP3>// <CJK>
0x8C58<SEP>0x3739<SEP>0x50BE<SEP3>// <CJK>
0x8C59<SEP>0x373A<SEP>0x5211<SEP3>// <CJK>
0x8C5A<SEP>0x373B<SEP>0x5144<SEP3>// <CJK>
0x8C5B<SEP>0x373C<SEP>0x5553<SEP3>// <CJK>
0x8C5C<SEP>0x373D<SEP>0x572D<SEP3>// <CJK>
0x8C5D<SEP>0x373E<SEP>0x73EA<SEP3>// <CJK>
0x8C5E<SEP>0x373F<SEP>0x578B<SEP3>// <CJK>
0x8C5F<SEP>0x3740<SEP>0x5951<SEP3>// <CJK>
0x8C60<SEP>0x3741<SEP>0x5F62<SEP3>// <CJK>
0x8C61<SEP>0x3742<SEP>0x5F84<SEP3>// <CJK>
0x8C62<SEP>0x3743<SEP>0x6075<SEP3>// <CJK>
0x8C63<SEP>0x3744<SEP>0x6176<SEP3>// <CJK>
0x8C64<SEP>0x3745<SEP>0x6167<SEP3>// <CJK>
0x8C65<SEP>0x3746<SEP>0x61A9<SEP3>// <CJK>
0x8C66<SEP>0x3747<SEP>0x63B2<SEP3>// <CJK>
0x8C67<SEP>0x3748<SEP>0x643A<SEP3>// <CJK>
0x8C68<SEP>0x3749<SEP>0x656C<SEP3>// <CJK>
0x8C69<SEP>0x374A<SEP>0x666F<SEP3>// <CJK>
0x8C6A<SEP>0x374B<SEP>0x6842<SEP3>// <CJK>
0x8C6B<SEP>0x374C<SEP>0x6E13<SEP3>// <CJK>
0x8C6C<SEP>0x374D<SEP>0x7566<SEP3>// <CJK>
0x8C6D<SEP>0x374E<SEP>0x7A3D<SEP3>// <CJK>
0x8C6E<SEP>0x374F<SEP>0x7CFB<SEP3>// <CJK>
0x8C6F<SEP>0x3750<SEP>0x7D4C<SEP3>// <CJK>
0x8C70<SEP>0x3751<SEP>0x7D99<SEP3>// <CJK>
0x8C71<SEP>0x3752<SEP>0x7E4B<SEP3>// <CJK>
0x8C72<SEP>0x3753<SEP>0x7F6B<SEP3>// <CJK>
0x8C73<SEP>0x3754<SEP>0x830E<SEP3>// <CJK>
0x8C74<SEP>0x3755<SEP>0x834A<SEP3>// <CJK>
0x8C75<SEP>0x3756<SEP>0x86CD<SEP3>// <CJK>
0x8C76<SEP>0x3757<SEP>0x8A08<SEP3>// <CJK>
0x8C77<SEP>0x3758<SEP>0x8A63<SEP3>// <CJK>
0x8C78<SEP>0x3759<SEP>0x8B66<SEP3>// <CJK>
0x8C79<SEP>0x375A<SEP>0x8EFD<SEP3>// <CJK>
0x8C7A<SEP>0x375B<SEP>0x981A<SEP3>// <CJK>
0x8C7B<SEP>0x375C<SEP>0x9D8F<SEP3>// <CJK>
0x8C7C<SEP>0x375D<SEP>0x82B8<SEP3>// <CJK>
0x8C7D<SEP>0x375E<SEP>0x8FCE<SEP3>// <CJK>
0x8C7E<SEP>0x375F<SEP>0x9BE8<SEP3>// <CJK>
0x8C80<SEP>0x3760<SEP>0x5287<SEP3>// <CJK>
0x8C81<SEP>0x3761<SEP>0x621F<SEP3>// <CJK>
0x8C82<SEP>0x3762<SEP>0x6483<SEP3>// <CJK>
0x8C83<SEP>0x3763<SEP>0x6FC0<SEP3>// <CJK>
0x8C84<SEP>0x3764<SEP>0x9699<SEP3>// <CJK>
0x8C85<SEP>0x3765<SEP>0x6841<SEP3>// <CJK>
0x8C86<SEP>0x3766<SEP>0x5091<SEP3>// <CJK>
0x8C87<SEP>0x3767<SEP>0x6B20<SEP3>// <CJK>
0x8C88<SEP>0x3768<SEP>0x6C7A<SEP3>// <CJK>
0x8C89<SEP>0x3769<SEP>0x6F54<SEP3>// <CJK>
0x8C8A<SEP>0x376A<SEP>0x7A74<SEP3>// <CJK>
0x8C8B<SEP>0x376B<SEP>0x7D50<SEP3>// <CJK>
0x8C8C<SEP>0x376C<SEP>0x8840<SEP3>// <CJK>
0x8C8D<SEP>0x376D<SEP>0x8A23<SEP3>// <CJK>
0x8C8E<SEP>0x376E<SEP>0x6708<SEP3>// <CJK>
0x8C8F<SEP>0x376F<SEP>0x4EF6<SEP3>// <CJK>
0x8C90<SEP>0x3770<SEP>0x5039<SEP3>// <CJK>
0x8C91<SEP>0x3771<SEP>0x5026<SEP3>// <CJK>
0x8C92<SEP>0x3772<SEP>0x5065<SEP3>// <CJK>
0x8C93<SEP>0x3773<SEP>0x517C<SEP3>// <CJK>
0x8C94<SEP>0x3774<SEP>0x5238<SEP3>// <CJK>
0x8C95<SEP>0x3775<SEP>0x5263<SEP3>// <CJK>
0x8C96<SEP>0x3776<SEP>0x55A7<SEP3>// <CJK>
0x8C97<SEP>0x3777<SEP>0x570F<SEP3>// <CJK>
0x8C98<SEP>0x3778<SEP>0x5805<SEP3>// <CJK>
0x8C99<SEP>0x3779<SEP>0x5ACC<SEP3>// <CJK>
0x8C9A<SEP>0x377A<SEP>0x5EFA<SEP3>// <CJK>
0x8C9B<SEP>0x377B<SEP>0x61B2<SEP3>// <CJK>
0x8C9C<SEP>0x377C<SEP>0x61F8<SEP3>// <CJK>
0x8C9D<SEP>0x377D<SEP>0x62F3<SEP3>// <CJK>
0x8C9E<SEP>0x377E<SEP>0x6372<SEP3>// <CJK>
0x8C9F<SEP>0x3821<SEP>0x691C<SEP3>// <CJK>
0x8CA0<SEP>0x3822<SEP>0x6A29<SEP3>// <CJK>
0x8CA1<SEP>0x3823<SEP>0x727D<SEP3>// <CJK>
0x8CA2<SEP>0x3824<SEP>0x72AC<SEP3>// <CJK>
0x8CA3<SEP>0x3825<SEP>0x732E<SEP3>// <CJK>
0x8CA4<SEP>0x3826<SEP>0x7814<SEP3>// <CJK>
0x8CA5<SEP>0x3827<SEP>0x786F<SEP3>// <CJK>
0x8CA6<SEP>0x3828<SEP>0x7D79<SEP3>// <CJK>
0x8CA7<SEP>0x3829<SEP>0x770C<SEP3>// <CJK>
0x8CA8<SEP>0x382A<SEP>0x80A9<SEP3>// <CJK>
0x8CA9<SEP>0x382B<SEP>0x898B<SEP3>// <CJK>
0x8CAA<SEP>0x382C<SEP>0x8B19<SEP3>// <CJK>
0x8CAB<SEP>0x382D<SEP>0x8CE2<SEP3>// <CJK>
0x8CAC<SEP>0x382E<SEP>0x8ED2<SEP3>// <CJK>
0x8CAD<SEP>0x382F<SEP>0x9063<SEP3>// <CJK>
0x8CAE<SEP>0x3830<SEP>0x9375<SEP3>// <CJK>
0x8CAF<SEP>0x3831<SEP>0x967A<SEP3>// <CJK>
0x8CB0<SEP>0x3832<SEP>0x9855<SEP3>// <CJK>
0x8CB1<SEP>0x3833<SEP>0x9A13<SEP3>// <CJK>
0x8CB2<SEP>0x3834<SEP>0x9E78<SEP3>// <CJK>
0x8CB3<SEP>0x3835<SEP>0x5143<SEP3>// <CJK>
0x8CB4<SEP>0x3836<SEP>0x539F<SEP3>// <CJK>
0x8CB5<SEP>0x3837<SEP>0x53B3<SEP3>// <CJK>
0x8CB6<SEP>0x3838<SEP>0x5E7B<SEP3>// <CJK>
0x8CB7<SEP>0x3839<SEP>0x5F26<SEP3>// <CJK>
0x8CB8<SEP>0x383A<SEP>0x6E1B<SEP3>// <CJK>
0x8CB9<SEP>0x383B<SEP>0x6E90<SEP3>// <CJK>
0x8CBA<SEP>0x383C<SEP>0x7384<SEP3>// <CJK>
0x8CBB<SEP>0x383D<SEP>0x73FE<SEP3>// <CJK>
0x8CBC<SEP>0x383E<SEP>0x7D43<SEP3>// <CJK>
0x8CBD<SEP>0x383F<SEP>0x8237<SEP3>// <CJK>
0x8CBE<SEP>0x3840<SEP>0x8A00<SEP3>// <CJK>
0x8CBF<SEP>0x3841<SEP>0x8AFA<SEP3>// <CJK>
0x8CC0<SEP>0x3842<SEP>0x9650<SEP3>// <CJK>
0x8CC1<SEP>0x3843<SEP>0x4E4E<SEP3>// <CJK>
0x8CC2<SEP>0x3844<SEP>0x500B<SEP3>// <CJK>
0x8CC3<SEP>0x3845<SEP>0x53E4<SEP3>// <CJK>
0x8CC4<SEP>0x3846<SEP>0x547C<SEP3>// <CJK>
0x8CC5<SEP>0x3847<SEP>0x56FA<SEP3>// <CJK>
0x8CC6<SEP>0x3848<SEP>0x59D1<SEP3>// <CJK>
0x8CC7<SEP>0x3849<SEP>0x5B64<SEP3>// <CJK>
0x8CC8<SEP>0x384A<SEP>0x5DF1<SEP3>// <CJK>
0x8CC9<SEP>0x384B<SEP>0x5EAB<SEP3>// <CJK>
0x8CCA<SEP>0x384C<SEP>0x5F27<SEP3>// <CJK>
0x8CCB<SEP>0x384D<SEP>0x6238<SEP3>// <CJK>
0x8CCC<SEP>0x384E<SEP>0x6545<SEP3>// <CJK>
0x8CCD<SEP>0x384F<SEP>0x67AF<SEP3>// <CJK>
0x8CCE<SEP>0x3850<SEP>0x6E56<SEP3>// <CJK>
0x8CCF<SEP>0x3851<SEP>0x72D0<SEP3>// <CJK>
0x8CD0<SEP>0x3852<SEP>0x7CCA<SEP3>// <CJK>
0x8CD1<SEP>0x3853<SEP>0x88B4<SEP3>// <CJK>
0x8CD2<SEP>0x3854<SEP>0x80A1<SEP3>// <CJK>
0x8CD3<SEP>0x3855<SEP>0x80E1<SEP3>// <CJK>
0x8CD4<SEP>0x3856<SEP>0x83F0<SEP3>// <CJK>
0x8CD5<SEP>0x3857<SEP>0x864E<SEP3>// <CJK>
0x8CD6<SEP>0x3858<SEP>0x8A87<SEP3>// <CJK>
0x8CD7<SEP>0x3859<SEP>0x8DE8<SEP3>// <CJK>
0x8CD8<SEP>0x385A<SEP>0x9237<SEP3>// <CJK>
0x8CD9<SEP>0x385B<SEP>0x96C7<SEP3>// <CJK>
0x8CDA<SEP>0x385C<SEP>0x9867<SEP3>// <CJK>
0x8CDB<SEP>0x385D<SEP>0x9F13<SEP3>// <CJK>
0x8CDC<SEP>0x385E<SEP>0x4E94<SEP3>// <CJK>
0x8CDD<SEP>0x385F<SEP>0x4E92<SEP3>// <CJK>
0x8CDE<SEP>0x3860<SEP>0x4F0D<SEP3>// <CJK>
0x8CDF<SEP>0x3861<SEP>0x5348<SEP3>// <CJK>
0x8CE0<SEP>0x3862<SEP>0x5449<SEP3>// <CJK>
0x8CE1<SEP>0x3863<SEP>0x543E<SEP3>// <CJK>
0x8CE2<SEP>0x3864<SEP>0x5A2F<SEP3>// <CJK>
0x8CE3<SEP>0x3865<SEP>0x5F8C<SEP3>// <CJK>
0x8CE4<SEP>0x3866<SEP>0x5FA1<SEP3>// <CJK>
0x8CE5<SEP>0x3867<SEP>0x609F<SEP3>// <CJK>
0x8CE6<SEP>0x3868<SEP>0x68A7<SEP3>// <CJK>
0x8CE7<SEP>0x3869<SEP>0x6A8E<SEP3>// <CJK>
0x8CE8<SEP>0x386A<SEP>0x745A<SEP3>// <CJK>
0x8CE9<SEP>0x386B<SEP>0x7881<SEP3>// <CJK>
0x8CEA<SEP>0x386C<SEP>0x8A9E<SEP3>// <CJK>
0x8CEB<SEP>0x386D<SEP>0x8AA4<SEP3>// <CJK>
0x8CEC<SEP>0x386E<SEP>0x8B77<SEP3>// <CJK>
0x8CED<SEP>0x386F<SEP>0x9190<SEP3>// <CJK>
0x8CEE<SEP>0x3870<SEP>0x4E5E<SEP3>// <CJK>
0x8CEF<SEP>0x3871<SEP>0x9BC9<SEP3>// <CJK>
0x8CF0<SEP>0x3872<SEP>0x4EA4<SEP3>// <CJK>
0x8CF1<SEP>0x3873<SEP>0x4F7C<SEP3>// <CJK>
0x8CF2<SEP>0x3874<SEP>0x4FAF<SEP3>// <CJK>
0x8CF3<SEP>0x3875<SEP>0x5019<SEP3>// <CJK>
0x8CF4<SEP>0x3876<SEP>0x5016<SEP3>// <CJK>
0x8CF5<SEP>0x3877<SEP>0x5149<SEP3>// <CJK>
0x8CF6<SEP>0x3878<SEP>0x516C<SEP3>// <CJK>
0x8CF7<SEP>0x3879<SEP>0x529F<SEP3>// <CJK>
0x8CF8<SEP>0x387A<SEP>0x52B9<SEP3>// <CJK>
0x8CF9<SEP>0x387B<SEP>0x52FE<SEP3>// <CJK>
0x8CFA<SEP>0x387C<SEP>0x539A<SEP3>// <CJK>
0x8CFB<SEP>0x387D<SEP>0x53E3<SEP3>// <CJK>
0x8CFC<SEP>0x387E<SEP>0x5411<SEP3>// <CJK>
0x8D40<SEP>0x3921<SEP>0x540E<SEP3>// <CJK>
0x8D41<SEP>0x3922<SEP>0x5589<SEP3>// <CJK>
0x8D42<SEP>0x3923<SEP>0x5751<SEP3>// <CJK>
0x8D43<SEP>0x3924<SEP>0x57A2<SEP3>// <CJK>
0x8D44<SEP>0x3925<SEP>0x597D<SEP3>// <CJK>
0x8D45<SEP>0x3926<SEP>0x5B54<SEP3>// <CJK>
0x8D46<SEP>0x3927<SEP>0x5B5D<SEP3>// <CJK>
0x8D47<SEP>0x3928<SEP>0x5B8F<SEP3>// <CJK>
0x8D48<SEP>0x3929<SEP>0x5DE5<SEP3>// <CJK>
0x8D49<SEP>0x392A<SEP>0x5DE7<SEP3>// <CJK>
0x8D4A<SEP>0x392B<SEP>0x5DF7<SEP3>// <CJK>
0x8D4B<SEP>0x392C<SEP>0x5E78<SEP3>// <CJK>
0x8D4C<SEP>0x392D<SEP>0x5E83<SEP3>// <CJK>
0x8D4D<SEP>0x392E<SEP>0x5E9A<SEP3>// <CJK>
0x8D4E<SEP>0x392F<SEP>0x5EB7<SEP3>// <CJK>
0x8D4F<SEP>0x3930<SEP>0x5F18<SEP3>// <CJK>
0x8D50<SEP>0x3931<SEP>0x6052<SEP3>// <CJK>
0x8D51<SEP>0x3932<SEP>0x614C<SEP3>// <CJK>
0x8D52<SEP>0x3933<SEP>0x6297<SEP3>// <CJK>
0x8D53<SEP>0x3934<SEP>0x62D8<SEP3>// <CJK>
0x8D54<SEP>0x3935<SEP>0x63A7<SEP3>// <CJK>
0x8D55<SEP>0x3936<SEP>0x653B<SEP3>// <CJK>
0x8D56<SEP>0x3937<SEP>0x6602<SEP3>// <CJK>
0x8D57<SEP>0x3938<SEP>0x6643<SEP3>// <CJK>
0x8D58<SEP>0x3939<SEP>0x66F4<SEP3>// <CJK>
0x8D59<SEP>0x393A<SEP>0x676D<SEP3>// <CJK>
0x8D5A<SEP>0x393B<SEP>0x6821<SEP3>// <CJK>
0x8D5B<SEP>0x393C<SEP>0x6897<SEP3>// <CJK>
0x8D5C<SEP>0x393D<SEP>0x69CB<SEP3>// <CJK>
0x8D5D<SEP>0x393E<SEP>0x6C5F<SEP3>// <CJK>
0x8D5E<SEP>0x393F<SEP>0x6D2A<SEP3>// <CJK>
0x8D5F<SEP>0x3940<SEP>0x6D69<SEP3>// <CJK>
0x8D60<SEP>0x3941<SEP>0x6E2F<SEP3>// <CJK>
0x8D61<SEP>0x3942<SEP>0x6E9D<SEP3>// <CJK>
0x8D62<SEP>0x3943<SEP>0x7532<SEP3>// <CJK>
0x8D63<SEP>0x3944<SEP>0x7687<SEP3>// <CJK>
0x8D64<SEP>0x3945<SEP>0x786C<SEP3>// <CJK>
0x8D65<SEP>0x3946<SEP>0x7A3F<SEP3>// <CJK>
0x8D66<SEP>0x3947<SEP>0x7CE0<SEP3>// <CJK>
0x8D67<SEP>0x3948<SEP>0x7D05<SEP3>// <CJK>
0x8D68<SEP>0x3949<SEP>0x7D18<SEP3>// <CJK>
0x8D69<SEP>0x394A<SEP>0x7D5E<SEP3>// <CJK>
0x8D6A<SEP>0x394B<SEP>0x7DB1<SEP3>// <CJK>
0x8D6B<SEP>0x394C<SEP>0x8015<SEP3>// <CJK>
0x8D6C<SEP>0x394D<SEP>0x8003<SEP3>// <CJK>
0x8D6D<SEP>0x394E<SEP>0x80AF<SEP3>// <CJK>
0x8D6E<SEP>0x394F<SEP>0x80B1<SEP3>// <CJK>
0x8D6F<SEP>0x3950<SEP>0x8154<SEP3>// <CJK>
0x8D70<SEP>0x3951<SEP>0x818F<SEP3>// <CJK>
0x8D71<SEP>0x3952<SEP>0x822A<SEP3>// <CJK>
0x8D72<SEP>0x3953<SEP>0x8352<SEP3>// <CJK>
0x8D73<SEP>0x3954<SEP>0x884C<SEP3>// <CJK>
0x8D74<SEP>0x3955<SEP>0x8861<SEP3>// <CJK>
0x8D75<SEP>0x3956<SEP>0x8B1B<SEP3>// <CJK>
0x8D76<SEP>0x3957<SEP>0x8CA2<SEP3>// <CJK>
0x8D77<SEP>0x3958<SEP>0x8CFC<SEP3>// <CJK>
0x8D78<SEP>0x3959<SEP>0x90CA<SEP3>// <CJK>
0x8D79<SEP>0x395A<SEP>0x9175<SEP3>// <CJK>
0x8D7A<SEP>0x395B<SEP>0x9271<SEP3>// <CJK>
0x8D7B<SEP>0x395C<SEP>0x783F<SEP3>// <CJK>
0x8D7C<SEP>0x395D<SEP>0x92FC<SEP3>// <CJK>
0x8D7D<SEP>0x395E<SEP>0x95A4<SEP3>// <CJK>
0x8D7E<SEP>0x395F<SEP>0x964D<SEP3>// <CJK>
0x8D80<SEP>0x3960<SEP>0x9805<SEP3>// <CJK>
0x8D81<SEP>0x3961<SEP>0x9999<SEP3>// <CJK>
0x8D82<SEP>0x3962<SEP>0x9AD8<SEP3>// <CJK>
0x8D83<SEP>0x3963<SEP>0x9D3B<SEP3>// <CJK>
0x8D84<SEP>0x3964<SEP>0x525B<SEP3>// <CJK>
0x8D85<SEP>0x3965<SEP>0x52AB<SEP3>// <CJK>
0x8D86<SEP>0x3966<SEP>0x53F7<SEP3>// <CJK>
0x8D87<SEP>0x3967<SEP>0x5408<SEP3>// <CJK>
0x8D88<SEP>0x3968<SEP>0x58D5<SEP3>// <CJK>
0x8D89<SEP>0x3969<SEP>0x62F7<SEP3>// <CJK>
0x8D8A<SEP>0x396A<SEP>0x6FE0<SEP3>// <CJK>
0x8D8B<SEP>0x396B<SEP>0x8C6A<SEP3>// <CJK>
0x8D8C<SEP>0x396C<SEP>0x8F5F<SEP3>// <CJK>
0x8D8D<SEP>0x396D<SEP>0x9EB9<SEP3>// <CJK>
0x8D8E<SEP>0x396E<SEP>0x514B<SEP3>// <CJK>
0x8D8F<SEP>0x396F<SEP>0x523B<SEP3>// <CJK>
0x8D90<SEP>0x3970<SEP>0x544A<SEP3>// <CJK>
0x8D91<SEP>0x3971<SEP>0x56FD<SEP3>// <CJK>
0x8D92<SEP>0x3972<SEP>0x7A40<SEP3>// <CJK>
0x8D93<SEP>0x3973<SEP>0x9177<SEP3>// <CJK>
0x8D94<SEP>0x3974<SEP>0x9D60<SEP3>// <CJK>
0x8D95<SEP>0x3975<SEP>0x9ED2<SEP3>// <CJK>
0x8D96<SEP>0x3976<SEP>0x7344<SEP3>// <CJK>
0x8D97<SEP>0x3977<SEP>0x6F09<SEP3>// <CJK>
0x8D98<SEP>0x3978<SEP>0x8170<SEP3>// <CJK>
0x8D99<SEP>0x3979<SEP>0x7511<SEP3>// <CJK>
0x8D9A<SEP>0x397A<SEP>0x5FFD<SEP3>// <CJK>
0x8D9B<SEP>0x397B<SEP>0x60DA<SEP3>// <CJK>
0x8D9C<SEP>0x397C<SEP>0x9AA8<SEP3>// <CJK>
0x8D9D<SEP>0x397D<SEP>0x72DB<SEP3>// <CJK>
0x8D9E<SEP>0x397E<SEP>0x8FBC<SEP3>// <CJK>
0x8D9F<SEP>0x3A21<SEP>0x6B64<SEP3>// <CJK>
0x8DA0<SEP>0x3A22<SEP>0x9803<SEP3>// <CJK>
0x8DA1<SEP>0x3A23<SEP>0x4ECA<SEP3>// <CJK>
0x8DA2<SEP>0x3A24<SEP>0x56F0<SEP3>// <CJK>
0x8DA3<SEP>0x3A25<SEP>0x5764<SEP3>// <CJK>
0x8DA4<SEP>0x3A26<SEP>0x58BE<SEP3>// <CJK>
0x8DA5<SEP>0x3A27<SEP>0x5A5A<SEP3>// <CJK>
0x8DA6<SEP>0x3A28<SEP>0x6068<SEP3>// <CJK>
0x8DA7<SEP>0x3A29<SEP>0x61C7<SEP3>// <CJK>
0x8DA8<SEP>0x3A2A<SEP>0x660F<SEP3>// <CJK>
0x8DA9<SEP>0x3A2B<SEP>0x6606<SEP3>// <CJK>
0x8DAA<SEP>0x3A2C<SEP>0x6839<SEP3>// <CJK>
0x8DAB<SEP>0x3A2D<SEP>0x68B1<SEP3>// <CJK>
0x8DAC<SEP>0x3A2E<SEP>0x6DF7<SEP3>// <CJK>
0x8DAD<SEP>0x3A2F<SEP>0x75D5<SEP3>// <CJK>
0x8DAE<SEP>0x3A30<SEP>0x7D3A<SEP3>// <CJK>
0x8DAF<SEP>0x3A31<SEP>0x826E<SEP3>// <CJK>
0x8DB0<SEP>0x3A32<SEP>0x9B42<SEP3>// <CJK>
0x8DB1<SEP>0x3A33<SEP>0x4E9B<SEP3>// <CJK>
0x8DB2<SEP>0x3A34<SEP>0x4F50<SEP3>// <CJK>
0x8DB3<SEP>0x3A35<SEP>0x53C9<SEP3>// <CJK>
0x8DB4<SEP>0x3A36<SEP>0x5506<SEP3>// <CJK>
0x8DB5<SEP>0x3A37<SEP>0x5D6F<SEP3>// <CJK>
0x8DB6<SEP>0x3A38<SEP>0x5DE6<SEP3>// <CJK>
0x8DB7<SEP>0x3A39<SEP>0x5DEE<SEP3>// <CJK>
0x8DB8<SEP>0x3A3A<SEP>0x67FB<SEP3>// <CJK>
0x8DB9<SEP>0x3A3B<SEP>0x6C99<SEP3>// <CJK>
0x8DBA<SEP>0x3A3C<SEP>0x7473<SEP3>// <CJK>
0x8DBB<SEP>0x3A3D<SEP>0x7802<SEP3>// <CJK>
0x8DBC<SEP>0x3A3E<SEP>0x8A50<SEP3>// <CJK>
0x8DBD<SEP>0x3A3F<SEP>0x9396<SEP3>// <CJK>
0x8DBE<SEP>0x3A40<SEP>0x88DF<SEP3>// <CJK>
0x8DBF<SEP>0x3A41<SEP>0x5750<SEP3>// <CJK>
0x8DC0<SEP>0x3A42<SEP>0x5EA7<SEP3>// <CJK>
0x8DC1<SEP>0x3A43<SEP>0x632B<SEP3>// <CJK>
0x8DC2<SEP>0x3A44<SEP>0x50B5<SEP3>// <CJK>
0x8DC3<SEP>0x3A45<SEP>0x50AC<SEP3>// <CJK>
0x8DC4<SEP>0x3A46<SEP>0x518D<SEP3>// <CJK>
0x8DC5<SEP>0x3A47<SEP>0x6700<SEP3>// <CJK>
0x8DC6<SEP>0x3A48<SEP>0x54C9<SEP3>// <CJK>
0x8DC7<SEP>0x3A49<SEP>0x585E<SEP3>// <CJK>
0x8DC8<SEP>0x3A4A<SEP>0x59BB<SEP3>// <CJK>
0x8DC9<SEP>0x3A4B<SEP>0x5BB0<SEP3>// <CJK>
0x8DCA<SEP>0x3A4C<SEP>0x5F69<SEP3>// <CJK>
0x8DCB<SEP>0x3A4D<SEP>0x624D<SEP3>// <CJK>
0x8DCC<SEP>0x3A4E<SEP>0x63A1<SEP3>// <CJK>
0x8DCD<SEP>0x3A4F<SEP>0x683D<SEP3>// <CJK>
0x8DCE<SEP>0x3A50<SEP>0x6B73<SEP3>// <CJK>
0x8DCF<SEP>0x3A51<SEP>0x6E08<SEP3>// <CJK>
0x8DD0<SEP>0x3A52<SEP>0x707D<SEP3>// <CJK>
0x8DD1<SEP>0x3A53<SEP>0x91C7<SEP3>// <CJK>
0x8DD2<SEP>0x3A54<SEP>0x7280<SEP3>// <CJK>
0x8DD3<SEP>0x3A55<SEP>0x7815<SEP3>// <CJK>
0x8DD4<SEP>0x3A56<SEP>0x7826<SEP3>// <CJK>
0x8DD5<SEP>0x3A57<SEP>0x796D<SEP3>// <CJK>
0x8DD6<SEP>0x3A58<SEP>0x658E<SEP3>// <CJK>
0x8DD7<SEP>0x3A59<SEP>0x7D30<SEP3>// <CJK>
0x8DD8<SEP>0x3A5A<SEP>0x83DC<SEP3>// <CJK>
0x8DD9<SEP>0x3A5B<SEP>0x88C1<SEP3>// <CJK>
0x8DDA<SEP>0x3A5C<SEP>0x8F09<SEP3>// <CJK>
0x8DDB<SEP>0x3A5D<SEP>0x969B<SEP3>// <CJK>
0x8DDC<SEP>0x3A5E<SEP>0x5264<SEP3>// <CJK>
0x8DDD<SEP>0x3A5F<SEP>0x5728<SEP3>// <CJK>
0x8DDE<SEP>0x3A60<SEP>0x6750<SEP3>// <CJK>
0x8DDF<SEP>0x3A61<SEP>0x7F6A<SEP3>// <CJK>
0x8DE0<SEP>0x3A62<SEP>0x8CA1<SEP3>// <CJK>
0x8DE1<SEP>0x3A63<SEP>0x51B4<SEP3>// <CJK>
0x8DE2<SEP>0x3A64<SEP>0x5742<SEP3>// <CJK>
0x8DE3<SEP>0x3A65<SEP>0x962A<SEP3>// <CJK>
0x8DE4<SEP>0x3A66<SEP>0x583A<SEP3>// <CJK>
0x8DE5<SEP>0x3A67<SEP>0x698A<SEP3>// <CJK>
0x8DE6<SEP>0x3A68<SEP>0x80B4<SEP3>// <CJK>
0x8DE7<SEP>0x3A69<SEP>0x54B2<SEP3>// <CJK>
0x8DE8<SEP>0x3A6A<SEP>0x5D0E<SEP3>// <CJK>
0x8DE9<SEP>0x3A6B<SEP>0x57FC<SEP3>// <CJK>
0x8DEA<SEP>0x3A6C<SEP>0x7895<SEP3>// <CJK>
0x8DEB<SEP>0x3A6D<SEP>0x9DFA<SEP3>// <CJK>
0x8DEC<SEP>0x3A6E<SEP>0x4F5C<SEP3>// <CJK>
0x8DED<SEP>0x3A6F<SEP>0x524A<SEP3>// <CJK>
0x8DEE<SEP>0x3A70<SEP>0x548B<SEP3>// <CJK>
0x8DEF<SEP>0x3A71<SEP>0x643E<SEP3>// <CJK>
0x8DF0<SEP>0x3A72<SEP>0x6628<SEP3>// <CJK>
0x8DF1<SEP>0x3A73<SEP>0x6714<SEP3>// <CJK>
0x8DF2<SEP>0x3A74<SEP>0x67F5<SEP3>// <CJK>
0x8DF3<SEP>0x3A75<SEP>0x7A84<SEP3>// <CJK>
0x8DF4<SEP>0x3A76<SEP>0x7B56<SEP3>// <CJK>
0x8DF5<SEP>0x3A77<SEP>0x7D22<SEP3>// <CJK>
0x8DF6<SEP>0x3A78<SEP>0x932F<SEP3>// <CJK>
0x8DF7<SEP>0x3A79<SEP>0x685C<SEP3>// <CJK>
0x8DF8<SEP>0x3A7A<SEP>0x9BAD<SEP3>// <CJK>
0x8DF9<SEP>0x3A7B<SEP>0x7B39<SEP3>// <CJK>
0x8DFA<SEP>0x3A7C<SEP>0x5319<SEP3>// <CJK>
0x8DFB<SEP>0x3A7D<SEP>0x518A<SEP3>// <CJK>
0x8DFC<SEP>0x3A7E<SEP>0x5237<SEP3>// <CJK>
0x8E40<SEP>0x3B21<SEP>0x5BDF<SEP3>// <CJK>
0x8E41<SEP>0x3B22<SEP>0x62F6<SEP3>// <CJK>
0x8E42<SEP>0x3B23<SEP>0x64AE<SEP3>// <CJK>
0x8E43<SEP>0x3B24<SEP>0x64E6<SEP3>// <CJK>
0x8E44<SEP>0x3B25<SEP>0x672D<SEP3>// <CJK>
0x8E45<SEP>0x3B26<SEP>0x6BBA<SEP3>// <CJK>
0x8E46<SEP>0x3B27<SEP>0x85A9<SEP3>// <CJK>
0x8E47<SEP>0x3B28<SEP>0x96D1<SEP3>// <CJK>
0x8E48<SEP>0x3B29<SEP>0x7690<SEP3>// <CJK>
0x8E49<SEP>0x3B2A<SEP>0x9BD6<SEP3>// <CJK>
0x8E4A<SEP>0x3B2B<SEP>0x634C<SEP3>// <CJK>
0x8E4B<SEP>0x3B2C<SEP>0x9306<SEP3>// <CJK>
0x8E4C<SEP>0x3B2D<SEP>0x9BAB<SEP3>// <CJK>
0x8E4D<SEP>0x3B2E<SEP>0x76BF<SEP3>// <CJK>
0x8E4E<SEP>0x3B2F<SEP>0x6652<SEP3>// <CJK>
0x8E4F<SEP>0x3B30<SEP>0x4E09<SEP3>// <CJK>
0x8E50<SEP>0x3B31<SEP>0x5098<SEP3>// <CJK>
0x8E51<SEP>0x3B32<SEP>0x53C2<SEP3>// <CJK>
0x8E52<SEP>0x3B33<SEP>0x5C71<SEP3>// <CJK>
0x8E53<SEP>0x3B34<SEP>0x60E8<SEP3>// <CJK>
0x8E54<SEP>0x3B35<SEP>0x6492<SEP3>// <CJK>
0x8E55<SEP>0x3B36<SEP>0x6563<SEP3>// <CJK>
0x8E56<SEP>0x3B37<SEP>0x685F<SEP3>// <CJK>
0x8E57<SEP>0x3B38<SEP>0x71E6<SEP3>// <CJK>
0x8E58<SEP>0x3B39<SEP>0x73CA<SEP3>// <CJK>
0x8E59<SEP>0x3B3A<SEP>0x7523<SEP3>// <CJK>
0x8E5A<SEP>0x3B3B<SEP>0x7B97<SEP3>// <CJK>
0x8E5B<SEP>0x3B3C<SEP>0x7E82<SEP3>// <CJK>
0x8E5C<SEP>0x3B3D<SEP>0x8695<SEP3>// <CJK>
0x8E5D<SEP>0x3B3E<SEP>0x8B83<SEP3>// <CJK>
0x8E5E<SEP>0x3B3F<SEP>0x8CDB<SEP3>// <CJK>
0x8E5F<SEP>0x3B40<SEP>0x9178<SEP3>// <CJK>
0x8E60<SEP>0x3B41<SEP>0x9910<SEP3>// <CJK>
0x8E61<SEP>0x3B42<SEP>0x65AC<SEP3>// <CJK>
0x8E62<SEP>0x3B43<SEP>0x66AB<SEP3>// <CJK>
0x8E63<SEP>0x3B44<SEP>0x6B8B<SEP3>// <CJK>
0x8E64<SEP>0x3B45<SEP>0x4ED5<SEP3>// <CJK>
0x8E65<SEP>0x3B46<SEP>0x4ED4<SEP3>// <CJK>
0x8E66<SEP>0x3B47<SEP>0x4F3A<SEP3>// <CJK>
0x8E67<SEP>0x3B48<SEP>0x4F7F<SEP3>// <CJK>
0x8E68<SEP>0x3B49<SEP>0x523A<SEP3>// <CJK>
0x8E69<SEP>0x3B4A<SEP>0x53F8<SEP3>// <CJK>
0x8E6A<SEP>0x3B4B<SEP>0x53F2<SEP3>// <CJK>
0x8E6B<SEP>0x3B4C<SEP>0x55E3<SEP3>// <CJK>
0x8E6C<SEP>0x3B4D<SEP>0x56DB<SEP3>// <CJK>
0x8E6D<SEP>0x3B4E<SEP>0x58EB<SEP3>// <CJK>
0x8E6E<SEP>0x3B4F<SEP>0x59CB<SEP3>// <CJK>
0x8E6F<SEP>0x3B50<SEP>0x59C9<SEP3>// <CJK>
0x8E70<SEP>0x3B51<SEP>0x59FF<SEP3>// <CJK>
0x8E71<SEP>0x3B52<SEP>0x5B50<SEP3>// <CJK>
0x8E72<SEP>0x3B53<SEP>0x5C4D<SEP3>// <CJK>
0x8E73<SEP>0x3B54<SEP>0x5E02<SEP3>// <CJK>
0x8E74<SEP>0x3B55<SEP>0x5E2B<SEP3>// <CJK>
0x8E75<SEP>0x3B56<SEP>0x5FD7<SEP3>// <CJK>
0x8E76<SEP>0x3B57<SEP>0x601D<SEP3>// <CJK>
0x8E77<SEP>0x3B58<SEP>0x6307<SEP3>// <CJK>
0x8E78<SEP>0x3B59<SEP>0x652F<SEP3>// <CJK>
0x8E79<SEP>0x3B5A<SEP>0x5B5C<SEP3>// <CJK>
0x8E7A<SEP>0x3B5B<SEP>0x65AF<SEP3>// <CJK>
0x8E7B<SEP>0x3B5C<SEP>0x65BD<SEP3>// <CJK>
0x8E7C<SEP>0x3B5D<SEP>0x65E8<SEP3>// <CJK>
0x8E7D<SEP>0x3B5E<SEP>0x679D<SEP3>// <CJK>
0x8E7E<SEP>0x3B5F<SEP>0x6B62<SEP3>// <CJK>
0x8E80<SEP>0x3B60<SEP>0x6B7B<SEP3>// <CJK>
0x8E81<SEP>0x3B61<SEP>0x6C0F<SEP3>// <CJK>
0x8E82<SEP>0x3B62<SEP>0x7345<SEP3>// <CJK>
0x8E83<SEP>0x3B63<SEP>0x7949<SEP3>// <CJK>
0x8E84<SEP>0x3B64<SEP>0x79C1<SEP3>// <CJK>
0x8E85<SEP>0x3B65<SEP>0x7CF8<SEP3>// <CJK>
0x8E86<SEP>0x3B66<SEP>0x7D19<SEP3>// <CJK>
0x8E87<SEP>0x3B67<SEP>0x7D2B<SEP3>// <CJK>
0x8E88<SEP>0x3B68<SEP>0x80A2<SEP3>// <CJK>
0x8E89<SEP>0x3B69<SEP>0x8102<SEP3>// <CJK>
0x8E8A<SEP>0x3B6A<SEP>0x81F3<SEP3>// <CJK>
0x8E8B<SEP>0x3B6B<SEP>0x8996<SEP3>// <CJK>
0x8E8C<SEP>0x3B6C<SEP>0x8A5E<SEP3>// <CJK>
0x8E8D<SEP>0x3B6D<SEP>0x8A69<SEP3>// <CJK>
0x8E8E<SEP>0x3B6E<SEP>0x8A66<SEP3>// <CJK>
0x8E8F<SEP>0x3B6F<SEP>0x8A8C<SEP3>// <CJK>
0x8E90<SEP>0x3B70<SEP>0x8AEE<SEP3>// <CJK>
0x8E91<SEP>0x3B71<SEP>0x8CC7<SEP3>// <CJK>
0x8E92<SEP>0x3B72<SEP>0x8CDC<SEP3>// <CJK>
0x8E93<SEP>0x3B73<SEP>0x96CC<SEP3>// <CJK>
0x8E94<SEP>0x3B74<SEP>0x98FC<SEP3>// <CJK>
0x8E95<SEP>0x3B75<SEP>0x6B6F<SEP3>// <CJK>
0x8E96<SEP>0x3B76<SEP>0x4E8B<SEP3>// <CJK>
0x8E97<SEP>0x3B77<SEP>0x4F3C<SEP3>// <CJK>
0x8E98<SEP>0x3B78<SEP>0x4F8D<SEP3>// <CJK>
0x8E99<SEP>0x3B79<SEP>0x5150<SEP3>// <CJK>
0x8E9A<SEP>0x3B7A<SEP>0x5B57<SEP3>// <CJK>
0x8E9B<SEP>0x3B7B<SEP>0x5BFA<SEP3>// <CJK>
0x8E9C<SEP>0x3B7C<SEP>0x6148<SEP3>// <CJK>
0x8E9D<SEP>0x3B7D<SEP>0x6301<SEP3>// <CJK>
0x8E9E<SEP>0x3B7E<SEP>0x6642<SEP3>// <CJK>
0x8E9F<SEP>0x3C21<SEP>0x6B21<SEP3>// <CJK>
0x8EA0<SEP>0x3C22<SEP>0x6ECB<SEP3>// <CJK>
0x8EA1<SEP>0x3C23<SEP>0x6CBB<SEP3>// <CJK>
0x8EA2<SEP>0x3C24<SEP>0x723E<SEP3>// <CJK>
0x8EA3<SEP>0x3C25<SEP>0x74BD<SEP3>// <CJK>
0x8EA4<SEP>0x3C26<SEP>0x75D4<SEP3>// <CJK>
0x8EA5<SEP>0x3C27<SEP>0x78C1<SEP3>// <CJK>
0x8EA6<SEP>0x3C28<SEP>0x793A<SEP3>// <CJK>
0x8EA7<SEP>0x3C29<SEP>0x800C<SEP3>// <CJK>
0x8EA8<SEP>0x3C2A<SEP>0x8033<SEP3>// <CJK>
0x8EA9<SEP>0x3C2B<SEP>0x81EA<SEP3>// <CJK>
0x8EAA<SEP>0x3C2C<SEP>0x8494<SEP3>// <CJK>
0x8EAB<SEP>0x3C2D<SEP>0x8F9E<SEP3>// <CJK>
0x8EAC<SEP>0x3C2E<SEP>0x6C50<SEP3>// <CJK>
0x8EAD<SEP>0x3C2F<SEP>0x9E7F<SEP3>// <CJK>
0x8EAE<SEP>0x3C30<SEP>0x5F0F<SEP3>// <CJK>
0x8EAF<SEP>0x3C31<SEP>0x8B58<SEP3>// <CJK>
0x8EB0<SEP>0x3C32<SEP>0x9D2B<SEP3>// <CJK>
0x8EB1<SEP>0x3C33<SEP>0x7AFA<SEP3>// <CJK>
0x8EB2<SEP>0x3C34<SEP>0x8EF8<SEP3>// <CJK>
0x8EB3<SEP>0x3C35<SEP>0x5B8D<SEP3>// <CJK>
0x8EB4<SEP>0x3C36<SEP>0x96EB<SEP3>// <CJK>
0x8EB5<SEP>0x3C37<SEP>0x4E03<SEP3>// <CJK>
0x8EB6<SEP>0x3C38<SEP>0x53F1<SEP3>// <CJK>
0x8EB7<SEP>0x3C39<SEP>0x57F7<SEP3>// <CJK>
0x8EB8<SEP>0x3C3A<SEP>0x5931<SEP3>// <CJK>
0x8EB9<SEP>0x3C3B<SEP>0x5AC9<SEP3>// <CJK>
0x8EBA<SEP>0x3C3C<SEP>0x5BA4<SEP3>// <CJK>
0x8EBB<SEP>0x3C3D<SEP>0x6089<SEP3>// <CJK>
0x8EBC<SEP>0x3C3E<SEP>0x6E7F<SEP3>// <CJK>
0x8EBD<SEP>0x3C3F<SEP>0x6F06<SEP3>// <CJK>
0x8EBE<SEP>0x3C40<SEP>0x75BE<SEP3>// <CJK>
0x8EBF<SEP>0x3C41<SEP>0x8CEA<SEP3>// <CJK>
0x8EC0<SEP>0x3C42<SEP>0x5B9F<SEP3>// <CJK>
0x8EC1<SEP>0x3C43<SEP>0x8500<SEP3>// <CJK>
0x8EC2<SEP>0x3C44<SEP>0x7BE0<SEP3>// <CJK>
0x8EC3<SEP>0x3C45<SEP>0x5072<SEP3>// <CJK>
0x8EC4<SEP>0x3C46<SEP>0x67F4<SEP3>// <CJK>
0x8EC5<SEP>0x3C47<SEP>0x829D<SEP3>// <CJK>
0x8EC6<SEP>0x3C48<SEP>0x5C61<SEP3>// <CJK>
0x8EC7<SEP>0x3C49<SEP>0x854A<SEP3>// <CJK>
0x8EC8<SEP>0x3C4A<SEP>0x7E1E<SEP3>// <CJK>
0x8EC9<SEP>0x3C4B<SEP>0x820E<SEP3>// <CJK>
0x8ECA<SEP>0x3C4C<SEP>0x5199<SEP3>// <CJK>
0x8ECB<SEP>0x3C4D<SEP>0x5C04<SEP3>// <CJK>
0x8ECC<SEP>0x3C4E<SEP>0x6368<SEP3>// <CJK>
0x8ECD<SEP>0x3C4F<SEP>0x8D66<SEP3>// <CJK>
0x8ECE<SEP>0x3C50<SEP>0x659C<SEP3>// <CJK>
0x8ECF<SEP>0x3C51<SEP>0x716E<SEP3>// <CJK>
0x8ED0<SEP>0x3C52<SEP>0x793E<SEP3>// <CJK>
0x8ED1<SEP>0x3C53<SEP>0x7D17<SEP3>// <CJK>
0x8ED2<SEP>0x3C54<SEP>0x8005<SEP3>// <CJK>
0x8ED3<SEP>0x3C55<SEP>0x8B1D<SEP3>// <CJK>
0x8ED4<SEP>0x3C56<SEP>0x8ECA<SEP3>// <CJK>
0x8ED5<SEP>0x3C57<SEP>0x906E<SEP3>// <CJK>
0x8ED6<SEP>0x3C58<SEP>0x86C7<SEP3>// <CJK>
0x8ED7<SEP>0x3C59<SEP>0x90AA<SEP3>// <CJK>
0x8ED8<SEP>0x3C5A<SEP>0x501F<SEP3>// <CJK>
0x8ED9<SEP>0x3C5B<SEP>0x52FA<SEP3>// <CJK>
0x8EDA<SEP>0x3C5C<SEP>0x5C3A<SEP3>// <CJK>
0x8EDB<SEP>0x3C5D<SEP>0x6753<SEP3>// <CJK>
0x8EDC<SEP>0x3C5E<SEP>0x707C<SEP3>// <CJK>
0x8EDD<SEP>0x3C5F<SEP>0x7235<SEP3>// <CJK>
0x8EDE<SEP>0x3C60<SEP>0x914C<SEP3>// <CJK>
0x8EDF<SEP>0x3C61<SEP>0x91C8<SEP3>// <CJK>
0x8EE0<SEP>0x3C62<SEP>0x932B<SEP3>// <CJK>
0x8EE1<SEP>0x3C63<SEP>0x82E5<SEP3>// <CJK>
0x8EE2<SEP>0x3C64<SEP>0x5BC2<SEP3>// <CJK>
0x8EE3<SEP>0x3C65<SEP>0x5F31<SEP3>// <CJK>
0x8EE4<SEP>0x3C66<SEP>0x60F9<SEP3>// <CJK>
0x8EE5<SEP>0x3C67<SEP>0x4E3B<SEP3>// <CJK>
0x8EE6<SEP>0x3C68<SEP>0x53D6<SEP3>// <CJK>
0x8EE7<SEP>0x3C69<SEP>0x5B88<SEP3>// <CJK>
0x8EE8<SEP>0x3C6A<SEP>0x624B<SEP3>// <CJK>
0x8EE9<SEP>0x3C6B<SEP>0x6731<SEP3>// <CJK>
0x8EEA<SEP>0x3C6C<SEP>0x6B8A<SEP3>// <CJK>
0x8EEB<SEP>0x3C6D<SEP>0x72E9<SEP3>// <CJK>
0x8EEC<SEP>0x3C6E<SEP>0x73E0<SEP3>// <CJK>
0x8EED<SEP>0x3C6F<SEP>0x7A2E<SEP3>// <CJK>
0x8EEE<SEP>0x3C70<SEP>0x816B<SEP3>// <CJK>
0x8EEF<SEP>0x3C71<SEP>0x8DA3<SEP3>// <CJK>
0x8EF0<SEP>0x3C72<SEP>0x9152<SEP3>// <CJK>
0x8EF1<SEP>0x3C73<SEP>0x9996<SEP3>// <CJK>
0x8EF2<SEP>0x3C74<SEP>0x5112<SEP3>// <CJK>
0x8EF3<SEP>0x3C75<SEP>0x53D7<SEP3>// <CJK>
0x8EF4<SEP>0x3C76<SEP>0x546A<SEP3>// <CJK>
0x8EF5<SEP>0x3C77<SEP>0x5BFF<SEP3>// <CJK>
0x8EF6<SEP>0x3C78<SEP>0x6388<SEP3>// <CJK>
0x8EF7<SEP>0x3C79<SEP>0x6A39<SEP3>// <CJK>
0x8EF8<SEP>0x3C7A<SEP>0x7DAC<SEP3>// <CJK>
0x8EF9<SEP>0x3C7B<SEP>0x9700<SEP3>// <CJK>
0x8EFA<SEP>0x3C7C<SEP>0x56DA<SEP3>// <CJK>
0x8EFB<SEP>0x3C7D<SEP>0x53CE<SEP3>// <CJK>
0x8EFC<SEP>0x3C7E<SEP>0x5468<SEP3>// <CJK>
0x8F40<SEP>0x3D21<SEP>0x5B97<SEP3>// <CJK>
0x8F41<SEP>0x3D22<SEP>0x5C31<SEP3>// <CJK>
0x8F42<SEP>0x3D23<SEP>0x5DDE<SEP3>// <CJK>
0x8F43<SEP>0x3D24<SEP>0x4FEE<SEP3>// <CJK>
0x8F44<SEP>0x3D25<SEP>0x6101<SEP3>// <CJK>
0x8F45<SEP>0x3D26<SEP>0x62FE<SEP3>// <CJK>
0x8F46<SEP>0x3D27<SEP>0x6D32<SEP3>// <CJK>
0x8F47<SEP>0x3D28<SEP>0x79C0<SEP3>// <CJK>
0x8F48<SEP>0x3D29<SEP>0x79CB<SEP3>// <CJK>
0x8F49<SEP>0x3D2A<SEP>0x7D42<SEP3>// <CJK>
0x8F4A<SEP>0x3D2B<SEP>0x7E4D<SEP3>// <CJK>
0x8F4B<SEP>0x3D2C<SEP>0x7FD2<SEP3>// <CJK>
0x8F4C<SEP>0x3D2D<SEP>0x81ED<SEP3>// <CJK>
0x8F4D<SEP>0x3D2E<SEP>0x821F<SEP3>// <CJK>
0x8F4E<SEP>0x3D2F<SEP>0x8490<SEP3>// <CJK>
0x8F4F<SEP>0x3D30<SEP>0x8846<SEP3>// <CJK>
0x8F50<SEP>0x3D31<SEP>0x8972<SEP3>// <CJK>
0x8F51<SEP>0x3D32<SEP>0x8B90<SEP3>// <CJK>
0x8F52<SEP>0x3D33<SEP>0x8E74<SEP3>// <CJK>
0x8F53<SEP>0x3D34<SEP>0x8F2F<SEP3>// <CJK>
0x8F54<SEP>0x3D35<SEP>0x9031<SEP3>// <CJK>
0x8F55<SEP>0x3D36<SEP>0x914B<SEP3>// <CJK>
0x8F56<SEP>0x3D37<SEP>0x916C<SEP3>// <CJK>
0x8F57<SEP>0x3D38<SEP>0x96C6<SEP3>// <CJK>
0x8F58<SEP>0x3D39<SEP>0x919C<SEP3>// <CJK>
0x8F59<SEP>0x3D3A<SEP>0x4EC0<SEP3>// <CJK>
0x8F5A<SEP>0x3D3B<SEP>0x4F4F<SEP3>// <CJK>
0x8F5B<SEP>0x3D3C<SEP>0x5145<SEP3>// <CJK>
0x8F5C<SEP>0x3D3D<SEP>0x5341<SEP3>// <CJK>
0x8F5D<SEP>0x3D3E<SEP>0x5F93<SEP3>// <CJK>
0x8F5E<SEP>0x3D3F<SEP>0x620E<SEP3>// <CJK>
0x8F5F<SEP>0x3D40<SEP>0x67D4<SEP3>// <CJK>
0x8F60<SEP>0x3D41<SEP>0x6C41<SEP3>// <CJK>
0x8F61<SEP>0x3D42<SEP>0x6E0B<SEP3>// <CJK>
0x8F62<SEP>0x3D43<SEP>0x7363<SEP3>// <CJK>
0x8F63<SEP>0x3D44<SEP>0x7E26<SEP3>// <CJK>
0x8F64<SEP>0x3D45<SEP>0x91CD<SEP3>// <CJK>
0x8F65<SEP>0x3D46<SEP>0x9283<SEP3>// <CJK>
0x8F66<SEP>0x3D47<SEP>0x53D4<SEP3>// <CJK>
0x8F67<SEP>0x3D48<SEP>0x5919<SEP3>// <CJK>
0x8F68<SEP>0x3D49<SEP>0x5BBF<SEP3>// <CJK>
0x8F69<SEP>0x3D4A<SEP>0x6DD1<SEP3>// <CJK>
0x8F6A<SEP>0x3D4B<SEP>0x795D<SEP3>// <CJK>
0x8F6B<SEP>0x3D4C<SEP>0x7E2E<SEP3>// <CJK>
0x8F6C<SEP>0x3D4D<SEP>0x7C9B<SEP3>// <CJK>
0x8F6D<SEP>0x3D4E<SEP>0x587E<SEP3>// <CJK>
0x8F6E<SEP>0x3D4F<SEP>0x719F<SEP3>// <CJK>
0x8F6F<SEP>0x3D50<SEP>0x51FA<SEP3>// <CJK>
0x8F70<SEP>0x3D51<SEP>0x8853<SEP3>// <CJK>
0x8F71<SEP>0x3D52<SEP>0x8FF0<SEP3>// <CJK>
0x8F72<SEP>0x3D53<SEP>0x4FCA<SEP3>// <CJK>
0x8F73<SEP>0x3D54<SEP>0x5CFB<SEP3>// <CJK>
0x8F74<SEP>0x3D55<SEP>0x6625<SEP3>// <CJK>
0x8F75<SEP>0x3D56<SEP>0x77AC<SEP3>// <CJK>
0x8F76<SEP>0x3D57<SEP>0x7AE3<SEP3>// <CJK>
0x8F77<SEP>0x3D58<SEP>0x821C<SEP3>// <CJK>
0x8F78<SEP>0x3D59<SEP>0x99FF<SEP3>// <CJK>
0x8F79<SEP>0x3D5A<SEP>0x51C6<SEP3>// <CJK>
0x8F7A<SEP>0x3D5B<SEP>0x5FAA<SEP3>// <CJK>
0x8F7B<SEP>0x3D5C<SEP>0x65EC<SEP3>// <CJK>
0x8F7C<SEP>0x3D5D<SEP>0x696F<SEP3>// <CJK>
0x8F7D<SEP>0x3D5E<SEP>0x6B89<SEP3>// <CJK>
0x8F7E<SEP>0x3D5F<SEP>0x6DF3<SEP3>// <CJK>
0x8F80<SEP>0x3D60<SEP>0x6E96<SEP3>// <CJK>
0x8F81<SEP>0x3D61<SEP>0x6F64<SEP3>// <CJK>
0x8F82<SEP>0x3D62<SEP>0x76FE<SEP3>// <CJK>
0x8F83<SEP>0x3D63<SEP>0x7D14<SEP3>// <CJK>
0x8F84<SEP>0x3D64<SEP>0x5DE1<SEP3>// <CJK>
0x8F85<SEP>0x3D65<SEP>0x9075<SEP3>// <CJK>
0x8F86<SEP>0x3D66<SEP>0x9187<SEP3>// <CJK>
0x8F87<SEP>0x3D67<SEP>0x9806<SEP3>// <CJK>
0x8F88<SEP>0x3D68<SEP>0x51E6<SEP3>// <CJK>
0x8F89<SEP>0x3D69<SEP>0x521D<SEP3>// <CJK>
0x8F8A<SEP>0x3D6A<SEP>0x6240<SEP3>// <CJK>
0x8F8B<SEP>0x3D6B<SEP>0x6691<SEP3>// <CJK>
0x8F8C<SEP>0x3D6C<SEP>0x66D9<SEP3>// <CJK>
0x8F8D<SEP>0x3D6D<SEP>0x6E1A<SEP3>// <CJK>
0x8F8E<SEP>0x3D6E<SEP>0x5EB6<SEP3>// <CJK>
0x8F8F<SEP>0x3D6F<SEP>0x7DD2<SEP3>// <CJK>
0x8F90<SEP>0x3D70<SEP>0x7F72<SEP3>// <CJK>
0x8F91<SEP>0x3D71<SEP>0x66F8<SEP3>// <CJK>
0x8F92<SEP>0x3D72<SEP>0x85AF<SEP3>// <CJK>
0x8F93<SEP>0x3D73<SEP>0x85F7<SEP3>// <CJK>
0x8F94<SEP>0x3D74<SEP>0x8AF8<SEP3>// <CJK>
0x8F95<SEP>0x3D75<SEP>0x52A9<SEP3>// <CJK>
0x8F96<SEP>0x3D76<SEP>0x53D9<SEP3>// <CJK>
0x8F97<SEP>0x3D77<SEP>0x5973<SEP3>// <CJK>
0x8F98<SEP>0x3D78<SEP>0x5E8F<SEP3>// <CJK>
0x8F99<SEP>0x3D79<SEP>0x5F90<SEP3>// <CJK>
0x8F9A<SEP>0x3D7A<SEP>0x6055<SEP3>// <CJK>
0x8F9B<SEP>0x3D7B<SEP>0x92E4<SEP3>// <CJK>
0x8F9C<SEP>0x3D7C<SEP>0x9664<SEP3>// <CJK>
0x8F9D<SEP>0x3D7D<SEP>0x50B7<SEP3>// <CJK>
0x8F9E<SEP>0x3D7E<SEP>0x511F<SEP3>// <CJK>
0x8F9F<SEP>0x3E21<SEP>0x52DD<SEP3>// <CJK>
0x8FA0<SEP>0x3E22<SEP>0x5320<SEP3>// <CJK>
0x8FA1<SEP>0x3E23<SEP>0x5347<SEP3>// <CJK>
0x8FA2<SEP>0x3E24<SEP>0x53EC<SEP3>// <CJK>
0x8FA3<SEP>0x3E25<SEP>0x54E8<SEP3>// <CJK>
0x8FA4<SEP>0x3E26<SEP>0x5546<SEP3>// <CJK>
0x8FA5<SEP>0x3E27<SEP>0x5531<SEP3>// <CJK>
0x8FA6<SEP>0x3E28<SEP>0x5617<SEP3>// <CJK>
0x8FA7<SEP>0x3E29<SEP>0x5968<SEP3>// <CJK>
0x8FA8<SEP>0x3E2A<SEP>0x59BE<SEP3>// <CJK>
0x8FA9<SEP>0x3E2B<SEP>0x5A3C<SEP3>// <CJK>
0x8FAA<SEP>0x3E2C<SEP>0x5BB5<SEP3>// <CJK>
0x8FAB<SEP>0x3E2D<SEP>0x5C06<SEP3>// <CJK>
0x8FAC<SEP>0x3E2E<SEP>0x5C0F<SEP3>// <CJK>
0x8FAD<SEP>0x3E2F<SEP>0x5C11<SEP3>// <CJK>
0x8FAE<SEP>0x3E30<SEP>0x5C1A<SEP3>// <CJK>
0x8FAF<SEP>0x3E31<SEP>0x5E84<SEP3>// <CJK>
0x8FB0<SEP>0x3E32<SEP>0x5E8A<SEP3>// <CJK>
0x8FB1<SEP>0x3E33<SEP>0x5EE0<SEP3>// <CJK>
0x8FB2<SEP>0x3E34<SEP>0x5F70<SEP3>// <CJK>
0x8FB3<SEP>0x3E35<SEP>0x627F<SEP3>// <CJK>
0x8FB4<SEP>0x3E36<SEP>0x6284<SEP3>// <CJK>
0x8FB5<SEP>0x3E37<SEP>0x62DB<SEP3>// <CJK>
0x8FB6<SEP>0x3E38<SEP>0x638C<SEP3>// <CJK>
0x8FB7<SEP>0x3E39<SEP>0x6377<SEP3>// <CJK>
0x8FB8<SEP>0x3E3A<SEP>0x6607<SEP3>// <CJK>
0x8FB9<SEP>0x3E3B<SEP>0x660C<SEP3>// <CJK>
0x8FBA<SEP>0x3E3C<SEP>0x662D<SEP3>// <CJK>
0x8FBB<SEP>0x3E3D<SEP>0x6676<SEP3>// <CJK>
0x8FBC<SEP>0x3E3E<SEP>0x677E<SEP3>// <CJK>
0x8FBD<SEP>0x3E3F<SEP>0x68A2<SEP3>// <CJK>
0x8FBE<SEP>0x3E40<SEP>0x6A1F<SEP3>// <CJK>
0x8FBF<SEP>0x3E41<SEP>0x6A35<SEP3>// <CJK>
0x8FC0<SEP>0x3E42<SEP>0x6CBC<SEP3>// <CJK>
0x8FC1<SEP>0x3E43<SEP>0x6D88<SEP3>// <CJK>
0x8FC2<SEP>0x3E44<SEP>0x6E09<SEP3>// <CJK>
0x8FC3<SEP>0x3E45<SEP>0x6E58<SEP3>// <CJK>
0x8FC4<SEP>0x3E46<SEP>0x713C<SEP3>// <CJK>
0x8FC5<SEP>0x3E47<SEP>0x7126<SEP3>// <CJK>
0x8FC6<SEP>0x3E48<SEP>0x7167<SEP3>// <CJK>
0x8FC7<SEP>0x3E49<SEP>0x75C7<SEP3>// <CJK>
0x8FC8<SEP>0x3E4A<SEP>0x7701<SEP3>// <CJK>
0x8FC9<SEP>0x3E4B<SEP>0x785D<SEP3>// <CJK>
0x8FCA<SEP>0x3E4C<SEP>0x7901<SEP3>// <CJK>
0x8FCB<SEP>0x3E4D<SEP>0x7965<SEP3>// <CJK>
0x8FCC<SEP>0x3E4E<SEP>0x79F0<SEP3>// <CJK>
0x8FCD<SEP>0x3E4F<SEP>0x7AE0<SEP3>// <CJK>
0x8FCE<SEP>0x3E50<SEP>0x7B11<SEP3>// <CJK>
0x8FCF<SEP>0x3E51<SEP>0x7CA7<SEP3>// <CJK>
0x8FD0<SEP>0x3E52<SEP>0x7D39<SEP3>// <CJK>
0x8FD1<SEP>0x3E53<SEP>0x8096<SEP3>// <CJK>
0x8FD2<SEP>0x3E54<SEP>0x83D6<SEP3>// <CJK>
0x8FD3<SEP>0x3E55<SEP>0x848B<SEP3>// <CJK>
0x8FD4<SEP>0x3E56<SEP>0x8549<SEP3>// <CJK>
0x8FD5<SEP>0x3E57<SEP>0x885D<SEP3>// <CJK>
0x8FD6<SEP>0x3E58<SEP>0x88F3<SEP3>// <CJK>
0x8FD7<SEP>0x3E59<SEP>0x8A1F<SEP3>// <CJK>
0x8FD8<SEP>0x3E5A<SEP>0x8A3C<SEP3>// <CJK>
0x8FD9<SEP>0x3E5B<SEP>0x8A54<SEP3>// <CJK>
0x8FDA<SEP>0x3E5C<SEP>0x8A73<SEP3>// <CJK>
0x8FDB<SEP>0x3E5D<SEP>0x8C61<SEP3>// <CJK>
0x8FDC<SEP>0x3E5E<SEP>0x8CDE<SEP3>// <CJK>
0x8FDD<SEP>0x3E5F<SEP>0x91A4<SEP3>// <CJK>
0x8FDE<SEP>0x3E60<SEP>0x9266<SEP3>// <CJK>
0x8FDF<SEP>0x3E61<SEP>0x937E<SEP3>// <CJK>
0x8FE0<SEP>0x3E62<SEP>0x9418<SEP3>// <CJK>
0x8FE1<SEP>0x3E63<SEP>0x969C<SEP3>// <CJK>
0x8FE2<SEP>0x3E64<SEP>0x9798<SEP3>// <CJK>
0x8FE3<SEP>0x3E65<SEP>0x4E0A<SEP3>// <CJK>
0x8FE4<SEP>0x3E66<SEP>0x4E08<SEP3>// <CJK>
0x8FE5<SEP>0x3E67<SEP>0x4E1E<SEP3>// <CJK>
0x8FE6<SEP>0x3E68<SEP>0x4E57<SEP3>// <CJK>
0x8FE7<SEP>0x3E69<SEP>0x5197<SEP3>// <CJK>
0x8FE8<SEP>0x3E6A<SEP>0x5270<SEP3>// <CJK>
0x8FE9<SEP>0x3E6B<SEP>0x57CE<SEP3>// <CJK>
0x8FEA<SEP>0x3E6C<SEP>0x5834<SEP3>// <CJK>
0x8FEB<SEP>0x3E6D<SEP>0x58CC<SEP3>// <CJK>
0x8FEC<SEP>0x3E6E<SEP>0x5B22<SEP3>// <CJK>
0x8FED<SEP>0x3E6F<SEP>0x5E38<SEP3>// <CJK>
0x8FEE<SEP>0x3E70<SEP>0x60C5<SEP3>// <CJK>
0x8FEF<SEP>0x3E71<SEP>0x64FE<SEP3>// <CJK>
0x8FF0<SEP>0x3E72<SEP>0x6761<SEP3>// <CJK>
0x8FF1<SEP>0x3E73<SEP>0x6756<SEP3>// <CJK>
0x8FF2<SEP>0x3E74<SEP>0x6D44<SEP3>// <CJK>
0x8FF3<SEP>0x3E75<SEP>0x72B6<SEP3>// <CJK>
0x8FF4<SEP>0x3E76<SEP>0x7573<SEP3>// <CJK>
0x8FF5<SEP>0x3E77<SEP>0x7A63<SEP3>// <CJK>
0x8FF6<SEP>0x3E78<SEP>0x84B8<SEP3>// <CJK>
0x8FF7<SEP>0x3E79<SEP>0x8B72<SEP3>// <CJK>
0x8FF8<SEP>0x3E7A<SEP>0x91B8<SEP3>// <CJK>
0x8FF9<SEP>0x3E7B<SEP>0x9320<SEP3>// <CJK>
0x8FFA<SEP>0x3E7C<SEP>0x5631<SEP3>// <CJK>
0x8FFB<SEP>0x3E7D<SEP>0x57F4<SEP3>// <CJK>
0x8FFC<SEP>0x3E7E<SEP>0x98FE<SEP3>// <CJK>
0x9040<SEP>0x3F21<SEP>0x62ED<SEP3>// <CJK>
0x9041<SEP>0x3F22<SEP>0x690D<SEP3>// <CJK>
0x9042<SEP>0x3F23<SEP>0x6B96<SEP3>// <CJK>
0x9043<SEP>0x3F24<SEP>0x71ED<SEP3>// <CJK>
0x9044<SEP>0x3F25<SEP>0x7E54<SEP3>// <CJK>
0x9045<SEP>0x3F26<SEP>0x8077<SEP3>// <CJK>
0x9046<SEP>0x3F27<SEP>0x8272<SEP3>// <CJK>
0x9047<SEP>0x3F28<SEP>0x89E6<SEP3>// <CJK>
0x9048<SEP>0x3F29<SEP>0x98DF<SEP3>// <CJK>
0x9049<SEP>0x3F2A<SEP>0x8755<SEP3>// <CJK>
0x904A<SEP>0x3F2B<SEP>0x8FB1<SEP3>// <CJK>
0x904B<SEP>0x3F2C<SEP>0x5C3B<SEP3>// <CJK>
0x904C<SEP>0x3F2D<SEP>0x4F38<SEP3>// <CJK>
0x904D<SEP>0x3F2E<SEP>0x4FE1<SEP3>// <CJK>
0x904E<SEP>0x3F2F<SEP>0x4FB5<SEP3>// <CJK>
0x904F<SEP>0x3F30<SEP>0x5507<SEP3>// <CJK>
0x9050<SEP>0x3F31<SEP>0x5A20<SEP3>// <CJK>
0x9051<SEP>0x3F32<SEP>0x5BDD<SEP3>// <CJK>
0x9052<SEP>0x3F33<SEP>0x5BE9<SEP3>// <CJK>
0x9053<SEP>0x3F34<SEP>0x5FC3<SEP3>// <CJK>
0x9054<SEP>0x3F35<SEP>0x614E<SEP3>// <CJK>
0x9055<SEP>0x3F36<SEP>0x632F<SEP3>// <CJK>
0x9056<SEP>0x3F37<SEP>0x65B0<SEP3>// <CJK>
0x9057<SEP>0x3F38<SEP>0x664B<SEP3>// <CJK>
0x9058<SEP>0x3F39<SEP>0x68EE<SEP3>// <CJK>
0x9059<SEP>0x3F3A<SEP>0x699B<SEP3>// <CJK>
0x905A<SEP>0x3F3B<SEP>0x6D78<SEP3>// <CJK>
0x905B<SEP>0x3F3C<SEP>0x6DF1<SEP3>// <CJK>
0x905C<SEP>0x3F3D<SEP>0x7533<SEP3>// <CJK>
0x905D<SEP>0x3F3E<SEP>0x75B9<SEP3>// <CJK>
0x905E<SEP>0x3F3F<SEP>0x771F<SEP3>// <CJK>
0x905F<SEP>0x3F40<SEP>0x795E<SEP3>// <CJK>
0x9060<SEP>0x3F41<SEP>0x79E6<SEP3>// <CJK>
0x9061<SEP>0x3F42<SEP>0x7D33<SEP3>// <CJK>
0x9062<SEP>0x3F43<SEP>0x81E3<SEP3>// <CJK>
0x9063<SEP>0x3F44<SEP>0x82AF<SEP3>// <CJK>
0x9064<SEP>0x3F45<SEP>0x85AA<SEP3>// <CJK>
0x9065<SEP>0x3F46<SEP>0x89AA<SEP3>// <CJK>
0x9066<SEP>0x3F47<SEP>0x8A3A<SEP3>// <CJK>
0x9067<SEP>0x3F48<SEP>0x8EAB<SEP3>// <CJK>
0x9068<SEP>0x3F49<SEP>0x8F9B<SEP3>// <CJK>
0x9069<SEP>0x3F4A<SEP>0x9032<SEP3>// <CJK>
0x906A<SEP>0x3F4B<SEP>0x91DD<SEP3>// <CJK>
0x906B<SEP>0x3F4C<SEP>0x9707<SEP3>// <CJK>
0x906C<SEP>0x3F4D<SEP>0x4EBA<SEP3>// <CJK>
0x906D<SEP>0x3F4E<SEP>0x4EC1<SEP3>// <CJK>
0x906E<SEP>0x3F4F<SEP>0x5203<SEP3>// <CJK>
0x906F<SEP>0x3F50<SEP>0x5875<SEP3>// <CJK>
0x9070<SEP>0x3F51<SEP>0x58EC<SEP3>// <CJK>
0x9071<SEP>0x3F52<SEP>0x5C0B<SEP3>// <CJK>
0x9072<SEP>0x3F53<SEP>0x751A<SEP3>// <CJK>
0x9073<SEP>0x3F54<SEP>0x5C3D<SEP3>// <CJK>
0x9074<SEP>0x3F55<SEP>0x814E<SEP3>// <CJK>
0x9075<SEP>0x3F56<SEP>0x8A0A<SEP3>// <CJK>
0x9076<SEP>0x3F57<SEP>0x8FC5<SEP3>// <CJK>
0x9077<SEP>0x3F58<SEP>0x9663<SEP3>// <CJK>
0x9078<SEP>0x3F59<SEP>0x976D<SEP3>// <CJK>
0x9079<SEP>0x3F5A<SEP>0x7B25<SEP3>// <CJK>
0x907A<SEP>0x3F5B<SEP>0x8ACF<SEP3>// <CJK>
0x907B<SEP>0x3F5C<SEP>0x9808<SEP3>// <CJK>
0x907C<SEP>0x3F5D<SEP>0x9162<SEP3>// <CJK>
0x907D<SEP>0x3F5E<SEP>0x56F3<SEP3>// <CJK>
0x907E<SEP>0x3F5F<SEP>0x53A8<SEP3>// <CJK>
0x9080<SEP>0x3F60<SEP>0x9017<SEP3>// <CJK>
0x9081<SEP>0x3F61<SEP>0x5439<SEP3>// <CJK>
0x9082<SEP>0x3F62<SEP>0x5782<SEP3>// <CJK>
0x9083<SEP>0x3F63<SEP>0x5E25<SEP3>// <CJK>
0x9084<SEP>0x3F64<SEP>0x63A8<SEP3>// <CJK>
0x9085<SEP>0x3F65<SEP>0x6C34<SEP3>// <CJK>
0x9086<SEP>0x3F66<SEP>0x708A<SEP3>// <CJK>
0x9087<SEP>0x3F67<SEP>0x7761<SEP3>// <CJK>
0x9088<SEP>0x3F68<SEP>0x7C8B<SEP3>// <CJK>
0x9089<SEP>0x3F69<SEP>0x7FE0<SEP3>// <CJK>
0x908A<SEP>0x3F6A<SEP>0x8870<SEP3>// <CJK>
0x908B<SEP>0x3F6B<SEP>0x9042<SEP3>// <CJK>
0x908C<SEP>0x3F6C<SEP>0x9154<SEP3>// <CJK>
0x908D<SEP>0x3F6D<SEP>0x9310<SEP3>// <CJK>
0x908E<SEP>0x3F6E<SEP>0x9318<SEP3>// <CJK>
0x908F<SEP>0x3F6F<SEP>0x968F<SEP3>// <CJK>
0x9090<SEP>0x3F70<SEP>0x745E<SEP3>// <CJK>
0x9091<SEP>0x3F71<SEP>0x9AC4<SEP3>// <CJK>
0x9092<SEP>0x3F72<SEP>0x5D07<SEP3>// <CJK>
0x9093<SEP>0x3F73<SEP>0x5D69<SEP3>// <CJK>
0x9094<SEP>0x3F74<SEP>0x6570<SEP3>// <CJK>
0x9095<SEP>0x3F75<SEP>0x67A2<SEP3>// <CJK>
0x9096<SEP>0x3F76<SEP>0x8DA8<SEP3>// <CJK>
0x9097<SEP>0x3F77<SEP>0x96DB<SEP3>// <CJK>
0x9098<SEP>0x3F78<SEP>0x636E<SEP3>// <CJK>
0x9099<SEP>0x3F79<SEP>0x6749<SEP3>// <CJK>
0x909A<SEP>0x3F7A<SEP>0x6919<SEP3>// <CJK>
0x909B<SEP>0x3F7B<SEP>0x83C5<SEP3>// <CJK>
0x909C<SEP>0x3F7C<SEP>0x9817<SEP3>// <CJK>
0x909D<SEP>0x3F7D<SEP>0x96C0<SEP3>// <CJK>
0x909E<SEP>0x3F7E<SEP>0x88FE<SEP3>// <CJK>
0x909F<SEP>0x4021<SEP>0x6F84<SEP3>// <CJK>
0x90A0<SEP>0x4022<SEP>0x647A<SEP3>// <CJK>
0x90A1<SEP>0x4023<SEP>0x5BF8<SEP3>// <CJK>
0x90A2<SEP>0x4024<SEP>0x4E16<SEP3>// <CJK>
0x90A3<SEP>0x4025<SEP>0x702C<SEP3>// <CJK>
0x90A4<SEP>0x4026<SEP>0x755D<SEP3>// <CJK>
0x90A5<SEP>0x4027<SEP>0x662F<SEP3>// <CJK>
0x90A6<SEP>0x4028<SEP>0x51C4<SEP3>// <CJK>
0x90A7<SEP>0x4029<SEP>0x5236<SEP3>// <CJK>
0x90A8<SEP>0x402A<SEP>0x52E2<SEP3>// <CJK>
0x90A9<SEP>0x402B<SEP>0x59D3<SEP3>// <CJK>
0x90AA<SEP>0x402C<SEP>0x5F81<SEP3>// <CJK>
0x90AB<SEP>0x402D<SEP>0x6027<SEP3>// <CJK>
0x90AC<SEP>0x402E<SEP>0x6210<SEP3>// <CJK>
0x90AD<SEP>0x402F<SEP>0x653F<SEP3>// <CJK>
0x90AE<SEP>0x4030<SEP>0x6574<SEP3>// <CJK>
0x90AF<SEP>0x4031<SEP>0x661F<SEP3>// <CJK>
0x90B0<SEP>0x4032<SEP>0x6674<SEP3>// <CJK>
0x90B1<SEP>0x4033<SEP>0x68F2<SEP3>// <CJK>
0x90B2<SEP>0x4034<SEP>0x6816<SEP3>// <CJK>
0x90B3<SEP>0x4035<SEP>0x6B63<SEP3>// <CJK>
0x90B4<SEP>0x4036<SEP>0x6E05<SEP3>// <CJK>
0x90B5<SEP>0x4037<SEP>0x7272<SEP3>// <CJK>
0x90B6<SEP>0x4038<SEP>0x751F<SEP3>// <CJK>
0x90B7<SEP>0x4039<SEP>0x76DB<SEP3>// <CJK>
0x90B8<SEP>0x403A<SEP>0x7CBE<SEP3>// <CJK>
0x90B9<SEP>0x403B<SEP>0x8056<SEP3>// <CJK>
0x90BA<SEP>0x403C<SEP>0x58F0<SEP3>// <CJK>
0x90BB<SEP>0x403D<SEP>0x88FD<SEP3>// <CJK>
0x90BC<SEP>0x403E<SEP>0x897F<SEP3>// <CJK>
0x90BD<SEP>0x403F<SEP>0x8AA0<SEP3>// <CJK>
0x90BE<SEP>0x4040<SEP>0x8A93<SEP3>// <CJK>
0x90BF<SEP>0x4041<SEP>0x8ACB<SEP3>// <CJK>
0x90C0<SEP>0x4042<SEP>0x901D<SEP3>// <CJK>
0x90C1<SEP>0x4043<SEP>0x9192<SEP3>// <CJK>
0x90C2<SEP>0x4044<SEP>0x9752<SEP3>// <CJK>
0x90C3<SEP>0x4045<SEP>0x9759<SEP3>// <CJK>
0x90C4<SEP>0x4046<SEP>0x6589<SEP3>// <CJK>
0x90C5<SEP>0x4047<SEP>0x7A0E<SEP3>// <CJK>
0x90C6<SEP>0x4048<SEP>0x8106<SEP3>// <CJK>
0x90C7<SEP>0x4049<SEP>0x96BB<SEP3>// <CJK>
0x90C8<SEP>0x404A<SEP>0x5E2D<SEP3>// <CJK>
0x90C9<SEP>0x404B<SEP>0x60DC<SEP3>// <CJK>
0x90CA<SEP>0x404C<SEP>0x621A<SEP3>// <CJK>
0x90CB<SEP>0x404D<SEP>0x65A5<SEP3>// <CJK>
0x90CC<SEP>0x404E<SEP>0x6614<SEP3>// <CJK>
0x90CD<SEP>0x404F<SEP>0x6790<SEP3>// <CJK>
0x90CE<SEP>0x4050<SEP>0x77F3<SEP3>// <CJK>
0x90CF<SEP>0x4051<SEP>0x7A4D<SEP3>// <CJK>
0x90D0<SEP>0x4052<SEP>0x7C4D<SEP3>// <CJK>
0x90D1<SEP>0x4053<SEP>0x7E3E<SEP3>// <CJK>
0x90D2<SEP>0x4054<SEP>0x810A<SEP3>// <CJK>
0x90D3<SEP>0x4055<SEP>0x8CAC<SEP3>// <CJK>
0x90D4<SEP>0x4056<SEP>0x8D64<SEP3>// <CJK>
0x90D5<SEP>0x4057<SEP>0x8DE1<SEP3>// <CJK>
0x90D6<SEP>0x4058<SEP>0x8E5F<SEP3>// <CJK>
0x90D7<SEP>0x4059<SEP>0x78A9<SEP3>// <CJK>
0x90D8<SEP>0x405A<SEP>0x5207<SEP3>// <CJK>
0x90D9<SEP>0x405B<SEP>0x62D9<SEP3>// <CJK>
0x90DA<SEP>0x405C<SEP>0x63A5<SEP3>// <CJK>
0x90DB<SEP>0x405D<SEP>0x6442<SEP3>// <CJK>
0x90DC<SEP>0x405E<SEP>0x6298<SEP3>// <CJK>
0x90DD<SEP>0x405F<SEP>0x8A2D<SEP3>// <CJK>
0x90DE<SEP>0x4060<SEP>0x7A83<SEP3>// <CJK>
0x90DF<SEP>0x4061<SEP>0x7BC0<SEP3>// <CJK>
0x90E0<SEP>0x4062<SEP>0x8AAC<SEP3>// <CJK>
0x90E1<SEP>0x4063<SEP>0x96EA<SEP3>// <CJK>
0x90E2<SEP>0x4064<SEP>0x7D76<SEP3>// <CJK>
0x90E3<SEP>0x4065<SEP>0x820C<SEP3>// <CJK>
0x90E4<SEP>0x4066<SEP>0x8749<SEP3>// <CJK>
0x90E5<SEP>0x4067<SEP>0x4ED9<SEP3>// <CJK>
0x90E6<SEP>0x4068<SEP>0x5148<SEP3>// <CJK>
0x90E7<SEP>0x4069<SEP>0x5343<SEP3>// <CJK>
0x90E8<SEP>0x406A<SEP>0x5360<SEP3>// <CJK>
0x90E9<SEP>0x406B<SEP>0x5BA3<SEP3>// <CJK>
0x90EA<SEP>0x406C<SEP>0x5C02<SEP3>// <CJK>
0x90EB<SEP>0x406D<SEP>0x5C16<SEP3>// <CJK>
0x90EC<SEP>0x406E<SEP>0x5DDD<SEP3>// <CJK>
0x90ED<SEP>0x406F<SEP>0x6226<SEP3>// <CJK>
0x90EE<SEP>0x4070<SEP>0x6247<SEP3>// <CJK>
0x90EF<SEP>0x4071<SEP>0x64B0<SEP3>// <CJK>
0x90F0<SEP>0x4072<SEP>0x6813<SEP3>// <CJK>
0x90F1<SEP>0x4073<SEP>0x6834<SEP3>// <CJK>
0x90F2<SEP>0x4074<SEP>0x6CC9<SEP3>// <CJK>
0x90F3<SEP>0x4075<SEP>0x6D45<SEP3>// <CJK>
0x90F4<SEP>0x4076<SEP>0x6D17<SEP3>// <CJK>
0x90F5<SEP>0x4077<SEP>0x67D3<SEP3>// <CJK>
0x90F6<SEP>0x4078<SEP>0x6F5C<SEP3>// <CJK>
0x90F7<SEP>0x4079<SEP>0x714E<SEP3>// <CJK>
0x90F8<SEP>0x407A<SEP>0x717D<SEP3>// <CJK>
0x90F9<SEP>0x407B<SEP>0x65CB<SEP3>// <CJK>
0x90FA<SEP>0x407C<SEP>0x7A7F<SEP3>// <CJK>
0x90FB<SEP>0x407D<SEP>0x7BAD<SEP3>// <CJK>
0x90FC<SEP>0x407E<SEP>0x7DDA<SEP3>// <CJK>
0x9140<SEP>0x4121<SEP>0x7E4A<SEP3>// <CJK>
0x9141<SEP>0x4122<SEP>0x7FA8<SEP3>// <CJK>
0x9142<SEP>0x4123<SEP>0x817A<SEP3>// <CJK>
0x9143<SEP>0x4124<SEP>0x821B<SEP3>// <CJK>
0x9144<SEP>0x4125<SEP>0x8239<SEP3>// <CJK>
0x9145<SEP>0x4126<SEP>0x85A6<SEP3>// <CJK>
0x9146<SEP>0x4127<SEP>0x8A6E<SEP3>// <CJK>
0x9147<SEP>0x4128<SEP>0x8CCE<SEP3>// <CJK>
0x9148<SEP>0x4129<SEP>0x8DF5<SEP3>// <CJK>
0x9149<SEP>0x412A<SEP>0x9078<SEP3>// <CJK>
0x914A<SEP>0x412B<SEP>0x9077<SEP3>// <CJK>
0x914B<SEP>0x412C<SEP>0x92AD<SEP3>// <CJK>
0x914C<SEP>0x412D<SEP>0x9291<SEP3>// <CJK>
0x914D<SEP>0x412E<SEP>0x9583<SEP3>// <CJK>
0x914E<SEP>0x412F<SEP>0x9BAE<SEP3>// <CJK>
0x914F<SEP>0x4130<SEP>0x524D<SEP3>// <CJK>
0x9150<SEP>0x4131<SEP>0x5584<SEP3>// <CJK>
0x9151<SEP>0x4132<SEP>0x6F38<SEP3>// <CJK>
0x9152<SEP>0x4133<SEP>0x7136<SEP3>// <CJK>
0x9153<SEP>0x4134<SEP>0x5168<SEP3>// <CJK>
0x9154<SEP>0x4135<SEP>0x7985<SEP3>// <CJK>
0x9155<SEP>0x4136<SEP>0x7E55<SEP3>// <CJK>
0x9156<SEP>0x4137<SEP>0x81B3<SEP3>// <CJK>
0x9157<SEP>0x4138<SEP>0x7CCE<SEP3>// <CJK>
0x9158<SEP>0x4139<SEP>0x564C<SEP3>// <CJK>
0x9159<SEP>0x413A<SEP>0x5851<SEP3>// <CJK>
0x915A<SEP>0x413B<SEP>0x5CA8<SEP3>// <CJK>
0x915B<SEP>0x413C<SEP>0x63AA<SEP3>// <CJK>
0x915C<SEP>0x413D<SEP>0x66FE<SEP3>// <CJK>
0x915D<SEP>0x413E<SEP>0x66FD<SEP3>// <CJK>
0x915E<SEP>0x413F<SEP>0x695A<SEP3>// <CJK>
0x915F<SEP>0x4140<SEP>0x72D9<SEP3>// <CJK>
0x9160<SEP>0x4141<SEP>0x758F<SEP3>// <CJK>
0x9161<SEP>0x4142<SEP>0x758E<SEP3>// <CJK>
0x9162<SEP>0x4143<SEP>0x790E<SEP3>// <CJK>
0x9163<SEP>0x4144<SEP>0x7956<SEP3>// <CJK>
0x9164<SEP>0x4145<SEP>0x79DF<SEP3>// <CJK>
0x9165<SEP>0x4146<SEP>0x7C97<SEP3>// <CJK>
0x9166<SEP>0x4147<SEP>0x7D20<SEP3>// <CJK>
0x9167<SEP>0x4148<SEP>0x7D44<SEP3>// <CJK>
0x9168<SEP>0x4149<SEP>0x8607<SEP3>// <CJK>
0x9169<SEP>0x414A<SEP>0x8A34<SEP3>// <CJK>
0x916A<SEP>0x414B<SEP>0x963B<SEP3>// <CJK>
0x916B<SEP>0x414C<SEP>0x9061<SEP3>// <CJK>
0x916C<SEP>0x414D<SEP>0x9F20<SEP3>// <CJK>
0x916D<SEP>0x414E<SEP>0x50E7<SEP3>// <CJK>
0x916E<SEP>0x414F<SEP>0x5275<SEP3>// <CJK>
0x916F<SEP>0x4150<SEP>0x53CC<SEP3>// <CJK>
0x9170<SEP>0x4151<SEP>0x53E2<SEP3>// <CJK>
0x9171<SEP>0x4152<SEP>0x5009<SEP3>// <CJK>
0x9172<SEP>0x4153<SEP>0x55AA<SEP3>// <CJK>
0x9173<SEP>0x4154<SEP>0x58EE<SEP3>// <CJK>
0x9174<SEP>0x4155<SEP>0x594F<SEP3>// <CJK>
0x9175<SEP>0x4156<SEP>0x723D<SEP3>// <CJK>
0x9176<SEP>0x4157<SEP>0x5B8B<SEP3>// <CJK>
0x9177<SEP>0x4158<SEP>0x5C64<SEP3>// <CJK>
0x9178<SEP>0x4159<SEP>0x531D<SEP3>// <CJK>
0x9179<SEP>0x415A<SEP>0x60E3<SEP3>// <CJK>
0x917A<SEP>0x415B<SEP>0x60F3<SEP3>// <CJK>
0x917B<SEP>0x415C<SEP>0x635C<SEP3>// <CJK>
0x917C<SEP>0x415D<SEP>0x6383<SEP3>// <CJK>
0x917D<SEP>0x415E<SEP>0x633F<SEP3>// <CJK>
0x917E<SEP>0x415F<SEP>0x63BB<SEP3>// <CJK>
0x9180<SEP>0x4160<SEP>0x64CD<SEP3>// <CJK>
0x9181<SEP>0x4161<SEP>0x65E9<SEP3>// <CJK>
0x9182<SEP>0x4162<SEP>0x66F9<SEP3>// <CJK>
0x9183<SEP>0x4163<SEP>0x5DE3<SEP3>// <CJK>
0x9184<SEP>0x4164<SEP>0x69CD<SEP3>// <CJK>
0x9185<SEP>0x4165<SEP>0x69FD<SEP3>// <CJK>
0x9186<SEP>0x4166<SEP>0x6F15<SEP3>// <CJK>
0x9187<SEP>0x4167<SEP>0x71E5<SEP3>// <CJK>
0x9188<SEP>0x4168<SEP>0x4E89<SEP3>// <CJK>
0x9189<SEP>0x4169<SEP>0x75E9<SEP3>// <CJK>
0x918A<SEP>0x416A<SEP>0x76F8<SEP3>// <CJK>
0x918B<SEP>0x416B<SEP>0x7A93<SEP3>// <CJK>
0x918C<SEP>0x416C<SEP>0x7CDF<SEP3>// <CJK>
0x918D<SEP>0x416D<SEP>0x7DCF<SEP3>// <CJK>
0x918E<SEP>0x416E<SEP>0x7D9C<SEP3>// <CJK>
0x918F<SEP>0x416F<SEP>0x8061<SEP3>// <CJK>
0x9190<SEP>0x4170<SEP>0x8349<SEP3>// <CJK>
0x9191<SEP>0x4171<SEP>0x8358<SEP3>// <CJK>
0x9192<SEP>0x4172<SEP>0x846C<SEP3>// <CJK>
0x9193<SEP>0x4173<SEP>0x84BC<SEP3>// <CJK>
0x9194<SEP>0x4174<SEP>0x85FB<SEP3>// <CJK>
0x9195<SEP>0x4175<SEP>0x88C5<SEP3>// <CJK>
0x9196<SEP>0x4176<SEP>0x8D70<SEP3>// <CJK>
0x9197<SEP>0x4177<SEP>0x9001<SEP3>// <CJK>
0x9198<SEP>0x4178<SEP>0x906D<SEP3>// <CJK>
0x9199<SEP>0x4179<SEP>0x9397<SEP3>// <CJK>
0x919A<SEP>0x417A<SEP>0x971C<SEP3>// <CJK>
0x919B<SEP>0x417B<SEP>0x9A12<SEP3>// <CJK>
0x919C<SEP>0x417C<SEP>0x50CF<SEP3>// <CJK>
0x919D<SEP>0x417D<SEP>0x5897<SEP3>// <CJK>
0x919E<SEP>0x417E<SEP>0x618E<SEP3>// <CJK>
0x919F<SEP>0x4221<SEP>0x81D3<SEP3>// <CJK>
0x91A0<SEP>0x4222<SEP>0x8535<SEP3>// <CJK>
0x91A1<SEP>0x4223<SEP>0x8D08<SEP3>// <CJK>
0x91A2<SEP>0x4224<SEP>0x9020<SEP3>// <CJK>
0x91A3<SEP>0x4225<SEP>0x4FC3<SEP3>// <CJK>
0x91A4<SEP>0x4226<SEP>0x5074<SEP3>// <CJK>
0x91A5<SEP>0x4227<SEP>0x5247<SEP3>// <CJK>
0x91A6<SEP>0x4228<SEP>0x5373<SEP3>// <CJK>
0x91A7<SEP>0x4229<SEP>0x606F<SEP3>// <CJK>
0x91A8<SEP>0x422A<SEP>0x6349<SEP3>// <CJK>
0x91A9<SEP>0x422B<SEP>0x675F<SEP3>// <CJK>
0x91AA<SEP>0x422C<SEP>0x6E2C<SEP3>// <CJK>
0x91AB<SEP>0x422D<SEP>0x8DB3<SEP3>// <CJK>
0x91AC<SEP>0x422E<SEP>0x901F<SEP3>// <CJK>
0x91AD<SEP>0x422F<SEP>0x4FD7<SEP3>// <CJK>
0x91AE<SEP>0x4230<SEP>0x5C5E<SEP3>// <CJK>
0x91AF<SEP>0x4231<SEP>0x8CCA<SEP3>// <CJK>
0x91B0<SEP>0x4232<SEP>0x65CF<SEP3>// <CJK>
0x91B1<SEP>0x4233<SEP>0x7D9A<SEP3>// <CJK>
0x91B2<SEP>0x4234<SEP>0x5352<SEP3>// <CJK>
0x91B3<SEP>0x4235<SEP>0x8896<SEP3>// <CJK>
0x91B4<SEP>0x4236<SEP>0x5176<SEP3>// <CJK>
0x91B5<SEP>0x4237<SEP>0x63C3<SEP3>// <CJK>
0x91B6<SEP>0x4238<SEP>0x5B58<SEP3>// <CJK>
0x91B7<SEP>0x4239<SEP>0x5B6B<SEP3>// <CJK>
0x91B8<SEP>0x423A<SEP>0x5C0A<SEP3>// <CJK>
0x91B9<SEP>0x423B<SEP>0x640D<SEP3>// <CJK>
0x91BA<SEP>0x423C<SEP>0x6751<SEP3>// <CJK>
0x91BB<SEP>0x423D<SEP>0x905C<SEP3>// <CJK>
0x91BC<SEP>0x423E<SEP>0x4ED6<SEP3>// <CJK>
0x91BD<SEP>0x423F<SEP>0x591A<SEP3>// <CJK>
0x91BE<SEP>0x4240<SEP>0x592A<SEP3>// <CJK>
0x91BF<SEP>0x4241<SEP>0x6C70<SEP3>// <CJK>
0x91C0<SEP>0x4242<SEP>0x8A51<SEP3>// <CJK>
0x91C1<SEP>0x4243<SEP>0x553E<SEP3>// <CJK>
0x91C2<SEP>0x4244<SEP>0x5815<SEP3>// <CJK>
0x91C3<SEP>0x4245<SEP>0x59A5<SEP3>// <CJK>
0x91C4<SEP>0x4246<SEP>0x60F0<SEP3>// <CJK>
0x91C5<SEP>0x4247<SEP>0x6253<SEP3>// <CJK>
0x91C6<SEP>0x4248<SEP>0x67C1<SEP3>// <CJK>
0x91C7<SEP>0x4249<SEP>0x8235<SEP3>// <CJK>
0x91C8<SEP>0x424A<SEP>0x6955<SEP3>// <CJK>
0x91C9<SEP>0x424B<SEP>0x9640<SEP3>// <CJK>
0x91CA<SEP>0x424C<SEP>0x99C4<SEP3>// <CJK>
0x91CB<SEP>0x424D<SEP>0x9A28<SEP3>// <CJK>
0x91CC<SEP>0x424E<SEP>0x4F53<SEP3>// <CJK>
0x91CD<SEP>0x424F<SEP>0x5806<SEP3>// <CJK>
0x91CE<SEP>0x4250<SEP>0x5BFE<SEP3>// <CJK>
0x91CF<SEP>0x4251<SEP>0x8010<SEP3>// <CJK>
0x91D0<SEP>0x4252<SEP>0x5CB1<SEP3>// <CJK>
0x91D1<SEP>0x4253<SEP>0x5E2F<SEP3>// <CJK>
0x91D2<SEP>0x4254<SEP>0x5F85<SEP3>// <CJK>
0x91D3<SEP>0x4255<SEP>0x6020<SEP3>// <CJK>
0x91D4<SEP>0x4256<SEP>0x614B<SEP3>// <CJK>
0x91D5<SEP>0x4257<SEP>0x6234<SEP3>// <CJK>
0x91D6<SEP>0x4258<SEP>0x66FF<SEP3>// <CJK>
0x91D7<SEP>0x4259<SEP>0x6CF0<SEP3>// <CJK>
0x91D8<SEP>0x425A<SEP>0x6EDE<SEP3>// <CJK>
0x91D9<SEP>0x425B<SEP>0x80CE<SEP3>// <CJK>
0x91DA<SEP>0x425C<SEP>0x817F<SEP3>// <CJK>
0x91DB<SEP>0x425D<SEP>0x82D4<SEP3>// <CJK>
0x91DC<SEP>0x425E<SEP>0x888B<SEP3>// <CJK>
0x91DD<SEP>0x425F<SEP>0x8CB8<SEP3>// <CJK>
0x91DE<SEP>0x4260<SEP>0x9000<SEP3>// <CJK>
0x91DF<SEP>0x4261<SEP>0x902E<SEP3>// <CJK>
0x91E0<SEP>0x4262<SEP>0x968A<SEP3>// <CJK>
0x91E1<SEP>0x4263<SEP>0x9EDB<SEP3>// <CJK>
0x91E2<SEP>0x4264<SEP>0x9BDB<SEP3>// <CJK>
0x91E3<SEP>0x4265<SEP>0x4EE3<SEP3>// <CJK>
0x91E4<SEP>0x4266<SEP>0x53F0<SEP3>// <CJK>
0x91E5<SEP>0x4267<SEP>0x5927<SEP3>// <CJK>
0x91E6<SEP>0x4268<SEP>0x7B2C<SEP3>// <CJK>
0x91E7<SEP>0x4269<SEP>0x918D<SEP3>// <CJK>
0x91E8<SEP>0x426A<SEP>0x984C<SEP3>// <CJK>
0x91E9<SEP>0x426B<SEP>0x9DF9<SEP3>// <CJK>
0x91EA<SEP>0x426C<SEP>0x6EDD<SEP3>// <CJK>
0x91EB<SEP>0x426D<SEP>0x7027<SEP3>// <CJK>
0x91EC<SEP>0x426E<SEP>0x5353<SEP3>// <CJK>
0x91ED<SEP>0x426F<SEP>0x5544<SEP3>// <CJK>
0x91EE<SEP>0x4270<SEP>0x5B85<SEP3>// <CJK>
0x91EF<SEP>0x4271<SEP>0x6258<SEP3>// <CJK>
0x91F0<SEP>0x4272<SEP>0x629E<SEP3>// <CJK>
0x91F1<SEP>0x4273<SEP>0x62D3<SEP3>// <CJK>
0x91F2<SEP>0x4274<SEP>0x6CA2<SEP3>// <CJK>
0x91F3<SEP>0x4275<SEP>0x6FEF<SEP3>// <CJK>
0x91F4<SEP>0x4276<SEP>0x7422<SEP3>// <CJK>
0x91F5<SEP>0x4277<SEP>0x8A17<SEP3>// <CJK>
0x91F6<SEP>0x4278<SEP>0x9438<SEP3>// <CJK>
0x91F7<SEP>0x4279<SEP>0x6FC1<SEP3>// <CJK>
0x91F8<SEP>0x427A<SEP>0x8AFE<SEP3>// <CJK>
0x91F9<SEP>0x427B<SEP>0x8338<SEP3>// <CJK>
0x91FA<SEP>0x427C<SEP>0x51E7<SEP3>// <CJK>
0x91FB<SEP>0x427D<SEP>0x86F8<SEP3>// <CJK>
0x91FC<SEP>0x427E<SEP>0x53EA<SEP3>// <CJK>
0x9240<SEP>0x4321<SEP>0x53E9<SEP3>// <CJK>
0x9241<SEP>0x4322<SEP>0x4F46<SEP3>// <CJK>
0x9242<SEP>0x4323<SEP>0x9054<SEP3>// <CJK>
0x9243<SEP>0x4324<SEP>0x8FB0<SEP3>// <CJK>
0x9244<SEP>0x4325<SEP>0x596A<SEP3>// <CJK>
0x9245<SEP>0x4326<SEP>0x8131<SEP3>// <CJK>
0x9246<SEP>0x4327<SEP>0x5DFD<SEP3>// <CJK>
0x9247<SEP>0x4328<SEP>0x7AEA<SEP3>// <CJK>
0x9248<SEP>0x4329<SEP>0x8FBF<SEP3>// <CJK>
0x9249<SEP>0x432A<SEP>0x68DA<SEP3>// <CJK>
0x924A<SEP>0x432B<SEP>0x8C37<SEP3>// <CJK>
0x924B<SEP>0x432C<SEP>0x72F8<SEP3>// <CJK>
0x924C<SEP>0x432D<SEP>0x9C48<SEP3>// <CJK>
0x924D<SEP>0x432E<SEP>0x6A3D<SEP3>// <CJK>
0x924E<SEP>0x432F<SEP>0x8AB0<SEP3>// <CJK>
0x924F<SEP>0x4330<SEP>0x4E39<SEP3>// <CJK>
0x9250<SEP>0x4331<SEP>0x5358<SEP3>// <CJK>
0x9251<SEP>0x4332<SEP>0x5606<SEP3>// <CJK>
0x9252<SEP>0x4333<SEP>0x5766<SEP3>// <CJK>
0x9253<SEP>0x4334<SEP>0x62C5<SEP3>// <CJK>
0x9254<SEP>0x4335<SEP>0x63A2<SEP3>// <CJK>
0x9255<SEP>0x4336<SEP>0x65E6<SEP3>// <CJK>
0x9256<SEP>0x4337<SEP>0x6B4E<SEP3>// <CJK>
0x9257<SEP>0x4338<SEP>0x6DE1<SEP3>// <CJK>
0x9258<SEP>0x4339<SEP>0x6E5B<SEP3>// <CJK>
0x9259<SEP>0x433A<SEP>0x70AD<SEP3>// <CJK>
0x925A<SEP>0x433B<SEP>0x77ED<SEP3>// <CJK>
0x925B<SEP>0x433C<SEP>0x7AEF<SEP3>// <CJK>
0x925C<SEP>0x433D<SEP>0x7BAA<SEP3>// <CJK>
0x925D<SEP>0x433E<SEP>0x7DBB<SEP3>// <CJK>
0x925E<SEP>0x433F<SEP>0x803D<SEP3>// <CJK>
0x925F<SEP>0x4340<SEP>0x80C6<SEP3>// <CJK>
0x9260<SEP>0x4341<SEP>0x86CB<SEP3>// <CJK>
0x9261<SEP>0x4342<SEP>0x8A95<SEP3>// <CJK>
0x9262<SEP>0x4343<SEP>0x935B<SEP3>// <CJK>
0x9263<SEP>0x4344<SEP>0x56E3<SEP3>// <CJK>
0x9264<SEP>0x4345<SEP>0x58C7<SEP3>// <CJK>
0x9265<SEP>0x4346<SEP>0x5F3E<SEP3>// <CJK>
0x9266<SEP>0x4347<SEP>0x65AD<SEP3>// <CJK>
0x9267<SEP>0x4348<SEP>0x6696<SEP3>// <CJK>
0x9268<SEP>0x4349<SEP>0x6A80<SEP3>// <CJK>
0x9269<SEP>0x434A<SEP>0x6BB5<SEP3>// <CJK>
0x926A<SEP>0x434B<SEP>0x7537<SEP3>// <CJK>
0x926B<SEP>0x434C<SEP>0x8AC7<SEP3>// <CJK>
0x926C<SEP>0x434D<SEP>0x5024<SEP3>// <CJK>
0x926D<SEP>0x434E<SEP>0x77E5<SEP3>// <CJK>
0x926E<SEP>0x434F<SEP>0x5730<SEP3>// <CJK>
0x926F<SEP>0x4350<SEP>0x5F1B<SEP3>// <CJK>
0x9270<SEP>0x4351<SEP>0x6065<SEP3>// <CJK>
0x9271<SEP>0x4352<SEP>0x667A<SEP3>// <CJK>
0x9272<SEP>0x4353<SEP>0x6C60<SEP3>// <CJK>
0x9273<SEP>0x4354<SEP>0x75F4<SEP3>// <CJK>
0x9274<SEP>0x4355<SEP>0x7A1A<SEP3>// <CJK>
0x9275<SEP>0x4356<SEP>0x7F6E<SEP3>// <CJK>
0x9276<SEP>0x4357<SEP>0x81F4<SEP3>// <CJK>
0x9277<SEP>0x4358<SEP>0x8718<SEP3>// <CJK>
0x9278<SEP>0x4359<SEP>0x9045<SEP3>// <CJK>
0x9279<SEP>0x435A<SEP>0x99B3<SEP3>// <CJK>
0x927A<SEP>0x435B<SEP>0x7BC9<SEP3>// <CJK>
0x927B<SEP>0x435C<SEP>0x755C<SEP3>// <CJK>
0x927C<SEP>0x435D<SEP>0x7AF9<SEP3>// <CJK>
0x927D<SEP>0x435E<SEP>0x7B51<SEP3>// <CJK>
0x927E<SEP>0x435F<SEP>0x84C4<SEP3>// <CJK>
0x9280<SEP>0x4360<SEP>0x9010<SEP3>// <CJK>
0x9281<SEP>0x4361<SEP>0x79E9<SEP3>// <CJK>
0x9282<SEP>0x4362<SEP>0x7A92<SEP3>// <CJK>
0x9283<SEP>0x4363<SEP>0x8336<SEP3>// <CJK>
0x9284<SEP>0x4364<SEP>0x5AE1<SEP3>// <CJK>
0x9285<SEP>0x4365<SEP>0x7740<SEP3>// <CJK>
0x9286<SEP>0x4366<SEP>0x4E2D<SEP3>// <CJK>
0x9287<SEP>0x4367<SEP>0x4EF2<SEP3>// <CJK>
0x9288<SEP>0x4368<SEP>0x5B99<SEP3>// <CJK>
0x9289<SEP>0x4369<SEP>0x5FE0<SEP3>// <CJK>
0x928A<SEP>0x436A<SEP>0x62BD<SEP3>// <CJK>
0x928B<SEP>0x436B<SEP>0x663C<SEP3>// <CJK>
0x928C<SEP>0x436C<SEP>0x67F1<SEP3>// <CJK>
0x928D<SEP>0x436D<SEP>0x6CE8<SEP3>// <CJK>
0x928E<SEP>0x436E<SEP>0x866B<SEP3>// <CJK>
0x928F<SEP>0x436F<SEP>0x8877<SEP3>// <CJK>
0x9290<SEP>0x4370<SEP>0x8A3B<SEP3>// <CJK>
0x9291<SEP>0x4371<SEP>0x914E<SEP3>// <CJK>
0x9292<SEP>0x4372<SEP>0x92F3<SEP3>// <CJK>
0x9293<SEP>0x4373<SEP>0x99D0<SEP3>// <CJK>
0x9294<SEP>0x4374<SEP>0x6A17<SEP3>// <CJK>
0x9295<SEP>0x4375<SEP>0x7026<SEP3>// <CJK>
0x9296<SEP>0x4376<SEP>0x732A<SEP3>// <CJK>
0x9297<SEP>0x4377<SEP>0x82E7<SEP3>// <CJK>
0x9298<SEP>0x4378<SEP>0x8457<SEP3>// <CJK>
0x9299<SEP>0x4379<SEP>0x8CAF<SEP3>// <CJK>
0x929A<SEP>0x437A<SEP>0x4E01<SEP3>// <CJK>
0x929B<SEP>0x437B<SEP>0x5146<SEP3>// <CJK>
0x929C<SEP>0x437C<SEP>0x51CB<SEP3>// <CJK>
0x929D<SEP>0x437D<SEP>0x558B<SEP3>// <CJK>
0x929E<SEP>0x437E<SEP>0x5BF5<SEP3>// <CJK>
0x929F<SEP>0x4421<SEP>0x5E16<SEP3>// <CJK>
0x92A0<SEP>0x4422<SEP>0x5E33<SEP3>// <CJK>
0x92A1<SEP>0x4423<SEP>0x5E81<SEP3>// <CJK>
0x92A2<SEP>0x4424<SEP>0x5F14<SEP3>// <CJK>
0x92A3<SEP>0x4425<SEP>0x5F35<SEP3>// <CJK>
0x92A4<SEP>0x4426<SEP>0x5F6B<SEP3>// <CJK>
0x92A5<SEP>0x4427<SEP>0x5FB4<SEP3>// <CJK>
0x92A6<SEP>0x4428<SEP>0x61F2<SEP3>// <CJK>
0x92A7<SEP>0x4429<SEP>0x6311<SEP3>// <CJK>
0x92A8<SEP>0x442A<SEP>0x66A2<SEP3>// <CJK>
0x92A9<SEP>0x442B<SEP>0x671D<SEP3>// <CJK>
0x92AA<SEP>0x442C<SEP>0x6F6E<SEP3>// <CJK>
0x92AB<SEP>0x442D<SEP>0x7252<SEP3>// <CJK>
0x92AC<SEP>0x442E<SEP>0x753A<SEP3>// <CJK>
0x92AD<SEP>0x442F<SEP>0x773A<SEP3>// <CJK>
0x92AE<SEP>0x4430<SEP>0x8074<SEP3>// <CJK>
0x92AF<SEP>0x4431<SEP>0x8139<SEP3>// <CJK>
0x92B0<SEP>0x4432<SEP>0x8178<SEP3>// <CJK>
0x92B1<SEP>0x4433<SEP>0x8776<SEP3>// <CJK>
0x92B2<SEP>0x4434<SEP>0x8ABF<SEP3>// <CJK>
0x92B3<SEP>0x4435<SEP>0x8ADC<SEP3>// <CJK>
0x92B4<SEP>0x4436<SEP>0x8D85<SEP3>// <CJK>
0x92B5<SEP>0x4437<SEP>0x8DF3<SEP3>// <CJK>
0x92B6<SEP>0x4438<SEP>0x929A<SEP3>// <CJK>
0x92B7<SEP>0x4439<SEP>0x9577<SEP3>// <CJK>
0x92B8<SEP>0x443A<SEP>0x9802<SEP3>// <CJK>
0x92B9<SEP>0x443B<SEP>0x9CE5<SEP3>// <CJK>
0x92BA<SEP>0x443C<SEP>0x52C5<SEP3>// <CJK>
0x92BB<SEP>0x443D<SEP>0x6357<SEP3>// <CJK>
0x92BC<SEP>0x443E<SEP>0x76F4<SEP3>// <CJK>
0x92BD<SEP>0x443F<SEP>0x6715<SEP3>// <CJK>
0x92BE<SEP>0x4440<SEP>0x6C88<SEP3>// <CJK>
0x92BF<SEP>0x4441<SEP>0x73CD<SEP3>// <CJK>
0x92C0<SEP>0x4442<SEP>0x8CC3<SEP3>// <CJK>
0x92C1<SEP>0x4443<SEP>0x93AE<SEP3>// <CJK>
0x92C2<SEP>0x4444<SEP>0x9673<SEP3>// <CJK>
0x92C3<SEP>0x4445<SEP>0x6D25<SEP3>// <CJK>
0x92C4<SEP>0x4446<SEP>0x589C<SEP3>// <CJK>
0x92C5<SEP>0x4447<SEP>0x690E<SEP3>// <CJK>
0x92C6<SEP>0x4448<SEP>0x69CC<SEP3>// <CJK>
0x92C7<SEP>0x4449<SEP>0x8FFD<SEP3>// <CJK>
0x92C8<SEP>0x444A<SEP>0x939A<SEP3>// <CJK>
0x92C9<SEP>0x444B<SEP>0x75DB<SEP3>// <CJK>
0x92CA<SEP>0x444C<SEP>0x901A<SEP3>// <CJK>
0x92CB<SEP>0x444D<SEP>0x585A<SEP3>// <CJK>
0x92CC<SEP>0x444E<SEP>0x6802<SEP3>// <CJK>
0x92CD<SEP>0x444F<SEP>0x63B4<SEP3>// <CJK>
0x92CE<SEP>0x4450<SEP>0x69FB<SEP3>// <CJK>
0x92CF<SEP>0x4451<SEP>0x4F43<SEP3>// <CJK>
0x92D0<SEP>0x4452<SEP>0x6F2C<SEP3>// <CJK>
0x92D1<SEP>0x4453<SEP>0x67D8<SEP3>// <CJK>
0x92D2<SEP>0x4454<SEP>0x8FBB<SEP3>// <CJK>
0x92D3<SEP>0x4455<SEP>0x8526<SEP3>// <CJK>
0x92D4<SEP>0x4456<SEP>0x7DB4<SEP3>// <CJK>
0x92D5<SEP>0x4457<SEP>0x9354<SEP3>// <CJK>
0x92D6<SEP>0x4458<SEP>0x693F<SEP3>// <CJK>
0x92D7<SEP>0x4459<SEP>0x6F70<SEP3>// <CJK>
0x92D8<SEP>0x445A<SEP>0x576A<SEP3>// <CJK>
0x92D9<SEP>0x445B<SEP>0x58F7<SEP3>// <CJK>
0x92DA<SEP>0x445C<SEP>0x5B2C<SEP3>// <CJK>
0x92DB<SEP>0x445D<SEP>0x7D2C<SEP3>// <CJK>
0x92DC<SEP>0x445E<SEP>0x722A<SEP3>// <CJK>
0x92DD<SEP>0x445F<SEP>0x540A<SEP3>// <CJK>
0x92DE<SEP>0x4460<SEP>0x91E3<SEP3>// <CJK>
0x92DF<SEP>0x4461<SEP>0x9DB4<SEP3>// <CJK>
0x92E0<SEP>0x4462<SEP>0x4EAD<SEP3>// <CJK>
0x92E1<SEP>0x4463<SEP>0x4F4E<SEP3>// <CJK>
0x92E2<SEP>0x4464<SEP>0x505C<SEP3>// <CJK>
0x92E3<SEP>0x4465<SEP>0x5075<SEP3>// <CJK>
0x92E4<SEP>0x4466<SEP>0x5243<SEP3>// <CJK>
0x92E5<SEP>0x4467<SEP>0x8C9E<SEP3>// <CJK>
0x92E6<SEP>0x4468<SEP>0x5448<SEP3>// <CJK>
0x92E7<SEP>0x4469<SEP>0x5824<SEP3>// <CJK>
0x92E8<SEP>0x446A<SEP>0x5B9A<SEP3>// <CJK>
0x92E9<SEP>0x446B<SEP>0x5E1D<SEP3>// <CJK>
0x92EA<SEP>0x446C<SEP>0x5E95<SEP3>// <CJK>
0x92EB<SEP>0x446D<SEP>0x5EAD<SEP3>// <CJK>
0x92EC<SEP>0x446E<SEP>0x5EF7<SEP3>// <CJK>
0x92ED<SEP>0x446F<SEP>0x5F1F<SEP3>// <CJK>
0x92EE<SEP>0x4470<SEP>0x608C<SEP3>// <CJK>
0x92EF<SEP>0x4471<SEP>0x62B5<SEP3>// <CJK>
0x92F0<SEP>0x4472<SEP>0x633A<SEP3>// <CJK>
0x92F1<SEP>0x4473<SEP>0x63D0<SEP3>// <CJK>
0x92F2<SEP>0x4474<SEP>0x68AF<SEP3>// <CJK>
0x92F3<SEP>0x4475<SEP>0x6C40<SEP3>// <CJK>
0x92F4<SEP>0x4476<SEP>0x7887<SEP3>// <CJK>
0x92F5<SEP>0x4477<SEP>0x798E<SEP3>// <CJK>
0x92F6<SEP>0x4478<SEP>0x7A0B<SEP3>// <CJK>
0x92F7<SEP>0x4479<SEP>0x7DE0<SEP3>// <CJK>
0x92F8<SEP>0x447A<SEP>0x8247<SEP3>// <CJK>
0x92F9<SEP>0x447B<SEP>0x8A02<SEP3>// <CJK>
0x92FA<SEP>0x447C<SEP>0x8AE6<SEP3>// <CJK>
0x92FB<SEP>0x447D<SEP>0x8E44<SEP3>// <CJK>
0x92FC<SEP>0x447E<SEP>0x9013<SEP3>// <CJK>
0x9340<SEP>0x4521<SEP>0x90B8<SEP3>// <CJK>
0x9341<SEP>0x4522<SEP>0x912D<SEP3>// <CJK>
0x9342<SEP>0x4523<SEP>0x91D8<SEP3>// <CJK>
0x9343<SEP>0x4524<SEP>0x9F0E<SEP3>// <CJK>
0x9344<SEP>0x4525<SEP>0x6CE5<SEP3>// <CJK>
0x9345<SEP>0x4526<SEP>0x6458<SEP3>// <CJK>
0x9346<SEP>0x4527<SEP>0x64E2<SEP3>// <CJK>
0x9347<SEP>0x4528<SEP>0x6575<SEP3>// <CJK>
0x9348<SEP>0x4529<SEP>0x6EF4<SEP3>// <CJK>
0x9349<SEP>0x452A<SEP>0x7684<SEP3>// <CJK>
0x934A<SEP>0x452B<SEP>0x7B1B<SEP3>// <CJK>
0x934B<SEP>0x452C<SEP>0x9069<SEP3>// <CJK>
0x934C<SEP>0x452D<SEP>0x93D1<SEP3>// <CJK>
0x934D<SEP>0x452E<SEP>0x6EBA<SEP3>// <CJK>
0x934E<SEP>0x452F<SEP>0x54F2<SEP3>// <CJK>
0x934F<SEP>0x4530<SEP>0x5FB9<SEP3>// <CJK>
0x9350<SEP>0x4531<SEP>0x64A4<SEP3>// <CJK>
0x9351<SEP>0x4532<SEP>0x8F4D<SEP3>// <CJK>
0x9352<SEP>0x4533<SEP>0x8FED<SEP3>// <CJK>
0x9353<SEP>0x4534<SEP>0x9244<SEP3>// <CJK>
0x9354<SEP>0x4535<SEP>0x5178<SEP3>// <CJK>
0x9355<SEP>0x4536<SEP>0x586B<SEP3>// <CJK>
0x9356<SEP>0x4537<SEP>0x5929<SEP3>// <CJK>
0x9357<SEP>0x4538<SEP>0x5C55<SEP3>// <CJK>
0x9358<SEP>0x4539<SEP>0x5E97<SEP3>// <CJK>
0x9359<SEP>0x453A<SEP>0x6DFB<SEP3>// <CJK>
0x935A<SEP>0x453B<SEP>0x7E8F<SEP3>// <CJK>
0x935B<SEP>0x453C<SEP>0x751C<SEP3>// <CJK>
0x935C<SEP>0x453D<SEP>0x8CBC<SEP3>// <CJK>
0x935D<SEP>0x453E<SEP>0x8EE2<SEP3>// <CJK>
0x935E<SEP>0x453F<SEP>0x985B<SEP3>// <CJK>
0x935F<SEP>0x4540<SEP>0x70B9<SEP3>// <CJK>
0x9360<SEP>0x4541<SEP>0x4F1D<SEP3>// <CJK>
0x9361<SEP>0x4542<SEP>0x6BBF<SEP3>// <CJK>
0x9362<SEP>0x4543<SEP>0x6FB1<SEP3>// <CJK>
0x9363<SEP>0x4544<SEP>0x7530<SEP3>// <CJK>
0x9364<SEP>0x4545<SEP>0x96FB<SEP3>// <CJK>
0x9365<SEP>0x4546<SEP>0x514E<SEP3>// <CJK>
0x9366<SEP>0x4547<SEP>0x5410<SEP3>// <CJK>
0x9367<SEP>0x4548<SEP>0x5835<SEP3>// <CJK>
0x9368<SEP>0x4549<SEP>0x5857<SEP3>// <CJK>
0x9369<SEP>0x454A<SEP>0x59AC<SEP3>// <CJK>
0x936A<SEP>0x454B<SEP>0x5C60<SEP3>// <CJK>
0x936B<SEP>0x454C<SEP>0x5F92<SEP3>// <CJK>
0x936C<SEP>0x454D<SEP>0x6597<SEP3>// <CJK>
0x936D<SEP>0x454E<SEP>0x675C<SEP3>// <CJK>
0x936E<SEP>0x454F<SEP>0x6E21<SEP3>// <CJK>
0x936F<SEP>0x4550<SEP>0x767B<SEP3>// <CJK>
0x9370<SEP>0x4551<SEP>0x83DF<SEP3>// <CJK>
0x9371<SEP>0x4552<SEP>0x8CED<SEP3>// <CJK>
0x9372<SEP>0x4553<SEP>0x9014<SEP3>// <CJK>
0x9373<SEP>0x4554<SEP>0x90FD<SEP3>// <CJK>
0x9374<SEP>0x4555<SEP>0x934D<SEP3>// <CJK>
0x9375<SEP>0x4556<SEP>0x7825<SEP3>// <CJK>
0x9376<SEP>0x4557<SEP>0x783A<SEP3>// <CJK>
0x9377<SEP>0x4558<SEP>0x52AA<SEP3>// <CJK>
0x9378<SEP>0x4559<SEP>0x5EA6<SEP3>// <CJK>
0x9379<SEP>0x455A<SEP>0x571F<SEP3>// <CJK>
0x937A<SEP>0x455B<SEP>0x5974<SEP3>// <CJK>
0x937B<SEP>0x455C<SEP>0x6012<SEP3>// <CJK>
0x937C<SEP>0x455D<SEP>0x5012<SEP3>// <CJK>
0x937D<SEP>0x455E<SEP>0x515A<SEP3>// <CJK>
0x937E<SEP>0x455F<SEP>0x51AC<SEP3>// <CJK>
0x9380<SEP>0x4560<SEP>0x51CD<SEP3>// <CJK>
0x9381<SEP>0x4561<SEP>0x5200<SEP3>// <CJK>
0x9382<SEP>0x4562<SEP>0x5510<SEP3>// <CJK>
0x9383<SEP>0x4563<SEP>0x5854<SEP3>// <CJK>
0x9384<SEP>0x4564<SEP>0x5858<SEP3>// <CJK>
0x9385<SEP>0x4565<SEP>0x5957<SEP3>// <CJK>
0x9386<SEP>0x4566<SEP>0x5B95<SEP3>// <CJK>
0x9387<SEP>0x4567<SEP>0x5CF6<SEP3>// <CJK>
0x9388<SEP>0x4568<SEP>0x5D8B<SEP3>// <CJK>
0x9389<SEP>0x4569<SEP>0x60BC<SEP3>// <CJK>
0x938A<SEP>0x456A<SEP>0x6295<SEP3>// <CJK>
0x938B<SEP>0x456B<SEP>0x642D<SEP3>// <CJK>
0x938C<SEP>0x456C<SEP>0x6771<SEP3>// <CJK>
0x938D<SEP>0x456D<SEP>0x6843<SEP3>// <CJK>
0x938E<SEP>0x456E<SEP>0x68BC<SEP3>// <CJK>
0x938F<SEP>0x456F<SEP>0x68DF<SEP3>// <CJK>
0x9390<SEP>0x4570<SEP>0x76D7<SEP3>// <CJK>
0x9391<SEP>0x4571<SEP>0x6DD8<SEP3>// <CJK>
0x9392<SEP>0x4572<SEP>0x6E6F<SEP3>// <CJK>
0x9393<SEP>0x4573<SEP>0x6D9B<SEP3>// <CJK>
0x9394<SEP>0x4574<SEP>0x706F<SEP3>// <CJK>
0x9395<SEP>0x4575<SEP>0x71C8<SEP3>// <CJK>
0x9396<SEP>0x4576<SEP>0x5F53<SEP3>// <CJK>
0x9397<SEP>0x4577<SEP>0x75D8<SEP3>// <CJK>
0x9398<SEP>0x4578<SEP>0x7977<SEP3>// <CJK>
0x9399<SEP>0x4579<SEP>0x7B49<SEP3>// <CJK>
0x939A<SEP>0x457A<SEP>0x7B54<SEP3>// <CJK>
0x939B<SEP>0x457B<SEP>0x7B52<SEP3>// <CJK>
0x939C<SEP>0x457C<SEP>0x7CD6<SEP3>// <CJK>
0x939D<SEP>0x457D<SEP>0x7D71<SEP3>// <CJK>
0x939E<SEP>0x457E<SEP>0x5230<SEP3>// <CJK>
0x939F<SEP>0x4621<SEP>0x8463<SEP3>// <CJK>
0x93A0<SEP>0x4622<SEP>0x8569<SEP3>// <CJK>
0x93A1<SEP>0x4623<SEP>0x85E4<SEP3>// <CJK>
0x93A2<SEP>0x4624<SEP>0x8A0E<SEP3>// <CJK>
0x93A3<SEP>0x4625<SEP>0x8B04<SEP3>// <CJK>
0x93A4<SEP>0x4626<SEP>0x8C46<SEP3>// <CJK>
0x93A5<SEP>0x4627<SEP>0x8E0F<SEP3>// <CJK>
0x93A6<SEP>0x4628<SEP>0x9003<SEP3>// <CJK>
0x93A7<SEP>0x4629<SEP>0x900F<SEP3>// <CJK>
0x93A8<SEP>0x462A<SEP>0x9419<SEP3>// <CJK>
0x93A9<SEP>0x462B<SEP>0x9676<SEP3>// <CJK>
0x93AA<SEP>0x462C<SEP>0x982D<SEP3>// <CJK>
0x93AB<SEP>0x462D<SEP>0x9A30<SEP3>// <CJK>
0x93AC<SEP>0x462E<SEP>0x95D8<SEP3>// <CJK>
0x93AD<SEP>0x462F<SEP>0x50CD<SEP3>// <CJK>
0x93AE<SEP>0x4630<SEP>0x52D5<SEP3>// <CJK>
0x93AF<SEP>0x4631<SEP>0x540C<SEP3>// <CJK>
0x93B0<SEP>0x4632<SEP>0x5802<SEP3>// <CJK>
0x93B1<SEP>0x4633<SEP>0x5C0E<SEP3>// <CJK>
0x93B2<SEP>0x4634<SEP>0x61A7<SEP3>// <CJK>
0x93B3<SEP>0x4635<SEP>0x649E<SEP3>// <CJK>
0x93B4<SEP>0x4636<SEP>0x6D1E<SEP3>// <CJK>
0x93B5<SEP>0x4637<SEP>0x77B3<SEP3>// <CJK>
0x93B6<SEP>0x4638<SEP>0x7AE5<SEP3>// <CJK>
0x93B7<SEP>0x4639<SEP>0x80F4<SEP3>// <CJK>
0x93B8<SEP>0x463A<SEP>0x8404<SEP3>// <CJK>
0x93B9<SEP>0x463B<SEP>0x9053<SEP3>// <CJK>
0x93BA<SEP>0x463C<SEP>0x9285<SEP3>// <CJK>
0x93BB<SEP>0x463D<SEP>0x5CE0<SEP3>// <CJK>
0x93BC<SEP>0x463E<SEP>0x9D07<SEP3>// <CJK>
0x93BD<SEP>0x463F<SEP>0x533F<SEP3>// <CJK>
0x93BE<SEP>0x4640<SEP>0x5F97<SEP3>// <CJK>
0x93BF<SEP>0x4641<SEP>0x5FB3<SEP3>// <CJK>
0x93C0<SEP>0x4642<SEP>0x6D9C<SEP3>// <CJK>
0x93C1<SEP>0x4643<SEP>0x7279<SEP3>// <CJK>
0x93C2<SEP>0x4644<SEP>0x7763<SEP3>// <CJK>
0x93C3<SEP>0x4645<SEP>0x79BF<SEP3>// <CJK>
0x93C4<SEP>0x4646<SEP>0x7BE4<SEP3>// <CJK>
0x93C5<SEP>0x4647<SEP>0x6BD2<SEP3>// <CJK>
0x93C6<SEP>0x4648<SEP>0x72EC<SEP3>// <CJK>
0x93C7<SEP>0x4649<SEP>0x8AAD<SEP3>// <CJK>
0x93C8<SEP>0x464A<SEP>0x6803<SEP3>// <CJK>
0x93C9<SEP>0x464B<SEP>0x6A61<SEP3>// <CJK>
0x93CA<SEP>0x464C<SEP>0x51F8<SEP3>// <CJK>
0x93CB<SEP>0x464D<SEP>0x7A81<SEP3>// <CJK>
0x93CC<SEP>0x464E<SEP>0x6934<SEP3>// <CJK>
0x93CD<SEP>0x464F<SEP>0x5C4A<SEP3>// <CJK>
0x93CE<SEP>0x4650<SEP>0x9CF6<SEP3>// <CJK>
0x93CF<SEP>0x4651<SEP>0x82EB<SEP3>// <CJK>
0x93D0<SEP>0x4652<SEP>0x5BC5<SEP3>// <CJK>
0x93D1<SEP>0x4653<SEP>0x9149<SEP3>// <CJK>
0x93D2<SEP>0x4654<SEP>0x701E<SEP3>// <CJK>
0x93D3<SEP>0x4655<SEP>0x5678<SEP3>// <CJK>
0x93D4<SEP>0x4656<SEP>0x5C6F<SEP3>// <CJK>
0x93D5<SEP>0x4657<SEP>0x60C7<SEP3>// <CJK>
0x93D6<SEP>0x4658<SEP>0x6566<SEP3>// <CJK>
0x93D7<SEP>0x4659<SEP>0x6C8C<SEP3>// <CJK>
0x93D8<SEP>0x465A<SEP>0x8C5A<SEP3>// <CJK>
0x93D9<SEP>0x465B<SEP>0x9041<SEP3>// <CJK>
0x93DA<SEP>0x465C<SEP>0x9813<SEP3>// <CJK>
0x93DB<SEP>0x465D<SEP>0x5451<SEP3>// <CJK>
0x93DC<SEP>0x465E<SEP>0x66C7<SEP3>// <CJK>
0x93DD<SEP>0x465F<SEP>0x920D<SEP3>// <CJK>
0x93DE<SEP>0x4660<SEP>0x5948<SEP3>// <CJK>
0x93DF<SEP>0x4661<SEP>0x90A3<SEP3>// <CJK>
0x93E0<SEP>0x4662<SEP>0x5185<SEP3>// <CJK>
0x93E1<SEP>0x4663<SEP>0x4E4D<SEP3>// <CJK>
0x93E2<SEP>0x4664<SEP>0x51EA<SEP3>// <CJK>
0x93E3<SEP>0x4665<SEP>0x8599<SEP3>// <CJK>
0x93E4<SEP>0x4666<SEP>0x8B0E<SEP3>// <CJK>
0x93E5<SEP>0x4667<SEP>0x7058<SEP3>// <CJK>
0x93E6<SEP>0x4668<SEP>0x637A<SEP3>// <CJK>
0x93E7<SEP>0x4669<SEP>0x934B<SEP3>// <CJK>
0x93E8<SEP>0x466A<SEP>0x6962<SEP3>// <CJK>
0x93E9<SEP>0x466B<SEP>0x99B4<SEP3>// <CJK>
0x93EA<SEP>0x466C<SEP>0x7E04<SEP3>// <CJK>
0x93EB<SEP>0x466D<SEP>0x7577<SEP3>// <CJK>
0x93EC<SEP>0x466E<SEP>0x5357<SEP3>// <CJK>
0x93ED<SEP>0x466F<SEP>0x6960<SEP3>// <CJK>
0x93EE<SEP>0x4670<SEP>0x8EDF<SEP3>// <CJK>
0x93EF<SEP>0x4671<SEP>0x96E3<SEP3>// <CJK>
0x93F0<SEP>0x4672<SEP>0x6C5D<SEP3>// <CJK>
0x93F1<SEP>0x4673<SEP>0x4E8C<SEP3>// <CJK>
0x93F2<SEP>0x4674<SEP>0x5C3C<SEP3>// <CJK>
0x93F3<SEP>0x4675<SEP>0x5F10<SEP3>// <CJK>
0x93F4<SEP>0x4676<SEP>0x8FE9<SEP3>// <CJK>
0x93F5<SEP>0x4677<SEP>0x5302<SEP3>// <CJK>
0x93F6<SEP>0x4678<SEP>0x8CD1<SEP3>// <CJK>
0x93F7<SEP>0x4679<SEP>0x8089<SEP3>// <CJK>
0x93F8<SEP>0x467A<SEP>0x8679<SEP3>// <CJK>
0x93F9<SEP>0x467B<SEP>0x5EFF<SEP3>// <CJK>
0x93FA<SEP>0x467C<SEP>0x65E5<SEP3>// <CJK>
0x93FB<SEP>0x467D<SEP>0x4E73<SEP3>// <CJK>
0x93FC<SEP>0x467E<SEP>0x5165<SEP3>// <CJK>
0x9440<SEP>0x4721<SEP>0x5982<SEP3>// <CJK>
0x9441<SEP>0x4722<SEP>0x5C3F<SEP3>// <CJK>
0x9442<SEP>0x4723<SEP>0x97EE<SEP3>// <CJK>
0x9443<SEP>0x4724<SEP>0x4EFB<SEP3>// <CJK>
0x9444<SEP>0x4725<SEP>0x598A<SEP3>// <CJK>
0x9445<SEP>0x4726<SEP>0x5FCD<SEP3>// <CJK>
0x9446<SEP>0x4727<SEP>0x8A8D<SEP3>// <CJK>
0x9447<SEP>0x4728<SEP>0x6FE1<SEP3>// <CJK>
0x9448<SEP>0x4729<SEP>0x79B0<SEP3>// <CJK>
0x9449<SEP>0x472A<SEP>0x7962<SEP3>// <CJK>
0x944A<SEP>0x472B<SEP>0x5BE7<SEP3>// <CJK>
0x944B<SEP>0x472C<SEP>0x8471<SEP3>// <CJK>
0x944C<SEP>0x472D<SEP>0x732B<SEP3>// <CJK>
0x944D<SEP>0x472E<SEP>0x71B1<SEP3>// <CJK>
0x944E<SEP>0x472F<SEP>0x5E74<SEP3>// <CJK>
0x944F<SEP>0x4730<SEP>0x5FF5<SEP3>// <CJK>
0x9450<SEP>0x4731<SEP>0x637B<SEP3>// <CJK>
0x9451<SEP>0x4732<SEP>0x649A<SEP3>// <CJK>
0x9452<SEP>0x4733<SEP>0x71C3<SEP3>// <CJK>
0x9453<SEP>0x4734<SEP>0x7C98<SEP3>// <CJK>
0x9454<SEP>0x4735<SEP>0x4E43<SEP3>// <CJK>
0x9455<SEP>0x4736<SEP>0x5EFC<SEP3>// <CJK>
0x9456<SEP>0x4737<SEP>0x4E4B<SEP3>// <CJK>
0x9457<SEP>0x4738<SEP>0x57DC<SEP3>// <CJK>
0x9458<SEP>0x4739<SEP>0x56A2<SEP3>// <CJK>
0x9459<SEP>0x473A<SEP>0x60A9<SEP3>// <CJK>
0x945A<SEP>0x473B<SEP>0x6FC3<SEP3>// <CJK>
0x945B<SEP>0x473C<SEP>0x7D0D<SEP3>// <CJK>
0x945C<SEP>0x473D<SEP>0x80FD<SEP3>// <CJK>
0x945D<SEP>0x473E<SEP>0x8133<SEP3>// <CJK>
0x945E<SEP>0x473F<SEP>0x81BF<SEP3>// <CJK>
0x945F<SEP>0x4740<SEP>0x8FB2<SEP3>// <CJK>
0x9460<SEP>0x4741<SEP>0x8997<SEP3>// <CJK>
0x9461<SEP>0x4742<SEP>0x86A4<SEP3>// <CJK>
0x9462<SEP>0x4743<SEP>0x5DF4<SEP3>// <CJK>
0x9463<SEP>0x4744<SEP>0x628A<SEP3>// <CJK>
0x9464<SEP>0x4745<SEP>0x64AD<SEP3>// <CJK>
0x9465<SEP>0x4746<SEP>0x8987<SEP3>// <CJK>
0x9466<SEP>0x4747<SEP>0x6777<SEP3>// <CJK>
0x9467<SEP>0x4748<SEP>0x6CE2<SEP3>// <CJK>
0x9468<SEP>0x4749<SEP>0x6D3E<SEP3>// <CJK>
0x9469<SEP>0x474A<SEP>0x7436<SEP3>// <CJK>
0x946A<SEP>0x474B<SEP>0x7834<SEP3>// <CJK>
0x946B<SEP>0x474C<SEP>0x5A46<SEP3>// <CJK>
0x946C<SEP>0x474D<SEP>0x7F75<SEP3>// <CJK>
0x946D<SEP>0x474E<SEP>0x82AD<SEP3>// <CJK>
0x946E<SEP>0x474F<SEP>0x99AC<SEP3>// <CJK>
0x946F<SEP>0x4750<SEP>0x4FF3<SEP3>// <CJK>
0x9470<SEP>0x4751<SEP>0x5EC3<SEP3>// <CJK>
0x9471<SEP>0x4752<SEP>0x62DD<SEP3>// <CJK>
0x9472<SEP>0x4753<SEP>0x6392<SEP3>// <CJK>
0x9473<SEP>0x4754<SEP>0x6557<SEP3>// <CJK>
0x9474<SEP>0x4755<SEP>0x676F<SEP3>// <CJK>
0x9475<SEP>0x4756<SEP>0x76C3<SEP3>// <CJK>
0x9476<SEP>0x4757<SEP>0x724C<SEP3>// <CJK>
0x9477<SEP>0x4758<SEP>0x80CC<SEP3>// <CJK>
0x9478<SEP>0x4759<SEP>0x80BA<SEP3>// <CJK>
0x9479<SEP>0x475A<SEP>0x8F29<SEP3>// <CJK>
0x947A<SEP>0x475B<SEP>0x914D<SEP3>// <CJK>
0x947B<SEP>0x475C<SEP>0x500D<SEP3>// <CJK>
0x947C<SEP>0x475D<SEP>0x57F9<SEP3>// <CJK>
0x947D<SEP>0x475E<SEP>0x5A92<SEP3>// <CJK>
0x947E<SEP>0x475F<SEP>0x6885<SEP3>// <CJK>
0x9480<SEP>0x4760<SEP>0x6973<SEP3>// <CJK>
0x9481<SEP>0x4761<SEP>0x7164<SEP3>// <CJK>
0x9482<SEP>0x4762<SEP>0x72FD<SEP3>// <CJK>
0x9483<SEP>0x4763<SEP>0x8CB7<SEP3>// <CJK>
0x9484<SEP>0x4764<SEP>0x58F2<SEP3>// <CJK>
0x9485<SEP>0x4765<SEP>0x8CE0<SEP3>// <CJK>
0x9486<SEP>0x4766<SEP>0x966A<SEP3>// <CJK>
0x9487<SEP>0x4767<SEP>0x9019<SEP3>// <CJK>
0x9488<SEP>0x4768<SEP>0x877F<SEP3>// <CJK>
0x9489<SEP>0x4769<SEP>0x79E4<SEP3>// <CJK>
0x948A<SEP>0x476A<SEP>0x77E7<SEP3>// <CJK>
0x948B<SEP>0x476B<SEP>0x8429<SEP3>// <CJK>
0x948C<SEP>0x476C<SEP>0x4F2F<SEP3>// <CJK>
0x948D<SEP>0x476D<SEP>0x5265<SEP3>// <CJK>
0x948E<SEP>0x476E<SEP>0x535A<SEP3>// <CJK>
0x948F<SEP>0x476F<SEP>0x62CD<SEP3>// <CJK>
0x9490<SEP>0x4770<SEP>0x67CF<SEP3>// <CJK>
0x9491<SEP>0x4771<SEP>0x6CCA<SEP3>// <CJK>
0x9492<SEP>0x4772<SEP>0x767D<SEP3>// <CJK>
0x9493<SEP>0x4773<SEP>0x7B94<SEP3>// <CJK>
0x9494<SEP>0x4774<SEP>0x7C95<SEP3>// <CJK>
0x9495<SEP>0x4775<SEP>0x8236<SEP3>// <CJK>
0x9496<SEP>0x4776<SEP>0x8584<SEP3>// <CJK>
0x9497<SEP>0x4777<SEP>0x8FEB<SEP3>// <CJK>
0x9498<SEP>0x4778<SEP>0x66DD<SEP3>// <CJK>
0x9499<SEP>0x4779<SEP>0x6F20<SEP3>// <CJK>
0x949A<SEP>0x477A<SEP>0x7206<SEP3>// <CJK>
0x949B<SEP>0x477B<SEP>0x7E1B<SEP3>// <CJK>
0x949C<SEP>0x477C<SEP>0x83AB<SEP3>// <CJK>
0x949D<SEP>0x477D<SEP>0x99C1<SEP3>// <CJK>
0x949E<SEP>0x477E<SEP>0x9EA6<SEP3>// <CJK>
0x949F<SEP>0x4821<SEP>0x51FD<SEP3>// <CJK>
0x94A0<SEP>0x4822<SEP>0x7BB1<SEP3>// <CJK>
0x94A1<SEP>0x4823<SEP>0x7872<SEP3>// <CJK>
0x94A2<SEP>0x4824<SEP>0x7BB8<SEP3>// <CJK>
0x94A3<SEP>0x4825<SEP>0x8087<SEP3>// <CJK>
0x94A4<SEP>0x4826<SEP>0x7B48<SEP3>// <CJK>
0x94A5<SEP>0x4827<SEP>0x6AE8<SEP3>// <CJK>
0x94A6<SEP>0x4828<SEP>0x5E61<SEP3>// <CJK>
0x94A7<SEP>0x4829<SEP>0x808C<SEP3>// <CJK>
0x94A8<SEP>0x482A<SEP>0x7551<SEP3>// <CJK>
0x94A9<SEP>0x482B<SEP>0x7560<SEP3>// <CJK>
0x94AA<SEP>0x482C<SEP>0x516B<SEP3>// <CJK>
0x94AB<SEP>0x482D<SEP>0x9262<SEP3>// <CJK>
0x94AC<SEP>0x482E<SEP>0x6E8C<SEP3>// <CJK>
0x94AD<SEP>0x482F<SEP>0x767A<SEP3>// <CJK>
0x94AE<SEP>0x4830<SEP>0x9197<SEP3>// <CJK>
0x94AF<SEP>0x4831<SEP>0x9AEA<SEP3>// <CJK>
0x94B0<SEP>0x4832<SEP>0x4F10<SEP3>// <CJK>
0x94B1<SEP>0x4833<SEP>0x7F70<SEP3>// <CJK>
0x94B2<SEP>0x4834<SEP>0x629C<SEP3>// <CJK>
0x94B3<SEP>0x4835<SEP>0x7B4F<SEP3>// <CJK>
0x94B4<SEP>0x4836<SEP>0x95A5<SEP3>// <CJK>
0x94B5<SEP>0x4837<SEP>0x9CE9<SEP3>// <CJK>
0x94B6<SEP>0x4838<SEP>0x567A<SEP3>// <CJK>
0x94B7<SEP>0x4839<SEP>0x5859<SEP3>// <CJK>
0x94B8<SEP>0x483A<SEP>0x86E4<SEP3>// <CJK>
0x94B9<SEP>0x483B<SEP>0x96BC<SEP3>// <CJK>
0x94BA<SEP>0x483C<SEP>0x4F34<SEP3>// <CJK>
0x94BB<SEP>0x483D<SEP>0x5224<SEP3>// <CJK>
0x94BC<SEP>0x483E<SEP>0x534A<SEP3>// <CJK>
0x94BD<SEP>0x483F<SEP>0x53CD<SEP3>// <CJK>
0x94BE<SEP>0x4840<SEP>0x53DB<SEP3>// <CJK>
0x94BF<SEP>0x4841<SEP>0x5E06<SEP3>// <CJK>
0x94C0<SEP>0x4842<SEP>0x642C<SEP3>// <CJK>
0x94C1<SEP>0x4843<SEP>0x6591<SEP3>// <CJK>
0x94C2<SEP>0x4844<SEP>0x677F<SEP3>// <CJK>
0x94C3<SEP>0x4845<SEP>0x6C3E<SEP3>// <CJK>
0x94C4<SEP>0x4846<SEP>0x6C4E<SEP3>// <CJK>
0x94C5<SEP>0x4847<SEP>0x7248<SEP3>// <CJK>
0x94C6<SEP>0x4848<SEP>0x72AF<SEP3>// <CJK>
0x94C7<SEP>0x4849<SEP>0x73ED<SEP3>// <CJK>
0x94C8<SEP>0x484A<SEP>0x7554<SEP3>// <CJK>
0x94C9<SEP>0x484B<SEP>0x7E41<SEP3>// <CJK>
0x94CA<SEP>0x484C<SEP>0x822C<SEP3>// <CJK>
0x94CB<SEP>0x484D<SEP>0x85E9<SEP3>// <CJK>
0x94CC<SEP>0x484E<SEP>0x8CA9<SEP3>// <CJK>
0x94CD<SEP>0x484F<SEP>0x7BC4<SEP3>// <CJK>
0x94CE<SEP>0x4850<SEP>0x91C6<SEP3>// <CJK>
0x94CF<SEP>0x4851<SEP>0x7169<SEP3>// <CJK>
0x94D0<SEP>0x4852<SEP>0x9812<SEP3>// <CJK>
0x94D1<SEP>0x4853<SEP>0x98EF<SEP3>// <CJK>
0x94D2<SEP>0x4854<SEP>0x633D<SEP3>// <CJK>
0x94D3<SEP>0x4855<SEP>0x6669<SEP3>// <CJK>
0x94D4<SEP>0x4856<SEP>0x756A<SEP3>// <CJK>
0x94D5<SEP>0x4857<SEP>0x76E4<SEP3>// <CJK>
0x94D6<SEP>0x4858<SEP>0x78D0<SEP3>// <CJK>
0x94D7<SEP>0x4859<SEP>0x8543<SEP3>// <CJK>
0x94D8<SEP>0x485A<SEP>0x86EE<SEP3>// <CJK>
0x94D9<SEP>0x485B<SEP>0x532A<SEP3>// <CJK>
0x94DA<SEP>0x485C<SEP>0x5351<SEP3>// <CJK>
0x94DB<SEP>0x485D<SEP>0x5426<SEP3>// <CJK>
0x94DC<SEP>0x485E<SEP>0x5983<SEP3>// <CJK>
0x94DD<SEP>0x485F<SEP>0x5E87<SEP3>// <CJK>
0x94DE<SEP>0x4860<SEP>0x5F7C<SEP3>// <CJK>
0x94DF<SEP>0x4861<SEP>0x60B2<SEP3>// <CJK>
0x94E0<SEP>0x4862<SEP>0x6249<SEP3>// <CJK>
0x94E1<SEP>0x4863<SEP>0x6279<SEP3>// <CJK>
0x94E2<SEP>0x4864<SEP>0x62AB<SEP3>// <CJK>
0x94E3<SEP>0x4865<SEP>0x6590<SEP3>// <CJK>
0x94E4<SEP>0x4866<SEP>0x6BD4<SEP3>// <CJK>
0x94E5<SEP>0x4867<SEP>0x6CCC<SEP3>// <CJK>
0x94E6<SEP>0x4868<SEP>0x75B2<SEP3>// <CJK>
0x94E7<SEP>0x4869<SEP>0x76AE<SEP3>// <CJK>
0x94E8<SEP>0x486A<SEP>0x7891<SEP3>// <CJK>
0x94E9<SEP>0x486B<SEP>0x79D8<SEP3>// <CJK>
0x94EA<SEP>0x486C<SEP>0x7DCB<SEP3>// <CJK>
0x94EB<SEP>0x486D<SEP>0x7F77<SEP3>// <CJK>
0x94EC<SEP>0x486E<SEP>0x80A5<SEP3>// <CJK>
0x94ED<SEP>0x486F<SEP>0x88AB<SEP3>// <CJK>
0x94EE<SEP>0x4870<SEP>0x8AB9<SEP3>// <CJK>
0x94EF<SEP>0x4871<SEP>0x8CBB<SEP3>// <CJK>
0x94F0<SEP>0x4872<SEP>0x907F<SEP3>// <CJK>
0x94F1<SEP>0x4873<SEP>0x975E<SEP3>// <CJK>
0x94F2<SEP>0x4874<SEP>0x98DB<SEP3>// <CJK>
0x94F3<SEP>0x4875<SEP>0x6A0B<SEP3>// <CJK>
0x94F4<SEP>0x4876<SEP>0x7C38<SEP3>// <CJK>
0x94F5<SEP>0x4877<SEP>0x5099<SEP3>// <CJK>
0x94F6<SEP>0x4878<SEP>0x5C3E<SEP3>// <CJK>
0x94F7<SEP>0x4879<SEP>0x5FAE<SEP3>// <CJK>
0x94F8<SEP>0x487A<SEP>0x6787<SEP3>// <CJK>
0x94F9<SEP>0x487B<SEP>0x6BD8<SEP3>// <CJK>
0x94FA<SEP>0x487C<SEP>0x7435<SEP3>// <CJK>
0x94FB<SEP>0x487D<SEP>0x7709<SEP3>// <CJK>
0x94FC<SEP>0x487E<SEP>0x7F8E<SEP3>// <CJK>
0x9540<SEP>0x4921<SEP>0x9F3B<SEP3>// <CJK>
0x9541<SEP>0x4922<SEP>0x67CA<SEP3>// <CJK>
0x9542<SEP>0x4923<SEP>0x7A17<SEP3>// <CJK>
0x9543<SEP>0x4924<SEP>0x5339<SEP3>// <CJK>
0x9544<SEP>0x4925<SEP>0x758B<SEP3>// <CJK>
0x9545<SEP>0x4926<SEP>0x9AED<SEP3>// <CJK>
0x9546<SEP>0x4927<SEP>0x5F66<SEP3>// <CJK>
0x9547<SEP>0x4928<SEP>0x819D<SEP3>// <CJK>
0x9548<SEP>0x4929<SEP>0x83F1<SEP3>// <CJK>
0x9549<SEP>0x492A<SEP>0x8098<SEP3>// <CJK>
0x954A<SEP>0x492B<SEP>0x5F3C<SEP3>// <CJK>
0x954B<SEP>0x492C<SEP>0x5FC5<SEP3>// <CJK>
0x954C<SEP>0x492D<SEP>0x7562<SEP3>// <CJK>
0x954D<SEP>0x492E<SEP>0x7B46<SEP3>// <CJK>
0x954E<SEP>0x492F<SEP>0x903C<SEP3>// <CJK>
0x954F<SEP>0x4930<SEP>0x6867<SEP3>// <CJK>
0x9550<SEP>0x4931<SEP>0x59EB<SEP3>// <CJK>
0x9551<SEP>0x4932<SEP>0x5A9B<SEP3>// <CJK>
0x9552<SEP>0x4933<SEP>0x7D10<SEP3>// <CJK>
0x9553<SEP>0x4934<SEP>0x767E<SEP3>// <CJK>
0x9554<SEP>0x4935<SEP>0x8B2C<SEP3>// <CJK>
0x9555<SEP>0x4936<SEP>0x4FF5<SEP3>// <CJK>
0x9556<SEP>0x4937<SEP>0x5F6A<SEP3>// <CJK>
0x9557<SEP>0x4938<SEP>0x6A19<SEP3>// <CJK>
0x9558<SEP>0x4939<SEP>0x6C37<SEP3>// <CJK>
0x9559<SEP>0x493A<SEP>0x6F02<SEP3>// <CJK>
0x955A<SEP>0x493B<SEP>0x74E2<SEP3>// <CJK>
0x955B<SEP>0x493C<SEP>0x7968<SEP3>// <CJK>
0x955C<SEP>0x493D<SEP>0x8868<SEP3>// <CJK>
0x955D<SEP>0x493E<SEP>0x8A55<SEP3>// <CJK>
0x955E<SEP>0x493F<SEP>0x8C79<SEP3>// <CJK>
0x955F<SEP>0x4940<SEP>0x5EDF<SEP3>// <CJK>
0x9560<SEP>0x4941<SEP>0x63CF<SEP3>// <CJK>
0x9561<SEP>0x4942<SEP>0x75C5<SEP3>// <CJK>
0x9562<SEP>0x4943<SEP>0x79D2<SEP3>// <CJK>
0x9563<SEP>0x4944<SEP>0x82D7<SEP3>// <CJK>
0x9564<SEP>0x4945<SEP>0x9328<SEP3>// <CJK>
0x9565<SEP>0x4946<SEP>0x92F2<SEP3>// <CJK>
0x9566<SEP>0x4947<SEP>0x849C<SEP3>// <CJK>
0x9567<SEP>0x4948<SEP>0x86ED<SEP3>// <CJK>
0x9568<SEP>0x4949<SEP>0x9C2D<SEP3>// <CJK>
0x9569<SEP>0x494A<SEP>0x54C1<SEP3>// <CJK>
0x956A<SEP>0x494B<SEP>0x5F6C<SEP3>// <CJK>
0x956B<SEP>0x494C<SEP>0x658C<SEP3>// <CJK>
0x956C<SEP>0x494D<SEP>0x6D5C<SEP3>// <CJK>
0x956D<SEP>0x494E<SEP>0x7015<SEP3>// <CJK>
0x956E<SEP>0x494F<SEP>0x8CA7<SEP3>// <CJK>
0x956F<SEP>0x4950<SEP>0x8CD3<SEP3>// <CJK>
0x9570<SEP>0x4951<SEP>0x983B<SEP3>// <CJK>
0x9571<SEP>0x4952<SEP>0x654F<SEP3>// <CJK>
0x9572<SEP>0x4953<SEP>0x74F6<SEP3>// <CJK>
0x9573<SEP>0x4954<SEP>0x4E0D<SEP3>// <CJK>
0x9574<SEP>0x4955<SEP>0x4ED8<SEP3>// <CJK>
0x9575<SEP>0x4956<SEP>0x57E0<SEP3>// <CJK>
0x9576<SEP>0x4957<SEP>0x592B<SEP3>// <CJK>
0x9577<SEP>0x4958<SEP>0x5A66<SEP3>// <CJK>
0x9578<SEP>0x4959<SEP>0x5BCC<SEP3>// <CJK>
0x9579<SEP>0x495A<SEP>0x51A8<SEP3>// <CJK>
0x957A<SEP>0x495B<SEP>0x5E03<SEP3>// <CJK>
0x957B<SEP>0x495C<SEP>0x5E9C<SEP3>// <CJK>
0x957C<SEP>0x495D<SEP>0x6016<SEP3>// <CJK>
0x957D<SEP>0x495E<SEP>0x6276<SEP3>// <CJK>
0x957E<SEP>0x495F<SEP>0x6577<SEP3>// <CJK>
0x9580<SEP>0x4960<SEP>0x65A7<SEP3>// <CJK>
0x9581<SEP>0x4961<SEP>0x666E<SEP3>// <CJK>
0x9582<SEP>0x4962<SEP>0x6D6E<SEP3>// <CJK>
0x9583<SEP>0x4963<SEP>0x7236<SEP3>// <CJK>
0x9584<SEP>0x4964<SEP>0x7B26<SEP3>// <CJK>
0x9585<SEP>0x4965<SEP>0x8150<SEP3>// <CJK>
0x9586<SEP>0x4966<SEP>0x819A<SEP3>// <CJK>
0x9587<SEP>0x4967<SEP>0x8299<SEP3>// <CJK>
0x9588<SEP>0x4968<SEP>0x8B5C<SEP3>// <CJK>
0x9589<SEP>0x4969<SEP>0x8CA0<SEP3>// <CJK>
0x958A<SEP>0x496A<SEP>0x8CE6<SEP3>// <CJK>
0x958B<SEP>0x496B<SEP>0x8D74<SEP3>// <CJK>
0x958C<SEP>0x496C<SEP>0x961C<SEP3>// <CJK>
0x958D<SEP>0x496D<SEP>0x9644<SEP3>// <CJK>
0x958E<SEP>0x496E<SEP>0x4FAE<SEP3>// <CJK>
0x958F<SEP>0x496F<SEP>0x64AB<SEP3>// <CJK>
0x9590<SEP>0x4970<SEP>0x6B66<SEP3>// <CJK>
0x9591<SEP>0x4971<SEP>0x821E<SEP3>// <CJK>
0x9592<SEP>0x4972<SEP>0x8461<SEP3>// <CJK>
0x9593<SEP>0x4973<SEP>0x856A<SEP3>// <CJK>
0x9594<SEP>0x4974<SEP>0x90E8<SEP3>// <CJK>
0x9595<SEP>0x4975<SEP>0x5C01<SEP3>// <CJK>
0x9596<SEP>0x4976<SEP>0x6953<SEP3>// <CJK>
0x9597<SEP>0x4977<SEP>0x98A8<SEP3>// <CJK>
0x9598<SEP>0x4978<SEP>0x847A<SEP3>// <CJK>
0x9599<SEP>0x4979<SEP>0x8557<SEP3>// <CJK>
0x959A<SEP>0x497A<SEP>0x4F0F<SEP3>// <CJK>
0x959B<SEP>0x497B<SEP>0x526F<SEP3>// <CJK>
0x959C<SEP>0x497C<SEP>0x5FA9<SEP3>// <CJK>
0x959D<SEP>0x497D<SEP>0x5E45<SEP3>// <CJK>
0x959E<SEP>0x497E<SEP>0x670D<SEP3>// <CJK>
0x959F<SEP>0x4A21<SEP>0x798F<SEP3>// <CJK>
0x95A0<SEP>0x4A22<SEP>0x8179<SEP3>// <CJK>
0x95A1<SEP>0x4A23<SEP>0x8907<SEP3>// <CJK>
0x95A2<SEP>0x4A24<SEP>0x8986<SEP3>// <CJK>
0x95A3<SEP>0x4A25<SEP>0x6DF5<SEP3>// <CJK>
0x95A4<SEP>0x4A26<SEP>0x5F17<SEP3>// <CJK>
0x95A5<SEP>0x4A27<SEP>0x6255<SEP3>// <CJK>
0x95A6<SEP>0x4A28<SEP>0x6CB8<SEP3>// <CJK>
0x95A7<SEP>0x4A29<SEP>0x4ECF<SEP3>// <CJK>
0x95A8<SEP>0x4A2A<SEP>0x7269<SEP3>// <CJK>
0x95A9<SEP>0x4A2B<SEP>0x9B92<SEP3>// <CJK>
0x95AA<SEP>0x4A2C<SEP>0x5206<SEP3>// <CJK>
0x95AB<SEP>0x4A2D<SEP>0x543B<SEP3>// <CJK>
0x95AC<SEP>0x4A2E<SEP>0x5674<SEP3>// <CJK>
0x95AD<SEP>0x4A2F<SEP>0x58B3<SEP3>// <CJK>
0x95AE<SEP>0x4A30<SEP>0x61A4<SEP3>// <CJK>
0x95AF<SEP>0x4A31<SEP>0x626E<SEP3>// <CJK>
0x95B0<SEP>0x4A32<SEP>0x711A<SEP3>// <CJK>
0x95B1<SEP>0x4A33<SEP>0x596E<SEP3>// <CJK>
0x95B2<SEP>0x4A34<SEP>0x7C89<SEP3>// <CJK>
0x95B3<SEP>0x4A35<SEP>0x7CDE<SEP3>// <CJK>
0x95B4<SEP>0x4A36<SEP>0x7D1B<SEP3>// <CJK>
0x95B5<SEP>0x4A37<SEP>0x96F0<SEP3>// <CJK>
0x95B6<SEP>0x4A38<SEP>0x6587<SEP3>// <CJK>
0x95B7<SEP>0x4A39<SEP>0x805E<SEP3>// <CJK>
0x95B8<SEP>0x4A3A<SEP>0x4E19<SEP3>// <CJK>
0x95B9<SEP>0x4A3B<SEP>0x4F75<SEP3>// <CJK>
0x95BA<SEP>0x4A3C<SEP>0x5175<SEP3>// <CJK>
0x95BB<SEP>0x4A3D<SEP>0x5840<SEP3>// <CJK>
0x95BC<SEP>0x4A3E<SEP>0x5E63<SEP3>// <CJK>
0x95BD<SEP>0x4A3F<SEP>0x5E73<SEP3>// <CJK>
0x95BE<SEP>0x4A40<SEP>0x5F0A<SEP3>// <CJK>
0x95BF<SEP>0x4A41<SEP>0x67C4<SEP3>// <CJK>
0x95C0<SEP>0x4A42<SEP>0x4E26<SEP3>// <CJK>
0x95C1<SEP>0x4A43<SEP>0x853D<SEP3>// <CJK>
0x95C2<SEP>0x4A44<SEP>0x9589<SEP3>// <CJK>
0x95C3<SEP>0x4A45<SEP>0x965B<SEP3>// <CJK>
0x95C4<SEP>0x4A46<SEP>0x7C73<SEP3>// <CJK>
0x95C5<SEP>0x4A47<SEP>0x9801<SEP3>// <CJK>
0x95C6<SEP>0x4A48<SEP>0x50FB<SEP3>// <CJK>
0x95C7<SEP>0x4A49<SEP>0x58C1<SEP3>// <CJK>
0x95C8<SEP>0x4A4A<SEP>0x7656<SEP3>// <CJK>
0x95C9<SEP>0x4A4B<SEP>0x78A7<SEP3>// <CJK>
0x95CA<SEP>0x4A4C<SEP>0x5225<SEP3>// <CJK>
0x95CB<SEP>0x4A4D<SEP>0x77A5<SEP3>// <CJK>
0x95CC<SEP>0x4A4E<SEP>0x8511<SEP3>// <CJK>
0x95CD<SEP>0x4A4F<SEP>0x7B86<SEP3>// <CJK>
0x95CE<SEP>0x4A50<SEP>0x504F<SEP3>// <CJK>
0x95CF<SEP>0x4A51<SEP>0x5909<SEP3>// <CJK>
0x95D0<SEP>0x4A52<SEP>0x7247<SEP3>// <CJK>
0x95D1<SEP>0x4A53<SEP>0x7BC7<SEP3>// <CJK>
0x95D2<SEP>0x4A54<SEP>0x7DE8<SEP3>// <CJK>
0x95D3<SEP>0x4A55<SEP>0x8FBA<SEP3>// <CJK>
0x95D4<SEP>0x4A56<SEP>0x8FD4<SEP3>// <CJK>
0x95D5<SEP>0x4A57<SEP>0x904D<SEP3>// <CJK>
0x95D6<SEP>0x4A58<SEP>0x4FBF<SEP3>// <CJK>
0x95D7<SEP>0x4A59<SEP>0x52C9<SEP3>// <CJK>
0x95D8<SEP>0x4A5A<SEP>0x5A29<SEP3>// <CJK>
0x95D9<SEP>0x4A5B<SEP>0x5F01<SEP3>// <CJK>
0x95DA<SEP>0x4A5C<SEP>0x97AD<SEP3>// <CJK>
0x95DB<SEP>0x4A5D<SEP>0x4FDD<SEP3>// <CJK>
0x95DC<SEP>0x4A5E<SEP>0x8217<SEP3>// <CJK>
0x95DD<SEP>0x4A5F<SEP>0x92EA<SEP3>// <CJK>
0x95DE<SEP>0x4A60<SEP>0x5703<SEP3>// <CJK>
0x95DF<SEP>0x4A61<SEP>0x6355<SEP3>// <CJK>
0x95E0<SEP>0x4A62<SEP>0x6B69<SEP3>// <CJK>
0x95E1<SEP>0x4A63<SEP>0x752B<SEP3>// <CJK>
0x95E2<SEP>0x4A64<SEP>0x88DC<SEP3>// <CJK>
0x95E3<SEP>0x4A65<SEP>0x8F14<SEP3>// <CJK>
0x95E4<SEP>0x4A66<SEP>0x7A42<SEP3>// <CJK>
0x95E5<SEP>0x4A67<SEP>0x52DF<SEP3>// <CJK>
0x95E6<SEP>0x4A68<SEP>0x5893<SEP3>// <CJK>
0x95E7<SEP>0x4A69<SEP>0x6155<SEP3>// <CJK>
0x95E8<SEP>0x4A6A<SEP>0x620A<SEP3>// <CJK>
0x95E9<SEP>0x4A6B<SEP>0x66AE<SEP3>// <CJK>
0x95EA<SEP>0x4A6C<SEP>0x6BCD<SEP3>// <CJK>
0x95EB<SEP>0x4A6D<SEP>0x7C3F<SEP3>// <CJK>
0x95EC<SEP>0x4A6E<SEP>0x83E9<SEP3>// <CJK>
0x95ED<SEP>0x4A6F<SEP>0x5023<SEP3>// <CJK>
0x95EE<SEP>0x4A70<SEP>0x4FF8<SEP3>// <CJK>
0x95EF<SEP>0x4A71<SEP>0x5305<SEP3>// <CJK>
0x95F0<SEP>0x4A72<SEP>0x5446<SEP3>// <CJK>
0x95F1<SEP>0x4A73<SEP>0x5831<SEP3>// <CJK>
0x95F2<SEP>0x4A74<SEP>0x5949<SEP3>// <CJK>
0x95F3<SEP>0x4A75<SEP>0x5B9D<SEP3>// <CJK>
0x95F4<SEP>0x4A76<SEP>0x5CF0<SEP3>// <CJK>
0x95F5<SEP>0x4A77<SEP>0x5CEF<SEP3>// <CJK>
0x95F6<SEP>0x4A78<SEP>0x5D29<SEP3>// <CJK>
0x95F7<SEP>0x4A79<SEP>0x5E96<SEP3>// <CJK>
0x95F8<SEP>0x4A7A<SEP>0x62B1<SEP3>// <CJK>
0x95F9<SEP>0x4A7B<SEP>0x6367<SEP3>// <CJK>
0x95FA<SEP>0x4A7C<SEP>0x653E<SEP3>// <CJK>
0x95FB<SEP>0x4A7D<SEP>0x65B9<SEP3>// <CJK>
0x95FC<SEP>0x4A7E<SEP>0x670B<SEP3>// <CJK>
0x9640<SEP>0x4B21<SEP>0x6CD5<SEP3>// <CJK>
0x9641<SEP>0x4B22<SEP>0x6CE1<SEP3>// <CJK>
0x9642<SEP>0x4B23<SEP>0x70F9<SEP3>// <CJK>
0x9643<SEP>0x4B24<SEP>0x7832<SEP3>// <CJK>
0x9644<SEP>0x4B25<SEP>0x7E2B<SEP3>// <CJK>
0x9645<SEP>0x4B26<SEP>0x80DE<SEP3>// <CJK>
0x9646<SEP>0x4B27<SEP>0x82B3<SEP3>// <CJK>
0x9647<SEP>0x4B28<SEP>0x840C<SEP3>// <CJK>
0x9648<SEP>0x4B29<SEP>0x84EC<SEP3>// <CJK>
0x9649<SEP>0x4B2A<SEP>0x8702<SEP3>// <CJK>
0x964A<SEP>0x4B2B<SEP>0x8912<SEP3>// <CJK>
0x964B<SEP>0x4B2C<SEP>0x8A2A<SEP3>// <CJK>
0x964C<SEP>0x4B2D<SEP>0x8C4A<SEP3>// <CJK>
0x964D<SEP>0x4B2E<SEP>0x90A6<SEP3>// <CJK>
0x964E<SEP>0x4B2F<SEP>0x92D2<SEP3>// <CJK>
0x964F<SEP>0x4B30<SEP>0x98FD<SEP3>// <CJK>
0x9650<SEP>0x4B31<SEP>0x9CF3<SEP3>// <CJK>
0x9651<SEP>0x4B32<SEP>0x9D6C<SEP3>// <CJK>
0x9652<SEP>0x4B33<SEP>0x4E4F<SEP3>// <CJK>
0x9653<SEP>0x4B34<SEP>0x4EA1<SEP3>// <CJK>
0x9654<SEP>0x4B35<SEP>0x508D<SEP3>// <CJK>
0x9655<SEP>0x4B36<SEP>0x5256<SEP3>// <CJK>
0x9656<SEP>0x4B37<SEP>0x574A<SEP3>// <CJK>
0x9657<SEP>0x4B38<SEP>0x59A8<SEP3>// <CJK>
0x9658<SEP>0x4B39<SEP>0x5E3D<SEP3>// <CJK>
0x9659<SEP>0x4B3A<SEP>0x5FD8<SEP3>// <CJK>
0x965A<SEP>0x4B3B<SEP>0x5FD9<SEP3>// <CJK>
0x965B<SEP>0x4B3C<SEP>0x623F<SEP3>// <CJK>
0x965C<SEP>0x4B3D<SEP>0x66B4<SEP3>// <CJK>
0x965D<SEP>0x4B3E<SEP>0x671B<SEP3>// <CJK>
0x965E<SEP>0x4B3F<SEP>0x67D0<SEP3>// <CJK>
0x965F<SEP>0x4B40<SEP>0x68D2<SEP3>// <CJK>
0x9660<SEP>0x4B41<SEP>0x5192<SEP3>// <CJK>
0x9661<SEP>0x4B42<SEP>0x7D21<SEP3>// <CJK>
0x9662<SEP>0x4B43<SEP>0x80AA<SEP3>// <CJK>
0x9663<SEP>0x4B44<SEP>0x81A8<SEP3>// <CJK>
0x9664<SEP>0x4B45<SEP>0x8B00<SEP3>// <CJK>
0x9665<SEP>0x4B46<SEP>0x8C8C<SEP3>// <CJK>
0x9666<SEP>0x4B47<SEP>0x8CBF<SEP3>// <CJK>
0x9667<SEP>0x4B48<SEP>0x927E<SEP3>// <CJK>
0x9668<SEP>0x4B49<SEP>0x9632<SEP3>// <CJK>
0x9669<SEP>0x4B4A<SEP>0x5420<SEP3>// <CJK>
0x966A<SEP>0x4B4B<SEP>0x982C<SEP3>// <CJK>
0x966B<SEP>0x4B4C<SEP>0x5317<SEP3>// <CJK>
0x966C<SEP>0x4B4D<SEP>0x50D5<SEP3>// <CJK>
0x966D<SEP>0x4B4E<SEP>0x535C<SEP3>// <CJK>
0x966E<SEP>0x4B4F<SEP>0x58A8<SEP3>// <CJK>
0x966F<SEP>0x4B50<SEP>0x64B2<SEP3>// <CJK>
0x9670<SEP>0x4B51<SEP>0x6734<SEP3>// <CJK>
0x9671<SEP>0x4B52<SEP>0x7267<SEP3>// <CJK>
0x9672<SEP>0x4B53<SEP>0x7766<SEP3>// <CJK>
0x9673<SEP>0x4B54<SEP>0x7A46<SEP3>// <CJK>
0x9674<SEP>0x4B55<SEP>0x91E6<SEP3>// <CJK>
0x9675<SEP>0x4B56<SEP>0x52C3<SEP3>// <CJK>
0x9676<SEP>0x4B57<SEP>0x6CA1<SEP3>// <CJK>
0x9677<SEP>0x4B58<SEP>0x6B86<SEP3>// <CJK>
0x9678<SEP>0x4B59<SEP>0x5800<SEP3>// <CJK>
0x9679<SEP>0x4B5A<SEP>0x5E4C<SEP3>// <CJK>
0x967A<SEP>0x4B5B<SEP>0x5954<SEP3>// <CJK>
0x967B<SEP>0x4B5C<SEP>0x672C<SEP3>// <CJK>
0x967C<SEP>0x4B5D<SEP>0x7FFB<SEP3>// <CJK>
0x967D<SEP>0x4B5E<SEP>0x51E1<SEP3>// <CJK>
0x967E<SEP>0x4B5F<SEP>0x76C6<SEP3>// <CJK>
0x9680<SEP>0x4B60<SEP>0x6469<SEP3>// <CJK>
0x9681<SEP>0x4B61<SEP>0x78E8<SEP3>// <CJK>
0x9682<SEP>0x4B62<SEP>0x9B54<SEP3>// <CJK>
0x9683<SEP>0x4B63<SEP>0x9EBB<SEP3>// <CJK>
0x9684<SEP>0x4B64<SEP>0x57CB<SEP3>// <CJK>
0x9685<SEP>0x4B65<SEP>0x59B9<SEP3>// <CJK>
0x9686<SEP>0x4B66<SEP>0x6627<SEP3>// <CJK>
0x9687<SEP>0x4B67<SEP>0x679A<SEP3>// <CJK>
0x9688<SEP>0x4B68<SEP>0x6BCE<SEP3>// <CJK>
0x9689<SEP>0x4B69<SEP>0x54E9<SEP3>// <CJK>
0x968A<SEP>0x4B6A<SEP>0x69D9<SEP3>// <CJK>
0x968B<SEP>0x4B6B<SEP>0x5E55<SEP3>// <CJK>
0x968C<SEP>0x4B6C<SEP>0x819C<SEP3>// <CJK>
0x968D<SEP>0x4B6D<SEP>0x6795<SEP3>// <CJK>
0x968E<SEP>0x4B6E<SEP>0x9BAA<SEP3>// <CJK>
0x968F<SEP>0x4B6F<SEP>0x67FE<SEP3>// <CJK>
0x9690<SEP>0x4B70<SEP>0x9C52<SEP3>// <CJK>
0x9691<SEP>0x4B71<SEP>0x685D<SEP3>// <CJK>
0x9692<SEP>0x4B72<SEP>0x4EA6<SEP3>// <CJK>
0x9693<SEP>0x4B73<SEP>0x4FE3<SEP3>// <CJK>
0x9694<SEP>0x4B74<SEP>0x53C8<SEP3>// <CJK>
0x9695<SEP>0x4B75<SEP>0x62B9<SEP3>// <CJK>
0x9696<SEP>0x4B76<SEP>0x672B<SEP3>// <CJK>
0x9697<SEP>0x4B77<SEP>0x6CAB<SEP3>// <CJK>
0x9698<SEP>0x4B78<SEP>0x8FC4<SEP3>// <CJK>
0x9699<SEP>0x4B79<SEP>0x4FAD<SEP3>// <CJK>
0x969A<SEP>0x4B7A<SEP>0x7E6D<SEP3>// <CJK>
0x969B<SEP>0x4B7B<SEP>0x9EBF<SEP3>// <CJK>
0x969C<SEP>0x4B7C<SEP>0x4E07<SEP3>// <CJK>
0x969D<SEP>0x4B7D<SEP>0x6162<SEP3>// <CJK>
0x969E<SEP>0x4B7E<SEP>0x6E80<SEP3>// <CJK>
0x969F<SEP>0x4C21<SEP>0x6F2B<SEP3>// <CJK>
0x96A0<SEP>0x4C22<SEP>0x8513<SEP3>// <CJK>
0x96A1<SEP>0x4C23<SEP>0x5473<SEP3>// <CJK>
0x96A2<SEP>0x4C24<SEP>0x672A<SEP3>// <CJK>
0x96A3<SEP>0x4C25<SEP>0x9B45<SEP3>// <CJK>
0x96A4<SEP>0x4C26<SEP>0x5DF3<SEP3>// <CJK>
0x96A5<SEP>0x4C27<SEP>0x7B95<SEP3>// <CJK>
0x96A6<SEP>0x4C28<SEP>0x5CAC<SEP3>// <CJK>
0x96A7<SEP>0x4C29<SEP>0x5BC6<SEP3>// <CJK>
0x96A8<SEP>0x4C2A<SEP>0x871C<SEP3>// <CJK>
0x96A9<SEP>0x4C2B<SEP>0x6E4A<SEP3>// <CJK>
0x96AA<SEP>0x4C2C<SEP>0x84D1<SEP3>// <CJK>
0x96AB<SEP>0x4C2D<SEP>0x7A14<SEP3>// <CJK>
0x96AC<SEP>0x4C2E<SEP>0x8108<SEP3>// <CJK>
0x96AD<SEP>0x4C2F<SEP>0x5999<SEP3>// <CJK>
0x96AE<SEP>0x4C30<SEP>0x7C8D<SEP3>// <CJK>
0x96AF<SEP>0x4C31<SEP>0x6C11<SEP3>// <CJK>
0x96B0<SEP>0x4C32<SEP>0x7720<SEP3>// <CJK>
0x96B1<SEP>0x4C33<SEP>0x52D9<SEP3>// <CJK>
0x96B2<SEP>0x4C34<SEP>0x5922<SEP3>// <CJK>
0x96B3<SEP>0x4C35<SEP>0x7121<SEP3>// <CJK>
0x96B4<SEP>0x4C36<SEP>0x725F<SEP3>// <CJK>
0x96B5<SEP>0x4C37<SEP>0x77DB<SEP3>// <CJK>
0x96B6<SEP>0x4C38<SEP>0x9727<SEP3>// <CJK>
0x96B7<SEP>0x4C39<SEP>0x9D61<SEP3>// <CJK>
0x96B8<SEP>0x4C3A<SEP>0x690B<SEP3>// <CJK>
0x96B9<SEP>0x4C3B<SEP>0x5A7F<SEP3>// <CJK>
0x96BA<SEP>0x4C3C<SEP>0x5A18<SEP3>// <CJK>
0x96BB<SEP>0x4C3D<SEP>0x51A5<SEP3>// <CJK>
0x96BC<SEP>0x4C3E<SEP>0x540D<SEP3>// <CJK>
0x96BD<SEP>0x4C3F<SEP>0x547D<SEP3>// <CJK>
0x96BE<SEP>0x4C40<SEP>0x660E<SEP3>// <CJK>
0x96BF<SEP>0x4C41<SEP>0x76DF<SEP3>// <CJK>
0x96C0<SEP>0x4C42<SEP>0x8FF7<SEP3>// <CJK>
0x96C1<SEP>0x4C43<SEP>0x9298<SEP3>// <CJK>
0x96C2<SEP>0x4C44<SEP>0x9CF4<SEP3>// <CJK>
0x96C3<SEP>0x4C45<SEP>0x59EA<SEP3>// <CJK>
0x96C4<SEP>0x4C46<SEP>0x725D<SEP3>// <CJK>
0x96C5<SEP>0x4C47<SEP>0x6EC5<SEP3>// <CJK>
0x96C6<SEP>0x4C48<SEP>0x514D<SEP3>// <CJK>
0x96C7<SEP>0x4C49<SEP>0x68C9<SEP3>// <CJK>
0x96C8<SEP>0x4C4A<SEP>0x7DBF<SEP3>// <CJK>
0x96C9<SEP>0x4C4B<SEP>0x7DEC<SEP3>// <CJK>
0x96CA<SEP>0x4C4C<SEP>0x9762<SEP3>// <CJK>
0x96CB<SEP>0x4C4D<SEP>0x9EBA<SEP3>// <CJK>
0x96CC<SEP>0x4C4E<SEP>0x6478<SEP3>// <CJK>
0x96CD<SEP>0x4C4F<SEP>0x6A21<SEP3>// <CJK>
0x96CE<SEP>0x4C50<SEP>0x8302<SEP3>// <CJK>
0x96CF<SEP>0x4C51<SEP>0x5984<SEP3>// <CJK>
0x96D0<SEP>0x4C52<SEP>0x5B5F<SEP3>// <CJK>
0x96D1<SEP>0x4C53<SEP>0x6BDB<SEP3>// <CJK>
0x96D2<SEP>0x4C54<SEP>0x731B<SEP3>// <CJK>
0x96D3<SEP>0x4C55<SEP>0x76F2<SEP3>// <CJK>
0x96D4<SEP>0x4C56<SEP>0x7DB2<SEP3>// <CJK>
0x96D5<SEP>0x4C57<SEP>0x8017<SEP3>// <CJK>
0x96D6<SEP>0x4C58<SEP>0x8499<SEP3>// <CJK>
0x96D7<SEP>0x4C59<SEP>0x5132<SEP3>// <CJK>
0x96D8<SEP>0x4C5A<SEP>0x6728<SEP3>// <CJK>
0x96D9<SEP>0x4C5B<SEP>0x9ED9<SEP3>// <CJK>
0x96DA<SEP>0x4C5C<SEP>0x76EE<SEP3>// <CJK>
0x96DB<SEP>0x4C5D<SEP>0x6762<SEP3>// <CJK>
0x96DC<SEP>0x4C5E<SEP>0x52FF<SEP3>// <CJK>
0x96DD<SEP>0x4C5F<SEP>0x9905<SEP3>// <CJK>
0x96DE<SEP>0x4C60<SEP>0x5C24<SEP3>// <CJK>
0x96DF<SEP>0x4C61<SEP>0x623B<SEP3>// <CJK>
0x96E0<SEP>0x4C62<SEP>0x7C7E<SEP3>// <CJK>
0x96E1<SEP>0x4C63<SEP>0x8CB0<SEP3>// <CJK>
0x96E2<SEP>0x4C64<SEP>0x554F<SEP3>// <CJK>
0x96E3<SEP>0x4C65<SEP>0x60B6<SEP3>// <CJK>
0x96E4<SEP>0x4C66<SEP>0x7D0B<SEP3>// <CJK>
0x96E5<SEP>0x4C67<SEP>0x9580<SEP3>// <CJK>
0x96E6<SEP>0x4C68<SEP>0x5301<SEP3>// <CJK>
0x96E7<SEP>0x4C69<SEP>0x4E5F<SEP3>// <CJK>
0x96E8<SEP>0x4C6A<SEP>0x51B6<SEP3>// <CJK>
0x96E9<SEP>0x4C6B<SEP>0x591C<SEP3>// <CJK>
0x96EA<SEP>0x4C6C<SEP>0x723A<SEP3>// <CJK>
0x96EB<SEP>0x4C6D<SEP>0x8036<SEP3>// <CJK>
0x96EC<SEP>0x4C6E<SEP>0x91CE<SEP3>// <CJK>
0x96ED<SEP>0x4C6F<SEP>0x5F25<SEP3>// <CJK>
0x96EE<SEP>0x4C70<SEP>0x77E2<SEP3>// <CJK>
0x96EF<SEP>0x4C71<SEP>0x5384<SEP3>// <CJK>
0x96F0<SEP>0x4C72<SEP>0x5F79<SEP3>// <CJK>
0x96F1<SEP>0x4C73<SEP>0x7D04<SEP3>// <CJK>
0x96F2<SEP>0x4C74<SEP>0x85AC<SEP3>// <CJK>
0x96F3<SEP>0x4C75<SEP>0x8A33<SEP3>// <CJK>
0x96F4<SEP>0x4C76<SEP>0x8E8D<SEP3>// <CJK>
0x96F5<SEP>0x4C77<SEP>0x9756<SEP3>// <CJK>
0x96F6<SEP>0x4C78<SEP>0x67F3<SEP3>// <CJK>
0x96F7<SEP>0x4C79<SEP>0x85AE<SEP3>// <CJK>
0x96F8<SEP>0x4C7A<SEP>0x9453<SEP3>// <CJK>
0x96F9<SEP>0x4C7B<SEP>0x6109<SEP3>// <CJK>
0x96FA<SEP>0x4C7C<SEP>0x6108<SEP3>// <CJK>
0x96FB<SEP>0x4C7D<SEP>0x6CB9<SEP3>// <CJK>
0x96FC<SEP>0x4C7E<SEP>0x7652<SEP3>// <CJK>
0x9740<SEP>0x4D21<SEP>0x8AED<SEP3>// <CJK>
0x9741<SEP>0x4D22<SEP>0x8F38<SEP3>// <CJK>
0x9742<SEP>0x4D23<SEP>0x552F<SEP3>// <CJK>
0x9743<SEP>0x4D24<SEP>0x4F51<SEP3>// <CJK>
0x9744<SEP>0x4D25<SEP>0x512A<SEP3>// <CJK>
0x9745<SEP>0x4D26<SEP>0x52C7<SEP3>// <CJK>
0x9746<SEP>0x4D27<SEP>0x53CB<SEP3>// <CJK>
0x9747<SEP>0x4D28<SEP>0x5BA5<SEP3>// <CJK>
0x9748<SEP>0x4D29<SEP>0x5E7D<SEP3>// <CJK>
0x9749<SEP>0x4D2A<SEP>0x60A0<SEP3>// <CJK>
0x974A<SEP>0x4D2B<SEP>0x6182<SEP3>// <CJK>
0x974B<SEP>0x4D2C<SEP>0x63D6<SEP3>// <CJK>
0x974C<SEP>0x4D2D<SEP>0x6709<SEP3>// <CJK>
0x974D<SEP>0x4D2E<SEP>0x67DA<SEP3>// <CJK>
0x974E<SEP>0x4D2F<SEP>0x6E67<SEP3>// <CJK>
0x974F<SEP>0x4D30<SEP>0x6D8C<SEP3>// <CJK>
0x9750<SEP>0x4D31<SEP>0x7336<SEP3>// <CJK>
0x9751<SEP>0x4D32<SEP>0x7337<SEP3>// <CJK>
0x9752<SEP>0x4D33<SEP>0x7531<SEP3>// <CJK>
0x9753<SEP>0x4D34<SEP>0x7950<SEP3>// <CJK>
0x9754<SEP>0x4D35<SEP>0x88D5<SEP3>// <CJK>
0x9755<SEP>0x4D36<SEP>0x8A98<SEP3>// <CJK>
0x9756<SEP>0x4D37<SEP>0x904A<SEP3>// <CJK>
0x9757<SEP>0x4D38<SEP>0x9091<SEP3>// <CJK>
0x9758<SEP>0x4D39<SEP>0x90F5<SEP3>// <CJK>
0x9759<SEP>0x4D3A<SEP>0x96C4<SEP3>// <CJK>
0x975A<SEP>0x4D3B<SEP>0x878D<SEP3>// <CJK>
0x975B<SEP>0x4D3C<SEP>0x5915<SEP3>// <CJK>
0x975C<SEP>0x4D3D<SEP>0x4E88<SEP3>// <CJK>
0x975D<SEP>0x4D3E<SEP>0x4F59<SEP3>// <CJK>
0x975E<SEP>0x4D3F<SEP>0x4E0E<SEP3>// <CJK>
0x975F<SEP>0x4D40<SEP>0x8A89<SEP3>// <CJK>
0x9760<SEP>0x4D41<SEP>0x8F3F<SEP3>// <CJK>
0x9761<SEP>0x4D42<SEP>0x9810<SEP3>// <CJK>
0x9762<SEP>0x4D43<SEP>0x50AD<SEP3>// <CJK>
0x9763<SEP>0x4D44<SEP>0x5E7C<SEP3>// <CJK>
0x9764<SEP>0x4D45<SEP>0x5996<SEP3>// <CJK>
0x9765<SEP>0x4D46<SEP>0x5BB9<SEP3>// <CJK>
0x9766<SEP>0x4D47<SEP>0x5EB8<SEP3>// <CJK>
0x9767<SEP>0x4D48<SEP>0x63DA<SEP3>// <CJK>
0x9768<SEP>0x4D49<SEP>0x63FA<SEP3>// <CJK>
0x9769<SEP>0x4D4A<SEP>0x64C1<SEP3>// <CJK>
0x976A<SEP>0x4D4B<SEP>0x66DC<SEP3>// <CJK>
0x976B<SEP>0x4D4C<SEP>0x694A<SEP3>// <CJK>
0x976C<SEP>0x4D4D<SEP>0x69D8<SEP3>// <CJK>
0x976D<SEP>0x4D4E<SEP>0x6D0B<SEP3>// <CJK>
0x976E<SEP>0x4D4F<SEP>0x6EB6<SEP3>// <CJK>
0x976F<SEP>0x4D50<SEP>0x7194<SEP3>// <CJK>
0x9770<SEP>0x4D51<SEP>0x7528<SEP3>// <CJK>
0x9771<SEP>0x4D52<SEP>0x7AAF<SEP3>// <CJK>
0x9772<SEP>0x4D53<SEP>0x7F8A<SEP3>// <CJK>
0x9773<SEP>0x4D54<SEP>0x8000<SEP3>// <CJK>
0x9774<SEP>0x4D55<SEP>0x8449<SEP3>// <CJK>
0x9775<SEP>0x4D56<SEP>0x84C9<SEP3>// <CJK>
0x9776<SEP>0x4D57<SEP>0x8981<SEP3>// <CJK>
0x9777<SEP>0x4D58<SEP>0x8B21<SEP3>// <CJK>
0x9778<SEP>0x4D59<SEP>0x8E0A<SEP3>// <CJK>
0x9779<SEP>0x4D5A<SEP>0x9065<SEP3>// <CJK>
0x977A<SEP>0x4D5B<SEP>0x967D<SEP3>// <CJK>
0x977B<SEP>0x4D5C<SEP>0x990A<SEP3>// <CJK>
0x977C<SEP>0x4D5D<SEP>0x617E<SEP3>// <CJK>
0x977D<SEP>0x4D5E<SEP>0x6291<SEP3>// <CJK>
0x977E<SEP>0x4D5F<SEP>0x6B32<SEP3>// <CJK>
0x9780<SEP>0x4D60<SEP>0x6C83<SEP3>// <CJK>
0x9781<SEP>0x4D61<SEP>0x6D74<SEP3>// <CJK>
0x9782<SEP>0x4D62<SEP>0x7FCC<SEP3>// <CJK>
0x9783<SEP>0x4D63<SEP>0x7FFC<SEP3>// <CJK>
0x9784<SEP>0x4D64<SEP>0x6DC0<SEP3>// <CJK>
0x9785<SEP>0x4D65<SEP>0x7F85<SEP3>// <CJK>
0x9786<SEP>0x4D66<SEP>0x87BA<SEP3>// <CJK>
0x9787<SEP>0x4D67<SEP>0x88F8<SEP3>// <CJK>
0x9788<SEP>0x4D68<SEP>0x6765<SEP3>// <CJK>
0x9789<SEP>0x4D69<SEP>0x83B1<SEP3>// <CJK>
0x978A<SEP>0x4D6A<SEP>0x983C<SEP3>// <CJK>
0x978B<SEP>0x4D6B<SEP>0x96F7<SEP3>// <CJK>
0x978C<SEP>0x4D6C<SEP>0x6D1B<SEP3>// <CJK>
0x978D<SEP>0x4D6D<SEP>0x7D61<SEP3>// <CJK>
0x978E<SEP>0x4D6E<SEP>0x843D<SEP3>// <CJK>
0x978F<SEP>0x4D6F<SEP>0x916A<SEP3>// <CJK>
0x9790<SEP>0x4D70<SEP>0x4E71<SEP3>// <CJK>
0x9791<SEP>0x4D71<SEP>0x5375<SEP3>// <CJK>
0x9792<SEP>0x4D72<SEP>0x5D50<SEP3>// <CJK>
0x9793<SEP>0x4D73<SEP>0x6B04<SEP3>// <CJK>
0x9794<SEP>0x4D74<SEP>0x6FEB<SEP3>// <CJK>
0x9795<SEP>0x4D75<SEP>0x85CD<SEP3>// <CJK>
0x9796<SEP>0x4D76<SEP>0x862D<SEP3>// <CJK>
0x9797<SEP>0x4D77<SEP>0x89A7<SEP3>// <CJK>
0x9798<SEP>0x4D78<SEP>0x5229<SEP3>// <CJK>
0x9799<SEP>0x4D79<SEP>0x540F<SEP3>// <CJK>
0x979A<SEP>0x4D7A<SEP>0x5C65<SEP3>// <CJK>
0x979B<SEP>0x4D7B<SEP>0x674E<SEP3>// <CJK>
0x979C<SEP>0x4D7C<SEP>0x68A8<SEP3>// <CJK>
0x979D<SEP>0x4D7D<SEP>0x7406<SEP3>// <CJK>
0x979E<SEP>0x4D7E<SEP>0x7483<SEP3>// <CJK>
0x979F<SEP>0x4E21<SEP>0x75E2<SEP3>// <CJK>
0x97A0<SEP>0x4E22<SEP>0x88CF<SEP3>// <CJK>
0x97A1<SEP>0x4E23<SEP>0x88E1<SEP3>// <CJK>
0x97A2<SEP>0x4E24<SEP>0x91CC<SEP3>// <CJK>
0x97A3<SEP>0x4E25<SEP>0x96E2<SEP3>// <CJK>
0x97A4<SEP>0x4E26<SEP>0x9678<SEP3>// <CJK>
0x97A5<SEP>0x4E27<SEP>0x5F8B<SEP3>// <CJK>
0x97A6<SEP>0x4E28<SEP>0x7387<SEP3>// <CJK>
0x97A7<SEP>0x4E29<SEP>0x7ACB<SEP3>// <CJK>
0x97A8<SEP>0x4E2A<SEP>0x844E<SEP3>// <CJK>
0x97A9<SEP>0x4E2B<SEP>0x63A0<SEP3>// <CJK>
0x97AA<SEP>0x4E2C<SEP>0x7565<SEP3>// <CJK>
0x97AB<SEP>0x4E2D<SEP>0x5289<SEP3>// <CJK>
0x97AC<SEP>0x4E2E<SEP>0x6D41<SEP3>// <CJK>
0x97AD<SEP>0x4E2F<SEP>0x6E9C<SEP3>// <CJK>
0x97AE<SEP>0x4E30<SEP>0x7409<SEP3>// <CJK>
0x97AF<SEP>0x4E31<SEP>0x7559<SEP3>// <CJK>
0x97B0<SEP>0x4E32<SEP>0x786B<SEP3>// <CJK>
0x97B1<SEP>0x4E33<SEP>0x7C92<SEP3>// <CJK>
0x97B2<SEP>0x4E34<SEP>0x9686<SEP3>// <CJK>
0x97B3<SEP>0x4E35<SEP>0x7ADC<SEP3>// <CJK>
0x97B4<SEP>0x4E36<SEP>0x9F8D<SEP3>// <CJK>
0x97B5<SEP>0x4E37<SEP>0x4FB6<SEP3>// <CJK>
0x97B6<SEP>0x4E38<SEP>0x616E<SEP3>// <CJK>
0x97B7<SEP>0x4E39<SEP>0x65C5<SEP3>// <CJK>
0x97B8<SEP>0x4E3A<SEP>0x865C<SEP3>// <CJK>
0x97B9<SEP>0x4E3B<SEP>0x4E86<SEP3>// <CJK>
0x97BA<SEP>0x4E3C<SEP>0x4EAE<SEP3>// <CJK>
0x97BB<SEP>0x4E3D<SEP>0x50DA<SEP3>// <CJK>
0x97BC<SEP>0x4E3E<SEP>0x4E21<SEP3>// <CJK>
0x97BD<SEP>0x4E3F<SEP>0x51CC<SEP3>// <CJK>
0x97BE<SEP>0x4E40<SEP>0x5BEE<SEP3>// <CJK>
0x97BF<SEP>0x4E41<SEP>0x6599<SEP3>// <CJK>
0x97C0<SEP>0x4E42<SEP>0x6881<SEP3>// <CJK>
0x97C1<SEP>0x4E43<SEP>0x6DBC<SEP3>// <CJK>
0x97C2<SEP>0x4E44<SEP>0x731F<SEP3>// <CJK>
0x97C3<SEP>0x4E45<SEP>0x7642<SEP3>// <CJK>
0x97C4<SEP>0x4E46<SEP>0x77AD<SEP3>// <CJK>
0x97C5<SEP>0x4E47<SEP>0x7A1C<SEP3>// <CJK>
0x97C6<SEP>0x4E48<SEP>0x7CE7<SEP3>// <CJK>
0x97C7<SEP>0x4E49<SEP>0x826F<SEP3>// <CJK>
0x97C8<SEP>0x4E4A<SEP>0x8AD2<SEP3>// <CJK>
0x97C9<SEP>0x4E4B<SEP>0x907C<SEP3>// <CJK>
0x97CA<SEP>0x4E4C<SEP>0x91CF<SEP3>// <CJK>
0x97CB<SEP>0x4E4D<SEP>0x9675<SEP3>// <CJK>
0x97CC<SEP>0x4E4E<SEP>0x9818<SEP3>// <CJK>
0x97CD<SEP>0x4E4F<SEP>0x529B<SEP3>// <CJK>
0x97CE<SEP>0x4E50<SEP>0x7DD1<SEP3>// <CJK>
0x97CF<SEP>0x4E51<SEP>0x502B<SEP3>// <CJK>
0x97D0<SEP>0x4E52<SEP>0x5398<SEP3>// <CJK>
0x97D1<SEP>0x4E53<SEP>0x6797<SEP3>// <CJK>
0x97D2<SEP>0x4E54<SEP>0x6DCB<SEP3>// <CJK>
0x97D3<SEP>0x4E55<SEP>0x71D0<SEP3>// <CJK>
0x97D4<SEP>0x4E56<SEP>0x7433<SEP3>// <CJK>
0x97D5<SEP>0x4E57<SEP>0x81E8<SEP3>// <CJK>
0x97D6<SEP>0x4E58<SEP>0x8F2A<SEP3>// <CJK>
0x97D7<SEP>0x4E59<SEP>0x96A3<SEP3>// <CJK>
0x97D8<SEP>0x4E5A<SEP>0x9C57<SEP3>// <CJK>
0x97D9<SEP>0x4E5B<SEP>0x9E9F<SEP3>// <CJK>
0x97DA<SEP>0x4E5C<SEP>0x7460<SEP3>// <CJK>
0x97DB<SEP>0x4E5D<SEP>0x5841<SEP3>// <CJK>
0x97DC<SEP>0x4E5E<SEP>0x6D99<SEP3>// <CJK>
0x97DD<SEP>0x4E5F<SEP>0x7D2F<SEP3>// <CJK>
0x97DE<SEP>0x4E60<SEP>0x985E<SEP3>// <CJK>
0x97DF<SEP>0x4E61<SEP>0x4EE4<SEP3>// <CJK>
0x97E0<SEP>0x4E62<SEP>0x4F36<SEP3>// <CJK>
0x97E1<SEP>0x4E63<SEP>0x4F8B<SEP3>// <CJK>
0x97E2<SEP>0x4E64<SEP>0x51B7<SEP3>// <CJK>
0x97E3<SEP>0x4E65<SEP>0x52B1<SEP3>// <CJK>
0x97E4<SEP>0x4E66<SEP>0x5DBA<SEP3>// <CJK>
0x97E5<SEP>0x4E67<SEP>0x601C<SEP3>// <CJK>
0x97E6<SEP>0x4E68<SEP>0x73B2<SEP3>// <CJK>
0x97E7<SEP>0x4E69<SEP>0x793C<SEP3>// <CJK>
0x97E8<SEP>0x4E6A<SEP>0x82D3<SEP3>// <CJK>
0x97E9<SEP>0x4E6B<SEP>0x9234<SEP3>// <CJK>
0x97EA<SEP>0x4E6C<SEP>0x96B7<SEP3>// <CJK>
0x97EB<SEP>0x4E6D<SEP>0x96F6<SEP3>// <CJK>
0x97EC<SEP>0x4E6E<SEP>0x970A<SEP3>// <CJK>
0x97ED<SEP>0x4E6F<SEP>0x9E97<SEP3>// <CJK>
0x97EE<SEP>0x4E70<SEP>0x9F62<SEP3>// <CJK>
0x97EF<SEP>0x4E71<SEP>0x66A6<SEP3>// <CJK>
0x97F0<SEP>0x4E72<SEP>0x6B74<SEP3>// <CJK>
0x97F1<SEP>0x4E73<SEP>0x5217<SEP3>// <CJK>
0x97F2<SEP>0x4E74<SEP>0x52A3<SEP3>// <CJK>
0x97F3<SEP>0x4E75<SEP>0x70C8<SEP3>// <CJK>
0x97F4<SEP>0x4E76<SEP>0x88C2<SEP3>// <CJK>
0x97F5<SEP>0x4E77<SEP>0x5EC9<SEP3>// <CJK>
0x97F6<SEP>0x4E78<SEP>0x604B<SEP3>// <CJK>
0x97F7<SEP>0x4E79<SEP>0x6190<SEP3>// <CJK>
0x97F8<SEP>0x4E7A<SEP>0x6F23<SEP3>// <CJK>
0x97F9<SEP>0x4E7B<SEP>0x7149<SEP3>// <CJK>
0x97FA<SEP>0x4E7C<SEP>0x7C3E<SEP3>// <CJK>
0x97FB<SEP>0x4E7D<SEP>0x7DF4<SEP3>// <CJK>
0x97FC<SEP>0x4E7E<SEP>0x806F<SEP3>// <CJK>
0x9840<SEP>0x4F21<SEP>0x84EE<SEP3>// <CJK>
0x9841<SEP>0x4F22<SEP>0x9023<SEP3>// <CJK>
0x9842<SEP>0x4F23<SEP>0x932C<SEP3>// <CJK>
0x9843<SEP>0x4F24<SEP>0x5442<SEP3>// <CJK>
0x9844<SEP>0x4F25<SEP>0x9B6F<SEP3>// <CJK>
0x9845<SEP>0x4F26<SEP>0x6AD3<SEP3>// <CJK>
0x9846<SEP>0x4F27<SEP>0x7089<SEP3>// <CJK>
0x9847<SEP>0x4F28<SEP>0x8CC2<SEP3>// <CJK>
0x9848<SEP>0x4F29<SEP>0x8DEF<SEP3>// <CJK>
0x9849<SEP>0x4F2A<SEP>0x9732<SEP3>// <CJK>
0x984A<SEP>0x4F2B<SEP>0x52B4<SEP3>// <CJK>
0x984B<SEP>0x4F2C<SEP>0x5A41<SEP3>// <CJK>
0x984C<SEP>0x4F2D<SEP>0x5ECA<SEP3>// <CJK>
0x984D<SEP>0x4F2E<SEP>0x5F04<SEP3>// <CJK>
0x984E<SEP>0x4F2F<SEP>0x6717<SEP3>// <CJK>
0x984F<SEP>0x4F30<SEP>0x697C<SEP3>// <CJK>
0x9850<SEP>0x4F31<SEP>0x6994<SEP3>// <CJK>
0x9851<SEP>0x4F32<SEP>0x6D6A<SEP3>// <CJK>
0x9852<SEP>0x4F33<SEP>0x6F0F<SEP3>// <CJK>
0x9853<SEP>0x4F34<SEP>0x7262<SEP3>// <CJK>
0x9854<SEP>0x4F35<SEP>0x72FC<SEP3>// <CJK>
0x9855<SEP>0x4F36<SEP>0x7BED<SEP3>// <CJK>
0x9856<SEP>0x4F37<SEP>0x8001<SEP3>// <CJK>
0x9857<SEP>0x4F38<SEP>0x807E<SEP3>// <CJK>
0x9858<SEP>0x4F39<SEP>0x874B<SEP3>// <CJK>
0x9859<SEP>0x4F3A<SEP>0x90CE<SEP3>// <CJK>
0x985A<SEP>0x4F3B<SEP>0x516D<SEP3>// <CJK>
0x985B<SEP>0x4F3C<SEP>0x9E93<SEP3>// <CJK>
0x985C<SEP>0x4F3D<SEP>0x7984<SEP3>// <CJK>
0x985D<SEP>0x4F3E<SEP>0x808B<SEP3>// <CJK>
0x985E<SEP>0x4F3F<SEP>0x9332<SEP3>// <CJK>
0x985F<SEP>0x4F40<SEP>0x8AD6<SEP3>// <CJK>
0x9860<SEP>0x4F41<SEP>0x502D<SEP3>// <CJK>
0x9861<SEP>0x4F42<SEP>0x548C<SEP3>// <CJK>
0x9862<SEP>0x4F43<SEP>0x8A71<SEP3>// <CJK>
0x9863<SEP>0x4F44<SEP>0x6B6A<SEP3>// <CJK>
0x9864<SEP>0x4F45<SEP>0x8CC4<SEP3>// <CJK>
0x9865<SEP>0x4F46<SEP>0x8107<SEP3>// <CJK>
0x9866<SEP>0x4F47<SEP>0x60D1<SEP3>// <CJK>
0x9867<SEP>0x4F48<SEP>0x67A0<SEP3>// <CJK>
0x9868<SEP>0x4F49<SEP>0x9DF2<SEP3>// <CJK>
0x9869<SEP>0x4F4A<SEP>0x4E99<SEP3>// <CJK>
0x986A<SEP>0x4F4B<SEP>0x4E98<SEP3>// <CJK>
0x986B<SEP>0x4F4C<SEP>0x9C10<SEP3>// <CJK>
0x986C<SEP>0x4F4D<SEP>0x8A6B<SEP3>// <CJK>
0x986D<SEP>0x4F4E<SEP>0x85C1<SEP3>// <CJK>
0x986E<SEP>0x4F4F<SEP>0x8568<SEP3>// <CJK>
0x986F<SEP>0x4F50<SEP>0x6900<SEP3>// <CJK>
0x9870<SEP>0x4F51<SEP>0x6E7E<SEP3>// <CJK>
0x9871<SEP>0x4F52<SEP>0x7897<SEP3>// <CJK>
0x9872<SEP>0x4F53<SEP>0x8155<SEP3>// <CJK>
0x989F<SEP>0x5021<SEP>0x5F0C<SEP3>// <CJK>
0x98A0<SEP>0x5022<SEP>0x4E10<SEP3>// <CJK>
0x98A1<SEP>0x5023<SEP>0x4E15<SEP3>// <CJK>
0x98A2<SEP>0x5024<SEP>0x4E2A<SEP3>// <CJK>
0x98A3<SEP>0x5025<SEP>0x4E31<SEP3>// <CJK>
0x98A4<SEP>0x5026<SEP>0x4E36<SEP3>// <CJK>
0x98A5<SEP>0x5027<SEP>0x4E3C<SEP3>// <CJK>
0x98A6<SEP>0x5028<SEP>0x4E3F<SEP3>// <CJK>
0x98A7<SEP>0x5029<SEP>0x4E42<SEP3>// <CJK>
0x98A8<SEP>0x502A<SEP>0x4E56<SEP3>// <CJK>
0x98A9<SEP>0x502B<SEP>0x4E58<SEP3>// <CJK>
0x98AA<SEP>0x502C<SEP>0x4E82<SEP3>// <CJK>
0x98AB<SEP>0x502D<SEP>0x4E85<SEP3>// <CJK>
0x98AC<SEP>0x502E<SEP>0x8C6B<SEP3>// <CJK>
0x98AD<SEP>0x502F<SEP>0x4E8A<SEP3>// <CJK>
0x98AE<SEP>0x5030<SEP>0x8212<SEP3>// <CJK>
0x98AF<SEP>0x5031<SEP>0x5F0D<SEP3>// <CJK>
0x98B0<SEP>0x5032<SEP>0x4E8E<SEP3>// <CJK>
0x98B1<SEP>0x5033<SEP>0x4E9E<SEP3>// <CJK>
0x98B2<SEP>0x5034<SEP>0x4E9F<SEP3>// <CJK>
0x98B3<SEP>0x5035<SEP>0x4EA0<SEP3>// <CJK>
0x98B4<SEP>0x5036<SEP>0x4EA2<SEP3>// <CJK>
0x98B5<SEP>0x5037<SEP>0x4EB0<SEP3>// <CJK>
0x98B6<SEP>0x5038<SEP>0x4EB3<SEP3>// <CJK>
0x98B7<SEP>0x5039<SEP>0x4EB6<SEP3>// <CJK>
0x98B8<SEP>0x503A<SEP>0x4ECE<SEP3>// <CJK>
0x98B9<SEP>0x503B<SEP>0x4ECD<SEP3>// <CJK>
0x98BA<SEP>0x503C<SEP>0x4EC4<SEP3>// <CJK>
0x98BB<SEP>0x503D<SEP>0x4EC6<SEP3>// <CJK>
0x98BC<SEP>0x503E<SEP>0x4EC2<SEP3>// <CJK>
0x98BD<SEP>0x503F<SEP>0x4ED7<SEP3>// <CJK>
0x98BE<SEP>0x5040<SEP>0x4EDE<SEP3>// <CJK>
0x98BF<SEP>0x5041<SEP>0x4EED<SEP3>// <CJK>
0x98C0<SEP>0x5042<SEP>0x4EDF<SEP3>// <CJK>
0x98C1<SEP>0x5043<SEP>0x4EF7<SEP3>// <CJK>
0x98C2<SEP>0x5044<SEP>0x4F09<SEP3>// <CJK>
0x98C3<SEP>0x5045<SEP>0x4F5A<SEP3>// <CJK>
0x98C4<SEP>0x5046<SEP>0x4F30<SEP3>// <CJK>
0x98C5<SEP>0x5047<SEP>0x4F5B<SEP3>// <CJK>
0x98C6<SEP>0x5048<SEP>0x4F5D<SEP3>// <CJK>
0x98C7<SEP>0x5049<SEP>0x4F57<SEP3>// <CJK>
0x98C8<SEP>0x504A<SEP>0x4F47<SEP3>// <CJK>
0x98C9<SEP>0x504B<SEP>0x4F76<SEP3>// <CJK>
0x98CA<SEP>0x504C<SEP>0x4F88<SEP3>// <CJK>
0x98CB<SEP>0x504D<SEP>0x4F8F<SEP3>// <CJK>
0x98CC<SEP>0x504E<SEP>0x4F98<SEP3>// <CJK>
0x98CD<SEP>0x504F<SEP>0x4F7B<SEP3>// <CJK>
0x98CE<SEP>0x5050<SEP>0x4F69<SEP3>// <CJK>
0x98CF<SEP>0x5051<SEP>0x4F70<SEP3>// <CJK>
0x98D0<SEP>0x5052<SEP>0x4F91<SEP3>// <CJK>
0x98D1<SEP>0x5053<SEP>0x4F6F<SEP3>// <CJK>
0x98D2<SEP>0x5054<SEP>0x4F86<SEP3>// <CJK>
0x98D3<SEP>0x5055<SEP>0x4F96<SEP3>// <CJK>
0x98D4<SEP>0x5056<SEP>0x5118<SEP3>// <CJK>
0x98D5<SEP>0x5057<SEP>0x4FD4<SEP3>// <CJK>
0x98D6<SEP>0x5058<SEP>0x4FDF<SEP3>// <CJK>
0x98D7<SEP>0x5059<SEP>0x4FCE<SEP3>// <CJK>
0x98D8<SEP>0x505A<SEP>0x4FD8<SEP3>// <CJK>
0x98D9<SEP>0x505B<SEP>0x4FDB<SEP3>// <CJK>
0x98DA<SEP>0x505C<SEP>0x4FD1<SEP3>// <CJK>
0x98DB<SEP>0x505D<SEP>0x4FDA<SEP3>// <CJK>
0x98DC<SEP>0x505E<SEP>0x4FD0<SEP3>// <CJK>
0x98DD<SEP>0x505F<SEP>0x4FE4<SEP3>// <CJK>
0x98DE<SEP>0x5060<SEP>0x4FE5<SEP3>// <CJK>
0x98DF<SEP>0x5061<SEP>0x501A<SEP3>// <CJK>
0x98E0<SEP>0x5062<SEP>0x5028<SEP3>// <CJK>
0x98E1<SEP>0x5063<SEP>0x5014<SEP3>// <CJK>
0x98E2<SEP>0x5064<SEP>0x502A<SEP3>// <CJK>
0x98E3<SEP>0x5065<SEP>0x5025<SEP3>// <CJK>
0x98E4<SEP>0x5066<SEP>0x5005<SEP3>// <CJK>
0x98E5<SEP>0x5067<SEP>0x4F1C<SEP3>// <CJK>
0x98E6<SEP>0x5068<SEP>0x4FF6<SEP3>// <CJK>
0x98E7<SEP>0x5069<SEP>0x5021<SEP3>// <CJK>
0x98E8<SEP>0x506A<SEP>0x5029<SEP3>// <CJK>
0x98E9<SEP>0x506B<SEP>0x502C<SEP3>// <CJK>
0x98EA<SEP>0x506C<SEP>0x4FFE<SEP3>// <CJK>
0x98EB<SEP>0x506D<SEP>0x4FEF<SEP3>// <CJK>
0x98EC<SEP>0x506E<SEP>0x5011<SEP3>// <CJK>
0x98ED<SEP>0x506F<SEP>0x5006<SEP3>// <CJK>
0x98EE<SEP>0x5070<SEP>0x5043<SEP3>// <CJK>
0x98EF<SEP>0x5071<SEP>0x5047<SEP3>// <CJK>
0x98F0<SEP>0x5072<SEP>0x6703<SEP3>// <CJK>
0x98F1<SEP>0x5073<SEP>0x5055<SEP3>// <CJK>
0x98F2<SEP>0x5074<SEP>0x5050<SEP3>// <CJK>
0x98F3<SEP>0x5075<SEP>0x5048<SEP3>// <CJK>
0x98F4<SEP>0x5076<SEP>0x505A<SEP3>// <CJK>
0x98F5<SEP>0x5077<SEP>0x5056<SEP3>// <CJK>
0x98F6<SEP>0x5078<SEP>0x506C<SEP3>// <CJK>
0x98F7<SEP>0x5079<SEP>0x5078<SEP3>// <CJK>
0x98F8<SEP>0x507A<SEP>0x5080<SEP3>// <CJK>
0x98F9<SEP>0x507B<SEP>0x509A<SEP3>// <CJK>
0x98FA<SEP>0x507C<SEP>0x5085<SEP3>// <CJK>
0x98FB<SEP>0x507D<SEP>0x50B4<SEP3>// <CJK>
0x98FC<SEP>0x507E<SEP>0x50B2<SEP3>// <CJK>
0x9940<SEP>0x5121<SEP>0x50C9<SEP3>// <CJK>
0x9941<SEP>0x5122<SEP>0x50CA<SEP3>// <CJK>
0x9942<SEP>0x5123<SEP>0x50B3<SEP3>// <CJK>
0x9943<SEP>0x5124<SEP>0x50C2<SEP3>// <CJK>
0x9944<SEP>0x5125<SEP>0x50D6<SEP3>// <CJK>
0x9945<SEP>0x5126<SEP>0x50DE<SEP3>// <CJK>
0x9946<SEP>0x5127<SEP>0x50E5<SEP3>// <CJK>
0x9947<SEP>0x5128<SEP>0x50ED<SEP3>// <CJK>
0x9948<SEP>0x5129<SEP>0x50E3<SEP3>// <CJK>
0x9949<SEP>0x512A<SEP>0x50EE<SEP3>// <CJK>
0x994A<SEP>0x512B<SEP>0x50F9<SEP3>// <CJK>
0x994B<SEP>0x512C<SEP>0x50F5<SEP3>// <CJK>
0x994C<SEP>0x512D<SEP>0x5109<SEP3>// <CJK>
0x994D<SEP>0x512E<SEP>0x5101<SEP3>// <CJK>
0x994E<SEP>0x512F<SEP>0x5102<SEP3>// <CJK>
0x994F<SEP>0x5130<SEP>0x5116<SEP3>// <CJK>
0x9950<SEP>0x5131<SEP>0x5115<SEP3>// <CJK>
0x9951<SEP>0x5132<SEP>0x5114<SEP3>// <CJK>
0x9952<SEP>0x5133<SEP>0x511A<SEP3>// <CJK>
0x9953<SEP>0x5134<SEP>0x5121<SEP3>// <CJK>
0x9954<SEP>0x5135<SEP>0x513A<SEP3>// <CJK>
0x9955<SEP>0x5136<SEP>0x5137<SEP3>// <CJK>
0x9956<SEP>0x5137<SEP>0x513C<SEP3>// <CJK>
0x9957<SEP>0x5138<SEP>0x513B<SEP3>// <CJK>
0x9958<SEP>0x5139<SEP>0x513F<SEP3>// <CJK>
0x9959<SEP>0x513A<SEP>0x5140<SEP3>// <CJK>
0x995A<SEP>0x513B<SEP>0x5152<SEP3>// <CJK>
0x995B<SEP>0x513C<SEP>0x514C<SEP3>// <CJK>
0x995C<SEP>0x513D<SEP>0x5154<SEP3>// <CJK>
0x995D<SEP>0x513E<SEP>0x5162<SEP3>// <CJK>
0x995E<SEP>0x513F<SEP>0x7AF8<SEP3>// <CJK>
0x995F<SEP>0x5140<SEP>0x5169<SEP3>// <CJK>
0x9960<SEP>0x5141<SEP>0x516A<SEP3>// <CJK>
0x9961<SEP>0x5142<SEP>0x516E<SEP3>// <CJK>
0x9962<SEP>0x5143<SEP>0x5180<SEP3>// <CJK>
0x9963<SEP>0x5144<SEP>0x5182<SEP3>// <CJK>
0x9964<SEP>0x5145<SEP>0x56D8<SEP3>// <CJK>
0x9965<SEP>0x5146<SEP>0x518C<SEP3>// <CJK>
0x9966<SEP>0x5147<SEP>0x5189<SEP3>// <CJK>
0x9967<SEP>0x5148<SEP>0x518F<SEP3>// <CJK>
0x9968<SEP>0x5149<SEP>0x5191<SEP3>// <CJK>
0x9969<SEP>0x514A<SEP>0x5193<SEP3>// <CJK>
0x996A<SEP>0x514B<SEP>0x5195<SEP3>// <CJK>
0x996B<SEP>0x514C<SEP>0x5196<SEP3>// <CJK>
0x996C<SEP>0x514D<SEP>0x51A4<SEP3>// <CJK>
0x996D<SEP>0x514E<SEP>0x51A6<SEP3>// <CJK>
0x996E<SEP>0x514F<SEP>0x51A2<SEP3>// <CJK>
0x996F<SEP>0x5150<SEP>0x51A9<SEP3>// <CJK>
0x9970<SEP>0x5151<SEP>0x51AA<SEP3>// <CJK>
0x9971<SEP>0x5152<SEP>0x51AB<SEP3>// <CJK>
0x9972<SEP>0x5153<SEP>0x51B3<SEP3>// <CJK>
0x9973<SEP>0x5154<SEP>0x51B1<SEP3>// <CJK>
0x9974<SEP>0x5155<SEP>0x51B2<SEP3>// <CJK>
0x9975<SEP>0x5156<SEP>0x51B0<SEP3>// <CJK>
0x9976<SEP>0x5157<SEP>0x51B5<SEP3>// <CJK>
0x9977<SEP>0x5158<SEP>0x51BD<SEP3>// <CJK>
0x9978<SEP>0x5159<SEP>0x51C5<SEP3>// <CJK>
0x9979<SEP>0x515A<SEP>0x51C9<SEP3>// <CJK>
0x997A<SEP>0x515B<SEP>0x51DB<SEP3>// <CJK>
0x997B<SEP>0x515C<SEP>0x51E0<SEP3>// <CJK>
0x997C<SEP>0x515D<SEP>0x8655<SEP3>// <CJK>
0x997D<SEP>0x515E<SEP>0x51E9<SEP3>// <CJK>
0x997E<SEP>0x515F<SEP>0x51ED<SEP3>// <CJK>
0x9980<SEP>0x5160<SEP>0x51F0<SEP3>// <CJK>
0x9981<SEP>0x5161<SEP>0x51F5<SEP3>// <CJK>
0x9982<SEP>0x5162<SEP>0x51FE<SEP3>// <CJK>
0x9983<SEP>0x5163<SEP>0x5204<SEP3>// <CJK>
0x9984<SEP>0x5164<SEP>0x520B<SEP3>// <CJK>
0x9985<SEP>0x5165<SEP>0x5214<SEP3>// <CJK>
0x9986<SEP>0x5166<SEP>0x520E<SEP3>// <CJK>
0x9987<SEP>0x5167<SEP>0x5227<SEP3>// <CJK>
0x9988<SEP>0x5168<SEP>0x522A<SEP3>// <CJK>
0x9989<SEP>0x5169<SEP>0x522E<SEP3>// <CJK>
0x998A<SEP>0x516A<SEP>0x5233<SEP3>// <CJK>
0x998B<SEP>0x516B<SEP>0x5239<SEP3>// <CJK>
0x998C<SEP>0x516C<SEP>0x524F<SEP3>// <CJK>
0x998D<SEP>0x516D<SEP>0x5244<SEP3>// <CJK>
0x998E<SEP>0x516E<SEP>0x524B<SEP3>// <CJK>
0x998F<SEP>0x516F<SEP>0x524C<SEP3>// <CJK>
0x9990<SEP>0x5170<SEP>0x525E<SEP3>// <CJK>
0x9991<SEP>0x5171<SEP>0x5254<SEP3>// <CJK>
0x9992<SEP>0x5172<SEP>0x526A<SEP3>// <CJK>
0x9993<SEP>0x5173<SEP>0x5274<SEP3>// <CJK>
0x9994<SEP>0x5174<SEP>0x5269<SEP3>// <CJK>
0x9995<SEP>0x5175<SEP>0x5273<SEP3>// <CJK>
0x9996<SEP>0x5176<SEP>0x527F<SEP3>// <CJK>
0x9997<SEP>0x5177<SEP>0x527D<SEP3>// <CJK>
0x9998<SEP>0x5178<SEP>0x528D<SEP3>// <CJK>
0x9999<SEP>0x5179<SEP>0x5294<SEP3>// <CJK>
0x999A<SEP>0x517A<SEP>0x5292<SEP3>// <CJK>
0x999B<SEP>0x517B<SEP>0x5271<SEP3>// <CJK>
0x999C<SEP>0x517C<SEP>0x5288<SEP3>// <CJK>
0x999D<SEP>0x517D<SEP>0x5291<SEP3>// <CJK>
0x999E<SEP>0x517E<SEP>0x8FA8<SEP3>// <CJK>
0x999F<SEP>0x5221<SEP>0x8FA7<SEP3>// <CJK>
0x99A0<SEP>0x5222<SEP>0x52AC<SEP3>// <CJK>
0x99A1<SEP>0x5223<SEP>0x52AD<SEP3>// <CJK>
0x99A2<SEP>0x5224<SEP>0x52BC<SEP3>// <CJK>
0x99A3<SEP>0x5225<SEP>0x52B5<SEP3>// <CJK>
0x99A4<SEP>0x5226<SEP>0x52C1<SEP3>// <CJK>
0x99A5<SEP>0x5227<SEP>0x52CD<SEP3>// <CJK>
0x99A6<SEP>0x5228<SEP>0x52D7<SEP3>// <CJK>
0x99A7<SEP>0x5229<SEP>0x52DE<SEP3>// <CJK>
0x99A8<SEP>0x522A<SEP>0x52E3<SEP3>// <CJK>
0x99A9<SEP>0x522B<SEP>0x52E6<SEP3>// <CJK>
0x99AA<SEP>0x522C<SEP>0x98ED<SEP3>// <CJK>
0x99AB<SEP>0x522D<SEP>0x52E0<SEP3>// <CJK>
0x99AC<SEP>0x522E<SEP>0x52F3<SEP3>// <CJK>
0x99AD<SEP>0x522F<SEP>0x52F5<SEP3>// <CJK>
0x99AE<SEP>0x5230<SEP>0x52F8<SEP3>// <CJK>
0x99AF<SEP>0x5231<SEP>0x52F9<SEP3>// <CJK>
0x99B0<SEP>0x5232<SEP>0x5306<SEP3>// <CJK>
0x99B1<SEP>0x5233<SEP>0x5308<SEP3>// <CJK>
0x99B2<SEP>0x5234<SEP>0x7538<SEP3>// <CJK>
0x99B3<SEP>0x5235<SEP>0x530D<SEP3>// <CJK>
0x99B4<SEP>0x5236<SEP>0x5310<SEP3>// <CJK>
0x99B5<SEP>0x5237<SEP>0x530F<SEP3>// <CJK>
0x99B6<SEP>0x5238<SEP>0x5315<SEP3>// <CJK>
0x99B7<SEP>0x5239<SEP>0x531A<SEP3>// <CJK>
0x99B8<SEP>0x523A<SEP>0x5323<SEP3>// <CJK>
0x99B9<SEP>0x523B<SEP>0x532F<SEP3>// <CJK>
0x99BA<SEP>0x523C<SEP>0x5331<SEP3>// <CJK>
0x99BB<SEP>0x523D<SEP>0x5333<SEP3>// <CJK>
0x99BC<SEP>0x523E<SEP>0x5338<SEP3>// <CJK>
0x99BD<SEP>0x523F<SEP>0x5340<SEP3>// <CJK>
0x99BE<SEP>0x5240<SEP>0x5346<SEP3>// <CJK>
0x99BF<SEP>0x5241<SEP>0x5345<SEP3>// <CJK>
0x99C0<SEP>0x5242<SEP>0x4E17<SEP3>// <CJK>
0x99C1<SEP>0x5243<SEP>0x5349<SEP3>// <CJK>
0x99C2<SEP>0x5244<SEP>0x534D<SEP3>// <CJK>
0x99C3<SEP>0x5245<SEP>0x51D6<SEP3>// <CJK>
0x99C4<SEP>0x5246<SEP>0x535E<SEP3>// <CJK>
0x99C5<SEP>0x5247<SEP>0x5369<SEP3>// <CJK>
0x99C6<SEP>0x5248<SEP>0x536E<SEP3>// <CJK>
0x99C7<SEP>0x5249<SEP>0x5918<SEP3>// <CJK>
0x99C8<SEP>0x524A<SEP>0x537B<SEP3>// <CJK>
0x99C9<SEP>0x524B<SEP>0x5377<SEP3>// <CJK>
0x99CA<SEP>0x524C<SEP>0x5382<SEP3>// <CJK>
0x99CB<SEP>0x524D<SEP>0x5396<SEP3>// <CJK>
0x99CC<SEP>0x524E<SEP>0x53A0<SEP3>// <CJK>
0x99CD<SEP>0x524F<SEP>0x53A6<SEP3>// <CJK>
0x99CE<SEP>0x5250<SEP>0x53A5<SEP3>// <CJK>
0x99CF<SEP>0x5251<SEP>0x53AE<SEP3>// <CJK>
0x99D0<SEP>0x5252<SEP>0x53B0<SEP3>// <CJK>
0x99D1<SEP>0x5253<SEP>0x53B6<SEP3>// <CJK>
0x99D2<SEP>0x5254<SEP>0x53C3<SEP3>// <CJK>
0x99D3<SEP>0x5255<SEP>0x7C12<SEP3>// <CJK>
0x99D4<SEP>0x5256<SEP>0x96D9<SEP3>// <CJK>
0x99D5<SEP>0x5257<SEP>0x53DF<SEP3>// <CJK>
0x99D6<SEP>0x5258<SEP>0x66FC<SEP3>// <CJK>
0x99D7<SEP>0x5259<SEP>0x71EE<SEP3>// <CJK>
0x99D8<SEP>0x525A<SEP>0x53EE<SEP3>// <CJK>
0x99D9<SEP>0x525B<SEP>0x53E8<SEP3>// <CJK>
0x99DA<SEP>0x525C<SEP>0x53ED<SEP3>// <CJK>
0x99DB<SEP>0x525D<SEP>0x53FA<SEP3>// <CJK>
0x99DC<SEP>0x525E<SEP>0x5401<SEP3>// <CJK>
0x99DD<SEP>0x525F<SEP>0x543D<SEP3>// <CJK>
0x99DE<SEP>0x5260<SEP>0x5440<SEP3>// <CJK>
0x99DF<SEP>0x5261<SEP>0x542C<SEP3>// <CJK>
0x99E0<SEP>0x5262<SEP>0x542D<SEP3>// <CJK>
0x99E1<SEP>0x5263<SEP>0x543C<SEP3>// <CJK>
0x99E2<SEP>0x5264<SEP>0x542E<SEP3>// <CJK>
0x99E3<SEP>0x5265<SEP>0x5436<SEP3>// <CJK>
0x99E4<SEP>0x5266<SEP>0x5429<SEP3>// <CJK>
0x99E5<SEP>0x5267<SEP>0x541D<SEP3>// <CJK>
0x99E6<SEP>0x5268<SEP>0x544E<SEP3>// <CJK>
0x99E7<SEP>0x5269<SEP>0x548F<SEP3>// <CJK>
0x99E8<SEP>0x526A<SEP>0x5475<SEP3>// <CJK>
0x99E9<SEP>0x526B<SEP>0x548E<SEP3>// <CJK>
0x99EA<SEP>0x526C<SEP>0x545F<SEP3>// <CJK>
0x99EB<SEP>0x526D<SEP>0x5471<SEP3>// <CJK>
0x99EC<SEP>0x526E<SEP>0x5477<SEP3>// <CJK>
0x99ED<SEP>0x526F<SEP>0x5470<SEP3>// <CJK>
0x99EE<SEP>0x5270<SEP>0x5492<SEP3>// <CJK>
0x99EF<SEP>0x5271<SEP>0x547B<SEP3>// <CJK>
0x99F0<SEP>0x5272<SEP>0x5480<SEP3>// <CJK>
0x99F1<SEP>0x5273<SEP>0x5476<SEP3>// <CJK>
0x99F2<SEP>0x5274<SEP>0x5484<SEP3>// <CJK>
0x99F3<SEP>0x5275<SEP>0x5490<SEP3>// <CJK>
0x99F4<SEP>0x5276<SEP>0x5486<SEP3>// <CJK>
0x99F5<SEP>0x5277<SEP>0x54C7<SEP3>// <CJK>
0x99F6<SEP>0x5278<SEP>0x54A2<SEP3>// <CJK>
0x99F7<SEP>0x5279<SEP>0x54B8<SEP3>// <CJK>
0x99F8<SEP>0x527A<SEP>0x54A5<SEP3>// <CJK>
0x99F9<SEP>0x527B<SEP>0x54AC<SEP3>// <CJK>
0x99FA<SEP>0x527C<SEP>0x54C4<SEP3>// <CJK>
0x99FB<SEP>0x527D<SEP>0x54C8<SEP3>// <CJK>
0x99FC<SEP>0x527E<SEP>0x54A8<SEP3>// <CJK>
0x9A40<SEP>0x5321<SEP>0x54AB<SEP3>// <CJK>
0x9A41<SEP>0x5322<SEP>0x54C2<SEP3>// <CJK>
0x9A42<SEP>0x5323<SEP>0x54A4<SEP3>// <CJK>
0x9A43<SEP>0x5324<SEP>0x54BE<SEP3>// <CJK>
0x9A44<SEP>0x5325<SEP>0x54BC<SEP3>// <CJK>
0x9A45<SEP>0x5326<SEP>0x54D8<SEP3>// <CJK>
0x9A46<SEP>0x5327<SEP>0x54E5<SEP3>// <CJK>
0x9A47<SEP>0x5328<SEP>0x54E6<SEP3>// <CJK>
0x9A48<SEP>0x5329<SEP>0x550F<SEP3>// <CJK>
0x9A49<SEP>0x532A<SEP>0x5514<SEP3>// <CJK>
0x9A4A<SEP>0x532B<SEP>0x54FD<SEP3>// <CJK>
0x9A4B<SEP>0x532C<SEP>0x54EE<SEP3>// <CJK>
0x9A4C<SEP>0x532D<SEP>0x54ED<SEP3>// <CJK>
0x9A4D<SEP>0x532E<SEP>0x54FA<SEP3>// <CJK>
0x9A4E<SEP>0x532F<SEP>0x54E2<SEP3>// <CJK>
0x9A4F<SEP>0x5330<SEP>0x5539<SEP3>// <CJK>
0x9A50<SEP>0x5331<SEP>0x5540<SEP3>// <CJK>
0x9A51<SEP>0x5332<SEP>0x5563<SEP3>// <CJK>
0x9A52<SEP>0x5333<SEP>0x554C<SEP3>// <CJK>
0x9A53<SEP>0x5334<SEP>0x552E<SEP3>// <CJK>
0x9A54<SEP>0x5335<SEP>0x555C<SEP3>// <CJK>
0x9A55<SEP>0x5336<SEP>0x5545<SEP3>// <CJK>
0x9A56<SEP>0x5337<SEP>0x5556<SEP3>// <CJK>
0x9A57<SEP>0x5338<SEP>0x5557<SEP3>// <CJK>
0x9A58<SEP>0x5339<SEP>0x5538<SEP3>// <CJK>
0x9A59<SEP>0x533A<SEP>0x5533<SEP3>// <CJK>
0x9A5A<SEP>0x533B<SEP>0x555D<SEP3>// <CJK>
0x9A5B<SEP>0x533C<SEP>0x5599<SEP3>// <CJK>
0x9A5C<SEP>0x533D<SEP>0x5580<SEP3>// <CJK>
0x9A5D<SEP>0x533E<SEP>0x54AF<SEP3>// <CJK>
0x9A5E<SEP>0x533F<SEP>0x558A<SEP3>// <CJK>
0x9A5F<SEP>0x5340<SEP>0x559F<SEP3>// <CJK>
0x9A60<SEP>0x5341<SEP>0x557B<SEP3>// <CJK>
0x9A61<SEP>0x5342<SEP>0x557E<SEP3>// <CJK>
0x9A62<SEP>0x5343<SEP>0x5598<SEP3>// <CJK>
0x9A63<SEP>0x5344<SEP>0x559E<SEP3>// <CJK>
0x9A64<SEP>0x5345<SEP>0x55AE<SEP3>// <CJK>
0x9A65<SEP>0x5346<SEP>0x557C<SEP3>// <CJK>
0x9A66<SEP>0x5347<SEP>0x5583<SEP3>// <CJK>
0x9A67<SEP>0x5348<SEP>0x55A9<SEP3>// <CJK>
0x9A68<SEP>0x5349<SEP>0x5587<SEP3>// <CJK>
0x9A69<SEP>0x534A<SEP>0x55A8<SEP3>// <CJK>
0x9A6A<SEP>0x534B<SEP>0x55DA<SEP3>// <CJK>
0x9A6B<SEP>0x534C<SEP>0x55C5<SEP3>// <CJK>
0x9A6C<SEP>0x534D<SEP>0x55DF<SEP3>// <CJK>
0x9A6D<SEP>0x534E<SEP>0x55C4<SEP3>// <CJK>
0x9A6E<SEP>0x534F<SEP>0x55DC<SEP3>// <CJK>
0x9A6F<SEP>0x5350<SEP>0x55E4<SEP3>// <CJK>
0x9A70<SEP>0x5351<SEP>0x55D4<SEP3>// <CJK>
0x9A71<SEP>0x5352<SEP>0x5614<SEP3>// <CJK>
0x9A72<SEP>0x5353<SEP>0x55F7<SEP3>// <CJK>
0x9A73<SEP>0x5354<SEP>0x5616<SEP3>// <CJK>
0x9A74<SEP>0x5355<SEP>0x55FE<SEP3>// <CJK>
0x9A75<SEP>0x5356<SEP>0x55FD<SEP3>// <CJK>
0x9A76<SEP>0x5357<SEP>0x561B<SEP3>// <CJK>
0x9A77<SEP>0x5358<SEP>0x55F9<SEP3>// <CJK>
0x9A78<SEP>0x5359<SEP>0x564E<SEP3>// <CJK>
0x9A79<SEP>0x535A<SEP>0x5650<SEP3>// <CJK>
0x9A7A<SEP>0x535B<SEP>0x71DF<SEP3>// <CJK>
0x9A7B<SEP>0x535C<SEP>0x5634<SEP3>// <CJK>
0x9A7C<SEP>0x535D<SEP>0x5636<SEP3>// <CJK>
0x9A7D<SEP>0x535E<SEP>0x5632<SEP3>// <CJK>
0x9A7E<SEP>0x535F<SEP>0x5638<SEP3>// <CJK>
0x9A80<SEP>0x5360<SEP>0x566B<SEP3>// <CJK>
0x9A81<SEP>0x5361<SEP>0x5664<SEP3>// <CJK>
0x9A82<SEP>0x5362<SEP>0x562F<SEP3>// <CJK>
0x9A83<SEP>0x5363<SEP>0x566C<SEP3>// <CJK>
0x9A84<SEP>0x5364<SEP>0x566A<SEP3>// <CJK>
0x9A85<SEP>0x5365<SEP>0x5686<SEP3>// <CJK>
0x9A86<SEP>0x5366<SEP>0x5680<SEP3>// <CJK>
0x9A87<SEP>0x5367<SEP>0x568A<SEP3>// <CJK>
0x9A88<SEP>0x5368<SEP>0x56A0<SEP3>// <CJK>
0x9A89<SEP>0x5369<SEP>0x5694<SEP3>// <CJK>
0x9A8A<SEP>0x536A<SEP>0x568F<SEP3>// <CJK>
0x9A8B<SEP>0x536B<SEP>0x56A5<SEP3>// <CJK>
0x9A8C<SEP>0x536C<SEP>0x56AE<SEP3>// <CJK>
0x9A8D<SEP>0x536D<SEP>0x56B6<SEP3>// <CJK>
0x9A8E<SEP>0x536E<SEP>0x56B4<SEP3>// <CJK>
0x9A8F<SEP>0x536F<SEP>0x56C2<SEP3>// <CJK>
0x9A90<SEP>0x5370<SEP>0x56BC<SEP3>// <CJK>
0x9A91<SEP>0x5371<SEP>0x56C1<SEP3>// <CJK>
0x9A92<SEP>0x5372<SEP>0x56C3<SEP3>// <CJK>
0x9A93<SEP>0x5373<SEP>0x56C0<SEP3>// <CJK>
0x9A94<SEP>0x5374<SEP>0x56C8<SEP3>// <CJK>
0x9A95<SEP>0x5375<SEP>0x56CE<SEP3>// <CJK>
0x9A96<SEP>0x5376<SEP>0x56D1<SEP3>// <CJK>
0x9A97<SEP>0x5377<SEP>0x56D3<SEP3>// <CJK>
0x9A98<SEP>0x5378<SEP>0x56D7<SEP3>// <CJK>
0x9A99<SEP>0x5379<SEP>0x56EE<SEP3>// <CJK>
0x9A9A<SEP>0x537A<SEP>0x56F9<SEP3>// <CJK>
0x9A9B<SEP>0x537B<SEP>0x5700<SEP3>// <CJK>
0x9A9C<SEP>0x537C<SEP>0x56FF<SEP3>// <CJK>
0x9A9D<SEP>0x537D<SEP>0x5704<SEP3>// <CJK>
0x9A9E<SEP>0x537E<SEP>0x5709<SEP3>// <CJK>
0x9A9F<SEP>0x5421<SEP>0x5708<SEP3>// <CJK>
0x9AA0<SEP>0x5422<SEP>0x570B<SEP3>// <CJK>
0x9AA1<SEP>0x5423<SEP>0x570D<SEP3>// <CJK>
0x9AA2<SEP>0x5424<SEP>0x5713<SEP3>// <CJK>
0x9AA3<SEP>0x5425<SEP>0x5718<SEP3>// <CJK>
0x9AA4<SEP>0x5426<SEP>0x5716<SEP3>// <CJK>
0x9AA5<SEP>0x5427<SEP>0x55C7<SEP3>// <CJK>
0x9AA6<SEP>0x5428<SEP>0x571C<SEP3>// <CJK>
0x9AA7<SEP>0x5429<SEP>0x5726<SEP3>// <CJK>
0x9AA8<SEP>0x542A<SEP>0x5737<SEP3>// <CJK>
0x9AA9<SEP>0x542B<SEP>0x5738<SEP3>// <CJK>
0x9AAA<SEP>0x542C<SEP>0x574E<SEP3>// <CJK>
0x9AAB<SEP>0x542D<SEP>0x573B<SEP3>// <CJK>
0x9AAC<SEP>0x542E<SEP>0x5740<SEP3>// <CJK>
0x9AAD<SEP>0x542F<SEP>0x574F<SEP3>// <CJK>
0x9AAE<SEP>0x5430<SEP>0x5769<SEP3>// <CJK>
0x9AAF<SEP>0x5431<SEP>0x57C0<SEP3>// <CJK>
0x9AB0<SEP>0x5432<SEP>0x5788<SEP3>// <CJK>
0x9AB1<SEP>0x5433<SEP>0x5761<SEP3>// <CJK>
0x9AB2<SEP>0x5434<SEP>0x577F<SEP3>// <CJK>
0x9AB3<SEP>0x5435<SEP>0x5789<SEP3>// <CJK>
0x9AB4<SEP>0x5436<SEP>0x5793<SEP3>// <CJK>
0x9AB5<SEP>0x5437<SEP>0x57A0<SEP3>// <CJK>
0x9AB6<SEP>0x5438<SEP>0x57B3<SEP3>// <CJK>
0x9AB7<SEP>0x5439<SEP>0x57A4<SEP3>// <CJK>
0x9AB8<SEP>0x543A<SEP>0x57AA<SEP3>// <CJK>
0x9AB9<SEP>0x543B<SEP>0x57B0<SEP3>// <CJK>
0x9ABA<SEP>0x543C<SEP>0x57C3<SEP3>// <CJK>
0x9ABB<SEP>0x543D<SEP>0x57C6<SEP3>// <CJK>
0x9ABC<SEP>0x543E<SEP>0x57D4<SEP3>// <CJK>
0x9ABD<SEP>0x543F<SEP>0x57D2<SEP3>// <CJK>
0x9ABE<SEP>0x5440<SEP>0x57D3<SEP3>// <CJK>
0x9ABF<SEP>0x5441<SEP>0x580A<SEP3>// <CJK>
0x9AC0<SEP>0x5442<SEP>0x57D6<SEP3>// <CJK>
0x9AC1<SEP>0x5443<SEP>0x57E3<SEP3>// <CJK>
0x9AC2<SEP>0x5444<SEP>0x580B<SEP3>// <CJK>
0x9AC3<SEP>0x5445<SEP>0x5819<SEP3>// <CJK>
0x9AC4<SEP>0x5446<SEP>0x581D<SEP3>// <CJK>
0x9AC5<SEP>0x5447<SEP>0x5872<SEP3>// <CJK>
0x9AC6<SEP>0x5448<SEP>0x5821<SEP3>// <CJK>
0x9AC7<SEP>0x5449<SEP>0x5862<SEP3>// <CJK>
0x9AC8<SEP>0x544A<SEP>0x584B<SEP3>// <CJK>
0x9AC9<SEP>0x544B<SEP>0x5870<SEP3>// <CJK>
0x9ACA<SEP>0x544C<SEP>0x6BC0<SEP3>// <CJK>
0x9ACB<SEP>0x544D<SEP>0x5852<SEP3>// <CJK>
0x9ACC<SEP>0x544E<SEP>0x583D<SEP3>// <CJK>
0x9ACD<SEP>0x544F<SEP>0x5879<SEP3>// <CJK>
0x9ACE<SEP>0x5450<SEP>0x5885<SEP3>// <CJK>
0x9ACF<SEP>0x5451<SEP>0x58B9<SEP3>// <CJK>
0x9AD0<SEP>0x5452<SEP>0x589F<SEP3>// <CJK>
0x9AD1<SEP>0x5453<SEP>0x58AB<SEP3>// <CJK>
0x9AD2<SEP>0x5454<SEP>0x58BA<SEP3>// <CJK>
0x9AD3<SEP>0x5455<SEP>0x58DE<SEP3>// <CJK>
0x9AD4<SEP>0x5456<SEP>0x58BB<SEP3>// <CJK>
0x9AD5<SEP>0x5457<SEP>0x58B8<SEP3>// <CJK>
0x9AD6<SEP>0x5458<SEP>0x58AE<SEP3>// <CJK>
0x9AD7<SEP>0x5459<SEP>0x58C5<SEP3>// <CJK>
0x9AD8<SEP>0x545A<SEP>0x58D3<SEP3>// <CJK>
0x9AD9<SEP>0x545B<SEP>0x58D1<SEP3>// <CJK>
0x9ADA<SEP>0x545C<SEP>0x58D7<SEP3>// <CJK>
0x9ADB<SEP>0x545D<SEP>0x58D9<SEP3>// <CJK>
0x9ADC<SEP>0x545E<SEP>0x58D8<SEP3>// <CJK>
0x9ADD<SEP>0x545F<SEP>0x58E5<SEP3>// <CJK>
0x9ADE<SEP>0x5460<SEP>0x58DC<SEP3>// <CJK>
0x9ADF<SEP>0x5461<SEP>0x58E4<SEP3>// <CJK>
0x9AE0<SEP>0x5462<SEP>0x58DF<SEP3>// <CJK>
0x9AE1<SEP>0x5463<SEP>0x58EF<SEP3>// <CJK>
0x9AE2<SEP>0x5464<SEP>0x58FA<SEP3>// <CJK>
0x9AE3<SEP>0x5465<SEP>0x58F9<SEP3>// <CJK>
0x9AE4<SEP>0x5466<SEP>0x58FB<SEP3>// <CJK>
0x9AE5<SEP>0x5467<SEP>0x58FC<SEP3>// <CJK>
0x9AE6<SEP>0x5468<SEP>0x58FD<SEP3>// <CJK>
0x9AE7<SEP>0x5469<SEP>0x5902<SEP3>// <CJK>
0x9AE8<SEP>0x546A<SEP>0x590A<SEP3>// <CJK>
0x9AE9<SEP>0x546B<SEP>0x5910<SEP3>// <CJK>
0x9AEA<SEP>0x546C<SEP>0x591B<SEP3>// <CJK>
0x9AEB<SEP>0x546D<SEP>0x68A6<SEP3>// <CJK>
0x9AEC<SEP>0x546E<SEP>0x5925<SEP3>// <CJK>
0x9AED<SEP>0x546F<SEP>0x592C<SEP3>// <CJK>
0x9AEE<SEP>0x5470<SEP>0x592D<SEP3>// <CJK>
0x9AEF<SEP>0x5471<SEP>0x5932<SEP3>// <CJK>
0x9AF0<SEP>0x5472<SEP>0x5938<SEP3>// <CJK>
0x9AF1<SEP>0x5473<SEP>0x593E<SEP3>// <CJK>
0x9AF2<SEP>0x5474<SEP>0x7AD2<SEP3>// <CJK>
0x9AF3<SEP>0x5475<SEP>0x5955<SEP3>// <CJK>
0x9AF4<SEP>0x5476<SEP>0x5950<SEP3>// <CJK>
0x9AF5<SEP>0x5477<SEP>0x594E<SEP3>// <CJK>
0x9AF6<SEP>0x5478<SEP>0x595A<SEP3>// <CJK>
0x9AF7<SEP>0x5479<SEP>0x5958<SEP3>// <CJK>
0x9AF8<SEP>0x547A<SEP>0x5962<SEP3>// <CJK>
0x9AF9<SEP>0x547B<SEP>0x5960<SEP3>// <CJK>
0x9AFA<SEP>0x547C<SEP>0x5967<SEP3>// <CJK>
0x9AFB<SEP>0x547D<SEP>0x596C<SEP3>// <CJK>
0x9AFC<SEP>0x547E<SEP>0x5969<SEP3>// <CJK>
0x9B40<SEP>0x5521<SEP>0x5978<SEP3>// <CJK>
0x9B41<SEP>0x5522<SEP>0x5981<SEP3>// <CJK>
0x9B42<SEP>0x5523<SEP>0x599D<SEP3>// <CJK>
0x9B43<SEP>0x5524<SEP>0x4F5E<SEP3>// <CJK>
0x9B44<SEP>0x5525<SEP>0x4FAB<SEP3>// <CJK>
0x9B45<SEP>0x5526<SEP>0x59A3<SEP3>// <CJK>
0x9B46<SEP>0x5527<SEP>0x59B2<SEP3>// <CJK>
0x9B47<SEP>0x5528<SEP>0x59C6<SEP3>// <CJK>
0x9B48<SEP>0x5529<SEP>0x59E8<SEP3>// <CJK>
0x9B49<SEP>0x552A<SEP>0x59DC<SEP3>// <CJK>
0x9B4A<SEP>0x552B<SEP>0x598D<SEP3>// <CJK>
0x9B4B<SEP>0x552C<SEP>0x59D9<SEP3>// <CJK>
0x9B4C<SEP>0x552D<SEP>0x59DA<SEP3>// <CJK>
0x9B4D<SEP>0x552E<SEP>0x5A25<SEP3>// <CJK>
0x9B4E<SEP>0x552F<SEP>0x5A1F<SEP3>// <CJK>
0x9B4F<SEP>0x5530<SEP>0x5A11<SEP3>// <CJK>
0x9B50<SEP>0x5531<SEP>0x5A1C<SEP3>// <CJK>
0x9B51<SEP>0x5532<SEP>0x5A09<SEP3>// <CJK>
0x9B52<SEP>0x5533<SEP>0x5A1A<SEP3>// <CJK>
0x9B53<SEP>0x5534<SEP>0x5A40<SEP3>// <CJK>
0x9B54<SEP>0x5535<SEP>0x5A6C<SEP3>// <CJK>
0x9B55<SEP>0x5536<SEP>0x5A49<SEP3>// <CJK>
0x9B56<SEP>0x5537<SEP>0x5A35<SEP3>// <CJK>
0x9B57<SEP>0x5538<SEP>0x5A36<SEP3>// <CJK>
0x9B58<SEP>0x5539<SEP>0x5A62<SEP3>// <CJK>
0x9B59<SEP>0x553A<SEP>0x5A6A<SEP3>// <CJK>
0x9B5A<SEP>0x553B<SEP>0x5A9A<SEP3>// <CJK>
0x9B5B<SEP>0x553C<SEP>0x5ABC<SEP3>// <CJK>
0x9B5C<SEP>0x553D<SEP>0x5ABE<SEP3>// <CJK>
0x9B5D<SEP>0x553E<SEP>0x5ACB<SEP3>// <CJK>
0x9B5E<SEP>0x553F<SEP>0x5AC2<SEP3>// <CJK>
0x9B5F<SEP>0x5540<SEP>0x5ABD<SEP3>// <CJK>
0x9B60<SEP>0x5541<SEP>0x5AE3<SEP3>// <CJK>
0x9B61<SEP>0x5542<SEP>0x5AD7<SEP3>// <CJK>
0x9B62<SEP>0x5543<SEP>0x5AE6<SEP3>// <CJK>
0x9B63<SEP>0x5544<SEP>0x5AE9<SEP3>// <CJK>
0x9B64<SEP>0x5545<SEP>0x5AD6<SEP3>// <CJK>
0x9B65<SEP>0x5546<SEP>0x5AFA<SEP3>// <CJK>
0x9B66<SEP>0x5547<SEP>0x5AFB<SEP3>// <CJK>
0x9B67<SEP>0x5548<SEP>0x5B0C<SEP3>// <CJK>
0x9B68<SEP>0x5549<SEP>0x5B0B<SEP3>// <CJK>
0x9B69<SEP>0x554A<SEP>0x5B16<SEP3>// <CJK>
0x9B6A<SEP>0x554B<SEP>0x5B32<SEP3>// <CJK>
0x9B6B<SEP>0x554C<SEP>0x5AD0<SEP3>// <CJK>
0x9B6C<SEP>0x554D<SEP>0x5B2A<SEP3>// <CJK>
0x9B6D<SEP>0x554E<SEP>0x5B36<SEP3>// <CJK>
0x9B6E<SEP>0x554F<SEP>0x5B3E<SEP3>// <CJK>
0x9B6F<SEP>0x5550<SEP>0x5B43<SEP3>// <CJK>
0x9B70<SEP>0x5551<SEP>0x5B45<SEP3>// <CJK>
0x9B71<SEP>0x5552<SEP>0x5B40<SEP3>// <CJK>
0x9B72<SEP>0x5553<SEP>0x5B51<SEP3>// <CJK>
0x9B73<SEP>0x5554<SEP>0x5B55<SEP3>// <CJK>
0x9B74<SEP>0x5555<SEP>0x5B5A<SEP3>// <CJK>
0x9B75<SEP>0x5556<SEP>0x5B5B<SEP3>// <CJK>
0x9B76<SEP>0x5557<SEP>0x5B65<SEP3>// <CJK>
0x9B77<SEP>0x5558<SEP>0x5B69<SEP3>// <CJK>
0x9B78<SEP>0x5559<SEP>0x5B70<SEP3>// <CJK>
0x9B79<SEP>0x555A<SEP>0x5B73<SEP3>// <CJK>
0x9B7A<SEP>0x555B<SEP>0x5B75<SEP3>// <CJK>
0x9B7B<SEP>0x555C<SEP>0x5B78<SEP3>// <CJK>
0x9B7C<SEP>0x555D<SEP>0x6588<SEP3>// <CJK>
0x9B7D<SEP>0x555E<SEP>0x5B7A<SEP3>// <CJK>
0x9B7E<SEP>0x555F<SEP>0x5B80<SEP3>// <CJK>
0x9B80<SEP>0x5560<SEP>0x5B83<SEP3>// <CJK>
0x9B81<SEP>0x5561<SEP>0x5BA6<SEP3>// <CJK>
0x9B82<SEP>0x5562<SEP>0x5BB8<SEP3>// <CJK>
0x9B83<SEP>0x5563<SEP>0x5BC3<SEP3>// <CJK>
0x9B84<SEP>0x5564<SEP>0x5BC7<SEP3>// <CJK>
0x9B85<SEP>0x5565<SEP>0x5BC9<SEP3>// <CJK>
0x9B86<SEP>0x5566<SEP>0x5BD4<SEP3>// <CJK>
0x9B87<SEP>0x5567<SEP>0x5BD0<SEP3>// <CJK>
0x9B88<SEP>0x5568<SEP>0x5BE4<SEP3>// <CJK>
0x9B89<SEP>0x5569<SEP>0x5BE6<SEP3>// <CJK>
0x9B8A<SEP>0x556A<SEP>0x5BE2<SEP3>// <CJK>
0x9B8B<SEP>0x556B<SEP>0x5BDE<SEP3>// <CJK>
0x9B8C<SEP>0x556C<SEP>0x5BE5<SEP3>// <CJK>
0x9B8D<SEP>0x556D<SEP>0x5BEB<SEP3>// <CJK>
0x9B8E<SEP>0x556E<SEP>0x5BF0<SEP3>// <CJK>
0x9B8F<SEP>0x556F<SEP>0x5BF6<SEP3>// <CJK>
0x9B90<SEP>0x5570<SEP>0x5BF3<SEP3>// <CJK>
0x9B91<SEP>0x5571<SEP>0x5C05<SEP3>// <CJK>
0x9B92<SEP>0x5572<SEP>0x5C07<SEP3>// <CJK>
0x9B93<SEP>0x5573<SEP>0x5C08<SEP3>// <CJK>
0x9B94<SEP>0x5574<SEP>0x5C0D<SEP3>// <CJK>
0x9B95<SEP>0x5575<SEP>0x5C13<SEP3>// <CJK>
0x9B96<SEP>0x5576<SEP>0x5C20<SEP3>// <CJK>
0x9B97<SEP>0x5577<SEP>0x5C22<SEP3>// <CJK>
0x9B98<SEP>0x5578<SEP>0x5C28<SEP3>// <CJK>
0x9B99<SEP>0x5579<SEP>0x5C38<SEP3>// <CJK>
0x9B9A<SEP>0x557A<SEP>0x5C39<SEP3>// <CJK>
0x9B9B<SEP>0x557B<SEP>0x5C41<SEP3>// <CJK>
0x9B9C<SEP>0x557C<SEP>0x5C46<SEP3>// <CJK>
0x9B9D<SEP>0x557D<SEP>0x5C4E<SEP3>// <CJK>
0x9B9E<SEP>0x557E<SEP>0x5C53<SEP3>// <CJK>
0x9B9F<SEP>0x5621<SEP>0x5C50<SEP3>// <CJK>
0x9BA0<SEP>0x5622<SEP>0x5C4F<SEP3>// <CJK>
0x9BA1<SEP>0x5623<SEP>0x5B71<SEP3>// <CJK>
0x9BA2<SEP>0x5624<SEP>0x5C6C<SEP3>// <CJK>
0x9BA3<SEP>0x5625<SEP>0x5C6E<SEP3>// <CJK>
0x9BA4<SEP>0x5626<SEP>0x4E62<SEP3>// <CJK>
0x9BA5<SEP>0x5627<SEP>0x5C76<SEP3>// <CJK>
0x9BA6<SEP>0x5628<SEP>0x5C79<SEP3>// <CJK>
0x9BA7<SEP>0x5629<SEP>0x5C8C<SEP3>// <CJK>
0x9BA8<SEP>0x562A<SEP>0x5C91<SEP3>// <CJK>
0x9BA9<SEP>0x562B<SEP>0x5C94<SEP3>// <CJK>
0x9BAA<SEP>0x562C<SEP>0x599B<SEP3>// <CJK>
0x9BAB<SEP>0x562D<SEP>0x5CAB<SEP3>// <CJK>
0x9BAC<SEP>0x562E<SEP>0x5CBB<SEP3>// <CJK>
0x9BAD<SEP>0x562F<SEP>0x5CB6<SEP3>// <CJK>
0x9BAE<SEP>0x5630<SEP>0x5CBC<SEP3>// <CJK>
0x9BAF<SEP>0x5631<SEP>0x5CB7<SEP3>// <CJK>
0x9BB0<SEP>0x5632<SEP>0x5CC5<SEP3>// <CJK>
0x9BB1<SEP>0x5633<SEP>0x5CBE<SEP3>// <CJK>
0x9BB2<SEP>0x5634<SEP>0x5CC7<SEP3>// <CJK>
0x9BB3<SEP>0x5635<SEP>0x5CD9<SEP3>// <CJK>
0x9BB4<SEP>0x5636<SEP>0x5CE9<SEP3>// <CJK>
0x9BB5<SEP>0x5637<SEP>0x5CFD<SEP3>// <CJK>
0x9BB6<SEP>0x5638<SEP>0x5CFA<SEP3>// <CJK>
0x9BB7<SEP>0x5639<SEP>0x5CED<SEP3>// <CJK>
0x9BB8<SEP>0x563A<SEP>0x5D8C<SEP3>// <CJK>
0x9BB9<SEP>0x563B<SEP>0x5CEA<SEP3>// <CJK>
0x9BBA<SEP>0x563C<SEP>0x5D0B<SEP3>// <CJK>
0x9BBB<SEP>0x563D<SEP>0x5D15<SEP3>// <CJK>
0x9BBC<SEP>0x563E<SEP>0x5D17<SEP3>// <CJK>
0x9BBD<SEP>0x563F<SEP>0x5D5C<SEP3>// <CJK>
0x9BBE<SEP>0x5640<SEP>0x5D1F<SEP3>// <CJK>
0x9BBF<SEP>0x5641<SEP>0x5D1B<SEP3>// <CJK>
0x9BC0<SEP>0x5642<SEP>0x5D11<SEP3>// <CJK>
0x9BC1<SEP>0x5643<SEP>0x5D14<SEP3>// <CJK>
0x9BC2<SEP>0x5644<SEP>0x5D22<SEP3>// <CJK>
0x9BC3<SEP>0x5645<SEP>0x5D1A<SEP3>// <CJK>
0x9BC4<SEP>0x5646<SEP>0x5D19<SEP3>// <CJK>
0x9BC5<SEP>0x5647<SEP>0x5D18<SEP3>// <CJK>
0x9BC6<SEP>0x5648<SEP>0x5D4C<SEP3>// <CJK>
0x9BC7<SEP>0x5649<SEP>0x5D52<SEP3>// <CJK>
0x9BC8<SEP>0x564A<SEP>0x5D4E<SEP3>// <CJK>
0x9BC9<SEP>0x564B<SEP>0x5D4B<SEP3>// <CJK>
0x9BCA<SEP>0x564C<SEP>0x5D6C<SEP3>// <CJK>
0x9BCB<SEP>0x564D<SEP>0x5D73<SEP3>// <CJK>
0x9BCC<SEP>0x564E<SEP>0x5D76<SEP3>// <CJK>
0x9BCD<SEP>0x564F<SEP>0x5D87<SEP3>// <CJK>
0x9BCE<SEP>0x5650<SEP>0x5D84<SEP3>// <CJK>
0x9BCF<SEP>0x5651<SEP>0x5D82<SEP3>// <CJK>
0x9BD0<SEP>0x5652<SEP>0x5DA2<SEP3>// <CJK>
0x9BD1<SEP>0x5653<SEP>0x5D9D<SEP3>// <CJK>
0x9BD2<SEP>0x5654<SEP>0x5DAC<SEP3>// <CJK>
0x9BD3<SEP>0x5655<SEP>0x5DAE<SEP3>// <CJK>
0x9BD4<SEP>0x5656<SEP>0x5DBD<SEP3>// <CJK>
0x9BD5<SEP>0x5657<SEP>0x5D90<SEP3>// <CJK>
0x9BD6<SEP>0x5658<SEP>0x5DB7<SEP3>// <CJK>
0x9BD7<SEP>0x5659<SEP>0x5DBC<SEP3>// <CJK>
0x9BD8<SEP>0x565A<SEP>0x5DC9<SEP3>// <CJK>
0x9BD9<SEP>0x565B<SEP>0x5DCD<SEP3>// <CJK>
0x9BDA<SEP>0x565C<SEP>0x5DD3<SEP3>// <CJK>
0x9BDB<SEP>0x565D<SEP>0x5DD2<SEP3>// <CJK>
0x9BDC<SEP>0x565E<SEP>0x5DD6<SEP3>// <CJK>
0x9BDD<SEP>0x565F<SEP>0x5DDB<SEP3>// <CJK>
0x9BDE<SEP>0x5660<SEP>0x5DEB<SEP3>// <CJK>
0x9BDF<SEP>0x5661<SEP>0x5DF2<SEP3>// <CJK>
0x9BE0<SEP>0x5662<SEP>0x5DF5<SEP3>// <CJK>
0x9BE1<SEP>0x5663<SEP>0x5E0B<SEP3>// <CJK>
0x9BE2<SEP>0x5664<SEP>0x5E1A<SEP3>// <CJK>
0x9BE3<SEP>0x5665<SEP>0x5E19<SEP3>// <CJK>
0x9BE4<SEP>0x5666<SEP>0x5E11<SEP3>// <CJK>
0x9BE5<SEP>0x5667<SEP>0x5E1B<SEP3>// <CJK>
0x9BE6<SEP>0x5668<SEP>0x5E36<SEP3>// <CJK>
0x9BE7<SEP>0x5669<SEP>0x5E37<SEP3>// <CJK>
0x9BE8<SEP>0x566A<SEP>0x5E44<SEP3>// <CJK>
0x9BE9<SEP>0x566B<SEP>0x5E43<SEP3>// <CJK>
0x9BEA<SEP>0x566C<SEP>0x5E40<SEP3>// <CJK>
0x9BEB<SEP>0x566D<SEP>0x5E4E<SEP3>// <CJK>
0x9BEC<SEP>0x566E<SEP>0x5E57<SEP3>// <CJK>
0x9BED<SEP>0x566F<SEP>0x5E54<SEP3>// <CJK>
0x9BEE<SEP>0x5670<SEP>0x5E5F<SEP3>// <CJK>
0x9BEF<SEP>0x5671<SEP>0x5E62<SEP3>// <CJK>
0x9BF0<SEP>0x5672<SEP>0x5E64<SEP3>// <CJK>
0x9BF1<SEP>0x5673<SEP>0x5E47<SEP3>// <CJK>
0x9BF2<SEP>0x5674<SEP>0x5E75<SEP3>// <CJK>
0x9BF3<SEP>0x5675<SEP>0x5E76<SEP3>// <CJK>
0x9BF4<SEP>0x5676<SEP>0x5E7A<SEP3>// <CJK>
0x9BF5<SEP>0x5677<SEP>0x9EBC<SEP3>// <CJK>
0x9BF6<SEP>0x5678<SEP>0x5E7F<SEP3>// <CJK>
0x9BF7<SEP>0x5679<SEP>0x5EA0<SEP3>// <CJK>
0x9BF8<SEP>0x567A<SEP>0x5EC1<SEP3>// <CJK>
0x9BF9<SEP>0x567B<SEP>0x5EC2<SEP3>// <CJK>
0x9BFA<SEP>0x567C<SEP>0x5EC8<SEP3>// <CJK>
0x9BFB<SEP>0x567D<SEP>0x5ED0<SEP3>// <CJK>
0x9BFC<SEP>0x567E<SEP>0x5ECF<SEP3>// <CJK>
0x9C40<SEP>0x5721<SEP>0x5ED6<SEP3>// <CJK>
0x9C41<SEP>0x5722<SEP>0x5EE3<SEP3>// <CJK>
0x9C42<SEP>0x5723<SEP>0x5EDD<SEP3>// <CJK>
0x9C43<SEP>0x5724<SEP>0x5EDA<SEP3>// <CJK>
0x9C44<SEP>0x5725<SEP>0x5EDB<SEP3>// <CJK>
0x9C45<SEP>0x5726<SEP>0x5EE2<SEP3>// <CJK>
0x9C46<SEP>0x5727<SEP>0x5EE1<SEP3>// <CJK>
0x9C47<SEP>0x5728<SEP>0x5EE8<SEP3>// <CJK>
0x9C48<SEP>0x5729<SEP>0x5EE9<SEP3>// <CJK>
0x9C49<SEP>0x572A<SEP>0x5EEC<SEP3>// <CJK>
0x9C4A<SEP>0x572B<SEP>0x5EF1<SEP3>// <CJK>
0x9C4B<SEP>0x572C<SEP>0x5EF3<SEP3>// <CJK>
0x9C4C<SEP>0x572D<SEP>0x5EF0<SEP3>// <CJK>
0x9C4D<SEP>0x572E<SEP>0x5EF4<SEP3>// <CJK>
0x9C4E<SEP>0x572F<SEP>0x5EF8<SEP3>// <CJK>
0x9C4F<SEP>0x5730<SEP>0x5EFE<SEP3>// <CJK>
0x9C50<SEP>0x5731<SEP>0x5F03<SEP3>// <CJK>
0x9C51<SEP>0x5732<SEP>0x5F09<SEP3>// <CJK>
0x9C52<SEP>0x5733<SEP>0x5F5D<SEP3>// <CJK>
0x9C53<SEP>0x5734<SEP>0x5F5C<SEP3>// <CJK>
0x9C54<SEP>0x5735<SEP>0x5F0B<SEP3>// <CJK>
0x9C55<SEP>0x5736<SEP>0x5F11<SEP3>// <CJK>
0x9C56<SEP>0x5737<SEP>0x5F16<SEP3>// <CJK>
0x9C57<SEP>0x5738<SEP>0x5F29<SEP3>// <CJK>
0x9C58<SEP>0x5739<SEP>0x5F2D<SEP3>// <CJK>
0x9C59<SEP>0x573A<SEP>0x5F38<SEP3>// <CJK>
0x9C5A<SEP>0x573B<SEP>0x5F41<SEP3>// <CJK>
0x9C5B<SEP>0x573C<SEP>0x5F48<SEP3>// <CJK>
0x9C5C<SEP>0x573D<SEP>0x5F4C<SEP3>// <CJK>
0x9C5D<SEP>0x573E<SEP>0x5F4E<SEP3>// <CJK>
0x9C5E<SEP>0x573F<SEP>0x5F2F<SEP3>// <CJK>
0x9C5F<SEP>0x5740<SEP>0x5F51<SEP3>// <CJK>
0x9C60<SEP>0x5741<SEP>0x5F56<SEP3>// <CJK>
0x9C61<SEP>0x5742<SEP>0x5F57<SEP3>// <CJK>
0x9C62<SEP>0x5743<SEP>0x5F59<SEP3>// <CJK>
0x9C63<SEP>0x5744<SEP>0x5F61<SEP3>// <CJK>
0x9C64<SEP>0x5745<SEP>0x5F6D<SEP3>// <CJK>
0x9C65<SEP>0x5746<SEP>0x5F73<SEP3>// <CJK>
0x9C66<SEP>0x5747<SEP>0x5F77<SEP3>// <CJK>
0x9C67<SEP>0x5748<SEP>0x5F83<SEP3>// <CJK>
0x9C68<SEP>0x5749<SEP>0x5F82<SEP3>// <CJK>
0x9C69<SEP>0x574A<SEP>0x5F7F<SEP3>// <CJK>
0x9C6A<SEP>0x574B<SEP>0x5F8A<SEP3>// <CJK>
0x9C6B<SEP>0x574C<SEP>0x5F88<SEP3>// <CJK>
0x9C6C<SEP>0x574D<SEP>0x5F91<SEP3>// <CJK>
0x9C6D<SEP>0x574E<SEP>0x5F87<SEP3>// <CJK>
0x9C6E<SEP>0x574F<SEP>0x5F9E<SEP3>// <CJK>
0x9C6F<SEP>0x5750<SEP>0x5F99<SEP3>// <CJK>
0x9C70<SEP>0x5751<SEP>0x5F98<SEP3>// <CJK>
0x9C71<SEP>0x5752<SEP>0x5FA0<SEP3>// <CJK>
0x9C72<SEP>0x5753<SEP>0x5FA8<SEP3>// <CJK>
0x9C73<SEP>0x5754<SEP>0x5FAD<SEP3>// <CJK>
0x9C74<SEP>0x5755<SEP>0x5FBC<SEP3>// <CJK>
0x9C75<SEP>0x5756<SEP>0x5FD6<SEP3>// <CJK>
0x9C76<SEP>0x5757<SEP>0x5FFB<SEP3>// <CJK>
0x9C77<SEP>0x5758<SEP>0x5FE4<SEP3>// <CJK>
0x9C78<SEP>0x5759<SEP>0x5FF8<SEP3>// <CJK>
0x9C79<SEP>0x575A<SEP>0x5FF1<SEP3>// <CJK>
0x9C7A<SEP>0x575B<SEP>0x5FDD<SEP3>// <CJK>
0x9C7B<SEP>0x575C<SEP>0x60B3<SEP3>// <CJK>
0x9C7C<SEP>0x575D<SEP>0x5FFF<SEP3>// <CJK>
0x9C7D<SEP>0x575E<SEP>0x6021<SEP3>// <CJK>
0x9C7E<SEP>0x575F<SEP>0x6060<SEP3>// <CJK>
0x9C80<SEP>0x5760<SEP>0x6019<SEP3>// <CJK>
0x9C81<SEP>0x5761<SEP>0x6010<SEP3>// <CJK>
0x9C82<SEP>0x5762<SEP>0x6029<SEP3>// <CJK>
0x9C83<SEP>0x5763<SEP>0x600E<SEP3>// <CJK>
0x9C84<SEP>0x5764<SEP>0x6031<SEP3>// <CJK>
0x9C85<SEP>0x5765<SEP>0x601B<SEP3>// <CJK>
0x9C86<SEP>0x5766<SEP>0x6015<SEP3>// <CJK>
0x9C87<SEP>0x5767<SEP>0x602B<SEP3>// <CJK>
0x9C88<SEP>0x5768<SEP>0x6026<SEP3>// <CJK>
0x9C89<SEP>0x5769<SEP>0x600F<SEP3>// <CJK>
0x9C8A<SEP>0x576A<SEP>0x603A<SEP3>// <CJK>
0x9C8B<SEP>0x576B<SEP>0x605A<SEP3>// <CJK>
0x9C8C<SEP>0x576C<SEP>0x6041<SEP3>// <CJK>
0x9C8D<SEP>0x576D<SEP>0x606A<SEP3>// <CJK>
0x9C8E<SEP>0x576E<SEP>0x6077<SEP3>// <CJK>
0x9C8F<SEP>0x576F<SEP>0x605F<SEP3>// <CJK>
0x9C90<SEP>0x5770<SEP>0x604A<SEP3>// <CJK>
0x9C91<SEP>0x5771<SEP>0x6046<SEP3>// <CJK>
0x9C92<SEP>0x5772<SEP>0x604D<SEP3>// <CJK>
0x9C93<SEP>0x5773<SEP>0x6063<SEP3>// <CJK>
0x9C94<SEP>0x5774<SEP>0x6043<SEP3>// <CJK>
0x9C95<SEP>0x5775<SEP>0x6064<SEP3>// <CJK>
0x9C96<SEP>0x5776<SEP>0x6042<SEP3>// <CJK>
0x9C97<SEP>0x5777<SEP>0x606C<SEP3>// <CJK>
0x9C98<SEP>0x5778<SEP>0x606B<SEP3>// <CJK>
0x9C99<SEP>0x5779<SEP>0x6059<SEP3>// <CJK>
0x9C9A<SEP>0x577A<SEP>0x6081<SEP3>// <CJK>
0x9C9B<SEP>0x577B<SEP>0x608D<SEP3>// <CJK>
0x9C9C<SEP>0x577C<SEP>0x60E7<SEP3>// <CJK>
0x9C9D<SEP>0x577D<SEP>0x6083<SEP3>// <CJK>
0x9C9E<SEP>0x577E<SEP>0x609A<SEP3>// <CJK>
0x9C9F<SEP>0x5821<SEP>0x6084<SEP3>// <CJK>
0x9CA0<SEP>0x5822<SEP>0x609B<SEP3>// <CJK>
0x9CA1<SEP>0x5823<SEP>0x6096<SEP3>// <CJK>
0x9CA2<SEP>0x5824<SEP>0x6097<SEP3>// <CJK>
0x9CA3<SEP>0x5825<SEP>0x6092<SEP3>// <CJK>
0x9CA4<SEP>0x5826<SEP>0x60A7<SEP3>// <CJK>
0x9CA5<SEP>0x5827<SEP>0x608B<SEP3>// <CJK>
0x9CA6<SEP>0x5828<SEP>0x60E1<SEP3>// <CJK>
0x9CA7<SEP>0x5829<SEP>0x60B8<SEP3>// <CJK>
0x9CA8<SEP>0x582A<SEP>0x60E0<SEP3>// <CJK>
0x9CA9<SEP>0x582B<SEP>0x60D3<SEP3>// <CJK>
0x9CAA<SEP>0x582C<SEP>0x60B4<SEP3>// <CJK>
0x9CAB<SEP>0x582D<SEP>0x5FF0<SEP3>// <CJK>
0x9CAC<SEP>0x582E<SEP>0x60BD<SEP3>// <CJK>
0x9CAD<SEP>0x582F<SEP>0x60C6<SEP3>// <CJK>
0x9CAE<SEP>0x5830<SEP>0x60B5<SEP3>// <CJK>
0x9CAF<SEP>0x5831<SEP>0x60D8<SEP3>// <CJK>
0x9CB0<SEP>0x5832<SEP>0x614D<SEP3>// <CJK>
0x9CB1<SEP>0x5833<SEP>0x6115<SEP3>// <CJK>
0x9CB2<SEP>0x5834<SEP>0x6106<SEP3>// <CJK>
0x9CB3<SEP>0x5835<SEP>0x60F6<SEP3>// <CJK>
0x9CB4<SEP>0x5836<SEP>0x60F7<SEP3>// <CJK>
0x9CB5<SEP>0x5837<SEP>0x6100<SEP3>// <CJK>
0x9CB6<SEP>0x5838<SEP>0x60F4<SEP3>// <CJK>
0x9CB7<SEP>0x5839<SEP>0x60FA<SEP3>// <CJK>
0x9CB8<SEP>0x583A<SEP>0x6103<SEP3>// <CJK>
0x9CB9<SEP>0x583B<SEP>0x6121<SEP3>// <CJK>
0x9CBA<SEP>0x583C<SEP>0x60FB<SEP3>// <CJK>
0x9CBB<SEP>0x583D<SEP>0x60F1<SEP3>// <CJK>
0x9CBC<SEP>0x583E<SEP>0x610D<SEP3>// <CJK>
0x9CBD<SEP>0x583F<SEP>0x610E<SEP3>// <CJK>
0x9CBE<SEP>0x5840<SEP>0x6147<SEP3>// <CJK>
0x9CBF<SEP>0x5841<SEP>0x613E<SEP3>// <CJK>
0x9CC0<SEP>0x5842<SEP>0x6128<SEP3>// <CJK>
0x9CC1<SEP>0x5843<SEP>0x6127<SEP3>// <CJK>
0x9CC2<SEP>0x5844<SEP>0x614A<SEP3>// <CJK>
0x9CC3<SEP>0x5845<SEP>0x613F<SEP3>// <CJK>
0x9CC4<SEP>0x5846<SEP>0x613C<SEP3>// <CJK>
0x9CC5<SEP>0x5847<SEP>0x612C<SEP3>// <CJK>
0x9CC6<SEP>0x5848<SEP>0x6134<SEP3>// <CJK>
0x9CC7<SEP>0x5849<SEP>0x613D<SEP3>// <CJK>
0x9CC8<SEP>0x584A<SEP>0x6142<SEP3>// <CJK>
0x9CC9<SEP>0x584B<SEP>0x6144<SEP3>// <CJK>
0x9CCA<SEP>0x584C<SEP>0x6173<SEP3>// <CJK>
0x9CCB<SEP>0x584D<SEP>0x6177<SEP3>// <CJK>
0x9CCC<SEP>0x584E<SEP>0x6158<SEP3>// <CJK>
0x9CCD<SEP>0x584F<SEP>0x6159<SEP3>// <CJK>
0x9CCE<SEP>0x5850<SEP>0x615A<SEP3>// <CJK>
0x9CCF<SEP>0x5851<SEP>0x616B<SEP3>// <CJK>
0x9CD0<SEP>0x5852<SEP>0x6174<SEP3>// <CJK>
0x9CD1<SEP>0x5853<SEP>0x616F<SEP3>// <CJK>
0x9CD2<SEP>0x5854<SEP>0x6165<SEP3>// <CJK>
0x9CD3<SEP>0x5855<SEP>0x6171<SEP3>// <CJK>
0x9CD4<SEP>0x5856<SEP>0x615F<SEP3>// <CJK>
0x9CD5<SEP>0x5857<SEP>0x615D<SEP3>// <CJK>
0x9CD6<SEP>0x5858<SEP>0x6153<SEP3>// <CJK>
0x9CD7<SEP>0x5859<SEP>0x6175<SEP3>// <CJK>
0x9CD8<SEP>0x585A<SEP>0x6199<SEP3>// <CJK>
0x9CD9<SEP>0x585B<SEP>0x6196<SEP3>// <CJK>
0x9CDA<SEP>0x585C<SEP>0x6187<SEP3>// <CJK>
0x9CDB<SEP>0x585D<SEP>0x61AC<SEP3>// <CJK>
0x9CDC<SEP>0x585E<SEP>0x6194<SEP3>// <CJK>
0x9CDD<SEP>0x585F<SEP>0x619A<SEP3>// <CJK>
0x9CDE<SEP>0x5860<SEP>0x618A<SEP3>// <CJK>
0x9CDF<SEP>0x5861<SEP>0x6191<SEP3>// <CJK>
0x9CE0<SEP>0x5862<SEP>0x61AB<SEP3>// <CJK>
0x9CE1<SEP>0x5863<SEP>0x61AE<SEP3>// <CJK>
0x9CE2<SEP>0x5864<SEP>0x61CC<SEP3>// <CJK>
0x9CE3<SEP>0x5865<SEP>0x61CA<SEP3>// <CJK>
0x9CE4<SEP>0x5866<SEP>0x61C9<SEP3>// <CJK>
0x9CE5<SEP>0x5867<SEP>0x61F7<SEP3>// <CJK>
0x9CE6<SEP>0x5868<SEP>0x61C8<SEP3>// <CJK>
0x9CE7<SEP>0x5869<SEP>0x61C3<SEP3>// <CJK>
0x9CE8<SEP>0x586A<SEP>0x61C6<SEP3>// <CJK>
0x9CE9<SEP>0x586B<SEP>0x61BA<SEP3>// <CJK>
0x9CEA<SEP>0x586C<SEP>0x61CB<SEP3>// <CJK>
0x9CEB<SEP>0x586D<SEP>0x7F79<SEP3>// <CJK>
0x9CEC<SEP>0x586E<SEP>0x61CD<SEP3>// <CJK>
0x9CED<SEP>0x586F<SEP>0x61E6<SEP3>// <CJK>
0x9CEE<SEP>0x5870<SEP>0x61E3<SEP3>// <CJK>
0x9CEF<SEP>0x5871<SEP>0x61F6<SEP3>// <CJK>
0x9CF0<SEP>0x5872<SEP>0x61FA<SEP3>// <CJK>
0x9CF1<SEP>0x5873<SEP>0x61F4<SEP3>// <CJK>
0x9CF2<SEP>0x5874<SEP>0x61FF<SEP3>// <CJK>
0x9CF3<SEP>0x5875<SEP>0x61FD<SEP3>// <CJK>
0x9CF4<SEP>0x5876<SEP>0x61FC<SEP3>// <CJK>
0x9CF5<SEP>0x5877<SEP>0x61FE<SEP3>// <CJK>
0x9CF6<SEP>0x5878<SEP>0x6200<SEP3>// <CJK>
0x9CF7<SEP>0x5879<SEP>0x6208<SEP3>// <CJK>
0x9CF8<SEP>0x587A<SEP>0x6209<SEP3>// <CJK>
0x9CF9<SEP>0x587B<SEP>0x620D<SEP3>// <CJK>
0x9CFA<SEP>0x587C<SEP>0x620C<SEP3>// <CJK>
0x9CFB<SEP>0x587D<SEP>0x6214<SEP3>// <CJK>
0x9CFC<SEP>0x587E<SEP>0x621B<SEP3>// <CJK>
0x9D40<SEP>0x5921<SEP>0x621E<SEP3>// <CJK>
0x9D41<SEP>0x5922<SEP>0x6221<SEP3>// <CJK>
0x9D42<SEP>0x5923<SEP>0x622A<SEP3>// <CJK>
0x9D43<SEP>0x5924<SEP>0x622E<SEP3>// <CJK>
0x9D44<SEP>0x5925<SEP>0x6230<SEP3>// <CJK>
0x9D45<SEP>0x5926<SEP>0x6232<SEP3>// <CJK>
0x9D46<SEP>0x5927<SEP>0x6233<SEP3>// <CJK>
0x9D47<SEP>0x5928<SEP>0x6241<SEP3>// <CJK>
0x9D48<SEP>0x5929<SEP>0x624E<SEP3>// <CJK>
0x9D49<SEP>0x592A<SEP>0x625E<SEP3>// <CJK>
0x9D4A<SEP>0x592B<SEP>0x6263<SEP3>// <CJK>
0x9D4B<SEP>0x592C<SEP>0x625B<SEP3>// <CJK>
0x9D4C<SEP>0x592D<SEP>0x6260<SEP3>// <CJK>
0x9D4D<SEP>0x592E<SEP>0x6268<SEP3>// <CJK>
0x9D4E<SEP>0x592F<SEP>0x627C<SEP3>// <CJK>
0x9D4F<SEP>0x5930<SEP>0x6282<SEP3>// <CJK>
0x9D50<SEP>0x5931<SEP>0x6289<SEP3>// <CJK>
0x9D51<SEP>0x5932<SEP>0x627E<SEP3>// <CJK>
0x9D52<SEP>0x5933<SEP>0x6292<SEP3>// <CJK>
0x9D53<SEP>0x5934<SEP>0x6293<SEP3>// <CJK>
0x9D54<SEP>0x5935<SEP>0x6296<SEP3>// <CJK>
0x9D55<SEP>0x5936<SEP>0x62D4<SEP3>// <CJK>
0x9D56<SEP>0x5937<SEP>0x6283<SEP3>// <CJK>
0x9D57<SEP>0x5938<SEP>0x6294<SEP3>// <CJK>
0x9D58<SEP>0x5939<SEP>0x62D7<SEP3>// <CJK>
0x9D59<SEP>0x593A<SEP>0x62D1<SEP3>// <CJK>
0x9D5A<SEP>0x593B<SEP>0x62BB<SEP3>// <CJK>
0x9D5B<SEP>0x593C<SEP>0x62CF<SEP3>// <CJK>
0x9D5C<SEP>0x593D<SEP>0x62FF<SEP3>// <CJK>
0x9D5D<SEP>0x593E<SEP>0x62C6<SEP3>// <CJK>
0x9D5E<SEP>0x593F<SEP>0x64D4<SEP3>// <CJK>
0x9D5F<SEP>0x5940<SEP>0x62C8<SEP3>// <CJK>
0x9D60<SEP>0x5941<SEP>0x62DC<SEP3>// <CJK>
0x9D61<SEP>0x5942<SEP>0x62CC<SEP3>// <CJK>
0x9D62<SEP>0x5943<SEP>0x62CA<SEP3>// <CJK>
0x9D63<SEP>0x5944<SEP>0x62C2<SEP3>// <CJK>
0x9D64<SEP>0x5945<SEP>0x62C7<SEP3>// <CJK>
0x9D65<SEP>0x5946<SEP>0x629B<SEP3>// <CJK>
0x9D66<SEP>0x5947<SEP>0x62C9<SEP3>// <CJK>
0x9D67<SEP>0x5948<SEP>0x630C<SEP3>// <CJK>
0x9D68<SEP>0x5949<SEP>0x62EE<SEP3>// <CJK>
0x9D69<SEP>0x594A<SEP>0x62F1<SEP3>// <CJK>
0x9D6A<SEP>0x594B<SEP>0x6327<SEP3>// <CJK>
0x9D6B<SEP>0x594C<SEP>0x6302<SEP3>// <CJK>
0x9D6C<SEP>0x594D<SEP>0x6308<SEP3>// <CJK>
0x9D6D<SEP>0x594E<SEP>0x62EF<SEP3>// <CJK>
0x9D6E<SEP>0x594F<SEP>0x62F5<SEP3>// <CJK>
0x9D6F<SEP>0x5950<SEP>0x6350<SEP3>// <CJK>
0x9D70<SEP>0x5951<SEP>0x633E<SEP3>// <CJK>
0x9D71<SEP>0x5952<SEP>0x634D<SEP3>// <CJK>
0x9D72<SEP>0x5953<SEP>0x641C<SEP3>// <CJK>
0x9D73<SEP>0x5954<SEP>0x634F<SEP3>// <CJK>
0x9D74<SEP>0x5955<SEP>0x6396<SEP3>// <CJK>
0x9D75<SEP>0x5956<SEP>0x638E<SEP3>// <CJK>
0x9D76<SEP>0x5957<SEP>0x6380<SEP3>// <CJK>
0x9D77<SEP>0x5958<SEP>0x63AB<SEP3>// <CJK>
0x9D78<SEP>0x5959<SEP>0x6376<SEP3>// <CJK>
0x9D79<SEP>0x595A<SEP>0x63A3<SEP3>// <CJK>
0x9D7A<SEP>0x595B<SEP>0x638F<SEP3>// <CJK>
0x9D7B<SEP>0x595C<SEP>0x6389<SEP3>// <CJK>
0x9D7C<SEP>0x595D<SEP>0x639F<SEP3>// <CJK>
0x9D7D<SEP>0x595E<SEP>0x63B5<SEP3>// <CJK>
0x9D7E<SEP>0x595F<SEP>0x636B<SEP3>// <CJK>
0x9D80<SEP>0x5960<SEP>0x6369<SEP3>// <CJK>
0x9D81<SEP>0x5961<SEP>0x63BE<SEP3>// <CJK>
0x9D82<SEP>0x5962<SEP>0x63E9<SEP3>// <CJK>
0x9D83<SEP>0x5963<SEP>0x63C0<SEP3>// <CJK>
0x9D84<SEP>0x5964<SEP>0x63C6<SEP3>// <CJK>
0x9D85<SEP>0x5965<SEP>0x63E3<SEP3>// <CJK>
0x9D86<SEP>0x5966<SEP>0x63C9<SEP3>// <CJK>
0x9D87<SEP>0x5967<SEP>0x63D2<SEP3>// <CJK>
0x9D88<SEP>0x5968<SEP>0x63F6<SEP3>// <CJK>
0x9D89<SEP>0x5969<SEP>0x63C4<SEP3>// <CJK>
0x9D8A<SEP>0x596A<SEP>0x6416<SEP3>// <CJK>
0x9D8B<SEP>0x596B<SEP>0x6434<SEP3>// <CJK>
0x9D8C<SEP>0x596C<SEP>0x6406<SEP3>// <CJK>
0x9D8D<SEP>0x596D<SEP>0x6413<SEP3>// <CJK>
0x9D8E<SEP>0x596E<SEP>0x6426<SEP3>// <CJK>
0x9D8F<SEP>0x596F<SEP>0x6436<SEP3>// <CJK>
0x9D90<SEP>0x5970<SEP>0x651D<SEP3>// <CJK>
0x9D91<SEP>0x5971<SEP>0x6417<SEP3>// <CJK>
0x9D92<SEP>0x5972<SEP>0x6428<SEP3>// <CJK>
0x9D93<SEP>0x5973<SEP>0x640F<SEP3>// <CJK>
0x9D94<SEP>0x5974<SEP>0x6467<SEP3>// <CJK>
0x9D95<SEP>0x5975<SEP>0x646F<SEP3>// <CJK>
0x9D96<SEP>0x5976<SEP>0x6476<SEP3>// <CJK>
0x9D97<SEP>0x5977<SEP>0x644E<SEP3>// <CJK>
0x9D98<SEP>0x5978<SEP>0x652A<SEP3>// <CJK>
0x9D99<SEP>0x5979<SEP>0x6495<SEP3>// <CJK>
0x9D9A<SEP>0x597A<SEP>0x6493<SEP3>// <CJK>
0x9D9B<SEP>0x597B<SEP>0x64A5<SEP3>// <CJK>
0x9D9C<SEP>0x597C<SEP>0x64A9<SEP3>// <CJK>
0x9D9D<SEP>0x597D<SEP>0x6488<SEP3>// <CJK>
0x9D9E<SEP>0x597E<SEP>0x64BC<SEP3>// <CJK>
0x9D9F<SEP>0x5A21<SEP>0x64DA<SEP3>// <CJK>
0x9DA0<SEP>0x5A22<SEP>0x64D2<SEP3>// <CJK>
0x9DA1<SEP>0x5A23<SEP>0x64C5<SEP3>// <CJK>
0x9DA2<SEP>0x5A24<SEP>0x64C7<SEP3>// <CJK>
0x9DA3<SEP>0x5A25<SEP>0x64BB<SEP3>// <CJK>
0x9DA4<SEP>0x5A26<SEP>0x64D8<SEP3>// <CJK>
0x9DA5<SEP>0x5A27<SEP>0x64C2<SEP3>// <CJK>
0x9DA6<SEP>0x5A28<SEP>0x64F1<SEP3>// <CJK>
0x9DA7<SEP>0x5A29<SEP>0x64E7<SEP3>// <CJK>
0x9DA8<SEP>0x5A2A<SEP>0x8209<SEP3>// <CJK>
0x9DA9<SEP>0x5A2B<SEP>0x64E0<SEP3>// <CJK>
0x9DAA<SEP>0x5A2C<SEP>0x64E1<SEP3>// <CJK>
0x9DAB<SEP>0x5A2D<SEP>0x62AC<SEP3>// <CJK>
0x9DAC<SEP>0x5A2E<SEP>0x64E3<SEP3>// <CJK>
0x9DAD<SEP>0x5A2F<SEP>0x64EF<SEP3>// <CJK>
0x9DAE<SEP>0x5A30<SEP>0x652C<SEP3>// <CJK>
0x9DAF<SEP>0x5A31<SEP>0x64F6<SEP3>// <CJK>
0x9DB0<SEP>0x5A32<SEP>0x64F4<SEP3>// <CJK>
0x9DB1<SEP>0x5A33<SEP>0x64F2<SEP3>// <CJK>
0x9DB2<SEP>0x5A34<SEP>0x64FA<SEP3>// <CJK>
0x9DB3<SEP>0x5A35<SEP>0x6500<SEP3>// <CJK>
0x9DB4<SEP>0x5A36<SEP>0x64FD<SEP3>// <CJK>
0x9DB5<SEP>0x5A37<SEP>0x6518<SEP3>// <CJK>
0x9DB6<SEP>0x5A38<SEP>0x651C<SEP3>// <CJK>
0x9DB7<SEP>0x5A39<SEP>0x6505<SEP3>// <CJK>
0x9DB8<SEP>0x5A3A<SEP>0x6524<SEP3>// <CJK>
0x9DB9<SEP>0x5A3B<SEP>0x6523<SEP3>// <CJK>
0x9DBA<SEP>0x5A3C<SEP>0x652B<SEP3>// <CJK>
0x9DBB<SEP>0x5A3D<SEP>0x6534<SEP3>// <CJK>
0x9DBC<SEP>0x5A3E<SEP>0x6535<SEP3>// <CJK>
0x9DBD<SEP>0x5A3F<SEP>0x6537<SEP3>// <CJK>
0x9DBE<SEP>0x5A40<SEP>0x6536<SEP3>// <CJK>
0x9DBF<SEP>0x5A41<SEP>0x6538<SEP3>// <CJK>
0x9DC0<SEP>0x5A42<SEP>0x754B<SEP3>// <CJK>
0x9DC1<SEP>0x5A43<SEP>0x6548<SEP3>// <CJK>
0x9DC2<SEP>0x5A44<SEP>0x6556<SEP3>// <CJK>
0x9DC3<SEP>0x5A45<SEP>0x6555<SEP3>// <CJK>
0x9DC4<SEP>0x5A46<SEP>0x654D<SEP3>// <CJK>
0x9DC5<SEP>0x5A47<SEP>0x6558<SEP3>// <CJK>
0x9DC6<SEP>0x5A48<SEP>0x655E<SEP3>// <CJK>
0x9DC7<SEP>0x5A49<SEP>0x655D<SEP3>// <CJK>
0x9DC8<SEP>0x5A4A<SEP>0x6572<SEP3>// <CJK>
0x9DC9<SEP>0x5A4B<SEP>0x6578<SEP3>// <CJK>
0x9DCA<SEP>0x5A4C<SEP>0x6582<SEP3>// <CJK>
0x9DCB<SEP>0x5A4D<SEP>0x6583<SEP3>// <CJK>
0x9DCC<SEP>0x5A4E<SEP>0x8B8A<SEP3>// <CJK>
0x9DCD<SEP>0x5A4F<SEP>0x659B<SEP3>// <CJK>
0x9DCE<SEP>0x5A50<SEP>0x659F<SEP3>// <CJK>
0x9DCF<SEP>0x5A51<SEP>0x65AB<SEP3>// <CJK>
0x9DD0<SEP>0x5A52<SEP>0x65B7<SEP3>// <CJK>
0x9DD1<SEP>0x5A53<SEP>0x65C3<SEP3>// <CJK>
0x9DD2<SEP>0x5A54<SEP>0x65C6<SEP3>// <CJK>
0x9DD3<SEP>0x5A55<SEP>0x65C1<SEP3>// <CJK>
0x9DD4<SEP>0x5A56<SEP>0x65C4<SEP3>// <CJK>
0x9DD5<SEP>0x5A57<SEP>0x65CC<SEP3>// <CJK>
0x9DD6<SEP>0x5A58<SEP>0x65D2<SEP3>// <CJK>
0x9DD7<SEP>0x5A59<SEP>0x65DB<SEP3>// <CJK>
0x9DD8<SEP>0x5A5A<SEP>0x65D9<SEP3>// <CJK>
0x9DD9<SEP>0x5A5B<SEP>0x65E0<SEP3>// <CJK>
0x9DDA<SEP>0x5A5C<SEP>0x65E1<SEP3>// <CJK>
0x9DDB<SEP>0x5A5D<SEP>0x65F1<SEP3>// <CJK>
0x9DDC<SEP>0x5A5E<SEP>0x6772<SEP3>// <CJK>
0x9DDD<SEP>0x5A5F<SEP>0x660A<SEP3>// <CJK>
0x9DDE<SEP>0x5A60<SEP>0x6603<SEP3>// <CJK>
0x9DDF<SEP>0x5A61<SEP>0x65FB<SEP3>// <CJK>
0x9DE0<SEP>0x5A62<SEP>0x6773<SEP3>// <CJK>
0x9DE1<SEP>0x5A63<SEP>0x6635<SEP3>// <CJK>
0x9DE2<SEP>0x5A64<SEP>0x6636<SEP3>// <CJK>
0x9DE3<SEP>0x5A65<SEP>0x6634<SEP3>// <CJK>
0x9DE4<SEP>0x5A66<SEP>0x661C<SEP3>// <CJK>
0x9DE5<SEP>0x5A67<SEP>0x664F<SEP3>// <CJK>
0x9DE6<SEP>0x5A68<SEP>0x6644<SEP3>// <CJK>
0x9DE7<SEP>0x5A69<SEP>0x6649<SEP3>// <CJK>
0x9DE8<SEP>0x5A6A<SEP>0x6641<SEP3>// <CJK>
0x9DE9<SEP>0x5A6B<SEP>0x665E<SEP3>// <CJK>
0x9DEA<SEP>0x5A6C<SEP>0x665D<SEP3>// <CJK>
0x9DEB<SEP>0x5A6D<SEP>0x6664<SEP3>// <CJK>
0x9DEC<SEP>0x5A6E<SEP>0x6667<SEP3>// <CJK>
0x9DED<SEP>0x5A6F<SEP>0x6668<SEP3>// <CJK>
0x9DEE<SEP>0x5A70<SEP>0x665F<SEP3>// <CJK>
0x9DEF<SEP>0x5A71<SEP>0x6662<SEP3>// <CJK>
0x9DF0<SEP>0x5A72<SEP>0x6670<SEP3>// <CJK>
0x9DF1<SEP>0x5A73<SEP>0x6683<SEP3>// <CJK>
0x9DF2<SEP>0x5A74<SEP>0x6688<SEP3>// <CJK>
0x9DF3<SEP>0x5A75<SEP>0x668E<SEP3>// <CJK>
0x9DF4<SEP>0x5A76<SEP>0x6689<SEP3>// <CJK>
0x9DF5<SEP>0x5A77<SEP>0x6684<SEP3>// <CJK>
0x9DF6<SEP>0x5A78<SEP>0x6698<SEP3>// <CJK>
0x9DF7<SEP>0x5A79<SEP>0x669D<SEP3>// <CJK>
0x9DF8<SEP>0x5A7A<SEP>0x66C1<SEP3>// <CJK>
0x9DF9<SEP>0x5A7B<SEP>0x66B9<SEP3>// <CJK>
0x9DFA<SEP>0x5A7C<SEP>0x66C9<SEP3>// <CJK>
0x9DFB<SEP>0x5A7D<SEP>0x66BE<SEP3>// <CJK>
0x9DFC<SEP>0x5A7E<SEP>0x66BC<SEP3>// <CJK>
0x9E40<SEP>0x5B21<SEP>0x66C4<SEP3>// <CJK>
0x9E41<SEP>0x5B22<SEP>0x66B8<SEP3>// <CJK>
0x9E42<SEP>0x5B23<SEP>0x66D6<SEP3>// <CJK>
0x9E43<SEP>0x5B24<SEP>0x66DA<SEP3>// <CJK>
0x9E44<SEP>0x5B25<SEP>0x66E0<SEP3>// <CJK>
0x9E45<SEP>0x5B26<SEP>0x663F<SEP3>// <CJK>
0x9E46<SEP>0x5B27<SEP>0x66E6<SEP3>// <CJK>
0x9E47<SEP>0x5B28<SEP>0x66E9<SEP3>// <CJK>
0x9E48<SEP>0x5B29<SEP>0x66F0<SEP3>// <CJK>
0x9E49<SEP>0x5B2A<SEP>0x66F5<SEP3>// <CJK>
0x9E4A<SEP>0x5B2B<SEP>0x66F7<SEP3>// <CJK>
0x9E4B<SEP>0x5B2C<SEP>0x670F<SEP3>// <CJK>
0x9E4C<SEP>0x5B2D<SEP>0x6716<SEP3>// <CJK>
0x9E4D<SEP>0x5B2E<SEP>0x671E<SEP3>// <CJK>
0x9E4E<SEP>0x5B2F<SEP>0x6726<SEP3>// <CJK>
0x9E4F<SEP>0x5B30<SEP>0x6727<SEP3>// <CJK>
0x9E50<SEP>0x5B31<SEP>0x9738<SEP3>// <CJK>
0x9E51<SEP>0x5B32<SEP>0x672E<SEP3>// <CJK>
0x9E52<SEP>0x5B33<SEP>0x673F<SEP3>// <CJK>
0x9E53<SEP>0x5B34<SEP>0x6736<SEP3>// <CJK>
0x9E54<SEP>0x5B35<SEP>0x6741<SEP3>// <CJK>
0x9E55<SEP>0x5B36<SEP>0x6738<SEP3>// <CJK>
0x9E56<SEP>0x5B37<SEP>0x6737<SEP3>// <CJK>
0x9E57<SEP>0x5B38<SEP>0x6746<SEP3>// <CJK>
0x9E58<SEP>0x5B39<SEP>0x675E<SEP3>// <CJK>
0x9E59<SEP>0x5B3A<SEP>0x6760<SEP3>// <CJK>
0x9E5A<SEP>0x5B3B<SEP>0x6759<SEP3>// <CJK>
0x9E5B<SEP>0x5B3C<SEP>0x6763<SEP3>// <CJK>
0x9E5C<SEP>0x5B3D<SEP>0x6764<SEP3>// <CJK>
0x9E5D<SEP>0x5B3E<SEP>0x6789<SEP3>// <CJK>
0x9E5E<SEP>0x5B3F<SEP>0x6770<SEP3>// <CJK>
0x9E5F<SEP>0x5B40<SEP>0x67A9<SEP3>// <CJK>
0x9E60<SEP>0x5B41<SEP>0x677C<SEP3>// <CJK>
0x9E61<SEP>0x5B42<SEP>0x676A<SEP3>// <CJK>
0x9E62<SEP>0x5B43<SEP>0x678C<SEP3>// <CJK>
0x9E63<SEP>0x5B44<SEP>0x678B<SEP3>// <CJK>
0x9E64<SEP>0x5B45<SEP>0x67A6<SEP3>// <CJK>
0x9E65<SEP>0x5B46<SEP>0x67A1<SEP3>// <CJK>
0x9E66<SEP>0x5B47<SEP>0x6785<SEP3>// <CJK>
0x9E67<SEP>0x5B48<SEP>0x67B7<SEP3>// <CJK>
0x9E68<SEP>0x5B49<SEP>0x67EF<SEP3>// <CJK>
0x9E69<SEP>0x5B4A<SEP>0x67B4<SEP3>// <CJK>
0x9E6A<SEP>0x5B4B<SEP>0x67EC<SEP3>// <CJK>
0x9E6B<SEP>0x5B4C<SEP>0x67B3<SEP3>// <CJK>
0x9E6C<SEP>0x5B4D<SEP>0x67E9<SEP3>// <CJK>
0x9E6D<SEP>0x5B4E<SEP>0x67B8<SEP3>// <CJK>
0x9E6E<SEP>0x5B4F<SEP>0x67E4<SEP3>// <CJK>
0x9E6F<SEP>0x5B50<SEP>0x67DE<SEP3>// <CJK>
0x9E70<SEP>0x5B51<SEP>0x67DD<SEP3>// <CJK>
0x9E71<SEP>0x5B52<SEP>0x67E2<SEP3>// <CJK>
0x9E72<SEP>0x5B53<SEP>0x67EE<SEP3>// <CJK>
0x9E73<SEP>0x5B54<SEP>0x67B9<SEP3>// <CJK>
0x9E74<SEP>0x5B55<SEP>0x67CE<SEP3>// <CJK>
0x9E75<SEP>0x5B56<SEP>0x67C6<SEP3>// <CJK>
0x9E76<SEP>0x5B57<SEP>0x67E7<SEP3>// <CJK>
0x9E77<SEP>0x5B58<SEP>0x6A9C<SEP3>// <CJK>
0x9E78<SEP>0x5B59<SEP>0x681E<SEP3>// <CJK>
0x9E79<SEP>0x5B5A<SEP>0x6846<SEP3>// <CJK>
0x9E7A<SEP>0x5B5B<SEP>0x6829<SEP3>// <CJK>
0x9E7B<SEP>0x5B5C<SEP>0x6840<SEP3>// <CJK>
0x9E7C<SEP>0x5B5D<SEP>0x684D<SEP3>// <CJK>
0x9E7D<SEP>0x5B5E<SEP>0x6832<SEP3>// <CJK>
0x9E7E<SEP>0x5B5F<SEP>0x684E<SEP3>// <CJK>
0x9E80<SEP>0x5B60<SEP>0x68B3<SEP3>// <CJK>
0x9E81<SEP>0x5B61<SEP>0x682B<SEP3>// <CJK>
0x9E82<SEP>0x5B62<SEP>0x6859<SEP3>// <CJK>
0x9E83<SEP>0x5B63<SEP>0x6863<SEP3>// <CJK>
0x9E84<SEP>0x5B64<SEP>0x6877<SEP3>// <CJK>
0x9E85<SEP>0x5B65<SEP>0x687F<SEP3>// <CJK>
0x9E86<SEP>0x5B66<SEP>0x689F<SEP3>// <CJK>
0x9E87<SEP>0x5B67<SEP>0x688F<SEP3>// <CJK>
0x9E88<SEP>0x5B68<SEP>0x68AD<SEP3>// <CJK>
0x9E89<SEP>0x5B69<SEP>0x6894<SEP3>// <CJK>
0x9E8A<SEP>0x5B6A<SEP>0x689D<SEP3>// <CJK>
0x9E8B<SEP>0x5B6B<SEP>0x689B<SEP3>// <CJK>
0x9E8C<SEP>0x5B6C<SEP>0x6883<SEP3>// <CJK>
0x9E8D<SEP>0x5B6D<SEP>0x6AAE<SEP3>// <CJK>
0x9E8E<SEP>0x5B6E<SEP>0x68B9<SEP3>// <CJK>
0x9E8F<SEP>0x5B6F<SEP>0x6874<SEP3>// <CJK>
0x9E90<SEP>0x5B70<SEP>0x68B5<SEP3>// <CJK>
0x9E91<SEP>0x5B71<SEP>0x68A0<SEP3>// <CJK>
0x9E92<SEP>0x5B72<SEP>0x68BA<SEP3>// <CJK>
0x9E93<SEP>0x5B73<SEP>0x690F<SEP3>// <CJK>
0x9E94<SEP>0x5B74<SEP>0x688D<SEP3>// <CJK>
0x9E95<SEP>0x5B75<SEP>0x687E<SEP3>// <CJK>
0x9E96<SEP>0x5B76<SEP>0x6901<SEP3>// <CJK>
0x9E97<SEP>0x5B77<SEP>0x68CA<SEP3>// <CJK>
0x9E98<SEP>0x5B78<SEP>0x6908<SEP3>// <CJK>
0x9E99<SEP>0x5B79<SEP>0x68D8<SEP3>// <CJK>
0x9E9A<SEP>0x5B7A<SEP>0x6922<SEP3>// <CJK>
0x9E9B<SEP>0x5B7B<SEP>0x6926<SEP3>// <CJK>
0x9E9C<SEP>0x5B7C<SEP>0x68E1<SEP3>// <CJK>
0x9E9D<SEP>0x5B7D<SEP>0x690C<SEP3>// <CJK>
0x9E9E<SEP>0x5B7E<SEP>0x68CD<SEP3>// <CJK>
0x9E9F<SEP>0x5C21<SEP>0x68D4<SEP3>// <CJK>
0x9EA0<SEP>0x5C22<SEP>0x68E7<SEP3>// <CJK>
0x9EA1<SEP>0x5C23<SEP>0x68D5<SEP3>// <CJK>
0x9EA2<SEP>0x5C24<SEP>0x6936<SEP3>// <CJK>
0x9EA3<SEP>0x5C25<SEP>0x6912<SEP3>// <CJK>
0x9EA4<SEP>0x5C26<SEP>0x6904<SEP3>// <CJK>
0x9EA5<SEP>0x5C27<SEP>0x68D7<SEP3>// <CJK>
0x9EA6<SEP>0x5C28<SEP>0x68E3<SEP3>// <CJK>
0x9EA7<SEP>0x5C29<SEP>0x6925<SEP3>// <CJK>
0x9EA8<SEP>0x5C2A<SEP>0x68F9<SEP3>// <CJK>
0x9EA9<SEP>0x5C2B<SEP>0x68E0<SEP3>// <CJK>
0x9EAA<SEP>0x5C2C<SEP>0x68EF<SEP3>// <CJK>
0x9EAB<SEP>0x5C2D<SEP>0x6928<SEP3>// <CJK>
0x9EAC<SEP>0x5C2E<SEP>0x692A<SEP3>// <CJK>
0x9EAD<SEP>0x5C2F<SEP>0x691A<SEP3>// <CJK>
0x9EAE<SEP>0x5C30<SEP>0x6923<SEP3>// <CJK>
0x9EAF<SEP>0x5C31<SEP>0x6921<SEP3>// <CJK>
0x9EB0<SEP>0x5C32<SEP>0x68C6<SEP3>// <CJK>
0x9EB1<SEP>0x5C33<SEP>0x6979<SEP3>// <CJK>
0x9EB2<SEP>0x5C34<SEP>0x6977<SEP3>// <CJK>
0x9EB3<SEP>0x5C35<SEP>0x695C<SEP3>// <CJK>
0x9EB4<SEP>0x5C36<SEP>0x6978<SEP3>// <CJK>
0x9EB5<SEP>0x5C37<SEP>0x696B<SEP3>// <CJK>
0x9EB6<SEP>0x5C38<SEP>0x6954<SEP3>// <CJK>
0x9EB7<SEP>0x5C39<SEP>0x697E<SEP3>// <CJK>
0x9EB8<SEP>0x5C3A<SEP>0x696E<SEP3>// <CJK>
0x9EB9<SEP>0x5C3B<SEP>0x6939<SEP3>// <CJK>
0x9EBA<SEP>0x5C3C<SEP>0x6974<SEP3>// <CJK>
0x9EBB<SEP>0x5C3D<SEP>0x693D<SEP3>// <CJK>
0x9EBC<SEP>0x5C3E<SEP>0x6959<SEP3>// <CJK>
0x9EBD<SEP>0x5C3F<SEP>0x6930<SEP3>// <CJK>
0x9EBE<SEP>0x5C40<SEP>0x6961<SEP3>// <CJK>
0x9EBF<SEP>0x5C41<SEP>0x695E<SEP3>// <CJK>
0x9EC0<SEP>0x5C42<SEP>0x695D<SEP3>// <CJK>
0x9EC1<SEP>0x5C43<SEP>0x6981<SEP3>// <CJK>
0x9EC2<SEP>0x5C44<SEP>0x696A<SEP3>// <CJK>
0x9EC3<SEP>0x5C45<SEP>0x69B2<SEP3>// <CJK>
0x9EC4<SEP>0x5C46<SEP>0x69AE<SEP3>// <CJK>
0x9EC5<SEP>0x5C47<SEP>0x69D0<SEP3>// <CJK>
0x9EC6<SEP>0x5C48<SEP>0x69BF<SEP3>// <CJK>
0x9EC7<SEP>0x5C49<SEP>0x69C1<SEP3>// <CJK>
0x9EC8<SEP>0x5C4A<SEP>0x69D3<SEP3>// <CJK>
0x9EC9<SEP>0x5C4B<SEP>0x69BE<SEP3>// <CJK>
0x9ECA<SEP>0x5C4C<SEP>0x69CE<SEP3>// <CJK>
0x9ECB<SEP>0x5C4D<SEP>0x5BE8<SEP3>// <CJK>
0x9ECC<SEP>0x5C4E<SEP>0x69CA<SEP3>// <CJK>
0x9ECD<SEP>0x5C4F<SEP>0x69DD<SEP3>// <CJK>
0x9ECE<SEP>0x5C50<SEP>0x69BB<SEP3>// <CJK>
0x9ECF<SEP>0x5C51<SEP>0x69C3<SEP3>// <CJK>
0x9ED0<SEP>0x5C52<SEP>0x69A7<SEP3>// <CJK>
0x9ED1<SEP>0x5C53<SEP>0x6A2E<SEP3>// <CJK>
0x9ED2<SEP>0x5C54<SEP>0x6991<SEP3>// <CJK>
0x9ED3<SEP>0x5C55<SEP>0x69A0<SEP3>// <CJK>
0x9ED4<SEP>0x5C56<SEP>0x699C<SEP3>// <CJK>
0x9ED5<SEP>0x5C57<SEP>0x6995<SEP3>// <CJK>
0x9ED6<SEP>0x5C58<SEP>0x69B4<SEP3>// <CJK>
0x9ED7<SEP>0x5C59<SEP>0x69DE<SEP3>// <CJK>
0x9ED8<SEP>0x5C5A<SEP>0x69E8<SEP3>// <CJK>
0x9ED9<SEP>0x5C5B<SEP>0x6A02<SEP3>// <CJK>
0x9EDA<SEP>0x5C5C<SEP>0x6A1B<SEP3>// <CJK>
0x9EDB<SEP>0x5C5D<SEP>0x69FF<SEP3>// <CJK>
0x9EDC<SEP>0x5C5E<SEP>0x6B0A<SEP3>// <CJK>
0x9EDD<SEP>0x5C5F<SEP>0x69F9<SEP3>// <CJK>
0x9EDE<SEP>0x5C60<SEP>0x69F2<SEP3>// <CJK>
0x9EDF<SEP>0x5C61<SEP>0x69E7<SEP3>// <CJK>
0x9EE0<SEP>0x5C62<SEP>0x6A05<SEP3>// <CJK>
0x9EE1<SEP>0x5C63<SEP>0x69B1<SEP3>// <CJK>
0x9EE2<SEP>0x5C64<SEP>0x6A1E<SEP3>// <CJK>
0x9EE3<SEP>0x5C65<SEP>0x69ED<SEP3>// <CJK>
0x9EE4<SEP>0x5C66<SEP>0x6A14<SEP3>// <CJK>
0x9EE5<SEP>0x5C67<SEP>0x69EB<SEP3>// <CJK>
0x9EE6<SEP>0x5C68<SEP>0x6A0A<SEP3>// <CJK>
0x9EE7<SEP>0x5C69<SEP>0x6A12<SEP3>// <CJK>
0x9EE8<SEP>0x5C6A<SEP>0x6AC1<SEP3>// <CJK>
0x9EE9<SEP>0x5C6B<SEP>0x6A23<SEP3>// <CJK>
0x9EEA<SEP>0x5C6C<SEP>0x6A13<SEP3>// <CJK>
0x9EEB<SEP>0x5C6D<SEP>0x6A44<SEP3>// <CJK>
0x9EEC<SEP>0x5C6E<SEP>0x6A0C<SEP3>// <CJK>
0x9EED<SEP>0x5C6F<SEP>0x6A72<SEP3>// <CJK>
0x9EEE<SEP>0x5C70<SEP>0x6A36<SEP3>// <CJK>
0x9EEF<SEP>0x5C71<SEP>0x6A78<SEP3>// <CJK>
0x9EF0<SEP>0x5C72<SEP>0x6A47<SEP3>// <CJK>
0x9EF1<SEP>0x5C73<SEP>0x6A62<SEP3>// <CJK>
0x9EF2<SEP>0x5C74<SEP>0x6A59<SEP3>// <CJK>
0x9EF3<SEP>0x5C75<SEP>0x6A66<SEP3>// <CJK>
0x9EF4<SEP>0x5C76<SEP>0x6A48<SEP3>// <CJK>
0x9EF5<SEP>0x5C77<SEP>0x6A38<SEP3>// <CJK>
0x9EF6<SEP>0x5C78<SEP>0x6A22<SEP3>// <CJK>
0x9EF7<SEP>0x5C79<SEP>0x6A90<SEP3>// <CJK>
0x9EF8<SEP>0x5C7A<SEP>0x6A8D<SEP3>// <CJK>
0x9EF9<SEP>0x5C7B<SEP>0x6AA0<SEP3>// <CJK>
0x9EFA<SEP>0x5C7C<SEP>0x6A84<SEP3>// <CJK>
0x9EFB<SEP>0x5C7D<SEP>0x6AA2<SEP3>// <CJK>
0x9EFC<SEP>0x5C7E<SEP>0x6AA3<SEP3>// <CJK>
0x9F40<SEP>0x5D21<SEP>0x6A97<SEP3>// <CJK>
0x9F41<SEP>0x5D22<SEP>0x8617<SEP3>// <CJK>
0x9F42<SEP>0x5D23<SEP>0x6ABB<SEP3>// <CJK>
0x9F43<SEP>0x5D24<SEP>0x6AC3<SEP3>// <CJK>
0x9F44<SEP>0x5D25<SEP>0x6AC2<SEP3>// <CJK>
0x9F45<SEP>0x5D26<SEP>0x6AB8<SEP3>// <CJK>
0x9F46<SEP>0x5D27<SEP>0x6AB3<SEP3>// <CJK>
0x9F47<SEP>0x5D28<SEP>0x6AAC<SEP3>// <CJK>
0x9F48<SEP>0x5D29<SEP>0x6ADE<SEP3>// <CJK>
0x9F49<SEP>0x5D2A<SEP>0x6AD1<SEP3>// <CJK>
0x9F4A<SEP>0x5D2B<SEP>0x6ADF<SEP3>// <CJK>
0x9F4B<SEP>0x5D2C<SEP>0x6AAA<SEP3>// <CJK>
0x9F4C<SEP>0x5D2D<SEP>0x6ADA<SEP3>// <CJK>
0x9F4D<SEP>0x5D2E<SEP>0x6AEA<SEP3>// <CJK>
0x9F4E<SEP>0x5D2F<SEP>0x6AFB<SEP3>// <CJK>
0x9F4F<SEP>0x5D30<SEP>0x6B05<SEP3>// <CJK>
0x9F50<SEP>0x5D31<SEP>0x8616<SEP3>// <CJK>
0x9F51<SEP>0x5D32<SEP>0x6AFA<SEP3>// <CJK>
0x9F52<SEP>0x5D33<SEP>0x6B12<SEP3>// <CJK>
0x9F53<SEP>0x5D34<SEP>0x6B16<SEP3>// <CJK>
0x9F54<SEP>0x5D35<SEP>0x9B31<SEP3>// <CJK>
0x9F55<SEP>0x5D36<SEP>0x6B1F<SEP3>// <CJK>
0x9F56<SEP>0x5D37<SEP>0x6B38<SEP3>// <CJK>
0x9F57<SEP>0x5D38<SEP>0x6B37<SEP3>// <CJK>
0x9F58<SEP>0x5D39<SEP>0x76DC<SEP3>// <CJK>
0x9F59<SEP>0x5D3A<SEP>0x6B39<SEP3>// <CJK>
0x9F5A<SEP>0x5D3B<SEP>0x98EE<SEP3>// <CJK>
0x9F5B<SEP>0x5D3C<SEP>0x6B47<SEP3>// <CJK>
0x9F5C<SEP>0x5D3D<SEP>0x6B43<SEP3>// <CJK>
0x9F5D<SEP>0x5D3E<SEP>0x6B49<SEP3>// <CJK>
0x9F5E<SEP>0x5D3F<SEP>0x6B50<SEP3>// <CJK>
0x9F5F<SEP>0x5D40<SEP>0x6B59<SEP3>// <CJK>
0x9F60<SEP>0x5D41<SEP>0x6B54<SEP3>// <CJK>
0x9F61<SEP>0x5D42<SEP>0x6B5B<SEP3>// <CJK>
0x9F62<SEP>0x5D43<SEP>0x6B5F<SEP3>// <CJK>
0x9F63<SEP>0x5D44<SEP>0x6B61<SEP3>// <CJK>
0x9F64<SEP>0x5D45<SEP>0x6B78<SEP3>// <CJK>
0x9F65<SEP>0x5D46<SEP>0x6B79<SEP3>// <CJK>
0x9F66<SEP>0x5D47<SEP>0x6B7F<SEP3>// <CJK>
0x9F67<SEP>0x5D48<SEP>0x6B80<SEP3>// <CJK>
0x9F68<SEP>0x5D49<SEP>0x6B84<SEP3>// <CJK>
0x9F69<SEP>0x5D4A<SEP>0x6B83<SEP3>// <CJK>
0x9F6A<SEP>0x5D4B<SEP>0x6B8D<SEP3>// <CJK>
0x9F6B<SEP>0x5D4C<SEP>0x6B98<SEP3>// <CJK>
0x9F6C<SEP>0x5D4D<SEP>0x6B95<SEP3>// <CJK>
0x9F6D<SEP>0x5D4E<SEP>0x6B9E<SEP3>// <CJK>
0x9F6E<SEP>0x5D4F<SEP>0x6BA4<SEP3>// <CJK>
0x9F6F<SEP>0x5D50<SEP>0x6BAA<SEP3>// <CJK>
0x9F70<SEP>0x5D51<SEP>0x6BAB<SEP3>// <CJK>
0x9F71<SEP>0x5D52<SEP>0x6BAF<SEP3>// <CJK>
0x9F72<SEP>0x5D53<SEP>0x6BB2<SEP3>// <CJK>
0x9F73<SEP>0x5D54<SEP>0x6BB1<SEP3>// <CJK>
0x9F74<SEP>0x5D55<SEP>0x6BB3<SEP3>// <CJK>
0x9F75<SEP>0x5D56<SEP>0x6BB7<SEP3>// <CJK>
0x9F76<SEP>0x5D57<SEP>0x6BBC<SEP3>// <CJK>
0x9F77<SEP>0x5D58<SEP>0x6BC6<SEP3>// <CJK>
0x9F78<SEP>0x5D59<SEP>0x6BCB<SEP3>// <CJK>
0x9F79<SEP>0x5D5A<SEP>0x6BD3<SEP3>// <CJK>
0x9F7A<SEP>0x5D5B<SEP>0x6BDF<SEP3>// <CJK>
0x9F7B<SEP>0x5D5C<SEP>0x6BEC<SEP3>// <CJK>
0x9F7C<SEP>0x5D5D<SEP>0x6BEB<SEP3>// <CJK>
0x9F7D<SEP>0x5D5E<SEP>0x6BF3<SEP3>// <CJK>
0x9F7E<SEP>0x5D5F<SEP>0x6BEF<SEP3>// <CJK>
0x9F80<SEP>0x5D60<SEP>0x9EBE<SEP3>// <CJK>
0x9F81<SEP>0x5D61<SEP>0x6C08<SEP3>// <CJK>
0x9F82<SEP>0x5D62<SEP>0x6C13<SEP3>// <CJK>
0x9F83<SEP>0x5D63<SEP>0x6C14<SEP3>// <CJK>
0x9F84<SEP>0x5D64<SEP>0x6C1B<SEP3>// <CJK>
0x9F85<SEP>0x5D65<SEP>0x6C24<SEP3>// <CJK>
0x9F86<SEP>0x5D66<SEP>0x6C23<SEP3>// <CJK>
0x9F87<SEP>0x5D67<SEP>0x6C5E<SEP3>// <CJK>
0x9F88<SEP>0x5D68<SEP>0x6C55<SEP3>// <CJK>
0x9F89<SEP>0x5D69<SEP>0x6C62<SEP3>// <CJK>
0x9F8A<SEP>0x5D6A<SEP>0x6C6A<SEP3>// <CJK>
0x9F8B<SEP>0x5D6B<SEP>0x6C82<SEP3>// <CJK>
0x9F8C<SEP>0x5D6C<SEP>0x6C8D<SEP3>// <CJK>
0x9F8D<SEP>0x5D6D<SEP>0x6C9A<SEP3>// <CJK>
0x9F8E<SEP>0x5D6E<SEP>0x6C81<SEP3>// <CJK>
0x9F8F<SEP>0x5D6F<SEP>0x6C9B<SEP3>// <CJK>
0x9F90<SEP>0x5D70<SEP>0x6C7E<SEP3>// <CJK>
0x9F91<SEP>0x5D71<SEP>0x6C68<SEP3>// <CJK>
0x9F92<SEP>0x5D72<SEP>0x6C73<SEP3>// <CJK>
0x9F93<SEP>0x5D73<SEP>0x6C92<SEP3>// <CJK>
0x9F94<SEP>0x5D74<SEP>0x6C90<SEP3>// <CJK>
0x9F95<SEP>0x5D75<SEP>0x6CC4<SEP3>// <CJK>
0x9F96<SEP>0x5D76<SEP>0x6CF1<SEP3>// <CJK>
0x9F97<SEP>0x5D77<SEP>0x6CD3<SEP3>// <CJK>
0x9F98<SEP>0x5D78<SEP>0x6CBD<SEP3>// <CJK>
0x9F99<SEP>0x5D79<SEP>0x6CD7<SEP3>// <CJK>
0x9F9A<SEP>0x5D7A<SEP>0x6CC5<SEP3>// <CJK>
0x9F9B<SEP>0x5D7B<SEP>0x6CDD<SEP3>// <CJK>
0x9F9C<SEP>0x5D7C<SEP>0x6CAE<SEP3>// <CJK>
0x9F9D<SEP>0x5D7D<SEP>0x6CB1<SEP3>// <CJK>
0x9F9E<SEP>0x5D7E<SEP>0x6CBE<SEP3>// <CJK>
0x9F9F<SEP>0x5E21<SEP>0x6CBA<SEP3>// <CJK>
0x9FA0<SEP>0x5E22<SEP>0x6CDB<SEP3>// <CJK>
0x9FA1<SEP>0x5E23<SEP>0x6CEF<SEP3>// <CJK>
0x9FA2<SEP>0x5E24<SEP>0x6CD9<SEP3>// <CJK>
0x9FA3<SEP>0x5E25<SEP>0x6CEA<SEP3>// <CJK>
0x9FA4<SEP>0x5E26<SEP>0x6D1F<SEP3>// <CJK>
0x9FA5<SEP>0x5E27<SEP>0x884D<SEP3>// <CJK>
0x9FA6<SEP>0x5E28<SEP>0x6D36<SEP3>// <CJK>
0x9FA7<SEP>0x5E29<SEP>0x6D2B<SEP3>// <CJK>
0x9FA8<SEP>0x5E2A<SEP>0x6D3D<SEP3>// <CJK>
0x9FA9<SEP>0x5E2B<SEP>0x6D38<SEP3>// <CJK>
0x9FAA<SEP>0x5E2C<SEP>0x6D19<SEP3>// <CJK>
0x9FAB<SEP>0x5E2D<SEP>0x6D35<SEP3>// <CJK>
0x9FAC<SEP>0x5E2E<SEP>0x6D33<SEP3>// <CJK>
0x9FAD<SEP>0x5E2F<SEP>0x6D12<SEP3>// <CJK>
0x9FAE<SEP>0x5E30<SEP>0x6D0C<SEP3>// <CJK>
0x9FAF<SEP>0x5E31<SEP>0x6D63<SEP3>// <CJK>
0x9FB0<SEP>0x5E32<SEP>0x6D93<SEP3>// <CJK>
0x9FB1<SEP>0x5E33<SEP>0x6D64<SEP3>// <CJK>
0x9FB2<SEP>0x5E34<SEP>0x6D5A<SEP3>// <CJK>
0x9FB3<SEP>0x5E35<SEP>0x6D79<SEP3>// <CJK>
0x9FB4<SEP>0x5E36<SEP>0x6D59<SEP3>// <CJK>
0x9FB5<SEP>0x5E37<SEP>0x6D8E<SEP3>// <CJK>
0x9FB6<SEP>0x5E38<SEP>0x6D95<SEP3>// <CJK>
0x9FB7<SEP>0x5E39<SEP>0x6FE4<SEP3>// <CJK>
0x9FB8<SEP>0x5E3A<SEP>0x6D85<SEP3>// <CJK>
0x9FB9<SEP>0x5E3B<SEP>0x6DF9<SEP3>// <CJK>
0x9FBA<SEP>0x5E3C<SEP>0x6E15<SEP3>// <CJK>
0x9FBB<SEP>0x5E3D<SEP>0x6E0A<SEP3>// <CJK>
0x9FBC<SEP>0x5E3E<SEP>0x6DB5<SEP3>// <CJK>
0x9FBD<SEP>0x5E3F<SEP>0x6DC7<SEP3>// <CJK>
0x9FBE<SEP>0x5E40<SEP>0x6DE6<SEP3>// <CJK>
0x9FBF<SEP>0x5E41<SEP>0x6DB8<SEP3>// <CJK>
0x9FC0<SEP>0x5E42<SEP>0x6DC6<SEP3>// <CJK>
0x9FC1<SEP>0x5E43<SEP>0x6DEC<SEP3>// <CJK>
0x9FC2<SEP>0x5E44<SEP>0x6DDE<SEP3>// <CJK>
0x9FC3<SEP>0x5E45<SEP>0x6DCC<SEP3>// <CJK>
0x9FC4<SEP>0x5E46<SEP>0x6DE8<SEP3>// <CJK>
0x9FC5<SEP>0x5E47<SEP>0x6DD2<SEP3>// <CJK>
0x9FC6<SEP>0x5E48<SEP>0x6DC5<SEP3>// <CJK>
0x9FC7<SEP>0x5E49<SEP>0x6DFA<SEP3>// <CJK>
0x9FC8<SEP>0x5E4A<SEP>0x6DD9<SEP3>// <CJK>
0x9FC9<SEP>0x5E4B<SEP>0x6DE4<SEP3>// <CJK>
0x9FCA<SEP>0x5E4C<SEP>0x6DD5<SEP3>// <CJK>
0x9FCB<SEP>0x5E4D<SEP>0x6DEA<SEP3>// <CJK>
0x9FCC<SEP>0x5E4E<SEP>0x6DEE<SEP3>// <CJK>
0x9FCD<SEP>0x5E4F<SEP>0x6E2D<SEP3>// <CJK>
0x9FCE<SEP>0x5E50<SEP>0x6E6E<SEP3>// <CJK>
0x9FCF<SEP>0x5E51<SEP>0x6E2E<SEP3>// <CJK>
0x9FD0<SEP>0x5E52<SEP>0x6E19<SEP3>// <CJK>
0x9FD1<SEP>0x5E53<SEP>0x6E72<SEP3>// <CJK>
0x9FD2<SEP>0x5E54<SEP>0x6E5F<SEP3>// <CJK>
0x9FD3<SEP>0x5E55<SEP>0x6E3E<SEP3>// <CJK>
0x9FD4<SEP>0x5E56<SEP>0x6E23<SEP3>// <CJK>
0x9FD5<SEP>0x5E57<SEP>0x6E6B<SEP3>// <CJK>
0x9FD6<SEP>0x5E58<SEP>0x6E2B<SEP3>// <CJK>
0x9FD7<SEP>0x5E59<SEP>0x6E76<SEP3>// <CJK>
0x9FD8<SEP>0x5E5A<SEP>0x6E4D<SEP3>// <CJK>
0x9FD9<SEP>0x5E5B<SEP>0x6E1F<SEP3>// <CJK>
0x9FDA<SEP>0x5E5C<SEP>0x6E43<SEP3>// <CJK>
0x9FDB<SEP>0x5E5D<SEP>0x6E3A<SEP3>// <CJK>
0x9FDC<SEP>0x5E5E<SEP>0x6E4E<SEP3>// <CJK>
0x9FDD<SEP>0x5E5F<SEP>0x6E24<SEP3>// <CJK>
0x9FDE<SEP>0x5E60<SEP>0x6EFF<SEP3>// <CJK>
0x9FDF<SEP>0x5E61<SEP>0x6E1D<SEP3>// <CJK>
0x9FE0<SEP>0x5E62<SEP>0x6E38<SEP3>// <CJK>
0x9FE1<SEP>0x5E63<SEP>0x6E82<SEP3>// <CJK>
0x9FE2<SEP>0x5E64<SEP>0x6EAA<SEP3>// <CJK>
0x9FE3<SEP>0x5E65<SEP>0x6E98<SEP3>// <CJK>
0x9FE4<SEP>0x5E66<SEP>0x6EC9<SEP3>// <CJK>
0x9FE5<SEP>0x5E67<SEP>0x6EB7<SEP3>// <CJK>
0x9FE6<SEP>0x5E68<SEP>0x6ED3<SEP3>// <CJK>
0x9FE7<SEP>0x5E69<SEP>0x6EBD<SEP3>// <CJK>
0x9FE8<SEP>0x5E6A<SEP>0x6EAF<SEP3>// <CJK>
0x9FE9<SEP>0x5E6B<SEP>0x6EC4<SEP3>// <CJK>
0x9FEA<SEP>0x5E6C<SEP>0x6EB2<SEP3>// <CJK>
0x9FEB<SEP>0x5E6D<SEP>0x6ED4<SEP3>// <CJK>
0x9FEC<SEP>0x5E6E<SEP>0x6ED5<SEP3>// <CJK>
0x9FED<SEP>0x5E6F<SEP>0x6E8F<SEP3>// <CJK>
0x9FEE<SEP>0x5E70<SEP>0x6EA5<SEP3>// <CJK>
0x9FEF<SEP>0x5E71<SEP>0x6EC2<SEP3>// <CJK>
0x9FF0<SEP>0x5E72<SEP>0x6E9F<SEP3>// <CJK>
0x9FF1<SEP>0x5E73<SEP>0x6F41<SEP3>// <CJK>
0x9FF2<SEP>0x5E74<SEP>0x6F11<SEP3>// <CJK>
0x9FF3<SEP>0x5E75<SEP>0x704C<SEP3>// <CJK>
0x9FF4<SEP>0x5E76<SEP>0x6EEC<SEP3>// <CJK>
0x9FF5<SEP>0x5E77<SEP>0x6EF8<SEP3>// <CJK>
0x9FF6<SEP>0x5E78<SEP>0x6EFE<SEP3>// <CJK>
0x9FF7<SEP>0x5E79<SEP>0x6F3F<SEP3>// <CJK>
0x9FF8<SEP>0x5E7A<SEP>0x6EF2<SEP3>// <CJK>
0x9FF9<SEP>0x5E7B<SEP>0x6F31<SEP3>// <CJK>
0x9FFA<SEP>0x5E7C<SEP>0x6EEF<SEP3>// <CJK>
0x9FFB<SEP>0x5E7D<SEP>0x6F32<SEP3>// <CJK>
0x9FFC<SEP>0x5E7E<SEP>0x6ECC<SEP3>// <CJK>

0xE040<SEP>0x5F21<SEP>0x6F3E<SEP3>// <CJK>
0xE041<SEP>0x5F22<SEP>0x6F13<SEP3>// <CJK>
0xE042<SEP>0x5F23<SEP>0x6EF7<SEP3>// <CJK>
0xE043<SEP>0x5F24<SEP>0x6F86<SEP3>// <CJK>
0xE044<SEP>0x5F25<SEP>0x6F7A<SEP3>// <CJK>
0xE045<SEP>0x5F26<SEP>0x6F78<SEP3>// <CJK>
0xE046<SEP>0x5F27<SEP>0x6F81<SEP3>// <CJK>
0xE047<SEP>0x5F28<SEP>0x6F80<SEP3>// <CJK>
0xE048<SEP>0x5F29<SEP>0x6F6F<SEP3>// <CJK>
0xE049<SEP>0x5F2A<SEP>0x6F5B<SEP3>// <CJK>
0xE04A<SEP>0x5F2B<SEP>0x6FF3<SEP3>// <CJK>
0xE04B<SEP>0x5F2C<SEP>0x6F6D<SEP3>// <CJK>
0xE04C<SEP>0x5F2D<SEP>0x6F82<SEP3>// <CJK>
0xE04D<SEP>0x5F2E<SEP>0x6F7C<SEP3>// <CJK>
0xE04E<SEP>0x5F2F<SEP>0x6F58<SEP3>// <CJK>
0xE04F<SEP>0x5F30<SEP>0x6F8E<SEP3>// <CJK>
0xE050<SEP>0x5F31<SEP>0x6F91<SEP3>// <CJK>
0xE051<SEP>0x5F32<SEP>0x6FC2<SEP3>// <CJK>
0xE052<SEP>0x5F33<SEP>0x6F66<SEP3>// <CJK>
0xE053<SEP>0x5F34<SEP>0x6FB3<SEP3>// <CJK>
0xE054<SEP>0x5F35<SEP>0x6FA3<SEP3>// <CJK>
0xE055<SEP>0x5F36<SEP>0x6FA1<SEP3>// <CJK>
0xE056<SEP>0x5F37<SEP>0x6FA4<SEP3>// <CJK>
0xE057<SEP>0x5F38<SEP>0x6FB9<SEP3>// <CJK>
0xE058<SEP>0x5F39<SEP>0x6FC6<SEP3>// <CJK>
0xE059<SEP>0x5F3A<SEP>0x6FAA<SEP3>// <CJK>
0xE05A<SEP>0x5F3B<SEP>0x6FDF<SEP3>// <CJK>
0xE05B<SEP>0x5F3C<SEP>0x6FD5<SEP3>// <CJK>
0xE05C<SEP>0x5F3D<SEP>0x6FEC<SEP3>// <CJK>
0xE05D<SEP>0x5F3E<SEP>0x6FD4<SEP3>// <CJK>
0xE05E<SEP>0x5F3F<SEP>0x6FD8<SEP3>// <CJK>
0xE05F<SEP>0x5F40<SEP>0x6FF1<SEP3>// <CJK>
0xE060<SEP>0x5F41<SEP>0x6FEE<SEP3>// <CJK>
0xE061<SEP>0x5F42<SEP>0x6FDB<SEP3>// <CJK>
0xE062<SEP>0x5F43<SEP>0x7009<SEP3>// <CJK>
0xE063<SEP>0x5F44<SEP>0x700B<SEP3>// <CJK>
0xE064<SEP>0x5F45<SEP>0x6FFA<SEP3>// <CJK>
0xE065<SEP>0x5F46<SEP>0x7011<SEP3>// <CJK>
0xE066<SEP>0x5F47<SEP>0x7001<SEP3>// <CJK>
0xE067<SEP>0x5F48<SEP>0x700F<SEP3>// <CJK>
0xE068<SEP>0x5F49<SEP>0x6FFE<SEP3>// <CJK>
0xE069<SEP>0x5F4A<SEP>0x701B<SEP3>// <CJK>
0xE06A<SEP>0x5F4B<SEP>0x701A<SEP3>// <CJK>
0xE06B<SEP>0x5F4C<SEP>0x6F74<SEP3>// <CJK>
0xE06C<SEP>0x5F4D<SEP>0x701D<SEP3>// <CJK>
0xE06D<SEP>0x5F4E<SEP>0x7018<SEP3>// <CJK>
0xE06E<SEP>0x5F4F<SEP>0x701F<SEP3>// <CJK>
0xE06F<SEP>0x5F50<SEP>0x7030<SEP3>// <CJK>
0xE070<SEP>0x5F51<SEP>0x703E<SEP3>// <CJK>
0xE071<SEP>0x5F52<SEP>0x7032<SEP3>// <CJK>
0xE072<SEP>0x5F53<SEP>0x7051<SEP3>// <CJK>
0xE073<SEP>0x5F54<SEP>0x7063<SEP3>// <CJK>
0xE074<SEP>0x5F55<SEP>0x7099<SEP3>// <CJK>
0xE075<SEP>0x5F56<SEP>0x7092<SEP3>// <CJK>
0xE076<SEP>0x5F57<SEP>0x70AF<SEP3>// <CJK>
0xE077<SEP>0x5F58<SEP>0x70F1<SEP3>// <CJK>
0xE078<SEP>0x5F59<SEP>0x70AC<SEP3>// <CJK>
0xE079<SEP>0x5F5A<SEP>0x70B8<SEP3>// <CJK>
0xE07A<SEP>0x5F5B<SEP>0x70B3<SEP3>// <CJK>
0xE07B<SEP>0x5F5C<SEP>0x70AE<SEP3>// <CJK>
0xE07C<SEP>0x5F5D<SEP>0x70DF<SEP3>// <CJK>
0xE07D<SEP>0x5F5E<SEP>0x70CB<SEP3>// <CJK>
0xE07E<SEP>0x5F5F<SEP>0x70DD<SEP3>// <CJK>
0xE080<SEP>0x5F60<SEP>0x70D9<SEP3>// <CJK>
0xE081<SEP>0x5F61<SEP>0x7109<SEP3>// <CJK>
0xE082<SEP>0x5F62<SEP>0x70FD<SEP3>// <CJK>
0xE083<SEP>0x5F63<SEP>0x711C<SEP3>// <CJK>
0xE084<SEP>0x5F64<SEP>0x7119<SEP3>// <CJK>
0xE085<SEP>0x5F65<SEP>0x7165<SEP3>// <CJK>
0xE086<SEP>0x5F66<SEP>0x7155<SEP3>// <CJK>
0xE087<SEP>0x5F67<SEP>0x7188<SEP3>// <CJK>
0xE088<SEP>0x5F68<SEP>0x7166<SEP3>// <CJK>
0xE089<SEP>0x5F69<SEP>0x7162<SEP3>// <CJK>
0xE08A<SEP>0x5F6A<SEP>0x714C<SEP3>// <CJK>
0xE08B<SEP>0x5F6B<SEP>0x7156<SEP3>// <CJK>
0xE08C<SEP>0x5F6C<SEP>0x716C<SEP3>// <CJK>
0xE08D<SEP>0x5F6D<SEP>0x718F<SEP3>// <CJK>
0xE08E<SEP>0x5F6E<SEP>0x71FB<SEP3>// <CJK>
0xE08F<SEP>0x5F6F<SEP>0x7184<SEP3>// <CJK>
0xE090<SEP>0x5F70<SEP>0x7195<SEP3>// <CJK>
0xE091<SEP>0x5F71<SEP>0x71A8<SEP3>// <CJK>
0xE092<SEP>0x5F72<SEP>0x71AC<SEP3>// <CJK>
0xE093<SEP>0x5F73<SEP>0x71D7<SEP3>// <CJK>
0xE094<SEP>0x5F74<SEP>0x71B9<SEP3>// <CJK>
0xE095<SEP>0x5F75<SEP>0x71BE<SEP3>// <CJK>
0xE096<SEP>0x5F76<SEP>0x71D2<SEP3>// <CJK>
0xE097<SEP>0x5F77<SEP>0x71C9<SEP3>// <CJK>
0xE098<SEP>0x5F78<SEP>0x71D4<SEP3>// <CJK>
0xE099<SEP>0x5F79<SEP>0x71CE<SEP3>// <CJK>
0xE09A<SEP>0x5F7A<SEP>0x71E0<SEP3>// <CJK>
0xE09B<SEP>0x5F7B<SEP>0x71EC<SEP3>// <CJK>
0xE09C<SEP>0x5F7C<SEP>0x71E7<SEP3>// <CJK>
0xE09D<SEP>0x5F7D<SEP>0x71F5<SEP3>// <CJK>
0xE09E<SEP>0x5F7E<SEP>0x71FC<SEP3>// <CJK>
0xE09F<SEP>0x6021<SEP>0x71F9<SEP3>// <CJK>
0xE0A0<SEP>0x6022<SEP>0x71FF<SEP3>// <CJK>
0xE0A1<SEP>0x6023<SEP>0x720D<SEP3>// <CJK>
0xE0A2<SEP>0x6024<SEP>0x7210<SEP3>// <CJK>
0xE0A3<SEP>0x6025<SEP>0x721B<SEP3>// <CJK>
0xE0A4<SEP>0x6026<SEP>0x7228<SEP3>// <CJK>
0xE0A5<SEP>0x6027<SEP>0x722D<SEP3>// <CJK>
0xE0A6<SEP>0x6028<SEP>0x722C<SEP3>// <CJK>
0xE0A7<SEP>0x6029<SEP>0x7230<SEP3>// <CJK>
0xE0A8<SEP>0x602A<SEP>0x7232<SEP3>// <CJK>
0xE0A9<SEP>0x602B<SEP>0x723B<SEP3>// <CJK>
0xE0AA<SEP>0x602C<SEP>0x723C<SEP3>// <CJK>
0xE0AB<SEP>0x602D<SEP>0x723F<SEP3>// <CJK>
0xE0AC<SEP>0x602E<SEP>0x7240<SEP3>// <CJK>
0xE0AD<SEP>0x602F<SEP>0x7246<SEP3>// <CJK>
0xE0AE<SEP>0x6030<SEP>0x724B<SEP3>// <CJK>
0xE0AF<SEP>0x6031<SEP>0x7258<SEP3>// <CJK>
0xE0B0<SEP>0x6032<SEP>0x7274<SEP3>// <CJK>
0xE0B1<SEP>0x6033<SEP>0x727E<SEP3>// <CJK>
0xE0B2<SEP>0x6034<SEP>0x7282<SEP3>// <CJK>
0xE0B3<SEP>0x6035<SEP>0x7281<SEP3>// <CJK>
0xE0B4<SEP>0x6036<SEP>0x7287<SEP3>// <CJK>
0xE0B5<SEP>0x6037<SEP>0x7292<SEP3>// <CJK>
0xE0B6<SEP>0x6038<SEP>0x7296<SEP3>// <CJK>
0xE0B7<SEP>0x6039<SEP>0x72A2<SEP3>// <CJK>
0xE0B8<SEP>0x603A<SEP>0x72A7<SEP3>// <CJK>
0xE0B9<SEP>0x603B<SEP>0x72B9<SEP3>// <CJK>
0xE0BA<SEP>0x603C<SEP>0x72B2<SEP3>// <CJK>
0xE0BB<SEP>0x603D<SEP>0x72C3<SEP3>// <CJK>
0xE0BC<SEP>0x603E<SEP>0x72C6<SEP3>// <CJK>
0xE0BD<SEP>0x603F<SEP>0x72C4<SEP3>// <CJK>
0xE0BE<SEP>0x6040<SEP>0x72CE<SEP3>// <CJK>
0xE0BF<SEP>0x6041<SEP>0x72D2<SEP3>// <CJK>
0xE0C0<SEP>0x6042<SEP>0x72E2<SEP3>// <CJK>
0xE0C1<SEP>0x6043<SEP>0x72E0<SEP3>// <CJK>
0xE0C2<SEP>0x6044<SEP>0x72E1<SEP3>// <CJK>
0xE0C3<SEP>0x6045<SEP>0x72F9<SEP3>// <CJK>
0xE0C4<SEP>0x6046<SEP>0x72F7<SEP3>// <CJK>
0xE0C5<SEP>0x6047<SEP>0x500F<SEP3>// <CJK>
0xE0C6<SEP>0x6048<SEP>0x7317<SEP3>// <CJK>
0xE0C7<SEP>0x6049<SEP>0x730A<SEP3>// <CJK>
0xE0C8<SEP>0x604A<SEP>0x731C<SEP3>// <CJK>
0xE0C9<SEP>0x604B<SEP>0x7316<SEP3>// <CJK>
0xE0CA<SEP>0x604C<SEP>0x731D<SEP3>// <CJK>
0xE0CB<SEP>0x604D<SEP>0x7334<SEP3>// <CJK>
0xE0CC<SEP>0x604E<SEP>0x732F<SEP3>// <CJK>
0xE0CD<SEP>0x604F<SEP>0x7329<SEP3>// <CJK>
0xE0CE<SEP>0x6050<SEP>0x7325<SEP3>// <CJK>
0xE0CF<SEP>0x6051<SEP>0x733E<SEP3>// <CJK>
0xE0D0<SEP>0x6052<SEP>0x734E<SEP3>// <CJK>
0xE0D1<SEP>0x6053<SEP>0x734F<SEP3>// <CJK>
0xE0D2<SEP>0x6054<SEP>0x9ED8<SEP3>// <CJK>
0xE0D3<SEP>0x6055<SEP>0x7357<SEP3>// <CJK>
0xE0D4<SEP>0x6056<SEP>0x736A<SEP3>// <CJK>
0xE0D5<SEP>0x6057<SEP>0x7368<SEP3>// <CJK>
0xE0D6<SEP>0x6058<SEP>0x7370<SEP3>// <CJK>
0xE0D7<SEP>0x6059<SEP>0x7378<SEP3>// <CJK>
0xE0D8<SEP>0x605A<SEP>0x7375<SEP3>// <CJK>
0xE0D9<SEP>0x605B<SEP>0x737B<SEP3>// <CJK>
0xE0DA<SEP>0x605C<SEP>0x737A<SEP3>// <CJK>
0xE0DB<SEP>0x605D<SEP>0x73C8<SEP3>// <CJK>
0xE0DC<SEP>0x605E<SEP>0x73B3<SEP3>// <CJK>
0xE0DD<SEP>0x605F<SEP>0x73CE<SEP3>// <CJK>
0xE0DE<SEP>0x6060<SEP>0x73BB<SEP3>// <CJK>
0xE0DF<SEP>0x6061<SEP>0x73C0<SEP3>// <CJK>
0xE0E0<SEP>0x6062<SEP>0x73E5<SEP3>// <CJK>
0xE0E1<SEP>0x6063<SEP>0x73EE<SEP3>// <CJK>
0xE0E2<SEP>0x6064<SEP>0x73DE<SEP3>// <CJK>
0xE0E3<SEP>0x6065<SEP>0x74A2<SEP3>// <CJK>
0xE0E4<SEP>0x6066<SEP>0x7405<SEP3>// <CJK>
0xE0E5<SEP>0x6067<SEP>0x746F<SEP3>// <CJK>
0xE0E6<SEP>0x6068<SEP>0x7425<SEP3>// <CJK>
0xE0E7<SEP>0x6069<SEP>0x73F8<SEP3>// <CJK>
0xE0E8<SEP>0x606A<SEP>0x7432<SEP3>// <CJK>
0xE0E9<SEP>0x606B<SEP>0x743A<SEP3>// <CJK>
0xE0EA<SEP>0x606C<SEP>0x7455<SEP3>// <CJK>
0xE0EB<SEP>0x606D<SEP>0x743F<SEP3>// <CJK>
0xE0EC<SEP>0x606E<SEP>0x745F<SEP3>// <CJK>
0xE0ED<SEP>0x606F<SEP>0x7459<SEP3>// <CJK>
0xE0EE<SEP>0x6070<SEP>0x7441<SEP3>// <CJK>
0xE0EF<SEP>0x6071<SEP>0x745C<SEP3>// <CJK>
0xE0F0<SEP>0x6072<SEP>0x7469<SEP3>// <CJK>
0xE0F1<SEP>0x6073<SEP>0x7470<SEP3>// <CJK>
0xE0F2<SEP>0x6074<SEP>0x7463<SEP3>// <CJK>
0xE0F3<SEP>0x6075<SEP>0x746A<SEP3>// <CJK>
0xE0F4<SEP>0x6076<SEP>0x7476<SEP3>// <CJK>
0xE0F5<SEP>0x6077<SEP>0x747E<SEP3>// <CJK>
0xE0F6<SEP>0x6078<SEP>0x748B<SEP3>// <CJK>
0xE0F7<SEP>0x6079<SEP>0x749E<SEP3>// <CJK>
0xE0F8<SEP>0x607A<SEP>0x74A7<SEP3>// <CJK>
0xE0F9<SEP>0x607B<SEP>0x74CA<SEP3>// <CJK>
0xE0FA<SEP>0x607C<SEP>0x74CF<SEP3>// <CJK>
0xE0FB<SEP>0x607D<SEP>0x74D4<SEP3>// <CJK>
0xE0FC<SEP>0x607E<SEP>0x73F1<SEP3>// <CJK>
0xE140<SEP>0x6121<SEP>0x74E0<SEP3>// <CJK>
0xE141<SEP>0x6122<SEP>0x74E3<SEP3>// <CJK>
0xE142<SEP>0x6123<SEP>0x74E7<SEP3>// <CJK>
0xE143<SEP>0x6124<SEP>0x74E9<SEP3>// <CJK>
0xE144<SEP>0x6125<SEP>0x74EE<SEP3>// <CJK>
0xE145<SEP>0x6126<SEP>0x74F2<SEP3>// <CJK>
0xE146<SEP>0x6127<SEP>0x74F0<SEP3>// <CJK>
0xE147<SEP>0x6128<SEP>0x74F1<SEP3>// <CJK>
0xE148<SEP>0x6129<SEP>0x74F8<SEP3>// <CJK>
0xE149<SEP>0x612A<SEP>0x74F7<SEP3>// <CJK>
0xE14A<SEP>0x612B<SEP>0x7504<SEP3>// <CJK>
0xE14B<SEP>0x612C<SEP>0x7503<SEP3>// <CJK>
0xE14C<SEP>0x612D<SEP>0x7505<SEP3>// <CJK>
0xE14D<SEP>0x612E<SEP>0x750C<SEP3>// <CJK>
0xE14E<SEP>0x612F<SEP>0x750E<SEP3>// <CJK>
0xE14F<SEP>0x6130<SEP>0x750D<SEP3>// <CJK>
0xE150<SEP>0x6131<SEP>0x7515<SEP3>// <CJK>
0xE151<SEP>0x6132<SEP>0x7513<SEP3>// <CJK>
0xE152<SEP>0x6133<SEP>0x751E<SEP3>// <CJK>
0xE153<SEP>0x6134<SEP>0x7526<SEP3>// <CJK>
0xE154<SEP>0x6135<SEP>0x752C<SEP3>// <CJK>
0xE155<SEP>0x6136<SEP>0x753C<SEP3>// <CJK>
0xE156<SEP>0x6137<SEP>0x7544<SEP3>// <CJK>
0xE157<SEP>0x6138<SEP>0x754D<SEP3>// <CJK>
0xE158<SEP>0x6139<SEP>0x754A<SEP3>// <CJK>
0xE159<SEP>0x613A<SEP>0x7549<SEP3>// <CJK>
0xE15A<SEP>0x613B<SEP>0x755B<SEP3>// <CJK>
0xE15B<SEP>0x613C<SEP>0x7546<SEP3>// <CJK>
0xE15C<SEP>0x613D<SEP>0x755A<SEP3>// <CJK>
0xE15D<SEP>0x613E<SEP>0x7569<SEP3>// <CJK>
0xE15E<SEP>0x613F<SEP>0x7564<SEP3>// <CJK>
0xE15F<SEP>0x6140<SEP>0x7567<SEP3>// <CJK>
0xE160<SEP>0x6141<SEP>0x756B<SEP3>// <CJK>
0xE161<SEP>0x6142<SEP>0x756D<SEP3>// <CJK>
0xE162<SEP>0x6143<SEP>0x7578<SEP3>// <CJK>
0xE163<SEP>0x6144<SEP>0x7576<SEP3>// <CJK>
0xE164<SEP>0x6145<SEP>0x7586<SEP3>// <CJK>
0xE165<SEP>0x6146<SEP>0x7587<SEP3>// <CJK>
0xE166<SEP>0x6147<SEP>0x7574<SEP3>// <CJK>
0xE167<SEP>0x6148<SEP>0x758A<SEP3>// <CJK>
0xE168<SEP>0x6149<SEP>0x7589<SEP3>// <CJK>
0xE169<SEP>0x614A<SEP>0x7582<SEP3>// <CJK>
0xE16A<SEP>0x614B<SEP>0x7594<SEP3>// <CJK>
0xE16B<SEP>0x614C<SEP>0x759A<SEP3>// <CJK>
0xE16C<SEP>0x614D<SEP>0x759D<SEP3>// <CJK>
0xE16D<SEP>0x614E<SEP>0x75A5<SEP3>// <CJK>
0xE16E<SEP>0x614F<SEP>0x75A3<SEP3>// <CJK>
0xE16F<SEP>0x6150<SEP>0x75C2<SEP3>// <CJK>
0xE170<SEP>0x6151<SEP>0x75B3<SEP3>// <CJK>
0xE171<SEP>0x6152<SEP>0x75C3<SEP3>// <CJK>
0xE172<SEP>0x6153<SEP>0x75B5<SEP3>// <CJK>
0xE173<SEP>0x6154<SEP>0x75BD<SEP3>// <CJK>
0xE174<SEP>0x6155<SEP>0x75B8<SEP3>// <CJK>
0xE175<SEP>0x6156<SEP>0x75BC<SEP3>// <CJK>
0xE176<SEP>0x6157<SEP>0x75B1<SEP3>// <CJK>
0xE177<SEP>0x6158<SEP>0x75CD<SEP3>// <CJK>
0xE178<SEP>0x6159<SEP>0x75CA<SEP3>// <CJK>
0xE179<SEP>0x615A<SEP>0x75D2<SEP3>// <CJK>
0xE17A<SEP>0x615B<SEP>0x75D9<SEP3>// <CJK>
0xE17B<SEP>0x615C<SEP>0x75E3<SEP3>// <CJK>
0xE17C<SEP>0x615D<SEP>0x75DE<SEP3>// <CJK>
0xE17D<SEP>0x615E<SEP>0x75FE<SEP3>// <CJK>
0xE17E<SEP>0x615F<SEP>0x75FF<SEP3>// <CJK>
0xE180<SEP>0x6160<SEP>0x75FC<SEP3>// <CJK>
0xE181<SEP>0x6161<SEP>0x7601<SEP3>// <CJK>
0xE182<SEP>0x6162<SEP>0x75F0<SEP3>// <CJK>
0xE183<SEP>0x6163<SEP>0x75FA<SEP3>// <CJK>
0xE184<SEP>0x6164<SEP>0x75F2<SEP3>// <CJK>
0xE185<SEP>0x6165<SEP>0x75F3<SEP3>// <CJK>
0xE186<SEP>0x6166<SEP>0x760B<SEP3>// <CJK>
0xE187<SEP>0x6167<SEP>0x760D<SEP3>// <CJK>
0xE188<SEP>0x6168<SEP>0x7609<SEP3>// <CJK>
0xE189<SEP>0x6169<SEP>0x761F<SEP3>// <CJK>
0xE18A<SEP>0x616A<SEP>0x7627<SEP3>// <CJK>
0xE18B<SEP>0x616B<SEP>0x7620<SEP3>// <CJK>
0xE18C<SEP>0x616C<SEP>0x7621<SEP3>// <CJK>
0xE18D<SEP>0x616D<SEP>0x7622<SEP3>// <CJK>
0xE18E<SEP>0x616E<SEP>0x7624<SEP3>// <CJK>
0xE18F<SEP>0x616F<SEP>0x7634<SEP3>// <CJK>
0xE190<SEP>0x6170<SEP>0x7630<SEP3>// <CJK>
0xE191<SEP>0x6171<SEP>0x763B<SEP3>// <CJK>
0xE192<SEP>0x6172<SEP>0x7647<SEP3>// <CJK>
0xE193<SEP>0x6173<SEP>0x7648<SEP3>// <CJK>
0xE194<SEP>0x6174<SEP>0x7646<SEP3>// <CJK>
0xE195<SEP>0x6175<SEP>0x765C<SEP3>// <CJK>
0xE196<SEP>0x6176<SEP>0x7658<SEP3>// <CJK>
0xE197<SEP>0x6177<SEP>0x7661<SEP3>// <CJK>
0xE198<SEP>0x6178<SEP>0x7662<SEP3>// <CJK>
0xE199<SEP>0x6179<SEP>0x7668<SEP3>// <CJK>
0xE19A<SEP>0x617A<SEP>0x7669<SEP3>// <CJK>
0xE19B<SEP>0x617B<SEP>0x766A<SEP3>// <CJK>
0xE19C<SEP>0x617C<SEP>0x7667<SEP3>// <CJK>
0xE19D<SEP>0x617D<SEP>0x766C<SEP3>// <CJK>
0xE19E<SEP>0x617E<SEP>0x7670<SEP3>// <CJK>
0xE19F<SEP>0x6221<SEP>0x7672<SEP3>// <CJK>
0xE1A0<SEP>0x6222<SEP>0x7676<SEP3>// <CJK>
0xE1A1<SEP>0x6223<SEP>0x7678<SEP3>// <CJK>
0xE1A2<SEP>0x6224<SEP>0x767C<SEP3>// <CJK>
0xE1A3<SEP>0x6225<SEP>0x7680<SEP3>// <CJK>
0xE1A4<SEP>0x6226<SEP>0x7683<SEP3>// <CJK>
0xE1A5<SEP>0x6227<SEP>0x7688<SEP3>// <CJK>
0xE1A6<SEP>0x6228<SEP>0x768B<SEP3>// <CJK>
0xE1A7<SEP>0x6229<SEP>0x768E<SEP3>// <CJK>
0xE1A8<SEP>0x622A<SEP>0x7696<SEP3>// <CJK>
0xE1A9<SEP>0x622B<SEP>0x7693<SEP3>// <CJK>
0xE1AA<SEP>0x622C<SEP>0x7699<SEP3>// <CJK>
0xE1AB<SEP>0x622D<SEP>0x769A<SEP3>// <CJK>
0xE1AC<SEP>0x622E<SEP>0x76B0<SEP3>// <CJK>
0xE1AD<SEP>0x622F<SEP>0x76B4<SEP3>// <CJK>
0xE1AE<SEP>0x6230<SEP>0x76B8<SEP3>// <CJK>
0xE1AF<SEP>0x6231<SEP>0x76B9<SEP3>// <CJK>
0xE1B0<SEP>0x6232<SEP>0x76BA<SEP3>// <CJK>
0xE1B1<SEP>0x6233<SEP>0x76C2<SEP3>// <CJK>
0xE1B2<SEP>0x6234<SEP>0x76CD<SEP3>// <CJK>
0xE1B3<SEP>0x6235<SEP>0x76D6<SEP3>// <CJK>
0xE1B4<SEP>0x6236<SEP>0x76D2<SEP3>// <CJK>
0xE1B5<SEP>0x6237<SEP>0x76DE<SEP3>// <CJK>
0xE1B6<SEP>0x6238<SEP>0x76E1<SEP3>// <CJK>
0xE1B7<SEP>0x6239<SEP>0x76E5<SEP3>// <CJK>
0xE1B8<SEP>0x623A<SEP>0x76E7<SEP3>// <CJK>
0xE1B9<SEP>0x623B<SEP>0x76EA<SEP3>// <CJK>
0xE1BA<SEP>0x623C<SEP>0x862F<SEP3>// <CJK>
0xE1BB<SEP>0x623D<SEP>0x76FB<SEP3>// <CJK>
0xE1BC<SEP>0x623E<SEP>0x7708<SEP3>// <CJK>
0xE1BD<SEP>0x623F<SEP>0x7707<SEP3>// <CJK>
0xE1BE<SEP>0x6240<SEP>0x7704<SEP3>// <CJK>
0xE1BF<SEP>0x6241<SEP>0x7729<SEP3>// <CJK>
0xE1C0<SEP>0x6242<SEP>0x7724<SEP3>// <CJK>
0xE1C1<SEP>0x6243<SEP>0x771E<SEP3>// <CJK>
0xE1C2<SEP>0x6244<SEP>0x7725<SEP3>// <CJK>
0xE1C3<SEP>0x6245<SEP>0x7726<SEP3>// <CJK>
0xE1C4<SEP>0x6246<SEP>0x771B<SEP3>// <CJK>
0xE1C5<SEP>0x6247<SEP>0x7737<SEP3>// <CJK>
0xE1C6<SEP>0x6248<SEP>0x7738<SEP3>// <CJK>
0xE1C7<SEP>0x6249<SEP>0x7747<SEP3>// <CJK>
0xE1C8<SEP>0x624A<SEP>0x775A<SEP3>// <CJK>
0xE1C9<SEP>0x624B<SEP>0x7768<SEP3>// <CJK>
0xE1CA<SEP>0x624C<SEP>0x776B<SEP3>// <CJK>
0xE1CB<SEP>0x624D<SEP>0x775B<SEP3>// <CJK>
0xE1CC<SEP>0x624E<SEP>0x7765<SEP3>// <CJK>
0xE1CD<SEP>0x624F<SEP>0x777F<SEP3>// <CJK>
0xE1CE<SEP>0x6250<SEP>0x777E<SEP3>// <CJK>
0xE1CF<SEP>0x6251<SEP>0x7779<SEP3>// <CJK>
0xE1D0<SEP>0x6252<SEP>0x778E<SEP3>// <CJK>
0xE1D1<SEP>0x6253<SEP>0x778B<SEP3>// <CJK>
0xE1D2<SEP>0x6254<SEP>0x7791<SEP3>// <CJK>
0xE1D3<SEP>0x6255<SEP>0x77A0<SEP3>// <CJK>
0xE1D4<SEP>0x6256<SEP>0x779E<SEP3>// <CJK>
0xE1D5<SEP>0x6257<SEP>0x77B0<SEP3>// <CJK>
0xE1D6<SEP>0x6258<SEP>0x77B6<SEP3>// <CJK>
0xE1D7<SEP>0x6259<SEP>0x77B9<SEP3>// <CJK>
0xE1D8<SEP>0x625A<SEP>0x77BF<SEP3>// <CJK>
0xE1D9<SEP>0x625B<SEP>0x77BC<SEP3>// <CJK>
0xE1DA<SEP>0x625C<SEP>0x77BD<SEP3>// <CJK>
0xE1DB<SEP>0x625D<SEP>0x77BB<SEP3>// <CJK>
0xE1DC<SEP>0x625E<SEP>0x77C7<SEP3>// <CJK>
0xE1DD<SEP>0x625F<SEP>0x77CD<SEP3>// <CJK>
0xE1DE<SEP>0x6260<SEP>0x77D7<SEP3>// <CJK>
0xE1DF<SEP>0x6261<SEP>0x77DA<SEP3>// <CJK>
0xE1E0<SEP>0x6262<SEP>0x77DC<SEP3>// <CJK>
0xE1E1<SEP>0x6263<SEP>0x77E3<SEP3>// <CJK>
0xE1E2<SEP>0x6264<SEP>0x77EE<SEP3>// <CJK>
0xE1E3<SEP>0x6265<SEP>0x77FC<SEP3>// <CJK>
0xE1E4<SEP>0x6266<SEP>0x780C<SEP3>// <CJK>
0xE1E5<SEP>0x6267<SEP>0x7812<SEP3>// <CJK>
0xE1E6<SEP>0x6268<SEP>0x7926<SEP3>// <CJK>
0xE1E7<SEP>0x6269<SEP>0x7820<SEP3>// <CJK>
0xE1E8<SEP>0x626A<SEP>0x792A<SEP3>// <CJK>
0xE1E9<SEP>0x626B<SEP>0x7845<SEP3>// <CJK>
0xE1EA<SEP>0x626C<SEP>0x788E<SEP3>// <CJK>
0xE1EB<SEP>0x626D<SEP>0x7874<SEP3>// <CJK>
0xE1EC<SEP>0x626E<SEP>0x7886<SEP3>// <CJK>
0xE1ED<SEP>0x626F<SEP>0x787C<SEP3>// <CJK>
0xE1EE<SEP>0x6270<SEP>0x789A<SEP3>// <CJK>
0xE1EF<SEP>0x6271<SEP>0x788C<SEP3>// <CJK>
0xE1F0<SEP>0x6272<SEP>0x78A3<SEP3>// <CJK>
0xE1F1<SEP>0x6273<SEP>0x78B5<SEP3>// <CJK>
0xE1F2<SEP>0x6274<SEP>0x78AA<SEP3>// <CJK>
0xE1F3<SEP>0x6275<SEP>0x78AF<SEP3>// <CJK>
0xE1F4<SEP>0x6276<SEP>0x78D1<SEP3>// <CJK>
0xE1F5<SEP>0x6277<SEP>0x78C6<SEP3>// <CJK>
0xE1F6<SEP>0x6278<SEP>0x78CB<SEP3>// <CJK>
0xE1F7<SEP>0x6279<SEP>0x78D4<SEP3>// <CJK>
0xE1F8<SEP>0x627A<SEP>0x78BE<SEP3>// <CJK>
0xE1F9<SEP>0x627B<SEP>0x78BC<SEP3>// <CJK>
0xE1FA<SEP>0x627C<SEP>0x78C5<SEP3>// <CJK>
0xE1FB<SEP>0x627D<SEP>0x78CA<SEP3>// <CJK>
0xE1FC<SEP>0x627E<SEP>0x78EC<SEP3>// <CJK>
0xE240<SEP>0x6321<SEP>0x78E7<SEP3>// <CJK>
0xE241<SEP>0x6322<SEP>0x78DA<SEP3>// <CJK>
0xE242<SEP>0x6323<SEP>0x78FD<SEP3>// <CJK>
0xE243<SEP>0x6324<SEP>0x78F4<SEP3>// <CJK>
0xE244<SEP>0x6325<SEP>0x7907<SEP3>// <CJK>
0xE245<SEP>0x6326<SEP>0x7912<SEP3>// <CJK>
0xE246<SEP>0x6327<SEP>0x7911<SEP3>// <CJK>
0xE247<SEP>0x6328<SEP>0x7919<SEP3>// <CJK>
0xE248<SEP>0x6329<SEP>0x792C<SEP3>// <CJK>
0xE249<SEP>0x632A<SEP>0x792B<SEP3>// <CJK>
0xE24A<SEP>0x632B<SEP>0x7940<SEP3>// <CJK>
0xE24B<SEP>0x632C<SEP>0x7960<SEP3>// <CJK>
0xE24C<SEP>0x632D<SEP>0x7957<SEP3>// <CJK>
0xE24D<SEP>0x632E<SEP>0x795F<SEP3>// <CJK>
0xE24E<SEP>0x632F<SEP>0x795A<SEP3>// <CJK>
0xE24F<SEP>0x6330<SEP>0x7955<SEP3>// <CJK>
0xE250<SEP>0x6331<SEP>0x7953<SEP3>// <CJK>
0xE251<SEP>0x6332<SEP>0x797A<SEP3>// <CJK>
0xE252<SEP>0x6333<SEP>0x797F<SEP3>// <CJK>
0xE253<SEP>0x6334<SEP>0x798A<SEP3>// <CJK>
0xE254<SEP>0x6335<SEP>0x799D<SEP3>// <CJK>
0xE255<SEP>0x6336<SEP>0x79A7<SEP3>// <CJK>
0xE256<SEP>0x6337<SEP>0x9F4B<SEP3>// <CJK>
0xE257<SEP>0x6338<SEP>0x79AA<SEP3>// <CJK>
0xE258<SEP>0x6339<SEP>0x79AE<SEP3>// <CJK>
0xE259<SEP>0x633A<SEP>0x79B3<SEP3>// <CJK>
0xE25A<SEP>0x633B<SEP>0x79B9<SEP3>// <CJK>
0xE25B<SEP>0x633C<SEP>0x79BA<SEP3>// <CJK>
0xE25C<SEP>0x633D<SEP>0x79C9<SEP3>// <CJK>
0xE25D<SEP>0x633E<SEP>0x79D5<SEP3>// <CJK>
0xE25E<SEP>0x633F<SEP>0x79E7<SEP3>// <CJK>
0xE25F<SEP>0x6340<SEP>0x79EC<SEP3>// <CJK>
0xE260<SEP>0x6341<SEP>0x79E1<SEP3>// <CJK>
0xE261<SEP>0x6342<SEP>0x79E3<SEP3>// <CJK>
0xE262<SEP>0x6343<SEP>0x7A08<SEP3>// <CJK>
0xE263<SEP>0x6344<SEP>0x7A0D<SEP3>// <CJK>
0xE264<SEP>0x6345<SEP>0x7A18<SEP3>// <CJK>
0xE265<SEP>0x6346<SEP>0x7A19<SEP3>// <CJK>
0xE266<SEP>0x6347<SEP>0x7A20<SEP3>// <CJK>
0xE267<SEP>0x6348<SEP>0x7A1F<SEP3>// <CJK>
0xE268<SEP>0x6349<SEP>0x7980<SEP3>// <CJK>
0xE269<SEP>0x634A<SEP>0x7A31<SEP3>// <CJK>
0xE26A<SEP>0x634B<SEP>0x7A3B<SEP3>// <CJK>
0xE26B<SEP>0x634C<SEP>0x7A3E<SEP3>// <CJK>
0xE26C<SEP>0x634D<SEP>0x7A37<SEP3>// <CJK>
0xE26D<SEP>0x634E<SEP>0x7A43<SEP3>// <CJK>
0xE26E<SEP>0x634F<SEP>0x7A57<SEP3>// <CJK>
0xE26F<SEP>0x6350<SEP>0x7A49<SEP3>// <CJK>
0xE270<SEP>0x6351<SEP>0x7A61<SEP3>// <CJK>
0xE271<SEP>0x6352<SEP>0x7A62<SEP3>// <CJK>
0xE272<SEP>0x6353<SEP>0x7A69<SEP3>// <CJK>
0xE273<SEP>0x6354<SEP>0x9F9D<SEP3>// <CJK>
0xE274<SEP>0x6355<SEP>0x7A70<SEP3>// <CJK>
0xE275<SEP>0x6356<SEP>0x7A79<SEP3>// <CJK>
0xE276<SEP>0x6357<SEP>0x7A7D<SEP3>// <CJK>
0xE277<SEP>0x6358<SEP>0x7A88<SEP3>// <CJK>
0xE278<SEP>0x6359<SEP>0x7A97<SEP3>// <CJK>
0xE279<SEP>0x635A<SEP>0x7A95<SEP3>// <CJK>
0xE27A<SEP>0x635B<SEP>0x7A98<SEP3>// <CJK>
0xE27B<SEP>0x635C<SEP>0x7A96<SEP3>// <CJK>
0xE27C<SEP>0x635D<SEP>0x7AA9<SEP3>// <CJK>
0xE27D<SEP>0x635E<SEP>0x7AC8<SEP3>// <CJK>
0xE27E<SEP>0x635F<SEP>0x7AB0<SEP3>// <CJK>
0xE280<SEP>0x6360<SEP>0x7AB6<SEP3>// <CJK>
0xE281<SEP>0x6361<SEP>0x7AC5<SEP3>// <CJK>
0xE282<SEP>0x6362<SEP>0x7AC4<SEP3>// <CJK>
0xE283<SEP>0x6363<SEP>0x7ABF<SEP3>// <CJK>
0xE284<SEP>0x6364<SEP>0x9083<SEP3>// <CJK>
0xE285<SEP>0x6365<SEP>0x7AC7<SEP3>// <CJK>
0xE286<SEP>0x6366<SEP>0x7ACA<SEP3>// <CJK>
0xE287<SEP>0x6367<SEP>0x7ACD<SEP3>// <CJK>
0xE288<SEP>0x6368<SEP>0x7ACF<SEP3>// <CJK>
0xE289<SEP>0x6369<SEP>0x7AD5<SEP3>// <CJK>
0xE28A<SEP>0x636A<SEP>0x7AD3<SEP3>// <CJK>
0xE28B<SEP>0x636B<SEP>0x7AD9<SEP3>// <CJK>
0xE28C<SEP>0x636C<SEP>0x7ADA<SEP3>// <CJK>
0xE28D<SEP>0x636D<SEP>0x7ADD<SEP3>// <CJK>
0xE28E<SEP>0x636E<SEP>0x7AE1<SEP3>// <CJK>
0xE28F<SEP>0x636F<SEP>0x7AE2<SEP3>// <CJK>
0xE290<SEP>0x6370<SEP>0x7AE6<SEP3>// <CJK>
0xE291<SEP>0x6371<SEP>0x7AED<SEP3>// <CJK>
0xE292<SEP>0x6372<SEP>0x7AF0<SEP3>// <CJK>
0xE293<SEP>0x6373<SEP>0x7B02<SEP3>// <CJK>
0xE294<SEP>0x6374<SEP>0x7B0F<SEP3>// <CJK>
0xE295<SEP>0x6375<SEP>0x7B0A<SEP3>// <CJK>
0xE296<SEP>0x6376<SEP>0x7B06<SEP3>// <CJK>
0xE297<SEP>0x6377<SEP>0x7B33<SEP3>// <CJK>
0xE298<SEP>0x6378<SEP>0x7B18<SEP3>// <CJK>
0xE299<SEP>0x6379<SEP>0x7B19<SEP3>// <CJK>
0xE29A<SEP>0x637A<SEP>0x7B1E<SEP3>// <CJK>
0xE29B<SEP>0x637B<SEP>0x7B35<SEP3>// <CJK>
0xE29C<SEP>0x637C<SEP>0x7B28<SEP3>// <CJK>
0xE29D<SEP>0x637D<SEP>0x7B36<SEP3>// <CJK>
0xE29E<SEP>0x637E<SEP>0x7B50<SEP3>// <CJK>
0xE29F<SEP>0x6421<SEP>0x7B7A<SEP3>// <CJK>
0xE2A0<SEP>0x6422<SEP>0x7B04<SEP3>// <CJK>
0xE2A1<SEP>0x6423<SEP>0x7B4D<SEP3>// <CJK>
0xE2A2<SEP>0x6424<SEP>0x7B0B<SEP3>// <CJK>
0xE2A3<SEP>0x6425<SEP>0x7B4C<SEP3>// <CJK>
0xE2A4<SEP>0x6426<SEP>0x7B45<SEP3>// <CJK>
0xE2A5<SEP>0x6427<SEP>0x7B75<SEP3>// <CJK>
0xE2A6<SEP>0x6428<SEP>0x7B65<SEP3>// <CJK>
0xE2A7<SEP>0x6429<SEP>0x7B74<SEP3>// <CJK>
0xE2A8<SEP>0x642A<SEP>0x7B67<SEP3>// <CJK>
0xE2A9<SEP>0x642B<SEP>0x7B70<SEP3>// <CJK>
0xE2AA<SEP>0x642C<SEP>0x7B71<SEP3>// <CJK>
0xE2AB<SEP>0x642D<SEP>0x7B6C<SEP3>// <CJK>
0xE2AC<SEP>0x642E<SEP>0x7B6E<SEP3>// <CJK>
0xE2AD<SEP>0x642F<SEP>0x7B9D<SEP3>// <CJK>
0xE2AE<SEP>0x6430<SEP>0x7B98<SEP3>// <CJK>
0xE2AF<SEP>0x6431<SEP>0x7B9F<SEP3>// <CJK>
0xE2B0<SEP>0x6432<SEP>0x7B8D<SEP3>// <CJK>
0xE2B1<SEP>0x6433<SEP>0x7B9C<SEP3>// <CJK>
0xE2B2<SEP>0x6434<SEP>0x7B9A<SEP3>// <CJK>
0xE2B3<SEP>0x6435<SEP>0x7B8B<SEP3>// <CJK>
0xE2B4<SEP>0x6436<SEP>0x7B92<SEP3>// <CJK>
0xE2B5<SEP>0x6437<SEP>0x7B8F<SEP3>// <CJK>
0xE2B6<SEP>0x6438<SEP>0x7B5D<SEP3>// <CJK>
0xE2B7<SEP>0x6439<SEP>0x7B99<SEP3>// <CJK>
0xE2B8<SEP>0x643A<SEP>0x7BCB<SEP3>// <CJK>
0xE2B9<SEP>0x643B<SEP>0x7BC1<SEP3>// <CJK>
0xE2BA<SEP>0x643C<SEP>0x7BCC<SEP3>// <CJK>
0xE2BB<SEP>0x643D<SEP>0x7BCF<SEP3>// <CJK>
0xE2BC<SEP>0x643E<SEP>0x7BB4<SEP3>// <CJK>
0xE2BD<SEP>0x643F<SEP>0x7BC6<SEP3>// <CJK>
0xE2BE<SEP>0x6440<SEP>0x7BDD<SEP3>// <CJK>
0xE2BF<SEP>0x6441<SEP>0x7BE9<SEP3>// <CJK>
0xE2C0<SEP>0x6442<SEP>0x7C11<SEP3>// <CJK>
0xE2C1<SEP>0x6443<SEP>0x7C14<SEP3>// <CJK>
0xE2C2<SEP>0x6444<SEP>0x7BE6<SEP3>// <CJK>
0xE2C3<SEP>0x6445<SEP>0x7BE5<SEP3>// <CJK>
0xE2C4<SEP>0x6446<SEP>0x7C60<SEP3>// <CJK>
0xE2C5<SEP>0x6447<SEP>0x7C00<SEP3>// <CJK>
0xE2C6<SEP>0x6448<SEP>0x7C07<SEP3>// <CJK>
0xE2C7<SEP>0x6449<SEP>0x7C13<SEP3>// <CJK>
0xE2C8<SEP>0x644A<SEP>0x7BF3<SEP3>// <CJK>
0xE2C9<SEP>0x644B<SEP>0x7BF7<SEP3>// <CJK>
0xE2CA<SEP>0x644C<SEP>0x7C17<SEP3>// <CJK>
0xE2CB<SEP>0x644D<SEP>0x7C0D<SEP3>// <CJK>
0xE2CC<SEP>0x644E<SEP>0x7BF6<SEP3>// <CJK>
0xE2CD<SEP>0x644F<SEP>0x7C23<SEP3>// <CJK>
0xE2CE<SEP>0x6450<SEP>0x7C27<SEP3>// <CJK>
0xE2CF<SEP>0x6451<SEP>0x7C2A<SEP3>// <CJK>
0xE2D0<SEP>0x6452<SEP>0x7C1F<SEP3>// <CJK>
0xE2D1<SEP>0x6453<SEP>0x7C37<SEP3>// <CJK>
0xE2D2<SEP>0x6454<SEP>0x7C2B<SEP3>// <CJK>
0xE2D3<SEP>0x6455<SEP>0x7C3D<SEP3>// <CJK>
0xE2D4<SEP>0x6456<SEP>0x7C4C<SEP3>// <CJK>
0xE2D5<SEP>0x6457<SEP>0x7C43<SEP3>// <CJK>
0xE2D6<SEP>0x6458<SEP>0x7C54<SEP3>// <CJK>
0xE2D7<SEP>0x6459<SEP>0x7C4F<SEP3>// <CJK>
0xE2D8<SEP>0x645A<SEP>0x7C40<SEP3>// <CJK>
0xE2D9<SEP>0x645B<SEP>0x7C50<SEP3>// <CJK>
0xE2DA<SEP>0x645C<SEP>0x7C58<SEP3>// <CJK>
0xE2DB<SEP>0x645D<SEP>0x7C5F<SEP3>// <CJK>
0xE2DC<SEP>0x645E<SEP>0x7C64<SEP3>// <CJK>
0xE2DD<SEP>0x645F<SEP>0x7C56<SEP3>// <CJK>
0xE2DE<SEP>0x6460<SEP>0x7C65<SEP3>// <CJK>
0xE2DF<SEP>0x6461<SEP>0x7C6C<SEP3>// <CJK>
0xE2E0<SEP>0x6462<SEP>0x7C75<SEP3>// <CJK>
0xE2E1<SEP>0x6463<SEP>0x7C83<SEP3>// <CJK>
0xE2E2<SEP>0x6464<SEP>0x7C90<SEP3>// <CJK>
0xE2E3<SEP>0x6465<SEP>0x7CA4<SEP3>// <CJK>
0xE2E4<SEP>0x6466<SEP>0x7CAD<SEP3>// <CJK>
0xE2E5<SEP>0x6467<SEP>0x7CA2<SEP3>// <CJK>
0xE2E6<SEP>0x6468<SEP>0x7CAB<SEP3>// <CJK>
0xE2E7<SEP>0x6469<SEP>0x7CA1<SEP3>// <CJK>
0xE2E8<SEP>0x646A<SEP>0x7CA8<SEP3>// <CJK>
0xE2E9<SEP>0x646B<SEP>0x7CB3<SEP3>// <CJK>
0xE2EA<SEP>0x646C<SEP>0x7CB2<SEP3>// <CJK>
0xE2EB<SEP>0x646D<SEP>0x7CB1<SEP3>// <CJK>
0xE2EC<SEP>0x646E<SEP>0x7CAE<SEP3>// <CJK>
0xE2ED<SEP>0x646F<SEP>0x7CB9<SEP3>// <CJK>
0xE2EE<SEP>0x6470<SEP>0x7CBD<SEP3>// <CJK>
0xE2EF<SEP>0x6471<SEP>0x7CC0<SEP3>// <CJK>
0xE2F0<SEP>0x6472<SEP>0x7CC5<SEP3>// <CJK>
0xE2F1<SEP>0x6473<SEP>0x7CC2<SEP3>// <CJK>
0xE2F2<SEP>0x6474<SEP>0x7CD8<SEP3>// <CJK>
0xE2F3<SEP>0x6475<SEP>0x7CD2<SEP3>// <CJK>
0xE2F4<SEP>0x6476<SEP>0x7CDC<SEP3>// <CJK>
0xE2F5<SEP>0x6477<SEP>0x7CE2<SEP3>// <CJK>
0xE2F6<SEP>0x6478<SEP>0x9B3B<SEP3>// <CJK>
0xE2F7<SEP>0x6479<SEP>0x7CEF<SEP3>// <CJK>
0xE2F8<SEP>0x647A<SEP>0x7CF2<SEP3>// <CJK>
0xE2F9<SEP>0x647B<SEP>0x7CF4<SEP3>// <CJK>
0xE2FA<SEP>0x647C<SEP>0x7CF6<SEP3>// <CJK>
0xE2FB<SEP>0x647D<SEP>0x7CFA<SEP3>// <CJK>
0xE2FC<SEP>0x647E<SEP>0x7D06<SEP3>// <CJK>
0xE340<SEP>0x6521<SEP>0x7D02<SEP3>// <CJK>
0xE341<SEP>0x6522<SEP>0x7D1C<SEP3>// <CJK>
0xE342<SEP>0x6523<SEP>0x7D15<SEP3>// <CJK>
0xE343<SEP>0x6524<SEP>0x7D0A<SEP3>// <CJK>
0xE344<SEP>0x6525<SEP>0x7D45<SEP3>// <CJK>
0xE345<SEP>0x6526<SEP>0x7D4B<SEP3>// <CJK>
0xE346<SEP>0x6527<SEP>0x7D2E<SEP3>// <CJK>
0xE347<SEP>0x6528<SEP>0x7D32<SEP3>// <CJK>
0xE348<SEP>0x6529<SEP>0x7D3F<SEP3>// <CJK>
0xE349<SEP>0x652A<SEP>0x7D35<SEP3>// <CJK>
0xE34A<SEP>0x652B<SEP>0x7D46<SEP3>// <CJK>
0xE34B<SEP>0x652C<SEP>0x7D73<SEP3>// <CJK>
0xE34C<SEP>0x652D<SEP>0x7D56<SEP3>// <CJK>
0xE34D<SEP>0x652E<SEP>0x7D4E<SEP3>// <CJK>
0xE34E<SEP>0x652F<SEP>0x7D72<SEP3>// <CJK>
0xE34F<SEP>0x6530<SEP>0x7D68<SEP3>// <CJK>
0xE350<SEP>0x6531<SEP>0x7D6E<SEP3>// <CJK>
0xE351<SEP>0x6532<SEP>0x7D4F<SEP3>// <CJK>
0xE352<SEP>0x6533<SEP>0x7D63<SEP3>// <CJK>
0xE353<SEP>0x6534<SEP>0x7D93<SEP3>// <CJK>
0xE354<SEP>0x6535<SEP>0x7D89<SEP3>// <CJK>
0xE355<SEP>0x6536<SEP>0x7D5B<SEP3>// <CJK>
0xE356<SEP>0x6537<SEP>0x7D8F<SEP3>// <CJK>
0xE357<SEP>0x6538<SEP>0x7D7D<SEP3>// <CJK>
0xE358<SEP>0x6539<SEP>0x7D9B<SEP3>// <CJK>
0xE359<SEP>0x653A<SEP>0x7DBA<SEP3>// <CJK>
0xE35A<SEP>0x653B<SEP>0x7DAE<SEP3>// <CJK>
0xE35B<SEP>0x653C<SEP>0x7DA3<SEP3>// <CJK>
0xE35C<SEP>0x653D<SEP>0x7DB5<SEP3>// <CJK>
0xE35D<SEP>0x653E<SEP>0x7DC7<SEP3>// <CJK>
0xE35E<SEP>0x653F<SEP>0x7DBD<SEP3>// <CJK>
0xE35F<SEP>0x6540<SEP>0x7DAB<SEP3>// <CJK>
0xE360<SEP>0x6541<SEP>0x7E3D<SEP3>// <CJK>
0xE361<SEP>0x6542<SEP>0x7DA2<SEP3>// <CJK>
0xE362<SEP>0x6543<SEP>0x7DAF<SEP3>// <CJK>
0xE363<SEP>0x6544<SEP>0x7DDC<SEP3>// <CJK>
0xE364<SEP>0x6545<SEP>0x7DB8<SEP3>// <CJK>
0xE365<SEP>0x6546<SEP>0x7D9F<SEP3>// <CJK>
0xE366<SEP>0x6547<SEP>0x7DB0<SEP3>// <CJK>
0xE367<SEP>0x6548<SEP>0x7DD8<SEP3>// <CJK>
0xE368<SEP>0x6549<SEP>0x7DDD<SEP3>// <CJK>
0xE369<SEP>0x654A<SEP>0x7DE4<SEP3>// <CJK>
0xE36A<SEP>0x654B<SEP>0x7DDE<SEP3>// <CJK>
0xE36B<SEP>0x654C<SEP>0x7DFB<SEP3>// <CJK>
0xE36C<SEP>0x654D<SEP>0x7DF2<SEP3>// <CJK>
0xE36D<SEP>0x654E<SEP>0x7DE1<SEP3>// <CJK>
0xE36E<SEP>0x654F<SEP>0x7E05<SEP3>// <CJK>
0xE36F<SEP>0x6550<SEP>0x7E0A<SEP3>// <CJK>
0xE370<SEP>0x6551<SEP>0x7E23<SEP3>// <CJK>
0xE371<SEP>0x6552<SEP>0x7E21<SEP3>// <CJK>
0xE372<SEP>0x6553<SEP>0x7E12<SEP3>// <CJK>
0xE373<SEP>0x6554<SEP>0x7E31<SEP3>// <CJK>
0xE374<SEP>0x6555<SEP>0x7E1F<SEP3>// <CJK>
0xE375<SEP>0x6556<SEP>0x7E09<SEP3>// <CJK>
0xE376<SEP>0x6557<SEP>0x7E0B<SEP3>// <CJK>
0xE377<SEP>0x6558<SEP>0x7E22<SEP3>// <CJK>
0xE378<SEP>0x6559<SEP>0x7E46<SEP3>// <CJK>
0xE379<SEP>0x655A<SEP>0x7E66<SEP3>// <CJK>
0xE37A<SEP>0x655B<SEP>0x7E3B<SEP3>// <CJK>
0xE37B<SEP>0x655C<SEP>0x7E35<SEP3>// <CJK>
0xE37C<SEP>0x655D<SEP>0x7E39<SEP3>// <CJK>
0xE37D<SEP>0x655E<SEP>0x7E43<SEP3>// <CJK>
0xE37E<SEP>0x655F<SEP>0x7E37<SEP3>// <CJK>
0xE380<SEP>0x6560<SEP>0x7E32<SEP3>// <CJK>
0xE381<SEP>0x6561<SEP>0x7E3A<SEP3>// <CJK>
0xE382<SEP>0x6562<SEP>0x7E67<SEP3>// <CJK>
0xE383<SEP>0x6563<SEP>0x7E5D<SEP3>// <CJK>
0xE384<SEP>0x6564<SEP>0x7E56<SEP3>// <CJK>
0xE385<SEP>0x6565<SEP>0x7E5E<SEP3>// <CJK>
0xE386<SEP>0x6566<SEP>0x7E59<SEP3>// <CJK>
0xE387<SEP>0x6567<SEP>0x7E5A<SEP3>// <CJK>
0xE388<SEP>0x6568<SEP>0x7E79<SEP3>// <CJK>
0xE389<SEP>0x6569<SEP>0x7E6A<SEP3>// <CJK>
0xE38A<SEP>0x656A<SEP>0x7E69<SEP3>// <CJK>
0xE38B<SEP>0x656B<SEP>0x7E7C<SEP3>// <CJK>
0xE38C<SEP>0x656C<SEP>0x7E7B<SEP3>// <CJK>
0xE38D<SEP>0x656D<SEP>0x7E83<SEP3>// <CJK>
0xE38E<SEP>0x656E<SEP>0x7DD5<SEP3>// <CJK>
0xE38F<SEP>0x656F<SEP>0x7E7D<SEP3>// <CJK>
0xE390<SEP>0x6570<SEP>0x8FAE<SEP3>// <CJK>
0xE391<SEP>0x6571<SEP>0x7E7F<SEP3>// <CJK>
0xE392<SEP>0x6572<SEP>0x7E88<SEP3>// <CJK>
0xE393<SEP>0x6573<SEP>0x7E89<SEP3>// <CJK>
0xE394<SEP>0x6574<SEP>0x7E8C<SEP3>// <CJK>
0xE395<SEP>0x6575<SEP>0x7E92<SEP3>// <CJK>
0xE396<SEP>0x6576<SEP>0x7E90<SEP3>// <CJK>
0xE397<SEP>0x6577<SEP>0x7E93<SEP3>// <CJK>
0xE398<SEP>0x6578<SEP>0x7E94<SEP3>// <CJK>
0xE399<SEP>0x6579<SEP>0x7E96<SEP3>// <CJK>
0xE39A<SEP>0x657A<SEP>0x7E8E<SEP3>// <CJK>
0xE39B<SEP>0x657B<SEP>0x7E9B<SEP3>// <CJK>
0xE39C<SEP>0x657C<SEP>0x7E9C<SEP3>// <CJK>
0xE39D<SEP>0x657D<SEP>0x7F38<SEP3>// <CJK>
0xE39E<SEP>0x657E<SEP>0x7F3A<SEP3>// <CJK>
0xE39F<SEP>0x6621<SEP>0x7F45<SEP3>// <CJK>
0xE3A0<SEP>0x6622<SEP>0x7F4C<SEP3>// <CJK>
0xE3A1<SEP>0x6623<SEP>0x7F4D<SEP3>// <CJK>
0xE3A2<SEP>0x6624<SEP>0x7F4E<SEP3>// <CJK>
0xE3A3<SEP>0x6625<SEP>0x7F50<SEP3>// <CJK>
0xE3A4<SEP>0x6626<SEP>0x7F51<SEP3>// <CJK>
0xE3A5<SEP>0x6627<SEP>0x7F55<SEP3>// <CJK>
0xE3A6<SEP>0x6628<SEP>0x7F54<SEP3>// <CJK>
0xE3A7<SEP>0x6629<SEP>0x7F58<SEP3>// <CJK>
0xE3A8<SEP>0x662A<SEP>0x7F5F<SEP3>// <CJK>
0xE3A9<SEP>0x662B<SEP>0x7F60<SEP3>// <CJK>
0xE3AA<SEP>0x662C<SEP>0x7F68<SEP3>// <CJK>
0xE3AB<SEP>0x662D<SEP>0x7F69<SEP3>// <CJK>
0xE3AC<SEP>0x662E<SEP>0x7F67<SEP3>// <CJK>
0xE3AD<SEP>0x662F<SEP>0x7F78<SEP3>// <CJK>
0xE3AE<SEP>0x6630<SEP>0x7F82<SEP3>// <CJK>
0xE3AF<SEP>0x6631<SEP>0x7F86<SEP3>// <CJK>
0xE3B0<SEP>0x6632<SEP>0x7F83<SEP3>// <CJK>
0xE3B1<SEP>0x6633<SEP>0x7F88<SEP3>// <CJK>
0xE3B2<SEP>0x6634<SEP>0x7F87<SEP3>// <CJK>
0xE3B3<SEP>0x6635<SEP>0x7F8C<SEP3>// <CJK>
0xE3B4<SEP>0x6636<SEP>0x7F94<SEP3>// <CJK>
0xE3B5<SEP>0x6637<SEP>0x7F9E<SEP3>// <CJK>
0xE3B6<SEP>0x6638<SEP>0x7F9D<SEP3>// <CJK>
0xE3B7<SEP>0x6639<SEP>0x7F9A<SEP3>// <CJK>
0xE3B8<SEP>0x663A<SEP>0x7FA3<SEP3>// <CJK>
0xE3B9<SEP>0x663B<SEP>0x7FAF<SEP3>// <CJK>
0xE3BA<SEP>0x663C<SEP>0x7FB2<SEP3>// <CJK>
0xE3BB<SEP>0x663D<SEP>0x7FB9<SEP3>// <CJK>
0xE3BC<SEP>0x663E<SEP>0x7FAE<SEP3>// <CJK>
0xE3BD<SEP>0x663F<SEP>0x7FB6<SEP3>// <CJK>
0xE3BE<SEP>0x6640<SEP>0x7FB8<SEP3>// <CJK>
0xE3BF<SEP>0x6641<SEP>0x8B71<SEP3>// <CJK>
0xE3C0<SEP>0x6642<SEP>0x7FC5<SEP3>// <CJK>
0xE3C1<SEP>0x6643<SEP>0x7FC6<SEP3>// <CJK>
0xE3C2<SEP>0x6644<SEP>0x7FCA<SEP3>// <CJK>
0xE3C3<SEP>0x6645<SEP>0x7FD5<SEP3>// <CJK>
0xE3C4<SEP>0x6646<SEP>0x7FD4<SEP3>// <CJK>
0xE3C5<SEP>0x6647<SEP>0x7FE1<SEP3>// <CJK>
0xE3C6<SEP>0x6648<SEP>0x7FE6<SEP3>// <CJK>
0xE3C7<SEP>0x6649<SEP>0x7FE9<SEP3>// <CJK>
0xE3C8<SEP>0x664A<SEP>0x7FF3<SEP3>// <CJK>
0xE3C9<SEP>0x664B<SEP>0x7FF9<SEP3>// <CJK>
0xE3CA<SEP>0x664C<SEP>0x98DC<SEP3>// <CJK>
0xE3CB<SEP>0x664D<SEP>0x8006<SEP3>// <CJK>
0xE3CC<SEP>0x664E<SEP>0x8004<SEP3>// <CJK>
0xE3CD<SEP>0x664F<SEP>0x800B<SEP3>// <CJK>
0xE3CE<SEP>0x6650<SEP>0x8012<SEP3>// <CJK>
0xE3CF<SEP>0x6651<SEP>0x8018<SEP3>// <CJK>
0xE3D0<SEP>0x6652<SEP>0x8019<SEP3>// <CJK>
0xE3D1<SEP>0x6653<SEP>0x801C<SEP3>// <CJK>
0xE3D2<SEP>0x6654<SEP>0x8021<SEP3>// <CJK>
0xE3D3<SEP>0x6655<SEP>0x8028<SEP3>// <CJK>
0xE3D4<SEP>0x6656<SEP>0x803F<SEP3>// <CJK>
0xE3D5<SEP>0x6657<SEP>0x803B<SEP3>// <CJK>
0xE3D6<SEP>0x6658<SEP>0x804A<SEP3>// <CJK>
0xE3D7<SEP>0x6659<SEP>0x8046<SEP3>// <CJK>
0xE3D8<SEP>0x665A<SEP>0x8052<SEP3>// <CJK>
0xE3D9<SEP>0x665B<SEP>0x8058<SEP3>// <CJK>
0xE3DA<SEP>0x665C<SEP>0x805A<SEP3>// <CJK>
0xE3DB<SEP>0x665D<SEP>0x805F<SEP3>// <CJK>
0xE3DC<SEP>0x665E<SEP>0x8062<SEP3>// <CJK>
0xE3DD<SEP>0x665F<SEP>0x8068<SEP3>// <CJK>
0xE3DE<SEP>0x6660<SEP>0x8073<SEP3>// <CJK>
0xE3DF<SEP>0x6661<SEP>0x8072<SEP3>// <CJK>
0xE3E0<SEP>0x6662<SEP>0x8070<SEP3>// <CJK>
0xE3E1<SEP>0x6663<SEP>0x8076<SEP3>// <CJK>
0xE3E2<SEP>0x6664<SEP>0x8079<SEP3>// <CJK>
0xE3E3<SEP>0x6665<SEP>0x807D<SEP3>// <CJK>
0xE3E4<SEP>0x6666<SEP>0x807F<SEP3>// <CJK>
0xE3E5<SEP>0x6667<SEP>0x8084<SEP3>// <CJK>
0xE3E6<SEP>0x6668<SEP>0x8086<SEP3>// <CJK>
0xE3E7<SEP>0x6669<SEP>0x8085<SEP3>// <CJK>
0xE3E8<SEP>0x666A<SEP>0x809B<SEP3>// <CJK>
0xE3E9<SEP>0x666B<SEP>0x8093<SEP3>// <CJK>
0xE3EA<SEP>0x666C<SEP>0x809A<SEP3>// <CJK>
0xE3EB<SEP>0x666D<SEP>0x80AD<SEP3>// <CJK>
0xE3EC<SEP>0x666E<SEP>0x5190<SEP3>// <CJK>
0xE3ED<SEP>0x666F<SEP>0x80AC<SEP3>// <CJK>
0xE3EE<SEP>0x6670<SEP>0x80DB<SEP3>// <CJK>
0xE3EF<SEP>0x6671<SEP>0x80E5<SEP3>// <CJK>
0xE3F0<SEP>0x6672<SEP>0x80D9<SEP3>// <CJK>
0xE3F1<SEP>0x6673<SEP>0x80DD<SEP3>// <CJK>
0xE3F2<SEP>0x6674<SEP>0x80C4<SEP3>// <CJK>
0xE3F3<SEP>0x6675<SEP>0x80DA<SEP3>// <CJK>
0xE3F4<SEP>0x6676<SEP>0x80D6<SEP3>// <CJK>
0xE3F5<SEP>0x6677<SEP>0x8109<SEP3>// <CJK>
0xE3F6<SEP>0x6678<SEP>0x80EF<SEP3>// <CJK>
0xE3F7<SEP>0x6679<SEP>0x80F1<SEP3>// <CJK>
0xE3F8<SEP>0x667A<SEP>0x811B<SEP3>// <CJK>
0xE3F9<SEP>0x667B<SEP>0x8129<SEP3>// <CJK>
0xE3FA<SEP>0x667C<SEP>0x8123<SEP3>// <CJK>
0xE3FB<SEP>0x667D<SEP>0x812F<SEP3>// <CJK>
0xE3FC<SEP>0x667E<SEP>0x814B<SEP3>// <CJK>
0xE440<SEP>0x6721<SEP>0x968B<SEP3>// <CJK>
0xE441<SEP>0x6722<SEP>0x8146<SEP3>// <CJK>
0xE442<SEP>0x6723<SEP>0x813E<SEP3>// <CJK>
0xE443<SEP>0x6724<SEP>0x8153<SEP3>// <CJK>
0xE444<SEP>0x6725<SEP>0x8151<SEP3>// <CJK>
0xE445<SEP>0x6726<SEP>0x80FC<SEP3>// <CJK>
0xE446<SEP>0x6727<SEP>0x8171<SEP3>// <CJK>
0xE447<SEP>0x6728<SEP>0x816E<SEP3>// <CJK>
0xE448<SEP>0x6729<SEP>0x8165<SEP3>// <CJK>
0xE449<SEP>0x672A<SEP>0x8166<SEP3>// <CJK>
0xE44A<SEP>0x672B<SEP>0x8174<SEP3>// <CJK>
0xE44B<SEP>0x672C<SEP>0x8183<SEP3>// <CJK>
0xE44C<SEP>0x672D<SEP>0x8188<SEP3>// <CJK>
0xE44D<SEP>0x672E<SEP>0x818A<SEP3>// <CJK>
0xE44E<SEP>0x672F<SEP>0x8180<SEP3>// <CJK>
0xE44F<SEP>0x6730<SEP>0x8182<SEP3>// <CJK>
0xE450<SEP>0x6731<SEP>0x81A0<SEP3>// <CJK>
0xE451<SEP>0x6732<SEP>0x8195<SEP3>// <CJK>
0xE452<SEP>0x6733<SEP>0x81A4<SEP3>// <CJK>
0xE453<SEP>0x6734<SEP>0x81A3<SEP3>// <CJK>
0xE454<SEP>0x6735<SEP>0x815F<SEP3>// <CJK>
0xE455<SEP>0x6736<SEP>0x8193<SEP3>// <CJK>
0xE456<SEP>0x6737<SEP>0x81A9<SEP3>// <CJK>
0xE457<SEP>0x6738<SEP>0x81B0<SEP3>// <CJK>
0xE458<SEP>0x6739<SEP>0x81B5<SEP3>// <CJK>
0xE459<SEP>0x673A<SEP>0x81BE<SEP3>// <CJK>
0xE45A<SEP>0x673B<SEP>0x81B8<SEP3>// <CJK>
0xE45B<SEP>0x673C<SEP>0x81BD<SEP3>// <CJK>
0xE45C<SEP>0x673D<SEP>0x81C0<SEP3>// <CJK>
0xE45D<SEP>0x673E<SEP>0x81C2<SEP3>// <CJK>
0xE45E<SEP>0x673F<SEP>0x81BA<SEP3>// <CJK>
0xE45F<SEP>0x6740<SEP>0x81C9<SEP3>// <CJK>
0xE460<SEP>0x6741<SEP>0x81CD<SEP3>// <CJK>
0xE461<SEP>0x6742<SEP>0x81D1<SEP3>// <CJK>
0xE462<SEP>0x6743<SEP>0x81D9<SEP3>// <CJK>
0xE463<SEP>0x6744<SEP>0x81D8<SEP3>// <CJK>
0xE464<SEP>0x6745<SEP>0x81C8<SEP3>// <CJK>
0xE465<SEP>0x6746<SEP>0x81DA<SEP3>// <CJK>
0xE466<SEP>0x6747<SEP>0x81DF<SEP3>// <CJK>
0xE467<SEP>0x6748<SEP>0x81E0<SEP3>// <CJK>
0xE468<SEP>0x6749<SEP>0x81E7<SEP3>// <CJK>
0xE469<SEP>0x674A<SEP>0x81FA<SEP3>// <CJK>
0xE46A<SEP>0x674B<SEP>0x81FB<SEP3>// <CJK>
0xE46B<SEP>0x674C<SEP>0x81FE<SEP3>// <CJK>
0xE46C<SEP>0x674D<SEP>0x8201<SEP3>// <CJK>
0xE46D<SEP>0x674E<SEP>0x8202<SEP3>// <CJK>
0xE46E<SEP>0x674F<SEP>0x8205<SEP3>// <CJK>
0xE46F<SEP>0x6750<SEP>0x8207<SEP3>// <CJK>
0xE470<SEP>0x6751<SEP>0x820A<SEP3>// <CJK>
0xE471<SEP>0x6752<SEP>0x820D<SEP3>// <CJK>
0xE472<SEP>0x6753<SEP>0x8210<SEP3>// <CJK>
0xE473<SEP>0x6754<SEP>0x8216<SEP3>// <CJK>
0xE474<SEP>0x6755<SEP>0x8229<SEP3>// <CJK>
0xE475<SEP>0x6756<SEP>0x822B<SEP3>// <CJK>
0xE476<SEP>0x6757<SEP>0x8238<SEP3>// <CJK>
0xE477<SEP>0x6758<SEP>0x8233<SEP3>// <CJK>
0xE478<SEP>0x6759<SEP>0x8240<SEP3>// <CJK>
0xE479<SEP>0x675A<SEP>0x8259<SEP3>// <CJK>
0xE47A<SEP>0x675B<SEP>0x8258<SEP3>// <CJK>
0xE47B<SEP>0x675C<SEP>0x825D<SEP3>// <CJK>
0xE47C<SEP>0x675D<SEP>0x825A<SEP3>// <CJK>
0xE47D<SEP>0x675E<SEP>0x825F<SEP3>// <CJK>
0xE47E<SEP>0x675F<SEP>0x8264<SEP3>// <CJK>
0xE480<SEP>0x6760<SEP>0x8262<SEP3>// <CJK>
0xE481<SEP>0x6761<SEP>0x8268<SEP3>// <CJK>
0xE482<SEP>0x6762<SEP>0x826A<SEP3>// <CJK>
0xE483<SEP>0x6763<SEP>0x826B<SEP3>// <CJK>
0xE484<SEP>0x6764<SEP>0x822E<SEP3>// <CJK>
0xE485<SEP>0x6765<SEP>0x8271<SEP3>// <CJK>
0xE486<SEP>0x6766<SEP>0x8277<SEP3>// <CJK>
0xE487<SEP>0x6767<SEP>0x8278<SEP3>// <CJK>
0xE488<SEP>0x6768<SEP>0x827E<SEP3>// <CJK>
0xE489<SEP>0x6769<SEP>0x828D<SEP3>// <CJK>
0xE48A<SEP>0x676A<SEP>0x8292<SEP3>// <CJK>
0xE48B<SEP>0x676B<SEP>0x82AB<SEP3>// <CJK>
0xE48C<SEP>0x676C<SEP>0x829F<SEP3>// <CJK>
0xE48D<SEP>0x676D<SEP>0x82BB<SEP3>// <CJK>
0xE48E<SEP>0x676E<SEP>0x82AC<SEP3>// <CJK>
0xE48F<SEP>0x676F<SEP>0x82E1<SEP3>// <CJK>
0xE490<SEP>0x6770<SEP>0x82E3<SEP3>// <CJK>
0xE491<SEP>0x6771<SEP>0x82DF<SEP3>// <CJK>
0xE492<SEP>0x6772<SEP>0x82D2<SEP3>// <CJK>
0xE493<SEP>0x6773<SEP>0x82F4<SEP3>// <CJK>
0xE494<SEP>0x6774<SEP>0x82F3<SEP3>// <CJK>
0xE495<SEP>0x6775<SEP>0x82FA<SEP3>// <CJK>
0xE496<SEP>0x6776<SEP>0x8393<SEP3>// <CJK>
0xE497<SEP>0x6777<SEP>0x8303<SEP3>// <CJK>
0xE498<SEP>0x6778<SEP>0x82FB<SEP3>// <CJK>
0xE499<SEP>0x6779<SEP>0x82F9<SEP3>// <CJK>
0xE49A<SEP>0x677A<SEP>0x82DE<SEP3>// <CJK>
0xE49B<SEP>0x677B<SEP>0x8306<SEP3>// <CJK>
0xE49C<SEP>0x677C<SEP>0x82DC<SEP3>// <CJK>
0xE49D<SEP>0x677D<SEP>0x8309<SEP3>// <CJK>
0xE49E<SEP>0x677E<SEP>0x82D9<SEP3>// <CJK>
0xE49F<SEP>0x6821<SEP>0x8335<SEP3>// <CJK>
0xE4A0<SEP>0x6822<SEP>0x8334<SEP3>// <CJK>
0xE4A1<SEP>0x6823<SEP>0x8316<SEP3>// <CJK>
0xE4A2<SEP>0x6824<SEP>0x8332<SEP3>// <CJK>
0xE4A3<SEP>0x6825<SEP>0x8331<SEP3>// <CJK>
0xE4A4<SEP>0x6826<SEP>0x8340<SEP3>// <CJK>
0xE4A5<SEP>0x6827<SEP>0x8339<SEP3>// <CJK>
0xE4A6<SEP>0x6828<SEP>0x8350<SEP3>// <CJK>
0xE4A7<SEP>0x6829<SEP>0x8345<SEP3>// <CJK>
0xE4A8<SEP>0x682A<SEP>0x832F<SEP3>// <CJK>
0xE4A9<SEP>0x682B<SEP>0x832B<SEP3>// <CJK>
0xE4AA<SEP>0x682C<SEP>0x8317<SEP3>// <CJK>
0xE4AB<SEP>0x682D<SEP>0x8318<SEP3>// <CJK>
0xE4AC<SEP>0x682E<SEP>0x8385<SEP3>// <CJK>
0xE4AD<SEP>0x682F<SEP>0x839A<SEP3>// <CJK>
0xE4AE<SEP>0x6830<SEP>0x83AA<SEP3>// <CJK>
0xE4AF<SEP>0x6831<SEP>0x839F<SEP3>// <CJK>
0xE4B0<SEP>0x6832<SEP>0x83A2<SEP3>// <CJK>
0xE4B1<SEP>0x6833<SEP>0x8396<SEP3>// <CJK>
0xE4B2<SEP>0x6834<SEP>0x8323<SEP3>// <CJK>
0xE4B3<SEP>0x6835<SEP>0x838E<SEP3>// <CJK>
0xE4B4<SEP>0x6836<SEP>0x8387<SEP3>// <CJK>
0xE4B5<SEP>0x6837<SEP>0x838A<SEP3>// <CJK>
0xE4B6<SEP>0x6838<SEP>0x837C<SEP3>// <CJK>
0xE4B7<SEP>0x6839<SEP>0x83B5<SEP3>// <CJK>
0xE4B8<SEP>0x683A<SEP>0x8373<SEP3>// <CJK>
0xE4B9<SEP>0x683B<SEP>0x8375<SEP3>// <CJK>
0xE4BA<SEP>0x683C<SEP>0x83A0<SEP3>// <CJK>
0xE4BB<SEP>0x683D<SEP>0x8389<SEP3>// <CJK>
0xE4BC<SEP>0x683E<SEP>0x83A8<SEP3>// <CJK>
0xE4BD<SEP>0x683F<SEP>0x83F4<SEP3>// <CJK>
0xE4BE<SEP>0x6840<SEP>0x8413<SEP3>// <CJK>
0xE4BF<SEP>0x6841<SEP>0x83EB<SEP3>// <CJK>
0xE4C0<SEP>0x6842<SEP>0x83CE<SEP3>// <CJK>
0xE4C1<SEP>0x6843<SEP>0x83FD<SEP3>// <CJK>
0xE4C2<SEP>0x6844<SEP>0x8403<SEP3>// <CJK>
0xE4C3<SEP>0x6845<SEP>0x83D8<SEP3>// <CJK>
0xE4C4<SEP>0x6846<SEP>0x840B<SEP3>// <CJK>
0xE4C5<SEP>0x6847<SEP>0x83C1<SEP3>// <CJK>
0xE4C6<SEP>0x6848<SEP>0x83F7<SEP3>// <CJK>
0xE4C7<SEP>0x6849<SEP>0x8407<SEP3>// <CJK>
0xE4C8<SEP>0x684A<SEP>0x83E0<SEP3>// <CJK>
0xE4C9<SEP>0x684B<SEP>0x83F2<SEP3>// <CJK>
0xE4CA<SEP>0x684C<SEP>0x840D<SEP3>// <CJK>
0xE4CB<SEP>0x684D<SEP>0x8422<SEP3>// <CJK>
0xE4CC<SEP>0x684E<SEP>0x8420<SEP3>// <CJK>
0xE4CD<SEP>0x684F<SEP>0x83BD<SEP3>// <CJK>
0xE4CE<SEP>0x6850<SEP>0x8438<SEP3>// <CJK>
0xE4CF<SEP>0x6851<SEP>0x8506<SEP3>// <CJK>
0xE4D0<SEP>0x6852<SEP>0x83FB<SEP3>// <CJK>
0xE4D1<SEP>0x6853<SEP>0x846D<SEP3>// <CJK>
0xE4D2<SEP>0x6854<SEP>0x842A<SEP3>// <CJK>
0xE4D3<SEP>0x6855<SEP>0x843C<SEP3>// <CJK>
0xE4D4<SEP>0x6856<SEP>0x855A<SEP3>// <CJK>
0xE4D5<SEP>0x6857<SEP>0x8484<SEP3>// <CJK>
0xE4D6<SEP>0x6858<SEP>0x8477<SEP3>// <CJK>
0xE4D7<SEP>0x6859<SEP>0x846B<SEP3>// <CJK>
0xE4D8<SEP>0x685A<SEP>0x84AD<SEP3>// <CJK>
0xE4D9<SEP>0x685B<SEP>0x846E<SEP3>// <CJK>
0xE4DA<SEP>0x685C<SEP>0x8482<SEP3>// <CJK>
0xE4DB<SEP>0x685D<SEP>0x8469<SEP3>// <CJK>
0xE4DC<SEP>0x685E<SEP>0x8446<SEP3>// <CJK>
0xE4DD<SEP>0x685F<SEP>0x842C<SEP3>// <CJK>
0xE4DE<SEP>0x6860<SEP>0x846F<SEP3>// <CJK>
0xE4DF<SEP>0x6861<SEP>0x8479<SEP3>// <CJK>
0xE4E0<SEP>0x6862<SEP>0x8435<SEP3>// <CJK>
0xE4E1<SEP>0x6863<SEP>0x84CA<SEP3>// <CJK>
0xE4E2<SEP>0x6864<SEP>0x8462<SEP3>// <CJK>
0xE4E3<SEP>0x6865<SEP>0x84B9<SEP3>// <CJK>
0xE4E4<SEP>0x6866<SEP>0x84BF<SEP3>// <CJK>
0xE4E5<SEP>0x6867<SEP>0x849F<SEP3>// <CJK>
0xE4E6<SEP>0x6868<SEP>0x84D9<SEP3>// <CJK>
0xE4E7<SEP>0x6869<SEP>0x84CD<SEP3>// <CJK>
0xE4E8<SEP>0x686A<SEP>0x84BB<SEP3>// <CJK>
0xE4E9<SEP>0x686B<SEP>0x84DA<SEP3>// <CJK>
0xE4EA<SEP>0x686C<SEP>0x84D0<SEP3>// <CJK>
0xE4EB<SEP>0x686D<SEP>0x84C1<SEP3>// <CJK>
0xE4EC<SEP>0x686E<SEP>0x84C6<SEP3>// <CJK>
0xE4ED<SEP>0x686F<SEP>0x84D6<SEP3>// <CJK>
0xE4EE<SEP>0x6870<SEP>0x84A1<SEP3>// <CJK>
0xE4EF<SEP>0x6871<SEP>0x8521<SEP3>// <CJK>
0xE4F0<SEP>0x6872<SEP>0x84FF<SEP3>// <CJK>
0xE4F1<SEP>0x6873<SEP>0x84F4<SEP3>// <CJK>
0xE4F2<SEP>0x6874<SEP>0x8517<SEP3>// <CJK>
0xE4F3<SEP>0x6875<SEP>0x8518<SEP3>// <CJK>
0xE4F4<SEP>0x6876<SEP>0x852C<SEP3>// <CJK>
0xE4F5<SEP>0x6877<SEP>0x851F<SEP3>// <CJK>
0xE4F6<SEP>0x6878<SEP>0x8515<SEP3>// <CJK>
0xE4F7<SEP>0x6879<SEP>0x8514<SEP3>// <CJK>
0xE4F8<SEP>0x687A<SEP>0x84FC<SEP3>// <CJK>
0xE4F9<SEP>0x687B<SEP>0x8540<SEP3>// <CJK>
0xE4FA<SEP>0x687C<SEP>0x8563<SEP3>// <CJK>
0xE4FB<SEP>0x687D<SEP>0x8558<SEP3>// <CJK>
0xE4FC<SEP>0x687E<SEP>0x8548<SEP3>// <CJK>
0xE540<SEP>0x6921<SEP>0x8541<SEP3>// <CJK>
0xE541<SEP>0x6922<SEP>0x8602<SEP3>// <CJK>
0xE542<SEP>0x6923<SEP>0x854B<SEP3>// <CJK>
0xE543<SEP>0x6924<SEP>0x8555<SEP3>// <CJK>
0xE544<SEP>0x6925<SEP>0x8580<SEP3>// <CJK>
0xE545<SEP>0x6926<SEP>0x85A4<SEP3>// <CJK>
0xE546<SEP>0x6927<SEP>0x8588<SEP3>// <CJK>
0xE547<SEP>0x6928<SEP>0x8591<SEP3>// <CJK>
0xE548<SEP>0x6929<SEP>0x858A<SEP3>// <CJK>
0xE549<SEP>0x692A<SEP>0x85A8<SEP3>// <CJK>
0xE54A<SEP>0x692B<SEP>0x856D<SEP3>// <CJK>
0xE54B<SEP>0x692C<SEP>0x8594<SEP3>// <CJK>
0xE54C<SEP>0x692D<SEP>0x859B<SEP3>// <CJK>
0xE54D<SEP>0x692E<SEP>0x85EA<SEP3>// <CJK>
0xE54E<SEP>0x692F<SEP>0x8587<SEP3>// <CJK>
0xE54F<SEP>0x6930<SEP>0x859C<SEP3>// <CJK>
0xE550<SEP>0x6931<SEP>0x8577<SEP3>// <CJK>
0xE551<SEP>0x6932<SEP>0x857E<SEP3>// <CJK>
0xE552<SEP>0x6933<SEP>0x8590<SEP3>// <CJK>
0xE553<SEP>0x6934<SEP>0x85C9<SEP3>// <CJK>
0xE554<SEP>0x6935<SEP>0x85BA<SEP3>// <CJK>
0xE555<SEP>0x6936<SEP>0x85CF<SEP3>// <CJK>
0xE556<SEP>0x6937<SEP>0x85B9<SEP3>// <CJK>
0xE557<SEP>0x6938<SEP>0x85D0<SEP3>// <CJK>
0xE558<SEP>0x6939<SEP>0x85D5<SEP3>// <CJK>
0xE559<SEP>0x693A<SEP>0x85DD<SEP3>// <CJK>
0xE55A<SEP>0x693B<SEP>0x85E5<SEP3>// <CJK>
0xE55B<SEP>0x693C<SEP>0x85DC<SEP3>// <CJK>
0xE55C<SEP>0x693D<SEP>0x85F9<SEP3>// <CJK>
0xE55D<SEP>0x693E<SEP>0x860A<SEP3>// <CJK>
0xE55E<SEP>0x693F<SEP>0x8613<SEP3>// <CJK>
0xE55F<SEP>0x6940<SEP>0x860B<SEP3>// <CJK>
0xE560<SEP>0x6941<SEP>0x85FE<SEP3>// <CJK>
0xE561<SEP>0x6942<SEP>0x85FA<SEP3>// <CJK>
0xE562<SEP>0x6943<SEP>0x8606<SEP3>// <CJK>
0xE563<SEP>0x6944<SEP>0x8622<SEP3>// <CJK>
0xE564<SEP>0x6945<SEP>0x861A<SEP3>// <CJK>
0xE565<SEP>0x6946<SEP>0x8630<SEP3>// <CJK>
0xE566<SEP>0x6947<SEP>0x863F<SEP3>// <CJK>
0xE567<SEP>0x6948<SEP>0x864D<SEP3>// <CJK>
0xE568<SEP>0x6949<SEP>0x4E55<SEP3>// <CJK>
0xE569<SEP>0x694A<SEP>0x8654<SEP3>// <CJK>
0xE56A<SEP>0x694B<SEP>0x865F<SEP3>// <CJK>
0xE56B<SEP>0x694C<SEP>0x8667<SEP3>// <CJK>
0xE56C<SEP>0x694D<SEP>0x8671<SEP3>// <CJK>
0xE56D<SEP>0x694E<SEP>0x8693<SEP3>// <CJK>
0xE56E<SEP>0x694F<SEP>0x86A3<SEP3>// <CJK>
0xE56F<SEP>0x6950<SEP>0x86A9<SEP3>// <CJK>
0xE570<SEP>0x6951<SEP>0x86AA<SEP3>// <CJK>
0xE571<SEP>0x6952<SEP>0x868B<SEP3>// <CJK>
0xE572<SEP>0x6953<SEP>0x868C<SEP3>// <CJK>
0xE573<SEP>0x6954<SEP>0x86B6<SEP3>// <CJK>
0xE574<SEP>0x6955<SEP>0x86AF<SEP3>// <CJK>
0xE575<SEP>0x6956<SEP>0x86C4<SEP3>// <CJK>
0xE576<SEP>0x6957<SEP>0x86C6<SEP3>// <CJK>
0xE577<SEP>0x6958<SEP>0x86B0<SEP3>// <CJK>
0xE578<SEP>0x6959<SEP>0x86C9<SEP3>// <CJK>
0xE579<SEP>0x695A<SEP>0x8823<SEP3>// <CJK>
0xE57A<SEP>0x695B<SEP>0x86AB<SEP3>// <CJK>
0xE57B<SEP>0x695C<SEP>0x86D4<SEP3>// <CJK>
0xE57C<SEP>0x695D<SEP>0x86DE<SEP3>// <CJK>
0xE57D<SEP>0x695E<SEP>0x86E9<SEP3>// <CJK>
0xE57E<SEP>0x695F<SEP>0x86EC<SEP3>// <CJK>
0xE580<SEP>0x6960<SEP>0x86DF<SEP3>// <CJK>
0xE581<SEP>0x6961<SEP>0x86DB<SEP3>// <CJK>
0xE582<SEP>0x6962<SEP>0x86EF<SEP3>// <CJK>
0xE583<SEP>0x6963<SEP>0x8712<SEP3>// <CJK>
0xE584<SEP>0x6964<SEP>0x8706<SEP3>// <CJK>
0xE585<SEP>0x6965<SEP>0x8708<SEP3>// <CJK>
0xE586<SEP>0x6966<SEP>0x8700<SEP3>// <CJK>
0xE587<SEP>0x6967<SEP>0x8703<SEP3>// <CJK>
0xE588<SEP>0x6968<SEP>0x86FB<SEP3>// <CJK>
0xE589<SEP>0x6969<SEP>0x8711<SEP3>// <CJK>
0xE58A<SEP>0x696A<SEP>0x8709<SEP3>// <CJK>
0xE58B<SEP>0x696B<SEP>0x870D<SEP3>// <CJK>
0xE58C<SEP>0x696C<SEP>0x86F9<SEP3>// <CJK>
0xE58D<SEP>0x696D<SEP>0x870A<SEP3>// <CJK>
0xE58E<SEP>0x696E<SEP>0x8734<SEP3>// <CJK>
0xE58F<SEP>0x696F<SEP>0x873F<SEP3>// <CJK>
0xE590<SEP>0x6970<SEP>0x8737<SEP3>// <CJK>
0xE591<SEP>0x6971<SEP>0x873B<SEP3>// <CJK>
0xE592<SEP>0x6972<SEP>0x8725<SEP3>// <CJK>
0xE593<SEP>0x6973<SEP>0x8729<SEP3>// <CJK>
0xE594<SEP>0x6974<SEP>0x871A<SEP3>// <CJK>
0xE595<SEP>0x6975<SEP>0x8760<SEP3>// <CJK>
0xE596<SEP>0x6976<SEP>0x875F<SEP3>// <CJK>
0xE597<SEP>0x6977<SEP>0x8778<SEP3>// <CJK>
0xE598<SEP>0x6978<SEP>0x874C<SEP3>// <CJK>
0xE599<SEP>0x6979<SEP>0x874E<SEP3>// <CJK>
0xE59A<SEP>0x697A<SEP>0x8774<SEP3>// <CJK>
0xE59B<SEP>0x697B<SEP>0x8757<SEP3>// <CJK>
0xE59C<SEP>0x697C<SEP>0x8768<SEP3>// <CJK>
0xE59D<SEP>0x697D<SEP>0x876E<SEP3>// <CJK>
0xE59E<SEP>0x697E<SEP>0x8759<SEP3>// <CJK>
0xE59F<SEP>0x6A21<SEP>0x8753<SEP3>// <CJK>
0xE5A0<SEP>0x6A22<SEP>0x8763<SEP3>// <CJK>
0xE5A1<SEP>0x6A23<SEP>0x876A<SEP3>// <CJK>
0xE5A2<SEP>0x6A24<SEP>0x8805<SEP3>// <CJK>
0xE5A3<SEP>0x6A25<SEP>0x87A2<SEP3>// <CJK>
0xE5A4<SEP>0x6A26<SEP>0x879F<SEP3>// <CJK>
0xE5A5<SEP>0x6A27<SEP>0x8782<SEP3>// <CJK>
0xE5A6<SEP>0x6A28<SEP>0x87AF<SEP3>// <CJK>
0xE5A7<SEP>0x6A29<SEP>0x87CB<SEP3>// <CJK>
0xE5A8<SEP>0x6A2A<SEP>0x87BD<SEP3>// <CJK>
0xE5A9<SEP>0x6A2B<SEP>0x87C0<SEP3>// <CJK>
0xE5AA<SEP>0x6A2C<SEP>0x87D0<SEP3>// <CJK>
0xE5AB<SEP>0x6A2D<SEP>0x96D6<SEP3>// <CJK>
0xE5AC<SEP>0x6A2E<SEP>0x87AB<SEP3>// <CJK>
0xE5AD<SEP>0x6A2F<SEP>0x87C4<SEP3>// <CJK>
0xE5AE<SEP>0x6A30<SEP>0x87B3<SEP3>// <CJK>
0xE5AF<SEP>0x6A31<SEP>0x87C7<SEP3>// <CJK>
0xE5B0<SEP>0x6A32<SEP>0x87C6<SEP3>// <CJK>
0xE5B1<SEP>0x6A33<SEP>0x87BB<SEP3>// <CJK>
0xE5B2<SEP>0x6A34<SEP>0x87EF<SEP3>// <CJK>
0xE5B3<SEP>0x6A35<SEP>0x87F2<SEP3>// <CJK>
0xE5B4<SEP>0x6A36<SEP>0x87E0<SEP3>// <CJK>
0xE5B5<SEP>0x6A37<SEP>0x880F<SEP3>// <CJK>
0xE5B6<SEP>0x6A38<SEP>0x880D<SEP3>// <CJK>
0xE5B7<SEP>0x6A39<SEP>0x87FE<SEP3>// <CJK>
0xE5B8<SEP>0x6A3A<SEP>0x87F6<SEP3>// <CJK>
0xE5B9<SEP>0x6A3B<SEP>0x87F7<SEP3>// <CJK>
0xE5BA<SEP>0x6A3C<SEP>0x880E<SEP3>// <CJK>
0xE5BB<SEP>0x6A3D<SEP>0x87D2<SEP3>// <CJK>
0xE5BC<SEP>0x6A3E<SEP>0x8811<SEP3>// <CJK>
0xE5BD<SEP>0x6A3F<SEP>0x8816<SEP3>// <CJK>
0xE5BE<SEP>0x6A40<SEP>0x8815<SEP3>// <CJK>
0xE5BF<SEP>0x6A41<SEP>0x8822<SEP3>// <CJK>
0xE5C0<SEP>0x6A42<SEP>0x8821<SEP3>// <CJK>
0xE5C1<SEP>0x6A43<SEP>0x8831<SEP3>// <CJK>
0xE5C2<SEP>0x6A44<SEP>0x8836<SEP3>// <CJK>
0xE5C3<SEP>0x6A45<SEP>0x8839<SEP3>// <CJK>
0xE5C4<SEP>0x6A46<SEP>0x8827<SEP3>// <CJK>
0xE5C5<SEP>0x6A47<SEP>0x883B<SEP3>// <CJK>
0xE5C6<SEP>0x6A48<SEP>0x8844<SEP3>// <CJK>
0xE5C7<SEP>0x6A49<SEP>0x8842<SEP3>// <CJK>
0xE5C8<SEP>0x6A4A<SEP>0x8852<SEP3>// <CJK>
0xE5C9<SEP>0x6A4B<SEP>0x8859<SEP3>// <CJK>
0xE5CA<SEP>0x6A4C<SEP>0x885E<SEP3>// <CJK>
0xE5CB<SEP>0x6A4D<SEP>0x8862<SEP3>// <CJK>
0xE5CC<SEP>0x6A4E<SEP>0x886B<SEP3>// <CJK>
0xE5CD<SEP>0x6A4F<SEP>0x8881<SEP3>// <CJK>
0xE5CE<SEP>0x6A50<SEP>0x887E<SEP3>// <CJK>
0xE5CF<SEP>0x6A51<SEP>0x889E<SEP3>// <CJK>
0xE5D0<SEP>0x6A52<SEP>0x8875<SEP3>// <CJK>
0xE5D1<SEP>0x6A53<SEP>0x887D<SEP3>// <CJK>
0xE5D2<SEP>0x6A54<SEP>0x88B5<SEP3>// <CJK>
0xE5D3<SEP>0x6A55<SEP>0x8872<SEP3>// <CJK>
0xE5D4<SEP>0x6A56<SEP>0x8882<SEP3>// <CJK>
0xE5D5<SEP>0x6A57<SEP>0x8897<SEP3>// <CJK>
0xE5D6<SEP>0x6A58<SEP>0x8892<SEP3>// <CJK>
0xE5D7<SEP>0x6A59<SEP>0x88AE<SEP3>// <CJK>
0xE5D8<SEP>0x6A5A<SEP>0x8899<SEP3>// <CJK>
0xE5D9<SEP>0x6A5B<SEP>0x88A2<SEP3>// <CJK>
0xE5DA<SEP>0x6A5C<SEP>0x888D<SEP3>// <CJK>
0xE5DB<SEP>0x6A5D<SEP>0x88A4<SEP3>// <CJK>
0xE5DC<SEP>0x6A5E<SEP>0x88B0<SEP3>// <CJK>
0xE5DD<SEP>0x6A5F<SEP>0x88BF<SEP3>// <CJK>
0xE5DE<SEP>0x6A60<SEP>0x88B1<SEP3>// <CJK>
0xE5DF<SEP>0x6A61<SEP>0x88C3<SEP3>// <CJK>
0xE5E0<SEP>0x6A62<SEP>0x88C4<SEP3>// <CJK>
0xE5E1<SEP>0x6A63<SEP>0x88D4<SEP3>// <CJK>
0xE5E2<SEP>0x6A64<SEP>0x88D8<SEP3>// <CJK>
0xE5E3<SEP>0x6A65<SEP>0x88D9<SEP3>// <CJK>
0xE5E4<SEP>0x6A66<SEP>0x88DD<SEP3>// <CJK>
0xE5E5<SEP>0x6A67<SEP>0x88F9<SEP3>// <CJK>
0xE5E6<SEP>0x6A68<SEP>0x8902<SEP3>// <CJK>
0xE5E7<SEP>0x6A69<SEP>0x88FC<SEP3>// <CJK>
0xE5E8<SEP>0x6A6A<SEP>0x88F4<SEP3>// <CJK>
0xE5E9<SEP>0x6A6B<SEP>0x88E8<SEP3>// <CJK>
0xE5EA<SEP>0x6A6C<SEP>0x88F2<SEP3>// <CJK>
0xE5EB<SEP>0x6A6D<SEP>0x8904<SEP3>// <CJK>
0xE5EC<SEP>0x6A6E<SEP>0x890C<SEP3>// <CJK>
0xE5ED<SEP>0x6A6F<SEP>0x890A<SEP3>// <CJK>
0xE5EE<SEP>0x6A70<SEP>0x8913<SEP3>// <CJK>
0xE5EF<SEP>0x6A71<SEP>0x8943<SEP3>// <CJK>
0xE5F0<SEP>0x6A72<SEP>0x891E<SEP3>// <CJK>
0xE5F1<SEP>0x6A73<SEP>0x8925<SEP3>// <CJK>
0xE5F2<SEP>0x6A74<SEP>0x892A<SEP3>// <CJK>
0xE5F3<SEP>0x6A75<SEP>0x892B<SEP3>// <CJK>
0xE5F4<SEP>0x6A76<SEP>0x8941<SEP3>// <CJK>
0xE5F5<SEP>0x6A77<SEP>0x8944<SEP3>// <CJK>
0xE5F6<SEP>0x6A78<SEP>0x893B<SEP3>// <CJK>
0xE5F7<SEP>0x6A79<SEP>0x8936<SEP3>// <CJK>
0xE5F8<SEP>0x6A7A<SEP>0x8938<SEP3>// <CJK>
0xE5F9<SEP>0x6A7B<SEP>0x894C<SEP3>// <CJK>
0xE5FA<SEP>0x6A7C<SEP>0x891D<SEP3>// <CJK>
0xE5FB<SEP>0x6A7D<SEP>0x8960<SEP3>// <CJK>
0xE5FC<SEP>0x6A7E<SEP>0x895E<SEP3>// <CJK>
0xE640<SEP>0x6B21<SEP>0x8966<SEP3>// <CJK>
0xE641<SEP>0x6B22<SEP>0x8964<SEP3>// <CJK>
0xE642<SEP>0x6B23<SEP>0x896D<SEP3>// <CJK>
0xE643<SEP>0x6B24<SEP>0x896A<SEP3>// <CJK>
0xE644<SEP>0x6B25<SEP>0x896F<SEP3>// <CJK>
0xE645<SEP>0x6B26<SEP>0x8974<SEP3>// <CJK>
0xE646<SEP>0x6B27<SEP>0x8977<SEP3>// <CJK>
0xE647<SEP>0x6B28<SEP>0x897E<SEP3>// <CJK>
0xE648<SEP>0x6B29<SEP>0x8983<SEP3>// <CJK>
0xE649<SEP>0x6B2A<SEP>0x8988<SEP3>// <CJK>
0xE64A<SEP>0x6B2B<SEP>0x898A<SEP3>// <CJK>
0xE64B<SEP>0x6B2C<SEP>0x8993<SEP3>// <CJK>
0xE64C<SEP>0x6B2D<SEP>0x8998<SEP3>// <CJK>
0xE64D<SEP>0x6B2E<SEP>0x89A1<SEP3>// <CJK>
0xE64E<SEP>0x6B2F<SEP>0x89A9<SEP3>// <CJK>
0xE64F<SEP>0x6B30<SEP>0x89A6<SEP3>// <CJK>
0xE650<SEP>0x6B31<SEP>0x89AC<SEP3>// <CJK>
0xE651<SEP>0x6B32<SEP>0x89AF<SEP3>// <CJK>
0xE652<SEP>0x6B33<SEP>0x89B2<SEP3>// <CJK>
0xE653<SEP>0x6B34<SEP>0x89BA<SEP3>// <CJK>
0xE654<SEP>0x6B35<SEP>0x89BD<SEP3>// <CJK>
0xE655<SEP>0x6B36<SEP>0x89BF<SEP3>// <CJK>
0xE656<SEP>0x6B37<SEP>0x89C0<SEP3>// <CJK>
0xE657<SEP>0x6B38<SEP>0x89DA<SEP3>// <CJK>
0xE658<SEP>0x6B39<SEP>0x89DC<SEP3>// <CJK>
0xE659<SEP>0x6B3A<SEP>0x89DD<SEP3>// <CJK>
0xE65A<SEP>0x6B3B<SEP>0x89E7<SEP3>// <CJK>
0xE65B<SEP>0x6B3C<SEP>0x89F4<SEP3>// <CJK>
0xE65C<SEP>0x6B3D<SEP>0x89F8<SEP3>// <CJK>
0xE65D<SEP>0x6B3E<SEP>0x8A03<SEP3>// <CJK>
0xE65E<SEP>0x6B3F<SEP>0x8A16<SEP3>// <CJK>
0xE65F<SEP>0x6B40<SEP>0x8A10<SEP3>// <CJK>
0xE660<SEP>0x6B41<SEP>0x8A0C<SEP3>// <CJK>
0xE661<SEP>0x6B42<SEP>0x8A1B<SEP3>// <CJK>
0xE662<SEP>0x6B43<SEP>0x8A1D<SEP3>// <CJK>
0xE663<SEP>0x6B44<SEP>0x8A25<SEP3>// <CJK>
0xE664<SEP>0x6B45<SEP>0x8A36<SEP3>// <CJK>
0xE665<SEP>0x6B46<SEP>0x8A41<SEP3>// <CJK>
0xE666<SEP>0x6B47<SEP>0x8A5B<SEP3>// <CJK>
0xE667<SEP>0x6B48<SEP>0x8A52<SEP3>// <CJK>
0xE668<SEP>0x6B49<SEP>0x8A46<SEP3>// <CJK>
0xE669<SEP>0x6B4A<SEP>0x8A48<SEP3>// <CJK>
0xE66A<SEP>0x6B4B<SEP>0x8A7C<SEP3>// <CJK>
0xE66B<SEP>0x6B4C<SEP>0x8A6D<SEP3>// <CJK>
0xE66C<SEP>0x6B4D<SEP>0x8A6C<SEP3>// <CJK>
0xE66D<SEP>0x6B4E<SEP>0x8A62<SEP3>// <CJK>
0xE66E<SEP>0x6B4F<SEP>0x8A85<SEP3>// <CJK>
0xE66F<SEP>0x6B50<SEP>0x8A82<SEP3>// <CJK>
0xE670<SEP>0x6B51<SEP>0x8A84<SEP3>// <CJK>
0xE671<SEP>0x6B52<SEP>0x8AA8<SEP3>// <CJK>
0xE672<SEP>0x6B53<SEP>0x8AA1<SEP3>// <CJK>
0xE673<SEP>0x6B54<SEP>0x8A91<SEP3>// <CJK>
0xE674<SEP>0x6B55<SEP>0x8AA5<SEP3>// <CJK>
0xE675<SEP>0x6B56<SEP>0x8AA6<SEP3>// <CJK>
0xE676<SEP>0x6B57<SEP>0x8A9A<SEP3>// <CJK>
0xE677<SEP>0x6B58<SEP>0x8AA3<SEP3>// <CJK>
0xE678<SEP>0x6B59<SEP>0x8AC4<SEP3>// <CJK>
0xE679<SEP>0x6B5A<SEP>0x8ACD<SEP3>// <CJK>
0xE67A<SEP>0x6B5B<SEP>0x8AC2<SEP3>// <CJK>
0xE67B<SEP>0x6B5C<SEP>0x8ADA<SEP3>// <CJK>
0xE67C<SEP>0x6B5D<SEP>0x8AEB<SEP3>// <CJK>
0xE67D<SEP>0x6B5E<SEP>0x8AF3<SEP3>// <CJK>
0xE67E<SEP>0x6B5F<SEP>0x8AE7<SEP3>// <CJK>
0xE680<SEP>0x6B60<SEP>0x8AE4<SEP3>// <CJK>
0xE681<SEP>0x6B61<SEP>0x8AF1<SEP3>// <CJK>
0xE682<SEP>0x6B62<SEP>0x8B14<SEP3>// <CJK>
0xE683<SEP>0x6B63<SEP>0x8AE0<SEP3>// <CJK>
0xE684<SEP>0x6B64<SEP>0x8AE2<SEP3>// <CJK>
0xE685<SEP>0x6B65<SEP>0x8AF7<SEP3>// <CJK>
0xE686<SEP>0x6B66<SEP>0x8ADE<SEP3>// <CJK>
0xE687<SEP>0x6B67<SEP>0x8ADB<SEP3>// <CJK>
0xE688<SEP>0x6B68<SEP>0x8B0C<SEP3>// <CJK>
0xE689<SEP>0x6B69<SEP>0x8B07<SEP3>// <CJK>
0xE68A<SEP>0x6B6A<SEP>0x8B1A<SEP3>// <CJK>
0xE68B<SEP>0x6B6B<SEP>0x8AE1<SEP3>// <CJK>
0xE68C<SEP>0x6B6C<SEP>0x8B16<SEP3>// <CJK>
0xE68D<SEP>0x6B6D<SEP>0x8B10<SEP3>// <CJK>
0xE68E<SEP>0x6B6E<SEP>0x8B17<SEP3>// <CJK>
0xE68F<SEP>0x6B6F<SEP>0x8B20<SEP3>// <CJK>
0xE690<SEP>0x6B70<SEP>0x8B33<SEP3>// <CJK>
0xE691<SEP>0x6B71<SEP>0x97AB<SEP3>// <CJK>
0xE692<SEP>0x6B72<SEP>0x8B26<SEP3>// <CJK>
0xE693<SEP>0x6B73<SEP>0x8B2B<SEP3>// <CJK>
0xE694<SEP>0x6B74<SEP>0x8B3E<SEP3>// <CJK>
0xE695<SEP>0x6B75<SEP>0x8B28<SEP3>// <CJK>
0xE696<SEP>0x6B76<SEP>0x8B41<SEP3>// <CJK>
0xE697<SEP>0x6B77<SEP>0x8B4C<SEP3>// <CJK>
0xE698<SEP>0x6B78<SEP>0x8B4F<SEP3>// <CJK>
0xE699<SEP>0x6B79<SEP>0x8B4E<SEP3>// <CJK>
0xE69A<SEP>0x6B7A<SEP>0x8B49<SEP3>// <CJK>
0xE69B<SEP>0x6B7B<SEP>0x8B56<SEP3>// <CJK>
0xE69C<SEP>0x6B7C<SEP>0x8B5B<SEP3>// <CJK>
0xE69D<SEP>0x6B7D<SEP>0x8B5A<SEP3>// <CJK>
0xE69E<SEP>0x6B7E<SEP>0x8B6B<SEP3>// <CJK>
0xE69F<SEP>0x6C21<SEP>0x8B5F<SEP3>// <CJK>
0xE6A0<SEP>0x6C22<SEP>0x8B6C<SEP3>// <CJK>
0xE6A1<SEP>0x6C23<SEP>0x8B6F<SEP3>// <CJK>
0xE6A2<SEP>0x6C24<SEP>0x8B74<SEP3>// <CJK>
0xE6A3<SEP>0x6C25<SEP>0x8B7D<SEP3>// <CJK>
0xE6A4<SEP>0x6C26<SEP>0x8B80<SEP3>// <CJK>
0xE6A5<SEP>0x6C27<SEP>0x8B8C<SEP3>// <CJK>
0xE6A6<SEP>0x6C28<SEP>0x8B8E<SEP3>// <CJK>
0xE6A7<SEP>0x6C29<SEP>0x8B92<SEP3>// <CJK>
0xE6A8<SEP>0x6C2A<SEP>0x8B93<SEP3>// <CJK>
0xE6A9<SEP>0x6C2B<SEP>0x8B96<SEP3>// <CJK>
0xE6AA<SEP>0x6C2C<SEP>0x8B99<SEP3>// <CJK>
0xE6AB<SEP>0x6C2D<SEP>0x8B9A<SEP3>// <CJK>
0xE6AC<SEP>0x6C2E<SEP>0x8C3A<SEP3>// <CJK>
0xE6AD<SEP>0x6C2F<SEP>0x8C41<SEP3>// <CJK>
0xE6AE<SEP>0x6C30<SEP>0x8C3F<SEP3>// <CJK>
0xE6AF<SEP>0x6C31<SEP>0x8C48<SEP3>// <CJK>
0xE6B0<SEP>0x6C32<SEP>0x8C4C<SEP3>// <CJK>
0xE6B1<SEP>0x6C33<SEP>0x8C4E<SEP3>// <CJK>
0xE6B2<SEP>0x6C34<SEP>0x8C50<SEP3>// <CJK>
0xE6B3<SEP>0x6C35<SEP>0x8C55<SEP3>// <CJK>
0xE6B4<SEP>0x6C36<SEP>0x8C62<SEP3>// <CJK>
0xE6B5<SEP>0x6C37<SEP>0x8C6C<SEP3>// <CJK>
0xE6B6<SEP>0x6C38<SEP>0x8C78<SEP3>// <CJK>
0xE6B7<SEP>0x6C39<SEP>0x8C7A<SEP3>// <CJK>
0xE6B8<SEP>0x6C3A<SEP>0x8C82<SEP3>// <CJK>
0xE6B9<SEP>0x6C3B<SEP>0x8C89<SEP3>// <CJK>
0xE6BA<SEP>0x6C3C<SEP>0x8C85<SEP3>// <CJK>
0xE6BB<SEP>0x6C3D<SEP>0x8C8A<SEP3>// <CJK>
0xE6BC<SEP>0x6C3E<SEP>0x8C8D<SEP3>// <CJK>
0xE6BD<SEP>0x6C3F<SEP>0x8C8E<SEP3>// <CJK>
0xE6BE<SEP>0x6C40<SEP>0x8C94<SEP3>// <CJK>
0xE6BF<SEP>0x6C41<SEP>0x8C7C<SEP3>// <CJK>
0xE6C0<SEP>0x6C42<SEP>0x8C98<SEP3>// <CJK>
0xE6C1<SEP>0x6C43<SEP>0x621D<SEP3>// <CJK>
0xE6C2<SEP>0x6C44<SEP>0x8CAD<SEP3>// <CJK>
0xE6C3<SEP>0x6C45<SEP>0x8CAA<SEP3>// <CJK>
0xE6C4<SEP>0x6C46<SEP>0x8CBD<SEP3>// <CJK>
0xE6C5<SEP>0x6C47<SEP>0x8CB2<SEP3>// <CJK>
0xE6C6<SEP>0x6C48<SEP>0x8CB3<SEP3>// <CJK>
0xE6C7<SEP>0x6C49<SEP>0x8CAE<SEP3>// <CJK>
0xE6C8<SEP>0x6C4A<SEP>0x8CB6<SEP3>// <CJK>
0xE6C9<SEP>0x6C4B<SEP>0x8CC8<SEP3>// <CJK>
0xE6CA<SEP>0x6C4C<SEP>0x8CC1<SEP3>// <CJK>
0xE6CB<SEP>0x6C4D<SEP>0x8CE4<SEP3>// <CJK>
0xE6CC<SEP>0x6C4E<SEP>0x8CE3<SEP3>// <CJK>
0xE6CD<SEP>0x6C4F<SEP>0x8CDA<SEP3>// <CJK>
0xE6CE<SEP>0x6C50<SEP>0x8CFD<SEP3>// <CJK>
0xE6CF<SEP>0x6C51<SEP>0x8CFA<SEP3>// <CJK>
0xE6D0<SEP>0x6C52<SEP>0x8CFB<SEP3>// <CJK>
0xE6D1<SEP>0x6C53<SEP>0x8D04<SEP3>// <CJK>
0xE6D2<SEP>0x6C54<SEP>0x8D05<SEP3>// <CJK>
0xE6D3<SEP>0x6C55<SEP>0x8D0A<SEP3>// <CJK>
0xE6D4<SEP>0x6C56<SEP>0x8D07<SEP3>// <CJK>
0xE6D5<SEP>0x6C57<SEP>0x8D0F<SEP3>// <CJK>
0xE6D6<SEP>0x6C58<SEP>0x8D0D<SEP3>// <CJK>
0xE6D7<SEP>0x6C59<SEP>0x8D10<SEP3>// <CJK>
0xE6D8<SEP>0x6C5A<SEP>0x9F4E<SEP3>// <CJK>
0xE6D9<SEP>0x6C5B<SEP>0x8D13<SEP3>// <CJK>
0xE6DA<SEP>0x6C5C<SEP>0x8CCD<SEP3>// <CJK>
0xE6DB<SEP>0x6C5D<SEP>0x8D14<SEP3>// <CJK>
0xE6DC<SEP>0x6C5E<SEP>0x8D16<SEP3>// <CJK>
0xE6DD<SEP>0x6C5F<SEP>0x8D67<SEP3>// <CJK>
0xE6DE<SEP>0x6C60<SEP>0x8D6D<SEP3>// <CJK>
0xE6DF<SEP>0x6C61<SEP>0x8D71<SEP3>// <CJK>
0xE6E0<SEP>0x6C62<SEP>0x8D73<SEP3>// <CJK>
0xE6E1<SEP>0x6C63<SEP>0x8D81<SEP3>// <CJK>
0xE6E2<SEP>0x6C64<SEP>0x8D99<SEP3>// <CJK>
0xE6E3<SEP>0x6C65<SEP>0x8DC2<SEP3>// <CJK>
0xE6E4<SEP>0x6C66<SEP>0x8DBE<SEP3>// <CJK>
0xE6E5<SEP>0x6C67<SEP>0x8DBA<SEP3>// <CJK>
0xE6E6<SEP>0x6C68<SEP>0x8DCF<SEP3>// <CJK>
0xE6E7<SEP>0x6C69<SEP>0x8DDA<SEP3>// <CJK>
0xE6E8<SEP>0x6C6A<SEP>0x8DD6<SEP3>// <CJK>
0xE6E9<SEP>0x6C6B<SEP>0x8DCC<SEP3>// <CJK>
0xE6EA<SEP>0x6C6C<SEP>0x8DDB<SEP3>// <CJK>
0xE6EB<SEP>0x6C6D<SEP>0x8DCB<SEP3>// <CJK>
0xE6EC<SEP>0x6C6E<SEP>0x8DEA<SEP3>// <CJK>
0xE6ED<SEP>0x6C6F<SEP>0x8DEB<SEP3>// <CJK>
0xE6EE<SEP>0x6C70<SEP>0x8DDF<SEP3>// <CJK>
0xE6EF<SEP>0x6C71<SEP>0x8DE3<SEP3>// <CJK>
0xE6F0<SEP>0x6C72<SEP>0x8DFC<SEP3>// <CJK>
0xE6F1<SEP>0x6C73<SEP>0x8E08<SEP3>// <CJK>
0xE6F2<SEP>0x6C74<SEP>0x8E09<SEP3>// <CJK>
0xE6F3<SEP>0x6C75<SEP>0x8DFF<SEP3>// <CJK>
0xE6F4<SEP>0x6C76<SEP>0x8E1D<SEP3>// <CJK>
0xE6F5<SEP>0x6C77<SEP>0x8E1E<SEP3>// <CJK>
0xE6F6<SEP>0x6C78<SEP>0x8E10<SEP3>// <CJK>
0xE6F7<SEP>0x6C79<SEP>0x8E1F<SEP3>// <CJK>
0xE6F8<SEP>0x6C7A<SEP>0x8E42<SEP3>// <CJK>
0xE6F9<SEP>0x6C7B<SEP>0x8E35<SEP3>// <CJK>
0xE6FA<SEP>0x6C7C<SEP>0x8E30<SEP3>// <CJK>
0xE6FB<SEP>0x6C7D<SEP>0x8E34<SEP3>// <CJK>
0xE6FC<SEP>0x6C7E<SEP>0x8E4A<SEP3>// <CJK>
0xE740<SEP>0x6D21<SEP>0x8E47<SEP3>// <CJK>
0xE741<SEP>0x6D22<SEP>0x8E49<SEP3>// <CJK>
0xE742<SEP>0x6D23<SEP>0x8E4C<SEP3>// <CJK>
0xE743<SEP>0x6D24<SEP>0x8E50<SEP3>// <CJK>
0xE744<SEP>0x6D25<SEP>0x8E48<SEP3>// <CJK>
0xE745<SEP>0x6D26<SEP>0x8E59<SEP3>// <CJK>
0xE746<SEP>0x6D27<SEP>0x8E64<SEP3>// <CJK>
0xE747<SEP>0x6D28<SEP>0x8E60<SEP3>// <CJK>
0xE748<SEP>0x6D29<SEP>0x8E2A<SEP3>// <CJK>
0xE749<SEP>0x6D2A<SEP>0x8E63<SEP3>// <CJK>
0xE74A<SEP>0x6D2B<SEP>0x8E55<SEP3>// <CJK>
0xE74B<SEP>0x6D2C<SEP>0x8E76<SEP3>// <CJK>
0xE74C<SEP>0x6D2D<SEP>0x8E72<SEP3>// <CJK>
0xE74D<SEP>0x6D2E<SEP>0x8E7C<SEP3>// <CJK>
0xE74E<SEP>0x6D2F<SEP>0x8E81<SEP3>// <CJK>
0xE74F<SEP>0x6D30<SEP>0x8E87<SEP3>// <CJK>
0xE750<SEP>0x6D31<SEP>0x8E85<SEP3>// <CJK>
0xE751<SEP>0x6D32<SEP>0x8E84<SEP3>// <CJK>
0xE752<SEP>0x6D33<SEP>0x8E8B<SEP3>// <CJK>
0xE753<SEP>0x6D34<SEP>0x8E8A<SEP3>// <CJK>
0xE754<SEP>0x6D35<SEP>0x8E93<SEP3>// <CJK>
0xE755<SEP>0x6D36<SEP>0x8E91<SEP3>// <CJK>
0xE756<SEP>0x6D37<SEP>0x8E94<SEP3>// <CJK>
0xE757<SEP>0x6D38<SEP>0x8E99<SEP3>// <CJK>
0xE758<SEP>0x6D39<SEP>0x8EAA<SEP3>// <CJK>
0xE759<SEP>0x6D3A<SEP>0x8EA1<SEP3>// <CJK>
0xE75A<SEP>0x6D3B<SEP>0x8EAC<SEP3>// <CJK>
0xE75B<SEP>0x6D3C<SEP>0x8EB0<SEP3>// <CJK>
0xE75C<SEP>0x6D3D<SEP>0x8EC6<SEP3>// <CJK>
0xE75D<SEP>0x6D3E<SEP>0x8EB1<SEP3>// <CJK>
0xE75E<SEP>0x6D3F<SEP>0x8EBE<SEP3>// <CJK>
0xE75F<SEP>0x6D40<SEP>0x8EC5<SEP3>// <CJK>
0xE760<SEP>0x6D41<SEP>0x8EC8<SEP3>// <CJK>
0xE761<SEP>0x6D42<SEP>0x8ECB<SEP3>// <CJK>
0xE762<SEP>0x6D43<SEP>0x8EDB<SEP3>// <CJK>
0xE763<SEP>0x6D44<SEP>0x8EE3<SEP3>// <CJK>
0xE764<SEP>0x6D45<SEP>0x8EFC<SEP3>// <CJK>
0xE765<SEP>0x6D46<SEP>0x8EFB<SEP3>// <CJK>
0xE766<SEP>0x6D47<SEP>0x8EEB<SEP3>// <CJK>
0xE767<SEP>0x6D48<SEP>0x8EFE<SEP3>// <CJK>
0xE768<SEP>0x6D49<SEP>0x8F0A<SEP3>// <CJK>
0xE769<SEP>0x6D4A<SEP>0x8F05<SEP3>// <CJK>
0xE76A<SEP>0x6D4B<SEP>0x8F15<SEP3>// <CJK>
0xE76B<SEP>0x6D4C<SEP>0x8F12<SEP3>// <CJK>
0xE76C<SEP>0x6D4D<SEP>0x8F19<SEP3>// <CJK>
0xE76D<SEP>0x6D4E<SEP>0x8F13<SEP3>// <CJK>
0xE76E<SEP>0x6D4F<SEP>0x8F1C<SEP3>// <CJK>
0xE76F<SEP>0x6D50<SEP>0x8F1F<SEP3>// <CJK>
0xE770<SEP>0x6D51<SEP>0x8F1B<SEP3>// <CJK>
0xE771<SEP>0x6D52<SEP>0x8F0C<SEP3>// <CJK>
0xE772<SEP>0x6D53<SEP>0x8F26<SEP3>// <CJK>
0xE773<SEP>0x6D54<SEP>0x8F33<SEP3>// <CJK>
0xE774<SEP>0x6D55<SEP>0x8F3B<SEP3>// <CJK>
0xE775<SEP>0x6D56<SEP>0x8F39<SEP3>// <CJK>
0xE776<SEP>0x6D57<SEP>0x8F45<SEP3>// <CJK>
0xE777<SEP>0x6D58<SEP>0x8F42<SEP3>// <CJK>
0xE778<SEP>0x6D59<SEP>0x8F3E<SEP3>// <CJK>
0xE779<SEP>0x6D5A<SEP>0x8F4C<SEP3>// <CJK>
0xE77A<SEP>0x6D5B<SEP>0x8F49<SEP3>// <CJK>
0xE77B<SEP>0x6D5C<SEP>0x8F46<SEP3>// <CJK>
0xE77C<SEP>0x6D5D<SEP>0x8F4E<SEP3>// <CJK>
0xE77D<SEP>0x6D5E<SEP>0x8F57<SEP3>// <CJK>
0xE77E<SEP>0x6D5F<SEP>0x8F5C<SEP3>// <CJK>
0xE780<SEP>0x6D60<SEP>0x8F62<SEP3>// <CJK>
0xE781<SEP>0x6D61<SEP>0x8F63<SEP3>// <CJK>
0xE782<SEP>0x6D62<SEP>0x8F64<SEP3>// <CJK>
0xE783<SEP>0x6D63<SEP>0x8F9C<SEP3>// <CJK>
0xE784<SEP>0x6D64<SEP>0x8F9F<SEP3>// <CJK>
0xE785<SEP>0x6D65<SEP>0x8FA3<SEP3>// <CJK>
0xE786<SEP>0x6D66<SEP>0x8FAD<SEP3>// <CJK>
0xE787<SEP>0x6D67<SEP>0x8FAF<SEP3>// <CJK>
0xE788<SEP>0x6D68<SEP>0x8FB7<SEP3>// <CJK>
0xE789<SEP>0x6D69<SEP>0x8FDA<SEP3>// <CJK>
0xE78A<SEP>0x6D6A<SEP>0x8FE5<SEP3>// <CJK>
0xE78B<SEP>0x6D6B<SEP>0x8FE2<SEP3>// <CJK>
0xE78C<SEP>0x6D6C<SEP>0x8FEA<SEP3>// <CJK>
0xE78D<SEP>0x6D6D<SEP>0x8FEF<SEP3>// <CJK>
0xE78E<SEP>0x6D6E<SEP>0x9087<SEP3>// <CJK>
0xE78F<SEP>0x6D6F<SEP>0x8FF4<SEP3>// <CJK>
0xE790<SEP>0x6D70<SEP>0x9005<SEP3>// <CJK>
0xE791<SEP>0x6D71<SEP>0x8FF9<SEP3>// <CJK>
0xE792<SEP>0x6D72<SEP>0x8FFA<SEP3>// <CJK>
0xE793<SEP>0x6D73<SEP>0x9011<SEP3>// <CJK>
0xE794<SEP>0x6D74<SEP>0x9015<SEP3>// <CJK>
0xE795<SEP>0x6D75<SEP>0x9021<SEP3>// <CJK>
0xE796<SEP>0x6D76<SEP>0x900D<SEP3>// <CJK>
0xE797<SEP>0x6D77<SEP>0x901E<SEP3>// <CJK>
0xE798<SEP>0x6D78<SEP>0x9016<SEP3>// <CJK>
0xE799<SEP>0x6D79<SEP>0x900B<SEP3>// <CJK>
0xE79A<SEP>0x6D7A<SEP>0x9027<SEP3>// <CJK>
0xE79B<SEP>0x6D7B<SEP>0x9036<SEP3>// <CJK>
0xE79C<SEP>0x6D7C<SEP>0x9035<SEP3>// <CJK>
0xE79D<SEP>0x6D7D<SEP>0x9039<SEP3>// <CJK>
0xE79E<SEP>0x6D7E<SEP>0x8FF8<SEP3>// <CJK>
0xE79F<SEP>0x6E21<SEP>0x904F<SEP3>// <CJK>
0xE7A0<SEP>0x6E22<SEP>0x9050<SEP3>// <CJK>
0xE7A1<SEP>0x6E23<SEP>0x9051<SEP3>// <CJK>
0xE7A2<SEP>0x6E24<SEP>0x9052<SEP3>// <CJK>
0xE7A3<SEP>0x6E25<SEP>0x900E<SEP3>// <CJK>
0xE7A4<SEP>0x6E26<SEP>0x9049<SEP3>// <CJK>
0xE7A5<SEP>0x6E27<SEP>0x903E<SEP3>// <CJK>
0xE7A6<SEP>0x6E28<SEP>0x9056<SEP3>// <CJK>
0xE7A7<SEP>0x6E29<SEP>0x9058<SEP3>// <CJK>
0xE7A8<SEP>0x6E2A<SEP>0x905E<SEP3>// <CJK>
0xE7A9<SEP>0x6E2B<SEP>0x9068<SEP3>// <CJK>
0xE7AA<SEP>0x6E2C<SEP>0x906F<SEP3>// <CJK>
0xE7AB<SEP>0x6E2D<SEP>0x9076<SEP3>// <CJK>
0xE7AC<SEP>0x6E2E<SEP>0x96A8<SEP3>// <CJK>
0xE7AD<SEP>0x6E2F<SEP>0x9072<SEP3>// <CJK>
0xE7AE<SEP>0x6E30<SEP>0x9082<SEP3>// <CJK>
0xE7AF<SEP>0x6E31<SEP>0x907D<SEP3>// <CJK>
0xE7B0<SEP>0x6E32<SEP>0x9081<SEP3>// <CJK>
0xE7B1<SEP>0x6E33<SEP>0x9080<SEP3>// <CJK>
0xE7B2<SEP>0x6E34<SEP>0x908A<SEP3>// <CJK>
0xE7B3<SEP>0x6E35<SEP>0x9089<SEP3>// <CJK>
0xE7B4<SEP>0x6E36<SEP>0x908F<SEP3>// <CJK>
0xE7B5<SEP>0x6E37<SEP>0x90A8<SEP3>// <CJK>
0xE7B6<SEP>0x6E38<SEP>0x90AF<SEP3>// <CJK>
0xE7B7<SEP>0x6E39<SEP>0x90B1<SEP3>// <CJK>
0xE7B8<SEP>0x6E3A<SEP>0x90B5<SEP3>// <CJK>
0xE7B9<SEP>0x6E3B<SEP>0x90E2<SEP3>// <CJK>
0xE7BA<SEP>0x6E3C<SEP>0x90E4<SEP3>// <CJK>
0xE7BB<SEP>0x6E3D<SEP>0x6248<SEP3>// <CJK>
0xE7BC<SEP>0x6E3E<SEP>0x90DB<SEP3>// <CJK>
0xE7BD<SEP>0x6E3F<SEP>0x9102<SEP3>// <CJK>
0xE7BE<SEP>0x6E40<SEP>0x9112<SEP3>// <CJK>
0xE7BF<SEP>0x6E41<SEP>0x9119<SEP3>// <CJK>
0xE7C0<SEP>0x6E42<SEP>0x9132<SEP3>// <CJK>
0xE7C1<SEP>0x6E43<SEP>0x9130<SEP3>// <CJK>
0xE7C2<SEP>0x6E44<SEP>0x914A<SEP3>// <CJK>
0xE7C3<SEP>0x6E45<SEP>0x9156<SEP3>// <CJK>
0xE7C4<SEP>0x6E46<SEP>0x9158<SEP3>// <CJK>
0xE7C5<SEP>0x6E47<SEP>0x9163<SEP3>// <CJK>
0xE7C6<SEP>0x6E48<SEP>0x9165<SEP3>// <CJK>
0xE7C7<SEP>0x6E49<SEP>0x9169<SEP3>// <CJK>
0xE7C8<SEP>0x6E4A<SEP>0x9173<SEP3>// <CJK>
0xE7C9<SEP>0x6E4B<SEP>0x9172<SEP3>// <CJK>
0xE7CA<SEP>0x6E4C<SEP>0x918B<SEP3>// <CJK>
0xE7CB<SEP>0x6E4D<SEP>0x9189<SEP3>// <CJK>
0xE7CC<SEP>0x6E4E<SEP>0x9182<SEP3>// <CJK>
0xE7CD<SEP>0x6E4F<SEP>0x91A2<SEP3>// <CJK>
0xE7CE<SEP>0x6E50<SEP>0x91AB<SEP3>// <CJK>
0xE7CF<SEP>0x6E51<SEP>0x91AF<SEP3>// <CJK>
0xE7D0<SEP>0x6E52<SEP>0x91AA<SEP3>// <CJK>
0xE7D1<SEP>0x6E53<SEP>0x91B5<SEP3>// <CJK>
0xE7D2<SEP>0x6E54<SEP>0x91B4<SEP3>// <CJK>
0xE7D3<SEP>0x6E55<SEP>0x91BA<SEP3>// <CJK>
0xE7D4<SEP>0x6E56<SEP>0x91C0<SEP3>// <CJK>
0xE7D5<SEP>0x6E57<SEP>0x91C1<SEP3>// <CJK>
0xE7D6<SEP>0x6E58<SEP>0x91C9<SEP3>// <CJK>
0xE7D7<SEP>0x6E59<SEP>0x91CB<SEP3>// <CJK>
0xE7D8<SEP>0x6E5A<SEP>0x91D0<SEP3>// <CJK>
0xE7D9<SEP>0x6E5B<SEP>0x91D6<SEP3>// <CJK>
0xE7DA<SEP>0x6E5C<SEP>0x91DF<SEP3>// <CJK>
0xE7DB<SEP>0x6E5D<SEP>0x91E1<SEP3>// <CJK>
0xE7DC<SEP>0x6E5E<SEP>0x91DB<SEP3>// <CJK>
0xE7DD<SEP>0x6E5F<SEP>0x91FC<SEP3>// <CJK>
0xE7DE<SEP>0x6E60<SEP>0x91F5<SEP3>// <CJK>
0xE7DF<SEP>0x6E61<SEP>0x91F6<SEP3>// <CJK>
0xE7E0<SEP>0x6E62<SEP>0x921E<SEP3>// <CJK>
0xE7E1<SEP>0x6E63<SEP>0x91FF<SEP3>// <CJK>
0xE7E2<SEP>0x6E64<SEP>0x9214<SEP3>// <CJK>
0xE7E3<SEP>0x6E65<SEP>0x922C<SEP3>// <CJK>
0xE7E4<SEP>0x6E66<SEP>0x9215<SEP3>// <CJK>
0xE7E5<SEP>0x6E67<SEP>0x9211<SEP3>// <CJK>
0xE7E6<SEP>0x6E68<SEP>0x925E<SEP3>// <CJK>
0xE7E7<SEP>0x6E69<SEP>0x9257<SEP3>// <CJK>
0xE7E8<SEP>0x6E6A<SEP>0x9245<SEP3>// <CJK>
0xE7E9<SEP>0x6E6B<SEP>0x9249<SEP3>// <CJK>
0xE7EA<SEP>0x6E6C<SEP>0x9264<SEP3>// <CJK>
0xE7EB<SEP>0x6E6D<SEP>0x9248<SEP3>// <CJK>
0xE7EC<SEP>0x6E6E<SEP>0x9295<SEP3>// <CJK>
0xE7ED<SEP>0x6E6F<SEP>0x923F<SEP3>// <CJK>
0xE7EE<SEP>0x6E70<SEP>0x924B<SEP3>// <CJK>
0xE7EF<SEP>0x6E71<SEP>0x9250<SEP3>// <CJK>
0xE7F0<SEP>0x6E72<SEP>0x929C<SEP3>// <CJK>
0xE7F1<SEP>0x6E73<SEP>0x9296<SEP3>// <CJK>
0xE7F2<SEP>0x6E74<SEP>0x9293<SEP3>// <CJK>
0xE7F3<SEP>0x6E75<SEP>0x929B<SEP3>// <CJK>
0xE7F4<SEP>0x6E76<SEP>0x925A<SEP3>// <CJK>
0xE7F5<SEP>0x6E77<SEP>0x92CF<SEP3>// <CJK>
0xE7F6<SEP>0x6E78<SEP>0x92B9<SEP3>// <CJK>
0xE7F7<SEP>0x6E79<SEP>0x92B7<SEP3>// <CJK>
0xE7F8<SEP>0x6E7A<SEP>0x92E9<SEP3>// <CJK>
0xE7F9<SEP>0x6E7B<SEP>0x930F<SEP3>// <CJK>
0xE7FA<SEP>0x6E7C<SEP>0x92FA<SEP3>// <CJK>
0xE7FB<SEP>0x6E7D<SEP>0x9344<SEP3>// <CJK>
0xE7FC<SEP>0x6E7E<SEP>0x932E<SEP3>// <CJK>
0xE840<SEP>0x6F21<SEP>0x9319<SEP3>// <CJK>
0xE841<SEP>0x6F22<SEP>0x9322<SEP3>// <CJK>
0xE842<SEP>0x6F23<SEP>0x931A<SEP3>// <CJK>
0xE843<SEP>0x6F24<SEP>0x9323<SEP3>// <CJK>
0xE844<SEP>0x6F25<SEP>0x933A<SEP3>// <CJK>
0xE845<SEP>0x6F26<SEP>0x9335<SEP3>// <CJK>
0xE846<SEP>0x6F27<SEP>0x933B<SEP3>// <CJK>
0xE847<SEP>0x6F28<SEP>0x935C<SEP3>// <CJK>
0xE848<SEP>0x6F29<SEP>0x9360<SEP3>// <CJK>
0xE849<SEP>0x6F2A<SEP>0x937C<SEP3>// <CJK>
0xE84A<SEP>0x6F2B<SEP>0x936E<SEP3>// <CJK>
0xE84B<SEP>0x6F2C<SEP>0x9356<SEP3>// <CJK>
0xE84C<SEP>0x6F2D<SEP>0x93B0<SEP3>// <CJK>
0xE84D<SEP>0x6F2E<SEP>0x93AC<SEP3>// <CJK>
0xE84E<SEP>0x6F2F<SEP>0x93AD<SEP3>// <CJK>
0xE84F<SEP>0x6F30<SEP>0x9394<SEP3>// <CJK>
0xE850<SEP>0x6F31<SEP>0x93B9<SEP3>// <CJK>
0xE851<SEP>0x6F32<SEP>0x93D6<SEP3>// <CJK>
0xE852<SEP>0x6F33<SEP>0x93D7<SEP3>// <CJK>
0xE853<SEP>0x6F34<SEP>0x93E8<SEP3>// <CJK>
0xE854<SEP>0x6F35<SEP>0x93E5<SEP3>// <CJK>
0xE855<SEP>0x6F36<SEP>0x93D8<SEP3>// <CJK>
0xE856<SEP>0x6F37<SEP>0x93C3<SEP3>// <CJK>
0xE857<SEP>0x6F38<SEP>0x93DD<SEP3>// <CJK>
0xE858<SEP>0x6F39<SEP>0x93D0<SEP3>// <CJK>
0xE859<SEP>0x6F3A<SEP>0x93C8<SEP3>// <CJK>
0xE85A<SEP>0x6F3B<SEP>0x93E4<SEP3>// <CJK>
0xE85B<SEP>0x6F3C<SEP>0x941A<SEP3>// <CJK>
0xE85C<SEP>0x6F3D<SEP>0x9414<SEP3>// <CJK>
0xE85D<SEP>0x6F3E<SEP>0x9413<SEP3>// <CJK>
0xE85E<SEP>0x6F3F<SEP>0x9403<SEP3>// <CJK>
0xE85F<SEP>0x6F40<SEP>0x9407<SEP3>// <CJK>
0xE860<SEP>0x6F41<SEP>0x9410<SEP3>// <CJK>
0xE861<SEP>0x6F42<SEP>0x9436<SEP3>// <CJK>
0xE862<SEP>0x6F43<SEP>0x942B<SEP3>// <CJK>
0xE863<SEP>0x6F44<SEP>0x9435<SEP3>// <CJK>
0xE864<SEP>0x6F45<SEP>0x9421<SEP3>// <CJK>
0xE865<SEP>0x6F46<SEP>0x943A<SEP3>// <CJK>
0xE866<SEP>0x6F47<SEP>0x9441<SEP3>// <CJK>
0xE867<SEP>0x6F48<SEP>0x9452<SEP3>// <CJK>
0xE868<SEP>0x6F49<SEP>0x9444<SEP3>// <CJK>
0xE869<SEP>0x6F4A<SEP>0x945B<SEP3>// <CJK>
0xE86A<SEP>0x6F4B<SEP>0x9460<SEP3>// <CJK>
0xE86B<SEP>0x6F4C<SEP>0x9462<SEP3>// <CJK>
0xE86C<SEP>0x6F4D<SEP>0x945E<SEP3>// <CJK>
0xE86D<SEP>0x6F4E<SEP>0x946A<SEP3>// <CJK>
0xE86E<SEP>0x6F4F<SEP>0x9229<SEP3>// <CJK>
0xE86F<SEP>0x6F50<SEP>0x9470<SEP3>// <CJK>
0xE870<SEP>0x6F51<SEP>0x9475<SEP3>// <CJK>
0xE871<SEP>0x6F52<SEP>0x9477<SEP3>// <CJK>
0xE872<SEP>0x6F53<SEP>0x947D<SEP3>// <CJK>
0xE873<SEP>0x6F54<SEP>0x945A<SEP3>// <CJK>
0xE874<SEP>0x6F55<SEP>0x947C<SEP3>// <CJK>
0xE875<SEP>0x6F56<SEP>0x947E<SEP3>// <CJK>
0xE876<SEP>0x6F57<SEP>0x9481<SEP3>// <CJK>
0xE877<SEP>0x6F58<SEP>0x947F<SEP3>// <CJK>
0xE878<SEP>0x6F59<SEP>0x9582<SEP3>// <CJK>
0xE879<SEP>0x6F5A<SEP>0x9587<SEP3>// <CJK>
0xE87A<SEP>0x6F5B<SEP>0x958A<SEP3>// <CJK>
0xE87B<SEP>0x6F5C<SEP>0x9594<SEP3>// <CJK>
0xE87C<SEP>0x6F5D<SEP>0x9596<SEP3>// <CJK>
0xE87D<SEP>0x6F5E<SEP>0x9598<SEP3>// <CJK>
0xE87E<SEP>0x6F5F<SEP>0x9599<SEP3>// <CJK>
0xE880<SEP>0x6F60<SEP>0x95A0<SEP3>// <CJK>
0xE881<SEP>0x6F61<SEP>0x95A8<SEP3>// <CJK>
0xE882<SEP>0x6F62<SEP>0x95A7<SEP3>// <CJK>
0xE883<SEP>0x6F63<SEP>0x95AD<SEP3>// <CJK>
0xE884<SEP>0x6F64<SEP>0x95BC<SEP3>// <CJK>
0xE885<SEP>0x6F65<SEP>0x95BB<SEP3>// <CJK>
0xE886<SEP>0x6F66<SEP>0x95B9<SEP3>// <CJK>
0xE887<SEP>0x6F67<SEP>0x95BE<SEP3>// <CJK>
0xE888<SEP>0x6F68<SEP>0x95CA<SEP3>// <CJK>
0xE889<SEP>0x6F69<SEP>0x6FF6<SEP3>// <CJK>
0xE88A<SEP>0x6F6A<SEP>0x95C3<SEP3>// <CJK>
0xE88B<SEP>0x6F6B<SEP>0x95CD<SEP3>// <CJK>
0xE88C<SEP>0x6F6C<SEP>0x95CC<SEP3>// <CJK>
0xE88D<SEP>0x6F6D<SEP>0x95D5<SEP3>// <CJK>
0xE88E<SEP>0x6F6E<SEP>0x95D4<SEP3>// <CJK>
0xE88F<SEP>0x6F6F<SEP>0x95D6<SEP3>// <CJK>
0xE890<SEP>0x6F70<SEP>0x95DC<SEP3>// <CJK>
0xE891<SEP>0x6F71<SEP>0x95E1<SEP3>// <CJK>
0xE892<SEP>0x6F72<SEP>0x95E5<SEP3>// <CJK>
0xE893<SEP>0x6F73<SEP>0x95E2<SEP3>// <CJK>
0xE894<SEP>0x6F74<SEP>0x9621<SEP3>// <CJK>
0xE895<SEP>0x6F75<SEP>0x9628<SEP3>// <CJK>
0xE896<SEP>0x6F76<SEP>0x962E<SEP3>// <CJK>
0xE897<SEP>0x6F77<SEP>0x962F<SEP3>// <CJK>
0xE898<SEP>0x6F78<SEP>0x9642<SEP3>// <CJK>
0xE899<SEP>0x6F79<SEP>0x964C<SEP3>// <CJK>
0xE89A<SEP>0x6F7A<SEP>0x964F<SEP3>// <CJK>
0xE89B<SEP>0x6F7B<SEP>0x964B<SEP3>// <CJK>
0xE89C<SEP>0x6F7C<SEP>0x9677<SEP3>// <CJK>
0xE89D<SEP>0x6F7D<SEP>0x965C<SEP3>// <CJK>
0xE89E<SEP>0x6F7E<SEP>0x965E<SEP3>// <CJK>
0xE89F<SEP>0x7021<SEP>0x965D<SEP3>// <CJK>
0xE8A0<SEP>0x7022<SEP>0x965F<SEP3>// <CJK>
0xE8A1<SEP>0x7023<SEP>0x9666<SEP3>// <CJK>
0xE8A2<SEP>0x7024<SEP>0x9672<SEP3>// <CJK>
0xE8A3<SEP>0x7025<SEP>0x966C<SEP3>// <CJK>
0xE8A4<SEP>0x7026<SEP>0x968D<SEP3>// <CJK>
0xE8A5<SEP>0x7027<SEP>0x9698<SEP3>// <CJK>
0xE8A6<SEP>0x7028<SEP>0x9695<SEP3>// <CJK>
0xE8A7<SEP>0x7029<SEP>0x9697<SEP3>// <CJK>
0xE8A8<SEP>0x702A<SEP>0x96AA<SEP3>// <CJK>
0xE8A9<SEP>0x702B<SEP>0x96A7<SEP3>// <CJK>
0xE8AA<SEP>0x702C<SEP>0x96B1<SEP3>// <CJK>
0xE8AB<SEP>0x702D<SEP>0x96B2<SEP3>// <CJK>
0xE8AC<SEP>0x702E<SEP>0x96B0<SEP3>// <CJK>
0xE8AD<SEP>0x702F<SEP>0x96B4<SEP3>// <CJK>
0xE8AE<SEP>0x7030<SEP>0x96B6<SEP3>// <CJK>
0xE8AF<SEP>0x7031<SEP>0x96B8<SEP3>// <CJK>
0xE8B0<SEP>0x7032<SEP>0x96B9<SEP3>// <CJK>
0xE8B1<SEP>0x7033<SEP>0x96CE<SEP3>// <CJK>
0xE8B2<SEP>0x7034<SEP>0x96CB<SEP3>// <CJK>
0xE8B3<SEP>0x7035<SEP>0x96C9<SEP3>// <CJK>
0xE8B4<SEP>0x7036<SEP>0x96CD<SEP3>// <CJK>
0xE8B5<SEP>0x7037<SEP>0x894D<SEP3>// <CJK>
0xE8B6<SEP>0x7038<SEP>0x96DC<SEP3>// <CJK>
0xE8B7<SEP>0x7039<SEP>0x970D<SEP3>// <CJK>
0xE8B8<SEP>0x703A<SEP>0x96D5<SEP3>// <CJK>
0xE8B9<SEP>0x703B<SEP>0x96F9<SEP3>// <CJK>
0xE8BA<SEP>0x703C<SEP>0x9704<SEP3>// <CJK>
0xE8BB<SEP>0x703D<SEP>0x9706<SEP3>// <CJK>
0xE8BC<SEP>0x703E<SEP>0x9708<SEP3>// <CJK>
0xE8BD<SEP>0x703F<SEP>0x9713<SEP3>// <CJK>
0xE8BE<SEP>0x7040<SEP>0x970E<SEP3>// <CJK>
0xE8BF<SEP>0x7041<SEP>0x9711<SEP3>// <CJK>
0xE8C0<SEP>0x7042<SEP>0x970F<SEP3>// <CJK>
0xE8C1<SEP>0x7043<SEP>0x9716<SEP3>// <CJK>
0xE8C2<SEP>0x7044<SEP>0x9719<SEP3>// <CJK>
0xE8C3<SEP>0x7045<SEP>0x9724<SEP3>// <CJK>
0xE8C4<SEP>0x7046<SEP>0x972A<SEP3>// <CJK>
0xE8C5<SEP>0x7047<SEP>0x9730<SEP3>// <CJK>
0xE8C6<SEP>0x7048<SEP>0x9739<SEP3>// <CJK>
0xE8C7<SEP>0x7049<SEP>0x973D<SEP3>// <CJK>
0xE8C8<SEP>0x704A<SEP>0x973E<SEP3>// <CJK>
0xE8C9<SEP>0x704B<SEP>0x9744<SEP3>// <CJK>
0xE8CA<SEP>0x704C<SEP>0x9746<SEP3>// <CJK>
0xE8CB<SEP>0x704D<SEP>0x9748<SEP3>// <CJK>
0xE8CC<SEP>0x704E<SEP>0x9742<SEP3>// <CJK>
0xE8CD<SEP>0x704F<SEP>0x9749<SEP3>// <CJK>
0xE8CE<SEP>0x7050<SEP>0x975C<SEP3>// <CJK>
0xE8CF<SEP>0x7051<SEP>0x9760<SEP3>// <CJK>
0xE8D0<SEP>0x7052<SEP>0x9764<SEP3>// <CJK>
0xE8D1<SEP>0x7053<SEP>0x9766<SEP3>// <CJK>
0xE8D2<SEP>0x7054<SEP>0x9768<SEP3>// <CJK>
0xE8D3<SEP>0x7055<SEP>0x52D2<SEP3>// <CJK>
0xE8D4<SEP>0x7056<SEP>0x976B<SEP3>// <CJK>
0xE8D5<SEP>0x7057<SEP>0x9771<SEP3>// <CJK>
0xE8D6<SEP>0x7058<SEP>0x9779<SEP3>// <CJK>
0xE8D7<SEP>0x7059<SEP>0x9785<SEP3>// <CJK>
0xE8D8<SEP>0x705A<SEP>0x977C<SEP3>// <CJK>
0xE8D9<SEP>0x705B<SEP>0x9781<SEP3>// <CJK>
0xE8DA<SEP>0x705C<SEP>0x977A<SEP3>// <CJK>
0xE8DB<SEP>0x705D<SEP>0x9786<SEP3>// <CJK>
0xE8DC<SEP>0x705E<SEP>0x978B<SEP3>// <CJK>
0xE8DD<SEP>0x705F<SEP>0x978F<SEP3>// <CJK>
0xE8DE<SEP>0x7060<SEP>0x9790<SEP3>// <CJK>
0xE8DF<SEP>0x7061<SEP>0x979C<SEP3>// <CJK>
0xE8E0<SEP>0x7062<SEP>0x97A8<SEP3>// <CJK>
0xE8E1<SEP>0x7063<SEP>0x97A6<SEP3>// <CJK>
0xE8E2<SEP>0x7064<SEP>0x97A3<SEP3>// <CJK>
0xE8E3<SEP>0x7065<SEP>0x97B3<SEP3>// <CJK>
0xE8E4<SEP>0x7066<SEP>0x97B4<SEP3>// <CJK>
0xE8E5<SEP>0x7067<SEP>0x97C3<SEP3>// <CJK>
0xE8E6<SEP>0x7068<SEP>0x97C6<SEP3>// <CJK>
0xE8E7<SEP>0x7069<SEP>0x97C8<SEP3>// <CJK>
0xE8E8<SEP>0x706A<SEP>0x97CB<SEP3>// <CJK>
0xE8E9<SEP>0x706B<SEP>0x97DC<SEP3>// <CJK>
0xE8EA<SEP>0x706C<SEP>0x97ED<SEP3>// <CJK>
0xE8EB<SEP>0x706D<SEP>0x9F4F<SEP3>// <CJK>
0xE8EC<SEP>0x706E<SEP>0x97F2<SEP3>// <CJK>
0xE8ED<SEP>0x706F<SEP>0x7ADF<SEP3>// <CJK>
0xE8EE<SEP>0x7070<SEP>0x97F6<SEP3>// <CJK>
0xE8EF<SEP>0x7071<SEP>0x97F5<SEP3>// <CJK>
0xE8F0<SEP>0x7072<SEP>0x980F<SEP3>// <CJK>
0xE8F1<SEP>0x7073<SEP>0x980C<SEP3>// <CJK>
0xE8F2<SEP>0x7074<SEP>0x9838<SEP3>// <CJK>
0xE8F3<SEP>0x7075<SEP>0x9824<SEP3>// <CJK>
0xE8F4<SEP>0x7076<SEP>0x9821<SEP3>// <CJK>
0xE8F5<SEP>0x7077<SEP>0x9837<SEP3>// <CJK>
0xE8F6<SEP>0x7078<SEP>0x983D<SEP3>// <CJK>
0xE8F7<SEP>0x7079<SEP>0x9846<SEP3>// <CJK>
0xE8F8<SEP>0x707A<SEP>0x984F<SEP3>// <CJK>
0xE8F9<SEP>0x707B<SEP>0x984B<SEP3>// <CJK>
0xE8FA<SEP>0x707C<SEP>0x986B<SEP3>// <CJK>
0xE8FB<SEP>0x707D<SEP>0x986F<SEP3>// <CJK>
0xE8FC<SEP>0x707E<SEP>0x9870<SEP3>// <CJK>
0xE940<SEP>0x7121<SEP>0x9871<SEP3>// <CJK>
0xE941<SEP>0x7122<SEP>0x9874<SEP3>// <CJK>
0xE942<SEP>0x7123<SEP>0x9873<SEP3>// <CJK>
0xE943<SEP>0x7124<SEP>0x98AA<SEP3>// <CJK>
0xE944<SEP>0x7125<SEP>0x98AF<SEP3>// <CJK>
0xE945<SEP>0x7126<SEP>0x98B1<SEP3>// <CJK>
0xE946<SEP>0x7127<SEP>0x98B6<SEP3>// <CJK>
0xE947<SEP>0x7128<SEP>0x98C4<SEP3>// <CJK>
0xE948<SEP>0x7129<SEP>0x98C3<SEP3>// <CJK>
0xE949<SEP>0x712A<SEP>0x98C6<SEP3>// <CJK>
0xE94A<SEP>0x712B<SEP>0x98E9<SEP3>// <CJK>
0xE94B<SEP>0x712C<SEP>0x98EB<SEP3>// <CJK>
0xE94C<SEP>0x712D<SEP>0x9903<SEP3>// <CJK>
0xE94D<SEP>0x712E<SEP>0x9909<SEP3>// <CJK>
0xE94E<SEP>0x712F<SEP>0x9912<SEP3>// <CJK>
0xE94F<SEP>0x7130<SEP>0x9914<SEP3>// <CJK>
0xE950<SEP>0x7131<SEP>0x9918<SEP3>// <CJK>
0xE951<SEP>0x7132<SEP>0x9921<SEP3>// <CJK>
0xE952<SEP>0x7133<SEP>0x991D<SEP3>// <CJK>
0xE953<SEP>0x7134<SEP>0x991E<SEP3>// <CJK>
0xE954<SEP>0x7135<SEP>0x9924<SEP3>// <CJK>
0xE955<SEP>0x7136<SEP>0x9920<SEP3>// <CJK>
0xE956<SEP>0x7137<SEP>0x992C<SEP3>// <CJK>
0xE957<SEP>0x7138<SEP>0x992E<SEP3>// <CJK>
0xE958<SEP>0x7139<SEP>0x993D<SEP3>// <CJK>
0xE959<SEP>0x713A<SEP>0x993E<SEP3>// <CJK>
0xE95A<SEP>0x713B<SEP>0x9942<SEP3>// <CJK>
0xE95B<SEP>0x713C<SEP>0x9949<SEP3>// <CJK>
0xE95C<SEP>0x713D<SEP>0x9945<SEP3>// <CJK>
0xE95D<SEP>0x713E<SEP>0x9950<SEP3>// <CJK>
0xE95E<SEP>0x713F<SEP>0x994B<SEP3>// <CJK>
0xE95F<SEP>0x7140<SEP>0x9951<SEP3>// <CJK>
0xE960<SEP>0x7141<SEP>0x9952<SEP3>// <CJK>
0xE961<SEP>0x7142<SEP>0x994C<SEP3>// <CJK>
0xE962<SEP>0x7143<SEP>0x9955<SEP3>// <CJK>
0xE963<SEP>0x7144<SEP>0x9997<SEP3>// <CJK>
0xE964<SEP>0x7145<SEP>0x9998<SEP3>// <CJK>
0xE965<SEP>0x7146<SEP>0x99A5<SEP3>// <CJK>
0xE966<SEP>0x7147<SEP>0x99AD<SEP3>// <CJK>
0xE967<SEP>0x7148<SEP>0x99AE<SEP3>// <CJK>
0xE968<SEP>0x7149<SEP>0x99BC<SEP3>// <CJK>
0xE969<SEP>0x714A<SEP>0x99DF<SEP3>// <CJK>
0xE96A<SEP>0x714B<SEP>0x99DB<SEP3>// <CJK>
0xE96B<SEP>0x714C<SEP>0x99DD<SEP3>// <CJK>
0xE96C<SEP>0x714D<SEP>0x99D8<SEP3>// <CJK>
0xE96D<SEP>0x714E<SEP>0x99D1<SEP3>// <CJK>
0xE96E<SEP>0x714F<SEP>0x99ED<SEP3>// <CJK>
0xE96F<SEP>0x7150<SEP>0x99EE<SEP3>// <CJK>
0xE970<SEP>0x7151<SEP>0x99F1<SEP3>// <CJK>
0xE971<SEP>0x7152<SEP>0x99F2<SEP3>// <CJK>
0xE972<SEP>0x7153<SEP>0x99FB<SEP3>// <CJK>
0xE973<SEP>0x7154<SEP>0x99F8<SEP3>// <CJK>
0xE974<SEP>0x7155<SEP>0x9A01<SEP3>// <CJK>
0xE975<SEP>0x7156<SEP>0x9A0F<SEP3>// <CJK>
0xE976<SEP>0x7157<SEP>0x9A05<SEP3>// <CJK>
0xE977<SEP>0x7158<SEP>0x99E2<SEP3>// <CJK>
0xE978<SEP>0x7159<SEP>0x9A19<SEP3>// <CJK>
0xE979<SEP>0x715A<SEP>0x9A2B<SEP3>// <CJK>
0xE97A<SEP>0x715B<SEP>0x9A37<SEP3>// <CJK>
0xE97B<SEP>0x715C<SEP>0x9A45<SEP3>// <CJK>
0xE97C<SEP>0x715D<SEP>0x9A42<SEP3>// <CJK>
0xE97D<SEP>0x715E<SEP>0x9A40<SEP3>// <CJK>
0xE97E<SEP>0x715F<SEP>0x9A43<SEP3>// <CJK>
0xE980<SEP>0x7160<SEP>0x9A3E<SEP3>// <CJK>
0xE981<SEP>0x7161<SEP>0x9A55<SEP3>// <CJK>
0xE982<SEP>0x7162<SEP>0x9A4D<SEP3>// <CJK>
0xE983<SEP>0x7163<SEP>0x9A5B<SEP3>// <CJK>
0xE984<SEP>0x7164<SEP>0x9A57<SEP3>// <CJK>
0xE985<SEP>0x7165<SEP>0x9A5F<SEP3>// <CJK>
0xE986<SEP>0x7166<SEP>0x9A62<SEP3>// <CJK>
0xE987<SEP>0x7167<SEP>0x9A65<SEP3>// <CJK>
0xE988<SEP>0x7168<SEP>0x9A64<SEP3>// <CJK>
0xE989<SEP>0x7169<SEP>0x9A69<SEP3>// <CJK>
0xE98A<SEP>0x716A<SEP>0x9A6B<SEP3>// <CJK>
0xE98B<SEP>0x716B<SEP>0x9A6A<SEP3>// <CJK>
0xE98C<SEP>0x716C<SEP>0x9AAD<SEP3>// <CJK>
0xE98D<SEP>0x716D<SEP>0x9AB0<SEP3>// <CJK>
0xE98E<SEP>0x716E<SEP>0x9ABC<SEP3>// <CJK>
0xE98F<SEP>0x716F<SEP>0x9AC0<SEP3>// <CJK>
0xE990<SEP>0x7170<SEP>0x9ACF<SEP3>// <CJK>
0xE991<SEP>0x7171<SEP>0x9AD1<SEP3>// <CJK>
0xE992<SEP>0x7172<SEP>0x9AD3<SEP3>// <CJK>
0xE993<SEP>0x7173<SEP>0x9AD4<SEP3>// <CJK>
0xE994<SEP>0x7174<SEP>0x9ADE<SEP3>// <CJK>
0xE995<SEP>0x7175<SEP>0x9ADF<SEP3>// <CJK>
0xE996<SEP>0x7176<SEP>0x9AE2<SEP3>// <CJK>
0xE997<SEP>0x7177<SEP>0x9AE3<SEP3>// <CJK>
0xE998<SEP>0x7178<SEP>0x9AE6<SEP3>// <CJK>
0xE999<SEP>0x7179<SEP>0x9AEF<SEP3>// <CJK>
0xE99A<SEP>0x717A<SEP>0x9AEB<SEP3>// <CJK>
0xE99B<SEP>0x717B<SEP>0x9AEE<SEP3>// <CJK>
0xE99C<SEP>0x717C<SEP>0x9AF4<SEP3>// <CJK>
0xE99D<SEP>0x717D<SEP>0x9AF1<SEP3>// <CJK>
0xE99E<SEP>0x717E<SEP>0x9AF7<SEP3>// <CJK>
0xE99F<SEP>0x7221<SEP>0x9AFB<SEP3>// <CJK>
0xE9A0<SEP>0x7222<SEP>0x9B06<SEP3>// <CJK>
0xE9A1<SEP>0x7223<SEP>0x9B18<SEP3>// <CJK>
0xE9A2<SEP>0x7224<SEP>0x9B1A<SEP3>// <CJK>
0xE9A3<SEP>0x7225<SEP>0x9B1F<SEP3>// <CJK>
0xE9A4<SEP>0x7226<SEP>0x9B22<SEP3>// <CJK>
0xE9A5<SEP>0x7227<SEP>0x9B23<SEP3>// <CJK>
0xE9A6<SEP>0x7228<SEP>0x9B25<SEP3>// <CJK>
0xE9A7<SEP>0x7229<SEP>0x9B27<SEP3>// <CJK>
0xE9A8<SEP>0x722A<SEP>0x9B28<SEP3>// <CJK>
0xE9A9<SEP>0x722B<SEP>0x9B29<SEP3>// <CJK>
0xE9AA<SEP>0x722C<SEP>0x9B2A<SEP3>// <CJK>
0xE9AB<SEP>0x722D<SEP>0x9B2E<SEP3>// <CJK>
0xE9AC<SEP>0x722E<SEP>0x9B2F<SEP3>// <CJK>
0xE9AD<SEP>0x722F<SEP>0x9B32<SEP3>// <CJK>
0xE9AE<SEP>0x7230<SEP>0x9B44<SEP3>// <CJK>
0xE9AF<SEP>0x7231<SEP>0x9B43<SEP3>// <CJK>
0xE9B0<SEP>0x7232<SEP>0x9B4F<SEP3>// <CJK>
0xE9B1<SEP>0x7233<SEP>0x9B4D<SEP3>// <CJK>
0xE9B2<SEP>0x7234<SEP>0x9B4E<SEP3>// <CJK>
0xE9B3<SEP>0x7235<SEP>0x9B51<SEP3>// <CJK>
0xE9B4<SEP>0x7236<SEP>0x9B58<SEP3>// <CJK>
0xE9B5<SEP>0x7237<SEP>0x9B74<SEP3>// <CJK>
0xE9B6<SEP>0x7238<SEP>0x9B93<SEP3>// <CJK>
0xE9B7<SEP>0x7239<SEP>0x9B83<SEP3>// <CJK>
0xE9B8<SEP>0x723A<SEP>0x9B91<SEP3>// <CJK>
0xE9B9<SEP>0x723B<SEP>0x9B96<SEP3>// <CJK>
0xE9BA<SEP>0x723C<SEP>0x9B97<SEP3>// <CJK>
0xE9BB<SEP>0x723D<SEP>0x9B9F<SEP3>// <CJK>
0xE9BC<SEP>0x723E<SEP>0x9BA0<SEP3>// <CJK>
0xE9BD<SEP>0x723F<SEP>0x9BA8<SEP3>// <CJK>
0xE9BE<SEP>0x7240<SEP>0x9BB4<SEP3>// <CJK>
0xE9BF<SEP>0x7241<SEP>0x9BC0<SEP3>// <CJK>
0xE9C0<SEP>0x7242<SEP>0x9BCA<SEP3>// <CJK>
0xE9C1<SEP>0x7243<SEP>0x9BB9<SEP3>// <CJK>
0xE9C2<SEP>0x7244<SEP>0x9BC6<SEP3>// <CJK>
0xE9C3<SEP>0x7245<SEP>0x9BCF<SEP3>// <CJK>
0xE9C4<SEP>0x7246<SEP>0x9BD1<SEP3>// <CJK>
0xE9C5<SEP>0x7247<SEP>0x9BD2<SEP3>// <CJK>
0xE9C6<SEP>0x7248<SEP>0x9BE3<SEP3>// <CJK>
0xE9C7<SEP>0x7249<SEP>0x9BE2<SEP3>// <CJK>
0xE9C8<SEP>0x724A<SEP>0x9BE4<SEP3>// <CJK>
0xE9C9<SEP>0x724B<SEP>0x9BD4<SEP3>// <CJK>
0xE9CA<SEP>0x724C<SEP>0x9BE1<SEP3>// <CJK>
0xE9CB<SEP>0x724D<SEP>0x9C3A<SEP3>// <CJK>
0xE9CC<SEP>0x724E<SEP>0x9BF2<SEP3>// <CJK>
0xE9CD<SEP>0x724F<SEP>0x9BF1<SEP3>// <CJK>
0xE9CE<SEP>0x7250<SEP>0x9BF0<SEP3>// <CJK>
0xE9CF<SEP>0x7251<SEP>0x9C15<SEP3>// <CJK>
0xE9D0<SEP>0x7252<SEP>0x9C14<SEP3>// <CJK>
0xE9D1<SEP>0x7253<SEP>0x9C09<SEP3>// <CJK>
0xE9D2<SEP>0x7254<SEP>0x9C13<SEP3>// <CJK>
0xE9D3<SEP>0x7255<SEP>0x9C0C<SEP3>// <CJK>
0xE9D4<SEP>0x7256<SEP>0x9C06<SEP3>// <CJK>
0xE9D5<SEP>0x7257<SEP>0x9C08<SEP3>// <CJK>
0xE9D6<SEP>0x7258<SEP>0x9C12<SEP3>// <CJK>
0xE9D7<SEP>0x7259<SEP>0x9C0A<SEP3>// <CJK>
0xE9D8<SEP>0x725A<SEP>0x9C04<SEP3>// <CJK>
0xE9D9<SEP>0x725B<SEP>0x9C2E<SEP3>// <CJK>
0xE9DA<SEP>0x725C<SEP>0x9C1B<SEP3>// <CJK>
0xE9DB<SEP>0x725D<SEP>0x9C25<SEP3>// <CJK>
0xE9DC<SEP>0x725E<SEP>0x9C24<SEP3>// <CJK>
0xE9DD<SEP>0x725F<SEP>0x9C21<SEP3>// <CJK>
0xE9DE<SEP>0x7260<SEP>0x9C30<SEP3>// <CJK>
0xE9DF<SEP>0x7261<SEP>0x9C47<SEP3>// <CJK>
0xE9E0<SEP>0x7262<SEP>0x9C32<SEP3>// <CJK>
0xE9E1<SEP>0x7263<SEP>0x9C46<SEP3>// <CJK>
0xE9E2<SEP>0x7264<SEP>0x9C3E<SEP3>// <CJK>
0xE9E3<SEP>0x7265<SEP>0x9C5A<SEP3>// <CJK>
0xE9E4<SEP>0x7266<SEP>0x9C60<SEP3>// <CJK>
0xE9E5<SEP>0x7267<SEP>0x9C67<SEP3>// <CJK>
0xE9E6<SEP>0x7268<SEP>0x9C76<SEP3>// <CJK>
0xE9E7<SEP>0x7269<SEP>0x9C78<SEP3>// <CJK>
0xE9E8<SEP>0x726A<SEP>0x9CE7<SEP3>// <CJK>
0xE9E9<SEP>0x726B<SEP>0x9CEC<SEP3>// <CJK>
0xE9EA<SEP>0x726C<SEP>0x9CF0<SEP3>// <CJK>
0xE9EB<SEP>0x726D<SEP>0x9D09<SEP3>// <CJK>
0xE9EC<SEP>0x726E<SEP>0x9D08<SEP3>// <CJK>
0xE9ED<SEP>0x726F<SEP>0x9CEB<SEP3>// <CJK>
0xE9EE<SEP>0x7270<SEP>0x9D03<SEP3>// <CJK>
0xE9EF<SEP>0x7271<SEP>0x9D06<SEP3>// <CJK>
0xE9F0<SEP>0x7272<SEP>0x9D2A<SEP3>// <CJK>
0xE9F1<SEP>0x7273<SEP>0x9D26<SEP3>// <CJK>
0xE9F2<SEP>0x7274<SEP>0x9DAF<SEP3>// <CJK>
0xE9F3<SEP>0x7275<SEP>0x9D23<SEP3>// <CJK>
0xE9F4<SEP>0x7276<SEP>0x9D1F<SEP3>// <CJK>
0xE9F5<SEP>0x7277<SEP>0x9D44<SEP3>// <CJK>
0xE9F6<SEP>0x7278<SEP>0x9D15<SEP3>// <CJK>
0xE9F7<SEP>0x7279<SEP>0x9D12<SEP3>// <CJK>
0xE9F8<SEP>0x727A<SEP>0x9D41<SEP3>// <CJK>
0xE9F9<SEP>0x727B<SEP>0x9D3F<SEP3>// <CJK>
0xE9FA<SEP>0x727C<SEP>0x9D3E<SEP3>// <CJK>
0xE9FB<SEP>0x727D<SEP>0x9D46<SEP3>// <CJK>
0xE9FC<SEP>0x727E<SEP>0x9D48<SEP3>// <CJK>
0xEA40<SEP>0x7321<SEP>0x9D5D<SEP3>// <CJK>
0xEA41<SEP>0x7322<SEP>0x9D5E<SEP3>// <CJK>
0xEA42<SEP>0x7323<SEP>0x9D64<SEP3>// <CJK>
0xEA43<SEP>0x7324<SEP>0x9D51<SEP3>// <CJK>
0xEA44<SEP>0x7325<SEP>0x9D50<SEP3>// <CJK>
0xEA45<SEP>0x7326<SEP>0x9D59<SEP3>// <CJK>
0xEA46<SEP>0x7327<SEP>0x9D72<SEP3>// <CJK>
0xEA47<SEP>0x7328<SEP>0x9D89<SEP3>// <CJK>
0xEA48<SEP>0x7329<SEP>0x9D87<SEP3>// <CJK>
0xEA49<SEP>0x732A<SEP>0x9DAB<SEP3>// <CJK>
0xEA4A<SEP>0x732B<SEP>0x9D6F<SEP3>// <CJK>
0xEA4B<SEP>0x732C<SEP>0x9D7A<SEP3>// <CJK>
0xEA4C<SEP>0x732D<SEP>0x9D9A<SEP3>// <CJK>
0xEA4D<SEP>0x732E<SEP>0x9DA4<SEP3>// <CJK>
0xEA4E<SEP>0x732F<SEP>0x9DA9<SEP3>// <CJK>
0xEA4F<SEP>0x7330<SEP>0x9DB2<SEP3>// <CJK>
0xEA50<SEP>0x7331<SEP>0x9DC4<SEP3>// <CJK>
0xEA51<SEP>0x7332<SEP>0x9DC1<SEP3>// <CJK>
0xEA52<SEP>0x7333<SEP>0x9DBB<SEP3>// <CJK>
0xEA53<SEP>0x7334<SEP>0x9DB8<SEP3>// <CJK>
0xEA54<SEP>0x7335<SEP>0x9DBA<SEP3>// <CJK>
0xEA55<SEP>0x7336<SEP>0x9DC6<SEP3>// <CJK>
0xEA56<SEP>0x7337<SEP>0x9DCF<SEP3>// <CJK>
0xEA57<SEP>0x7338<SEP>0x9DC2<SEP3>// <CJK>
0xEA58<SEP>0x7339<SEP>0x9DD9<SEP3>// <CJK>
0xEA59<SEP>0x733A<SEP>0x9DD3<SEP3>// <CJK>
0xEA5A<SEP>0x733B<SEP>0x9DF8<SEP3>// <CJK>
0xEA5B<SEP>0x733C<SEP>0x9DE6<SEP3>// <CJK>
0xEA5C<SEP>0x733D<SEP>0x9DED<SEP3>// <CJK>
0xEA5D<SEP>0x733E<SEP>0x9DEF<SEP3>// <CJK>
0xEA5E<SEP>0x733F<SEP>0x9DFD<SEP3>// <CJK>
0xEA5F<SEP>0x7340<SEP>0x9E1A<SEP3>// <CJK>
0xEA60<SEP>0x7341<SEP>0x9E1B<SEP3>// <CJK>
0xEA61<SEP>0x7342<SEP>0x9E1E<SEP3>// <CJK>
0xEA62<SEP>0x7343<SEP>0x9E75<SEP3>// <CJK>
0xEA63<SEP>0x7344<SEP>0x9E79<SEP3>// <CJK>
0xEA64<SEP>0x7345<SEP>0x9E7D<SEP3>// <CJK>
0xEA65<SEP>0x7346<SEP>0x9E81<SEP3>// <CJK>
0xEA66<SEP>0x7347<SEP>0x9E88<SEP3>// <CJK>
0xEA67<SEP>0x7348<SEP>0x9E8B<SEP3>// <CJK>
0xEA68<SEP>0x7349<SEP>0x9E8C<SEP3>// <CJK>
0xEA69<SEP>0x734A<SEP>0x9E92<SEP3>// <CJK>
0xEA6A<SEP>0x734B<SEP>0x9E95<SEP3>// <CJK>
0xEA6B<SEP>0x734C<SEP>0x9E91<SEP3>// <CJK>
0xEA6C<SEP>0x734D<SEP>0x9E9D<SEP3>// <CJK>
0xEA6D<SEP>0x734E<SEP>0x9EA5<SEP3>// <CJK>
0xEA6E<SEP>0x734F<SEP>0x9EA9<SEP3>// <CJK>
0xEA6F<SEP>0x7350<SEP>0x9EB8<SEP3>// <CJK>
0xEA70<SEP>0x7351<SEP>0x9EAA<SEP3>// <CJK>
0xEA71<SEP>0x7352<SEP>0x9EAD<SEP3>// <CJK>
0xEA72<SEP>0x7353<SEP>0x9761<SEP3>// <CJK>
0xEA73<SEP>0x7354<SEP>0x9ECC<SEP3>// <CJK>
0xEA74<SEP>0x7355<SEP>0x9ECE<SEP3>// <CJK>
0xEA75<SEP>0x7356<SEP>0x9ECF<SEP3>// <CJK>
0xEA76<SEP>0x7357<SEP>0x9ED0<SEP3>// <CJK>
0xEA77<SEP>0x7358<SEP>0x9ED4<SEP3>// <CJK>
0xEA78<SEP>0x7359<SEP>0x9EDC<SEP3>// <CJK>
0xEA79<SEP>0x735A<SEP>0x9EDE<SEP3>// <CJK>
0xEA7A<SEP>0x735B<SEP>0x9EDD<SEP3>// <CJK>
0xEA7B<SEP>0x735C<SEP>0x9EE0<SEP3>// <CJK>
0xEA7C<SEP>0x735D<SEP>0x9EE5<SEP3>// <CJK>
0xEA7D<SEP>0x735E<SEP>0x9EE8<SEP3>// <CJK>
0xEA7E<SEP>0x735F<SEP>0x9EEF<SEP3>// <CJK>
0xEA80<SEP>0x7360<SEP>0x9EF4<SEP3>// <CJK>
0xEA81<SEP>0x7361<SEP>0x9EF6<SEP3>// <CJK>
0xEA82<SEP>0x7362<SEP>0x9EF7<SEP3>// <CJK>
0xEA83<SEP>0x7363<SEP>0x9EF9<SEP3>// <CJK>
0xEA84<SEP>0x7364<SEP>0x9EFB<SEP3>// <CJK>
0xEA85<SEP>0x7365<SEP>0x9EFC<SEP3>// <CJK>
0xEA86<SEP>0x7366<SEP>0x9EFD<SEP3>// <CJK>
0xEA87<SEP>0x7367<SEP>0x9F07<SEP3>// <CJK>
0xEA88<SEP>0x7368<SEP>0x9F08<SEP3>// <CJK>
0xEA89<SEP>0x7369<SEP>0x76B7<SEP3>// <CJK>
0xEA8A<SEP>0x736A<SEP>0x9F15<SEP3>// <CJK>
0xEA8B<SEP>0x736B<SEP>0x9F21<SEP3>// <CJK>
0xEA8C<SEP>0x736C<SEP>0x9F2C<SEP3>// <CJK>
0xEA8D<SEP>0x736D<SEP>0x9F3E<SEP3>// <CJK>
0xEA8E<SEP>0x736E<SEP>0x9F4A<SEP3>// <CJK>
0xEA8F<SEP>0x736F<SEP>0x9F52<SEP3>// <CJK>
0xEA90<SEP>0x7370<SEP>0x9F54<SEP3>// <CJK>
0xEA91<SEP>0x7371<SEP>0x9F63<SEP3>// <CJK>
0xEA92<SEP>0x7372<SEP>0x9F5F<SEP3>// <CJK>
0xEA93<SEP>0x7373<SEP>0x9F60<SEP3>// <CJK>
0xEA94<SEP>0x7374<SEP>0x9F61<SEP3>// <CJK>
0xEA95<SEP>0x7375<SEP>0x9F66<SEP3>// <CJK>
0xEA96<SEP>0x7376<SEP>0x9F67<SEP3>// <CJK>
0xEA97<SEP>0x7377<SEP>0x9F6C<SEP3>// <CJK>
0xEA98<SEP>0x7378<SEP>0x9F6A<SEP3>// <CJK>
0xEA99<SEP>0x7379<SEP>0x9F77<SEP3>// <CJK>
0xEA9A<SEP>0x737A<SEP>0x9F72<SEP3>// <CJK>
0xEA9B<SEP>0x737B<SEP>0x9F76<SEP3>// <CJK>
0xEA9C<SEP>0x737C<SEP>0x9F95<SEP3>// <CJK>
0xEA9D<SEP>0x737D<SEP>0x9F9C<SEP3>// <CJK>
0xEA9E<SEP>0x737E<SEP>0x9FA0<SEP3>// <CJK>
0xEA9F<SEP>0x7421<SEP>0x582F<SEP3>// <CJK>
0xEAA0<SEP>0x7422<SEP>0x69C7<SEP3>// <CJK>
0xEAA1<SEP>0x7423<SEP>0x9059<SEP3>// <CJK>
0xEAA2<SEP>0x7424<SEP>0x7464<SEP3>// <CJK>
0xEAA3<SEP>0x7425<SEP>0x51DC<SEP3>// <CJK>
0xEAA4<SEP>0x7426<SEP>0x7199<SEP3>// <CJK>
*/


/*
Description:
  Convert a Windows code page 932 encoded value to a UNICODE code point.
  This code page is often used for Korean glpyhs.

Parameters:
  code_page_932_character_value - [in]
    Valid values are 0 to 0xFDFE with some exceptions in that range.
  unicode_code_point - [out]
    ON_UnicodeCodePoint::ON_ReplacementCharacter is returned when code_page_932_character_value is not valid.

Returns:
  1: if code_page_932_character_value and the corresponding UNICODE code point is returned in *unicode_code_point. 
  0: otherwise and *unicode_code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter.

Remarks:
  Windows code page 932: https://msdn.microsoft.com/en-us/library/cc194887.aspx
  Conversions to Unicode are based on the Unicode.org mapping of Windows-932
  ftp://ftp.unicode.org/Public/MAPPINGS/OBSOLETE/EASTASIA/JIS/SHIFTJIS.TXT
*/
#if defined(ON_COMPILER_MSC) && defined(NDEBUG)
  // Work around Release build optimization bug in Visual Studio 2017.
  __declspec(noinline)
#endif
int ON_Internal_MapWindowsCodePage932ToUnicode(
  ON__UINT32 code_page_932_character_value,
  ON__UINT32* unicode_code_point
)
{
  // Windows code page 932 specification: (Shift JIS)
  // https://msdn.microsoft.com/en-us/library/cc194905.aspx

  ON__UINT32 code_point = ON_UnicodeCodePoint::ON_ReplacementCharacter;
  bool rc = false;

  const ON__UINT32 code_page_932_lead_byte_value = code_page_932_character_value / 256;

  while (
    0 == code_page_932_lead_byte_value
    || (code_page_932_lead_byte_value >= 0x81 && code_page_932_lead_byte_value <= 0x9F)
    || (code_page_932_lead_byte_value >= 0xE0 && code_page_932_lead_byte_value <= 0xFC)
    )
  {
    if (code_page_932_character_value < 0x0080)
    {
      // Values in the range 0x00 to 0x7F have identity mapping to UNICODE code point.
      code_point = code_page_932_character_value;
      rc = true;
      break;
    }

    if (0x80 == code_page_932_character_value)
    {
      // 0x80 is UNDEFINED as a code page 932 value.
      // Code page 1252 maps it to the Euro Sign.
      code_point = 0x20ac; // Euro Sign
      rc = true;
      break;
    }

    if (code_page_932_character_value < 0x00A1)
    {
      // 0x0081 - 0x00A0 have no code page 932 mapping.
      break;
    }


    if (code_page_932_character_value < 0x00E0)
    {
      // 0x00A1 - 0x00DF have these code page 932 mappings.
      switch (code_page_932_character_value)
      {
      case 0x00A1: code_point = 0xFF61; break;
      case 0x00A2: code_point = 0xFF62; break;
      case 0x00A3: code_point = 0xFF63; break;
      case 0x00A4: code_point = 0xFF64; break;
      case 0x00A5: code_point = 0xFF65; break;
      case 0x00A6: code_point = 0xFF66; break;
      case 0x00A7: code_point = 0xFF67; break;
      case 0x00A8: code_point = 0xFF68; break;
      case 0x00A9: code_point = 0xFF69; break;
      case 0x00AA: code_point = 0xFF6A; break;
      case 0x00AB: code_point = 0xFF6B; break;
      case 0x00AC: code_point = 0xFF6C; break;
      case 0x00AD: code_point = 0xFF6D; break;
      case 0x00AE: code_point = 0xFF6E; break;
      case 0x00AF: code_point = 0xFF6F; break;

      case 0x00B0: code_point = 0xFF70; break;
      case 0x00B1: code_point = 0xFF71; break;
      case 0x00B2: code_point = 0xFF72; break;
      case 0x00B3: code_point = 0xFF73; break;
      case 0x00B4: code_point = 0xFF74; break;
      case 0x00B5: code_point = 0xFF75; break;
      case 0x00B6: code_point = 0xFF76; break;
      case 0x00B7: code_point = 0xFF77; break;
      case 0x00B8: code_point = 0xFF78; break;
      case 0x00B9: code_point = 0xFF79; break;
      case 0x00BA: code_point = 0xFF7A; break;
      case 0x00BB: code_point = 0xFF7B; break;
      case 0x00BC: code_point = 0xFF7C; break;
      case 0x00BD: code_point = 0xFF7D; break;
      case 0x00BE: code_point = 0xFF7E; break;
      case 0x00BF: code_point = 0xFF7F; break;

      case 0x00C0: code_point = 0xFF80; break;
      case 0x00C1: code_point = 0xFF81; break;
      case 0x00C2: code_point = 0xFF82; break;
      case 0x00C3: code_point = 0xFF83; break;
      case 0x00C4: code_point = 0xFF84; break;
      case 0x00C5: code_point = 0xFF85; break;
      case 0x00C6: code_point = 0xFF86; break;
      case 0x00C7: code_point = 0xFF87; break;
      case 0x00C8: code_point = 0xFF88; break;
      case 0x00C9: code_point = 0xFF89; break;
      case 0x00CA: code_point = 0xFF8A; break;
      case 0x00CB: code_point = 0xFF8B; break;
      case 0x00CC: code_point = 0xFF8C; break;
      case 0x00CD: code_point = 0xFF8D; break;
      case 0x00CE: code_point = 0xFF8E; break;
      case 0x00CF: code_point = 0xFF8F; break;

      case 0x00D0: code_point = 0xFF90; break;
      case 0x00D1: code_point = 0xFF91; break;
      case 0x00D2: code_point = 0xFF92; break;
      case 0x00D3: code_point = 0xFF93; break;
      case 0x00D4: code_point = 0xFF94; break;
      case 0x00D5: code_point = 0xFF95; break;
      case 0x00D6: code_point = 0xFF96; break;
      case 0x00D7: code_point = 0xFF97; break;
      case 0x00D8: code_point = 0xFF98; break;
      case 0x00D9: code_point = 0xFF99; break;
      case 0x00DA: code_point = 0xFF9A; break;
      case 0x00DB: code_point = 0xFF9B; break;
      case 0x00DC: code_point = 0xFF9C; break;
      case 0x00DD: code_point = 0xFF9D; break;
      case 0x00DE: code_point = 0xFF9E; break;
      case 0x00DF: code_point = 0xFF9F; break;
      }
      break;
    }

    if (code_page_932_character_value <= 0xFF)
    {
      // 0x00E0 - 0x00FF have no code page 932 mapping.
      break;
    }

    switch (code_page_932_lead_byte_value)
    {
      //case 0x80: code_point = Internal_MapWindowsCodePage932ToUnicode_0x80(code_page_932_character_value); break;
    case 0x81: code_point = Internal_MapWindowsCodePage932ToUnicode_0x81(code_page_932_character_value); break;
    case 0x82: code_point = Internal_MapWindowsCodePage932ToUnicode_0x82(code_page_932_character_value); break;
    case 0x83: code_point = Internal_MapWindowsCodePage932ToUnicode_0x83(code_page_932_character_value); break;
    case 0x84: code_point = Internal_MapWindowsCodePage932ToUnicode_0x84(code_page_932_character_value); break;
    case 0x85: code_point = Internal_MapWindowsCodePage932ToUnicode_0x85(code_page_932_character_value); break;
    case 0x86: code_point = Internal_MapWindowsCodePage932ToUnicode_0x86(code_page_932_character_value); break;
    case 0x87: code_point = Internal_MapWindowsCodePage932ToUnicode_0x87(code_page_932_character_value); break;
    case 0x88: code_point = Internal_MapWindowsCodePage932ToUnicode_0x88(code_page_932_character_value); break;
    case 0x89: code_point = Internal_MapWindowsCodePage932ToUnicode_0x89(code_page_932_character_value); break;
    case 0x8A: code_point = Internal_MapWindowsCodePage932ToUnicode_0x8A(code_page_932_character_value); break;
    case 0x8B: code_point = Internal_MapWindowsCodePage932ToUnicode_0x8B(code_page_932_character_value); break;
    case 0x8C: code_point = Internal_MapWindowsCodePage932ToUnicode_0x8C(code_page_932_character_value); break;
    case 0x8D: code_point = Internal_MapWindowsCodePage932ToUnicode_0x8D(code_page_932_character_value); break;
    case 0x8E: code_point = Internal_MapWindowsCodePage932ToUnicode_0x8E(code_page_932_character_value); break;
    case 0x8F: code_point = Internal_MapWindowsCodePage932ToUnicode_0x8F(code_page_932_character_value); break;

    case 0x90: code_point = Internal_MapWindowsCodePage932ToUnicode_0x90(code_page_932_character_value); break;
    case 0x91: code_point = Internal_MapWindowsCodePage932ToUnicode_0x91(code_page_932_character_value); break;
    case 0x92: code_point = Internal_MapWindowsCodePage932ToUnicode_0x92(code_page_932_character_value); break;
    case 0x93: code_point = Internal_MapWindowsCodePage932ToUnicode_0x93(code_page_932_character_value); break;
    case 0x94: code_point = Internal_MapWindowsCodePage932ToUnicode_0x94(code_page_932_character_value); break;
    case 0x95: code_point = Internal_MapWindowsCodePage932ToUnicode_0x95(code_page_932_character_value); break;
    case 0x96: code_point = Internal_MapWindowsCodePage932ToUnicode_0x96(code_page_932_character_value); break;
    case 0x97: code_point = Internal_MapWindowsCodePage932ToUnicode_0x97(code_page_932_character_value); break;
    case 0x98: code_point = Internal_MapWindowsCodePage932ToUnicode_0x98(code_page_932_character_value); break;
    case 0x99: code_point = Internal_MapWindowsCodePage932ToUnicode_0x99(code_page_932_character_value); break;
    case 0x9A: code_point = Internal_MapWindowsCodePage932ToUnicode_0x9A(code_page_932_character_value); break;
    case 0x9B: code_point = Internal_MapWindowsCodePage932ToUnicode_0x9B(code_page_932_character_value); break;
    case 0x9C: code_point = Internal_MapWindowsCodePage932ToUnicode_0x9C(code_page_932_character_value); break;
    case 0x9D: code_point = Internal_MapWindowsCodePage932ToUnicode_0x9D(code_page_932_character_value); break;
    case 0x9E: code_point = Internal_MapWindowsCodePage932ToUnicode_0x9E(code_page_932_character_value); break;
    case 0x9F: code_point = Internal_MapWindowsCodePage932ToUnicode_0x9F(code_page_932_character_value); break;

    case 0xA0: code_point = Internal_MapWindowsCodePage932ToUnicode_0xA0(code_page_932_character_value); break;
    case 0xA1: code_point = Internal_MapWindowsCodePage932ToUnicode_0xA1(code_page_932_character_value); break;
    case 0xA2: code_point = Internal_MapWindowsCodePage932ToUnicode_0xA2(code_page_932_character_value); break;
    case 0xA3: code_point = Internal_MapWindowsCodePage932ToUnicode_0xA3(code_page_932_character_value); break;
    case 0xA4: code_point = Internal_MapWindowsCodePage932ToUnicode_0xA4(code_page_932_character_value); break;
    case 0xA5: code_point = Internal_MapWindowsCodePage932ToUnicode_0xA5(code_page_932_character_value); break;
    case 0xA6: code_point = Internal_MapWindowsCodePage932ToUnicode_0xA6(code_page_932_character_value); break;
    case 0xA7: code_point = Internal_MapWindowsCodePage932ToUnicode_0xA7(code_page_932_character_value); break;
    case 0xA8: code_point = Internal_MapWindowsCodePage932ToUnicode_0xA8(code_page_932_character_value); break;
    case 0xA9: code_point = Internal_MapWindowsCodePage932ToUnicode_0xA9(code_page_932_character_value); break;
    case 0xAA: code_point = Internal_MapWindowsCodePage932ToUnicode_0xAA(code_page_932_character_value); break;
    case 0xAB: code_point = Internal_MapWindowsCodePage932ToUnicode_0xAB(code_page_932_character_value); break;
    case 0xAC: code_point = Internal_MapWindowsCodePage932ToUnicode_0xAC(code_page_932_character_value); break;
    case 0xAD: code_point = Internal_MapWindowsCodePage932ToUnicode_0xAD(code_page_932_character_value); break;
    case 0xAE: code_point = Internal_MapWindowsCodePage932ToUnicode_0xAE(code_page_932_character_value); break;
    case 0xAF: code_point = Internal_MapWindowsCodePage932ToUnicode_0xAF(code_page_932_character_value); break;

    case 0xB0: code_point = Internal_MapWindowsCodePage932ToUnicode_0xB0(code_page_932_character_value); break;
    case 0xB1: code_point = Internal_MapWindowsCodePage932ToUnicode_0xB1(code_page_932_character_value); break;
    case 0xB2: code_point = Internal_MapWindowsCodePage932ToUnicode_0xB2(code_page_932_character_value); break;
    case 0xB3: code_point = Internal_MapWindowsCodePage932ToUnicode_0xB3(code_page_932_character_value); break;
    case 0xB4: code_point = Internal_MapWindowsCodePage932ToUnicode_0xB4(code_page_932_character_value); break;
    case 0xB5: code_point = Internal_MapWindowsCodePage932ToUnicode_0xB5(code_page_932_character_value); break;
    case 0xB6: code_point = Internal_MapWindowsCodePage932ToUnicode_0xB6(code_page_932_character_value); break;
    case 0xB7: code_point = Internal_MapWindowsCodePage932ToUnicode_0xB7(code_page_932_character_value); break;
    case 0xB8: code_point = Internal_MapWindowsCodePage932ToUnicode_0xB8(code_page_932_character_value); break;
    case 0xB9: code_point = Internal_MapWindowsCodePage932ToUnicode_0xB9(code_page_932_character_value); break;
    case 0xBA: code_point = Internal_MapWindowsCodePage932ToUnicode_0xBA(code_page_932_character_value); break;
    case 0xBB: code_point = Internal_MapWindowsCodePage932ToUnicode_0xBB(code_page_932_character_value); break;
    case 0xBC: code_point = Internal_MapWindowsCodePage932ToUnicode_0xBC(code_page_932_character_value); break;
    case 0xBD: code_point = Internal_MapWindowsCodePage932ToUnicode_0xBD(code_page_932_character_value); break;
    case 0xBE: code_point = Internal_MapWindowsCodePage932ToUnicode_0xBE(code_page_932_character_value); break;
    case 0xBF: code_point = Internal_MapWindowsCodePage932ToUnicode_0xBF(code_page_932_character_value); break;

    case 0xC0: code_point = Internal_MapWindowsCodePage932ToUnicode_0xC0(code_page_932_character_value); break;
    case 0xC1: code_point = Internal_MapWindowsCodePage932ToUnicode_0xC1(code_page_932_character_value); break;
    case 0xC2: code_point = Internal_MapWindowsCodePage932ToUnicode_0xC2(code_page_932_character_value); break;
    case 0xC3: code_point = Internal_MapWindowsCodePage932ToUnicode_0xC3(code_page_932_character_value); break;
    case 0xC4: code_point = Internal_MapWindowsCodePage932ToUnicode_0xC4(code_page_932_character_value); break;
    case 0xC5: code_point = Internal_MapWindowsCodePage932ToUnicode_0xC5(code_page_932_character_value); break;
    case 0xC6: code_point = Internal_MapWindowsCodePage932ToUnicode_0xC6(code_page_932_character_value); break;
    case 0xC7: code_point = Internal_MapWindowsCodePage932ToUnicode_0xC7(code_page_932_character_value); break;
    case 0xC8: code_point = Internal_MapWindowsCodePage932ToUnicode_0xC8(code_page_932_character_value); break;
      //case 0xC9: code_point = Internal_MapWindowsCodePage932ToUnicode_0xC9(code_page_932_character_value); break;
    case 0xCA: code_point = Internal_MapWindowsCodePage932ToUnicode_0xCA(code_page_932_character_value); break;
    case 0xCB: code_point = Internal_MapWindowsCodePage932ToUnicode_0xCB(code_page_932_character_value); break;
    case 0xCC: code_point = Internal_MapWindowsCodePage932ToUnicode_0xCC(code_page_932_character_value); break;
    case 0xCD: code_point = Internal_MapWindowsCodePage932ToUnicode_0xCD(code_page_932_character_value); break;
    case 0xCE: code_point = Internal_MapWindowsCodePage932ToUnicode_0xCE(code_page_932_character_value); break;
    case 0xCF: code_point = Internal_MapWindowsCodePage932ToUnicode_0xCF(code_page_932_character_value); break;

    case 0xD0: code_point = Internal_MapWindowsCodePage932ToUnicode_0xD0(code_page_932_character_value); break;
    case 0xD1: code_point = Internal_MapWindowsCodePage932ToUnicode_0xD1(code_page_932_character_value); break;
    case 0xD2: code_point = Internal_MapWindowsCodePage932ToUnicode_0xD2(code_page_932_character_value); break;
    case 0xD3: code_point = Internal_MapWindowsCodePage932ToUnicode_0xD3(code_page_932_character_value); break;
    case 0xD4: code_point = Internal_MapWindowsCodePage932ToUnicode_0xD4(code_page_932_character_value); break;
    case 0xD5: code_point = Internal_MapWindowsCodePage932ToUnicode_0xD5(code_page_932_character_value); break;
    case 0xD6: code_point = Internal_MapWindowsCodePage932ToUnicode_0xD6(code_page_932_character_value); break;
    case 0xD7: code_point = Internal_MapWindowsCodePage932ToUnicode_0xD7(code_page_932_character_value); break;
    case 0xD8: code_point = Internal_MapWindowsCodePage932ToUnicode_0xD8(code_page_932_character_value); break;
    case 0xD9: code_point = Internal_MapWindowsCodePage932ToUnicode_0xD9(code_page_932_character_value); break;
    case 0xDA: code_point = Internal_MapWindowsCodePage932ToUnicode_0xDA(code_page_932_character_value); break;
    case 0xDB: code_point = Internal_MapWindowsCodePage932ToUnicode_0xDB(code_page_932_character_value); break;
    case 0xDC: code_point = Internal_MapWindowsCodePage932ToUnicode_0xDC(code_page_932_character_value); break;
    case 0xDD: code_point = Internal_MapWindowsCodePage932ToUnicode_0xDD(code_page_932_character_value); break;
    case 0xDE: code_point = Internal_MapWindowsCodePage932ToUnicode_0xDE(code_page_932_character_value); break;
    case 0xDF: code_point = Internal_MapWindowsCodePage932ToUnicode_0xDF(code_page_932_character_value); break;

    case 0xE0: code_point = Internal_MapWindowsCodePage932ToUnicode_0xE0(code_page_932_character_value); break;
    case 0xE1: code_point = Internal_MapWindowsCodePage932ToUnicode_0xE1(code_page_932_character_value); break;
    case 0xE2: code_point = Internal_MapWindowsCodePage932ToUnicode_0xE2(code_page_932_character_value); break;
    case 0xE3: code_point = Internal_MapWindowsCodePage932ToUnicode_0xE3(code_page_932_character_value); break;
    case 0xE4: code_point = Internal_MapWindowsCodePage932ToUnicode_0xE4(code_page_932_character_value); break;
    case 0xE5: code_point = Internal_MapWindowsCodePage932ToUnicode_0xE5(code_page_932_character_value); break;
    case 0xE6: code_point = Internal_MapWindowsCodePage932ToUnicode_0xE6(code_page_932_character_value); break;
    case 0xE7: code_point = Internal_MapWindowsCodePage932ToUnicode_0xE7(code_page_932_character_value); break;
    case 0xE8: code_point = Internal_MapWindowsCodePage932ToUnicode_0xE8(code_page_932_character_value); break;
    case 0xE9: code_point = Internal_MapWindowsCodePage932ToUnicode_0xE9(code_page_932_character_value); break;
    case 0xEA: code_point = Internal_MapWindowsCodePage932ToUnicode_0xEA(code_page_932_character_value); break;
    case 0xEB: code_point = Internal_MapWindowsCodePage932ToUnicode_0xEB(code_page_932_character_value); break;
    case 0xEC: code_point = Internal_MapWindowsCodePage932ToUnicode_0xEC(code_page_932_character_value); break;
    case 0xED: code_point = Internal_MapWindowsCodePage932ToUnicode_0xED(code_page_932_character_value); break;
    case 0xEE: code_point = Internal_MapWindowsCodePage932ToUnicode_0xEE(code_page_932_character_value); break;
    case 0xEF: code_point = Internal_MapWindowsCodePage932ToUnicode_0xEF(code_page_932_character_value); break;

    case 0xF0: code_point = Internal_MapWindowsCodePage932ToUnicode_0xF0(code_page_932_character_value); break;
    case 0xF1: code_point = Internal_MapWindowsCodePage932ToUnicode_0xF1(code_page_932_character_value); break;
    case 0xF2: code_point = Internal_MapWindowsCodePage932ToUnicode_0xF2(code_page_932_character_value); break;
    case 0xF3: code_point = Internal_MapWindowsCodePage932ToUnicode_0xF3(code_page_932_character_value); break;
    case 0xF4: code_point = Internal_MapWindowsCodePage932ToUnicode_0xF4(code_page_932_character_value); break;
    case 0xF5: code_point = Internal_MapWindowsCodePage932ToUnicode_0xF5(code_page_932_character_value); break;
    case 0xF6: code_point = Internal_MapWindowsCodePage932ToUnicode_0xF6(code_page_932_character_value); break;
    case 0xF7: code_point = Internal_MapWindowsCodePage932ToUnicode_0xF7(code_page_932_character_value); break;
    case 0xF8: code_point = Internal_MapWindowsCodePage932ToUnicode_0xF8(code_page_932_character_value); break;
    case 0xF9: code_point = Internal_MapWindowsCodePage932ToUnicode_0xF9(code_page_932_character_value); break;
    case 0xFA: code_point = Internal_MapWindowsCodePage932ToUnicode_0xFA(code_page_932_character_value); break;
    case 0xFB: code_point = Internal_MapWindowsCodePage932ToUnicode_0xFB(code_page_932_character_value); break;
    case 0xFC: code_point = Internal_MapWindowsCodePage932ToUnicode_0xFC(code_page_932_character_value); break;
    case 0xFD: code_point = Internal_MapWindowsCodePage932ToUnicode_0xFD(code_page_932_character_value); break;
      //case 0xFE: code_point = Internal_MapWindowsCodePage932ToUnicode_0xFE(code_page_932_character_value); break;
      //case 0xFF: code_point = Internal_MapWindowsCodePage932ToUnicode_0xFF(code_page_932_character_value); break;

    }
    rc = (ON_UnicodeCodePoint::ON_ReplacementCharacter != code_point);

    break;
  }
}

#endif
