import oracledb

oracle_user = "geo_test"
oracle_pwd = "geo_test"
oracle_tns = "XEPDB1"

dsn = oracledb.makedsn("127.0.0.1", 1521, service_name=oracle_tns)

conn = oracledb.connect(user=oracle_user, password=oracle_pwd, dsn=dsn)

cur = conn.cursor()

sql = """
CREATE TABLE geo_test.lakes (
    id          NUMBER GENERATED AS IDENTITY PRIMARY KEY,
    area        NUMBER,
    volume      NUMBER,
    name        VARCHAR2(255 CHAR),
    wiki_link   VARCHAR2(1024 CHAR),
    geometry    MDSYS.SDO_GEOMETRY
)
"""

cur.execute(sql)

sql = """
CREATE PUBLIC SYNONYM lakes_public_syn FOR geo_test.lakes
"""

cur.execute(sql)

sql = """
CREATE SYNONYM geo_test.lakes_private_syn FOR geo_test.lakes
"""

cur.execute(sql)


sql = """
INSERT INTO lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'Lake Baikal',
    'https://en.wikipedia.org/wiki/Lake_Baikal',
    SDO_GEOMETRY(
    2003,
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1),
    SDO_ORDINATE_ARRAY(
      106.57998579307912,
      52.79998159444554
    ,
      106.53998823448521,
      52.93999888774037
    ,
      107.0800069519353,
      53.18001007751998
    ,
      107.2999935242018,
      53.37999787048953
    ,
      107.59997521365611,
      53.51998932556822
    ,
      108.03994835818912,
      53.859968573616456
    ,
      108.37997928266967,
      54.25999583598784
    ,
      109.05270307824526,
      55.027597561251326
    ,
      109.19346967980832,
      55.53560272889659
    ,
      109.50699059452313,
      55.73091380474372
    ,
      109.92980716353523,
      55.7129562445223
    ,
      109.70000206913326,
      54.980003567110515
    ,
      109.66000451053935,
      54.71999359803395
    ,
      109.47996382043448,
      54.33999095317566
    ,
      109.31997358605884,
      53.81999685323869
    ,
      109.22003136600637,
      53.619983222052994
    ,
      108.99999311730755,
      53.78002513286093
    ,
      108.60001753136845,
      53.4399942083804
    ,
      108.800005324338,
      53.37999787048953
    ,
      108.76000776574409,
      53.200008856816936
    ,
      108.45997439985749,
      53.14001251892607
    ,
      108.17999148970011,
      52.79998159444554
    ,
      107.79996300662566,
      52.579995022179034
    ,
      107.31999230349876,
      52.42000478780339
    ,
      106.64003380740229,
      52.32001089131862
    ,
      106.1000150899522,
      52.03997630472897
    ,
      105.740037062607,
      51.759993394571595
    ,
      105.24001590375084,
      51.52000804300813
    ,
      104.81998986208251,
      51.46001170511727
    ,
      104.30002160036167,
      51.50000926371118
    ,
      103.7600028829116,
      51.60000316019595
    ,
      103.6200114278329,
      51.73999461527464
    ,
      103.85999677939637,
      51.85998729105637
    ,
      104.39996382041414,
      51.85998729105637
    ,
      105.05997521364597,
      52.0000045843512
    ,
      105.4800012553143,
      52.28001333272471
    ,
      105.98002241417046,
      52.51999868428817
    ,
      106.26000532432784,
      52.619992580772944
    ,
      106.57998579307912,
      52.79998159444554
    )
  )
)
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'Lake Winnipeg',
    'https://en.wikipedia.org/wiki/Lake_Winnipeg',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
        --
        -98.95540137408423,
        53.92978343364277
        ,
        --
        -97.95799455441879,
        54.337097072967325
        ,
        --
        -97.8050064766187,
        54.05938792583079
        ,
        --
        -97.64380184608419,
        53.42521474874492
        ,
        --
        -96.39258622921722,
        51.39730235453108
        ,
        --
        -96.23789282915149,
        50.6910147161819
        ,
        --
        -96.72558915890605,
        50.448910630894474
        ,
        --
        -96.92110694048235,
        50.75405996357799
        ,
        --
        -97.23568722205913,
        51.49778717712263
        ,
        --
        -98.20097713905517,
        52.18456696228162
        ,
        --
        -99.23680538612963,
        53.21628693298888
        ,
        --
        -98.95540137408423,
        53.92978343364277
    )
  )
  )
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'Great Slave Lake',
    'https://en.wikipedia.org/wiki/Great_Slave_Lake',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
                --
          -115.00000342492967,
          61.9723932969562
        ,
        --
          -115.80669837122196,
          62.54171255151576
        ,
        --
          -116.0585951404287,
          62.77880402287089
        ,
        --
          -115.84279435917783,
          62.7503044704619
        ,
        --
          -114.45259497766185,
          62.42820526798667
        ,
        --
          -113.35341142459757,
          62.04448192000336
        ,
        --
          -111.77890804731261,
          62.44360484480964
        ,
        --
          -111.04001258018727,
          62.92000987410843
        ,
        --
          -110.20001217328286,
          63.08000010848407
        ,
        --
          -109.40000932497237,
          62.87817780216814
        ,
        --
          -109.09010576051801,
          62.814099026126215
        ,
        --
          -109.11651241741916,
          62.6928144395372
        ,
        --
          -110.10089677614705,
          62.51561595320837
        ,
        --
          -111.27599300824811,
          62.34911448836395
        ,
        --
          -112.63050981326654,
          61.55991201440246
        ,
        --
          -113.64000891808828,
          61.07999298770784
        ,
        --
          -115.3409903634076,
          60.87659455020702
        ,
        --
          -116.43999304895887,
          60.86000641544133
        ,
        --
          -118.06110856817108,
          61.31196849226605
        ,
        --
          -118.3474735177165,
          61.36137116153708
        ,
        --
          -118.3849906075604,
          61.52110301375126
        ,
        --
          -118.17960262741634,
          61.55629466414203
        ,
        --
          -116.8028132800801,
          61.32589529076871
        ,
        --
          -115.67879920129957,
          61.69179026961132
        ,
        --
          -115.00000342492967,
          61.9723932969562
    )
  )
  )
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'L. Ontario',
    'https://en.wikipedia.org/wiki/Lake_Ontario',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
                --
          -79.05630591502026,
          43.25410431576152
        ,
        --
          -79.36168779164908,
          43.20237620703736
        ,
        --
          -79.76047481964547,
          43.29720246029295
        ,
        --
          -79.46116492381094,
          43.639197089200565
        ,
        --
          -79.1561706204243,
          43.75743276628437
        ,
        --
          -78.45052893747877,
          43.9031861435636
        ,
        --
          -77.60536088734519,
          44.039327704436545
        ,
        --
          -77.16148617217414,
          43.850140285815996
        ,
        --
          -76.88269181995948,
          44.0694550644627
        ,
        --
          -76.56555355498425,
          44.20802541765336
        ,
        --
          -76.35303422718391,
          44.134670722015045
        ,
        --
          -76.23926856149336,
          43.979150499032656
        ,
        --
          -76.17999569365458,
          43.5900011256587
        ,
        --
          -76.9300015937227,
          43.2599954290428
        ,
        --
          -77.74915056019732,
          43.342832750006664
        ,
        --
          -78.53499406605984,
          43.379988104824534
        ,
        --
          -79.05630591502026,
          43.25410431576152
    )
  )
  )
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'L. Erie',
    'https://en.wikipedia.org/wiki/Lake_Erie',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
                --
          -83.12001135937246,
          42.08001577409016
        ,
        --
          -82.57123348664891,
          42.01702220312636
        ,
        --
          -81.82918575715374,
          42.33552989355732
        ,
        --
          -81.39226152212595,
          42.61517690690481
        ,
        --
          -81.09496700715081,
          42.66075552018623
        ,
        --
          -80.54515560578142,
          42.560089830081665
        ,
        --
          -80.27917700877515,
          42.71566172949635
        ,
        --
          -79.79135148793986,
          42.84203644466612
        ,
        --
          -78.92000932485044,
          42.96500051530464
        ,
        --
          -78.90057898630869,
          42.8667119410855
        ,
        --
          -79.76220598012725,
          42.269616604169045
        ,
        --
          -80.51644934764329,
          41.980331936199136
        ,
        --
          -81.03119828970264,
          41.845508124349635
        ,
        --
          -81.62351355663209,
          41.568935858723535
        ,
        --
          -82.34744869660895,
          41.435920722004255
        ,
        --
          -82.84610043000939,
          41.48710622818935
        ,
        --
          -83.46283281119673,
          41.69396698665372
        ,
        --
          -83.12001135937246,
          42.08001577409016
        ,
        --
          -83.12001135937246,
          42.08001577409016
    )
  )
  )
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'Lake Superior',
    'https://en.wikipedia.org/wiki/Lake_Superior',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
          -89.60000342482806,
          48.00998973244721
        ,
        --
          -89.19405921095924,
          48.40546946877693
        ,
        --
          -88.62641944044917,
          48.56251414651193
        ,
        --
          -88.40423661981026,
          48.80632355406499
        ,
        --
          -88.17895321323383,
          48.93670319273738
        ,
        --
          -87.24903581414156,
          48.73511343036678
        ,
        --
          -86.56000810417788,
          48.71108388935106
        ,
        --
          -86.32103044304411,
          48.57729360614741
        ,
        --
          -85.98652889681881,
          48.01035146747326
        ,
        --
          -84.8642201403039,
          47.86007640236849
        ,
        --
          -85.04061764193222,
          47.575700995466306
        ,
        --
          -84.64500871452178,
          47.28220469826462
        ,
        --
          -84.81528255892351,
          46.90233124448706
        ,
        --
          -84.39559241406505,
          46.77683502866624
        ,
        --
          -84.60490780306328,
          46.439594631529474
        ,
        --
          -84.9100054593145,
          46.48000560158172
        ,
        --
          -85.11999264193253,
          46.76001434995524
        ,
        --
          -86.1026200019625,
          46.67265534116582
        ,
        --
          -86.99000769727856,
          46.45000743263628
        ,
        --
          -87.69427995476835,
          46.83104360614041
        ,
        --
          -88.2612220934425,
          46.958581041036766
        ,
        --
          -87.93992387566777,
          47.485913194359185
        ,
        --
          -88.82260901564527,
          47.154796454449
        ,
        --
          -89.62498897984119,
          46.83083690041124
        ,
        --
          -90.39703487828177,
          46.57648550067064
        ,
        --
          -91.00999487991183,
          46.92000458433087
        ,
        --
          -92.01192338740282,
          46.71167104754619
        ,
        --
          -92.00877112503301,
          46.85843211525511
        ,
        --
          -91.33000118687926,
          47.28000844989221
        ,
        --
          -90.61999284540505,
          47.68000987404746
        ,
        --
          -89.60000342482806,
          48.00998973244721
    )
  )
  )
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'Lake Victoria',
    'https://en.wikipedia.org/wiki/Lake_Victoria',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
                --
          33.85036827976734,
          0.128157863766091
        ,
        --
          33.85036827976734,
          0.128157863766091
        ,
        --
          34.13624230320599,
          -0.319308363449238
        ,
        --
          34.0726286150547,
          -1.059831638191795
        ,
        --
          33.579428745261055,
          -1.506005954599821
        ,
        --
          33.251748488098286,
          -1.957968031424549
        ,
        --
          33.64717654799571,
          -2.30089283611342
        ,
        --
          33.07672041192572,
          -2.547131035984201
        ,
        --
          32.95176679864397,
          -2.43044565186915
        ,
        --
          32.37309410983957,
          -2.489925225437091
        ,
        --
          31.926558058405476,
          -2.714511000177573
        ,
        --
          31.648022088352292,
          -2.32921152100937
        ,
        --
          31.836020949030114,
          -1.629305922048232
        ,
        --
          31.866199985488578,
          -1.027378838712494
        ,
        --
          31.815143670384202,
          -0.64042571371094
        ,
        --
          32.27284183119332,
          -0.056120293786734
        ,
        --
          32.906136508930246,
          0.0867650415003
        ,
        --
          33.33184695815069,
          0.324993394365833
        ,
        --
          33.85036827976734,
          0.128157863766091
    )
  )
  )
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'Lake Ladoga',
    'https://en.wikipedia.org/wiki/Lake_Ladoga',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
                --
          29.836711460089845,
          61.22608226179696
        ,
        --
          29.836711460089845,
          61.22608226179696
        ,
        --
          30.85199832532828,
          61.77504100203353
        ,
        --
          32.52688317234018,
          61.11751007755173
        ,
        --
          32.94432539239392,
          60.64260366478942
        ,
        --
          32.81575442885176,
          60.481889960361684
        ,
        --
          32.599901971168606,
          60.533514716221276
        ,
        --
          32.583882277158125,
          60.20893504499601
        ,
        --
          31.699440138482714,
          60.23565176049091
        ,
        --
          31.50973595553924,
          59.92034800886205
        ,
        --
          31.106246372204282,
          59.92768606224749
        ,
        --
          31.10893354668346,
          60.14645823835514
        ,
        --
          30.533878208139498,
          60.63009796817478
        ,
        --
          30.502045525847706,
          60.843211574946466
        ,
        --
          29.836711460089845,
          61.22608226179696
    )
  )
  )
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'Lake Balkhash',
    'https://en.wikipedia.org/wiki/Lake_Balkhash',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
        --
          78.99076541536459,
          46.748619696634876
        ,
        --
          78.99076541536459,
          46.748619696634876
        ,
        --
          79.2451684915375,
          46.64516347918655
        ,
        --
          78.88989301953086,
          46.369934800800024
        ,
        --
          78.44506229036242,
          46.29717438413307
        ,
        --
          77.20606814973246,
          46.3955663112168
        ,
        --
          75.61128177277294,
          46.50718740496724
        ,
        --
          75.46333214712132,
          46.6706141220903
        ,
        --
          75.40566124868357,
          46.47080719663377
        ,
        --
          74.91122114451494,
          46.404661363300164
        ,
        --
          74.77138471873312,
          46.107831936215646
        ,
        --
          74.27802981964263,
          46.004065660173566
        ,
        --
          74.0999528339648,
          44.98893382423201
        ,
        --
          73.4367375019309,
          45.60946442319282
        ,
        --
          73.4399931171653,
          45.80586070411809
        ,
        --
          73.73713260284359,
          46.012747300798594
        ,
        --
          73.67925499867667,
          46.18307282163262
        ,
        --
          74.02068118682908,
          46.20490611427593
        ,
        --
          74.09432010284502,
          46.42781240496693
        ,
        --
          74.939384800114,
          46.81678091082786
        ,
        --
          76.20313195181177,
          46.7800131292522
        ,
        --
          77.18131513866464,
          46.64340648048862
        ,
        --
          77.85993004752152,
          46.64785065366573
        ,
        --
          78.29700931184618,
          46.46853343361292
        ,
        --
          78.39710656119556,
          46.657669175801175
        ,
        --
          78.99076541536459,
          46.748619696634876
    )
  )
  )
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'Lake Tanganyika',
    'https://en.wikipedia.org/wiki/Lake_Tanganyika',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
        --
          30.806006300588507,
          -8.578339125201033
        ,
        --
          30.46442508313922,
          -8.498188978716335
        ,
        --
          30.566847771941724,
          -8.1150082332721
        ,
        --
          30.27735639824263,
          -7.848357842646031
        ,
        --
          30.14702843600253,
          -7.299244073112582
        ,
        --
          29.536523064906334,
          -6.7541610652979
        ,
        --
          29.19318484875913,
          -6.038029066597119
        ,
        --
          29.371985304489016,
          -5.616452731960017
        ,
        --
          29.101717563602506,
          -5.054006442895265
        ,
        --
          29.281034783655315,
          -3.455499362810748
        ,
        --
          29.652588331833897,
          -4.420143324403149
        ,
        --
          29.600085076625334,
          -4.896393324405054
        ,
        --
          29.79195966972506,
          -5.040880629093131
        ,
        --
          29.758421665167646,
          -5.466901136907339
        ,
        --
          29.951226434048635,
          -5.860985609565162
        ,
        --
          29.722041456834177,
          -6.244114678577112
        ,
        --
          30.52803877129051,
          -6.922729587433992
        ,
        --
          30.604158156056457,
          -7.541916599155222
        ,
        --
          31.189032016735865,
          -8.729906101113095
        ,
        --
          31.022117140433124,
          -8.786543470904988
        ,
        --
          30.806006300588507,
          -8.578339125201033
        ,
        --
          30.806006300588507,
          -8.578339125201033
    )
  )
  )
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'Lake Malawi',
    'https://en.wikipedia.org/wiki/Lake_Malawi',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
        --
          35.2602047055542,
          -14.277474460510291
        ,
        --
          35.236226840970915,
          -14.401291192281633
        ,
        --
          34.881209751125766,
          -14.012012627826891
        ,
        --
          34.706543409979076,
          -14.262023207255027
        ,
        --
          34.54675988133266,
          -14.047669366108266
        ,
        --
          34.55110070164528,
          -13.67208505621096
        ,
        --
          34.3209338722171,
          -13.379389743709737
        ,
        --
          34.32997724786827,
          -12.944584242405995
        ,
        --
          34.032527703596315,
          -12.208556817272836
        ,
        --
          34.322690870915096,
          -11.652983493702834
        ,
        --
          34.25990400568048,
          -10.447579034062642
        ,
        --
          33.906592238100984,
          -9.801726983278854
        ,
        --
          33.99557905450757,
          -9.495440769084837
        ,
        --
          34.52422895685345,
          -10.03013681400887
        ,
        --
          34.60789310073403,
          -11.080511976773494
        ,
        --
          34.93702029800096,
          -11.463434340056267
        ,
        --
          34.69388268406766,
          -12.422393894096615
        ,
        --
          34.86756717300062,
          -13.701127211159019
        ,
        --
          35.05597944513687,
          -13.742933444883136
        ,
        --
          35.2602047055542,
          -14.277474460510291
    )
  )
  )
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'Aral Sea',
    'https://en.wikipedia.org/wiki/Aral_Sea',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
        --
          60.05285159692946,
          44.264636949229114
        ,
        --
          59.77002648299603,
          44.15999217383806
        ,
        --
          59.06288618351405,
          44.36928172462015
        ,
        --
          59.34571129744745,
          44.99720205339871
        ,
        --
          59.35930219914022,
          45.190006822279685
        ,
        --
          58.96139367049281,
          45.37500844988459
        ,
        --
          58.92144778833119,
          45.101846828789746
        ,
        --
          58.92144778833119,
          44.73556427670495
        ,
        --
          58.497132602782614,
          44.212340399749735
        ,
        --
          58.285000848224456,
          44.473952338227335
        ,
        --
          58.285000848224456,
          44.89255727800766
        ,
        --
          58.689989048095896,
          45.50001373959863
        ,
        --
          58.78000939314833,
          45.88673432065487
        ,
        --
          59.20427290226462,
          45.93905670835039
        ,
        --
          59.535002068932585,
          45.70501414650049
        ,
        --
          59.55784305200561,
          46.30533926043519
        ,
        --
          59.77002648299603,
          46.25299103452352
        ,
        --
          60.12359663273702,
          46.096023871436955
        ,
        --
          60.12359663273702,
          45.88673432065487
        ,
        --
          59.94675988143425,
          45.808211981787366
        ,
        --
          59.84071984237133,
          45.520477606786216
        ,
        --
          60.12359663273702,
          45.572774156265595
        ,
        --
          60.23997195825834,
          44.78403677019473
        ,
        --
          60.05285159692946,
          44.264636949229114
    )
  )
  )
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'Vänern',
    'https://en.wikipedia.org/wiki/V%C3%A4nern',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
        --
          13.979281447005576,
          59.20491364199721
        ,
        --
          13.979281447005576,
          59.20491364199721
        ,
        --
          13.984449090234762,
          59.086212877022774
        ,
        --
          13.91892337408865,
          58.902503160225166
        ,
        --
          13.28268313971111,
          58.608670966213566
        ,
        --
          12.830100945698888,
          58.50903880475484
        ,
        --
          12.460149366921371,
          58.50619660097878
        ,
        --
          12.537767368223768,
          58.77594757754237
        ,
        --
          12.522161085671598,
          58.880282294339665
        ,
        --
          12.697085808979608,
          58.953843695707135
        ,
        --
          13.027039829163215,
          58.993531195707305
        ,
        --
          13.195298292705559,
          59.12900096296045
        ,
        --
          13.59144982265505,
          59.336481838612315
        ,
        --
          13.979281447005576,
          59.20491364199721
    )
  )
  )
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'Lake Okeechobee',
    'https://en.wikipedia.org/wiki/Lake_Okeechobee',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
        --
          -80.70643775096435,
          26.788959458924822
        ,
        --
          -80.93244462759287,
          26.823272609966622
        ,
        --
          -80.91970638703292,
          27.068916530866048
        ,
        --
          -80.69369951040441,
          27.034629218040394
        ,
        --
          -80.70643775096435,
          26.788959458924822
        ,
        --
          -80.70643775096435,
          26.788959458924822
    )
  )
  )
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'Lago de Nicaragua',
    'https://en.wikipedia.org/wiki/Lake_Nicaragua',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
        --
          -84.85548682324658,
          11.147898667846633
        ,
        --
          -85.29013729525353,
          11.176165676310276
        ,
        --
          -85.79132117383625,
          11.509737046754324
        ,
        --
          -85.8851655748783,
          11.900100816287136
        ,
        --
          -85.5653401354239,
          11.940330918826362
        ,
        --
          -85.03684526237491,
          11.5216484643976
        ,
        --
          -84.85548682324658,
          11.147898667846633
        ,
        --
          -84.85548682324658,
          11.147898667846633
    )
  )
  )
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'Lake Tana',
    'https://en.wikipedia.org/wiki/Lake_Tana',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
        --
          37.14370730972843,
          11.850594794151519
        ,
        --
          37.01482628759251,
          12.035596421756424
        ,
        --
          37.24401126480697,
          12.233878892460353
        ,
        --
          37.518361443844526,
          12.160601711470477
        ,
        --
          37.48187788264647,
          11.825092474815477
        ,
        --
          37.33635704931254,
          11.713393866416595
        ,
        --
          37.14370730972843,
          11.850594794151519
        ,
        --
          37.14370730972843,
          11.850594794151519
    )
  )
  )
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'Lago Titicaca',
    'https://en.wikipedia.org/wiki/Lake_Titicaca',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
        --
          -69.40673987494259,
          -16.126198825752063
        ,
        --
          -69.7290974595793,
          -15.928794854397104
        ,
        --
          -69.98365556504908,
          -15.73717864345884
        ,
        --
          -69.8770212470148,
          -15.669844252182529
        ,
        --
          -69.8679778713637,
          -15.546079196843493
        ,
        --
          -69.88559953477524,
          -15.35425628017606
        ,
        --
          -69.59675411647981,
          -15.410480238509614
        ,
        --
          -68.98697221543571,
          -15.885903415594846
        ,
        --
          -68.9596870591856,
          -15.91329192470954
        ,
        --
          -68.74623755560401,
          -16.356003920154023
        ,
        --
          -68.90524593776611,
          -16.506640720284835
        ,
        --
          -69.00115739609983,
          -16.536406345284952
        ,
        --
          -69.09084184434238,
          -16.461992282784657
        ,
        --
          -69.18205074733753,
          -16.40116912197712
        ,
        --
          -69.25098710801488,
          -16.227536309476427
        ,
        --
          -69.40673987494259,
          -16.126198825752063
        ,
        --
          -69.40673987494259,
          -16.126198825752063
    )
  )
  )
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'Lake Winnipegosis',
    'https://en.wikipedia.org/wiki/Lake_Winnipegosis',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
        --
          -99.40377193886468,
          53.1258531764781
        ,
        --
          -99.54846594928192,
          53.120427151087455
        ,
        --
          -99.80498775917877,
          53.14290639913442
        ,
        --
          -100.43146114785316,
          53.2841897650204
        ,
        --
          -100.60685095905177,
          53.531616522833886
        ,
        --
          -100.33487789589965,
          53.745246893928496
        ,
        --
          -100.42673275429846,
          53.90740753846039
        ,
        --
          -100.4044860501968,
          53.94507965760117
        ,
        --
          -100.32629960813921,
          54.094011135466346
        ,
        --
          -100.23586585162842,
          54.23033356385231
        ,
        --
          -99.99549292682278,
          54.215864162810576
        ,
        --
          -100.04778947630214,
          54.10013479269293
        ,
        --
          -100.18356930214904,
          53.930351874397985
        ,
        --
          -99.87128862180926,
          53.928465684619326
        ,
        --
          -99.91066606321566,
          53.821314602262134
        ,
        --
          -100.05649695514333,
          53.44332733826322
        ,
        --
          -99.66551306842301,
          53.29581696228607
        ,
        --
          -99.39317827024485,
          53.26791168884846
        ,
        --
          -99.40377193886468,
          53.1258531764781
        ,
        --
          -99.40377193886468,
          53.1258531764781
    )
  )
  )
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'Lake Onega',
    'https://en.wikipedia.org/wiki/Lake_Onega',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
        --
          35.71464725112901,
          62.2802298041189
        ,
        --
          36.0541614112866,
          61.716310736733874
        ,
        --
          36.391401808423325,
          61.27605337182331
        ,
        --
          36.10945519383887,
          61.01508738874924
        ,
        --
          35.35074181492962,
          60.948579820389625
        ,
        --
          34.866843702948586,
          61.11637319604125
        ,
        --
          35.207288038887384,
          61.114435329830485
        ,
        --
          35.57832482274313,
          61.08634918887975
        ,
        --
          35.16000410334027,
          61.39428904890701
        ,
        --
          34.85733523940689,
          61.55179881453273
        ,
        --
          34.48691857273877,
          61.86697337508076
        ,
        --
          34.265019972477376,
          62.21914826114994
        ,
        --
          34.289824659977455,
          62.29774811466581
        ,
        --
          34.66561567560399,
          62.22979360620195
        ,
        --
          34.62613488133297,
          62.45223480900245
        ,
        --
          34.8356311378443,
          62.29676626245225
        ,
        --
          35.080267368314026,
          62.1411943630377
        ,
        --
          35.21658979669991,
          62.193284206787894
        ,
        --
          35.463706495919666,
          62.2560193955901
        ,
        --
          35.13969526544963,
          62.48776235620312
        ,
        --
          34.614352654770414,
          62.762448432050576
        ,
        --
          34.99541466649072,
          62.748469957115674
        ,
        --
          35.23395307795005,
          62.675347805422575
        ,
        --
          35.71464725112901,
          62.2802298041189
    )
  )
  )
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'Great Salt Lake',
    'https://en.wikipedia.org/wiki/Great_Salt_Lake',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
        --
          -112.18405127648089,
          41.34124949804567
        ,
        --
          -112.13875688357706,
          41.142346910154174
        ,
        --
          -112.17193315310845,
          40.851460272783186
        ,
        --
          -112.67882727745939,
          41.130487168943205
        ,
        --
          -112.70549231652205,
          41.16753917089636
        ,
        --
          -112.87814327680917,
          41.62815705013003
        ,
        --
          -112.58955624067522,
          41.43891795507716
        ,
        --
          -112.40532975955472,
          41.33801972102742
        ,
        --
          -112.21901038292629,
          41.42855683040267
        ,
        --
          -112.18405127648089,
          41.34124949804567
    )
  )
  )
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'Great Bear Lake',
    'https://en.wikipedia.org/wiki/Great_Bear_Lake',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
        --
          -117.7592923653704,
          66.22368419052789
        ,
        --
          -117.97374955938167,
          65.85489533147692
        ,
        --
          -118.10710059291085,
          65.76691620550001
        ,
        --
          -119.7200520432652,
          65.73479930283061
        ,
        --
          -119.74568355368197,
          65.65436493596833
        ,
        --
          -119.6648099371452,
          65.52742178004333
        ,
        --
          -119.70219783590836,
          65.36794830999061
        ,
        --
          -121.35509436098008,
          64.87999359807459
        ,
        --
          -121.33610327211281,
          64.99461192489797
        ,
        --
          -120.94527441468938,
          65.37774099390991
        ,
        --
          -121.05728308168202,
          65.4463414577774
        ,
        --
          -122.56450374412293,
          65.0310696478799
        ,
        --
          -123.232705851873,
          65.18041453720339
        ,
        --
          -123.17963415590926,
          65.31937246363624
        ,
        --
          -122.32599117087979,
          65.79378795029179
        ,
        --
          -122.35622188377054,
          65.90184337021411
        ,
        --
          -124.95363440005697,
          66.04925039332666
        ,
        --
          -124.89753963280414,
          66.15115631780624
        ,
        --
          -119.48724971579031,
          66.96929759385118
        ,
        --
          -119.35743771042887,
          66.87519481064767
        ,
        --
          -120.1769492193738,
          66.46527151149239
        ,
        --
          -117.60545162643749,
          66.55934845647975
        ,
        --
          -117.61278967982294,
          66.41997711858856
        ,
        --
          -117.7592923653704,
          66.22368419052789
        ,
        --
          -117.7592923653704,
          66.22368419052789
    )
  )
  )
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'Lake Athabasca',
    'https://en.wikipedia.org/wiki/Lake_Athabasca',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
        --
          -109.65330135785099,
          59.03763703066841
        ,
        --
          -111.08626298708849,
          58.56017263450765
        ,
        --
          -111.19948605023998,
          58.685565497463884
        ,
        --
          -111.160005255969,
          58.75985036888345
        ,
        --
          -109.09672034385136,
          59.55042226830068
        ,
        --
          -106.54517066122398,
          59.31968699811746
        ,
        --
          -106.54695349813804,
          59.292815253325685
        ,
        --
          -109.65330135785099,
          59.03763703066841
        ,
        --
          -109.65330135785099,
          59.03763703066841
    )
  )
  )
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'Reindeer Lake',
    'https://en.wikipedia.org/wiki/Reindeer_Lake',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
        --
          -101.89514441608819,
          58.01403025983099
        ,
        --
          -101.89514441608819,
          58.01403025983099
        ,
        --
          -101.54384802936804,
          57.86809601503873
        ,
        --
          -101.97090206582807,
          57.34867035585697
        ,
        --
          -101.93403093138781,
          57.23066722271848
        ,
        --
          -103.20416012247362,
          56.34539826112639
        ,
        --
          -103.2825015938281,
          56.40994212505895
        ,
        --
          -103.1487371488406,
          56.70411021588043
        ,
        --
          -103.07832800984292,
          56.71080231386223
        ,
        --
          -103.01440426309787,
          56.56510061301529
        ,
        --
          -102.57680823445028,
          56.938281968811054
        ,
        --
          -102.81322791218561,
          57.28714956321349
        ,
        --
          -102.81369300007623,
          57.46434804954232
        ,
        --
          -102.12874772826359,
          58.01914622662788
        ,
        --
          -101.89514441608819,
          58.01403025983099
    )
  )
  )
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'Lake Huron',
    'https://en.wikipedia.org/wiki/Lake_Huron',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
        --
          -80.41056433787725,
          45.590137437515665
        ,
        --
          -79.76292945017934,
          44.824602769543844
        ,
        --
          -80.08500281443844,
          44.493925279308144
        ,
        --
          -80.89769222687659,
          44.63164297136599
        ,
        --
          -81.40233842642287,
          45.25005483660284
        ,
        --
          -81.27567949087549,
          44.6201708033972
        ,
        --
          -81.75265296092948,
          44.06464915625956
        ,
        --
          -81.70017554393709,
          43.590052802090995
        ,
        --
          -81.78272864452336,
          43.310845038417995
        ,
        --
          -82.43000179719522,
          42.98001251888543
        ,
        --
          -82.4799987454376,
          43.39001333268915
        ,
        --
          -82.6599877591102,
          43.970003770516996
        ,
        --
          -83.02999101432,
          44.06999766700177
        ,
        --
          -83.6500048489579,
          43.62999868425261
        ,
        --
          -83.84870073112015,
          43.63831858985161
        ,
        --
          -83.89998959016984,
          43.88998281511303
        ,
        --
          -83.34999732128743,
          44.29001007748441
        ,
        --
          -83.25878841829228,
          44.74574453386644
        ,
        --
          -83.33999793163895,
          45.200006211928155
        ,
        --
          -84.08000444205858,
          45.58998240821879
        ,
        --
          -84.93000423861146,
          45.789996039404485
        ,
        --
          -84.75355506055087,
          45.924483954444085
        ,
        --
          -84.71999121777729,
          45.91998810483469
        ,
        --
          -83.83919226757845,
          46.010215155616294
        ,
        --
          -84.33670711946846,
          46.40876963966737
        ,
        --
          -84.14870825879063,
          46.55576325132161
        ,
        --
          -83.95257036002683,
          46.334278062518635
        ,
        --
          -83.20251278352643,
          46.21015127215355
        ,
        --
          -82.44199072948692,
          46.19963511818216
        ,
        --
          -81.63136837434045,
          46.09754832618957
        ,
        --
          -80.73679765493583,
          45.90381338152733
        ,
        --
          -80.41056433787725,
          45.590137437515665
    )
  )
  )
"""

cur.execute(sql)

sql = """
INSERT INTO geo_test.lakes (area, volume, name, wiki_link, geometry)
  VALUES (NULL, NULL, 'Lake Michigan',
    'https://en.wikipedia.org/wiki/Lake_Michigan',
    SDO_GEOMETRY(
    2003,  -- two-dimensional polygon
    4326,
    NULL,
    SDO_ELEM_INFO_ARRAY(1,1003,1), -- one polygon (exterior polygon ring)
    SDO_ORDINATE_ARRAY(
        --
          -85.53999284538475,
          46.03000722918408
        ,
        --
          -84.75355506055087,
          45.924483954444085
        ,
        --
          -84.93000423861146,
          45.789996039404485
        ,
        --
          -85.06999569369015,
          45.40999339454619
        ,
        --
          -85.29044735384727,
          45.30824249936349
        ,
        --
          -85.46710323763705,
          44.81457754167923
        ,
        --
          -85.55999162468169,
          45.150009263685774
        ,
        --
          -85.95983801954006,
          44.91059235287753
        ,
        --
          -86.20935767286137,
          44.574798895844935
        ,
        --
          -86.47027197950304,
          44.08423452409818
        ,
        --
          -86.52001054558397,
          43.65999685319804
        ,
        --
          -86.18842871778315,
          43.04140412044818
        ,
        --
          -86.21604977084317,
          42.38170278581012
        ,
        --
          -86.62191647006355,
          41.8944198675139
        ,
        --
          -86.8244364082154,
          41.75618541113313
        ,
        --
          -87.09444576694042,
          41.64616628678374
        ,
        --
          -87.4342183092595,
          41.640714423176945
        ,
        --
          -87.52617652052288,
          41.70851390234388
        ,
        --
          -87.79569495314115,
          42.23411489518453
        ,
        --
          -87.80344641798493,
          42.49399567318035
        ,
        --
          -87.77672970249003,
          42.740853990238634
        ,
        --
          -87.90214840366241,
          43.23051402442029
        ,
        --
          -87.71221167677363,
          43.79650014909703
        ,
        --
          -87.486359829442,
          44.49335683855294
        ,
        --
          -86.9674767727993,
          45.26287059181122
        ,
        --
          -87.11806189649782,
          45.25933075619923
        ,
        --
          -87.85282324903983,
          44.61505483660031
        ,
        --
          -87.98831885450912,
          44.73331635190026
        ,
        --
          -87.5964306302237,
          45.093707790703775
        ,
        --
          -87.00000708692704,
          45.73999909116209
        ,
        --
          -86.31999691439827,
          45.829993597998396
        ,
        --
          -85.53999284538475,
          46.03000722918408
    )
  )
  )
"""

cur.execute(sql)

conn.commit()
