/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mspdi;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.Availability;
import net.sf.mpxj.AvailabilityTable;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Rate;
import net.sf.mpxj.RecurrenceType;
import net.sf.mpxj.RecurringData;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskMode;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.TimephasedWork;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.CharsetHelper;
import net.sf.mpxj.common.DefaultTimephasedWorkContainer;
import net.sf.mpxj.common.FieldTypeHelper;
import net.sf.mpxj.common.MPPAssignmentField;
import net.sf.mpxj.common.MPPResourceField;
import net.sf.mpxj.common.MPPTaskField;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.Pair;
import net.sf.mpxj.common.ReplaceOnceStream;
import net.sf.mpxj.common.SplitTaskFactory;
import net.sf.mpxj.common.TimephasedWorkNormaliser;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.mspdi.DatatypeConverter;
import net.sf.mpxj.mspdi.MSPDITimephasedWorkNormaliser;
import net.sf.mpxj.mspdi.schema.Project;
import net.sf.mpxj.mspdi.schema.TimephasedDataType;
import net.sf.mpxj.reader.AbstractProjectReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MSPDIReader
extends AbstractProjectReader {
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;
    private boolean m_compatibleInput = true;
    private String m_encoding;
    private Charset m_charset;
    protected ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private List<ProjectListener> m_projectListeners;
    private static final RecurrenceType[] RECURRENCE_TYPES;
    private static final boolean[] RELATIVE_MAP;
    private static final int[] DAY_MASKS;
    private static final int NAMESPACE_SCOPE = 512;
    private static final String NAMESPACE_REGEX = "xmlns=\\\"http://schemas\\.microsoft\\.com/project.*\\\"";
    private static final String NAMESPACE_REPLACEMENT = "xmlns=\"http://schemas.microsoft.com/project\"";

    public void setEncoding(String string) {
        this.m_encoding = string;
    }

    public void setCharset(Charset charset) {
        this.m_charset = charset;
    }

    private Charset getCharset() {
        Charset charset = this.m_charset;
        if (charset == null) {
            charset = this.m_encoding == null ? CharsetHelper.UTF8 : Charset.forName(this.m_encoding);
        }
        return charset;
    }

    @Override
    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            ReplaceOnceStream replaceOnceStream = new ReplaceOnceStream(inputStream, NAMESPACE_REGEX, NAMESPACE_REPLACEMENT, 512, this.getCharset());
            this.m_projectFile = new ProjectFile();
            this.m_eventManager = this.m_projectFile.getEventManager();
            ProjectConfig projectConfig = this.m_projectFile.getProjectConfig();
            projectConfig.setAutoTaskID(false);
            projectConfig.setAutoTaskUniqueID(false);
            projectConfig.setAutoResourceID(false);
            projectConfig.setAutoResourceUniqueID(false);
            projectConfig.setAutoOutlineLevel(false);
            projectConfig.setAutoOutlineNumber(false);
            projectConfig.setAutoWBS(false);
            projectConfig.setAutoCalendarUniqueID(false);
            projectConfig.setAutoAssignmentUniqueID(false);
            this.m_eventManager.addProjectListeners(this.m_projectListeners);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            SAXSource sAXSource = new SAXSource(xMLReader, new InputSource(new InputStreamReader((InputStream)replaceOnceStream, this.getCharset())));
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
            if (this.m_compatibleInput) {
                unmarshaller.setEventHandler(new ValidationEventHandler(this){

                    @Override
                    public boolean handleEvent(ValidationEvent validationEvent) {
                        return true;
                    }
                });
            }
            DatatypeConverter.setParentFile(this.m_projectFile);
            Project project = (Project)unmarshaller.unmarshal(sAXSource);
            HashMap<BigInteger, ProjectCalendar> hashMap = new HashMap<BigInteger, ProjectCalendar>();
            this.readProjectProperties(project);
            this.readProjectExtendedAttributes(project);
            this.readCalendars(project, hashMap);
            this.readResources(project, hashMap);
            this.readTasks(project);
            this.readAssignments(project);
            projectConfig.updateUniqueCounters();
            ProjectCalendar projectCalendar = hashMap.get(project.getCalendarUID());
            if (projectCalendar != null) {
                this.m_projectFile.getProjectProperties().setDefaultCalendarName(projectCalendar.getName());
            }
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new MPXJException("Failed to parse file", parserConfigurationException);
        }
        catch (JAXBException jAXBException) {
            throw new MPXJException("Failed to parse file", jAXBException);
        }
        catch (SAXException sAXException) {
            throw new MPXJException("Failed to parse file", sAXException);
        }
        finally {
            this.m_projectFile = null;
        }
    }

    private void readProjectProperties(Project project) {
        ProjectProperties projectProperties = this.m_projectFile.getProjectProperties();
        projectProperties.setActualsInSync(BooleanHelper.getBoolean(project.isActualsInSync()));
        projectProperties.setAdminProject(BooleanHelper.getBoolean(project.isAdminProject()));
        projectProperties.setApplicationVersion(NumberHelper.getInteger(project.getSaveVersion()));
        projectProperties.setAuthor(project.getAuthor());
        projectProperties.setAutoAddNewResourcesAndTasks(BooleanHelper.getBoolean(project.isAutoAddNewResourcesAndTasks()));
        projectProperties.setAutolink(BooleanHelper.getBoolean(project.isAutolink()));
        projectProperties.setBaselineForEarnedValue(NumberHelper.getInteger(project.getBaselineForEarnedValue()));
        projectProperties.setDefaultCalendarName(project.getCalendarUID() == null ? null : project.getCalendarUID().toString());
        projectProperties.setCategory(project.getCategory());
        projectProperties.setCompany(project.getCompany());
        projectProperties.setCreationDate(DatatypeConverter.parseDate(project.getCreationDate()));
        projectProperties.setCriticalSlackLimit(NumberHelper.getInteger(project.getCriticalSlackLimit()));
        projectProperties.setCurrencyDigits(NumberHelper.getInteger(project.getCurrencyDigits()));
        projectProperties.setCurrencyCode(project.getCurrencyCode());
        projectProperties.setCurrencySymbol(project.getCurrencySymbol());
        projectProperties.setCurrentDate(DatatypeConverter.parseDate(project.getCurrentDate()));
        projectProperties.setDaysPerMonth(NumberHelper.getInteger(project.getDaysPerMonth()));
        projectProperties.setDefaultDurationUnits(DatatypeConverter.parseDurationTimeUnits(project.getDurationFormat()));
        projectProperties.setDefaultEndTime(DatatypeConverter.parseTime(project.getDefaultFinishTime()));
        projectProperties.setDefaultFixedCostAccrual(project.getDefaultFixedCostAccrual());
        projectProperties.setDefaultOvertimeRate(DatatypeConverter.parseRate(project.getDefaultOvertimeRate()));
        projectProperties.setDefaultStandardRate(DatatypeConverter.parseRate(project.getDefaultStandardRate()));
        projectProperties.setDefaultStartTime(DatatypeConverter.parseTime(project.getDefaultStartTime()));
        projectProperties.setDefaultTaskEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(project.getDefaultTaskEVMethod()));
        projectProperties.setDefaultTaskType(project.getDefaultTaskType());
        projectProperties.setDefaultWorkUnits(DatatypeConverter.parseWorkUnits(project.getWorkFormat()));
        projectProperties.setEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(project.getEarnedValueMethod()));
        projectProperties.setEditableActualCosts(BooleanHelper.getBoolean(project.isEditableActualCosts()));
        projectProperties.setExtendedCreationDate(DatatypeConverter.parseDate(project.getExtendedCreationDate()));
        projectProperties.setFinishDate(DatatypeConverter.parseDate(project.getFinishDate()));
        projectProperties.setFiscalYearStart(BooleanHelper.getBoolean(project.isFiscalYearStart()));
        projectProperties.setFiscalYearStartMonth(NumberHelper.getInteger(project.getFYStartDate()));
        projectProperties.setHonorConstraints(BooleanHelper.getBoolean(project.isHonorConstraints()));
        projectProperties.setInsertedProjectsLikeSummary(BooleanHelper.getBoolean(project.isInsertedProjectsLikeSummary()));
        projectProperties.setLastSaved(DatatypeConverter.parseDate(project.getLastSaved()));
        projectProperties.setManager(project.getManager());
        projectProperties.setMicrosoftProjectServerURL(BooleanHelper.getBoolean(project.isMicrosoftProjectServerURL()));
        projectProperties.setMinutesPerDay(NumberHelper.getInteger(project.getMinutesPerDay()));
        projectProperties.setMinutesPerWeek(NumberHelper.getInteger(project.getMinutesPerWeek()));
        projectProperties.setMoveCompletedEndsBack(BooleanHelper.getBoolean(project.isMoveCompletedEndsBack()));
        projectProperties.setMoveCompletedEndsForward(BooleanHelper.getBoolean(project.isMoveCompletedEndsForward()));
        projectProperties.setMoveRemainingStartsBack(BooleanHelper.getBoolean(project.isMoveRemainingStartsBack()));
        projectProperties.setMoveRemainingStartsForward(BooleanHelper.getBoolean(project.isMoveRemainingStartsForward()));
        projectProperties.setMultipleCriticalPaths(BooleanHelper.getBoolean(project.isMultipleCriticalPaths()));
        projectProperties.setName(project.getName());
        projectProperties.setNewTasksEffortDriven(BooleanHelper.getBoolean(project.isNewTasksEffortDriven()));
        projectProperties.setNewTasksEstimated(BooleanHelper.getBoolean(project.isNewTasksEstimated()));
        projectProperties.setNewTaskStartIsProjectStart(NumberHelper.getInt(project.getNewTaskStartDate()) == 0);
        projectProperties.setProjectExternallyEdited(BooleanHelper.getBoolean(project.isProjectExternallyEdited()));
        projectProperties.setProjectTitle(project.getTitle());
        projectProperties.setRemoveFileProperties(BooleanHelper.getBoolean(project.isRemoveFileProperties()));
        projectProperties.setRevision(NumberHelper.getInteger(project.getRevision()));
        projectProperties.setScheduleFrom(BooleanHelper.getBoolean(project.isScheduleFromStart()) ? ScheduleFrom.START : ScheduleFrom.FINISH);
        projectProperties.setSubject(project.getSubject());
        projectProperties.setSplitInProgressTasks(BooleanHelper.getBoolean(project.isSplitsInProgressTasks()));
        projectProperties.setSpreadActualCost(BooleanHelper.getBoolean(project.isSpreadActualCost()));
        projectProperties.setSpreadPercentComplete(BooleanHelper.getBoolean(project.isSpreadPercentComplete()));
        projectProperties.setStartDate(DatatypeConverter.parseDate(project.getStartDate()));
        projectProperties.setStatusDate(DatatypeConverter.parseDate(project.getStatusDate()));
        projectProperties.setSymbolPosition(project.getCurrencySymbolPosition());
        projectProperties.setUniqueID(project.getUID());
        projectProperties.setUpdatingTaskStatusUpdatesResourceStatus(BooleanHelper.getBoolean(project.isTaskUpdatesResource()));
        projectProperties.setWeekStartDay(DatatypeConverter.parseDay(project.getWeekStartDay()));
        this.updateScheduleSource(projectProperties);
    }

    private void updateScheduleSource(ProjectProperties projectProperties) {
        if (projectProperties.getCompany() != null && projectProperties.getCompany().equals("Synchro Software Ltd")) {
            projectProperties.setFileApplication("Synchro");
        } else if (projectProperties.getAuthor() != null && projectProperties.getAuthor().equals("SG Project")) {
            projectProperties.setFileApplication("Simple Genius");
        } else {
            projectProperties.setFileApplication("Microsoft");
        }
        projectProperties.setFileType("MSPDI");
    }

    private void readCalendars(Project project, HashMap<BigInteger, ProjectCalendar> hashMap) {
        Object object;
        Project.Calendars calendars = project.getCalendars();
        if (calendars != null) {
            object = new LinkedList();
            for (Project.Calendars.Calendar object2 : calendars.getCalendar()) {
                this.readCalendar(object2, hashMap, (List<Pair<ProjectCalendar, BigInteger>>)object);
            }
            MSPDIReader.updateBaseCalendarNames((List<Pair<ProjectCalendar, BigInteger>>)object, hashMap);
        }
        try {
            object = this.m_projectFile.getProjectProperties();
            BigInteger bigInteger = new BigInteger(((ProjectProperties)object).getDefaultCalendarName());
            ProjectCalendar projectCalendar = hashMap.get(bigInteger);
            this.m_projectFile.setDefaultCalendar(projectCalendar);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void updateBaseCalendarNames(List<Pair<ProjectCalendar, BigInteger>> list, HashMap<BigInteger, ProjectCalendar> hashMap) {
        for (Pair<ProjectCalendar, BigInteger> pair : list) {
            ProjectCalendar projectCalendar = pair.getFirst();
            BigInteger bigInteger = pair.getSecond();
            ProjectCalendar projectCalendar2 = hashMap.get(bigInteger);
            if (projectCalendar2 == null) continue;
            projectCalendar.setParent(projectCalendar2);
        }
    }

    private void readCalendar(Project.Calendars.Calendar calendar, HashMap<BigInteger, ProjectCalendar> hashMap, List<Pair<ProjectCalendar, BigInteger>> list) {
        ProjectCalendar projectCalendar = this.m_projectFile.addCalendar();
        projectCalendar.setUniqueID(NumberHelper.getInteger(calendar.getUID()));
        projectCalendar.setName(calendar.getName());
        BigInteger bigInteger = calendar.getBaseCalendarUID();
        if (bigInteger != null) {
            list.add(new Pair<ProjectCalendar, BigInteger>(projectCalendar, bigInteger));
        }
        this.readExceptions(calendar, projectCalendar);
        boolean bl = projectCalendar.getCalendarExceptions().isEmpty();
        Project.Calendars.Calendar.WeekDays weekDays = calendar.getWeekDays();
        if (weekDays != null) {
            for (Project.Calendars.Calendar.WeekDays.WeekDay weekDay : weekDays.getWeekDay()) {
                this.readDay(projectCalendar, weekDay, bl);
            }
        } else {
            projectCalendar.setWorkingDay(Day.SUNDAY, DayType.DEFAULT);
            projectCalendar.setWorkingDay(Day.MONDAY, DayType.DEFAULT);
            projectCalendar.setWorkingDay(Day.TUESDAY, DayType.DEFAULT);
            projectCalendar.setWorkingDay(Day.WEDNESDAY, DayType.DEFAULT);
            projectCalendar.setWorkingDay(Day.THURSDAY, DayType.DEFAULT);
            projectCalendar.setWorkingDay(Day.FRIDAY, DayType.DEFAULT);
            projectCalendar.setWorkingDay(Day.SATURDAY, DayType.DEFAULT);
        }
        this.readWorkWeeks(calendar, projectCalendar);
        hashMap.put(calendar.getUID(), projectCalendar);
        this.m_eventManager.fireCalendarReadEvent(projectCalendar);
    }

    private void readDay(ProjectCalendar projectCalendar, Project.Calendars.Calendar.WeekDays.WeekDay weekDay, boolean bl) {
        BigInteger bigInteger = weekDay.getDayType();
        if (bigInteger != null) {
            if (bigInteger.intValue() == 0) {
                if (bl) {
                    this.readExceptionDay(projectCalendar, weekDay);
                }
            } else {
                this.readNormalDay(projectCalendar, weekDay);
            }
        }
    }

    private void readNormalDay(ProjectCalendar projectCalendar, Project.Calendars.Calendar.WeekDays.WeekDay weekDay) {
        int n = weekDay.getDayType().intValue();
        Day day = Day.getInstance(n);
        projectCalendar.setWorkingDay(day, BooleanHelper.getBoolean(weekDay.isDayWorking()));
        ProjectCalendarHours projectCalendarHours = projectCalendar.addCalendarHours(day);
        Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes workingTimes = weekDay.getWorkingTimes();
        if (workingTimes != null) {
            for (Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime workingTime : workingTimes.getWorkingTime()) {
                Date date = DatatypeConverter.parseTime(workingTime.getFromTime());
                Date date2 = DatatypeConverter.parseTime(workingTime.getToTime());
                if (date == null || date2 == null) continue;
                if (date.getTime() >= date2.getTime()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date2);
                    calendar.add(6, 1);
                    date2 = calendar.getTime();
                }
                projectCalendarHours.addRange(new DateRange(date, date2));
            }
        }
    }

    private void readExceptionDay(ProjectCalendar projectCalendar, Project.Calendars.Calendar.WeekDays.WeekDay weekDay) {
        Project.Calendars.Calendar.WeekDays.WeekDay.TimePeriod timePeriod = weekDay.getTimePeriod();
        Date date = DatatypeConverter.parseDate(timePeriod.getFromDate());
        Date date2 = DatatypeConverter.parseDate(timePeriod.getToDate());
        Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes workingTimes = weekDay.getWorkingTimes();
        ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException(date, date2);
        if (workingTimes != null) {
            List<Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime> list = workingTimes.getWorkingTime();
            for (Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime workingTime : list) {
                Date date3 = DatatypeConverter.parseTime(workingTime.getFromTime());
                Date date4 = DatatypeConverter.parseTime(workingTime.getToTime());
                if (date3 == null || date4 == null) continue;
                if (date3.getTime() >= date4.getTime()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date4);
                    calendar.add(6, 1);
                    date4 = calendar.getTime();
                }
                projectCalendarException.addRange(new DateRange(date3, date4));
            }
        }
    }

    private void readExceptions(Project.Calendars.Calendar calendar, ProjectCalendar projectCalendar) {
        Project.Calendars.Calendar.Exceptions exceptions = calendar.getExceptions();
        if (exceptions != null) {
            for (Project.Calendars.Calendar.Exceptions.Exception exception : exceptions.getException()) {
                this.readException(projectCalendar, exception);
            }
        }
    }

    private void readException(ProjectCalendar projectCalendar, Project.Calendars.Calendar.Exceptions.Exception exception) {
        Date date = DatatypeConverter.parseDate(exception.getTimePeriod().getFromDate());
        Date date2 = DatatypeConverter.parseDate(exception.getTimePeriod().getToDate());
        if (date != null && date2 != null) {
            ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException(date, date2);
            projectCalendarException.setName(exception.getName());
            this.readRecurringData(projectCalendarException, exception);
            Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes workingTimes = exception.getWorkingTimes();
            if (workingTimes != null) {
                List<Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes.WorkingTime> list = workingTimes.getWorkingTime();
                for (Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes.WorkingTime workingTime : list) {
                    Date date3 = DatatypeConverter.parseTime(workingTime.getFromTime());
                    Date date4 = DatatypeConverter.parseTime(workingTime.getToTime());
                    if (date3 == null || date4 == null) continue;
                    if (date3.getTime() >= date4.getTime()) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(date4);
                        calendar.add(6, 1);
                        date4 = calendar.getTime();
                    }
                    projectCalendarException.addRange(new DateRange(date3, date4));
                }
            }
        }
    }

    private void readRecurringData(ProjectCalendarException projectCalendarException, Project.Calendars.Calendar.Exceptions.Exception exception) {
        RecurringData recurringData = new RecurringData();
        recurringData.setStartDate(projectCalendarException.getFromDate());
        recurringData.setFinishDate(projectCalendarException.getToDate());
        recurringData.setRecurrenceType(this.getRecurrenceType(NumberHelper.getInt(exception.getType())));
        recurringData.setRelative(this.getRelative(NumberHelper.getInt(exception.getType())));
        recurringData.setOccurrences(NumberHelper.getInteger(exception.getOccurrences()));
        switch (recurringData.getRecurrenceType()) {
            case DAILY: {
                recurringData.setFrequency(this.getFrequency(exception));
                break;
            }
            case WEEKLY: {
                recurringData.setWeeklyDaysFromBitmap(NumberHelper.getInteger(exception.getDaysOfWeek()), DAY_MASKS);
                recurringData.setFrequency(this.getFrequency(exception));
                break;
            }
            case MONTHLY: {
                if (recurringData.getRelative()) {
                    recurringData.setDayOfWeek(Day.getInstance(NumberHelper.getInt(exception.getMonthItem()) - 2));
                    recurringData.setDayNumber(NumberHelper.getInt(exception.getMonthPosition()) + 1);
                } else {
                    recurringData.setDayNumber(NumberHelper.getInteger(exception.getMonthDay()));
                }
                recurringData.setFrequency(this.getFrequency(exception));
                break;
            }
            case YEARLY: {
                if (recurringData.getRelative()) {
                    recurringData.setDayOfWeek(Day.getInstance(NumberHelper.getInt(exception.getMonthItem()) - 2));
                    recurringData.setDayNumber(NumberHelper.getInt(exception.getMonthPosition()) + 1);
                } else {
                    recurringData.setDayNumber(NumberHelper.getInteger(exception.getMonthDay()));
                }
                recurringData.setMonthNumber(NumberHelper.getInt(exception.getMonth()) + 1);
            }
        }
        if (recurringData.getRecurrenceType() != RecurrenceType.DAILY || recurringData.getDates().length > 1) {
            projectCalendarException.setRecurring(recurringData);
        }
    }

    private RecurrenceType getRecurrenceType(int n) {
        RecurrenceType recurrenceType = n < 0 || n >= RECURRENCE_TYPES.length ? null : RECURRENCE_TYPES[n];
        return recurrenceType;
    }

    private boolean getRelative(int n) {
        boolean bl = n < 0 || n >= RELATIVE_MAP.length ? false : RELATIVE_MAP[n];
        return bl;
    }

    private Integer getFrequency(Project.Calendars.Calendar.Exceptions.Exception exception) {
        Integer n = NumberHelper.getInteger(exception.getPeriod());
        if (n == null) {
            n = 1;
        }
        return n;
    }

    private void readWorkWeeks(Project.Calendars.Calendar calendar, ProjectCalendar projectCalendar) {
        Project.Calendars.Calendar.WorkWeeks workWeeks = calendar.getWorkWeeks();
        if (workWeeks != null) {
            for (Project.Calendars.Calendar.WorkWeeks.WorkWeek workWeek : workWeeks.getWorkWeek()) {
                ProjectCalendarWeek projectCalendarWeek = projectCalendar.addWorkWeek();
                projectCalendarWeek.setName(workWeek.getName());
                Date date = DatatypeConverter.parseDate(workWeek.getTimePeriod().getFromDate());
                Date date2 = DatatypeConverter.parseDate(workWeek.getTimePeriod().getToDate());
                projectCalendarWeek.setDateRange(new DateRange(date, date2));
                Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays weekDays = workWeek.getWeekDays();
                if (weekDays == null) continue;
                for (Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay weekDay : weekDays.getWeekDay()) {
                    int n = weekDay.getDayType().intValue();
                    Day day = Day.getInstance(n);
                    projectCalendarWeek.setWorkingDay(day, BooleanHelper.getBoolean(weekDay.isDayWorking()));
                    ProjectCalendarHours projectCalendarHours = projectCalendarWeek.addCalendarHours(day);
                    Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay.WorkingTimes workingTimes = weekDay.getWorkingTimes();
                    if (workingTimes == null) continue;
                    for (Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay.WorkingTimes.WorkingTime workingTime : workingTimes.getWorkingTime()) {
                        date = DatatypeConverter.parseTime(workingTime.getFromTime());
                        date2 = DatatypeConverter.parseTime(workingTime.getToTime());
                        if (date == null || date2 == null) continue;
                        if (date.getTime() >= date2.getTime()) {
                            Calendar calendar2 = Calendar.getInstance();
                            calendar2.setTime(date2);
                            calendar2.add(6, 1);
                            date2 = calendar2.getTime();
                        }
                        projectCalendarHours.addRange(new DateRange(date, date2));
                    }
                }
            }
        }
    }

    private void readProjectExtendedAttributes(Project project) {
        Project.ExtendedAttributes extendedAttributes = project.getExtendedAttributes();
        if (extendedAttributes != null) {
            for (Project.ExtendedAttributes.ExtendedAttribute extendedAttribute : extendedAttributes.getExtendedAttribute()) {
                this.readFieldAlias(extendedAttribute);
            }
        }
    }

    private void readFieldAlias(Project.ExtendedAttributes.ExtendedAttribute extendedAttribute) {
        String string = extendedAttribute.getAlias();
        if (string != null && string.length() != 0) {
            FieldType fieldType = FieldTypeHelper.getInstance(Integer.parseInt(extendedAttribute.getFieldID()));
            this.m_projectFile.getCustomFields().getCustomField(fieldType).setAlias(extendedAttribute.getAlias());
        }
    }

    protected void readResources(Project project, HashMap<BigInteger, ProjectCalendar> hashMap) {
        Project.Resources resources = project.getResources();
        if (resources != null) {
            for (Project.Resources.Resource resource : resources.getResource()) {
                this.readResource(resource, hashMap);
            }
        }
    }

    private void readResource(Project.Resources.Resource resource, HashMap<BigInteger, ProjectCalendar> hashMap) {
        Resource resource2 = this.m_projectFile.addResource();
        resource2.setAccrueAt(resource.getAccrueAt());
        resource2.setActveDirectoryGUID(resource.getActiveDirectoryGUID());
        resource2.setActualCost(DatatypeConverter.parseCurrency(resource.getActualCost()));
        resource2.setActualOvertimeCost(DatatypeConverter.parseCurrency(resource.getActualOvertimeCost()));
        resource2.setActualOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, null, resource.getActualOvertimeWork()));
        resource2.setActualOvertimeWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, null, resource.getActualOvertimeWorkProtected()));
        resource2.setActualWork(DatatypeConverter.parseDuration(this.m_projectFile, null, resource.getActualWork()));
        resource2.setActualWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, null, resource.getActualWorkProtected()));
        resource2.setACWP(DatatypeConverter.parseCurrency(resource.getACWP()));
        resource2.setAvailableFrom(DatatypeConverter.parseDate(resource.getAvailableFrom()));
        resource2.setAvailableTo(DatatypeConverter.parseDate(resource.getAvailableTo()));
        resource2.setBCWS(DatatypeConverter.parseCurrency(resource.getBCWS()));
        resource2.setBCWP(DatatypeConverter.parseCurrency(resource.getBCWP()));
        resource2.setBookingType(resource.getBookingType());
        resource2.setBudget(BooleanHelper.getBoolean(resource.isIsBudget()));
        resource2.setCanLevel(BooleanHelper.getBoolean(resource.isCanLevel()));
        resource2.setCode(resource.getCode());
        resource2.setCost(DatatypeConverter.parseCurrency(resource.getCost()));
        resource2.setCostPerUse(DatatypeConverter.parseCurrency(resource.getCostPerUse()));
        resource2.setCostVariance(DatatypeConverter.parseCurrency(resource.getCostVariance()));
        resource2.setCreationDate(DatatypeConverter.parseDate(resource.getCreationDate()));
        resource2.setCV(DatatypeConverter.parseCurrency(resource.getCV()));
        resource2.setEmailAddress(resource.getEmailAddress());
        resource2.setGroup(resource.getGroup());
        resource2.setHyperlink(resource.getHyperlink());
        resource2.setHyperlinkAddress(resource.getHyperlinkAddress());
        resource2.setHyperlinkSubAddress(resource.getHyperlinkSubAddress());
        resource2.setID(NumberHelper.getInteger(resource.getID()));
        resource2.setInitials(resource.getInitials());
        resource2.setIsEnterprise(BooleanHelper.getBoolean(resource.isIsEnterprise()));
        resource2.setIsGeneric(BooleanHelper.getBoolean(resource.isIsGeneric()));
        resource2.setIsInactive(BooleanHelper.getBoolean(resource.isIsInactive()));
        resource2.setIsNull(BooleanHelper.getBoolean(resource.isIsNull()));
        resource2.setMaterialLabel(resource.getMaterialLabel());
        resource2.setMaxUnits(DatatypeConverter.parseUnits(resource.getMaxUnits()));
        resource2.setName(resource.getName());
        if (resource.getNotes() != null && resource.getNotes().length() != 0) {
            resource2.setNotes(resource.getNotes());
        }
        resource2.setNtAccount(resource.getNTAccount());
        resource2.setOvertimeCost(DatatypeConverter.parseCurrency(resource.getOvertimeCost()));
        resource2.setOvertimeRate(DatatypeConverter.parseRate(resource.getOvertimeRate()));
        resource2.setOvertimeRateUnits(DatatypeConverter.parseTimeUnit(resource.getOvertimeRateFormat()));
        resource2.setOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, null, resource.getOvertimeWork()));
        resource2.setPeakUnits(DatatypeConverter.parseUnits(resource.getPeakUnits()));
        resource2.setPercentWorkComplete(resource.getPercentWorkComplete());
        resource2.setPhonetics(resource.getPhonetics());
        resource2.setRegularWork(DatatypeConverter.parseDuration(this.m_projectFile, null, resource.getRegularWork()));
        resource2.setRemainingCost(DatatypeConverter.parseCurrency(resource.getRemainingCost()));
        resource2.setRemainingOvertimeCost(DatatypeConverter.parseCurrency(resource.getRemainingOvertimeCost()));
        resource2.setRemainingWork(DatatypeConverter.parseDuration(this.m_projectFile, null, resource.getRemainingWork()));
        resource2.setRemainingOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, null, resource.getRemainingOvertimeWork()));
        resource2.setStandardRate(DatatypeConverter.parseRate(resource.getStandardRate()));
        resource2.setStandardRateUnits(DatatypeConverter.parseTimeUnit(resource.getStandardRateFormat()));
        resource2.setSV(DatatypeConverter.parseCurrency(resource.getSV()));
        resource2.setType(resource.getType());
        resource2.setUniqueID(NumberHelper.getInteger(resource.getUID()));
        resource2.setWork(DatatypeConverter.parseDuration(this.m_projectFile, null, resource.getWork()));
        resource2.setWorkGroup(resource.getWorkGroup());
        resource2.setWorkVariance(DatatypeConverter.parseDurationInThousanthsOfMinutes(resource.getWorkVariance()));
        if (resource2.getType() == ResourceType.MATERIAL && BooleanHelper.getBoolean(resource.isIsCostResource())) {
            resource2.setType(ResourceType.COST);
        }
        this.readResourceExtendedAttributes(resource, resource2);
        this.readResourceBaselines(resource, resource2);
        resource2.setResourceCalendar(hashMap.get(resource.getCalendarUID()));
        resource2.setOverAllocated(BooleanHelper.getBoolean(resource.isOverAllocated()));
        this.readCostRateTables(resource2, resource.getRates());
        this.readAvailabilityTable(resource2, resource.getAvailabilityPeriods());
        this.m_eventManager.fireResourceReadEvent(resource2);
    }

    private void readResourceBaselines(Project.Resources.Resource resource, Resource resource2) {
        for (Project.Resources.Resource.Baseline baseline : resource.getBaseline()) {
            int n = NumberHelper.getInt(baseline.getNumber());
            Double d = DatatypeConverter.parseCurrency(baseline.getCost());
            Duration duration = DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, baseline.getWork());
            if (n == 0) {
                resource2.setBaselineCost(d);
                resource2.setBaselineWork(duration);
                continue;
            }
            resource2.setBaselineCost(n, d);
            resource2.setBaselineWork(n, duration);
        }
    }

    private void readResourceExtendedAttributes(Project.Resources.Resource resource, Resource resource2) {
        for (Project.Resources.Resource.ExtendedAttribute extendedAttribute : resource.getExtendedAttribute()) {
            int n = Integer.parseInt(extendedAttribute.getFieldID()) & 0xFFFF;
            ResourceField resourceField = MPPResourceField.getInstance(n);
            TimeUnit timeUnit = DatatypeConverter.parseDurationTimeUnits(extendedAttribute.getDurationFormat(), null);
            DatatypeConverter.parseExtendedAttribute(this.m_projectFile, resource2, extendedAttribute.getValue(), resourceField, timeUnit);
        }
    }

    private void readCostRateTables(Resource resource, Project.Resources.Resource.Rates rates) {
        if (rates == null) {
            CostRateTable costRateTable = new CostRateTable();
            costRateTable.add(CostRateTableEntry.DEFAULT_ENTRY);
            resource.setCostRateTable(0, costRateTable);
            costRateTable = new CostRateTable();
            costRateTable.add(CostRateTableEntry.DEFAULT_ENTRY);
            resource.setCostRateTable(1, costRateTable);
            costRateTable = new CostRateTable();
            costRateTable.add(CostRateTableEntry.DEFAULT_ENTRY);
            resource.setCostRateTable(2, costRateTable);
            costRateTable = new CostRateTable();
            costRateTable.add(CostRateTableEntry.DEFAULT_ENTRY);
            resource.setCostRateTable(3, costRateTable);
            costRateTable = new CostRateTable();
            costRateTable.add(CostRateTableEntry.DEFAULT_ENTRY);
            resource.setCostRateTable(4, costRateTable);
        } else {
            HashSet<CostRateTable> hashSet = new HashSet<CostRateTable>();
            for (Project.Resources.Resource.Rates.Rate object : rates.getRate()) {
                Rate rate = DatatypeConverter.parseRate(object.getStandardRate());
                TimeUnit timeUnit = DatatypeConverter.parseTimeUnit(object.getStandardRateFormat());
                Rate rate2 = DatatypeConverter.parseRate(object.getOvertimeRate());
                TimeUnit timeUnit2 = DatatypeConverter.parseTimeUnit(object.getOvertimeRateFormat());
                Double d = DatatypeConverter.parseCurrency(object.getCostPerUse());
                Date date = DatatypeConverter.parseDate(object.getRatesTo());
                CostRateTableEntry costRateTableEntry = new CostRateTableEntry(rate, timeUnit, rate2, timeUnit2, d, date);
                int n = object.getRateTable().intValue();
                CostRateTable costRateTable = resource.getCostRateTable(n);
                if (costRateTable == null) {
                    costRateTable = new CostRateTable();
                    resource.setCostRateTable(n, costRateTable);
                }
                costRateTable.add(costRateTableEntry);
                hashSet.add(costRateTable);
            }
            for (CostRateTable costRateTable : hashSet) {
                Collections.sort(costRateTable);
            }
        }
    }

    private void readAvailabilityTable(Resource resource, Project.Resources.Resource.AvailabilityPeriods availabilityPeriods) {
        if (availabilityPeriods != null) {
            AvailabilityTable availabilityTable = resource.getAvailability();
            List<Project.Resources.Resource.AvailabilityPeriods.AvailabilityPeriod> list = availabilityPeriods.getAvailabilityPeriod();
            for (Project.Resources.Resource.AvailabilityPeriods.AvailabilityPeriod availabilityPeriod : list) {
                Date date = DatatypeConverter.parseDate(availabilityPeriod.getAvailableFrom());
                Date date2 = DatatypeConverter.parseDate(availabilityPeriod.getAvailableTo());
                Number number = DatatypeConverter.parseUnits(availabilityPeriod.getAvailableUnits());
                Availability availability = new Availability(date, date2, number);
                availabilityTable.add(availability);
            }
            Collections.sort(availabilityTable);
        }
    }

    private void readTasks(Project project) {
        Project.Tasks tasks = project.getTasks();
        if (tasks != null) {
            int n = 0;
            for (Project.Tasks.Task task : tasks.getTask()) {
                Task task2 = this.readTask(task);
                if (task2.getID() != null) continue;
                ++n;
            }
            for (Project.Tasks.Task task : tasks.getTask()) {
                this.readPredecessors(task);
            }
            if (n == tasks.getTask().size()) {
                this.m_projectFile.renumberTaskIDs();
            }
        }
        this.m_projectFile.updateStructure();
    }

    private Task readTask(Project.Tasks.Task task) {
        Task task2 = this.m_projectFile.addTask();
        task2.setNull(BooleanHelper.getBoolean(task.isIsNull()));
        task2.setID(NumberHelper.getInteger(task.getID()));
        task2.setUniqueID(NumberHelper.getInteger(task.getUID()));
        if (!task2.getNull()) {
            double d;
            TimeUnit timeUnit = DatatypeConverter.parseDurationTimeUnits(task.getDurationFormat());
            task2.setActive(task.isActive() == null ? true : BooleanHelper.getBoolean(task.isActive()));
            task2.setActualCost(DatatypeConverter.parseCurrency(task.getActualCost()));
            task2.setActualDuration(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getActualDuration()));
            task2.setActualFinish(DatatypeConverter.parseDate(task.getActualFinish()));
            task2.setActualOvertimeCost(DatatypeConverter.parseCurrency(task.getActualOvertimeCost()));
            task2.setActualOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getActualOvertimeWork()));
            task2.setActualOvertimeWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getActualOvertimeWorkProtected()));
            task2.setActualStart(DatatypeConverter.parseDate(task.getActualStart()));
            task2.setActualWork(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getActualWork()));
            task2.setActualWorkProtected(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getActualWorkProtected()));
            task2.setACWP(DatatypeConverter.parseCurrency(task.getACWP()));
            task2.setCalendar(this.getTaskCalendar(task));
            task2.setConstraintDate(DatatypeConverter.parseDate(task.getConstraintDate()));
            task2.setConstraintType(DatatypeConverter.parseConstraintType(task.getConstraintType()));
            task2.setContact(task.getContact());
            task2.setCost(DatatypeConverter.parseCurrency(task.getCost()));
            task2.setCreateDate(DatatypeConverter.parseDate(task.getCreateDate()));
            task2.setCV(DatatypeConverter.parseCurrency(task.getCV()));
            task2.setDeadline(DatatypeConverter.parseDate(task.getDeadline()));
            task2.setDuration(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getDuration()));
            task2.setDurationText(task.getDurationText());
            task2.setEarlyFinish(DatatypeConverter.parseDate(task.getEarlyFinish()));
            task2.setEarlyStart(DatatypeConverter.parseDate(task.getEarlyStart()));
            task2.setEarnedValueMethod(DatatypeConverter.parseEarnedValueMethod(task.getEarnedValueMethod()));
            task2.setEffortDriven(BooleanHelper.getBoolean(task.isEffortDriven()));
            task2.setEstimated(BooleanHelper.getBoolean(task.isEstimated()));
            task2.setExternalTask(BooleanHelper.getBoolean(task.isExternalTask()));
            task2.setProject(task.getExternalTaskProject());
            task2.setFinish(DatatypeConverter.parseDate(task.getFinish()));
            task2.setFinishText(task.getFinishText());
            task2.setFinishVariance(DatatypeConverter.parseDurationInThousanthsOfMinutes(task.getFinishVariance()));
            task2.setFixedCost(DatatypeConverter.parseCurrency(task.getFixedCost()));
            task2.setFixedCostAccrual(task.getFixedCostAccrual());
            task2.setHideBar(BooleanHelper.getBoolean(task.isHideBar()));
            task2.setHyperlink(task.getHyperlink());
            task2.setHyperlinkAddress(task.getHyperlinkAddress());
            task2.setHyperlinkSubAddress(task.getHyperlinkSubAddress());
            task2.setIgnoreResourceCalendar(BooleanHelper.getBoolean(task.isIgnoreResourceCalendar()));
            task2.setLateFinish(DatatypeConverter.parseDate(task.getLateFinish()));
            task2.setLateStart(DatatypeConverter.parseDate(task.getLateStart()));
            task2.setLevelAssignments(BooleanHelper.getBoolean(task.isLevelAssignments()));
            task2.setLevelingCanSplit(BooleanHelper.getBoolean(task.isLevelingCanSplit()));
            task2.setLevelingDelayFormat(DatatypeConverter.parseDurationTimeUnits(task.getLevelingDelayFormat()));
            if (task.getLevelingDelay() != null && task2.getLevelingDelayFormat() != null && (d = task.getLevelingDelay().doubleValue()) != 0.0) {
                task2.setLevelingDelay(Duration.convertUnits(d / 10.0, TimeUnit.MINUTES, task2.getLevelingDelayFormat(), this.m_projectFile.getProjectProperties()));
            }
            task2.setMilestone(BooleanHelper.getBoolean(task.isMilestone()));
            task2.setName(task.getName());
            if (task.getNotes() != null && task.getNotes().length() != 0) {
                task2.setNotes(task.getNotes());
            }
            task2.setOutlineLevel(NumberHelper.getInteger(task.getOutlineLevel()));
            task2.setOutlineNumber(task.getOutlineNumber());
            task2.setOverAllocated(BooleanHelper.getBoolean(task.isOverAllocated()));
            task2.setOvertimeCost(DatatypeConverter.parseCurrency(task.getOvertimeCost()));
            task2.setOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getOvertimeWork()));
            task2.setPercentageComplete(task.getPercentComplete());
            task2.setPercentageWorkComplete(task.getPercentWorkComplete());
            task2.setPhysicalPercentComplete(NumberHelper.getInteger(task.getPhysicalPercentComplete()));
            task2.setPreleveledFinish(DatatypeConverter.parseDate(task.getPreLeveledFinish()));
            task2.setPreleveledStart(DatatypeConverter.parseDate(task.getPreLeveledStart()));
            task2.setPriority(DatatypeConverter.parsePriority(task.getPriority()));
            task2.setRecurring(BooleanHelper.getBoolean(task.isRecurring()));
            task2.setRegularWork(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getRegularWork()));
            task2.setRemainingCost(DatatypeConverter.parseCurrency(task.getRemainingCost()));
            task2.setRemainingDuration(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getRemainingDuration()));
            task2.setRemainingOvertimeCost(DatatypeConverter.parseCurrency(task.getRemainingOvertimeCost()));
            task2.setRemainingOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getRemainingOvertimeWork()));
            task2.setRemainingWork(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getRemainingWork()));
            task2.setResume(DatatypeConverter.parseDate(task.getResume()));
            task2.setResumeValid(BooleanHelper.getBoolean(task.isResumeValid()));
            task2.setRollup(BooleanHelper.getBoolean(task.isRollup()));
            task2.setStart(DatatypeConverter.parseDate(task.getStart()));
            task2.setStartText(task.getStartText());
            task2.setStartVariance(DatatypeConverter.parseDurationInThousanthsOfMinutes(task.getStartVariance()));
            task2.setStop(DatatypeConverter.parseDate(task.getStop()));
            task2.setSubProject(BooleanHelper.getBoolean(task.isIsSubproject()) ? new SubProject() : null);
            task2.setSubprojectName(task.getSubprojectName());
            task2.setSubprojectReadOnly(BooleanHelper.getBoolean(task.isIsSubprojectReadOnly()));
            task2.setSummary(BooleanHelper.getBoolean(task.isSummary()));
            task2.setTaskMode(BooleanHelper.getBoolean(task.isManual()) ? TaskMode.MANUALLY_SCHEDULED : TaskMode.AUTO_SCHEDULED);
            task2.setType(task.getType());
            task2.setWBS(task.getWBS());
            task2.setWBSLevel(task.getWBSLevel());
            task2.setWork(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getWork()));
            task2.setWorkVariance(Duration.getInstance(NumberHelper.getDouble(task.getWorkVariance()) / 1000.0, TimeUnit.MINUTES));
            this.validateFinishDate(task2);
            task2.setStartSlack(DatatypeConverter.parseDurationInTenthsOfMinutes(task.getStartSlack()));
            task2.setFinishSlack(DatatypeConverter.parseDurationInTenthsOfMinutes(task.getFinishSlack()));
            task2.setFreeSlack(DatatypeConverter.parseDurationInTenthsOfMinutes(task.getFreeSlack()));
            task2.setTotalSlack(DatatypeConverter.parseDurationInTenthsOfMinutes(task.getTotalSlack()));
            task2.setCritical(BooleanHelper.getBoolean(task.isCritical()));
            this.readTaskExtendedAttributes(task, task2);
            this.readTaskBaselines(task, task2, timeUnit);
            if (task2.getTaskMode() == TaskMode.MANUALLY_SCHEDULED) {
                task2.setManualDuration(DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, task.getManualDuration()));
            }
            if (NumberHelper.getInt(task2.getUniqueID()) == 0) {
                this.updateProjectProperties(task2);
            }
        }
        this.m_eventManager.fireTaskReadEvent(task2);
        return task2;
    }

    private void updateProjectProperties(Task task) {
        ProjectProperties projectProperties = this.m_projectFile.getProjectProperties();
        projectProperties.setComments(task.getNotes());
    }

    private void validateFinishDate(Task task) {
        Date date;
        if (task.getFinish() == null && (date = task.getStart()) != null) {
            if (task.getMilestone()) {
                task.setFinish(date);
            } else {
                Duration duration = task.getDuration();
                if (duration != null) {
                    ProjectCalendar projectCalendar = task.getEffectiveCalendar();
                    task.setFinish(projectCalendar.getDate(date, duration, false));
                }
            }
        }
    }

    private void readTaskBaselines(Project.Tasks.Task task, Task task2, TimeUnit timeUnit) {
        for (Project.Tasks.Task.Baseline baseline : task.getBaseline()) {
            int n = NumberHelper.getInt(baseline.getNumber());
            Double d = DatatypeConverter.parseCurrency(baseline.getCost());
            Duration duration = DatatypeConverter.parseDuration(this.m_projectFile, timeUnit, baseline.getDuration());
            Date date = DatatypeConverter.parseDate(baseline.getFinish());
            Date date2 = DatatypeConverter.parseDate(baseline.getStart());
            Duration duration2 = DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, baseline.getWork());
            if (n == 0) {
                task2.setBaselineCost(d);
                task2.setBaselineDuration(duration);
                task2.setBaselineFinish(date);
                task2.setBaselineStart(date2);
                task2.setBaselineWork(duration2);
                continue;
            }
            task2.setBaselineCost(n, d);
            task2.setBaselineDuration(n, duration);
            task2.setBaselineFinish(n, date);
            task2.setBaselineStart(n, date2);
            task2.setBaselineWork(n, duration2);
        }
    }

    private void readTaskExtendedAttributes(Project.Tasks.Task task, Task task2) {
        for (Project.Tasks.Task.ExtendedAttribute extendedAttribute : task.getExtendedAttribute()) {
            int n = Integer.parseInt(extendedAttribute.getFieldID()) & 0xFFFF;
            TaskField taskField = MPPTaskField.getInstance(n);
            TimeUnit timeUnit = DatatypeConverter.parseDurationTimeUnits(extendedAttribute.getDurationFormat(), null);
            DatatypeConverter.parseExtendedAttribute(this.m_projectFile, task2, extendedAttribute.getValue(), taskField, timeUnit);
        }
    }

    private ProjectCalendar getTaskCalendar(Project.Tasks.Task task) {
        ProjectCalendar projectCalendar = null;
        BigInteger bigInteger = task.getCalendarUID();
        if (bigInteger != null) {
            projectCalendar = this.m_projectFile.getCalendarByUniqueID(bigInteger.intValue());
        }
        return projectCalendar;
    }

    protected void readPredecessors(Project.Tasks.Task task) {
        Task task2;
        Integer n = task.getUID();
        if (n != null && (task2 = this.m_projectFile.getTaskByUniqueID(n)) != null) {
            for (Project.Tasks.Task.PredecessorLink predecessorLink : task.getPredecessorLink()) {
                this.readPredecessor(task2, predecessorLink);
            }
        }
    }

    protected void readPredecessor(Task task, Project.Tasks.Task.PredecessorLink predecessorLink) {
        Task task2;
        BigInteger bigInteger = predecessorLink.getPredecessorUID();
        if (bigInteger != null && (task2 = this.m_projectFile.getTaskByUniqueID(bigInteger.intValue())) != null) {
            RelationType relationType = predecessorLink.getType() != null ? RelationType.getInstance(predecessorLink.getType().intValue()) : RelationType.FINISH_START;
            int n = predecessorLink.getLinkLag() != null ? predecessorLink.getLinkLag().intValue() / 10 : 0;
            TimeUnit timeUnit = DatatypeConverter.parseDurationTimeUnits(predecessorLink.getLagFormat());
            Duration duration = Duration.convertUnits(n, TimeUnit.MINUTES, timeUnit, this.m_projectFile.getProjectProperties());
            Relation relation = task.addPredecessor(task2, relationType, duration);
            this.m_eventManager.fireRelationReadEvent(relation);
        }
    }

    private void readAssignments(Project project) {
        Project.Assignments assignments = project.getAssignments();
        if (assignments != null) {
            SplitTaskFactory splitTaskFactory = new SplitTaskFactory();
            MSPDITimephasedWorkNormaliser mSPDITimephasedWorkNormaliser = new MSPDITimephasedWorkNormaliser();
            for (Project.Assignments.Assignment assignment : assignments.getAssignment()) {
                this.readAssignment(assignment, splitTaskFactory, mSPDITimephasedWorkNormaliser);
            }
        }
    }

    protected ResourceAssignment readAssignment(Project.Assignments.Assignment assignment, SplitTaskFactory splitTaskFactory, TimephasedWorkNormaliser timephasedWorkNormaliser) {
        Task task;
        BigInteger bigInteger = assignment.getTaskUID();
        BigInteger bigInteger2 = assignment.getResourceUID();
        if (bigInteger != null && bigInteger2 != null && (task = this.m_projectFile.getTaskByUniqueID(bigInteger.intValue())) != null) {
            Resource resource = this.m_projectFile.getResourceByUniqueID(bigInteger2.intValue());
            ProjectCalendar projectCalendar = null;
            if (resource != null) {
                projectCalendar = resource.getResourceCalendar();
            }
            if (projectCalendar == null || task.getIgnoreResourceCalendar()) {
                projectCalendar = task.getEffectiveCalendar();
            }
            LinkedList<TimephasedWork> linkedList = this.readTimephasedAssignment(projectCalendar, assignment, 2);
            LinkedList<TimephasedWork> linkedList2 = this.readTimephasedAssignment(projectCalendar, assignment, 1);
            boolean bl = true;
            if (this.isSplit(projectCalendar, linkedList) || this.isSplit(projectCalendar, linkedList2)) {
                task.setSplits(new LinkedList<DateRange>());
                timephasedWorkNormaliser.normalise(projectCalendar, linkedList);
                timephasedWorkNormaliser.normalise(projectCalendar, linkedList2);
                splitTaskFactory.processSplitData(task, linkedList, linkedList2);
                bl = false;
            }
            DefaultTimephasedWorkContainer defaultTimephasedWorkContainer = new DefaultTimephasedWorkContainer(projectCalendar, timephasedWorkNormaliser, linkedList, bl);
            DefaultTimephasedWorkContainer defaultTimephasedWorkContainer2 = new DefaultTimephasedWorkContainer(projectCalendar, timephasedWorkNormaliser, linkedList2, bl);
            ResourceAssignment resourceAssignment = task.addResourceAssignment(resource);
            resourceAssignment.setActualCost(DatatypeConverter.parseCurrency(assignment.getActualCost()));
            resourceAssignment.setActualFinish(DatatypeConverter.parseDate(assignment.getActualFinish()));
            resourceAssignment.setActualOvertimeCost(DatatypeConverter.parseCurrency(assignment.getActualOvertimeCost()));
            resourceAssignment.setActualOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getActualOvertimeWork()));
            resourceAssignment.setActualStart(DatatypeConverter.parseDate(assignment.getActualStart()));
            resourceAssignment.setActualWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getActualWork()));
            resourceAssignment.setACWP(DatatypeConverter.parseCurrency(assignment.getACWP()));
            resourceAssignment.setBCWP(DatatypeConverter.parseCurrency(assignment.getBCWP()));
            resourceAssignment.setBCWS(DatatypeConverter.parseCurrency(assignment.getBCWS()));
            resourceAssignment.setBudgetCost(DatatypeConverter.parseCurrency(assignment.getBudgetCost()));
            resourceAssignment.setBudgetWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getBudgetWork()));
            resourceAssignment.setCost(DatatypeConverter.parseCurrency(assignment.getCost()));
            resourceAssignment.setCostRateTableIndex(NumberHelper.getInt(assignment.getCostRateTable()));
            resourceAssignment.setCreateDate(DatatypeConverter.parseDate(assignment.getCreationDate()));
            resourceAssignment.setCV(DatatypeConverter.parseCurrency(assignment.getCV()));
            resourceAssignment.setDelay(DatatypeConverter.parseDurationInTenthsOfMinutes(assignment.getDelay()));
            resourceAssignment.setFinish(DatatypeConverter.parseDate(assignment.getFinish()));
            resourceAssignment.setVariableRateUnits(BooleanHelper.getBoolean(assignment.isHasFixedRateUnits()) ? null : DatatypeConverter.parseTimeUnit(assignment.getRateScale()));
            resourceAssignment.setHyperlink(assignment.getHyperlink());
            resourceAssignment.setHyperlinkAddress(assignment.getHyperlinkAddress());
            resourceAssignment.setHyperlinkSubAddress(assignment.getHyperlinkSubAddress());
            resourceAssignment.setLevelingDelay(DatatypeConverter.parseDurationInTenthsOfMinutes(this.m_projectFile.getProjectProperties(), assignment.getLevelingDelay(), DatatypeConverter.parseDurationTimeUnits(assignment.getLevelingDelayFormat())));
            resourceAssignment.setNotes(assignment.getNotes());
            resourceAssignment.setOvertimeCost(DatatypeConverter.parseCurrency(assignment.getOvertimeCost()));
            resourceAssignment.setOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getOvertimeWork()));
            resourceAssignment.setPercentageWorkComplete(assignment.getPercentWorkComplete());
            resourceAssignment.setRegularWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getRegularWork()));
            resourceAssignment.setRemainingCost(DatatypeConverter.parseCurrency(assignment.getRemainingCost()));
            resourceAssignment.setRemainingOvertimeCost(DatatypeConverter.parseCurrency(assignment.getRemainingOvertimeCost()));
            resourceAssignment.setRemainingOvertimeWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getRemainingOvertimeWork()));
            resourceAssignment.setRemainingWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getRemainingWork()));
            resourceAssignment.setResume(DatatypeConverter.parseDate(assignment.getResume()));
            resourceAssignment.setStart(DatatypeConverter.parseDate(assignment.getStart()));
            resourceAssignment.setStop(DatatypeConverter.parseDate(assignment.getStop()));
            resourceAssignment.setSV(DatatypeConverter.parseCurrency(assignment.getSV()));
            resourceAssignment.setUniqueID(NumberHelper.getInteger(assignment.getUID()));
            resourceAssignment.setUnits(DatatypeConverter.parseUnits(assignment.getUnits()));
            resourceAssignment.setVAC(DatatypeConverter.parseCurrency(assignment.getVAC()));
            resourceAssignment.setWork(DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, assignment.getWork()));
            resourceAssignment.setWorkContour(assignment.getWorkContour());
            resourceAssignment.setTimephasedActualWork(defaultTimephasedWorkContainer);
            resourceAssignment.setTimephasedWork(defaultTimephasedWorkContainer2);
            this.readAssignmentExtendedAttributes(assignment, resourceAssignment);
            this.readAssignmentBaselines(assignment, resourceAssignment);
            resourceAssignment.setCostVariance(DatatypeConverter.parseCurrency(assignment.getCostVariance()));
            resourceAssignment.setWorkVariance(DatatypeConverter.parseDurationInThousanthsOfMinutes(this.m_projectFile.getProjectProperties(), assignment.getWorkVariance(), TimeUnit.HOURS));
            resourceAssignment.setStartVariance(DatatypeConverter.parseDurationInTenthsOfMinutes(this.m_projectFile.getProjectProperties(), assignment.getStartVariance(), TimeUnit.DAYS));
            resourceAssignment.setFinishVariance(DatatypeConverter.parseDurationInTenthsOfMinutes(this.m_projectFile.getProjectProperties(), assignment.getFinishVariance(), TimeUnit.DAYS));
            this.m_eventManager.fireAssignmentReadEvent(resourceAssignment);
            return resourceAssignment;
        }
        return null;
    }

    private void readAssignmentBaselines(Project.Assignments.Assignment assignment, ResourceAssignment resourceAssignment) {
        for (Project.Assignments.Assignment.Baseline baseline : assignment.getBaseline()) {
            int n = NumberHelper.getInt(baseline.getNumber());
            Number number = DatatypeConverter.parseExtendedAttributeCurrency(baseline.getCost());
            Date date = DatatypeConverter.parseExtendedAttributeDate(baseline.getFinish());
            Date date2 = DatatypeConverter.parseExtendedAttributeDate(baseline.getStart());
            Duration duration = DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.HOURS, baseline.getWork());
            if (n == 0) {
                resourceAssignment.setBaselineCost(number);
                resourceAssignment.setBaselineFinish(date);
                resourceAssignment.setBaselineStart(date2);
                resourceAssignment.setBaselineWork(duration);
                continue;
            }
            resourceAssignment.setBaselineCost(n, number);
            resourceAssignment.setBaselineWork(n, duration);
            resourceAssignment.setBaselineStart(n, date2);
            resourceAssignment.setBaselineFinish(n, date);
        }
    }

    private void readAssignmentExtendedAttributes(Project.Assignments.Assignment assignment, ResourceAssignment resourceAssignment) {
        for (Project.Assignments.Assignment.ExtendedAttribute extendedAttribute : assignment.getExtendedAttribute()) {
            int n = Integer.parseInt(extendedAttribute.getFieldID()) & 0xFFFF;
            AssignmentField assignmentField = MPPAssignmentField.getInstance(n);
            TimeUnit timeUnit = DatatypeConverter.parseDurationTimeUnits(extendedAttribute.getDurationFormat(), null);
            DatatypeConverter.parseExtendedAttribute(this.m_projectFile, resourceAssignment, extendedAttribute.getValue(), assignmentField, timeUnit);
        }
    }

    private boolean isSplit(ProjectCalendar projectCalendar, List<TimephasedWork> list) {
        boolean bl = false;
        for (TimephasedWork timephasedWork : list) {
            Duration duration;
            if (projectCalendar == null || ((Duration)timephasedWork.getTotalAmount()).getDuration() != 0.0 || (duration = projectCalendar.getWork(timephasedWork.getStart(), timephasedWork.getFinish(), TimeUnit.MINUTES)).getDuration() == 0.0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private LinkedList<TimephasedWork> readTimephasedAssignment(ProjectCalendar projectCalendar, Project.Assignments.Assignment assignment, int n) {
        LinkedList<TimephasedWork> linkedList = new LinkedList<TimephasedWork>();
        for (TimephasedDataType timephasedDataType : assignment.getTimephasedData()) {
            if (NumberHelper.getInt(timephasedDataType.getType()) != n) continue;
            Date date = DatatypeConverter.parseDate(timephasedDataType.getStart());
            Date date2 = DatatypeConverter.parseDate(timephasedDataType.getFinish());
            Duration duration = DatatypeConverter.parseDuration(this.m_projectFile, TimeUnit.MINUTES, timephasedDataType.getValue());
            duration = duration == null ? Duration.getInstance(0, TimeUnit.MINUTES) : Duration.getInstance(NumberHelper.round(duration.getDuration(), 2.0), TimeUnit.MINUTES);
            TimephasedWork timephasedWork = new TimephasedWork();
            timephasedWork.setStart(date);
            timephasedWork.setFinish(date2);
            timephasedWork.setTotalAmount(duration);
            linkedList.add(timephasedWork);
        }
        return linkedList;
    }

    public void setMicrosoftProjectCompatibleInput(boolean bl) {
        this.m_compatibleInput = bl;
    }

    public boolean getMicrosoftProjectCompatibleInput() {
        return this.m_compatibleInput;
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance("net.sf.mpxj.mspdi.schema", MSPDIReader.class.getClassLoader());
        }
        catch (JAXBException jAXBException) {
            CONTEXT_EXCEPTION = jAXBException;
            CONTEXT = null;
        }
        RECURRENCE_TYPES = new RecurrenceType[]{null, RecurrenceType.DAILY, RecurrenceType.YEARLY, RecurrenceType.YEARLY, RecurrenceType.MONTHLY, RecurrenceType.MONTHLY, RecurrenceType.WEEKLY, RecurrenceType.DAILY};
        RELATIVE_MAP = new boolean[]{false, false, false, true, false, true};
        DAY_MASKS = new int[]{0, 1, 2, 4, 8, 16, 32, 64};
    }
}

