/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.task;

import com.projectlibre1.algorithm.ReverseQuery;
import com.projectlibre1.association.InvalidAssociationException;
import com.projectlibre1.configuration.CircularDependencyException;
import com.projectlibre1.configuration.FieldDictionary;
import com.projectlibre1.configuration.Settings;
import com.projectlibre1.datatype.Duration;
import com.projectlibre1.datatype.Hyperlink;
import com.projectlibre1.datatype.ImageLink;
import com.projectlibre1.document.Document;
import com.projectlibre1.document.ObjectEvent;
import com.projectlibre1.document.ObjectEventManager;
import com.projectlibre1.document.ObjectSelectionEventManager;
import com.projectlibre1.field.Field;
import com.projectlibre1.field.FieldContext;
import com.projectlibre1.field.HasExtraFields;
import com.projectlibre1.functor.IntervalConsumer;
import com.projectlibre1.graphic.configuration.GraphicConfiguration;
import com.projectlibre1.graphic.configuration.SpreadSheetFieldArray;
import com.projectlibre1.grouping.core.Node;
import com.projectlibre1.grouping.core.NodeException;
import com.projectlibre1.grouping.core.NodeFactory;
import com.projectlibre1.grouping.core.NodeList;
import com.projectlibre1.grouping.core.NodeVisitor;
import com.projectlibre1.grouping.core.OutlineCollection;
import com.projectlibre1.grouping.core.OutlineCollectionImpl;
import com.projectlibre1.grouping.core.event.HierarchyEvent;
import com.projectlibre1.grouping.core.event.HierarchyListener;
import com.projectlibre1.grouping.core.hierarchy.NodeHierarchy;
import com.projectlibre1.grouping.core.model.AssignmentNodeModel;
import com.projectlibre1.grouping.core.model.NodeModel;
import com.projectlibre1.grouping.core.model.NodeModelDataFactory;
import com.projectlibre1.grouping.core.model.NodeModelFactory;
import com.projectlibre1.grouping.core.transform.filtering.NotAssignmentFilter;
import com.projectlibre1.options.CalendarOption;
import com.projectlibre1.options.TimesheetOption;
import com.projectlibre1.pm.assignment.Assignment;
import com.projectlibre1.pm.assignment.HasTimeDistributedData;
import com.projectlibre1.pm.assignment.TimeDistributedDataConsolidator;
import com.projectlibre1.pm.assignment.TimeDistributedFields;
import com.projectlibre1.pm.assignment.timesheet.TimesheetHelper;
import com.projectlibre1.pm.assignment.timesheet.UpdatesFromTimesheet;
import com.projectlibre1.pm.calendar.CalendarService;
import com.projectlibre1.pm.calendar.HasBaseCalendar;
import com.projectlibre1.pm.calendar.HasCalendar;
import com.projectlibre1.pm.calendar.WorkCalendar;
import com.projectlibre1.pm.calendar.WorkingCalendar;
import com.projectlibre1.pm.costing.EarnedValueCalculator;
import com.projectlibre1.pm.costing.EarnedValueFields;
import com.projectlibre1.pm.costing.EarnedValueValues;
import com.projectlibre1.pm.costing.HasExpenseType;
import com.projectlibre1.pm.criticalpath.CriticalPath;
import com.projectlibre1.pm.criticalpath.HasSentinels;
import com.projectlibre1.pm.criticalpath.SchedulingAlgorithm;
import com.projectlibre1.pm.dependency.Dependency;
import com.projectlibre1.pm.dependency.DependencyService;
import com.projectlibre1.pm.key.HasKey;
import com.projectlibre1.pm.key.HasKeyImpl;
import com.projectlibre1.pm.resource.Resource;
import com.projectlibre1.pm.resource.ResourcePool;
import com.projectlibre1.pm.scheduling.BarClosure;
import com.projectlibre1.pm.scheduling.Schedule;
import com.projectlibre1.pm.scheduling.ScheduleEvent;
import com.projectlibre1.pm.scheduling.ScheduleEventListener;
import com.projectlibre1.pm.scheduling.ScheduleEventManager;
import com.projectlibre1.pm.scheduling.ScheduleInterval;
import com.projectlibre1.pm.scheduling.ScheduleUtil;
import com.projectlibre1.pm.snapshot.BaselineScheduleFields;
import com.projectlibre1.pm.snapshot.Snapshottable;
import com.projectlibre1.pm.snapshot.SnapshottableImpl;
import com.projectlibre1.pm.task.BelongsToDocument;
import com.projectlibre1.pm.task.ExternalTaskManager;
import com.projectlibre1.pm.task.HasNotes;
import com.projectlibre1.pm.task.HasPriority;
import com.projectlibre1.pm.task.NormalTask;
import com.projectlibre1.pm.task.ProjectEvent;
import com.projectlibre1.pm.task.ProjectFactory;
import com.projectlibre1.pm.task.ProjectListener;
import com.projectlibre1.pm.task.ProjectSpecificFields;
import com.projectlibre1.pm.task.SubProj;
import com.projectlibre1.pm.task.SubprojectHandler;
import com.projectlibre1.pm.task.Task;
import com.projectlibre1.pm.task.TaskBackup;
import com.projectlibre1.pm.task.TaskSnapshot;
import com.projectlibre1.pm.time.MutableHasStartAndEnd;
import com.projectlibre1.print.PrintSettings;
import com.projectlibre1.server.access.ErrorLogger;
import com.projectlibre1.server.data.DataObject;
import com.projectlibre1.server.data.DistributionComparator;
import com.projectlibre1.server.data.DistributionConverter;
import com.projectlibre1.server.data.DistributionData;
import com.projectlibre1.session.FileHelper;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.transaction.MultipleTransactionManager;
import com.projectlibre1.undo.ClearSnapshotEdit;
import com.projectlibre1.undo.DataFactoryUndoController;
import com.projectlibre1.undo.SaveSnapshotEdit;
import com.projectlibre1.util.Alert;
import com.projectlibre1.util.DateTime;
import com.projectlibre1.util.Environment;
import com.projectlibre1.workspace.SavableToWorkspace;
import com.projectlibre1.workspace.WorkspaceSetting;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.undo.UndoableEditSupport;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public class Project
implements Document,
BelongsToDocument,
HasKey,
HasPriority,
MutableHasStartAndEnd,
ProjectSpecificFields,
HasNotes,
HasBaseCalendar,
HasCalendar,
NodeModelDataFactory,
HierarchyListener,
HasTimeDistributedData,
TimeDistributedFields,
EarnedValueValues,
EarnedValueFields,
DataObject,
HasSentinels,
BaselineScheduleFields,
Schedule,
UpdatesFromTimesheet,
HasExtraFields,
HasExpenseType,
SavableToWorkspace {
    static final long serialVersionUID = 17283790404932L;
    private long statusDate = 0L;
    private String manager = "";
    private transient HasKeyImpl hasKey;
    private String notes = "";
    private transient LinkedList tasks = new LinkedList();
    private transient ResourcePool resourcePool = null;
    private transient SchedulingAlgorithm schedulingAlgorithm = null;
    private transient boolean initialized = false;
    private transient ScheduleEventManager scheduleEventManager = new ScheduleEventManager();
    private transient MultipleTransactionManager multipleTransactionManager = new MultipleTransactionManager();
    private transient ObjectEventManager objectEventManager = new ObjectEventManager();
    private transient ObjectSelectionEventManager objectSelectionEventManager = new ObjectSelectionEventManager();
    private transient int taskIdCounter = 0;
    private transient boolean isGroupDirty = false;
    private transient boolean isDirty = false;
    private transient boolean readOnly = false;
    private transient SubprojectHandler subprojectHandler;
    public static transient Project lastDeserialized = null;
    long start;
    long end;
    long duration;
    boolean forward = true;
    int priority = 500;
    long currentDate = 0L;
    private Map extraFields = null;
    private double risk = 0.0;
    private double netPresentValue = 0.0;
    private int benefit = 0;
    transient int projectStatus = 0;
    transient int projectType = 0;
    transient int expenseType = 0;
    transient String group;
    transient String division;
    private transient boolean openedAsSubproject = false;
    private transient Hyperlink documentFolderUrl = null;
    private transient long earliestStartingTask = 0L;
    private transient long latestFinishingTask = 0L;
    private static Project dummy = null;
    private transient NodeModel taskModel = null;
    private transient NodeModel resourceModel = null;
    private transient Object taskCache = null;
    private transient Object resourceCache = null;
    private transient List<Task> repaired = null;
    private transient Date creationDate;
    private transient Date lastModificationDate;
    private transient OutlineCollection taskOutlines = new OutlineCollectionImpl(Settings.numHierarchies(), this);
    WorkCalendar workCalendar = null;
    protected transient EventListenerList projectListenerList = new EventListenerList();
    private transient BarClosure barClosureInstance = new BarClosure();
    Workspace workspace;
    protected transient DataFactoryUndoController undoController;
    protected boolean master = false;
    protected transient boolean temporaryLocal;
    private transient ExternalTaskManager externalTaskManager = null;
    protected transient int accessControlPolicy;
    protected transient String fileName;
    protected transient int fileType = 1;
    public transient SpreadSheetFieldArray fieldArray = null;
    public transient PrintSettings printSettings = null;
    public transient PrintSettings tmpSettings = null;
    public transient CalendarOption calendarOption = null;
    private transient TreeMap<DistributionData, DistributionData> distributionMap;
    private transient TreeMap<DistributionData, DistributionData> newDistributionMap;
    protected transient boolean forceNonIncremental;
    protected transient boolean forceNonIncrementalDistributions;
    public static final float CURRENT_VERSION = 1.2f;
    protected float version = 1.2f;

    public NodeModel getTaskModel() {
        if (this.taskModel == null) {
            this.taskModel = NodeModelFactory.createTaskModel(this);
        }
        return this.taskModel;
    }

    public NodeModel getResourceModel() {
        if (this.resourceModel == null) {
            this.resourceModel = NodeModelFactory.createResourceModel(this);
        }
        return this.resourceModel;
    }

    public Object getResourceCache() {
        return this.resourceCache;
    }

    public void setResourceCache(Object object) {
        this.resourceCache = object;
    }

    public Object getTaskCache() {
        return this.taskCache;
    }

    public void setTaskCache(Object object) {
        this.taskCache = object;
    }

    private Project(boolean bl) {
        this.initSubprojectHandler();
        this.hasKey = new HasKeyImpl(bl, this);
        this.setWorkCalendar(CalendarService.getInstance().getDefaultInstance());
        this.start = CalendarOption.getInstance().makeValidStart(DateTime.midnightToday(), true);
        this.end = this.start = this.getEffectiveWorkCalendar().adjustInsideCalendar(this.start, false);
        this.calendarOption = CalendarOption.getDefaultInstance();
    }

    private Project(ResourcePool resourcePool, DataFactoryUndoController dataFactoryUndoController) {
        this(resourcePool.isLocal());
        this.resourcePool = resourcePool;
        this.undoController = dataFactoryUndoController;
    }

    public void dispose() {
        System.out.println("disposing project " + String.valueOf(this));
    }

    public static Project getDummy() {
        if (dummy == null) {
            dummy = new Project(true);
        }
        return dummy;
    }

    public static Project createProject(ResourcePool resourcePool, DataFactoryUndoController dataFactoryUndoController) {
        Project project = new Project(resourcePool, dataFactoryUndoController);
        project.initializeProject();
        project.setUndoController(dataFactoryUndoController);
        return project;
    }

    public void initializeOutlines() {
        int n = Settings.numHierarchies();
        for (int i = 0; i < n; ++i) {
            NodeModel nodeModel = this.taskOutlines.getOutline(i);
            if (nodeModel == null) continue;
            if (nodeModel instanceof AssignmentNodeModel) {
                AssignmentNodeModel assignmentNodeModel = (AssignmentNodeModel)nodeModel;
                assignmentNodeModel.setContainsLeftObjects(true);
                assignmentNodeModel.setDocument(this);
            }
            nodeModel.setUndoController(this.undoController);
        }
        this.initializeDefaultOutline();
    }

    public void disconnectOutlines() {
        int n = Settings.numHierarchies();
        for (int i = 0; i < n; ++i) {
            NodeModel nodeModel = this.taskOutlines.getOutline(i);
            if (!(nodeModel instanceof AssignmentNodeModel)) continue;
            AssignmentNodeModel assignmentNodeModel = (AssignmentNodeModel)nodeModel;
            assignmentNodeModel.setDocument(null);
        }
        this.disconnectDefaultOutline();
    }

    public long getStartConstraint() {
        long l = this.getReferringSubprojectTaskDependencyDate();
        long l2 = l > this.getStart() ? this.getEffectiveWorkCalendar().adjustInsideCalendar(l, false) : this.getStart();
        return l2;
    }

    public void initialize(boolean bl, boolean bl2) {
        this.initialized = true;
        this.repairTasks();
        if (!bl) {
            this.schedulingAlgorithm.initialize(this);
        }
        if (this.getStart() == 0L) {
            System.out.println("no start so using earliest");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Project.this.recalculate();
                    Project.this.setStart(Project.this.getEarliestStartingTaskOrStart());
                }
            });
        }
        this.initializeDefaultOutline();
        if (TimesheetOption.getInstance().isAutomaticallyIntegrateTimecardData()) {
            this.applyTimesheet(TimesheetOption.getInstance().getTimesheetFieldArray());
        }
        this.setAllTasksAsUnchangedFromPersisted(false);
        if (bl2) {
            this.updateDistributionMap();
        }
    }

    void setEarliestAndLatestDatesFromSchedule() {
        Iterator iterator = this.tasks.iterator();
        long l = Long.MAX_VALUE;
        long l2 = 0L;
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            if (task.isExternal() || task.getOwningProject() != this) continue;
            l = Math.min(l, task.getStart());
            l2 = Math.max(l2, task.getEnd());
        }
        this.earliestStartingTask = l != Long.MAX_VALUE ? l : this.getStart();
        this.latestFinishingTask = l2 != 0L ? l2 : this.getEnd();
    }

    public void initializeProject() {
        this.setSchedulingAlgorithm(new CriticalPath(this));
        this.initializeOutlines();
    }

    public void disconnect() {
        this.disconnectOutlines();
        this.removeObjectListener(this.getSchedulingAlgorithm());
        this.schedulingAlgorithm = null;
    }

    private void initializeDefaultOutline() {
        this.taskOutlines.getDefaultOutline().getHierarchy().addHierarchyListener(this);
    }

    private void disconnectDefaultOutline() {
        this.taskOutlines.getDefaultOutline().getHierarchy().removeHierarchyListener(this);
    }

    public NormalTask newNormalTaskInstance() {
        return this.newNormalTaskInstance(true);
    }

    public void initializeId(Task task) {
        long l = ++this.taskIdCounter;
        task.setId(l);
    }

    public NormalTask newNormalTaskInstance(boolean bl) {
        NormalTask normalTask = new NormalTask(this);
        this.add(normalTask);
        this.initializeId(normalTask);
        if (bl) {
            this.objectEventManager.fireCreateEvent(this, normalTask);
        }
        return normalTask;
    }

    public void setLocalParent(Task task, Task task2) {
        Node node = this.getTaskModel().search(task);
        Node node2 = task2 == null ? null : this.getTaskModel().search(task2);
        this.setLocalParent(node, node2);
    }

    public void setLocalParent(Node node, Node node2) {
        Task task = (Task)node.getImpl();
        Task task2 = (Task)(node2 == null ? null : node2.getImpl());
        if (task.getWbsParentTask() == task2) {
            return;
        }
        Node node3 = this.getTaskModel().search(task.getWbsParentTask());
        if (node3 != null) {
            node3.getChildren().remove(node);
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(node);
        this.getTaskModel().move(node2, arrayList, -1, 3);
        this.setDefaultRelationship(node2, node);
    }

    public Node createLocalTaskNode(Node node) {
        NormalTask normalTask = new NormalTask(this);
        Node node2 = NodeFactory.getInstance().createNode(normalTask);
        this.connectTask(normalTask);
        this.addToDefaultOutline(node, node2);
        this.getSchedulingAlgorithm().addObject(normalTask);
        return node2;
    }

    public NormalTask newStandaloneNormalTaskInstance() {
        NormalTask normalTask = new NormalTask(this);
        normalTask.getCurrentSchedule().setStart(this.getWorkCalendar().adjustInsideCalendar(normalTask.getCurrentSchedule().getStart(), false));
        this.initializeId(normalTask);
        return normalTask;
    }

    public NormalTask createScriptedTask() {
        NormalTask normalTask = this.newStandaloneNormalTaskInstance();
        this.connectTask(normalTask);
        this.taskOutlines.addToAll(normalTask, null);
        normalTask.markTaskAsNeedingRecalculation();
        this.updateScheduling(this, normalTask, 1);
        return normalTask;
    }

    public void connectTask(Task task) {
        Project project;
        if (!this.isOpenedAsSubproject() || !this.tasks.contains(task)) {
            this.add(task);
        }
        if (task.getOwningProject() == null) {
            task.setOwningProject(this);
        }
        if (task.getProjectId() == 0L) {
            task.setProjectId(this.getUniqueId());
        }
        if ((project = (Project)task.getMasterDocument()) == this) {
            task.setProject(this);
            if (task.getSuccessorList().size() == 0) {
                this.addEndSentinelDependency(task);
            }
            if (task.getPredecessorList().size() == 0) {
                this.addStartSentinelDependency(task);
            }
        } else {
            project.add(task);
            task.setProject(project);
        }
    }

    @Override
    public long getStatusDate() {
        if (this.statusDate == 0L) {
            return this.workCalendar.adjustInsideCalendar(DateTime.midnightTomorrow() - 1L, true);
        }
        return this.statusDate;
    }

    @Override
    public void setStatusDate(long l) {
        l = DateTime.midnightNextDay(l) - 1L;
        this.statusDate = l = this.workCalendar.adjustInsideCalendar(l, true);
    }

    @Override
    public final int getPriority() {
        return this.priority;
    }

    @Override
    public final void setPriority(int n) {
        this.priority = n;
    }

    public void add(Task task) {
        this.tasks.add(task);
    }

    public LinkedList getTasks() {
        return this.tasks;
    }

    @Override
    public ResourcePool getResourcePool() {
        return this.resourcePool;
    }

    public void setResourcePool(ResourcePool resourcePool) {
        this.resourcePool = resourcePool;
    }

    public void accept(NodeVisitor nodeVisitor) {
        nodeVisitor.execute(this);
    }

    public Class getType() throws NodeException {
        return this.getClass();
    }

    public boolean isVirtual() {
        return false;
    }

    public void setVirtual(boolean bl) {
    }

    public NodeModel getTaskOutline() {
        return this.taskOutlines.getOutline();
    }

    public NodeModel getTaskOutline(int n) {
        return this.taskOutlines.getOutline(n);
    }

    public void addToDefaultOutline(Node node, Node node2) {
        this.taskOutlines.addToDefaultOutline(node, node2);
        if (node == null) {
            return;
        }
        this.setDefaultRelationship(node, node2);
    }

    public void addToDefaultOutline(Node node, Node node2, int n, boolean bl) {
        this.taskOutlines.addToDefaultOutline(node, node2, n, bl);
        if (node == null || node2.isVoid()) {
            return;
        }
        this.setDefaultRelationship(node, node2);
    }

    public OutlineCollection getTaskOutlines() {
        return this.taskOutlines;
    }

    private void setDefaultRelationship(Node node, Node node2) {
        Task task = (Task)node2.getImpl();
        if (node == null) {
            task.setWbsParent(null);
        } else {
            Task task2 = (Task)node.getImpl();
            task.setWbsParent(task2);
            if (task2 != null) {
                task2.setWbsChildrenNodes(this.taskOutlines.getDefaultOutline().getHierarchy().getChildren(node));
            }
        }
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getEnd() {
        return this.end;
    }

    @Override
    public long getDuration() {
        return this.getEffectiveWorkCalendar().compare(this.end, this.start, false);
    }

    @Override
    public WorkCalendar getWorkCalendar() {
        return this.workCalendar;
    }

    @Override
    public void setWorkCalendar(WorkCalendar workCalendar) {
        if (this.workCalendar != null) {
            ((WorkingCalendar)this.workCalendar).removeObjectUsing(this);
        }
        this.workCalendar = workCalendar;
        ((WorkingCalendar)this.workCalendar).addObjectUsing(this);
    }

    @Override
    public WorkCalendar getEffectiveWorkCalendar() {
        return this.workCalendar;
    }

    public HasCalendar getHasCalendar() {
        return this;
    }

    @Override
    public void setEnd(long l) {
        this.end = l;
    }

    @Override
    public void setStart(long l) {
        this.start = l;
    }

    public static Task findTaskById(Object object, Collection collection) {
        Iterator iterator = collection.iterator();
        int n = ((Number)object).intValue();
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            if (task.getId() != (long)n) continue;
            return task;
        }
        return null;
    }

    public Task findByUniqueId(long l) {
        Iterator<Task> iterator = this.getTaskOutlineIterator();
        while (iterator.hasNext()) {
            Task task = iterator.next();
            if (task.getUniqueId() != l) continue;
            return task;
        }
        return null;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public String getManager() {
        return this.manager;
    }

    @Override
    public void setManager(String string) {
        this.manager = string;
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    @Override
    public void setNotes(String string) {
        this.notes = string;
    }

    @Override
    public Date getCreated() {
        return this.hasKey.getCreated();
    }

    @Override
    public long getId() {
        return this.hasKey.getId();
    }

    @Override
    public String getName() {
        return this.hasKey.getName();
    }

    @Override
    public long getUniqueId() {
        return this.hasKey.getUniqueId();
    }

    @Override
    public void setCreated(Date date) {
        this.hasKey.setCreated(date);
    }

    @Override
    public void setId(long l) {
        this.hasKey.setId(l);
    }

    @Override
    public void setName(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        String string2 = this.getName();
        this.hasKey.setName(string);
        if (string2 == null && string != null || !string2.equals(string)) {
            this.fireNameChanged(this, string2);
        }
        if (this.getWorkCalendar() == null) {
            System.out.println("error work calendar is null on project");
        }
    }

    public void addProjectListener(ProjectListener projectListener) {
        this.projectListenerList.add(ProjectListener.class, projectListener);
    }

    public void removeProjectListener(ProjectListener projectListener) {
        this.projectListenerList.remove(ProjectListener.class, projectListener);
    }

    public ProjectListener[] getProjectListeners() {
        return (ProjectListener[])this.projectListenerList.getListeners(ProjectListener.class);
    }

    public EventListener[] getProjectListeners(Class clazz) {
        return this.projectListenerList.getListeners(clazz);
    }

    protected void fireNameChanged(Object object, String string) {
        Object[] objectArray = this.projectListenerList.getListenerList();
        ProjectEvent projectEvent = null;
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ProjectListener.class) continue;
            if (projectEvent == null) {
                projectEvent = new ProjectEvent(object, 1, this, string);
            }
            ((ProjectListener)objectArray[i + 1]).nameChanged(projectEvent);
        }
    }

    protected void fireGroupDirtyChanged(Object object, boolean bl) {
        Object[] objectArray = this.projectListenerList.getListenerList();
        ProjectEvent projectEvent = null;
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ProjectListener.class) continue;
            if (projectEvent == null) {
                projectEvent = new ProjectEvent(object, 2, this, new Boolean(bl));
            }
            ((ProjectListener)objectArray[i + 1]).groupDirtyChanged(projectEvent);
        }
    }

    @Override
    public void setUniqueId(long l) {
        this.hasKey.setUniqueId(l);
    }

    @Override
    public Object createUnvalidatedObject(NodeModel nodeModel, Object object) {
        NormalTask normalTask = this.newStandaloneNormalTaskInstance();
        normalTask.setWbsParent((Task)object);
        return normalTask;
    }

    @Override
    public void addUnvalidatedObject(Object object, NodeModel nodeModel, Object object2) {
        if (!(object instanceof NormalTask)) {
            return;
        }
        NormalTask normalTask = (NormalTask)object;
        normalTask.setWbsParent((Task)object2);
        normalTask.setInSubproject(normalTask.liesInSubproject());
    }

    @Override
    public NodeModelDataFactory getFactoryToUseForChildOfParent(Object object) {
        if (object == null || !(object instanceof Task)) {
            return this;
        }
        return ((Task)object).getEnclosingProject();
    }

    @Override
    public void validateObject(Object object, NodeModel nodeModel, Object object2, Object object3, boolean bl) {
        if (!(object instanceof Task)) {
            return;
        }
        Task task = (Task)object;
        task.setProject((Project)this.getSchedulingAlgorithm().getMasterDocument());
        task.setOwningProject(this);
        this.connectTask(task);
        this.taskOutlines.addToAll(object, nodeModel);
        Task task2 = task.getWbsParentTask();
        Node node = task2 == null ? null : nodeModel.search(task.getWbsParentTask());
        Node node2 = nodeModel.search(task);
        this.setDefaultRelationship(node, node2);
        task.markTaskAsNeedingRecalculation();
        this.updateScheduling(this, object, 1);
    }

    public void updateScheduling(Object object, Object object2, int n) {
        ObjectEvent objectEvent = ObjectEvent.getInstance(object, object2, n, null);
        this.getSchedulingAlgorithm().objectChanged(objectEvent);
        objectEvent.recycle();
    }

    public void updateScheduling(Object object, Object object2, int n, Field field) {
        ObjectEvent objectEvent = ObjectEvent.getInstance(object, object2, n, null);
        objectEvent.setField(field);
        this.getSchedulingAlgorithm().objectChanged(objectEvent);
        objectEvent.recycle();
    }

    @Override
    public void remove(Object object, NodeModel nodeModel, boolean bl, boolean bl2, boolean bl3) {
        NodeModel nodeModel2 = nodeModel;
        if (!(object instanceof Task)) {
            return;
        }
        Task task = (Task)object;
        Project project = task.getOwningProject();
        if (project != this) {
            project.taskOutlines.removeFromAll(object, null);
            project.tasks.remove(task);
        }
        task.cleanUp(nodeModel2, bl, bl2, bl3);
        this.tasks.remove(task);
        this.taskOutlines.removeFromAll(task, nodeModel);
        if (task.isSubproject()) {
            Project project2 = ((SubProj)((Object)task)).getSubproject();
            ProjectFactory.getInstance().removeProject(project2, false, false, true);
        }
        this.objectEventManager.fireDeleteEvent(nodeModel2, task);
    }

    public void removeExternal(Task task) {
        this.tasks.remove(task);
        this.taskOutlines.removeFromAll(task, null);
        this.objectEventManager.fireDeleteEvent(this, task);
    }

    public void saveCurrentToSnapshot(Object object, boolean bl, List list, boolean bl2) {
        UndoableEditSupport undoableEditSupport;
        if (bl) {
            this.forTasks(new SnapshottableImpl.SaveCurrentToSnapshotClosure(object));
        } else {
            CollectionUtils.forAllDo(list, new SnapshottableImpl.SaveCurrentToSnapshotClosure(object));
        }
        this.fireBaselineChanged(this, null, (Integer)object, true);
        if (bl2 && (undoableEditSupport = this.getUndoController().getEditSupport()) != null) {
            undoableEditSupport.postEdit(new SaveSnapshotEdit(this, object, bl, list));
        }
    }

    public void restoreSnapshot(Object object, boolean bl, List list, Collection collection) {
        Iterator<Task> iterator;
        if (bl) {
            iterator = this.getTaskOutlineIterator();
        } else {
            if (list == null) {
                return;
            }
            iterator = list.iterator();
        }
        Iterator iterator2 = collection.iterator();
        while (iterator.hasNext()) {
            NormalTask normalTask = (NormalTask)iterator.next();
            normalTask.restoreSnapshot(object, iterator2.next());
        }
        this.fireBaselineChanged(this, null, (Integer)object, true);
    }

    public void clearSnapshot(Object object, boolean bl, List list, boolean bl2) {
        Object object2;
        ArrayList<TaskBackup> arrayList;
        Iterator<Task> iterator = bl ? this.getTaskOutlineIterator() : (list == null ? null : list.iterator());
        boolean[] blArray = new boolean[1];
        if (bl2 && iterator != null && iterator.hasNext()) {
            arrayList = new ArrayList<TaskBackup>();
            while (iterator.hasNext()) {
                object2 = (NormalTask)iterator.next();
                TaskBackup taskBackup = (TaskBackup)((NormalTask)object2).backupDetail(object);
                if (taskBackup.snapshot != null) {
                    blArray[0] = true;
                }
                arrayList.add(taskBackup);
            }
        } else {
            arrayList = null;
        }
        if (bl) {
            this.forTasks(new SnapshottableImpl.ClearSnapshotClosure(object));
        } else {
            CollectionUtils.forAllDo(list, new SnapshottableImpl.ClearSnapshotClosure(object));
        }
        this.fireBaselineChanged(this, null, (Integer)object, false);
        if (blArray[0] && (object2 = this.getUndoController().getEditSupport()) != null) {
            ((UndoableEditSupport)object2).postEdit(new ClearSnapshotEdit(this, object, bl, list, arrayList));
        }
    }

    @Override
    public String getName(FieldContext fieldContext) {
        return this.hasKey.getName(fieldContext);
    }

    public String toString() {
        return this.getName();
    }

    public void addScheduleListener(ScheduleEventListener scheduleEventListener) {
        this.scheduleEventManager.addListener(scheduleEventListener);
    }

    public void removeScheduleListener(ScheduleEventListener scheduleEventListener) {
        this.scheduleEventManager.removeListener(scheduleEventListener);
    }

    @Override
    public void addObjectListener(ObjectEvent.Listener listener) {
        this.objectEventManager.addListener(listener);
    }

    @Override
    public void removeObjectListener(ObjectEvent.Listener listener) {
        this.objectEventManager.removeListener(listener);
    }

    @Override
    public ObjectEventManager getObjectEventManager() {
        return this.objectEventManager;
    }

    public void fireScheduleChanged(Object object, String string) {
        this.scheduleEventManager.fire(object, string);
    }

    public void fireScheduleChanged(Object object, String string, Object object2) {
        this.scheduleEventManager.fire(object, string, object2);
    }

    public void fireBaselineChanged(Object object, Object object2, Integer n, boolean bl) {
        this.scheduleEventManager.fireBaselineChanged(object, null, n, bl);
    }

    @Override
    public Document getDocument() {
        return this;
    }

    @Override
    public void buildReverseQuery(ReverseQuery reverseQuery) {
        Iterator iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            ((Task)iterator.next()).buildReverseQuery(reverseQuery);
        }
    }

    @Override
    public void forEachWorkingInterval(Closure closure, boolean bl, WorkCalendar workCalendar) {
        Iterator iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            ((Task)iterator.next()).forEachWorkingInterval(closure, bl, workCalendar);
        }
    }

    @Override
    public double acwp(long l, long l2) {
        return TimeDistributedDataConsolidator.acwp(l, l2, this.childrenToRollup());
    }

    @Override
    public double bac(long l, long l2) {
        return TimeDistributedDataConsolidator.bac(l, l2, this.childrenToRollup());
    }

    @Override
    public double bcwp(long l, long l2) {
        return TimeDistributedDataConsolidator.bcwp(l, l2, this.childrenToRollup());
    }

    @Override
    public double bcws(long l, long l2) {
        return TimeDistributedDataConsolidator.bcws(l, l2, this.childrenToRollup());
    }

    @Override
    public double baselineCost(long l, long l2) {
        return TimeDistributedDataConsolidator.baselineCost(l, l2, this.childrenToRollup());
    }

    @Override
    public long baselineWork(long l, long l2) {
        return TimeDistributedDataConsolidator.baselineWork(l, l2, this.childrenToRollup(), true);
    }

    @Override
    public double cost(long l, long l2) {
        return TimeDistributedDataConsolidator.cost(l, l2, this.childrenToRollup());
    }

    @Override
    public double actualCost(long l, long l2) {
        return TimeDistributedDataConsolidator.actualCost(l, l2, this.childrenToRollup());
    }

    @Override
    public double fixedCost(long l, long l2) {
        return TimeDistributedDataConsolidator.fixedCost(l, l2, this.childrenToRollup());
    }

    @Override
    public double actualFixedCost(long l, long l2) {
        return TimeDistributedDataConsolidator.actualFixedCost(l, l2, this.childrenToRollup());
    }

    @Override
    public boolean fieldHideActualFixedCost(FieldContext fieldContext) {
        return false;
    }

    @Override
    public long work(long l, long l2) {
        return TimeDistributedDataConsolidator.work(l, l2, this.childrenToRollup(), true);
    }

    @Override
    public long actualWork(long l, long l2) {
        return TimeDistributedDataConsolidator.actualWork(l, l2, this.childrenToRollup(), true);
    }

    @Override
    public long remainingWork(long l, long l2) {
        return TimeDistributedDataConsolidator.remainingWork(l, l2, this.childrenToRollup(), true);
    }

    boolean isInRange(long l, long l2) {
        long l3 = this.getStart();
        return l2 > l3 && l < this.getEnd();
    }

    private boolean isFieldHidden(FieldContext fieldContext) {
        return fieldContext != null && !this.isInRange(fieldContext.getStart(), fieldContext.getEnd());
    }

    @Override
    public boolean fieldHideCost(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideWork(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideActualCost(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideActualWork(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideBaselineCost(int n, FieldContext fieldContext) {
        return false;
    }

    @Override
    public boolean fieldHideBaselineWork(int n, FieldContext fieldContext) {
        return false;
    }

    @Override
    public boolean fieldHideAcwp(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideBac(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideBcwp(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideBcws(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideCv(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideSv(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideEac(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideVac(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideCpi(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideSpi(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideCvPercent(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideSvPercent(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideTcpi(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public double getCost(FieldContext fieldContext) {
        return this.getFixedCost(fieldContext) + this.cost(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getFixedCost(FieldContext fieldContext) {
        return this.fixedCost(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getActualFixedCost(FieldContext fieldContext) {
        return this.actualFixedCost(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public long getWork(FieldContext fieldContext) {
        return this.work(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getActualCost(FieldContext fieldContext) {
        return this.getActualFixedCost(fieldContext) + this.actualCost(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public long getActualWork(FieldContext fieldContext) {
        return this.actualWork(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public long getRemainingWork(FieldContext fieldContext) {
        return this.remainingWork(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getRemainingCost(FieldContext fieldContext) {
        return this.getCost(fieldContext) - this.getActualCost(fieldContext);
    }

    public double getBaselineCost(FieldContext fieldContext) {
        return this.baselineCost(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public long getBaselineWork(FieldContext fieldContext) {
        return this.baselineWork(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public void nodeRemoved(HierarchyEvent hierarchyEvent) {
    }

    @Override
    public double getAcwp(FieldContext fieldContext) {
        return this.acwp(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getBac(FieldContext fieldContext) {
        return this.bac(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getBcwp(FieldContext fieldContext) {
        return this.bcwp(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getBcws(FieldContext fieldContext) {
        return this.bcws(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getCv(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().cv(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getSv(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().sv(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getEac(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().eac(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getVac(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().vac(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getCpi(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().cpi(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getSpi(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().spi(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getCsi(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().csi(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getCvPercent(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().cvPercent(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getSvPercent(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().svPercent(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getTcpi(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().tcpi(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public Collection childrenToRollup() {
        return this.tasks;
    }

    @Override
    public String getSchedulingMethod() {
        return this.schedulingAlgorithm.getName();
    }

    @Override
    public double getBaselineCost(int n, FieldContext fieldContext) {
        return this.baselineCost(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public long getBaselineWork(int n, FieldContext fieldContext) {
        return this.baselineWork(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    public void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    @Override
    public void nodesChanged(HierarchyEvent hierarchyEvent) {
        int n = hierarchyEvent.getNodes().length;
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Node node = (Node)hierarchyEvent.getNodes()[i];
            if (!(node.getImpl() instanceof Task)) continue;
            Task task = (Task)node.getImpl();
            Task task2 = task.getWbsParentTask();
            Node node2 = this.taskOutlines.getDefaultOutline().search(task2);
            if (task2 != null) {
                task2.markAllDependentTasksAsNeedingRecalculation(true);
                task2.setWbsChildrenNodes(this.taskOutlines.getDefaultOutline().getHierarchy().getChildren(node2));
            }
            NodeHierarchy nodeHierarchy = this.taskOutlines.getDefaultOutline().getHierarchy();
            Node node3 = nodeHierarchy.getParent(node);
            Task task3 = null;
            if (node3 != nodeHierarchy.getRoot()) {
                task3 = (Task)node3.getImpl();
                task3.setWbsChildrenNodes(this.taskOutlines.getDefaultOutline().getHierarchy().getChildren(node3));
                task3.restrictToValidConstraintType();
                task3.markAllDependentTasksAsNeedingRecalculation(true);
            }
            task.setWbsParent(task3);
            final Task task4 = task3;
            final Object object = hierarchyEvent.getSource();
            this.taskOutlines.getDefaultOutline().getHierarchy().visitAll(node3, new Closure(){

                @Override
                public void execute(Object object2) {
                    Node node = (Node)object2;
                    if (!(node.getImpl() instanceof Task)) {
                        return;
                    }
                    Task task = (Task)node.getImpl();
                    DependencyService.getInstance().removeAnyDependencies(task, task4, object);
                }
            });
        }
        if (!hierarchyEvent.isVoid()) {
            hierarchyEvent.consume();
            this.updateScheduling(hierarchyEvent.getSource(), this, 1);
        }
    }

    @Override
    public void nodesInserted(HierarchyEvent hierarchyEvent) {
        this.nodesChanged(hierarchyEvent);
    }

    @Override
    public void nodesRemoved(HierarchyEvent hierarchyEvent) {
    }

    @Override
    public void structureChanged(HierarchyEvent hierarchyEvent) {
    }

    public List getRootNodes(List list) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (Task task : list) {
            if (task.getWbsParentTask() != null) continue;
            linkedList.add(this.taskOutlines.getDefaultOutline().search(task));
        }
        return linkedList;
    }

    public void dump(Collection collection, String string) {
        if (collection != null) {
            for (Node node : collection) {
                Task task = (Task)node.getImpl();
                System.out.println(string + String.valueOf(task.getWbsParentTask()) + "->" + String.valueOf(task));
                this.dump(task.getWbsChildrenNodes(), string + "-");
            }
        }
    }

    public void moveInterval(Object object, long l, long l2, ScheduleInterval scheduleInterval) {
        if (l != scheduleInterval.getStart()) {
            this.setStart(l);
        }
    }

    @Override
    public void consumeIntervals(IntervalConsumer intervalConsumer) {
        intervalConsumer.consumeInterval(new ScheduleInterval(this.getStart(), this.getEnd()));
    }

    public boolean equals(Object object) {
        if (object instanceof DataObject) {
            return this.getName().equals(((DataObject)object).getName());
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.workspace = (Workspace)this.createWorkspace(1);
        objectOutputStream.defaultWriteObject();
        this.hasKey.serialize(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.hasKey = HasKeyImpl.deserialize(objectInputStream, this);
        this.tasks = new LinkedList();
        this.objectEventManager = new ObjectEventManager();
        this.objectSelectionEventManager = new ObjectSelectionEventManager();
        this.scheduleEventManager = new ScheduleEventManager();
        this.multipleTransactionManager = new MultipleTransactionManager();
        this.projectListenerList = new EventListenerList();
        this.taskOutlines = new OutlineCollectionImpl(Settings.numHierarchies(), this);
        this.barClosureInstance = new BarClosure();
    }

    private void initSubprojectHandler() {
        try {
            this.subprojectHandler = (SubprojectHandler)Class.forName(Messages.getMetaString("SubprojectHandler")).getConstructor(Project.class).newInstance(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("SubprojectHandler not valid in meta.properties");
            System.exit(-1);
        }
    }

    public void postDeserialization() {
        lastDeserialized = this;
        this.initSubprojectHandler();
        this.setSchedulingAlgorithm(new CriticalPath(this));
        int n = Settings.numHierarchies();
        for (int i = 0; i < n; ++i) {
            NodeModel nodeModel = this.taskOutlines.getOutline(i);
            if (nodeModel == null) continue;
            if (nodeModel instanceof AssignmentNodeModel) {
                AssignmentNodeModel assignmentNodeModel = (AssignmentNodeModel)nodeModel;
                assignmentNodeModel.setContainsLeftObjects(true);
                assignmentNodeModel.setDocument(this);
            }
            nodeModel.setUndoController(this.undoController);
        }
        this.initializeDefaultOutline();
        this.setInitialized(true);
        this.setGroupDirty(false);
        if (this.workspace != null) {
            this.restoreWorkspace(this.workspace, 1);
        }
        if (this.calendarOption == null) {
            this.calendarOption = CalendarOption.getDefaultInstance();
        }
    }

    @Override
    public void addEndSentinelDependency(Task task) {
        if (!task.isInSubproject()) {
            this.schedulingAlgorithm.addEndSentinelDependency(task);
        }
    }

    @Override
    public boolean removeEndSentinelDependency(Task task) {
        if (!task.isInSubproject()) {
            return this.schedulingAlgorithm.removeEndSentinelDependency(task);
        }
        return false;
    }

    @Override
    public void addStartSentinelDependency(Task task) {
        if (!task.isInSubproject()) {
            this.schedulingAlgorithm.addStartSentinelDependency(task);
        }
    }

    @Override
    public boolean removeStartSentinelDependency(Task task) {
        if (!task.isInSubproject()) {
            return this.schedulingAlgorithm.removeStartSentinelDependency(task);
        }
        return false;
    }

    @Override
    public void setEndConstraint(long l) {
        this.schedulingAlgorithm.setEndConstraint(l);
    }

    @Override
    public void setStartConstraint(long l) {
        this.schedulingAlgorithm.setStartConstraint(l);
    }

    @Override
    public boolean isForward() {
        return this.forward;
    }

    @Override
    public void setForward(boolean bl) {
        if (bl == this.forward) {
            return;
        }
        this.forward = bl;
        Iterator iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            ((Task)iterator.next()).setForward(bl);
        }
        this.markAllTasksAsNeedingRecalculation(false);
        this.schedulingAlgorithm.setForward(bl);
        this.schedulingAlgorithm.reset();
        this.schedulingAlgorithm.calculate(true);
    }

    @Override
    public void fireUpdateEvent(Object object, Object object2) {
        if (this.isInitialized()) {
            this.objectEventManager.fireUpdateEvent(object, object2);
        }
    }

    int getCalculationStateCount() {
        if (this.schedulingAlgorithm == null) {
            return 0;
        }
        return this.schedulingAlgorithm.getCalculationStateCount();
    }

    public final MultipleTransactionManager getMultipleTransactionManager() {
        return this.multipleTransactionManager;
    }

    @Override
    public int fireMultipleTransaction(int n, boolean bl) {
        return this.multipleTransactionManager.fire(this, n, bl);
    }

    private void repairTasks() {
        for (NormalTask normalTask : this.tasks) {
            if (normalTask.validateConstraints()) {
                this.addRepaired(normalTask);
            }
            if (!normalTask.getAssignments().isEmpty()) continue;
            Assignment assignment = normalTask.addDefaultAssignment();
            assignment.setDirty(true);
            normalTask.setDirty(true);
            ErrorLogger.logOnce("NoAssignment", "Repaired task with no assignments", null);
            System.out.println("added default ass for " + String.valueOf(normalTask));
            this.addRepaired(normalTask);
        }
    }

    public void setAllTasksAsUnchangedFromPersisted(boolean bl) {
        this.getTaskOutline().getHierarchy().visitAll(new Closure(this){
            int id = 1;

            @Override
            public void execute(Object object) {
                Node node = (Node)object;
                if (node.getImpl() instanceof NormalTask) {
                    NormalTask normalTask = (NormalTask)node.getImpl();
                    normalTask.setDirty(false);
                    normalTask.setLastSavedStart(normalTask.getStart());
                    normalTask.setLastSavedFinish(normalTask.getEnd());
                    Iterator iterator = normalTask.getAssignments().iterator();
                    while (iterator.hasNext()) {
                        ((Assignment)iterator.next()).setDirty(false);
                    }
                    iterator = normalTask.getDependencyList(true).iterator();
                    while (iterator.hasNext()) {
                        ((Dependency)iterator.next()).setDirty(false);
                    }
                    Node node2 = (Node)node.getParent();
                    if (node2 == null || node2.isRoot()) {
                        normalTask.setLastSavedParentId(-1L);
                    } else {
                        normalTask.setLastSavedParentId(((Task)node2.getImpl()).getUniqueId());
                    }
                    normalTask.setLastSavedPosistion(node2.getIndex(node));
                }
            }
        });
        if (!bl && this.repaired != null) {
            for (NormalTask normalTask : this.repaired) {
                normalTask.setTaskAssignementAndPredsDirty();
            }
            this.repaired = null;
        }
    }

    void addRepaired(Task task) {
        if (this.repaired == null) {
            this.repaired = new LinkedList<Task>();
        }
        this.repaired.add(task);
    }

    public void markAllTasksAsNeedingRecalculation(boolean bl) {
        int n = this.getCalculationStateCount() + 1;
        for (Task task : this.tasks) {
            task.setCalculationStateCount(n);
            if (!bl) continue;
            task.invalidateSchedules();
        }
        this.getSchedulingAlgorithm().initEarliestAndLatest();
    }

    @Override
    public void setAllChildrenDirty(boolean bl) {
        for (Task task : this.tasks) {
            task.setDirty(bl);
        }
    }

    public void setAllDirty() {
        this.setDirty(true);
        this.setGroupDirty(true);
        for (NormalTask normalTask : this.tasks) {
            normalTask.setDirty(false);
            Iterator iterator = normalTask.getAssignments().iterator();
            while (iterator.hasNext()) {
                ((Assignment)iterator.next()).setDirty(true);
            }
            iterator = normalTask.getDependencyList(true).iterator();
            while (iterator.hasNext()) {
                ((Dependency)iterator.next()).setDirty(true);
            }
        }
    }

    int getDefaultConstraintType() {
        if (this.isForward()) {
            return 0;
        }
        return 1;
    }

    @Override
    public WorkCalendar getDefaultCalendar() {
        return this.getWorkCalendar();
    }

    @Override
    public void setWork(long l, FieldContext fieldContext) {
    }

    @Override
    public void setRemainingWork(long l, FieldContext fieldContext) {
    }

    @Override
    public void setActualWork(long l, FieldContext fieldContext) {
    }

    public SchedulingAlgorithm getSchedulingAlgorithm() {
        return this.schedulingAlgorithm;
    }

    public void setSchedulingAlgorithm(SchedulingAlgorithm schedulingAlgorithm) {
        if (this.schedulingAlgorithm != null) {
            this.removeObjectListener(this.schedulingAlgorithm);
            this.getMultipleTransactionManager().removeListener(this.schedulingAlgorithm);
        }
        this.schedulingAlgorithm = schedulingAlgorithm;
        this.addObjectListener(schedulingAlgorithm);
        this.getMultipleTransactionManager().addListener(schedulingAlgorithm);
    }

    @Override
    public boolean isReadOnlyWork(FieldContext fieldContext) {
        return true;
    }

    @Override
    public boolean isReadOnlyActualWork(FieldContext fieldContext) {
        return true;
    }

    @Override
    public boolean isReadOnlyRemainingWork(FieldContext fieldContext) {
        return true;
    }

    @Override
    public void setFixedCost(double d, FieldContext fieldContext) {
    }

    @Override
    public boolean isReadOnlyFixedCost(FieldContext fieldContext) {
        return true;
    }

    @Override
    public boolean isLabor() {
        return true;
    }

    @Override
    public final long getStartDate() {
        return this.getStart();
    }

    @Override
    public final void setStartDate(long l) {
        l = this.getEffectiveWorkCalendar().adjustInsideCalendar(l, false);
        this.setStart(l);
        this.getSchedulingAlgorithm().setStartConstraint(l);
    }

    @Override
    public final boolean isReadOnlyStartDate(FieldContext fieldContext) {
        return this.getSchedulingAlgorithm() == null || !this.getSchedulingAlgorithm().isForward();
    }

    @Override
    public final long getFinishDate() {
        return this.getEnd();
    }

    @Override
    public void setFinishDate(long l) {
        l = this.getEffectiveWorkCalendar().adjustInsideCalendar(l, true);
        this.setEnd(l);
        this.getSchedulingAlgorithm().setEndConstraint(l);
    }

    @Override
    public boolean isReadOnlyFinishDate(FieldContext fieldContext) {
        return this.getSchedulingAlgorithm() == null || this.getSchedulingAlgorithm().isForward();
    }

    @Override
    public final long getCurrentDate() {
        return this.currentDate;
    }

    @Override
    public final void setCurrentDate(long l) {
        this.currentDate = l;
    }

    @Override
    public long getBaselineStart(int n) {
        long l = Long.MAX_VALUE;
        for (NormalTask normalTask : this.tasks) {
            long l2 = normalTask.getBaselineStart(n);
            if (l2 == 0L || l2 >= l) continue;
            l = l2;
        }
        if (l == Long.MAX_VALUE) {
            l = 0L;
        }
        return l;
    }

    @Override
    public long getBaselineFinish(int n) {
        long l = 0L;
        for (NormalTask normalTask : this.tasks) {
            long l2 = normalTask.getBaselineFinish(n);
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    @Override
    public long getBaselineDuration(int n) {
        return this.getEffectiveWorkCalendar().compare(this.getBaselineFinish(n), this.getBaselineStart(n), false);
    }

    @Override
    public long getActualStart() {
        long l = Long.MAX_VALUE;
        for (Task task : this.tasks) {
            long l2 = task.getActualStart();
            if (l2 == 0L || l2 >= l) continue;
            l = l2;
        }
        if (l == Long.MAX_VALUE) {
            l = 0L;
        }
        return l;
    }

    @Override
    public void setActualStart(long l) {
    }

    @Override
    public long getActualFinish() {
        Task task;
        long l;
        long l2 = 0L;
        Iterator iterator = this.tasks.iterator();
        while (iterator.hasNext() && (l = (task = (Task)iterator.next()).getActualFinish()) != 0L) {
            if (l <= l2) continue;
            l2 = l;
        }
        return l2;
    }

    @Override
    public long getStop() {
        long l = 0L;
        for (Task task : this.tasks) {
            long l2 = task.getStop();
            if (l2 == 0L) {
                return 0L;
            }
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    @Override
    public long getEarliestStop() {
        long l = Long.MAX_VALUE;
        for (Task task : this.tasks) {
            long l2 = task.getEarliestStop();
            if (l2 < l) {
                l = l2;
            }
            if (l2 != 0L) continue;
        }
        if (l == Long.MAX_VALUE) {
            l = 0L;
        }
        return l;
    }

    @Override
    public void setActualFinish(long l) {
    }

    @Override
    public long getActualDuration() {
        long l = this.getStop();
        if (l == 0L) {
            return 0L;
        }
        return this.getEffectiveWorkCalendar().compare(l, this.getStartDate(), false);
    }

    @Override
    public void setActualDuration(long l) {
    }

    @Override
    public long getRemainingDuration() {
        long l = this.getStop();
        if (l == 0L) {
            l = this.getStartDate();
        }
        return this.getEffectiveWorkCalendar().compare(this.getFinishDate(), l, false);
    }

    @Override
    public void setRemainingDuration(long l) {
    }

    @Override
    public double getPercentComplete() {
        long l = 0L;
        long l2 = 0L;
        for (Task task : this.tasks) {
            l += Duration.millis(task.getActualDuration());
            l2 += Duration.millis(task.getDuration());
        }
        if (l2 == 0L) {
            return 0.0;
        }
        return (double)l / (double)l2;
    }

    @Override
    public void setPercentComplete(double d) {
    }

    @Override
    public void setDuration(long l) {
    }

    @Override
    public long getElapsedDuration() {
        return Math.round((double)this.getEffectiveWorkCalendar().compare(this.getEnd(), this.getStart(), true) * CalendarOption.getInstance().getFractionOfDayThatIsWorking());
    }

    @Override
    public long getDependencyStart() {
        return 0L;
    }

    @Override
    public void setDependencyStart(long l) {
    }

    @Override
    public long getResume() {
        return 0L;
    }

    @Override
    public void setResume(long l) {
    }

    @Override
    public void setStop(long l) {
    }

    @Override
    public void clearDuration() {
    }

    @Override
    public void moveRemainingToDate(long l) {
    }

    @Override
    public void moveInterval(Object object, long l, long l2, ScheduleInterval scheduleInterval, boolean bl) {
    }

    @Override
    public void split(Object object, long l, long l2) {
    }

    @Override
    public final boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public final void setDirty(boolean bl) {
        this.isDirty = this.isDirty;
        if (this.isDirty) {
            this.setGroupDirty(true);
        }
    }

    @Override
    public final boolean isGroupDirty() {
        return this.isGroupDirty;
    }

    @Override
    public final void setGroupDirty(boolean bl) {
        boolean bl2 = this.isGroupDirty;
        this.isGroupDirty = bl;
        if (bl2 != bl) {
            this.fireGroupDirtyChanged(this, bl2);
        }
    }

    @Override
    public DataFactoryUndoController getUndoController() {
        return this.undoController;
    }

    public void setUndoController(DataFactoryUndoController dataFactoryUndoController) {
        this.undoController = dataFactoryUndoController;
        if (dataFactoryUndoController != null) {
            dataFactoryUndoController.setDataFactory(this);
        }
    }

    public static Predicate instanceofPredicate() {
        return new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                return object instanceof Project;
            }
        };
    }

    public void addPastedTask(Task task) {
        this.getSchedulingAlgorithm().addObject(task);
    }

    @Override
    public Document invalidateCalendar() {
        this.markAllTasksAsNeedingRecalculation(false);
        return this;
    }

    @Override
    public WorkCalendar getBaseCalendar() {
        return this.getWorkCalendar();
    }

    @Override
    public void setBaseCalendar(WorkCalendar workCalendar) throws CircularDependencyException {
        this.setWorkCalendar(workCalendar);
    }

    @Override
    public boolean fieldHideBaseCalendar(FieldContext fieldContext) {
        return false;
    }

    @Override
    public boolean isJustModified() {
        return true;
    }

    @Override
    public void setComplete(boolean bl) {
        ScheduleUtil.setComplete(this, bl);
    }

    @Override
    public boolean isComplete() {
        return this.getPercentComplete() == 1.0;
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean bl) {
        this.master = bl;
    }

    @Override
    public boolean isLocal() {
        return this.hasKey.isLocal();
    }

    @Override
    public void setLocal(boolean bl) {
        this.hasKey.setLocal(bl);
    }

    public boolean isSavable() {
        return Environment.isProjectLibre() || !this.isLocal() && !this.isReadOnly();
    }

    public boolean isTemporaryLocal() {
        return this.temporaryLocal;
    }

    public void setTemporaryLocal(boolean bl) {
        this.temporaryLocal = bl;
    }

    public boolean isLockable() {
        return !this.temporaryLocal && !this.isLocal();
    }

    public boolean applyTimesheet(Collection collection) {
        return this.applyTimesheet(collection, System.currentTimeMillis());
    }

    @Override
    public boolean applyTimesheet(Collection collection, long l) {
        return TimesheetHelper.applyTimesheet(this.getTasks(), collection, l);
    }

    @Override
    public long getLastTimesheetUpdate() {
        return TimesheetHelper.getLastTimesheetUpdate(this.getTasks());
    }

    @Override
    public boolean isPendingTimesheetUpdate() {
        return TimesheetHelper.isPendingTimesheetUpdate(this.getTasks());
    }

    @Override
    public int getTimesheetStatus() {
        return TimesheetHelper.getTimesheetStatus(this.getTasks());
    }

    @Override
    public String getTimesheetStatusName() {
        return TimesheetHelper.getTimesheetStatusName(this.getTimesheetStatus());
    }

    @Override
    public void rollbackUnvalidated(NodeModel nodeModel, Object object) {
    }

    @Override
    public void initOutline(NodeModel nodeModel) {
    }

    @Override
    public final long getCompletedThrough() {
        long l = this.getStart();
        if (l == 0L) {
            return 0L;
        }
        long l2 = DateTime.closestDate((double)this.getDuration() * this.getPercentComplete());
        return this.getEffectiveWorkCalendar().add(l, l2, true);
    }

    @Override
    public final void setCompletedThrough(long l) {
    }

    public final boolean isOpenedAsSubproject() {
        return this.openedAsSubproject;
    }

    public final void setOpenedAsSubproject(boolean bl) {
        this.openedAsSubproject = bl;
    }

    private ExternalTaskManager getExternalTaskManager() {
        if (this.externalTaskManager == null) {
            this.externalTaskManager = new ExternalTaskManager();
        }
        return this.externalTaskManager;
    }

    public void addExternalTask(Task task) {
        this.getExternalTaskManager().add(task);
        task.markTaskAsNeedingRecalculation();
    }

    public void handleExternalTasks(Project project, boolean bl, boolean bl2) {
        this.getExternalTaskManager().handleExternalTasks(project, bl, bl2);
        project.getExternalTaskManager().handleExternalTasks(this, bl, bl2);
    }

    public boolean needsSaving() {
        return this.isSavable() && this.isGroupDirty();
    }

    @Override
    public long getEarliestStartingTask() {
        return this.earliestStartingTask;
    }

    public long getEarliestStartingTaskOrStart() {
        if (this.isOpenedAsSubproject()) {
            return this.earliestStartingTask;
        }
        long l = ((CriticalPath)this.getSchedulingAlgorithm()).getEarliestStart();
        if (l == 0L) {
            l = this.getStart();
            System.out.println("0 earliest start for project. Forward = " + this.isForward() + " using proj start " + String.valueOf(new Date(l)));
        }
        return l;
    }

    @Override
    public long getLatestFinishingTask() {
        if (this.isOpenedAsSubproject()) {
            return this.latestFinishingTask;
        }
        long l = ((CriticalPath)this.getSchedulingAlgorithm()).getLatestFinish();
        if (l == 0L || l == Long.MAX_VALUE) {
            l = this.getEnd();
            System.out.println(l + " latest finish for project. Forward = " + this.isForward() + " using proj end " + String.valueOf(new Date(this.end)));
        }
        return l;
    }

    @Override
    public final Map getExtraFields() {
        if (this.extraFields == null) {
            this.extraFields = new HashMap();
        }
        return this.extraFields;
    }

    @Override
    public final void setExtraFields(Map map) {
        this.extraFields = map;
    }

    public final Hyperlink getDocumentFolderUrl() {
        return this.documentFolderUrl;
    }

    public final void setDocumentFolderUrl(Hyperlink hyperlink) {
        this.documentFolderUrl = hyperlink;
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public final Collection getReferringSubprojectTasks() {
        return this.subprojectHandler.getReferringSubprojectTasks();
    }

    public final void setReferringSubprojectTasks(Collection collection) {
        this.subprojectHandler.setReferringSubprojectTasks(collection);
    }

    public final Task getContainingSubprojectTask() {
        return this.subprojectHandler.getContainingSubprojectTask();
    }

    public final void setContainingSubprojectTask(Task task) {
        this.subprojectHandler.setContainingSubprojectTask(task);
    }

    @Override
    public long getFinishOffset() {
        return EarnedValueCalculator.getInstance().getFinishOffset(this);
    }

    @Override
    public long getStartOffset() {
        return EarnedValueCalculator.getInstance().getStartOffset(this);
    }

    @Override
    public double getRisk() {
        return this.risk;
    }

    @Override
    public void setRisk(double d) {
        this.risk = d;
    }

    @Override
    public int getProjectType() {
        return this.projectType;
    }

    @Override
    public void setProjectType(int n) {
        this.projectType = n;
    }

    @Override
    public int getExpenseType() {
        return this.expenseType;
    }

    @Override
    public void setExpenseType(int n) {
        this.expenseType = n;
    }

    @Override
    public int getEffectiveExpenseType() {
        return this.getExpenseType();
    }

    @Override
    public String getDivision() {
        return this.division;
    }

    @Override
    public void setDivision(String string) {
        this.division = string;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(String string) {
        this.group = string;
    }

    @Override
    public int getProjectStatus() {
        return this.projectStatus;
    }

    @Override
    public void setProjectStatus(int n) {
        this.projectStatus = n;
    }

    public ImageLink getBudgetStatusIndicator() {
        return EarnedValueCalculator.getInstance().getBudgetStatusIndicator(this.getCpi(null));
    }

    public ImageLink getScheduleStatusIndicator() {
        return EarnedValueCalculator.getInstance().getBudgetStatusIndicator(this.getSpi(null));
    }

    @Override
    public Object backupDetail() {
        return null;
    }

    @Override
    public void restoreDetail(Object object, Object object2, boolean bl) {
    }

    @Override
    public boolean containsAssignments() {
        return true;
    }

    public void beginUndoUpdate() {
        if (this.undoController != null) {
            this.undoController.beginUpdate();
        }
    }

    public void endUndoUpdate() {
        if (this.undoController != null) {
            this.undoController.endUpdate();
        }
    }

    @Override
    public boolean renumber(boolean bl) {
        NormalTask normalTask;
        boolean bl2 = false;
        long l = this.getUniqueId();
        Iterator<Task> iterator = this.getTaskOutlineIterator();
        while (iterator.hasNext()) {
            normalTask = (NormalTask)iterator.next();
            if (normalTask.getProjectId() != l) continue;
            bl2 |= normalTask.renumber(bl);
        }
        if (!(bl2 |= this.hasKey.renumber(bl))) {
            return false;
        }
        l = this.getUniqueId();
        iterator = this.getTaskOutlineIterator();
        while (iterator.hasNext()) {
            normalTask = (NormalTask)iterator.next();
            normalTask.setProjectId(l);
        }
        return true;
    }

    @Override
    public int getAccessControlPolicy() {
        return this.accessControlPolicy;
    }

    @Override
    public void setAccessControlPolicy(int n) {
        this.accessControlPolicy = n;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date date) {
        this.creationDate = date;
    }

    public Date getLastModificationDate() {
        return this.lastModificationDate;
    }

    public void setLastModificationDate(Date date) {
        this.lastModificationDate = date;
    }

    public void linkAllSiblings(Node node, Predicate predicate, Object object) {
        List list = this.getTaskModel().getChildren(node);
        if (list == null) {
            return;
        }
        try {
            DependencyService.getInstance().connect(NodeList.nodeListToImplList(list, NotAssignmentFilter.getInstance()), object, predicate);
        }
        catch (InvalidAssociationException invalidAssociationException) {
            invalidAssociationException.printStackTrace();
        }
        for (Node node2 : list) {
            this.linkAllSiblings(node2, predicate, object);
        }
    }

    public List<NormalTask> getRootTasks() {
        List list = this.getTaskModel().getChildren(null);
        return NodeList.nodeListToImplList(list);
    }

    public List<Resource> getRootResources() {
        List list = this.getResourceModel().getChildren(null);
        return NodeList.nodeListToImplList(list);
    }

    public boolean isCriticalPathJustChanged() {
        return ((CriticalPath)this.getSchedulingAlgorithm()).isCriticalPathJustChanged();
    }

    @Override
    public int getBenefit() {
        return this.benefit;
    }

    @Override
    public void setBenefit(int n) {
        this.benefit = n;
    }

    @Override
    public double getNetPresentValue() {
        return this.netPresentValue;
    }

    @Override
    public void setNetPresentValue(double d) {
        this.netPresentValue = d;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getGuessedFileName() {
        if (this.fileName != null) {
            return this.fileName;
        }
        String string = this.getName();
        if (string == null) {
            return null;
        }
        return this.getName() + "." + FileHelper.getFileExtension(this.fileType);
    }

    public void setFileName(String string) {
        this.fileName = string;
        if (string != null) {
            this.setFileType(FileHelper.getFileType(string));
        }
    }

    public String getTitle() {
        return this.getName() + (String)(this.fileName == null ? "" : " - " + this.fileName);
    }

    public int getFileType() {
        return this.fileType;
    }

    public void setFileType(int n) {
        this.fileType = n;
    }

    public void setBoundsAfterReadProject() {
        this.getSchedulingAlgorithm().setEarliestAndLatest(this.getStart(), this.getEnd());
        this.fireScheduleChanged(this, ScheduleEvent.SCHEDULE);
    }

    public void setAllTasksInSubproject(boolean bl, Project project) {
    }

    public void setAllNodesInSubproject(boolean bl) {
    }

    public SubprojectHandler getSubprojectHandler() {
        return this.subprojectHandler;
    }

    @Override
    public long getReferringSubprojectTaskDependencyDate() {
        return this.subprojectHandler.getReferringSubprojectTaskDependencyDate();
    }

    @Override
    public String getSubprojectOf() {
        return this.subprojectHandler.getSubprojectOf();
    }

    public void resetRoles(boolean bl) {
        try {
            Class.forName(Messages.getMetaString("ProjectRoleManager")).getDeclaredMethod("resetRoles", Project.class, Boolean.class).invoke(null, this, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("ProjectRoleManager not valid in meta.properties");
            System.exit(-1);
        }
    }

    public PrintSettings getPrintSettings(int n) {
        return n == 1 ? this.printSettings : this.tmpSettings;
    }

    public void setPrintSettings(PrintSettings printSettings) {
        this.printSettings = printSettings;
        this.setGroupDirty(true);
    }

    public CalendarOption getCalendarOption() {
        return this.calendarOption;
    }

    public void setCalendarOption(CalendarOption calendarOption) {
        this.calendarOption = calendarOption;
        this.setGroupDirty(true);
    }

    public PrintSettings getTmpSettings() {
        return this.tmpSettings;
    }

    public void setTmpSettings(PrintSettings printSettings) {
        this.tmpSettings = printSettings;
    }

    @Override
    public void restoreWorkspace(WorkspaceSetting workspaceSetting, int n) {
        Workspace workspace = (Workspace)workspaceSetting;
        if (workspace.spreadsheetWorkspace != null) {
            this.fieldArray = SpreadSheetFieldArray.restore(workspace.spreadsheetWorkspace, this.getName(), n);
        }
        if (workspace.printSettings != null) {
            this.printSettings = workspace.printSettings;
            if (this.printSettings != null) {
                this.printSettings.init();
                this.tmpSettings = (PrintSettings)this.printSettings.clone();
            }
        }
        if (workspace.fieldAliasMap != null) {
            FieldDictionary.setAliasMap(workspace.fieldAliasMap);
        }
        if (workspace.calendarOption != null) {
            this.calendarOption = workspace.calendarOption;
            CalendarOption.setInstance(this.calendarOption);
        }
    }

    @Override
    public WorkspaceSetting createWorkspace(int n) {
        Workspace workspace = new Workspace();
        if (Environment.isClientSide()) {
            this.fieldArray = (SpreadSheetFieldArray)Alert.getGraphicManagerMethod("getCurrentFieldArray");
            if (this.fieldArray != null) {
                workspace.spreadsheetWorkspace = this.fieldArray.createWorkspace(n);
            }
            if (this.printSettings != null) {
                workspace.printSettings = this.printSettings;
                this.printSettings.updateWorkspace();
            }
            if (this.calendarOption != null) {
                workspace.calendarOption = this.calendarOption;
            }
        }
        workspace.fieldAliasMap = FieldDictionary.getAliasMap();
        return workspace;
    }

    public SpreadSheetFieldArray getFieldArray() {
        return this.fieldArray;
    }

    public void forTasks(Closure closure) {
        Iterator<Task> iterator = this.getTaskOutlineIterator();
        while (iterator.hasNext()) {
            closure.execute(iterator.next());
        }
    }

    public Iterator<Task> getTaskOutlineIterator() {
        return new TaskIterator(this);
    }

    public Node getTaskOutlineRoot() {
        if (this.isOpenedAsSubproject() && this.getTasks().size() > 0) {
            NormalTask normalTask = (NormalTask)this.getTasks().get(0);
            return normalTask.getEnclosingSubprojectNode();
        }
        return null;
    }

    public TreeMap<DistributionData, DistributionData> getDistributionMap() {
        return this.distributionMap;
    }

    public void setDistributionMap(TreeMap<DistributionData, DistributionData> treeMap) {
        this.distributionMap = treeMap;
    }

    public TreeMap<DistributionData, DistributionData> getNewDistributionMap() {
        return this.newDistributionMap;
    }

    public void setNewDistributionMap(TreeMap<DistributionData, DistributionData> treeMap) {
        this.newDistributionMap = treeMap;
    }

    public void updateDistributionMap() {
        long l = System.currentTimeMillis();
        List list = new DistributionConverter().createDistributionData(this, false);
        if (list == null) {
            return;
        }
        TreeMap<DistributionData, DistributionData> treeMap = new TreeMap<DistributionData, DistributionData>(new DistributionComparator());
        this.setDistributionMap(treeMap);
        long l2 = this.getUniqueId();
        for (DistributionData distributionData : list) {
            if (distributionData.getProjectId() != l2) continue;
            treeMap.put(distributionData, distributionData);
        }
        System.out.println("DistributionMap: " + list.size() + " elements, updated in " + (System.currentTimeMillis() - l) + " ms");
    }

    public void validateNewDistributionMap() {
        if (this.distributionMap != null) {
            this.distributionMap.clear();
        }
        this.setDistributionMap(this.getNewDistributionMap());
        this.setNewDistributionMap(null);
        this.setForceNonIncrementalDistributions(false);
    }

    public boolean isForceNonIncremental() {
        return this.forceNonIncremental;
    }

    public void setForceNonIncremental(boolean bl) {
        this.forceNonIncremental = bl;
    }

    public boolean isForceNonIncrementalDistributions() {
        return this.forceNonIncrementalDistributions;
    }

    public void setForceNonIncrementalDistributions(boolean bl) {
        this.forceNonIncrementalDistributions = bl;
    }

    public float getVersion() {
        return this.version;
    }

    public void setVersion(float f) {
        this.version = f;
    }

    public void recalculate() {
        this.markAllTasksAsNeedingRecalculation(true);
        this.schedulingAlgorithm.reset();
        this.schedulingAlgorithm.calculate(true);
    }

    @Override
    public ObjectSelectionEventManager getObjectSelectionEventManager() {
        return this.objectSelectionEventManager;
    }

    public int getRowHeight(SortedSet sortedSet) {
        Iterator<Task> iterator = this.getTaskOutlineIterator();
        while (iterator.hasNext()) {
            Task task = iterator.next();
            int n = Snapshottable.CURRENT;
            for (int i = 0; i < Settings.numGanttBaselines(); ++i) {
                TaskSnapshot taskSnapshot;
                if (i == n || (taskSnapshot = (TaskSnapshot)task.getSnapshot(new Integer(i))) == null) continue;
                sortedSet.add(new Integer(i));
            }
        }
        int n = sortedSet.size() == 0 ? 0 : (Integer)sortedSet.last() + 1;
        int n2 = GraphicConfiguration.getInstance().getRowHeight() + n * GraphicConfiguration.getInstance().getBaselineHeight();
        return n2;
    }

    public class Workspace
    implements WorkspaceSetting {
        private static final long serialVersionUID = 6909144693873463556L;
        WorkspaceSetting spreadsheetWorkspace;
        HashMap fieldAliasMap;
        PrintSettings printSettings;
        CalendarOption calendarOption;
    }

    private class TaskIterator
    implements Iterator<Task> {
        private Iterator iterator;
        private Task next = null;

        private Task nextElement() {
            Node node = null;
            while (this.iterator.hasNext() && !((node = (Node)this.iterator.next()).getImpl() instanceof Task)) {
            }
            this.next = node != null && node.getImpl() instanceof Task ? (Task)node.getImpl() : null;
            return this.next;
        }

        TaskIterator(Project project) {
            this.iterator = project.getTaskOutline().iterator(project.getTaskOutlineRoot());
            this.nextElement();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Task next() {
            Task task = this.next;
            this.nextElement();
            return task;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

