/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.graphic.frames;

import com.projectlibre1.association.InvalidAssociationException;
import com.projectlibre1.command.UpdateProjectCommand;
import com.projectlibre1.configuration.Configuration;
import com.projectlibre1.dialog.BaselineDialog;
import com.projectlibre1.dialog.DelegateTaskDialog;
import com.projectlibre1.dialog.FindDialog;
import com.projectlibre1.dialog.UpdateProjectDialogBox;
import com.projectlibre1.dialog.UpdateTaskDialog;
import com.projectlibre1.dialog.calendar.ChangeWorkingTimeDialogBox;
import com.projectlibre1.document.ObjectEvent;
import com.projectlibre1.document.ObjectSelectionEvent;
import com.projectlibre1.document.ObjectSelectionListener;
import com.projectlibre1.field.Field;
import com.projectlibre1.grouping.core.Node;
import com.projectlibre1.grouping.core.NodeList;
import com.projectlibre1.grouping.core.model.NodeModel;
import com.projectlibre1.grouping.core.transform.ViewTransformer;
import com.projectlibre1.grouping.core.transform.filtering.NodeFilter;
import com.projectlibre1.grouping.core.transform.filtering.NotAssignmentFilter;
import com.projectlibre1.grouping.core.transform.filtering.ResourceInTeamFilter;
import com.projectlibre1.job.JobQueue;
import com.projectlibre1.menu.MenuActionConstants;
import com.projectlibre1.menu.MenuActionsMap;
import com.projectlibre1.menu.MenuManager;
import com.projectlibre1.pm.calendar.CalendarService;
import com.projectlibre1.pm.calendar.HasCalendar;
import com.projectlibre1.pm.calendar.WorkingCalendar;
import com.projectlibre1.pm.dependency.DependencyService;
import com.projectlibre1.pm.graphic.IconManager;
import com.projectlibre1.pm.graphic.frames.GraphicManager;
import com.projectlibre1.pm.graphic.frames.workspace.NamedFrame;
import com.projectlibre1.pm.graphic.model.cache.NodeModelCache;
import com.projectlibre1.pm.graphic.model.cache.NodeModelCacheFactory;
import com.projectlibre1.pm.graphic.model.cache.ReferenceNodeModelCache;
import com.projectlibre1.pm.graphic.spreadsheet.SpreadSheet;
import com.projectlibre1.pm.graphic.spreadsheet.SpreadSheetModel;
import com.projectlibre1.pm.graphic.spreadsheet.selection.event.SelectionNodeEvent;
import com.projectlibre1.pm.graphic.spreadsheet.selection.event.SelectionNodeListener;
import com.projectlibre1.pm.graphic.timescale.CoordinatesConverter;
import com.projectlibre1.pm.graphic.views.BaseView;
import com.projectlibre1.pm.graphic.views.ChartView;
import com.projectlibre1.pm.graphic.views.GanttView;
import com.projectlibre1.pm.graphic.views.MainView;
import com.projectlibre1.pm.graphic.views.PertView;
import com.projectlibre1.pm.graphic.views.ProjectView;
import com.projectlibre1.pm.graphic.views.ResourceView;
import com.projectlibre1.pm.graphic.views.Searchable;
import com.projectlibre1.pm.graphic.views.SplittedView;
import com.projectlibre1.pm.graphic.views.TreeView;
import com.projectlibre1.pm.graphic.views.UsageDetailView;
import com.projectlibre1.pm.resource.ResourceImpl;
import com.projectlibre1.pm.task.Portfolio;
import com.projectlibre1.pm.task.Project;
import com.projectlibre1.pm.task.ProjectEvent;
import com.projectlibre1.pm.task.ProjectFactory;
import com.projectlibre1.pm.task.ProjectListener;
import com.projectlibre1.pm.task.Task;
import com.projectlibre1.preference.GlobalPreferences;
import com.projectlibre1.session.LoadOptions;
import com.projectlibre1.toolbar.FilterToolBarManager;
import com.projectlibre1.undo.UndoController;
import com.projectlibre1.util.Alert;
import com.projectlibre1.util.ArrayUtils;
import com.projectlibre1.util.ClassUtils;
import com.projectlibre1.util.DataUtils;
import com.projectlibre1.util.Environment;
import com.projectlibre1.workspace.SavableToWorkspace;
import com.projectlibre1.workspace.WorkspaceSetting;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.apache.commons.collections.Closure;

public class DocumentFrame
extends NamedFrame
implements SelectionNodeListener,
UndoableEditListener,
MenuActionConstants,
ObjectEvent.Listener,
ProjectListener,
SavableToWorkspace,
ObjectSelectionListener {
    private static final long serialVersionUID = 2075764134837908178L;
    protected MainView mainView;
    protected GanttView ganttView;
    protected UsageDetailView taskUsageDetailView;
    protected UsageDetailView resourceUsageDetailView;
    protected PertView pertView;
    protected TreeView wbsView;
    protected TreeView rbsView;
    protected ChartView chartView;
    protected ChartView histogramView;
    protected ResourceView resourceView;
    protected ProjectView projectView;
    protected UsageDetailView taskUsageView;
    protected UsageDetailView resourceUsageView;
    protected BaseView reportView;
    private static ArrayList ganttColumns = null;
    private FindDialog findDialog = null;
    protected CoordinatesConverter coord;
    protected Project project;
    protected GraphicManager graphicManager;
    protected MenuManager menuManager;
    MenuActionsMap actionsMap = null;
    BaseView activeTopView = null;
    BaseView activeBottomView = null;
    String lastTopButton = null;
    String lastBottomButton = "NoSubWindow";
    Workspace workspace;
    FilterToolBarManager filterToolBarManager = null;
    JobQueue jobQueue = null;
    private JRadioButtonMenuItem menuItem = null;
    protected SelectionNodeEvent lastSelectionEvent = null;
    protected UndoController currentUndoController = null;
    private ArrayList<ResourceInTeamFilter> resourcesInTeamFilters = new ArrayList();

    public GraphicManager getGraphicManager() {
        return this.graphicManager;
    }

    protected NodeModel getTaskModel() {
        return this.project.getTaskModel();
    }

    protected NodeModel getResourceModel() {
        return this.project.getResourceModel();
    }

    public JobQueue getJobQueue() {
        if (this.jobQueue == null) {
            this.jobQueue = new JobQueue("GraphicManager", true);
        }
        return this.jobQueue;
    }

    public ReferenceNodeModelCache getTaskNodeModelCache() {
        ReferenceNodeModelCache referenceNodeModelCache = (ReferenceNodeModelCache)this.project.getTaskCache();
        if (referenceNodeModelCache == null) {
            referenceNodeModelCache = NodeModelCacheFactory.createTaskNodeModelCache(this.project, this.getTaskModel());
            this.project.setTaskCache(referenceNodeModelCache);
        }
        return referenceNodeModelCache;
    }

    public ReferenceNodeModelCache getResourceNodeModelCache() {
        ReferenceNodeModelCache referenceNodeModelCache = (ReferenceNodeModelCache)this.project.getResourceCache();
        if (referenceNodeModelCache == null) {
            referenceNodeModelCache = NodeModelCacheFactory.createResourceNodeModelCache(this.project.getResourcePool(), this.getResourceModel());
            this.project.setResourceCache(referenceNodeModelCache);
        }
        return referenceNodeModelCache;
    }

    public ReferenceNodeModelCache getReferenceCache(boolean bl) {
        ReferenceNodeModelCache referenceNodeModelCache = bl ? this.getTaskNodeModelCache() : this.getResourceNodeModelCache();
        return referenceNodeModelCache;
    }

    public NodeModelCache createCache(boolean bl, String string) {
        return NodeModelCacheFactory.getInstance().createFilteredCache(this.getReferenceCache(bl), string, null);
    }

    public DocumentFrame(GraphicManager graphicManager, Project project, String string) {
        super(string, IconManager.getHalfSizedIcon("view.gantt"));
        this.graphicManager = graphicManager;
        this.menuManager = this.graphicManager.getMenuManager();
        this.filterToolBarManager = Environment.isNewLook() ? FilterToolBarManager.create(this.menuManager) : this.graphicManager.getFilterToolBarManager();
        this.project = project;
        this.coord = new CoordinatesConverter(project);
        project.addObjectListener(this);
        this.getGraphicManager().getPreferences().addObjectListener(this);
        project.getObjectSelectionEventManager().addListener(this);
        this.setPreferredSize(new Dimension(800, 600));
        this.setMainView(true);
    }

    private void setMainView(boolean bl) {
        if (this.mainView != null) {
            this.remove(this.mainView);
        }
        this.mainView = new MainView();
        this.mainView.setBorder(null);
        this.setLayout(new GridLayout(1, 1));
        this.add(this.mainView);
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (DocumentFrame.this.isEditingResourcePool()) {
                        DocumentFrame.this.activateResourceView();
                        DocumentFrame.this.getGraphicManager().setAllButResourceDisabled(true);
                    } else {
                        DocumentFrame.this.activateGanttView();
                        DocumentFrame.this.getGraphicManager().setAllButResourceDisabled(false);
                    }
                    DocumentFrame.this.getGraphicManager().setButtonState(null, DocumentFrame.this.project);
                }
            });
        }
    }

    List getSelectedNodes(boolean bl) {
        SpreadSheet spreadSheet = this.getTopSpreadSheet();
        if (spreadSheet == null) {
            return null;
        }
        ArrayList arrayList = spreadSheet.getSelectedNodes();
        if (arrayList.size() == 0) {
            return null;
        }
        if (bl) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                Object object = node.getImpl();
                if (!ClassUtils.isObjectReadOnly(object)) continue;
                iterator.remove();
            }
        }
        return arrayList;
    }

    Object getSelectedImpl() {
        SpreadSheet spreadSheet = this.getTopSpreadSheet();
        if (spreadSheet == null) {
            return null;
        }
        return spreadSheet.getCurrentRowImpl();
    }

    boolean doBaselineDialog(boolean bl) {
        List list;
        this.finishAnyOperations();
        BaselineDialog baselineDialog = BaselineDialog.getInstance(this.getGraphicManager(), null, bl, this.hasAtLeastOneTaskSelected());
        if (!baselineDialog.doModal()) {
            return false;
        }
        Integer n = new Integer(baselineDialog.getForm().getBaselineNumber());
        boolean bl2 = baselineDialog.getForm().isEntireProject();
        List list2 = list = bl2 ? null : this.getSelectedImpls(true);
        if (bl) {
            this.getProject().saveCurrentToSnapshot(n, bl2, list, true);
        } else {
            this.getProject().clearSnapshot(n, bl2, list, true);
        }
        return true;
    }

    void doChangeWorkingTimeDialog(boolean bl) {
        this.finishAnyOperations();
        Object object = this.getSelectedImpl();
        WorkingCalendar workingCalendar = null;
        ArrayList arrayList = null;
        if (object instanceof HasCalendar) {
            workingCalendar = (WorkingCalendar)((HasCalendar)object).getWorkCalendar();
            if (object instanceof ResourceImpl) {
                arrayList = ((ResourceImpl)object).getResourcePool().extractCalendars();
            }
        }
        if (workingCalendar == null) {
            workingCalendar = (WorkingCalendar)this.getProject().getWorkCalendar();
        }
        CalendarService calendarService = CalendarService.getInstance();
        ChangeWorkingTimeDialogBox changeWorkingTimeDialogBox = ChangeWorkingTimeDialogBox.getInstance(this.getGraphicManager().getFrame(), this.project, workingCalendar, arrayList, bl, this.getUndoController());
        changeWorkingTimeDialogBox.doModal();
    }

    void doLevelResourcesDialog() {
    }

    void doDelegateTasksDialog() {
        this.finishAnyOperations();
        List list = this.getSelectedNodes(true);
        if (list == null) {
            return;
        }
        DelegateTaskDialog delegateTaskDialog = DelegateTaskDialog.getInstance(this.getGraphicManager().getFrame(), list);
        delegateTaskDialog.setLocationRelativeTo(null);
        delegateTaskDialog.doModal();
    }

    void doUpdateTasksDialog() {
        this.finishAnyOperations();
        List list = this.getSelectedNodes(true);
        if (list == null) {
            return;
        }
        UpdateTaskDialog updateTaskDialog = UpdateTaskDialog.getInstance(this.getGraphicManager().getFrame(), list);
        updateTaskDialog.setLocationRelativeTo(null);
        updateTaskDialog.doModal();
    }

    void doUpdateProjectDialog() {
        this.finishAnyOperations();
        UpdateProjectDialogBox updateProjectDialogBox = UpdateProjectDialogBox.getInstance(this.getGraphicManager().getFrame(), null, this.hasAtLeastOneTaskSelected());
        if (updateProjectDialogBox.doModal()) {
            UpdateProjectCommand updateProjectCommand = new UpdateProjectCommand(this.project, updateProjectDialogBox.getForm().getActiveDate().getTime(), updateProjectDialogBox.getForm().getUpdate(), updateProjectDialogBox.getForm().getProgress());
            this.forTasksDo(updateProjectCommand, updateProjectDialogBox.getForm().getEntireProject());
            updateProjectCommand = null;
        }
    }

    void doDefineCodeDialog() {
        this.finishAnyOperations();
    }

    void doRecurringTaskDialog() {
        this.finishAnyOperations();
    }

    void doBarDialog() {
        this.finishAnyOperations();
    }

    void doSortDialog() {
        this.finishAnyOperations();
    }

    void doGroupDialog() {
        this.finishAnyOperations();
    }

    public void doLinkTasks() {
        this.finishAnyOperations();
        try {
            List list = NodeList.nodeListToImplList(this.getSelectedNodes(false), NotAssignmentFilter.getInstance());
            DependencyService.getInstance().connect(list, this, null);
        }
        catch (InvalidAssociationException invalidAssociationException) {
            Alert.error(invalidAssociationException.getMessage(), this);
        }
    }

    public void doUnlinkTasks() {
        this.finishAnyOperations();
        List list = NodeList.nodeListToImplList(this.getSelectedNodes(false), NotAssignmentFilter.getInstance());
        DependencyService.getInstance().removeAnyDependencies(list, this);
    }

    public void doUndoRedo(boolean bl) {
        if (!this.isActive()) {
            return;
        }
        this.finishAnyOperations();
        UndoController undoController = this.getUndoController();
        if (undoController != null) {
            if (bl) {
                undoController.undo();
            } else {
                undoController.redo();
            }
            this.refreshUndoButtons();
        }
    }

    public void doZoomIn() {
        if (this.activeTopView != null) {
            this.activeTopView.zoomIn();
        }
    }

    public void doZoomOut() {
        if (this.activeTopView != null) {
            this.activeTopView.zoomOut();
        }
    }

    public void doScrollToTask() {
        if (this.activeTopView != null) {
            this.activeTopView.scrollToTask();
        }
    }

    public boolean canZoomIn() {
        return this.activeTopView == null ? false : this.activeTopView.canZoomIn();
    }

    public boolean canZoomOut() {
        return this.activeTopView == null ? false : this.activeTopView.canZoomOut();
    }

    public boolean canScrollToTask() {
        return this.activeTopView == null ? false : this.activeTopView.canScrollToTask();
    }

    public int getScale() {
        return this.activeTopView == null ? -1 : this.activeTopView.getScale();
    }

    public void doOutdent() {
        SpreadSheet spreadSheet = this.getActiveSpreadSheet();
        if (spreadSheet != null) {
            spreadSheet.executeAction("Outdent");
        }
    }

    public void doExpand() {
        SpreadSheet spreadSheet = this.getActiveSpreadSheet();
        if (spreadSheet != null) {
            spreadSheet.executeAction("Expand");
        }
    }

    public void doCollapse() {
        SpreadSheet spreadSheet = this.getActiveSpreadSheet();
        if (spreadSheet != null) {
            spreadSheet.executeAction("Collapse");
        }
    }

    public void doIndent() {
        SpreadSheet spreadSheet = this.getActiveSpreadSheet();
        if (spreadSheet != null) {
            spreadSheet.executeAction("Indent");
        }
    }

    public void doDelete() {
        SpreadSheet spreadSheet = this.getActiveSpreadSheet();
        if (spreadSheet != null) {
            spreadSheet.executeAction("Delete");
        }
    }

    public void doCut() {
        SpreadSheet spreadSheet = this.getActiveSpreadSheet();
        if (spreadSheet != null) {
            spreadSheet.prepareAction("Cut").actionPerformed(new ActionEvent(spreadSheet, 0, null));
        }
    }

    public void doCopy() {
        SpreadSheet spreadSheet = this.getActiveSpreadSheet();
        if (spreadSheet != null) {
            spreadSheet.prepareAction("Copy").actionPerformed(new ActionEvent(spreadSheet, 0, null));
        }
    }

    public void doPaste() {
        SpreadSheet spreadSheet = this.getActiveSpreadSheet();
        if (spreadSheet != null) {
            spreadSheet.prepareAction("Paste").actionPerformed(new ActionEvent(spreadSheet, 0, null));
        }
    }

    public GanttView getGanttView() {
        if (this.ganttView == null) {
            this.ganttView = new GanttView(this, this.graphicManager.getMenuManager(), this.mainView.getSynchronizer());
            this.ganttView.init(this.getTaskNodeModelCache(), this.getTaskModel(), this.coord);
            this.restoreWorkspaceFor(this.ganttView);
        }
        return this.ganttView;
    }

    public UsageDetailView getTaskUsageDetailView() {
        if (this.taskUsageDetailView == null) {
            this.taskUsageDetailView = new UsageDetailView(this, this.graphicManager.getMenuManager(), this.mainView.getSynchronizer());
            this.taskUsageDetailView.init(this.getTaskNodeModelCache(), true, this.coord, false, "TaskUsageDetail", this.addTransformerInitializationClosure());
            this.restoreWorkspaceFor(this.taskUsageDetailView);
        }
        return this.taskUsageDetailView;
    }

    public UsageDetailView getResourceUsageDetailView() {
        if (this.resourceUsageDetailView == null) {
            this.resourceUsageDetailView = new UsageDetailView(this, this.graphicManager.getMenuManager(), this.mainView.getSynchronizer());
            this.resourceUsageDetailView.init(this.getResourceNodeModelCache(), false, this.coord, false, "ResourceUsageDetail", this.addTransformerInitializationClosure());
            this.restoreWorkspaceFor(this.resourceUsageDetailView);
        }
        return this.resourceUsageDetailView;
    }

    public PertView getPertView() {
        if (this.pertView == null) {
            this.pertView = new PertView(this, this.graphicManager.getMenuManager());
            this.pertView.init(this.getTaskNodeModelCache(), this.getTaskModel());
            this.restoreWorkspaceFor(this.pertView);
        }
        return this.pertView;
    }

    public TreeView getWBSView() {
        if (this.wbsView == null) {
            this.wbsView = new TreeView(this, this.graphicManager.getMenuManager());
            this.wbsView.init(this.getTaskNodeModelCache(), this.getTaskModel(), "WBS", this.addTransformerInitializationClosure());
            this.restoreWorkspaceFor(this.wbsView);
        }
        return this.wbsView;
    }

    public TreeView getRBSView() {
        if (this.rbsView == null) {
            this.rbsView = new TreeView(this, this.graphicManager.getMenuManager());
            this.rbsView.init(this.getResourceNodeModelCache(), this.getResourceModel(), "RBS", this.addTransformerInitializationClosure());
            this.restoreWorkspaceFor(this.rbsView);
        }
        return this.rbsView;
    }

    public BaseView getReportView() {
        try {
            if (this.reportView == null) {
                Class<?> clazz = Class.forName("com.projectlibre1.reports.view.ReportView");
                this.reportView = (BaseView)clazz.getConstructor(DocumentFrame.class).newInstance(this);
                clazz.getMethod("init", CoordinatesConverter.class).invoke((Object)this.reportView, this.coord);
                if (this.reportView != null) {
                    this.restoreWorkspaceFor(this.reportView);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.reportView = null;
        }
        return this.reportView;
    }

    public ChartView getChartView() {
        if (this.chartView == null) {
            this.chartView = new ChartView(this, false, this.graphicManager.getMenuManager(), this.mainView.getSynchronizer(), this.addTransformerInitializationClosure());
            this.chartView.init(this.coord);
            this.restoreWorkspaceFor(this.chartView);
        }
        return this.chartView;
    }

    public ChartView getHistogramView() {
        if (this.histogramView == null) {
            this.histogramView = new ChartView(this, true, this.graphicManager.getMenuManager(), this.mainView.getSynchronizer(), this.addTransformerInitializationClosure());
            this.histogramView.init(this.coord);
            this.restoreWorkspaceFor(this.histogramView);
        }
        return this.histogramView;
    }

    public ResourceView getResourceView() {
        if (this.resourceView == null) {
            this.resourceView = new ResourceView(this.getResourceNodeModelCache(), this.getResourceModel(), this.project.getResourcePool(), !Environment.isProjectLibre() && this.project.isReadOnly(), this.graphicManager.isEditingMasterProject());
            this.restoreWorkspaceFor(this.resourceView);
        }
        return this.resourceView;
    }

    public ProjectView getProjectView() {
        if (this.projectView == null) {
            Portfolio portfolio = this.getGraphicManager().getProjectFactory().getPortfolio();
            this.projectView = new ProjectView(portfolio.getNodeModel(), portfolio);
            this.restoreWorkspaceFor(this.projectView);
        }
        return this.projectView;
    }

    public UsageDetailView getTaskUsageView() {
        if (this.taskUsageView == null) {
            this.taskUsageView = new UsageDetailView(this, this.graphicManager.getMenuManager(), this.mainView.getSynchronizer());
            this.taskUsageView.init(this.getTaskNodeModelCache(), true, this.coord, true, "TaskUsage", this.addTransformerInitializationClosure());
            this.restoreWorkspaceFor(this.taskUsageView);
        }
        return this.taskUsageView;
    }

    public UsageDetailView getResourceUsageView() {
        if (this.resourceUsageView == null) {
            this.resourceUsageView = new UsageDetailView(this, this.graphicManager.getMenuManager(), this.mainView.getSynchronizer());
            this.resourceUsageView.init(this.getResourceNodeModelCache(), false, this.coord, true, "ResourceUsage", this.addTransformerInitializationClosure());
            this.restoreWorkspaceFor(this.resourceUsageView);
        }
        return this.resourceUsageView;
    }

    public void toggleMinWidth() {
        boolean bl = !(this.activeTopView != null && !this.activeTopView.hasNormalMinWidth() || this.activeBottomView != null && !this.activeBottomView.hasNormalMinWidth());
        this.coord.toggleMinWidth(bl);
    }

    public boolean activateView(String string) {
        BaseView baseView = null;
        SplittedView splittedView = null;
        boolean bl = true;
        if (string.equals("Gantt")) {
            this.activateGanttView();
            return bl;
        }
        if (string.equals("TrackingGantt")) {
            this.activateTrackingGanttView();
            return bl;
        }
        if (string.equals("TaskUsageDetail")) {
            baseView = this.getTaskUsageDetailView();
        } else if (string.equals("ResourceUsageDetail")) {
            baseView = this.getResourceUsageDetailView();
        } else if (string.equals("Network")) {
            baseView = this.getPertView();
        } else if (string.equals("WBS")) {
            baseView = this.getWBSView();
        } else if (string.equals("RBS")) {
            baseView = this.getRBSView();
        } else if (string.equals("Report")) {
            baseView = this.getReportView();
        } else if (string.equals("Resources")) {
            baseView = this.getResourceView();
        } else if (string.equals("Projects")) {
            baseView = this.getProjectView();
        } else if (string.equals("Histogram")) {
            splittedView = this.getHistogramView();
        } else if (string.equals("Charts")) {
            splittedView = this.getChartView();
        } else if (string.equals("TaskUsage")) {
            splittedView = this.getTaskUsageView();
        } else if (string.equals("ResourceUsage")) {
            splittedView = this.getResourceUsageView();
        } else if (string.equals("NoSubWindow")) {
            this.deactivateBottomView();
        }
        if (baseView != null) {
            this.activateTopView(baseView, string);
        }
        if (splittedView != null) {
            boolean bl2 = true;
            if (!Environment.isNewLook()) {
                bl2 = splittedView != this.activeBottomView;
                this.deactivateBottomView();
            }
            if (bl2) {
                this.activateBottomView((BaseView)((Object)splittedView), string);
            }
            bl = false;
        }
        return bl;
    }

    private void activateTopView(BaseView baseView, String string) {
        SpreadSheet spreadSheet;
        this.showWaitCursor(true);
        if (this.findDialog != null) {
            this.findDialog.setVisible(false);
        }
        if ((spreadSheet = this.getTopSpreadSheet()) != null) {
            spreadSheet.removeSelectionNodeListener(this);
        }
        this.deactivateTopView();
        this.activeTopView = baseView;
        this.mainView.setTop((Component)((Object)baseView));
        baseView.onActivate(true);
        spreadSheet = baseView.getSpreadSheet();
        if (spreadSheet != null) {
            spreadSheet.addSelectionNodeListener(this);
        }
        this.toggleMinWidth();
        this.menuManager.setActionSelected(string, true);
        this.lastTopButton = string;
        this.setComboBoxesViewName(baseView.getViewName());
        this.getGraphicManager().setTaskInformation(baseView.showsTasks(), baseView.showsResources());
        this.refreshUndoButtons();
        this.getGraphicManager().setEnabledDocumentMenuActions(true);
        this.showWaitCursor(false);
    }

    void deactivateTopView() {
        SpreadSheet spreadSheet;
        if (this.activeTopView == null) {
            return;
        }
        if (this.lastTopButton != null) {
            this.menuManager.setActionSelected(this.lastTopButton, false);
        }
        if ((spreadSheet = this.getTopSpreadSheet()) != null) {
            spreadSheet.removeSelectionNodeListener(this);
        }
        this.mainView.removeTop();
        this.activeTopView.onActivate(false);
        this.activeTopView = null;
        this.toggleMinWidth();
        this.getGraphicManager().setTaskInformation(false, false);
        this.refreshUndoButtons();
        this.getGraphicManager().setEnabledDocumentMenuActions(false);
    }

    public void activateResourceView() {
        this.activateTopView(this.getResourceView(), "Resources");
    }

    public void activateGanttView() {
        if (ganttColumns != null) {
            this.getGanttView().setColumns(ganttColumns);
        }
        this.getGanttView().setBarStyles("standard");
        this.getGanttView().setTracking(false);
        this.activateTopView(this.getGanttView(), "Gantt");
    }

    public ArrayList getGanttColumns() {
        return ganttColumns;
    }

    public void activateTrackingGanttView() {
        this.getGanttView().setBarStyles("Tracking");
        this.getGanttView().setTracking(true);
        ganttColumns = this.getGanttView().setColumns("Spreadsheet.Task.tracking");
        this.activateTopView(this.getGanttView(), "TrackingGantt");
    }

    public void activateBottomView(BaseView baseView, String string) {
        boolean bl = string.equals(this.lastBottomButton);
        if (bl) {
            return;
        }
        if (string == "NoSubWindow") {
            this.deactivateBottomView();
        } else {
            this.mainView.removeBottom();
        }
        this.activeBottomView = baseView;
        baseView.onActivate(true);
        this.lastBottomButton = string;
        this.mainView.setBottom((Component)((Object)baseView));
        this.toggleMinWidth();
        this.menuManager.setActionSelected(string, true);
        this.refreshUndoButtons();
        if (this.lastSelectionEvent != null && baseView != null && baseView instanceof SelectionNodeListener) {
            ((SelectionNodeListener)((Object)baseView)).selectionChanged(this.lastSelectionEvent);
        }
    }

    public void deactivateBottomView() {
        if (this.activeBottomView == null) {
            return;
        }
        this.menuManager.setActionSelected("NoSubWindow", true);
        if (this.lastBottomButton != null) {
            this.menuManager.setActionSelected(this.lastBottomButton, false);
        }
        this.activeTopView.onActivate(false);
        this.lastBottomButton = "NoSubWindow";
        this.mainView.removeBottom();
        this.activeBottomView = null;
        this.toggleMinWidth();
        this.refreshUndoButtons();
    }

    public MainView getMainView() {
        return this.mainView;
    }

    public Project getProject() {
        return this.project;
    }

    public SpreadSheet getTopSpreadSheet() {
        SpreadSheet spreadSheet = null;
        if (this.activeTopView != null) {
            spreadSheet = this.activeTopView.getSpreadSheet();
        }
        return spreadSheet;
    }

    public SpreadSheet getActiveSpreadSheet() {
        SpreadSheet spreadSheet = this.getTopSpreadSheet();
        if (spreadSheet == null && this.activeBottomView != null) {
            spreadSheet = this.activeBottomView.getSpreadSheet();
        }
        return spreadSheet;
    }

    @Override
    public void selectionChanged(SelectionNodeEvent selectionNodeEvent) {
        this.lastSelectionEvent = selectionNodeEvent;
        Component component = this.mainView.getBottomComponent();
        if (component != null && component instanceof SelectionNodeListener) {
            ((SelectionNodeListener)((Object)component)).selectionChanged(selectionNodeEvent);
        }
        this.graphicManager.selectionChanged(selectionNodeEvent);
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    private boolean hasAtLeastOneTaskSelected() {
        return DataUtils.nodeListContainsImplOfType(this.getSelectedNodes(true), Task.class);
    }

    private void forTasksDo(Closure closure, boolean bl) {
        DataUtils.forAllDo(closure, bl, this.project.getTaskOutlineIterator(), (Collection)this.getSelectedNodes(true), Task.class);
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.refreshUndoButtons();
    }

    public UndoController getUndoController() {
        return this.currentUndoController;
    }

    void refreshViewButtons(boolean bl) {
        if (bl) {
            this.refreshUndoButtons();
        }
        if (this.lastTopButton != null) {
            this.menuManager.setActionSelected(this.lastTopButton, bl);
        }
        if (this.lastBottomButton != null) {
            this.menuManager.setActionSelected(this.lastBottomButton, bl);
        }
    }

    public void refreshUndoButtons() {
        UndoController undoController = null;
        if (this.activeTopView != null) {
            undoController = this.activeTopView.getUndoController();
        }
        if (undoController != this.currentUndoController) {
            if (this.currentUndoController != null) {
                this.currentUndoController.getEditSupport().removeUndoableEditListener(this);
            }
            if (undoController != null) {
                undoController.getEditSupport().addUndoableEditListener(this);
            }
            this.currentUndoController = undoController;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (undoController != null) {
            bl = undoController.canUndo();
            bl2 = undoController.canRedo();
        }
        this.menuManager.setActionEnabled("Undo", bl);
        this.menuManager.setActionEnabled("Redo", bl2);
    }

    public Node addNodeForImpl(Object object) {
        return this.addNodeForImpl(object, 3);
    }

    public Node addNodeForImpl(Object object, int n) {
        SpreadSheet spreadSheet = this.getTopSpreadSheet();
        if (object == null) {
            spreadSheet.executeAction("InsertTask");
            return null;
        }
        return spreadSheet.addNodeForImpl(object, n);
    }

    public boolean isCurrentRowInMainProject() {
        SpreadSheet spreadSheet = this.getTopSpreadSheet();
        if (spreadSheet == null) {
            return true;
        }
        int n = spreadSheet.getCurrentRow();
        if (n == -1) {
            return true;
        }
        Node node = spreadSheet.getCurrentRowNode();
        SpreadSheetModel spreadSheetModel = (SpreadSheetModel)spreadSheet.getModel();
        LinkedList linkedList = spreadSheetModel.getPreviousVisibleNodesFromRow(n);
        if (linkedList == null) {
            return true;
        }
        linkedList.add(node);
        ListIterator listIterator = linkedList.listIterator(linkedList.size());
        while (listIterator.hasPrevious()) {
            Object object = ((Node)listIterator.previous()).getImpl();
            if (!(object instanceof Task)) continue;
            if (((Task)object).isInSubproject()) {
                return false;
            }
            return this.project == ((Task)object).getOwningProject();
        }
        return true;
    }

    public List getSelectedImpls(boolean bl) {
        return NodeList.nodeListToImplList(this.getSelectedNodes(bl));
    }

    public void finishAnyOperations() {
        if (!this.isActive()) {
            return;
        }
        SpreadSheet spreadSheet = this.getTopSpreadSheet();
        if (spreadSheet != null) {
            spreadSheet.finishCurrentOperations();
        }
    }

    public void setComboBoxesViewName(String string) {
        if (!Environment.isPlugin()) {
            this.filterToolBarManager.setComboBoxesViewName(string);
        }
    }

    public void showWaitCursor(boolean bl) {
        this.getGraphicManager().showWaitCursor(bl);
    }

    @Override
    public void objectChanged(ObjectEvent objectEvent) {
        if (objectEvent.getObject() instanceof Project && objectEvent.isUpdate()) {
            if (objectEvent.getField() == Configuration.getFieldFromId("Field.name")) {
                this.getGraphicManager().setTabNameAndTitle(this, this.project);
            }
        } else if (objectEvent.getObject() instanceof GlobalPreferences && objectEvent.isUpdate()) {
            for (ResourceInTeamFilter resourceInTeamFilter : this.resourcesInTeamFilters) {
                resourceInTeamFilter.setFilterTeam(this.getGraphicManager().getPreferences().isShowProjectResourcesOnly());
            }
            ResourceInTeamFilter resourceInTeamFilter = this.getGraphicManager().getAssignmentDialogTransformerInitializationClosure();
            if (resourceInTeamFilter != null) {
                resourceInTeamFilter.setFilterTeam(this.getGraphicManager().getPreferences().isShowProjectResourcesOnly());
            }
        }
    }

    public Closure addTransformerInitializationClosure() {
        return new Closure(){

            @Override
            public void execute(Object object) {
                ViewTransformer viewTransformer = (ViewTransformer)object;
                NodeFilter nodeFilter = viewTransformer.getHiddenFilter();
                if (nodeFilter != null && nodeFilter instanceof ResourceInTeamFilter) {
                    ResourceInTeamFilter resourceInTeamFilter = (ResourceInTeamFilter)nodeFilter;
                    resourceInTeamFilter.setFilterTeam(DocumentFrame.this.getGraphicManager().getPreferences().isShowProjectResourcesOnly());
                    DocumentFrame.this.resourcesInTeamFilters.add(resourceInTeamFilter);
                }
            }
        };
    }

    void onClose() {
        this.project = null;
    }

    boolean isPrintable() {
        return this.activeTopView != null && this.activeTopView.isPrintable();
    }

    final CoordinatesConverter getCoord() {
        return this.coord;
    }

    @Override
    public void nameChanged(ProjectEvent projectEvent) {
        this.setTabNameAndTitle(projectEvent.getProject());
    }

    @Override
    public void groupDirtyChanged(ProjectEvent projectEvent) {
        this.setTabNameAndTitle(projectEvent.getProject());
        this.getGraphicManager().refreshSaveStatus(false);
    }

    void setTabNameAndTitle(Project project) {
        boolean bl = this.isShowTitleBar();
        this.getGraphicManager().setTitle(false);
        this.setTabTitle(project.getName());
        this.setShowTitleBar(bl);
    }

    String getTopViewId() {
        if (this.lastTopButton == null) {
            return "Gantt";
        }
        return this.lastTopButton;
    }

    protected void finalize() throws Throwable {
        System.out.println("~~~~~~~~~~~~~~~~ DocumentFrame.finalize()");
        super.finalize();
    }

    public void cleanUp() {
        System.out.println("Document Frame Cleanup");
        if (this.project != null) {
            this.project.removeProjectListener(this);
            this.project.removeObjectListener(this);
            this.project.removeScheduleListener(this.coord);
        }
        if (this.getUndoController() != null && this.getUndoController().getEditSupport() != null) {
            this.getUndoController().getEditSupport().removeUndoableEditListener(this);
        }
        if (this.coord != null) {
            this.coord.removeTimeScaleListener(this.mainView);
        }
        this.forAllViews(new Closure(this){

            @Override
            public void execute(Object object) {
                if (object != null) {
                    ((BaseView)object).cleanUp();
                }
            }
        });
        this.resetViews();
        if (this.jobQueue != null) {
            this.jobQueue.cancel();
        }
        this.jobQueue = null;
        this.project = null;
        this.coord = null;
        this.resetViews();
    }

    void resetViews() {
        this.ganttView = null;
        this.taskUsageDetailView = null;
        this.resourceUsageDetailView = null;
        this.pertView = null;
        this.wbsView = null;
        this.rbsView = null;
        this.chartView = null;
        this.histogramView = null;
        this.resourceView = null;
        this.projectView = null;
        this.taskUsageView = null;
        this.resourceUsageView = null;
        this.reportView = null;
        this.activeTopView = null;
        this.activeBottomView = null;
    }

    private void forAllViews(Closure closure) {
        Object[] objectArray = new Object[]{this.ganttView, this.taskUsageDetailView, this.resourceUsageDetailView, this.pertView, this.wbsView, this.rbsView, this.chartView, this.histogramView, this.resourceView, this.projectView, this.taskUsageView, this.resourceUsageView, this.reportView};
        ArrayUtils.forAllDo(objectArray, closure);
    }

    @Override
    public void restoreWorkspace(WorkspaceSetting workspaceSetting, int n) {
        Workspace workspace;
        this.workspace = workspace = (Workspace)workspaceSetting;
        this.setMainView(false);
        if (this.project == null) {
            this.project = ProjectFactory.getInstance().findFromId(workspace.projectId);
            if (this.project == null) {
                LoadOptions loadOptions = new LoadOptions();
                loadOptions.setId(workspace.projectId);
                loadOptions.setSync(true);
                this.project = ProjectFactory.getInstance().openProject(loadOptions);
            }
        }
        this.coord.restoreWorkspace(workspace.getCoord(), n);
        this.activateView(workspace.topViewName);
        this.activateView(workspace.bottomViewName);
        this.mainView.restoreWorkspace(workspace.mainView, n);
    }

    private WorkspaceSetting restoreWorkspaceFor(BaseView baseView) {
        WorkspaceSetting workspaceSetting = this.getWorkspaceFor(baseView);
        if (workspaceSetting != null) {
            baseView.restoreWorkspace(workspaceSetting, 0);
        }
        return workspaceSetting;
    }

    private WorkspaceSetting getWorkspaceFor(BaseView baseView) {
        if (this.workspace == null || this.workspace.views == null) {
            return null;
        }
        return (WorkspaceSetting)this.workspace.views.get(baseView.getViewName());
    }

    private void saveViewWorkspace(Workspace workspace, String string, BaseView baseView) {
        if (baseView != null) {
            workspace.views.put(string, baseView.createWorkspace(0));
        }
    }

    @Override
    public WorkspaceSetting createWorkspace(int n) {
        Workspace workspace = new Workspace();
        workspace.projectId = this.getProject().getUniqueId();
        workspace.topViewName = this.getTopViewId();
        workspace.bottomViewName = this.lastBottomButton;
        workspace.coord = this.coord.createWorkspace(n);
        workspace.mainView = this.mainView.createWorkspace(n);
        workspace.saveViewWorkspace("Gantt", this.ganttView);
        workspace.saveViewWorkspace("TaskUsageDetail", this.taskUsageDetailView);
        workspace.saveViewWorkspace("ResourceUsageDetail", this.resourceUsageDetailView);
        workspace.saveViewWorkspace("Network", this.pertView);
        workspace.saveViewWorkspace("WBS", this.wbsView);
        workspace.saveViewWorkspace("RBS", this.rbsView);
        workspace.saveViewWorkspace("Charts", this.chartView);
        workspace.saveViewWorkspace("Histogram", this.histogramView);
        workspace.saveViewWorkspace("Resources", this.resourceView);
        workspace.saveViewWorkspace("Projects", this.projectView);
        workspace.saveViewWorkspace("TaskUsage", this.taskUsageView);
        workspace.saveViewWorkspace("ResourceUsage", this.resourceUsageView);
        workspace.saveViewWorkspace("Report", this.reportView);
        return workspace;
    }

    public FilterToolBarManager getFilterToolBarManager() {
        return this.filterToolBarManager;
    }

    public BaseView getActiveBottomView() {
        return this.activeBottomView;
    }

    public BaseView getActiveTopView() {
        return this.activeTopView;
    }

    public void setMenuItem(JRadioButtonMenuItem jRadioButtonMenuItem) {
        this.menuItem = jRadioButtonMenuItem;
    }

    public JRadioButtonMenuItem getMenuItem() {
        return this.menuItem;
    }

    @Override
    public void setActive(boolean bl) {
        super.setActive(bl);
        if (this.isEditingResourcePool()) {
            this.getGraphicManager().setAllButResourceDisabled(true);
        } else {
            this.getGraphicManager().setAllButResourceDisabled(false);
        }
    }

    boolean isEditingResourcePool() {
        return this.project.isMaster() && !this.project.isLocal();
    }

    public void doFind(Searchable searchable, Field field) {
        if (!this.isActive()) {
            return;
        }
        if (this.findDialog == null) {
            this.findDialog = FindDialog.getInstance(this, searchable, field);
            this.findDialog.pack();
            this.findDialog.setModal(false);
        } else {
            this.findDialog.init(searchable, field);
        }
        this.findDialog.setLocationRelativeTo(this);
        this.findDialog.setVisible(true);
    }

    @Override
    public void objectSelected(ObjectSelectionEvent objectSelectionEvent) {
        SpreadSheet spreadSheet = this.getTopSpreadSheet();
        spreadSheet.selectObject(objectSelectionEvent.getObject());
        this.doScrollToTask();
    }

    public static class Workspace
    implements WorkspaceSetting {
        private static final long serialVersionUID = 8836549717587108911L;
        long projectId;
        String topViewName;
        String bottomViewName;
        WorkspaceSetting coord;
        WorkspaceSetting mainView;
        HashMap views;

        public void saveViewWorkspace(String string, BaseView baseView) {
            if (this.views == null) {
                this.views = new HashMap();
            }
            if (baseView != null) {
                this.views.put(string, baseView.createWorkspace(0));
            }
        }

        public final String getBottomViewName() {
            return this.bottomViewName;
        }

        public final void setBottomViewName(String string) {
            this.bottomViewName = string;
        }

        public final String getTopViewName() {
            return this.topViewName;
        }

        public final void setTopViewName(String string) {
            this.topViewName = string;
        }

        public final long getProjectId() {
            return this.projectId;
        }

        public final void setProjectId(long l) {
            this.projectId = l;
        }

        public WorkspaceSetting getCoord() {
            return this.coord;
        }

        public void setCoord(WorkspaceSetting workspaceSetting) {
            this.coord = workspaceSetting;
        }

        public HashMap getViews() {
            return this.views;
        }

        public void setViews(HashMap hashMap) {
            this.views = hashMap;
        }

        public WorkspaceSetting getMainView() {
            return this.mainView;
        }

        public void setMainView(WorkspaceSetting workspaceSetting) {
            this.mainView = workspaceSetting;
        }
    }
}

