/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk;

import com.amazonaws.encryptionsdk.CryptoResult;
import com.amazonaws.encryptionsdk.MasterKey;
import com.amazonaws.encryptionsdk.exception.BadCiphertextException;
import com.amazonaws.encryptionsdk.internal.MessageCryptoHandler;
import com.amazonaws.encryptionsdk.internal.Utils;
import java.io.IOException;
import java.io.OutputStream;

public class CryptoOutputStream<K extends MasterKey<K>>
extends OutputStream {
    private final OutputStream outputStream_;
    private final MessageCryptoHandler cryptoHandler_;

    CryptoOutputStream(OutputStream outputStream, MessageCryptoHandler cryptoHandler) {
        this.outputStream_ = Utils.assertNonNull(outputStream, "outputStream");
        this.cryptoHandler_ = Utils.assertNonNull(cryptoHandler, "cryptoHandler");
    }

    @Override
    public void write(byte[] b) throws IllegalArgumentException, IOException, BadCiphertextException {
        if (b == null) {
            throw new IllegalArgumentException("b cannot be null");
        }
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IllegalArgumentException, IOException, BadCiphertextException {
        if (b == null) {
            throw new IllegalArgumentException("b cannot be null");
        }
        if (len < 0 || off < 0) {
            throw new IllegalArgumentException(String.format("Invalid values for offset: %d and length: %d", off, len));
        }
        int outLen = this.cryptoHandler_.estimatePartialOutputSize(len);
        byte[] outBytes = new byte[outLen];
        int bytesWritten = this.cryptoHandler_.processBytes(b, off, len, outBytes, 0).getBytesWritten();
        if (bytesWritten > 0) {
            this.outputStream_.write(outBytes, 0, bytesWritten);
        }
    }

    @Override
    public void write(int b) throws IOException, BadCiphertextException {
        byte[] bArray = new byte[]{(byte)b};
        this.write(bArray, 0, 1);
    }

    @Override
    public void close() throws IOException, BadCiphertextException {
        byte[] outBytes = new byte[this.cryptoHandler_.estimateFinalOutputSize()];
        int finalLen = this.cryptoHandler_.doFinal(outBytes, 0);
        this.outputStream_.write(outBytes, 0, finalLen);
        this.outputStream_.close();
    }

    public void setMaxInputLength(long size) {
        this.cryptoHandler_.setMaxInputLength(size);
    }

    public CryptoResult<CryptoOutputStream<K>, K> getCryptoResult() {
        if (!this.cryptoHandler_.getHeaders().isComplete().booleanValue()) {
            throw new IllegalStateException("Ciphertext headers not yet written to stream");
        }
        return new CryptoResult(this, this.cryptoHandler_.getMasterKeys(), this.cryptoHandler_.getHeaders(), this.cryptoHandler_.getEncryptionContext());
    }
}

