/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;

public class PGPKeyPair {
    protected PGPPublicKey pub;
    protected PGPPrivateKey priv;

    public PGPKeyPair(PGPPublicKey pub, PGPPrivateKey priv) {
        this.pub = pub;
        this.priv = priv;
    }

    protected PGPKeyPair() {
    }

    public long getKeyID() {
        return this.pub.getKeyID();
    }

    public KeyIdentifier getKeyIdentifier() {
        return this.getPublicKey().getKeyIdentifier();
    }

    public PGPPublicKey getPublicKey() {
        return this.pub;
    }

    public PGPPrivateKey getPrivateKey() {
        return this.priv;
    }

    public PGPKeyPair asSubkey(KeyFingerPrintCalculator fingerPrintCalculator) throws PGPException {
        if (this.pub.getPublicKeyPacket() instanceof PublicSubkeyPacket) {
            return this;
        }
        PublicSubkeyPacket pubSubPkt = new PublicSubkeyPacket(this.pub.getVersion(), this.pub.getAlgorithm(), this.pub.getCreationTime(), this.pub.getPublicKeyPacket().getKey());
        return new PGPKeyPair(new PGPPublicKey(pubSubPkt, fingerPrintCalculator), new PGPPrivateKey(this.pub.getKeyID(), pubSubPkt, this.priv.getPrivateKeyDataPacket()));
    }
}

