/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.plugin.rest;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.sql.common.utils.QueryContext;
import org.opensearch.sql.datasources.utils.Scheduler;
import org.opensearch.sql.legacy.executor.format.ErrorMessageFactory;
import org.opensearch.sql.legacy.metrics.Metrics;
import org.opensearch.transport.client.node.NodeClient;
import shaded.com.google.common.collect.ImmutableList;

public class RestPPLStatsAction
extends BaseRestHandler {
    private static final Logger LOG = LogManager.getLogger(RestPPLStatsAction.class);
    public static final String PPL_STATS_API_ENDPOINT = "/_plugins/_ppl/stats";

    public RestPPLStatsAction(Settings settings, RestController restController) {
    }

    public String getName() {
        return "ppl_stats_action";
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, PPL_STATS_API_ENDPOINT), (Object)new RestHandler.Route(RestRequest.Method.GET, PPL_STATS_API_ENDPOINT));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        QueryContext.addRequestId();
        try {
            return channel -> Scheduler.schedule(client, () -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, Metrics.getInstance().collectToJSON())));
        }
        catch (Exception e) {
            LOG.error("Failed during Query PPL STATS Action.", (Throwable)e);
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, ErrorMessageFactory.createErrorMessage(e, RestStatus.INTERNAL_SERVER_ERROR.getStatus()).toString()));
        }
    }

    protected Set<String> responseParams() {
        HashSet<String> responseParams = new HashSet<String>(super.responseParams());
        responseParams.addAll(Arrays.asList("format", "sanitize"));
        return responseParams;
    }
}

