/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.parse;

import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.parse.ParseExpression;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableSet;

public class PatternsExpression
extends ParseExpression {
    public static final String DEFAULT_NEW_FIELD = "patterns_field";
    private static final ImmutableSet<Character> DEFAULT_IGNORED_CHARS = ImmutableSet.copyOf((Object[])((Character[])"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".chars().mapToObj(c -> Character.valueOf((char)c)).toArray(Character[]::new)));
    private final boolean useCustomPattern;
    private Pattern pattern;

    public PatternsExpression(Expression sourceField, Expression pattern, Expression identifier) {
        super("patterns", sourceField, pattern, identifier);
        String patternStr = pattern.valueOf().stringValue();
        boolean bl = this.useCustomPattern = !patternStr.isEmpty();
        if (this.useCustomPattern) {
            this.pattern = Pattern.compile(patternStr);
        }
    }

    @Override
    public ExprValue parseValue(ExprValue value) throws ExpressionEvaluationException {
        String rawString;
        String string = rawString = value.isNull() || value.isMissing() ? "" : value.stringValue();
        if (this.useCustomPattern) {
            return new ExprStringValue(this.pattern.matcher(rawString).replaceAll(""));
        }
        char[] chars = rawString.toCharArray();
        int pos = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (DEFAULT_IGNORED_CHARS.contains((Object)Character.valueOf(chars[i]))) continue;
            chars[pos++] = chars[i];
        }
        return new ExprStringValue(new String(chars, 0, pos));
    }

    public static List<String> getNamedGroupCandidates(String identifier) {
        return ImmutableList.of((Object)Objects.requireNonNullElse(identifier, DEFAULT_NEW_FIELD));
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PatternsExpression)) {
            return false;
        }
        PatternsExpression other = (PatternsExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.useCustomPattern == other.useCustomPattern;
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PatternsExpression;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.useCustomPattern ? 79 : 97);
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "PatternsExpression(useCustomPattern=" + this.useCustomPattern + ", pattern=" + String.valueOf(this.pattern) + ")";
    }
}

