/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.directquery.transport;

import org.opensearch.action.ActionType;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.sql.directquery.DirectQueryExecutorService;
import org.opensearch.sql.directquery.DirectQueryExecutorServiceImpl;
import org.opensearch.sql.directquery.rest.model.ExecuteDirectQueryRequest;
import org.opensearch.sql.directquery.rest.model.ExecuteDirectQueryResponse;
import org.opensearch.sql.directquery.transport.model.ExecuteDirectQueryActionRequest;
import org.opensearch.sql.directquery.transport.model.ExecuteDirectQueryActionResponse;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportExecuteDirectQueryRequestAction
extends HandledTransportAction<ExecuteDirectQueryActionRequest, ExecuteDirectQueryActionResponse> {
    private final DirectQueryExecutorService directQueryExecutorService;
    public static final String NAME = "cluster:admin/opensearch/direct_query/read/query";
    public static final ActionType<ExecuteDirectQueryActionResponse> ACTION_TYPE = new ActionType("cluster:admin/opensearch/direct_query/read/query", ExecuteDirectQueryActionResponse::new);

    @Inject
    public TransportExecuteDirectQueryRequestAction(TransportService transportService, ActionFilters actionFilters, DirectQueryExecutorServiceImpl directQueryExecutorService) {
        super(NAME, transportService, actionFilters, ExecuteDirectQueryActionRequest::new);
        this.directQueryExecutorService = directQueryExecutorService;
    }

    protected void doExecute(Task task, ExecuteDirectQueryActionRequest request, ActionListener<ExecuteDirectQueryActionResponse> listener) {
        try {
            ExecuteDirectQueryRequest directQueryRequest = request.getDirectQueryRequest();
            ExecuteDirectQueryResponse response = this.directQueryExecutorService.executeDirectQuery(directQueryRequest);
            listener.onResponse((Object)new ExecuteDirectQueryActionResponse(response.getQueryId(), response.getResult(), response.getSessionId(), directQueryRequest.getDataSources(), response.getDataSourceType()));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }
}

