/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning.handlers;

import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.Bin;
import org.opensearch.sql.ast.tree.RangeBin;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.CalciteRexNodeVisitor;
import org.opensearch.sql.calcite.utils.binning.BinFieldValidator;
import org.opensearch.sql.calcite.utils.binning.BinHandler;
import org.opensearch.sql.calcite.utils.binning.BinnableField;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.PPLFuncImpTable;

public class RangeBinHandler
implements BinHandler {
    @Override
    public RexNode createExpression(Bin node, RexNode fieldExpr, CalcitePlanContext context, CalciteRexNodeVisitor visitor) {
        RangeBin rangeBin = (RangeBin)node;
        String fieldName = BinFieldValidator.extractFieldName(node);
        BinnableField field = new BinnableField(fieldExpr, fieldExpr.getType(), fieldName);
        if (!field.requiresNumericBinning()) {
            throw new IllegalArgumentException("Range binning (start/end) is only supported for numeric fields, not time-based fields");
        }
        RexNode dataMin = context.relBuilder.min(fieldExpr).over().toRex();
        RexNode dataMax = context.relBuilder.max(fieldExpr).over().toRex();
        RexNode startParam = this.convertParameter(rangeBin.getStart(), context, visitor);
        RexNode endParam = this.convertParameter(rangeBin.getEnd(), context, visitor);
        return PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.RANGE_BUCKET, fieldExpr, dataMin, dataMax, startParam, endParam);
    }

    private RexNode convertParameter(UnresolvedExpression expr, CalcitePlanContext context, CalciteRexNodeVisitor visitor) {
        if (expr == null) {
            return context.relBuilder.literal(null);
        }
        return visitor.analyze(expr, context);
    }
}

