/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.expression;

import java.util.Locale;
import lombok.Generated;
import org.opensearch.sql.ast.dsl.AstDSL;
import org.opensearch.sql.ast.expression.DataType;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.expression.WindowBound;

public class WindowFrame
extends UnresolvedExpression {
    private final FrameType type;
    private final WindowBound lower;
    private final WindowBound upper;

    public static WindowFrame rowsUnbounded() {
        return WindowFrame.of(FrameType.ROWS, AstDSL.stringLiteral("UNBOUNDED PRECEDING"), AstDSL.stringLiteral("UNBOUNDED FOLLOWING"));
    }

    public static WindowFrame toCurrentRow() {
        return WindowFrame.of(FrameType.ROWS, AstDSL.stringLiteral("UNBOUNDED PRECEDING"), AstDSL.stringLiteral("CURRENT ROW"));
    }

    public static WindowFrame of(FrameType type, String lower, String upper) {
        return WindowFrame.of(type, AstDSL.stringLiteral(lower), AstDSL.stringLiteral(upper));
    }

    public static WindowFrame of(FrameType type, Literal lower, Literal upper) {
        WindowBound lowerBound = null;
        WindowBound upperBound = null;
        if (lower != null) {
            if (lower.getType() == DataType.STRING) {
                lowerBound = WindowFrame.createBound(lower.getValue().toString());
            } else {
                throw new IllegalArgumentException(String.format("Unsupported bound type: %s", new Object[]{lower.getType()}));
            }
        }
        if (upper != null) {
            if (upper.getType() == DataType.STRING) {
                upperBound = WindowFrame.createBound(upper.getValue().toString());
            } else {
                throw new IllegalArgumentException(String.format("Unsupported bound type: %s", new Object[]{upper.getType()}));
            }
        }
        return new WindowFrame(type, lowerBound, upperBound);
    }

    private static WindowBound createBound(String boundType) {
        if ("CURRENT ROW".equals(boundType = boundType.trim().toUpperCase(Locale.ROOT))) {
            return new WindowBound.CurrentRowWindowBound();
        }
        if ("UNBOUNDED PRECEDING".equals(boundType)) {
            return new WindowBound.UnboundedWindowBound(true);
        }
        if ("UNBOUNDED FOLLOWING".equals(boundType)) {
            return new WindowBound.UnboundedWindowBound(false);
        }
        if (boundType.endsWith(" PRECEDING")) {
            long number = Long.parseLong(boundType.split(" PRECEDING")[0]);
            return new WindowBound.OffSetWindowBound(number, true);
        }
        if (boundType.endsWith(" FOLLOWING")) {
            long number = Long.parseLong(boundType.split(" FOLLOWING")[0]);
            return new WindowBound.OffSetWindowBound(number, false);
        }
        throw new IllegalArgumentException(String.format("Unsupported bound type: %s", boundType));
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WindowFrame)) {
            return false;
        }
        WindowFrame other = (WindowFrame)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FrameType this$type = this.getType();
        FrameType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        WindowBound this$lower = this.getLower();
        WindowBound other$lower = other.getLower();
        if (this$lower == null ? other$lower != null : !this$lower.equals(other$lower)) {
            return false;
        }
        WindowBound this$upper = this.getUpper();
        WindowBound other$upper = other.getUpper();
        return !(this$upper == null ? other$upper != null : !this$upper.equals(other$upper));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WindowFrame;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FrameType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        WindowBound $lower = this.getLower();
        result = result * 59 + ($lower == null ? 43 : $lower.hashCode());
        WindowBound $upper = this.getUpper();
        result = result * 59 + ($upper == null ? 43 : $upper.hashCode());
        return result;
    }

    @Generated
    public FrameType getType() {
        return this.type;
    }

    @Generated
    public WindowBound getLower() {
        return this.lower;
    }

    @Generated
    public WindowBound getUpper() {
        return this.upper;
    }

    @Generated
    public WindowFrame(FrameType type, WindowBound lower, WindowBound upper) {
        this.type = type;
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    @Generated
    public String toString() {
        return "WindowFrame(type=" + String.valueOf((Object)this.getType()) + ", lower=" + String.valueOf(this.getLower()) + ", upper=" + String.valueOf(this.getUpper()) + ")";
    }

    public static enum FrameType {
        RANGE,
        ROWS;

    }
}

