/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest.mcpserver;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ActionType;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.mcpserver.action.MLMcpToolsUpdateAction;
import org.opensearch.ml.common.transport.mcpserver.requests.update.MLMcpToolsUpdateNodesRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

@ExperimentalApi
public class RestMLMcpToolsUpdateAction
extends BaseRestHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(RestMLMcpToolsUpdateAction.class);
    private static final String ML_UPDATE_MCP_TOOLS_ACTION = "ml_mcp_tools_update_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private final ClusterService clusterService;

    public RestMLMcpToolsUpdateAction(ClusterService clusterService, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.clusterService = clusterService;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_UPDATE_MCP_TOOLS_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/mcp/tools/_update", "/_plugins/_ml")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.mlFeatureEnabledSetting.isMcpServerEnabled()) {
            throw new OpenSearchException(MLCommonsSettings.ML_COMMONS_MCP_SERVER_DISABLED_MESSAGE, new Object[0]);
        }
        MLMcpToolsUpdateNodesRequest updateNodesRequest = this.getRequest(request);
        ActionRequestValidationException exception = new ActionRequestValidationException();
        if (CollectionUtils.isEmpty((Collection)updateNodesRequest.getMcpTools())) {
            exception.addValidationError("tools list can not be null");
            throw exception;
        }
        return channel -> client.execute((ActionType)MLMcpToolsUpdateAction.INSTANCE, (ActionRequest)this.getRequest(request), (ActionListener)new RestToXContentListener(channel));
    }

    private MLMcpToolsUpdateNodesRequest getRequest(RestRequest request) throws IOException {
        return MLMcpToolsUpdateNodesRequest.parse((XContentParser)request.contentParser(), (String[])this.clusterService.state().nodes().getNodes().keySet().toArray(new String[0]));
    }
}

