/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.OpenSearchParseException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupAction;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupInput;
import org.opensearch.ml.common.transport.model_group.MLRegisterModelGroupRequest;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLRegisterModelGroupAction
extends BaseRestHandler {
    private static final String ML_REGISTER_MODEL_GROUP_ACTION = "ml_register_model_group_action";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLRegisterModelGroupAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_REGISTER_MODEL_GROUP_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/model_groups/_register", "/_plugins/_ml")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLRegisterModelGroupRequest createModelGroupRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLRegisterModelGroupAction.INSTANCE, (ActionRequest)createModelGroupRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLRegisterModelGroupRequest getRequest(RestRequest request) throws IOException {
        boolean hasContent = request.hasContent();
        String tenantId = TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request);
        if (!hasContent) {
            throw new OpenSearchParseException("Model group request has empty body", new Object[0]);
        }
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLRegisterModelGroupInput input = MLRegisterModelGroupInput.parse((XContentParser)parser);
        input.setTenantId(tenantId);
        return new MLRegisterModelGroupRequest(input);
    }
}

