/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.ml.common.memorycontainer.MemoryType;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.memorycontainer.MLMemoryContainerDeleteAction;
import org.opensearch.ml.common.transport.memorycontainer.MLMemoryContainerDeleteRequest;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLDeleteMemoryContainerAction
extends BaseRestHandler {
    private static final String ML_DELETE_MEMORY_CONTAINER_ACTION = "ml_delete_memory_container_action";
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLDeleteMemoryContainerAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_DELETE_MEMORY_CONTAINER_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.DELETE, String.format(Locale.ROOT, "%s/{%s}", "/_plugins/_ml/memory_containers", "memory_container_id")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.mlFeatureEnabledSetting.isAgenticMemoryEnabled()) {
            throw new OpenSearchStatusException(MLCommonsSettings.ML_COMMONS_AGENTIC_MEMORY_DISABLED_MESSAGE, RestStatus.FORBIDDEN, new Object[0]);
        }
        String memoryContainerId = request.param("memory_container_id");
        String tenantId = TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request);
        boolean deleteAllMemories = request.paramAsBoolean("delete_all_memories", false);
        LinkedHashSet<String> deleteMemoriesStr = null;
        String[] memoryArray = request.paramAsStringArray("delete_memories", Strings.EMPTY_ARRAY);
        if (memoryArray != null && memoryArray.length > 0) {
            deleteMemoriesStr = new LinkedHashSet<String>(Arrays.asList(memoryArray));
        }
        if (request.hasContent()) {
            try (XContentParser parser = request.contentParser();){
                Object value;
                Map map = parser.map();
                if (!deleteAllMemories && map.containsKey("delete_all_memories") && (value = map.get("delete_all_memories")) instanceof Boolean) {
                    deleteAllMemories = (Boolean)value;
                }
                if ((deleteMemoriesStr == null || deleteMemoriesStr.isEmpty()) && map.containsKey("delete_memories") && (value = map.get("delete_memories")) instanceof List) {
                    deleteMemoriesStr = new LinkedHashSet();
                    for (Object item : (List)value) {
                        if (!(item instanceof String)) continue;
                        deleteMemoriesStr.add((String)item);
                    }
                }
            }
        }
        Set deleteMemories = null;
        if (deleteMemoriesStr != null && !deleteMemoriesStr.isEmpty()) {
            deleteMemories = deleteMemoriesStr.stream().map(MemoryType::fromString).collect(Collectors.toSet());
        }
        MLMemoryContainerDeleteRequest mlMemoryContainerDeleteRequest = new MLMemoryContainerDeleteRequest(memoryContainerId, deleteAllMemories, deleteMemories, tenantId);
        return channel -> client.execute((ActionType)MLMemoryContainerDeleteAction.INSTANCE, (ActionRequest)mlMemoryContainerDeleteRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

