/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.painless.DefBootstrap;
import org.opensearch.painless.WriterConstants;
import org.opensearch.script.ScriptException;

public interface PainlessScript {
    public String getName();

    public String getSource();

    public BitSet getStatements();

    default public ScriptException convertToScriptException(Throwable originalThrowable, Map<String, List<String>> extraMetadata) {
        Throwable throwable = originalThrowable;
        Objects.requireNonNull(throwable);
        Throwable throwable2 = throwable;
        int n = 0;
        Throwable unwrapped = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DefBootstrap.WrappedCheckedException.class}, (Object)throwable2, n)) {
            case 0 -> {
                StackTraceElement[] w = (StackTraceElement[])throwable2;
                yield w.getCause();
            }
            default -> originalThrowable;
        };
        ArrayList<String> scriptStack = new ArrayList<String>();
        ScriptException.Position pos = null;
        for (StackTraceElement element : unwrapped.getStackTrace()) {
            if (WriterConstants.CLASS_NAME.equals(element.getClassName())) {
                int endOffset;
                int offset;
                int startOffset;
                int originalOffset = element.getLineNumber();
                if (originalOffset == -1) {
                    scriptStack.add("<<< unknown portion of script >>>");
                    break;
                }
                if ((startOffset = this.getPreviousStatement(offset = --originalOffset)) == -1) {
                    if (!1.$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    startOffset = 0;
                }
                if ((endOffset = this.getNextStatement(startOffset)) == -1) {
                    endOffset = this.getSource().length();
                }
                String snippet = this.getSource().substring(startOffset, endOffset);
                scriptStack.add(snippet);
                StringBuilder pointer = new StringBuilder();
                for (int i = startOffset; i < offset; ++i) {
                    pointer.append(' ');
                }
                pointer.append("^---- HERE");
                scriptStack.add(pointer.toString());
                pos = new ScriptException.Position(originalOffset, startOffset, endOffset);
                break;
            }
            if (this.shouldFilter(element)) continue;
            scriptStack.add(element.toString());
        }
        ScriptException scriptException = new ScriptException("runtime error", unwrapped, scriptStack, this.getName(), "painless", pos);
        for (Map.Entry<String, List<String>> entry : extraMetadata.entrySet()) {
            scriptException.addMetadata(entry.getKey(), entry.getValue());
        }
        return scriptException;
    }

    default public boolean shouldFilter(StackTraceElement element) {
        return element.getClassName().startsWith("org.opensearch.painless.") || element.getClassName().startsWith("java.lang.invoke.") || element.getClassName().startsWith("sun.invoke.");
    }

    default public int getPreviousStatement(int offset) {
        return this.getStatements().previousSetBit(offset);
    }

    default public int getNextStatement(int offset) {
        return this.getStatements().nextSetBit(offset + 1);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

