/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.action.get;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.TotalHits;
import org.jetbrains.annotations.NotNull;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.ShardSearchFailure;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.WildcardQueryBuilder;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.action.get.GetRollupsRequest;
import org.opensearch.indexmanagement.rollup.action.get.GetRollupsResponse;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.settings.IndexManagementSettings;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B9\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J&\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00022\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030&H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0016\u0010\u001e\u001a\n \u001c*\u0004\u0018\u00010\u001f0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/opensearch/indexmanagement/rollup/action/get/TransportGetRollupsAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/rollup/action/get/GetRollupsRequest;", "Lorg/opensearch/indexmanagement/rollup/action/get/GetRollupsResponse;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/transport/client/Client;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "<init>", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/transport/client/Client;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/core/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/opensearch/transport/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "log", "Lorg/apache/logging/log4j/Logger;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "listener", "Lorg/opensearch/core/action/ActionListener;", "opensearch-index-management"})
public final class TransportGetRollupsAction
extends HandledTransportAction<GetRollupsRequest, GetRollupsResponse> {
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Settings settings;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private volatile Boolean filterByEnabled;
    private final Logger log;

    @Inject
    public TransportGetRollupsAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opendistro/rollup/search", transportService, actionFilters, GetRollupsRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> TransportGetRollupsAction._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull GetRollupsRequest request, @NotNull ActionListener<GetRollupsResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.log.debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
        String searchString = ((Object)StringsKt.trim((CharSequence)request.getSearchString())).toString();
        int from = request.getFrom();
        int size = request.getSize();
        String sortField = request.getSortField();
        String sortDirection = request.getSortDirection();
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder().filter((QueryBuilder)new ExistsQueryBuilder("rollup"));
        if (((CharSequence)searchString).length() > 0) {
            boolQueryBuilder.filter((QueryBuilder)new WildcardQueryBuilder("rollup.rollup_id.keyword", "*" + searchString + "*"));
        }
        ThreadContext threadContext = this.client.threadPool().getThreadContext();
        Intrinsics.checkNotNullExpressionValue((Object)threadContext, (String)"getThreadContext(...)");
        User user = SecurityUtils.Companion.buildUser$default(SecurityUtils.Companion, threadContext, null, 2, null);
        Intrinsics.checkNotNull((Object)boolQueryBuilder);
        Boolean bl = this.filterByEnabled;
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"filterByEnabled");
        SecurityUtils.Companion.addUserFilter(user, boolQueryBuilder, bl, "rollup.user");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)boolQueryBuilder).from(from).size(size).seqNoAndPrimaryTerm(Boolean.valueOf(true)).sort(sortField, SortOrder.fromString((String)sortDirection));
        Object object = new String[]{".opendistro-ism-config"};
        SearchRequest searchRequest = new SearchRequest(object).source(searchSourceBuilder);
        object = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)object;
            boolean bl2 = false;
            this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(listener){
                final /* synthetic */ ActionListener<GetRollupsResponse> $listener;
                {
                    this.$listener = $listener;
                }

                /*
                 * WARNING - void declaration
                 */
                public void onResponse(SearchResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    TotalHits totalHits = response2.getHits().getTotalHits();
                    long totalRollups = totalHits != null ? totalHits.value() : 0L;
                    ShardSearchFailure[] shardSearchFailureArray = response2.getShardFailures();
                    Intrinsics.checkNotNullExpressionValue((Object)shardSearchFailureArray, (String)"getShardFailures(...)");
                    if (!(((Object[])shardSearchFailureArray).length == 0)) {
                        ShardSearchFailure[] shardSearchFailureArray2 = response2.getShardFailures();
                        Intrinsics.checkNotNullExpressionValue((Object)shardSearchFailureArray2, (String)"getShardFailures(...)");
                        Object[] $this$reduce$iv = shardSearchFailureArray2;
                        boolean $i$f$reduce = false;
                        if ($this$reduce$iv.length == 0) {
                            throw new UnsupportedOperationException("Empty array can't be reduced.");
                        }
                        Object accumulator$iv = $this$reduce$iv[0];
                        int index$iv = 1;
                        int n = ArraysKt.getLastIndex((Object[])$this$reduce$iv);
                        if (index$iv <= n) {
                            while (true) {
                                void s2;
                                ShardSearchFailure shardSearchFailure = (ShardSearchFailure)$this$reduce$iv[index$iv];
                                ShardSearchFailure s1 = (ShardSearchFailure)accumulator$iv;
                                boolean bl = false;
                                Object object = accumulator$iv = s1.status().getStatus() > s2.status().getStatus() ? s1 : s2;
                                if (index$iv == n) break;
                                ++index$iv;
                            }
                        }
                        ShardSearchFailure failure = (ShardSearchFailure)accumulator$iv;
                        this.$listener.onFailure((Exception)((Object)new OpenSearchStatusException("Get rollups failed on some shards", failure.status(), failure.getCause(), new Object[0])));
                    } else {
                        try {
                            void $this$mapTo$iv$iv;
                            SearchHit[] searchHitArray = response2.getHits().getHits();
                            Intrinsics.checkNotNullExpressionValue((Object)searchHitArray, (String)"getHits(...)");
                            Object[] $this$map$iv = searchHitArray;
                            boolean $i$f$map = false;
                            Object[] accumulator$iv = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                            boolean $i$f$mapTo = false;
                            for (void item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                SearchHit searchHit = (SearchHit)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                BytesReference bytesReference = it.getSourceRef();
                                Intrinsics.checkNotNullExpressionValue((Object)bytesReference, (String)"getSourceRef(...)");
                                XContentParser xContentParser = OpenSearchExtensionsKt.contentParser$default(bytesReference, null, 2, null);
                                String string = it.getId();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                                collection.add((Rollup)OpenSearchExtensionsKt.parseWithType(xContentParser, string, it.getSeqNo(), it.getPrimaryTerm(), (Function4)new Function4<XContentParser, String, Long, Long, Rollup>((Object)Rollup.Companion){

                                    public final Rollup invoke(XContentParser p0, String p1, long p2, long p3) {
                                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                        return ((Rollup.Companion)this.receiver).parse(p0, p1, p2, p3);
                                    }
                                }));
                            }
                            List rollups2 = (List)destination$iv$iv;
                            this.$listener.onResponse((Object)((Object)new GetRollupsResponse(rollups2, (int)totalRollups, RestStatus.OK)));
                        }
                        catch (Exception e) {
                            this.$listener.onFailure((Exception)((Object)new OpenSearchStatusException("Failed to parse rollups", RestStatus.INTERNAL_SERVER_ERROR, ExceptionsHelper.unwrapCause((Throwable)e), new Object[0])));
                        }
                    }
                }

                public void onFailure(Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$listener.onFailure(e);
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
    }

    private static final void _init_$lambda$0(TransportGetRollupsAction this$0, Boolean it) {
        this$0.filterByEnabled = it;
    }
}

