/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.reindex;

import org.opensearch.action.ActionType;
import org.opensearch.action.search.TransportSearchAction;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.TransportIndicesResolvingAction;
import org.opensearch.cluster.metadata.ResolvedIndices;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.reindex.AsyncDeleteByQueryAction;
import org.opensearch.index.reindex.BulkByScrollParallelizationHelper;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.BulkByScrollTask;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.script.ScriptService;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.ParentTaskAssigningClient;

public class TransportDeleteByQueryAction
extends HandledTransportAction<DeleteByQueryRequest, BulkByScrollResponse>
implements TransportIndicesResolvingAction<DeleteByQueryRequest> {
    private final ThreadPool threadPool;
    private final Client client;
    private final ScriptService scriptService;
    private final ClusterService clusterService;
    private final TransportSearchAction transportSearchAction;

    @Inject
    public TransportDeleteByQueryAction(ThreadPool threadPool, ActionFilters actionFilters, Client client, TransportService transportService, ScriptService scriptService, ClusterService clusterService, TransportSearchAction transportSearchAction) {
        super("indices:data/write/delete/byquery", transportService, actionFilters, DeleteByQueryRequest::new);
        this.threadPool = threadPool;
        this.client = client;
        this.scriptService = scriptService;
        this.clusterService = clusterService;
        this.transportSearchAction = transportSearchAction;
    }

    public void doExecute(Task task, DeleteByQueryRequest request, ActionListener<BulkByScrollResponse> listener) {
        BulkByScrollTask bulkByScrollTask = (BulkByScrollTask)task;
        BulkByScrollParallelizationHelper.startSlicedAction(this.clusterService.state().metadata(), request, bulkByScrollTask, (ActionType<BulkByScrollResponse>)DeleteByQueryAction.INSTANCE, listener, this.client, this.clusterService.localNode(), () -> {
            ParentTaskAssigningClient assigningClient = new ParentTaskAssigningClient(this.client, this.clusterService.localNode(), (Task)bulkByScrollTask);
            new AsyncDeleteByQueryAction(bulkByScrollTask, this.logger, assigningClient, this.threadPool, request, this.scriptService, listener).start();
        });
    }

    public ResolvedIndices resolveIndices(DeleteByQueryRequest request) {
        return this.transportSearchAction.resolveIndices(request.getSearchRequest());
    }
}

