/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status;

import java.io.Serializable;
import java.util.Date;
import org.apache.spark.status.api.v1.TaskData;
import org.apache.spark.status.api.v1.TaskMetrics;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class AppStatusUtils$ {
    public static final AppStatusUtils$ MODULE$ = new AppStatusUtils$();
    private static final Set<String> TASK_FINISHED_STATES = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"FAILED", "KILLED", "SUCCESS"}));

    private Set<String> TASK_FINISHED_STATES() {
        return TASK_FINISHED_STATES;
    }

    private boolean isTaskFinished(TaskData task) {
        return this.TASK_FINISHED_STATES().contains((Object)task.status());
    }

    public long schedulerDelay(TaskData task) {
        long l;
        if (this.isTaskFinished(task) && task.taskMetrics().isDefined() && task.duration().isDefined()) {
            TaskMetrics m = (TaskMetrics)task.taskMetrics().get();
            l = this.schedulerDelay(task.launchTime().getTime(), this.fetchStart(task), BoxesRunTime.unboxToLong((Object)task.duration().get()), m.executorDeserializeTime(), m.resultSerializationTime(), m.executorRunTime());
        } else {
            l = 0L;
        }
        return l;
    }

    public long gettingResultTime(TaskData task) {
        return this.gettingResultTime(task.launchTime().getTime(), this.fetchStart(task), BoxesRunTime.unboxToLong((Object)task.duration().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)));
    }

    public long schedulerDelay(long launchTime, long fetchStart, long duration, long deserializeTime, long serializeTime, long runTime) {
        return package$.MODULE$.max(0L, duration - runTime - deserializeTime - serializeTime - this.gettingResultTime(launchTime, fetchStart, duration));
    }

    public long gettingResultTime(long launchTime, long fetchStart, long duration) {
        return fetchStart > 0L ? (duration > 0L ? launchTime + duration - fetchStart : System.currentTimeMillis() - fetchStart) : 0L;
    }

    private long fetchStart(TaskData task) {
        return task.resultFetchStart().isDefined() ? ((Date)task.resultFetchStart().get()).getTime() : -1L;
    }

    public IndexedSeq<Object> getQuantilesValue(IndexedSeq<Object> values, double[] quantiles) {
        IndexedSeq indexedSeq;
        int count = values.size();
        if (count > 0) {
            long[] indices = (long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(quantiles), (Function1)(JFunction1.mcJD.sp & Serializable)q -> package$.MODULE$.min((long)(q * (double)count), (long)(count - 1)), (ClassTag)ClassTag$.MODULE$.Long());
            indexedSeq = ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.doubleArrayOps((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.longArrayOps(indices), (Function1)(JFunction1.mcDJ.sp & Serializable)i -> BoxesRunTime.unboxToDouble((Object)values.apply((int)i)), (ClassTag)ClassTag$.MODULE$.Double())));
        } else {
            indexedSeq = (IndexedSeq)scala.package$.MODULE$.IndexedSeq().fill(quantiles.length, (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0);
        }
        return indexedSeq;
    }

    private AppStatusUtils$() {
    }
}

