/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mapred;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.executor.CommitDeniedException;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.OutputCommitCoordinator;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Tuple2;
import scala.runtime.java8.JFunction0;

public final class SparkHadoopMapRedUtil$
implements Logging {
    public static final SparkHadoopMapRedUtil$ MODULE$ = new SparkHadoopMapRedUtil$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void commitTask(OutputCommitter committer, TaskAttemptContext mrTaskContext, int jobId, int splitId) {
        TaskContext ctx;
        TaskAttemptID mrTaskAttemptID = mrTaskContext.getTaskAttemptID();
        if (!committer.needsTaskCommit(mrTaskContext)) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(64).append("No need to commit output of task because needsTaskCommit=false: ").append(mrTaskAttemptID).toString());
            return;
        }
        SparkConf sparkConf = SparkEnv$.MODULE$.get().conf();
        boolean shouldCoordinateWithDriver = sparkConf.getBoolean("spark.hadoop.outputCommitCoordination.enabled", true);
        if (!shouldCoordinateWithDriver) {
            this.performCommit$1(committer, mrTaskContext, mrTaskAttemptID);
            return;
        }
        OutputCommitCoordinator outputCommitCoordinator = SparkEnv$.MODULE$.get().outputCommitCoordinator();
        boolean canCommit = outputCommitCoordinator.canCommit((ctx = TaskContext$.MODULE$.get()).stageId(), ctx.stageAttemptNumber(), splitId, ctx.attemptNumber());
        if (canCommit) {
            this.performCommit$1(committer, mrTaskContext, mrTaskAttemptID);
            return;
        }
        String message = new StringBuilder(59).append(mrTaskAttemptID).append(": Not committed because the driver did not authorize commit").toString();
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> message);
        committer.abortTask(mrTaskContext);
        throw new CommitDeniedException(message, ctx.stageId(), splitId, ctx.attemptNumber());
    }

    private final void performCommit$1(OutputCommitter committer$1, TaskAttemptContext mrTaskContext$1, TaskAttemptID mrTaskAttemptID$1) {
        try {
            long timeCost;
            Tuple2 tuple2 = Utils$.MODULE$.timeTakenMs((JFunction0.mcV.sp & Serializable)() -> committer$1.commitTask(mrTaskContext$1));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            long l = timeCost = tuple2._2$mcJ$sp();
            long timeCost2 = l;
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append(mrTaskAttemptID$1).append(": Committed. Elapsed time: ").append(timeCost2).append(" ms.").toString());
        }
        catch (IOException cause) {
            this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Error committing the output of task: ").append(mrTaskAttemptID$1).toString(), cause);
            committer$1.abortTask(mrTaskContext$1);
            throw cause;
        }
    }

    private SparkHadoopMapRedUtil$() {
    }
}

