/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.ext.saml2delrestrict.Delegate;
import org.opensaml.saml.ext.saml2delrestrict.DelegationRestrictionType;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Condition;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.ManageNameIDRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDMappingRequest;
import org.opensaml.saml.saml2.core.NameIDMappingResponse;
import org.opensaml.saml.saml2.core.NewEncryptedID;
import org.opensaml.saml.saml2.core.NewID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectQuery;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.profile.impl.AbstractDecryptAction;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.slf4j.Logger;

public class DecryptNameIDs
extends AbstractDecryptAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DecryptNameIDs.class);

    @Override
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        block12: {
            SAMLObject message = this.getSAMLObject();
            try {
                if (message instanceof AuthnRequest) {
                    AuthnRequest r = (AuthnRequest)message;
                    this.processSubject(profileRequestContext, r.getSubject());
                    break block12;
                }
                if (message instanceof SubjectQuery) {
                    SubjectQuery r = (SubjectQuery)message;
                    this.processSubject(profileRequestContext, r.getSubject());
                    break block12;
                }
                if (message instanceof Response) {
                    Response r = (Response)message;
                    for (Assertion a : r.getAssertions()) {
                        assert (a != null);
                        this.processAssertion(profileRequestContext, a);
                    }
                    break block12;
                }
                if (message instanceof LogoutRequest) {
                    LogoutRequest r = (LogoutRequest)message;
                    this.processLogoutRequest(profileRequestContext, r);
                    break block12;
                }
                if (message instanceof ManageNameIDRequest) {
                    ManageNameIDRequest r = (ManageNameIDRequest)message;
                    this.processManageNameIDRequest(profileRequestContext, r);
                    break block12;
                }
                if (message instanceof NameIDMappingRequest) {
                    NameIDMappingRequest r = (NameIDMappingRequest)message;
                    this.processNameIDMappingRequest(profileRequestContext, r);
                    break block12;
                }
                if (message instanceof NameIDMappingResponse) {
                    NameIDMappingResponse r = (NameIDMappingResponse)message;
                    this.processNameIDMappingResponse(profileRequestContext, r);
                    break block12;
                }
                if (message instanceof Assertion) {
                    Assertion a = (Assertion)message;
                    this.processAssertion(profileRequestContext, a);
                    break block12;
                }
                this.log.debug("{} Message was of unrecognized type {}, nothing to do", (Object)this.getLogPrefix(), (Object)message.getClass().getName());
                return;
            }
            catch (DecryptionException e) {
                this.log.warn("{} Failure performing decryption", (Object)this.getLogPrefix(), (Object)e);
                if (!this.isErrorFatal()) break block12;
                ActionSupport.buildEvent(profileRequestContext, "DecryptNameIDFailed");
            }
        }
    }

    @Nullable
    private NameID processEncryptedID(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull EncryptedID encID) throws DecryptionException {
        if (!this.getDecryptionPredicate().test(new Pair<ProfileRequestContext, EncryptedID>(profileRequestContext, encID))) {
            return null;
        }
        Decrypter decrypter = this.getDecrypter();
        if (decrypter == null) {
            throw new DecryptionException("No decryption parameters, unable to decrypt EncryptedID");
        }
        SAMLObject object = decrypter.decrypt(encID);
        if (object instanceof NameID) {
            return (NameID)object;
        }
        throw new DecryptionException("Decrypted EncryptedID was not a NameID, was a " + object.getElementQName().toString());
    }

    @Nullable
    private NewID processNewEncryptedID(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull NewEncryptedID encID) throws DecryptionException {
        if (!this.getDecryptionPredicate().test(new Pair<ProfileRequestContext, NewEncryptedID>(profileRequestContext, encID))) {
            return null;
        }
        Decrypter decrypter = this.getDecrypter();
        if (decrypter == null) {
            throw new DecryptionException("No decryption parameters, unable to decrypt NewEncryptedID");
        }
        return decrypter.decrypt(encID);
    }

    private void processSubject(@Nonnull ProfileRequestContext profileRequestContext, @Nullable Subject subject) throws DecryptionException {
        if (subject != null) {
            EncryptedID encID = subject.getEncryptedID();
            if (encID != null) {
                this.log.debug("{} Decrypting EncryptedID in Subject", (Object)this.getLogPrefix());
                try {
                    NameID decrypted = this.processEncryptedID(profileRequestContext, encID);
                    if (decrypted != null) {
                        subject.setNameID(decrypted);
                        subject.setEncryptedID(null);
                    }
                }
                catch (DecryptionException e) {
                    if (this.isErrorFatal()) {
                        throw e;
                    }
                    this.log.warn("{} Trapped failure decrypting EncryptedID in Subject", (Object)this.getLogPrefix(), (Object)e);
                }
            }
            for (SubjectConfirmation sc : subject.getSubjectConfirmations()) {
                encID = sc.getEncryptedID();
                if (encID == null) continue;
                this.log.debug("{} Decrypting EncryptedID in SubjectConfirmation", (Object)this.getLogPrefix());
                try {
                    NameID decrypted = this.processEncryptedID(profileRequestContext, encID);
                    if (decrypted == null) continue;
                    sc.setNameID(decrypted);
                    sc.setEncryptedID(null);
                }
                catch (DecryptionException e) {
                    if (this.isErrorFatal()) {
                        throw e;
                    }
                    this.log.warn("{} Trapped failure decrypting EncryptedID in SubjectConfirmation", (Object)this.getLogPrefix(), (Object)e);
                }
            }
        }
    }

    private void processLogoutRequest(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull LogoutRequest request) throws DecryptionException {
        EncryptedID encID = request.getEncryptedID();
        if (encID != null) {
            this.log.debug("{} Decrypting EncryptedID in LogoutRequest", (Object)this.getLogPrefix());
            NameID decrypted = this.processEncryptedID(profileRequestContext, encID);
            if (decrypted != null) {
                request.setNameID(decrypted);
                request.setEncryptedID(null);
            }
        }
    }

    private void processManageNameIDRequest(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ManageNameIDRequest request) throws DecryptionException {
        NewEncryptedID newID;
        EncryptedID encID = request.getEncryptedID();
        if (encID != null) {
            this.log.debug("{} Decrypting EncryptedID in ManageNameIDRequest", (Object)this.getLogPrefix());
            NameID decrypted = this.processEncryptedID(profileRequestContext, encID);
            if (decrypted != null) {
                request.setNameID(decrypted);
                request.setEncryptedID(null);
            }
        }
        if ((newID = request.getNewEncryptedID()) != null) {
            this.log.debug("{} Decrypting NewEncryptedID in ManageNameIDRequest", (Object)this.getLogPrefix());
            NewID decrypted = this.processNewEncryptedID(profileRequestContext, newID);
            if (decrypted != null) {
                request.setNewID(decrypted);
                request.setNewEncryptedID(null);
            }
        }
    }

    private void processNameIDMappingRequest(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull NameIDMappingRequest request) throws DecryptionException {
        EncryptedID encID = request.getEncryptedID();
        if (encID != null) {
            this.log.debug("{} Decrypting EncryptedID in NameIDMappingRequest", (Object)this.getLogPrefix());
            NameID decrypted = this.processEncryptedID(profileRequestContext, encID);
            if (decrypted != null) {
                request.setNameID(decrypted);
                request.setEncryptedID(null);
            }
        }
    }

    private void processNameIDMappingResponse(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull NameIDMappingResponse response) throws DecryptionException {
        EncryptedID encID = response.getEncryptedID();
        if (encID != null) {
            this.log.debug("{} Decrypting EncryptedID in NameIDMappingRequest", (Object)this.getLogPrefix());
            NameID decrypted = this.processEncryptedID(profileRequestContext, encID);
            if (decrypted != null) {
                response.setNameID(decrypted);
                response.setEncryptedID(null);
            }
        }
    }

    private void processAssertion(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull Assertion assertion) throws DecryptionException {
        try {
            this.processSubject(profileRequestContext, assertion.getSubject());
        }
        catch (DecryptionException e) {
            if (this.isErrorFatal()) {
                throw e;
            }
            this.log.warn("{} Trapped failure decrypting EncryptedIDs in Subject", (Object)this.getLogPrefix(), (Object)e);
        }
        Conditions conditions = assertion.getConditions();
        if (conditions != null) {
            for (Condition c : conditions.getConditions()) {
                if (!(c instanceof DelegationRestrictionType)) continue;
                for (Delegate d : ((DelegationRestrictionType)c).getDelegates()) {
                    EncryptedID encID = d.getEncryptedID();
                    if (encID == null) continue;
                    this.log.debug("{} Decrypting EncryptedID in Delegate", (Object)this.getLogPrefix());
                    try {
                        NameID decrypted = this.processEncryptedID(profileRequestContext, encID);
                        if (decrypted == null) continue;
                        d.setNameID(decrypted);
                        d.setEncryptedID(null);
                    }
                    catch (DecryptionException e) {
                        if (this.isErrorFatal()) {
                            throw e;
                        }
                        this.log.warn("{} Trapped failure decrypting EncryptedID in Delegate", (Object)this.getLogPrefix(), (Object)e);
                    }
                }
            }
        }
    }
}

