/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.binding.artifact;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.saml.saml1.binding.artifact.SAML1Artifact;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactBuilder;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactType0001;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactType0001Builder;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactType0002;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactType0002Builder;

public class SAML1ArtifactBuilderFactory {
    @Nonnull
    private final Map<String, SAML1ArtifactBuilder<?>> artifactBuilders;

    public SAML1ArtifactBuilderFactory() {
        HashMap<String, SAML1ArtifactBuilder<SAML1ArtifactType0001>> sourceMap = new HashMap<String, SAML1ArtifactBuilder<SAML1ArtifactType0001>>(2);
        sourceMap.put(new String(SAML1ArtifactType0001.TYPE_CODE), new SAML1ArtifactType0001Builder());
        sourceMap.put(new String(SAML1ArtifactType0002.TYPE_CODE), new SAML1ArtifactType0002Builder());
        this.artifactBuilders = CollectionSupport.copyToMap(sourceMap);
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Map<String, SAML1ArtifactBuilder<?>> getArtifactBuilders() {
        return this.artifactBuilders;
    }

    @Nullable
    public SAML1ArtifactBuilder<?> getArtifactBuilder(byte[] type) {
        return this.artifactBuilders.get(new String(type));
    }

    @Nullable
    public SAML1Artifact buildArtifact(@Nonnull String base64Artifact) throws DecodingException {
        return this.buildArtifact(Base64Support.decode(base64Artifact));
    }

    @Nullable
    public SAML1Artifact buildArtifact(@Nullable byte[] artifact) {
        if (artifact == null) {
            return null;
        }
        byte[] type = new byte[]{artifact[0], artifact[1]};
        SAML1ArtifactBuilder<?> artifactBuilder = this.getArtifactBuilder(type);
        if (artifactBuilder == null) {
            throw new IllegalArgumentException("Saw unsupported artifact type: " + new String(type));
        }
        return artifactBuilder.buildArtifact(artifact);
    }
}

