/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.module.scala.ClassTagExtensions;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.fasterxml.jackson.module.scala.JavaTypeable;
import com.fasterxml.jackson.module.scala.JavaTypeable$;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.zone.ZoneOffsetTransition;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.catalyst.util.SparkDateTimeUtils$;
import org.apache.spark.util.SparkClassUtils$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.AnyRefMap;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class RebaseDateTime$ {
    public static final RebaseDateTime$ MODULE$ = new RebaseDateTime$();
    private static ObjectMapper mapper;
    private static final int[] julianGregDiffs;
    private static final int[] julianGregDiffSwitchDay;
    private static final int lastSwitchJulianDay;
    private static final int julianCommonEraStartDay;
    private static final int[] gregJulianDiffs;
    private static final int[] gregJulianDiffSwitchDay;
    private static final int lastSwitchGregorianDay;
    private static final int gregorianCommonEraStartDay;
    private static final LocalDate gregorianStartDate;
    private static final LocalDate julianEndDate;
    private static final AnyRefMap<String, RebaseDateTime.RebaseInfo> gregJulianRebaseMap;
    private static final long lastSwitchGregorianTs;
    private static final LocalDateTime gregorianStartTs;
    private static final LocalDateTime julianEndTs;
    private static final AnyRefMap<String, RebaseDateTime.RebaseInfo> julianGregRebaseMap;
    private static final long lastSwitchJulianTs;
    private static volatile boolean bitmap$0;

    static {
        julianGregDiffs = new int[]{2, 1, 0, -1, -2, -3, -4, -5, -6, -7, -8, -9, -10, 0};
        julianGregDiffSwitchDay = new int[]{-719164, -682945, -646420, -609895, -536845, -500320, -463795, -390745, -354220, -317695, -244645, -208120, -171595, -141427};
        lastSwitchJulianDay = BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.intArrayOps(MODULE$.julianGregDiffSwitchDay())));
        julianCommonEraStartDay = MODULE$.julianGregDiffSwitchDay()[0];
        gregJulianDiffs = new int[]{-2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
        gregJulianDiffSwitchDay = new int[]{-719162, -682944, -646420, -609896, -536847, -500323, -463799, -390750, -354226, -317702, -244653, -208129, -171605, -141436, -141435, -141434, -141433, -141432, -141431, -141430, -141429, -141428, -141427};
        lastSwitchGregorianDay = BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.intArrayOps(MODULE$.gregJulianDiffSwitchDay())));
        gregorianCommonEraStartDay = MODULE$.gregJulianDiffSwitchDay()[0];
        gregorianStartDate = LocalDate.of(1582, 10, 15);
        julianEndDate = LocalDate.of(1582, 10, 4);
        gregJulianRebaseMap = MODULE$.loadRebaseRecords("gregorian-julian-rebase-micros.json");
        lastSwitchGregorianTs = MODULE$.getLastSwitchTs(MODULE$.gregJulianRebaseMap());
        gregorianStartTs = LocalDateTime.of(MODULE$.gregorianStartDate(), LocalTime.MIDNIGHT);
        julianEndTs = LocalDateTime.of(MODULE$.julianEndDate(), LocalTime.of(23, 59, 59, 999999999));
        julianGregRebaseMap = MODULE$.loadRebaseRecords("julian-gregorian-rebase-micros.json");
        lastSwitchJulianTs = MODULE$.getLastSwitchTs(MODULE$.julianGregRebaseMap());
    }

    private int rebaseDays(int[] switches, int[] diffs, int days) {
        int i = switches.length;
        while (--i > 0 && days < switches[i]) {
        }
        return days + diffs[i];
    }

    private int[] julianGregDiffs() {
        return julianGregDiffs;
    }

    private int[] julianGregDiffSwitchDay() {
        return julianGregDiffSwitchDay;
    }

    public final int lastSwitchJulianDay() {
        return lastSwitchJulianDay;
    }

    private final int julianCommonEraStartDay() {
        return julianCommonEraStartDay;
    }

    public int localRebaseJulianToGregorianDays(int days) {
        Calendar utcCal = new Calendar.Builder().setCalendarType("gregory").setTimeZone(SparkDateTimeUtils$.MODULE$.TimeZoneUTC()).setInstant(Math.multiplyExact((long)days, 86400000L)).build();
        LocalDate localDate = LocalDate.of(utcCal.get(1), utcCal.get(2) + 1, 1).with(ChronoField.ERA, utcCal.get(0)).plusDays(utcCal.get(5) - 1);
        return Math.toIntExact(localDate.toEpochDay());
    }

    public int rebaseJulianToGregorianDays(int days) {
        return days < this.julianCommonEraStartDay() ? this.localRebaseJulianToGregorianDays(days) : this.rebaseDays(this.julianGregDiffSwitchDay(), this.julianGregDiffs(), days);
    }

    private int[] gregJulianDiffs() {
        return gregJulianDiffs;
    }

    private int[] gregJulianDiffSwitchDay() {
        return gregJulianDiffSwitchDay;
    }

    public final int lastSwitchGregorianDay() {
        return lastSwitchGregorianDay;
    }

    private final int gregorianCommonEraStartDay() {
        return gregorianCommonEraStartDay;
    }

    private final LocalDate gregorianStartDate() {
        return gregorianStartDate;
    }

    private final LocalDate julianEndDate() {
        return julianEndDate;
    }

    public int localRebaseGregorianToJulianDays(int days) {
        Calendar utcCal;
        LocalDate localDate = LocalDate.ofEpochDay(days);
        if (localDate.isAfter(this.julianEndDate()) && localDate.isBefore(this.gregorianStartDate())) {
            localDate = this.gregorianStartDate();
        }
        Predef$.MODULE$.assert((utcCal = new Calendar.Builder().setCalendarType("gregory").setTimeZone(SparkDateTimeUtils$.MODULE$.TimeZoneUTC()).setDate(localDate.getYear(), localDate.getMonthValue() - 1, localDate.getDayOfMonth()).build()).getTimeInMillis() % 86400000L == 0L);
        return Math.toIntExact(utcCal.getTimeInMillis() / 86400000L);
    }

    public int rebaseGregorianToJulianDays(int days) {
        return days < this.gregorianCommonEraStartDay() ? this.localRebaseGregorianToJulianDays(days) : this.rebaseDays(this.gregJulianDiffSwitchDay(), this.gregJulianDiffs(), days);
    }

    private long rebaseMicros(RebaseDateTime.RebaseInfo rebaseInfo, long micros) {
        long[] switches = rebaseInfo.switches();
        int i = switches.length;
        while (--i > 0 && micros < switches[i]) {
        }
        return micros + rebaseInfo.diffs()[i];
    }

    /*
     * WARNING - void declaration
     */
    private ObjectMapper mapper$lzycompute() {
        RebaseDateTime$ rebaseDateTime$ = this;
        synchronized (rebaseDateTime$) {
            if (!bitmap$0) {
                void var2_2;
                ClassTagExtensions mapper = new ClassTagExtensions(){

                    public final <Target, MixinSource> ObjectMapper addMixin(ClassTag<Target> evidence$1, ClassTag<MixinSource> evidence$2) {
                        return ClassTagExtensions.addMixin$((ClassTagExtensions)this, evidence$1, evidence$2);
                    }

                    public final <T> Class<?> findMixInClassFor(ClassTag<T> evidence$3) {
                        return ClassTagExtensions.findMixInClassFor$((ClassTagExtensions)this, evidence$3);
                    }

                    public <T> JavaType constructType(JavaTypeable<T> evidence$4) {
                        return ClassTagExtensions.constructType$((ClassTagExtensions)this, evidence$4);
                    }

                    public <T> T readValue(JsonParser jp, JavaTypeable<T> evidence$5) {
                        return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (JsonParser)jp, evidence$5);
                    }

                    public <T> MappingIterator<T> readValues(JsonParser jp, JavaTypeable<T> evidence$6) {
                        return ClassTagExtensions.readValues$((ClassTagExtensions)this, (JsonParser)jp, evidence$6);
                    }

                    public <T> T treeToValue(TreeNode n, JavaTypeable<T> evidence$7) {
                        return (T)ClassTagExtensions.treeToValue$((ClassTagExtensions)this, (TreeNode)n, evidence$7);
                    }

                    public <T> T readValue(File src, JavaTypeable<T> evidence$8) {
                        return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (File)src, evidence$8);
                    }

                    public <T> T readValue(URL src, JavaTypeable<T> evidence$9) {
                        return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (URL)src, evidence$9);
                    }

                    public <T> T readValue(String content, JavaTypeable<T> evidence$10) {
                        return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (String)content, evidence$10);
                    }

                    public <T> T readValue(Reader src, JavaTypeable<T> evidence$11) {
                        return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (Reader)src, evidence$11);
                    }

                    public <T> T readValue(InputStream src, JavaTypeable<T> evidence$12) {
                        return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (InputStream)src, evidence$12);
                    }

                    public <T> T readValue(byte[] src, JavaTypeable<T> evidence$13) {
                        return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (byte[])src, evidence$13);
                    }

                    public <T> T readValue(byte[] src, int offset, int len, JavaTypeable<T> evidence$14) {
                        return (T)ClassTagExtensions.readValue$((ClassTagExtensions)this, (byte[])src, (int)offset, (int)len, evidence$14);
                    }

                    public <T> T updateValue(T valueToUpdate, File src, JavaTypeable<T> evidence$15) {
                        return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (File)src, evidence$15);
                    }

                    public <T> T updateValue(T valueToUpdate, URL src, JavaTypeable<T> evidence$16) {
                        return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (URL)src, evidence$16);
                    }

                    public <T> T updateValue(T valueToUpdate, String content, JavaTypeable<T> evidence$17) {
                        return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (String)content, evidence$17);
                    }

                    public <T> T updateValue(T valueToUpdate, Reader src, JavaTypeable<T> evidence$18) {
                        return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (Reader)src, evidence$18);
                    }

                    public <T> T updateValue(T valueToUpdate, InputStream src, JavaTypeable<T> evidence$19) {
                        return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (InputStream)src, evidence$19);
                    }

                    public <T> T updateValue(T valueToUpdate, byte[] src, JavaTypeable<T> evidence$20) {
                        return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (byte[])src, evidence$20);
                    }

                    public <T> T updateValue(T valueToUpdate, byte[] src, int offset, int len, JavaTypeable<T> evidence$21) {
                        return (T)ClassTagExtensions.updateValue$((ClassTagExtensions)this, valueToUpdate, (byte[])src, (int)offset, (int)len, evidence$21);
                    }

                    public <T> ObjectWriter writerWithView(ClassTag<T> evidence$23) {
                        return ClassTagExtensions.writerWithView$((ClassTagExtensions)this, evidence$23);
                    }

                    public <T> ObjectWriter writerFor(JavaTypeable<T> evidence$24) {
                        return ClassTagExtensions.writerFor$((ClassTagExtensions)this, evidence$24);
                    }

                    public <T> ObjectReader readerFor(JavaTypeable<T> evidence$25) {
                        return ClassTagExtensions.readerFor$((ClassTagExtensions)this, evidence$25);
                    }

                    public <T> ObjectReader readerWithView(ClassTag<T> evidence$26) {
                        return ClassTagExtensions.readerWithView$((ClassTagExtensions)this, evidence$26);
                    }

                    public <T> T convertValue(Object fromValue, JavaTypeable<T> evidence$27) {
                        return (T)ClassTagExtensions.convertValue$((ClassTagExtensions)this, (Object)fromValue, evidence$27);
                    }
                    {
                        ClassTagExtensions.$init$((ClassTagExtensions)this);
                    }
                };
                mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
                RebaseDateTime$.mapper = var2_2;
                bitmap$0 = true;
            }
        }
        return mapper;
    }

    private ObjectMapper mapper() {
        return !bitmap$0 ? this.mapper$lzycompute() : mapper;
    }

    public AnyRefMap<String, RebaseDateTime.RebaseInfo> loadRebaseRecords(String fileName) {
        URL file = SparkClassUtils$.MODULE$.getSparkClassLoader().getResource(fileName);
        Seq jsonRebaseRecords = (Seq)((ClassTagExtensions)this.mapper()).readValue(file, JavaTypeable$.MODULE$.collectionJavaTypeable(JavaTypeable$.MODULE$.gen0JavaTypeable(ClassTag$.MODULE$.apply(RebaseDateTime.JsonRebaseRecord.class)), ClassTag$.MODULE$.apply(Seq.class)));
        AnyRefMap anyRefMap = new AnyRefMap(3 * jsonRebaseRecords.size() / 2);
        jsonRebaseRecords.foreach((Function1 & Serializable)jsonRecord -> {
            RebaseDateTime$.$anonfun$loadRebaseRecords$1(anyRefMap, jsonRecord);
            return BoxedUnit.UNIT;
        });
        return anyRefMap;
    }

    private AnyRefMap<String, RebaseDateTime.RebaseInfo> gregJulianRebaseMap() {
        return gregJulianRebaseMap;
    }

    /*
     * WARNING - void declaration
     */
    private long getLastSwitchTs(AnyRefMap<String, RebaseDateTime.RebaseInfo> rebaseMap) {
        void var2_2;
        long latestTs = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)rebaseMap.values().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)RebaseDateTime$.$anonfun$getLastSwitchTs$1(x$1)))).max((Ordering)Ordering.Long$.MODULE$));
        Predef$.MODULE$.require(rebaseMap.values().forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)RebaseDateTime$.$anonfun$getLastSwitchTs$2(x$2))), (Function0 & Serializable)() -> new StringBuilder(53).append(new StringBuilder(57).append("Differences between Julian and Gregorian calendar after ").append(SparkDateTimeUtils$.MODULE$.microsToInstant(latestTs)).append(" ").toString()).append("are expected to be zero for all available time zones.").toString());
        return (long)var2_2;
    }

    public final long lastSwitchGregorianTs() {
        return lastSwitchGregorianTs;
    }

    private final LocalDateTime gregorianStartTs() {
        return gregorianStartTs;
    }

    private final LocalDateTime julianEndTs() {
        return julianEndTs;
    }

    public long rebaseGregorianToJulianMicros(TimeZone tz, long micros) {
        Calendar cal;
        LocalDateTime ldt;
        block1: {
            ZoneId zoneId;
            Instant instant = SparkDateTimeUtils$.MODULE$.microsToInstant(micros);
            ZonedDateTime zonedDateTime = instant.atZone(zoneId = tz.toZoneId());
            ldt = zonedDateTime.toLocalDateTime();
            if (ldt.isAfter(this.julianEndTs()) && ldt.isBefore(this.gregorianStartTs())) {
                ldt = LocalDateTime.of(this.gregorianStartDate(), ldt.toLocalTime());
            }
            cal = new Calendar.Builder().setCalendarType("gregory").setDate(ldt.getYear(), ldt.getMonthValue() - 1, ldt.getDayOfMonth()).setTimeOfDay(ldt.getHour(), ldt.getMinute(), ldt.getSecond()).setTimeZone(tz).build();
            ZoneOffsetTransition trans = zoneId.getRules().getTransition(ldt);
            if (trans == null || !trans.isOverlap()) break block1;
            Calendar cloned = (Calendar)cal.clone();
            ZoneOffset zoneOffset = trans.getOffsetBefore();
            ZoneOffset zoneOffset2 = zonedDateTime.getOffset();
            int shift = !(zoneOffset != null ? !((Object)zoneOffset).equals(zoneOffset2) : zoneOffset2 != null) ? -1 : 1;
            cloned.add(5, shift);
            cal.set(15, cloned.get(15));
            cal.set(16, cloned.get(16));
        }
        return SparkDateTimeUtils$.MODULE$.millisToMicros(cal.getTimeInMillis()) + (long)ldt.get(ChronoField.MICRO_OF_SECOND);
    }

    public long rebaseGregorianToJulianMicros(String timeZoneId, long micros) {
        RebaseDateTime.RebaseInfo rebaseRecord;
        return micros >= this.lastSwitchGregorianTs() ? micros : ((rebaseRecord = (RebaseDateTime.RebaseInfo)this.gregJulianRebaseMap().getOrNull((Object)timeZoneId)) == null || micros < rebaseRecord.switches()[0] ? this.rebaseGregorianToJulianMicros(TimeZone.getTimeZone(timeZoneId), micros) : this.rebaseMicros(rebaseRecord, micros));
    }

    public long rebaseGregorianToJulianMicros(long micros) {
        return this.rebaseGregorianToJulianMicros(TimeZone.getDefault().getID(), micros);
    }

    public long rebaseJulianToGregorianMicros(TimeZone tz, long micros) {
        ZonedDateTime zonedDateTime;
        Calendar cal = new Calendar.Builder().setCalendarType("gregory").setInstant(SparkDateTimeUtils$.MODULE$.microsToMillis(micros)).setTimeZone(tz).build();
        LocalDateTime localDateTime = LocalDateTime.of(cal.get(1), cal.get(2) + 1, 1, cal.get(11), cal.get(12), cal.get(13), (int)(Math.floorMod(micros, 1000000L) * 1000L)).with(ChronoField.ERA, cal.get(0)).plusDays(cal.get(5) - 1);
        ZoneId zoneId = tz.toZoneId();
        ZonedDateTime zonedDateTime2 = localDateTime.atZone(zoneId);
        ZoneOffsetTransition trans = zoneId.getRules().getTransition(localDateTime);
        if (trans != null && trans.isOverlap()) {
            int dstOffset = cal.get(16);
            int zoneOffset = cal.get(15);
            cal.add(5, 1);
            zonedDateTime = zoneOffset == cal.get(15) && dstOffset == cal.get(16) ? zonedDateTime2.withLaterOffsetAtOverlap() : zonedDateTime2.withEarlierOffsetAtOverlap();
        } else {
            zonedDateTime = zonedDateTime2;
        }
        ZonedDateTime adjustedZdt = zonedDateTime;
        return SparkDateTimeUtils$.MODULE$.instantToMicros(adjustedZdt.toInstant());
    }

    private AnyRefMap<String, RebaseDateTime.RebaseInfo> julianGregRebaseMap() {
        return julianGregRebaseMap;
    }

    public final long lastSwitchJulianTs() {
        return lastSwitchJulianTs;
    }

    public long rebaseJulianToGregorianMicros(String timeZoneId, long micros) {
        RebaseDateTime.RebaseInfo rebaseRecord;
        return micros >= this.lastSwitchJulianTs() ? micros : ((rebaseRecord = (RebaseDateTime.RebaseInfo)this.julianGregRebaseMap().getOrNull((Object)timeZoneId)) == null || micros < rebaseRecord.switches()[0] ? this.rebaseJulianToGregorianMicros(TimeZone.getTimeZone(timeZoneId), micros) : this.rebaseMicros(rebaseRecord, micros));
    }

    public long rebaseJulianToGregorianMicros(long micros) {
        return this.rebaseJulianToGregorianMicros(TimeZone.getDefault().getID(), micros);
    }

    public static final /* synthetic */ void $anonfun$loadRebaseRecords$1(AnyRefMap anyRefMap$1, RebaseDateTime.JsonRebaseRecord jsonRecord) {
        RebaseDateTime.RebaseInfo rebaseInfo = new RebaseDateTime.RebaseInfo(jsonRecord.switches(), jsonRecord.diffs());
        for (int i = 0; i < rebaseInfo.switches().length; ++i) {
            rebaseInfo.switches()[i] = rebaseInfo.switches()[i] * 1000000L;
            rebaseInfo.diffs()[i] = rebaseInfo.diffs()[i] * 1000000L;
        }
        anyRefMap$1.update((Object)jsonRecord.tz(), (Object)rebaseInfo);
    }

    public static final /* synthetic */ long $anonfun$getLastSwitchTs$1(RebaseDateTime.RebaseInfo x$1) {
        return BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.longArrayOps(x$1.switches())));
    }

    public static final /* synthetic */ boolean $anonfun$getLastSwitchTs$2(RebaseDateTime.RebaseInfo x$2) {
        return BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.longArrayOps(x$2.diffs()))) == 0L;
    }

    private RebaseDateTime$() {
    }
}

