/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.rules.model;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.plugin.insights.rules.model.AggregationType;

public class Measurement
implements ToXContentObject,
Writeable {
    private static int DEFAULT_COUNT = 1;
    public static final String NUMBER = "number";
    public static final String COUNT = "count";
    public static final String AGGREGATION_TYPE = "aggregationType";
    private AggregationType aggregationType;
    private Number number;
    private int count;

    public Measurement(Number number, int count, AggregationType aggregationType) {
        this.number = number;
        this.count = count;
        this.aggregationType = aggregationType;
    }

    public Measurement(Number number, AggregationType aggregationType) {
        this(number, DEFAULT_COUNT, aggregationType);
    }

    public Measurement(Number number) {
        this(number, DEFAULT_COUNT, AggregationType.DEFAULT_AGGREGATION_TYPE);
    }

    private Measurement() {
    }

    public static Measurement fromXContent(XContentParser parser) throws IOException {
        Measurement builder = new Measurement();
        builder.parseXContent(parser);
        return builder;
    }

    public void addMeasurement(Number toAdd) {
        switch (this.aggregationType) {
            case NONE: {
                this.setMeasurement(toAdd);
                break;
            }
            case SUM: {
                this.setMeasurement(this.addMeasurementInferType(this.number, toAdd));
                break;
            }
            case AVERAGE: {
                ++this.count;
                this.setMeasurement(this.addMeasurementInferType(this.number, toAdd));
                break;
            }
            default: {
                throw new IllegalArgumentException("The following aggregation type is not supported : " + String.valueOf((Object)this.aggregationType));
            }
        }
    }

    private Number addMeasurementInferType(Number a, Number b) {
        if (a instanceof Long && b instanceof Long) {
            return a.longValue() + b.longValue();
        }
        if (a instanceof Integer && b instanceof Integer) {
            return a.intValue() + b.intValue();
        }
        if (a instanceof Double && b instanceof Double) {
            return a.doubleValue() + b.doubleValue();
        }
        if (a instanceof Float && b instanceof Float) {
            return Float.valueOf(a.floatValue() + b.floatValue());
        }
        throw new IllegalArgumentException("Unsupported number type: " + String.valueOf(a.getClass()) + " or " + String.valueOf(b.getClass()));
    }

    public Number getMeasurement() {
        switch (this.aggregationType) {
            case NONE: 
            case SUM: {
                return this.number;
            }
            case AVERAGE: {
                return this.getAverageMeasurement(this.number, this.count);
            }
        }
        throw new IllegalArgumentException("Aggregation Type should be set for measurement.");
    }

    private Number getAverageMeasurement(Number total, int count) {
        if (count == 0) {
            throw new IllegalArgumentException("Count cannot be zero for average calculation.");
        }
        if (total instanceof Long) {
            return (Long)total / (long)count;
        }
        if (total instanceof Integer) {
            return (Integer)total / count;
        }
        if (total instanceof Double) {
            return (Double)total / (double)count;
        }
        if (total instanceof Float) {
            return Float.valueOf(((Float)total).floatValue() / (float)count);
        }
        throw new IllegalArgumentException("Unsupported number type: " + String.valueOf(total.getClass()));
    }

    public void setMeasurement(Number measurement) {
        this.number = measurement;
    }

    public void setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NUMBER, (Object)this.number);
        builder.field(COUNT, this.count);
        builder.field(AGGREGATION_TYPE, this.aggregationType.toString());
        builder.endObject();
        return builder;
    }

    private void parseXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "Expected [" + String.valueOf(XContentParser.Token.START_OBJECT) + "] but found [" + String.valueOf(token) + "]", new Object[]{parser.getTokenLocation()});
        }
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!token.isValue()) continue;
            if (NUMBER.equals(currentFieldName)) {
                this.number = parser.numberValue();
                continue;
            }
            if (COUNT.equals(currentFieldName)) {
                this.count = parser.intValue();
                continue;
            }
            if (!AGGREGATION_TYPE.equals(currentFieldName)) continue;
            this.aggregationType = AggregationType.valueOf(parser.text());
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.writeNumber(out, this.number);
        out.writeInt(this.count);
        out.writeString(this.aggregationType.toString());
    }

    private void writeNumber(StreamOutput out, Number number) throws IOException {
        if (number instanceof Long) {
            out.writeByte((byte)0);
            out.writeLong(((Long)number).longValue());
        } else if (number instanceof Integer) {
            out.writeByte((byte)1);
            out.writeInt(((Integer)number).intValue());
        } else if (number instanceof Double) {
            out.writeByte((byte)2);
            out.writeDouble(((Double)number).doubleValue());
        } else if (number instanceof Float) {
            out.writeByte((byte)3);
            out.writeFloat(((Float)number).floatValue());
        } else {
            throw new IOException("Unsupported number type: " + String.valueOf(number.getClass()));
        }
    }

    private static Number readNumber(StreamInput in) throws IOException {
        byte typeIndicator = in.readByte();
        switch (typeIndicator) {
            case 0: {
                return in.readLong();
            }
            case 1: {
                return in.readInt();
            }
            case 2: {
                return in.readDouble();
            }
            case 3: {
                return Float.valueOf(in.readFloat());
            }
        }
        throw new IOException("Unsupported number type indicator: " + typeIndicator);
    }

    public static Measurement readFromStream(StreamInput in) throws IOException {
        Number number = Measurement.readNumber(in);
        int count = in.readInt();
        AggregationType aggregationType = AggregationType.valueOf(in.readString());
        return new Measurement(number, count, aggregationType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Measurement that = (Measurement)o;
        return this.count == that.count && this.number.doubleValue() == that.number.doubleValue() && this.aggregationType == that.aggregationType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.number, this.count, this.aggregationType});
    }
}

